{"vars":[{"line":103,"kind":2,"containerName":"","name":"base"},{"definition":"my","name":"%format_driver_map","kind":13,"localvar":"my","containerName":null,"line":108},{"line":167,"range":{"start":{"line":167,"character":0},"end":{"character":9999,"line":186}},"kind":12,"signature":{"label":"new($caller,@args)","parameters":[{"label":"$caller"},{"label":"@args"}],"documentation":"1;\n# $Id: OntologyIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::OntologyIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO - Parser factory for Ontology formats\n\n=head1 SYNOPSIS\n\n    use Bio::OntologyIO;\n\n    my $parser = Bio::OntologyIO->new(-format => \"go\",\n                                      -file=> $file);\n\n    while(my $ont = $parser->next_ontology()) {\n         print \"read ontology \",$ont->name(),\" with \",\n               scalar($ont->get_root_terms),\" root terms, and \",\n               scalar($ont->get_leaf_terms),\" leaf terms\\n\";\n    }\n\n=head1 DESCRIPTION\n\nThis is the parser factory for different ontology sources and\nformats. Conceptually, it is very similar to L<Bio::SeqIO>, but the\ndifference is that the chunk of data returned as an object is an\nentire ontology.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::OntologyIO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n#\n# Maps from format name to driver suitable for the format.\n#\nmy %format_driver_map = (\n                         \"go\"          => \"goflat\",\n                         \"so\"          => \"soflat\",\n                         \"interpro\"    => \"InterProParser\",\n                         \"interprosax\" => \"Handlers::InterPro_BioSQL_Handler\",\n                         \"evoc\"        => \"simplehierarchy\",\n                         \"obo\"        => \"obo\"\n                         );\n\n=head2 new\n\n Title   : new\n Usage   : my $parser = Bio::OntologyIO->new(-format => 'go', @args);\n Function: Returns a stream of ontologies opened on the specified input\n           for the specified format.\n Returns : An ontology parser (an instance of Bio::OntologyIO) initialized\n           for the specified format.\n Args    : Named parameters. Common parameters are\n\n              -format    - the format of the input; the following are\n                           presently supported:\n                  goflat: DAG-Edit Gene Ontology flat files\n                  go    : synonymous to goflat\n                  soflat: DAG-Edit Sequence Ontology flat files\n                  so    : synonymous to soflat\n                  simplehierarchy: text format with one term per line\n                          and indentation giving the hierarchy\n                  evoc  : synonymous to simplehierarchy\n                  interpro: InterPro XML\n                  interprosax: InterPro XML - this is actually not a\n                          Bio::OntologyIO compliant parser; instead it\n                          persists terms as they are encountered.\n                          L<Bio::OntologyIO::Handlers::InterPro_BioSQL_Handler>\n                  obo   : OBO format style from Gene Ontology Consortium\n              -file      - the file holding the data\n              -fh        - the stream providing the data (-file and -fh are\n                          mutually exclusive)\n              -ontology_name - the name of the ontology\n              -engine    - the L<Bio::Ontology::OntologyEngineI> object\n                          to be reused (will be created otherwise); note\n                          that every L<Bio::Ontology::OntologyI> will\n                          qualify as well since that one inherits from the\n                          former.\n              -term_factory - the ontology term factory to use. Provide a\n                          value only if you know what you are doing.\n\n           DAG-Edit flat file parsers will usually also accept the\n           following parameters.\n\n              -defs_file - the name of the file holding the term\n                          definitions\n              -files     - an array ref holding the file names (for GO,\n                          there will usually be 3 files: component.ontology,\n                          function.ontology, process.ontology)\n\n           Other parameters are specific to the parsers."},"children":[{"line":168,"containerName":"new","localvar":"my","kind":13,"name":"$caller","definition":"my"},{"name":"@args","containerName":"new","kind":13,"line":168},{"name":"$class","localvar":"my","containerName":"new","kind":13,"line":169,"definition":"my"},{"kind":13,"containerName":"new","name":"$caller","line":169},{"line":169,"name":"$caller","containerName":"new","kind":13},{"name":"$class","containerName":"new","kind":13,"line":172},{"name":"$self","localvar":"my","kind":13,"containerName":"new","line":173,"definition":"my"},{"line":173,"name":"$class","containerName":"new","kind":13},{"line":173,"name":"@args","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$self","line":174},{"line":174,"containerName":"new","kind":12,"name":"_initialize"},{"line":174,"name":"@args","containerName":"new","kind":13},{"name":"$self","kind":13,"containerName":"new","line":175},{"line":177,"kind":13,"localvar":"my","containerName":"new","name":"%param","definition":"my"},{"line":177,"name":"@args","containerName":"new","kind":13},{"line":178,"name":"@param","kind":13,"containerName":"new"},{"line":178,"name":"%param","kind":13,"containerName":"new"},{"name":"%param","containerName":"new","kind":13,"line":178},{"definition":"my","name":"$format","containerName":"new","localvar":"my","kind":13,"line":179},{"name":"$class","kind":13,"containerName":"new","line":179},{"line":179,"name":"_map_format","kind":12,"containerName":"new"},{"line":179,"containerName":"new","kind":13,"name":"$param"},{"name":"$class","kind":13,"containerName":"new","line":182},{"name":"_load_format_module","kind":12,"containerName":"new","line":182},{"line":182,"kind":13,"containerName":"new","name":"$format"},{"line":183,"containerName":"new","kind":12,"name":"new"},{"containerName":"new","kind":13,"name":"@args","line":183}],"containerName":"main::","name":"new","definition":"sub","detail":"($caller,@args)"},{"name":"SUPER","kind":12,"containerName":"new","line":173},{"children":[{"definition":"my","line":189,"name":"$self","kind":13,"localvar":"my","containerName":"_initialize"},{"containerName":"_initialize","kind":13,"name":"@args","line":189},{"name":"$eng","localvar":"my","containerName":"_initialize","kind":13,"line":192,"definition":"my"},{"line":192,"containerName":"_initialize","kind":13,"name":"$fact"},{"containerName":"_initialize","kind":13,"name":"$ontname","line":192},{"line":193,"containerName":"_initialize","kind":13,"name":"$self"},{"name":"_rearrange","kind":12,"containerName":"_initialize","line":193},{"line":194,"kind":13,"containerName":"_initialize","name":"@args"},{"line":196,"containerName":"_initialize","kind":13,"name":"$self"},{"line":196,"kind":12,"containerName":"_initialize","name":"term_factory"},{"line":196,"name":"$fact","kind":13,"containerName":"_initialize"},{"line":196,"kind":13,"containerName":"_initialize","name":"$fact"},{"kind":13,"containerName":"_initialize","name":"$self","line":199},{"line":199,"kind":12,"containerName":"_initialize","name":"_initialize_io"},{"containerName":"_initialize","kind":13,"name":"@args","line":199}],"name":"_initialize","containerName":"main::","definition":"sub","detail":"($self,@args)","line":188,"range":{"end":{"character":9999,"line":200},"start":{"character":0,"line":188}},"kind":12,"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"@args"}],"label":"_initialize($self,@args)"}},{"definition":"sub","name":"next_ontology","containerName":"main::","children":[{"name":"throw_not_implemented","kind":12,"containerName":"next_ontology","line":215}],"range":{"start":{"character":0,"line":214},"end":{"character":9999,"line":216}},"kind":12,"line":214},{"containerName":"main::","name":"term_factory","children":[{"kind":13,"localvar":"my","containerName":"term_factory","name":"$self","line":241,"definition":"my"},{"line":243,"containerName":"term_factory","kind":13,"name":"$self"},{"name":"$self","containerName":"term_factory","kind":13,"line":244}],"definition":"sub","range":{"start":{"line":240,"character":0},"end":{"line":245,"character":9999}},"kind":12,"line":240},{"definition":"sub","detail":"($self,$format)","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"_load_format_module","name":"$self","line":267},{"line":267,"name":"$format","kind":13,"containerName":"_load_format_module"},{"definition":"my","name":"$module","localvar":"my","containerName":"_load_format_module","kind":13,"line":268},{"name":"$format","containerName":"_load_format_module","kind":13,"line":268},{"definition":"my","line":269,"name":"$ok","localvar":"my","containerName":"_load_format_module","kind":13},{"name":"$ok","containerName":"_load_format_module","kind":13,"line":272},{"name":"$self","kind":13,"containerName":"_load_format_module","line":272},{"kind":12,"containerName":"_load_format_module","name":"_load_module","line":272},{"line":272,"name":"$module","kind":13,"containerName":"_load_format_module"},{"line":282,"name":"$ok","kind":13,"containerName":"_load_format_module"}],"name":"_load_format_module","containerName":"main::","signature":{"label":"_load_format_module($self,$format)","documentation":"1;\n# $Id: OntologyIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::OntologyIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO - Parser factory for Ontology formats\n\n=head1 SYNOPSIS\n\n    use Bio::OntologyIO;\n\n    my $parser = Bio::OntologyIO->new(-format => \"go\",\n                                      -file=> $file);\n\n    while(my $ont = $parser->next_ontology()) {\n         print \"read ontology \",$ont->name(),\" with \",\n               scalar($ont->get_root_terms),\" root terms, and \",\n               scalar($ont->get_leaf_terms),\" leaf terms\\n\";\n    }\n\n=head1 DESCRIPTION\n\nThis is the parser factory for different ontology sources and\nformats. Conceptually, it is very similar to L<Bio::SeqIO>, but the\ndifference is that the chunk of data returned as an object is an\nentire ontology.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::OntologyIO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n#\n# Maps from format name to driver suitable for the format.\n#\nmy %format_driver_map = (\n                         \"go\"          => \"goflat\",\n                         \"so\"          => \"soflat\",\n                         \"interpro\"    => \"InterProParser\",\n                         \"interprosax\" => \"Handlers::InterPro_BioSQL_Handler\",\n                         \"evoc\"        => \"simplehierarchy\",\n                         \"obo\"        => \"obo\"\n                         );\n\n=head2 new\n\n Title   : new\n Usage   : my $parser = Bio::OntologyIO->new(-format => 'go', @args);\n Function: Returns a stream of ontologies opened on the specified input\n           for the specified format.\n Returns : An ontology parser (an instance of Bio::OntologyIO) initialized\n           for the specified format.\n Args    : Named parameters. Common parameters are\n\n              -format    - the format of the input; the following are\n                           presently supported:\n                  goflat: DAG-Edit Gene Ontology flat files\n                  go    : synonymous to goflat\n                  soflat: DAG-Edit Sequence Ontology flat files\n                  so    : synonymous to soflat\n                  simplehierarchy: text format with one term per line\n                          and indentation giving the hierarchy\n                  evoc  : synonymous to simplehierarchy\n                  interpro: InterPro XML\n                  interprosax: InterPro XML - this is actually not a\n                          Bio::OntologyIO compliant parser; instead it\n                          persists terms as they are encountered.\n                          L<Bio::OntologyIO::Handlers::InterPro_BioSQL_Handler>\n                  obo   : OBO format style from Gene Ontology Consortium\n              -file      - the file holding the data\n              -fh        - the stream providing the data (-file and -fh are\n                          mutually exclusive)\n              -ontology_name - the name of the ontology\n              -engine    - the L<Bio::Ontology::OntologyEngineI> object\n                          to be reused (will be created otherwise); note\n                          that every L<Bio::Ontology::OntologyI> will\n                          qualify as well since that one inherits from the\n                          former.\n              -term_factory - the ontology term factory to use. Provide a\n                          value only if you know what you are doing.\n\n           DAG-Edit flat file parsers will usually also accept the\n           following parameters.\n\n              -defs_file - the name of the file holding the term\n                          definitions\n              -files     - an array ref holding the file names (for GO,\n                          there will usually be 3 files: component.ontology,\n                          function.ontology, process.ontology)\n\n           Other parameters are specific to the parsers.\n\n\nsub new {\n    my ($caller,@args) = @_;\n    my $class = ref($caller) || $caller;\n    # or do we want to call SUPER on an object if $caller is an\n    # object?\n    if( $class =~ /Bio::OntologyIO::(\\S+)/ ) {\n        my ($self) = $class->SUPER::new(@args);\n        $self->_initialize(@args);\n        return $self;\n    } else {\n        my %param = @args;\n        @param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n        my $format = $class->_map_format($param{'-format'});\n\n        # normalize capitalization\n        return unless( $class->_load_format_module($format) );\n        return \"Bio::OntologyIO::$format\"->new(@args);\n    }\n\n}\n\nsub _initialize {\n    my($self, @args) = @_;\n\n    # initialize factories etc\n    my ($eng,$fact,$ontname) =\n        $self->_rearrange([qw(TERM_FACTORY)\n                           ], @args);\n    # term object factory\n    $self->term_factory($fact) if $fact;\n\n    # initialize the Bio::Root::IO part\n    $self->_initialize_io(@args);\n}\n\n=head2 next_ontology\n\n Title   : next_ontology\n Usage   : $ont = $stream->next_ontology()\n Function: Reads the next ontology object from the stream and returns it.\n Returns : a L<Bio::Ontology::OntologyI> compliant object, or undef at the\n           end of the stream\n Args    : none\n\n\n\nsub next_ontology {\n    shift->throw_not_implemented();\n}\n\n=head2 term_factory\n\n Title   : term_factory\n Usage   : $obj->term_factory($newval)\n Function: Get/set the ontology term factory to use.\n\n           As a user of this module it is not necessary to call this\n           method as there will be default. In order to change the\n           default, the easiest way is to instantiate\n           L<Bio::Ontology::TermFactory> with the proper -type\n           argument. Most if not all parsers will actually use this\n           very implementation, so even easier than the aforementioned\n           way is to simply call\n           $ontio->term_factory->type(\"Bio::Ontology::MyTerm\").\n\n Example :\n Returns : value of term_factory (a Bio::Factory::ObjectFactoryI object)\n Args    : on set, new value (a Bio::Factory::ObjectFactoryI object, optional)\n\n\n\nsub term_factory{\n    my $self = shift;\n\n    return $self->{'term_factory'} = shift if @_;\n    return $self->{'term_factory'};\n}\n\n=head1 Private Methods\n\n  Some of these are actually 'protected' in OO speak, which means you\n  may or will want to utilize them in a derived ontology parser, but\n  you should not call them from outside.\n\n\n=head2 _load_format_module\n\n Title   : _load_format_module\n Usage   : *INTERNAL OntologyIO stuff*\n Function: Loads up (like use) a module at run time on demand\n Example :\n Returns :\n Args    :","parameters":[{"label":"$self"},{"label":"$format"}]},"line":266,"range":{"end":{"character":9999,"line":283},"start":{"line":266,"character":0}},"kind":12},{"kind":12,"range":{"end":{"line":289,"character":9999},"start":{"character":0,"line":285}},"line":285,"containerName":"main::","name":"DESTROY","children":[{"definition":"my","line":286,"name":"$self","localvar":"my","containerName":"DESTROY","kind":13},{"kind":13,"containerName":"DESTROY","name":"$self","line":288},{"name":"close","containerName":"DESTROY","kind":12,"line":288}],"definition":"sub"},{"definition":"sub","name":"_map_format","containerName":"main::","children":[{"definition":"my","line":292,"name":"$self","containerName":"_map_format","localvar":"my","kind":13},{"definition":"my","line":293,"name":"$format","localvar":"my","kind":13,"containerName":"_map_format"},{"name":"$mod","localvar":"my","kind":13,"containerName":"_map_format","line":294,"definition":"my"},{"line":296,"name":"$format","containerName":"_map_format","kind":13},{"line":297,"kind":13,"containerName":"_map_format","name":"$mod"},{"kind":13,"containerName":"_map_format","name":"$format_driver_map","line":297},{"name":"$format","kind":13,"containerName":"_map_format","line":297},{"line":298,"name":"$mod","kind":13,"containerName":"_map_format"},{"line":298,"name":"$format","containerName":"_map_format","kind":13},{"line":298,"name":"$mod","kind":13,"containerName":"_map_format"},{"line":300,"name":"$self","kind":13,"containerName":"_map_format"},{"containerName":"_map_format","kind":12,"name":"throw","line":300},{"line":302,"name":"$mod","kind":13,"containerName":"_map_format"}],"range":{"start":{"line":291,"character":0},"end":{"line":303,"character":9999}},"kind":12,"line":291},{"children":[{"name":"$self","localvar":"my","containerName":"unescape","kind":13,"line":306,"definition":"my"},{"name":"$ref","containerName":"unescape","kind":13,"line":306},{"line":307,"containerName":"unescape","kind":13,"name":"$ref"},{"kind":13,"containerName":"unescape","name":"$ref","line":308},{"line":309,"containerName":"unescape","kind":13,"name":"$ref"},{"containerName":"unescape","kind":13,"name":"$ref","line":310},{"line":311,"name":"$ref","containerName":"unescape","kind":13},{"kind":13,"containerName":"unescape","name":"$ref","line":312}],"containerName":"main::","name":"unescape","definition":"sub","detail":"($self,$ref)","line":305,"range":{"start":{"line":305,"character":0},"end":{"line":313,"character":9999}},"kind":12,"signature":{"label":"unescape($self,$ref)","documentation":"","parameters":[{"label":"$self"},{"label":"$ref"}]}}],"version":5}