{"vars":[{"line":90,"name":"base","kind":2,"containerName":""},{"signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :","parameters":[{"label":"$class"},{"label":"@args"}]},"range":{"end":{"line":118,"character":9999},"start":{"character":0,"line":103}},"kind":12,"line":103,"detail":"($class,@args)","definition":"sub","name":"new","containerName":"main::","children":[{"definition":"my","line":104,"name":"$class","kind":13,"localvar":"my","containerName":"new"},{"line":104,"name":"@args","containerName":"new","kind":13},{"kind":13,"localvar":"my","containerName":"new","name":"$self","line":105,"definition":"my"},{"name":"$class","containerName":"new","kind":13,"line":105},{"kind":13,"containerName":"new","name":"@args","line":105},{"line":108,"name":"$self","kind":13,"containerName":"new"},{"name":"_term_store","kind":12,"containerName":"new","line":108},{"line":109,"name":"$self","kind":13,"containerName":"new"},{"line":109,"kind":12,"containerName":"new","name":"_relationship_store"},{"line":110,"kind":13,"containerName":"new","name":"$self"},{"line":110,"name":"_inverted_relationship_store","kind":12,"containerName":"new"},{"containerName":"new","kind":13,"name":"$self","line":111},{"containerName":"new","kind":12,"name":"_relationship_type_store","line":111},{"kind":13,"containerName":"new","name":"$self","line":112},{"containerName":"new","kind":12,"name":"_instantiated_terms_store","line":112},{"line":115,"name":"$self","kind":13,"containerName":"new"},{"line":115,"kind":12,"containerName":"new","name":"relationship_factory"},{"line":115,"name":"new","kind":12,"containerName":"new"},{"kind":13,"containerName":"new","name":"$self","line":117}]},{"containerName":"new","kind":12,"name":"SUPER","line":105},{"line":115,"name":"Bio","kind":12,"containerName":"Ontology::RelationshipFactory"},{"signature":{"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash","parameters":[{"label":"$self"},{"label":"$value"}],"label":"_instantiated_terms_store($self,$value)"},"kind":12,"range":{"end":{"line":138,"character":9999},"start":{"line":131,"character":0}},"line":131,"detail":"($self,$value)","definition":"sub","name":"_instantiated_terms_store","containerName":"main::","children":[{"localvar":"my","containerName":"_instantiated_terms_store","kind":13,"name":"$self","line":132,"definition":"my"},{"kind":13,"containerName":"_instantiated_terms_store","name":"$value","line":132},{"line":134,"kind":13,"containerName":"_instantiated_terms_store","name":"$value"},{"name":"$self","containerName":"_instantiated_terms_store","kind":13,"line":135},{"name":"$value","kind":13,"containerName":"_instantiated_terms_store","line":135},{"line":137,"name":"$self","kind":13,"containerName":"_instantiated_terms_store"}]},{"line":155,"range":{"end":{"line":165,"character":9999},"start":{"line":155,"character":0}},"kind":12,"signature":{"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.","parameters":[{"label":"$self"},{"label":"@terms"}],"label":"mark_instantiated($self,@terms)"},"children":[{"name":"$self","localvar":"my","kind":13,"containerName":"mark_instantiated","line":156,"definition":"my"},{"name":"@terms","kind":13,"containerName":"mark_instantiated","line":156},{"definition":"my","line":158,"name":"$term","containerName":"mark_instantiated","localvar":"my","kind":13},{"kind":13,"containerName":"mark_instantiated","name":"@terms","line":158},{"line":159,"name":"$self","kind":13,"containerName":"mark_instantiated"},{"line":159,"name":"throw","kind":12,"containerName":"mark_instantiated"},{"kind":13,"containerName":"mark_instantiated","name":"$term","line":159},{"kind":12,"containerName":"mark_instantiated","name":"identifier","line":159},{"line":160,"name":"$self","containerName":"mark_instantiated","kind":13},{"line":160,"kind":12,"containerName":"mark_instantiated","name":"_term_store"},{"line":160,"kind":13,"containerName":"mark_instantiated","name":"$term"},{"line":160,"kind":12,"containerName":"mark_instantiated","name":"identifier"},{"containerName":"mark_instantiated","kind":13,"name":"$self","line":161},{"line":161,"name":"_instantiated_terms_store","containerName":"mark_instantiated","kind":12},{"line":161,"name":"$term","kind":13,"containerName":"mark_instantiated"},{"line":161,"name":"identifier","kind":12,"containerName":"mark_instantiated"},{"name":"@terms","kind":13,"containerName":"mark_instantiated","line":164}],"name":"mark_instantiated","containerName":"main::","definition":"sub","detail":"($self,@terms)"},{"kind":12,"range":{"start":{"line":179,"character":0},"end":{"line":190,"character":9999}},"line":179,"signature":{"parameters":[{"label":"$self"},{"label":"@terms"}],"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.","label":"mark_uninstantiated($self,@terms)"},"name":"mark_uninstantiated","containerName":"main::","children":[{"kind":13,"localvar":"my","containerName":"mark_uninstantiated","name":"$self","line":180,"definition":"my"},{"containerName":"mark_uninstantiated","kind":13,"name":"@terms","line":180},{"line":182,"localvar":"my","containerName":"mark_uninstantiated","kind":13,"name":"$term","definition":"my"},{"line":182,"name":"@terms","containerName":"mark_uninstantiated","kind":13},{"line":183,"containerName":"mark_uninstantiated","kind":13,"name":"$self"},{"name":"throw","containerName":"mark_uninstantiated","kind":12,"line":183},{"name":"$term","containerName":"mark_uninstantiated","kind":13,"line":183},{"line":183,"containerName":"mark_uninstantiated","kind":12,"name":"identifier"},{"kind":13,"containerName":"mark_uninstantiated","name":"$self","line":184},{"line":184,"name":"_term_store","kind":12,"containerName":"mark_uninstantiated"},{"line":184,"name":"$term","containerName":"mark_uninstantiated","kind":13},{"line":184,"name":"identifier","containerName":"mark_uninstantiated","kind":12},{"name":"$self","kind":13,"containerName":"mark_uninstantiated","line":185},{"name":"_instantiated_terms_store","containerName":"mark_uninstantiated","kind":12,"line":185},{"name":"$term","containerName":"mark_uninstantiated","kind":13,"line":185},{"line":185,"kind":12,"containerName":"mark_uninstantiated","name":"identifier"},{"line":186,"name":"$self","containerName":"mark_uninstantiated","kind":13},{"line":186,"name":"_instantiated_terms_store","containerName":"mark_uninstantiated","kind":12},{"name":"$term","containerName":"mark_uninstantiated","kind":13,"line":186},{"line":186,"kind":12,"containerName":"mark_uninstantiated","name":"identifier"},{"line":189,"kind":13,"containerName":"mark_uninstantiated","name":"@terms"}],"detail":"($self,@terms)","definition":"sub"},{"containerName":"main::","name":"_term_store","children":[{"definition":"my","line":204,"kind":13,"localvar":"my","containerName":"_term_store","name":"$self"},{"line":204,"kind":13,"containerName":"_term_store","name":"$value"},{"name":"$value","kind":13,"containerName":"_term_store","line":206},{"name":"$self","containerName":"_term_store","kind":13,"line":207},{"name":"$self","containerName":"_term_store","kind":13,"line":208},{"containerName":"_term_store","kind":12,"name":"throw","line":208},{"line":211,"name":"$self","kind":13,"containerName":"_term_store"},{"line":211,"name":"$value","kind":13,"containerName":"_term_store"},{"name":"$self","containerName":"_term_store","kind":13,"line":215}],"detail":"($self,$value)","definition":"sub","range":{"end":{"character":9999,"line":216},"start":{"character":0,"line":203}},"kind":12,"line":203,"signature":{"label":"_term_store($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects"}},{"signature":{"parameters":[{"label":"$self"},{"label":"$term"}],"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.","label":"add_term($self,$term)"},"line":230,"range":{"end":{"line":243,"character":9999},"start":{"line":230,"character":0}},"kind":12,"definition":"sub","detail":"($self,$term)","children":[{"definition":"my","containerName":"add_term","localvar":"my","kind":13,"name":"$self","line":231},{"name":"$term","containerName":"add_term","kind":13,"line":231},{"line":232,"localvar":"my","kind":13,"containerName":"add_term","name":"$term_store","definition":"my"},{"name":"$self","kind":13,"containerName":"add_term","line":232},{"line":232,"name":"_term_store","kind":12,"containerName":"add_term"},{"line":234,"containerName":"add_term","kind":13,"name":"$term_store"},{"name":"$term","containerName":"add_term","kind":13,"line":234},{"line":234,"name":"identifier","containerName":"add_term","kind":12},{"line":235,"name":"$self","kind":13,"containerName":"add_term"},{"containerName":"add_term","kind":12,"name":"throw","line":235},{"line":235,"name":"$term","kind":13,"containerName":"add_term"},{"kind":12,"containerName":"add_term","name":"identifier","line":235},{"line":238,"name":"$term_store","containerName":"add_term","kind":13},{"line":238,"kind":13,"containerName":"add_term","name":"$term"},{"kind":12,"containerName":"add_term","name":"identifier","line":238},{"line":238,"name":"$term","kind":13,"containerName":"add_term"},{"containerName":"add_term","kind":13,"name":"$self","line":239},{"name":"_instantiated_terms_store","containerName":"add_term","kind":12,"line":239},{"line":239,"containerName":"add_term","kind":13,"name":"$term"},{"line":239,"name":"identifier","containerName":"add_term","kind":12},{"line":242,"name":"$term","containerName":"add_term","kind":13}],"name":"add_term","containerName":"main::"},{"detail":"($self,@ids)","definition":"sub","containerName":"main::","name":"get_term_by_identifier","children":[{"definition":"my","line":258,"localvar":"my","containerName":"get_term_by_identifier","kind":13,"name":"$self"},{"line":258,"name":"@ids","kind":13,"containerName":"get_term_by_identifier"},{"localvar":"my","containerName":"get_term_by_identifier","kind":13,"name":"@ans","line":259,"definition":"my"},{"definition":"my","line":261,"name":"$id","containerName":"get_term_by_identifier","localvar":"my","kind":13},{"line":261,"kind":13,"containerName":"get_term_by_identifier","name":"@ids"},{"name":"$term","kind":13,"localvar":"my","containerName":"get_term_by_identifier","line":262,"definition":"my"},{"line":262,"name":"$self","containerName":"get_term_by_identifier","kind":13},{"line":262,"kind":12,"containerName":"get_term_by_identifier","name":"_term_store"},{"name":"$id","containerName":"get_term_by_identifier","kind":13,"line":262},{"name":"@ans","containerName":"get_term_by_identifier","kind":13,"line":263},{"line":263,"name":"$term","containerName":"get_term_by_identifier","kind":13},{"name":"$term","containerName":"get_term_by_identifier","kind":13,"line":263},{"containerName":"get_term_by_identifier","kind":13,"name":"@ans","line":266}],"signature":{"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings","parameters":[{"label":"$self"},{"label":"@ids"}],"label":"get_term_by_identifier($self,@ids)"},"kind":12,"range":{"end":{"line":267,"character":9999},"start":{"character":0,"line":257}},"line":257},{"signature":{"label":"_get_number_rels($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :"},"line":280,"kind":12,"range":{"end":{"line":288,"character":9999},"start":{"line":280,"character":0}},"definition":"sub","detail":"($self)","children":[{"definition":"my","line":281,"localvar":"my","containerName":"_get_number_rels","kind":13,"name":"$self"},{"definition":"my","line":282,"name":"$num_rels","kind":13,"localvar":"my","containerName":"_get_number_rels"},{"name":"$entry","localvar":"my","kind":13,"containerName":"_get_number_rels","line":284,"definition":"my"},{"line":284,"name":"$self","containerName":"_get_number_rels","kind":13},{"kind":12,"containerName":"_get_number_rels","name":"_relationship_store","line":284},{"line":285,"kind":13,"containerName":"_get_number_rels","name":"$num_rels"},{"line":285,"kind":13,"containerName":"_get_number_rels","name":"$entry"},{"line":287,"kind":13,"containerName":"_get_number_rels","name":"$num_rels"}],"containerName":"main::","name":"_get_number_rels"},{"signature":{"label":"_get_number_terms($self)","documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :","parameters":[{"label":"$self"}]},"line":301,"kind":12,"range":{"start":{"line":301,"character":0},"end":{"character":9999,"line":304}},"definition":"sub","detail":"($self)","children":[{"definition":"my","line":302,"localvar":"my","kind":13,"containerName":"_get_number_terms","name":"$self"},{"line":304,"name":"$self","kind":13,"containerName":"_get_number_terms"},{"name":"_filter_unmarked","kind":12,"containerName":"_get_number_terms","line":304},{"containerName":"_get_number_terms","kind":13,"name":"$self","line":304},{"containerName":"_get_number_terms","kind":12,"name":"_term_store","line":304}],"containerName":"main::","name":"_get_number_terms"},{"signature":{"label":"_relationship_store($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects"},"kind":12,"range":{"start":{"line":319,"character":0},"end":{"line":332,"character":9999}},"line":319,"detail":"($self,$value)","definition":"sub","name":"_relationship_store","containerName":"main::","children":[{"line":320,"name":"$self","localvar":"my","kind":13,"containerName":"_relationship_store","definition":"my"},{"line":320,"kind":13,"containerName":"_relationship_store","name":"$value"},{"name":"$value","containerName":"_relationship_store","kind":13,"line":322},{"line":323,"name":"$self","containerName":"_relationship_store","kind":13},{"line":324,"name":"$self","kind":13,"containerName":"_relationship_store"},{"line":324,"containerName":"_relationship_store","kind":12,"name":"throw"},{"name":"$self","containerName":"_relationship_store","kind":13,"line":327},{"line":327,"containerName":"_relationship_store","kind":13,"name":"$value"},{"line":331,"containerName":"_relationship_store","kind":13,"name":"$self"}]},{"definition":"sub","detail":"($self,$value)","children":[{"localvar":"my","kind":13,"containerName":"_inverted_relationship_store","name":"$self","line":346,"definition":"my"},{"containerName":"_inverted_relationship_store","kind":13,"name":"$value","line":346},{"line":348,"containerName":"_inverted_relationship_store","kind":13,"name":"$value"},{"kind":13,"containerName":"_inverted_relationship_store","name":"$self","line":349},{"name":"$self","containerName":"_inverted_relationship_store","kind":13,"line":350},{"line":350,"kind":12,"containerName":"_inverted_relationship_store","name":"throw"},{"name":"$self","kind":13,"containerName":"_inverted_relationship_store","line":353},{"line":353,"containerName":"_inverted_relationship_store","kind":13,"name":"$value"},{"line":357,"kind":13,"containerName":"_inverted_relationship_store","name":"$self"}],"containerName":"main::","name":"_inverted_relationship_store","signature":{"label":"_inverted_relationship_store($self,$value)","documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _relationship_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_store'}) {\n\t\t  $self->throw(\"_relationship_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_store'};\n}\n\n=head2 _inverted_relationship_store\n\n Title   : _inverted_relationship_store\n Usage   :\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects","parameters":[{"label":"$self"},{"label":"$value"}]},"line":345,"kind":12,"range":{"start":{"line":345,"character":0},"end":{"line":358,"character":9999}}},{"signature":{"label":"_relationship_type_store($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _relationship_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_store'}) {\n\t\t  $self->throw(\"_relationship_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_store'};\n}\n\n=head2 _inverted_relationship_store\n\n Title   : _inverted_relationship_store\n Usage   :\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _inverted_relationship_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\tif ( defined $self->{'_inverted_relationship_store'}) {\n\t\t\t$self->throw(\"_inverted_relationship_store already defined\\n\");\n\t\t}\n\t\telse {\n\t\t\t$self->{'_inverted_relationship_store'} = $value;\n\t\t}\n\t}\n\n  return $self->{'_inverted_relationship_store'};\n}\n\n=head2 _relationship_type_store\n\n Title   : _relationship_type_store\n Usage   : $obj->_relationship_type_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    : reference to an array of Bio::Ontology::RelationshipType objects"},"line":371,"range":{"end":{"line":384,"character":9999},"start":{"line":371,"character":0}},"kind":12,"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","line":372,"name":"$self","containerName":"_relationship_type_store","localvar":"my","kind":13},{"line":372,"containerName":"_relationship_type_store","kind":13,"name":"$value"},{"line":374,"name":"$value","containerName":"_relationship_type_store","kind":13},{"line":375,"name":"$self","containerName":"_relationship_type_store","kind":13},{"name":"$self","containerName":"_relationship_type_store","kind":13,"line":376},{"name":"throw","containerName":"_relationship_type_store","kind":12,"line":376},{"name":"$self","kind":13,"containerName":"_relationship_type_store","line":379},{"line":379,"name":"$value","kind":13,"containerName":"_relationship_type_store"},{"line":383,"containerName":"_relationship_type_store","kind":13,"name":"$self"}],"containerName":"main::","name":"_relationship_type_store"},{"signature":{"parameters":[{"label":"$self"},{"label":"$store"},{"label":"$rel"},{"label":"$inverted"}],"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _relationship_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_store'}) {\n\t\t  $self->throw(\"_relationship_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_store'};\n}\n\n=head2 _inverted_relationship_store\n\n Title   : _inverted_relationship_store\n Usage   :\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _inverted_relationship_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\tif ( defined $self->{'_inverted_relationship_store'}) {\n\t\t\t$self->throw(\"_inverted_relationship_store already defined\\n\");\n\t\t}\n\t\telse {\n\t\t\t$self->{'_inverted_relationship_store'} = $value;\n\t\t}\n\t}\n\n  return $self->{'_inverted_relationship_store'};\n}\n\n=head2 _relationship_type_store\n\n Title   : _relationship_type_store\n Usage   : $obj->_relationship_type_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    : reference to an array of Bio::Ontology::RelationshipType objects\n\n\nsub _relationship_type_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_type_store'}) {\n\t\t  $self->throw(\"_relationship_type_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_type_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_type_store'};\n}\n\n=head2 _add_relationship_simple\n\n Title   : _add_relationship_simple\n Usage   :\n Function:\n Example :\n Returns : \n Args    :","label":"_add_relationship_simple($self,$store,$rel,$inverted)"},"line":397,"range":{"end":{"line":420,"character":9999},"start":{"line":397,"character":0}},"kind":12,"definition":"sub","detail":"($self,$store,$rel,$inverted)","children":[{"line":398,"kind":13,"localvar":"my","containerName":"_add_relationship_simple","name":"$self","definition":"my"},{"name":"$store","kind":13,"containerName":"_add_relationship_simple","line":398},{"line":398,"kind":13,"containerName":"_add_relationship_simple","name":"$rel"},{"name":"$inverted","containerName":"_add_relationship_simple","kind":13,"line":398},{"definition":"my","name":"$parent_id","containerName":"_add_relationship_simple","localvar":"my","kind":13,"line":399},{"definition":"my","line":400,"name":"$child_id","kind":13,"localvar":"my","containerName":"_add_relationship_simple"},{"line":402,"name":"$inverted","kind":13,"containerName":"_add_relationship_simple"},{"line":403,"containerName":"_add_relationship_simple","kind":13,"name":"$parent_id"},{"name":"$rel","containerName":"_add_relationship_simple","kind":13,"line":403},{"name":"subject_term","containerName":"_add_relationship_simple","kind":12,"line":403},{"line":403,"containerName":"_add_relationship_simple","kind":12,"name":"identifier"},{"name":"$child_id","kind":13,"containerName":"_add_relationship_simple","line":404},{"name":"$rel","containerName":"_add_relationship_simple","kind":13,"line":404},{"line":404,"name":"object_term","kind":12,"containerName":"_add_relationship_simple"},{"line":404,"name":"identifier","containerName":"_add_relationship_simple","kind":12},{"containerName":"_add_relationship_simple","kind":13,"name":"$parent_id","line":407},{"name":"$rel","containerName":"_add_relationship_simple","kind":13,"line":407},{"line":407,"containerName":"_add_relationship_simple","kind":12,"name":"object_term"},{"name":"identifier","kind":12,"containerName":"_add_relationship_simple","line":407},{"name":"$child_id","containerName":"_add_relationship_simple","kind":13,"line":408},{"line":408,"kind":13,"containerName":"_add_relationship_simple","name":"$rel"},{"containerName":"_add_relationship_simple","kind":12,"name":"subject_term","line":408},{"line":408,"name":"identifier","containerName":"_add_relationship_simple","kind":12},{"name":"$store","containerName":"_add_relationship_simple","kind":13,"line":410},{"line":410,"name":"$parent_id","containerName":"_add_relationship_simple","kind":13},{"line":410,"kind":13,"containerName":"_add_relationship_simple","name":"$store"},{"name":"$parent_id","kind":13,"containerName":"_add_relationship_simple","line":410},{"containerName":"_add_relationship_simple","kind":13,"name":"$child_id","line":410},{"containerName":"_add_relationship_simple","kind":13,"name":"$store","line":411},{"kind":13,"containerName":"_add_relationship_simple","name":"$parent_id","line":411},{"line":411,"name":"$child_id","containerName":"_add_relationship_simple","kind":13},{"name":"name","kind":12,"containerName":"_add_relationship_simple","line":411},{"line":411,"containerName":"_add_relationship_simple","kind":13,"name":"$rel"},{"kind":12,"containerName":"_add_relationship_simple","name":"predicate_term","line":411},{"line":411,"name":"name","kind":12,"containerName":"_add_relationship_simple"},{"containerName":"_add_relationship_simple","kind":13,"name":"$self","line":412},{"line":412,"kind":12,"containerName":"_add_relationship_simple","name":"throw"},{"line":412,"name":"$rel","containerName":"_add_relationship_simple","kind":13},{"line":412,"name":"predicate_term","kind":12,"containerName":"_add_relationship_simple"},{"name":"$parent_id","containerName":"_add_relationship_simple","kind":13,"line":413},{"line":413,"kind":13,"containerName":"_add_relationship_simple","name":"$child_id"},{"line":415,"name":"$store","containerName":"_add_relationship_simple","kind":13},{"name":"$parent_id","kind":13,"containerName":"_add_relationship_simple","line":415},{"kind":13,"containerName":"_add_relationship_simple","name":"$child_id","line":415},{"name":"$store","containerName":"_add_relationship_simple","kind":13,"line":418},{"name":"$parent_id","kind":13,"containerName":"_add_relationship_simple","line":418},{"name":"$child_id","containerName":"_add_relationship_simple","kind":13,"line":418},{"containerName":"_add_relationship_simple","kind":13,"name":"$rel","line":418},{"line":418,"name":"predicate_term","containerName":"_add_relationship_simple","kind":12}],"containerName":"main::","name":"_add_relationship_simple"},{"line":412,"name":"Dumper","kind":12},{"line":415,"kind":12,"name":"Dumper"},{"children":[{"definition":"my","containerName":"add_relationship","localvar":"my","kind":13,"name":"$self","line":434},{"name":"$rel","kind":13,"containerName":"add_relationship","line":434},{"containerName":"add_relationship","kind":13,"name":"$self","line":436},{"name":"_add_relationship_simple","kind":12,"containerName":"add_relationship","line":436},{"line":436,"name":"$self","containerName":"add_relationship","kind":13},{"containerName":"add_relationship","kind":12,"name":"_relationship_store","line":436},{"containerName":"add_relationship","kind":13,"name":"$rel","line":437},{"kind":13,"containerName":"add_relationship","name":"$self","line":438},{"kind":12,"containerName":"add_relationship","name":"_add_relationship_simple","line":438},{"line":438,"containerName":"add_relationship","kind":13,"name":"$self"},{"containerName":"add_relationship","kind":12,"name":"_inverted_relationship_store","line":438},{"kind":13,"containerName":"add_relationship","name":"$rel","line":439},{"name":"$self","kind":13,"containerName":"add_relationship","line":440},{"line":440,"kind":12,"containerName":"add_relationship","name":"_relationship_type_store"},{"name":"$self","kind":13,"containerName":"add_relationship","line":441},{"line":441,"name":"_unique_termid","containerName":"add_relationship","kind":12},{"line":441,"name":"$rel","containerName":"add_relationship","kind":13},{"line":441,"name":"predicate_term","containerName":"add_relationship","kind":12},{"line":441,"name":"$rel","containerName":"add_relationship","kind":13},{"name":"predicate_term","kind":12,"containerName":"add_relationship","line":441},{"containerName":"add_relationship","kind":13,"name":"$rel","line":443}],"containerName":"main::","name":"add_relationship","definition":"sub","detail":"($self,$rel)","line":433,"range":{"end":{"line":444,"character":9999},"start":{"line":433,"character":0}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$rel"}],"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _relationship_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_store'}) {\n\t\t  $self->throw(\"_relationship_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_store'};\n}\n\n=head2 _inverted_relationship_store\n\n Title   : _inverted_relationship_store\n Usage   :\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _inverted_relationship_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\tif ( defined $self->{'_inverted_relationship_store'}) {\n\t\t\t$self->throw(\"_inverted_relationship_store already defined\\n\");\n\t\t}\n\t\telse {\n\t\t\t$self->{'_inverted_relationship_store'} = $value;\n\t\t}\n\t}\n\n  return $self->{'_inverted_relationship_store'};\n}\n\n=head2 _relationship_type_store\n\n Title   : _relationship_type_store\n Usage   : $obj->_relationship_type_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    : reference to an array of Bio::Ontology::RelationshipType objects\n\n\nsub _relationship_type_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_type_store'}) {\n\t\t  $self->throw(\"_relationship_type_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_type_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_type_store'};\n}\n\n=head2 _add_relationship_simple\n\n Title   : _add_relationship_simple\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _add_relationship_simple{\n   my ($self, $store, $rel, $inverted) = @_;\n   my $parent_id;\n   my $child_id;\n\n   if ($inverted) {\n\t\t$parent_id = $rel->subject_term->identifier;\n\t\t$child_id = $rel->object_term->identifier;\n   }\n   else {\n\t\t$parent_id = $rel->object_term->identifier;\n\t\t$child_id = $rel->subject_term->identifier;\n   }\n   if(defined $store->{$parent_id} && (defined $store->{$parent_id}->{$child_id}) &&\n      ($store->{$parent_id}->{$child_id}->name != $rel->predicate_term->name)){\n\t\t$self->throw(\"relationship \".Dumper($rel->predicate_term).\n\t\t\t\t\t\t \" between \".$parent_id.\" and \".$child_id.\n\t\t\t\t\t\t \" already defined as \".\n\t\t\t\t\t\t Dumper($store->{$parent_id}->{$child_id}).\"\\n\");\n   }\n   else {\n\t\t$store->{$parent_id}->{$child_id} = $rel->predicate_term;\n   }\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : add_relationship(RelationshipI relationship): RelationshipI\n Function: Adds a relationship object to the ontology engine.\n Example :\n Returns : Its argument.\n Args    : A RelationshipI object.","label":"add_relationship($self,$rel)"}},{"kind":12,"range":{"end":{"line":468,"character":9999},"start":{"character":0,"line":457}},"line":457,"definition":"sub","name":"get_relationships","containerName":"main::","children":[{"definition":"my","line":458,"name":"$self","localvar":"my","containerName":"get_relationships","kind":13},{"line":459,"containerName":"get_relationships","localvar":"my","kind":13,"name":"$term","definition":"my"},{"containerName":"get_relationships","localvar":"my","kind":13,"name":"@rels","line":460,"definition":"my"},{"line":461,"localvar":"my","containerName":"get_relationships","kind":13,"name":"$store","definition":"my"},{"name":"$self","kind":13,"containerName":"get_relationships","line":461},{"containerName":"get_relationships","kind":12,"name":"_relationship_store","line":461},{"name":"$relfact","localvar":"my","containerName":"get_relationships","kind":13,"line":462,"definition":"my"},{"line":462,"name":"$self","containerName":"get_relationships","kind":13},{"line":462,"name":"relationship_factory","kind":12,"containerName":"get_relationships"},{"line":464,"localvar":"my","containerName":"get_relationships","kind":13,"name":"@parent_ids","definition":"my"},{"name":"$term","kind":13,"containerName":"get_relationships","line":464},{"line":466,"name":"identifier","containerName":"get_relationships","kind":12},{"containerName":"get_relationships","kind":13,"name":"$self","line":466},{"containerName":"get_relationships","kind":12,"name":"get_parent_terms","line":466},{"kind":13,"containerName":"get_relationships","name":"$term","line":466},{"line":468,"containerName":"get_relationships","kind":13,"name":"$store"}]},{"kind":13,"containerName":null,"name":"@parent_ids","line":470},{"line":470,"name":"$term","containerName":null,"kind":13},{"line":470,"name":"identifier","containerName":"main::","kind":12},{"name":"$term","containerName":null,"kind":13,"line":470},{"definition":"my","line":472,"localvar":"my","kind":13,"containerName":null,"name":"$parent_id"},{"name":"@parent_ids","containerName":null,"kind":13,"line":472},{"definition":"my","line":473,"localvar":"my","containerName":null,"kind":13,"name":"$parent_entry"},{"line":473,"name":"%store","kind":13,"containerName":null},{"name":"$parent_id","containerName":null,"kind":13,"line":473},{"name":"$term","containerName":null,"kind":13,"line":477},{"line":477,"name":"$parent_id","kind":13,"containerName":null},{"line":477,"name":"$term","kind":13,"containerName":null},{"line":477,"name":"identifier","containerName":"main::","kind":12},{"line":478,"name":"@parent_terms","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"line":478,"name":"$self","containerName":null,"kind":13},{"line":478,"name":"get_term_by_identifier","containerName":"main::","kind":12},{"kind":13,"containerName":null,"name":"$parent_id","line":478},{"name":"$parent_term","localvar":"my","containerName":null,"kind":13,"line":479,"definition":"my"},{"name":"@parent_terms","containerName":null,"kind":13,"line":479},{"kind":13,"containerName":null,"name":"@rels","line":480},{"line":481,"kind":13,"containerName":null,"name":"$relfact"},{"name":"create_object","containerName":"main::","kind":12,"line":481},{"line":481,"name":"$parent_term","kind":13,"containerName":null},{"line":482,"containerName":null,"kind":13,"name":"$term"},{"line":484,"containerName":null,"kind":13,"name":"%parent_entry"},{"name":"$term","containerName":null,"kind":13,"line":484},{"name":"identifier","kind":12,"containerName":"main::","line":484},{"containerName":null,"kind":13,"name":"$term","line":485},{"containerName":"main::","kind":12,"name":"ontology","line":485},{"definition":"my","name":"@parent_terms","localvar":"my","kind":13,"containerName":null,"line":492},{"line":492,"kind":13,"containerName":null,"name":"$term"},{"name":"$term","containerName":null,"kind":13,"line":493},{"name":"$self","kind":13,"containerName":null,"line":493},{"name":"get_term_by_identifier","kind":12,"containerName":"main::","line":493},{"containerName":null,"kind":13,"name":"$parent_id","line":493},{"definition":"my","name":"$child_id","containerName":null,"localvar":"my","kind":13,"line":494},{"name":"%parent_entry","containerName":null,"kind":13,"line":494},{"containerName":null,"localvar":"my","kind":13,"name":"$rel_info","line":495,"definition":"my"},{"line":495,"name":"%parent_entry","containerName":null,"kind":13},{"line":495,"kind":13,"containerName":null,"name":"$child_id"},{"definition":"my","line":496,"containerName":null,"localvar":"my","kind":13,"name":"$subj_term"},{"name":"$self","containerName":null,"kind":13,"line":496},{"containerName":"main::","kind":12,"name":"get_term_by_identifier","line":496},{"containerName":null,"kind":13,"name":"$child_id","line":496},{"definition":"my","line":498,"name":"$parent_term","localvar":"my","containerName":null,"kind":13},{"line":498,"name":"@parent_terms","kind":13,"containerName":null},{"line":499,"name":"@rels","containerName":null,"kind":13},{"name":"$relfact","containerName":null,"kind":13,"line":500},{"name":"create_object","containerName":"main::","kind":12,"line":500},{"line":500,"containerName":null,"kind":13,"name":"$parent_term"},{"line":501,"kind":13,"containerName":null,"name":"$subj_term"},{"name":"$rel_info","containerName":null,"kind":13,"line":502},{"line":503,"kind":13,"containerName":null,"name":"$parent_term"},{"line":504,"kind":12,"containerName":"main::","name":"ontology"},{"kind":13,"containerName":null,"name":"@rels","line":511},{"definition":"sub","name":"get_all_relationships","containerName":"main::","children":[{"containerName":"get_all_relationships","kind":12,"name":"get_relationships","line":526}],"kind":12,"range":{"end":{"character":9999,"line":527},"start":{"character":0,"line":525}},"line":525},{"definition":"sub","detail":"($self)","children":[{"line":541,"name":"$self","containerName":"get_predicate_terms","localvar":"my","kind":13,"definition":"my"},{"line":543,"containerName":"get_predicate_terms","kind":13,"name":"$self"},{"name":"_relationship_type_store","kind":12,"containerName":"get_predicate_terms","line":543}],"containerName":"main::","name":"get_predicate_terms","signature":{"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _relationship_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_store'}) {\n\t\t  $self->throw(\"_relationship_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_store'};\n}\n\n=head2 _inverted_relationship_store\n\n Title   : _inverted_relationship_store\n Usage   :\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _inverted_relationship_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\tif ( defined $self->{'_inverted_relationship_store'}) {\n\t\t\t$self->throw(\"_inverted_relationship_store already defined\\n\");\n\t\t}\n\t\telse {\n\t\t\t$self->{'_inverted_relationship_store'} = $value;\n\t\t}\n\t}\n\n  return $self->{'_inverted_relationship_store'};\n}\n\n=head2 _relationship_type_store\n\n Title   : _relationship_type_store\n Usage   : $obj->_relationship_type_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    : reference to an array of Bio::Ontology::RelationshipType objects\n\n\nsub _relationship_type_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_type_store'}) {\n\t\t  $self->throw(\"_relationship_type_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_type_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_type_store'};\n}\n\n=head2 _add_relationship_simple\n\n Title   : _add_relationship_simple\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _add_relationship_simple{\n   my ($self, $store, $rel, $inverted) = @_;\n   my $parent_id;\n   my $child_id;\n\n   if ($inverted) {\n\t\t$parent_id = $rel->subject_term->identifier;\n\t\t$child_id = $rel->object_term->identifier;\n   }\n   else {\n\t\t$parent_id = $rel->object_term->identifier;\n\t\t$child_id = $rel->subject_term->identifier;\n   }\n   if(defined $store->{$parent_id} && (defined $store->{$parent_id}->{$child_id}) &&\n      ($store->{$parent_id}->{$child_id}->name != $rel->predicate_term->name)){\n\t\t$self->throw(\"relationship \".Dumper($rel->predicate_term).\n\t\t\t\t\t\t \" between \".$parent_id.\" and \".$child_id.\n\t\t\t\t\t\t \" already defined as \".\n\t\t\t\t\t\t Dumper($store->{$parent_id}->{$child_id}).\"\\n\");\n   }\n   else {\n\t\t$store->{$parent_id}->{$child_id} = $rel->predicate_term;\n   }\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : add_relationship(RelationshipI relationship): RelationshipI\n Function: Adds a relationship object to the ontology engine.\n Example :\n Returns : Its argument.\n Args    : A RelationshipI object.\n\n\nsub add_relationship{\n   my ($self, $rel) = @_;\n\n   $self->_add_relationship_simple($self->_relationship_store,\n\t\t\t\t   $rel, 0);\n   $self->_add_relationship_simple($self->_inverted_relationship_store,\n\t\t\t\t   $rel, 1);\n   $self->_relationship_type_store->{\n       $self->_unique_termid($rel->predicate_term)} = $rel->predicate_term;\n\n   return $rel;\n}\n\n=head2 get_relationships\n\n Title   : get_relationships\n Usage   : get_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_relationships{\n    my $self = shift;\n    my $term = shift;\n    my @rels;\n    my $store = $self->_relationship_store;\n    my $relfact = $self->relationship_factory(); \n\n    my @parent_ids = $term ?\n\t\t# if a term is supplied then only get the term's parents\n\t\t(map { $_->identifier(); } $self->get_parent_terms($term)) :\n\t\t  # otherwise use all parent ids\n\t\t  (keys %{$store});\n    # add the term as a parent too if one is supplied\n    push(@parent_ids,$term->identifier) if $term;\n    \n    foreach my $parent_id (@parent_ids) {\n\t\t my $parent_entry = $store->{$parent_id};\n\n\t\t # if a term is supplied, add a relationship for the parent to the term\n\t\t # except if the parent is the term itself (we added that one before)\n\t\t if($term && ($parent_id ne $term->identifier())) {\n\t\t\t my @parent_terms = $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t push(@rels,\n\t\t\t\t\t\t$relfact->create_object(-object_term    => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term   => $term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term =>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t$parent_entry->{$term->identifier},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology => $term->ontology())\n\t\t\t\t\t  );\n\t\t\t }\n\t\t \n\t\t } else {\n\t\t\t # otherwise, i.e., no term supplied, or the parent equals the\n\t\t\t # supplied term\n\t\t\t my @parent_terms = $term ?\n\t\t\t\t($term) : $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $child_id (keys %$parent_entry) {\n\t\t\t\t my $rel_info = $parent_entry->{$child_id};\n\t\t\t\t my ($subj_term) = $self->get_term_by_identifier($child_id);\n\n\t\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t\t push(@rels,\n\t\t\t\t\t\t\t$relfact->create_object(-object_term  => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term => $subj_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term => $rel_info,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology =>$parent_term->ontology\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t  )\n\t\t\t\t\t\t  );\n\t\t\t\t }\n\t\t\t }\n\t\t }\n    }\n\n    return @rels;\n}\n\n=head2 get_all_relationships\n\n Title   : get_all_relationships\n Usage   : get_all_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_all_relationships{\n    return shift->get_relationships();\n}\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : get_predicate_terms(): TermI\n Function: Retrives all relationship types stored in the engine\n Example :\n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    :","parameters":[{"label":"$self"}],"label":"get_predicate_terms($self)"},"line":540,"range":{"end":{"character":9999,"line":543},"start":{"line":540,"character":0}},"kind":12},{"detail":"($self,$term,@rel_types)","definition":"sub","containerName":"main::","name":"_is_rel_type","children":[{"definition":"my","line":558,"name":"$self","containerName":"_is_rel_type","localvar":"my","kind":13},{"containerName":"_is_rel_type","kind":13,"name":"$term","line":558},{"name":"@rel_types","containerName":"_is_rel_type","kind":13,"line":558},{"localvar":"my","kind":13,"containerName":"_is_rel_type","name":"$rel_type","line":560,"definition":"my"},{"line":560,"containerName":"_is_rel_type","kind":13,"name":"@rel_types"},{"line":561,"name":"$rel_type","containerName":"_is_rel_type","kind":13},{"kind":12,"containerName":"_is_rel_type","name":"identifier","line":561},{"line":561,"containerName":"_is_rel_type","kind":13,"name":"$term"},{"name":"identifier","containerName":"_is_rel_type","kind":12,"line":561},{"kind":13,"containerName":"_is_rel_type","name":"$rel_type","line":562},{"name":"identifier","kind":12,"containerName":"_is_rel_type","line":562},{"name":"$term","containerName":"_is_rel_type","kind":13,"line":562},{"containerName":"_is_rel_type","kind":12,"name":"identifier","line":562},{"line":564,"name":"$rel_type","containerName":"_is_rel_type","kind":13},{"name":"name","kind":12,"containerName":"_is_rel_type","line":564},{"line":564,"name":"$term","kind":13,"containerName":"_is_rel_type"},{"line":564,"name":"name","kind":12,"containerName":"_is_rel_type"}],"signature":{"parameters":[{"label":"$self"},{"label":"$term"},{"label":"@rel_types"}],"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _relationship_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_store'}) {\n\t\t  $self->throw(\"_relationship_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_store'};\n}\n\n=head2 _inverted_relationship_store\n\n Title   : _inverted_relationship_store\n Usage   :\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _inverted_relationship_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\tif ( defined $self->{'_inverted_relationship_store'}) {\n\t\t\t$self->throw(\"_inverted_relationship_store already defined\\n\");\n\t\t}\n\t\telse {\n\t\t\t$self->{'_inverted_relationship_store'} = $value;\n\t\t}\n\t}\n\n  return $self->{'_inverted_relationship_store'};\n}\n\n=head2 _relationship_type_store\n\n Title   : _relationship_type_store\n Usage   : $obj->_relationship_type_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    : reference to an array of Bio::Ontology::RelationshipType objects\n\n\nsub _relationship_type_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_type_store'}) {\n\t\t  $self->throw(\"_relationship_type_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_type_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_type_store'};\n}\n\n=head2 _add_relationship_simple\n\n Title   : _add_relationship_simple\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _add_relationship_simple{\n   my ($self, $store, $rel, $inverted) = @_;\n   my $parent_id;\n   my $child_id;\n\n   if ($inverted) {\n\t\t$parent_id = $rel->subject_term->identifier;\n\t\t$child_id = $rel->object_term->identifier;\n   }\n   else {\n\t\t$parent_id = $rel->object_term->identifier;\n\t\t$child_id = $rel->subject_term->identifier;\n   }\n   if(defined $store->{$parent_id} && (defined $store->{$parent_id}->{$child_id}) &&\n      ($store->{$parent_id}->{$child_id}->name != $rel->predicate_term->name)){\n\t\t$self->throw(\"relationship \".Dumper($rel->predicate_term).\n\t\t\t\t\t\t \" between \".$parent_id.\" and \".$child_id.\n\t\t\t\t\t\t \" already defined as \".\n\t\t\t\t\t\t Dumper($store->{$parent_id}->{$child_id}).\"\\n\");\n   }\n   else {\n\t\t$store->{$parent_id}->{$child_id} = $rel->predicate_term;\n   }\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : add_relationship(RelationshipI relationship): RelationshipI\n Function: Adds a relationship object to the ontology engine.\n Example :\n Returns : Its argument.\n Args    : A RelationshipI object.\n\n\nsub add_relationship{\n   my ($self, $rel) = @_;\n\n   $self->_add_relationship_simple($self->_relationship_store,\n\t\t\t\t   $rel, 0);\n   $self->_add_relationship_simple($self->_inverted_relationship_store,\n\t\t\t\t   $rel, 1);\n   $self->_relationship_type_store->{\n       $self->_unique_termid($rel->predicate_term)} = $rel->predicate_term;\n\n   return $rel;\n}\n\n=head2 get_relationships\n\n Title   : get_relationships\n Usage   : get_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_relationships{\n    my $self = shift;\n    my $term = shift;\n    my @rels;\n    my $store = $self->_relationship_store;\n    my $relfact = $self->relationship_factory(); \n\n    my @parent_ids = $term ?\n\t\t# if a term is supplied then only get the term's parents\n\t\t(map { $_->identifier(); } $self->get_parent_terms($term)) :\n\t\t  # otherwise use all parent ids\n\t\t  (keys %{$store});\n    # add the term as a parent too if one is supplied\n    push(@parent_ids,$term->identifier) if $term;\n    \n    foreach my $parent_id (@parent_ids) {\n\t\t my $parent_entry = $store->{$parent_id};\n\n\t\t # if a term is supplied, add a relationship for the parent to the term\n\t\t # except if the parent is the term itself (we added that one before)\n\t\t if($term && ($parent_id ne $term->identifier())) {\n\t\t\t my @parent_terms = $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t push(@rels,\n\t\t\t\t\t\t$relfact->create_object(-object_term    => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term   => $term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term =>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t$parent_entry->{$term->identifier},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology => $term->ontology())\n\t\t\t\t\t  );\n\t\t\t }\n\t\t \n\t\t } else {\n\t\t\t # otherwise, i.e., no term supplied, or the parent equals the\n\t\t\t # supplied term\n\t\t\t my @parent_terms = $term ?\n\t\t\t\t($term) : $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $child_id (keys %$parent_entry) {\n\t\t\t\t my $rel_info = $parent_entry->{$child_id};\n\t\t\t\t my ($subj_term) = $self->get_term_by_identifier($child_id);\n\n\t\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t\t push(@rels,\n\t\t\t\t\t\t\t$relfact->create_object(-object_term  => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term => $subj_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term => $rel_info,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology =>$parent_term->ontology\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t  )\n\t\t\t\t\t\t  );\n\t\t\t\t }\n\t\t\t }\n\t\t }\n    }\n\n    return @rels;\n}\n\n=head2 get_all_relationships\n\n Title   : get_all_relationships\n Usage   : get_all_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_all_relationships{\n    return shift->get_relationships();\n}\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : get_predicate_terms(): TermI\n Function: Retrives all relationship types stored in the engine\n Example :\n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    :\n\n\nsub get_predicate_terms{\n  my ($self) = @_;\n\n  return values %{$self->_relationship_type_store};\n}\n\n=head2 _is_rel_type\n\n Title   : _is_rel_type\n Usage   :\n Function:\n Example :\n Returns : \n Args    :","label":"_is_rel_type($self,$term,@rel_types)"},"range":{"end":{"character":9999,"line":569},"start":{"line":557,"character":0}},"kind":12,"line":557},{"detail":"($self,$rel_store,$level,$term_id,@rel_types)","definition":"sub","name":"_typed_traversal","containerName":"main::","children":[{"definition":"my","line":583,"localvar":"my","kind":13,"containerName":"_typed_traversal","name":"$self"},{"line":583,"containerName":"_typed_traversal","kind":13,"name":"$rel_store"},{"name":"$level","kind":13,"containerName":"_typed_traversal","line":583},{"containerName":"_typed_traversal","kind":13,"name":"$term_id","line":583},{"kind":13,"containerName":"_typed_traversal","name":"@rel_types","line":583},{"name":"$rel_store","kind":13,"containerName":"_typed_traversal","line":584},{"line":584,"containerName":"_typed_traversal","kind":13,"name":"$term_id"},{"definition":"my","name":"%parent_entry","kind":13,"localvar":"my","containerName":"_typed_traversal","line":585},{"kind":13,"containerName":"_typed_traversal","name":"$rel_store","line":585},{"line":585,"kind":13,"containerName":"_typed_traversal","name":"$term_id"}],"signature":{"label":"_typed_traversal($self,$rel_store,$level,$term_id,@rel_types)","parameters":[{"label":"$self"},{"label":"$rel_store"},{"label":"$level"},{"label":"$term_id"},{"label":"@rel_types"}],"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _relationship_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_store'}) {\n\t\t  $self->throw(\"_relationship_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_store'};\n}\n\n=head2 _inverted_relationship_store\n\n Title   : _inverted_relationship_store\n Usage   :\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _inverted_relationship_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\tif ( defined $self->{'_inverted_relationship_store'}) {\n\t\t\t$self->throw(\"_inverted_relationship_store already defined\\n\");\n\t\t}\n\t\telse {\n\t\t\t$self->{'_inverted_relationship_store'} = $value;\n\t\t}\n\t}\n\n  return $self->{'_inverted_relationship_store'};\n}\n\n=head2 _relationship_type_store\n\n Title   : _relationship_type_store\n Usage   : $obj->_relationship_type_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    : reference to an array of Bio::Ontology::RelationshipType objects\n\n\nsub _relationship_type_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_type_store'}) {\n\t\t  $self->throw(\"_relationship_type_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_type_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_type_store'};\n}\n\n=head2 _add_relationship_simple\n\n Title   : _add_relationship_simple\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _add_relationship_simple{\n   my ($self, $store, $rel, $inverted) = @_;\n   my $parent_id;\n   my $child_id;\n\n   if ($inverted) {\n\t\t$parent_id = $rel->subject_term->identifier;\n\t\t$child_id = $rel->object_term->identifier;\n   }\n   else {\n\t\t$parent_id = $rel->object_term->identifier;\n\t\t$child_id = $rel->subject_term->identifier;\n   }\n   if(defined $store->{$parent_id} && (defined $store->{$parent_id}->{$child_id}) &&\n      ($store->{$parent_id}->{$child_id}->name != $rel->predicate_term->name)){\n\t\t$self->throw(\"relationship \".Dumper($rel->predicate_term).\n\t\t\t\t\t\t \" between \".$parent_id.\" and \".$child_id.\n\t\t\t\t\t\t \" already defined as \".\n\t\t\t\t\t\t Dumper($store->{$parent_id}->{$child_id}).\"\\n\");\n   }\n   else {\n\t\t$store->{$parent_id}->{$child_id} = $rel->predicate_term;\n   }\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : add_relationship(RelationshipI relationship): RelationshipI\n Function: Adds a relationship object to the ontology engine.\n Example :\n Returns : Its argument.\n Args    : A RelationshipI object.\n\n\nsub add_relationship{\n   my ($self, $rel) = @_;\n\n   $self->_add_relationship_simple($self->_relationship_store,\n\t\t\t\t   $rel, 0);\n   $self->_add_relationship_simple($self->_inverted_relationship_store,\n\t\t\t\t   $rel, 1);\n   $self->_relationship_type_store->{\n       $self->_unique_termid($rel->predicate_term)} = $rel->predicate_term;\n\n   return $rel;\n}\n\n=head2 get_relationships\n\n Title   : get_relationships\n Usage   : get_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_relationships{\n    my $self = shift;\n    my $term = shift;\n    my @rels;\n    my $store = $self->_relationship_store;\n    my $relfact = $self->relationship_factory(); \n\n    my @parent_ids = $term ?\n\t\t# if a term is supplied then only get the term's parents\n\t\t(map { $_->identifier(); } $self->get_parent_terms($term)) :\n\t\t  # otherwise use all parent ids\n\t\t  (keys %{$store});\n    # add the term as a parent too if one is supplied\n    push(@parent_ids,$term->identifier) if $term;\n    \n    foreach my $parent_id (@parent_ids) {\n\t\t my $parent_entry = $store->{$parent_id};\n\n\t\t # if a term is supplied, add a relationship for the parent to the term\n\t\t # except if the parent is the term itself (we added that one before)\n\t\t if($term && ($parent_id ne $term->identifier())) {\n\t\t\t my @parent_terms = $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t push(@rels,\n\t\t\t\t\t\t$relfact->create_object(-object_term    => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term   => $term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term =>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t$parent_entry->{$term->identifier},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology => $term->ontology())\n\t\t\t\t\t  );\n\t\t\t }\n\t\t \n\t\t } else {\n\t\t\t # otherwise, i.e., no term supplied, or the parent equals the\n\t\t\t # supplied term\n\t\t\t my @parent_terms = $term ?\n\t\t\t\t($term) : $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $child_id (keys %$parent_entry) {\n\t\t\t\t my $rel_info = $parent_entry->{$child_id};\n\t\t\t\t my ($subj_term) = $self->get_term_by_identifier($child_id);\n\n\t\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t\t push(@rels,\n\t\t\t\t\t\t\t$relfact->create_object(-object_term  => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term => $subj_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term => $rel_info,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology =>$parent_term->ontology\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t  )\n\t\t\t\t\t\t  );\n\t\t\t\t }\n\t\t\t }\n\t\t }\n    }\n\n    return @rels;\n}\n\n=head2 get_all_relationships\n\n Title   : get_all_relationships\n Usage   : get_all_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_all_relationships{\n    return shift->get_relationships();\n}\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : get_predicate_terms(): TermI\n Function: Retrives all relationship types stored in the engine\n Example :\n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    :\n\n\nsub get_predicate_terms{\n  my ($self) = @_;\n\n  return values %{$self->_relationship_type_store};\n}\n\n=head2 _is_rel_type\n\n Title   : _is_rel_type\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _is_rel_type{\n  my ($self, $term, @rel_types) = @_;\n\n  foreach my $rel_type (@rel_types) {\n\t  if($rel_type->identifier || $term->identifier) {\n\t\t  return 1 if $rel_type->identifier eq $term->identifier;\n\t  } else {\n\t\t  return 1 if $rel_type->name eq $term->name;\n\t  }\n  }\n\n  return 0;\n}\n\n=head2 _typed_traversal\n\n Title   : _typed_traversal\n Usage   :\n Function:\n Example :\n Returns :\n Args    :"},"range":{"start":{"character":0,"line":582},"end":{"character":9999,"line":585}},"kind":12,"line":582},{"definition":"my","line":586,"localvar":"my","containerName":null,"kind":13,"name":"@children"},{"kind":13,"containerName":null,"name":"%parent_entry","line":586},{"line":588,"name":"@ans","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"name":"@rel_types","kind":13,"containerName":null,"line":590},{"containerName":null,"kind":13,"name":"@ans","line":591},{"line":593,"localvar":"my","kind":13,"containerName":null,"name":"$child_id","definition":"my"},{"line":593,"containerName":null,"kind":13,"name":"@children"},{"containerName":null,"kind":13,"name":"@ans","line":594},{"kind":13,"containerName":null,"name":"$child_id","line":595},{"line":595,"kind":13,"containerName":null,"name":"$self"},{"name":"_is_rel_type","kind":12,"containerName":"main::","line":595},{"line":595,"name":"%rel_store","containerName":null,"kind":13},{"line":595,"containerName":null,"kind":13,"name":"%term_id"},{"name":"$child_id","containerName":null,"kind":13,"line":595},{"line":596,"kind":13,"containerName":null,"name":"@rel_types"},{"name":"@ans","kind":13,"containerName":null,"line":600},{"name":"@children","containerName":null,"kind":13,"line":600},{"name":"%level","containerName":null,"kind":13,"line":602},{"name":"@ans1","kind":13,"localvar":"my","containerName":null,"line":603,"definition":"my"},{"line":605,"kind":13,"localvar":"my","containerName":null,"name":"$child_id","definition":"my"},{"name":"@ans","containerName":null,"kind":13,"line":605},{"name":"@ans1","kind":13,"containerName":null,"line":606},{"line":606,"name":"$self","kind":13,"containerName":null},{"line":606,"kind":12,"containerName":"main::","name":"_typed_traversal"},{"containerName":null,"kind":13,"name":"$rel_store","line":606},{"line":607,"kind":13,"containerName":null,"name":"$level"},{"name":"$child_id","kind":13,"containerName":null,"line":607},{"line":607,"kind":13,"containerName":null,"name":"@rel_types"},{"name":"%rel_store","containerName":null,"kind":13,"line":608},{"line":608,"name":"$child_id","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"@ans","line":610},{"line":610,"containerName":null,"kind":13,"name":"@ans1"},{"name":"@ans","containerName":null,"kind":13,"line":613},{"definition":"sub","detail":"($self,$term,@relationship_types)","children":[{"localvar":"my","containerName":"get_child_terms","kind":13,"name":"$self","line":634,"definition":"my"},{"name":"$term","containerName":"get_child_terms","kind":13,"line":634},{"name":"@relationship_types","containerName":"get_child_terms","kind":13,"line":634},{"name":"$self","containerName":"get_child_terms","kind":13,"line":636},{"name":"throw","kind":12,"containerName":"get_child_terms","line":636},{"line":637,"containerName":"get_child_terms","kind":13,"name":"$term"},{"name":"$term","kind":13,"containerName":"get_child_terms","line":637},{"line":637,"kind":12,"containerName":"get_child_terms","name":"isa"},{"line":639,"name":"$self","kind":13,"containerName":"get_child_terms"},{"line":639,"name":"_filter_unmarked","containerName":"get_child_terms","kind":12},{"line":640,"name":"$self","containerName":"get_child_terms","kind":13},{"name":"get_term_by_identifier","kind":12,"containerName":"get_child_terms","line":640},{"containerName":"get_child_terms","kind":13,"name":"$self","line":641},{"line":641,"name":"_typed_traversal","kind":12,"containerName":"get_child_terms"},{"containerName":"get_child_terms","kind":13,"name":"$self","line":641},{"kind":12,"containerName":"get_child_terms","name":"_relationship_store","line":641},{"kind":13,"containerName":"get_child_terms","name":"$term","line":643},{"line":643,"name":"identifier","kind":12,"containerName":"get_child_terms"},{"name":"@relationship_types","kind":13,"containerName":"get_child_terms","line":644}],"name":"get_child_terms","containerName":"main::","signature":{"label":"get_child_terms($self,$term,@relationship_types)","documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _relationship_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_store'}) {\n\t\t  $self->throw(\"_relationship_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_store'};\n}\n\n=head2 _inverted_relationship_store\n\n Title   : _inverted_relationship_store\n Usage   :\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _inverted_relationship_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\tif ( defined $self->{'_inverted_relationship_store'}) {\n\t\t\t$self->throw(\"_inverted_relationship_store already defined\\n\");\n\t\t}\n\t\telse {\n\t\t\t$self->{'_inverted_relationship_store'} = $value;\n\t\t}\n\t}\n\n  return $self->{'_inverted_relationship_store'};\n}\n\n=head2 _relationship_type_store\n\n Title   : _relationship_type_store\n Usage   : $obj->_relationship_type_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    : reference to an array of Bio::Ontology::RelationshipType objects\n\n\nsub _relationship_type_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_type_store'}) {\n\t\t  $self->throw(\"_relationship_type_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_type_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_type_store'};\n}\n\n=head2 _add_relationship_simple\n\n Title   : _add_relationship_simple\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _add_relationship_simple{\n   my ($self, $store, $rel, $inverted) = @_;\n   my $parent_id;\n   my $child_id;\n\n   if ($inverted) {\n\t\t$parent_id = $rel->subject_term->identifier;\n\t\t$child_id = $rel->object_term->identifier;\n   }\n   else {\n\t\t$parent_id = $rel->object_term->identifier;\n\t\t$child_id = $rel->subject_term->identifier;\n   }\n   if(defined $store->{$parent_id} && (defined $store->{$parent_id}->{$child_id}) &&\n      ($store->{$parent_id}->{$child_id}->name != $rel->predicate_term->name)){\n\t\t$self->throw(\"relationship \".Dumper($rel->predicate_term).\n\t\t\t\t\t\t \" between \".$parent_id.\" and \".$child_id.\n\t\t\t\t\t\t \" already defined as \".\n\t\t\t\t\t\t Dumper($store->{$parent_id}->{$child_id}).\"\\n\");\n   }\n   else {\n\t\t$store->{$parent_id}->{$child_id} = $rel->predicate_term;\n   }\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : add_relationship(RelationshipI relationship): RelationshipI\n Function: Adds a relationship object to the ontology engine.\n Example :\n Returns : Its argument.\n Args    : A RelationshipI object.\n\n\nsub add_relationship{\n   my ($self, $rel) = @_;\n\n   $self->_add_relationship_simple($self->_relationship_store,\n\t\t\t\t   $rel, 0);\n   $self->_add_relationship_simple($self->_inverted_relationship_store,\n\t\t\t\t   $rel, 1);\n   $self->_relationship_type_store->{\n       $self->_unique_termid($rel->predicate_term)} = $rel->predicate_term;\n\n   return $rel;\n}\n\n=head2 get_relationships\n\n Title   : get_relationships\n Usage   : get_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_relationships{\n    my $self = shift;\n    my $term = shift;\n    my @rels;\n    my $store = $self->_relationship_store;\n    my $relfact = $self->relationship_factory(); \n\n    my @parent_ids = $term ?\n\t\t# if a term is supplied then only get the term's parents\n\t\t(map { $_->identifier(); } $self->get_parent_terms($term)) :\n\t\t  # otherwise use all parent ids\n\t\t  (keys %{$store});\n    # add the term as a parent too if one is supplied\n    push(@parent_ids,$term->identifier) if $term;\n    \n    foreach my $parent_id (@parent_ids) {\n\t\t my $parent_entry = $store->{$parent_id};\n\n\t\t # if a term is supplied, add a relationship for the parent to the term\n\t\t # except if the parent is the term itself (we added that one before)\n\t\t if($term && ($parent_id ne $term->identifier())) {\n\t\t\t my @parent_terms = $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t push(@rels,\n\t\t\t\t\t\t$relfact->create_object(-object_term    => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term   => $term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term =>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t$parent_entry->{$term->identifier},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology => $term->ontology())\n\t\t\t\t\t  );\n\t\t\t }\n\t\t \n\t\t } else {\n\t\t\t # otherwise, i.e., no term supplied, or the parent equals the\n\t\t\t # supplied term\n\t\t\t my @parent_terms = $term ?\n\t\t\t\t($term) : $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $child_id (keys %$parent_entry) {\n\t\t\t\t my $rel_info = $parent_entry->{$child_id};\n\t\t\t\t my ($subj_term) = $self->get_term_by_identifier($child_id);\n\n\t\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t\t push(@rels,\n\t\t\t\t\t\t\t$relfact->create_object(-object_term  => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term => $subj_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term => $rel_info,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology =>$parent_term->ontology\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t  )\n\t\t\t\t\t\t  );\n\t\t\t\t }\n\t\t\t }\n\t\t }\n    }\n\n    return @rels;\n}\n\n=head2 get_all_relationships\n\n Title   : get_all_relationships\n Usage   : get_all_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_all_relationships{\n    return shift->get_relationships();\n}\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : get_predicate_terms(): TermI\n Function: Retrives all relationship types stored in the engine\n Example :\n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    :\n\n\nsub get_predicate_terms{\n  my ($self) = @_;\n\n  return values %{$self->_relationship_type_store};\n}\n\n=head2 _is_rel_type\n\n Title   : _is_rel_type\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _is_rel_type{\n  my ($self, $term, @rel_types) = @_;\n\n  foreach my $rel_type (@rel_types) {\n\t  if($rel_type->identifier || $term->identifier) {\n\t\t  return 1 if $rel_type->identifier eq $term->identifier;\n\t  } else {\n\t\t  return 1 if $rel_type->name eq $term->name;\n\t  }\n  }\n\n  return 0;\n}\n\n=head2 _typed_traversal\n\n Title   : _typed_traversal\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\nsub _typed_traversal{\n\tmy ($self, $rel_store, $level, $term_id, @rel_types) = @_;\n\treturn if !defined($rel_store->{$term_id});\n\tmy %parent_entry = %{$rel_store->{$term_id}};\n\tmy @children = keys %parent_entry;\n\n\tmy @ans;\n\n\tif (@rel_types > 0) {\n\t\t@ans = ();\n\n\t\tforeach my $child_id (@children) {\n\t\t\tpush @ans, $child_id\n\t\t\t  if $self->_is_rel_type( $rel_store->{$term_id}->{$child_id},\n\t\t\t\t\t\t\t\t\t\t\t  @rel_types);\n\t\t}\n\t}\n\telse {\n\t\t@ans = @children;\n\t}\n\tif ($level < 1) {\n\t\tmy @ans1 = ();\n\n\t\tforeach my $child_id (@ans) {\n\t\t\tpush @ans1, $self->_typed_traversal($rel_store,\n\t\t\t\t\t\t\t\t$level - 1, $child_id, @rel_types)\n\t\t\t  if defined $rel_store->{$child_id};\n\t\t}\n\t\tpush @ans, @ans1;\n\t}\n\n  return @ans;\n}\n\n=head2 get_child_terms\n\n Title   : get_child_terms\n Usage   : get_child_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all child terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_child_terms is a special\n           case of get_descendant_terms, limiting the search to the\n           direct descendants.\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.","parameters":[{"label":"$self"},{"label":"$term"},{"label":"@relationship_types"}]},"line":633,"kind":12,"range":{"start":{"character":0,"line":633},"end":{"line":645,"character":9999}}},{"definition":"sub","detail":"($self,$term,@relationship_types)","children":[{"line":665,"kind":13,"localvar":"my","containerName":"get_descendant_terms","name":"$self","definition":"my"},{"line":665,"name":"$term","containerName":"get_descendant_terms","kind":13},{"name":"@relationship_types","kind":13,"containerName":"get_descendant_terms","line":665},{"name":"$self","containerName":"get_descendant_terms","kind":13,"line":667},{"name":"throw","kind":12,"containerName":"get_descendant_terms","line":667},{"line":668,"kind":13,"containerName":"get_descendant_terms","name":"$term"},{"line":668,"kind":13,"containerName":"get_descendant_terms","name":"$term"},{"name":"isa","kind":12,"containerName":"get_descendant_terms","line":668},{"kind":13,"containerName":"get_descendant_terms","name":"$self","line":670},{"line":670,"name":"_filter_unmarked","kind":12,"containerName":"get_descendant_terms"},{"name":"$self","containerName":"get_descendant_terms","kind":13,"line":671},{"line":671,"containerName":"get_descendant_terms","kind":12,"name":"_filter_repeated"},{"line":672,"name":"$self","containerName":"get_descendant_terms","kind":13},{"line":672,"kind":12,"containerName":"get_descendant_terms","name":"get_term_by_identifier"},{"line":673,"name":"$self","kind":13,"containerName":"get_descendant_terms"},{"line":673,"name":"_typed_traversal","containerName":"get_descendant_terms","kind":12},{"kind":13,"containerName":"get_descendant_terms","name":"$self","line":673},{"line":673,"containerName":"get_descendant_terms","kind":12,"name":"_relationship_store"},{"kind":13,"containerName":"get_descendant_terms","name":"$term","line":675},{"kind":12,"containerName":"get_descendant_terms","name":"identifier","line":675},{"containerName":"get_descendant_terms","kind":13,"name":"@relationship_types","line":676}],"name":"get_descendant_terms","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$term"},{"label":"@relationship_types"}],"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _relationship_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_store'}) {\n\t\t  $self->throw(\"_relationship_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_store'};\n}\n\n=head2 _inverted_relationship_store\n\n Title   : _inverted_relationship_store\n Usage   :\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _inverted_relationship_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\tif ( defined $self->{'_inverted_relationship_store'}) {\n\t\t\t$self->throw(\"_inverted_relationship_store already defined\\n\");\n\t\t}\n\t\telse {\n\t\t\t$self->{'_inverted_relationship_store'} = $value;\n\t\t}\n\t}\n\n  return $self->{'_inverted_relationship_store'};\n}\n\n=head2 _relationship_type_store\n\n Title   : _relationship_type_store\n Usage   : $obj->_relationship_type_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    : reference to an array of Bio::Ontology::RelationshipType objects\n\n\nsub _relationship_type_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_type_store'}) {\n\t\t  $self->throw(\"_relationship_type_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_type_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_type_store'};\n}\n\n=head2 _add_relationship_simple\n\n Title   : _add_relationship_simple\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _add_relationship_simple{\n   my ($self, $store, $rel, $inverted) = @_;\n   my $parent_id;\n   my $child_id;\n\n   if ($inverted) {\n\t\t$parent_id = $rel->subject_term->identifier;\n\t\t$child_id = $rel->object_term->identifier;\n   }\n   else {\n\t\t$parent_id = $rel->object_term->identifier;\n\t\t$child_id = $rel->subject_term->identifier;\n   }\n   if(defined $store->{$parent_id} && (defined $store->{$parent_id}->{$child_id}) &&\n      ($store->{$parent_id}->{$child_id}->name != $rel->predicate_term->name)){\n\t\t$self->throw(\"relationship \".Dumper($rel->predicate_term).\n\t\t\t\t\t\t \" between \".$parent_id.\" and \".$child_id.\n\t\t\t\t\t\t \" already defined as \".\n\t\t\t\t\t\t Dumper($store->{$parent_id}->{$child_id}).\"\\n\");\n   }\n   else {\n\t\t$store->{$parent_id}->{$child_id} = $rel->predicate_term;\n   }\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : add_relationship(RelationshipI relationship): RelationshipI\n Function: Adds a relationship object to the ontology engine.\n Example :\n Returns : Its argument.\n Args    : A RelationshipI object.\n\n\nsub add_relationship{\n   my ($self, $rel) = @_;\n\n   $self->_add_relationship_simple($self->_relationship_store,\n\t\t\t\t   $rel, 0);\n   $self->_add_relationship_simple($self->_inverted_relationship_store,\n\t\t\t\t   $rel, 1);\n   $self->_relationship_type_store->{\n       $self->_unique_termid($rel->predicate_term)} = $rel->predicate_term;\n\n   return $rel;\n}\n\n=head2 get_relationships\n\n Title   : get_relationships\n Usage   : get_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_relationships{\n    my $self = shift;\n    my $term = shift;\n    my @rels;\n    my $store = $self->_relationship_store;\n    my $relfact = $self->relationship_factory(); \n\n    my @parent_ids = $term ?\n\t\t# if a term is supplied then only get the term's parents\n\t\t(map { $_->identifier(); } $self->get_parent_terms($term)) :\n\t\t  # otherwise use all parent ids\n\t\t  (keys %{$store});\n    # add the term as a parent too if one is supplied\n    push(@parent_ids,$term->identifier) if $term;\n    \n    foreach my $parent_id (@parent_ids) {\n\t\t my $parent_entry = $store->{$parent_id};\n\n\t\t # if a term is supplied, add a relationship for the parent to the term\n\t\t # except if the parent is the term itself (we added that one before)\n\t\t if($term && ($parent_id ne $term->identifier())) {\n\t\t\t my @parent_terms = $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t push(@rels,\n\t\t\t\t\t\t$relfact->create_object(-object_term    => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term   => $term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term =>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t$parent_entry->{$term->identifier},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology => $term->ontology())\n\t\t\t\t\t  );\n\t\t\t }\n\t\t \n\t\t } else {\n\t\t\t # otherwise, i.e., no term supplied, or the parent equals the\n\t\t\t # supplied term\n\t\t\t my @parent_terms = $term ?\n\t\t\t\t($term) : $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $child_id (keys %$parent_entry) {\n\t\t\t\t my $rel_info = $parent_entry->{$child_id};\n\t\t\t\t my ($subj_term) = $self->get_term_by_identifier($child_id);\n\n\t\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t\t push(@rels,\n\t\t\t\t\t\t\t$relfact->create_object(-object_term  => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term => $subj_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term => $rel_info,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology =>$parent_term->ontology\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t  )\n\t\t\t\t\t\t  );\n\t\t\t\t }\n\t\t\t }\n\t\t }\n    }\n\n    return @rels;\n}\n\n=head2 get_all_relationships\n\n Title   : get_all_relationships\n Usage   : get_all_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_all_relationships{\n    return shift->get_relationships();\n}\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : get_predicate_terms(): TermI\n Function: Retrives all relationship types stored in the engine\n Example :\n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    :\n\n\nsub get_predicate_terms{\n  my ($self) = @_;\n\n  return values %{$self->_relationship_type_store};\n}\n\n=head2 _is_rel_type\n\n Title   : _is_rel_type\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _is_rel_type{\n  my ($self, $term, @rel_types) = @_;\n\n  foreach my $rel_type (@rel_types) {\n\t  if($rel_type->identifier || $term->identifier) {\n\t\t  return 1 if $rel_type->identifier eq $term->identifier;\n\t  } else {\n\t\t  return 1 if $rel_type->name eq $term->name;\n\t  }\n  }\n\n  return 0;\n}\n\n=head2 _typed_traversal\n\n Title   : _typed_traversal\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\nsub _typed_traversal{\n\tmy ($self, $rel_store, $level, $term_id, @rel_types) = @_;\n\treturn if !defined($rel_store->{$term_id});\n\tmy %parent_entry = %{$rel_store->{$term_id}};\n\tmy @children = keys %parent_entry;\n\n\tmy @ans;\n\n\tif (@rel_types > 0) {\n\t\t@ans = ();\n\n\t\tforeach my $child_id (@children) {\n\t\t\tpush @ans, $child_id\n\t\t\t  if $self->_is_rel_type( $rel_store->{$term_id}->{$child_id},\n\t\t\t\t\t\t\t\t\t\t\t  @rel_types);\n\t\t}\n\t}\n\telse {\n\t\t@ans = @children;\n\t}\n\tif ($level < 1) {\n\t\tmy @ans1 = ();\n\n\t\tforeach my $child_id (@ans) {\n\t\t\tpush @ans1, $self->_typed_traversal($rel_store,\n\t\t\t\t\t\t\t\t$level - 1, $child_id, @rel_types)\n\t\t\t  if defined $rel_store->{$child_id};\n\t\t}\n\t\tpush @ans, @ans1;\n\t}\n\n  return @ans;\n}\n\n=head2 get_child_terms\n\n Title   : get_child_terms\n Usage   : get_child_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all child terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_child_terms is a special\n           case of get_descendant_terms, limiting the search to the\n           direct descendants.\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_child_terms{\n\tmy ($self, $term, @relationship_types) = @_;\n\n\t$self->throw(\"must provide TermI compliant object\") \n\t  unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n\treturn $self->_filter_unmarked(\n\t\t\t\t\t\t\t\t\t\t\t $self->get_term_by_identifier(\n\t\t\t\t\t\t$self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t   1,\n\t\t\t\t\t   $term->identifier,\n\t\t\t\t\t   @relationship_types) ) );\n}\n\n=head2 get_descendant_terms\n\n Title   : get_descendant_terms\n Usage   : get_descendant_terms(TermI term, TermI rel_types): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all descendant terms of a given term, that\n           satisfy a relationship among those that are specified in\n           the second argument or undef otherwise. Uses\n           _typed_traversal to find all descendants.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.","label":"get_descendant_terms($self,$term,@relationship_types)"},"line":664,"kind":12,"range":{"start":{"character":0,"line":664},"end":{"line":677,"character":9999}}},{"children":[{"definition":"my","localvar":"my","containerName":"get_parent_terms","kind":13,"name":"$self","line":697},{"line":697,"name":"$term","kind":13,"containerName":"get_parent_terms"},{"containerName":"get_parent_terms","kind":13,"name":"@relationship_types","line":697},{"name":"$self","kind":13,"containerName":"get_parent_terms","line":698},{"name":"throw","containerName":"get_parent_terms","kind":12,"line":698},{"line":698,"name":"$term","containerName":"get_parent_terms","kind":13},{"name":"$self","kind":13,"containerName":"get_parent_terms","line":700},{"line":700,"name":"_filter_unmarked","kind":12,"containerName":"get_parent_terms"},{"containerName":"get_parent_terms","kind":13,"name":"$self","line":701},{"line":701,"kind":12,"containerName":"get_parent_terms","name":"get_term_by_identifier"},{"line":702,"kind":13,"containerName":"get_parent_terms","name":"$self"},{"line":702,"containerName":"get_parent_terms","kind":12,"name":"_typed_traversal"},{"line":702,"containerName":"get_parent_terms","kind":13,"name":"$self"},{"containerName":"get_parent_terms","kind":12,"name":"_inverted_relationship_store","line":702},{"kind":13,"containerName":"get_parent_terms","name":"$term","line":704},{"line":704,"name":"identifier","containerName":"get_parent_terms","kind":12},{"line":705,"containerName":"get_parent_terms","kind":13,"name":"@relationship_types"}],"name":"get_parent_terms","containerName":"main::","definition":"sub","detail":"($self,$term,@relationship_types)","line":696,"kind":12,"range":{"start":{"line":696,"character":0},"end":{"line":706,"character":9999}},"signature":{"label":"get_parent_terms($self,$term,@relationship_types)","documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _relationship_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_store'}) {\n\t\t  $self->throw(\"_relationship_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_store'};\n}\n\n=head2 _inverted_relationship_store\n\n Title   : _inverted_relationship_store\n Usage   :\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _inverted_relationship_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\tif ( defined $self->{'_inverted_relationship_store'}) {\n\t\t\t$self->throw(\"_inverted_relationship_store already defined\\n\");\n\t\t}\n\t\telse {\n\t\t\t$self->{'_inverted_relationship_store'} = $value;\n\t\t}\n\t}\n\n  return $self->{'_inverted_relationship_store'};\n}\n\n=head2 _relationship_type_store\n\n Title   : _relationship_type_store\n Usage   : $obj->_relationship_type_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    : reference to an array of Bio::Ontology::RelationshipType objects\n\n\nsub _relationship_type_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_type_store'}) {\n\t\t  $self->throw(\"_relationship_type_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_type_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_type_store'};\n}\n\n=head2 _add_relationship_simple\n\n Title   : _add_relationship_simple\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _add_relationship_simple{\n   my ($self, $store, $rel, $inverted) = @_;\n   my $parent_id;\n   my $child_id;\n\n   if ($inverted) {\n\t\t$parent_id = $rel->subject_term->identifier;\n\t\t$child_id = $rel->object_term->identifier;\n   }\n   else {\n\t\t$parent_id = $rel->object_term->identifier;\n\t\t$child_id = $rel->subject_term->identifier;\n   }\n   if(defined $store->{$parent_id} && (defined $store->{$parent_id}->{$child_id}) &&\n      ($store->{$parent_id}->{$child_id}->name != $rel->predicate_term->name)){\n\t\t$self->throw(\"relationship \".Dumper($rel->predicate_term).\n\t\t\t\t\t\t \" between \".$parent_id.\" and \".$child_id.\n\t\t\t\t\t\t \" already defined as \".\n\t\t\t\t\t\t Dumper($store->{$parent_id}->{$child_id}).\"\\n\");\n   }\n   else {\n\t\t$store->{$parent_id}->{$child_id} = $rel->predicate_term;\n   }\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : add_relationship(RelationshipI relationship): RelationshipI\n Function: Adds a relationship object to the ontology engine.\n Example :\n Returns : Its argument.\n Args    : A RelationshipI object.\n\n\nsub add_relationship{\n   my ($self, $rel) = @_;\n\n   $self->_add_relationship_simple($self->_relationship_store,\n\t\t\t\t   $rel, 0);\n   $self->_add_relationship_simple($self->_inverted_relationship_store,\n\t\t\t\t   $rel, 1);\n   $self->_relationship_type_store->{\n       $self->_unique_termid($rel->predicate_term)} = $rel->predicate_term;\n\n   return $rel;\n}\n\n=head2 get_relationships\n\n Title   : get_relationships\n Usage   : get_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_relationships{\n    my $self = shift;\n    my $term = shift;\n    my @rels;\n    my $store = $self->_relationship_store;\n    my $relfact = $self->relationship_factory(); \n\n    my @parent_ids = $term ?\n\t\t# if a term is supplied then only get the term's parents\n\t\t(map { $_->identifier(); } $self->get_parent_terms($term)) :\n\t\t  # otherwise use all parent ids\n\t\t  (keys %{$store});\n    # add the term as a parent too if one is supplied\n    push(@parent_ids,$term->identifier) if $term;\n    \n    foreach my $parent_id (@parent_ids) {\n\t\t my $parent_entry = $store->{$parent_id};\n\n\t\t # if a term is supplied, add a relationship for the parent to the term\n\t\t # except if the parent is the term itself (we added that one before)\n\t\t if($term && ($parent_id ne $term->identifier())) {\n\t\t\t my @parent_terms = $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t push(@rels,\n\t\t\t\t\t\t$relfact->create_object(-object_term    => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term   => $term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term =>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t$parent_entry->{$term->identifier},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology => $term->ontology())\n\t\t\t\t\t  );\n\t\t\t }\n\t\t \n\t\t } else {\n\t\t\t # otherwise, i.e., no term supplied, or the parent equals the\n\t\t\t # supplied term\n\t\t\t my @parent_terms = $term ?\n\t\t\t\t($term) : $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $child_id (keys %$parent_entry) {\n\t\t\t\t my $rel_info = $parent_entry->{$child_id};\n\t\t\t\t my ($subj_term) = $self->get_term_by_identifier($child_id);\n\n\t\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t\t push(@rels,\n\t\t\t\t\t\t\t$relfact->create_object(-object_term  => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term => $subj_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term => $rel_info,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology =>$parent_term->ontology\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t  )\n\t\t\t\t\t\t  );\n\t\t\t\t }\n\t\t\t }\n\t\t }\n    }\n\n    return @rels;\n}\n\n=head2 get_all_relationships\n\n Title   : get_all_relationships\n Usage   : get_all_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_all_relationships{\n    return shift->get_relationships();\n}\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : get_predicate_terms(): TermI\n Function: Retrives all relationship types stored in the engine\n Example :\n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    :\n\n\nsub get_predicate_terms{\n  my ($self) = @_;\n\n  return values %{$self->_relationship_type_store};\n}\n\n=head2 _is_rel_type\n\n Title   : _is_rel_type\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _is_rel_type{\n  my ($self, $term, @rel_types) = @_;\n\n  foreach my $rel_type (@rel_types) {\n\t  if($rel_type->identifier || $term->identifier) {\n\t\t  return 1 if $rel_type->identifier eq $term->identifier;\n\t  } else {\n\t\t  return 1 if $rel_type->name eq $term->name;\n\t  }\n  }\n\n  return 0;\n}\n\n=head2 _typed_traversal\n\n Title   : _typed_traversal\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\nsub _typed_traversal{\n\tmy ($self, $rel_store, $level, $term_id, @rel_types) = @_;\n\treturn if !defined($rel_store->{$term_id});\n\tmy %parent_entry = %{$rel_store->{$term_id}};\n\tmy @children = keys %parent_entry;\n\n\tmy @ans;\n\n\tif (@rel_types > 0) {\n\t\t@ans = ();\n\n\t\tforeach my $child_id (@children) {\n\t\t\tpush @ans, $child_id\n\t\t\t  if $self->_is_rel_type( $rel_store->{$term_id}->{$child_id},\n\t\t\t\t\t\t\t\t\t\t\t  @rel_types);\n\t\t}\n\t}\n\telse {\n\t\t@ans = @children;\n\t}\n\tif ($level < 1) {\n\t\tmy @ans1 = ();\n\n\t\tforeach my $child_id (@ans) {\n\t\t\tpush @ans1, $self->_typed_traversal($rel_store,\n\t\t\t\t\t\t\t\t$level - 1, $child_id, @rel_types)\n\t\t\t  if defined $rel_store->{$child_id};\n\t\t}\n\t\tpush @ans, @ans1;\n\t}\n\n  return @ans;\n}\n\n=head2 get_child_terms\n\n Title   : get_child_terms\n Usage   : get_child_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all child terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_child_terms is a special\n           case of get_descendant_terms, limiting the search to the\n           direct descendants.\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_child_terms{\n\tmy ($self, $term, @relationship_types) = @_;\n\n\t$self->throw(\"must provide TermI compliant object\") \n\t  unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n\treturn $self->_filter_unmarked(\n\t\t\t\t\t\t\t\t\t\t\t $self->get_term_by_identifier(\n\t\t\t\t\t\t$self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t   1,\n\t\t\t\t\t   $term->identifier,\n\t\t\t\t\t   @relationship_types) ) );\n}\n\n=head2 get_descendant_terms\n\n Title   : get_descendant_terms\n Usage   : get_descendant_terms(TermI term, TermI rel_types): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all descendant terms of a given term, that\n           satisfy a relationship among those that are specified in\n           the second argument or undef otherwise. Uses\n           _typed_traversal to find all descendants.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_descendant_terms{\n  my ($self, $term, @relationship_types) = @_;\n\n  $self->throw(\"must provide TermI compliant object\") \n      unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n  return $self->_filter_unmarked(\n\t     $self->_filter_repeated(\n\t         $self->get_term_by_identifier(\n\t\t     $self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t     0,\n\t\t\t\t\t     $term->identifier,\n\t\t\t\t\t     @relationship_types) ) ) );\n}\n\n=head2 get_parent_terms\n\n Title   : get_parent_terms\n Usage   : get_parent_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all parent terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_parent_terms is a special\n           case of get_ancestor_terms, limiting the search to the\n           direct ancestors.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of relationship type terms.","parameters":[{"label":"$self"},{"label":"$term"},{"label":"@relationship_types"}]}},{"range":{"start":{"line":725,"character":0},"end":{"line":736,"character":9999}},"kind":12,"line":725,"signature":{"parameters":[{"label":"$self"},{"label":"$term"},{"label":"@relationship_types"}],"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _relationship_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_store'}) {\n\t\t  $self->throw(\"_relationship_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_store'};\n}\n\n=head2 _inverted_relationship_store\n\n Title   : _inverted_relationship_store\n Usage   :\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _inverted_relationship_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\tif ( defined $self->{'_inverted_relationship_store'}) {\n\t\t\t$self->throw(\"_inverted_relationship_store already defined\\n\");\n\t\t}\n\t\telse {\n\t\t\t$self->{'_inverted_relationship_store'} = $value;\n\t\t}\n\t}\n\n  return $self->{'_inverted_relationship_store'};\n}\n\n=head2 _relationship_type_store\n\n Title   : _relationship_type_store\n Usage   : $obj->_relationship_type_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    : reference to an array of Bio::Ontology::RelationshipType objects\n\n\nsub _relationship_type_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_type_store'}) {\n\t\t  $self->throw(\"_relationship_type_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_type_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_type_store'};\n}\n\n=head2 _add_relationship_simple\n\n Title   : _add_relationship_simple\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _add_relationship_simple{\n   my ($self, $store, $rel, $inverted) = @_;\n   my $parent_id;\n   my $child_id;\n\n   if ($inverted) {\n\t\t$parent_id = $rel->subject_term->identifier;\n\t\t$child_id = $rel->object_term->identifier;\n   }\n   else {\n\t\t$parent_id = $rel->object_term->identifier;\n\t\t$child_id = $rel->subject_term->identifier;\n   }\n   if(defined $store->{$parent_id} && (defined $store->{$parent_id}->{$child_id}) &&\n      ($store->{$parent_id}->{$child_id}->name != $rel->predicate_term->name)){\n\t\t$self->throw(\"relationship \".Dumper($rel->predicate_term).\n\t\t\t\t\t\t \" between \".$parent_id.\" and \".$child_id.\n\t\t\t\t\t\t \" already defined as \".\n\t\t\t\t\t\t Dumper($store->{$parent_id}->{$child_id}).\"\\n\");\n   }\n   else {\n\t\t$store->{$parent_id}->{$child_id} = $rel->predicate_term;\n   }\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : add_relationship(RelationshipI relationship): RelationshipI\n Function: Adds a relationship object to the ontology engine.\n Example :\n Returns : Its argument.\n Args    : A RelationshipI object.\n\n\nsub add_relationship{\n   my ($self, $rel) = @_;\n\n   $self->_add_relationship_simple($self->_relationship_store,\n\t\t\t\t   $rel, 0);\n   $self->_add_relationship_simple($self->_inverted_relationship_store,\n\t\t\t\t   $rel, 1);\n   $self->_relationship_type_store->{\n       $self->_unique_termid($rel->predicate_term)} = $rel->predicate_term;\n\n   return $rel;\n}\n\n=head2 get_relationships\n\n Title   : get_relationships\n Usage   : get_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_relationships{\n    my $self = shift;\n    my $term = shift;\n    my @rels;\n    my $store = $self->_relationship_store;\n    my $relfact = $self->relationship_factory(); \n\n    my @parent_ids = $term ?\n\t\t# if a term is supplied then only get the term's parents\n\t\t(map { $_->identifier(); } $self->get_parent_terms($term)) :\n\t\t  # otherwise use all parent ids\n\t\t  (keys %{$store});\n    # add the term as a parent too if one is supplied\n    push(@parent_ids,$term->identifier) if $term;\n    \n    foreach my $parent_id (@parent_ids) {\n\t\t my $parent_entry = $store->{$parent_id};\n\n\t\t # if a term is supplied, add a relationship for the parent to the term\n\t\t # except if the parent is the term itself (we added that one before)\n\t\t if($term && ($parent_id ne $term->identifier())) {\n\t\t\t my @parent_terms = $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t push(@rels,\n\t\t\t\t\t\t$relfact->create_object(-object_term    => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term   => $term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term =>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t$parent_entry->{$term->identifier},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology => $term->ontology())\n\t\t\t\t\t  );\n\t\t\t }\n\t\t \n\t\t } else {\n\t\t\t # otherwise, i.e., no term supplied, or the parent equals the\n\t\t\t # supplied term\n\t\t\t my @parent_terms = $term ?\n\t\t\t\t($term) : $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $child_id (keys %$parent_entry) {\n\t\t\t\t my $rel_info = $parent_entry->{$child_id};\n\t\t\t\t my ($subj_term) = $self->get_term_by_identifier($child_id);\n\n\t\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t\t push(@rels,\n\t\t\t\t\t\t\t$relfact->create_object(-object_term  => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term => $subj_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term => $rel_info,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology =>$parent_term->ontology\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t  )\n\t\t\t\t\t\t  );\n\t\t\t\t }\n\t\t\t }\n\t\t }\n    }\n\n    return @rels;\n}\n\n=head2 get_all_relationships\n\n Title   : get_all_relationships\n Usage   : get_all_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_all_relationships{\n    return shift->get_relationships();\n}\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : get_predicate_terms(): TermI\n Function: Retrives all relationship types stored in the engine\n Example :\n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    :\n\n\nsub get_predicate_terms{\n  my ($self) = @_;\n\n  return values %{$self->_relationship_type_store};\n}\n\n=head2 _is_rel_type\n\n Title   : _is_rel_type\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _is_rel_type{\n  my ($self, $term, @rel_types) = @_;\n\n  foreach my $rel_type (@rel_types) {\n\t  if($rel_type->identifier || $term->identifier) {\n\t\t  return 1 if $rel_type->identifier eq $term->identifier;\n\t  } else {\n\t\t  return 1 if $rel_type->name eq $term->name;\n\t  }\n  }\n\n  return 0;\n}\n\n=head2 _typed_traversal\n\n Title   : _typed_traversal\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\nsub _typed_traversal{\n\tmy ($self, $rel_store, $level, $term_id, @rel_types) = @_;\n\treturn if !defined($rel_store->{$term_id});\n\tmy %parent_entry = %{$rel_store->{$term_id}};\n\tmy @children = keys %parent_entry;\n\n\tmy @ans;\n\n\tif (@rel_types > 0) {\n\t\t@ans = ();\n\n\t\tforeach my $child_id (@children) {\n\t\t\tpush @ans, $child_id\n\t\t\t  if $self->_is_rel_type( $rel_store->{$term_id}->{$child_id},\n\t\t\t\t\t\t\t\t\t\t\t  @rel_types);\n\t\t}\n\t}\n\telse {\n\t\t@ans = @children;\n\t}\n\tif ($level < 1) {\n\t\tmy @ans1 = ();\n\n\t\tforeach my $child_id (@ans) {\n\t\t\tpush @ans1, $self->_typed_traversal($rel_store,\n\t\t\t\t\t\t\t\t$level - 1, $child_id, @rel_types)\n\t\t\t  if defined $rel_store->{$child_id};\n\t\t}\n\t\tpush @ans, @ans1;\n\t}\n\n  return @ans;\n}\n\n=head2 get_child_terms\n\n Title   : get_child_terms\n Usage   : get_child_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all child terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_child_terms is a special\n           case of get_descendant_terms, limiting the search to the\n           direct descendants.\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_child_terms{\n\tmy ($self, $term, @relationship_types) = @_;\n\n\t$self->throw(\"must provide TermI compliant object\") \n\t  unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n\treturn $self->_filter_unmarked(\n\t\t\t\t\t\t\t\t\t\t\t $self->get_term_by_identifier(\n\t\t\t\t\t\t$self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t   1,\n\t\t\t\t\t   $term->identifier,\n\t\t\t\t\t   @relationship_types) ) );\n}\n\n=head2 get_descendant_terms\n\n Title   : get_descendant_terms\n Usage   : get_descendant_terms(TermI term, TermI rel_types): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all descendant terms of a given term, that\n           satisfy a relationship among those that are specified in\n           the second argument or undef otherwise. Uses\n           _typed_traversal to find all descendants.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_descendant_terms{\n  my ($self, $term, @relationship_types) = @_;\n\n  $self->throw(\"must provide TermI compliant object\") \n      unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n  return $self->_filter_unmarked(\n\t     $self->_filter_repeated(\n\t         $self->get_term_by_identifier(\n\t\t     $self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t     0,\n\t\t\t\t\t     $term->identifier,\n\t\t\t\t\t     @relationship_types) ) ) );\n}\n\n=head2 get_parent_terms\n\n Title   : get_parent_terms\n Usage   : get_parent_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all parent terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_parent_terms is a special\n           case of get_ancestor_terms, limiting the search to the\n           direct ancestors.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of relationship type terms.\n\n\nsub get_parent_terms{\n  my ($self, $term, @relationship_types) = @_;\n  $self->throw(\"term must be a valid object, not undef\") unless defined $term;\n\n  return $self->_filter_unmarked(\n\t    $self->get_term_by_identifier(\n\t\t$self->_typed_traversal($self->_inverted_relationship_store,\n\t\t\t\t\t1,\n\t\t\t\t\t$term->identifier,\n\t\t\t\t\t@relationship_types) ) );\n}\n\n=head2 get_ancestor_terms\n\n Title   : get_ancestor_terms\n Usage   : get_ancestor_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all ancestor terms of a given term, that satisfy\n           a relationship among those that are specified in the second\n           argument or undef otherwise. Uses _typed_traversal to find\n           all ancestors.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list\n           of relationship type terms.","label":"get_ancestor_terms($self,$term,@relationship_types)"},"containerName":"main::","name":"get_ancestor_terms","children":[{"name":"$self","localvar":"my","containerName":"get_ancestor_terms","kind":13,"line":726,"definition":"my"},{"line":726,"name":"$term","kind":13,"containerName":"get_ancestor_terms"},{"name":"@relationship_types","containerName":"get_ancestor_terms","kind":13,"line":726},{"name":"$self","kind":13,"containerName":"get_ancestor_terms","line":727},{"line":727,"containerName":"get_ancestor_terms","kind":12,"name":"throw"},{"name":"$term","containerName":"get_ancestor_terms","kind":13,"line":727},{"line":729,"containerName":"get_ancestor_terms","kind":13,"name":"$self"},{"line":729,"containerName":"get_ancestor_terms","kind":12,"name":"_filter_unmarked"},{"name":"$self","containerName":"get_ancestor_terms","kind":13,"line":730},{"line":730,"name":"_filter_repeated","kind":12,"containerName":"get_ancestor_terms"},{"name":"$self","kind":13,"containerName":"get_ancestor_terms","line":731},{"kind":12,"containerName":"get_ancestor_terms","name":"get_term_by_identifier","line":731},{"line":732,"kind":13,"containerName":"get_ancestor_terms","name":"$self"},{"line":732,"name":"_typed_traversal","kind":12,"containerName":"get_ancestor_terms"},{"line":732,"name":"$self","containerName":"get_ancestor_terms","kind":13},{"line":732,"name":"_inverted_relationship_store","containerName":"get_ancestor_terms","kind":12},{"kind":13,"containerName":"get_ancestor_terms","name":"$term","line":734},{"name":"identifier","kind":12,"containerName":"get_ancestor_terms","line":734},{"line":735,"name":"@relationship_types","containerName":"get_ancestor_terms","kind":13}],"detail":"($self,$term,@relationship_types)","definition":"sub"},{"containerName":"main::","name":"get_leaf_terms","children":[{"definition":"my","line":750,"containerName":"get_leaf_terms","localvar":"my","kind":13,"name":"$self"},{"name":"@leaf_terms","localvar":"my","containerName":"get_leaf_terms","kind":13,"line":751,"definition":"my"},{"definition":"my","line":753,"localvar":"my","containerName":"get_leaf_terms","kind":13,"name":"$term"},{"name":"$self","containerName":"get_leaf_terms","kind":13,"line":753},{"kind":12,"containerName":"get_leaf_terms","name":"_term_store","line":753}],"detail":"($self)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":749},"end":{"line":753,"character":9999}},"line":749,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _relationship_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_store'}) {\n\t\t  $self->throw(\"_relationship_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_store'};\n}\n\n=head2 _inverted_relationship_store\n\n Title   : _inverted_relationship_store\n Usage   :\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _inverted_relationship_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\tif ( defined $self->{'_inverted_relationship_store'}) {\n\t\t\t$self->throw(\"_inverted_relationship_store already defined\\n\");\n\t\t}\n\t\telse {\n\t\t\t$self->{'_inverted_relationship_store'} = $value;\n\t\t}\n\t}\n\n  return $self->{'_inverted_relationship_store'};\n}\n\n=head2 _relationship_type_store\n\n Title   : _relationship_type_store\n Usage   : $obj->_relationship_type_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    : reference to an array of Bio::Ontology::RelationshipType objects\n\n\nsub _relationship_type_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_type_store'}) {\n\t\t  $self->throw(\"_relationship_type_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_type_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_type_store'};\n}\n\n=head2 _add_relationship_simple\n\n Title   : _add_relationship_simple\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _add_relationship_simple{\n   my ($self, $store, $rel, $inverted) = @_;\n   my $parent_id;\n   my $child_id;\n\n   if ($inverted) {\n\t\t$parent_id = $rel->subject_term->identifier;\n\t\t$child_id = $rel->object_term->identifier;\n   }\n   else {\n\t\t$parent_id = $rel->object_term->identifier;\n\t\t$child_id = $rel->subject_term->identifier;\n   }\n   if(defined $store->{$parent_id} && (defined $store->{$parent_id}->{$child_id}) &&\n      ($store->{$parent_id}->{$child_id}->name != $rel->predicate_term->name)){\n\t\t$self->throw(\"relationship \".Dumper($rel->predicate_term).\n\t\t\t\t\t\t \" between \".$parent_id.\" and \".$child_id.\n\t\t\t\t\t\t \" already defined as \".\n\t\t\t\t\t\t Dumper($store->{$parent_id}->{$child_id}).\"\\n\");\n   }\n   else {\n\t\t$store->{$parent_id}->{$child_id} = $rel->predicate_term;\n   }\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : add_relationship(RelationshipI relationship): RelationshipI\n Function: Adds a relationship object to the ontology engine.\n Example :\n Returns : Its argument.\n Args    : A RelationshipI object.\n\n\nsub add_relationship{\n   my ($self, $rel) = @_;\n\n   $self->_add_relationship_simple($self->_relationship_store,\n\t\t\t\t   $rel, 0);\n   $self->_add_relationship_simple($self->_inverted_relationship_store,\n\t\t\t\t   $rel, 1);\n   $self->_relationship_type_store->{\n       $self->_unique_termid($rel->predicate_term)} = $rel->predicate_term;\n\n   return $rel;\n}\n\n=head2 get_relationships\n\n Title   : get_relationships\n Usage   : get_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_relationships{\n    my $self = shift;\n    my $term = shift;\n    my @rels;\n    my $store = $self->_relationship_store;\n    my $relfact = $self->relationship_factory(); \n\n    my @parent_ids = $term ?\n\t\t# if a term is supplied then only get the term's parents\n\t\t(map { $_->identifier(); } $self->get_parent_terms($term)) :\n\t\t  # otherwise use all parent ids\n\t\t  (keys %{$store});\n    # add the term as a parent too if one is supplied\n    push(@parent_ids,$term->identifier) if $term;\n    \n    foreach my $parent_id (@parent_ids) {\n\t\t my $parent_entry = $store->{$parent_id};\n\n\t\t # if a term is supplied, add a relationship for the parent to the term\n\t\t # except if the parent is the term itself (we added that one before)\n\t\t if($term && ($parent_id ne $term->identifier())) {\n\t\t\t my @parent_terms = $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t push(@rels,\n\t\t\t\t\t\t$relfact->create_object(-object_term    => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term   => $term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term =>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t$parent_entry->{$term->identifier},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology => $term->ontology())\n\t\t\t\t\t  );\n\t\t\t }\n\t\t \n\t\t } else {\n\t\t\t # otherwise, i.e., no term supplied, or the parent equals the\n\t\t\t # supplied term\n\t\t\t my @parent_terms = $term ?\n\t\t\t\t($term) : $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $child_id (keys %$parent_entry) {\n\t\t\t\t my $rel_info = $parent_entry->{$child_id};\n\t\t\t\t my ($subj_term) = $self->get_term_by_identifier($child_id);\n\n\t\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t\t push(@rels,\n\t\t\t\t\t\t\t$relfact->create_object(-object_term  => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term => $subj_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term => $rel_info,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology =>$parent_term->ontology\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t  )\n\t\t\t\t\t\t  );\n\t\t\t\t }\n\t\t\t }\n\t\t }\n    }\n\n    return @rels;\n}\n\n=head2 get_all_relationships\n\n Title   : get_all_relationships\n Usage   : get_all_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_all_relationships{\n    return shift->get_relationships();\n}\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : get_predicate_terms(): TermI\n Function: Retrives all relationship types stored in the engine\n Example :\n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    :\n\n\nsub get_predicate_terms{\n  my ($self) = @_;\n\n  return values %{$self->_relationship_type_store};\n}\n\n=head2 _is_rel_type\n\n Title   : _is_rel_type\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _is_rel_type{\n  my ($self, $term, @rel_types) = @_;\n\n  foreach my $rel_type (@rel_types) {\n\t  if($rel_type->identifier || $term->identifier) {\n\t\t  return 1 if $rel_type->identifier eq $term->identifier;\n\t  } else {\n\t\t  return 1 if $rel_type->name eq $term->name;\n\t  }\n  }\n\n  return 0;\n}\n\n=head2 _typed_traversal\n\n Title   : _typed_traversal\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\nsub _typed_traversal{\n\tmy ($self, $rel_store, $level, $term_id, @rel_types) = @_;\n\treturn if !defined($rel_store->{$term_id});\n\tmy %parent_entry = %{$rel_store->{$term_id}};\n\tmy @children = keys %parent_entry;\n\n\tmy @ans;\n\n\tif (@rel_types > 0) {\n\t\t@ans = ();\n\n\t\tforeach my $child_id (@children) {\n\t\t\tpush @ans, $child_id\n\t\t\t  if $self->_is_rel_type( $rel_store->{$term_id}->{$child_id},\n\t\t\t\t\t\t\t\t\t\t\t  @rel_types);\n\t\t}\n\t}\n\telse {\n\t\t@ans = @children;\n\t}\n\tif ($level < 1) {\n\t\tmy @ans1 = ();\n\n\t\tforeach my $child_id (@ans) {\n\t\t\tpush @ans1, $self->_typed_traversal($rel_store,\n\t\t\t\t\t\t\t\t$level - 1, $child_id, @rel_types)\n\t\t\t  if defined $rel_store->{$child_id};\n\t\t}\n\t\tpush @ans, @ans1;\n\t}\n\n  return @ans;\n}\n\n=head2 get_child_terms\n\n Title   : get_child_terms\n Usage   : get_child_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all child terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_child_terms is a special\n           case of get_descendant_terms, limiting the search to the\n           direct descendants.\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_child_terms{\n\tmy ($self, $term, @relationship_types) = @_;\n\n\t$self->throw(\"must provide TermI compliant object\") \n\t  unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n\treturn $self->_filter_unmarked(\n\t\t\t\t\t\t\t\t\t\t\t $self->get_term_by_identifier(\n\t\t\t\t\t\t$self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t   1,\n\t\t\t\t\t   $term->identifier,\n\t\t\t\t\t   @relationship_types) ) );\n}\n\n=head2 get_descendant_terms\n\n Title   : get_descendant_terms\n Usage   : get_descendant_terms(TermI term, TermI rel_types): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all descendant terms of a given term, that\n           satisfy a relationship among those that are specified in\n           the second argument or undef otherwise. Uses\n           _typed_traversal to find all descendants.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_descendant_terms{\n  my ($self, $term, @relationship_types) = @_;\n\n  $self->throw(\"must provide TermI compliant object\") \n      unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n  return $self->_filter_unmarked(\n\t     $self->_filter_repeated(\n\t         $self->get_term_by_identifier(\n\t\t     $self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t     0,\n\t\t\t\t\t     $term->identifier,\n\t\t\t\t\t     @relationship_types) ) ) );\n}\n\n=head2 get_parent_terms\n\n Title   : get_parent_terms\n Usage   : get_parent_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all parent terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_parent_terms is a special\n           case of get_ancestor_terms, limiting the search to the\n           direct ancestors.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of relationship type terms.\n\n\nsub get_parent_terms{\n  my ($self, $term, @relationship_types) = @_;\n  $self->throw(\"term must be a valid object, not undef\") unless defined $term;\n\n  return $self->_filter_unmarked(\n\t    $self->get_term_by_identifier(\n\t\t$self->_typed_traversal($self->_inverted_relationship_store,\n\t\t\t\t\t1,\n\t\t\t\t\t$term->identifier,\n\t\t\t\t\t@relationship_types) ) );\n}\n\n=head2 get_ancestor_terms\n\n Title   : get_ancestor_terms\n Usage   : get_ancestor_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all ancestor terms of a given term, that satisfy\n           a relationship among those that are specified in the second\n           argument or undef otherwise. Uses _typed_traversal to find\n           all ancestors.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list\n           of relationship type terms.\n\n\nsub get_ancestor_terms{\n  my ($self, $term, @relationship_types) = @_;\n  $self->throw(\"term must be a valid object, not undef\") unless defined $term;\n\n  return $self->_filter_unmarked(\n\t    $self->_filter_repeated(\n               $self->get_term_by_identifier(\n                  $self->_typed_traversal($self->_inverted_relationship_store,\n\t\t\t\t\t  0,\n\t\t\t\t\t  $term->identifier,\n\t\t\t\t\t  @relationship_types) ) ) );\n}\n\n=head2 get_leaf_terms\n\n Title   : get_leaf_terms\n Usage   : get_leaf_terms(): TermI\n Function: Retrieves all leaf terms from the ontology. Leaf term is a term w/o descendants.\n Example : @leaf_terms = $obj->get_leaf_terms()\n Returns : Array of TermI objects.\n Args    :","label":"get_leaf_terms($self)"}},{"name":"@leaf_terms","kind":13,"containerName":null,"line":754},{"containerName":null,"kind":13,"name":"$term","line":755},{"name":"$self","kind":13,"containerName":null,"line":755},{"kind":12,"containerName":"main::","name":"_relationship_store","line":755},{"line":755,"containerName":null,"kind":13,"name":"$term"},{"name":"identifier","kind":12,"containerName":"main::","line":755},{"line":756,"name":"$self","kind":13,"containerName":null},{"kind":12,"containerName":"main::","name":"_instantiated_terms_store","line":756},{"kind":13,"containerName":null,"name":"$term","line":756},{"kind":12,"containerName":"main::","name":"identifier","line":756},{"kind":13,"containerName":null,"name":"@leaf_terms","line":759},{"name":"get_root_terms","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"get_root_terms","localvar":"my","kind":13,"line":774},{"containerName":"get_root_terms","localvar":"my","kind":13,"name":"@root_terms","line":775,"definition":"my"},{"definition":"my","line":777,"localvar":"my","containerName":"get_root_terms","kind":13,"name":"$term"},{"line":777,"kind":13,"containerName":"get_root_terms","name":"$self"},{"line":777,"kind":12,"containerName":"get_root_terms","name":"_term_store"}],"detail":"($self)","definition":"sub","range":{"end":{"character":9999,"line":777},"start":{"character":0,"line":773}},"kind":12,"line":773,"signature":{"label":"get_root_terms($self)","documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _relationship_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_store'}) {\n\t\t  $self->throw(\"_relationship_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_store'};\n}\n\n=head2 _inverted_relationship_store\n\n Title   : _inverted_relationship_store\n Usage   :\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _inverted_relationship_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\tif ( defined $self->{'_inverted_relationship_store'}) {\n\t\t\t$self->throw(\"_inverted_relationship_store already defined\\n\");\n\t\t}\n\t\telse {\n\t\t\t$self->{'_inverted_relationship_store'} = $value;\n\t\t}\n\t}\n\n  return $self->{'_inverted_relationship_store'};\n}\n\n=head2 _relationship_type_store\n\n Title   : _relationship_type_store\n Usage   : $obj->_relationship_type_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    : reference to an array of Bio::Ontology::RelationshipType objects\n\n\nsub _relationship_type_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_type_store'}) {\n\t\t  $self->throw(\"_relationship_type_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_type_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_type_store'};\n}\n\n=head2 _add_relationship_simple\n\n Title   : _add_relationship_simple\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _add_relationship_simple{\n   my ($self, $store, $rel, $inverted) = @_;\n   my $parent_id;\n   my $child_id;\n\n   if ($inverted) {\n\t\t$parent_id = $rel->subject_term->identifier;\n\t\t$child_id = $rel->object_term->identifier;\n   }\n   else {\n\t\t$parent_id = $rel->object_term->identifier;\n\t\t$child_id = $rel->subject_term->identifier;\n   }\n   if(defined $store->{$parent_id} && (defined $store->{$parent_id}->{$child_id}) &&\n      ($store->{$parent_id}->{$child_id}->name != $rel->predicate_term->name)){\n\t\t$self->throw(\"relationship \".Dumper($rel->predicate_term).\n\t\t\t\t\t\t \" between \".$parent_id.\" and \".$child_id.\n\t\t\t\t\t\t \" already defined as \".\n\t\t\t\t\t\t Dumper($store->{$parent_id}->{$child_id}).\"\\n\");\n   }\n   else {\n\t\t$store->{$parent_id}->{$child_id} = $rel->predicate_term;\n   }\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : add_relationship(RelationshipI relationship): RelationshipI\n Function: Adds a relationship object to the ontology engine.\n Example :\n Returns : Its argument.\n Args    : A RelationshipI object.\n\n\nsub add_relationship{\n   my ($self, $rel) = @_;\n\n   $self->_add_relationship_simple($self->_relationship_store,\n\t\t\t\t   $rel, 0);\n   $self->_add_relationship_simple($self->_inverted_relationship_store,\n\t\t\t\t   $rel, 1);\n   $self->_relationship_type_store->{\n       $self->_unique_termid($rel->predicate_term)} = $rel->predicate_term;\n\n   return $rel;\n}\n\n=head2 get_relationships\n\n Title   : get_relationships\n Usage   : get_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_relationships{\n    my $self = shift;\n    my $term = shift;\n    my @rels;\n    my $store = $self->_relationship_store;\n    my $relfact = $self->relationship_factory(); \n\n    my @parent_ids = $term ?\n\t\t# if a term is supplied then only get the term's parents\n\t\t(map { $_->identifier(); } $self->get_parent_terms($term)) :\n\t\t  # otherwise use all parent ids\n\t\t  (keys %{$store});\n    # add the term as a parent too if one is supplied\n    push(@parent_ids,$term->identifier) if $term;\n    \n    foreach my $parent_id (@parent_ids) {\n\t\t my $parent_entry = $store->{$parent_id};\n\n\t\t # if a term is supplied, add a relationship for the parent to the term\n\t\t # except if the parent is the term itself (we added that one before)\n\t\t if($term && ($parent_id ne $term->identifier())) {\n\t\t\t my @parent_terms = $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t push(@rels,\n\t\t\t\t\t\t$relfact->create_object(-object_term    => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term   => $term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term =>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t$parent_entry->{$term->identifier},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology => $term->ontology())\n\t\t\t\t\t  );\n\t\t\t }\n\t\t \n\t\t } else {\n\t\t\t # otherwise, i.e., no term supplied, or the parent equals the\n\t\t\t # supplied term\n\t\t\t my @parent_terms = $term ?\n\t\t\t\t($term) : $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $child_id (keys %$parent_entry) {\n\t\t\t\t my $rel_info = $parent_entry->{$child_id};\n\t\t\t\t my ($subj_term) = $self->get_term_by_identifier($child_id);\n\n\t\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t\t push(@rels,\n\t\t\t\t\t\t\t$relfact->create_object(-object_term  => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term => $subj_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term => $rel_info,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology =>$parent_term->ontology\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t  )\n\t\t\t\t\t\t  );\n\t\t\t\t }\n\t\t\t }\n\t\t }\n    }\n\n    return @rels;\n}\n\n=head2 get_all_relationships\n\n Title   : get_all_relationships\n Usage   : get_all_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_all_relationships{\n    return shift->get_relationships();\n}\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : get_predicate_terms(): TermI\n Function: Retrives all relationship types stored in the engine\n Example :\n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    :\n\n\nsub get_predicate_terms{\n  my ($self) = @_;\n\n  return values %{$self->_relationship_type_store};\n}\n\n=head2 _is_rel_type\n\n Title   : _is_rel_type\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _is_rel_type{\n  my ($self, $term, @rel_types) = @_;\n\n  foreach my $rel_type (@rel_types) {\n\t  if($rel_type->identifier || $term->identifier) {\n\t\t  return 1 if $rel_type->identifier eq $term->identifier;\n\t  } else {\n\t\t  return 1 if $rel_type->name eq $term->name;\n\t  }\n  }\n\n  return 0;\n}\n\n=head2 _typed_traversal\n\n Title   : _typed_traversal\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\nsub _typed_traversal{\n\tmy ($self, $rel_store, $level, $term_id, @rel_types) = @_;\n\treturn if !defined($rel_store->{$term_id});\n\tmy %parent_entry = %{$rel_store->{$term_id}};\n\tmy @children = keys %parent_entry;\n\n\tmy @ans;\n\n\tif (@rel_types > 0) {\n\t\t@ans = ();\n\n\t\tforeach my $child_id (@children) {\n\t\t\tpush @ans, $child_id\n\t\t\t  if $self->_is_rel_type( $rel_store->{$term_id}->{$child_id},\n\t\t\t\t\t\t\t\t\t\t\t  @rel_types);\n\t\t}\n\t}\n\telse {\n\t\t@ans = @children;\n\t}\n\tif ($level < 1) {\n\t\tmy @ans1 = ();\n\n\t\tforeach my $child_id (@ans) {\n\t\t\tpush @ans1, $self->_typed_traversal($rel_store,\n\t\t\t\t\t\t\t\t$level - 1, $child_id, @rel_types)\n\t\t\t  if defined $rel_store->{$child_id};\n\t\t}\n\t\tpush @ans, @ans1;\n\t}\n\n  return @ans;\n}\n\n=head2 get_child_terms\n\n Title   : get_child_terms\n Usage   : get_child_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all child terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_child_terms is a special\n           case of get_descendant_terms, limiting the search to the\n           direct descendants.\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_child_terms{\n\tmy ($self, $term, @relationship_types) = @_;\n\n\t$self->throw(\"must provide TermI compliant object\") \n\t  unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n\treturn $self->_filter_unmarked(\n\t\t\t\t\t\t\t\t\t\t\t $self->get_term_by_identifier(\n\t\t\t\t\t\t$self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t   1,\n\t\t\t\t\t   $term->identifier,\n\t\t\t\t\t   @relationship_types) ) );\n}\n\n=head2 get_descendant_terms\n\n Title   : get_descendant_terms\n Usage   : get_descendant_terms(TermI term, TermI rel_types): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all descendant terms of a given term, that\n           satisfy a relationship among those that are specified in\n           the second argument or undef otherwise. Uses\n           _typed_traversal to find all descendants.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_descendant_terms{\n  my ($self, $term, @relationship_types) = @_;\n\n  $self->throw(\"must provide TermI compliant object\") \n      unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n  return $self->_filter_unmarked(\n\t     $self->_filter_repeated(\n\t         $self->get_term_by_identifier(\n\t\t     $self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t     0,\n\t\t\t\t\t     $term->identifier,\n\t\t\t\t\t     @relationship_types) ) ) );\n}\n\n=head2 get_parent_terms\n\n Title   : get_parent_terms\n Usage   : get_parent_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all parent terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_parent_terms is a special\n           case of get_ancestor_terms, limiting the search to the\n           direct ancestors.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of relationship type terms.\n\n\nsub get_parent_terms{\n  my ($self, $term, @relationship_types) = @_;\n  $self->throw(\"term must be a valid object, not undef\") unless defined $term;\n\n  return $self->_filter_unmarked(\n\t    $self->get_term_by_identifier(\n\t\t$self->_typed_traversal($self->_inverted_relationship_store,\n\t\t\t\t\t1,\n\t\t\t\t\t$term->identifier,\n\t\t\t\t\t@relationship_types) ) );\n}\n\n=head2 get_ancestor_terms\n\n Title   : get_ancestor_terms\n Usage   : get_ancestor_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all ancestor terms of a given term, that satisfy\n           a relationship among those that are specified in the second\n           argument or undef otherwise. Uses _typed_traversal to find\n           all ancestors.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list\n           of relationship type terms.\n\n\nsub get_ancestor_terms{\n  my ($self, $term, @relationship_types) = @_;\n  $self->throw(\"term must be a valid object, not undef\") unless defined $term;\n\n  return $self->_filter_unmarked(\n\t    $self->_filter_repeated(\n               $self->get_term_by_identifier(\n                  $self->_typed_traversal($self->_inverted_relationship_store,\n\t\t\t\t\t  0,\n\t\t\t\t\t  $term->identifier,\n\t\t\t\t\t  @relationship_types) ) ) );\n}\n\n=head2 get_leaf_terms\n\n Title   : get_leaf_terms\n Usage   : get_leaf_terms(): TermI\n Function: Retrieves all leaf terms from the ontology. Leaf term is a term w/o descendants.\n Example : @leaf_terms = $obj->get_leaf_terms()\n Returns : Array of TermI objects.\n Args    :\n\n\nsub get_leaf_terms{\n  my ($self) = @_;\n  my @leaf_terms;\n\n  foreach my $term (values %{$self->_term_store}) {\n\t  push @leaf_terms, $term\n\t\t if !defined $self->_relationship_store->{$term->identifier} &&\n\t\t\tdefined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @leaf_terms;\n}\n\n=head2 get_root_terms\n\n Title   : get_root_terms\n Usage   : get_root_terms(): TermI\n Function: Retrieves all root terms from the ontology. Root term is a term w/o descendants.\n Example : @root_terms = $obj->get_root_terms()\n Returns : Array of TermI objects.\n Args    :","parameters":[{"label":"$self"}]}},{"line":778,"name":"@root_terms","containerName":null,"kind":13},{"line":779,"containerName":null,"kind":13,"name":"$term"},{"line":779,"name":"$self","kind":13,"containerName":null},{"name":"_inverted_relationship_store","kind":12,"containerName":"main::","line":779},{"line":779,"kind":13,"containerName":null,"name":"$term"},{"containerName":"main::","kind":12,"name":"identifier","line":779},{"kind":13,"containerName":null,"name":"$self","line":780},{"line":780,"kind":12,"containerName":"main::","name":"_instantiated_terms_store"},{"containerName":null,"kind":13,"name":"$term","line":780},{"line":780,"name":"identifier","kind":12,"containerName":"main::"},{"line":783,"name":"@root_terms","containerName":null,"kind":13},{"detail":"($self,@args)","definition":"sub","containerName":"main::","name":"_filter_repeated","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"_filter_repeated","line":798},{"line":798,"name":"@args","containerName":"_filter_repeated","kind":13},{"line":799,"localvar":"my","kind":13,"containerName":"_filter_repeated","name":"%h","definition":"my"},{"containerName":"_filter_repeated","localvar":"my","kind":13,"name":"$element","line":801,"definition":"my"},{"containerName":"_filter_repeated","kind":13,"name":"@args","line":801},{"name":"$h","kind":13,"containerName":"_filter_repeated","line":802},{"line":802,"name":"$element","containerName":"_filter_repeated","kind":13},{"containerName":"_filter_repeated","kind":12,"name":"identifier","line":802},{"kind":13,"containerName":"_filter_repeated","name":"$element","line":802},{"name":"$h","kind":13,"containerName":"_filter_repeated","line":802},{"line":802,"containerName":"_filter_repeated","kind":13,"name":"$element"},{"line":802,"containerName":"_filter_repeated","kind":12,"name":"identifier"},{"kind":13,"containerName":"_filter_repeated","name":"%h","line":805}],"signature":{"label":"_filter_repeated($self,@args)","documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _relationship_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_store'}) {\n\t\t  $self->throw(\"_relationship_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_store'};\n}\n\n=head2 _inverted_relationship_store\n\n Title   : _inverted_relationship_store\n Usage   :\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _inverted_relationship_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\tif ( defined $self->{'_inverted_relationship_store'}) {\n\t\t\t$self->throw(\"_inverted_relationship_store already defined\\n\");\n\t\t}\n\t\telse {\n\t\t\t$self->{'_inverted_relationship_store'} = $value;\n\t\t}\n\t}\n\n  return $self->{'_inverted_relationship_store'};\n}\n\n=head2 _relationship_type_store\n\n Title   : _relationship_type_store\n Usage   : $obj->_relationship_type_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    : reference to an array of Bio::Ontology::RelationshipType objects\n\n\nsub _relationship_type_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_type_store'}) {\n\t\t  $self->throw(\"_relationship_type_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_type_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_type_store'};\n}\n\n=head2 _add_relationship_simple\n\n Title   : _add_relationship_simple\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _add_relationship_simple{\n   my ($self, $store, $rel, $inverted) = @_;\n   my $parent_id;\n   my $child_id;\n\n   if ($inverted) {\n\t\t$parent_id = $rel->subject_term->identifier;\n\t\t$child_id = $rel->object_term->identifier;\n   }\n   else {\n\t\t$parent_id = $rel->object_term->identifier;\n\t\t$child_id = $rel->subject_term->identifier;\n   }\n   if(defined $store->{$parent_id} && (defined $store->{$parent_id}->{$child_id}) &&\n      ($store->{$parent_id}->{$child_id}->name != $rel->predicate_term->name)){\n\t\t$self->throw(\"relationship \".Dumper($rel->predicate_term).\n\t\t\t\t\t\t \" between \".$parent_id.\" and \".$child_id.\n\t\t\t\t\t\t \" already defined as \".\n\t\t\t\t\t\t Dumper($store->{$parent_id}->{$child_id}).\"\\n\");\n   }\n   else {\n\t\t$store->{$parent_id}->{$child_id} = $rel->predicate_term;\n   }\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : add_relationship(RelationshipI relationship): RelationshipI\n Function: Adds a relationship object to the ontology engine.\n Example :\n Returns : Its argument.\n Args    : A RelationshipI object.\n\n\nsub add_relationship{\n   my ($self, $rel) = @_;\n\n   $self->_add_relationship_simple($self->_relationship_store,\n\t\t\t\t   $rel, 0);\n   $self->_add_relationship_simple($self->_inverted_relationship_store,\n\t\t\t\t   $rel, 1);\n   $self->_relationship_type_store->{\n       $self->_unique_termid($rel->predicate_term)} = $rel->predicate_term;\n\n   return $rel;\n}\n\n=head2 get_relationships\n\n Title   : get_relationships\n Usage   : get_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_relationships{\n    my $self = shift;\n    my $term = shift;\n    my @rels;\n    my $store = $self->_relationship_store;\n    my $relfact = $self->relationship_factory(); \n\n    my @parent_ids = $term ?\n\t\t# if a term is supplied then only get the term's parents\n\t\t(map { $_->identifier(); } $self->get_parent_terms($term)) :\n\t\t  # otherwise use all parent ids\n\t\t  (keys %{$store});\n    # add the term as a parent too if one is supplied\n    push(@parent_ids,$term->identifier) if $term;\n    \n    foreach my $parent_id (@parent_ids) {\n\t\t my $parent_entry = $store->{$parent_id};\n\n\t\t # if a term is supplied, add a relationship for the parent to the term\n\t\t # except if the parent is the term itself (we added that one before)\n\t\t if($term && ($parent_id ne $term->identifier())) {\n\t\t\t my @parent_terms = $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t push(@rels,\n\t\t\t\t\t\t$relfact->create_object(-object_term    => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term   => $term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term =>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t$parent_entry->{$term->identifier},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology => $term->ontology())\n\t\t\t\t\t  );\n\t\t\t }\n\t\t \n\t\t } else {\n\t\t\t # otherwise, i.e., no term supplied, or the parent equals the\n\t\t\t # supplied term\n\t\t\t my @parent_terms = $term ?\n\t\t\t\t($term) : $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $child_id (keys %$parent_entry) {\n\t\t\t\t my $rel_info = $parent_entry->{$child_id};\n\t\t\t\t my ($subj_term) = $self->get_term_by_identifier($child_id);\n\n\t\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t\t push(@rels,\n\t\t\t\t\t\t\t$relfact->create_object(-object_term  => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term => $subj_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term => $rel_info,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology =>$parent_term->ontology\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t  )\n\t\t\t\t\t\t  );\n\t\t\t\t }\n\t\t\t }\n\t\t }\n    }\n\n    return @rels;\n}\n\n=head2 get_all_relationships\n\n Title   : get_all_relationships\n Usage   : get_all_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_all_relationships{\n    return shift->get_relationships();\n}\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : get_predicate_terms(): TermI\n Function: Retrives all relationship types stored in the engine\n Example :\n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    :\n\n\nsub get_predicate_terms{\n  my ($self) = @_;\n\n  return values %{$self->_relationship_type_store};\n}\n\n=head2 _is_rel_type\n\n Title   : _is_rel_type\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _is_rel_type{\n  my ($self, $term, @rel_types) = @_;\n\n  foreach my $rel_type (@rel_types) {\n\t  if($rel_type->identifier || $term->identifier) {\n\t\t  return 1 if $rel_type->identifier eq $term->identifier;\n\t  } else {\n\t\t  return 1 if $rel_type->name eq $term->name;\n\t  }\n  }\n\n  return 0;\n}\n\n=head2 _typed_traversal\n\n Title   : _typed_traversal\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\nsub _typed_traversal{\n\tmy ($self, $rel_store, $level, $term_id, @rel_types) = @_;\n\treturn if !defined($rel_store->{$term_id});\n\tmy %parent_entry = %{$rel_store->{$term_id}};\n\tmy @children = keys %parent_entry;\n\n\tmy @ans;\n\n\tif (@rel_types > 0) {\n\t\t@ans = ();\n\n\t\tforeach my $child_id (@children) {\n\t\t\tpush @ans, $child_id\n\t\t\t  if $self->_is_rel_type( $rel_store->{$term_id}->{$child_id},\n\t\t\t\t\t\t\t\t\t\t\t  @rel_types);\n\t\t}\n\t}\n\telse {\n\t\t@ans = @children;\n\t}\n\tif ($level < 1) {\n\t\tmy @ans1 = ();\n\n\t\tforeach my $child_id (@ans) {\n\t\t\tpush @ans1, $self->_typed_traversal($rel_store,\n\t\t\t\t\t\t\t\t$level - 1, $child_id, @rel_types)\n\t\t\t  if defined $rel_store->{$child_id};\n\t\t}\n\t\tpush @ans, @ans1;\n\t}\n\n  return @ans;\n}\n\n=head2 get_child_terms\n\n Title   : get_child_terms\n Usage   : get_child_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all child terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_child_terms is a special\n           case of get_descendant_terms, limiting the search to the\n           direct descendants.\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_child_terms{\n\tmy ($self, $term, @relationship_types) = @_;\n\n\t$self->throw(\"must provide TermI compliant object\") \n\t  unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n\treturn $self->_filter_unmarked(\n\t\t\t\t\t\t\t\t\t\t\t $self->get_term_by_identifier(\n\t\t\t\t\t\t$self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t   1,\n\t\t\t\t\t   $term->identifier,\n\t\t\t\t\t   @relationship_types) ) );\n}\n\n=head2 get_descendant_terms\n\n Title   : get_descendant_terms\n Usage   : get_descendant_terms(TermI term, TermI rel_types): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all descendant terms of a given term, that\n           satisfy a relationship among those that are specified in\n           the second argument or undef otherwise. Uses\n           _typed_traversal to find all descendants.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_descendant_terms{\n  my ($self, $term, @relationship_types) = @_;\n\n  $self->throw(\"must provide TermI compliant object\") \n      unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n  return $self->_filter_unmarked(\n\t     $self->_filter_repeated(\n\t         $self->get_term_by_identifier(\n\t\t     $self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t     0,\n\t\t\t\t\t     $term->identifier,\n\t\t\t\t\t     @relationship_types) ) ) );\n}\n\n=head2 get_parent_terms\n\n Title   : get_parent_terms\n Usage   : get_parent_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all parent terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_parent_terms is a special\n           case of get_ancestor_terms, limiting the search to the\n           direct ancestors.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of relationship type terms.\n\n\nsub get_parent_terms{\n  my ($self, $term, @relationship_types) = @_;\n  $self->throw(\"term must be a valid object, not undef\") unless defined $term;\n\n  return $self->_filter_unmarked(\n\t    $self->get_term_by_identifier(\n\t\t$self->_typed_traversal($self->_inverted_relationship_store,\n\t\t\t\t\t1,\n\t\t\t\t\t$term->identifier,\n\t\t\t\t\t@relationship_types) ) );\n}\n\n=head2 get_ancestor_terms\n\n Title   : get_ancestor_terms\n Usage   : get_ancestor_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all ancestor terms of a given term, that satisfy\n           a relationship among those that are specified in the second\n           argument or undef otherwise. Uses _typed_traversal to find\n           all ancestors.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list\n           of relationship type terms.\n\n\nsub get_ancestor_terms{\n  my ($self, $term, @relationship_types) = @_;\n  $self->throw(\"term must be a valid object, not undef\") unless defined $term;\n\n  return $self->_filter_unmarked(\n\t    $self->_filter_repeated(\n               $self->get_term_by_identifier(\n                  $self->_typed_traversal($self->_inverted_relationship_store,\n\t\t\t\t\t  0,\n\t\t\t\t\t  $term->identifier,\n\t\t\t\t\t  @relationship_types) ) ) );\n}\n\n=head2 get_leaf_terms\n\n Title   : get_leaf_terms\n Usage   : get_leaf_terms(): TermI\n Function: Retrieves all leaf terms from the ontology. Leaf term is a term w/o descendants.\n Example : @leaf_terms = $obj->get_leaf_terms()\n Returns : Array of TermI objects.\n Args    :\n\n\nsub get_leaf_terms{\n  my ($self) = @_;\n  my @leaf_terms;\n\n  foreach my $term (values %{$self->_term_store}) {\n\t  push @leaf_terms, $term\n\t\t if !defined $self->_relationship_store->{$term->identifier} &&\n\t\t\tdefined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @leaf_terms;\n}\n\n=head2 get_root_terms\n\n Title   : get_root_terms\n Usage   : get_root_terms(): TermI\n Function: Retrieves all root terms from the ontology. Root term is a term w/o descendants.\n Example : @root_terms = $obj->get_root_terms()\n Returns : Array of TermI objects.\n Args    :\n\n\nsub get_root_terms{\n  my ($self) = @_;\n  my @root_terms;\n\n  foreach my $term (values %{$self->_term_store}) {\n    push @root_terms, $term\n      if !defined $self->_inverted_relationship_store->{$term->identifier} &&\n\t\t  defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @root_terms;\n}\n\n=head2 _filter_repeated\n\n Title   : _filter_repeated\n Usage   : @lst = $self->_filter_repeated(@old_lst);\n Function: Removes repeated terms\n Example :\n Returns : List of unique TermI objects\n Args    : List of TermI objects","parameters":[{"label":"$self"},{"label":"@args"}]},"range":{"end":{"line":806,"character":9999},"start":{"line":797,"character":0}},"kind":12,"line":797},{"kind":12,"range":{"end":{"line":822,"character":9999},"start":{"line":819,"character":0}},"line":819,"signature":{"label":"get_all_terms($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _relationship_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_store'}) {\n\t\t  $self->throw(\"_relationship_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_store'};\n}\n\n=head2 _inverted_relationship_store\n\n Title   : _inverted_relationship_store\n Usage   :\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _inverted_relationship_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\tif ( defined $self->{'_inverted_relationship_store'}) {\n\t\t\t$self->throw(\"_inverted_relationship_store already defined\\n\");\n\t\t}\n\t\telse {\n\t\t\t$self->{'_inverted_relationship_store'} = $value;\n\t\t}\n\t}\n\n  return $self->{'_inverted_relationship_store'};\n}\n\n=head2 _relationship_type_store\n\n Title   : _relationship_type_store\n Usage   : $obj->_relationship_type_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    : reference to an array of Bio::Ontology::RelationshipType objects\n\n\nsub _relationship_type_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_type_store'}) {\n\t\t  $self->throw(\"_relationship_type_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_type_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_type_store'};\n}\n\n=head2 _add_relationship_simple\n\n Title   : _add_relationship_simple\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _add_relationship_simple{\n   my ($self, $store, $rel, $inverted) = @_;\n   my $parent_id;\n   my $child_id;\n\n   if ($inverted) {\n\t\t$parent_id = $rel->subject_term->identifier;\n\t\t$child_id = $rel->object_term->identifier;\n   }\n   else {\n\t\t$parent_id = $rel->object_term->identifier;\n\t\t$child_id = $rel->subject_term->identifier;\n   }\n   if(defined $store->{$parent_id} && (defined $store->{$parent_id}->{$child_id}) &&\n      ($store->{$parent_id}->{$child_id}->name != $rel->predicate_term->name)){\n\t\t$self->throw(\"relationship \".Dumper($rel->predicate_term).\n\t\t\t\t\t\t \" between \".$parent_id.\" and \".$child_id.\n\t\t\t\t\t\t \" already defined as \".\n\t\t\t\t\t\t Dumper($store->{$parent_id}->{$child_id}).\"\\n\");\n   }\n   else {\n\t\t$store->{$parent_id}->{$child_id} = $rel->predicate_term;\n   }\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : add_relationship(RelationshipI relationship): RelationshipI\n Function: Adds a relationship object to the ontology engine.\n Example :\n Returns : Its argument.\n Args    : A RelationshipI object.\n\n\nsub add_relationship{\n   my ($self, $rel) = @_;\n\n   $self->_add_relationship_simple($self->_relationship_store,\n\t\t\t\t   $rel, 0);\n   $self->_add_relationship_simple($self->_inverted_relationship_store,\n\t\t\t\t   $rel, 1);\n   $self->_relationship_type_store->{\n       $self->_unique_termid($rel->predicate_term)} = $rel->predicate_term;\n\n   return $rel;\n}\n\n=head2 get_relationships\n\n Title   : get_relationships\n Usage   : get_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_relationships{\n    my $self = shift;\n    my $term = shift;\n    my @rels;\n    my $store = $self->_relationship_store;\n    my $relfact = $self->relationship_factory(); \n\n    my @parent_ids = $term ?\n\t\t# if a term is supplied then only get the term's parents\n\t\t(map { $_->identifier(); } $self->get_parent_terms($term)) :\n\t\t  # otherwise use all parent ids\n\t\t  (keys %{$store});\n    # add the term as a parent too if one is supplied\n    push(@parent_ids,$term->identifier) if $term;\n    \n    foreach my $parent_id (@parent_ids) {\n\t\t my $parent_entry = $store->{$parent_id};\n\n\t\t # if a term is supplied, add a relationship for the parent to the term\n\t\t # except if the parent is the term itself (we added that one before)\n\t\t if($term && ($parent_id ne $term->identifier())) {\n\t\t\t my @parent_terms = $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t push(@rels,\n\t\t\t\t\t\t$relfact->create_object(-object_term    => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term   => $term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term =>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t$parent_entry->{$term->identifier},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology => $term->ontology())\n\t\t\t\t\t  );\n\t\t\t }\n\t\t \n\t\t } else {\n\t\t\t # otherwise, i.e., no term supplied, or the parent equals the\n\t\t\t # supplied term\n\t\t\t my @parent_terms = $term ?\n\t\t\t\t($term) : $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $child_id (keys %$parent_entry) {\n\t\t\t\t my $rel_info = $parent_entry->{$child_id};\n\t\t\t\t my ($subj_term) = $self->get_term_by_identifier($child_id);\n\n\t\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t\t push(@rels,\n\t\t\t\t\t\t\t$relfact->create_object(-object_term  => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term => $subj_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term => $rel_info,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology =>$parent_term->ontology\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t  )\n\t\t\t\t\t\t  );\n\t\t\t\t }\n\t\t\t }\n\t\t }\n    }\n\n    return @rels;\n}\n\n=head2 get_all_relationships\n\n Title   : get_all_relationships\n Usage   : get_all_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_all_relationships{\n    return shift->get_relationships();\n}\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : get_predicate_terms(): TermI\n Function: Retrives all relationship types stored in the engine\n Example :\n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    :\n\n\nsub get_predicate_terms{\n  my ($self) = @_;\n\n  return values %{$self->_relationship_type_store};\n}\n\n=head2 _is_rel_type\n\n Title   : _is_rel_type\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _is_rel_type{\n  my ($self, $term, @rel_types) = @_;\n\n  foreach my $rel_type (@rel_types) {\n\t  if($rel_type->identifier || $term->identifier) {\n\t\t  return 1 if $rel_type->identifier eq $term->identifier;\n\t  } else {\n\t\t  return 1 if $rel_type->name eq $term->name;\n\t  }\n  }\n\n  return 0;\n}\n\n=head2 _typed_traversal\n\n Title   : _typed_traversal\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\nsub _typed_traversal{\n\tmy ($self, $rel_store, $level, $term_id, @rel_types) = @_;\n\treturn if !defined($rel_store->{$term_id});\n\tmy %parent_entry = %{$rel_store->{$term_id}};\n\tmy @children = keys %parent_entry;\n\n\tmy @ans;\n\n\tif (@rel_types > 0) {\n\t\t@ans = ();\n\n\t\tforeach my $child_id (@children) {\n\t\t\tpush @ans, $child_id\n\t\t\t  if $self->_is_rel_type( $rel_store->{$term_id}->{$child_id},\n\t\t\t\t\t\t\t\t\t\t\t  @rel_types);\n\t\t}\n\t}\n\telse {\n\t\t@ans = @children;\n\t}\n\tif ($level < 1) {\n\t\tmy @ans1 = ();\n\n\t\tforeach my $child_id (@ans) {\n\t\t\tpush @ans1, $self->_typed_traversal($rel_store,\n\t\t\t\t\t\t\t\t$level - 1, $child_id, @rel_types)\n\t\t\t  if defined $rel_store->{$child_id};\n\t\t}\n\t\tpush @ans, @ans1;\n\t}\n\n  return @ans;\n}\n\n=head2 get_child_terms\n\n Title   : get_child_terms\n Usage   : get_child_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all child terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_child_terms is a special\n           case of get_descendant_terms, limiting the search to the\n           direct descendants.\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_child_terms{\n\tmy ($self, $term, @relationship_types) = @_;\n\n\t$self->throw(\"must provide TermI compliant object\") \n\t  unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n\treturn $self->_filter_unmarked(\n\t\t\t\t\t\t\t\t\t\t\t $self->get_term_by_identifier(\n\t\t\t\t\t\t$self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t   1,\n\t\t\t\t\t   $term->identifier,\n\t\t\t\t\t   @relationship_types) ) );\n}\n\n=head2 get_descendant_terms\n\n Title   : get_descendant_terms\n Usage   : get_descendant_terms(TermI term, TermI rel_types): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all descendant terms of a given term, that\n           satisfy a relationship among those that are specified in\n           the second argument or undef otherwise. Uses\n           _typed_traversal to find all descendants.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_descendant_terms{\n  my ($self, $term, @relationship_types) = @_;\n\n  $self->throw(\"must provide TermI compliant object\") \n      unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n  return $self->_filter_unmarked(\n\t     $self->_filter_repeated(\n\t         $self->get_term_by_identifier(\n\t\t     $self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t     0,\n\t\t\t\t\t     $term->identifier,\n\t\t\t\t\t     @relationship_types) ) ) );\n}\n\n=head2 get_parent_terms\n\n Title   : get_parent_terms\n Usage   : get_parent_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all parent terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_parent_terms is a special\n           case of get_ancestor_terms, limiting the search to the\n           direct ancestors.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of relationship type terms.\n\n\nsub get_parent_terms{\n  my ($self, $term, @relationship_types) = @_;\n  $self->throw(\"term must be a valid object, not undef\") unless defined $term;\n\n  return $self->_filter_unmarked(\n\t    $self->get_term_by_identifier(\n\t\t$self->_typed_traversal($self->_inverted_relationship_store,\n\t\t\t\t\t1,\n\t\t\t\t\t$term->identifier,\n\t\t\t\t\t@relationship_types) ) );\n}\n\n=head2 get_ancestor_terms\n\n Title   : get_ancestor_terms\n Usage   : get_ancestor_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all ancestor terms of a given term, that satisfy\n           a relationship among those that are specified in the second\n           argument or undef otherwise. Uses _typed_traversal to find\n           all ancestors.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list\n           of relationship type terms.\n\n\nsub get_ancestor_terms{\n  my ($self, $term, @relationship_types) = @_;\n  $self->throw(\"term must be a valid object, not undef\") unless defined $term;\n\n  return $self->_filter_unmarked(\n\t    $self->_filter_repeated(\n               $self->get_term_by_identifier(\n                  $self->_typed_traversal($self->_inverted_relationship_store,\n\t\t\t\t\t  0,\n\t\t\t\t\t  $term->identifier,\n\t\t\t\t\t  @relationship_types) ) ) );\n}\n\n=head2 get_leaf_terms\n\n Title   : get_leaf_terms\n Usage   : get_leaf_terms(): TermI\n Function: Retrieves all leaf terms from the ontology. Leaf term is a term w/o descendants.\n Example : @leaf_terms = $obj->get_leaf_terms()\n Returns : Array of TermI objects.\n Args    :\n\n\nsub get_leaf_terms{\n  my ($self) = @_;\n  my @leaf_terms;\n\n  foreach my $term (values %{$self->_term_store}) {\n\t  push @leaf_terms, $term\n\t\t if !defined $self->_relationship_store->{$term->identifier} &&\n\t\t\tdefined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @leaf_terms;\n}\n\n=head2 get_root_terms\n\n Title   : get_root_terms\n Usage   : get_root_terms(): TermI\n Function: Retrieves all root terms from the ontology. Root term is a term w/o descendants.\n Example : @root_terms = $obj->get_root_terms()\n Returns : Array of TermI objects.\n Args    :\n\n\nsub get_root_terms{\n  my ($self) = @_;\n  my @root_terms;\n\n  foreach my $term (values %{$self->_term_store}) {\n    push @root_terms, $term\n      if !defined $self->_inverted_relationship_store->{$term->identifier} &&\n\t\t  defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @root_terms;\n}\n\n=head2 _filter_repeated\n\n Title   : _filter_repeated\n Usage   : @lst = $self->_filter_repeated(@old_lst);\n Function: Removes repeated terms\n Example :\n Returns : List of unique TermI objects\n Args    : List of TermI objects\n\n\nsub _filter_repeated{\n  my ($self, @args) = @_;\n  my %h;\n\n  foreach my $element (@args) {\n    $h{$element->identifier} = $element if !defined $h{$element->identifier};\n  }\n\n  return values %h;\n}\n\n=head2 get_all_terms\n\n Title   : get_all_terms\n Usage   : get_all_terms(): TermI\n Function: Retrieves all terms currently stored in the ontology.\n Example : @all_terms = $obj->get_all_terms()\n Returns : Array of TermI objects.\n Args    :"},"containerName":"main::","name":"get_all_terms","children":[{"containerName":"get_all_terms","localvar":"my","kind":13,"name":"$self","line":820,"definition":"my"},{"name":"$self","kind":13,"containerName":"get_all_terms","line":822},{"line":822,"containerName":"get_all_terms","kind":12,"name":"_filter_unmarked"},{"name":"$self","containerName":"get_all_terms","kind":13,"line":822},{"name":"_term_store","kind":12,"containerName":"get_all_terms","line":822}],"detail":"($self)","definition":"sub"},{"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _relationship_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_store'}) {\n\t\t  $self->throw(\"_relationship_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_store'};\n}\n\n=head2 _inverted_relationship_store\n\n Title   : _inverted_relationship_store\n Usage   :\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _inverted_relationship_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\tif ( defined $self->{'_inverted_relationship_store'}) {\n\t\t\t$self->throw(\"_inverted_relationship_store already defined\\n\");\n\t\t}\n\t\telse {\n\t\t\t$self->{'_inverted_relationship_store'} = $value;\n\t\t}\n\t}\n\n  return $self->{'_inverted_relationship_store'};\n}\n\n=head2 _relationship_type_store\n\n Title   : _relationship_type_store\n Usage   : $obj->_relationship_type_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    : reference to an array of Bio::Ontology::RelationshipType objects\n\n\nsub _relationship_type_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_type_store'}) {\n\t\t  $self->throw(\"_relationship_type_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_type_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_type_store'};\n}\n\n=head2 _add_relationship_simple\n\n Title   : _add_relationship_simple\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _add_relationship_simple{\n   my ($self, $store, $rel, $inverted) = @_;\n   my $parent_id;\n   my $child_id;\n\n   if ($inverted) {\n\t\t$parent_id = $rel->subject_term->identifier;\n\t\t$child_id = $rel->object_term->identifier;\n   }\n   else {\n\t\t$parent_id = $rel->object_term->identifier;\n\t\t$child_id = $rel->subject_term->identifier;\n   }\n   if(defined $store->{$parent_id} && (defined $store->{$parent_id}->{$child_id}) &&\n      ($store->{$parent_id}->{$child_id}->name != $rel->predicate_term->name)){\n\t\t$self->throw(\"relationship \".Dumper($rel->predicate_term).\n\t\t\t\t\t\t \" between \".$parent_id.\" and \".$child_id.\n\t\t\t\t\t\t \" already defined as \".\n\t\t\t\t\t\t Dumper($store->{$parent_id}->{$child_id}).\"\\n\");\n   }\n   else {\n\t\t$store->{$parent_id}->{$child_id} = $rel->predicate_term;\n   }\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : add_relationship(RelationshipI relationship): RelationshipI\n Function: Adds a relationship object to the ontology engine.\n Example :\n Returns : Its argument.\n Args    : A RelationshipI object.\n\n\nsub add_relationship{\n   my ($self, $rel) = @_;\n\n   $self->_add_relationship_simple($self->_relationship_store,\n\t\t\t\t   $rel, 0);\n   $self->_add_relationship_simple($self->_inverted_relationship_store,\n\t\t\t\t   $rel, 1);\n   $self->_relationship_type_store->{\n       $self->_unique_termid($rel->predicate_term)} = $rel->predicate_term;\n\n   return $rel;\n}\n\n=head2 get_relationships\n\n Title   : get_relationships\n Usage   : get_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_relationships{\n    my $self = shift;\n    my $term = shift;\n    my @rels;\n    my $store = $self->_relationship_store;\n    my $relfact = $self->relationship_factory(); \n\n    my @parent_ids = $term ?\n\t\t# if a term is supplied then only get the term's parents\n\t\t(map { $_->identifier(); } $self->get_parent_terms($term)) :\n\t\t  # otherwise use all parent ids\n\t\t  (keys %{$store});\n    # add the term as a parent too if one is supplied\n    push(@parent_ids,$term->identifier) if $term;\n    \n    foreach my $parent_id (@parent_ids) {\n\t\t my $parent_entry = $store->{$parent_id};\n\n\t\t # if a term is supplied, add a relationship for the parent to the term\n\t\t # except if the parent is the term itself (we added that one before)\n\t\t if($term && ($parent_id ne $term->identifier())) {\n\t\t\t my @parent_terms = $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t push(@rels,\n\t\t\t\t\t\t$relfact->create_object(-object_term    => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term   => $term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term =>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t$parent_entry->{$term->identifier},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology => $term->ontology())\n\t\t\t\t\t  );\n\t\t\t }\n\t\t \n\t\t } else {\n\t\t\t # otherwise, i.e., no term supplied, or the parent equals the\n\t\t\t # supplied term\n\t\t\t my @parent_terms = $term ?\n\t\t\t\t($term) : $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $child_id (keys %$parent_entry) {\n\t\t\t\t my $rel_info = $parent_entry->{$child_id};\n\t\t\t\t my ($subj_term) = $self->get_term_by_identifier($child_id);\n\n\t\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t\t push(@rels,\n\t\t\t\t\t\t\t$relfact->create_object(-object_term  => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term => $subj_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term => $rel_info,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology =>$parent_term->ontology\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t  )\n\t\t\t\t\t\t  );\n\t\t\t\t }\n\t\t\t }\n\t\t }\n    }\n\n    return @rels;\n}\n\n=head2 get_all_relationships\n\n Title   : get_all_relationships\n Usage   : get_all_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_all_relationships{\n    return shift->get_relationships();\n}\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : get_predicate_terms(): TermI\n Function: Retrives all relationship types stored in the engine\n Example :\n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    :\n\n\nsub get_predicate_terms{\n  my ($self) = @_;\n\n  return values %{$self->_relationship_type_store};\n}\n\n=head2 _is_rel_type\n\n Title   : _is_rel_type\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _is_rel_type{\n  my ($self, $term, @rel_types) = @_;\n\n  foreach my $rel_type (@rel_types) {\n\t  if($rel_type->identifier || $term->identifier) {\n\t\t  return 1 if $rel_type->identifier eq $term->identifier;\n\t  } else {\n\t\t  return 1 if $rel_type->name eq $term->name;\n\t  }\n  }\n\n  return 0;\n}\n\n=head2 _typed_traversal\n\n Title   : _typed_traversal\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\nsub _typed_traversal{\n\tmy ($self, $rel_store, $level, $term_id, @rel_types) = @_;\n\treturn if !defined($rel_store->{$term_id});\n\tmy %parent_entry = %{$rel_store->{$term_id}};\n\tmy @children = keys %parent_entry;\n\n\tmy @ans;\n\n\tif (@rel_types > 0) {\n\t\t@ans = ();\n\n\t\tforeach my $child_id (@children) {\n\t\t\tpush @ans, $child_id\n\t\t\t  if $self->_is_rel_type( $rel_store->{$term_id}->{$child_id},\n\t\t\t\t\t\t\t\t\t\t\t  @rel_types);\n\t\t}\n\t}\n\telse {\n\t\t@ans = @children;\n\t}\n\tif ($level < 1) {\n\t\tmy @ans1 = ();\n\n\t\tforeach my $child_id (@ans) {\n\t\t\tpush @ans1, $self->_typed_traversal($rel_store,\n\t\t\t\t\t\t\t\t$level - 1, $child_id, @rel_types)\n\t\t\t  if defined $rel_store->{$child_id};\n\t\t}\n\t\tpush @ans, @ans1;\n\t}\n\n  return @ans;\n}\n\n=head2 get_child_terms\n\n Title   : get_child_terms\n Usage   : get_child_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all child terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_child_terms is a special\n           case of get_descendant_terms, limiting the search to the\n           direct descendants.\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_child_terms{\n\tmy ($self, $term, @relationship_types) = @_;\n\n\t$self->throw(\"must provide TermI compliant object\") \n\t  unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n\treturn $self->_filter_unmarked(\n\t\t\t\t\t\t\t\t\t\t\t $self->get_term_by_identifier(\n\t\t\t\t\t\t$self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t   1,\n\t\t\t\t\t   $term->identifier,\n\t\t\t\t\t   @relationship_types) ) );\n}\n\n=head2 get_descendant_terms\n\n Title   : get_descendant_terms\n Usage   : get_descendant_terms(TermI term, TermI rel_types): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all descendant terms of a given term, that\n           satisfy a relationship among those that are specified in\n           the second argument or undef otherwise. Uses\n           _typed_traversal to find all descendants.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_descendant_terms{\n  my ($self, $term, @relationship_types) = @_;\n\n  $self->throw(\"must provide TermI compliant object\") \n      unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n  return $self->_filter_unmarked(\n\t     $self->_filter_repeated(\n\t         $self->get_term_by_identifier(\n\t\t     $self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t     0,\n\t\t\t\t\t     $term->identifier,\n\t\t\t\t\t     @relationship_types) ) ) );\n}\n\n=head2 get_parent_terms\n\n Title   : get_parent_terms\n Usage   : get_parent_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all parent terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_parent_terms is a special\n           case of get_ancestor_terms, limiting the search to the\n           direct ancestors.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of relationship type terms.\n\n\nsub get_parent_terms{\n  my ($self, $term, @relationship_types) = @_;\n  $self->throw(\"term must be a valid object, not undef\") unless defined $term;\n\n  return $self->_filter_unmarked(\n\t    $self->get_term_by_identifier(\n\t\t$self->_typed_traversal($self->_inverted_relationship_store,\n\t\t\t\t\t1,\n\t\t\t\t\t$term->identifier,\n\t\t\t\t\t@relationship_types) ) );\n}\n\n=head2 get_ancestor_terms\n\n Title   : get_ancestor_terms\n Usage   : get_ancestor_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all ancestor terms of a given term, that satisfy\n           a relationship among those that are specified in the second\n           argument or undef otherwise. Uses _typed_traversal to find\n           all ancestors.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list\n           of relationship type terms.\n\n\nsub get_ancestor_terms{\n  my ($self, $term, @relationship_types) = @_;\n  $self->throw(\"term must be a valid object, not undef\") unless defined $term;\n\n  return $self->_filter_unmarked(\n\t    $self->_filter_repeated(\n               $self->get_term_by_identifier(\n                  $self->_typed_traversal($self->_inverted_relationship_store,\n\t\t\t\t\t  0,\n\t\t\t\t\t  $term->identifier,\n\t\t\t\t\t  @relationship_types) ) ) );\n}\n\n=head2 get_leaf_terms\n\n Title   : get_leaf_terms\n Usage   : get_leaf_terms(): TermI\n Function: Retrieves all leaf terms from the ontology. Leaf term is a term w/o descendants.\n Example : @leaf_terms = $obj->get_leaf_terms()\n Returns : Array of TermI objects.\n Args    :\n\n\nsub get_leaf_terms{\n  my ($self) = @_;\n  my @leaf_terms;\n\n  foreach my $term (values %{$self->_term_store}) {\n\t  push @leaf_terms, $term\n\t\t if !defined $self->_relationship_store->{$term->identifier} &&\n\t\t\tdefined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @leaf_terms;\n}\n\n=head2 get_root_terms\n\n Title   : get_root_terms\n Usage   : get_root_terms(): TermI\n Function: Retrieves all root terms from the ontology. Root term is a term w/o descendants.\n Example : @root_terms = $obj->get_root_terms()\n Returns : Array of TermI objects.\n Args    :\n\n\nsub get_root_terms{\n  my ($self) = @_;\n  my @root_terms;\n\n  foreach my $term (values %{$self->_term_store}) {\n    push @root_terms, $term\n      if !defined $self->_inverted_relationship_store->{$term->identifier} &&\n\t\t  defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @root_terms;\n}\n\n=head2 _filter_repeated\n\n Title   : _filter_repeated\n Usage   : @lst = $self->_filter_repeated(@old_lst);\n Function: Removes repeated terms\n Example :\n Returns : List of unique TermI objects\n Args    : List of TermI objects\n\n\nsub _filter_repeated{\n  my ($self, @args) = @_;\n  my %h;\n\n  foreach my $element (@args) {\n    $h{$element->identifier} = $element if !defined $h{$element->identifier};\n  }\n\n  return values %h;\n}\n\n=head2 get_all_terms\n\n Title   : get_all_terms\n Usage   : get_all_terms(): TermI\n Function: Retrieves all terms currently stored in the ontology.\n Example : @all_terms = $obj->get_all_terms()\n Returns : Array of TermI objects.\n Args    :\n\n\nsub get_all_terms{\n  my ($self) = @_;\n\n  return $self->_filter_unmarked( values %{$self->_term_store} );\n}\n\n=head2 find_terms\n\n Title   : find_terms\n Usage   : ($term) = $oe->find_terms(-identifier => \"SO:0000263\");\n Function: Find term instances matching queries for their attributes.\n\n           This implementation can efficiently resolve queries by\n           identifier.\n\n Example :\n Returns : an array of zero or more Bio::Ontology::TermI objects\n Args    : Named parameters. The following parameters should be recognized\n           by any implementations:\n\n              -identifier    query by the given identifier\n              -name          query by the given name","label":"find_terms($self,@args)"},"line":844,"range":{"start":{"line":844,"character":0},"end":{"line":859,"character":9999}},"kind":12,"definition":"sub","detail":"($self,@args)","children":[{"line":845,"name":"$self","kind":13,"localvar":"my","containerName":"find_terms","definition":"my"},{"line":845,"containerName":"find_terms","kind":13,"name":"@args"},{"line":846,"localvar":"my","containerName":"find_terms","kind":13,"name":"@terms","definition":"my"},{"line":848,"name":"$id","localvar":"my","kind":13,"containerName":"find_terms","definition":"my"},{"line":848,"name":"$name","kind":13,"containerName":"find_terms"},{"name":"$self","containerName":"find_terms","kind":13,"line":848},{"kind":12,"containerName":"find_terms","name":"_rearrange","line":848},{"name":"@args","containerName":"find_terms","kind":13,"line":848},{"line":850,"containerName":"find_terms","kind":13,"name":"$id"},{"containerName":"find_terms","kind":13,"name":"@terms","line":851},{"line":851,"name":"$self","containerName":"find_terms","kind":13},{"name":"get_term_by_identifier","kind":12,"containerName":"find_terms","line":851},{"line":851,"name":"$id","containerName":"find_terms","kind":13},{"line":853,"name":"@terms","containerName":"find_terms","kind":13},{"line":853,"name":"$self","kind":13,"containerName":"find_terms"},{"name":"get_all_terms","containerName":"find_terms","kind":12,"line":853},{"line":855,"name":"$name","containerName":"find_terms","kind":13},{"line":856,"name":"@terms","kind":13,"containerName":"find_terms"},{"line":856,"name":"name","containerName":"find_terms","kind":12},{"name":"$name","containerName":"find_terms","kind":13,"line":856},{"line":856,"name":"@terms","kind":13,"containerName":"find_terms"},{"line":858,"name":"@terms","kind":13,"containerName":"find_terms"}],"containerName":"main::","name":"find_terms"},{"range":{"start":{"line":876,"character":0},"end":{"character":9999,"line":881}},"kind":12,"line":876,"definition":"sub","containerName":"main::","name":"relationship_factory","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"relationship_factory","line":877},{"name":"$self","containerName":"relationship_factory","kind":13,"line":879},{"kind":13,"containerName":"relationship_factory","name":"$self","line":880}]},{"containerName":"main::","name":"term_factory","children":[{"definition":"my","line":902,"name":"$self","localvar":"my","kind":13,"containerName":"term_factory"},{"line":905,"name":"$self","kind":13,"containerName":"term_factory"},{"line":905,"containerName":"term_factory","kind":12,"name":"warn"},{"line":905,"name":"$self","kind":13,"containerName":"term_factory"},{"name":"$self","kind":13,"containerName":"term_factory","line":907},{"line":909,"kind":13,"containerName":"term_factory","name":"$self"}],"definition":"sub","kind":12,"range":{"end":{"line":910,"character":9999},"start":{"character":0,"line":901}},"line":901},{"signature":{"label":"_filter_unmarked($self,@terms)","parameters":[{"label":"$self"},{"label":"@terms"}],"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _relationship_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_store'}) {\n\t\t  $self->throw(\"_relationship_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_store'};\n}\n\n=head2 _inverted_relationship_store\n\n Title   : _inverted_relationship_store\n Usage   :\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _inverted_relationship_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\tif ( defined $self->{'_inverted_relationship_store'}) {\n\t\t\t$self->throw(\"_inverted_relationship_store already defined\\n\");\n\t\t}\n\t\telse {\n\t\t\t$self->{'_inverted_relationship_store'} = $value;\n\t\t}\n\t}\n\n  return $self->{'_inverted_relationship_store'};\n}\n\n=head2 _relationship_type_store\n\n Title   : _relationship_type_store\n Usage   : $obj->_relationship_type_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    : reference to an array of Bio::Ontology::RelationshipType objects\n\n\nsub _relationship_type_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_type_store'}) {\n\t\t  $self->throw(\"_relationship_type_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_type_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_type_store'};\n}\n\n=head2 _add_relationship_simple\n\n Title   : _add_relationship_simple\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _add_relationship_simple{\n   my ($self, $store, $rel, $inverted) = @_;\n   my $parent_id;\n   my $child_id;\n\n   if ($inverted) {\n\t\t$parent_id = $rel->subject_term->identifier;\n\t\t$child_id = $rel->object_term->identifier;\n   }\n   else {\n\t\t$parent_id = $rel->object_term->identifier;\n\t\t$child_id = $rel->subject_term->identifier;\n   }\n   if(defined $store->{$parent_id} && (defined $store->{$parent_id}->{$child_id}) &&\n      ($store->{$parent_id}->{$child_id}->name != $rel->predicate_term->name)){\n\t\t$self->throw(\"relationship \".Dumper($rel->predicate_term).\n\t\t\t\t\t\t \" between \".$parent_id.\" and \".$child_id.\n\t\t\t\t\t\t \" already defined as \".\n\t\t\t\t\t\t Dumper($store->{$parent_id}->{$child_id}).\"\\n\");\n   }\n   else {\n\t\t$store->{$parent_id}->{$child_id} = $rel->predicate_term;\n   }\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : add_relationship(RelationshipI relationship): RelationshipI\n Function: Adds a relationship object to the ontology engine.\n Example :\n Returns : Its argument.\n Args    : A RelationshipI object.\n\n\nsub add_relationship{\n   my ($self, $rel) = @_;\n\n   $self->_add_relationship_simple($self->_relationship_store,\n\t\t\t\t   $rel, 0);\n   $self->_add_relationship_simple($self->_inverted_relationship_store,\n\t\t\t\t   $rel, 1);\n   $self->_relationship_type_store->{\n       $self->_unique_termid($rel->predicate_term)} = $rel->predicate_term;\n\n   return $rel;\n}\n\n=head2 get_relationships\n\n Title   : get_relationships\n Usage   : get_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_relationships{\n    my $self = shift;\n    my $term = shift;\n    my @rels;\n    my $store = $self->_relationship_store;\n    my $relfact = $self->relationship_factory(); \n\n    my @parent_ids = $term ?\n\t\t# if a term is supplied then only get the term's parents\n\t\t(map { $_->identifier(); } $self->get_parent_terms($term)) :\n\t\t  # otherwise use all parent ids\n\t\t  (keys %{$store});\n    # add the term as a parent too if one is supplied\n    push(@parent_ids,$term->identifier) if $term;\n    \n    foreach my $parent_id (@parent_ids) {\n\t\t my $parent_entry = $store->{$parent_id};\n\n\t\t # if a term is supplied, add a relationship for the parent to the term\n\t\t # except if the parent is the term itself (we added that one before)\n\t\t if($term && ($parent_id ne $term->identifier())) {\n\t\t\t my @parent_terms = $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t push(@rels,\n\t\t\t\t\t\t$relfact->create_object(-object_term    => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term   => $term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term =>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t$parent_entry->{$term->identifier},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology => $term->ontology())\n\t\t\t\t\t  );\n\t\t\t }\n\t\t \n\t\t } else {\n\t\t\t # otherwise, i.e., no term supplied, or the parent equals the\n\t\t\t # supplied term\n\t\t\t my @parent_terms = $term ?\n\t\t\t\t($term) : $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $child_id (keys %$parent_entry) {\n\t\t\t\t my $rel_info = $parent_entry->{$child_id};\n\t\t\t\t my ($subj_term) = $self->get_term_by_identifier($child_id);\n\n\t\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t\t push(@rels,\n\t\t\t\t\t\t\t$relfact->create_object(-object_term  => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term => $subj_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term => $rel_info,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology =>$parent_term->ontology\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t  )\n\t\t\t\t\t\t  );\n\t\t\t\t }\n\t\t\t }\n\t\t }\n    }\n\n    return @rels;\n}\n\n=head2 get_all_relationships\n\n Title   : get_all_relationships\n Usage   : get_all_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_all_relationships{\n    return shift->get_relationships();\n}\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : get_predicate_terms(): TermI\n Function: Retrives all relationship types stored in the engine\n Example :\n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    :\n\n\nsub get_predicate_terms{\n  my ($self) = @_;\n\n  return values %{$self->_relationship_type_store};\n}\n\n=head2 _is_rel_type\n\n Title   : _is_rel_type\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _is_rel_type{\n  my ($self, $term, @rel_types) = @_;\n\n  foreach my $rel_type (@rel_types) {\n\t  if($rel_type->identifier || $term->identifier) {\n\t\t  return 1 if $rel_type->identifier eq $term->identifier;\n\t  } else {\n\t\t  return 1 if $rel_type->name eq $term->name;\n\t  }\n  }\n\n  return 0;\n}\n\n=head2 _typed_traversal\n\n Title   : _typed_traversal\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\nsub _typed_traversal{\n\tmy ($self, $rel_store, $level, $term_id, @rel_types) = @_;\n\treturn if !defined($rel_store->{$term_id});\n\tmy %parent_entry = %{$rel_store->{$term_id}};\n\tmy @children = keys %parent_entry;\n\n\tmy @ans;\n\n\tif (@rel_types > 0) {\n\t\t@ans = ();\n\n\t\tforeach my $child_id (@children) {\n\t\t\tpush @ans, $child_id\n\t\t\t  if $self->_is_rel_type( $rel_store->{$term_id}->{$child_id},\n\t\t\t\t\t\t\t\t\t\t\t  @rel_types);\n\t\t}\n\t}\n\telse {\n\t\t@ans = @children;\n\t}\n\tif ($level < 1) {\n\t\tmy @ans1 = ();\n\n\t\tforeach my $child_id (@ans) {\n\t\t\tpush @ans1, $self->_typed_traversal($rel_store,\n\t\t\t\t\t\t\t\t$level - 1, $child_id, @rel_types)\n\t\t\t  if defined $rel_store->{$child_id};\n\t\t}\n\t\tpush @ans, @ans1;\n\t}\n\n  return @ans;\n}\n\n=head2 get_child_terms\n\n Title   : get_child_terms\n Usage   : get_child_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all child terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_child_terms is a special\n           case of get_descendant_terms, limiting the search to the\n           direct descendants.\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_child_terms{\n\tmy ($self, $term, @relationship_types) = @_;\n\n\t$self->throw(\"must provide TermI compliant object\") \n\t  unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n\treturn $self->_filter_unmarked(\n\t\t\t\t\t\t\t\t\t\t\t $self->get_term_by_identifier(\n\t\t\t\t\t\t$self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t   1,\n\t\t\t\t\t   $term->identifier,\n\t\t\t\t\t   @relationship_types) ) );\n}\n\n=head2 get_descendant_terms\n\n Title   : get_descendant_terms\n Usage   : get_descendant_terms(TermI term, TermI rel_types): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all descendant terms of a given term, that\n           satisfy a relationship among those that are specified in\n           the second argument or undef otherwise. Uses\n           _typed_traversal to find all descendants.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_descendant_terms{\n  my ($self, $term, @relationship_types) = @_;\n\n  $self->throw(\"must provide TermI compliant object\") \n      unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n  return $self->_filter_unmarked(\n\t     $self->_filter_repeated(\n\t         $self->get_term_by_identifier(\n\t\t     $self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t     0,\n\t\t\t\t\t     $term->identifier,\n\t\t\t\t\t     @relationship_types) ) ) );\n}\n\n=head2 get_parent_terms\n\n Title   : get_parent_terms\n Usage   : get_parent_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all parent terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_parent_terms is a special\n           case of get_ancestor_terms, limiting the search to the\n           direct ancestors.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of relationship type terms.\n\n\nsub get_parent_terms{\n  my ($self, $term, @relationship_types) = @_;\n  $self->throw(\"term must be a valid object, not undef\") unless defined $term;\n\n  return $self->_filter_unmarked(\n\t    $self->get_term_by_identifier(\n\t\t$self->_typed_traversal($self->_inverted_relationship_store,\n\t\t\t\t\t1,\n\t\t\t\t\t$term->identifier,\n\t\t\t\t\t@relationship_types) ) );\n}\n\n=head2 get_ancestor_terms\n\n Title   : get_ancestor_terms\n Usage   : get_ancestor_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all ancestor terms of a given term, that satisfy\n           a relationship among those that are specified in the second\n           argument or undef otherwise. Uses _typed_traversal to find\n           all ancestors.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list\n           of relationship type terms.\n\n\nsub get_ancestor_terms{\n  my ($self, $term, @relationship_types) = @_;\n  $self->throw(\"term must be a valid object, not undef\") unless defined $term;\n\n  return $self->_filter_unmarked(\n\t    $self->_filter_repeated(\n               $self->get_term_by_identifier(\n                  $self->_typed_traversal($self->_inverted_relationship_store,\n\t\t\t\t\t  0,\n\t\t\t\t\t  $term->identifier,\n\t\t\t\t\t  @relationship_types) ) ) );\n}\n\n=head2 get_leaf_terms\n\n Title   : get_leaf_terms\n Usage   : get_leaf_terms(): TermI\n Function: Retrieves all leaf terms from the ontology. Leaf term is a term w/o descendants.\n Example : @leaf_terms = $obj->get_leaf_terms()\n Returns : Array of TermI objects.\n Args    :\n\n\nsub get_leaf_terms{\n  my ($self) = @_;\n  my @leaf_terms;\n\n  foreach my $term (values %{$self->_term_store}) {\n\t  push @leaf_terms, $term\n\t\t if !defined $self->_relationship_store->{$term->identifier} &&\n\t\t\tdefined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @leaf_terms;\n}\n\n=head2 get_root_terms\n\n Title   : get_root_terms\n Usage   : get_root_terms(): TermI\n Function: Retrieves all root terms from the ontology. Root term is a term w/o descendants.\n Example : @root_terms = $obj->get_root_terms()\n Returns : Array of TermI objects.\n Args    :\n\n\nsub get_root_terms{\n  my ($self) = @_;\n  my @root_terms;\n\n  foreach my $term (values %{$self->_term_store}) {\n    push @root_terms, $term\n      if !defined $self->_inverted_relationship_store->{$term->identifier} &&\n\t\t  defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @root_terms;\n}\n\n=head2 _filter_repeated\n\n Title   : _filter_repeated\n Usage   : @lst = $self->_filter_repeated(@old_lst);\n Function: Removes repeated terms\n Example :\n Returns : List of unique TermI objects\n Args    : List of TermI objects\n\n\nsub _filter_repeated{\n  my ($self, @args) = @_;\n  my %h;\n\n  foreach my $element (@args) {\n    $h{$element->identifier} = $element if !defined $h{$element->identifier};\n  }\n\n  return values %h;\n}\n\n=head2 get_all_terms\n\n Title   : get_all_terms\n Usage   : get_all_terms(): TermI\n Function: Retrieves all terms currently stored in the ontology.\n Example : @all_terms = $obj->get_all_terms()\n Returns : Array of TermI objects.\n Args    :\n\n\nsub get_all_terms{\n  my ($self) = @_;\n\n  return $self->_filter_unmarked( values %{$self->_term_store} );\n}\n\n=head2 find_terms\n\n Title   : find_terms\n Usage   : ($term) = $oe->find_terms(-identifier => \"SO:0000263\");\n Function: Find term instances matching queries for their attributes.\n\n           This implementation can efficiently resolve queries by\n           identifier.\n\n Example :\n Returns : an array of zero or more Bio::Ontology::TermI objects\n Args    : Named parameters. The following parameters should be recognized\n           by any implementations:\n\n              -identifier    query by the given identifier\n              -name          query by the given name\n\n\nsub find_terms{\n    my ($self,@args) = @_;\n    my @terms;\n\n    my ($id,$name) = $self->_rearrange([qw(IDENTIFIER NAME)],@args);\n\n    if(defined($id)) {\n\t\t @terms = $self->get_term_by_identifier($id);\n    } else {\n\t\t @terms = $self->get_all_terms();\n    }\n    if(defined($name)) {\n\t\t @terms = grep { $_->name() eq $name; } @terms;\n    }\n    return @terms;\n}\n\n\n=head2 relationship_factory\n\n Title   : relationship_factory\n Usage   : $fact = $obj->relationship_factory()\n Function: Get/set the object factory to be used when relationship\n           objects are created by the implementation on-the-fly.\n\n Example : \n Returns : value of relationship_factory (a Bio::Factory::ObjectFactoryI\n           compliant object)\n Args    : on set, a Bio::Factory::ObjectFactoryI compliant object\n\n\nsub relationship_factory{\n    my $self = shift;\n\n    return $self->{'relationship_factory'} = shift if @_;\n    return $self->{'relationship_factory'};\n}\n\n=head2 term_factory\n\n Title   : term_factory\n Usage   : $fact = $obj->term_factory()\n Function: Get/set the object factory to be used when term objects are\n           created by the implementation on-the-fly.\n\n           Note that this ontology engine implementation does not\n           create term objects on the fly, and therefore setting this\n           attribute is meaningless.\n\n Example : \n Returns : value of term_factory (a Bio::Factory::ObjectFactoryI\n           compliant object)\n Args    : on set, a Bio::Factory::ObjectFactoryI compliant object\n\n\nsub term_factory{\n    my $self = shift;\n\n    if(@_) {\n\t\t $self->warn(\"setting term factory, but \".ref($self).\n\t\t\t\t\t\t \" does not create terms on-the-fly\");\n\t\t return $self->{'term_factory'} = shift;\n    }\n    return $self->{'term_factory'};\n}\n\n=head2 _filter_unmarked\n\n Title   : _filter_unmarked\n Usage   : _filter_unmarked(TermI terms): TermI\n Function: Removes the uninstantiated terms from the list of terms\n Example :\n Returns : array of fully instantiated TermI objects\n Args    : array of TermI objects"},"line":923,"kind":12,"range":{"start":{"line":923,"character":0},"end":{"character":9999,"line":935}},"definition":"sub","detail":"($self,@terms)","children":[{"line":924,"containerName":"_filter_unmarked","localvar":"my","kind":13,"name":"$self","definition":"my"},{"name":"@terms","kind":13,"containerName":"_filter_unmarked","line":924},{"definition":"my","kind":13,"localvar":"my","containerName":"_filter_unmarked","name":"@filtered_terms","line":925},{"line":927,"name":"@terms","kind":13,"containerName":"_filter_unmarked"},{"definition":"my","containerName":"_filter_unmarked","localvar":"my","kind":13,"name":"$term","line":928},{"name":"@terms","kind":13,"containerName":"_filter_unmarked","line":928},{"line":929,"containerName":"_filter_unmarked","kind":13,"name":"@filtered_terms"},{"name":"$term","containerName":"_filter_unmarked","kind":13,"line":930},{"name":"$self","kind":13,"containerName":"_filter_unmarked","line":930},{"line":930,"containerName":"_filter_unmarked","kind":12,"name":"_instantiated_terms_store"},{"name":"$term","kind":13,"containerName":"_filter_unmarked","line":930},{"kind":12,"containerName":"_filter_unmarked","name":"identifier","line":930},{"line":934,"name":"@filtered_terms","kind":13,"containerName":"_filter_unmarked"}],"name":"_filter_unmarked","containerName":"main::"},{"signature":{"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _relationship_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_store'}) {\n\t\t  $self->throw(\"_relationship_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_store'};\n}\n\n=head2 _inverted_relationship_store\n\n Title   : _inverted_relationship_store\n Usage   :\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _inverted_relationship_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\tif ( defined $self->{'_inverted_relationship_store'}) {\n\t\t\t$self->throw(\"_inverted_relationship_store already defined\\n\");\n\t\t}\n\t\telse {\n\t\t\t$self->{'_inverted_relationship_store'} = $value;\n\t\t}\n\t}\n\n  return $self->{'_inverted_relationship_store'};\n}\n\n=head2 _relationship_type_store\n\n Title   : _relationship_type_store\n Usage   : $obj->_relationship_type_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    : reference to an array of Bio::Ontology::RelationshipType objects\n\n\nsub _relationship_type_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_type_store'}) {\n\t\t  $self->throw(\"_relationship_type_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_type_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_type_store'};\n}\n\n=head2 _add_relationship_simple\n\n Title   : _add_relationship_simple\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _add_relationship_simple{\n   my ($self, $store, $rel, $inverted) = @_;\n   my $parent_id;\n   my $child_id;\n\n   if ($inverted) {\n\t\t$parent_id = $rel->subject_term->identifier;\n\t\t$child_id = $rel->object_term->identifier;\n   }\n   else {\n\t\t$parent_id = $rel->object_term->identifier;\n\t\t$child_id = $rel->subject_term->identifier;\n   }\n   if(defined $store->{$parent_id} && (defined $store->{$parent_id}->{$child_id}) &&\n      ($store->{$parent_id}->{$child_id}->name != $rel->predicate_term->name)){\n\t\t$self->throw(\"relationship \".Dumper($rel->predicate_term).\n\t\t\t\t\t\t \" between \".$parent_id.\" and \".$child_id.\n\t\t\t\t\t\t \" already defined as \".\n\t\t\t\t\t\t Dumper($store->{$parent_id}->{$child_id}).\"\\n\");\n   }\n   else {\n\t\t$store->{$parent_id}->{$child_id} = $rel->predicate_term;\n   }\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : add_relationship(RelationshipI relationship): RelationshipI\n Function: Adds a relationship object to the ontology engine.\n Example :\n Returns : Its argument.\n Args    : A RelationshipI object.\n\n\nsub add_relationship{\n   my ($self, $rel) = @_;\n\n   $self->_add_relationship_simple($self->_relationship_store,\n\t\t\t\t   $rel, 0);\n   $self->_add_relationship_simple($self->_inverted_relationship_store,\n\t\t\t\t   $rel, 1);\n   $self->_relationship_type_store->{\n       $self->_unique_termid($rel->predicate_term)} = $rel->predicate_term;\n\n   return $rel;\n}\n\n=head2 get_relationships\n\n Title   : get_relationships\n Usage   : get_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_relationships{\n    my $self = shift;\n    my $term = shift;\n    my @rels;\n    my $store = $self->_relationship_store;\n    my $relfact = $self->relationship_factory(); \n\n    my @parent_ids = $term ?\n\t\t# if a term is supplied then only get the term's parents\n\t\t(map { $_->identifier(); } $self->get_parent_terms($term)) :\n\t\t  # otherwise use all parent ids\n\t\t  (keys %{$store});\n    # add the term as a parent too if one is supplied\n    push(@parent_ids,$term->identifier) if $term;\n    \n    foreach my $parent_id (@parent_ids) {\n\t\t my $parent_entry = $store->{$parent_id};\n\n\t\t # if a term is supplied, add a relationship for the parent to the term\n\t\t # except if the parent is the term itself (we added that one before)\n\t\t if($term && ($parent_id ne $term->identifier())) {\n\t\t\t my @parent_terms = $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t push(@rels,\n\t\t\t\t\t\t$relfact->create_object(-object_term    => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term   => $term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term =>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t$parent_entry->{$term->identifier},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology => $term->ontology())\n\t\t\t\t\t  );\n\t\t\t }\n\t\t \n\t\t } else {\n\t\t\t # otherwise, i.e., no term supplied, or the parent equals the\n\t\t\t # supplied term\n\t\t\t my @parent_terms = $term ?\n\t\t\t\t($term) : $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $child_id (keys %$parent_entry) {\n\t\t\t\t my $rel_info = $parent_entry->{$child_id};\n\t\t\t\t my ($subj_term) = $self->get_term_by_identifier($child_id);\n\n\t\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t\t push(@rels,\n\t\t\t\t\t\t\t$relfact->create_object(-object_term  => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term => $subj_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term => $rel_info,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology =>$parent_term->ontology\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t  )\n\t\t\t\t\t\t  );\n\t\t\t\t }\n\t\t\t }\n\t\t }\n    }\n\n    return @rels;\n}\n\n=head2 get_all_relationships\n\n Title   : get_all_relationships\n Usage   : get_all_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_all_relationships{\n    return shift->get_relationships();\n}\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : get_predicate_terms(): TermI\n Function: Retrives all relationship types stored in the engine\n Example :\n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    :\n\n\nsub get_predicate_terms{\n  my ($self) = @_;\n\n  return values %{$self->_relationship_type_store};\n}\n\n=head2 _is_rel_type\n\n Title   : _is_rel_type\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _is_rel_type{\n  my ($self, $term, @rel_types) = @_;\n\n  foreach my $rel_type (@rel_types) {\n\t  if($rel_type->identifier || $term->identifier) {\n\t\t  return 1 if $rel_type->identifier eq $term->identifier;\n\t  } else {\n\t\t  return 1 if $rel_type->name eq $term->name;\n\t  }\n  }\n\n  return 0;\n}\n\n=head2 _typed_traversal\n\n Title   : _typed_traversal\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\nsub _typed_traversal{\n\tmy ($self, $rel_store, $level, $term_id, @rel_types) = @_;\n\treturn if !defined($rel_store->{$term_id});\n\tmy %parent_entry = %{$rel_store->{$term_id}};\n\tmy @children = keys %parent_entry;\n\n\tmy @ans;\n\n\tif (@rel_types > 0) {\n\t\t@ans = ();\n\n\t\tforeach my $child_id (@children) {\n\t\t\tpush @ans, $child_id\n\t\t\t  if $self->_is_rel_type( $rel_store->{$term_id}->{$child_id},\n\t\t\t\t\t\t\t\t\t\t\t  @rel_types);\n\t\t}\n\t}\n\telse {\n\t\t@ans = @children;\n\t}\n\tif ($level < 1) {\n\t\tmy @ans1 = ();\n\n\t\tforeach my $child_id (@ans) {\n\t\t\tpush @ans1, $self->_typed_traversal($rel_store,\n\t\t\t\t\t\t\t\t$level - 1, $child_id, @rel_types)\n\t\t\t  if defined $rel_store->{$child_id};\n\t\t}\n\t\tpush @ans, @ans1;\n\t}\n\n  return @ans;\n}\n\n=head2 get_child_terms\n\n Title   : get_child_terms\n Usage   : get_child_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all child terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_child_terms is a special\n           case of get_descendant_terms, limiting the search to the\n           direct descendants.\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_child_terms{\n\tmy ($self, $term, @relationship_types) = @_;\n\n\t$self->throw(\"must provide TermI compliant object\") \n\t  unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n\treturn $self->_filter_unmarked(\n\t\t\t\t\t\t\t\t\t\t\t $self->get_term_by_identifier(\n\t\t\t\t\t\t$self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t   1,\n\t\t\t\t\t   $term->identifier,\n\t\t\t\t\t   @relationship_types) ) );\n}\n\n=head2 get_descendant_terms\n\n Title   : get_descendant_terms\n Usage   : get_descendant_terms(TermI term, TermI rel_types): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all descendant terms of a given term, that\n           satisfy a relationship among those that are specified in\n           the second argument or undef otherwise. Uses\n           _typed_traversal to find all descendants.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_descendant_terms{\n  my ($self, $term, @relationship_types) = @_;\n\n  $self->throw(\"must provide TermI compliant object\") \n      unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n  return $self->_filter_unmarked(\n\t     $self->_filter_repeated(\n\t         $self->get_term_by_identifier(\n\t\t     $self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t     0,\n\t\t\t\t\t     $term->identifier,\n\t\t\t\t\t     @relationship_types) ) ) );\n}\n\n=head2 get_parent_terms\n\n Title   : get_parent_terms\n Usage   : get_parent_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all parent terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_parent_terms is a special\n           case of get_ancestor_terms, limiting the search to the\n           direct ancestors.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of relationship type terms.\n\n\nsub get_parent_terms{\n  my ($self, $term, @relationship_types) = @_;\n  $self->throw(\"term must be a valid object, not undef\") unless defined $term;\n\n  return $self->_filter_unmarked(\n\t    $self->get_term_by_identifier(\n\t\t$self->_typed_traversal($self->_inverted_relationship_store,\n\t\t\t\t\t1,\n\t\t\t\t\t$term->identifier,\n\t\t\t\t\t@relationship_types) ) );\n}\n\n=head2 get_ancestor_terms\n\n Title   : get_ancestor_terms\n Usage   : get_ancestor_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all ancestor terms of a given term, that satisfy\n           a relationship among those that are specified in the second\n           argument or undef otherwise. Uses _typed_traversal to find\n           all ancestors.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list\n           of relationship type terms.\n\n\nsub get_ancestor_terms{\n  my ($self, $term, @relationship_types) = @_;\n  $self->throw(\"term must be a valid object, not undef\") unless defined $term;\n\n  return $self->_filter_unmarked(\n\t    $self->_filter_repeated(\n               $self->get_term_by_identifier(\n                  $self->_typed_traversal($self->_inverted_relationship_store,\n\t\t\t\t\t  0,\n\t\t\t\t\t  $term->identifier,\n\t\t\t\t\t  @relationship_types) ) ) );\n}\n\n=head2 get_leaf_terms\n\n Title   : get_leaf_terms\n Usage   : get_leaf_terms(): TermI\n Function: Retrieves all leaf terms from the ontology. Leaf term is a term w/o descendants.\n Example : @leaf_terms = $obj->get_leaf_terms()\n Returns : Array of TermI objects.\n Args    :\n\n\nsub get_leaf_terms{\n  my ($self) = @_;\n  my @leaf_terms;\n\n  foreach my $term (values %{$self->_term_store}) {\n\t  push @leaf_terms, $term\n\t\t if !defined $self->_relationship_store->{$term->identifier} &&\n\t\t\tdefined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @leaf_terms;\n}\n\n=head2 get_root_terms\n\n Title   : get_root_terms\n Usage   : get_root_terms(): TermI\n Function: Retrieves all root terms from the ontology. Root term is a term w/o descendants.\n Example : @root_terms = $obj->get_root_terms()\n Returns : Array of TermI objects.\n Args    :\n\n\nsub get_root_terms{\n  my ($self) = @_;\n  my @root_terms;\n\n  foreach my $term (values %{$self->_term_store}) {\n    push @root_terms, $term\n      if !defined $self->_inverted_relationship_store->{$term->identifier} &&\n\t\t  defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @root_terms;\n}\n\n=head2 _filter_repeated\n\n Title   : _filter_repeated\n Usage   : @lst = $self->_filter_repeated(@old_lst);\n Function: Removes repeated terms\n Example :\n Returns : List of unique TermI objects\n Args    : List of TermI objects\n\n\nsub _filter_repeated{\n  my ($self, @args) = @_;\n  my %h;\n\n  foreach my $element (@args) {\n    $h{$element->identifier} = $element if !defined $h{$element->identifier};\n  }\n\n  return values %h;\n}\n\n=head2 get_all_terms\n\n Title   : get_all_terms\n Usage   : get_all_terms(): TermI\n Function: Retrieves all terms currently stored in the ontology.\n Example : @all_terms = $obj->get_all_terms()\n Returns : Array of TermI objects.\n Args    :\n\n\nsub get_all_terms{\n  my ($self) = @_;\n\n  return $self->_filter_unmarked( values %{$self->_term_store} );\n}\n\n=head2 find_terms\n\n Title   : find_terms\n Usage   : ($term) = $oe->find_terms(-identifier => \"SO:0000263\");\n Function: Find term instances matching queries for their attributes.\n\n           This implementation can efficiently resolve queries by\n           identifier.\n\n Example :\n Returns : an array of zero or more Bio::Ontology::TermI objects\n Args    : Named parameters. The following parameters should be recognized\n           by any implementations:\n\n              -identifier    query by the given identifier\n              -name          query by the given name\n\n\nsub find_terms{\n    my ($self,@args) = @_;\n    my @terms;\n\n    my ($id,$name) = $self->_rearrange([qw(IDENTIFIER NAME)],@args);\n\n    if(defined($id)) {\n\t\t @terms = $self->get_term_by_identifier($id);\n    } else {\n\t\t @terms = $self->get_all_terms();\n    }\n    if(defined($name)) {\n\t\t @terms = grep { $_->name() eq $name; } @terms;\n    }\n    return @terms;\n}\n\n\n=head2 relationship_factory\n\n Title   : relationship_factory\n Usage   : $fact = $obj->relationship_factory()\n Function: Get/set the object factory to be used when relationship\n           objects are created by the implementation on-the-fly.\n\n Example : \n Returns : value of relationship_factory (a Bio::Factory::ObjectFactoryI\n           compliant object)\n Args    : on set, a Bio::Factory::ObjectFactoryI compliant object\n\n\nsub relationship_factory{\n    my $self = shift;\n\n    return $self->{'relationship_factory'} = shift if @_;\n    return $self->{'relationship_factory'};\n}\n\n=head2 term_factory\n\n Title   : term_factory\n Usage   : $fact = $obj->term_factory()\n Function: Get/set the object factory to be used when term objects are\n           created by the implementation on-the-fly.\n\n           Note that this ontology engine implementation does not\n           create term objects on the fly, and therefore setting this\n           attribute is meaningless.\n\n Example : \n Returns : value of term_factory (a Bio::Factory::ObjectFactoryI\n           compliant object)\n Args    : on set, a Bio::Factory::ObjectFactoryI compliant object\n\n\nsub term_factory{\n    my $self = shift;\n\n    if(@_) {\n\t\t $self->warn(\"setting term factory, but \".ref($self).\n\t\t\t\t\t\t \" does not create terms on-the-fly\");\n\t\t return $self->{'term_factory'} = shift;\n    }\n    return $self->{'term_factory'};\n}\n\n=head2 _filter_unmarked\n\n Title   : _filter_unmarked\n Usage   : _filter_unmarked(TermI terms): TermI\n Function: Removes the uninstantiated terms from the list of terms\n Example :\n Returns : array of fully instantiated TermI objects\n Args    : array of TermI objects\n\n\nsub _filter_unmarked{\n  my ($self, @terms) = @_;\n  my @filtered_terms = ();\n\n  if ( scalar(@terms) >= 1) {\n    foreach my $term (@terms) {\n      push @filtered_terms, $term\n\tif defined $self->_instantiated_terms_store->{$term->identifier};\n    }\n  }\n\n  return @filtered_terms;\n}\n\n=head2 remove_term_by_id\n\n Title   : remove_term_by_id\n Usage   : remove_term_by_id(String id): TermI\n Function: Removes TermI object from the ontology engine using the\n           string id as an identifier. Current implementation does not\n           enforce consistency of the relationships using that term.\n Example : $term = $soe->remove_term_by_id($id);\n Returns : Object of class TermI or undef if not found.\n Args    : The string identifier of a term.","parameters":[{"label":"$self"},{"label":"$id"}],"label":"remove_term_by_id($self,$id)"},"kind":12,"range":{"end":{"character":9999,"line":962},"start":{"character":0,"line":950}},"line":950,"detail":"($self,$id)","definition":"sub","containerName":"main::","name":"remove_term_by_id","children":[{"kind":13,"localvar":"my","containerName":"remove_term_by_id","name":"$self","line":951,"definition":"my"},{"line":951,"containerName":"remove_term_by_id","kind":13,"name":"$id"},{"containerName":"remove_term_by_id","kind":13,"name":"$self","line":953},{"line":953,"name":"get_term_by_identifier","containerName":"remove_term_by_id","kind":12},{"line":953,"name":"$id","containerName":"remove_term_by_id","kind":13},{"line":954,"name":"$term","localvar":"my","containerName":"remove_term_by_id","kind":13,"definition":"my"},{"line":954,"kind":13,"containerName":"remove_term_by_id","name":"$self"},{"line":954,"name":"$id","kind":13,"containerName":"remove_term_by_id"},{"kind":13,"containerName":"remove_term_by_id","name":"$self","line":955},{"kind":13,"containerName":"remove_term_by_id","name":"$id","line":955},{"line":956,"name":"$term","kind":13,"containerName":"remove_term_by_id"},{"line":959,"name":"$self","kind":13,"containerName":"remove_term_by_id"},{"line":959,"name":"warn","containerName":"remove_term_by_id","kind":12}]},{"name":"_term_store","kind":12,"line":954},{"line":955,"name":"_term_store","kind":12},{"definition":"sub","detail":"($self)","children":[{"line":977,"containerName":"to_string","localvar":"my","kind":13,"name":"$self","definition":"my"},{"localvar":"my","containerName":"to_string","kind":13,"name":"$s","line":978,"definition":"my"},{"line":980,"name":"$s","kind":13,"containerName":"to_string"},{"name":"$s","kind":13,"containerName":"to_string","line":981},{"line":981,"kind":13,"containerName":"to_string","name":"$self"},{"line":981,"name":"get_all_terms","kind":12,"containerName":"to_string"},{"containerName":"to_string","kind":13,"name":"$s","line":982},{"line":983,"name":"$s","kind":13,"containerName":"to_string"},{"line":983,"containerName":"to_string","kind":13,"name":"$self"},{"line":983,"name":"_get_number_rels","kind":12,"containerName":"to_string"},{"name":"$s","kind":13,"containerName":"to_string","line":985}],"containerName":"main::","name":"to_string","signature":{"label":"to_string($self)","documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _relationship_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_store'}) {\n\t\t  $self->throw(\"_relationship_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_store'};\n}\n\n=head2 _inverted_relationship_store\n\n Title   : _inverted_relationship_store\n Usage   :\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _inverted_relationship_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\tif ( defined $self->{'_inverted_relationship_store'}) {\n\t\t\t$self->throw(\"_inverted_relationship_store already defined\\n\");\n\t\t}\n\t\telse {\n\t\t\t$self->{'_inverted_relationship_store'} = $value;\n\t\t}\n\t}\n\n  return $self->{'_inverted_relationship_store'};\n}\n\n=head2 _relationship_type_store\n\n Title   : _relationship_type_store\n Usage   : $obj->_relationship_type_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    : reference to an array of Bio::Ontology::RelationshipType objects\n\n\nsub _relationship_type_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_type_store'}) {\n\t\t  $self->throw(\"_relationship_type_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_type_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_type_store'};\n}\n\n=head2 _add_relationship_simple\n\n Title   : _add_relationship_simple\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _add_relationship_simple{\n   my ($self, $store, $rel, $inverted) = @_;\n   my $parent_id;\n   my $child_id;\n\n   if ($inverted) {\n\t\t$parent_id = $rel->subject_term->identifier;\n\t\t$child_id = $rel->object_term->identifier;\n   }\n   else {\n\t\t$parent_id = $rel->object_term->identifier;\n\t\t$child_id = $rel->subject_term->identifier;\n   }\n   if(defined $store->{$parent_id} && (defined $store->{$parent_id}->{$child_id}) &&\n      ($store->{$parent_id}->{$child_id}->name != $rel->predicate_term->name)){\n\t\t$self->throw(\"relationship \".Dumper($rel->predicate_term).\n\t\t\t\t\t\t \" between \".$parent_id.\" and \".$child_id.\n\t\t\t\t\t\t \" already defined as \".\n\t\t\t\t\t\t Dumper($store->{$parent_id}->{$child_id}).\"\\n\");\n   }\n   else {\n\t\t$store->{$parent_id}->{$child_id} = $rel->predicate_term;\n   }\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : add_relationship(RelationshipI relationship): RelationshipI\n Function: Adds a relationship object to the ontology engine.\n Example :\n Returns : Its argument.\n Args    : A RelationshipI object.\n\n\nsub add_relationship{\n   my ($self, $rel) = @_;\n\n   $self->_add_relationship_simple($self->_relationship_store,\n\t\t\t\t   $rel, 0);\n   $self->_add_relationship_simple($self->_inverted_relationship_store,\n\t\t\t\t   $rel, 1);\n   $self->_relationship_type_store->{\n       $self->_unique_termid($rel->predicate_term)} = $rel->predicate_term;\n\n   return $rel;\n}\n\n=head2 get_relationships\n\n Title   : get_relationships\n Usage   : get_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_relationships{\n    my $self = shift;\n    my $term = shift;\n    my @rels;\n    my $store = $self->_relationship_store;\n    my $relfact = $self->relationship_factory(); \n\n    my @parent_ids = $term ?\n\t\t# if a term is supplied then only get the term's parents\n\t\t(map { $_->identifier(); } $self->get_parent_terms($term)) :\n\t\t  # otherwise use all parent ids\n\t\t  (keys %{$store});\n    # add the term as a parent too if one is supplied\n    push(@parent_ids,$term->identifier) if $term;\n    \n    foreach my $parent_id (@parent_ids) {\n\t\t my $parent_entry = $store->{$parent_id};\n\n\t\t # if a term is supplied, add a relationship for the parent to the term\n\t\t # except if the parent is the term itself (we added that one before)\n\t\t if($term && ($parent_id ne $term->identifier())) {\n\t\t\t my @parent_terms = $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t push(@rels,\n\t\t\t\t\t\t$relfact->create_object(-object_term    => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term   => $term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term =>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t$parent_entry->{$term->identifier},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology => $term->ontology())\n\t\t\t\t\t  );\n\t\t\t }\n\t\t \n\t\t } else {\n\t\t\t # otherwise, i.e., no term supplied, or the parent equals the\n\t\t\t # supplied term\n\t\t\t my @parent_terms = $term ?\n\t\t\t\t($term) : $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $child_id (keys %$parent_entry) {\n\t\t\t\t my $rel_info = $parent_entry->{$child_id};\n\t\t\t\t my ($subj_term) = $self->get_term_by_identifier($child_id);\n\n\t\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t\t push(@rels,\n\t\t\t\t\t\t\t$relfact->create_object(-object_term  => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term => $subj_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term => $rel_info,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology =>$parent_term->ontology\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t  )\n\t\t\t\t\t\t  );\n\t\t\t\t }\n\t\t\t }\n\t\t }\n    }\n\n    return @rels;\n}\n\n=head2 get_all_relationships\n\n Title   : get_all_relationships\n Usage   : get_all_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_all_relationships{\n    return shift->get_relationships();\n}\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : get_predicate_terms(): TermI\n Function: Retrives all relationship types stored in the engine\n Example :\n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    :\n\n\nsub get_predicate_terms{\n  my ($self) = @_;\n\n  return values %{$self->_relationship_type_store};\n}\n\n=head2 _is_rel_type\n\n Title   : _is_rel_type\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _is_rel_type{\n  my ($self, $term, @rel_types) = @_;\n\n  foreach my $rel_type (@rel_types) {\n\t  if($rel_type->identifier || $term->identifier) {\n\t\t  return 1 if $rel_type->identifier eq $term->identifier;\n\t  } else {\n\t\t  return 1 if $rel_type->name eq $term->name;\n\t  }\n  }\n\n  return 0;\n}\n\n=head2 _typed_traversal\n\n Title   : _typed_traversal\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\nsub _typed_traversal{\n\tmy ($self, $rel_store, $level, $term_id, @rel_types) = @_;\n\treturn if !defined($rel_store->{$term_id});\n\tmy %parent_entry = %{$rel_store->{$term_id}};\n\tmy @children = keys %parent_entry;\n\n\tmy @ans;\n\n\tif (@rel_types > 0) {\n\t\t@ans = ();\n\n\t\tforeach my $child_id (@children) {\n\t\t\tpush @ans, $child_id\n\t\t\t  if $self->_is_rel_type( $rel_store->{$term_id}->{$child_id},\n\t\t\t\t\t\t\t\t\t\t\t  @rel_types);\n\t\t}\n\t}\n\telse {\n\t\t@ans = @children;\n\t}\n\tif ($level < 1) {\n\t\tmy @ans1 = ();\n\n\t\tforeach my $child_id (@ans) {\n\t\t\tpush @ans1, $self->_typed_traversal($rel_store,\n\t\t\t\t\t\t\t\t$level - 1, $child_id, @rel_types)\n\t\t\t  if defined $rel_store->{$child_id};\n\t\t}\n\t\tpush @ans, @ans1;\n\t}\n\n  return @ans;\n}\n\n=head2 get_child_terms\n\n Title   : get_child_terms\n Usage   : get_child_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all child terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_child_terms is a special\n           case of get_descendant_terms, limiting the search to the\n           direct descendants.\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_child_terms{\n\tmy ($self, $term, @relationship_types) = @_;\n\n\t$self->throw(\"must provide TermI compliant object\") \n\t  unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n\treturn $self->_filter_unmarked(\n\t\t\t\t\t\t\t\t\t\t\t $self->get_term_by_identifier(\n\t\t\t\t\t\t$self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t   1,\n\t\t\t\t\t   $term->identifier,\n\t\t\t\t\t   @relationship_types) ) );\n}\n\n=head2 get_descendant_terms\n\n Title   : get_descendant_terms\n Usage   : get_descendant_terms(TermI term, TermI rel_types): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all descendant terms of a given term, that\n           satisfy a relationship among those that are specified in\n           the second argument or undef otherwise. Uses\n           _typed_traversal to find all descendants.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_descendant_terms{\n  my ($self, $term, @relationship_types) = @_;\n\n  $self->throw(\"must provide TermI compliant object\") \n      unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n  return $self->_filter_unmarked(\n\t     $self->_filter_repeated(\n\t         $self->get_term_by_identifier(\n\t\t     $self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t     0,\n\t\t\t\t\t     $term->identifier,\n\t\t\t\t\t     @relationship_types) ) ) );\n}\n\n=head2 get_parent_terms\n\n Title   : get_parent_terms\n Usage   : get_parent_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all parent terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_parent_terms is a special\n           case of get_ancestor_terms, limiting the search to the\n           direct ancestors.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of relationship type terms.\n\n\nsub get_parent_terms{\n  my ($self, $term, @relationship_types) = @_;\n  $self->throw(\"term must be a valid object, not undef\") unless defined $term;\n\n  return $self->_filter_unmarked(\n\t    $self->get_term_by_identifier(\n\t\t$self->_typed_traversal($self->_inverted_relationship_store,\n\t\t\t\t\t1,\n\t\t\t\t\t$term->identifier,\n\t\t\t\t\t@relationship_types) ) );\n}\n\n=head2 get_ancestor_terms\n\n Title   : get_ancestor_terms\n Usage   : get_ancestor_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all ancestor terms of a given term, that satisfy\n           a relationship among those that are specified in the second\n           argument or undef otherwise. Uses _typed_traversal to find\n           all ancestors.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list\n           of relationship type terms.\n\n\nsub get_ancestor_terms{\n  my ($self, $term, @relationship_types) = @_;\n  $self->throw(\"term must be a valid object, not undef\") unless defined $term;\n\n  return $self->_filter_unmarked(\n\t    $self->_filter_repeated(\n               $self->get_term_by_identifier(\n                  $self->_typed_traversal($self->_inverted_relationship_store,\n\t\t\t\t\t  0,\n\t\t\t\t\t  $term->identifier,\n\t\t\t\t\t  @relationship_types) ) ) );\n}\n\n=head2 get_leaf_terms\n\n Title   : get_leaf_terms\n Usage   : get_leaf_terms(): TermI\n Function: Retrieves all leaf terms from the ontology. Leaf term is a term w/o descendants.\n Example : @leaf_terms = $obj->get_leaf_terms()\n Returns : Array of TermI objects.\n Args    :\n\n\nsub get_leaf_terms{\n  my ($self) = @_;\n  my @leaf_terms;\n\n  foreach my $term (values %{$self->_term_store}) {\n\t  push @leaf_terms, $term\n\t\t if !defined $self->_relationship_store->{$term->identifier} &&\n\t\t\tdefined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @leaf_terms;\n}\n\n=head2 get_root_terms\n\n Title   : get_root_terms\n Usage   : get_root_terms(): TermI\n Function: Retrieves all root terms from the ontology. Root term is a term w/o descendants.\n Example : @root_terms = $obj->get_root_terms()\n Returns : Array of TermI objects.\n Args    :\n\n\nsub get_root_terms{\n  my ($self) = @_;\n  my @root_terms;\n\n  foreach my $term (values %{$self->_term_store}) {\n    push @root_terms, $term\n      if !defined $self->_inverted_relationship_store->{$term->identifier} &&\n\t\t  defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @root_terms;\n}\n\n=head2 _filter_repeated\n\n Title   : _filter_repeated\n Usage   : @lst = $self->_filter_repeated(@old_lst);\n Function: Removes repeated terms\n Example :\n Returns : List of unique TermI objects\n Args    : List of TermI objects\n\n\nsub _filter_repeated{\n  my ($self, @args) = @_;\n  my %h;\n\n  foreach my $element (@args) {\n    $h{$element->identifier} = $element if !defined $h{$element->identifier};\n  }\n\n  return values %h;\n}\n\n=head2 get_all_terms\n\n Title   : get_all_terms\n Usage   : get_all_terms(): TermI\n Function: Retrieves all terms currently stored in the ontology.\n Example : @all_terms = $obj->get_all_terms()\n Returns : Array of TermI objects.\n Args    :\n\n\nsub get_all_terms{\n  my ($self) = @_;\n\n  return $self->_filter_unmarked( values %{$self->_term_store} );\n}\n\n=head2 find_terms\n\n Title   : find_terms\n Usage   : ($term) = $oe->find_terms(-identifier => \"SO:0000263\");\n Function: Find term instances matching queries for their attributes.\n\n           This implementation can efficiently resolve queries by\n           identifier.\n\n Example :\n Returns : an array of zero or more Bio::Ontology::TermI objects\n Args    : Named parameters. The following parameters should be recognized\n           by any implementations:\n\n              -identifier    query by the given identifier\n              -name          query by the given name\n\n\nsub find_terms{\n    my ($self,@args) = @_;\n    my @terms;\n\n    my ($id,$name) = $self->_rearrange([qw(IDENTIFIER NAME)],@args);\n\n    if(defined($id)) {\n\t\t @terms = $self->get_term_by_identifier($id);\n    } else {\n\t\t @terms = $self->get_all_terms();\n    }\n    if(defined($name)) {\n\t\t @terms = grep { $_->name() eq $name; } @terms;\n    }\n    return @terms;\n}\n\n\n=head2 relationship_factory\n\n Title   : relationship_factory\n Usage   : $fact = $obj->relationship_factory()\n Function: Get/set the object factory to be used when relationship\n           objects are created by the implementation on-the-fly.\n\n Example : \n Returns : value of relationship_factory (a Bio::Factory::ObjectFactoryI\n           compliant object)\n Args    : on set, a Bio::Factory::ObjectFactoryI compliant object\n\n\nsub relationship_factory{\n    my $self = shift;\n\n    return $self->{'relationship_factory'} = shift if @_;\n    return $self->{'relationship_factory'};\n}\n\n=head2 term_factory\n\n Title   : term_factory\n Usage   : $fact = $obj->term_factory()\n Function: Get/set the object factory to be used when term objects are\n           created by the implementation on-the-fly.\n\n           Note that this ontology engine implementation does not\n           create term objects on the fly, and therefore setting this\n           attribute is meaningless.\n\n Example : \n Returns : value of term_factory (a Bio::Factory::ObjectFactoryI\n           compliant object)\n Args    : on set, a Bio::Factory::ObjectFactoryI compliant object\n\n\nsub term_factory{\n    my $self = shift;\n\n    if(@_) {\n\t\t $self->warn(\"setting term factory, but \".ref($self).\n\t\t\t\t\t\t \" does not create terms on-the-fly\");\n\t\t return $self->{'term_factory'} = shift;\n    }\n    return $self->{'term_factory'};\n}\n\n=head2 _filter_unmarked\n\n Title   : _filter_unmarked\n Usage   : _filter_unmarked(TermI terms): TermI\n Function: Removes the uninstantiated terms from the list of terms\n Example :\n Returns : array of fully instantiated TermI objects\n Args    : array of TermI objects\n\n\nsub _filter_unmarked{\n  my ($self, @terms) = @_;\n  my @filtered_terms = ();\n\n  if ( scalar(@terms) >= 1) {\n    foreach my $term (@terms) {\n      push @filtered_terms, $term\n\tif defined $self->_instantiated_terms_store->{$term->identifier};\n    }\n  }\n\n  return @filtered_terms;\n}\n\n=head2 remove_term_by_id\n\n Title   : remove_term_by_id\n Usage   : remove_term_by_id(String id): TermI\n Function: Removes TermI object from the ontology engine using the\n           string id as an identifier. Current implementation does not\n           enforce consistency of the relationships using that term.\n Example : $term = $soe->remove_term_by_id($id);\n Returns : Object of class TermI or undef if not found.\n Args    : The string identifier of a term.\n\n\nsub remove_term_by_id{\n  my ($self, $id) = @_;\n\n  if ( $self->get_term_by_identifier($id) ) {\n\t  my $term = $self->{_term_store}->{$id};\n\t  delete $self->{_term_store}->{$id};\n\t  return $term;\n  }\n  else {\n\t  $self->warn(\"Term with id '$id' is not in the term store\");\n\t  return;\n  }\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : print $sv->to_string();\n Function: Currently returns formatted string containing the number of\n           terms and number of relationships from the ontology engine.\n Example : print $sv->to_string();\n Returns :\n Args    :","parameters":[{"label":"$self"}]},"line":976,"range":{"end":{"character":9999,"line":986},"start":{"line":976,"character":0}},"kind":12},{"kind":12,"range":{"end":{"line":1020,"character":9999},"start":{"line":1008,"character":0}},"line":1008,"containerName":"main::","name":"_unique_termid","children":[{"line":1009,"name":"$self","kind":13,"localvar":"my","containerName":"_unique_termid","definition":"my"},{"containerName":"_unique_termid","localvar":"my","kind":13,"name":"$term","line":1010,"definition":"my"},{"line":1012,"containerName":"_unique_termid","kind":13,"name":"$term"},{"line":1012,"kind":12,"containerName":"_unique_termid","name":"identifier"},{"name":"$term","containerName":"_unique_termid","kind":13,"line":1012},{"name":"identifier","containerName":"_unique_termid","kind":12,"line":1012},{"line":1013,"name":"$id","localvar":"my","kind":13,"containerName":"_unique_termid","definition":"my"},{"name":"$term","kind":13,"containerName":"_unique_termid","line":1013},{"line":1013,"name":"ontology","kind":12,"containerName":"_unique_termid"},{"line":1013,"containerName":"_unique_termid","kind":12,"name":"name"},{"name":"$term","containerName":"_unique_termid","kind":13,"line":1013},{"line":1013,"containerName":"_unique_termid","kind":12,"name":"ontology"},{"line":1014,"name":"$id","containerName":"_unique_termid","kind":13},{"line":1015,"name":"$id","kind":13,"containerName":"_unique_termid"},{"line":1017,"kind":13,"containerName":"_unique_termid","name":"$id"},{"line":1019,"containerName":"_unique_termid","kind":13,"name":"$id"},{"line":1019,"name":"$term","kind":13,"containerName":"_unique_termid"},{"line":1019,"kind":12,"containerName":"_unique_termid","name":"name"}],"definition":"sub"}],"version":5}