{"vars":[{"name":"base","containerName":"","kind":2,"line":115},{"line":119,"name":"%ont_store_by_name","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"localvar":"my","containerName":null,"kind":13,"name":"%ont_store_by_id","line":120,"definition":"my"},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"%ont_aliases","line":121},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$instance","line":125},{"children":[{"name":"get_instance","containerName":"new","kind":12,"line":146}],"name":"new","containerName":"main::","definition":"sub","line":145,"range":{"end":{"line":147,"character":9999},"start":{"character":0,"line":145}},"kind":12},{"line":172,"range":{"end":{"line":179,"character":9999},"start":{"line":172,"character":0}},"kind":12,"signature":{"documentation":"1;\n# $Id: OntologyStore.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::OntologyStore\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::OntologyStore - A repository of ontologies\n\n=head1 SYNOPSIS\n\n  #----------\n  #SCENARIO 1\n  #----------\n\n  #make an ontology object manually. via OntologyIO\n  my $io = Bio::OntologyIO->new(\n                                #params to fetch Cell Ontology here\n                               );\n  my $cell_ontology = $io->next_ontology;\n\n  #this is a singleton that caches the fact that you've created\n  #a 'Cell Ontology' intance...\n  my $store = Bio::Ontology::OntologyStore->get_instance();\n\n  #...and it can hand you back a copy of it at any time.\n  my $cell_ontology_copy = $store->get_ontology('Cell Ontology');\n\n\n  #----------\n  #SCENARIO 2\n  #----------\n\n  my $store = Bio::Ontology::OntologyStore->get_instance();\n  #this use case allows the construction of an ontology on\n  #demand just by supplying the name.\n  my $ontology = $store->get_ontology('Sequence Ontology');\n\n\n=head1 DESCRIPTION\n\nThe primary purpose of this module is that of a singleton repository\nof L<Bio::Ontology::OntologyI> instances from which an Ontology\ninstance can be retrieved by name or identifier. This enables TermI\nimplementations to return their corresponding OntologyI through using\nthis singleton store instead of storing a direct reference to the\nOntology object. The latter would almost inevitably lead to memory\ncycles, and would therefore potentially blow up an application.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\n  Hilmar Lapp E<lt>hlapp@gmx.netE<gt>\n  Allen Day E<lt>allenday@ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::OntologyStore;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Ontology::DocumentRegistry;\nuse Bio::OntologyIO;\nuse FileHandle;\nuse File::Spec::Functions;\n\n\nuse base qw(Bio::Root::Root);\n\n# these are the static ontology stores by name and by identifier - there is\n# only one of each in any application\nmy %ont_store_by_name = ();\nmy %ont_store_by_id = ();\nmy %ont_aliases = (\n                   'Gene Ontology' => 'Gene_Ontology'\n                    );\n# also, this is really meant as a singleton object, so we try to enforce it\nmy $instance = undef;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Ontology::OntologyStore->new();\n Function: Returns the Bio::Ontology::OntologyStore object.\n\n           Unlike usual implementations of new, this implementation\n           will try to return a previously instantiated store, if\n           there is any. It is just a synonym for get_instance. In\n           order to avoid ambiguities in your code, you may rather\n           want to call rather get_instance explicitly, which also\n           usually is better associated with this kind of behaviour.\n\n Returns : an instance of Bio::Ontology::OntologyStore\n Args    :\n\n\nsub new {\n    return shift->get_instance(@_);\n}\n\n=head2 get_instance\n\n Title   : get_instance\n Usage   :\n Function: Get an instance of this class for perusal.\n\n           Since by design this class is meant to be used as a\n           singleton, the implementation will return a previously\n           instantianted store if there is one, and instantiate a new\n           one otherwise. In order to use this class by means of an\n           instance, call this method for added code clarity, not\n           new().\n\n Example :\n Returns : an instance of this class\n Args    : named parameters, if any (currently, there are no \n           class-specific parameters other than those accepted by\n           Bio::Root::Root.\n\nSee L<Bio::Root::Root>.","parameters":[{"label":"$self"},{"label":"@args"}],"label":"get_instance($self,@args)"},"children":[{"name":"$self","localvar":"my","containerName":"get_instance","kind":13,"line":173,"definition":"my"},{"kind":13,"containerName":"get_instance","name":"@args","line":173},{"name":"$instance","containerName":"get_instance","kind":13,"line":175},{"line":176,"name":"$instance","containerName":"get_instance","kind":13},{"line":176,"kind":13,"containerName":"get_instance","name":"$self"},{"name":"@args","containerName":"get_instance","kind":13,"line":176},{"line":178,"kind":13,"containerName":"get_instance","name":"$instance"}],"containerName":"main::","name":"get_instance","definition":"sub","detail":"($self,@args)"},{"line":176,"name":"SUPER","kind":12,"containerName":"new"},{"kind":12,"range":{"end":{"character":9999,"line":254},"start":{"character":0,"line":211}},"line":211,"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: OntologyStore.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::OntologyStore\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::OntologyStore - A repository of ontologies\n\n=head1 SYNOPSIS\n\n  #----------\n  #SCENARIO 1\n  #----------\n\n  #make an ontology object manually. via OntologyIO\n  my $io = Bio::OntologyIO->new(\n                                #params to fetch Cell Ontology here\n                               );\n  my $cell_ontology = $io->next_ontology;\n\n  #this is a singleton that caches the fact that you've created\n  #a 'Cell Ontology' intance...\n  my $store = Bio::Ontology::OntologyStore->get_instance();\n\n  #...and it can hand you back a copy of it at any time.\n  my $cell_ontology_copy = $store->get_ontology('Cell Ontology');\n\n\n  #----------\n  #SCENARIO 2\n  #----------\n\n  my $store = Bio::Ontology::OntologyStore->get_instance();\n  #this use case allows the construction of an ontology on\n  #demand just by supplying the name.\n  my $ontology = $store->get_ontology('Sequence Ontology');\n\n\n=head1 DESCRIPTION\n\nThe primary purpose of this module is that of a singleton repository\nof L<Bio::Ontology::OntologyI> instances from which an Ontology\ninstance can be retrieved by name or identifier. This enables TermI\nimplementations to return their corresponding OntologyI through using\nthis singleton store instead of storing a direct reference to the\nOntology object. The latter would almost inevitably lead to memory\ncycles, and would therefore potentially blow up an application.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\n  Hilmar Lapp E<lt>hlapp@gmx.netE<gt>\n  Allen Day E<lt>allenday@ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::OntologyStore;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Ontology::DocumentRegistry;\nuse Bio::OntologyIO;\nuse FileHandle;\nuse File::Spec::Functions;\n\n\nuse base qw(Bio::Root::Root);\n\n# these are the static ontology stores by name and by identifier - there is\n# only one of each in any application\nmy %ont_store_by_name = ();\nmy %ont_store_by_id = ();\nmy %ont_aliases = (\n                   'Gene Ontology' => 'Gene_Ontology'\n                    );\n# also, this is really meant as a singleton object, so we try to enforce it\nmy $instance = undef;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Ontology::OntologyStore->new();\n Function: Returns the Bio::Ontology::OntologyStore object.\n\n           Unlike usual implementations of new, this implementation\n           will try to return a previously instantiated store, if\n           there is any. It is just a synonym for get_instance. In\n           order to avoid ambiguities in your code, you may rather\n           want to call rather get_instance explicitly, which also\n           usually is better associated with this kind of behaviour.\n\n Returns : an instance of Bio::Ontology::OntologyStore\n Args    :\n\n\nsub new {\n    return shift->get_instance(@_);\n}\n\n=head2 get_instance\n\n Title   : get_instance\n Usage   :\n Function: Get an instance of this class for perusal.\n\n           Since by design this class is meant to be used as a\n           singleton, the implementation will return a previously\n           instantianted store if there is one, and instantiate a new\n           one otherwise. In order to use this class by means of an\n           instance, call this method for added code clarity, not\n           new().\n\n Example :\n Returns : an instance of this class\n Args    : named parameters, if any (currently, there are no \n           class-specific parameters other than those accepted by\n           Bio::Root::Root.\n\nSee L<Bio::Root::Root>.\n\n\nsub get_instance{\n   my ($self,@args) = @_;\n\n   if(! $instance) {\n       $instance = $self->SUPER::new(@args);\n   }\n   return $instance;\n}\n\n=head2 get_ontology\n\n Title   : get_ontology\n Usage   :\n Function: Get a previously instantiated and registered instance of\n           this class by name or by identifier. \n\n           One of the main purposes of this class is to enable TermI\n           implementations to return their respective ontology without\n           keeping a strong reference to the respective ontology\n           object. Only objects previously registered objects can be\n           retrieved.\n\n           This is a class method, hence you can call it on the class\n           name, without dereferencing an object.\n\n Example :\n Returns : a Bio::Ontology::OntologyI implementing object, or undef\n           if the query could not be satisfied\n Args    : Named parameters specifying the query. The following parameters\n           are recognized:\n              -name   query the store for an ontology with the given name\n              -id     query for an ontology with the given identifier\n           If both are specified, an implicit AND logical operator is\n           assumed.\n\nSee L<Bio::Ontology::OntologyI>.","label":"get_ontology($self,@args)"},"containerName":"main::","name":"get_ontology","children":[{"line":212,"localvar":"my","kind":13,"containerName":"get_ontology","name":"$self","definition":"my"},{"containerName":"get_ontology","kind":13,"name":"@args","line":212},{"name":"$ont","localvar":"my","containerName":"get_ontology","kind":13,"line":213,"definition":"my"},{"localvar":"my","kind":13,"containerName":"get_ontology","name":"$name","line":215,"definition":"my"},{"line":215,"containerName":"get_ontology","kind":13,"name":"$id"},{"containerName":"get_ontology","kind":13,"name":"$self","line":215},{"line":215,"name":"_rearrange","kind":12,"containerName":"get_ontology"},{"name":"@args","containerName":"get_ontology","kind":13,"line":215},{"line":216,"name":"$id","containerName":"get_ontology","kind":13},{"name":"$ont","kind":13,"containerName":"get_ontology","line":217},{"name":"$ont_store_by_id","containerName":"get_ontology","kind":13,"line":217},{"line":217,"name":"$id","containerName":"get_ontology","kind":13},{"kind":13,"containerName":"get_ontology","name":"$ont","line":218},{"kind":13,"containerName":"get_ontology","name":"$name","line":221},{"line":222,"name":"$o","kind":13,"localvar":"my","containerName":"get_ontology","definition":"my"},{"line":222,"name":"$ont_store_by_name","containerName":"get_ontology","kind":13},{"name":"$name","containerName":"get_ontology","kind":13,"line":222},{"containerName":"get_ontology","kind":13,"name":"$o","line":224},{"definition":"my","name":"$doc_registry","containerName":"get_ontology","localvar":"my","kind":13,"line":225},{"kind":12,"containerName":"get_ontology","name":"get_instance","line":225},{"line":226,"name":"$url","containerName":"get_ontology","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"get_ontology","name":"$def","line":226},{"line":226,"kind":13,"containerName":"get_ontology","name":"$fmt"},{"line":226,"name":"$doc_registry","kind":13,"containerName":"get_ontology"},{"line":226,"name":"documents","containerName":"get_ontology","kind":12},{"line":226,"name":"$name","containerName":"get_ontology","kind":13},{"name":"$url","containerName":"get_ontology","kind":13,"line":228},{"definition":"my","name":"$io","localvar":"my","containerName":"get_ontology","kind":13,"line":229},{"line":229,"kind":12,"containerName":"get_ontology","name":"new"},{"name":"$url","kind":13,"containerName":"get_ontology","line":229},{"name":"$def","containerName":"get_ontology","kind":13,"line":230},{"name":"$fmt","containerName":"get_ontology","kind":13,"line":231},{"line":234,"containerName":"get_ontology","kind":13,"name":"$o"},{"line":234,"name":"$io","containerName":"get_ontology","kind":13},{"name":"next_ontology","kind":12,"containerName":"get_ontology","line":234},{"name":"$ont_store_by_name","containerName":"get_ontology","kind":13,"line":235},{"line":235,"containerName":"get_ontology","kind":13,"name":"$name"},{"line":235,"name":"$o","containerName":"get_ontology","kind":13},{"kind":13,"containerName":"get_ontology","name":"$url","line":236},{"definition":"my","line":237,"localvar":"my","containerName":"get_ontology","kind":13,"name":"$io"},{"line":237,"name":"new","containerName":"get_ontology","kind":12},{"containerName":"get_ontology","kind":13,"name":"$url","line":237},{"kind":13,"containerName":"get_ontology","name":"$def","line":238},{"kind":13,"containerName":"get_ontology","name":"$fmt","line":239},{"kind":13,"containerName":"get_ontology","name":"$o","line":241},{"containerName":"get_ontology","kind":13,"name":"$io","line":241},{"name":"next_ontology","containerName":"get_ontology","kind":12,"line":241},{"line":242,"name":"$ont_store_by_name","containerName":"get_ontology","kind":13},{"name":"$name","kind":13,"containerName":"get_ontology","line":242},{"kind":13,"containerName":"get_ontology","name":"$o","line":242},{"name":"$ont","containerName":"get_ontology","kind":13,"line":246},{"line":246,"name":"$ont","kind":13,"containerName":"get_ontology"},{"name":"identifier","kind":12,"containerName":"get_ontology","line":246},{"kind":13,"containerName":"get_ontology","name":"$o","line":246},{"line":246,"kind":12,"containerName":"get_ontology","name":"identifier"},{"line":247,"name":"$ont","containerName":"get_ontology","kind":13},{"containerName":"get_ontology","kind":13,"name":"$o","line":247},{"name":"$ont","containerName":"get_ontology","kind":13,"line":249},{"kind":13,"containerName":"get_ontology","name":"$ont","line":253}],"detail":"($self,@args)","definition":"sub"},{"name":"Bio","containerName":"Ontology::DocumentRegistry","kind":12,"line":225},{"line":229,"name":"Bio","kind":12,"containerName":"OntologyIO"},{"name":"Bio","containerName":"OntologyIO","kind":12,"line":237},{"children":[{"definition":"my","name":"$self","containerName":"register_ontology","localvar":"my","kind":13,"line":272},{"line":272,"containerName":"register_ontology","kind":13,"name":"@args"},{"definition":"my","line":273,"kind":13,"localvar":"my","containerName":"register_ontology","name":"$ret"},{"kind":13,"localvar":"my","containerName":"register_ontology","name":"$ont","line":274,"definition":"my"},{"name":"@args","containerName":"register_ontology","kind":13,"line":274},{"line":275,"containerName":"register_ontology","kind":13,"name":"$ont"},{"name":"$ont","containerName":"register_ontology","kind":13,"line":275},{"containerName":"register_ontology","kind":12,"name":"isa","line":275},{"kind":13,"containerName":"register_ontology","name":"$ont_store_by_name","line":276},{"containerName":"register_ontology","kind":13,"name":"$ont","line":276},{"name":"name","kind":12,"containerName":"register_ontology","line":276},{"line":276,"containerName":"register_ontology","kind":13,"name":"$ont"},{"line":276,"name":"$ont","kind":13,"containerName":"register_ontology"},{"kind":12,"containerName":"register_ontology","name":"name","line":276},{"line":280,"kind":13,"containerName":"register_ontology","name":"$ont"},{"line":280,"name":"$ont","kind":13,"containerName":"register_ontology"},{"line":280,"name":"isa","containerName":"register_ontology","kind":12},{"name":"$self","containerName":"register_ontology","kind":13,"line":281},{"name":"throw","containerName":"register_ontology","kind":12,"line":281},{"line":281,"containerName":"register_ontology","kind":13,"name":"$ont"},{"name":"$ont","containerName":"register_ontology","kind":13,"line":281},{"line":281,"kind":13,"containerName":"register_ontology","name":"$ont"},{"kind":13,"containerName":"register_ontology","name":"$self","line":284},{"line":284,"name":"get_ontology","kind":12,"containerName":"register_ontology"},{"line":284,"name":"$ont","containerName":"register_ontology","kind":13},{"line":284,"name":"name","containerName":"register_ontology","kind":12},{"name":"$self","containerName":"register_ontology","kind":13,"line":285},{"line":285,"name":"warn","containerName":"register_ontology","kind":12},{"name":"$ont","kind":13,"containerName":"register_ontology","line":285},{"containerName":"register_ontology","kind":12,"name":"name","line":285},{"line":287,"containerName":"register_ontology","kind":13,"name":"$ret"},{"name":"$self","kind":13,"containerName":"register_ontology","line":290},{"name":"get_ontology","kind":12,"containerName":"register_ontology","line":290},{"kind":13,"containerName":"register_ontology","name":"$ont","line":290},{"containerName":"register_ontology","kind":12,"name":"identifier","line":290},{"name":"$self","containerName":"register_ontology","kind":13,"line":291},{"line":291,"kind":12,"containerName":"register_ontology","name":"warn"},{"kind":13,"containerName":"register_ontology","name":"$ont","line":291},{"name":"identifier","containerName":"register_ontology","kind":12,"line":291},{"kind":13,"containerName":"register_ontology","name":"$ret","line":293},{"line":296,"containerName":"register_ontology","kind":13,"name":"$ont_store_by_name"},{"line":296,"name":"$ont","kind":13,"containerName":"register_ontology"},{"containerName":"register_ontology","kind":12,"name":"name","line":296},{"line":296,"name":"$ont","containerName":"register_ontology","kind":13},{"line":297,"containerName":"register_ontology","kind":13,"name":"$ont_store_by_id"},{"name":"$ont","containerName":"register_ontology","kind":13,"line":297},{"line":297,"kind":12,"containerName":"register_ontology","name":"identifier"},{"line":297,"containerName":"register_ontology","kind":13,"name":"$ont"},{"containerName":"register_ontology","kind":13,"name":"$ret","line":299}],"name":"register_ontology","containerName":"main::","definition":"sub","detail":"($self,@args)","line":271,"kind":12,"range":{"start":{"line":271,"character":0},"end":{"line":300,"character":9999}},"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: OntologyStore.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::OntologyStore\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::OntologyStore - A repository of ontologies\n\n=head1 SYNOPSIS\n\n  #----------\n  #SCENARIO 1\n  #----------\n\n  #make an ontology object manually. via OntologyIO\n  my $io = Bio::OntologyIO->new(\n                                #params to fetch Cell Ontology here\n                               );\n  my $cell_ontology = $io->next_ontology;\n\n  #this is a singleton that caches the fact that you've created\n  #a 'Cell Ontology' intance...\n  my $store = Bio::Ontology::OntologyStore->get_instance();\n\n  #...and it can hand you back a copy of it at any time.\n  my $cell_ontology_copy = $store->get_ontology('Cell Ontology');\n\n\n  #----------\n  #SCENARIO 2\n  #----------\n\n  my $store = Bio::Ontology::OntologyStore->get_instance();\n  #this use case allows the construction of an ontology on\n  #demand just by supplying the name.\n  my $ontology = $store->get_ontology('Sequence Ontology');\n\n\n=head1 DESCRIPTION\n\nThe primary purpose of this module is that of a singleton repository\nof L<Bio::Ontology::OntologyI> instances from which an Ontology\ninstance can be retrieved by name or identifier. This enables TermI\nimplementations to return their corresponding OntologyI through using\nthis singleton store instead of storing a direct reference to the\nOntology object. The latter would almost inevitably lead to memory\ncycles, and would therefore potentially blow up an application.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\n  Hilmar Lapp E<lt>hlapp@gmx.netE<gt>\n  Allen Day E<lt>allenday@ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::OntologyStore;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Ontology::DocumentRegistry;\nuse Bio::OntologyIO;\nuse FileHandle;\nuse File::Spec::Functions;\n\n\nuse base qw(Bio::Root::Root);\n\n# these are the static ontology stores by name and by identifier - there is\n# only one of each in any application\nmy %ont_store_by_name = ();\nmy %ont_store_by_id = ();\nmy %ont_aliases = (\n                   'Gene Ontology' => 'Gene_Ontology'\n                    );\n# also, this is really meant as a singleton object, so we try to enforce it\nmy $instance = undef;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Ontology::OntologyStore->new();\n Function: Returns the Bio::Ontology::OntologyStore object.\n\n           Unlike usual implementations of new, this implementation\n           will try to return a previously instantiated store, if\n           there is any. It is just a synonym for get_instance. In\n           order to avoid ambiguities in your code, you may rather\n           want to call rather get_instance explicitly, which also\n           usually is better associated with this kind of behaviour.\n\n Returns : an instance of Bio::Ontology::OntologyStore\n Args    :\n\n\nsub new {\n    return shift->get_instance(@_);\n}\n\n=head2 get_instance\n\n Title   : get_instance\n Usage   :\n Function: Get an instance of this class for perusal.\n\n           Since by design this class is meant to be used as a\n           singleton, the implementation will return a previously\n           instantianted store if there is one, and instantiate a new\n           one otherwise. In order to use this class by means of an\n           instance, call this method for added code clarity, not\n           new().\n\n Example :\n Returns : an instance of this class\n Args    : named parameters, if any (currently, there are no \n           class-specific parameters other than those accepted by\n           Bio::Root::Root.\n\nSee L<Bio::Root::Root>.\n\n\nsub get_instance{\n   my ($self,@args) = @_;\n\n   if(! $instance) {\n       $instance = $self->SUPER::new(@args);\n   }\n   return $instance;\n}\n\n=head2 get_ontology\n\n Title   : get_ontology\n Usage   :\n Function: Get a previously instantiated and registered instance of\n           this class by name or by identifier. \n\n           One of the main purposes of this class is to enable TermI\n           implementations to return their respective ontology without\n           keeping a strong reference to the respective ontology\n           object. Only objects previously registered objects can be\n           retrieved.\n\n           This is a class method, hence you can call it on the class\n           name, without dereferencing an object.\n\n Example :\n Returns : a Bio::Ontology::OntologyI implementing object, or undef\n           if the query could not be satisfied\n Args    : Named parameters specifying the query. The following parameters\n           are recognized:\n              -name   query the store for an ontology with the given name\n              -id     query for an ontology with the given identifier\n           If both are specified, an implicit AND logical operator is\n           assumed.\n\nSee L<Bio::Ontology::OntologyI>.\n\n\nsub get_ontology{\n  my ($self,@args) = @_;\n  my $ont;\n\n  my ($name,$id) = $self->_rearrange([qw(NAME ID)], @args);\n  if($id) {\n    $ont = $ont_store_by_id{$id};\n    return unless $ont; # no AND can be satisfied in this case\n  }\n\n  if($name) {\n    my $o = $ont_store_by_name{$name};\n\n    if(!$o){\n      my $doc_registry = Bio::Ontology::DocumentRegistry->get_instance();\n      my($url,$def,$fmt) = $doc_registry->documents($name);\n\n      if(ref($url) eq 'ARRAY'){\n        my $io = Bio::OntologyIO->new(-url      => $url,\n                                      -defs_url => $def,\n                                      -format   => $fmt,\n                                     );\n\n        $o = $io->next_ontology();\n        $ont_store_by_name{$name} = $o;\n      } elsif($url){\n        my $io = Bio::OntologyIO->new(-url      => $url,\n                                      -defs_url => $def,\n                                      -format   => $fmt,\n                                     );\n        $o = $io->next_ontology;\n        $ont_store_by_name{$name} = $o;\n      }\n    }\n\n    if((! $ont) || ($ont->identifier() eq $o->identifier())) {\n      $ont = $o;\n    } else {\n      $ont = undef;\n    }\n  }\n  \n  return $ont;\n}\n\n=head2 register_ontology\n\n Title   : register_ontology\n Usage   :\n Function: Registers the given Ontology object for later retrieval\n           by name and identifier.\n\n Example :\n Returns : TRUE on success and FALSE otherwise\n Args    : the Bio::Ontology::OntologyI object(s) to register\n\nSee L<Bio::Ontology::OntologyI>.","label":"register_ontology($self,@args)"}},{"definition":"sub","children":[{"line":317,"localvar":"my","containerName":"remove_ontology","kind":13,"name":"$self","definition":"my"},{"name":"$ret","containerName":"remove_ontology","localvar":"my","kind":13,"line":318,"definition":"my"},{"name":"$ont","localvar":"my","kind":13,"containerName":"remove_ontology","line":320,"definition":"my"},{"line":321,"containerName":"remove_ontology","kind":13,"name":"$self"},{"containerName":"remove_ontology","kind":12,"name":"throw","line":321},{"name":"$ont","kind":13,"containerName":"remove_ontology","line":321},{"kind":13,"containerName":"remove_ontology","name":"$ont","line":322},{"containerName":"remove_ontology","kind":13,"name":"$ont","line":322},{"line":322,"containerName":"remove_ontology","kind":13,"name":"$ont"},{"containerName":"remove_ontology","kind":12,"name":"isa","line":322},{"kind":13,"containerName":"remove_ontology","name":"$ont_store_by_id","line":324},{"kind":13,"containerName":"remove_ontology","name":"$ont","line":324},{"kind":12,"containerName":"remove_ontology","name":"identifier","line":324},{"line":325,"kind":13,"containerName":"remove_ontology","name":"$ont_store_by_name"},{"containerName":"remove_ontology","kind":13,"name":"$ont","line":325},{"line":325,"name":"name","containerName":"remove_ontology","kind":12},{"name":"$ont","containerName":"remove_ontology","kind":13,"line":325},{"name":"name","containerName":"remove_ontology","kind":12,"line":325}],"containerName":"main::","name":"remove_ontology","line":316,"range":{"start":{"character":0,"line":316},"end":{"line":328,"character":9999}},"kind":12},{"containerName":"main::","name":"guess_ontology","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"guess_ontology","line":345},{"line":345,"kind":13,"containerName":"guess_ontology","name":"$id"},{"line":347,"name":"$prefix","containerName":"guess_ontology","localvar":"my","kind":13,"definition":"my"},{"line":347,"kind":13,"containerName":"guess_ontology","name":"$id"},{"localvar":"my","kind":13,"containerName":"guess_ontology","name":"%prefix","line":349,"definition":"my"},{"line":355,"containerName":"guess_ontology","kind":13,"name":"$prefix"},{"name":"$prefix","containerName":"guess_ontology","kind":13,"line":355}],"detail":"($self,$id)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":344},"end":{"character":9999,"line":356}},"line":344,"signature":{"label":"guess_ontology($self,$id)","parameters":[{"label":"$self"},{"label":"$id"}],"documentation":"1;\n# $Id: OntologyStore.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::OntologyStore\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::OntologyStore - A repository of ontologies\n\n=head1 SYNOPSIS\n\n  #----------\n  #SCENARIO 1\n  #----------\n\n  #make an ontology object manually. via OntologyIO\n  my $io = Bio::OntologyIO->new(\n                                #params to fetch Cell Ontology here\n                               );\n  my $cell_ontology = $io->next_ontology;\n\n  #this is a singleton that caches the fact that you've created\n  #a 'Cell Ontology' intance...\n  my $store = Bio::Ontology::OntologyStore->get_instance();\n\n  #...and it can hand you back a copy of it at any time.\n  my $cell_ontology_copy = $store->get_ontology('Cell Ontology');\n\n\n  #----------\n  #SCENARIO 2\n  #----------\n\n  my $store = Bio::Ontology::OntologyStore->get_instance();\n  #this use case allows the construction of an ontology on\n  #demand just by supplying the name.\n  my $ontology = $store->get_ontology('Sequence Ontology');\n\n\n=head1 DESCRIPTION\n\nThe primary purpose of this module is that of a singleton repository\nof L<Bio::Ontology::OntologyI> instances from which an Ontology\ninstance can be retrieved by name or identifier. This enables TermI\nimplementations to return their corresponding OntologyI through using\nthis singleton store instead of storing a direct reference to the\nOntology object. The latter would almost inevitably lead to memory\ncycles, and would therefore potentially blow up an application.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\n  Hilmar Lapp E<lt>hlapp@gmx.netE<gt>\n  Allen Day E<lt>allenday@ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::OntologyStore;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Ontology::DocumentRegistry;\nuse Bio::OntologyIO;\nuse FileHandle;\nuse File::Spec::Functions;\n\n\nuse base qw(Bio::Root::Root);\n\n# these are the static ontology stores by name and by identifier - there is\n# only one of each in any application\nmy %ont_store_by_name = ();\nmy %ont_store_by_id = ();\nmy %ont_aliases = (\n                   'Gene Ontology' => 'Gene_Ontology'\n                    );\n# also, this is really meant as a singleton object, so we try to enforce it\nmy $instance = undef;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Ontology::OntologyStore->new();\n Function: Returns the Bio::Ontology::OntologyStore object.\n\n           Unlike usual implementations of new, this implementation\n           will try to return a previously instantiated store, if\n           there is any. It is just a synonym for get_instance. In\n           order to avoid ambiguities in your code, you may rather\n           want to call rather get_instance explicitly, which also\n           usually is better associated with this kind of behaviour.\n\n Returns : an instance of Bio::Ontology::OntologyStore\n Args    :\n\n\nsub new {\n    return shift->get_instance(@_);\n}\n\n=head2 get_instance\n\n Title   : get_instance\n Usage   :\n Function: Get an instance of this class for perusal.\n\n           Since by design this class is meant to be used as a\n           singleton, the implementation will return a previously\n           instantianted store if there is one, and instantiate a new\n           one otherwise. In order to use this class by means of an\n           instance, call this method for added code clarity, not\n           new().\n\n Example :\n Returns : an instance of this class\n Args    : named parameters, if any (currently, there are no \n           class-specific parameters other than those accepted by\n           Bio::Root::Root.\n\nSee L<Bio::Root::Root>.\n\n\nsub get_instance{\n   my ($self,@args) = @_;\n\n   if(! $instance) {\n       $instance = $self->SUPER::new(@args);\n   }\n   return $instance;\n}\n\n=head2 get_ontology\n\n Title   : get_ontology\n Usage   :\n Function: Get a previously instantiated and registered instance of\n           this class by name or by identifier. \n\n           One of the main purposes of this class is to enable TermI\n           implementations to return their respective ontology without\n           keeping a strong reference to the respective ontology\n           object. Only objects previously registered objects can be\n           retrieved.\n\n           This is a class method, hence you can call it on the class\n           name, without dereferencing an object.\n\n Example :\n Returns : a Bio::Ontology::OntologyI implementing object, or undef\n           if the query could not be satisfied\n Args    : Named parameters specifying the query. The following parameters\n           are recognized:\n              -name   query the store for an ontology with the given name\n              -id     query for an ontology with the given identifier\n           If both are specified, an implicit AND logical operator is\n           assumed.\n\nSee L<Bio::Ontology::OntologyI>.\n\n\nsub get_ontology{\n  my ($self,@args) = @_;\n  my $ont;\n\n  my ($name,$id) = $self->_rearrange([qw(NAME ID)], @args);\n  if($id) {\n    $ont = $ont_store_by_id{$id};\n    return unless $ont; # no AND can be satisfied in this case\n  }\n\n  if($name) {\n    my $o = $ont_store_by_name{$name};\n\n    if(!$o){\n      my $doc_registry = Bio::Ontology::DocumentRegistry->get_instance();\n      my($url,$def,$fmt) = $doc_registry->documents($name);\n\n      if(ref($url) eq 'ARRAY'){\n        my $io = Bio::OntologyIO->new(-url      => $url,\n                                      -defs_url => $def,\n                                      -format   => $fmt,\n                                     );\n\n        $o = $io->next_ontology();\n        $ont_store_by_name{$name} = $o;\n      } elsif($url){\n        my $io = Bio::OntologyIO->new(-url      => $url,\n                                      -defs_url => $def,\n                                      -format   => $fmt,\n                                     );\n        $o = $io->next_ontology;\n        $ont_store_by_name{$name} = $o;\n      }\n    }\n\n    if((! $ont) || ($ont->identifier() eq $o->identifier())) {\n      $ont = $o;\n    } else {\n      $ont = undef;\n    }\n  }\n  \n  return $ont;\n}\n\n=head2 register_ontology\n\n Title   : register_ontology\n Usage   :\n Function: Registers the given Ontology object for later retrieval\n           by name and identifier.\n\n Example :\n Returns : TRUE on success and FALSE otherwise\n Args    : the Bio::Ontology::OntologyI object(s) to register\n\nSee L<Bio::Ontology::OntologyI>.\n\n\nsub register_ontology {\n  my ($self,@args) = @_;\n  my $ret = 1;\n  foreach my $ont (@args) {\n    if(ref($ont) && $ont->isa('Bio::Ontology::OntologyI')){\n      $ont_store_by_name{$ont->name()} = $ont if $ont->name;\n      next;\n    }\n\n\tif(! (ref($ont) && $ont->isa(\"Bio::Ontology::OntologyI\"))) {\n      $self->throw((ref($ont) ? ref($ont) : $ont).\" does not implement \".\n                   \"Bio::Ontology::OntologyI or is not an object\");\n\t}\n\tif($self->get_ontology(-name => $ont->name())) {\n      $self->warn(\"ontology with name \\\"\".$ont->name().\n                  \"\\\" already exists in the store, ignoring new one\");\n      $ret = 0;\n      next;\n\t}\n\tif($self->get_ontology(-id => $ont->identifier())) {\n      $self->warn(\"ontology with id \\\"\".$ont->identifier().\n                  \"\\\" already exists in the store, ignoring new one\");\n      $ret = 0;\n      next;\n\t}\n\t$ont_store_by_name{$ont->name()} = $ont;\n\t$ont_store_by_id{$ont->identifier()} = $ont;\n  }\n  return $ret;\n}\n\n=head2 remove_ontology\n\n Title   : remove_ontology\n Usage   :\n Function: Remove the specified ontology from the store.\n Example :\n Returns : TRUE on success and FALSE otherwise\n Args    : the Bio::Ontology::OntologyI implementing object(s)\n           to be removed from the store\n\nSee L<Bio::Ontology::OntologyI>.\n\n\nsub remove_ontology{\n    my $self = shift;\n    my $ret = 1;\n\n    foreach my $ont (@_) {\n\t$self->throw(ref($ont).\" does not implement Bio::Ontology::OntologyI\")\n\t    unless $ont && ref($ont) && $ont->isa(\"Bio::Ontology::OntologyI\");\n\t# remove it from both the id hash and the name hash\n\tdelete $ont_store_by_id{$ont->identifier()};\n\tdelete $ont_store_by_name{$ont->name()} if $ont->name();\n    }\n    return 1;\n}\n\n=head2 guess_ontology()\n\n Usage   : my $ontology = \n           Bio::Ontology::OntologyStore->guess_ontology('GO:0000001');\n Function: tries to guess which ontology a term identifier comes from, \n           loads it as necessary,\n           and returns it as a Bio::Ontology::Ontology object.\n Example :\n Returns : a Bio::Ontology::Ontology object, or warns and returns undef\n Args    : an ontology term identifier in XXXX:DDDDDDD format.  \n           Guessing is based on the XXXX string before the colon."}},{"kind":12,"name":"SO","line":350},{"line":351,"name":"SOFA","kind":12},{"line":352,"name":"GO","kind":12}],"version":5}