{"version":5,"vars":[{"line":130,"containerName":"","kind":2,"name":"base"},{"line":132,"name":"@Bio","containerName":null,"kind":13},{"line":132,"name":"Matrix","kind":12,"containerName":"PSM::Psm::HEADER"},{"containerName":"main::","name":"new","children":[{"line":153,"localvar":"my","kind":13,"containerName":"new","name":"$caller","definition":"my"},{"name":"@args","containerName":"new","kind":13,"line":153},{"containerName":"new","localvar":"my","kind":13,"name":"$class","line":154,"definition":"my"},{"kind":13,"containerName":"new","name":"$caller","line":154},{"containerName":"new","kind":13,"name":"$caller","line":154},{"definition":"my","line":155,"name":"$self","localvar":"my","containerName":"new","kind":13},{"line":155,"name":"$class","kind":13,"containerName":"new"},{"line":155,"containerName":"new","kind":13,"name":"@args"},{"line":156,"containerName":"new","kind":13,"name":"$self"},{"name":"$self","containerName":"new","kind":13,"line":157},{"kind":12,"containerName":"new","name":"_typemap","line":157},{"name":"new","containerName":"new","kind":12,"line":157},{"name":"$self","kind":13,"containerName":"new","line":158},{"name":"$self","kind":13,"containerName":"new","line":158},{"name":"_rearrange","containerName":"new","kind":12,"line":158},{"line":158,"kind":13,"containerName":"new","name":"@args"},{"line":159,"kind":13,"containerName":"new","name":"$self"}],"detail":"($caller,@args)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":152},"end":{"character":9999,"line":160}},"line":152,"signature":{"label":"new($caller,@args)","documentation":"1;\n#---------------------------------------------------------\n# $Id: Psm.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n#ISA SiteMatrix, HAS InstanceSite\n\n=head1 NAME\n\nBio::Matrix::PSM::Psm - handle combination of site matricies\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::PSM::IO;\n\n  #To get a Psm object from a file use the Psm parser:\n  my $psmIO =  Bio::Matrix::PSM::IO->new(-format=>'meme', -file=>$file);\n\n  # Now go through all entities in the file with next_psm, which\n  # returns a Psm object see Bio::Matrix::PSM::IO for detailed\n  # documentation (matrix predictions or matrix sequence matches or\n  # both):\n\n  while (my $psm=$psmIO->next_psm) {\n    my %psm_header=$psm->header;\n    my $ic=$psm_header{IC};\n    my $sites=$psm_header{sites};\n    my $width=$psm_header{width};\n    my $score=$psm_header{e_val};\n    my $IUPAC=$psm->IUPAC;\n    my $instances=$psm->instances;\n    foreach my $instance (@{$instances}) {\n      my $id=$instance->primary_id;\n      #Do something with the id\n    }\n  }\n\n #or create from memmory:\n  my $psm= Bio::Matrix::PSM::Psm->new( -pA=>\\@pA,-pC=>\\@pC,-pG=>\\@pG,-pT=>\\@pT,\n       -id=>$id,\n       -instances=>$instances, -e_val=>$e_val,\n       -IC=>$ic, -width=>$width, -sites=>$sites)\n\n  # where pA through pG are the respective frequencies of the matrix (see also\n  # Bio::Matrix::PSM::SiteMatrix), and everything else is self-explenatory, \n  # except for -instances (reference to an array of \n  #  Bio::Matrix::PSM::InstanceSite objects) which is documented bellow.\n\n=head1 DESCRIPTION\n\nTo handle a combination of site matrices and/or their corresponding\nsequence matches (instances). This object inherits from\nBio::Matrix::PSM::SiteMatrix, so you can use the respective\nmethods. It may hold also an array of Bio::Matrix::PSM::InstanceSite\nobject, but you will have to retrieve these through\nBio::Matrix::PSM::Psm-E<gt>instances method (see below). To some extent\nthis is an expanded SiteMatrix object, holding data from analysis that\nalso deal with sequence matches of a particular matrix.\n\n\n=head2 DESIGN ISSUES\n\nThis does not make too much sense to me I am mixing PSM with PSM\nsequence matches Though they are very closely related, I am not\nsatisfied by the way this is implemented here.  Heikki suggested\ndifferent objects when one has something like meme But does this mean\nwe have to write a different objects for mast, meme, transfac,\ntheiresias, etc.?  To me the best way is to return SiteMatrix object +\narrray of InstanceSite objects and then mast will return undef for\nSiteMatrix and transfac will return undef for InstanceSite. Probably I\ncannot see some other design issues that might arise from such\napproach, but it seems more straightforward.  Hilmar does not like\nthis beacause it is an exception from the general BioPerl rules Should\nI leave this as an option?  Also the header rightfully belongs the\ndriver object, and could be retrieved as hashes.  I do not think it\ncan be done any other way, unless we want to create even one more\nobject with very unclear content.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 SEE ALSO\n\nSiteMatrix, meme, transfac, InstanceSite\n\n=head1 APPENDIX\n\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::Psm;\nuse Bio::Matrix::PSM::InstanceSite;\nuse strict;\n\nuse base qw(Bio::Matrix::PSM::SiteMatrix Bio::Matrix::PSM::PsmI Bio::Annotation::Collection);\n\n@Bio::Matrix::PSM::Psm::HEADER = qw(e_val sites IC width);\n\n=head2 new\n\n Title   : new\n Usage   : my $psm= Bio::Matrix::PSM::Psm->new( -pA=>\\@pA,-pC=>\\@pC,\n\t\t\t\t\t       -pG=>\\@pG,-pT=>\\@pT,-id=>$id,\n\t\t\t\t\t       -instances=>$instances, \n\t\t\t\t\t       -e_val=>$e_val,\n\t\t\t\t\t       -IC=>$ic, -width=>$width, \n\t\t\t\t\t       -sites=>$sites)\n Function: Creates a new Bio::Matrix::PSM::Psm object\n Throws  :\n Example :\n Returns :  Bio::Matrix::PSM::Psm object\n Args    :  hash","parameters":[{"label":"$caller"},{"label":"@args"}]}},{"name":"SUPER","kind":12,"containerName":"new","line":155},{"line":157,"kind":12,"containerName":"Annotation::TypeManager","name":"Bio"},{"kind":12,"name":"instances","line":158},{"children":[{"definition":"my","localvar":"my","kind":13,"containerName":"instances","name":"$self","line":177},{"definition":"my","kind":13,"localvar":"my","containerName":"instances","name":"$prev","line":178},{"line":178,"name":"$self","kind":13,"containerName":"instances"},{"containerName":"instances","kind":13,"name":"$self","line":179},{"line":180,"kind":13,"containerName":"instances","name":"$prev"}],"name":"instances","containerName":"main::","definition":"sub","line":176,"range":{"end":{"character":9999,"line":181},"start":{"character":0,"line":176}},"kind":12},{"line":178,"kind":12,"name":"instances"},{"line":179,"name":"instances","kind":12},{"line":203,"range":{"start":{"character":0,"line":203},"end":{"line":212,"character":9999}},"kind":12,"definition":"sub","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"header","line":204},{"line":205,"name":"$self","containerName":"header","kind":13},{"localvar":"my","containerName":"header","kind":13,"name":"%header","line":206,"definition":"my"},{"name":"$key","localvar":"my","kind":13,"containerName":"header","line":207,"definition":"my"},{"name":"$self","kind":13,"containerName":"header","line":207},{"line":207,"kind":13,"containerName":"header","name":"$key"},{"name":"$key","containerName":"header","localvar":"my","kind":13,"line":208,"definition":"my"},{"kind":13,"containerName":"header","name":"@Bio","line":208},{"name":"$header","kind":13,"containerName":"header","line":209},{"line":209,"name":"$key","kind":13,"containerName":"header"},{"line":209,"name":"$self","kind":13,"containerName":"header"},{"containerName":"header","kind":13,"name":"$key","line":209},{"containerName":"header","kind":13,"name":"%header","line":211}],"containerName":"main::","name":"header"},{"line":205,"kind":12,"name":"end"},{"line":208,"name":"Matrix","kind":12,"containerName":"PSM::Psm::HEADER"},{"definition":"sub","name":"matrix","containerName":"main::","children":[{"definition":"my","line":229,"name":"$self","localvar":"my","kind":13,"containerName":"matrix"},{"localvar":"my","containerName":"matrix","kind":13,"name":"$prev","line":230,"definition":"my"},{"name":"new","containerName":"matrix","kind":12,"line":230},{"line":230,"containerName":"matrix","kind":13,"name":"$self"},{"line":231,"containerName":"matrix","kind":13,"name":"$self"},{"line":232,"kind":13,"containerName":"matrix","name":"$self"},{"name":"$self","kind":13,"containerName":"matrix","line":233},{"kind":13,"containerName":"matrix","name":"$self","line":234},{"kind":13,"containerName":"matrix","name":"$self","line":235},{"containerName":"matrix","kind":13,"name":"$self","line":236},{"line":237,"kind":13,"containerName":"matrix","name":"$self"},{"name":"$self","containerName":"matrix","kind":13,"line":238},{"name":"$self","kind":13,"containerName":"matrix","line":239},{"line":240,"kind":13,"containerName":"matrix","name":"$self"},{"kind":13,"localvar":"my","containerName":"matrix","name":"$matrix","line":242,"definition":"my"},{"kind":13,"containerName":"matrix","name":"$self","line":243},{"name":"$matrix","kind":13,"containerName":"matrix","line":243},{"name":"IC","containerName":"matrix","kind":12,"line":243},{"line":244,"name":"$self","kind":13,"containerName":"matrix"},{"line":244,"name":"$matrix","containerName":"matrix","kind":13},{"name":"$self","kind":13,"containerName":"matrix","line":245},{"containerName":"matrix","kind":13,"name":"$matrix","line":245},{"kind":13,"containerName":"matrix","name":"$self","line":246},{"line":246,"containerName":"matrix","kind":13,"name":"$matrix"},{"kind":13,"containerName":"matrix","name":"$self","line":247},{"name":"$matrix","containerName":"matrix","kind":13,"line":247},{"name":"$self","kind":13,"containerName":"matrix","line":248},{"line":248,"name":"$matrix","kind":13,"containerName":"matrix"},{"name":"e_val","kind":12,"containerName":"matrix","line":248},{"name":"$self","containerName":"matrix","kind":13,"line":249},{"line":249,"kind":13,"containerName":"matrix","name":"$matrix"},{"line":249,"name":"id","kind":12,"containerName":"matrix"},{"line":251,"kind":13,"containerName":"matrix","name":"$prev"}],"kind":12,"range":{"end":{"character":9999,"line":252},"start":{"line":228,"character":0}},"line":228},{"name":"Bio","containerName":"Matrix::PSM::SiteMatrix","kind":12,"line":230},{"line":230,"kind":12,"name":"probA"},{"line":231,"kind":12,"name":"probC"},{"name":"probG","kind":12,"line":232},{"kind":12,"name":"probT","line":233},{"line":234,"kind":12,"name":"logA"},{"name":"logC","kind":12,"line":235},{"name":"logG","kind":12,"line":236},{"line":237,"kind":12,"name":"logT"},{"line":238,"name":"IC","kind":12},{"name":"e_val","kind":12,"line":239},{"name":"id","kind":12,"line":240},{"line":243,"name":"IC","kind":12},{"line":244,"kind":12,"name":"probA"},{"name":"probA","kind":12,"line":244},{"line":245,"name":"probC","kind":12},{"kind":12,"name":"probC","line":245},{"line":246,"name":"probG","kind":12},{"line":246,"name":"probG","kind":12},{"kind":12,"name":"probT","line":247},{"kind":12,"name":"probT","line":247},{"kind":12,"name":"e_val","line":248},{"line":249,"kind":12,"name":"id"}]}