{"vars":[{"line":78,"name":"base","kind":2,"containerName":""},{"kind":12,"range":{"start":{"line":92,"character":0},"end":{"character":9999,"line":95}},"line":92,"signature":{"label":"matrix_id($self)","documentation":"1;\n# $Id $\n#\n# BioPerl module for Bio::Matrix::MatrixI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::MatrixI - An interface for describing a Matrix \n\n=head1 SYNOPSIS\n\n  # Get a Matrix object\n\n=head1 DESCRIPTION\n\nThis is an interface describing how one should be able to interact\nwith a matrix.  One can have a lot of information I suppose and this\noutline won't really work for PWM or PSSMs.  We will have to derive a\nparticular interface for those.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Matrix::MatrixI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get the matrix ID\n Returns : string value\n Args    : ","parameters":[{"label":"$self"}]},"name":"matrix_id","containerName":"main::","children":[{"line":93,"kind":13,"localvar":"my","containerName":"matrix_id","name":"$self","definition":"my"},{"name":"$self","kind":13,"containerName":"matrix_id","line":94},{"containerName":"matrix_id","kind":12,"name":"throw_not_implemented","line":94}],"detail":"($self)","definition":"sub"},{"line":108,"range":{"start":{"line":108,"character":0},"end":{"line":112,"character":9999}},"kind":12,"signature":{"label":"matrix_name($self)","documentation":"1;\n# $Id $\n#\n# BioPerl module for Bio::Matrix::MatrixI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::MatrixI - An interface for describing a Matrix \n\n=head1 SYNOPSIS\n\n  # Get a Matrix object\n\n=head1 DESCRIPTION\n\nThis is an interface describing how one should be able to interact\nwith a matrix.  One can have a lot of information I suppose and this\noutline won't really work for PWM or PSSMs.  We will have to derive a\nparticular interface for those.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Matrix::MatrixI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get the matrix ID\n Returns : string value\n Args    : \n\n\n\nsub matrix_id{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get the matrix name\n Returns : string value\n Args    :","parameters":[{"label":"$self"}]},"children":[{"definition":"my","line":109,"name":"$self","localvar":"my","containerName":"matrix_name","kind":13},{"line":111,"containerName":"matrix_name","kind":13,"name":"$self"},{"name":"throw_not_implemented","kind":12,"containerName":"matrix_name","line":111}],"containerName":"main::","name":"matrix_name","definition":"sub","detail":"($self)"},{"range":{"end":{"character":9999,"line":130},"start":{"line":126,"character":0}},"kind":12,"line":126,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id $\n#\n# BioPerl module for Bio::Matrix::MatrixI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::MatrixI - An interface for describing a Matrix \n\n=head1 SYNOPSIS\n\n  # Get a Matrix object\n\n=head1 DESCRIPTION\n\nThis is an interface describing how one should be able to interact\nwith a matrix.  One can have a lot of information I suppose and this\noutline won't really work for PWM or PSSMs.  We will have to derive a\nparticular interface for those.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Matrix::MatrixI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get the matrix ID\n Returns : string value\n Args    : \n\n\n\nsub matrix_id{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get the matrix name\n Returns : string value\n Args    :\n\n\n\nsub matrix_name{\n   my ($self) = @_;\n\n   $self->throw_not_implemented();\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name ","label":"get_entry($self)"},"containerName":"main::","name":"get_entry","children":[{"line":127,"name":"$self","containerName":"get_entry","localvar":"my","kind":13,"definition":"my"},{"name":"$self","containerName":"get_entry","kind":13,"line":129},{"line":129,"containerName":"get_entry","kind":12,"name":"throw_not_implemented"}],"detail":"($self)","definition":"sub"},{"signature":{"documentation":"1;\n# $Id $\n#\n# BioPerl module for Bio::Matrix::MatrixI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::MatrixI - An interface for describing a Matrix \n\n=head1 SYNOPSIS\n\n  # Get a Matrix object\n\n=head1 DESCRIPTION\n\nThis is an interface describing how one should be able to interact\nwith a matrix.  One can have a lot of information I suppose and this\noutline won't really work for PWM or PSSMs.  We will have to derive a\nparticular interface for those.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Matrix::MatrixI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get the matrix ID\n Returns : string value\n Args    : \n\n\n\nsub matrix_id{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get the matrix name\n Returns : string value\n Args    :\n\n\n\nsub matrix_name{\n   my ($self) = @_;\n\n   $self->throw_not_implemented();\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{\n   my ($self) = @_;\n\n    $self->throw_not_implemented();\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column","parameters":[{"label":"$self"}],"label":"get_column($self)"},"line":145,"range":{"start":{"line":145,"character":0},"end":{"character":9999,"line":148}},"kind":12,"definition":"sub","detail":"($self)","children":[{"definition":"my","line":146,"name":"$self","containerName":"get_column","localvar":"my","kind":13},{"line":147,"containerName":"get_column","kind":13,"name":"$self"},{"line":147,"name":"throw_not_implemented","containerName":"get_column","kind":12}],"name":"get_column","containerName":"main::"},{"signature":{"documentation":"1;\n# $Id $\n#\n# BioPerl module for Bio::Matrix::MatrixI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::MatrixI - An interface for describing a Matrix \n\n=head1 SYNOPSIS\n\n  # Get a Matrix object\n\n=head1 DESCRIPTION\n\nThis is an interface describing how one should be able to interact\nwith a matrix.  One can have a lot of information I suppose and this\noutline won't really work for PWM or PSSMs.  We will have to derive a\nparticular interface for those.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Matrix::MatrixI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get the matrix ID\n Returns : string value\n Args    : \n\n\n\nsub matrix_id{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get the matrix name\n Returns : string value\n Args    :\n\n\n\nsub matrix_name{\n   my ($self) = @_;\n\n   $self->throw_not_implemented();\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{\n   my ($self) = @_;\n\n    $self->throw_not_implemented();\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n\n\n\nsub get_column{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 get_row\n\n Title   : get_row\n Usage   : my @row = $matrix->get_row('ALPHA');\n Function: Get a particular row\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the row","parameters":[{"label":"$self"}],"label":"get_row($self)"},"range":{"end":{"character":9999,"line":164},"start":{"line":161,"character":0}},"kind":12,"line":161,"detail":"($self)","definition":"sub","name":"get_row","containerName":"main::","children":[{"definition":"my","localvar":"my","containerName":"get_row","kind":13,"name":"$self","line":162},{"name":"$self","containerName":"get_row","kind":13,"line":163},{"line":163,"name":"throw_not_implemented","kind":12,"containerName":"get_row"}]},{"signature":{"label":"get_diagonal($self)","documentation":"1;\n# $Id $\n#\n# BioPerl module for Bio::Matrix::MatrixI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::MatrixI - An interface for describing a Matrix \n\n=head1 SYNOPSIS\n\n  # Get a Matrix object\n\n=head1 DESCRIPTION\n\nThis is an interface describing how one should be able to interact\nwith a matrix.  One can have a lot of information I suppose and this\noutline won't really work for PWM or PSSMs.  We will have to derive a\nparticular interface for those.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Matrix::MatrixI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get the matrix ID\n Returns : string value\n Args    : \n\n\n\nsub matrix_id{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get the matrix name\n Returns : string value\n Args    :\n\n\n\nsub matrix_name{\n   my ($self) = @_;\n\n   $self->throw_not_implemented();\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{\n   my ($self) = @_;\n\n    $self->throw_not_implemented();\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n\n\n\nsub get_column{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 get_row\n\n Title   : get_row\n Usage   : my @row = $matrix->get_row('ALPHA');\n Function: Get a particular row\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the row\n\n\nsub get_row{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 get_diagonal\n\n Title   : get_diagonal\n Usage   : my @diagonal = $matrix->get_diagonal; \n Function: Get the diagonal of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : none","parameters":[{"label":"$self"}]},"range":{"end":{"character":9999,"line":181},"start":{"line":178,"character":0}},"kind":12,"line":178,"detail":"($self)","definition":"sub","containerName":"main::","name":"get_diagonal","children":[{"definition":"my","line":179,"containerName":"get_diagonal","localvar":"my","kind":13,"name":"$self"},{"containerName":"get_diagonal","kind":13,"name":"$self","line":180},{"name":"throw_not_implemented","containerName":"get_diagonal","kind":12,"line":180}]},{"signature":{"label":"column_num_for_name($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id $\n#\n# BioPerl module for Bio::Matrix::MatrixI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::MatrixI - An interface for describing a Matrix \n\n=head1 SYNOPSIS\n\n  # Get a Matrix object\n\n=head1 DESCRIPTION\n\nThis is an interface describing how one should be able to interact\nwith a matrix.  One can have a lot of information I suppose and this\noutline won't really work for PWM or PSSMs.  We will have to derive a\nparticular interface for those.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Matrix::MatrixI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get the matrix ID\n Returns : string value\n Args    : \n\n\n\nsub matrix_id{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get the matrix name\n Returns : string value\n Args    :\n\n\n\nsub matrix_name{\n   my ($self) = @_;\n\n   $self->throw_not_implemented();\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{\n   my ($self) = @_;\n\n    $self->throw_not_implemented();\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n\n\n\nsub get_column{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 get_row\n\n Title   : get_row\n Usage   : my @row = $matrix->get_row('ALPHA');\n Function: Get a particular row\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the row\n\n\nsub get_row{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 get_diagonal\n\n Title   : get_diagonal\n Usage   : my @diagonal = $matrix->get_diagonal; \n Function: Get the diagonal of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : none\n\n\n\nsub get_diagonal{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 column_num_for_name\n\n Title   : column_num_for_name\n Usage   : my $num = $matrix->column_num_for_name($name)\n Function: Gets the column number for a particular column name\n Returns : integer\n Args    : string"},"line":194,"range":{"end":{"character":9999,"line":198},"start":{"character":0,"line":194}},"kind":12,"definition":"sub","detail":"($self)","children":[{"definition":"my","name":"$self","containerName":"column_num_for_name","localvar":"my","kind":13,"line":195},{"line":197,"kind":13,"containerName":"column_num_for_name","name":"$self"},{"line":197,"name":"throw_not_implemented","containerName":"column_num_for_name","kind":12}],"name":"column_num_for_name","containerName":"main::"},{"definition":"sub","detail":"($self)","children":[{"definition":"my","line":212,"name":"$self","localvar":"my","containerName":"row_num_for_name","kind":13},{"line":213,"containerName":"row_num_for_name","kind":13,"name":"$self"},{"containerName":"row_num_for_name","kind":12,"name":"throw_not_implemented","line":213}],"name":"row_num_for_name","containerName":"main::","signature":{"documentation":"1;\n# $Id $\n#\n# BioPerl module for Bio::Matrix::MatrixI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::MatrixI - An interface for describing a Matrix \n\n=head1 SYNOPSIS\n\n  # Get a Matrix object\n\n=head1 DESCRIPTION\n\nThis is an interface describing how one should be able to interact\nwith a matrix.  One can have a lot of information I suppose and this\noutline won't really work for PWM or PSSMs.  We will have to derive a\nparticular interface for those.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Matrix::MatrixI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get the matrix ID\n Returns : string value\n Args    : \n\n\n\nsub matrix_id{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get the matrix name\n Returns : string value\n Args    :\n\n\n\nsub matrix_name{\n   my ($self) = @_;\n\n   $self->throw_not_implemented();\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{\n   my ($self) = @_;\n\n    $self->throw_not_implemented();\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n\n\n\nsub get_column{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 get_row\n\n Title   : get_row\n Usage   : my @row = $matrix->get_row('ALPHA');\n Function: Get a particular row\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the row\n\n\nsub get_row{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 get_diagonal\n\n Title   : get_diagonal\n Usage   : my @diagonal = $matrix->get_diagonal; \n Function: Get the diagonal of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : none\n\n\n\nsub get_diagonal{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 column_num_for_name\n\n Title   : column_num_for_name\n Usage   : my $num = $matrix->column_num_for_name($name)\n Function: Gets the column number for a particular column name\n Returns : integer\n Args    : string\n\n\n\nsub column_num_for_name{\n   my ($self) = @_;\n\n    $self->throw_not_implemented();\n}\n\n=head2 row_num_for_name\n\n Title   : row_num_for_name\n Usage   : my $num = $matrix->row_num_for_name($name)\n Function: Gets the row number for a particular row name\n Returns : integer\n Args    : string","parameters":[{"label":"$self"}],"label":"row_num_for_name($self)"},"line":211,"kind":12,"range":{"end":{"character":9999,"line":214},"start":{"character":0,"line":211}}},{"name":"num_rows","containerName":"main::","children":[{"line":228,"localvar":"my","kind":13,"containerName":"num_rows","name":"$self","definition":"my"},{"kind":13,"containerName":"num_rows","name":"$self","line":229},{"line":229,"name":"throw_not_implemented","containerName":"num_rows","kind":12}],"detail":"($self)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":230},"start":{"character":0,"line":227}},"line":227,"signature":{"label":"num_rows($self)","documentation":"1;\n# $Id $\n#\n# BioPerl module for Bio::Matrix::MatrixI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::MatrixI - An interface for describing a Matrix \n\n=head1 SYNOPSIS\n\n  # Get a Matrix object\n\n=head1 DESCRIPTION\n\nThis is an interface describing how one should be able to interact\nwith a matrix.  One can have a lot of information I suppose and this\noutline won't really work for PWM or PSSMs.  We will have to derive a\nparticular interface for those.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Matrix::MatrixI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get the matrix ID\n Returns : string value\n Args    : \n\n\n\nsub matrix_id{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get the matrix name\n Returns : string value\n Args    :\n\n\n\nsub matrix_name{\n   my ($self) = @_;\n\n   $self->throw_not_implemented();\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{\n   my ($self) = @_;\n\n    $self->throw_not_implemented();\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n\n\n\nsub get_column{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 get_row\n\n Title   : get_row\n Usage   : my @row = $matrix->get_row('ALPHA');\n Function: Get a particular row\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the row\n\n\nsub get_row{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 get_diagonal\n\n Title   : get_diagonal\n Usage   : my @diagonal = $matrix->get_diagonal; \n Function: Get the diagonal of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : none\n\n\n\nsub get_diagonal{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 column_num_for_name\n\n Title   : column_num_for_name\n Usage   : my $num = $matrix->column_num_for_name($name)\n Function: Gets the column number for a particular column name\n Returns : integer\n Args    : string\n\n\n\nsub column_num_for_name{\n   my ($self) = @_;\n\n    $self->throw_not_implemented();\n}\n\n=head2 row_num_for_name\n\n Title   : row_num_for_name\n Usage   : my $num = $matrix->row_num_for_name($name)\n Function: Gets the row number for a particular row name\n Returns : integer\n Args    : string\n\n\n\nsub row_num_for_name{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 num_rows\n\n Title   : num_rows\n Usage   : my $rowcount = $matrix->num_rows;\n Function: Get the number of rows\n Returns : integer\n Args    : none","parameters":[{"label":"$self"}]}},{"name":"num_columns","containerName":"main::","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"num_columns","line":245,"definition":"my"},{"name":"$self","containerName":"num_columns","kind":13,"line":246},{"line":246,"name":"throw_not_implemented","kind":12,"containerName":"num_columns"}],"detail":"($self)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":244},"end":{"line":247,"character":9999}},"line":244,"signature":{"label":"num_columns($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id $\n#\n# BioPerl module for Bio::Matrix::MatrixI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::MatrixI - An interface for describing a Matrix \n\n=head1 SYNOPSIS\n\n  # Get a Matrix object\n\n=head1 DESCRIPTION\n\nThis is an interface describing how one should be able to interact\nwith a matrix.  One can have a lot of information I suppose and this\noutline won't really work for PWM or PSSMs.  We will have to derive a\nparticular interface for those.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Matrix::MatrixI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get the matrix ID\n Returns : string value\n Args    : \n\n\n\nsub matrix_id{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get the matrix name\n Returns : string value\n Args    :\n\n\n\nsub matrix_name{\n   my ($self) = @_;\n\n   $self->throw_not_implemented();\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{\n   my ($self) = @_;\n\n    $self->throw_not_implemented();\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n\n\n\nsub get_column{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 get_row\n\n Title   : get_row\n Usage   : my @row = $matrix->get_row('ALPHA');\n Function: Get a particular row\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the row\n\n\nsub get_row{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 get_diagonal\n\n Title   : get_diagonal\n Usage   : my @diagonal = $matrix->get_diagonal; \n Function: Get the diagonal of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : none\n\n\n\nsub get_diagonal{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 column_num_for_name\n\n Title   : column_num_for_name\n Usage   : my $num = $matrix->column_num_for_name($name)\n Function: Gets the column number for a particular column name\n Returns : integer\n Args    : string\n\n\n\nsub column_num_for_name{\n   my ($self) = @_;\n\n    $self->throw_not_implemented();\n}\n\n=head2 row_num_for_name\n\n Title   : row_num_for_name\n Usage   : my $num = $matrix->row_num_for_name($name)\n Function: Gets the row number for a particular row name\n Returns : integer\n Args    : string\n\n\n\nsub row_num_for_name{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 num_rows\n\n Title   : num_rows\n Usage   : my $rowcount = $matrix->num_rows;\n Function: Get the number of rows\n Returns : integer\n Args    : none\n\n\n\nsub num_rows{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 num_columns\n\n Title   : num_columns\n Usage   : my $colcount = $matrix->num_columns\n Function: Get the number of columns\n Returns : integer\n Args    : none"}},{"containerName":"main::","name":"reverse","children":[{"definition":"my","line":263,"localvar":"my","containerName":"reverse","kind":13,"name":"$self"},{"line":264,"containerName":"reverse","kind":13,"name":"$self"},{"line":264,"name":"throw_not_implemented","containerName":"reverse","kind":12}],"detail":"($self)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":265},"start":{"line":262,"character":0}},"line":262,"signature":{"label":"reverse($self)","documentation":"1;\n# $Id $\n#\n# BioPerl module for Bio::Matrix::MatrixI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::MatrixI - An interface for describing a Matrix \n\n=head1 SYNOPSIS\n\n  # Get a Matrix object\n\n=head1 DESCRIPTION\n\nThis is an interface describing how one should be able to interact\nwith a matrix.  One can have a lot of information I suppose and this\noutline won't really work for PWM or PSSMs.  We will have to derive a\nparticular interface for those.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Matrix::MatrixI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get the matrix ID\n Returns : string value\n Args    : \n\n\n\nsub matrix_id{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get the matrix name\n Returns : string value\n Args    :\n\n\n\nsub matrix_name{\n   my ($self) = @_;\n\n   $self->throw_not_implemented();\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{\n   my ($self) = @_;\n\n    $self->throw_not_implemented();\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n\n\n\nsub get_column{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 get_row\n\n Title   : get_row\n Usage   : my @row = $matrix->get_row('ALPHA');\n Function: Get a particular row\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the row\n\n\nsub get_row{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 get_diagonal\n\n Title   : get_diagonal\n Usage   : my @diagonal = $matrix->get_diagonal; \n Function: Get the diagonal of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : none\n\n\n\nsub get_diagonal{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 column_num_for_name\n\n Title   : column_num_for_name\n Usage   : my $num = $matrix->column_num_for_name($name)\n Function: Gets the column number for a particular column name\n Returns : integer\n Args    : string\n\n\n\nsub column_num_for_name{\n   my ($self) = @_;\n\n    $self->throw_not_implemented();\n}\n\n=head2 row_num_for_name\n\n Title   : row_num_for_name\n Usage   : my $num = $matrix->row_num_for_name($name)\n Function: Gets the row number for a particular row name\n Returns : integer\n Args    : string\n\n\n\nsub row_num_for_name{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 num_rows\n\n Title   : num_rows\n Usage   : my $rowcount = $matrix->num_rows;\n Function: Get the number of rows\n Returns : integer\n Args    : none\n\n\n\nsub num_rows{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 num_columns\n\n Title   : num_columns\n Usage   : my $colcount = $matrix->num_columns\n Function: Get the number of columns\n Returns : integer\n Args    : none\n\n\n\nsub num_columns{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n# inverse?\n=head2 reverse\n\n Title   : reverse\n Usage   : my $matrix = $matrix->reverse\n Function: Get the reverse of a matrix\n Returns : \n Args    :","parameters":[{"label":"$self"}]}},{"line":278,"kind":12,"range":{"end":{"character":9999,"line":281},"start":{"line":278,"character":0}},"signature":{"label":"row_names($self)","documentation":"1;\n# $Id $\n#\n# BioPerl module for Bio::Matrix::MatrixI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::MatrixI - An interface for describing a Matrix \n\n=head1 SYNOPSIS\n\n  # Get a Matrix object\n\n=head1 DESCRIPTION\n\nThis is an interface describing how one should be able to interact\nwith a matrix.  One can have a lot of information I suppose and this\noutline won't really work for PWM or PSSMs.  We will have to derive a\nparticular interface for those.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Matrix::MatrixI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get the matrix ID\n Returns : string value\n Args    : \n\n\n\nsub matrix_id{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get the matrix name\n Returns : string value\n Args    :\n\n\n\nsub matrix_name{\n   my ($self) = @_;\n\n   $self->throw_not_implemented();\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{\n   my ($self) = @_;\n\n    $self->throw_not_implemented();\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n\n\n\nsub get_column{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 get_row\n\n Title   : get_row\n Usage   : my @row = $matrix->get_row('ALPHA');\n Function: Get a particular row\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the row\n\n\nsub get_row{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 get_diagonal\n\n Title   : get_diagonal\n Usage   : my @diagonal = $matrix->get_diagonal; \n Function: Get the diagonal of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : none\n\n\n\nsub get_diagonal{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 column_num_for_name\n\n Title   : column_num_for_name\n Usage   : my $num = $matrix->column_num_for_name($name)\n Function: Gets the column number for a particular column name\n Returns : integer\n Args    : string\n\n\n\nsub column_num_for_name{\n   my ($self) = @_;\n\n    $self->throw_not_implemented();\n}\n\n=head2 row_num_for_name\n\n Title   : row_num_for_name\n Usage   : my $num = $matrix->row_num_for_name($name)\n Function: Gets the row number for a particular row name\n Returns : integer\n Args    : string\n\n\n\nsub row_num_for_name{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 num_rows\n\n Title   : num_rows\n Usage   : my $rowcount = $matrix->num_rows;\n Function: Get the number of rows\n Returns : integer\n Args    : none\n\n\n\nsub num_rows{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 num_columns\n\n Title   : num_columns\n Usage   : my $colcount = $matrix->num_columns\n Function: Get the number of columns\n Returns : integer\n Args    : none\n\n\n\nsub num_columns{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n# inverse?\n=head2 reverse\n\n Title   : reverse\n Usage   : my $matrix = $matrix->reverse\n Function: Get the reverse of a matrix\n Returns : \n Args    :\n\n\n\nsub reverse{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 row_names\n\n Title   : row_names\n Usage   : my @rows = $matrix->row_names\n Function: The names of all the rows\n Returns : array in array context, arrayref in scalar context\n Args    : none","parameters":[{"label":"$self"}]},"children":[{"definition":"my","line":279,"name":"$self","containerName":"row_names","localvar":"my","kind":13},{"kind":13,"containerName":"row_names","name":"$self","line":280},{"line":280,"containerName":"row_names","kind":12,"name":"throw_not_implemented"}],"containerName":"main::","name":"row_names","definition":"sub","detail":"($self)"},{"children":[{"definition":"my","localvar":"my","kind":13,"containerName":"column_names","name":"$self","line":296},{"line":297,"name":"$self","containerName":"column_names","kind":13},{"line":297,"containerName":"column_names","kind":12,"name":"throw_not_implemented"}],"containerName":"main::","name":"column_names","definition":"sub","detail":"($self)","line":295,"kind":12,"range":{"end":{"line":298,"character":9999},"start":{"line":295,"character":0}},"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id $\n#\n# BioPerl module for Bio::Matrix::MatrixI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::MatrixI - An interface for describing a Matrix \n\n=head1 SYNOPSIS\n\n  # Get a Matrix object\n\n=head1 DESCRIPTION\n\nThis is an interface describing how one should be able to interact\nwith a matrix.  One can have a lot of information I suppose and this\noutline won't really work for PWM or PSSMs.  We will have to derive a\nparticular interface for those.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Matrix::MatrixI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get the matrix ID\n Returns : string value\n Args    : \n\n\n\nsub matrix_id{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get the matrix name\n Returns : string value\n Args    :\n\n\n\nsub matrix_name{\n   my ($self) = @_;\n\n   $self->throw_not_implemented();\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : my $entry = $matrix->get_entry($rowname,$columname)\n Function: Get the entry for a given row,column pair\n Returns : scalar\n Args    : $row name\n           $column name \n\n\n\nsub get_entry{\n   my ($self) = @_;\n\n    $self->throw_not_implemented();\n}\n\n\n=head2 get_column\n\n Title   : get_column\n Usage   : my @row = $matrix->get_column('ALPHA');\n Function: Get a particular column\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the column\n\n\n\nsub get_column{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 get_row\n\n Title   : get_row\n Usage   : my @row = $matrix->get_row('ALPHA');\n Function: Get a particular row\n Returns : Array (in array context) or arrayref (in scalar context)\n           of values\n Args    : name of the row\n\n\nsub get_row{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 get_diagonal\n\n Title   : get_diagonal\n Usage   : my @diagonal = $matrix->get_diagonal; \n Function: Get the diagonal of the matrix\n Returns : Array (in array context) or arrayref (in scalar context)\n Args    : none\n\n\n\nsub get_diagonal{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 column_num_for_name\n\n Title   : column_num_for_name\n Usage   : my $num = $matrix->column_num_for_name($name)\n Function: Gets the column number for a particular column name\n Returns : integer\n Args    : string\n\n\n\nsub column_num_for_name{\n   my ($self) = @_;\n\n    $self->throw_not_implemented();\n}\n\n=head2 row_num_for_name\n\n Title   : row_num_for_name\n Usage   : my $num = $matrix->row_num_for_name($name)\n Function: Gets the row number for a particular row name\n Returns : integer\n Args    : string\n\n\n\nsub row_num_for_name{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 num_rows\n\n Title   : num_rows\n Usage   : my $rowcount = $matrix->num_rows;\n Function: Get the number of rows\n Returns : integer\n Args    : none\n\n\n\nsub num_rows{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 num_columns\n\n Title   : num_columns\n Usage   : my $colcount = $matrix->num_columns\n Function: Get the number of columns\n Returns : integer\n Args    : none\n\n\n\nsub num_columns{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n# inverse?\n=head2 reverse\n\n Title   : reverse\n Usage   : my $matrix = $matrix->reverse\n Function: Get the reverse of a matrix\n Returns : \n Args    :\n\n\n\nsub reverse{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 row_names\n\n Title   : row_names\n Usage   : my @rows = $matrix->row_names\n Function: The names of all the rows\n Returns : array in array context, arrayref in scalar context\n Args    : none\n\n\n\nsub row_names{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 column_names\n\n Title   : column_names\n Usage   : my @columns = $matrix->column_names\n Function: The names of all the columns\n Returns : array in array context, arrayref in scalar context\n Args    : none","label":"column_names($self)"}}],"version":5}