{"vars":[{"line":86,"name":"base","containerName":"","kind":2},{"detail":"($self)","definition":"sub","containerName":"main::","name":"next_map","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"next_map","kind":13,"line":101},{"kind":13,"localvar":"my","containerName":"next_map","name":"$map","line":102,"definition":"my"},{"name":"new","containerName":"next_map","kind":12,"line":102},{"line":110,"name":"$in_map","containerName":"next_map","localvar":"my","kind":13,"definition":"my"},{"name":"$runningDistance","kind":13,"containerName":"next_map","line":110},{"line":112,"kind":13,"containerName":"next_map","name":"$self"},{"name":"_readline","kind":12,"containerName":"next_map","line":112},{"name":"$in_map","kind":13,"containerName":"next_map","line":114},{"line":117,"name":"$in_map","containerName":"next_map","kind":13},{"name":"$number","localvar":"my","containerName":"next_map","kind":13,"line":120,"definition":"my"},{"containerName":"next_map","kind":13,"name":"$name","line":120},{"line":120,"name":"$distance","containerName":"next_map","kind":13},{"line":121,"kind":13,"containerName":"next_map","name":"$runningDistance"},{"line":121,"containerName":"next_map","kind":13,"name":"$distance"},{"kind":13,"containerName":"next_map","name":"$distance","line":121},{"name":"$runningDistance","containerName":"next_map","kind":13,"line":122},{"line":122,"name":"$runningDistance","kind":13,"containerName":"next_map"},{"kind":13,"containerName":"next_map","name":"$distance","line":122},{"line":124,"kind":13,"localvar":"my","containerName":"next_map","name":"$pos","definition":"my"},{"kind":12,"containerName":"next_map","name":"new","line":124},{"kind":13,"containerName":"next_map","name":"$number","line":124},{"kind":13,"containerName":"next_map","name":"$map","line":125},{"line":126,"name":"$runningDistance","containerName":"next_map","kind":13},{"line":127,"kind":13,"localvar":"my","containerName":"next_map","name":"$marker","definition":"my"},{"kind":12,"containerName":"next_map","name":"new","line":127},{"name":"$name","containerName":"next_map","kind":13,"line":127},{"name":"$pos","containerName":"next_map","kind":13,"line":128},{"line":130,"containerName":"next_map","kind":13,"name":"$distance"},{"name":"$in_map","kind":13,"containerName":"next_map","line":131},{"line":132,"name":"$map","containerName":"next_map","kind":13}],"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: mapmaker.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::MapIO::mapmaker\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::MapIO::mapmaker - A Mapmaker Map reader\n\n=head1 SYNOPSIS\n\n# do not use this object directly it is accessed through the Bio::MapIO system \n\n    use Bio::MapIO;\n    my $mapio = Bio::MapIO->new(-format => \"mapmaker\",\n\t\t\t                      -file   => \"mapfile.map\");\n    while ( my $map = $mapio->next_map ) {  # get each map\n\t    foreach my $marker ( $map->each_element ) {\n\t       # loop through the markers associated with the map\n\t    }\n    }\n\n=head1 DESCRIPTION\n\nThis object contains code for parsing and processing Mapmaker output\nand creating L<Bio::Map::MapI> objects from it.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::MapIO::mapmaker;\nuse strict;\n\nuse Bio::Map::SimpleMap;\nuse Bio::Map::LinkagePosition;\nuse Bio::Map::Marker;\n\nuse base qw(Bio::MapIO);\n\n=head2 next_map\n\n Title   : next_map\n Usage   : my $map = $factory->next_map;\n Function: Get one or more map objects from the Mapmaker input\n Returns : Bio::Map::MapI\n Args    : none\n\nSee L<Bio::Map::MapI>","label":"next_map($self)"},"range":{"end":{"character":9999,"line":135},"start":{"line":100,"character":0}},"kind":12,"line":100},{"line":102,"name":"Bio","kind":12,"containerName":"Map::SimpleMap"},{"line":124,"containerName":"Map::LinkagePosition","kind":12,"name":"Bio"},{"containerName":"Map::Marker","kind":12,"name":"Bio","line":127},{"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: mapmaker.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::MapIO::mapmaker\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::MapIO::mapmaker - A Mapmaker Map reader\n\n=head1 SYNOPSIS\n\n# do not use this object directly it is accessed through the Bio::MapIO system \n\n    use Bio::MapIO;\n    my $mapio = Bio::MapIO->new(-format => \"mapmaker\",\n\t\t\t                      -file   => \"mapfile.map\");\n    while ( my $map = $mapio->next_map ) {  # get each map\n\t    foreach my $marker ( $map->each_element ) {\n\t       # loop through the markers associated with the map\n\t    }\n    }\n\n=head1 DESCRIPTION\n\nThis object contains code for parsing and processing Mapmaker output\nand creating L<Bio::Map::MapI> objects from it.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::MapIO::mapmaker;\nuse strict;\n\nuse Bio::Map::SimpleMap;\nuse Bio::Map::LinkagePosition;\nuse Bio::Map::Marker;\n\nuse base qw(Bio::MapIO);\n\n=head2 next_map\n\n Title   : next_map\n Usage   : my $map = $factory->next_map;\n Function: Get one or more map objects from the Mapmaker input\n Returns : Bio::Map::MapI\n Args    : none\n\nSee L<Bio::Map::MapI>\n\n\nsub next_map{\n   my ($self) = @_;\n   my $map = Bio::Map::SimpleMap->new(-name  => '',\n\t\t\t\t\t\t\t\t\t\t\t\t  -units => 'cM',\n\t\t\t\t\t\t\t\t\t\t\t\t  -type  => 'Genetic');\n\n\t# Mapmaker input can be free-form, like the result of a copy-paste\n\t# from a terminal, with no particular format before or after the \n\t# map data. The $in_map variable is a flag that's set to 1 when \n\t# we're reading map data lines and set back to 0 when we're finished.\n   my ($in_map,$runningDistance);\n\n   while ( defined ($_ = $self->_readline()) ) {\n\t\tif ( /^\\s+Markers\\s+Distance/ ) {\n\t\t\t$in_map = 1;\n\t\t\tnext;\n\t\t} \n\t\tnext unless $in_map;\n \n\t\ts/ +/\\t/;\n\t\tmy ($number,$name,$distance) = split;\n\t\t$runningDistance += $distance unless ($distance =~ /-+/);\n\t\t$runningDistance = '0.0' if ($runningDistance == 0 || $distance =~ /-+/);\n\n\t\tmy $pos = Bio::Map::LinkagePosition->new(-order => $number,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t -map   => $map,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t -value => $runningDistance );\n\t\tmy $marker = Bio::Map::Marker->new(-name     => $name,\n\t\t\t\t\t\t\t\t\t\t\t\t\t -position => $pos );\n\t\t\n\t\tif ($distance =~ /-+/) { # last marker\n\t\t\t$in_map = 0;\n\t\t\treturn $map;\n\t\t}  \n\t}\n}\n\n=head2 write_map\n\n Title   : write_map\n Usage   : $factory->write_map($map);\n Function: Write a map out through the factory\n Returns : none\n Args    : Bio::Map::MapI","label":"write_map($self,@args)"},"line":147,"range":{"start":{"character":0,"line":147},"end":{"character":9999,"line":150}},"kind":12,"definition":"sub","detail":"($self,@args)","children":[{"definition":"my","line":148,"name":"$self","kind":13,"localvar":"my","containerName":"write_map"},{"kind":13,"containerName":"write_map","name":"@args","line":148},{"kind":13,"containerName":"write_map","name":"$self","line":149},{"line":149,"name":"throw_not_implemented","kind":12,"containerName":"write_map"}],"name":"write_map","containerName":"main::"}],"version":5}