{"vars":[{"name":"base","containerName":"","kind":2,"line":71},{"definition":"my","line":73,"name":"$_readcor","localvar":"my","containerName":null,"kind":13},{"line":87,"kind":12,"range":{"start":{"line":87,"character":0},"end":{"line":93,"character":9999}},"signature":{"documentation":"# fpc.pm,v 1.2.2.1 2005/10/09 15:16:27 jason Exp\n#\n# BioPerl module for Bio::MapIO::fpc\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gaurav Gupta <gaurav@genome.arizona.edu>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::MapIO::fpc - A FPC Map reader\n\n=head1 SYNOPSIS\n\n# do not use this object directly it is accessed through the Bio::MapIO system\n\n    use Bio::MapIO;\n\n     -format  : specifies the format of the file format is \"fpc\",\n     -file    : specifies the name of the .fpc file\n     -readcor : boolean argument, indicating if .cor is to be read\n                 or not. It looks for the .cor file in the same path\n                 as .fpc file.\n                 0 : doesn't read .cor file\n                 1 : reads the .cor file\n                 [default 0]\n     -verbose : indicates the process of loading of fpc file\n    my $mapio = Bio::MapIO->new(-format  => \"fpc\",\n                               -file    => \"rice.fpc\",\n                               -readcor => 0,\n                               -verbose => 0);\n\n    my $map = $mapio->next_map();\n\n    foreach my $marker ( $map->each_markerid() ) {\n         # loop through the markers associated with the map\n         # likewise for contigs, clones, etc.\n    }\n\n\n=head1 DESCRIPTION\n\nThis object contains code for parsing and processing FPC files and creating\nL<Bio::Map::Physical> object from it.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\nWe handle reading of the FPC ourselves, since MapIO module of Bioperl adds\ntoo much overhead.\n\n\n# Let the code begin...\n\npackage Bio::MapIO::fpc;\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Physical;\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\nuse Bio::Range;\n\nuse base qw(Bio::MapIO);\n\nmy $_readcor;\n\n=head1 Initializer\n\n=head2 _initialize\n\n Title   : _initialize\n Usage   : called implicitly\n Function: calls the SUPER::_initialize\n Returns : nothing\n Args    : species, readcor","parameters":[{"label":"$self"},{"label":"@args"}],"label":"_initialize($self,@args)"},"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"_initialize","line":88,"definition":"my"},{"containerName":"_initialize","kind":13,"name":"@args","line":88},{"definition":"my","line":89,"kind":13,"localvar":"my","containerName":"_initialize","name":"$species"},{"name":"$self","kind":13,"containerName":"_initialize","line":90},{"containerName":"_initialize","kind":13,"name":"@args","line":90},{"name":"$species","containerName":"_initialize","kind":13,"line":91},{"line":91,"kind":13,"containerName":"_initialize","name":"$_readcor"},{"name":"$self","containerName":"_initialize","kind":13,"line":91},{"line":91,"kind":12,"containerName":"_initialize","name":"_rearrange"},{"containerName":"_initialize","kind":13,"name":"@args","line":91},{"name":"$_readcor","containerName":"_initialize","kind":13,"line":92},{"name":"$_readcor","containerName":"_initialize","kind":13,"line":92}],"name":"_initialize","containerName":"main::","definition":"sub","detail":"($self,@args)"},{"line":90,"name":"SUPER","kind":12,"containerName":"_initialize"},{"definition":"sub","detail":"($self)","children":[{"line":111,"localvar":"my","kind":13,"containerName":"next_map","name":"$self","definition":"my"},{"line":113,"localvar":"my","kind":13,"containerName":"next_map","name":"$line","definition":"my"},{"definition":"my","line":114,"name":"$name","localvar":"my","kind":13,"containerName":"next_map"},{"name":"$fpcver","containerName":"next_map","kind":13,"line":114},{"containerName":"next_map","kind":13,"name":"$moddate","line":114},{"line":114,"kind":13,"containerName":"next_map","name":"$moduser"},{"name":"$contigcnt","kind":13,"containerName":"next_map","line":114},{"line":114,"containerName":"next_map","kind":13,"name":"$clonecnt"},{"kind":13,"containerName":"next_map","name":"$markerscnt","line":114},{"line":115,"containerName":"next_map","kind":13,"name":"$bandcnt"},{"name":"$marker","kind":13,"containerName":"next_map","line":115},{"line":115,"containerName":"next_map","kind":13,"name":"$seqclone"},{"definition":"my","line":116,"name":"$corfile","kind":13,"localvar":"my","containerName":"next_map"},{"containerName":"next_map","kind":13,"name":"$corindex","line":116},{"containerName":"next_map","kind":13,"name":"$BUFFER","line":116},{"line":117,"localvar":"my","containerName":"next_map","kind":13,"name":"@cordata","definition":"my"},{"definition":"my","name":"%fpcmarker","localvar":"my","kind":13,"containerName":"next_map","line":118},{"definition":"my","kind":13,"localvar":"my","containerName":"next_map","name":"$contig","line":119},{"name":"$contigNumber","kind":13,"containerName":"next_map","line":119},{"line":120,"name":"$curClone","kind":13,"localvar":"my","containerName":"next_map","definition":"my"},{"definition":"my","name":"$curMarker","localvar":"my","containerName":"next_map","kind":13,"line":121},{"name":"$curContig","kind":13,"localvar":"my","containerName":"next_map","line":122,"definition":"my"},{"line":123,"kind":13,"localvar":"my","containerName":"next_map","name":"%_clones","definition":"my"},{"definition":"my","name":"%_markers","localvar":"my","containerName":"next_map","kind":13,"line":124},{"definition":"my","line":125,"localvar":"my","kind":13,"containerName":"next_map","name":"%_contigs"},{"definition":"my","line":126,"localvar":"my","kind":13,"containerName":"next_map","name":"$ctgzeropos"},{"name":"$map","containerName":"next_map","localvar":"my","kind":13,"line":128,"definition":"my"},{"line":128,"kind":12,"containerName":"next_map","name":"new"},{"definition":"my","line":131,"localvar":"my","containerName":"next_map","kind":13,"name":"$filename"},{"line":131,"name":"$self","kind":13,"containerName":"next_map"},{"containerName":"next_map","kind":12,"name":"file","line":131},{"line":132,"localvar":"my","kind":13,"containerName":"next_map","name":"$fh","definition":"my"},{"line":132,"kind":13,"containerName":"next_map","name":"$self"},{"line":134,"kind":13,"containerName":"next_map","name":"$_readcor"},{"line":135,"name":"$map","kind":13,"containerName":"next_map"},{"line":135,"name":"core_exists","kind":12,"containerName":"next_map"},{"line":135,"name":"$_readcor","containerName":"next_map","kind":13},{"line":138,"containerName":"next_map","kind":13,"name":"$map"},{"line":138,"containerName":"next_map","kind":12,"name":"core_exists"},{"line":141,"kind":13,"containerName":"next_map","name":"$map"},{"containerName":"next_map","kind":12,"name":"core_exists","line":141},{"line":142,"name":"$corfile","kind":13,"containerName":"next_map"},{"line":142,"containerName":"next_map","kind":13,"name":"$filename"},{"line":142,"name":"$filename","containerName":"next_map","kind":13},{"line":143,"containerName":"next_map","kind":13,"name":"$corfile"},{"name":"$BUFFER","containerName":"next_map","kind":13,"line":144},{"containerName":"next_map","kind":13,"name":"@cordata","line":145},{"name":"$BUFFER","containerName":"next_map","kind":13,"line":145},{"name":"$map","kind":13,"containerName":"next_map","line":149},{"line":149,"containerName":"next_map","kind":12,"name":"core_exists"},{"kind":13,"containerName":"next_map","name":"$line","line":154},{"line":154,"containerName":"next_map","kind":13,"name":"$fh"},{"line":155,"containerName":"next_map","kind":13,"name":"$line"},{"name":"$line","containerName":"next_map","kind":13,"line":157},{"name":"$map","kind":13,"containerName":"next_map","line":157},{"kind":12,"containerName":"next_map","name":"name","line":157},{"line":158,"containerName":"next_map","kind":13,"name":"$line"},{"localvar":"my","kind":13,"containerName":"next_map","name":"$version","line":159,"definition":"my"},{"kind":13,"containerName":"next_map","name":"$version","line":160},{"line":161,"containerName":"next_map","kind":13,"name":"$map"},{"kind":12,"containerName":"next_map","name":"version","line":161},{"name":"$line","kind":13,"containerName":"next_map","line":162},{"containerName":"next_map","kind":13,"name":"$map","line":162},{"name":"modification_user","containerName":"next_map","kind":12,"line":162},{"line":165,"name":"$line","containerName":"next_map","kind":13},{"name":"$map","containerName":"next_map","kind":13,"line":167},{"line":167,"name":"group_type","kind":12,"containerName":"next_map"},{"containerName":"next_map","kind":13,"name":"$map","line":168},{"kind":12,"containerName":"next_map","name":"group_abbr","line":168},{"line":171,"name":"$line","kind":13,"containerName":"next_map"},{"name":"$map","kind":13,"containerName":"next_map","line":174},{"line":174,"name":"group_type","kind":12,"containerName":"next_map"},{"name":"$map","kind":13,"containerName":"next_map","line":174},{"line":174,"containerName":"next_map","kind":12,"name":"group_abbr"},{"line":175,"name":"$map","containerName":"next_map","kind":13},{"name":"group_type","kind":12,"containerName":"next_map","line":175},{"line":176,"kind":13,"containerName":"next_map","name":"$map"},{"kind":12,"containerName":"next_map","name":"group_abbr","line":176},{"line":179,"kind":13,"containerName":"next_map","name":"$_contigs"},{"containerName":"next_map","kind":13,"name":"$_contigs","line":180},{"containerName":"next_map","kind":13,"name":"$line","line":183},{"line":183,"kind":13,"containerName":"next_map","name":"$fh"},{"line":184,"containerName":"next_map","kind":13,"name":"$marker"},{"kind":13,"containerName":"next_map","name":"$contig","line":185},{"line":186,"containerName":"next_map","kind":13,"name":"$seqclone"},{"containerName":"next_map","kind":13,"name":"$contigNumber","line":187},{"line":189,"name":"$type","kind":13,"localvar":"my","containerName":"next_map","definition":"my"},{"kind":13,"containerName":"next_map","name":"$name","line":189},{"definition":"my","localvar":"my","containerName":"next_map","kind":13,"name":"@amatch","line":190},{"line":190,"kind":13,"containerName":"next_map","name":"@pmatch"},{"line":190,"name":"@ematch","containerName":"next_map","kind":13},{"definition":"my","name":"$bandsread","localvar":"my","kind":13,"containerName":"next_map","line":192},{"kind":13,"containerName":"next_map","name":"$line","line":194},{"line":197,"kind":13,"containerName":"next_map","name":"$line"},{"line":200,"kind":13,"containerName":"next_map","name":"$type"},{"line":200,"kind":13,"containerName":"next_map","name":"$name"},{"containerName":"next_map","kind":13,"name":"$name","line":202},{"line":203,"name":"$seqclone","containerName":"next_map","kind":13},{"line":206,"name":"$_clones","containerName":"next_map","kind":13},{"line":206,"kind":13,"containerName":"next_map","name":"$name"},{"containerName":"next_map","kind":13,"name":"$type","line":206},{"line":207,"kind":13,"containerName":"next_map","name":"$_clones"},{"containerName":"next_map","kind":13,"name":"$name","line":207},{"containerName":"next_map","kind":13,"name":"$_contigs","line":208},{"name":"$name","containerName":"next_map","kind":13,"line":208},{"definition":"my","line":210,"name":"$temp","localvar":"my","containerName":"next_map","kind":13},{"name":"$line","containerName":"next_map","kind":13,"line":213},{"kind":13,"containerName":"next_map","name":"$fh","line":213},{"containerName":"next_map","kind":13,"name":"$line","line":213},{"line":215,"kind":13,"containerName":"next_map","name":"$line"},{"name":"$_clones","containerName":"next_map","kind":13,"line":216},{"containerName":"next_map","kind":13,"name":"$name","line":216},{"containerName":"next_map","kind":13,"name":"$_contigs","line":217},{"name":"$name","kind":13,"containerName":"next_map","line":217},{"name":"$_contigs","kind":13,"containerName":"next_map","line":219},{"name":"$name","containerName":"next_map","kind":13,"line":219},{"kind":13,"containerName":"next_map","name":"$temp","line":221},{"name":"$contigNumber","containerName":"next_map","kind":13,"line":222},{"line":223,"kind":13,"containerName":"next_map","name":"$line"},{"containerName":"next_map","kind":13,"name":"$fh","line":223},{"line":224,"name":"$line","kind":13,"containerName":"next_map"},{"name":"$_clones","kind":13,"containerName":"next_map","line":225},{"line":225,"containerName":"next_map","kind":13,"name":"$name"},{"name":"$temp","containerName":"next_map","kind":13,"line":225},{"containerName":"next_map","kind":13,"name":"$_contigs","line":227},{"line":227,"containerName":"next_map","kind":13,"name":"$contigNumber"},{"name":"$temp","kind":13,"containerName":"next_map","line":228},{"containerName":"next_map","kind":13,"name":"$_contigs","line":228},{"kind":13,"containerName":"next_map","name":"$contigNumber","line":228},{"line":229,"kind":13,"containerName":"next_map","name":"$_contigs"},{"line":229,"name":"$contigNumber","kind":13,"containerName":"next_map"},{"line":230,"name":"$temp","kind":13,"containerName":"next_map"},{"name":"$_clones","kind":13,"containerName":"next_map","line":232},{"containerName":"next_map","kind":13,"name":"$name","line":232},{"line":234,"containerName":"next_map","kind":13,"name":"$_contigs"},{"line":234,"kind":13,"containerName":"next_map","name":"$contigNumber"},{"kind":13,"containerName":"next_map","name":"$_contigs","line":235},{"line":235,"name":"$contigNumber","kind":13,"containerName":"next_map"},{"kind":13,"containerName":"next_map","name":"$_contigs","line":236},{"name":"$contigNumber","containerName":"next_map","kind":13,"line":236},{"line":239,"name":"$line","containerName":"next_map","kind":13},{"line":240,"name":"$matchtype","localvar":"my","kind":13,"containerName":"next_map","definition":"my"},{"line":241,"name":"$_clones","kind":13,"containerName":"next_map"},{"line":241,"containerName":"next_map","kind":13,"name":"$name"},{"line":241,"containerName":"next_map","kind":13,"name":"$matchtype"},{"kind":13,"containerName":"next_map","name":"$line","line":243},{"line":244,"kind":13,"containerName":"next_map","name":"$_clones"},{"line":244,"kind":13,"containerName":"next_map","name":"$name"},{"line":245,"containerName":"next_map","kind":13,"name":"$_markers"},{"containerName":"next_map","kind":13,"name":"$name","line":245},{"line":246,"kind":13,"containerName":"next_map","name":"$_markers"},{"line":247,"containerName":"next_map","kind":13,"name":"$_markers"},{"kind":13,"containerName":"next_map","name":"$contigNumber","line":247},{"line":248,"name":"$_contigs","containerName":"next_map","kind":13},{"line":248,"name":"$contigNumber","kind":13,"containerName":"next_map"},{"name":"$line","kind":13,"containerName":"next_map","line":250},{"kind":13,"containerName":"next_map","name":"$bandsread","line":250},{"line":251,"localvar":"my","kind":13,"containerName":"next_map","name":"$i","definition":"my"},{"definition":"my","line":252,"name":"@numbands","localvar":"my","containerName":"next_map","kind":13},{"kind":13,"containerName":"next_map","name":"$bandsread","line":253},{"name":"$map","containerName":"next_map","kind":13,"line":255},{"line":255,"name":"core_exists","kind":12,"containerName":"next_map"},{"containerName":"next_map","kind":13,"name":"$i","line":256},{"name":"@numbands","containerName":"next_map","kind":13,"line":257},{"containerName":"next_map","kind":13,"name":"$cordata","line":257},{"line":257,"name":"$i","containerName":"next_map","kind":13},{"containerName":"next_map","kind":13,"name":"$i","line":258},{"containerName":"next_map","kind":13,"name":"$_clones","line":260},{"line":260,"name":"$name","kind":13,"containerName":"next_map"},{"containerName":"next_map","kind":13,"name":"@numbands","line":260},{"line":263,"name":"@numbands","kind":13,"containerName":"next_map"},{"name":"$_clones","containerName":"next_map","kind":13,"line":264},{"line":264,"containerName":"next_map","kind":13,"name":"$name"},{"line":264,"name":"@numbands","containerName":"next_map","kind":13},{"line":266,"name":"$_contigs","kind":13,"containerName":"next_map"},{"line":266,"kind":13,"containerName":"next_map","name":"$name"},{"line":267,"containerName":"next_map","kind":13,"name":"$_clones"},{"line":267,"name":"$name","kind":13,"containerName":"next_map"},{"containerName":"next_map","kind":13,"name":"$ctgzeropos","line":267},{"name":"$_clones","kind":13,"containerName":"next_map","line":268},{"containerName":"next_map","kind":13,"name":"$name","line":268},{"line":268,"name":"$ctgzeropos","kind":13,"containerName":"next_map"},{"kind":13,"containerName":"next_map","name":"$_contigs","line":269},{"line":269,"containerName":"next_map","kind":13,"name":"$ctgzeropos"},{"containerName":"next_map","kind":13,"name":"$ctgzeropos","line":270},{"line":273,"containerName":"next_map","kind":13,"name":"$line"},{"line":274,"containerName":"next_map","kind":13,"name":"$_clones"},{"name":"$name","kind":13,"containerName":"next_map","line":274},{"containerName":"next_map","kind":13,"name":"$line","line":276},{"line":277,"name":"$_clones","kind":13,"containerName":"next_map"},{"line":277,"name":"$name","kind":13,"containerName":"next_map"},{"line":278,"kind":13,"containerName":"next_map","name":"$_clones"},{"line":278,"name":"$name","kind":13,"containerName":"next_map"},{"name":"$seqclone","kind":13,"containerName":"next_map","line":279},{"line":281,"containerName":"next_map","kind":13,"name":"$_clones"},{"line":281,"name":"$name","containerName":"next_map","kind":13},{"name":"$line","kind":13,"containerName":"next_map","line":285},{"kind":13,"containerName":"next_map","name":"$_clones","line":286},{"line":286,"name":"$name","kind":13,"containerName":"next_map"},{"line":288,"kind":13,"containerName":"next_map","name":"$line"},{"line":289,"name":"$_clones","containerName":"next_map","kind":13},{"line":289,"containerName":"next_map","kind":13,"name":"$name"},{"line":290,"name":"$_clones","kind":13,"containerName":"next_map"},{"line":290,"name":"$name","containerName":"next_map","kind":13},{"name":"$line","kind":13,"containerName":"next_map","line":292},{"line":293,"name":"$_clones","containerName":"next_map","kind":13},{"name":"$name","containerName":"next_map","kind":13,"line":293},{"line":294,"kind":13,"containerName":"next_map","name":"$_clones"},{"line":294,"kind":13,"containerName":"next_map","name":"$name"},{"line":298,"name":"$curClone","kind":13,"containerName":"next_map"},{"line":300,"containerName":"next_map","kind":13,"name":"$self"},{"line":300,"containerName":"next_map","kind":12,"name":"verbose"},{"name":"$curClone","kind":13,"containerName":"next_map","line":300},{"containerName":"next_map","kind":13,"name":"$map","line":303},{"name":"_setCloneRef","kind":12,"containerName":"next_map","line":303},{"containerName":"next_map","kind":13,"name":"%_clones","line":303},{"line":304,"name":"$line","kind":13,"containerName":"next_map"},{"name":"$fh","kind":13,"containerName":"next_map","line":304},{"name":"$line","kind":13,"containerName":"next_map","line":306},{"kind":13,"containerName":"next_map","name":"$fh","line":306},{"line":306,"containerName":"next_map","kind":13,"name":"$line"},{"localvar":"my","containerName":"next_map","kind":13,"name":"$type","line":307,"definition":"my"},{"line":307,"kind":13,"containerName":"next_map","name":"$name"},{"line":309,"name":"$line","containerName":"next_map","kind":13},{"line":311,"kind":13,"containerName":"next_map","name":"$type"},{"name":"$name","containerName":"next_map","kind":13,"line":311},{"name":"$_markers","containerName":"next_map","kind":13,"line":313},{"name":"$name","containerName":"next_map","kind":13,"line":313},{"line":313,"name":"$type","containerName":"next_map","kind":13},{"line":314,"name":"$_markers","containerName":"next_map","kind":13},{"line":314,"containerName":"next_map","kind":13,"name":"$name"},{"line":315,"name":"$_markers","kind":13,"containerName":"next_map"},{"containerName":"next_map","kind":13,"name":"$name","line":315},{"name":"$_markers","kind":13,"containerName":"next_map","line":316},{"line":316,"containerName":"next_map","kind":13,"name":"$name"},{"containerName":"next_map","kind":13,"name":"$line","line":318},{"line":318,"name":"$fh","containerName":"next_map","kind":13},{"kind":13,"containerName":"next_map","name":"$line","line":318},{"name":"$line","kind":13,"containerName":"next_map","line":319},{"containerName":"next_map","localvar":"my","kind":13,"name":"$position","line":320,"definition":"my"},{"containerName":"next_map","kind":13,"name":"$position","line":321},{"name":"$position","kind":13,"containerName":"next_map","line":321},{"containerName":"next_map","kind":13,"name":"$_markers","line":323},{"kind":13,"containerName":"next_map","name":"$name","line":323},{"line":323,"name":"$position","kind":13,"containerName":"next_map"},{"line":324,"name":"$_markers","containerName":"next_map","kind":13},{"line":324,"containerName":"next_map","kind":13,"name":"$name"},{"name":"$_markers","containerName":"next_map","kind":13,"line":325},{"containerName":"next_map","kind":13,"name":"$name","line":325},{"name":"$_markers","kind":13,"containerName":"next_map","line":328},{"containerName":"next_map","kind":13,"name":"$name","line":328},{"line":331,"kind":13,"containerName":"next_map","name":"$_markers"},{"line":331,"kind":13,"containerName":"next_map","name":"$name"},{"line":334,"kind":13,"containerName":"next_map","name":"$line"},{"kind":13,"localvar":"my","containerName":"next_map","name":"$grpmatch","line":335,"definition":"my"},{"definition":"my","line":336,"localvar":"my","containerName":"next_map","kind":13,"name":"$grptype"},{"kind":13,"containerName":"next_map","name":"$map","line":336},{"line":336,"name":"group_type","kind":12,"containerName":"next_map"},{"line":338,"kind":13,"containerName":"next_map","name":"$grpmatch"},{"name":"$group","localvar":"my","kind":13,"containerName":"next_map","line":340,"definition":"my"},{"line":340,"name":"$subgroup","containerName":"next_map","kind":13},{"line":341,"name":"$group","kind":13,"containerName":"next_map"},{"containerName":"next_map","kind":13,"name":"$subgroup","line":342},{"line":344,"name":"$subgroup","kind":13,"containerName":"next_map"},{"line":344,"name":"$subgroup","containerName":"next_map","kind":13},{"line":344,"containerName":"next_map","kind":13,"name":"$subgroup"},{"kind":13,"containerName":"next_map","name":"$_markers","line":346},{"line":346,"name":"$name","kind":13,"containerName":"next_map"},{"line":346,"name":"$group","kind":13,"containerName":"next_map"},{"name":"$_markers","containerName":"next_map","kind":13,"line":347},{"line":347,"name":"$name","containerName":"next_map","kind":13},{"line":347,"kind":13,"containerName":"next_map","name":"$subgroup"},{"line":349,"name":"$line","containerName":"next_map","kind":13},{"kind":13,"containerName":"next_map","name":"$_markers","line":350},{"containerName":"next_map","kind":13,"name":"$name","line":350},{"name":"$_markers","kind":13,"containerName":"next_map","line":351},{"kind":13,"containerName":"next_map","name":"$name","line":351},{"name":"$_markers","kind":13,"containerName":"next_map","line":354},{"line":354,"kind":13,"containerName":"next_map","name":"$name"},{"containerName":"next_map","kind":13,"name":"$_markers","line":357},{"line":357,"containerName":"next_map","kind":13,"name":"$name"},{"line":360,"name":"$line","containerName":"next_map","kind":13},{"name":"$_markers","kind":13,"containerName":"next_map","line":361},{"line":361,"name":"$name","containerName":"next_map","kind":13},{"line":363,"name":"$line","kind":13,"containerName":"next_map"},{"name":"$_markers","containerName":"next_map","kind":13,"line":364},{"line":364,"name":"$name","containerName":"next_map","kind":13},{"containerName":"next_map","kind":13,"name":"$_markers","line":365},{"containerName":"next_map","kind":13,"name":"$name","line":365},{"containerName":"next_map","kind":13,"name":"$curMarker","line":368},{"line":370,"name":"$self","containerName":"next_map","kind":13},{"name":"verbose","kind":12,"containerName":"next_map","line":370},{"line":370,"containerName":"next_map","kind":13,"name":"$curMarker"},{"line":373,"kind":13,"containerName":"next_map","name":"$map"},{"name":"_setMarkerRef","containerName":"next_map","kind":12,"line":373},{"line":373,"name":"%_markers","containerName":"next_map","kind":13},{"definition":"my","line":375,"name":"$ctgname","containerName":"next_map","localvar":"my","kind":13},{"localvar":"my","kind":13,"containerName":"next_map","name":"$grpabbr","line":376,"definition":"my"},{"name":"$map","kind":13,"containerName":"next_map","line":376},{"line":376,"name":"group_abbr","containerName":"next_map","kind":12},{"definition":"my","localvar":"my","kind":13,"containerName":"next_map","name":"$chr_remark","line":377},{"line":379,"name":"$_contigs","kind":13,"containerName":"next_map"},{"kind":13,"containerName":"next_map","name":"$line","line":381},{"line":381,"containerName":"next_map","kind":13,"name":"$fh"},{"line":383,"name":"$line","containerName":"next_map","kind":13},{"name":"$ctgname","containerName":"next_map","kind":13,"line":384},{"line":385,"name":"$_contigs","containerName":"next_map","kind":13},{"line":385,"name":"$ctgname","kind":13,"containerName":"next_map"},{"name":"$_contigs","containerName":"next_map","kind":13,"line":386},{"kind":13,"containerName":"next_map","name":"$ctgname","line":386},{"kind":13,"containerName":"next_map","name":"$_contigs","line":387},{"line":387,"name":"$ctgname","kind":13,"containerName":"next_map"},{"name":"$line","kind":13,"containerName":"next_map","line":389},{"name":"$_contigs","kind":13,"containerName":"next_map","line":390},{"containerName":"next_map","kind":13,"name":"$ctgname","line":390},{"line":391,"containerName":"next_map","kind":13,"name":"$line"},{"name":"$_contigs","kind":13,"containerName":"next_map","line":392},{"name":"$ctgname","kind":13,"containerName":"next_map","line":392},{"line":393,"name":"$_contigs","kind":13,"containerName":"next_map"},{"name":"$ctgname","kind":13,"containerName":"next_map","line":393},{"line":397,"name":"$line","containerName":"next_map","kind":13},{"containerName":"next_map","kind":13,"name":"$_contigs","line":399},{"line":399,"kind":13,"containerName":"next_map","name":"$ctgname"},{"name":"$_contigs","containerName":"next_map","kind":13,"line":400},{"line":400,"name":"$ctgname","kind":13,"containerName":"next_map"},{"line":403,"name":"$_contigs","containerName":"next_map","kind":13},{"name":"$ctgname","containerName":"next_map","kind":13,"line":403},{"line":406,"name":"$_contigs","kind":13,"containerName":"next_map"},{"line":406,"name":"$ctgname","kind":13,"containerName":"next_map"},{"line":409,"name":"$line","kind":13,"containerName":"next_map"},{"line":410,"containerName":"next_map","kind":13,"name":"$_contigs"},{"line":410,"containerName":"next_map","kind":13,"name":"$ctgname"},{"line":412,"kind":13,"containerName":"next_map","name":"$line"},{"containerName":"next_map","kind":13,"name":"$_contigs","line":413},{"kind":13,"containerName":"next_map","name":"$ctgname","line":413},{"containerName":"next_map","kind":13,"name":"$grpabbr","line":415},{"name":"$line","kind":13,"containerName":"next_map","line":415},{"kind":13,"localvar":"my","containerName":"next_map","name":"$grpmatch","line":417,"definition":"my"},{"localvar":"my","kind":13,"containerName":"next_map","name":"$pos","line":418,"definition":"my"},{"name":"$pos","containerName":"next_map","kind":13,"line":419},{"line":420,"name":"$pos","containerName":"next_map","kind":13},{"name":"$_contigs","kind":13,"containerName":"next_map","line":423},{"line":423,"name":"$ctgname","containerName":"next_map","kind":13},{"kind":13,"containerName":"next_map","name":"$_contigs","line":424},{"line":424,"name":"$ctgname","containerName":"next_map","kind":13},{"name":"$pos","containerName":"next_map","kind":13,"line":424},{"line":425,"containerName":"next_map","kind":13,"name":"$_contigs"},{"line":425,"name":"$ctgname","containerName":"next_map","kind":13},{"line":427,"name":"$grpmatch","containerName":"next_map","kind":13},{"line":428,"name":"$_contigs","containerName":"next_map","kind":13},{"name":"$ctgname","kind":13,"containerName":"next_map","line":428},{"line":430,"containerName":"next_map","kind":13,"name":"$grpmatch"},{"definition":"my","name":"$group","localvar":"my","kind":13,"containerName":"next_map","line":432},{"line":432,"name":"$subgroup","containerName":"next_map","kind":13},{"containerName":"next_map","kind":13,"name":"$group","line":433},{"kind":13,"containerName":"next_map","name":"$grpabbr","line":433},{"name":"$subgroup","kind":13,"containerName":"next_map","line":434},{"name":"$grpabbr","containerName":"next_map","kind":13,"line":434},{"name":"$group","kind":13,"containerName":"next_map","line":436},{"containerName":"next_map","kind":13,"name":"$grpabbr","line":436},{"kind":13,"containerName":"next_map","name":"$subgroup","line":437},{"containerName":"next_map","kind":13,"name":"$grpabbr","line":437},{"line":439,"name":"$subgroup","kind":13,"containerName":"next_map"},{"kind":13,"containerName":"next_map","name":"$subgroup","line":439},{"line":439,"containerName":"next_map","kind":13,"name":"$subgroup"},{"line":440,"name":"$_contigs","containerName":"next_map","kind":13},{"line":440,"name":"$ctgname","containerName":"next_map","kind":13},{"containerName":"next_map","kind":13,"name":"$group","line":440},{"name":"$_contigs","kind":13,"containerName":"next_map","line":441},{"line":441,"name":"$ctgname","containerName":"next_map","kind":13},{"name":"$subgroup","kind":13,"containerName":"next_map","line":441},{"line":445,"name":"$_contigs","kind":13,"containerName":"next_map"},{"kind":13,"containerName":"next_map","name":"$ctgname","line":445},{"line":445,"kind":13,"containerName":"next_map","name":"$grpmatch"},{"kind":13,"containerName":"next_map","name":"$_contigs","line":449},{"containerName":"next_map","kind":13,"name":"$ctgname","line":449},{"line":450,"containerName":"next_map","kind":13,"name":"$_contigs"},{"kind":13,"containerName":"next_map","name":"$ctgname","line":450},{"kind":13,"containerName":"next_map","name":"$curContig","line":453},{"kind":13,"containerName":"next_map","name":"$self","line":455},{"name":"verbose","kind":12,"containerName":"next_map","line":455},{"line":455,"name":"$curContig","containerName":"next_map","kind":13},{"containerName":"next_map","kind":13,"name":"$map","line":458},{"line":458,"name":"_setContigRef","kind":12,"containerName":"next_map"},{"name":"%_contigs","containerName":"next_map","kind":13,"line":458},{"name":"$map","kind":13,"containerName":"next_map","line":459},{"containerName":"next_map","kind":12,"name":"_calc_markerposition","line":459},{"name":"$map","containerName":"next_map","kind":13,"line":460},{"line":460,"kind":12,"containerName":"next_map","name":"_calc_contigposition"},{"name":"$map","kind":13,"containerName":"next_map","line":460},{"name":"version","kind":12,"containerName":"next_map","line":460},{"line":461,"name":"$map","containerName":"next_map","kind":13},{"line":461,"name":"_calc_contiggroup","containerName":"next_map","kind":12},{"line":461,"name":"$map","kind":13,"containerName":"next_map"},{"name":"version","containerName":"next_map","kind":12,"line":461},{"kind":13,"containerName":"next_map","name":"$map","line":463}],"name":"next_map","containerName":"main::","signature":{"label":"next_map($self)","parameters":[{"label":"$self"}],"documentation":"# fpc.pm,v 1.2.2.1 2005/10/09 15:16:27 jason Exp\n#\n# BioPerl module for Bio::MapIO::fpc\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gaurav Gupta <gaurav@genome.arizona.edu>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::MapIO::fpc - A FPC Map reader\n\n=head1 SYNOPSIS\n\n# do not use this object directly it is accessed through the Bio::MapIO system\n\n    use Bio::MapIO;\n\n     -format  : specifies the format of the file format is \"fpc\",\n     -file    : specifies the name of the .fpc file\n     -readcor : boolean argument, indicating if .cor is to be read\n                 or not. It looks for the .cor file in the same path\n                 as .fpc file.\n                 0 : doesn't read .cor file\n                 1 : reads the .cor file\n                 [default 0]\n     -verbose : indicates the process of loading of fpc file\n    my $mapio = Bio::MapIO->new(-format  => \"fpc\",\n                               -file    => \"rice.fpc\",\n                               -readcor => 0,\n                               -verbose => 0);\n\n    my $map = $mapio->next_map();\n\n    foreach my $marker ( $map->each_markerid() ) {\n         # loop through the markers associated with the map\n         # likewise for contigs, clones, etc.\n    }\n\n\n=head1 DESCRIPTION\n\nThis object contains code for parsing and processing FPC files and creating\nL<Bio::Map::Physical> object from it.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\nWe handle reading of the FPC ourselves, since MapIO module of Bioperl adds\ntoo much overhead.\n\n\n# Let the code begin...\n\npackage Bio::MapIO::fpc;\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Physical;\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\nuse Bio::Range;\n\nuse base qw(Bio::MapIO);\n\nmy $_readcor;\n\n=head1 Initializer\n\n=head2 _initialize\n\n Title   : _initialize\n Usage   : called implicitly\n Function: calls the SUPER::_initialize\n Returns : nothing\n Args    : species, readcor\n\n\nsub _initialize{\n    my ($self,@args) = @_;\n    my $species;\n    $self->SUPER::_initialize(@args);\n    ($species,$_readcor) = $self->_rearrange([qw(SPECIES READCOR)], @args);\n    $_readcor = 0 unless (defined($_readcor));\n}\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 next_map\n\n Title   : next_map\n Usage   : my $fpcmap = $mapio->next_map();\n Function: gets the fpcmap from MapIO\n Returns : object of type L<Bio::Map::MapI>\n Args    : none"},"line":109,"range":{"end":{"character":9999,"line":464},"start":{"character":0,"line":109}},"kind":12},{"kind":12,"containerName":"Map::Physical","name":"Bio","line":128},{"line":320,"kind":12,"name":"floor"},{"kind":12,"name":"floor","line":324},{"line":477,"kind":12,"range":{"start":{"line":477,"character":0},"end":{"line":480,"character":9999}},"signature":{"documentation":"# fpc.pm,v 1.2.2.1 2005/10/09 15:16:27 jason Exp\n#\n# BioPerl module for Bio::MapIO::fpc\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gaurav Gupta <gaurav@genome.arizona.edu>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::MapIO::fpc - A FPC Map reader\n\n=head1 SYNOPSIS\n\n# do not use this object directly it is accessed through the Bio::MapIO system\n\n    use Bio::MapIO;\n\n     -format  : specifies the format of the file format is \"fpc\",\n     -file    : specifies the name of the .fpc file\n     -readcor : boolean argument, indicating if .cor is to be read\n                 or not. It looks for the .cor file in the same path\n                 as .fpc file.\n                 0 : doesn't read .cor file\n                 1 : reads the .cor file\n                 [default 0]\n     -verbose : indicates the process of loading of fpc file\n    my $mapio = Bio::MapIO->new(-format  => \"fpc\",\n                               -file    => \"rice.fpc\",\n                               -readcor => 0,\n                               -verbose => 0);\n\n    my $map = $mapio->next_map();\n\n    foreach my $marker ( $map->each_markerid() ) {\n         # loop through the markers associated with the map\n         # likewise for contigs, clones, etc.\n    }\n\n\n=head1 DESCRIPTION\n\nThis object contains code for parsing and processing FPC files and creating\nL<Bio::Map::Physical> object from it.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\nWe handle reading of the FPC ourselves, since MapIO module of Bioperl adds\ntoo much overhead.\n\n\n# Let the code begin...\n\npackage Bio::MapIO::fpc;\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Physical;\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\nuse Bio::Range;\n\nuse base qw(Bio::MapIO);\n\nmy $_readcor;\n\n=head1 Initializer\n\n=head2 _initialize\n\n Title   : _initialize\n Usage   : called implicitly\n Function: calls the SUPER::_initialize\n Returns : nothing\n Args    : species, readcor\n\n\nsub _initialize{\n    my ($self,@args) = @_;\n    my $species;\n    $self->SUPER::_initialize(@args);\n    ($species,$_readcor) = $self->_rearrange([qw(SPECIES READCOR)], @args);\n    $_readcor = 0 unless (defined($_readcor));\n}\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 next_map\n\n Title   : next_map\n Usage   : my $fpcmap = $mapio->next_map();\n Function: gets the fpcmap from MapIO\n Returns : object of type L<Bio::Map::MapI>\n Args    : none\n\n\nsub next_map{\n\n    my ($self) = @_;\n\n    my $line;\n    my ($name,$fpcver,$moddate,$moduser,$contigcnt,$clonecnt,$markerscnt,\n        $bandcnt,$marker,$seqclone);\n    my ($corfile,$corindex,$BUFFER);\n    my @cordata;\n    my %fpcmarker;\n    my ($contig, $contigNumber);\n    my $curClone  = 0;\n    my $curMarker = 0;\n    my $curContig = 0;\n    my %_clones;\n    my %_markers;\n    my %_contigs;\n    my $ctgzeropos = 1;\n\n    my $map = Bio::Map::Physical->new('-units' => 'CB',\n                                     '-type'  => 'physical');\n\n    my $filename = $self->file();\n    my $fh = $self->{'_filehandle'};\n\n    if (defined($_readcor)) {\n        $map->core_exists($_readcor);\n    }\n    else {\n        $map->core_exists(0);\n    }\n\n    if ($map->core_exists()) {\n        $corfile = substr($filename,0,length($filename)-3).\"cor\";\n        if (open(CORE,$corfile)) {\n            while(read(CORE,$BUFFER,2)) {\n                push(@cordata,unpack('n*', $BUFFER));\n            }\n        }\n        else {\n            $map->core_exists(0);\n        }\n    }\n\n    ## Read in the header\n    while (defined($line = <$fh>)) {\n        chomp($line);\n\n        if ($line =~ m{^//\\s+fpc\\s+project\\s+(.+)}) { $map->name($1); }\n        if ($line =~ m{^//\\s+([\\d.]+)}) {\n            my $version = $1;\n            $version =~ /((\\d+)\\.(\\d+))(.*)/;\n            $map->version($1);\n            if ($line =~ /User:\\s+(.+)/) { $map->modification_user($1); }\n        }\n\n        if ($line =~ m{^//\\s+Framework\\s+(\\w+)\\s+(\\w+)\\s+([-\\w]+)\\s+(\\w+)\\s+(\\w+)\\s+(.+)$})\n        {\n            $map->group_type($3) if ($2 eq \"Label\");\n            $map->group_abbr($5) if ($4 eq \"Abbrev\");\n        }\n\n        last unless ($line =~ m{^//});\n    }\n\n    if (!defined($map->group_type()) || !defined($map->group_abbr()) ) {\n        $map->group_type(\"Chromosome\");\n        $map->group_abbr(\"Chr\");\n    }\n\n    $_contigs{0}{'range'}{'end'}   = 0;\n    $_contigs{0}{'range'}{'start'} = 0;\n\n    ## Read in the clone data\n    while (defined($line = <$fh>)) {\n        $marker = 0;\n        $contig = 0;\n        $seqclone = 0;\n        $contigNumber = 0;\n\n        my ($type,$name);\n        my (@amatch,@pmatch,@ematch);\n\n        my $bandsread = 0;\n\n        last if ($line =~ /^Markerdata/);\n\n\n        $line =~ /^(\\w+)\\s+:\\s+\"(.+)\"/;\n\n        ## these will be set if we did find the clone line\n        ($type, $name) = ($1, $2);\n\n        if ($name =~ /sd1/) {\n            $seqclone = 1;\n        }\n\n        $_clones{$name}{'type'} = $type;\n        $_clones{$name}{'contig'} = 0;\n        $_contigs{'0'}{'clones'}{$name}  = 0;\n\n        my $temp;\n\n        ## Loop through the following lines, getting attributes for clone\n        while (defined($line = <$fh>) && $line !~ /^\\s*\\n$/)  {\n\n            if ($line =~ /^Map \"ctg(\\d+)\" Ends (Left|Right) ([-\\d]+)/)  {\n                $_clones{$name}{'contig'} = $1;\n                $_contigs{$1}{'clones'}{$name} = 0;\n\n                delete($_contigs{'0'}{'clones'}{$name});\n\n                $temp = $3;\n                $contigNumber = $1;\n                $line = <$fh>;\n                $line =~ /^Map \"ctg(\\d+)\" Ends (Left|Right) ([\\d]+)/;\n                $_clones{$name}{'range'}{'start'} = $temp;\n\n                $_contigs{$contigNumber}{'range'}{'start'} = $temp\n                    if (!exists($_contigs{$contigNumber}{'range'}{'start'})\n                        || $_contigs{$contigNumber}{'range'}{'start'}\n                        >  $temp );\n\n                $_clones{$name}{'range'}{'end'} = $3;\n\n                $_contigs{$contigNumber}{'range'}{'end'} = $3\n                    if (!exists($_contigs{$contigNumber}{'range'}{'end'})\n                        || $_contigs{$contigNumber}{'range'}{'end'} < $3 );\n\n            }\n            elsif ($line =~ /^([a-zA-Z]+)_match_to_\\w+\\s+\"(.+)\"/) {\n                my $matchtype = \"match\" . lc(substr($1, 0, 1));\n                $_clones{$name}{$matchtype}{$2} = 0;\n            }\n            elsif ($line =~ /^Positive_(\\w+)\\s+\"(.+)\"/) {\n                $_clones{$name}{'markers'}{$2} = 0;\n                $_markers{$2}{'clones'}{$name} = 0;\n                $_markers{$2}{'type'} = $1;\n                $_markers{$2}{'contigs'}{$contigNumber} = 0;\n                $_contigs{$contigNumber}{'markers'}{$2} = 0;\n            }\n            elsif ($line =~ /^Bands\\s+(\\d+)\\s+(\\d+)/ && !$bandsread) {\n                my $i = 0;\n                my @numbands;\n                $bandsread = 1;\n\n                if ($map->core_exists()) {\n                    while($i<$2){\n                        push(@numbands,$cordata[($1-1)+$i]);\n                        $i++;\n                    }\n                    $_clones{$name}{'bands'} = \\@numbands;\n                }\n                else {\n                    push(@numbands,$1,$2);\n                    $_clones{$name}{'bands'} = \\@numbands;\n                }\n                if (exists($_contigs{0}{'clones'}{$name})) {\n                    $_clones{$name}{'range'}{'start'} = $ctgzeropos;\n                    $_clones{$name}{'range'}{'end'} = $ctgzeropos + $2;\n                    $_contigs{0}{'range'}{'end'} = $ctgzeropos + $2;\n                    $ctgzeropos += $2;\n                }\n            }\n            elsif ($line =~ /^Gel_number\\s+(.+)/) {\n                $_clones{$name}{'gel'} = $1;\n            }\n            elsif ($line =~ /^Remark\\s+\"(.+)\"/)  {\n                $_clones{$name}{'remark'} .= $1;\n                $_clones{$name}{'remark'} .= \"\\n\";\n                if($seqclone == 1 ) {\n                    if( $1 =~ /\\,\\s+Chr(\\d+)\\s+/){\n                        $_clones{$name}{'group'} = $1;\n                    }\n                }\n            }\n            elsif ($line =~ /^Fp_number\\s+\"(.+)\"/) {\n                $_clones{$name}{'fp_number'} = $1;\n            }\n            elsif ($line =~ /^Shotgun\\s+(\\w+)\\s+(\\w+)/) {\n                $_clones{$name}{'sequence_type'} = $1;\n                $_clones{$name}{'sequence_status'} = $2;\n            }\n            elsif ($line =~ /^Fpc_remark\\s+\"(.+)\"/) {\n                $_clones{$name}{'fpc_remark'} .= $1;\n                $_clones{$name}{'fpc_remark'} .= \"\\n\";\n            }\n        }\n\n        $curClone++;\n        print \"Adding clone $curClone...\\n\\r\"\n            if ($self->verbose()  && $curClone % 1000 == 0);\n    }\n\n    $map->_setCloneRef(\\%_clones);\n    $line = <$fh>;\n\n    while (defined($line = <$fh>) && $line !~ /Contigdata/) {\n        my ($type,$name);\n\n        last if ($line !~ /^Marker_(\\w+)\\s+:\\s+\"(.+)\"/);\n\n        ($type, $name) = ($1, $2);\n\n        $_markers{$name}{'type'}   = $type;\n        $_markers{$name}{'group'}  = 0;\n        $_markers{$name}{'global'} = 0;\n        $_markers{$name}{'anchor'} = 0;\n\n        while (defined($line = <$fh>) && $line !~ /^\\s*\\n$/)  {\n            if ($line =~ /^Global_position\\s+([\\d.]+)\\s*(Frame)?/)  {\n                my $position = $1 - floor($1/1000)*1000;\n                $position = sprintf(\"%.2f\",$position);\n\n                $_markers{$name}{'global'} = $position;\n                $_markers{$name}{'group'}  = floor($1/1000);\n                $_markers{$name}{'anchor'} = 1;\n\n                if(defined($2)) {\n                    $_markers{$name}{'framework'} = 1;\n                }\n                else {\n                    $_markers{$name}{'framework'} = 0;\n                }\n            }\n            elsif ($line =~ /^Anchor_bin\\s+\"([\\w\\d.]+)\"/) {\n                my $grpmatch = $1;\n                my $grptype  = $map->group_type();\n\n                $grpmatch =~ /(\\d+|\\w)(.*)/;\n\n                my ($group,$subgroup);\n                $group    = $1;\n                $subgroup = $2;\n\n                $subgroup = substr($subgroup,1) if ($subgroup =~ /^\\./);\n\n                $_markers{$name}{'group'}      = $group;\n                $_markers{$name}{'subgroup'}   = $subgroup;\n            }\n            elsif ($line =~ /^Anchor_pos\\s+([\\d.]+)\\s+(F|P)?/){\n                $_markers{$name}{'global'}  = $1;\n                $_markers{$name}{'anchor'}  = 1;\n\n                if ($2 eq 'F') {\n                    $_markers{$name}{'framework'} = 1;\n                }\n                else {\n                    $_markers{$name}{'framework'} = 0;\n                }\n            }\n            elsif ($line =~ /^anchor$/) {\n                $_markers{$name}{'anchor'} = 1;\n            }\n            elsif ($line =~ /^Remark\\s+\"(.+)\"/)  {\n                $_markers{$name}{'remark'} .= $1;\n                $_markers{$name}{'remark'} .= \"\\n\";\n            }\n        }\n        $curMarker++;\n        print \"Adding Marker $curMarker...\\n\"\n            if ($self->verbose() && $curMarker % 1000 == 0);\n    }\n\n    $map->_setMarkerRef(\\%_markers);\n\n    my $ctgname;\n    my $grpabbr = $map->group_abbr();\n    my $chr_remark;\n\n    $_contigs{0}{'group'} = 0;\n\n    while (defined($line = <$fh>)) {\n\n        if ($line =~ /^Ctg(\\d+)/) {\n            $ctgname = $1;\n            $_contigs{$ctgname}{'group'}      = 0;\n            $_contigs{$ctgname}{'anchor'}     = 0;\n            $_contigs{$ctgname}{'position'}   = 0;\n\n            if ($line =~ /#\\w*(.*)\\w*$/) {\n                $_contigs{$ctgname}{'remark'} = $1;\n                if ($line =~ /#\\s+Chr(\\d+)\\s+/) {\n                    $_contigs{$ctgname}{'group'}  = $1;\n                    $_contigs{$ctgname}{'anchor'} = 1;\n                }\n            }\n        }\n        elsif ($line =~ /^Chr_remark\\s+\"(-|\\+|Chr(\\d+))\\s+(.+)\"$/) {\n\n            $_contigs{$ctgname}{'anchor'}     = 1;\n            $_contigs{$ctgname}{'chr_remark'} = $3 if(defined($3));\n\n            if (defined($2)) {\n                $_contigs{$ctgname}{'group'}  = $2;\n            }\n            else {\n                $_contigs{$ctgname}{'group'}  = \"?\";\n            }\n        }\n        elsif ($line =~ /^User_remark\\s+\"(.+)\"/) {\n            $_contigs{$ctgname}{'usr_remark'} = $1;\n        }\n        elsif ($line =~ /^Trace_remark\\s+\"(.+)\"/) {\n            $_contigs{$ctgname}{'trace_remark'} = $1;\n        }\n        elsif ($grpabbr && $line =~ /^Chr_remark\\s+\"(\\W|$grpabbr((\\d+)|(\\w+)|([.\\w\\d]+)))\\s*(\\{(.*)\\}|\\[(.*)\\])?\"\\s+(Pos\\s+((\\d.)+|NaN))(NOEDIT)?/)\n        {\n            my $grpmatch = $2;\n            my $pos = $10;\n            if ($pos eq \"NaN\") {\n                $pos = 0;\n                print \"Warning: Nan encountered for Contig position \\n\";\n            }\n            $_contigs{$ctgname}{'chr_remark'}   = $6;\n            $_contigs{$ctgname}{'position'} = $pos;\n            $_contigs{$ctgname}{'subgroup'} = 0;\n\n            if (defined($grpmatch)) {\n                $_contigs{$ctgname}{'anchor'} = 1;\n\n                if ($grpmatch =~ /((\\d+)((\\D\\d.\\d+)|(.\\d+)))|((\\w+)(\\.\\d+))/) {\n\n                    my ($group,$subgroup);\n                    $group    = $2 if($grpabbr eq \"Chr\");\n                    $subgroup = $3 if($grpabbr eq \"Chr\");\n\n                    $group    = $7 if($grpabbr eq \"Lg\");\n                    $subgroup = $8 if($grpabbr eq \"Lg\");\n\n                    $subgroup = substr($subgroup,1) if ($subgroup =~ /^\\./);\n                    $_contigs{$ctgname}{'group'}     = $group;\n                    $_contigs{$ctgname}{'subgroup'}  = $subgroup;\n\n                }\n                else {\n                    $_contigs{$ctgname}{'group'} = $grpmatch;\n                }\n            }\n            else {\n                $_contigs{$ctgname}{'anchor'} = 1;\n                $_contigs{$ctgname}{'group'}  = \"?\";\n            }\n        }\n        $curContig++;\n        print \"Adding Contig $curContig...\\n\"\n            if ($self->verbose() && $curContig % 100 == 0);\n    }\n\n    $map->_setContigRef(\\%_contigs);\n    $map->_calc_markerposition();\n    $map->_calc_contigposition() if ($map->version() < 7.0);\n    $map->_calc_contiggroup() if ($map->version() == 4.6);\n\n    return $map;\n}\n\n\n=head2 write_map\n\n Title   : write_map\n Usage   : $mapio->write_map($map);\n Function: Write a map out\n Returns : none\n Args    : Bio::Map::MapI","parameters":[{"label":"$self"},{"label":"@args"}],"label":"write_map($self,@args)"},"children":[{"definition":"my","line":478,"kind":13,"localvar":"my","containerName":"write_map","name":"$self"},{"name":"@args","kind":13,"containerName":"write_map","line":478},{"line":479,"name":"$self","containerName":"write_map","kind":13},{"line":479,"name":"throw_not_implemented","kind":12,"containerName":"write_map"}],"containerName":"main::","name":"write_map","definition":"sub","detail":"($self,@args)"}],"version":5}