{"vars":[{"line":101,"kind":2,"containerName":"strict::Scalar","name":"Util"},{"line":104,"name":"base","kind":2,"containerName":""},{"definition":"sub","detail":"($class,@args)","children":[{"definition":"my","line":130,"name":"$class","kind":13,"localvar":"my","containerName":"new"},{"line":130,"name":"@args","kind":13,"containerName":"new"},{"line":131,"containerName":"new","localvar":"my","kind":13,"name":"$self","definition":"my"},{"name":"$class","kind":13,"containerName":"new","line":131},{"kind":13,"containerName":"new","name":"@args","line":131},{"definition":"my","line":133,"kind":13,"localvar":"my","containerName":"new","name":"$map"},{"line":133,"name":"$marker","kind":13,"containerName":"new"},{"line":133,"name":"$element","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$value","line":133},{"name":"$start","containerName":"new","kind":13,"line":133},{"line":133,"containerName":"new","kind":13,"name":"$end"},{"line":133,"name":"$length","containerName":"new","kind":13},{"line":133,"containerName":"new","kind":13,"name":"$relative"},{"name":"$self","kind":13,"containerName":"new","line":134},{"containerName":"new","kind":12,"name":"_rearrange","line":134},{"line":142,"containerName":"new","kind":13,"name":"@args"},{"line":144,"name":"$do_range","containerName":"new","localvar":"my","kind":13,"definition":"my"},{"name":"$start","kind":13,"containerName":"new","line":144},{"line":144,"name":"$end","containerName":"new","kind":13},{"line":145,"containerName":"new","kind":13,"name":"$value"},{"name":"$do_range","kind":13,"containerName":"new","line":145},{"name":"$self","kind":13,"containerName":"new","line":146},{"line":146,"containerName":"new","kind":12,"name":"warn"},{"line":147,"kind":13,"containerName":"new","name":"$value"},{"name":"$map","kind":13,"containerName":"new","line":150},{"name":"$self","kind":13,"containerName":"new","line":150},{"name":"map","containerName":"new","kind":12,"line":150},{"line":150,"containerName":"new","kind":13,"name":"$map"},{"line":151,"name":"$marker","kind":13,"containerName":"new"},{"line":151,"name":"$self","containerName":"new","kind":13},{"line":151,"name":"element","containerName":"new","kind":12},{"line":151,"name":"$marker","kind":13,"containerName":"new"},{"line":152,"name":"$element","containerName":"new","kind":13},{"name":"$self","containerName":"new","kind":13,"line":152},{"line":152,"containerName":"new","kind":12,"name":"element"},{"line":152,"name":"$element","containerName":"new","kind":13},{"line":153,"name":"$relative","containerName":"new","kind":13},{"name":"$self","kind":13,"containerName":"new","line":153},{"kind":12,"containerName":"new","name":"relative","line":153},{"line":153,"containerName":"new","kind":13,"name":"$relative"},{"line":154,"kind":13,"containerName":"new","name":"$value"},{"name":"$self","containerName":"new","kind":13,"line":154},{"name":"value","kind":12,"containerName":"new","line":154},{"line":154,"containerName":"new","kind":13,"name":"$value"},{"name":"$do_range","kind":13,"containerName":"new","line":156},{"line":157,"containerName":"new","kind":13,"name":"$start"},{"kind":13,"containerName":"new","name":"$self","line":157},{"line":157,"kind":12,"containerName":"new","name":"start"},{"line":157,"kind":13,"containerName":"new","name":"$start"},{"name":"$end","kind":13,"containerName":"new","line":158},{"kind":13,"containerName":"new","name":"$self","line":158},{"containerName":"new","kind":12,"name":"end","line":158},{"line":158,"kind":13,"containerName":"new","name":"$end"},{"line":159,"name":"$length","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$start","line":160},{"line":160,"name":"$end","kind":13,"containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":161},{"line":161,"containerName":"new","kind":12,"name":"end"},{"line":161,"containerName":"new","kind":13,"name":"$start"},{"line":161,"kind":13,"containerName":"new","name":"$length"},{"line":163,"containerName":"new","kind":13,"name":"$start"},{"containerName":"new","kind":13,"name":"$self","line":164},{"line":164,"name":"start","containerName":"new","kind":12},{"line":164,"kind":13,"containerName":"new","name":"$end"},{"line":164,"name":"$length","kind":13,"containerName":"new"},{"line":167,"name":"$self","kind":13,"containerName":"new"},{"name":"end","kind":12,"containerName":"new","line":167},{"line":167,"name":"$self","kind":13,"containerName":"new"},{"kind":12,"containerName":"new","name":"end","line":167},{"kind":13,"containerName":"new","name":"$start","line":167},{"name":"$self","containerName":"new","kind":13,"line":170}],"name":"new","containerName":"main::","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Position.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Position\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Position - A single position of a Marker, or the range over which\n                     that marker lies, in a Map\n\n=head1 SYNOPSIS\n\n    use Bio::Map::Position;\n    my $position = Bio::Map::Position->new(-map => $map, \n\t\t\t\t\t  -element => $marker,\n\t\t\t\t\t  -value => 100\n\t\t\t\t\t  );\n\n\tmy $position_with_range = Bio::Map::Position->new(-map => $map, \n\t\t\t\t\t  -element => $marker,\n\t\t\t\t\t  -start => 100,\n\t\t\t\t\t  -length => 10\n\t\t\t\t\t  );\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the PositionI interface that\nhandles the specific values of a position. This allows a map element\n(e.g. Marker) to have multiple positions within a map and still be\ntreated as a single entity.\n\nThis handles the concept of a relative map in which the order of\nelements and the distance between them is known, but does not\ndirectly handle the case when distances are unknown - in that case\narbitrary values must be assigned for position values.\n\nNo units are assumed here - units are handled by context of which Map\na position is placed in or the subclass of this Position.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein@cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nChad Matsalla, bioinformatics1@dieselwurks.com\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Position;\nuse strict;\n\nuse Scalar::Util qw(looks_like_number);\nuse Bio::Map::Relative;\n\nuse base qw(Bio::Root::Root Bio::Map::PositionI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::Position->new();\n Function: Builds a new Bio::Map::Position object \n Returns : Bio::Map::Position\n Args    : -map      => Bio::Map::MapI object\n           -element  => Bio::Map::MappableI object\n           -relative => Bio::Map::RelativeI object\n\n           * If this position has no range, or if a single value can describe\n             the range *\n           -value => scalar             : something that describes the single\n                                          point position or range of this\n                                          Position, most likely an int\n\n           * Or if this position has a range, at least two of *\n           -start => int                : value of the start co-ordinate\n           -end => int                  : value of the end co-ordinate\n           -length => int               : length of the range","label":"new($class,@args)"},"line":129,"kind":12,"range":{"start":{"character":0,"line":129},"end":{"character":9999,"line":171}}},{"name":"SUPER","kind":12,"containerName":"new","line":131},{"signature":{"parameters":[{"label":"$self"},{"label":"$relative"}],"documentation":"1;\n# $Id: Position.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Position\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Position - A single position of a Marker, or the range over which\n                     that marker lies, in a Map\n\n=head1 SYNOPSIS\n\n    use Bio::Map::Position;\n    my $position = Bio::Map::Position->new(-map => $map, \n\t\t\t\t\t  -element => $marker,\n\t\t\t\t\t  -value => 100\n\t\t\t\t\t  );\n\n\tmy $position_with_range = Bio::Map::Position->new(-map => $map, \n\t\t\t\t\t  -element => $marker,\n\t\t\t\t\t  -start => 100,\n\t\t\t\t\t  -length => 10\n\t\t\t\t\t  );\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the PositionI interface that\nhandles the specific values of a position. This allows a map element\n(e.g. Marker) to have multiple positions within a map and still be\ntreated as a single entity.\n\nThis handles the concept of a relative map in which the order of\nelements and the distance between them is known, but does not\ndirectly handle the case when distances are unknown - in that case\narbitrary values must be assigned for position values.\n\nNo units are assumed here - units are handled by context of which Map\na position is placed in or the subclass of this Position.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein@cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nChad Matsalla, bioinformatics1@dieselwurks.com\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Position;\nuse strict;\n\nuse Scalar::Util qw(looks_like_number);\nuse Bio::Map::Relative;\n\nuse base qw(Bio::Root::Root Bio::Map::PositionI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::Position->new();\n Function: Builds a new Bio::Map::Position object \n Returns : Bio::Map::Position\n Args    : -map      => Bio::Map::MapI object\n           -element  => Bio::Map::MappableI object\n           -relative => Bio::Map::RelativeI object\n\n           * If this position has no range, or if a single value can describe\n             the range *\n           -value => scalar             : something that describes the single\n                                          point position or range of this\n                                          Position, most likely an int\n\n           * Or if this position has a range, at least two of *\n           -start => int                : value of the start co-ordinate\n           -end => int                  : value of the end co-ordinate\n           -length => int               : length of the range\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\t\n    my ($map, $marker, $element, $value, $start, $end, $length, $relative) = \n\t$self->_rearrange([qw( MAP\n\t\t\t       MARKER\n                   ELEMENT\n\t\t\t       VALUE\n\t\t\t\t   START\n\t\t\t\t   END\n\t\t\t\t   LENGTH\n                   RELATIVE\n\t\t\t       )], @args);\n\t\n    my $do_range = defined($start) || defined($end);\n    if ($value && $do_range) {\n        $self->warn(\"-value and (-start|-end|-length) are mutually exclusive, ignoring value\");\n\t\t$value = undef;\n    }\n\t\n    $map            && $self->map($map);\n    $marker         && $self->element($marker); # backwards compatibility\n    $element        && $self->element($element);\n    $relative       && $self->relative($relative);\n    defined($value) && $self->value($value);\n\t\n    if ($do_range) {\n\t\tdefined($start) && $self->start($start);\n\t\tdefined($end)   && $self->end($end);\n\t\tif ($length) {\n\t\t\tif (defined($start) && ! defined($end)) {\n\t\t\t\t$self->end($start + $length - 1);\n\t\t\t}\n\t\t\telsif (! defined($start)) {\n\t\t\t\t$self->start($end - $length + 1);\n\t\t\t}\n\t\t}\n\t\tdefined($self->end) || $self->end($start);\n    }\n\t\n    return $self;\n}\n\n=head2 relative\n\n  Title   : relative\n  Usage   : my $relative = $position->relative();\n            $position->relative($relative);\n  Function: Get/set the thing this Position's coordinates (numerical(), start(),\n            end()) are relative to, as described by a Relative object.\n  Returns : Bio::Map::RelativeI (default is one describing \"relative to the\n            start of the Position's map\")\n  Args    : none to get, OR\n            Bio::Map::RelativeI to set","label":"relative($self,$relative)"},"kind":12,"range":{"end":{"line":196,"character":9999},"start":{"character":0,"line":187}},"line":187,"detail":"($self,$relative)","definition":"sub","containerName":"main::","name":"relative","children":[{"definition":"my","line":188,"name":"$self","localvar":"my","containerName":"relative","kind":13},{"line":188,"containerName":"relative","kind":13,"name":"$relative"},{"line":189,"name":"$relative","kind":13,"containerName":"relative"},{"line":190,"kind":13,"containerName":"relative","name":"$self"},{"line":190,"name":"throw","containerName":"relative","kind":12},{"containerName":"relative","kind":13,"name":"$relative","line":190},{"name":"$self","kind":13,"containerName":"relative","line":191},{"line":191,"kind":12,"containerName":"relative","name":"throw"},{"line":191,"name":"$relative","containerName":"relative","kind":13},{"line":191,"kind":12,"containerName":"relative","name":"isa"},{"name":"$self","kind":13,"containerName":"relative","line":192},{"name":"$self","kind":13,"containerName":"relative","line":193},{"line":193,"name":"$relative","containerName":"relative","kind":13},{"name":"$self","containerName":"relative","kind":13,"line":195},{"line":195,"kind":13,"containerName":"relative","name":"$self"},{"containerName":"relative","kind":12,"name":"absolute_relative","line":195}]},{"line":192,"kind":12,"name":"_relative_not_implicit"},{"kind":12,"name":"_relative","line":193},{"line":195,"kind":12,"name":"_relative"},{"definition":"sub","name":"absolute","containerName":"main::","children":[{"definition":"my","line":223,"name":"$self","localvar":"my","containerName":"absolute","kind":13},{"name":"$self","containerName":"absolute","kind":13,"line":224},{"name":"$self","containerName":"absolute","kind":13,"line":225}],"range":{"start":{"line":222,"character":0},"end":{"line":226,"character":9999}},"kind":12,"line":222},{"name":"_absolute","kind":12,"line":224},{"line":225,"kind":12,"name":"_absolute"},{"containerName":"main::","name":"value","children":[{"definition":"my","line":239,"containerName":"value","localvar":"my","kind":13,"name":"$self"},{"line":239,"kind":13,"containerName":"value","name":"$value"},{"name":"$value","kind":13,"containerName":"value","line":240},{"containerName":"value","kind":13,"name":"$self","line":241},{"name":"$value","containerName":"value","kind":13,"line":241},{"kind":13,"containerName":"value","name":"$self","line":242},{"name":"start","containerName":"value","kind":12,"line":242},{"line":242,"name":"$self","kind":13,"containerName":"value"},{"containerName":"value","kind":12,"name":"numeric","line":242},{"line":242,"name":"$self","kind":13,"containerName":"value"},{"line":242,"name":"start","containerName":"value","kind":12},{"line":243,"name":"$self","containerName":"value","kind":13},{"line":243,"kind":12,"containerName":"value","name":"end"},{"line":243,"containerName":"value","kind":13,"name":"$self"},{"line":243,"containerName":"value","kind":12,"name":"numeric"},{"name":"$self","kind":13,"containerName":"value","line":243},{"kind":12,"containerName":"value","name":"end","line":243},{"line":245,"name":"$self","kind":13,"containerName":"value"}],"detail":"($self,$value)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":238},"end":{"line":246,"character":9999}},"line":238,"signature":{"label":"value($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Position.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Position\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Position - A single position of a Marker, or the range over which\n                     that marker lies, in a Map\n\n=head1 SYNOPSIS\n\n    use Bio::Map::Position;\n    my $position = Bio::Map::Position->new(-map => $map, \n\t\t\t\t\t  -element => $marker,\n\t\t\t\t\t  -value => 100\n\t\t\t\t\t  );\n\n\tmy $position_with_range = Bio::Map::Position->new(-map => $map, \n\t\t\t\t\t  -element => $marker,\n\t\t\t\t\t  -start => 100,\n\t\t\t\t\t  -length => 10\n\t\t\t\t\t  );\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the PositionI interface that\nhandles the specific values of a position. This allows a map element\n(e.g. Marker) to have multiple positions within a map and still be\ntreated as a single entity.\n\nThis handles the concept of a relative map in which the order of\nelements and the distance between them is known, but does not\ndirectly handle the case when distances are unknown - in that case\narbitrary values must be assigned for position values.\n\nNo units are assumed here - units are handled by context of which Map\na position is placed in or the subclass of this Position.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein@cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nChad Matsalla, bioinformatics1@dieselwurks.com\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Position;\nuse strict;\n\nuse Scalar::Util qw(looks_like_number);\nuse Bio::Map::Relative;\n\nuse base qw(Bio::Root::Root Bio::Map::PositionI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::Position->new();\n Function: Builds a new Bio::Map::Position object \n Returns : Bio::Map::Position\n Args    : -map      => Bio::Map::MapI object\n           -element  => Bio::Map::MappableI object\n           -relative => Bio::Map::RelativeI object\n\n           * If this position has no range, or if a single value can describe\n             the range *\n           -value => scalar             : something that describes the single\n                                          point position or range of this\n                                          Position, most likely an int\n\n           * Or if this position has a range, at least two of *\n           -start => int                : value of the start co-ordinate\n           -end => int                  : value of the end co-ordinate\n           -length => int               : length of the range\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\t\n    my ($map, $marker, $element, $value, $start, $end, $length, $relative) = \n\t$self->_rearrange([qw( MAP\n\t\t\t       MARKER\n                   ELEMENT\n\t\t\t       VALUE\n\t\t\t\t   START\n\t\t\t\t   END\n\t\t\t\t   LENGTH\n                   RELATIVE\n\t\t\t       )], @args);\n\t\n    my $do_range = defined($start) || defined($end);\n    if ($value && $do_range) {\n        $self->warn(\"-value and (-start|-end|-length) are mutually exclusive, ignoring value\");\n\t\t$value = undef;\n    }\n\t\n    $map            && $self->map($map);\n    $marker         && $self->element($marker); # backwards compatibility\n    $element        && $self->element($element);\n    $relative       && $self->relative($relative);\n    defined($value) && $self->value($value);\n\t\n    if ($do_range) {\n\t\tdefined($start) && $self->start($start);\n\t\tdefined($end)   && $self->end($end);\n\t\tif ($length) {\n\t\t\tif (defined($start) && ! defined($end)) {\n\t\t\t\t$self->end($start + $length - 1);\n\t\t\t}\n\t\t\telsif (! defined($start)) {\n\t\t\t\t$self->start($end - $length + 1);\n\t\t\t}\n\t\t}\n\t\tdefined($self->end) || $self->end($start);\n    }\n\t\n    return $self;\n}\n\n=head2 relative\n\n  Title   : relative\n  Usage   : my $relative = $position->relative();\n            $position->relative($relative);\n  Function: Get/set the thing this Position's coordinates (numerical(), start(),\n            end()) are relative to, as described by a Relative object.\n  Returns : Bio::Map::RelativeI (default is one describing \"relative to the\n            start of the Position's map\")\n  Args    : none to get, OR\n            Bio::Map::RelativeI to set\n\n\nsub relative {\n    my ($self, $relative) = @_;\n    if ($relative) {\n        $self->throw(\"Must supply an object\") unless ref($relative);\n        $self->throw(\"This is [$relative], not a Bio::Map::RelativeI\") unless $relative->isa('Bio::Map::RelativeI');\n        $self->{_relative_not_implicit} = 1;\n        $self->{_relative} = $relative;\n    }\n    return $self->{_relative} || $self->absolute_relative;\n}\n\n=head2 absolute\n\n  Title   : absolute\n  Usage   : my $absolute = $position->absolute();\n            $position->absolute($absolute);\n  Function: Get/set how this Position's co-ordinates (numerical(), start(),\n            end()) are reported. When absolute is off, co-ordinates are\n            relative to the thing described by relative(). Ie. the value\n            returned by start() will be the same as the value you set start()\n            to. When absolute is on, co-ordinates are converted to be relative\n            to the start of the map.\n\n            So if relative() currently points to a Relative object describing\n            \"relative to another position which is 100 bp from the start of\n            the map\", this Position's start() had been set to 50 and absolute()\n            returns 1, $position->start() will return 150. If absolute() returns\n            0 in the same situation, $position->start() would return 50.\n\n  Returns : boolean (default 0)\n  Args    : none to get, OR\n            boolean to set\n\n\nsub absolute {\n    my $self = shift;\n    if (@_) { $self->{_absolute} = shift }\n    return $self->{_absolute} || 0;\n}\n\n=head2 value\n\n Title   : value\n Usage   : my $pos = $position->value;\n Function: Get/Set the value for this postion\n Returns : scalar, value\n Args    : [optional] new value to set"}},{"line":261,"range":{"start":{"character":0,"line":261},"end":{"line":281,"character":9999}},"kind":12,"signature":{"label":"numeric($self,$value)","documentation":"1;\n# $Id: Position.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Position\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Position - A single position of a Marker, or the range over which\n                     that marker lies, in a Map\n\n=head1 SYNOPSIS\n\n    use Bio::Map::Position;\n    my $position = Bio::Map::Position->new(-map => $map, \n\t\t\t\t\t  -element => $marker,\n\t\t\t\t\t  -value => 100\n\t\t\t\t\t  );\n\n\tmy $position_with_range = Bio::Map::Position->new(-map => $map, \n\t\t\t\t\t  -element => $marker,\n\t\t\t\t\t  -start => 100,\n\t\t\t\t\t  -length => 10\n\t\t\t\t\t  );\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the PositionI interface that\nhandles the specific values of a position. This allows a map element\n(e.g. Marker) to have multiple positions within a map and still be\ntreated as a single entity.\n\nThis handles the concept of a relative map in which the order of\nelements and the distance between them is known, but does not\ndirectly handle the case when distances are unknown - in that case\narbitrary values must be assigned for position values.\n\nNo units are assumed here - units are handled by context of which Map\na position is placed in or the subclass of this Position.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein@cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nChad Matsalla, bioinformatics1@dieselwurks.com\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Position;\nuse strict;\n\nuse Scalar::Util qw(looks_like_number);\nuse Bio::Map::Relative;\n\nuse base qw(Bio::Root::Root Bio::Map::PositionI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::Position->new();\n Function: Builds a new Bio::Map::Position object \n Returns : Bio::Map::Position\n Args    : -map      => Bio::Map::MapI object\n           -element  => Bio::Map::MappableI object\n           -relative => Bio::Map::RelativeI object\n\n           * If this position has no range, or if a single value can describe\n             the range *\n           -value => scalar             : something that describes the single\n                                          point position or range of this\n                                          Position, most likely an int\n\n           * Or if this position has a range, at least two of *\n           -start => int                : value of the start co-ordinate\n           -end => int                  : value of the end co-ordinate\n           -length => int               : length of the range\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\t\n    my ($map, $marker, $element, $value, $start, $end, $length, $relative) = \n\t$self->_rearrange([qw( MAP\n\t\t\t       MARKER\n                   ELEMENT\n\t\t\t       VALUE\n\t\t\t\t   START\n\t\t\t\t   END\n\t\t\t\t   LENGTH\n                   RELATIVE\n\t\t\t       )], @args);\n\t\n    my $do_range = defined($start) || defined($end);\n    if ($value && $do_range) {\n        $self->warn(\"-value and (-start|-end|-length) are mutually exclusive, ignoring value\");\n\t\t$value = undef;\n    }\n\t\n    $map            && $self->map($map);\n    $marker         && $self->element($marker); # backwards compatibility\n    $element        && $self->element($element);\n    $relative       && $self->relative($relative);\n    defined($value) && $self->value($value);\n\t\n    if ($do_range) {\n\t\tdefined($start) && $self->start($start);\n\t\tdefined($end)   && $self->end($end);\n\t\tif ($length) {\n\t\t\tif (defined($start) && ! defined($end)) {\n\t\t\t\t$self->end($start + $length - 1);\n\t\t\t}\n\t\t\telsif (! defined($start)) {\n\t\t\t\t$self->start($end - $length + 1);\n\t\t\t}\n\t\t}\n\t\tdefined($self->end) || $self->end($start);\n    }\n\t\n    return $self;\n}\n\n=head2 relative\n\n  Title   : relative\n  Usage   : my $relative = $position->relative();\n            $position->relative($relative);\n  Function: Get/set the thing this Position's coordinates (numerical(), start(),\n            end()) are relative to, as described by a Relative object.\n  Returns : Bio::Map::RelativeI (default is one describing \"relative to the\n            start of the Position's map\")\n  Args    : none to get, OR\n            Bio::Map::RelativeI to set\n\n\nsub relative {\n    my ($self, $relative) = @_;\n    if ($relative) {\n        $self->throw(\"Must supply an object\") unless ref($relative);\n        $self->throw(\"This is [$relative], not a Bio::Map::RelativeI\") unless $relative->isa('Bio::Map::RelativeI');\n        $self->{_relative_not_implicit} = 1;\n        $self->{_relative} = $relative;\n    }\n    return $self->{_relative} || $self->absolute_relative;\n}\n\n=head2 absolute\n\n  Title   : absolute\n  Usage   : my $absolute = $position->absolute();\n            $position->absolute($absolute);\n  Function: Get/set how this Position's co-ordinates (numerical(), start(),\n            end()) are reported. When absolute is off, co-ordinates are\n            relative to the thing described by relative(). Ie. the value\n            returned by start() will be the same as the value you set start()\n            to. When absolute is on, co-ordinates are converted to be relative\n            to the start of the map.\n\n            So if relative() currently points to a Relative object describing\n            \"relative to another position which is 100 bp from the start of\n            the map\", this Position's start() had been set to 50 and absolute()\n            returns 1, $position->start() will return 150. If absolute() returns\n            0 in the same situation, $position->start() would return 50.\n\n  Returns : boolean (default 0)\n  Args    : none to get, OR\n            boolean to set\n\n\nsub absolute {\n    my $self = shift;\n    if (@_) { $self->{_absolute} = shift }\n    return $self->{_absolute} || 0;\n}\n\n=head2 value\n\n Title   : value\n Usage   : my $pos = $position->value;\n Function: Get/Set the value for this postion\n Returns : scalar, value\n Args    : [optional] new value to set\n\n\nsub value {\n\tmy ($self, $value) = @_;\n\tif (defined $value) {\n\t\t$self->{'_value'} = $value;\n\t\t$self->start($self->numeric) unless defined($self->start);\n\t\t$self->end($self->numeric) unless defined($self->end);\n\t}\n\treturn $self->{'_value'};\n}\n\n=head2 numeric\n\n Title   : numeric\n Usage   : my $num = $position->numeric;\n Function: Read-only method that is guaranteed to return a numeric \n           representation of the start of this position. \n Returns : scalar numeric\n Args    : none to get the co-ordinate normally (see absolute() method), OR\n           Bio::Map::RelativeI to get the co-ordinate converted to be\n           relative to what this Relative describes.","parameters":[{"label":"$self"},{"label":"$value"}]},"children":[{"line":262,"name":"$self","localvar":"my","kind":13,"containerName":"numeric","definition":"my"},{"line":262,"name":"$value","containerName":"numeric","kind":13},{"line":263,"localvar":"my","containerName":"numeric","kind":13,"name":"$num","definition":"my"},{"name":"$self","containerName":"numeric","kind":13,"line":263},{"name":"$self","kind":13,"containerName":"numeric","line":264},{"name":"throw","kind":12,"containerName":"numeric","line":264},{"containerName":"numeric","kind":13,"name":"$num","line":264},{"kind":13,"containerName":"numeric","name":"$self","line":265},{"name":"throw","containerName":"numeric","kind":12,"line":265},{"line":265,"containerName":"numeric","kind":13,"name":"$num"},{"containerName":"numeric","kind":13,"name":"$value","line":267},{"line":267,"name":"$value","kind":13,"containerName":"numeric"},{"line":267,"kind":12,"containerName":"numeric","name":"isa"},{"definition":"my","line":269,"containerName":"numeric","localvar":"my","kind":13,"name":"$raw"},{"containerName":"numeric","kind":13,"name":"$num","line":269},{"definition":"my","name":"$abs_start","localvar":"my","containerName":"numeric","kind":13,"line":270},{"kind":13,"containerName":"numeric","name":"$rel_start","line":270},{"line":270,"containerName":"numeric","kind":13,"name":"$self"},{"name":"_relative_handler","kind":12,"containerName":"numeric","line":270},{"kind":13,"containerName":"numeric","name":"$value","line":270},{"name":"$abs_start","containerName":"numeric","kind":13,"line":271},{"line":271,"kind":13,"containerName":"numeric","name":"$raw"},{"line":271,"name":"$rel_start","kind":13,"containerName":"numeric"},{"name":"$self","containerName":"numeric","kind":13,"line":275},{"name":"$self","kind":13,"containerName":"numeric","line":275},{"kind":12,"containerName":"numeric","name":"absolute","line":275},{"line":277,"kind":13,"containerName":"numeric","name":"$self"},{"containerName":"numeric","kind":12,"name":"relative","line":277},{"kind":12,"containerName":"numeric","name":"absolute_conversion","line":277},{"name":"$self","kind":13,"containerName":"numeric","line":277},{"line":280,"name":"$num","containerName":"numeric","kind":13}],"name":"numeric","containerName":"main::","definition":"sub","detail":"($self,$value)"},{"line":265,"kind":12,"name":"looks_like_number"},{"line":275,"kind":12,"name":"_relative_not_implicit"},{"children":[{"definition":"my","line":298,"containerName":"start","localvar":"my","kind":13,"name":"$self"},{"name":"$value","kind":13,"containerName":"start","line":298},{"name":"$value","kind":13,"containerName":"start","line":299},{"name":"$value","containerName":"start","kind":13,"line":300},{"containerName":"start","kind":13,"name":"$value","line":300},{"containerName":"start","kind":12,"name":"isa","line":300},{"line":302,"kind":13,"localvar":"my","containerName":"start","name":"$raw","definition":"my"},{"line":302,"kind":13,"containerName":"start","name":"$self"},{"line":303,"kind":13,"containerName":"start","name":"$raw"},{"definition":"my","line":304,"name":"$abs_start","localvar":"my","kind":13,"containerName":"start"},{"line":304,"name":"$rel_start","containerName":"start","kind":13},{"containerName":"start","kind":13,"name":"$self","line":304},{"line":304,"kind":12,"containerName":"start","name":"_relative_handler"},{"line":304,"kind":13,"containerName":"start","name":"$value"},{"line":305,"kind":13,"containerName":"start","name":"$abs_start"},{"line":305,"name":"$raw","containerName":"start","kind":13},{"line":305,"name":"$rel_start","kind":13,"containerName":"start"},{"kind":13,"containerName":"start","name":"$self","line":309},{"line":309,"name":"throw","kind":12,"containerName":"start"},{"name":"$value","kind":13,"containerName":"start","line":309},{"line":310,"kind":13,"containerName":"start","name":"$self"},{"line":310,"kind":13,"containerName":"start","name":"$value"},{"line":311,"kind":13,"containerName":"start","name":"$self"},{"line":311,"containerName":"start","kind":12,"name":"value"},{"line":311,"name":"$value","containerName":"start","kind":13},{"name":"$self","containerName":"start","kind":13,"line":311},{"name":"value","kind":12,"containerName":"start","line":311},{"kind":13,"containerName":"start","name":"$self","line":316},{"line":316,"containerName":"start","kind":13,"name":"$self"},{"line":316,"kind":12,"containerName":"start","name":"absolute"},{"line":317,"kind":13,"containerName":"start","name":"$self"},{"name":"relative","kind":12,"containerName":"start","line":317},{"containerName":"start","kind":12,"name":"absolute_conversion","line":317},{"kind":13,"containerName":"start","name":"$self","line":317},{"line":320,"name":"$self","containerName":"start","kind":13},{"name":"$self","containerName":"start","kind":13,"line":320}],"name":"start","containerName":"main::","definition":"sub","detail":"($self,$value)","line":297,"kind":12,"range":{"start":{"line":297,"character":0},"end":{"character":9999,"line":321}},"signature":{"documentation":"1;\n# $Id: Position.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Position\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Position - A single position of a Marker, or the range over which\n                     that marker lies, in a Map\n\n=head1 SYNOPSIS\n\n    use Bio::Map::Position;\n    my $position = Bio::Map::Position->new(-map => $map, \n\t\t\t\t\t  -element => $marker,\n\t\t\t\t\t  -value => 100\n\t\t\t\t\t  );\n\n\tmy $position_with_range = Bio::Map::Position->new(-map => $map, \n\t\t\t\t\t  -element => $marker,\n\t\t\t\t\t  -start => 100,\n\t\t\t\t\t  -length => 10\n\t\t\t\t\t  );\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the PositionI interface that\nhandles the specific values of a position. This allows a map element\n(e.g. Marker) to have multiple positions within a map and still be\ntreated as a single entity.\n\nThis handles the concept of a relative map in which the order of\nelements and the distance between them is known, but does not\ndirectly handle the case when distances are unknown - in that case\narbitrary values must be assigned for position values.\n\nNo units are assumed here - units are handled by context of which Map\na position is placed in or the subclass of this Position.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein@cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nChad Matsalla, bioinformatics1@dieselwurks.com\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Position;\nuse strict;\n\nuse Scalar::Util qw(looks_like_number);\nuse Bio::Map::Relative;\n\nuse base qw(Bio::Root::Root Bio::Map::PositionI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::Position->new();\n Function: Builds a new Bio::Map::Position object \n Returns : Bio::Map::Position\n Args    : -map      => Bio::Map::MapI object\n           -element  => Bio::Map::MappableI object\n           -relative => Bio::Map::RelativeI object\n\n           * If this position has no range, or if a single value can describe\n             the range *\n           -value => scalar             : something that describes the single\n                                          point position or range of this\n                                          Position, most likely an int\n\n           * Or if this position has a range, at least two of *\n           -start => int                : value of the start co-ordinate\n           -end => int                  : value of the end co-ordinate\n           -length => int               : length of the range\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\t\n    my ($map, $marker, $element, $value, $start, $end, $length, $relative) = \n\t$self->_rearrange([qw( MAP\n\t\t\t       MARKER\n                   ELEMENT\n\t\t\t       VALUE\n\t\t\t\t   START\n\t\t\t\t   END\n\t\t\t\t   LENGTH\n                   RELATIVE\n\t\t\t       )], @args);\n\t\n    my $do_range = defined($start) || defined($end);\n    if ($value && $do_range) {\n        $self->warn(\"-value and (-start|-end|-length) are mutually exclusive, ignoring value\");\n\t\t$value = undef;\n    }\n\t\n    $map            && $self->map($map);\n    $marker         && $self->element($marker); # backwards compatibility\n    $element        && $self->element($element);\n    $relative       && $self->relative($relative);\n    defined($value) && $self->value($value);\n\t\n    if ($do_range) {\n\t\tdefined($start) && $self->start($start);\n\t\tdefined($end)   && $self->end($end);\n\t\tif ($length) {\n\t\t\tif (defined($start) && ! defined($end)) {\n\t\t\t\t$self->end($start + $length - 1);\n\t\t\t}\n\t\t\telsif (! defined($start)) {\n\t\t\t\t$self->start($end - $length + 1);\n\t\t\t}\n\t\t}\n\t\tdefined($self->end) || $self->end($start);\n    }\n\t\n    return $self;\n}\n\n=head2 relative\n\n  Title   : relative\n  Usage   : my $relative = $position->relative();\n            $position->relative($relative);\n  Function: Get/set the thing this Position's coordinates (numerical(), start(),\n            end()) are relative to, as described by a Relative object.\n  Returns : Bio::Map::RelativeI (default is one describing \"relative to the\n            start of the Position's map\")\n  Args    : none to get, OR\n            Bio::Map::RelativeI to set\n\n\nsub relative {\n    my ($self, $relative) = @_;\n    if ($relative) {\n        $self->throw(\"Must supply an object\") unless ref($relative);\n        $self->throw(\"This is [$relative], not a Bio::Map::RelativeI\") unless $relative->isa('Bio::Map::RelativeI');\n        $self->{_relative_not_implicit} = 1;\n        $self->{_relative} = $relative;\n    }\n    return $self->{_relative} || $self->absolute_relative;\n}\n\n=head2 absolute\n\n  Title   : absolute\n  Usage   : my $absolute = $position->absolute();\n            $position->absolute($absolute);\n  Function: Get/set how this Position's co-ordinates (numerical(), start(),\n            end()) are reported. When absolute is off, co-ordinates are\n            relative to the thing described by relative(). Ie. the value\n            returned by start() will be the same as the value you set start()\n            to. When absolute is on, co-ordinates are converted to be relative\n            to the start of the map.\n\n            So if relative() currently points to a Relative object describing\n            \"relative to another position which is 100 bp from the start of\n            the map\", this Position's start() had been set to 50 and absolute()\n            returns 1, $position->start() will return 150. If absolute() returns\n            0 in the same situation, $position->start() would return 50.\n\n  Returns : boolean (default 0)\n  Args    : none to get, OR\n            boolean to set\n\n\nsub absolute {\n    my $self = shift;\n    if (@_) { $self->{_absolute} = shift }\n    return $self->{_absolute} || 0;\n}\n\n=head2 value\n\n Title   : value\n Usage   : my $pos = $position->value;\n Function: Get/Set the value for this postion\n Returns : scalar, value\n Args    : [optional] new value to set\n\n\nsub value {\n\tmy ($self, $value) = @_;\n\tif (defined $value) {\n\t\t$self->{'_value'} = $value;\n\t\t$self->start($self->numeric) unless defined($self->start);\n\t\t$self->end($self->numeric) unless defined($self->end);\n\t}\n\treturn $self->{'_value'};\n}\n\n=head2 numeric\n\n Title   : numeric\n Usage   : my $num = $position->numeric;\n Function: Read-only method that is guaranteed to return a numeric \n           representation of the start of this position. \n Returns : scalar numeric\n Args    : none to get the co-ordinate normally (see absolute() method), OR\n           Bio::Map::RelativeI to get the co-ordinate converted to be\n           relative to what this Relative describes.\n\n\nsub numeric {\n    my ($self, $value) = @_;\n    my $num = $self->{'_value'};\n    $self->throw(\"The value has not been set, can't convert to numeric\") unless defined($num);\n    $self->throw(\"This value [$num] is not numeric\") unless looks_like_number($num);\n    \n    if (ref($value) && $value->isa('Bio::Map::RelativeI')) {\n        # get the value after co-ordinate conversion\n        my $raw = $num;\n        my ($abs_start, $rel_start) = $self->_relative_handler($value);\n        return $abs_start + $raw - $rel_start;\n    }\n    \n    # get the value as per absolute\n    if ($self->{_relative_not_implicit} && $self->absolute) {\n        # this actually returns the start, but should be the same thing...\n        return $self->relative->absolute_conversion($self);\n    }\n    \n    return $num;\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : my $start = $position->start();\n            $position->start($start);\n  Function: Get/set the start co-ordinate of this position.\n  Returns : the start of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.","parameters":[{"label":"$self"},{"label":"$value"}],"label":"start($self,$value)"}},{"line":302,"name":"start","kind":12},{"line":309,"name":"looks_like_number","kind":12},{"name":"start","kind":12,"line":310},{"line":316,"kind":12,"name":"_relative_not_implicit"},{"line":320,"name":"start","kind":12},{"name":"start","kind":12,"line":320},{"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"end","line":338,"definition":"my"},{"name":"$value","kind":13,"containerName":"end","line":338},{"name":"$value","containerName":"end","kind":13,"line":339},{"name":"$value","kind":13,"containerName":"end","line":340},{"name":"$value","kind":13,"containerName":"end","line":340},{"line":340,"name":"isa","containerName":"end","kind":12},{"localvar":"my","kind":13,"containerName":"end","name":"$raw","line":342,"definition":"my"},{"line":342,"containerName":"end","kind":13,"name":"$self"},{"line":343,"kind":13,"containerName":"end","name":"$raw"},{"definition":"my","line":344,"name":"$abs_start","localvar":"my","kind":13,"containerName":"end"},{"line":344,"kind":13,"containerName":"end","name":"$rel_start"},{"line":344,"kind":13,"containerName":"end","name":"$self"},{"line":344,"kind":12,"containerName":"end","name":"_relative_handler"},{"line":344,"name":"$value","kind":13,"containerName":"end"},{"line":345,"kind":13,"containerName":"end","name":"$abs_start"},{"line":345,"name":"$raw","containerName":"end","kind":13},{"line":345,"name":"$rel_start","containerName":"end","kind":13},{"name":"$self","containerName":"end","kind":13,"line":349},{"kind":12,"containerName":"end","name":"throw","line":349},{"line":349,"kind":13,"containerName":"end","name":"$value"},{"name":"$self","containerName":"end","kind":13,"line":350},{"containerName":"end","kind":13,"name":"$value","line":350},{"name":"$self","containerName":"end","kind":13,"line":355},{"kind":13,"containerName":"end","name":"$self","line":355},{"line":355,"kind":12,"containerName":"end","name":"absolute"},{"definition":"my","line":356,"kind":13,"localvar":"my","containerName":"end","name":"$raw"},{"kind":13,"containerName":"end","name":"$self","line":356},{"definition":"my","localvar":"my","kind":13,"containerName":"end","name":"$abs_start","line":357},{"line":357,"name":"$self","kind":13,"containerName":"end"},{"containerName":"end","kind":12,"name":"relative","line":357},{"containerName":"end","kind":12,"name":"absolute_conversion","line":357},{"name":"$self","kind":13,"containerName":"end","line":357},{"name":"$abs_start","kind":13,"containerName":"end","line":358},{"containerName":"end","kind":13,"name":"$raw","line":358},{"name":"$self","kind":13,"containerName":"end","line":358},{"containerName":"end","kind":13,"name":"$self","line":361},{"kind":13,"containerName":"end","name":"$self","line":361}],"containerName":"main::","name":"end","definition":"sub","detail":"($self,$value)","line":337,"kind":12,"range":{"start":{"character":0,"line":337},"end":{"character":9999,"line":362}},"signature":{"documentation":"1;\n# $Id: Position.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Position\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Position - A single position of a Marker, or the range over which\n                     that marker lies, in a Map\n\n=head1 SYNOPSIS\n\n    use Bio::Map::Position;\n    my $position = Bio::Map::Position->new(-map => $map, \n\t\t\t\t\t  -element => $marker,\n\t\t\t\t\t  -value => 100\n\t\t\t\t\t  );\n\n\tmy $position_with_range = Bio::Map::Position->new(-map => $map, \n\t\t\t\t\t  -element => $marker,\n\t\t\t\t\t  -start => 100,\n\t\t\t\t\t  -length => 10\n\t\t\t\t\t  );\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the PositionI interface that\nhandles the specific values of a position. This allows a map element\n(e.g. Marker) to have multiple positions within a map and still be\ntreated as a single entity.\n\nThis handles the concept of a relative map in which the order of\nelements and the distance between them is known, but does not\ndirectly handle the case when distances are unknown - in that case\narbitrary values must be assigned for position values.\n\nNo units are assumed here - units are handled by context of which Map\na position is placed in or the subclass of this Position.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein@cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nChad Matsalla, bioinformatics1@dieselwurks.com\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Position;\nuse strict;\n\nuse Scalar::Util qw(looks_like_number);\nuse Bio::Map::Relative;\n\nuse base qw(Bio::Root::Root Bio::Map::PositionI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::Position->new();\n Function: Builds a new Bio::Map::Position object \n Returns : Bio::Map::Position\n Args    : -map      => Bio::Map::MapI object\n           -element  => Bio::Map::MappableI object\n           -relative => Bio::Map::RelativeI object\n\n           * If this position has no range, or if a single value can describe\n             the range *\n           -value => scalar             : something that describes the single\n                                          point position or range of this\n                                          Position, most likely an int\n\n           * Or if this position has a range, at least two of *\n           -start => int                : value of the start co-ordinate\n           -end => int                  : value of the end co-ordinate\n           -length => int               : length of the range\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\t\n    my ($map, $marker, $element, $value, $start, $end, $length, $relative) = \n\t$self->_rearrange([qw( MAP\n\t\t\t       MARKER\n                   ELEMENT\n\t\t\t       VALUE\n\t\t\t\t   START\n\t\t\t\t   END\n\t\t\t\t   LENGTH\n                   RELATIVE\n\t\t\t       )], @args);\n\t\n    my $do_range = defined($start) || defined($end);\n    if ($value && $do_range) {\n        $self->warn(\"-value and (-start|-end|-length) are mutually exclusive, ignoring value\");\n\t\t$value = undef;\n    }\n\t\n    $map            && $self->map($map);\n    $marker         && $self->element($marker); # backwards compatibility\n    $element        && $self->element($element);\n    $relative       && $self->relative($relative);\n    defined($value) && $self->value($value);\n\t\n    if ($do_range) {\n\t\tdefined($start) && $self->start($start);\n\t\tdefined($end)   && $self->end($end);\n\t\tif ($length) {\n\t\t\tif (defined($start) && ! defined($end)) {\n\t\t\t\t$self->end($start + $length - 1);\n\t\t\t}\n\t\t\telsif (! defined($start)) {\n\t\t\t\t$self->start($end - $length + 1);\n\t\t\t}\n\t\t}\n\t\tdefined($self->end) || $self->end($start);\n    }\n\t\n    return $self;\n}\n\n=head2 relative\n\n  Title   : relative\n  Usage   : my $relative = $position->relative();\n            $position->relative($relative);\n  Function: Get/set the thing this Position's coordinates (numerical(), start(),\n            end()) are relative to, as described by a Relative object.\n  Returns : Bio::Map::RelativeI (default is one describing \"relative to the\n            start of the Position's map\")\n  Args    : none to get, OR\n            Bio::Map::RelativeI to set\n\n\nsub relative {\n    my ($self, $relative) = @_;\n    if ($relative) {\n        $self->throw(\"Must supply an object\") unless ref($relative);\n        $self->throw(\"This is [$relative], not a Bio::Map::RelativeI\") unless $relative->isa('Bio::Map::RelativeI');\n        $self->{_relative_not_implicit} = 1;\n        $self->{_relative} = $relative;\n    }\n    return $self->{_relative} || $self->absolute_relative;\n}\n\n=head2 absolute\n\n  Title   : absolute\n  Usage   : my $absolute = $position->absolute();\n            $position->absolute($absolute);\n  Function: Get/set how this Position's co-ordinates (numerical(), start(),\n            end()) are reported. When absolute is off, co-ordinates are\n            relative to the thing described by relative(). Ie. the value\n            returned by start() will be the same as the value you set start()\n            to. When absolute is on, co-ordinates are converted to be relative\n            to the start of the map.\n\n            So if relative() currently points to a Relative object describing\n            \"relative to another position which is 100 bp from the start of\n            the map\", this Position's start() had been set to 50 and absolute()\n            returns 1, $position->start() will return 150. If absolute() returns\n            0 in the same situation, $position->start() would return 50.\n\n  Returns : boolean (default 0)\n  Args    : none to get, OR\n            boolean to set\n\n\nsub absolute {\n    my $self = shift;\n    if (@_) { $self->{_absolute} = shift }\n    return $self->{_absolute} || 0;\n}\n\n=head2 value\n\n Title   : value\n Usage   : my $pos = $position->value;\n Function: Get/Set the value for this postion\n Returns : scalar, value\n Args    : [optional] new value to set\n\n\nsub value {\n\tmy ($self, $value) = @_;\n\tif (defined $value) {\n\t\t$self->{'_value'} = $value;\n\t\t$self->start($self->numeric) unless defined($self->start);\n\t\t$self->end($self->numeric) unless defined($self->end);\n\t}\n\treturn $self->{'_value'};\n}\n\n=head2 numeric\n\n Title   : numeric\n Usage   : my $num = $position->numeric;\n Function: Read-only method that is guaranteed to return a numeric \n           representation of the start of this position. \n Returns : scalar numeric\n Args    : none to get the co-ordinate normally (see absolute() method), OR\n           Bio::Map::RelativeI to get the co-ordinate converted to be\n           relative to what this Relative describes.\n\n\nsub numeric {\n    my ($self, $value) = @_;\n    my $num = $self->{'_value'};\n    $self->throw(\"The value has not been set, can't convert to numeric\") unless defined($num);\n    $self->throw(\"This value [$num] is not numeric\") unless looks_like_number($num);\n    \n    if (ref($value) && $value->isa('Bio::Map::RelativeI')) {\n        # get the value after co-ordinate conversion\n        my $raw = $num;\n        my ($abs_start, $rel_start) = $self->_relative_handler($value);\n        return $abs_start + $raw - $rel_start;\n    }\n    \n    # get the value as per absolute\n    if ($self->{_relative_not_implicit} && $self->absolute) {\n        # this actually returns the start, but should be the same thing...\n        return $self->relative->absolute_conversion($self);\n    }\n    \n    return $num;\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : my $start = $position->start();\n            $position->start($start);\n  Function: Get/set the start co-ordinate of this position.\n  Returns : the start of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\nsub start {\n\tmy ($self, $value) = @_;\n    if (defined $value) {\n        if (ref($value) && $value->isa('Bio::Map::RelativeI')) {\n            # get the value after co-ordinate conversion\n            my $raw = $self->{start};\n            defined $raw || return;\n            my ($abs_start, $rel_start) = $self->_relative_handler($value);\n            return $abs_start + $raw - $rel_start;\n        }\n        else {\n            # set the value\n            $self->throw(\"This is [$value], not a number\") unless looks_like_number($value);\n            $self->{start} = $value;\n            $self->value($value) unless defined($self->value);\n        }\n    }\n    \n    # get the value as per absolute\n    if ($self->{_relative_not_implicit} && $self->absolute) {\n        return $self->relative->absolute_conversion($self);\n    }\n    \n    return defined($self->{start}) ? $self->{start} : return;\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : my $end = $position->end();\n            $position->end($end);\n  Function: Get/set the end co-ordinate of this position.\n  Returns : the end of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.","parameters":[{"label":"$self"},{"label":"$value"}],"label":"end($self,$value)"}},{"kind":12,"name":"end","line":342},{"line":349,"kind":12,"name":"looks_like_number"},{"line":350,"kind":12,"name":"end"},{"line":355,"name":"_relative_not_implicit","kind":12},{"line":356,"name":"end","kind":12},{"name":"start","kind":12,"line":358},{"name":"end","kind":12,"line":361},{"line":361,"name":"end","kind":12},{"children":[{"line":377,"localvar":"my","containerName":"length","kind":13,"name":"$self","definition":"my"},{"name":"$length","containerName":"length","kind":13,"line":377},{"line":378,"containerName":"length","kind":13,"name":"$length"},{"line":379,"name":"$length","kind":13,"containerName":"length"},{"name":"$existing_length","kind":13,"localvar":"my","containerName":"length","line":380,"definition":"my"},{"kind":13,"containerName":"length","name":"$self","line":380},{"line":380,"containerName":"length","kind":12,"name":"length"},{"line":381,"name":"$length","containerName":"length","kind":13},{"line":381,"containerName":"length","kind":13,"name":"$existing_length"},{"name":"$length","kind":13,"containerName":"length","line":381},{"kind":13,"containerName":"length","name":"$self","line":382},{"name":"end","kind":12,"containerName":"length","line":382},{"containerName":"length","kind":13,"name":"$self","line":382},{"line":382,"name":"$length","kind":13,"containerName":"length"},{"line":385,"name":"$self","kind":13,"containerName":"length"},{"line":385,"containerName":"length","kind":12,"name":"start"},{"line":385,"name":"$self","kind":13,"containerName":"length"},{"line":385,"name":"end","containerName":"length","kind":12},{"line":386,"kind":13,"containerName":"length","name":"$self"},{"name":"end","kind":12,"containerName":"length","line":386},{"name":"$self","containerName":"length","kind":13,"line":386},{"line":386,"kind":12,"containerName":"length","name":"start"}],"name":"length","containerName":"main::","definition":"sub","detail":"($self,$length)","line":376,"kind":12,"range":{"end":{"character":9999,"line":389},"start":{"character":0,"line":376}},"signature":{"parameters":[{"label":"$self"},{"label":"$length"}],"documentation":"1;\n# $Id: Position.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Position\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Position - A single position of a Marker, or the range over which\n                     that marker lies, in a Map\n\n=head1 SYNOPSIS\n\n    use Bio::Map::Position;\n    my $position = Bio::Map::Position->new(-map => $map, \n\t\t\t\t\t  -element => $marker,\n\t\t\t\t\t  -value => 100\n\t\t\t\t\t  );\n\n\tmy $position_with_range = Bio::Map::Position->new(-map => $map, \n\t\t\t\t\t  -element => $marker,\n\t\t\t\t\t  -start => 100,\n\t\t\t\t\t  -length => 10\n\t\t\t\t\t  );\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the PositionI interface that\nhandles the specific values of a position. This allows a map element\n(e.g. Marker) to have multiple positions within a map and still be\ntreated as a single entity.\n\nThis handles the concept of a relative map in which the order of\nelements and the distance between them is known, but does not\ndirectly handle the case when distances are unknown - in that case\narbitrary values must be assigned for position values.\n\nNo units are assumed here - units are handled by context of which Map\na position is placed in or the subclass of this Position.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein@cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nChad Matsalla, bioinformatics1@dieselwurks.com\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Position;\nuse strict;\n\nuse Scalar::Util qw(looks_like_number);\nuse Bio::Map::Relative;\n\nuse base qw(Bio::Root::Root Bio::Map::PositionI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::Position->new();\n Function: Builds a new Bio::Map::Position object \n Returns : Bio::Map::Position\n Args    : -map      => Bio::Map::MapI object\n           -element  => Bio::Map::MappableI object\n           -relative => Bio::Map::RelativeI object\n\n           * If this position has no range, or if a single value can describe\n             the range *\n           -value => scalar             : something that describes the single\n                                          point position or range of this\n                                          Position, most likely an int\n\n           * Or if this position has a range, at least two of *\n           -start => int                : value of the start co-ordinate\n           -end => int                  : value of the end co-ordinate\n           -length => int               : length of the range\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\t\n    my ($map, $marker, $element, $value, $start, $end, $length, $relative) = \n\t$self->_rearrange([qw( MAP\n\t\t\t       MARKER\n                   ELEMENT\n\t\t\t       VALUE\n\t\t\t\t   START\n\t\t\t\t   END\n\t\t\t\t   LENGTH\n                   RELATIVE\n\t\t\t       )], @args);\n\t\n    my $do_range = defined($start) || defined($end);\n    if ($value && $do_range) {\n        $self->warn(\"-value and (-start|-end|-length) are mutually exclusive, ignoring value\");\n\t\t$value = undef;\n    }\n\t\n    $map            && $self->map($map);\n    $marker         && $self->element($marker); # backwards compatibility\n    $element        && $self->element($element);\n    $relative       && $self->relative($relative);\n    defined($value) && $self->value($value);\n\t\n    if ($do_range) {\n\t\tdefined($start) && $self->start($start);\n\t\tdefined($end)   && $self->end($end);\n\t\tif ($length) {\n\t\t\tif (defined($start) && ! defined($end)) {\n\t\t\t\t$self->end($start + $length - 1);\n\t\t\t}\n\t\t\telsif (! defined($start)) {\n\t\t\t\t$self->start($end - $length + 1);\n\t\t\t}\n\t\t}\n\t\tdefined($self->end) || $self->end($start);\n    }\n\t\n    return $self;\n}\n\n=head2 relative\n\n  Title   : relative\n  Usage   : my $relative = $position->relative();\n            $position->relative($relative);\n  Function: Get/set the thing this Position's coordinates (numerical(), start(),\n            end()) are relative to, as described by a Relative object.\n  Returns : Bio::Map::RelativeI (default is one describing \"relative to the\n            start of the Position's map\")\n  Args    : none to get, OR\n            Bio::Map::RelativeI to set\n\n\nsub relative {\n    my ($self, $relative) = @_;\n    if ($relative) {\n        $self->throw(\"Must supply an object\") unless ref($relative);\n        $self->throw(\"This is [$relative], not a Bio::Map::RelativeI\") unless $relative->isa('Bio::Map::RelativeI');\n        $self->{_relative_not_implicit} = 1;\n        $self->{_relative} = $relative;\n    }\n    return $self->{_relative} || $self->absolute_relative;\n}\n\n=head2 absolute\n\n  Title   : absolute\n  Usage   : my $absolute = $position->absolute();\n            $position->absolute($absolute);\n  Function: Get/set how this Position's co-ordinates (numerical(), start(),\n            end()) are reported. When absolute is off, co-ordinates are\n            relative to the thing described by relative(). Ie. the value\n            returned by start() will be the same as the value you set start()\n            to. When absolute is on, co-ordinates are converted to be relative\n            to the start of the map.\n\n            So if relative() currently points to a Relative object describing\n            \"relative to another position which is 100 bp from the start of\n            the map\", this Position's start() had been set to 50 and absolute()\n            returns 1, $position->start() will return 150. If absolute() returns\n            0 in the same situation, $position->start() would return 50.\n\n  Returns : boolean (default 0)\n  Args    : none to get, OR\n            boolean to set\n\n\nsub absolute {\n    my $self = shift;\n    if (@_) { $self->{_absolute} = shift }\n    return $self->{_absolute} || 0;\n}\n\n=head2 value\n\n Title   : value\n Usage   : my $pos = $position->value;\n Function: Get/Set the value for this postion\n Returns : scalar, value\n Args    : [optional] new value to set\n\n\nsub value {\n\tmy ($self, $value) = @_;\n\tif (defined $value) {\n\t\t$self->{'_value'} = $value;\n\t\t$self->start($self->numeric) unless defined($self->start);\n\t\t$self->end($self->numeric) unless defined($self->end);\n\t}\n\treturn $self->{'_value'};\n}\n\n=head2 numeric\n\n Title   : numeric\n Usage   : my $num = $position->numeric;\n Function: Read-only method that is guaranteed to return a numeric \n           representation of the start of this position. \n Returns : scalar numeric\n Args    : none to get the co-ordinate normally (see absolute() method), OR\n           Bio::Map::RelativeI to get the co-ordinate converted to be\n           relative to what this Relative describes.\n\n\nsub numeric {\n    my ($self, $value) = @_;\n    my $num = $self->{'_value'};\n    $self->throw(\"The value has not been set, can't convert to numeric\") unless defined($num);\n    $self->throw(\"This value [$num] is not numeric\") unless looks_like_number($num);\n    \n    if (ref($value) && $value->isa('Bio::Map::RelativeI')) {\n        # get the value after co-ordinate conversion\n        my $raw = $num;\n        my ($abs_start, $rel_start) = $self->_relative_handler($value);\n        return $abs_start + $raw - $rel_start;\n    }\n    \n    # get the value as per absolute\n    if ($self->{_relative_not_implicit} && $self->absolute) {\n        # this actually returns the start, but should be the same thing...\n        return $self->relative->absolute_conversion($self);\n    }\n    \n    return $num;\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : my $start = $position->start();\n            $position->start($start);\n  Function: Get/set the start co-ordinate of this position.\n  Returns : the start of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\nsub start {\n\tmy ($self, $value) = @_;\n    if (defined $value) {\n        if (ref($value) && $value->isa('Bio::Map::RelativeI')) {\n            # get the value after co-ordinate conversion\n            my $raw = $self->{start};\n            defined $raw || return;\n            my ($abs_start, $rel_start) = $self->_relative_handler($value);\n            return $abs_start + $raw - $rel_start;\n        }\n        else {\n            # set the value\n            $self->throw(\"This is [$value], not a number\") unless looks_like_number($value);\n            $self->{start} = $value;\n            $self->value($value) unless defined($self->value);\n        }\n    }\n    \n    # get the value as per absolute\n    if ($self->{_relative_not_implicit} && $self->absolute) {\n        return $self->relative->absolute_conversion($self);\n    }\n    \n    return defined($self->{start}) ? $self->{start} : return;\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : my $end = $position->end();\n            $position->end($end);\n  Function: Get/set the end co-ordinate of this position.\n  Returns : the end of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\nsub end {\n\tmy ($self, $value) = @_;\n    if (defined $value) {\n        if (ref($value) && $value->isa('Bio::Map::RelativeI')) {\n            # get the value after co-ordinate conversion\n            my $raw = $self->{end};\n            defined $raw || return;\n            my ($abs_start, $rel_start) = $self->_relative_handler($value);\n            return $abs_start + $raw - $rel_start;\n        }\n        else {\n            # set the value\n            $self->throw(\"This value [$value] is not numeric!\") unless looks_like_number($value);\n            $self->{end} = $value;\n        }\n    }\n    \n    # get the value as per absolute\n    if ($self->{_relative_not_implicit} && $self->absolute) {\n        my $raw = $self->{end} || return;\n        my $abs_start = $self->relative->absolute_conversion($self) || return;\n        return $abs_start + ($raw - $self->{start});\n    }\n    \n    return defined($self->{end}) ? $self->{end} : return;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $position->length();\n  Function: Get/set the length of this position's range, changing the end() if\n            necessary. Getting and even setting the length will fail if both\n            start() and end() are not already defined.\n  Returns : the length of this range\n  Args    : none to get, OR scalar numeric (>0) to set.","label":"length($self,$length)"}},{"line":382,"kind":12,"name":"start"},{"signature":{"label":"sortable($self,$given_map)","parameters":[{"label":"$self"},{"label":"$given_map"}],"documentation":"1;\n# $Id: Position.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Position\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Position - A single position of a Marker, or the range over which\n                     that marker lies, in a Map\n\n=head1 SYNOPSIS\n\n    use Bio::Map::Position;\n    my $position = Bio::Map::Position->new(-map => $map, \n\t\t\t\t\t  -element => $marker,\n\t\t\t\t\t  -value => 100\n\t\t\t\t\t  );\n\n\tmy $position_with_range = Bio::Map::Position->new(-map => $map, \n\t\t\t\t\t  -element => $marker,\n\t\t\t\t\t  -start => 100,\n\t\t\t\t\t  -length => 10\n\t\t\t\t\t  );\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the PositionI interface that\nhandles the specific values of a position. This allows a map element\n(e.g. Marker) to have multiple positions within a map and still be\ntreated as a single entity.\n\nThis handles the concept of a relative map in which the order of\nelements and the distance between them is known, but does not\ndirectly handle the case when distances are unknown - in that case\narbitrary values must be assigned for position values.\n\nNo units are assumed here - units are handled by context of which Map\na position is placed in or the subclass of this Position.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein@cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nChad Matsalla, bioinformatics1@dieselwurks.com\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Position;\nuse strict;\n\nuse Scalar::Util qw(looks_like_number);\nuse Bio::Map::Relative;\n\nuse base qw(Bio::Root::Root Bio::Map::PositionI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::Position->new();\n Function: Builds a new Bio::Map::Position object \n Returns : Bio::Map::Position\n Args    : -map      => Bio::Map::MapI object\n           -element  => Bio::Map::MappableI object\n           -relative => Bio::Map::RelativeI object\n\n           * If this position has no range, or if a single value can describe\n             the range *\n           -value => scalar             : something that describes the single\n                                          point position or range of this\n                                          Position, most likely an int\n\n           * Or if this position has a range, at least two of *\n           -start => int                : value of the start co-ordinate\n           -end => int                  : value of the end co-ordinate\n           -length => int               : length of the range\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\t\n    my ($map, $marker, $element, $value, $start, $end, $length, $relative) = \n\t$self->_rearrange([qw( MAP\n\t\t\t       MARKER\n                   ELEMENT\n\t\t\t       VALUE\n\t\t\t\t   START\n\t\t\t\t   END\n\t\t\t\t   LENGTH\n                   RELATIVE\n\t\t\t       )], @args);\n\t\n    my $do_range = defined($start) || defined($end);\n    if ($value && $do_range) {\n        $self->warn(\"-value and (-start|-end|-length) are mutually exclusive, ignoring value\");\n\t\t$value = undef;\n    }\n\t\n    $map            && $self->map($map);\n    $marker         && $self->element($marker); # backwards compatibility\n    $element        && $self->element($element);\n    $relative       && $self->relative($relative);\n    defined($value) && $self->value($value);\n\t\n    if ($do_range) {\n\t\tdefined($start) && $self->start($start);\n\t\tdefined($end)   && $self->end($end);\n\t\tif ($length) {\n\t\t\tif (defined($start) && ! defined($end)) {\n\t\t\t\t$self->end($start + $length - 1);\n\t\t\t}\n\t\t\telsif (! defined($start)) {\n\t\t\t\t$self->start($end - $length + 1);\n\t\t\t}\n\t\t}\n\t\tdefined($self->end) || $self->end($start);\n    }\n\t\n    return $self;\n}\n\n=head2 relative\n\n  Title   : relative\n  Usage   : my $relative = $position->relative();\n            $position->relative($relative);\n  Function: Get/set the thing this Position's coordinates (numerical(), start(),\n            end()) are relative to, as described by a Relative object.\n  Returns : Bio::Map::RelativeI (default is one describing \"relative to the\n            start of the Position's map\")\n  Args    : none to get, OR\n            Bio::Map::RelativeI to set\n\n\nsub relative {\n    my ($self, $relative) = @_;\n    if ($relative) {\n        $self->throw(\"Must supply an object\") unless ref($relative);\n        $self->throw(\"This is [$relative], not a Bio::Map::RelativeI\") unless $relative->isa('Bio::Map::RelativeI');\n        $self->{_relative_not_implicit} = 1;\n        $self->{_relative} = $relative;\n    }\n    return $self->{_relative} || $self->absolute_relative;\n}\n\n=head2 absolute\n\n  Title   : absolute\n  Usage   : my $absolute = $position->absolute();\n            $position->absolute($absolute);\n  Function: Get/set how this Position's co-ordinates (numerical(), start(),\n            end()) are reported. When absolute is off, co-ordinates are\n            relative to the thing described by relative(). Ie. the value\n            returned by start() will be the same as the value you set start()\n            to. When absolute is on, co-ordinates are converted to be relative\n            to the start of the map.\n\n            So if relative() currently points to a Relative object describing\n            \"relative to another position which is 100 bp from the start of\n            the map\", this Position's start() had been set to 50 and absolute()\n            returns 1, $position->start() will return 150. If absolute() returns\n            0 in the same situation, $position->start() would return 50.\n\n  Returns : boolean (default 0)\n  Args    : none to get, OR\n            boolean to set\n\n\nsub absolute {\n    my $self = shift;\n    if (@_) { $self->{_absolute} = shift }\n    return $self->{_absolute} || 0;\n}\n\n=head2 value\n\n Title   : value\n Usage   : my $pos = $position->value;\n Function: Get/Set the value for this postion\n Returns : scalar, value\n Args    : [optional] new value to set\n\n\nsub value {\n\tmy ($self, $value) = @_;\n\tif (defined $value) {\n\t\t$self->{'_value'} = $value;\n\t\t$self->start($self->numeric) unless defined($self->start);\n\t\t$self->end($self->numeric) unless defined($self->end);\n\t}\n\treturn $self->{'_value'};\n}\n\n=head2 numeric\n\n Title   : numeric\n Usage   : my $num = $position->numeric;\n Function: Read-only method that is guaranteed to return a numeric \n           representation of the start of this position. \n Returns : scalar numeric\n Args    : none to get the co-ordinate normally (see absolute() method), OR\n           Bio::Map::RelativeI to get the co-ordinate converted to be\n           relative to what this Relative describes.\n\n\nsub numeric {\n    my ($self, $value) = @_;\n    my $num = $self->{'_value'};\n    $self->throw(\"The value has not been set, can't convert to numeric\") unless defined($num);\n    $self->throw(\"This value [$num] is not numeric\") unless looks_like_number($num);\n    \n    if (ref($value) && $value->isa('Bio::Map::RelativeI')) {\n        # get the value after co-ordinate conversion\n        my $raw = $num;\n        my ($abs_start, $rel_start) = $self->_relative_handler($value);\n        return $abs_start + $raw - $rel_start;\n    }\n    \n    # get the value as per absolute\n    if ($self->{_relative_not_implicit} && $self->absolute) {\n        # this actually returns the start, but should be the same thing...\n        return $self->relative->absolute_conversion($self);\n    }\n    \n    return $num;\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : my $start = $position->start();\n            $position->start($start);\n  Function: Get/set the start co-ordinate of this position.\n  Returns : the start of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\nsub start {\n\tmy ($self, $value) = @_;\n    if (defined $value) {\n        if (ref($value) && $value->isa('Bio::Map::RelativeI')) {\n            # get the value after co-ordinate conversion\n            my $raw = $self->{start};\n            defined $raw || return;\n            my ($abs_start, $rel_start) = $self->_relative_handler($value);\n            return $abs_start + $raw - $rel_start;\n        }\n        else {\n            # set the value\n            $self->throw(\"This is [$value], not a number\") unless looks_like_number($value);\n            $self->{start} = $value;\n            $self->value($value) unless defined($self->value);\n        }\n    }\n    \n    # get the value as per absolute\n    if ($self->{_relative_not_implicit} && $self->absolute) {\n        return $self->relative->absolute_conversion($self);\n    }\n    \n    return defined($self->{start}) ? $self->{start} : return;\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : my $end = $position->end();\n            $position->end($end);\n  Function: Get/set the end co-ordinate of this position.\n  Returns : the end of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\nsub end {\n\tmy ($self, $value) = @_;\n    if (defined $value) {\n        if (ref($value) && $value->isa('Bio::Map::RelativeI')) {\n            # get the value after co-ordinate conversion\n            my $raw = $self->{end};\n            defined $raw || return;\n            my ($abs_start, $rel_start) = $self->_relative_handler($value);\n            return $abs_start + $raw - $rel_start;\n        }\n        else {\n            # set the value\n            $self->throw(\"This value [$value] is not numeric!\") unless looks_like_number($value);\n            $self->{end} = $value;\n        }\n    }\n    \n    # get the value as per absolute\n    if ($self->{_relative_not_implicit} && $self->absolute) {\n        my $raw = $self->{end} || return;\n        my $abs_start = $self->relative->absolute_conversion($self) || return;\n        return $abs_start + ($raw - $self->{start});\n    }\n    \n    return defined($self->{end}) ? $self->{end} : return;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $position->length();\n  Function: Get/set the length of this position's range, changing the end() if\n            necessary. Getting and even setting the length will fail if both\n            start() and end() are not already defined.\n  Returns : the length of this range\n  Args    : none to get, OR scalar numeric (>0) to set.\n\n\nsub length {\n\tmy ($self, $length) = @_;\n\tif ($length) {\n        $length > 0 || return;\n\t\tmy $existing_length = $self->length || return;\n        return $length if $existing_length == $length;\n        $self->end($self->{start} + $length - 1);\n\t}\n\t\n\tif (defined($self->start) && defined($self->end)) {\n\t\treturn $self->end - $self->start + 1;\n\t}\n    return;\n}\n\n=head2 sortable\n\n Title   : sortable\n Usage   : my $num = $position->sortable();\n Function: Read-only method that is guaranteed to return a value suitable\n           for correctly sorting this kind of position amongst other positions\n           of the same kind on the same map. Note that sorting different kinds\n           of position together is unlikely to give sane results.\n Returns : numeric\n Args    : none"},"kind":12,"range":{"start":{"character":0,"line":404},"end":{"character":9999,"line":408}},"line":404,"detail":"($self,$given_map)","definition":"sub","containerName":"main::","name":"sortable","children":[{"kind":13,"localvar":"my","containerName":"sortable","name":"$self","line":405,"definition":"my"},{"kind":13,"containerName":"sortable","name":"$given_map","line":405},{"definition":"my","containerName":"sortable","localvar":"my","kind":13,"name":"$answer","line":406},{"kind":13,"containerName":"sortable","name":"$self","line":406},{"name":"numeric","kind":12,"containerName":"sortable","line":406},{"line":406,"name":"$self","containerName":"sortable","kind":13},{"line":406,"name":"absolute_relative","kind":12,"containerName":"sortable"},{"name":"$answer","kind":13,"containerName":"sortable","line":407}]},{"detail":"($self,$rel)","definition":"sub","containerName":"main::","name":"toString","children":[{"line":422,"localvar":"my","containerName":"toString","kind":13,"name":"$self","definition":"my"},{"line":422,"name":"$rel","containerName":"toString","kind":13},{"containerName":"toString","kind":13,"name":"$self","line":423},{"line":423,"name":"start","containerName":"toString","kind":12},{"line":423,"name":"$self","kind":13,"containerName":"toString"},{"name":"end","containerName":"toString","kind":12,"line":423},{"line":424,"name":"$self","containerName":"toString","kind":13},{"name":"start","containerName":"toString","kind":12,"line":424},{"line":424,"containerName":"toString","kind":13,"name":"$rel"},{"name":"$self","containerName":"toString","kind":13,"line":424},{"containerName":"toString","kind":12,"name":"end","line":424},{"line":424,"containerName":"toString","kind":13,"name":"$rel"}],"signature":{"documentation":"1;\n# $Id: Position.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Position\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Position - A single position of a Marker, or the range over which\n                     that marker lies, in a Map\n\n=head1 SYNOPSIS\n\n    use Bio::Map::Position;\n    my $position = Bio::Map::Position->new(-map => $map, \n\t\t\t\t\t  -element => $marker,\n\t\t\t\t\t  -value => 100\n\t\t\t\t\t  );\n\n\tmy $position_with_range = Bio::Map::Position->new(-map => $map, \n\t\t\t\t\t  -element => $marker,\n\t\t\t\t\t  -start => 100,\n\t\t\t\t\t  -length => 10\n\t\t\t\t\t  );\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the PositionI interface that\nhandles the specific values of a position. This allows a map element\n(e.g. Marker) to have multiple positions within a map and still be\ntreated as a single entity.\n\nThis handles the concept of a relative map in which the order of\nelements and the distance between them is known, but does not\ndirectly handle the case when distances are unknown - in that case\narbitrary values must be assigned for position values.\n\nNo units are assumed here - units are handled by context of which Map\na position is placed in or the subclass of this Position.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein@cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nChad Matsalla, bioinformatics1@dieselwurks.com\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Position;\nuse strict;\n\nuse Scalar::Util qw(looks_like_number);\nuse Bio::Map::Relative;\n\nuse base qw(Bio::Root::Root Bio::Map::PositionI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::Position->new();\n Function: Builds a new Bio::Map::Position object \n Returns : Bio::Map::Position\n Args    : -map      => Bio::Map::MapI object\n           -element  => Bio::Map::MappableI object\n           -relative => Bio::Map::RelativeI object\n\n           * If this position has no range, or if a single value can describe\n             the range *\n           -value => scalar             : something that describes the single\n                                          point position or range of this\n                                          Position, most likely an int\n\n           * Or if this position has a range, at least two of *\n           -start => int                : value of the start co-ordinate\n           -end => int                  : value of the end co-ordinate\n           -length => int               : length of the range\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\t\n    my ($map, $marker, $element, $value, $start, $end, $length, $relative) = \n\t$self->_rearrange([qw( MAP\n\t\t\t       MARKER\n                   ELEMENT\n\t\t\t       VALUE\n\t\t\t\t   START\n\t\t\t\t   END\n\t\t\t\t   LENGTH\n                   RELATIVE\n\t\t\t       )], @args);\n\t\n    my $do_range = defined($start) || defined($end);\n    if ($value && $do_range) {\n        $self->warn(\"-value and (-start|-end|-length) are mutually exclusive, ignoring value\");\n\t\t$value = undef;\n    }\n\t\n    $map            && $self->map($map);\n    $marker         && $self->element($marker); # backwards compatibility\n    $element        && $self->element($element);\n    $relative       && $self->relative($relative);\n    defined($value) && $self->value($value);\n\t\n    if ($do_range) {\n\t\tdefined($start) && $self->start($start);\n\t\tdefined($end)   && $self->end($end);\n\t\tif ($length) {\n\t\t\tif (defined($start) && ! defined($end)) {\n\t\t\t\t$self->end($start + $length - 1);\n\t\t\t}\n\t\t\telsif (! defined($start)) {\n\t\t\t\t$self->start($end - $length + 1);\n\t\t\t}\n\t\t}\n\t\tdefined($self->end) || $self->end($start);\n    }\n\t\n    return $self;\n}\n\n=head2 relative\n\n  Title   : relative\n  Usage   : my $relative = $position->relative();\n            $position->relative($relative);\n  Function: Get/set the thing this Position's coordinates (numerical(), start(),\n            end()) are relative to, as described by a Relative object.\n  Returns : Bio::Map::RelativeI (default is one describing \"relative to the\n            start of the Position's map\")\n  Args    : none to get, OR\n            Bio::Map::RelativeI to set\n\n\nsub relative {\n    my ($self, $relative) = @_;\n    if ($relative) {\n        $self->throw(\"Must supply an object\") unless ref($relative);\n        $self->throw(\"This is [$relative], not a Bio::Map::RelativeI\") unless $relative->isa('Bio::Map::RelativeI');\n        $self->{_relative_not_implicit} = 1;\n        $self->{_relative} = $relative;\n    }\n    return $self->{_relative} || $self->absolute_relative;\n}\n\n=head2 absolute\n\n  Title   : absolute\n  Usage   : my $absolute = $position->absolute();\n            $position->absolute($absolute);\n  Function: Get/set how this Position's co-ordinates (numerical(), start(),\n            end()) are reported. When absolute is off, co-ordinates are\n            relative to the thing described by relative(). Ie. the value\n            returned by start() will be the same as the value you set start()\n            to. When absolute is on, co-ordinates are converted to be relative\n            to the start of the map.\n\n            So if relative() currently points to a Relative object describing\n            \"relative to another position which is 100 bp from the start of\n            the map\", this Position's start() had been set to 50 and absolute()\n            returns 1, $position->start() will return 150. If absolute() returns\n            0 in the same situation, $position->start() would return 50.\n\n  Returns : boolean (default 0)\n  Args    : none to get, OR\n            boolean to set\n\n\nsub absolute {\n    my $self = shift;\n    if (@_) { $self->{_absolute} = shift }\n    return $self->{_absolute} || 0;\n}\n\n=head2 value\n\n Title   : value\n Usage   : my $pos = $position->value;\n Function: Get/Set the value for this postion\n Returns : scalar, value\n Args    : [optional] new value to set\n\n\nsub value {\n\tmy ($self, $value) = @_;\n\tif (defined $value) {\n\t\t$self->{'_value'} = $value;\n\t\t$self->start($self->numeric) unless defined($self->start);\n\t\t$self->end($self->numeric) unless defined($self->end);\n\t}\n\treturn $self->{'_value'};\n}\n\n=head2 numeric\n\n Title   : numeric\n Usage   : my $num = $position->numeric;\n Function: Read-only method that is guaranteed to return a numeric \n           representation of the start of this position. \n Returns : scalar numeric\n Args    : none to get the co-ordinate normally (see absolute() method), OR\n           Bio::Map::RelativeI to get the co-ordinate converted to be\n           relative to what this Relative describes.\n\n\nsub numeric {\n    my ($self, $value) = @_;\n    my $num = $self->{'_value'};\n    $self->throw(\"The value has not been set, can't convert to numeric\") unless defined($num);\n    $self->throw(\"This value [$num] is not numeric\") unless looks_like_number($num);\n    \n    if (ref($value) && $value->isa('Bio::Map::RelativeI')) {\n        # get the value after co-ordinate conversion\n        my $raw = $num;\n        my ($abs_start, $rel_start) = $self->_relative_handler($value);\n        return $abs_start + $raw - $rel_start;\n    }\n    \n    # get the value as per absolute\n    if ($self->{_relative_not_implicit} && $self->absolute) {\n        # this actually returns the start, but should be the same thing...\n        return $self->relative->absolute_conversion($self);\n    }\n    \n    return $num;\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : my $start = $position->start();\n            $position->start($start);\n  Function: Get/set the start co-ordinate of this position.\n  Returns : the start of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\nsub start {\n\tmy ($self, $value) = @_;\n    if (defined $value) {\n        if (ref($value) && $value->isa('Bio::Map::RelativeI')) {\n            # get the value after co-ordinate conversion\n            my $raw = $self->{start};\n            defined $raw || return;\n            my ($abs_start, $rel_start) = $self->_relative_handler($value);\n            return $abs_start + $raw - $rel_start;\n        }\n        else {\n            # set the value\n            $self->throw(\"This is [$value], not a number\") unless looks_like_number($value);\n            $self->{start} = $value;\n            $self->value($value) unless defined($self->value);\n        }\n    }\n    \n    # get the value as per absolute\n    if ($self->{_relative_not_implicit} && $self->absolute) {\n        return $self->relative->absolute_conversion($self);\n    }\n    \n    return defined($self->{start}) ? $self->{start} : return;\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : my $end = $position->end();\n            $position->end($end);\n  Function: Get/set the end co-ordinate of this position.\n  Returns : the end of this position\n  Args    : scalar numeric to set, OR\n            none to get the co-ordinate normally (see absolute() method), OR\n            Bio::Map::RelativeI to get the co-ordinate converted to be\n            relative to what this Relative describes.\n\n\nsub end {\n\tmy ($self, $value) = @_;\n    if (defined $value) {\n        if (ref($value) && $value->isa('Bio::Map::RelativeI')) {\n            # get the value after co-ordinate conversion\n            my $raw = $self->{end};\n            defined $raw || return;\n            my ($abs_start, $rel_start) = $self->_relative_handler($value);\n            return $abs_start + $raw - $rel_start;\n        }\n        else {\n            # set the value\n            $self->throw(\"This value [$value] is not numeric!\") unless looks_like_number($value);\n            $self->{end} = $value;\n        }\n    }\n    \n    # get the value as per absolute\n    if ($self->{_relative_not_implicit} && $self->absolute) {\n        my $raw = $self->{end} || return;\n        my $abs_start = $self->relative->absolute_conversion($self) || return;\n        return $abs_start + ($raw - $self->{start});\n    }\n    \n    return defined($self->{end}) ? $self->{end} : return;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $length = $position->length();\n  Function: Get/set the length of this position's range, changing the end() if\n            necessary. Getting and even setting the length will fail if both\n            start() and end() are not already defined.\n  Returns : the length of this range\n  Args    : none to get, OR scalar numeric (>0) to set.\n\n\nsub length {\n\tmy ($self, $length) = @_;\n\tif ($length) {\n        $length > 0 || return;\n\t\tmy $existing_length = $self->length || return;\n        return $length if $existing_length == $length;\n        $self->end($self->{start} + $length - 1);\n\t}\n\t\n\tif (defined($self->start) && defined($self->end)) {\n\t\treturn $self->end - $self->start + 1;\n\t}\n    return;\n}\n\n=head2 sortable\n\n Title   : sortable\n Usage   : my $num = $position->sortable();\n Function: Read-only method that is guaranteed to return a value suitable\n           for correctly sorting this kind of position amongst other positions\n           of the same kind on the same map. Note that sorting different kinds\n           of position together is unlikely to give sane results.\n Returns : numeric\n Args    : none\n\n\nsub sortable {\n    my ($self, $given_map) = @_;\n    my $answer = $self->numeric($self->absolute_relative);\n    return $answer;\n}\n\n=head2 toString\n\n  Title   : toString\n  Usage   : print $position->toString(), \"\\n\";\n  Function: stringifies this range\n  Returns : a string representation of the range of this Position\n  Args    : optional Bio::Map::RelativeI to have the co-ordinates reported\n            relative to the thing described by that Relative","parameters":[{"label":"$self"},{"label":"$rel"}],"label":"toString($self,$rel)"},"kind":12,"range":{"start":{"line":421,"character":0},"end":{"character":9999,"line":427}},"line":421},{"definition":"sub","children":[{"line":442,"containerName":"absolute_relative","kind":12,"name":"new"}],"name":"absolute_relative","containerName":"main::","line":441,"range":{"end":{"character":9999,"line":443},"start":{"line":441,"character":0}},"kind":12},{"name":"Bio","containerName":"Map::Relative","kind":12,"line":442},{"children":[{"line":448,"localvar":"my","kind":13,"containerName":"_relative_handler","name":"$self","definition":"my"},{"kind":13,"containerName":"_relative_handler","name":"$value","line":448},{"definition":"my","kind":13,"localvar":"my","containerName":"_relative_handler","name":"$own_relative","line":450},{"name":"$self","kind":13,"containerName":"_relative_handler","line":450},{"kind":12,"containerName":"_relative_handler","name":"relative","line":450},{"name":"$own_type","localvar":"my","kind":13,"containerName":"_relative_handler","line":454,"definition":"my"},{"line":454,"name":"$req_type","containerName":"_relative_handler","kind":13},{"line":454,"containerName":"_relative_handler","kind":13,"name":"$own_relative"},{"line":454,"kind":12,"containerName":"_relative_handler","name":"type"},{"name":"$value","kind":13,"containerName":"_relative_handler","line":454},{"name":"type","containerName":"_relative_handler","kind":12,"line":454},{"line":455,"name":"$own_type","containerName":"_relative_handler","kind":13},{"line":455,"name":"$req_type","kind":13,"containerName":"_relative_handler"},{"line":455,"name":"$own_type","kind":13,"containerName":"_relative_handler"},{"name":"$req_type","kind":13,"containerName":"_relative_handler","line":455},{"containerName":"_relative_handler","kind":13,"name":"$own_relative","line":455},{"containerName":"_relative_handler","kind":13,"name":"$own_type","line":455},{"line":455,"kind":13,"containerName":"_relative_handler","name":"$value"},{"line":455,"name":"$req_type","containerName":"_relative_handler","kind":13},{"definition":"my","line":459,"name":"$abs_start","containerName":"_relative_handler","localvar":"my","kind":13},{"name":"$own_relative","containerName":"_relative_handler","kind":13,"line":459},{"line":459,"containerName":"_relative_handler","kind":12,"name":"absolute_conversion"},{"line":459,"name":"$self","containerName":"_relative_handler","kind":13},{"definition":"my","containerName":"_relative_handler","localvar":"my","kind":13,"name":"$rel_start","line":460},{"name":"$value","kind":13,"containerName":"_relative_handler","line":460},{"line":460,"containerName":"_relative_handler","kind":12,"name":"absolute_conversion"},{"kind":13,"containerName":"_relative_handler","name":"$self","line":460},{"line":461,"name":"$self","kind":13,"containerName":"_relative_handler"},{"containerName":"_relative_handler","kind":12,"name":"throw","line":461},{"line":462,"kind":13,"containerName":"_relative_handler","name":"$abs_start"},{"line":462,"containerName":"_relative_handler","kind":13,"name":"$rel_start"},{"kind":13,"containerName":"_relative_handler","name":"$abs_start","line":464},{"line":464,"containerName":"_relative_handler","kind":13,"name":"$rel_start"}],"containerName":"main::","name":"_relative_handler","definition":"sub","detail":"($self,$value)","line":447,"kind":12,"range":{"start":{"line":447,"character":0},"end":{"line":465,"character":9999}},"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":" get our own absolute start and that of the thing we want as a frame of\n reference","label":"_relative_handler($self,$value)"}}],"version":5}