{"vars":[{"containerName":"","kind":2,"name":"base","line":85},{"range":{"end":{"character":9999,"line":112},"start":{"line":104,"character":0}},"kind":12,"line":104,"name":"get_position_handler","containerName":"main::","children":[{"definition":"my","line":105,"localvar":"my","containerName":"get_position_handler","kind":13,"name":"$self"},{"name":"$self","kind":13,"containerName":"get_position_handler","line":106},{"definition":"my","name":"$ph","localvar":"my","containerName":"get_position_handler","kind":13,"line":107},{"line":107,"name":"new","containerName":"get_position_handler","kind":12},{"containerName":"get_position_handler","kind":13,"name":"$self","line":107},{"name":"$self","kind":13,"containerName":"get_position_handler","line":108},{"name":"$ph","containerName":"get_position_handler","kind":13,"line":108},{"line":109,"containerName":"get_position_handler","kind":13,"name":"$ph"},{"line":109,"kind":12,"containerName":"get_position_handler","name":"register"},{"line":111,"name":"$self","containerName":"get_position_handler","kind":13}],"definition":"sub"},{"line":106,"name":"_eh","kind":12},{"kind":12,"containerName":"Map::PositionHandler","name":"Bio","line":107},{"line":108,"name":"_eh","kind":12},{"line":111,"kind":12,"name":"_eh"},{"name":"get_positions","containerName":"main::","children":[{"line":133,"name":"$self","containerName":"get_positions","localvar":"my","kind":13,"definition":"my"},{"line":133,"kind":13,"containerName":"get_positions","name":"$mappable"},{"definition":"my","localvar":"my","containerName":"get_positions","kind":13,"name":"@positions","line":134},{"kind":13,"containerName":"get_positions","name":"$self","line":134},{"line":134,"name":"get_position_handler","kind":12,"containerName":"get_positions"},{"containerName":"get_positions","kind":12,"name":"get_positions","line":134},{"line":134,"name":"$mappable","containerName":"get_positions","kind":13},{"line":136,"kind":13,"containerName":"get_positions","name":"@positions"},{"kind":13,"containerName":"get_positions","name":"$a","line":137},{"line":137,"containerName":"get_positions","kind":13,"name":"$b"},{"line":138,"kind":12,"containerName":"get_positions","name":"sortable"},{"line":139,"name":"@positions","kind":13,"containerName":"get_positions"},{"line":140,"containerName":"get_positions","kind":13,"name":"@positions"}],"detail":"($self,$mappable)","definition":"sub","kind":12,"range":{"end":{"line":141,"character":9999},"start":{"line":132,"character":0}},"line":132,"signature":{"parameters":[{"label":"$self"},{"label":"$mappable"}],"documentation":"1;\n# $Id: MapI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::MapI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::MapI - Interface for describing Map objects in bioperl \n\n=head1 SYNOPSIS\n\n    # get a MapI somehow\n    my $name   = $map->name();     # string\n    my $length = $map->length();   # integer\n    my $species= $map->species;    # Bio::Species\n    my $type   = $map->type();     # genetic/sts/rh/\n\n=head1 DESCRIPTION\n\nThis object describes the basic functionality of a Map in bioperl.\nMaps are anything from Genetic Map to Sequence Map to Assembly Map\nto Restriction Enzyme to FPC.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein@cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::MapI;\nuse strict;\nuse Bio::Map::PositionHandler;\n\nuse base qw(Bio::Map::EntityI Bio::AnnotatableI);\n\n=head2 EntityI methods\n\n These are fundamental to coordination of Maps and other entities, so are\n implemented at the interface level\n\n\n=head2 get_position_handler\n\n Title   : get_position_handler\n Usage   : my $position_handler = $entity->get_position_handler();\n Function: Gets a PositionHandlerI that $entity is registered with.\n Returns : Bio::Map::PositionHandlerI object\n Args    : none\n\n\nsub get_position_handler {\n    my $self = shift;\n    unless (defined $self->{_eh}) {\n        my $ph = Bio::Map::PositionHandler->new(-self => $self);\n        $self->{_eh} = $ph;\n        $ph->register;\n    }\n    return $self->{_eh};\n}\n\n=head2 PositionHandlerI-related methods\n\n These are fundamental to coordination of Maps and other entities, so are\n implemented at the interface level\n\n\n=head2 get_positions\n\n Title   : get_positions\n Usage   : my @positions = $mappable->get_positions();\n Function: Get all the Positions on this Map (sorted).\n Returns : Array of L<Bio::Map::PositionI> objects\n Args    : none for all, OR\n           L<Bio::Map::MappableI> object for positions of the given Mappable","label":"get_positions($self,$mappable)"}},{"detail":"($self,$thing)","definition":"sub","containerName":"main::","name":"purge_positions","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"purge_positions","kind":13,"line":168},{"line":168,"name":"$thing","kind":13,"containerName":"purge_positions"},{"line":169,"name":"$self","containerName":"purge_positions","kind":13},{"line":169,"name":"get_position_handler","containerName":"purge_positions","kind":12},{"line":169,"kind":12,"containerName":"purge_positions","name":"purge_positions"},{"line":169,"kind":13,"containerName":"purge_positions","name":"$thing"}],"signature":{"parameters":[{"label":"$self"},{"label":"$thing"}],"documentation":"1;\n# $Id: MapI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::MapI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::MapI - Interface for describing Map objects in bioperl \n\n=head1 SYNOPSIS\n\n    # get a MapI somehow\n    my $name   = $map->name();     # string\n    my $length = $map->length();   # integer\n    my $species= $map->species;    # Bio::Species\n    my $type   = $map->type();     # genetic/sts/rh/\n\n=head1 DESCRIPTION\n\nThis object describes the basic functionality of a Map in bioperl.\nMaps are anything from Genetic Map to Sequence Map to Assembly Map\nto Restriction Enzyme to FPC.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein@cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::MapI;\nuse strict;\nuse Bio::Map::PositionHandler;\n\nuse base qw(Bio::Map::EntityI Bio::AnnotatableI);\n\n=head2 EntityI methods\n\n These are fundamental to coordination of Maps and other entities, so are\n implemented at the interface level\n\n\n=head2 get_position_handler\n\n Title   : get_position_handler\n Usage   : my $position_handler = $entity->get_position_handler();\n Function: Gets a PositionHandlerI that $entity is registered with.\n Returns : Bio::Map::PositionHandlerI object\n Args    : none\n\n\nsub get_position_handler {\n    my $self = shift;\n    unless (defined $self->{_eh}) {\n        my $ph = Bio::Map::PositionHandler->new(-self => $self);\n        $self->{_eh} = $ph;\n        $ph->register;\n    }\n    return $self->{_eh};\n}\n\n=head2 PositionHandlerI-related methods\n\n These are fundamental to coordination of Maps and other entities, so are\n implemented at the interface level\n\n\n=head2 get_positions\n\n Title   : get_positions\n Usage   : my @positions = $mappable->get_positions();\n Function: Get all the Positions on this Map (sorted).\n Returns : Array of L<Bio::Map::PositionI> objects\n Args    : none for all, OR\n           L<Bio::Map::MappableI> object for positions of the given Mappable\n\n\nsub get_positions {\n    my ($self, $mappable) = @_;\n\tmy @positions = $self->get_position_handler->get_positions($mappable);\n    # precompute sortable for effieciency and to avoid bugs\n    @positions = map { $_->[1] }\n                 sort { $a->[0] <=> $b->[0] }\n                 map { [$_->sortable, $_] }\n                 @positions;\n    return @positions;\n}\n\n=head2 each_position\n\n Title   : each_position\n Function: Synonym of the get_positions() method.\n Status  : deprecated, will be removed in next version\n\n\n*each_position = \\&get_positions;\n\n=head2 purge_positions\n\n Title   : purge_positions\n Usage   : $map->purge_position();\n Function: Remove all positions from this map. Notifies the positions they are\n           no longer on this map.\n Returns : n/a\n Args    : none to remove all positions, OR\n           L<Bio::Map::PositionI> object to remove just that Position, OR\n\t\t   L<Bio::Map::MappableI> object to remove only those positions of the\n           given mappable","label":"purge_positions($self,$thing)"},"kind":12,"range":{"end":{"line":170,"character":9999},"start":{"character":0,"line":167}},"line":167},{"range":{"start":{"line":182,"character":0},"end":{"line":185,"character":9999}},"kind":12,"line":182,"definition":"sub","containerName":"main::","name":"get_elements","children":[{"definition":"my","line":183,"localvar":"my","kind":13,"containerName":"get_elements","name":"$self"},{"line":184,"containerName":"get_elements","kind":13,"name":"$self"},{"line":184,"kind":12,"containerName":"get_elements","name":"get_position_handler"},{"containerName":"get_elements","kind":12,"name":"get_other_entities","line":184}]},{"signature":{"label":"common_elements($self,$maps_ref,@extra_args)","parameters":[{"label":"$self"},{"label":"$maps_ref"},{"label":"@extra_args"}],"documentation":"1;\n# $Id: MapI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::MapI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::MapI - Interface for describing Map objects in bioperl \n\n=head1 SYNOPSIS\n\n    # get a MapI somehow\n    my $name   = $map->name();     # string\n    my $length = $map->length();   # integer\n    my $species= $map->species;    # Bio::Species\n    my $type   = $map->type();     # genetic/sts/rh/\n\n=head1 DESCRIPTION\n\nThis object describes the basic functionality of a Map in bioperl.\nMaps are anything from Genetic Map to Sequence Map to Assembly Map\nto Restriction Enzyme to FPC.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein@cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::MapI;\nuse strict;\nuse Bio::Map::PositionHandler;\n\nuse base qw(Bio::Map::EntityI Bio::AnnotatableI);\n\n=head2 EntityI methods\n\n These are fundamental to coordination of Maps and other entities, so are\n implemented at the interface level\n\n\n=head2 get_position_handler\n\n Title   : get_position_handler\n Usage   : my $position_handler = $entity->get_position_handler();\n Function: Gets a PositionHandlerI that $entity is registered with.\n Returns : Bio::Map::PositionHandlerI object\n Args    : none\n\n\nsub get_position_handler {\n    my $self = shift;\n    unless (defined $self->{_eh}) {\n        my $ph = Bio::Map::PositionHandler->new(-self => $self);\n        $self->{_eh} = $ph;\n        $ph->register;\n    }\n    return $self->{_eh};\n}\n\n=head2 PositionHandlerI-related methods\n\n These are fundamental to coordination of Maps and other entities, so are\n implemented at the interface level\n\n\n=head2 get_positions\n\n Title   : get_positions\n Usage   : my @positions = $mappable->get_positions();\n Function: Get all the Positions on this Map (sorted).\n Returns : Array of L<Bio::Map::PositionI> objects\n Args    : none for all, OR\n           L<Bio::Map::MappableI> object for positions of the given Mappable\n\n\nsub get_positions {\n    my ($self, $mappable) = @_;\n\tmy @positions = $self->get_position_handler->get_positions($mappable);\n    # precompute sortable for effieciency and to avoid bugs\n    @positions = map { $_->[1] }\n                 sort { $a->[0] <=> $b->[0] }\n                 map { [$_->sortable, $_] }\n                 @positions;\n    return @positions;\n}\n\n=head2 each_position\n\n Title   : each_position\n Function: Synonym of the get_positions() method.\n Status  : deprecated, will be removed in next version\n\n\n*each_position = \\&get_positions;\n\n=head2 purge_positions\n\n Title   : purge_positions\n Usage   : $map->purge_position();\n Function: Remove all positions from this map. Notifies the positions they are\n           no longer on this map.\n Returns : n/a\n Args    : none to remove all positions, OR\n           L<Bio::Map::PositionI> object to remove just that Position, OR\n\t\t   L<Bio::Map::MappableI> object to remove only those positions of the\n           given mappable\n\n\nsub purge_positions {\n    my ($self, $thing) = @_;\n    $self->get_position_handler->purge_positions($thing);\n}\n\n=head2 get_elements\n\n Title   : get_elements\n Usage   : my @elements = $map->get_elements;\n Function: Retrieves all the elements on a map (unordered)\n Returns : Array of Map elements (L<Bio::Map::MappableI>)\n Args    : none\n\n\nsub get_elements {\n    my $self = shift;\n    return $self->get_position_handler->get_other_entities;\n}\n\n=head2 each_element\n\n Title   : each_element\n Function: Synonym of the get_elements() method.\n Status  : deprecated, will be removed in the next version\n\n\n=head2 common_elements\n\n Title   : common_elements\n Usage   : my @common_elements = $map->common_elements(\\@other_maps);\n           my @common_elements = Bio::Map::SimpleMap->common_elements(\\@maps);\n Function: Find the elements that are common to multiple maps.\n Returns : array of Bio::Map::MappableI\n Args    : arg #1 = L<Bio::Map::MapI> to compare this one to, or an array ref\n                    of such objects (mandatory)\n           arg #2 = optionally, one or more of the key => value pairs below\n           -min_num => int        : the minimum number of input maps an element\n                                    must be found on before before returned\n                                    [default is 1]\n           -min_percent => number : as above, but the minimum percentage of\n                                    input maps [default is 100 - note that this\n                                    will effectively override all other options]\n           -require_self => 1|0   : require that all output elements at least\n                                    be on the calling map [default is 1, has no\n                                    effect when the second usage form is used]\n           -required => \\@maps    : require that all output elements be on at\n                                    least all the maps supplied here"},"line":219,"range":{"start":{"character":0,"line":219},"end":{"line":225,"character":9999}},"kind":12,"definition":"sub","detail":"($self,$maps_ref,@extra_args)","children":[{"definition":"my","line":220,"name":"$self","localvar":"my","kind":13,"containerName":"common_elements"},{"kind":13,"containerName":"common_elements","name":"$maps_ref","line":220},{"line":220,"containerName":"common_elements","kind":13,"name":"@extra_args"},{"line":221,"kind":13,"containerName":"common_elements","name":"$self"},{"kind":12,"containerName":"common_elements","name":"throw","line":221},{"line":221,"name":"$maps_ref","kind":13,"containerName":"common_elements"},{"definition":"my","containerName":"common_elements","localvar":"my","kind":13,"name":"@maps","line":222},{"containerName":"common_elements","kind":13,"name":"$maps_ref","line":223},{"line":224,"containerName":"common_elements","kind":13,"name":"@maps"},{"line":224,"kind":13,"containerName":"common_elements","name":"$maps_ref"}],"name":"common_elements","containerName":"main::"},{"line":226,"name":"$maps_ref","kind":13,"containerName":null},{"line":226,"name":"isa","containerName":"main::","kind":12},{"line":227,"kind":13,"containerName":null,"name":"@maps"},{"name":"$maps_ref","containerName":null,"kind":13,"line":227},{"name":"%self","kind":13,"containerName":null,"line":229},{"line":230,"containerName":null,"kind":13,"name":"@maps"},{"containerName":null,"kind":13,"name":"$self","line":230},{"line":232,"name":"$self","kind":13,"containerName":null},{"line":232,"kind":12,"containerName":"main::","name":"throw"},{"containerName":null,"kind":13,"name":"@maps","line":232},{"line":234,"localvar":"my","kind":13,"containerName":null,"name":"%args","definition":"my"},{"name":"@extra_args","kind":13,"containerName":null,"line":234},{"name":"$min_num","containerName":null,"localvar":"my","kind":13,"line":235,"definition":"my"},{"line":235,"name":"%args","kind":13,"containerName":null},{"line":236,"kind":13,"containerName":null,"name":"%args"},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"$mn","line":237},{"line":237,"kind":13,"containerName":null,"name":"@maps"},{"kind":13,"containerName":null,"name":"%args","line":237},{"line":238,"containerName":null,"kind":13,"name":"$mn"},{"containerName":null,"kind":13,"name":"%min_num","line":238},{"kind":13,"containerName":null,"name":"$min_num","line":239},{"containerName":null,"kind":13,"name":"$mn","line":239},{"definition":"my","name":"%required","localvar":"my","kind":13,"containerName":null,"line":242},{"containerName":null,"kind":13,"name":"%args","line":242},{"line":242,"kind":13,"containerName":null,"name":"%args"},{"name":"%required","containerName":null,"kind":13,"line":243},{"line":243,"name":"$self","containerName":null,"kind":13},{"name":"$self","containerName":null,"kind":13,"line":243},{"name":"%args","containerName":null,"kind":13,"line":243},{"definition":"my","name":"@required","localvar":"my","kind":13,"containerName":null,"line":244},{"line":244,"name":"%required","kind":13,"containerName":null},{"definition":"my","line":246,"localvar":"my","containerName":null,"kind":13,"name":"%map_elements"},{"localvar":"my","containerName":null,"kind":13,"name":"%elements","line":247,"definition":"my"},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"%count","line":248},{"line":249,"kind":13,"localvar":"my","containerName":null,"name":"$map","definition":"my"},{"line":249,"name":"@maps","kind":13,"containerName":null},{"line":250,"name":"%map_elements","containerName":null,"kind":13},{"name":"%map","containerName":null,"kind":13,"line":250},{"name":"$element","localvar":"my","containerName":null,"kind":13,"line":251,"definition":"my"},{"line":251,"name":"$map","kind":13,"containerName":null},{"line":251,"name":"get_elements","kind":12,"containerName":"main::"},{"name":"%map_elements","containerName":null,"kind":13,"line":252},{"name":"%map","containerName":null,"kind":13,"line":252},{"line":252,"kind":13,"containerName":null,"name":"$element"},{"name":"%elements","kind":13,"containerName":null,"line":253},{"containerName":null,"kind":13,"name":"$element","line":253},{"line":253,"name":"$element","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"%count","line":254},{"line":254,"name":"$element","kind":13,"containerName":null},{"name":"@elements","containerName":null,"localvar":"my","kind":13,"line":258,"definition":"my"},{"line":259,"kind":12,"name":"ELEMENT"},{"name":"$key","localvar":"my","containerName":null,"kind":13,"line":259,"definition":"my"},{"line":259,"name":"$value","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"%elements","line":259},{"containerName":null,"kind":13,"name":"%count","line":260},{"kind":13,"containerName":null,"name":"$key","line":260},{"line":260,"containerName":null,"kind":13,"name":"$min_num"},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"$required","line":261},{"name":"@required","containerName":null,"kind":13,"line":261},{"kind":13,"containerName":null,"name":"%map_elements","line":262},{"line":262,"name":"%required","kind":13,"containerName":null},{"line":262,"name":"$key","containerName":null,"kind":13},{"kind":12,"name":"ELEMENT","line":262},{"line":265,"kind":13,"containerName":null,"name":"@elements"},{"name":"$value","containerName":null,"kind":13,"line":265},{"name":"@elements","kind":13,"containerName":null,"line":267},{"definition":"sub","children":[{"definition":"my","line":285,"name":"$self","kind":13,"localvar":"my","containerName":"species"},{"kind":13,"containerName":"species","name":"$self","line":286},{"name":"throw_not_implemented","kind":12,"containerName":"species","line":286}],"containerName":"main::","name":"species","line":284,"kind":12,"range":{"start":{"character":0,"line":284},"end":{"character":9999,"line":287}}},{"kind":12,"range":{"end":{"character":9999,"line":302},"start":{"character":0,"line":299}},"line":299,"containerName":"main::","name":"units","children":[{"definition":"my","name":"$self","containerName":"units","localvar":"my","kind":13,"line":300},{"line":301,"name":"$self","containerName":"units","kind":13},{"name":"throw_not_implemented","containerName":"units","kind":12,"line":301}],"definition":"sub"},{"name":"type","containerName":"main::","children":[{"definition":"my","line":315,"name":"$self","localvar":"my","kind":13,"containerName":"type"},{"name":"$self","kind":13,"containerName":"type","line":316},{"line":316,"name":"throw_not_implemented","containerName":"type","kind":12}],"definition":"sub","kind":12,"range":{"end":{"line":317,"character":9999},"start":{"line":314,"character":0}},"line":314},{"containerName":"main::","name":"name","children":[{"kind":13,"localvar":"my","containerName":"name","name":"$self","line":330,"definition":"my"},{"kind":13,"containerName":"name","name":"$self","line":331},{"line":331,"containerName":"name","kind":12,"name":"throw_not_implemented"}],"definition":"sub","kind":12,"range":{"end":{"character":9999,"line":332},"start":{"line":329,"character":0}},"line":329},{"line":347,"range":{"end":{"line":350,"character":9999},"start":{"line":347,"character":0}},"kind":12,"children":[{"containerName":"length","localvar":"my","kind":13,"name":"$self","line":348,"definition":"my"},{"line":349,"containerName":"length","kind":13,"name":"$self"},{"kind":12,"containerName":"length","name":"throw_not_implemented","line":349}],"containerName":"main::","name":"length","definition":"sub"}],"version":5}