{"version":5,"vars":[{"containerName":"strict::Scalar","kind":2,"name":"Util","line":87},{"kind":2,"containerName":"","name":"base","line":89},{"line":118,"kind":12,"range":{"end":{"character":9999,"line":145},"start":{"character":0,"line":118}},"signature":{"documentation":"1;\n# $Id: GeneRelative.pm,v 1.6 2006/09/20 11:53:29 sendu Exp $\n#\n# BioPerl module for Bio::Map::GeneRelative\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::GeneRelative - Represents being relative to named sub-regions of a\n                         gene.\n\n=head1 SYNOPSIS\n\n    use Bio::Map::GeneRelative;\n\n    # say that a somthing will have a position relative to the start of the\n    # gene on map\n    my $rel = Bio::Map::GeneRelative->new(-gene => 0);\n\n    # or that something will be relative to the third transcript of a gene\n    # on a map\n    $rel = Bio::Map::GeneRelative->new(-transcript => 3);\n\n    # or to the 5th intron of the default transcript\n    $rel = Bio::Map::GeneRelative->new(-intron => [0, 5]);\n\n    # use the $rel as normal; see L<Bio::Map::Relative>\n\n=head1 DESCRIPTION\n\nBe able to say that a given position is relative to some standard part of a\ngene.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::GeneRelative;\nuse strict;\n\nuse Scalar::Util qw(looks_like_number);\n\nuse base qw(Bio::Map::Relative);\n\n=head2 new\n\n Title   : new\n Usage   : my $relative = Bio::Map::Relative->new();\n Function: Build a new Bio::Map::Relative object.\n Returns : Bio::Map::Relative object\n Args    : -gene => int       : coordinates are relative to the int'th base\n                                downstream of the Position's map's gene\n                                [default is gene => 0, ie. relative to the\n                                start of the gene],\n           -transcript => int : or relative to the start of the int'th\n                                transcript of the Position's map's gene,\n           -exon => [i, n]    : or relative to the start of the n'th\n                                transcript's i'th exon,\n           -intron => [i, n]  : or intron,\n           -coding => int     : or the start of the int'th transcript's coding\n                                region.\n\n           -description => string : Free text description of what this relative\n                                    describes\n\n           (To say a Position is relative to something and upstream of it,\n            the Position's start() co-ordinate should be set negative)\n           In all cases, a transcript number of 0 means the active transcript.","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"children":[{"line":119,"name":"$class","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"name":"@args","containerName":"new","kind":13,"line":119},{"name":"$self","kind":13,"localvar":"my","containerName":"new","line":120,"definition":"my"},{"name":"$class","kind":13,"containerName":"new","line":120},{"kind":13,"containerName":"new","name":"@args","line":120},{"line":122,"name":"$gene","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"kind":13,"containerName":"new","name":"$transcript","line":122},{"line":122,"kind":13,"containerName":"new","name":"$exon"},{"name":"$intron","kind":13,"containerName":"new","line":122},{"line":122,"containerName":"new","kind":13,"name":"$coding"},{"line":123,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"containerName":"new","name":"_rearrange","line":123},{"line":123,"kind":13,"containerName":"new","name":"@args"},{"name":"$set","localvar":"my","containerName":"new","kind":13,"line":125,"definition":"my"},{"line":125,"kind":13,"containerName":"new","name":"$gene"},{"name":"$transcript","kind":13,"containerName":"new","line":125},{"line":125,"name":"$exon","containerName":"new","kind":13},{"name":"$intron","containerName":"new","kind":13,"line":125},{"line":125,"name":"$coding","containerName":"new","kind":13},{"line":126,"kind":13,"containerName":"new","name":"$set"},{"kind":13,"containerName":"new","name":"$self","line":127},{"line":127,"name":"throw","kind":12,"containerName":"new"},{"line":129,"containerName":"new","kind":13,"name":"$exon"},{"name":"$exon","containerName":"new","kind":13,"line":129},{"line":129,"name":"$exon","kind":13,"containerName":"new"},{"line":130,"name":"$self","kind":13,"containerName":"new"},{"containerName":"new","kind":12,"name":"throw","line":130},{"name":"$intron","containerName":"new","kind":13,"line":132},{"containerName":"new","kind":13,"name":"$intron","line":132},{"line":132,"kind":13,"containerName":"new","name":"$intron"},{"kind":13,"containerName":"new","name":"$self","line":133},{"kind":12,"containerName":"new","name":"throw","line":133},{"kind":13,"containerName":"new","name":"$set","line":135},{"name":"$self","kind":13,"containerName":"new","line":137},{"name":"type","containerName":"new","kind":12,"line":137},{"kind":13,"containerName":"new","name":"$self","line":138},{"name":"warn","kind":12,"containerName":"new","line":138},{"line":140,"name":"$gene","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$self","line":143},{"name":"gene","kind":12,"containerName":"new","line":143},{"line":143,"kind":13,"containerName":"new","name":"$gene"},{"containerName":"new","kind":13,"name":"$gene","line":143},{"line":144,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","kind":12,"name":"transcript","line":144},{"name":"$transcript","containerName":"new","kind":13,"line":144},{"line":144,"containerName":"new","kind":13,"name":"$transcript"},{"line":145,"containerName":"new","kind":13,"name":"$self"},{"line":145,"containerName":"new","kind":12,"name":"exon"},{"line":145,"name":"$exon","kind":13,"containerName":"new"}],"name":"new","containerName":"main::","definition":"sub","detail":"($class,@args)"},{"line":120,"kind":12,"containerName":"new","name":"SUPER"},{"line":145,"name":"$exon","containerName":null,"kind":13},{"line":146,"containerName":null,"kind":13,"name":"$self"},{"line":146,"kind":12,"containerName":"main::","name":"intron"},{"containerName":null,"kind":13,"name":"$intron","line":146},{"kind":13,"containerName":null,"name":"$intron","line":146},{"line":147,"name":"$self","containerName":null,"kind":13},{"line":147,"name":"coding","kind":12,"containerName":"main::"},{"kind":13,"containerName":null,"name":"$coding","line":147},{"containerName":null,"kind":13,"name":"$coding","line":147},{"name":"$self","kind":13,"containerName":null,"line":149},{"children":[{"line":164,"kind":13,"localvar":"my","containerName":"absolute_conversion","name":"$self","definition":"my"},{"line":164,"name":"$pos","kind":13,"containerName":"absolute_conversion"},{"line":165,"containerName":"absolute_conversion","kind":13,"name":"$self"},{"name":"throw","kind":12,"containerName":"absolute_conversion","line":165},{"line":165,"name":"$pos","kind":13,"containerName":"absolute_conversion"},{"line":166,"name":"$self","kind":13,"containerName":"absolute_conversion"},{"name":"throw","containerName":"absolute_conversion","kind":12,"line":166},{"name":"$pos","kind":13,"containerName":"absolute_conversion","line":166},{"name":"isa","kind":12,"containerName":"absolute_conversion","line":166},{"definition":"my","line":169,"localvar":"my","kind":13,"containerName":"absolute_conversion","name":"$raw"},{"containerName":"absolute_conversion","kind":13,"name":"$pos","line":169},{"line":169,"kind":12,"containerName":"absolute_conversion","name":"start"},{"name":"$pos","kind":13,"containerName":"absolute_conversion","line":169},{"name":"relative","containerName":"absolute_conversion","kind":12,"line":169},{"line":170,"name":"$self","containerName":"absolute_conversion","kind":13},{"name":"throw","containerName":"absolute_conversion","kind":12,"line":170},{"name":"$raw","kind":13,"containerName":"absolute_conversion","line":170},{"line":173,"kind":13,"localvar":"my","containerName":"absolute_conversion","name":"$type","definition":"my"},{"containerName":"absolute_conversion","kind":13,"name":"$self","line":173},{"name":"type","containerName":"absolute_conversion","kind":12,"line":173},{"definition":"my","line":174,"kind":13,"localvar":"my","containerName":"absolute_conversion","name":"$value"},{"line":174,"containerName":"absolute_conversion","kind":13,"name":"$self"},{"line":174,"containerName":"absolute_conversion","kind":13,"name":"$type"},{"name":"$self","kind":13,"containerName":"absolute_conversion","line":175},{"line":175,"containerName":"absolute_conversion","kind":12,"name":"throw"},{"line":175,"name":"$value","containerName":"absolute_conversion","kind":13},{"containerName":"absolute_conversion","kind":13,"name":"$type","line":178},{"definition":"my","line":179,"name":"$map","localvar":"my","containerName":"absolute_conversion","kind":13},{"line":179,"containerName":"absolute_conversion","kind":13,"name":"$pos"},{"containerName":"absolute_conversion","kind":12,"name":"map","line":179},{"line":180,"name":"$throw_desc","containerName":"absolute_conversion","localvar":"my","kind":13,"definition":"my"},{"line":180,"name":"$type","containerName":"absolute_conversion","kind":13},{"containerName":"absolute_conversion","kind":13,"name":"$self","line":181},{"line":181,"containerName":"absolute_conversion","kind":12,"name":"throw"},{"line":181,"containerName":"absolute_conversion","kind":13,"name":"$map"},{"name":"$self","containerName":"absolute_conversion","kind":13,"line":182},{"containerName":"absolute_conversion","kind":12,"name":"throw","line":182},{"name":"$map","kind":13,"containerName":"absolute_conversion","line":182},{"line":182,"name":"isa","containerName":"absolute_conversion","kind":12},{"localvar":"my","containerName":"absolute_conversion","kind":13,"name":"$gene","line":183,"definition":"my"},{"containerName":"absolute_conversion","kind":13,"name":"$map","line":183},{"line":183,"kind":12,"containerName":"absolute_conversion","name":"gene"},{"line":185,"name":"$type","kind":13,"containerName":"absolute_conversion"},{"localvar":"my","containerName":"absolute_conversion","kind":13,"name":"$gene_pos","line":186,"definition":"my"},{"name":"$gene","kind":13,"containerName":"absolute_conversion","line":186},{"line":186,"kind":12,"containerName":"absolute_conversion","name":"position"},{"kind":13,"containerName":"absolute_conversion","name":"$map","line":186},{"definition":"my","line":187,"localvar":"my","containerName":"absolute_conversion","kind":13,"name":"$rel"},{"line":187,"kind":13,"containerName":"absolute_conversion","name":"$gene_pos"},{"line":187,"kind":12,"containerName":"absolute_conversion","name":"relative"},{"line":188,"localvar":"my","kind":13,"containerName":"absolute_conversion","name":"$start","definition":"my"},{"containerName":"absolute_conversion","kind":13,"name":"$rel","line":188},{"name":"absolute_conversion","containerName":"absolute_conversion","kind":12,"line":188},{"line":188,"kind":13,"containerName":"absolute_conversion","name":"$gene_pos"},{"name":"$value","containerName":"absolute_conversion","kind":13,"line":189},{"line":189,"kind":13,"containerName":"absolute_conversion","name":"$start"},{"line":192,"name":"@values","localvar":"my","containerName":"absolute_conversion","kind":13,"definition":"my"},{"line":192,"name":"$value","kind":13,"containerName":"absolute_conversion"},{"name":"$value","kind":13,"containerName":"absolute_conversion","line":192},{"name":"$value","kind":13,"containerName":"absolute_conversion","line":192},{"line":193,"containerName":"absolute_conversion","localvar":"my","kind":13,"name":"$trans","definition":"my"},{"line":193,"kind":13,"containerName":"absolute_conversion","name":"$value"},{"line":193,"name":"$values","kind":13,"containerName":"absolute_conversion"},{"line":193,"name":"$value","containerName":"absolute_conversion","kind":13},{"definition":"my","line":194,"containerName":"absolute_conversion","localvar":"my","kind":13,"name":"$throw_txt"},{"name":"$trans","kind":13,"containerName":"absolute_conversion","line":194},{"line":195,"name":"$throw_txt2","localvar":"my","containerName":"absolute_conversion","kind":13,"definition":"my"},{"containerName":"absolute_conversion","kind":13,"name":"$value","line":195},{"line":196,"kind":13,"localvar":"my","containerName":"absolute_conversion","name":"$method","definition":"my"},{"name":"$type","kind":13,"containerName":"absolute_conversion","line":196},{"containerName":"absolute_conversion","kind":13,"name":"$value","line":197},{"name":"$gene","containerName":"absolute_conversion","kind":13,"line":197},{"kind":13,"containerName":"absolute_conversion","name":"$method","line":197},{"line":197,"name":"$map","kind":13,"containerName":"absolute_conversion"},{"containerName":"absolute_conversion","kind":13,"name":"@values","line":197},{"line":197,"containerName":"absolute_conversion","kind":13,"name":"$self"},{"line":197,"name":"throw","kind":12,"containerName":"absolute_conversion"}],"name":"absolute_conversion","containerName":"main::","definition":"sub","detail":"($self,$pos)","line":163,"kind":12,"range":{"start":{"character":0,"line":163},"end":{"line":199,"character":9999}},"signature":{"parameters":[{"label":"$self"},{"label":"$pos"}],"documentation":"1;\n# $Id: GeneRelative.pm,v 1.6 2006/09/20 11:53:29 sendu Exp $\n#\n# BioPerl module for Bio::Map::GeneRelative\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::GeneRelative - Represents being relative to named sub-regions of a\n                         gene.\n\n=head1 SYNOPSIS\n\n    use Bio::Map::GeneRelative;\n\n    # say that a somthing will have a position relative to the start of the\n    # gene on map\n    my $rel = Bio::Map::GeneRelative->new(-gene => 0);\n\n    # or that something will be relative to the third transcript of a gene\n    # on a map\n    $rel = Bio::Map::GeneRelative->new(-transcript => 3);\n\n    # or to the 5th intron of the default transcript\n    $rel = Bio::Map::GeneRelative->new(-intron => [0, 5]);\n\n    # use the $rel as normal; see L<Bio::Map::Relative>\n\n=head1 DESCRIPTION\n\nBe able to say that a given position is relative to some standard part of a\ngene.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::GeneRelative;\nuse strict;\n\nuse Scalar::Util qw(looks_like_number);\n\nuse base qw(Bio::Map::Relative);\n\n=head2 new\n\n Title   : new\n Usage   : my $relative = Bio::Map::Relative->new();\n Function: Build a new Bio::Map::Relative object.\n Returns : Bio::Map::Relative object\n Args    : -gene => int       : coordinates are relative to the int'th base\n                                downstream of the Position's map's gene\n                                [default is gene => 0, ie. relative to the\n                                start of the gene],\n           -transcript => int : or relative to the start of the int'th\n                                transcript of the Position's map's gene,\n           -exon => [i, n]    : or relative to the start of the n'th\n                                transcript's i'th exon,\n           -intron => [i, n]  : or intron,\n           -coding => int     : or the start of the int'th transcript's coding\n                                region.\n\n           -description => string : Free text description of what this relative\n                                    describes\n\n           (To say a Position is relative to something and upstream of it,\n            the Position's start() co-ordinate should be set negative)\n           In all cases, a transcript number of 0 means the active transcript.\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($gene, $transcript, $exon, $intron, $coding) =\n        $self->_rearrange([qw( GENE TRANSCRIPT EXON INTRON CODING )], @args);\n    \n    my $set = (defined $gene) + (defined $transcript) + (defined $exon) + (defined $intron) + (defined $coding);\n    if ($set > 1) {\n        $self->throw(\"-gene, -transcript, -exon, -intron and -coding are mutually exclusive\");\n    }\n    if ($exon && (! ref($exon) || ref($exon) ne 'ARRAY')) {\n        $self->throw(\"-exon takes an array ref\");\n    }\n    if ($intron && (! ref($intron) || ref($intron) ne 'ARRAY')) {\n        $self->throw(\"-intron takes an array ref\");\n    }\n    if ($set == 0) {\n        # type could have been set already in the call to SUPER::new\n        if ($self->type) {\n            $self->warn(\"You set a type of relative not supported by GeneRelative; resetting to type 'gene'\");\n        }\n        $gene = 0;\n    }\n    \n    $self->gene($gene) if defined $gene;\n    $self->transcript($transcript) if defined $transcript;\n    $self->exon(@{$exon}) if defined $exon;\n    $self->intron(@{$intron}) if defined $intron;\n    $self->coding($coding) if defined $coding;\n    \n    return $self;\n}\n\n=head2 absolute_conversion\n\n Title   : absolute_conversion\n Usage   : my $absolute_coord = $relative->absolute_conversion($pos);\n Function: Convert the start co-ordinate of the supplied position into a number\n           relative to the start of its map.\n Returns : scalar number\n Args    : Bio::Map::PositionI object","label":"absolute_conversion($self,$pos)"}},{"name":"$self","containerName":null,"kind":13,"line":201},{"line":201,"containerName":"absolute_conversion","kind":12,"name":"SUPER"},{"containerName":null,"kind":13,"name":"$pos","line":201},{"name":"%value","containerName":null,"kind":13,"line":203},{"definition":"my","name":"$rel","localvar":"my","containerName":null,"kind":13,"line":205},{"line":205,"containerName":null,"kind":13,"name":"$value"},{"containerName":"main::","kind":12,"name":"relative","line":205},{"line":206,"kind":13,"containerName":null,"name":"$value"},{"line":206,"containerName":null,"kind":13,"name":"$rel"},{"line":206,"containerName":"main::","kind":12,"name":"absolute_conversion"},{"line":206,"containerName":null,"kind":13,"name":"$value"},{"name":"%value","containerName":null,"kind":13,"line":209},{"name":"$value","containerName":null,"kind":13,"line":210},{"name":"$raw","containerName":null,"kind":13,"line":210},{"signature":{"parameters":[{"label":"$self"},{"label":"$num"}],"documentation":"1;\n# $Id: GeneRelative.pm,v 1.6 2006/09/20 11:53:29 sendu Exp $\n#\n# BioPerl module for Bio::Map::GeneRelative\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::GeneRelative - Represents being relative to named sub-regions of a\n                         gene.\n\n=head1 SYNOPSIS\n\n    use Bio::Map::GeneRelative;\n\n    # say that a somthing will have a position relative to the start of the\n    # gene on map\n    my $rel = Bio::Map::GeneRelative->new(-gene => 0);\n\n    # or that something will be relative to the third transcript of a gene\n    # on a map\n    $rel = Bio::Map::GeneRelative->new(-transcript => 3);\n\n    # or to the 5th intron of the default transcript\n    $rel = Bio::Map::GeneRelative->new(-intron => [0, 5]);\n\n    # use the $rel as normal; see L<Bio::Map::Relative>\n\n=head1 DESCRIPTION\n\nBe able to say that a given position is relative to some standard part of a\ngene.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::GeneRelative;\nuse strict;\n\nuse Scalar::Util qw(looks_like_number);\n\nuse base qw(Bio::Map::Relative);\n\n=head2 new\n\n Title   : new\n Usage   : my $relative = Bio::Map::Relative->new();\n Function: Build a new Bio::Map::Relative object.\n Returns : Bio::Map::Relative object\n Args    : -gene => int       : coordinates are relative to the int'th base\n                                downstream of the Position's map's gene\n                                [default is gene => 0, ie. relative to the\n                                start of the gene],\n           -transcript => int : or relative to the start of the int'th\n                                transcript of the Position's map's gene,\n           -exon => [i, n]    : or relative to the start of the n'th\n                                transcript's i'th exon,\n           -intron => [i, n]  : or intron,\n           -coding => int     : or the start of the int'th transcript's coding\n                                region.\n\n           -description => string : Free text description of what this relative\n                                    describes\n\n           (To say a Position is relative to something and upstream of it,\n            the Position's start() co-ordinate should be set negative)\n           In all cases, a transcript number of 0 means the active transcript.\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($gene, $transcript, $exon, $intron, $coding) =\n        $self->_rearrange([qw( GENE TRANSCRIPT EXON INTRON CODING )], @args);\n    \n    my $set = (defined $gene) + (defined $transcript) + (defined $exon) + (defined $intron) + (defined $coding);\n    if ($set > 1) {\n        $self->throw(\"-gene, -transcript, -exon, -intron and -coding are mutually exclusive\");\n    }\n    if ($exon && (! ref($exon) || ref($exon) ne 'ARRAY')) {\n        $self->throw(\"-exon takes an array ref\");\n    }\n    if ($intron && (! ref($intron) || ref($intron) ne 'ARRAY')) {\n        $self->throw(\"-intron takes an array ref\");\n    }\n    if ($set == 0) {\n        # type could have been set already in the call to SUPER::new\n        if ($self->type) {\n            $self->warn(\"You set a type of relative not supported by GeneRelative; resetting to type 'gene'\");\n        }\n        $gene = 0;\n    }\n    \n    $self->gene($gene) if defined $gene;\n    $self->transcript($transcript) if defined $transcript;\n    $self->exon(@{$exon}) if defined $exon;\n    $self->intron(@{$intron}) if defined $intron;\n    $self->coding($coding) if defined $coding;\n    \n    return $self;\n}\n\n=head2 absolute_conversion\n\n Title   : absolute_conversion\n Usage   : my $absolute_coord = $relative->absolute_conversion($pos);\n Function: Convert the start co-ordinate of the supplied position into a number\n           relative to the start of its map.\n Returns : scalar number\n Args    : Bio::Map::PositionI object\n\n\nsub absolute_conversion {\n    my ($self, $pos) = @_;\n    $self->throw(\"Must supply an object\") unless ref($pos);\n    $self->throw(\"This is [$pos], not a Bio::Map::PositionI\") unless $pos->isa('Bio::Map::PositionI');\n    \n    # get the raw start position of our position\n    my $raw = $pos->start($pos->relative);\n    $self->throw(\"Can't convert co-ordinates when start isn't set\") unless defined($raw); #*** needed? return undef?\n    \n    # what are we relative to?\n    my $type = $self->type;\n    my $value = $self->$type;\n    $self->throw(\"Details not yet set for this Relative, cannot convert\") unless defined($value);\n    \n    # get the absolute start of the thing we're relative to\n    if ($type =~ /gene|transcript|exon|intron|coding/) {\n        my $map = $pos->map;\n        my $throw_desc = $type eq 'gene' ? 'gene' : \"gene's transcript\";\n        $self->throw(\"Relative to a map's $throw_desc, but the Position has no map\") unless $map;\n        $self->throw(\"Relative to a map's $throw_desc, but the Position's map isn't a Bio::Map::GeneMap\") unless $map->isa('Bio::Map::GeneMap');\n        my $gene = $map->gene;\n        \n        if ($type eq 'gene') {\n            my $gene_pos = $gene->position($map);\n            my $rel = $gene_pos->relative;\n            my $start = $rel->absolute_conversion($gene_pos);\n            $value += $start;\n        }\n        else {\n            my @values = ref($value) ? @{$value} : ($value);\n            my $trans = ref($value) ? $values[1] : $value;\n            my $throw_txt = $trans == 0 ? 'default/active transcript' : \"transcript $trans\";\n            my $throw_txt2 = ref($value) ? \", or no $type $values[0]\" : '';\n            my $method = $type eq 'coding' ? 'coding_position' : \"get_${type}_position\";\n            $value = $gene->$method($map, @values) || $self->throw(\"Relative to $throw_txt of the map's gene, but there is no such transcript$throw_txt2\");\n        }\n    }\n    else {\n        return $self->SUPER::absolute_conversion($pos);\n    }\n    if (ref($value)) {\n        # psuedo-recurse\n        my $rel = $value->relative;\n        $value = $rel->absolute_conversion($value);\n    }\n    \n    if (defined($value)) {\n        return $value + $raw;\n    }\n    return;\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $relative->type();\n Function: Get the type of thing we are relative to. The types correspond\n           to a method name, so the value of what we are relative to can\n           subsequently be found by $value = $relative->$type;\n\n           Note that type is set by the last method that was set, or during\n           new().\n\n Returns : 'gene', 'transcript', 'exon', 'intron' or 'coding'\n Args    : none\n\n\n=head2 gene\n\n Title   : gene\n Usage   : my $int = $relative->gene();\n           $relative->gene($int);\n Function: Get/set the distance from the start of the gene that the Position's\n           co-ordiantes are relative to.\n Returns : int\n Args    : none to get, OR\n           int to set; a value of 0 means relative to the start of the gene.","label":"gene($self,$num)"},"line":244,"range":{"start":{"line":244,"character":0},"end":{"line":252,"character":9999}},"kind":12,"definition":"sub","detail":"($self,$num)","children":[{"definition":"my","localvar":"my","containerName":"gene","kind":13,"name":"$self","line":245},{"containerName":"gene","kind":13,"name":"$num","line":245},{"kind":13,"containerName":"gene","name":"$num","line":246},{"kind":13,"containerName":"gene","name":"$self","line":247},{"line":247,"name":"throw","kind":12,"containerName":"gene"},{"line":247,"containerName":"gene","kind":13,"name":"$num"},{"name":"$self","containerName":"gene","kind":13,"line":248},{"line":249,"name":"$self","kind":13,"containerName":"gene"},{"line":249,"kind":13,"containerName":"gene","name":"$num"},{"name":"$self","kind":13,"containerName":"gene","line":251},{"containerName":"gene","kind":13,"name":"$self","line":251}],"name":"gene","containerName":"main::"},{"line":247,"kind":12,"name":"looks_like_number"},{"kind":12,"name":"_use","line":248},{"name":"_gene","kind":12,"line":249},{"kind":12,"name":"_gene","line":251},{"line":251,"name":"_gene","kind":12},{"range":{"start":{"line":267,"character":0},"end":{"character":9999,"line":275}},"kind":12,"line":267,"signature":{"label":"transcript($self,$num)","documentation":"1;\n# $Id: GeneRelative.pm,v 1.6 2006/09/20 11:53:29 sendu Exp $\n#\n# BioPerl module for Bio::Map::GeneRelative\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::GeneRelative - Represents being relative to named sub-regions of a\n                         gene.\n\n=head1 SYNOPSIS\n\n    use Bio::Map::GeneRelative;\n\n    # say that a somthing will have a position relative to the start of the\n    # gene on map\n    my $rel = Bio::Map::GeneRelative->new(-gene => 0);\n\n    # or that something will be relative to the third transcript of a gene\n    # on a map\n    $rel = Bio::Map::GeneRelative->new(-transcript => 3);\n\n    # or to the 5th intron of the default transcript\n    $rel = Bio::Map::GeneRelative->new(-intron => [0, 5]);\n\n    # use the $rel as normal; see L<Bio::Map::Relative>\n\n=head1 DESCRIPTION\n\nBe able to say that a given position is relative to some standard part of a\ngene.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::GeneRelative;\nuse strict;\n\nuse Scalar::Util qw(looks_like_number);\n\nuse base qw(Bio::Map::Relative);\n\n=head2 new\n\n Title   : new\n Usage   : my $relative = Bio::Map::Relative->new();\n Function: Build a new Bio::Map::Relative object.\n Returns : Bio::Map::Relative object\n Args    : -gene => int       : coordinates are relative to the int'th base\n                                downstream of the Position's map's gene\n                                [default is gene => 0, ie. relative to the\n                                start of the gene],\n           -transcript => int : or relative to the start of the int'th\n                                transcript of the Position's map's gene,\n           -exon => [i, n]    : or relative to the start of the n'th\n                                transcript's i'th exon,\n           -intron => [i, n]  : or intron,\n           -coding => int     : or the start of the int'th transcript's coding\n                                region.\n\n           -description => string : Free text description of what this relative\n                                    describes\n\n           (To say a Position is relative to something and upstream of it,\n            the Position's start() co-ordinate should be set negative)\n           In all cases, a transcript number of 0 means the active transcript.\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($gene, $transcript, $exon, $intron, $coding) =\n        $self->_rearrange([qw( GENE TRANSCRIPT EXON INTRON CODING )], @args);\n    \n    my $set = (defined $gene) + (defined $transcript) + (defined $exon) + (defined $intron) + (defined $coding);\n    if ($set > 1) {\n        $self->throw(\"-gene, -transcript, -exon, -intron and -coding are mutually exclusive\");\n    }\n    if ($exon && (! ref($exon) || ref($exon) ne 'ARRAY')) {\n        $self->throw(\"-exon takes an array ref\");\n    }\n    if ($intron && (! ref($intron) || ref($intron) ne 'ARRAY')) {\n        $self->throw(\"-intron takes an array ref\");\n    }\n    if ($set == 0) {\n        # type could have been set already in the call to SUPER::new\n        if ($self->type) {\n            $self->warn(\"You set a type of relative not supported by GeneRelative; resetting to type 'gene'\");\n        }\n        $gene = 0;\n    }\n    \n    $self->gene($gene) if defined $gene;\n    $self->transcript($transcript) if defined $transcript;\n    $self->exon(@{$exon}) if defined $exon;\n    $self->intron(@{$intron}) if defined $intron;\n    $self->coding($coding) if defined $coding;\n    \n    return $self;\n}\n\n=head2 absolute_conversion\n\n Title   : absolute_conversion\n Usage   : my $absolute_coord = $relative->absolute_conversion($pos);\n Function: Convert the start co-ordinate of the supplied position into a number\n           relative to the start of its map.\n Returns : scalar number\n Args    : Bio::Map::PositionI object\n\n\nsub absolute_conversion {\n    my ($self, $pos) = @_;\n    $self->throw(\"Must supply an object\") unless ref($pos);\n    $self->throw(\"This is [$pos], not a Bio::Map::PositionI\") unless $pos->isa('Bio::Map::PositionI');\n    \n    # get the raw start position of our position\n    my $raw = $pos->start($pos->relative);\n    $self->throw(\"Can't convert co-ordinates when start isn't set\") unless defined($raw); #*** needed? return undef?\n    \n    # what are we relative to?\n    my $type = $self->type;\n    my $value = $self->$type;\n    $self->throw(\"Details not yet set for this Relative, cannot convert\") unless defined($value);\n    \n    # get the absolute start of the thing we're relative to\n    if ($type =~ /gene|transcript|exon|intron|coding/) {\n        my $map = $pos->map;\n        my $throw_desc = $type eq 'gene' ? 'gene' : \"gene's transcript\";\n        $self->throw(\"Relative to a map's $throw_desc, but the Position has no map\") unless $map;\n        $self->throw(\"Relative to a map's $throw_desc, but the Position's map isn't a Bio::Map::GeneMap\") unless $map->isa('Bio::Map::GeneMap');\n        my $gene = $map->gene;\n        \n        if ($type eq 'gene') {\n            my $gene_pos = $gene->position($map);\n            my $rel = $gene_pos->relative;\n            my $start = $rel->absolute_conversion($gene_pos);\n            $value += $start;\n        }\n        else {\n            my @values = ref($value) ? @{$value} : ($value);\n            my $trans = ref($value) ? $values[1] : $value;\n            my $throw_txt = $trans == 0 ? 'default/active transcript' : \"transcript $trans\";\n            my $throw_txt2 = ref($value) ? \", or no $type $values[0]\" : '';\n            my $method = $type eq 'coding' ? 'coding_position' : \"get_${type}_position\";\n            $value = $gene->$method($map, @values) || $self->throw(\"Relative to $throw_txt of the map's gene, but there is no such transcript$throw_txt2\");\n        }\n    }\n    else {\n        return $self->SUPER::absolute_conversion($pos);\n    }\n    if (ref($value)) {\n        # psuedo-recurse\n        my $rel = $value->relative;\n        $value = $rel->absolute_conversion($value);\n    }\n    \n    if (defined($value)) {\n        return $value + $raw;\n    }\n    return;\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $relative->type();\n Function: Get the type of thing we are relative to. The types correspond\n           to a method name, so the value of what we are relative to can\n           subsequently be found by $value = $relative->$type;\n\n           Note that type is set by the last method that was set, or during\n           new().\n\n Returns : 'gene', 'transcript', 'exon', 'intron' or 'coding'\n Args    : none\n\n\n=head2 gene\n\n Title   : gene\n Usage   : my $int = $relative->gene();\n           $relative->gene($int);\n Function: Get/set the distance from the start of the gene that the Position's\n           co-ordiantes are relative to.\n Returns : int\n Args    : none to get, OR\n           int to set; a value of 0 means relative to the start of the gene.\n\n\nsub gene {\n    my ($self, $num) = @_;\n    if (defined($num)) {\n        $self->throw(\"This is [$num], not a number\") unless looks_like_number($num);\n        $self->{_use} = 'gene';\n        $self->{_gene} = $num;\n    }\n    return defined($self->{_gene}) ? $self->{_gene} : return;\n}\n\n=head2 transcript\n\n Title   : transcript\n Usage   : my $int = $relative->transcript();\n           $relative->transcript($int);\n Function: Get/set which transcript of the Position's map's gene the Position's\n           co-ordinates are relative to.\n Returns : int\n Args    : none to get, OR\n           int to set; a value of 0 means the active (default) transcript.","parameters":[{"label":"$self"},{"label":"$num"}]},"containerName":"main::","name":"transcript","children":[{"line":268,"localvar":"my","kind":13,"containerName":"transcript","name":"$self","definition":"my"},{"line":268,"name":"$num","kind":13,"containerName":"transcript"},{"name":"$num","kind":13,"containerName":"transcript","line":269},{"name":"$self","containerName":"transcript","kind":13,"line":270},{"kind":12,"containerName":"transcript","name":"throw","line":270},{"line":270,"name":"$num","kind":13,"containerName":"transcript"},{"line":271,"name":"$self","kind":13,"containerName":"transcript"},{"containerName":"transcript","kind":13,"name":"$self","line":272},{"line":272,"name":"$num","containerName":"transcript","kind":13},{"line":274,"kind":13,"containerName":"transcript","name":"$self"},{"kind":13,"containerName":"transcript","name":"$self","line":274}],"detail":"($self,$num)","definition":"sub"},{"line":270,"name":"looks_like_number","kind":12},{"line":271,"name":"_use","kind":12},{"line":272,"name":"_transcript","kind":12},{"line":274,"name":"_transcript","kind":12},{"name":"_transcript","kind":12,"line":274},{"line":291,"range":{"start":{"line":291,"character":0},"end":{"character":9999,"line":303}},"kind":12,"signature":{"documentation":"1;\n# $Id: GeneRelative.pm,v 1.6 2006/09/20 11:53:29 sendu Exp $\n#\n# BioPerl module for Bio::Map::GeneRelative\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::GeneRelative - Represents being relative to named sub-regions of a\n                         gene.\n\n=head1 SYNOPSIS\n\n    use Bio::Map::GeneRelative;\n\n    # say that a somthing will have a position relative to the start of the\n    # gene on map\n    my $rel = Bio::Map::GeneRelative->new(-gene => 0);\n\n    # or that something will be relative to the third transcript of a gene\n    # on a map\n    $rel = Bio::Map::GeneRelative->new(-transcript => 3);\n\n    # or to the 5th intron of the default transcript\n    $rel = Bio::Map::GeneRelative->new(-intron => [0, 5]);\n\n    # use the $rel as normal; see L<Bio::Map::Relative>\n\n=head1 DESCRIPTION\n\nBe able to say that a given position is relative to some standard part of a\ngene.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::GeneRelative;\nuse strict;\n\nuse Scalar::Util qw(looks_like_number);\n\nuse base qw(Bio::Map::Relative);\n\n=head2 new\n\n Title   : new\n Usage   : my $relative = Bio::Map::Relative->new();\n Function: Build a new Bio::Map::Relative object.\n Returns : Bio::Map::Relative object\n Args    : -gene => int       : coordinates are relative to the int'th base\n                                downstream of the Position's map's gene\n                                [default is gene => 0, ie. relative to the\n                                start of the gene],\n           -transcript => int : or relative to the start of the int'th\n                                transcript of the Position's map's gene,\n           -exon => [i, n]    : or relative to the start of the n'th\n                                transcript's i'th exon,\n           -intron => [i, n]  : or intron,\n           -coding => int     : or the start of the int'th transcript's coding\n                                region.\n\n           -description => string : Free text description of what this relative\n                                    describes\n\n           (To say a Position is relative to something and upstream of it,\n            the Position's start() co-ordinate should be set negative)\n           In all cases, a transcript number of 0 means the active transcript.\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($gene, $transcript, $exon, $intron, $coding) =\n        $self->_rearrange([qw( GENE TRANSCRIPT EXON INTRON CODING )], @args);\n    \n    my $set = (defined $gene) + (defined $transcript) + (defined $exon) + (defined $intron) + (defined $coding);\n    if ($set > 1) {\n        $self->throw(\"-gene, -transcript, -exon, -intron and -coding are mutually exclusive\");\n    }\n    if ($exon && (! ref($exon) || ref($exon) ne 'ARRAY')) {\n        $self->throw(\"-exon takes an array ref\");\n    }\n    if ($intron && (! ref($intron) || ref($intron) ne 'ARRAY')) {\n        $self->throw(\"-intron takes an array ref\");\n    }\n    if ($set == 0) {\n        # type could have been set already in the call to SUPER::new\n        if ($self->type) {\n            $self->warn(\"You set a type of relative not supported by GeneRelative; resetting to type 'gene'\");\n        }\n        $gene = 0;\n    }\n    \n    $self->gene($gene) if defined $gene;\n    $self->transcript($transcript) if defined $transcript;\n    $self->exon(@{$exon}) if defined $exon;\n    $self->intron(@{$intron}) if defined $intron;\n    $self->coding($coding) if defined $coding;\n    \n    return $self;\n}\n\n=head2 absolute_conversion\n\n Title   : absolute_conversion\n Usage   : my $absolute_coord = $relative->absolute_conversion($pos);\n Function: Convert the start co-ordinate of the supplied position into a number\n           relative to the start of its map.\n Returns : scalar number\n Args    : Bio::Map::PositionI object\n\n\nsub absolute_conversion {\n    my ($self, $pos) = @_;\n    $self->throw(\"Must supply an object\") unless ref($pos);\n    $self->throw(\"This is [$pos], not a Bio::Map::PositionI\") unless $pos->isa('Bio::Map::PositionI');\n    \n    # get the raw start position of our position\n    my $raw = $pos->start($pos->relative);\n    $self->throw(\"Can't convert co-ordinates when start isn't set\") unless defined($raw); #*** needed? return undef?\n    \n    # what are we relative to?\n    my $type = $self->type;\n    my $value = $self->$type;\n    $self->throw(\"Details not yet set for this Relative, cannot convert\") unless defined($value);\n    \n    # get the absolute start of the thing we're relative to\n    if ($type =~ /gene|transcript|exon|intron|coding/) {\n        my $map = $pos->map;\n        my $throw_desc = $type eq 'gene' ? 'gene' : \"gene's transcript\";\n        $self->throw(\"Relative to a map's $throw_desc, but the Position has no map\") unless $map;\n        $self->throw(\"Relative to a map's $throw_desc, but the Position's map isn't a Bio::Map::GeneMap\") unless $map->isa('Bio::Map::GeneMap');\n        my $gene = $map->gene;\n        \n        if ($type eq 'gene') {\n            my $gene_pos = $gene->position($map);\n            my $rel = $gene_pos->relative;\n            my $start = $rel->absolute_conversion($gene_pos);\n            $value += $start;\n        }\n        else {\n            my @values = ref($value) ? @{$value} : ($value);\n            my $trans = ref($value) ? $values[1] : $value;\n            my $throw_txt = $trans == 0 ? 'default/active transcript' : \"transcript $trans\";\n            my $throw_txt2 = ref($value) ? \", or no $type $values[0]\" : '';\n            my $method = $type eq 'coding' ? 'coding_position' : \"get_${type}_position\";\n            $value = $gene->$method($map, @values) || $self->throw(\"Relative to $throw_txt of the map's gene, but there is no such transcript$throw_txt2\");\n        }\n    }\n    else {\n        return $self->SUPER::absolute_conversion($pos);\n    }\n    if (ref($value)) {\n        # psuedo-recurse\n        my $rel = $value->relative;\n        $value = $rel->absolute_conversion($value);\n    }\n    \n    if (defined($value)) {\n        return $value + $raw;\n    }\n    return;\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $relative->type();\n Function: Get the type of thing we are relative to. The types correspond\n           to a method name, so the value of what we are relative to can\n           subsequently be found by $value = $relative->$type;\n\n           Note that type is set by the last method that was set, or during\n           new().\n\n Returns : 'gene', 'transcript', 'exon', 'intron' or 'coding'\n Args    : none\n\n\n=head2 gene\n\n Title   : gene\n Usage   : my $int = $relative->gene();\n           $relative->gene($int);\n Function: Get/set the distance from the start of the gene that the Position's\n           co-ordiantes are relative to.\n Returns : int\n Args    : none to get, OR\n           int to set; a value of 0 means relative to the start of the gene.\n\n\nsub gene {\n    my ($self, $num) = @_;\n    if (defined($num)) {\n        $self->throw(\"This is [$num], not a number\") unless looks_like_number($num);\n        $self->{_use} = 'gene';\n        $self->{_gene} = $num;\n    }\n    return defined($self->{_gene}) ? $self->{_gene} : return;\n}\n\n=head2 transcript\n\n Title   : transcript\n Usage   : my $int = $relative->transcript();\n           $relative->transcript($int);\n Function: Get/set which transcript of the Position's map's gene the Position's\n           co-ordinates are relative to.\n Returns : int\n Args    : none to get, OR\n           int to set; a value of 0 means the active (default) transcript.\n\n\nsub transcript {\n    my ($self, $num) = @_;\n    if (defined($num)) {\n        $self->throw(\"This is [$num], not a number\") unless looks_like_number($num);\n        $self->{_use} = 'transcript';\n        $self->{_transcript} = $num;\n    }\n    return defined($self->{_transcript}) ? $self->{_transcript} : return;\n}\n\n=head2 exon\n\n Title   : exon\n Usage   : my ($exon_number, $transcript_number) = @{$relative->exon()};\n           $relative->exon($exon_number, $transcript_number);\n Function: Get/set which exon of which transcript of the Position's map's gene\n           the Position's co-ordinates are relative to.\n Returns : reference to list with two ints, exon number and transcript number\n Args    : none to get, OR\n           int (exon number) AND int (transcript number) to set. The second int\n           is optional and defaults to 0 (meaning default/active transcript).","parameters":[{"label":"$self"},{"label":"$num"},{"label":"$t_num"}],"label":"exon($self,$num,$t_num)"},"children":[{"localvar":"my","containerName":"exon","kind":13,"name":"$self","line":292,"definition":"my"},{"line":292,"name":"$num","containerName":"exon","kind":13},{"name":"$t_num","containerName":"exon","kind":13,"line":292},{"line":293,"name":"$num","kind":13,"containerName":"exon"},{"line":294,"name":"$t_num","containerName":"exon","kind":13},{"containerName":"exon","kind":13,"name":"$self","line":295},{"name":"throw","containerName":"exon","kind":12,"line":295},{"name":"$t_num","containerName":"exon","kind":13,"line":295},{"name":"$t_num","containerName":"exon","kind":13,"line":297},{"kind":13,"containerName":"exon","name":"$self","line":298},{"line":298,"name":"throw","containerName":"exon","kind":12},{"line":298,"kind":13,"containerName":"exon","name":"$num"},{"line":299,"name":"$self","containerName":"exon","kind":13},{"line":300,"containerName":"exon","kind":13,"name":"$self"},{"line":300,"name":"$num","containerName":"exon","kind":13},{"name":"$t_num","kind":13,"containerName":"exon","line":300},{"line":302,"containerName":"exon","kind":13,"name":"$self"}],"name":"exon","containerName":"main::","definition":"sub","detail":"($self,$num,$t_num)"},{"name":"looks_like_number","kind":12,"line":295},{"name":"looks_like_number","kind":12,"line":298},{"name":"_use","kind":12,"line":299},{"line":300,"name":"_exon","kind":12},{"line":302,"kind":12,"name":"_exon"},{"range":{"start":{"line":320,"character":0},"end":{"character":9999,"line":332}},"kind":12,"line":320,"signature":{"documentation":"1;\n# $Id: GeneRelative.pm,v 1.6 2006/09/20 11:53:29 sendu Exp $\n#\n# BioPerl module for Bio::Map::GeneRelative\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::GeneRelative - Represents being relative to named sub-regions of a\n                         gene.\n\n=head1 SYNOPSIS\n\n    use Bio::Map::GeneRelative;\n\n    # say that a somthing will have a position relative to the start of the\n    # gene on map\n    my $rel = Bio::Map::GeneRelative->new(-gene => 0);\n\n    # or that something will be relative to the third transcript of a gene\n    # on a map\n    $rel = Bio::Map::GeneRelative->new(-transcript => 3);\n\n    # or to the 5th intron of the default transcript\n    $rel = Bio::Map::GeneRelative->new(-intron => [0, 5]);\n\n    # use the $rel as normal; see L<Bio::Map::Relative>\n\n=head1 DESCRIPTION\n\nBe able to say that a given position is relative to some standard part of a\ngene.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::GeneRelative;\nuse strict;\n\nuse Scalar::Util qw(looks_like_number);\n\nuse base qw(Bio::Map::Relative);\n\n=head2 new\n\n Title   : new\n Usage   : my $relative = Bio::Map::Relative->new();\n Function: Build a new Bio::Map::Relative object.\n Returns : Bio::Map::Relative object\n Args    : -gene => int       : coordinates are relative to the int'th base\n                                downstream of the Position's map's gene\n                                [default is gene => 0, ie. relative to the\n                                start of the gene],\n           -transcript => int : or relative to the start of the int'th\n                                transcript of the Position's map's gene,\n           -exon => [i, n]    : or relative to the start of the n'th\n                                transcript's i'th exon,\n           -intron => [i, n]  : or intron,\n           -coding => int     : or the start of the int'th transcript's coding\n                                region.\n\n           -description => string : Free text description of what this relative\n                                    describes\n\n           (To say a Position is relative to something and upstream of it,\n            the Position's start() co-ordinate should be set negative)\n           In all cases, a transcript number of 0 means the active transcript.\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($gene, $transcript, $exon, $intron, $coding) =\n        $self->_rearrange([qw( GENE TRANSCRIPT EXON INTRON CODING )], @args);\n    \n    my $set = (defined $gene) + (defined $transcript) + (defined $exon) + (defined $intron) + (defined $coding);\n    if ($set > 1) {\n        $self->throw(\"-gene, -transcript, -exon, -intron and -coding are mutually exclusive\");\n    }\n    if ($exon && (! ref($exon) || ref($exon) ne 'ARRAY')) {\n        $self->throw(\"-exon takes an array ref\");\n    }\n    if ($intron && (! ref($intron) || ref($intron) ne 'ARRAY')) {\n        $self->throw(\"-intron takes an array ref\");\n    }\n    if ($set == 0) {\n        # type could have been set already in the call to SUPER::new\n        if ($self->type) {\n            $self->warn(\"You set a type of relative not supported by GeneRelative; resetting to type 'gene'\");\n        }\n        $gene = 0;\n    }\n    \n    $self->gene($gene) if defined $gene;\n    $self->transcript($transcript) if defined $transcript;\n    $self->exon(@{$exon}) if defined $exon;\n    $self->intron(@{$intron}) if defined $intron;\n    $self->coding($coding) if defined $coding;\n    \n    return $self;\n}\n\n=head2 absolute_conversion\n\n Title   : absolute_conversion\n Usage   : my $absolute_coord = $relative->absolute_conversion($pos);\n Function: Convert the start co-ordinate of the supplied position into a number\n           relative to the start of its map.\n Returns : scalar number\n Args    : Bio::Map::PositionI object\n\n\nsub absolute_conversion {\n    my ($self, $pos) = @_;\n    $self->throw(\"Must supply an object\") unless ref($pos);\n    $self->throw(\"This is [$pos], not a Bio::Map::PositionI\") unless $pos->isa('Bio::Map::PositionI');\n    \n    # get the raw start position of our position\n    my $raw = $pos->start($pos->relative);\n    $self->throw(\"Can't convert co-ordinates when start isn't set\") unless defined($raw); #*** needed? return undef?\n    \n    # what are we relative to?\n    my $type = $self->type;\n    my $value = $self->$type;\n    $self->throw(\"Details not yet set for this Relative, cannot convert\") unless defined($value);\n    \n    # get the absolute start of the thing we're relative to\n    if ($type =~ /gene|transcript|exon|intron|coding/) {\n        my $map = $pos->map;\n        my $throw_desc = $type eq 'gene' ? 'gene' : \"gene's transcript\";\n        $self->throw(\"Relative to a map's $throw_desc, but the Position has no map\") unless $map;\n        $self->throw(\"Relative to a map's $throw_desc, but the Position's map isn't a Bio::Map::GeneMap\") unless $map->isa('Bio::Map::GeneMap');\n        my $gene = $map->gene;\n        \n        if ($type eq 'gene') {\n            my $gene_pos = $gene->position($map);\n            my $rel = $gene_pos->relative;\n            my $start = $rel->absolute_conversion($gene_pos);\n            $value += $start;\n        }\n        else {\n            my @values = ref($value) ? @{$value} : ($value);\n            my $trans = ref($value) ? $values[1] : $value;\n            my $throw_txt = $trans == 0 ? 'default/active transcript' : \"transcript $trans\";\n            my $throw_txt2 = ref($value) ? \", or no $type $values[0]\" : '';\n            my $method = $type eq 'coding' ? 'coding_position' : \"get_${type}_position\";\n            $value = $gene->$method($map, @values) || $self->throw(\"Relative to $throw_txt of the map's gene, but there is no such transcript$throw_txt2\");\n        }\n    }\n    else {\n        return $self->SUPER::absolute_conversion($pos);\n    }\n    if (ref($value)) {\n        # psuedo-recurse\n        my $rel = $value->relative;\n        $value = $rel->absolute_conversion($value);\n    }\n    \n    if (defined($value)) {\n        return $value + $raw;\n    }\n    return;\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $relative->type();\n Function: Get the type of thing we are relative to. The types correspond\n           to a method name, so the value of what we are relative to can\n           subsequently be found by $value = $relative->$type;\n\n           Note that type is set by the last method that was set, or during\n           new().\n\n Returns : 'gene', 'transcript', 'exon', 'intron' or 'coding'\n Args    : none\n\n\n=head2 gene\n\n Title   : gene\n Usage   : my $int = $relative->gene();\n           $relative->gene($int);\n Function: Get/set the distance from the start of the gene that the Position's\n           co-ordiantes are relative to.\n Returns : int\n Args    : none to get, OR\n           int to set; a value of 0 means relative to the start of the gene.\n\n\nsub gene {\n    my ($self, $num) = @_;\n    if (defined($num)) {\n        $self->throw(\"This is [$num], not a number\") unless looks_like_number($num);\n        $self->{_use} = 'gene';\n        $self->{_gene} = $num;\n    }\n    return defined($self->{_gene}) ? $self->{_gene} : return;\n}\n\n=head2 transcript\n\n Title   : transcript\n Usage   : my $int = $relative->transcript();\n           $relative->transcript($int);\n Function: Get/set which transcript of the Position's map's gene the Position's\n           co-ordinates are relative to.\n Returns : int\n Args    : none to get, OR\n           int to set; a value of 0 means the active (default) transcript.\n\n\nsub transcript {\n    my ($self, $num) = @_;\n    if (defined($num)) {\n        $self->throw(\"This is [$num], not a number\") unless looks_like_number($num);\n        $self->{_use} = 'transcript';\n        $self->{_transcript} = $num;\n    }\n    return defined($self->{_transcript}) ? $self->{_transcript} : return;\n}\n\n=head2 exon\n\n Title   : exon\n Usage   : my ($exon_number, $transcript_number) = @{$relative->exon()};\n           $relative->exon($exon_number, $transcript_number);\n Function: Get/set which exon of which transcript of the Position's map's gene\n           the Position's co-ordinates are relative to.\n Returns : reference to list with two ints, exon number and transcript number\n Args    : none to get, OR\n           int (exon number) AND int (transcript number) to set. The second int\n           is optional and defaults to 0 (meaning default/active transcript).\n\n\nsub exon {\n    my ($self, $num, $t_num) = @_;\n    if (defined($num)) {\n        if (defined($t_num)) {\n            $self->throw(\"This is [$t_num], not a number\") unless looks_like_number($t_num);\n        }\n        $t_num ||= 0;\n        $self->throw(\"This is [$num], not a number\") unless looks_like_number($num);\n        $self->{_use} = 'exon';\n        $self->{_exon} = [$num, $t_num];\n    }\n    return $self->{_exon} || return;\n}\n\n=head2 intron\n\n Title   : intron\n Usage   : my ($intron_number, $transcript_number) = @{$relative->intron()};\n           $relative->intron($intron_number, $transcript_number);\n Function: Get/set which intron of which transcript of the Position's map's gene\n           the Position's co-ordinates are relative to.\n Returns : reference to list with two ints, intron number and transcript number\n Args    : none to get, OR\n           int (intron number) AND int (transcript number) to set. The second\n           int is optional and defaults to 0 (meaning default/active\n           transcript).","parameters":[{"label":"$self"},{"label":"$num"},{"label":"$t_num"}],"label":"intron($self,$num,$t_num)"},"containerName":"main::","name":"intron","children":[{"line":321,"containerName":"intron","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":321,"containerName":"intron","kind":13,"name":"$num"},{"line":321,"name":"$t_num","kind":13,"containerName":"intron"},{"line":322,"name":"$num","kind":13,"containerName":"intron"},{"name":"$t_num","kind":13,"containerName":"intron","line":323},{"line":324,"kind":13,"containerName":"intron","name":"$self"},{"line":324,"kind":12,"containerName":"intron","name":"throw"},{"name":"$t_num","kind":13,"containerName":"intron","line":324},{"name":"$t_num","containerName":"intron","kind":13,"line":326},{"kind":13,"containerName":"intron","name":"$self","line":327},{"line":327,"name":"throw","containerName":"intron","kind":12},{"name":"$num","kind":13,"containerName":"intron","line":327},{"containerName":"intron","kind":13,"name":"$self","line":328},{"line":329,"containerName":"intron","kind":13,"name":"$self"},{"containerName":"intron","kind":13,"name":"$num","line":329},{"kind":13,"containerName":"intron","name":"$t_num","line":329},{"kind":13,"containerName":"intron","name":"$self","line":331}],"detail":"($self,$num,$t_num)","definition":"sub"},{"name":"looks_like_number","kind":12,"line":324},{"name":"looks_like_number","kind":12,"line":327},{"kind":12,"name":"_use","line":328},{"line":329,"kind":12,"name":"_intron"},{"name":"_intron","kind":12,"line":331},{"signature":{"label":"coding($self,$num)","parameters":[{"label":"$self"},{"label":"$num"}],"documentation":"1;\n# $Id: GeneRelative.pm,v 1.6 2006/09/20 11:53:29 sendu Exp $\n#\n# BioPerl module for Bio::Map::GeneRelative\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::GeneRelative - Represents being relative to named sub-regions of a\n                         gene.\n\n=head1 SYNOPSIS\n\n    use Bio::Map::GeneRelative;\n\n    # say that a somthing will have a position relative to the start of the\n    # gene on map\n    my $rel = Bio::Map::GeneRelative->new(-gene => 0);\n\n    # or that something will be relative to the third transcript of a gene\n    # on a map\n    $rel = Bio::Map::GeneRelative->new(-transcript => 3);\n\n    # or to the 5th intron of the default transcript\n    $rel = Bio::Map::GeneRelative->new(-intron => [0, 5]);\n\n    # use the $rel as normal; see L<Bio::Map::Relative>\n\n=head1 DESCRIPTION\n\nBe able to say that a given position is relative to some standard part of a\ngene.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::GeneRelative;\nuse strict;\n\nuse Scalar::Util qw(looks_like_number);\n\nuse base qw(Bio::Map::Relative);\n\n=head2 new\n\n Title   : new\n Usage   : my $relative = Bio::Map::Relative->new();\n Function: Build a new Bio::Map::Relative object.\n Returns : Bio::Map::Relative object\n Args    : -gene => int       : coordinates are relative to the int'th base\n                                downstream of the Position's map's gene\n                                [default is gene => 0, ie. relative to the\n                                start of the gene],\n           -transcript => int : or relative to the start of the int'th\n                                transcript of the Position's map's gene,\n           -exon => [i, n]    : or relative to the start of the n'th\n                                transcript's i'th exon,\n           -intron => [i, n]  : or intron,\n           -coding => int     : or the start of the int'th transcript's coding\n                                region.\n\n           -description => string : Free text description of what this relative\n                                    describes\n\n           (To say a Position is relative to something and upstream of it,\n            the Position's start() co-ordinate should be set negative)\n           In all cases, a transcript number of 0 means the active transcript.\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($gene, $transcript, $exon, $intron, $coding) =\n        $self->_rearrange([qw( GENE TRANSCRIPT EXON INTRON CODING )], @args);\n    \n    my $set = (defined $gene) + (defined $transcript) + (defined $exon) + (defined $intron) + (defined $coding);\n    if ($set > 1) {\n        $self->throw(\"-gene, -transcript, -exon, -intron and -coding are mutually exclusive\");\n    }\n    if ($exon && (! ref($exon) || ref($exon) ne 'ARRAY')) {\n        $self->throw(\"-exon takes an array ref\");\n    }\n    if ($intron && (! ref($intron) || ref($intron) ne 'ARRAY')) {\n        $self->throw(\"-intron takes an array ref\");\n    }\n    if ($set == 0) {\n        # type could have been set already in the call to SUPER::new\n        if ($self->type) {\n            $self->warn(\"You set a type of relative not supported by GeneRelative; resetting to type 'gene'\");\n        }\n        $gene = 0;\n    }\n    \n    $self->gene($gene) if defined $gene;\n    $self->transcript($transcript) if defined $transcript;\n    $self->exon(@{$exon}) if defined $exon;\n    $self->intron(@{$intron}) if defined $intron;\n    $self->coding($coding) if defined $coding;\n    \n    return $self;\n}\n\n=head2 absolute_conversion\n\n Title   : absolute_conversion\n Usage   : my $absolute_coord = $relative->absolute_conversion($pos);\n Function: Convert the start co-ordinate of the supplied position into a number\n           relative to the start of its map.\n Returns : scalar number\n Args    : Bio::Map::PositionI object\n\n\nsub absolute_conversion {\n    my ($self, $pos) = @_;\n    $self->throw(\"Must supply an object\") unless ref($pos);\n    $self->throw(\"This is [$pos], not a Bio::Map::PositionI\") unless $pos->isa('Bio::Map::PositionI');\n    \n    # get the raw start position of our position\n    my $raw = $pos->start($pos->relative);\n    $self->throw(\"Can't convert co-ordinates when start isn't set\") unless defined($raw); #*** needed? return undef?\n    \n    # what are we relative to?\n    my $type = $self->type;\n    my $value = $self->$type;\n    $self->throw(\"Details not yet set for this Relative, cannot convert\") unless defined($value);\n    \n    # get the absolute start of the thing we're relative to\n    if ($type =~ /gene|transcript|exon|intron|coding/) {\n        my $map = $pos->map;\n        my $throw_desc = $type eq 'gene' ? 'gene' : \"gene's transcript\";\n        $self->throw(\"Relative to a map's $throw_desc, but the Position has no map\") unless $map;\n        $self->throw(\"Relative to a map's $throw_desc, but the Position's map isn't a Bio::Map::GeneMap\") unless $map->isa('Bio::Map::GeneMap');\n        my $gene = $map->gene;\n        \n        if ($type eq 'gene') {\n            my $gene_pos = $gene->position($map);\n            my $rel = $gene_pos->relative;\n            my $start = $rel->absolute_conversion($gene_pos);\n            $value += $start;\n        }\n        else {\n            my @values = ref($value) ? @{$value} : ($value);\n            my $trans = ref($value) ? $values[1] : $value;\n            my $throw_txt = $trans == 0 ? 'default/active transcript' : \"transcript $trans\";\n            my $throw_txt2 = ref($value) ? \", or no $type $values[0]\" : '';\n            my $method = $type eq 'coding' ? 'coding_position' : \"get_${type}_position\";\n            $value = $gene->$method($map, @values) || $self->throw(\"Relative to $throw_txt of the map's gene, but there is no such transcript$throw_txt2\");\n        }\n    }\n    else {\n        return $self->SUPER::absolute_conversion($pos);\n    }\n    if (ref($value)) {\n        # psuedo-recurse\n        my $rel = $value->relative;\n        $value = $rel->absolute_conversion($value);\n    }\n    \n    if (defined($value)) {\n        return $value + $raw;\n    }\n    return;\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $relative->type();\n Function: Get the type of thing we are relative to. The types correspond\n           to a method name, so the value of what we are relative to can\n           subsequently be found by $value = $relative->$type;\n\n           Note that type is set by the last method that was set, or during\n           new().\n\n Returns : 'gene', 'transcript', 'exon', 'intron' or 'coding'\n Args    : none\n\n\n=head2 gene\n\n Title   : gene\n Usage   : my $int = $relative->gene();\n           $relative->gene($int);\n Function: Get/set the distance from the start of the gene that the Position's\n           co-ordiantes are relative to.\n Returns : int\n Args    : none to get, OR\n           int to set; a value of 0 means relative to the start of the gene.\n\n\nsub gene {\n    my ($self, $num) = @_;\n    if (defined($num)) {\n        $self->throw(\"This is [$num], not a number\") unless looks_like_number($num);\n        $self->{_use} = 'gene';\n        $self->{_gene} = $num;\n    }\n    return defined($self->{_gene}) ? $self->{_gene} : return;\n}\n\n=head2 transcript\n\n Title   : transcript\n Usage   : my $int = $relative->transcript();\n           $relative->transcript($int);\n Function: Get/set which transcript of the Position's map's gene the Position's\n           co-ordinates are relative to.\n Returns : int\n Args    : none to get, OR\n           int to set; a value of 0 means the active (default) transcript.\n\n\nsub transcript {\n    my ($self, $num) = @_;\n    if (defined($num)) {\n        $self->throw(\"This is [$num], not a number\") unless looks_like_number($num);\n        $self->{_use} = 'transcript';\n        $self->{_transcript} = $num;\n    }\n    return defined($self->{_transcript}) ? $self->{_transcript} : return;\n}\n\n=head2 exon\n\n Title   : exon\n Usage   : my ($exon_number, $transcript_number) = @{$relative->exon()};\n           $relative->exon($exon_number, $transcript_number);\n Function: Get/set which exon of which transcript of the Position's map's gene\n           the Position's co-ordinates are relative to.\n Returns : reference to list with two ints, exon number and transcript number\n Args    : none to get, OR\n           int (exon number) AND int (transcript number) to set. The second int\n           is optional and defaults to 0 (meaning default/active transcript).\n\n\nsub exon {\n    my ($self, $num, $t_num) = @_;\n    if (defined($num)) {\n        if (defined($t_num)) {\n            $self->throw(\"This is [$t_num], not a number\") unless looks_like_number($t_num);\n        }\n        $t_num ||= 0;\n        $self->throw(\"This is [$num], not a number\") unless looks_like_number($num);\n        $self->{_use} = 'exon';\n        $self->{_exon} = [$num, $t_num];\n    }\n    return $self->{_exon} || return;\n}\n\n=head2 intron\n\n Title   : intron\n Usage   : my ($intron_number, $transcript_number) = @{$relative->intron()};\n           $relative->intron($intron_number, $transcript_number);\n Function: Get/set which intron of which transcript of the Position's map's gene\n           the Position's co-ordinates are relative to.\n Returns : reference to list with two ints, intron number and transcript number\n Args    : none to get, OR\n           int (intron number) AND int (transcript number) to set. The second\n           int is optional and defaults to 0 (meaning default/active\n           transcript).\n\n\nsub intron {\n    my ($self, $num, $t_num) = @_;\n    if (defined($num)) {\n        if (defined($t_num)) {\n            $self->throw(\"This is [$t_num], not a number\") unless looks_like_number($t_num);\n        }\n        $t_num ||= 0;\n        $self->throw(\"This is [$num], not a number\") unless looks_like_number($num);\n        $self->{_use} = 'intron';\n        $self->{_intron} = [$num, $t_num];\n    }\n    return $self->{_intron} || return;\n}\n\n=head2 coding\n\n Title   : coding\n Usage   : my $transcript_number = $relative->coding;\n           $relative->coding($transcript_number);\n Function: Get/set which transcript's coding region of the Position's map's gene\n           the Position's co-ordinates are relative to.\n Returns : int\n Args    : none to get, OR\n           int to set (the transcript number, see transcript())"},"line":347,"range":{"end":{"line":355,"character":9999},"start":{"line":347,"character":0}},"kind":12,"definition":"sub","detail":"($self,$num)","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"coding","name":"$self","line":348},{"line":348,"containerName":"coding","kind":13,"name":"$num"},{"name":"$num","kind":13,"containerName":"coding","line":349},{"name":"$self","containerName":"coding","kind":13,"line":350},{"line":350,"containerName":"coding","kind":12,"name":"throw"},{"name":"$num","kind":13,"containerName":"coding","line":350},{"name":"$self","kind":13,"containerName":"coding","line":351},{"containerName":"coding","kind":13,"name":"$self","line":352},{"name":"$num","containerName":"coding","kind":13,"line":352},{"name":"$self","containerName":"coding","kind":13,"line":354},{"name":"$self","kind":13,"containerName":"coding","line":354}],"name":"coding","containerName":"main::"},{"line":350,"kind":12,"name":"looks_like_number"},{"line":351,"name":"_use","kind":12},{"line":352,"name":"_coding","kind":12},{"line":354,"name":"_coding","kind":12},{"line":354,"kind":12,"name":"_coding"}]}