{"vars":[{"containerName":"","kind":2,"name":"base","line":46},{"children":[{"definition":"my","kind":13,"localvar":"my","containerName":"new","name":"$thing","line":61},{"containerName":"new","kind":13,"name":"%args","line":61},{"definition":"my","line":62,"name":"$class","localvar":"my","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$thing","line":62},{"containerName":"new","kind":13,"name":"$thing","line":62},{"definition":"my","name":"$obj","containerName":"new","localvar":"my","kind":13,"line":63},{"name":"%transcript","kind":13,"containerName":"new","line":63},{"localvar":"my","containerName":"new","kind":13,"name":"@exons","line":65,"definition":"my"},{"name":"$args","containerName":"new","kind":13,"line":65}],"containerName":"main::","name":"new","definition":"sub","detail":"($thing,%args)","line":60,"range":{"end":{"line":65,"character":9999},"start":{"line":60,"character":0}},"kind":12,"signature":{"parameters":[{"label":"$thing"},{"label":"%args"}],"documentation":"1;\n# $Id: Transcript.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Transcript\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Transcript - Transcript class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis stores informations about coding sequences (CDS).\nThe implementation is that a Transcript object accesses a collection of\nExon objects, inferring from them the nucleotide structure and sequence.\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Transcript;\n\nuse strict;\n# use Carp qw(carp cluck);\nuse Bio::LiveSeq::Exon; # uses Exon to create new exon in case of deletion\nuse base qw(Bio::LiveSeq::SeqI);\n\n=head2 new\n\n  Title   : new\n  Usage   : $transcript = Bio::LiveSeq::Transcript->new(-exons => \\@obj_refs);\n\n  Function: generates a new Bio::LiveSeq::Transcript\n  Returns : reference to a new object of class Transcript\n  Errorcode -1\n  Args    : reference to an array of Exon object references","label":"new($thing,%args)"}},{"line":67,"name":"$obj","containerName":null,"kind":13},{"line":67,"containerName":null,"kind":13,"name":"%transcript"},{"name":"$obj","containerName":null,"kind":13,"line":68},{"line":68,"kind":13,"containerName":null,"name":"$obj"},{"line":68,"name":"$class","kind":13,"containerName":null},{"line":70,"name":"@exons","containerName":null,"kind":13},{"line":71,"kind":13,"containerName":null,"name":"$obj"},{"line":71,"containerName":"main::","kind":12,"name":"warn"},{"line":76,"kind":13,"localvar":"my","containerName":null,"name":"$firstexon","definition":"my"},{"name":"@exons","containerName":null,"kind":13,"line":76},{"line":80,"kind":13,"localvar":"my","containerName":null,"name":"$strand","definition":"my"},{"name":"$firstexon","kind":13,"containerName":null,"line":80},{"containerName":"main::","kind":12,"name":"strand","line":80},{"definition":"my","line":81,"name":"$seq","localvar":"my","kind":13,"containerName":null},{"line":81,"name":"%firstexon","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$obj","line":82},{"line":82,"containerName":"main::","kind":12,"name":"alphabet"},{"line":84,"name":"_checkexons","kind":12},{"kind":13,"containerName":null,"name":"@exons","line":84},{"kind":13,"containerName":null,"name":"$obj","line":85},{"line":85,"name":"warn","kind":12,"containerName":"main::"},{"name":"%obj","kind":13,"containerName":null,"line":88},{"name":"$strand","kind":13,"containerName":null,"line":88},{"name":"%obj","kind":13,"containerName":null,"line":89},{"line":89,"containerName":null,"kind":13,"name":"@exons"},{"line":90,"name":"%obj","containerName":null,"kind":13},{"line":90,"kind":13,"containerName":null,"name":"$seq"},{"definition":"my","line":93,"localvar":"my","containerName":null,"kind":13,"name":"$exon"},{"containerName":null,"kind":13,"name":"$exon","line":94},{"name":"@exons","containerName":null,"kind":13,"line":94},{"name":"%exon","containerName":null,"kind":13,"line":95},{"line":95,"name":"$obj","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$obj","line":97},{"kind":12,"range":{"end":{"line":115,"character":9999},"start":{"line":112,"character":0}},"line":112,"name":"all_Exons","containerName":"main::","children":[{"name":"$self","containerName":"all_Exons","localvar":"my","kind":13,"line":113,"definition":"my"},{"definition":"my","name":"$exonsref","containerName":"all_Exons","localvar":"my","kind":13,"line":114},{"line":114,"name":"$self","kind":13,"containerName":"all_Exons"},{"name":"@exons","kind":13,"localvar":"my","containerName":"all_Exons","line":115,"definition":"my"},{"containerName":"all_Exons","kind":13,"name":"$exonsref","line":115}],"definition":"sub"},{"containerName":null,"localvar":"my","kind":13,"name":"@newexons","line":116,"definition":"my"},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"$exon","line":117},{"name":"$exon","containerName":null,"kind":13,"line":118},{"line":118,"kind":13,"containerName":null,"name":"@exons"},{"line":119,"name":"$exon","containerName":null,"kind":13},{"kind":12,"containerName":"main::","name":"obj_valid","line":119},{"name":"$self","containerName":null,"kind":13,"line":120},{"name":"warn","containerName":"main::","kind":12,"line":120},{"line":122,"kind":13,"containerName":null,"name":"@newexons"},{"line":122,"kind":13,"containerName":null,"name":"$exon"},{"line":125,"name":"exons","kind":12},{"line":125,"kind":12,"name":"newexons"},{"line":127,"name":"%self","containerName":null,"kind":13},{"line":127,"name":"@newexons","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"@newexons","line":129},{"detail":"($self,$howmany)","definition":"sub","name":"downstream_seq","containerName":"main::","children":[{"definition":"my","line":151,"containerName":"downstream_seq","localvar":"my","kind":13,"name":"$self"},{"line":151,"kind":13,"containerName":"downstream_seq","name":"$howmany"},{"line":152,"localvar":"my","kind":13,"containerName":"downstream_seq","name":"$str","definition":"my"},{"line":153,"kind":13,"containerName":"downstream_seq","name":"$howmany"},{"line":154,"kind":13,"containerName":"downstream_seq","name":"$howmany"},{"kind":13,"containerName":"downstream_seq","name":"$self","line":155},{"name":"throw","kind":12,"containerName":"downstream_seq","line":155},{"line":158,"name":"$self","containerName":"downstream_seq","kind":13},{"name":"alphabet","kind":12,"containerName":"downstream_seq","line":158},{"name":"$self","containerName":"downstream_seq","kind":13,"line":161},{"name":"gene","kind":12,"containerName":"downstream_seq","line":161},{"line":162,"name":"$str","containerName":"downstream_seq","kind":13},{"name":"$self","kind":13,"containerName":"downstream_seq","line":162},{"name":"labelsubseq","kind":12,"containerName":"downstream_seq","line":162},{"name":"$self","kind":13,"containerName":"downstream_seq","line":162},{"name":"end","containerName":"downstream_seq","kind":12,"line":162},{"name":"$self","kind":13,"containerName":"downstream_seq","line":162},{"name":"gene","containerName":"downstream_seq","kind":12,"line":162},{"line":162,"name":"maxtranscript","kind":12,"containerName":"downstream_seq"},{"kind":12,"containerName":"downstream_seq","name":"end","line":162},{"name":"$str","containerName":"downstream_seq","kind":13,"line":163},{"line":163,"name":"$str","kind":13,"containerName":"downstream_seq"},{"containerName":"downstream_seq","kind":13,"name":"$str","line":164},{"line":165,"containerName":"downstream_seq","kind":13,"name":"$str"},{"line":167,"kind":13,"containerName":"downstream_seq","name":"$howmany"},{"line":170,"name":"$howmany","kind":13,"containerName":"downstream_seq"},{"definition":"my","localvar":"my","kind":13,"containerName":"downstream_seq","name":"@exons","line":174},{"line":174,"containerName":"downstream_seq","kind":13,"name":"$self"},{"line":174,"containerName":"downstream_seq","kind":12,"name":"all_Exons"},{"line":175,"containerName":"downstream_seq","localvar":"my","kind":13,"name":"$strand","definition":"my"},{"line":175,"name":"$self","containerName":"downstream_seq","kind":13},{"kind":12,"containerName":"downstream_seq","name":"strand","line":175},{"definition":"my","line":176,"containerName":"downstream_seq","localvar":"my","kind":13,"name":"$lastexon"},{"line":176,"containerName":"downstream_seq","kind":13,"name":"$exons"},{"definition":"my","name":"$lastexonlength","containerName":"downstream_seq","localvar":"my","kind":13,"line":177},{"name":"$lastexon","kind":13,"containerName":"downstream_seq","line":177},{"line":177,"name":"length","containerName":"downstream_seq","kind":12},{"definition":"my","line":180,"name":"$downstream_seq","containerName":"downstream_seq","localvar":"my","kind":13},{"line":182,"name":"$howmany","kind":13,"containerName":"downstream_seq"},{"line":183,"containerName":"downstream_seq","kind":13,"name":"$downstream_seq"},{"line":183,"name":"$lastexon","containerName":"downstream_seq","kind":13},{"line":183,"name":"labelsubseq","kind":12,"containerName":"downstream_seq"},{"kind":13,"containerName":"downstream_seq","name":"$self","line":183},{"line":183,"name":"end","kind":12,"containerName":"downstream_seq"},{"line":183,"name":"$howmany","kind":13,"containerName":"downstream_seq"},{"containerName":"downstream_seq","kind":13,"name":"$strand","line":185},{"line":186,"name":"$downstream_seq","kind":13,"containerName":"downstream_seq"},{"name":"$lastexon","kind":13,"containerName":"downstream_seq","line":186},{"line":186,"containerName":"downstream_seq","kind":12,"name":"labelsubseq"},{"line":186,"containerName":"downstream_seq","kind":13,"name":"$self"},{"line":186,"name":"end","containerName":"downstream_seq","kind":12},{"name":"$self","containerName":"downstream_seq","kind":13,"line":186},{"name":"end","kind":12,"containerName":"downstream_seq","line":186},{"line":188,"name":"$downstream_seq","containerName":"downstream_seq","kind":13},{"containerName":"downstream_seq","kind":13,"name":"$lastexon","line":188},{"containerName":"downstream_seq","kind":12,"name":"labelsubseq","line":188},{"name":"$self","containerName":"downstream_seq","kind":13,"line":188},{"line":188,"name":"end","containerName":"downstream_seq","kind":12},{"name":"$self","kind":13,"containerName":"downstream_seq","line":188},{"line":188,"name":"start","kind":12,"containerName":"downstream_seq"},{"name":"$downstream_seq","containerName":"downstream_seq","kind":13,"line":191}],"signature":{"documentation":"1;\n# $Id: Transcript.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Transcript\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Transcript - Transcript class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis stores informations about coding sequences (CDS).\nThe implementation is that a Transcript object accesses a collection of\nExon objects, inferring from them the nucleotide structure and sequence.\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Transcript;\n\nuse strict;\n# use Carp qw(carp cluck);\nuse Bio::LiveSeq::Exon; # uses Exon to create new exon in case of deletion\nuse base qw(Bio::LiveSeq::SeqI);\n\n=head2 new\n\n  Title   : new\n  Usage   : $transcript = Bio::LiveSeq::Transcript->new(-exons => \\@obj_refs);\n\n  Function: generates a new Bio::LiveSeq::Transcript\n  Returns : reference to a new object of class Transcript\n  Errorcode -1\n  Args    : reference to an array of Exon object references\n\n\nsub new {\n  my ($thing, %args) = @_;\n  my $class = ref($thing) || $thing;\n  my ($obj,%transcript);\n\n  my @exons=@{$args{-exons}};\n\n  $obj = \\%transcript;\n  $obj = bless $obj, $class;\n\n  unless (@exons) {\n    $obj->warn(\"$class not initialised because exons array empty\");\n    return(-1);\n  }\n\n  # now useless, after start and end methods have been overridden here\n  my $firstexon = $exons[0];\n  #my $lastexon = $exons[-1];\n  #my $start = $firstexon->start;\n  #my $end = $lastexon->end;\n  my $strand = $firstexon->strand;\n  my $seq = $firstexon->{'seq'};\n  $obj->alphabet('rna');\n\n  unless (_checkexons(\\@exons)) {\n    $obj->warn(\"$class not initialised because of problems in the exon structure\");\n    return(-1);\n  }\n  $obj->{'strand'}=$strand;\n  $obj->{'exons'}=\\@exons;\n  $obj->{'seq'}=$seq;\n\n  # set Transcript into each Exon\n  my $exon;\n  foreach $exon (@exons) {\n    $exon->{'transcript'}=$obj;\n  }\n  return $obj;\n}\n\n\n=head2 all_Exons\n\n Title   : all_Exons\n Usage   : $transcript_obj->all_Exons()\n Function: returns references to all Exon objects the Transcript is composed of\n Example : foreach $exon ($transcript->all_Exons()) { do_something }\n Returns : array of object references\n Args    : none\n\n\nsub all_Exons {\n  my $self=shift;\n  my $exonsref=$self->{'exons'};\n  my @exons=@{$exonsref};\n  my @newexons;\n  my $exon;\n  foreach $exon (@exons) {\n    unless ($exon->obj_valid) {\n      $self->warn(\"$exon no more valid, start or end label lost, skipping....\",1); # ignorable\n    } else {\n      push(@newexons,$exon);\n    }\n  }\n  if ($#exons != $#newexons) {\n    # update exons field\n    $self->{'exons'}=\\@newexons;\n  }\n  return (@newexons);\n}\n\n=head2 downstream_seq\n\n Title   : downstream_seq\n Usage   : $transcript_obj->downstream_seq()\n         : $transcript_obj->downstream_seq(64)\n Function: returns a string of nucleotides downstream of the end of the\n           CDS. If there is some information of the real mRNA, from features in\n           an attached Gene object, it will return up to those boundaries.\n           Otherwise it will return 1000 nucleotides.\n           If an argument is given it will override the default 1000 number\n           and return instead /that/ requested number of nucleotides.\n           But if a Gene object is attached, this argument will be ignored.\n Returns : string\n Args    : an optional integer number of nucleotides to be returned instead of\n           the default if no gene attached","parameters":[{"label":"$self"},{"label":"$howmany"}],"label":"downstream_seq($self,$howmany)"},"kind":12,"range":{"end":{"character":9999,"line":192},"start":{"line":150,"character":0}},"line":150},{"line":164,"name":"CORE","containerName":"length","kind":12},{"kind":12,"range":{"start":{"character":0,"line":205},"end":{"character":9999,"line":253}},"line":205,"signature":{"label":"upstream_seq($self,$howmany)","parameters":[{"label":"$self"},{"label":"$howmany"}],"documentation":"1;\n# $Id: Transcript.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Transcript\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Transcript - Transcript class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis stores informations about coding sequences (CDS).\nThe implementation is that a Transcript object accesses a collection of\nExon objects, inferring from them the nucleotide structure and sequence.\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Transcript;\n\nuse strict;\n# use Carp qw(carp cluck);\nuse Bio::LiveSeq::Exon; # uses Exon to create new exon in case of deletion\nuse base qw(Bio::LiveSeq::SeqI);\n\n=head2 new\n\n  Title   : new\n  Usage   : $transcript = Bio::LiveSeq::Transcript->new(-exons => \\@obj_refs);\n\n  Function: generates a new Bio::LiveSeq::Transcript\n  Returns : reference to a new object of class Transcript\n  Errorcode -1\n  Args    : reference to an array of Exon object references\n\n\nsub new {\n  my ($thing, %args) = @_;\n  my $class = ref($thing) || $thing;\n  my ($obj,%transcript);\n\n  my @exons=@{$args{-exons}};\n\n  $obj = \\%transcript;\n  $obj = bless $obj, $class;\n\n  unless (@exons) {\n    $obj->warn(\"$class not initialised because exons array empty\");\n    return(-1);\n  }\n\n  # now useless, after start and end methods have been overridden here\n  my $firstexon = $exons[0];\n  #my $lastexon = $exons[-1];\n  #my $start = $firstexon->start;\n  #my $end = $lastexon->end;\n  my $strand = $firstexon->strand;\n  my $seq = $firstexon->{'seq'};\n  $obj->alphabet('rna');\n\n  unless (_checkexons(\\@exons)) {\n    $obj->warn(\"$class not initialised because of problems in the exon structure\");\n    return(-1);\n  }\n  $obj->{'strand'}=$strand;\n  $obj->{'exons'}=\\@exons;\n  $obj->{'seq'}=$seq;\n\n  # set Transcript into each Exon\n  my $exon;\n  foreach $exon (@exons) {\n    $exon->{'transcript'}=$obj;\n  }\n  return $obj;\n}\n\n\n=head2 all_Exons\n\n Title   : all_Exons\n Usage   : $transcript_obj->all_Exons()\n Function: returns references to all Exon objects the Transcript is composed of\n Example : foreach $exon ($transcript->all_Exons()) { do_something }\n Returns : array of object references\n Args    : none\n\n\nsub all_Exons {\n  my $self=shift;\n  my $exonsref=$self->{'exons'};\n  my @exons=@{$exonsref};\n  my @newexons;\n  my $exon;\n  foreach $exon (@exons) {\n    unless ($exon->obj_valid) {\n      $self->warn(\"$exon no more valid, start or end label lost, skipping....\",1); # ignorable\n    } else {\n      push(@newexons,$exon);\n    }\n  }\n  if ($#exons != $#newexons) {\n    # update exons field\n    $self->{'exons'}=\\@newexons;\n  }\n  return (@newexons);\n}\n\n=head2 downstream_seq\n\n Title   : downstream_seq\n Usage   : $transcript_obj->downstream_seq()\n         : $transcript_obj->downstream_seq(64)\n Function: returns a string of nucleotides downstream of the end of the\n           CDS. If there is some information of the real mRNA, from features in\n           an attached Gene object, it will return up to those boundaries.\n           Otherwise it will return 1000 nucleotides.\n           If an argument is given it will override the default 1000 number\n           and return instead /that/ requested number of nucleotides.\n           But if a Gene object is attached, this argument will be ignored.\n Returns : string\n Args    : an optional integer number of nucleotides to be returned instead of\n           the default if no gene attached\n\n\nsub downstream_seq {\n  my ($self,$howmany)=@_;\n  my $str;\n  if (defined ($howmany)) {\n    unless ($howmany > 0) {\n      $self->throw(\"No sense in asking less than 1 downstream nucleotides!\");\n    }\n  } else {\n    unless ($self->{'seq'}->alphabet eq 'rna') { # if rna retrieve until the end\n      #$str=$DNAobj->labelsubseq($self->end,undef,undef,\"unsecuremoderequested\");\n      #return(substr($str,1)); # delete first nucleotide that is the last of Transcript\n      if ($self->gene) { # if there is Gene object attached fetch relevant info\n\t$str=$self->{'seq'}->labelsubseq($self->end,undef,$self->gene->maxtranscript->end); # retrieve from end of this Transcript to end of the maxtranscript\n\t$str=substr($str,1); # delete first nucleotide that is the last of Transcript\n\tif (CORE::length($str) > 0) {\n\t  return($str);\n\t} else { # if there was no downstream through the gene's maxtranscript, go the usual way\n\t  $howmany = 1000;\n\t}\n      } else {\n\t$howmany = 1000;\n      }\n    }\n  }\n  my @exons=$self->all_Exons;\n  my $strand=$self->strand();\n  my $lastexon=$exons[-1];\n  my $lastexonlength=$lastexon->length;\n  # $howmany nucs after end of last exon\n  #my $downstream_seq=$lastexon->subseq($lastexonlength+1,undef,$howmany);\n  my $downstream_seq;\n\n  if ($howmany) {\n      $downstream_seq=substr($lastexon->labelsubseq($self->end,$howmany,undef,\"unsecuremoderequested\"),1);\n  } else {\n    if ($strand == 1) {\n      $downstream_seq=substr($lastexon->labelsubseq($self->end,undef,$self->{'seq'}->end,\"unsecuremoderequested\"),1);\n    } else {\n      $downstream_seq=substr($lastexon->labelsubseq($self->end,undef,$self->{'seq'}->start,\"unsecuremoderequested\"),1);\n    }\n  }\n  return $downstream_seq;\n}\n\n=head2 upstream_seq\n\n Title   : upstream_seq\n Usage   : $transcript_obj->upstream_seq()\n         : $transcript_obj->upstream_seq(64)\n Function: just like downstream_seq but returns nucleotides before the ATG\n Note    : the default, if no Gene information present and no nucleotides\n           number given, is to return up to 400 nucleotides."},"name":"upstream_seq","containerName":"main::","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"upstream_seq","line":206,"definition":"my"},{"containerName":"upstream_seq","kind":13,"name":"$howmany","line":206},{"line":207,"name":"$howmany","kind":13,"containerName":"upstream_seq"},{"kind":13,"containerName":"upstream_seq","name":"$howmany","line":208},{"line":209,"kind":13,"containerName":"upstream_seq","name":"$self"},{"line":209,"containerName":"upstream_seq","kind":12,"name":"throw"},{"line":212,"kind":13,"containerName":"upstream_seq","name":"$self"},{"line":212,"containerName":"upstream_seq","kind":12,"name":"alphabet"},{"kind":13,"containerName":"upstream_seq","name":"$self","line":213},{"line":213,"name":"gene","kind":12,"containerName":"upstream_seq"},{"definition":"my","line":214,"containerName":"upstream_seq","localvar":"my","kind":13,"name":"$str"},{"line":214,"name":"$self","containerName":"upstream_seq","kind":13},{"containerName":"upstream_seq","kind":12,"name":"labelsubseq","line":214},{"line":214,"name":"$self","containerName":"upstream_seq","kind":13},{"line":214,"kind":12,"containerName":"upstream_seq","name":"gene"},{"kind":12,"containerName":"upstream_seq","name":"maxtranscript","line":214},{"line":214,"name":"start","kind":12,"containerName":"upstream_seq"},{"line":214,"name":"$self","containerName":"upstream_seq","kind":13},{"containerName":"upstream_seq","kind":12,"name":"start","line":214},{"line":215,"name":"$str","containerName":"upstream_seq","kind":13},{"line":216,"name":"$str","containerName":"upstream_seq","kind":13},{"kind":13,"containerName":"upstream_seq","name":"$str","line":217},{"containerName":"upstream_seq","kind":13,"name":"$howmany","line":219},{"line":222,"kind":13,"containerName":"upstream_seq","name":"$howmany"},{"line":226,"containerName":"upstream_seq","localvar":"my","kind":13,"name":"@exons","definition":"my"},{"line":226,"containerName":"upstream_seq","kind":13,"name":"$self"},{"line":226,"name":"all_Exons","kind":12,"containerName":"upstream_seq"},{"definition":"my","name":"$firstexon","localvar":"my","containerName":"upstream_seq","kind":13,"line":227},{"name":"$exons","containerName":"upstream_seq","kind":13,"line":227},{"definition":"my","line":229,"name":"$upstream_seq","containerName":"upstream_seq","localvar":"my","kind":13},{"definition":"my","line":230,"name":"$strand","localvar":"my","containerName":"upstream_seq","kind":13},{"containerName":"upstream_seq","kind":13,"name":"$self","line":230},{"kind":12,"containerName":"upstream_seq","name":"strand","line":230},{"line":232,"kind":13,"containerName":"upstream_seq","name":"$howmany"},{"line":233,"name":"$labelbefore","localvar":"my","containerName":"upstream_seq","kind":13,"definition":"my"},{"line":233,"containerName":"upstream_seq","kind":13,"name":"$firstexon"},{"kind":12,"containerName":"upstream_seq","name":"label","line":233},{"line":233,"kind":13,"containerName":"upstream_seq","name":"$howmany"},{"name":"$firstexon","kind":13,"containerName":"upstream_seq","line":233},{"line":233,"kind":12,"containerName":"upstream_seq","name":"start"},{"line":234,"kind":13,"containerName":"upstream_seq","name":"$labelbefore"},{"kind":13,"containerName":"upstream_seq","name":"$strand","line":235},{"line":236,"name":"$labelbefore","kind":13,"containerName":"upstream_seq"},{"line":236,"containerName":"upstream_seq","kind":13,"name":"$self"},{"line":236,"name":"start","containerName":"upstream_seq","kind":12},{"line":238,"name":"$labelbefore","containerName":"upstream_seq","kind":13},{"name":"$self","kind":13,"containerName":"upstream_seq","line":238},{"line":238,"kind":12,"containerName":"upstream_seq","name":"end"},{"name":"$upstream_seq","kind":13,"containerName":"upstream_seq","line":241},{"line":241,"kind":13,"containerName":"upstream_seq","name":"$firstexon"},{"containerName":"upstream_seq","kind":12,"name":"labelsubseq","line":241},{"name":"$labelbefore","containerName":"upstream_seq","kind":13,"line":241},{"line":241,"kind":13,"containerName":"upstream_seq","name":"$firstexon"},{"name":"start","containerName":"upstream_seq","kind":12,"line":241},{"kind":13,"containerName":"upstream_seq","name":"$upstream_seq","line":242},{"line":244,"name":"$strand","containerName":"upstream_seq","kind":13},{"line":245,"kind":13,"containerName":"upstream_seq","name":"$upstream_seq"},{"kind":13,"containerName":"upstream_seq","name":"$firstexon","line":245},{"line":245,"name":"labelsubseq","kind":12,"containerName":"upstream_seq"},{"containerName":"upstream_seq","kind":13,"name":"$self","line":245},{"name":"start","kind":12,"containerName":"upstream_seq","line":245},{"line":245,"kind":13,"containerName":"upstream_seq","name":"$self"},{"name":"start","kind":12,"containerName":"upstream_seq","line":245},{"line":246,"containerName":"upstream_seq","kind":13,"name":"$upstream_seq"},{"kind":13,"containerName":"upstream_seq","name":"$upstream_seq","line":248},{"containerName":"upstream_seq","kind":13,"name":"$firstexon","line":248},{"kind":12,"containerName":"upstream_seq","name":"labelsubseq","line":248},{"line":248,"kind":13,"containerName":"upstream_seq","name":"$self"},{"line":248,"containerName":"upstream_seq","kind":12,"name":"end"},{"kind":13,"containerName":"upstream_seq","name":"$self","line":248},{"line":248,"containerName":"upstream_seq","kind":12,"name":"start"},{"line":249,"name":"$upstream_seq","containerName":"upstream_seq","kind":13},{"line":252,"containerName":"upstream_seq","kind":13,"name":"$upstream_seq"}],"detail":"($self,$howmany)","definition":"sub"},{"detail":"($self,$position,$firstlabel)","definition":"sub","containerName":"main::","name":"label","children":[{"line":261,"name":"$self","localvar":"my","kind":13,"containerName":"label","definition":"my"},{"line":261,"name":"$position","containerName":"label","kind":13},{"line":261,"name":"$firstlabel","containerName":"label","kind":13},{"line":262,"name":"$position","containerName":"label","kind":13},{"line":263,"name":"$self","kind":13,"containerName":"label"},{"line":263,"containerName":"label","kind":12,"name":"warn"},{"definition":"my","line":266,"localvar":"my","kind":13,"containerName":"label","name":"$start"},{"line":266,"containerName":"label","kind":13,"name":"$end"},{"line":266,"containerName":"label","kind":13,"name":"$strand"},{"containerName":"label","kind":13,"name":"$self","line":266},{"line":266,"kind":12,"containerName":"label","name":"start"},{"containerName":"label","kind":13,"name":"$self","line":266},{"name":"end","containerName":"label","kind":12,"line":266},{"line":266,"name":"$self","containerName":"label","kind":13},{"name":"strand","kind":12,"containerName":"label","line":266},{"definition":"my","line":267,"localvar":"my","kind":13,"containerName":"label","name":"$label"},{"line":267,"containerName":"label","kind":13,"name":"@labels"},{"containerName":"label","kind":13,"name":"$length","line":267},{"line":267,"kind":13,"containerName":"label","name":"$arraypos"},{"name":"$firstlabel","kind":13,"containerName":"label","line":268},{"kind":13,"containerName":"label","name":"$firstlabel","line":269},{"name":"$self","kind":13,"containerName":"label","line":269},{"line":269,"kind":12,"containerName":"label","name":"coordinate_start"},{"definition":"my","line":271,"name":"$coord_pos","kind":13,"localvar":"my","containerName":"label"},{"name":"$self","containerName":"label","kind":13,"line":271},{"name":"_inside_position","containerName":"label","kind":12,"line":271},{"line":271,"name":"$firstlabel","kind":13,"containerName":"label"},{"line":272,"name":"$length","containerName":"label","kind":13},{"line":272,"containerName":"label","kind":13,"name":"$self"},{"kind":12,"containerName":"label","name":"length","line":272},{"line":274,"name":"$position","containerName":"label","kind":13},{"name":"$position","kind":13,"containerName":"label","line":275},{"containerName":"label","kind":13,"name":"$arraypos","line":277},{"name":"$position","containerName":"label","kind":13,"line":277},{"containerName":"label","kind":13,"name":"$coord_pos","line":277},{"kind":13,"containerName":"label","name":"$arraypos","line":279},{"kind":13,"containerName":"label","name":"$label","line":280},{"kind":13,"containerName":"label","name":"$self","line":280},{"line":280,"name":"label","kind":12,"containerName":"label"},{"line":280,"containerName":"label","kind":13,"name":"$arraypos"},{"name":"$start","kind":13,"containerName":"label","line":280},{"line":280,"name":"$strand","containerName":"label","kind":13},{"containerName":"label","kind":13,"name":"$arraypos","line":281},{"kind":13,"containerName":"label","name":"$length","line":281},{"name":"$label","kind":13,"containerName":"label","line":282},{"line":282,"name":"$self","kind":13,"containerName":"label"},{"line":282,"name":"label","containerName":"label","kind":12},{"line":282,"containerName":"label","kind":13,"name":"$arraypos"},{"line":282,"kind":13,"containerName":"label","name":"$length"},{"line":282,"containerName":"label","kind":13,"name":"$end"},{"containerName":"label","kind":13,"name":"$strand","line":282},{"containerName":"label","kind":13,"name":"@labels","line":284},{"name":"$self","kind":13,"containerName":"label","line":284},{"kind":12,"containerName":"label","name":"all_labels","line":284},{"line":285,"name":"$label","containerName":"label","kind":13},{"kind":13,"containerName":"label","name":"$labels","line":285},{"line":285,"containerName":"label","kind":13,"name":"$arraypos"}],"signature":{"label":"label($self,$position,$firstlabel)","documentation":" These get redefined here, overriding the SeqI one because they draw their\n information from the Exons a Transcript is built of\n optional argument: firstlabel. If not given, it checks coordinate_start\n                                This is useful when called by Translation\n                                also used by _delete","parameters":[{"label":"$self"},{"label":"$position"},{"label":"$firstlabel"}]},"kind":12,"range":{"end":{"line":288,"character":9999},"start":{"line":260,"character":0}},"line":260},{"children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"position","line":296},{"name":"$label","containerName":"position","kind":13,"line":296},{"name":"$firstlabel","containerName":"position","kind":13,"line":296},{"line":297,"name":"$self","kind":13,"containerName":"position"},{"containerName":"position","kind":12,"name":"valid","line":297},{"line":297,"name":"$label","containerName":"position","kind":13},{"line":298,"name":"$self","containerName":"position","kind":13},{"containerName":"position","kind":12,"name":"warn","line":298},{"kind":13,"containerName":"position","name":"$firstlabel","line":301},{"name":"$firstlabel","containerName":"position","kind":13,"line":302},{"line":302,"containerName":"position","kind":13,"name":"$self"},{"name":"coordinate_start","containerName":"position","kind":12,"line":302},{"name":"$label","kind":13,"containerName":"position","line":304},{"kind":13,"containerName":"position","name":"$firstlabel","line":304},{"definition":"my","name":"$start","localvar":"my","containerName":"position","kind":13,"line":307},{"containerName":"position","kind":13,"name":"$end","line":307},{"line":307,"name":"$strand","kind":13,"containerName":"position"},{"kind":13,"containerName":"position","name":"$self","line":307},{"kind":12,"containerName":"position","name":"start","line":307},{"line":307,"name":"$self","kind":13,"containerName":"position"},{"line":307,"kind":12,"containerName":"position","name":"end"},{"line":307,"kind":13,"containerName":"position","name":"$self"},{"line":307,"kind":12,"containerName":"position","name":"strand"},{"definition":"my","name":"$position","localvar":"my","containerName":"position","kind":13,"line":308},{"line":308,"name":"$in_pos","kind":13,"containerName":"position"},{"line":308,"name":"$out_pos","containerName":"position","kind":13},{"containerName":"position","kind":13,"name":"$coord_pos","line":308},{"definition":"my","localvar":"my","kind":13,"containerName":"position","name":"$length","line":309},{"name":"$self","kind":13,"containerName":"position","line":309},{"name":"length","kind":12,"containerName":"position","line":309},{"name":"$coord_pos","kind":13,"containerName":"position","line":310},{"line":310,"containerName":"position","kind":13,"name":"$self"},{"line":310,"kind":12,"containerName":"position","name":"_inside_position"},{"line":310,"name":"$firstlabel","kind":13,"containerName":"position"},{"line":311,"name":"$self","containerName":"position","kind":13},{"line":311,"containerName":"position","kind":12,"name":"valid"},{"line":311,"kind":13,"containerName":"position","name":"$label"},{"name":"$in_pos","kind":13,"containerName":"position","line":312},{"line":312,"name":"$self","kind":13,"containerName":"position"},{"line":312,"name":"_inside_position","kind":12,"containerName":"position"},{"line":312,"containerName":"position","kind":13,"name":"$label"},{"name":"$position","kind":13,"containerName":"position","line":313},{"line":313,"kind":13,"containerName":"position","name":"$in_pos"},{"kind":13,"containerName":"position","name":"$coord_pos","line":313},{"line":314,"containerName":"position","kind":13,"name":"$position"},{"line":315,"name":"$position","kind":13,"containerName":"position"},{"kind":13,"containerName":"position","name":"$self","line":318},{"line":318,"containerName":"position","kind":12,"name":"follows"},{"line":318,"containerName":"position","kind":13,"name":"$end"},{"line":318,"name":"$label","containerName":"position","kind":13},{"line":319,"name":"$out_pos","containerName":"position","kind":13},{"line":319,"kind":13,"containerName":"position","name":"$self"},{"containerName":"position","kind":12,"name":"position","line":319},{"line":319,"containerName":"position","kind":13,"name":"$label"},{"line":319,"containerName":"position","kind":13,"name":"$end"},{"line":319,"containerName":"position","kind":13,"name":"$strand"},{"line":321,"kind":13,"containerName":"position","name":"$position"},{"line":321,"name":"$out_pos","containerName":"position","kind":13},{"containerName":"position","kind":13,"name":"$length","line":321},{"line":321,"containerName":"position","kind":13,"name":"$coord_pos"},{"kind":13,"containerName":"position","name":"$self","line":322},{"line":322,"kind":12,"containerName":"position","name":"follows"},{"line":322,"name":"$label","kind":13,"containerName":"position"},{"containerName":"position","kind":13,"name":"$start","line":322},{"line":324,"kind":13,"containerName":"position","name":"$out_pos"},{"line":324,"containerName":"position","kind":13,"name":"$self"},{"line":324,"name":"position","containerName":"position","kind":12},{"name":"$label","containerName":"position","kind":13,"line":324},{"containerName":"position","kind":13,"name":"$start","line":324},{"name":"$strand","kind":13,"containerName":"position","line":324},{"line":325,"containerName":"position","kind":13,"name":"$position"},{"containerName":"position","kind":13,"name":"$out_pos","line":325},{"name":"$coord_pos","containerName":"position","kind":13,"line":325},{"line":327,"name":"$self","kind":13,"containerName":"position"},{"line":327,"name":"warn","kind":12,"containerName":"position"},{"name":"$position","containerName":"position","kind":13,"line":331}],"name":"position","containerName":"main::","definition":"sub","detail":"($self,$label,$firstlabel)","line":295,"kind":12,"range":{"end":{"character":9999,"line":332},"start":{"character":0,"line":295}},"signature":{"parameters":[{"label":"$self"},{"label":"$label"},{"label":"$firstlabel"}],"documentation":" argument: label\n returns: position of label according to coord_start\n errorcode: 0 label not found\n optional argument: firstlabel. If not given, it checks coordinate_start\n                                This is useful when called by Translation","label":"position($self,$label,$firstlabel)"}},{"kind":12,"range":{"end":{"line":342,"character":9999},"start":{"line":334,"character":0}},"line":334,"definition":"sub","name":"seq","containerName":"main::","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"seq","name":"$self","line":335},{"definition":"my","kind":13,"localvar":"my","containerName":"seq","name":"$exon","line":336},{"name":"$str","kind":13,"containerName":"seq","line":336},{"line":337,"kind":13,"localvar":"my","containerName":"seq","name":"@exons","definition":"my"},{"containerName":"seq","kind":13,"name":"$self","line":337},{"name":"all_Exons","containerName":"seq","kind":12,"line":337},{"kind":13,"containerName":"seq","name":"$exon","line":338},{"line":338,"containerName":"seq","kind":13,"name":"@exons"},{"containerName":"seq","kind":13,"name":"$str","line":339},{"line":339,"kind":13,"containerName":"seq","name":"$exon"},{"containerName":"seq","kind":12,"name":"seq","line":339},{"kind":13,"containerName":"seq","name":"$str","line":341}]},{"line":344,"range":{"start":{"character":0,"line":344},"end":{"line":352,"character":9999}},"kind":12,"definition":"sub","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"length","kind":13,"line":345},{"kind":13,"localvar":"my","containerName":"length","name":"$exon","line":346,"definition":"my"},{"kind":13,"containerName":"length","name":"$length","line":346},{"definition":"my","name":"@exons","localvar":"my","kind":13,"containerName":"length","line":347},{"line":347,"name":"$self","kind":13,"containerName":"length"},{"kind":12,"containerName":"length","name":"all_Exons","line":347},{"line":348,"kind":13,"containerName":"length","name":"$exon"},{"containerName":"length","kind":13,"name":"@exons","line":348},{"line":349,"name":"$length","kind":13,"containerName":"length"},{"line":349,"name":"$exon","kind":13,"containerName":"length"},{"name":"length","containerName":"length","kind":12,"line":349},{"name":"$length","containerName":"length","kind":13,"line":351}],"name":"length","containerName":"main::"},{"range":{"end":{"line":362,"character":9999},"start":{"line":354,"character":0}},"kind":12,"line":354,"definition":"sub","containerName":"main::","name":"all_labels","children":[{"definition":"my","line":355,"localvar":"my","containerName":"all_labels","kind":13,"name":"$self"},{"definition":"my","localvar":"my","kind":13,"containerName":"all_labels","name":"$exon","line":356},{"containerName":"all_labels","kind":13,"name":"@labels","line":356},{"containerName":"all_labels","localvar":"my","kind":13,"name":"@exons","line":357,"definition":"my"},{"kind":13,"containerName":"all_labels","name":"$self","line":357},{"name":"all_Exons","kind":12,"containerName":"all_labels","line":357},{"line":358,"kind":13,"containerName":"all_labels","name":"$exon"},{"name":"@exons","containerName":"all_labels","kind":13,"line":358},{"line":359,"name":"@labels","kind":13,"containerName":"all_labels"},{"name":"$exon","kind":13,"containerName":"all_labels","line":359},{"line":359,"name":"all_labels","containerName":"all_labels","kind":12},{"line":361,"kind":13,"containerName":"all_labels","name":"@labels"}]},{"definition":"sub","detail":"($self,$start,$length,$end)","children":[{"name":"$self","containerName":"old_labelsubseq","localvar":"my","kind":13,"line":374,"definition":"my"},{"kind":13,"containerName":"old_labelsubseq","name":"$start","line":374},{"line":374,"containerName":"old_labelsubseq","kind":13,"name":"$length"},{"line":374,"containerName":"old_labelsubseq","kind":13,"name":"$end"},{"definition":"my","localvar":"my","kind":13,"containerName":"old_labelsubseq","name":"$pos1","line":375},{"line":375,"containerName":"old_labelsubseq","kind":13,"name":"$pos2"},{"line":376,"name":"$start","containerName":"old_labelsubseq","kind":13},{"line":377,"containerName":"old_labelsubseq","kind":13,"name":"$self"},{"kind":12,"containerName":"old_labelsubseq","name":"valid","line":377},{"name":"$start","containerName":"old_labelsubseq","kind":13,"line":377},{"containerName":"old_labelsubseq","kind":13,"name":"$self","line":378},{"line":378,"containerName":"old_labelsubseq","kind":12,"name":"warn"},{"line":380,"name":"$pos1","containerName":"old_labelsubseq","kind":13},{"kind":13,"containerName":"old_labelsubseq","name":"$self","line":380},{"name":"position","containerName":"old_labelsubseq","kind":12,"line":380},{"name":"$start","kind":13,"containerName":"old_labelsubseq","line":380},{"kind":13,"containerName":"old_labelsubseq","name":"$end","line":382},{"line":383,"name":"$end","kind":13,"containerName":"old_labelsubseq"},{"containerName":"old_labelsubseq","kind":13,"name":"$start","line":383},{"line":384,"kind":13,"containerName":"old_labelsubseq","name":"$length"},{"line":386,"name":"$self","containerName":"old_labelsubseq","kind":13},{"line":386,"kind":12,"containerName":"old_labelsubseq","name":"valid"},{"line":386,"kind":13,"containerName":"old_labelsubseq","name":"$end"},{"kind":13,"containerName":"old_labelsubseq","name":"$self","line":387},{"line":387,"name":"warn","containerName":"old_labelsubseq","kind":12},{"name":"$self","kind":13,"containerName":"old_labelsubseq","line":389},{"line":389,"name":"follows","kind":12,"containerName":"old_labelsubseq"},{"containerName":"old_labelsubseq","kind":13,"name":"$start","line":389},{"line":389,"name":"$end","kind":13,"containerName":"old_labelsubseq"},{"containerName":"old_labelsubseq","kind":13,"name":"$self","line":390},{"name":"warn","kind":12,"containerName":"old_labelsubseq","line":390},{"name":"$pos2","containerName":"old_labelsubseq","kind":13,"line":392},{"name":"$self","containerName":"old_labelsubseq","kind":13,"line":392},{"line":392,"kind":12,"containerName":"old_labelsubseq","name":"position"},{"kind":13,"containerName":"old_labelsubseq","name":"$end","line":392},{"line":393,"name":"$length","kind":13,"containerName":"old_labelsubseq"},{"line":396,"containerName":"old_labelsubseq","kind":13,"name":"$self"},{"line":396,"name":"subseq","kind":12,"containerName":"old_labelsubseq"},{"line":396,"name":"$pos1","kind":13,"containerName":"old_labelsubseq"},{"line":396,"name":"$pos2","kind":13,"containerName":"old_labelsubseq"},{"containerName":"old_labelsubseq","kind":13,"name":"$length","line":396}],"containerName":"main::","name":"old_labelsubseq","signature":{"label":"old_labelsubseq($self,$start,$length,$end)","parameters":[{"label":"$self"},{"label":"$start"},{"label":"$length"},{"label":"$end"}],"documentation":" redefined here so that it will retrieve effective subseq without introns\n otherwise it would have retrieved an underlying DNA (possibly with introns)\n subsequence\n Drawback: this is really bulky, label->position and then a call to\n subseq that will do the opposite position-> label\n\n one day this can be rewritten as the main one so that the normal subseq\n will rely on this one and hence avoid this double (useless and lengthy)\n conversion between labels and positions"},"line":373,"range":{"start":{"character":0,"line":373},"end":{"line":397,"character":9999}},"kind":12},{"definition":"sub","detail":"($self,$start,$length,$end,$unsecuremode)","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"labelsubseq","kind":13,"line":402},{"containerName":"labelsubseq","kind":13,"name":"$start","line":402},{"containerName":"labelsubseq","kind":13,"name":"$length","line":402},{"line":402,"name":"$end","containerName":"labelsubseq","kind":13},{"line":402,"name":"$unsecuremode","kind":13,"containerName":"labelsubseq"},{"line":403,"containerName":"labelsubseq","kind":13,"name":"$unsecuremode"},{"line":404,"name":"$unsecuremode","containerName":"labelsubseq","kind":13},{"line":406,"name":"$start","kind":13,"containerName":"labelsubseq"},{"line":407,"containerName":"labelsubseq","kind":13,"name":"$self"},{"name":"valid","kind":12,"containerName":"labelsubseq","line":407},{"name":"$start","kind":13,"containerName":"labelsubseq","line":407},{"name":"$self","containerName":"labelsubseq","kind":13,"line":408},{"line":408,"name":"warn","containerName":"labelsubseq","kind":12},{"line":411,"containerName":"labelsubseq","kind":13,"name":"$start"},{"name":"$self","kind":13,"containerName":"labelsubseq","line":411},{"line":411,"kind":12,"containerName":"labelsubseq","name":"start"},{"line":413,"name":"$end","kind":13,"containerName":"labelsubseq"},{"line":414,"name":"$end","kind":13,"containerName":"labelsubseq"},{"line":414,"name":"$start","containerName":"labelsubseq","kind":13},{"name":"$length","kind":13,"containerName":"labelsubseq","line":415},{"name":"$end","containerName":"labelsubseq","kind":13,"line":416},{"line":418,"name":"$length","containerName":"labelsubseq","kind":13},{"containerName":"labelsubseq","kind":13,"name":"$self","line":419},{"line":419,"containerName":"labelsubseq","kind":12,"name":"valid"},{"kind":13,"containerName":"labelsubseq","name":"$end","line":419},{"line":420,"containerName":"labelsubseq","kind":13,"name":"$self"},{"name":"warn","containerName":"labelsubseq","kind":12,"line":420},{"line":422,"name":"$self","containerName":"labelsubseq","kind":13},{"name":"follows","containerName":"labelsubseq","kind":12,"line":422},{"kind":13,"containerName":"labelsubseq","name":"$start","line":422},{"name":"$end","kind":13,"containerName":"labelsubseq","line":422},{"containerName":"labelsubseq","kind":13,"name":"$self","line":423},{"name":"warn","containerName":"labelsubseq","kind":12,"line":423},{"containerName":"labelsubseq","kind":13,"name":"$end","line":427},{"containerName":"labelsubseq","kind":13,"name":"$self","line":427},{"line":427,"kind":12,"containerName":"labelsubseq","name":"end"},{"name":"$seq","localvar":"my","kind":13,"containerName":"labelsubseq","line":430,"definition":"my"},{"kind":13,"containerName":"labelsubseq","name":"$exon","line":430},{"line":430,"containerName":"labelsubseq","kind":13,"name":"$startexon"},{"line":430,"containerName":"labelsubseq","kind":13,"name":"$endexon"},{"definition":"my","line":430,"kind":13,"localvar":"my","containerName":"labelsubseq","name":"@exonlabels"},{"localvar":"my","kind":13,"containerName":"labelsubseq","name":"@exons","line":431,"definition":"my"},{"line":431,"containerName":"labelsubseq","kind":13,"name":"$self"},{"line":431,"name":"all_Exons","containerName":"labelsubseq","kind":12},{"kind":13,"containerName":"labelsubseq","name":"$exon","line":433},{"line":433,"name":"@exons","containerName":"labelsubseq","kind":13},{"line":434,"kind":13,"containerName":"labelsubseq","name":"$startexon"},{"containerName":"labelsubseq","kind":13,"name":"$exon","line":434},{"name":"valid","kind":12,"containerName":"labelsubseq","line":434},{"line":434,"name":"$start","containerName":"labelsubseq","kind":13},{"name":"$startexon","containerName":"labelsubseq","kind":13,"line":435},{"containerName":"labelsubseq","kind":13,"name":"$exon","line":435},{"line":437,"containerName":"labelsubseq","kind":13,"name":"$exon"},{"line":437,"kind":12,"containerName":"labelsubseq","name":"valid"},{"line":437,"name":"$end","kind":13,"containerName":"labelsubseq"},{"kind":13,"containerName":"labelsubseq","name":"$endexon","line":438},{"line":438,"name":"$exon","containerName":"labelsubseq","kind":13},{"kind":13,"containerName":"labelsubseq","name":"$seq","line":440},{"line":440,"name":"$startexon","containerName":"labelsubseq","kind":13},{"name":"$endexon","kind":13,"containerName":"labelsubseq","line":441},{"line":441,"name":"$endexon","containerName":"labelsubseq","kind":13},{"name":"$startexon","containerName":"labelsubseq","kind":13,"line":441},{"line":442,"containerName":"labelsubseq","kind":13,"name":"$length"},{"name":"$seq","kind":13,"containerName":"labelsubseq","line":443},{"line":443,"containerName":"labelsubseq","kind":13,"name":"$startexon"},{"line":443,"containerName":"labelsubseq","kind":12,"name":"labelsubseq"},{"line":443,"name":"$start","containerName":"labelsubseq","kind":13},{"name":"$length","containerName":"labelsubseq","kind":13,"line":443},{"name":"$seq","kind":13,"containerName":"labelsubseq","line":448},{"name":"$startexon","containerName":"labelsubseq","kind":13,"line":448},{"line":448,"kind":12,"containerName":"labelsubseq","name":"labelsubseq"},{"kind":13,"containerName":"labelsubseq","name":"$start","line":448},{"line":448,"containerName":"labelsubseq","kind":13,"name":"$end"},{"line":452,"name":"$seq","containerName":"labelsubseq","kind":13},{"line":452,"containerName":"labelsubseq","kind":13,"name":"$startexon"},{"line":452,"kind":12,"containerName":"labelsubseq","name":"labelsubseq"},{"kind":13,"containerName":"labelsubseq","name":"$start","line":452},{"name":"$startexon","kind":13,"containerName":"labelsubseq","line":455},{"name":"$exon","kind":13,"containerName":"labelsubseq","line":455},{"name":"$startexon","containerName":"labelsubseq","kind":13,"line":455},{"line":456,"kind":13,"containerName":"labelsubseq","name":"$endexon"},{"containerName":"labelsubseq","kind":13,"name":"$seq","line":457},{"containerName":"labelsubseq","kind":13,"name":"$endexon","line":457},{"line":457,"name":"labelsubseq","containerName":"labelsubseq","kind":12},{"containerName":"labelsubseq","kind":13,"name":"$end","line":457},{"kind":13,"containerName":"labelsubseq","name":"$startexon","line":460},{"name":"$seq","containerName":"labelsubseq","kind":13,"line":461},{"line":461,"name":"$exon","containerName":"labelsubseq","kind":13},{"line":461,"containerName":"labelsubseq","kind":12,"name":"seq"},{"line":463,"containerName":"labelsubseq","kind":13,"name":"$length"},{"line":464,"kind":13,"containerName":"labelsubseq","name":"$seq"},{"line":464,"name":"$seq","containerName":"labelsubseq","kind":13},{"name":"$length","containerName":"labelsubseq","kind":13,"line":464},{"name":"$length","containerName":"labelsubseq","kind":13,"line":470},{"line":471,"containerName":"labelsubseq","kind":13,"name":"$seq"},{"kind":13,"containerName":"labelsubseq","name":"$length","line":471},{"name":"$seq","kind":13,"containerName":"labelsubseq","line":473}],"containerName":"main::","name":"labelsubseq","signature":{"parameters":[{"label":"$self"},{"label":"$start"},{"label":"$length"},{"label":"$end"},{"label":"$unsecuremode"}],"documentation":" rewritten, eventually","label":"labelsubseq($self,$start,$length,$end,$unsecuremode)"},"line":401,"kind":12,"range":{"end":{"character":9999,"line":475},"start":{"character":0,"line":401}}},{"name":"EXONCHECK","kind":12,"line":432},{"name":"EXONCHECK","kind":12,"line":446},{"line":450,"kind":12,"name":"EXONCHECK"},{"kind":12,"name":"EXONCHECK","line":458},{"kind":12,"containerName":"length","name":"CORE","line":464},{"kind":12,"name":"EXONCHECK","line":465},{"detail":"($self,$label)","definition":"sub","name":"in_which_Exon","containerName":"main::","children":[{"line":482,"name":"$self","localvar":"my","containerName":"in_which_Exon","kind":13,"definition":"my"},{"name":"$label","kind":13,"containerName":"in_which_Exon","line":482},{"definition":"my","line":483,"containerName":"in_which_Exon","localvar":"my","kind":13,"name":"$count"},{"name":"$exon","containerName":"in_which_Exon","kind":13,"line":483},{"definition":"my","name":"@exons","localvar":"my","kind":13,"containerName":"in_which_Exon","line":484},{"line":484,"kind":13,"containerName":"in_which_Exon","name":"$self"},{"line":484,"name":"all_Exons","containerName":"in_which_Exon","kind":12},{"line":485,"containerName":"in_which_Exon","kind":13,"name":"$exon"},{"line":485,"containerName":"in_which_Exon","kind":13,"name":"@exons"},{"containerName":"in_which_Exon","kind":13,"name":"$count","line":486},{"line":487,"kind":13,"containerName":"in_which_Exon","name":"$exon"},{"kind":12,"containerName":"in_which_Exon","name":"valid","line":487},{"line":487,"kind":13,"containerName":"in_which_Exon","name":"$label"},{"line":488,"containerName":"in_which_Exon","kind":13,"name":"$exon"},{"name":"$count","kind":13,"containerName":"in_which_Exon","line":488}],"signature":{"label":"in_which_Exon($self,$label)","parameters":[{"label":"$self"},{"label":"$label"}],"documentation":" argument: label\n returns: the objref and progressive number of the Exon containing that label\n errorcode: -1"},"kind":12,"range":{"start":{"line":481,"character":0},"end":{"character":9999,"line":492}},"line":481},{"detail":"($self,$pos1,$pos2,$length)","definition":"sub","containerName":"main::","name":"subseq","children":[{"localvar":"my","containerName":"subseq","kind":13,"name":"$self","line":497,"definition":"my"},{"line":497,"containerName":"subseq","kind":13,"name":"$pos1"},{"line":497,"kind":13,"containerName":"subseq","name":"$pos2"},{"line":497,"containerName":"subseq","kind":13,"name":"$length"},{"definition":"my","containerName":"subseq","localvar":"my","kind":13,"name":"$str","line":498},{"name":"$startlabel","kind":13,"containerName":"subseq","line":498},{"name":"$endlabel","kind":13,"containerName":"subseq","line":498},{"line":499,"name":"$pos1","containerName":"subseq","kind":13},{"kind":13,"containerName":"subseq","name":"$pos1","line":500},{"line":501,"containerName":"subseq","kind":13,"name":"$self"},{"line":501,"containerName":"subseq","kind":12,"name":"warn"},{"containerName":"subseq","kind":13,"name":"$pos2","line":503},{"name":"$pos1","containerName":"subseq","kind":13,"line":503},{"containerName":"subseq","kind":13,"name":"$pos2","line":503},{"line":504,"name":"$self","containerName":"subseq","kind":13},{"line":504,"name":"warn","kind":12,"containerName":"subseq"},{"line":506,"name":"$startlabel","kind":13,"containerName":"subseq"},{"kind":13,"containerName":"subseq","name":"$self","line":506},{"containerName":"subseq","kind":12,"name":"label","line":506},{"line":506,"containerName":"subseq","kind":13,"name":"$pos1"},{"name":"$self","containerName":"subseq","kind":13,"line":507},{"line":507,"name":"valid","containerName":"subseq","kind":12},{"name":"$startlabel","kind":13,"containerName":"subseq","line":507},{"name":"$self","containerName":"subseq","kind":13,"line":508},{"name":"warn","kind":12,"containerName":"subseq","line":508},{"line":510,"kind":13,"containerName":"subseq","name":"$startlabel"},{"name":"$self","containerName":"subseq","kind":13,"line":511},{"name":"warn","containerName":"subseq","kind":12,"line":511},{"kind":13,"containerName":"subseq","name":"$startlabel","line":514},{"line":514,"name":"$self","kind":13,"containerName":"subseq"},{"name":"start","containerName":"subseq","kind":12,"line":514},{"line":516,"kind":13,"containerName":"subseq","name":"$pos2"},{"kind":13,"containerName":"subseq","name":"$pos2","line":517},{"kind":13,"containerName":"subseq","name":"$self","line":518},{"kind":12,"containerName":"subseq","name":"warn","line":518},{"name":"$length","kind":13,"containerName":"subseq","line":520},{"line":521,"kind":13,"containerName":"subseq","name":"$pos1"},{"name":"$pos1","containerName":"subseq","kind":13,"line":521},{"name":"$pos2","containerName":"subseq","kind":13,"line":521},{"line":522,"name":"$self","containerName":"subseq","kind":13},{"kind":12,"containerName":"subseq","name":"warn","line":522},{"line":524,"name":"$endlabel","containerName":"subseq","kind":13},{"containerName":"subseq","kind":13,"name":"$self","line":524},{"line":524,"name":"label","containerName":"subseq","kind":12},{"line":524,"kind":13,"containerName":"subseq","name":"$pos2"},{"line":525,"name":"$self","kind":13,"containerName":"subseq"},{"containerName":"subseq","kind":12,"name":"valid","line":525},{"line":525,"name":"$endlabel","containerName":"subseq","kind":13},{"line":526,"name":"$self","kind":13,"containerName":"subseq"},{"containerName":"subseq","kind":12,"name":"warn","line":526},{"containerName":"subseq","kind":13,"name":"$endlabel","line":528},{"name":"$self","containerName":"subseq","kind":13,"line":529},{"line":529,"containerName":"subseq","kind":12,"name":"warn"},{"name":"$length","containerName":"subseq","kind":13,"line":532},{"line":533,"kind":13,"containerName":"subseq","name":"$endlabel"},{"line":533,"containerName":"subseq","kind":13,"name":"$self"},{"line":533,"containerName":"subseq","kind":12,"name":"end"},{"name":"$self","kind":13,"containerName":"subseq","line":536},{"line":536,"name":"labelsubseq","kind":12,"containerName":"subseq"},{"containerName":"subseq","kind":13,"name":"$startlabel","line":536},{"line":536,"kind":13,"containerName":"subseq","name":"$length"},{"containerName":"subseq","kind":13,"name":"$endlabel","line":536}],"signature":{"label":"subseq($self,$pos1,$pos2,$length)","documentation":" recoded to exploit the new fast labelsubseq()\n valid only inside Transcript","parameters":[{"label":"$self"},{"label":"$pos1"},{"label":"$pos2"},{"label":"$length"}]},"kind":12,"range":{"end":{"line":537,"character":9999},"start":{"character":0,"line":496}},"line":496},{"definition":"sub","detail":"($self,$pos1,$pos2,$length)","children":[{"line":541,"name":"$self","localvar":"my","kind":13,"containerName":"old_subseq","definition":"my"},{"kind":13,"containerName":"old_subseq","name":"$pos1","line":541},{"line":541,"containerName":"old_subseq","kind":13,"name":"$pos2"},{"line":541,"name":"$length","kind":13,"containerName":"old_subseq"},{"line":542,"localvar":"my","containerName":"old_subseq","kind":13,"name":"$str","definition":"my"},{"containerName":"old_subseq","kind":13,"name":"$startcount","line":542},{"name":"$endcount","containerName":"old_subseq","kind":13,"line":542},{"containerName":"old_subseq","kind":13,"name":"$seq","line":542},{"name":"$seqlength","containerName":"old_subseq","kind":13,"line":542},{"line":543,"name":"$length","kind":13,"containerName":"old_subseq"},{"name":"$length","kind":13,"containerName":"old_subseq","line":544},{"line":545,"kind":13,"containerName":"old_subseq","name":"$self"},{"containerName":"old_subseq","kind":12,"name":"warn","line":545},{"name":"$firstlabel","localvar":"my","containerName":"old_subseq","kind":13,"line":549,"definition":"my"},{"line":549,"name":"$self","containerName":"old_subseq","kind":13},{"kind":12,"containerName":"old_subseq","name":"coordinate_start","line":549},{"definition":"my","name":"$coord_pos","containerName":"old_subseq","localvar":"my","kind":13,"line":550},{"line":550,"name":"$self","kind":13,"containerName":"old_subseq"},{"name":"_inside_position","containerName":"old_subseq","kind":12,"line":550},{"name":"$firstlabel","containerName":"old_subseq","kind":13,"line":550},{"line":551,"kind":13,"containerName":"old_subseq","name":"$seq"},{"line":551,"name":"$self","kind":13,"containerName":"old_subseq"},{"name":"seq","containerName":"old_subseq","kind":12,"line":551},{"line":552,"kind":13,"containerName":"old_subseq","name":"$seqlength"},{"name":"$seq","kind":13,"containerName":"old_subseq","line":552},{"name":"$pos1","kind":13,"containerName":"old_subseq","line":553},{"name":"$startcount","kind":13,"containerName":"old_subseq","line":554},{"line":554,"name":"$coord_pos","kind":13,"containerName":"old_subseq"},{"line":556,"name":"$pos1","kind":13,"containerName":"old_subseq"},{"line":557,"name":"$self","containerName":"old_subseq","kind":13},{"line":557,"name":"warn","containerName":"old_subseq","kind":12},{"line":558,"containerName":"old_subseq","kind":13,"name":"$pos1"},{"containerName":"old_subseq","kind":13,"name":"$pos1","line":559},{"line":561,"name":"$pos2","kind":13,"containerName":"old_subseq"},{"kind":13,"containerName":"old_subseq","name":"$pos1","line":561},{"containerName":"old_subseq","kind":13,"name":"$pos2","line":561},{"name":"$self","kind":13,"containerName":"old_subseq","line":562},{"line":562,"kind":12,"containerName":"old_subseq","name":"warn"},{"line":565,"name":"$startcount","kind":13,"containerName":"old_subseq"},{"name":"$pos1","kind":13,"containerName":"old_subseq","line":565},{"containerName":"old_subseq","kind":13,"name":"$coord_pos","line":565},{"name":"$pos2","containerName":"old_subseq","kind":13,"line":567},{"containerName":"old_subseq","kind":13,"name":"$pos2","line":570},{"name":"$self","kind":13,"containerName":"old_subseq","line":571},{"name":"warn","containerName":"old_subseq","kind":12,"line":571},{"line":572,"containerName":"old_subseq","kind":13,"name":"$pos2"},{"line":573,"name":"$pos2","containerName":"old_subseq","kind":13},{"line":575,"containerName":"old_subseq","kind":13,"name":"$pos1"},{"line":575,"name":"$pos1","kind":13,"containerName":"old_subseq"},{"kind":13,"containerName":"old_subseq","name":"$pos2","line":575},{"kind":13,"containerName":"old_subseq","name":"$self","line":576},{"line":576,"kind":12,"containerName":"old_subseq","name":"warn"},{"line":579,"name":"$endcount","kind":13,"containerName":"old_subseq"},{"line":579,"kind":13,"containerName":"old_subseq","name":"$pos2"},{"containerName":"old_subseq","kind":13,"name":"$coord_pos","line":579},{"containerName":"old_subseq","kind":13,"name":"$endcount","line":580},{"line":580,"name":"$seqlength","kind":13,"containerName":"old_subseq"},{"line":582,"kind":13,"containerName":"old_subseq","name":"$self"},{"name":"warn","containerName":"old_subseq","kind":12,"line":582},{"containerName":"old_subseq","kind":13,"name":"$length","line":585},{"name":"$endcount","containerName":"old_subseq","kind":13,"line":585},{"containerName":"old_subseq","kind":13,"name":"$startcount","line":585},{"definition":"my","line":588,"name":"$offset","containerName":"old_subseq","localvar":"my","kind":13},{"name":"$startcount","containerName":"old_subseq","kind":13,"line":588},{"line":589,"name":"$offset","containerName":"old_subseq","kind":13},{"line":590,"containerName":"old_subseq","kind":13,"name":"$self"},{"line":590,"name":"warn","containerName":"old_subseq","kind":12},{"line":591,"containerName":"old_subseq","kind":13,"name":"$seq"},{"containerName":"old_subseq","kind":13,"name":"$length","line":591},{"kind":13,"containerName":"old_subseq","name":"$offset","line":592},{"kind":13,"containerName":"old_subseq","name":"$seqlength","line":592},{"line":593,"kind":13,"containerName":"old_subseq","name":"$self"},{"line":593,"name":"warn","containerName":"old_subseq","kind":12},{"containerName":"old_subseq","kind":13,"name":"$str","line":596},{"line":596,"containerName":"old_subseq","kind":13,"name":"$seq"},{"line":596,"containerName":"old_subseq","kind":13,"name":"$offset"},{"kind":13,"containerName":"old_subseq","name":"$length","line":596},{"line":597,"name":"$str","kind":13,"containerName":"old_subseq"},{"line":597,"kind":13,"containerName":"old_subseq","name":"$length"},{"line":598,"name":"$self","containerName":"old_subseq","kind":13},{"line":598,"name":"warn","containerName":"old_subseq","kind":12},{"name":"$self","kind":13,"containerName":"old_subseq","line":599},{"line":599,"kind":12,"containerName":"old_subseq","name":"verbose"},{"line":601,"name":"$str","containerName":"old_subseq","kind":13}],"containerName":"main::","name":"old_subseq","signature":{"label":"old_subseq($self,$pos1,$pos2,$length)","documentation":" works only inside the transcript, complains if asked outside","parameters":[{"label":"$self"},{"label":"$pos1"},{"label":"$pos2"},{"label":"$length"}]},"line":540,"kind":12,"range":{"start":{"line":540,"character":0},"end":{"character":9999,"line":603}}},{"line":552,"kind":12,"containerName":"length","name":"CORE"},{"line":597,"containerName":"length","kind":12,"name":"CORE"},{"children":[{"definition":"my","kind":13,"localvar":"my","containerName":"start","name":"$self","line":608},{"definition":"my","line":609,"kind":13,"localvar":"my","containerName":"start","name":"$exonsref"},{"name":"$self","kind":13,"containerName":"start","line":609},{"definition":"my","line":610,"localvar":"my","containerName":"start","kind":13,"name":"@exons"},{"name":"$exonsref","containerName":"start","kind":13,"line":610}],"name":"start","containerName":"main::","definition":"sub","line":607,"range":{"end":{"character":9999,"line":610},"start":{"character":0,"line":607}},"kind":12},{"containerName":null,"kind":13,"name":"@exons","line":611},{"line":611,"kind":12,"containerName":"main::","name":"start"},{"name":"end","containerName":"main::","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"end","name":"$self","line":615},{"name":"$exonsref","localvar":"my","containerName":"end","kind":13,"line":616,"definition":"my"},{"name":"$self","kind":13,"containerName":"end","line":616},{"name":"@exons","localvar":"my","containerName":"end","kind":13,"line":617,"definition":"my"},{"line":617,"containerName":"end","kind":13,"name":"$exonsref"}],"definition":"sub","range":{"end":{"line":617,"character":9999},"start":{"line":614,"character":0}},"kind":12,"line":614},{"name":"@exons","kind":13,"containerName":null,"line":618},{"line":618,"name":"end","kind":12,"containerName":"main::"},{"detail":"($self,$label)","definition":"sub","name":"_inside_position","containerName":"main::","children":[{"definition":"my","line":629,"localvar":"my","containerName":"_inside_position","kind":13,"name":"$self"},{"line":629,"kind":13,"containerName":"_inside_position","name":"$label"},{"definition":"my","name":"$start","localvar":"my","containerName":"_inside_position","kind":13,"line":630},{"kind":13,"containerName":"_inside_position","name":"$end","line":630},{"containerName":"_inside_position","kind":13,"name":"$strand","line":630},{"kind":13,"containerName":"_inside_position","name":"$self","line":630},{"line":630,"kind":12,"containerName":"_inside_position","name":"start"},{"kind":13,"containerName":"_inside_position","name":"$self","line":630},{"containerName":"_inside_position","kind":12,"name":"end","line":630},{"containerName":"_inside_position","kind":13,"name":"$self","line":630},{"line":630,"kind":12,"containerName":"_inside_position","name":"strand"},{"definition":"my","containerName":"_inside_position","localvar":"my","kind":13,"name":"$position","line":631},{"kind":13,"containerName":"_inside_position","name":"$checkme","line":631},{"name":"@labels","localvar":"my","containerName":"_inside_position","kind":13,"line":632,"definition":"my"},{"name":"$self","kind":13,"containerName":"_inside_position","line":632},{"kind":12,"containerName":"_inside_position","name":"all_labels","line":632},{"kind":13,"containerName":"_inside_position","name":"$checkme","line":633},{"name":"@labels","kind":13,"containerName":"_inside_position","line":633},{"line":634,"name":"$position","containerName":"_inside_position","kind":13},{"kind":13,"containerName":"_inside_position","name":"$label","line":635},{"containerName":"_inside_position","kind":13,"name":"$checkme","line":635},{"line":636,"kind":13,"containerName":"_inside_position","name":"$position"}],"signature":{"label":"_inside_position($self,$label)","parameters":[{"label":"$self"},{"label":"$label"}],"documentation":" internal methods begin here\n returns: position of label in transcript's all_labels\n          with STARTlabel == 1\n errorcode 0 -> label not found\n argument: label"},"range":{"start":{"character":0,"line":628},"end":{"line":640,"character":9999}},"kind":12,"line":628},{"children":[{"definition":"my","name":"$exon","containerName":"_checkexons","localvar":"my","kind":13,"line":645},{"containerName":"_checkexons","kind":13,"name":"$thisstart","line":645},{"definition":"my","localvar":"my","containerName":"_checkexons","kind":13,"name":"$self","line":646},{"line":646,"name":"$exon","kind":13,"containerName":"_checkexons"},{"definition":"my","line":647,"name":"$exonsref","kind":13,"localvar":"my","containerName":"_checkexons"},{"definition":"my","containerName":"_checkexons","localvar":"my","kind":13,"name":"@exons","line":648},{"containerName":"_checkexons","kind":13,"name":"$exonsref","line":648}],"name":"_checkexons","containerName":"main::","definition":"sub","line":644,"range":{"end":{"character":9999,"line":648},"start":{"character":0,"line":644}},"kind":12},{"definition":"my","name":"$firstexon","localvar":"my","kind":13,"containerName":null,"line":650},{"line":650,"name":"@exons","containerName":null,"kind":13},{"line":652,"name":"%firstexon","containerName":null,"kind":13},{"line":653,"containerName":null,"kind":13,"name":"$self"},{"kind":12,"containerName":"main::","name":"warn","line":653},{"line":656,"kind":13,"localvar":"my","containerName":null,"name":"$strand","definition":"my"},{"containerName":null,"kind":13,"name":"$firstexon","line":656},{"kind":12,"containerName":"main::","name":"strand","line":656},{"line":658,"name":"$prevend","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"line":658,"name":"$firstexon","containerName":null,"kind":13},{"line":658,"kind":12,"containerName":"main::","name":"end"},{"line":659,"name":"@exons","kind":13,"containerName":null},{"line":660,"name":"$exon","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"@exons","line":660},{"containerName":null,"kind":13,"name":"%exon","line":661},{"kind":13,"containerName":null,"name":"$self","line":662},{"containerName":"main::","kind":12,"name":"warn","line":662},{"name":"$exon","kind":13,"containerName":null,"line":665},{"line":665,"containerName":"main::","kind":12,"name":"strand"},{"kind":13,"containerName":null,"name":"%strand","line":665},{"name":"$self","containerName":null,"kind":13,"line":666},{"containerName":"main::","kind":12,"name":"warn","line":666},{"containerName":null,"kind":13,"name":"$thisstart","line":669},{"line":669,"containerName":null,"kind":13,"name":"$exon"},{"name":"start","kind":12,"containerName":"main::","line":669},{"line":670,"name":"%exon","kind":13,"containerName":null},{"line":670,"containerName":"main::","kind":12,"name":"follows"},{"name":"$prevend","kind":13,"containerName":null,"line":670},{"line":670,"name":"$thisstart","kind":13,"containerName":null},{"name":"%strand","kind":13,"containerName":null,"line":670},{"name":"$self","containerName":null,"kind":13,"line":671},{"containerName":"main::","kind":12,"name":"warn","line":671},{"kind":13,"containerName":null,"name":"$prevend","line":674},{"line":674,"name":"$exon","containerName":null,"kind":13},{"line":674,"kind":12,"containerName":"main::","name":"end"},{"line":690,"kind":12,"range":{"start":{"line":690,"character":0},"end":{"line":693,"character":9999}},"children":[{"definition":"my","localvar":"my","containerName":"get_Translation","kind":13,"name":"$self","line":691},{"line":692,"name":"$self","containerName":"get_Translation","kind":13}],"containerName":"main::","name":"get_Translation","definition":"sub"},{"signature":{"label":"_deletecheck($self,$startlabel,$endlabel)","parameters":[{"label":"$self"},{"label":"$startlabel"},{"label":"$endlabel"}],"documentation":" this checks so that deletion spanning multiple exons is\n handled accordingly and correctly\n arguments: begin and end label of a deletion\n this is called BEFORE any deletion in the chain"},"range":{"start":{"line":699,"character":0},"end":{"line":702,"character":9999}},"kind":12,"line":699,"detail":"($self,$startlabel,$endlabel)","definition":"sub","containerName":"main::","name":"_deletecheck","children":[{"name":"$self","localvar":"my","containerName":"_deletecheck","kind":13,"line":700,"definition":"my"},{"line":700,"kind":13,"containerName":"_deletecheck","name":"$startlabel"},{"name":"$endlabel","containerName":"_deletecheck","kind":13,"line":700},{"definition":"my","kind":13,"localvar":"my","containerName":"_deletecheck","name":"$exonsref","line":701},{"line":701,"kind":13,"containerName":"_deletecheck","name":"$self"},{"definition":"my","line":702,"name":"@exons","containerName":"_deletecheck","localvar":"my","kind":13},{"line":702,"name":"$exonsref","containerName":"_deletecheck","kind":13}]},{"name":"$startexon","kind":13,"localvar":"my","containerName":null,"line":703,"definition":"my"},{"kind":13,"containerName":null,"name":"$endexon","line":703},{"line":703,"containerName":null,"kind":13,"name":"$exon"},{"name":"$startexon","containerName":null,"kind":13,"line":704},{"line":704,"name":"$endexon","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$exon","line":705},{"kind":13,"containerName":null,"name":"@exons","line":705},{"kind":13,"containerName":null,"name":"$startexon","line":706},{"kind":13,"containerName":null,"name":"$exon","line":706},{"line":706,"containerName":"main::","kind":12,"name":"valid"},{"line":706,"name":"%startlabel","kind":13,"containerName":null},{"line":707,"kind":13,"containerName":null,"name":"$startexon"},{"containerName":null,"kind":13,"name":"$exon","line":707},{"name":"$endexon","kind":13,"containerName":null,"line":709},{"name":"$exon","kind":13,"containerName":null,"line":709},{"line":709,"name":"valid","kind":12,"containerName":"main::"},{"name":"%endlabel","containerName":null,"kind":13,"line":709},{"containerName":null,"kind":13,"name":"$endexon","line":710},{"kind":13,"containerName":null,"name":"$exon","line":710},{"line":712,"kind":13,"containerName":null,"name":"$startexon"},{"containerName":null,"kind":13,"name":"%endexon","line":712},{"definition":"my","name":"$nextend","localvar":"my","kind":13,"containerName":null,"line":716},{"containerName":null,"kind":13,"name":"$self","line":716},{"line":716,"containerName":"main::","kind":12,"name":"label"},{"kind":13,"containerName":null,"name":"$endlabel","line":716},{"definition":"my","name":"$prevstart","kind":13,"localvar":"my","containerName":null,"line":717},{"containerName":null,"kind":13,"name":"$self","line":717},{"name":"label","containerName":"main::","kind":12,"line":717},{"line":717,"name":"$startlabel","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$startexon","line":719},{"name":"%endexon","kind":13,"containerName":null,"line":719},{"kind":13,"containerName":null,"name":"$startexon","line":720},{"line":720,"name":"start","kind":12,"containerName":"main::"},{"line":720,"name":"$startlabel","containerName":null,"kind":13},{"name":"$startexon","kind":13,"containerName":null,"line":720},{"containerName":"main::","kind":12,"name":"end","line":720},{"line":720,"name":"%endlabel","containerName":null,"kind":13},{"localvar":"my","kind":13,"containerName":null,"name":"@newexons","line":722,"definition":"my"},{"line":723,"containerName":null,"kind":13,"name":"$exon"},{"name":"@exons","containerName":null,"kind":13,"line":723},{"name":"$exon","kind":13,"containerName":null,"line":724},{"name":"%startexon","containerName":null,"kind":13,"line":724},{"containerName":null,"kind":13,"name":"@newexons","line":725},{"line":725,"containerName":null,"kind":13,"name":"$exon"},{"name":"%self","containerName":null,"kind":13,"line":728},{"kind":13,"containerName":null,"name":"@newexons","line":728},{"line":729,"containerName":null,"kind":13,"name":"$startexon"},{"line":729,"containerName":"main::","kind":12,"name":"start"},{"line":729,"containerName":null,"kind":13,"name":"%startlabel"},{"name":"%startexon","containerName":null,"kind":13,"line":730},{"kind":13,"containerName":null,"name":"$nextend","line":730},{"name":"$startexon","kind":13,"containerName":null,"line":731},{"containerName":"main::","kind":12,"name":"end","line":731},{"containerName":null,"kind":13,"name":"%endlabel","line":731},{"name":"%startexon","kind":13,"containerName":null,"line":732},{"name":"%prevstart","kind":13,"containerName":null,"line":732},{"name":"@newexons","localvar":"my","kind":13,"containerName":null,"line":737,"definition":"my"},{"definition":"my","line":738,"localvar":"my","kind":13,"containerName":null,"name":"$exonobj"},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"$dna","line":739},{"line":739,"kind":13,"containerName":null,"name":"%self"},{"definition":"my","line":740,"name":"$strand","localvar":"my","containerName":null,"kind":13},{"name":"$self","containerName":null,"kind":13,"line":740},{"line":740,"name":"strand","containerName":"main::","kind":12},{"line":741,"kind":13,"localvar":"my","containerName":null,"name":"$notmiddle","definition":"my"},{"line":742,"kind":13,"containerName":null,"name":"$exon"},{"line":742,"name":"@exons","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$exon","line":743},{"line":743,"name":"%startexon","kind":13,"containerName":null},{"line":744,"name":"$exonobj","containerName":null,"kind":13},{"line":744,"name":"Bio","kind":12,"containerName":"LiveSeq::Exon"},{"name":"new","kind":12,"containerName":"main::","line":744},{"name":"$dna","kind":13,"containerName":null,"line":744},{"line":744,"name":"$exon","containerName":null,"kind":13},{"line":744,"name":"start","containerName":"main::","kind":12},{"name":"$prevstart","kind":13,"containerName":null,"line":744},{"kind":13,"containerName":null,"name":"$strand","line":744},{"line":745,"name":"@newexons","containerName":null,"kind":13},{"line":745,"kind":13,"containerName":null,"name":"$exonobj"},{"line":746,"name":"$notmiddle","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$exon","line":747},{"containerName":null,"kind":13,"name":"%endexon","line":747},{"name":"$exonobj","kind":13,"containerName":null,"line":748},{"name":"Bio","kind":12,"containerName":"LiveSeq::Exon","line":748},{"line":748,"kind":12,"containerName":"main::","name":"new"},{"line":748,"name":"$dna","containerName":null,"kind":13},{"line":748,"containerName":null,"kind":13,"name":"$nextend"},{"line":748,"name":"$exon","containerName":null,"kind":13},{"containerName":"main::","kind":12,"name":"end","line":748},{"kind":13,"containerName":null,"name":"$strand","line":748},{"name":"@newexons","kind":13,"containerName":null,"line":749},{"line":749,"kind":13,"containerName":null,"name":"$exonobj"},{"line":750,"name":"%notmiddle","containerName":null,"kind":13},{"line":752,"name":"%notmiddle","kind":13,"containerName":null},{"name":"@newexons","containerName":null,"kind":13,"line":753},{"line":753,"name":"$exon","containerName":null,"kind":13},{"name":"%self","kind":13,"containerName":null,"line":757},{"containerName":null,"kind":13,"name":"@newexons","line":757},{"line":773,"range":{"start":{"character":0,"line":773},"end":{"character":9999,"line":783}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Transcript.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Transcript\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Transcript - Transcript class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis stores informations about coding sequences (CDS).\nThe implementation is that a Transcript object accesses a collection of\nExon objects, inferring from them the nucleotide structure and sequence.\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Transcript;\n\nuse strict;\n# use Carp qw(carp cluck);\nuse Bio::LiveSeq::Exon; # uses Exon to create new exon in case of deletion\nuse base qw(Bio::LiveSeq::SeqI);\n\n=head2 new\n\n  Title   : new\n  Usage   : $transcript = Bio::LiveSeq::Transcript->new(-exons => \\@obj_refs);\n\n  Function: generates a new Bio::LiveSeq::Transcript\n  Returns : reference to a new object of class Transcript\n  Errorcode -1\n  Args    : reference to an array of Exon object references\n\n\nsub new {\n  my ($thing, %args) = @_;\n  my $class = ref($thing) || $thing;\n  my ($obj,%transcript);\n\n  my @exons=@{$args{-exons}};\n\n  $obj = \\%transcript;\n  $obj = bless $obj, $class;\n\n  unless (@exons) {\n    $obj->warn(\"$class not initialised because exons array empty\");\n    return(-1);\n  }\n\n  # now useless, after start and end methods have been overridden here\n  my $firstexon = $exons[0];\n  #my $lastexon = $exons[-1];\n  #my $start = $firstexon->start;\n  #my $end = $lastexon->end;\n  my $strand = $firstexon->strand;\n  my $seq = $firstexon->{'seq'};\n  $obj->alphabet('rna');\n\n  unless (_checkexons(\\@exons)) {\n    $obj->warn(\"$class not initialised because of problems in the exon structure\");\n    return(-1);\n  }\n  $obj->{'strand'}=$strand;\n  $obj->{'exons'}=\\@exons;\n  $obj->{'seq'}=$seq;\n\n  # set Transcript into each Exon\n  my $exon;\n  foreach $exon (@exons) {\n    $exon->{'transcript'}=$obj;\n  }\n  return $obj;\n}\n\n\n=head2 all_Exons\n\n Title   : all_Exons\n Usage   : $transcript_obj->all_Exons()\n Function: returns references to all Exon objects the Transcript is composed of\n Example : foreach $exon ($transcript->all_Exons()) { do_something }\n Returns : array of object references\n Args    : none\n\n\nsub all_Exons {\n  my $self=shift;\n  my $exonsref=$self->{'exons'};\n  my @exons=@{$exonsref};\n  my @newexons;\n  my $exon;\n  foreach $exon (@exons) {\n    unless ($exon->obj_valid) {\n      $self->warn(\"$exon no more valid, start or end label lost, skipping....\",1); # ignorable\n    } else {\n      push(@newexons,$exon);\n    }\n  }\n  if ($#exons != $#newexons) {\n    # update exons field\n    $self->{'exons'}=\\@newexons;\n  }\n  return (@newexons);\n}\n\n=head2 downstream_seq\n\n Title   : downstream_seq\n Usage   : $transcript_obj->downstream_seq()\n         : $transcript_obj->downstream_seq(64)\n Function: returns a string of nucleotides downstream of the end of the\n           CDS. If there is some information of the real mRNA, from features in\n           an attached Gene object, it will return up to those boundaries.\n           Otherwise it will return 1000 nucleotides.\n           If an argument is given it will override the default 1000 number\n           and return instead /that/ requested number of nucleotides.\n           But if a Gene object is attached, this argument will be ignored.\n Returns : string\n Args    : an optional integer number of nucleotides to be returned instead of\n           the default if no gene attached\n\n\nsub downstream_seq {\n  my ($self,$howmany)=@_;\n  my $str;\n  if (defined ($howmany)) {\n    unless ($howmany > 0) {\n      $self->throw(\"No sense in asking less than 1 downstream nucleotides!\");\n    }\n  } else {\n    unless ($self->{'seq'}->alphabet eq 'rna') { # if rna retrieve until the end\n      #$str=$DNAobj->labelsubseq($self->end,undef,undef,\"unsecuremoderequested\");\n      #return(substr($str,1)); # delete first nucleotide that is the last of Transcript\n      if ($self->gene) { # if there is Gene object attached fetch relevant info\n\t$str=$self->{'seq'}->labelsubseq($self->end,undef,$self->gene->maxtranscript->end); # retrieve from end of this Transcript to end of the maxtranscript\n\t$str=substr($str,1); # delete first nucleotide that is the last of Transcript\n\tif (CORE::length($str) > 0) {\n\t  return($str);\n\t} else { # if there was no downstream through the gene's maxtranscript, go the usual way\n\t  $howmany = 1000;\n\t}\n      } else {\n\t$howmany = 1000;\n      }\n    }\n  }\n  my @exons=$self->all_Exons;\n  my $strand=$self->strand();\n  my $lastexon=$exons[-1];\n  my $lastexonlength=$lastexon->length;\n  # $howmany nucs after end of last exon\n  #my $downstream_seq=$lastexon->subseq($lastexonlength+1,undef,$howmany);\n  my $downstream_seq;\n\n  if ($howmany) {\n      $downstream_seq=substr($lastexon->labelsubseq($self->end,$howmany,undef,\"unsecuremoderequested\"),1);\n  } else {\n    if ($strand == 1) {\n      $downstream_seq=substr($lastexon->labelsubseq($self->end,undef,$self->{'seq'}->end,\"unsecuremoderequested\"),1);\n    } else {\n      $downstream_seq=substr($lastexon->labelsubseq($self->end,undef,$self->{'seq'}->start,\"unsecuremoderequested\"),1);\n    }\n  }\n  return $downstream_seq;\n}\n\n=head2 upstream_seq\n\n Title   : upstream_seq\n Usage   : $transcript_obj->upstream_seq()\n         : $transcript_obj->upstream_seq(64)\n Function: just like downstream_seq but returns nucleotides before the ATG\n Note    : the default, if no Gene information present and no nucleotides\n           number given, is to return up to 400 nucleotides.\n\n\nsub upstream_seq {\n  my ($self,$howmany)=@_;\n  if (defined ($howmany)) {\n    unless ($howmany > 0) {\n      $self->throw(\"No sense in asking less than 1 upstream nucleotides!\");\n    }\n  } else {\n    unless ($self->{'seq'}->alphabet eq 'rna') { # if rna retrieve from the start\n      if ($self->gene) { # if there is Gene object attached fetch relevant info\n\tmy $str=$self->{'seq'}->labelsubseq($self->gene->maxtranscript->start,undef,$self->start); # retrieve from start of maxtranscript to start of this Transcript\n\tchop $str; # delete last nucleotide that is the A of starting ATG\n\tif (length($str) > 0) {\n\t  return($str);\n\t} else { # if there was no upstream through the gene's maxtranscript, go the usual way\n\t  $howmany = 400;\n\t}\n      } else {\n\t$howmany = 400;\n      }\n    }\n  }\n  my @exons=$self->all_Exons;\n  my $firstexon=$exons[0];\n  \n  my $upstream_seq;\n  my $strand=$self->strand();\n\n  if ($howmany) {# $howmany nucs before begin of first exon\n    my $labelbefore=$firstexon->label(-$howmany,$firstexon->start);\n    if ($labelbefore < 1) {\n      if ($strand == 1) {\n\t$labelbefore=$self->{'seq'}->start;\n      } else {\n\t$labelbefore=$self->{'seq'}->end;\n      }\n    }\n    $upstream_seq=$firstexon->labelsubseq($labelbefore,undef,$firstexon->start,\"unsecuremoderequested\");\n    chop $upstream_seq;\n  } else {\n    if ($strand == 1) {\n      $upstream_seq=$firstexon->labelsubseq($self->{'seq'}->start,undef,$self->start,\"unsecuremoderequested\");\n      chop $upstream_seq; # delete last nucleotide that is the A of starting ATG\n    } else {\n      $upstream_seq=$firstexon->labelsubseq($self->{'seq'}->end,undef,$self->start,\"unsecuremoderequested\");\n      chop $upstream_seq; # delete last nucleotide that is the A of starting ATG\n    }\n  }\n  return $upstream_seq;\n}\n\n# These get redefined here, overriding the SeqI one because they draw their\n# information from the Exons a Transcript is built of\n# optional argument: firstlabel. If not given, it checks coordinate_start\n#                                This is useful when called by Translation\n#                                also used by _delete\nsub label {\n  my ($self,$position,$firstlabel)=@_;\n  unless ($position) {  # if position = 0 complain ?\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  my ($label,@labels,$length,$arraypos);\n  unless (defined ($firstlabel)) {\n    $firstlabel=$self->coordinate_start; # this is inside Transcript obj\n  }\n  my $coord_pos=$self->_inside_position($firstlabel);\n  $length=$self->length;\n  #if ($strand == 1) {\n    if ($position < 1) {\n      $position++; # to account for missing of 0 position\n    }\n    $arraypos=$position+$coord_pos-2;\n    #print \"\\n=-=-=-=-DEBUG: arraypos $arraypos, pos $position, coordpos: $coord_pos\";\n    if ($arraypos < 0) {\n      $label=$self->{'seq'}->label($arraypos,$start,$strand); #?\n    } elsif ($arraypos >= $length) {\n      $label=$self->{'seq'}->label($arraypos-$length+2,$end,$strand); #?\n    } else { # inside the Transcript\n      @labels=$self->all_labels;\n      $label=$labels[$arraypos];\n    }\n  #}\n}\n\n# argument: label\n# returns: position of label according to coord_start\n# errorcode: 0 label not found\n# optional argument: firstlabel. If not given, it checks coordinate_start\n#                                This is useful when called by Translation\nsub position {\n  my ($self,$label,$firstlabel)=@_;\n  unless ($self->{'seq'}->valid($label)) {\n    $self->warn(\"label is not valid\");\n    return (0);\n  }\n  unless (defined ($firstlabel)) {\n    $firstlabel=$self->coordinate_start; # this is inside Transcript obj\n  }\n  if ($label == $firstlabel) {\n    return (1);\n  }\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  my ($position,$in_pos,$out_pos,$coord_pos);\n  my $length=$self->length;\n  $coord_pos=$self->_inside_position($firstlabel);\n  if ($self->valid($label)) { # if label is inside the Transcript\n    $in_pos=$self->_inside_position($label);\n    $position=$in_pos-$coord_pos+1;\n    if ($position <= 0) {\n      return ($position-1); # accounts for the missing of the 0 position\n    }\n  } else {\n    if ($self->follows($end,$label)) { # label after end of transcript\n      $out_pos=$self->{'seq'}->position($label,$end,$strand);\n      #print \"\\n+++++++++DEBUG label $label FOLLOWS end $end outpos $out_pos coordpos $coord_pos\";\n      $position=$out_pos+$length-$coord_pos;\n    } elsif ($self->follows($label,$start)) { # label before begin of transcript\n      #print \"\\n+++++++++DEBUG label $label BEFORE start $start outpos $out_pos coordpos $coord_pos\";\n      $out_pos=$self->{'seq'}->position($label,$start,$strand);\n      $position=$out_pos-$coord_pos+1;\n    } else { # label is in intron (not valid, not after, not before)!\n      $self->warn(\"Cannot give position of label pointing to intron according to CDS numbering!\",1);\n      return (0);\n    }\n  }\n  return ($position);\n}\n\nsub seq {\n  my $self=shift;\n  my ($exon,$str);\n  my @exons=$self->all_Exons();\n  foreach $exon (@exons) {\n    $str .= $exon->seq();\n  }\n  return $str;\n}\n\nsub length {\n  my $self=shift;\n  my ($exon,$length);\n  my @exons=$self->all_Exons();\n  foreach $exon (@exons) {\n    $length += $exon->length();\n  }\n  return $length;\n}\n\nsub all_labels {\n  my $self=shift;\n  my ($exon,@labels);\n  my @exons=$self->all_Exons();\n  foreach $exon (@exons) {\n    push (@labels,$exon->all_labels());\n  }\n  return @labels;\n}\n\n# redefined here so that it will retrieve effective subseq without introns\n# otherwise it would have retrieved an underlying DNA (possibly with introns)\n# subsequence\n# Drawback: this is really bulky, label->position and then a call to\n# subseq that will do the opposite position-> label\n#\n# one day this can be rewritten as the main one so that the normal subseq\n# will rely on this one and hence avoid this double (useless and lengthy)\n# conversion between labels and positions\nsub old_labelsubseq {\n  my ($self,$start,$length,$end)=@_;\n  my ($pos1,$pos2);\n  if ($start) {\n    unless ($self->valid($start)) {\n      $self->warn(\"Start label not valid\"); return (-1);\n    }\n    $pos1=$self->position($start);\n  }\n  if ($end) {\n    if ($end == $start) {\n      $length=1;\n    } else {\n      unless ($self->valid($end)) {\n\t$self->warn(\"End label not valid\"); return (-1);\n      }\n      unless ($self->follows($start,$end) == 1) {\n\t$self->warn(\"End label does not follow Start label!\"); return (-1);\n      }\n      $pos2=$self->position($end);\n      undef $length;\n    }\n  }\n  return ($self->subseq($pos1,$pos2,$length));\n}\n\n# rewritten, eventually\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode)=@_;\n  unless (defined $unsecuremode && \n\t  $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    if ($start) {\n      unless ($self->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    } else {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length; # end argument overrides length argument\n\tunless ($self->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n      }\n    } else {\n      $end=$self->end;\n    }\n  }\n  my ($seq,$exon,$startexon,$endexon); my @exonlabels;\n  my @exons=$self->all_Exons;\n  EXONCHECK:\n  foreach $exon (@exons) {\n    if ((!(defined($startexon)))&&($exon->valid($start))) { # checks only if not yet found\n      $startexon=$exon;\n    }\n    if ($exon->valid($end)) {\n      $endexon=$exon;\n    }\n    if ((!(defined($seq)) && (defined($startexon)))) { # initializes only once\n      if ((defined($endexon)) && ($endexon eq $startexon)) { # then perfect, we are finished\n\tif ($length) {\n\t  $seq = $startexon->labelsubseq($start,$length,undef,\"unsecuremoderequested\");\n\n\n\t  last EXONCHECK;\n\t} else {\n\t  $seq = $startexon->labelsubseq($start,undef,$end,\"unsecuremoderequested\");\n\t}\n\tlast EXONCHECK;\n      } else { # get up to the end of the exon\n\t$seq = $startexon->labelsubseq($start,undef,undef,\"unsecuremoderequested\");\n      }\n    }\n    if (($startexon)&&($exon ne $startexon)) {\n      if (defined($endexon)) { # we arrived to the last exon\n\t$seq .= $endexon->labelsubseq(undef,undef,$end,\"unsecuremoderequested\"); # get from the start of the exon\n\tlast EXONCHECK;\n\n      } elsif (defined($startexon)) { # we are in a whole-exon-in-the-middle case\n\t  $seq .= $exon->seq; # we add it completely to the seq\n      } # else, we still have to reach the start point, exon useless, we move on\n      if ($length) { # if length argument specified\n\tif (($seq && (CORE::length($seq) >= $length))) {\n\t  last EXONCHECK;\n\t}\n      }\n    }\n  }\n  if ($length) {\n    return (substr($seq,0,$length));\n  } else {\n    return ($seq);\n  }\n}\n\n\n# argument: label\n# returns: the objref and progressive number of the Exon containing that label\n# errorcode: -1\nsub in_which_Exon {\n  my ($self,$label)=@_;\n  my ($count,$exon);\n  my @exons=$self->all_Exons;\n  foreach $exon (@exons) {\n    $count++; # 1st exon is numbered \"1\"\n    if ($exon->valid($label)) {\n      return ($exon,$count)\n    }\n  }\n  return (-1); # if nothing found\n}\n\n# recoded to exploit the new fast labelsubseq()\n# valid only inside Transcript\nsub subseq {\n  my ($self,$pos1,$pos2,$length) = @_;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($pos1)) {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    if ((defined ($pos2))&&($pos1>$pos2)) {\n      $self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n    }\n    $startlabel=$self->label($pos1);\n    unless ($self->valid($startlabel)) {\n      $self->warn(\"Start label not valid\"); return (-1);\n    }\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  } else {\n    $startlabel=$self->start;\n  }\n  if (defined ($pos2)) {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    if ((defined ($pos1))&&($pos1>$pos2)) {\n      $self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n    }\n    $endlabel=$self->label($pos2);\n    unless ($self->valid($endlabel)) {\n      $self->warn(\"End label not valid\"); return (-1);\n    }\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  } else {\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  }\n  return ($self->labelsubseq($startlabel,$length,$endlabel,\"unsecuremoderequested\"));\n}\n\n# works only inside the transcript, complains if asked outside\nsub old_subseq {\n  my ($self,$pos1,$pos2,$length) = @_;\n  my ($str,$startcount,$endcount,$seq,$seqlength);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  my $firstlabel=$self->coordinate_start; # this is inside Transcript obj\n  my $coord_pos=$self->_inside_position($firstlabel); # TESTME old\n  $seq=$self->seq;\n  $seqlength=CORE::length($seq);\n  unless (defined ($pos1)) {\n    $startcount=1+$coord_pos-1; # i.e. coord_pos\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    } elsif ($pos1 < 0) {\n      $pos1++;\n    }\n    if ((defined ($pos2))&&($pos1>$pos2)) {\n      $self->warn(\"1st position ($pos1) cannot be > 2nd position ($pos2)!\");\n      return (-1);\n    }\n    $startcount=$pos1+$coord_pos-1;\n  }\n  unless (defined ($pos2)) {\n  ;\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    } elsif ($pos2 < 0) {\n      $pos2++;\n    }\n    if ((defined ($pos1))&&($pos1>$pos2)) {\n      $self->warn(\"1st position ($pos1) cannot be > 2nd position ($pos2)!\");\n      return (-1);\n    }\n    $endcount=$pos2+$coord_pos-1;\n    if ($endcount > $seqlength) {\n      #print \"\\n###DEBUG###: pos1 $pos1 pos2 $pos2 coordpos $coord_pos endcount $endcount seqln $seqlength\\n\";\n      $self->warn(\"Cannot access end position after the end of Transcript\");\n      return (-1);\n    }\n    $length=$endcount-$startcount+1;\n  }\n  #print \"\\n###DEBUG pos1 $pos1 pos2 $pos2 start $startcount end $endcount length $length coordpos $coord_pos\\n\";\n  my $offset=$startcount-1;\n  if ($offset < 0) {\n    $self->warn(\"Cannot access startposition before the beginning of Transcript, returning from start\",1); # ignorable\n    return (substr($seq,0,$length));\n  } elsif ($offset >= $seqlength) {\n    $self->warn(\"Cannot access startposition after the end of Transcript\");\n    return (-1);\n  } else {\n    $str=substr($seq,$offset,$length);\n    if (CORE::length($str) < $length) {\n      $self->warn(\"Attention, cannot return the length requested \".\n\t\t  \"for subseq\",1) if $self->verbose > 0; # ignorable\n    }\n    return $str;\n  }\n}\n\n# redefined so that it doesn't require other methods (after deletions) to\n# reset it.\nsub start {\n  my $self = shift;\n  my $exonsref=$self->{'exons'};\n  my @exons=@{$exonsref};\n  return ($exons[0]->start);\n}\n\nsub end {\n  my $self = shift;\n  my $exonsref=$self->{'exons'};\n  my @exons=@{$exonsref};\n  return ($exons[-1]->end);\n}\n\n\n# internal methods begin here\n\n# returns: position of label in transcript's all_labels\n#          with STARTlabel == 1\n# errorcode 0 -> label not found\n# argument: label\nsub _inside_position {\n  my ($self,$label)=@_;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  my ($position,$checkme);\n  my @labels=$self->all_labels;\n  foreach $checkme (@labels) {\n    $position++;\n    if ($label == $checkme) {\n      return ($position);\n    }\n  }\n  return (0);\n}\n\n# returns 1 OK or 0 ERROR\n# arguments: reference to array of Exon object references\nsub _checkexons {\n  my ($exon,$thisstart);\n  my $self=$exon;\n  my $exonsref=$_[0];\n  my @exons=@{$exonsref};\n\n  my $firstexon = $exons[0];\n\n  unless (ref($firstexon) eq \"Bio::LiveSeq::Exon\") {\n    $self->warn(\"Object not of class Exon\");\n    return (0);\n  }\n  my $strand = $firstexon->strand;\n\n  my $prevend = $firstexon->end;\n  shift @exons; # skip first one\n  foreach $exon (@exons) {\n    unless (ref($exon) eq \"Bio::LiveSeq::Exon\") { # object class check\n      $self->warn(\"Object not of class Exon\");\n      return (0);\n    }\n    if ($exon->strand != $strand) { # strand consistency check\n      $self->warn(\"Exons' strands not consistent when trying to create Transcript\");\n      return (0);\n    }\n    $thisstart = $exon->start;\n    unless ($exon->{'seq'}->follows($prevend,$thisstart,$strand)) {\n      $self->warn(\"Exons not in correct order when trying to create Transcript\");\n      return (0);\n    }\n    $prevend = $exon->end;\n  }\n  return (1);\n}\n\n=head2 get_Translation\n\n  Title   : valid\n  Usage   : $translation = $obj->get_Translation()\n  Function: retrieves the reference to the object of class Translation (if any)\n            attached to a LiveSeq object\n  Returns : object reference\n  Args    : none\n\n\nsub get_Translation {\n  my $self=shift;\n  return ($self->{'translation'}); # this is set when Translation->new is called\n}\n\n# this checks so that deletion spanning multiple exons is\n# handled accordingly and correctly\n# arguments: begin and end label of a deletion\n# this is called BEFORE any deletion in the chain\nsub _deletecheck {\n  my ($self,$startlabel,$endlabel)=@_;\n  my $exonsref=$self->{'exons'};\n  my @exons=@{$exonsref};\n  my ($startexon,$endexon,$exon);\n  $startexon=$endexon=0;\n  foreach $exon (@exons) {\n    if (($startexon == 0)&&($exon->valid($startlabel))) {\n      $startexon=$exon; # exon containing start of deletion\n    }\n    if (($endexon == 0)&&($exon->valid($endlabel))) {\n      $endexon=$exon; # exon containing end of deletion\n    }\n    if (($startexon)&&($endexon)) {\n      last; # don't check further\n    }\n  }\n  my $nextend=$self->label(2,$endlabel); # retrieve the next label\n  my $prevstart=$self->label(-1,$startlabel); # retrieve the prev label\n\n  if ($startexon eq $endexon) { # intra-exon deletion\n    if (($startexon->start eq $startlabel) && ($startexon->end eq $endlabel)) {\n      # let's delete the entire exon\n      my @newexons;\n      foreach $exon (@exons) {\n\tunless ($exon eq $startexon) {\n\t  push(@newexons,$exon);\n\t}\n      }\n      $self->{'exons'}=\\@newexons;\n    } elsif ($startexon->start eq $startlabel) { # special cases\n      $startexon->{'start'}=$nextend; # set a new start of exon\n    } elsif ($startexon->end eq $endlabel) {\n      $startexon->{'end'}=$prevstart; # set a new end of exon\n    } else {\n      return; # no problem\n    }\n  } else { # two new exons to be created, inter-exons deletion\n    my @newexons;\n    my $exonobj;\n    my $dna=$self->{'seq'};\n    my $strand=$self->strand;\n    my $notmiddle=1; # flag for skipping exons in the middle of deletion\n    foreach $exon (@exons) {\n      if ($exon eq $startexon) {\n\t$exonobj=Bio::LiveSeq::Exon->new('-seq'=>$dna,'-start'=>$exon->start,'-end'=>$prevstart,'-strand'=>$strand); # new partial exon\n\tpush(@newexons,$exonobj);\n\t$notmiddle=0; # now we enter totally deleted exons\n      } elsif ($exon eq $endexon) {\n\t$exonobj=Bio::LiveSeq::Exon->new('-seq'=>$dna,'-start'=>$nextend,'-end'=>$exon->end,'-strand'=>$strand); # new partial exon\n\tpush(@newexons,$exonobj);\n\t$notmiddle=1; # exiting totally deleted exons\n      } else {\n\tif ($notmiddle) { # if before or after exons with deletion\n\t  push(@newexons,$exon); \n\t}# else skip them\n      }\n    }\n    $self->{'exons'}=\\@newexons;\n  }\n}\n\n=head2 translation_table\n\n Title   : translation_table\n Usage   : $name = $obj->translation_table;\n         : $name = $obj->translation_table(11);\n Function: Returns or sets the translation_table used for translating the\n           transcript.\n           If it has never been set, it will return undef.\n Returns : an integer","label":"translation_table($self,$value)"},"children":[{"definition":"my","line":774,"name":"$self","localvar":"my","kind":13,"containerName":"translation_table"},{"line":774,"containerName":"translation_table","kind":13,"name":"$value"},{"line":775,"name":"$value","containerName":"translation_table","kind":13},{"containerName":"translation_table","kind":13,"name":"$self","line":776},{"name":"$value","containerName":"translation_table","kind":13,"line":776},{"name":"$self","kind":13,"containerName":"translation_table","line":778},{"name":"$self","kind":13,"containerName":"translation_table","line":781}],"name":"translation_table","containerName":"main::","definition":"sub","detail":"($self,$value)"},{"signature":{"documentation":"1;\n# $Id: Transcript.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Transcript\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Transcript - Transcript class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis stores informations about coding sequences (CDS).\nThe implementation is that a Transcript object accesses a collection of\nExon objects, inferring from them the nucleotide structure and sequence.\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Transcript;\n\nuse strict;\n# use Carp qw(carp cluck);\nuse Bio::LiveSeq::Exon; # uses Exon to create new exon in case of deletion\nuse base qw(Bio::LiveSeq::SeqI);\n\n=head2 new\n\n  Title   : new\n  Usage   : $transcript = Bio::LiveSeq::Transcript->new(-exons => \\@obj_refs);\n\n  Function: generates a new Bio::LiveSeq::Transcript\n  Returns : reference to a new object of class Transcript\n  Errorcode -1\n  Args    : reference to an array of Exon object references\n\n\nsub new {\n  my ($thing, %args) = @_;\n  my $class = ref($thing) || $thing;\n  my ($obj,%transcript);\n\n  my @exons=@{$args{-exons}};\n\n  $obj = \\%transcript;\n  $obj = bless $obj, $class;\n\n  unless (@exons) {\n    $obj->warn(\"$class not initialised because exons array empty\");\n    return(-1);\n  }\n\n  # now useless, after start and end methods have been overridden here\n  my $firstexon = $exons[0];\n  #my $lastexon = $exons[-1];\n  #my $start = $firstexon->start;\n  #my $end = $lastexon->end;\n  my $strand = $firstexon->strand;\n  my $seq = $firstexon->{'seq'};\n  $obj->alphabet('rna');\n\n  unless (_checkexons(\\@exons)) {\n    $obj->warn(\"$class not initialised because of problems in the exon structure\");\n    return(-1);\n  }\n  $obj->{'strand'}=$strand;\n  $obj->{'exons'}=\\@exons;\n  $obj->{'seq'}=$seq;\n\n  # set Transcript into each Exon\n  my $exon;\n  foreach $exon (@exons) {\n    $exon->{'transcript'}=$obj;\n  }\n  return $obj;\n}\n\n\n=head2 all_Exons\n\n Title   : all_Exons\n Usage   : $transcript_obj->all_Exons()\n Function: returns references to all Exon objects the Transcript is composed of\n Example : foreach $exon ($transcript->all_Exons()) { do_something }\n Returns : array of object references\n Args    : none\n\n\nsub all_Exons {\n  my $self=shift;\n  my $exonsref=$self->{'exons'};\n  my @exons=@{$exonsref};\n  my @newexons;\n  my $exon;\n  foreach $exon (@exons) {\n    unless ($exon->obj_valid) {\n      $self->warn(\"$exon no more valid, start or end label lost, skipping....\",1); # ignorable\n    } else {\n      push(@newexons,$exon);\n    }\n  }\n  if ($#exons != $#newexons) {\n    # update exons field\n    $self->{'exons'}=\\@newexons;\n  }\n  return (@newexons);\n}\n\n=head2 downstream_seq\n\n Title   : downstream_seq\n Usage   : $transcript_obj->downstream_seq()\n         : $transcript_obj->downstream_seq(64)\n Function: returns a string of nucleotides downstream of the end of the\n           CDS. If there is some information of the real mRNA, from features in\n           an attached Gene object, it will return up to those boundaries.\n           Otherwise it will return 1000 nucleotides.\n           If an argument is given it will override the default 1000 number\n           and return instead /that/ requested number of nucleotides.\n           But if a Gene object is attached, this argument will be ignored.\n Returns : string\n Args    : an optional integer number of nucleotides to be returned instead of\n           the default if no gene attached\n\n\nsub downstream_seq {\n  my ($self,$howmany)=@_;\n  my $str;\n  if (defined ($howmany)) {\n    unless ($howmany > 0) {\n      $self->throw(\"No sense in asking less than 1 downstream nucleotides!\");\n    }\n  } else {\n    unless ($self->{'seq'}->alphabet eq 'rna') { # if rna retrieve until the end\n      #$str=$DNAobj->labelsubseq($self->end,undef,undef,\"unsecuremoderequested\");\n      #return(substr($str,1)); # delete first nucleotide that is the last of Transcript\n      if ($self->gene) { # if there is Gene object attached fetch relevant info\n\t$str=$self->{'seq'}->labelsubseq($self->end,undef,$self->gene->maxtranscript->end); # retrieve from end of this Transcript to end of the maxtranscript\n\t$str=substr($str,1); # delete first nucleotide that is the last of Transcript\n\tif (CORE::length($str) > 0) {\n\t  return($str);\n\t} else { # if there was no downstream through the gene's maxtranscript, go the usual way\n\t  $howmany = 1000;\n\t}\n      } else {\n\t$howmany = 1000;\n      }\n    }\n  }\n  my @exons=$self->all_Exons;\n  my $strand=$self->strand();\n  my $lastexon=$exons[-1];\n  my $lastexonlength=$lastexon->length;\n  # $howmany nucs after end of last exon\n  #my $downstream_seq=$lastexon->subseq($lastexonlength+1,undef,$howmany);\n  my $downstream_seq;\n\n  if ($howmany) {\n      $downstream_seq=substr($lastexon->labelsubseq($self->end,$howmany,undef,\"unsecuremoderequested\"),1);\n  } else {\n    if ($strand == 1) {\n      $downstream_seq=substr($lastexon->labelsubseq($self->end,undef,$self->{'seq'}->end,\"unsecuremoderequested\"),1);\n    } else {\n      $downstream_seq=substr($lastexon->labelsubseq($self->end,undef,$self->{'seq'}->start,\"unsecuremoderequested\"),1);\n    }\n  }\n  return $downstream_seq;\n}\n\n=head2 upstream_seq\n\n Title   : upstream_seq\n Usage   : $transcript_obj->upstream_seq()\n         : $transcript_obj->upstream_seq(64)\n Function: just like downstream_seq but returns nucleotides before the ATG\n Note    : the default, if no Gene information present and no nucleotides\n           number given, is to return up to 400 nucleotides.\n\n\nsub upstream_seq {\n  my ($self,$howmany)=@_;\n  if (defined ($howmany)) {\n    unless ($howmany > 0) {\n      $self->throw(\"No sense in asking less than 1 upstream nucleotides!\");\n    }\n  } else {\n    unless ($self->{'seq'}->alphabet eq 'rna') { # if rna retrieve from the start\n      if ($self->gene) { # if there is Gene object attached fetch relevant info\n\tmy $str=$self->{'seq'}->labelsubseq($self->gene->maxtranscript->start,undef,$self->start); # retrieve from start of maxtranscript to start of this Transcript\n\tchop $str; # delete last nucleotide that is the A of starting ATG\n\tif (length($str) > 0) {\n\t  return($str);\n\t} else { # if there was no upstream through the gene's maxtranscript, go the usual way\n\t  $howmany = 400;\n\t}\n      } else {\n\t$howmany = 400;\n      }\n    }\n  }\n  my @exons=$self->all_Exons;\n  my $firstexon=$exons[0];\n  \n  my $upstream_seq;\n  my $strand=$self->strand();\n\n  if ($howmany) {# $howmany nucs before begin of first exon\n    my $labelbefore=$firstexon->label(-$howmany,$firstexon->start);\n    if ($labelbefore < 1) {\n      if ($strand == 1) {\n\t$labelbefore=$self->{'seq'}->start;\n      } else {\n\t$labelbefore=$self->{'seq'}->end;\n      }\n    }\n    $upstream_seq=$firstexon->labelsubseq($labelbefore,undef,$firstexon->start,\"unsecuremoderequested\");\n    chop $upstream_seq;\n  } else {\n    if ($strand == 1) {\n      $upstream_seq=$firstexon->labelsubseq($self->{'seq'}->start,undef,$self->start,\"unsecuremoderequested\");\n      chop $upstream_seq; # delete last nucleotide that is the A of starting ATG\n    } else {\n      $upstream_seq=$firstexon->labelsubseq($self->{'seq'}->end,undef,$self->start,\"unsecuremoderequested\");\n      chop $upstream_seq; # delete last nucleotide that is the A of starting ATG\n    }\n  }\n  return $upstream_seq;\n}\n\n# These get redefined here, overriding the SeqI one because they draw their\n# information from the Exons a Transcript is built of\n# optional argument: firstlabel. If not given, it checks coordinate_start\n#                                This is useful when called by Translation\n#                                also used by _delete\nsub label {\n  my ($self,$position,$firstlabel)=@_;\n  unless ($position) {  # if position = 0 complain ?\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  my ($label,@labels,$length,$arraypos);\n  unless (defined ($firstlabel)) {\n    $firstlabel=$self->coordinate_start; # this is inside Transcript obj\n  }\n  my $coord_pos=$self->_inside_position($firstlabel);\n  $length=$self->length;\n  #if ($strand == 1) {\n    if ($position < 1) {\n      $position++; # to account for missing of 0 position\n    }\n    $arraypos=$position+$coord_pos-2;\n    #print \"\\n=-=-=-=-DEBUG: arraypos $arraypos, pos $position, coordpos: $coord_pos\";\n    if ($arraypos < 0) {\n      $label=$self->{'seq'}->label($arraypos,$start,$strand); #?\n    } elsif ($arraypos >= $length) {\n      $label=$self->{'seq'}->label($arraypos-$length+2,$end,$strand); #?\n    } else { # inside the Transcript\n      @labels=$self->all_labels;\n      $label=$labels[$arraypos];\n    }\n  #}\n}\n\n# argument: label\n# returns: position of label according to coord_start\n# errorcode: 0 label not found\n# optional argument: firstlabel. If not given, it checks coordinate_start\n#                                This is useful when called by Translation\nsub position {\n  my ($self,$label,$firstlabel)=@_;\n  unless ($self->{'seq'}->valid($label)) {\n    $self->warn(\"label is not valid\");\n    return (0);\n  }\n  unless (defined ($firstlabel)) {\n    $firstlabel=$self->coordinate_start; # this is inside Transcript obj\n  }\n  if ($label == $firstlabel) {\n    return (1);\n  }\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  my ($position,$in_pos,$out_pos,$coord_pos);\n  my $length=$self->length;\n  $coord_pos=$self->_inside_position($firstlabel);\n  if ($self->valid($label)) { # if label is inside the Transcript\n    $in_pos=$self->_inside_position($label);\n    $position=$in_pos-$coord_pos+1;\n    if ($position <= 0) {\n      return ($position-1); # accounts for the missing of the 0 position\n    }\n  } else {\n    if ($self->follows($end,$label)) { # label after end of transcript\n      $out_pos=$self->{'seq'}->position($label,$end,$strand);\n      #print \"\\n+++++++++DEBUG label $label FOLLOWS end $end outpos $out_pos coordpos $coord_pos\";\n      $position=$out_pos+$length-$coord_pos;\n    } elsif ($self->follows($label,$start)) { # label before begin of transcript\n      #print \"\\n+++++++++DEBUG label $label BEFORE start $start outpos $out_pos coordpos $coord_pos\";\n      $out_pos=$self->{'seq'}->position($label,$start,$strand);\n      $position=$out_pos-$coord_pos+1;\n    } else { # label is in intron (not valid, not after, not before)!\n      $self->warn(\"Cannot give position of label pointing to intron according to CDS numbering!\",1);\n      return (0);\n    }\n  }\n  return ($position);\n}\n\nsub seq {\n  my $self=shift;\n  my ($exon,$str);\n  my @exons=$self->all_Exons();\n  foreach $exon (@exons) {\n    $str .= $exon->seq();\n  }\n  return $str;\n}\n\nsub length {\n  my $self=shift;\n  my ($exon,$length);\n  my @exons=$self->all_Exons();\n  foreach $exon (@exons) {\n    $length += $exon->length();\n  }\n  return $length;\n}\n\nsub all_labels {\n  my $self=shift;\n  my ($exon,@labels);\n  my @exons=$self->all_Exons();\n  foreach $exon (@exons) {\n    push (@labels,$exon->all_labels());\n  }\n  return @labels;\n}\n\n# redefined here so that it will retrieve effective subseq without introns\n# otherwise it would have retrieved an underlying DNA (possibly with introns)\n# subsequence\n# Drawback: this is really bulky, label->position and then a call to\n# subseq that will do the opposite position-> label\n#\n# one day this can be rewritten as the main one so that the normal subseq\n# will rely on this one and hence avoid this double (useless and lengthy)\n# conversion between labels and positions\nsub old_labelsubseq {\n  my ($self,$start,$length,$end)=@_;\n  my ($pos1,$pos2);\n  if ($start) {\n    unless ($self->valid($start)) {\n      $self->warn(\"Start label not valid\"); return (-1);\n    }\n    $pos1=$self->position($start);\n  }\n  if ($end) {\n    if ($end == $start) {\n      $length=1;\n    } else {\n      unless ($self->valid($end)) {\n\t$self->warn(\"End label not valid\"); return (-1);\n      }\n      unless ($self->follows($start,$end) == 1) {\n\t$self->warn(\"End label does not follow Start label!\"); return (-1);\n      }\n      $pos2=$self->position($end);\n      undef $length;\n    }\n  }\n  return ($self->subseq($pos1,$pos2,$length));\n}\n\n# rewritten, eventually\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode)=@_;\n  unless (defined $unsecuremode && \n\t  $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    if ($start) {\n      unless ($self->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    } else {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length; # end argument overrides length argument\n\tunless ($self->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n      }\n    } else {\n      $end=$self->end;\n    }\n  }\n  my ($seq,$exon,$startexon,$endexon); my @exonlabels;\n  my @exons=$self->all_Exons;\n  EXONCHECK:\n  foreach $exon (@exons) {\n    if ((!(defined($startexon)))&&($exon->valid($start))) { # checks only if not yet found\n      $startexon=$exon;\n    }\n    if ($exon->valid($end)) {\n      $endexon=$exon;\n    }\n    if ((!(defined($seq)) && (defined($startexon)))) { # initializes only once\n      if ((defined($endexon)) && ($endexon eq $startexon)) { # then perfect, we are finished\n\tif ($length) {\n\t  $seq = $startexon->labelsubseq($start,$length,undef,\"unsecuremoderequested\");\n\n\n\t  last EXONCHECK;\n\t} else {\n\t  $seq = $startexon->labelsubseq($start,undef,$end,\"unsecuremoderequested\");\n\t}\n\tlast EXONCHECK;\n      } else { # get up to the end of the exon\n\t$seq = $startexon->labelsubseq($start,undef,undef,\"unsecuremoderequested\");\n      }\n    }\n    if (($startexon)&&($exon ne $startexon)) {\n      if (defined($endexon)) { # we arrived to the last exon\n\t$seq .= $endexon->labelsubseq(undef,undef,$end,\"unsecuremoderequested\"); # get from the start of the exon\n\tlast EXONCHECK;\n\n      } elsif (defined($startexon)) { # we are in a whole-exon-in-the-middle case\n\t  $seq .= $exon->seq; # we add it completely to the seq\n      } # else, we still have to reach the start point, exon useless, we move on\n      if ($length) { # if length argument specified\n\tif (($seq && (CORE::length($seq) >= $length))) {\n\t  last EXONCHECK;\n\t}\n      }\n    }\n  }\n  if ($length) {\n    return (substr($seq,0,$length));\n  } else {\n    return ($seq);\n  }\n}\n\n\n# argument: label\n# returns: the objref and progressive number of the Exon containing that label\n# errorcode: -1\nsub in_which_Exon {\n  my ($self,$label)=@_;\n  my ($count,$exon);\n  my @exons=$self->all_Exons;\n  foreach $exon (@exons) {\n    $count++; # 1st exon is numbered \"1\"\n    if ($exon->valid($label)) {\n      return ($exon,$count)\n    }\n  }\n  return (-1); # if nothing found\n}\n\n# recoded to exploit the new fast labelsubseq()\n# valid only inside Transcript\nsub subseq {\n  my ($self,$pos1,$pos2,$length) = @_;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($pos1)) {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    if ((defined ($pos2))&&($pos1>$pos2)) {\n      $self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n    }\n    $startlabel=$self->label($pos1);\n    unless ($self->valid($startlabel)) {\n      $self->warn(\"Start label not valid\"); return (-1);\n    }\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  } else {\n    $startlabel=$self->start;\n  }\n  if (defined ($pos2)) {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    if ((defined ($pos1))&&($pos1>$pos2)) {\n      $self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n    }\n    $endlabel=$self->label($pos2);\n    unless ($self->valid($endlabel)) {\n      $self->warn(\"End label not valid\"); return (-1);\n    }\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  } else {\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  }\n  return ($self->labelsubseq($startlabel,$length,$endlabel,\"unsecuremoderequested\"));\n}\n\n# works only inside the transcript, complains if asked outside\nsub old_subseq {\n  my ($self,$pos1,$pos2,$length) = @_;\n  my ($str,$startcount,$endcount,$seq,$seqlength);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  my $firstlabel=$self->coordinate_start; # this is inside Transcript obj\n  my $coord_pos=$self->_inside_position($firstlabel); # TESTME old\n  $seq=$self->seq;\n  $seqlength=CORE::length($seq);\n  unless (defined ($pos1)) {\n    $startcount=1+$coord_pos-1; # i.e. coord_pos\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    } elsif ($pos1 < 0) {\n      $pos1++;\n    }\n    if ((defined ($pos2))&&($pos1>$pos2)) {\n      $self->warn(\"1st position ($pos1) cannot be > 2nd position ($pos2)!\");\n      return (-1);\n    }\n    $startcount=$pos1+$coord_pos-1;\n  }\n  unless (defined ($pos2)) {\n  ;\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    } elsif ($pos2 < 0) {\n      $pos2++;\n    }\n    if ((defined ($pos1))&&($pos1>$pos2)) {\n      $self->warn(\"1st position ($pos1) cannot be > 2nd position ($pos2)!\");\n      return (-1);\n    }\n    $endcount=$pos2+$coord_pos-1;\n    if ($endcount > $seqlength) {\n      #print \"\\n###DEBUG###: pos1 $pos1 pos2 $pos2 coordpos $coord_pos endcount $endcount seqln $seqlength\\n\";\n      $self->warn(\"Cannot access end position after the end of Transcript\");\n      return (-1);\n    }\n    $length=$endcount-$startcount+1;\n  }\n  #print \"\\n###DEBUG pos1 $pos1 pos2 $pos2 start $startcount end $endcount length $length coordpos $coord_pos\\n\";\n  my $offset=$startcount-1;\n  if ($offset < 0) {\n    $self->warn(\"Cannot access startposition before the beginning of Transcript, returning from start\",1); # ignorable\n    return (substr($seq,0,$length));\n  } elsif ($offset >= $seqlength) {\n    $self->warn(\"Cannot access startposition after the end of Transcript\");\n    return (-1);\n  } else {\n    $str=substr($seq,$offset,$length);\n    if (CORE::length($str) < $length) {\n      $self->warn(\"Attention, cannot return the length requested \".\n\t\t  \"for subseq\",1) if $self->verbose > 0; # ignorable\n    }\n    return $str;\n  }\n}\n\n# redefined so that it doesn't require other methods (after deletions) to\n# reset it.\nsub start {\n  my $self = shift;\n  my $exonsref=$self->{'exons'};\n  my @exons=@{$exonsref};\n  return ($exons[0]->start);\n}\n\nsub end {\n  my $self = shift;\n  my $exonsref=$self->{'exons'};\n  my @exons=@{$exonsref};\n  return ($exons[-1]->end);\n}\n\n\n# internal methods begin here\n\n# returns: position of label in transcript's all_labels\n#          with STARTlabel == 1\n# errorcode 0 -> label not found\n# argument: label\nsub _inside_position {\n  my ($self,$label)=@_;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  my ($position,$checkme);\n  my @labels=$self->all_labels;\n  foreach $checkme (@labels) {\n    $position++;\n    if ($label == $checkme) {\n      return ($position);\n    }\n  }\n  return (0);\n}\n\n# returns 1 OK or 0 ERROR\n# arguments: reference to array of Exon object references\nsub _checkexons {\n  my ($exon,$thisstart);\n  my $self=$exon;\n  my $exonsref=$_[0];\n  my @exons=@{$exonsref};\n\n  my $firstexon = $exons[0];\n\n  unless (ref($firstexon) eq \"Bio::LiveSeq::Exon\") {\n    $self->warn(\"Object not of class Exon\");\n    return (0);\n  }\n  my $strand = $firstexon->strand;\n\n  my $prevend = $firstexon->end;\n  shift @exons; # skip first one\n  foreach $exon (@exons) {\n    unless (ref($exon) eq \"Bio::LiveSeq::Exon\") { # object class check\n      $self->warn(\"Object not of class Exon\");\n      return (0);\n    }\n    if ($exon->strand != $strand) { # strand consistency check\n      $self->warn(\"Exons' strands not consistent when trying to create Transcript\");\n      return (0);\n    }\n    $thisstart = $exon->start;\n    unless ($exon->{'seq'}->follows($prevend,$thisstart,$strand)) {\n      $self->warn(\"Exons not in correct order when trying to create Transcript\");\n      return (0);\n    }\n    $prevend = $exon->end;\n  }\n  return (1);\n}\n\n=head2 get_Translation\n\n  Title   : valid\n  Usage   : $translation = $obj->get_Translation()\n  Function: retrieves the reference to the object of class Translation (if any)\n            attached to a LiveSeq object\n  Returns : object reference\n  Args    : none\n\n\nsub get_Translation {\n  my $self=shift;\n  return ($self->{'translation'}); # this is set when Translation->new is called\n}\n\n# this checks so that deletion spanning multiple exons is\n# handled accordingly and correctly\n# arguments: begin and end label of a deletion\n# this is called BEFORE any deletion in the chain\nsub _deletecheck {\n  my ($self,$startlabel,$endlabel)=@_;\n  my $exonsref=$self->{'exons'};\n  my @exons=@{$exonsref};\n  my ($startexon,$endexon,$exon);\n  $startexon=$endexon=0;\n  foreach $exon (@exons) {\n    if (($startexon == 0)&&($exon->valid($startlabel))) {\n      $startexon=$exon; # exon containing start of deletion\n    }\n    if (($endexon == 0)&&($exon->valid($endlabel))) {\n      $endexon=$exon; # exon containing end of deletion\n    }\n    if (($startexon)&&($endexon)) {\n      last; # don't check further\n    }\n  }\n  my $nextend=$self->label(2,$endlabel); # retrieve the next label\n  my $prevstart=$self->label(-1,$startlabel); # retrieve the prev label\n\n  if ($startexon eq $endexon) { # intra-exon deletion\n    if (($startexon->start eq $startlabel) && ($startexon->end eq $endlabel)) {\n      # let's delete the entire exon\n      my @newexons;\n      foreach $exon (@exons) {\n\tunless ($exon eq $startexon) {\n\t  push(@newexons,$exon);\n\t}\n      }\n      $self->{'exons'}=\\@newexons;\n    } elsif ($startexon->start eq $startlabel) { # special cases\n      $startexon->{'start'}=$nextend; # set a new start of exon\n    } elsif ($startexon->end eq $endlabel) {\n      $startexon->{'end'}=$prevstart; # set a new end of exon\n    } else {\n      return; # no problem\n    }\n  } else { # two new exons to be created, inter-exons deletion\n    my @newexons;\n    my $exonobj;\n    my $dna=$self->{'seq'};\n    my $strand=$self->strand;\n    my $notmiddle=1; # flag for skipping exons in the middle of deletion\n    foreach $exon (@exons) {\n      if ($exon eq $startexon) {\n\t$exonobj=Bio::LiveSeq::Exon->new('-seq'=>$dna,'-start'=>$exon->start,'-end'=>$prevstart,'-strand'=>$strand); # new partial exon\n\tpush(@newexons,$exonobj);\n\t$notmiddle=0; # now we enter totally deleted exons\n      } elsif ($exon eq $endexon) {\n\t$exonobj=Bio::LiveSeq::Exon->new('-seq'=>$dna,'-start'=>$nextend,'-end'=>$exon->end,'-strand'=>$strand); # new partial exon\n\tpush(@newexons,$exonobj);\n\t$notmiddle=1; # exiting totally deleted exons\n      } else {\n\tif ($notmiddle) { # if before or after exons with deletion\n\t  push(@newexons,$exon); \n\t}# else skip them\n      }\n    }\n    $self->{'exons'}=\\@newexons;\n  }\n}\n\n=head2 translation_table\n\n Title   : translation_table\n Usage   : $name = $obj->translation_table;\n         : $name = $obj->translation_table(11);\n Function: Returns or sets the translation_table used for translating the\n           transcript.\n           If it has never been set, it will return undef.\n Returns : an integer\n\n\nsub translation_table {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'translation_table'} = $value;\n  }\n  unless (exists $self->{'translation_table'}) {\n    return;\n  } else {\n    return $self->{'translation_table'};\n  }\n}\n\n=head2 frame\n\n Title   : frame\n Usage   : $frame = $transcript->frame($label);\n Function: Returns the frame of a particular nucleotide.\n           Frame can be 0 1 or 2 and means the position in the codon triplet\n           of the particulat nucleotide. 0 is the first codon_position.\n           Codon_position (1 2 3) is simply frame+1.\n           If the label asked for is not inside the Transcript, -1 will be\n           returned.\n Args    : a label\n Returns : 0 1 or 2\n Errorcode -1\n\n args: label\n returns: frame of nucleotide (0 1 2)\n errorcode: -1","parameters":[{"label":"$self"},{"label":"$inputlabel"}],"label":"frame($self,$inputlabel)"},"line":804,"kind":12,"range":{"start":{"line":804,"character":0},"end":{"character":9999,"line":815}},"definition":"sub","detail":"($self,$inputlabel)","children":[{"line":805,"kind":13,"localvar":"my","containerName":"frame","name":"$self","definition":"my"},{"line":805,"name":"$inputlabel","kind":13,"containerName":"frame"},{"line":806,"name":"@labels","kind":13,"localvar":"my","containerName":"frame","definition":"my"},{"line":806,"name":"$self","containerName":"frame","kind":13},{"line":806,"name":"all_labels","containerName":"frame","kind":12},{"localvar":"my","containerName":"frame","kind":13,"name":"$label","line":807,"definition":"my"},{"line":807,"name":"$frame","kind":13,"containerName":"frame"},{"line":807,"kind":13,"containerName":"frame","name":"$count"},{"line":808,"kind":13,"containerName":"frame","name":"$label"},{"line":808,"containerName":"frame","kind":13,"name":"@labels"},{"name":"$inputlabel","kind":13,"containerName":"frame","line":809},{"line":809,"kind":13,"containerName":"frame","name":"$label"},{"kind":13,"containerName":"frame","name":"$count","line":810},{"line":812,"containerName":"frame","kind":13,"name":"$count"}],"name":"frame","containerName":"main::"}],"version":5}