{"vars":[{"line":94,"name":"base","containerName":"","kind":2},{"line":108,"kind":12,"range":{"end":{"line":118,"character":9999},"start":{"character":0,"line":108}},"definition":"sub","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"seq","line":109,"definition":"my"},{"containerName":"seq","localvar":"my","kind":13,"name":"$start","line":110,"definition":"my"},{"line":110,"kind":13,"containerName":"seq","name":"$end"},{"line":110,"name":"$self","containerName":"seq","kind":13},{"containerName":"seq","kind":12,"name":"start","line":110},{"name":"$self","kind":13,"containerName":"seq","line":110},{"line":110,"kind":12,"containerName":"seq","name":"end"},{"line":111,"name":"$self","kind":13,"containerName":"seq"},{"line":111,"kind":12,"containerName":"seq","name":"strand"},{"line":112,"kind":13,"containerName":"seq","name":"$self"},{"line":112,"containerName":"seq","kind":12,"name":"down_chain2string"},{"line":112,"containerName":"seq","kind":13,"name":"$start"},{"kind":13,"containerName":"seq","name":"$end","line":112},{"definition":"my","containerName":"seq","localvar":"my","kind":13,"name":"$str","line":114},{"line":114,"name":"$self","containerName":"seq","kind":13},{"line":114,"kind":12,"containerName":"seq","name":"up_chain2string"},{"name":"$start","containerName":"seq","kind":13,"line":114},{"line":114,"name":"$end","containerName":"seq","kind":13},{"line":115,"containerName":"seq","kind":13,"name":"$str"},{"line":116,"kind":13,"containerName":"seq","name":"$str"}],"name":"seq","containerName":"main::"},{"kind":12,"range":{"end":{"line":139,"character":9999},"start":{"character":0,"line":130}},"line":130,"containerName":"main::","name":"all_labels","children":[{"line":131,"name":"$self","localvar":"my","kind":13,"containerName":"all_labels","definition":"my"},{"definition":"my","containerName":"all_labels","localvar":"my","kind":13,"name":"$start","line":132},{"line":132,"name":"$end","kind":13,"containerName":"all_labels"},{"containerName":"all_labels","kind":13,"name":"$self","line":132},{"containerName":"all_labels","kind":12,"name":"start","line":132},{"kind":13,"containerName":"all_labels","name":"$self","line":132},{"line":132,"kind":12,"containerName":"all_labels","name":"end"},{"definition":"my","name":"$labels","localvar":"my","containerName":"all_labels","kind":13,"line":133},{"line":134,"name":"$self","kind":13,"containerName":"all_labels"},{"name":"strand","kind":12,"containerName":"all_labels","line":134},{"name":"$labels","containerName":"all_labels","kind":13,"line":135},{"name":"$self","kind":13,"containerName":"all_labels","line":135},{"name":"down_labels","containerName":"all_labels","kind":12,"line":135},{"line":135,"containerName":"all_labels","kind":13,"name":"$start"},{"line":135,"name":"$end","kind":13,"containerName":"all_labels"},{"line":137,"name":"$labels","containerName":"all_labels","kind":13},{"line":137,"name":"$self","kind":13,"containerName":"all_labels"},{"line":137,"containerName":"all_labels","kind":12,"name":"up_labels"},{"line":137,"kind":13,"containerName":"all_labels","name":"$start"},{"kind":13,"containerName":"all_labels","name":"$end","line":137},{"name":"$labels","containerName":"all_labels","kind":13,"line":139}],"definition":"sub"},{"signature":{"label":"labelsubseq($self,$start,$length,$end,$unsecuremode)","parameters":[{"label":"$self"},{"label":"$start"},{"label":"$length"},{"label":"$end"},{"label":"$unsecuremode"}],"documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!"},"line":171,"kind":12,"range":{"end":{"line":218,"character":9999},"start":{"character":0,"line":171}},"definition":"sub","detail":"($self,$start,$length,$end,$unsecuremode)","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"labelsubseq","line":172,"definition":"my"},{"kind":13,"containerName":"labelsubseq","name":"$start","line":172},{"kind":13,"containerName":"labelsubseq","name":"$length","line":172},{"line":172,"containerName":"labelsubseq","kind":13,"name":"$end"},{"containerName":"labelsubseq","kind":13,"name":"$unsecuremode","line":172},{"line":173,"kind":13,"containerName":"labelsubseq","name":"$unsecuremode"},{"line":173,"kind":13,"containerName":"labelsubseq","name":"$unsecuremode"},{"name":"$start","kind":13,"containerName":"labelsubseq","line":175},{"kind":13,"containerName":"labelsubseq","name":"$start","line":176},{"kind":13,"containerName":"labelsubseq","name":"$self","line":176},{"line":176,"name":"start","containerName":"labelsubseq","kind":12},{"containerName":"labelsubseq","kind":13,"name":"$end","line":178},{"kind":13,"containerName":"labelsubseq","name":"$end","line":179},{"name":"$start","kind":13,"containerName":"labelsubseq","line":179},{"line":180,"containerName":"labelsubseq","kind":13,"name":"$length"},{"name":"$end","kind":13,"containerName":"labelsubseq","line":181},{"line":183,"name":"$length","containerName":"labelsubseq","kind":13},{"line":186,"containerName":"labelsubseq","kind":13,"name":"$length"},{"line":187,"kind":13,"containerName":"labelsubseq","name":"$end"},{"line":187,"kind":13,"containerName":"labelsubseq","name":"$self"},{"line":187,"name":"end","containerName":"labelsubseq","kind":12},{"name":"$start","kind":13,"containerName":"labelsubseq","line":191},{"line":192,"name":"$self","containerName":"labelsubseq","kind":13},{"line":192,"name":"valid","kind":12,"containerName":"labelsubseq"},{"line":192,"containerName":"labelsubseq","kind":13,"name":"$start"},{"line":193,"kind":13,"containerName":"labelsubseq","name":"$self"},{"name":"warn","containerName":"labelsubseq","kind":12,"line":193},{"name":"$end","kind":13,"containerName":"labelsubseq","line":196},{"line":197,"kind":13,"containerName":"labelsubseq","name":"$end"},{"containerName":"labelsubseq","kind":13,"name":"$start","line":197},{"name":"$length","containerName":"labelsubseq","kind":13,"line":198},{"line":199,"name":"$end","containerName":"labelsubseq","kind":13},{"line":201,"kind":13,"containerName":"labelsubseq","name":"$self"},{"kind":12,"containerName":"labelsubseq","name":"valid","line":201},{"line":201,"kind":13,"containerName":"labelsubseq","name":"$end"},{"name":"$self","kind":13,"containerName":"labelsubseq","line":202},{"line":202,"name":"warn","kind":12,"containerName":"labelsubseq"},{"name":"$self","containerName":"labelsubseq","kind":13,"line":204},{"containerName":"labelsubseq","kind":12,"name":"follows","line":204},{"line":204,"containerName":"labelsubseq","kind":13,"name":"$start"},{"name":"$end","kind":13,"containerName":"labelsubseq","line":204},{"line":205,"kind":13,"containerName":"labelsubseq","name":"$self"},{"line":205,"name":"warn","kind":12,"containerName":"labelsubseq"},{"line":207,"name":"$length","kind":13,"containerName":"labelsubseq"},{"kind":13,"containerName":"labelsubseq","name":"$self","line":211},{"kind":12,"containerName":"labelsubseq","name":"strand","line":211},{"kind":13,"containerName":"labelsubseq","name":"$self","line":212},{"line":212,"kind":12,"containerName":"labelsubseq","name":"down_chain2string"},{"containerName":"labelsubseq","kind":13,"name":"$start","line":212},{"line":212,"containerName":"labelsubseq","kind":13,"name":"$length"},{"kind":13,"containerName":"labelsubseq","name":"$end","line":212},{"line":214,"containerName":"labelsubseq","localvar":"my","kind":13,"name":"$str","definition":"my"},{"name":"$self","containerName":"labelsubseq","kind":13,"line":214},{"containerName":"labelsubseq","kind":12,"name":"up_chain2string","line":214},{"line":214,"kind":13,"containerName":"labelsubseq","name":"$start"},{"line":214,"containerName":"labelsubseq","kind":13,"name":"$length"},{"name":"$end","containerName":"labelsubseq","kind":13,"line":214},{"line":215,"name":"$str","kind":13,"containerName":"labelsubseq"},{"kind":13,"containerName":"labelsubseq","name":"$str","line":216}],"containerName":"main::","name":"labelsubseq"},{"line":261,"range":{"start":{"line":261,"character":0},"end":{"line":329,"character":9999}},"kind":12,"signature":{"label":"subseq($self,$pos1,$pos2,$length,$strand)","documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n\n# NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode) = @_;\n  if (defined $unsecuremode && $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    unless ($start) {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length;\n      }\n    } else {\n      unless ($length) {\n\t$end=$self->end;\n      }\n    }\n  } else {\n    if ($start) {\n      unless ($self->{'seq'}->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tunless ($self->{'seq'}->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n\tundef $length;\n      }\n    }\n  }\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,$length,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,$length,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n         : $substring = $obj->subseq(10,undef,4);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal.\n\n           Allows for negative numbers $obj->subseq(-10,-1). By\n           definition, there is no 0!\n                       -5  -1 1   5\n                gctagcgcccaac atggctcgctg\n\n           This allows to retrieve sequences upstream from given position.\n\n           The precedence is from left to right: if END is given LENGTH is\n           ignored.\n\n Examples: $obj->subseq(-10,undef,10) returns 10 elements before position 1\n           $obj->subseq(4,8) returns elements from the 4th to the 8th, inclusive\n\n Returns : a string\n Errorcode: -1\n Args    : start,  integer, defaults to start of the sequence\n           end,    integer, '' or undef, defaults to end of the sequence\n           length, integer, '' or undef\n           an optional strand (1 or -1) 4th argument \n            if strand argument is not given, it will default to the object\n            argment. This argument is useful when a call is issued from a child\n            of a parent object containing the subseq method\n\n'\n check the fact about reverse strand!\n is it feasible? Is it correct? Should we do it? How about exons? Does it\n work when you ask subseq of an exon?\n eliminated now (Mon night)","parameters":[{"label":"$self"},{"label":"$pos1"},{"label":"$pos2"},{"label":"$length"},{"label":"$strand"}]},"children":[{"definition":"my","line":263,"containerName":"subseq","localvar":"my","kind":13,"name":"$self"},{"name":"$pos1","kind":13,"containerName":"subseq","line":263},{"kind":13,"containerName":"subseq","name":"$pos2","line":263},{"line":263,"kind":13,"containerName":"subseq","name":"$length"},{"containerName":"subseq","kind":13,"name":"$strand","line":263},{"line":267,"kind":13,"containerName":"subseq","name":"$strand"},{"name":"$self","kind":13,"containerName":"subseq","line":267},{"containerName":"subseq","kind":12,"name":"strand","line":267},{"name":"$str","containerName":"subseq","localvar":"my","kind":13,"line":268,"definition":"my"},{"line":268,"name":"$startlabel","kind":13,"containerName":"subseq"},{"name":"$endlabel","containerName":"subseq","kind":13,"line":268},{"kind":13,"containerName":"subseq","name":"$length","line":269},{"containerName":"subseq","kind":13,"name":"$length","line":270},{"line":271,"name":"$self","containerName":"subseq","kind":13},{"line":271,"kind":12,"containerName":"subseq","name":"warn"},{"line":275,"name":"$pos1","kind":13,"containerName":"subseq"},{"name":"$startlabel","containerName":"subseq","kind":13,"line":277},{"line":277,"name":"$self","kind":13,"containerName":"subseq"},{"containerName":"subseq","kind":12,"name":"start","line":277},{"line":279,"kind":13,"containerName":"subseq","name":"$pos1"},{"name":"$self","containerName":"subseq","kind":13,"line":280},{"name":"warn","kind":12,"containerName":"subseq","line":280},{"containerName":"subseq","kind":13,"name":"$pos2","line":283},{"name":"$pos1","kind":13,"containerName":"subseq","line":283},{"line":283,"name":"$pos2","kind":13,"containerName":"subseq"},{"line":284,"containerName":"subseq","kind":13,"name":"$self"},{"containerName":"subseq","kind":12,"name":"warn","line":284},{"name":"$startlabel","containerName":"subseq","kind":13,"line":291},{"name":"$self","kind":13,"containerName":"subseq","line":291},{"name":"label","kind":12,"containerName":"subseq","line":291},{"line":291,"kind":13,"containerName":"subseq","name":"$pos1"},{"kind":13,"containerName":"subseq","name":"$startlabel","line":292},{"kind":13,"containerName":"subseq","name":"$self","line":293},{"name":"warn","kind":12,"containerName":"subseq","line":293},{"line":296,"name":"$pos2","kind":13,"containerName":"subseq"},{"line":298,"kind":13,"containerName":"subseq","name":"$length"},{"line":299,"containerName":"subseq","kind":13,"name":"$endlabel"},{"line":299,"kind":13,"containerName":"subseq","name":"$self"},{"containerName":"subseq","kind":12,"name":"end","line":299},{"kind":13,"containerName":"subseq","name":"$pos2","line":302},{"line":303,"name":"$self","containerName":"subseq","kind":13},{"line":303,"name":"warn","kind":12,"containerName":"subseq"},{"name":"$length","kind":13,"containerName":"subseq","line":305},{"line":307,"containerName":"subseq","kind":13,"name":"$pos1"},{"kind":13,"containerName":"subseq","name":"$pos1","line":307},{"line":307,"kind":13,"containerName":"subseq","name":"$pos2"},{"line":308,"kind":13,"containerName":"subseq","name":"$self"},{"line":308,"name":"warn","containerName":"subseq","kind":12},{"line":315,"name":"$endlabel","kind":13,"containerName":"subseq"},{"line":315,"name":"$self","containerName":"subseq","kind":13},{"line":315,"name":"label","kind":12,"containerName":"subseq"},{"containerName":"subseq","kind":13,"name":"$pos2","line":315},{"kind":13,"containerName":"subseq","name":"$endlabel","line":316},{"kind":13,"containerName":"subseq","name":"$self","line":317},{"line":317,"name":"warn","containerName":"subseq","kind":12},{"line":322,"name":"$strand","kind":13,"containerName":"subseq"},{"line":323,"name":"$str","kind":13,"containerName":"subseq"},{"line":323,"name":"$self","containerName":"subseq","kind":13},{"line":323,"name":"down_chain2string","containerName":"subseq","kind":12},{"line":323,"name":"$startlabel","kind":13,"containerName":"subseq"},{"name":"$length","containerName":"subseq","kind":13,"line":323},{"kind":13,"containerName":"subseq","name":"$endlabel","line":323},{"line":325,"containerName":"subseq","kind":13,"name":"$str"},{"kind":13,"containerName":"subseq","name":"$self","line":325},{"kind":12,"containerName":"subseq","name":"up_chain2string","line":325},{"line":325,"containerName":"subseq","kind":13,"name":"$startlabel"},{"line":325,"kind":13,"containerName":"subseq","name":"$length"},{"line":325,"kind":13,"containerName":"subseq","name":"$endlabel"},{"line":326,"name":"$str","kind":13,"containerName":"subseq"},{"kind":13,"containerName":"subseq","name":"$str","line":328}],"containerName":"main::","name":"subseq","definition":"sub","detail":"($self,$pos1,$pos2,$length,$strand)"},{"line":343,"range":{"end":{"character":9999,"line":351},"start":{"line":343,"character":0}},"kind":12,"definition":"sub","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"length","line":344,"definition":"my"},{"definition":"my","line":345,"containerName":"length","localvar":"my","kind":13,"name":"$start"},{"containerName":"length","kind":13,"name":"$end","line":345},{"line":345,"name":"$strand","containerName":"length","kind":13},{"kind":13,"containerName":"length","name":"$self","line":345},{"kind":12,"containerName":"length","name":"start","line":345},{"line":345,"containerName":"length","kind":13,"name":"$self"},{"line":345,"name":"end","kind":12,"containerName":"length"},{"line":345,"containerName":"length","kind":13,"name":"$self"},{"line":345,"name":"strand","kind":12,"containerName":"length"},{"line":346,"containerName":"length","kind":13,"name":"$strand"},{"name":"$self","kind":13,"containerName":"length","line":347},{"containerName":"length","kind":12,"name":"down_subchain_length","line":347},{"line":347,"name":"$start","kind":13,"containerName":"length"},{"line":347,"name":"$end","kind":13,"containerName":"length"},{"containerName":"length","kind":13,"name":"$self","line":349},{"line":349,"name":"up_subchain_length","containerName":"length","kind":12},{"line":349,"name":"$start","containerName":"length","kind":13},{"kind":13,"containerName":"length","name":"$end","line":349}],"name":"length","containerName":"main::"},{"kind":12,"range":{"start":{"line":373,"character":0},"end":{"line":379,"character":9999}},"line":373,"signature":{"label":"display_id($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n\n# NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode) = @_;\n  if (defined $unsecuremode && $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    unless ($start) {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length;\n      }\n    } else {\n      unless ($length) {\n\t$end=$self->end;\n      }\n    }\n  } else {\n    if ($start) {\n      unless ($self->{'seq'}->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tunless ($self->{'seq'}->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n\tundef $length;\n      }\n    }\n  }\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,$length,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,$length,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n         : $substring = $obj->subseq(10,undef,4);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal.\n\n           Allows for negative numbers $obj->subseq(-10,-1). By\n           definition, there is no 0!\n                       -5  -1 1   5\n                gctagcgcccaac atggctcgctg\n\n           This allows to retrieve sequences upstream from given position.\n\n           The precedence is from left to right: if END is given LENGTH is\n           ignored.\n\n Examples: $obj->subseq(-10,undef,10) returns 10 elements before position 1\n           $obj->subseq(4,8) returns elements from the 4th to the 8th, inclusive\n\n Returns : a string\n Errorcode: -1\n Args    : start,  integer, defaults to start of the sequence\n           end,    integer, '' or undef, defaults to end of the sequence\n           length, integer, '' or undef\n           an optional strand (1 or -1) 4th argument \n            if strand argument is not given, it will default to the object\n            argment. This argument is useful when a call is issued from a child\n            of a parent object containing the subseq method\n\n\n#'\n# check the fact about reverse strand!\n# is it feasible? Is it correct? Should we do it? How about exons? Does it\n# work when you ask subseq of an exon?\n# eliminated now (Mon night)\nsub subseq {\n  ##my ($self,$pos1,$pos2,$length,$strand) = @_;\n  my ($self,$pos1,$pos2,$length,$strand) = @_;\n  ##unless (defined ($strand)) { # if optional [strand] argument not given\n  ##  $strand=$self->strand;\n  ##}\n  $strand=$self->strand;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  unless (defined ($pos1)) {\n    #print \"\\n##### DEBUG pos1 not defined\\n\";\n    $startlabel=$self->start;\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos2))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos2))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!)\"; return (-1);\n    ##  }\n    ##}\n    $startlabel=$self->label($pos1);\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  }\n  unless (defined ($pos2)) {\n    #print \"\\n##### pos2 not defined\\n\";\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos1))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos1))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!\"); return (-1);\n    ##  }\n    ##}\n    $endlabel=$self->label($pos2);\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  }\n  #print \"\\n    ####DEBUG: start $startlabel end $endlabel length $length strand $strand\\n\";\n\n  if ($strand == 1) {\n    $str = $self->{'seq'}->down_chain2string($startlabel,$length,$endlabel);\n  } else { # reverse strand\n    $str = $self->{'seq'}->up_chain2string($startlabel,$length,$endlabel);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n  }\n  return $str;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $seq->length();\n  Function: returns the number of nucleotides (or the number of aminoacids)\n            in the entire sequence\n  Returns : an integer\n  Errorcode -1\n  Args    : none\n\n\nsub length {\n  my $self=shift;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  if ($strand == 1) {\n    return $self->{'seq'}->down_subchain_length($start,$end);\n  } else {\n    return $self->{'seq'}->up_subchain_length($start,$end);\n  }\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, alias the common name of the object\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information.\n\n See also: accession_number\n Returns : a string\n Args    : none"},"name":"display_id","containerName":"main::","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"display_id","line":374,"definition":"my"},{"containerName":"display_id","kind":13,"name":"$value","line":374},{"line":375,"kind":13,"containerName":"display_id","name":"$value"},{"name":"$self","kind":13,"containerName":"display_id","line":376},{"containerName":"display_id","kind":13,"name":"$value","line":376},{"line":378,"kind":13,"containerName":"display_id","name":"$self"}],"detail":"($self,$value)","definition":"sub"},{"signature":{"label":"accession_number($self,$value)","documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n\n# NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode) = @_;\n  if (defined $unsecuremode && $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    unless ($start) {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length;\n      }\n    } else {\n      unless ($length) {\n\t$end=$self->end;\n      }\n    }\n  } else {\n    if ($start) {\n      unless ($self->{'seq'}->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tunless ($self->{'seq'}->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n\tundef $length;\n      }\n    }\n  }\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,$length,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,$length,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n         : $substring = $obj->subseq(10,undef,4);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal.\n\n           Allows for negative numbers $obj->subseq(-10,-1). By\n           definition, there is no 0!\n                       -5  -1 1   5\n                gctagcgcccaac atggctcgctg\n\n           This allows to retrieve sequences upstream from given position.\n\n           The precedence is from left to right: if END is given LENGTH is\n           ignored.\n\n Examples: $obj->subseq(-10,undef,10) returns 10 elements before position 1\n           $obj->subseq(4,8) returns elements from the 4th to the 8th, inclusive\n\n Returns : a string\n Errorcode: -1\n Args    : start,  integer, defaults to start of the sequence\n           end,    integer, '' or undef, defaults to end of the sequence\n           length, integer, '' or undef\n           an optional strand (1 or -1) 4th argument \n            if strand argument is not given, it will default to the object\n            argment. This argument is useful when a call is issued from a child\n            of a parent object containing the subseq method\n\n\n#'\n# check the fact about reverse strand!\n# is it feasible? Is it correct? Should we do it? How about exons? Does it\n# work when you ask subseq of an exon?\n# eliminated now (Mon night)\nsub subseq {\n  ##my ($self,$pos1,$pos2,$length,$strand) = @_;\n  my ($self,$pos1,$pos2,$length,$strand) = @_;\n  ##unless (defined ($strand)) { # if optional [strand] argument not given\n  ##  $strand=$self->strand;\n  ##}\n  $strand=$self->strand;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  unless (defined ($pos1)) {\n    #print \"\\n##### DEBUG pos1 not defined\\n\";\n    $startlabel=$self->start;\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos2))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos2))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!)\"; return (-1);\n    ##  }\n    ##}\n    $startlabel=$self->label($pos1);\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  }\n  unless (defined ($pos2)) {\n    #print \"\\n##### pos2 not defined\\n\";\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos1))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos1))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!\"); return (-1);\n    ##  }\n    ##}\n    $endlabel=$self->label($pos2);\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  }\n  #print \"\\n    ####DEBUG: start $startlabel end $endlabel length $length strand $strand\\n\";\n\n  if ($strand == 1) {\n    $str = $self->{'seq'}->down_chain2string($startlabel,$length,$endlabel);\n  } else { # reverse strand\n    $str = $self->{'seq'}->up_chain2string($startlabel,$length,$endlabel);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n  }\n  return $str;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $seq->length();\n  Function: returns the number of nucleotides (or the number of aminoacids)\n            in the entire sequence\n  Returns : an integer\n  Errorcode -1\n  Args    : none\n\n\nsub length {\n  my $self=shift;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  if ($strand == 1) {\n    return $self->{'seq'}->down_subchain_length($start,$end);\n  } else {\n    return $self->{'seq'}->up_subchain_length($start,$end);\n  }\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, alias the common name of the object\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information.\n\n See also: accession_number\n Returns : a string\n Args    : none\n\n\nsub display_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'display_id'} = $value;\n  }\n  return $self->{'display_id'};\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number.\n           Notice that primary_id() provides the unique id for the\n           implemetation, allowing multiple objects to have the same accession\n           number in a particular implementation.\n\n           For objects with no accession_number this method returns \"unknown\".\n Returns : a string\n Args    : none","parameters":[{"label":"$self"},{"label":"$value"}]},"line":398,"kind":12,"range":{"start":{"line":398,"character":0},"end":{"line":408,"character":9999}},"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","containerName":"accession_number","localvar":"my","kind":13,"name":"$self","line":399},{"name":"$value","containerName":"accession_number","kind":13,"line":399},{"line":400,"containerName":"accession_number","kind":13,"name":"$value"},{"line":401,"kind":13,"containerName":"accession_number","name":"$self"},{"kind":13,"containerName":"accession_number","name":"$value","line":401},{"containerName":"accession_number","kind":13,"name":"$self","line":403},{"name":"$self","containerName":"accession_number","kind":13,"line":406}],"name":"accession_number","containerName":"main::"},{"definition":"sub","detail":"($self,$value)","children":[{"line":429,"name":"$self","kind":13,"localvar":"my","containerName":"primary_id","definition":"my"},{"line":429,"name":"$value","kind":13,"containerName":"primary_id"},{"line":430,"containerName":"primary_id","kind":13,"name":"$value"},{"name":"$self","kind":13,"containerName":"primary_id","line":431},{"name":"$value","kind":13,"containerName":"primary_id","line":431},{"containerName":"primary_id","kind":13,"name":"$self","line":433},{"line":436,"kind":13,"containerName":"primary_id","name":"$self"}],"containerName":"main::","name":"primary_id","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n\n# NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode) = @_;\n  if (defined $unsecuremode && $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    unless ($start) {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length;\n      }\n    } else {\n      unless ($length) {\n\t$end=$self->end;\n      }\n    }\n  } else {\n    if ($start) {\n      unless ($self->{'seq'}->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tunless ($self->{'seq'}->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n\tundef $length;\n      }\n    }\n  }\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,$length,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,$length,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n         : $substring = $obj->subseq(10,undef,4);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal.\n\n           Allows for negative numbers $obj->subseq(-10,-1). By\n           definition, there is no 0!\n                       -5  -1 1   5\n                gctagcgcccaac atggctcgctg\n\n           This allows to retrieve sequences upstream from given position.\n\n           The precedence is from left to right: if END is given LENGTH is\n           ignored.\n\n Examples: $obj->subseq(-10,undef,10) returns 10 elements before position 1\n           $obj->subseq(4,8) returns elements from the 4th to the 8th, inclusive\n\n Returns : a string\n Errorcode: -1\n Args    : start,  integer, defaults to start of the sequence\n           end,    integer, '' or undef, defaults to end of the sequence\n           length, integer, '' or undef\n           an optional strand (1 or -1) 4th argument \n            if strand argument is not given, it will default to the object\n            argment. This argument is useful when a call is issued from a child\n            of a parent object containing the subseq method\n\n\n#'\n# check the fact about reverse strand!\n# is it feasible? Is it correct? Should we do it? How about exons? Does it\n# work when you ask subseq of an exon?\n# eliminated now (Mon night)\nsub subseq {\n  ##my ($self,$pos1,$pos2,$length,$strand) = @_;\n  my ($self,$pos1,$pos2,$length,$strand) = @_;\n  ##unless (defined ($strand)) { # if optional [strand] argument not given\n  ##  $strand=$self->strand;\n  ##}\n  $strand=$self->strand;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  unless (defined ($pos1)) {\n    #print \"\\n##### DEBUG pos1 not defined\\n\";\n    $startlabel=$self->start;\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos2))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos2))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!)\"; return (-1);\n    ##  }\n    ##}\n    $startlabel=$self->label($pos1);\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  }\n  unless (defined ($pos2)) {\n    #print \"\\n##### pos2 not defined\\n\";\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos1))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos1))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!\"); return (-1);\n    ##  }\n    ##}\n    $endlabel=$self->label($pos2);\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  }\n  #print \"\\n    ####DEBUG: start $startlabel end $endlabel length $length strand $strand\\n\";\n\n  if ($strand == 1) {\n    $str = $self->{'seq'}->down_chain2string($startlabel,$length,$endlabel);\n  } else { # reverse strand\n    $str = $self->{'seq'}->up_chain2string($startlabel,$length,$endlabel);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n  }\n  return $str;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $seq->length();\n  Function: returns the number of nucleotides (or the number of aminoacids)\n            in the entire sequence\n  Returns : an integer\n  Errorcode -1\n  Args    : none\n\n\nsub length {\n  my $self=shift;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  if ($strand == 1) {\n    return $self->{'seq'}->down_subchain_length($start,$end);\n  } else {\n    return $self->{'seq'}->up_subchain_length($start,$end);\n  }\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, alias the common name of the object\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information.\n\n See also: accession_number\n Returns : a string\n Args    : none\n\n\nsub display_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'display_id'} = $value;\n  }\n  return $self->{'display_id'};\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number.\n           Notice that primary_id() provides the unique id for the\n           implemetation, allowing multiple objects to have the same accession\n           number in a particular implementation.\n\n           For objects with no accession_number this method returns \"unknown\".\n Returns : a string\n Args    : none\n\n\nsub accession_number {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'accession_number'} = $value;\n  }\n  unless (exists $self->{'accession_number'}) {\n    return \"unknown\";\n  } else {\n    return $self->{'accession_number'};\n  }\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their own\n           object ids in a way the implementation can control. Clients can\n           expect one id to map to one object.\n\n           For sequences with no primary_id, this method returns\n           a stringified memory location.\n\n Returns : A string\n Args    : None","label":"primary_id($self,$value)"},"line":428,"kind":12,"range":{"end":{"character":9999,"line":438},"start":{"character":0,"line":428}}},{"containerName":"main::","name":"change","children":[],"definition":"sub","kind":12,"range":{"end":{"character":9999,"line":467},"start":{"line":465,"character":0}},"line":465},{"name":"positionchange","kind":12,"line":466},{"signature":{"parameters":[{"label":"$self"},{"label":"$newseq"},{"label":"$position"},{"label":"$length"}],"documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n\n# NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode) = @_;\n  if (defined $unsecuremode && $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    unless ($start) {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length;\n      }\n    } else {\n      unless ($length) {\n\t$end=$self->end;\n      }\n    }\n  } else {\n    if ($start) {\n      unless ($self->{'seq'}->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tunless ($self->{'seq'}->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n\tundef $length;\n      }\n    }\n  }\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,$length,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,$length,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n         : $substring = $obj->subseq(10,undef,4);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal.\n\n           Allows for negative numbers $obj->subseq(-10,-1). By\n           definition, there is no 0!\n                       -5  -1 1   5\n                gctagcgcccaac atggctcgctg\n\n           This allows to retrieve sequences upstream from given position.\n\n           The precedence is from left to right: if END is given LENGTH is\n           ignored.\n\n Examples: $obj->subseq(-10,undef,10) returns 10 elements before position 1\n           $obj->subseq(4,8) returns elements from the 4th to the 8th, inclusive\n\n Returns : a string\n Errorcode: -1\n Args    : start,  integer, defaults to start of the sequence\n           end,    integer, '' or undef, defaults to end of the sequence\n           length, integer, '' or undef\n           an optional strand (1 or -1) 4th argument \n            if strand argument is not given, it will default to the object\n            argment. This argument is useful when a call is issued from a child\n            of a parent object containing the subseq method\n\n\n#'\n# check the fact about reverse strand!\n# is it feasible? Is it correct? Should we do it? How about exons? Does it\n# work when you ask subseq of an exon?\n# eliminated now (Mon night)\nsub subseq {\n  ##my ($self,$pos1,$pos2,$length,$strand) = @_;\n  my ($self,$pos1,$pos2,$length,$strand) = @_;\n  ##unless (defined ($strand)) { # if optional [strand] argument not given\n  ##  $strand=$self->strand;\n  ##}\n  $strand=$self->strand;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  unless (defined ($pos1)) {\n    #print \"\\n##### DEBUG pos1 not defined\\n\";\n    $startlabel=$self->start;\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos2))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos2))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!)\"; return (-1);\n    ##  }\n    ##}\n    $startlabel=$self->label($pos1);\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  }\n  unless (defined ($pos2)) {\n    #print \"\\n##### pos2 not defined\\n\";\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos1))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos1))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!\"); return (-1);\n    ##  }\n    ##}\n    $endlabel=$self->label($pos2);\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  }\n  #print \"\\n    ####DEBUG: start $startlabel end $endlabel length $length strand $strand\\n\";\n\n  if ($strand == 1) {\n    $str = $self->{'seq'}->down_chain2string($startlabel,$length,$endlabel);\n  } else { # reverse strand\n    $str = $self->{'seq'}->up_chain2string($startlabel,$length,$endlabel);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n  }\n  return $str;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $seq->length();\n  Function: returns the number of nucleotides (or the number of aminoacids)\n            in the entire sequence\n  Returns : an integer\n  Errorcode -1\n  Args    : none\n\n\nsub length {\n  my $self=shift;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  if ($strand == 1) {\n    return $self->{'seq'}->down_subchain_length($start,$end);\n  } else {\n    return $self->{'seq'}->up_subchain_length($start,$end);\n  }\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, alias the common name of the object\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information.\n\n See also: accession_number\n Returns : a string\n Args    : none\n\n\nsub display_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'display_id'} = $value;\n  }\n  return $self->{'display_id'};\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number.\n           Notice that primary_id() provides the unique id for the\n           implemetation, allowing multiple objects to have the same accession\n           number in a particular implementation.\n\n           For objects with no accession_number this method returns \"unknown\".\n Returns : a string\n Args    : none\n\n\nsub accession_number {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'accession_number'} = $value;\n  }\n  unless (exists $self->{'accession_number'}) {\n    return \"unknown\";\n  } else {\n    return $self->{'accession_number'};\n  }\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their own\n           object ids in a way the implementation can control. Clients can\n           expect one id to map to one object.\n\n           For sequences with no primary_id, this method returns\n           a stringified memory location.\n\n Returns : A string\n Args    : None\n\n\n\nsub primary_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'primary_id'} = $value;\n  }\n  unless (exists $self->{'primary_id'}) {\n    return \"$self\";\n  } else {\n    return $self->{'primary_id'};\n  }\n}\n\n=head2 change\n\n Title   : change\n Usage   : $substring = $obj->change('AA', 10);\n Function: changes, modifies, mutates the LiveSequence\n Examples:\n        $obj->change('',   10);      delete nucleotide #10     \n        $obj->change('',   10, 2);   delete two nucleotides starting from #10\n        $obj->change('G',  10);      change nuc #10 to 'G'\n        $obj->change('GA', 10, 4);   replace #10 and 3 following with 'GA'\n        $obj->change('GA', 10, 2));  is same as $obj->change('GA',  10);\n        $obj->change('GA', 10, 0 );  insert 'GA' before nucleotide at #10\n        $obj->change('GA', 10, 1);   GA inserted before #10, #10 deleted\n        $obj->change('GATC', 10, 2); GATC inserted before #10, #10&#11 deleted\n        $obj->change('GATC', 10, 6); GATC inserted before #10, #10-#15 deleted\n\n\n Returns : a string of deleted bases (if any) or 1 (everything OK)\n Errorcode: -1\n Args    : seq,    string, or '' ('' = undef = 0 = deletion)\n           start,  integer\n           length, integer (optional)\n\n\nsub change {\n  &positionchange;\n}\n\n=head2 positionchange\n\n Title   : positionchange\n Function: Exactly like change. I.e. change() defaults to positionchange()","label":"positionchange($self,$newseq,$position,$length)"},"range":{"end":{"character":9999,"line":488},"start":{"character":0,"line":476}},"kind":12,"line":476,"detail":"($self,$newseq,$position,$length)","definition":"sub","name":"positionchange","containerName":"main::","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"positionchange","name":"$self","line":477},{"containerName":"positionchange","kind":13,"name":"$newseq","line":477},{"name":"$position","containerName":"positionchange","kind":13,"line":477},{"name":"$length","containerName":"positionchange","kind":13,"line":477},{"name":"$position","containerName":"positionchange","kind":13,"line":478},{"line":479,"containerName":"positionchange","kind":13,"name":"$self"},{"line":479,"kind":12,"containerName":"positionchange","name":"warn"},{"definition":"my","name":"$label","localvar":"my","kind":13,"containerName":"positionchange","line":482},{"name":"$self","kind":13,"containerName":"positionchange","line":482},{"line":482,"kind":12,"containerName":"positionchange","name":"label"},{"containerName":"positionchange","kind":13,"name":"$position","line":482},{"name":"$label","containerName":"positionchange","kind":13,"line":483},{"containerName":"positionchange","kind":13,"name":"$self","line":484},{"line":484,"name":"warn","kind":12,"containerName":"positionchange"},{"kind":13,"containerName":"positionchange","name":"$self","line":487},{"line":487,"kind":12,"containerName":"positionchange","name":"labelchange"},{"line":487,"kind":13,"containerName":"positionchange","name":"$newseq"},{"line":487,"kind":13,"containerName":"positionchange","name":"$label"},{"containerName":"positionchange","kind":13,"name":"$length","line":487}]},{"signature":{"documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n\n# NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode) = @_;\n  if (defined $unsecuremode && $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    unless ($start) {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length;\n      }\n    } else {\n      unless ($length) {\n\t$end=$self->end;\n      }\n    }\n  } else {\n    if ($start) {\n      unless ($self->{'seq'}->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tunless ($self->{'seq'}->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n\tundef $length;\n      }\n    }\n  }\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,$length,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,$length,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n         : $substring = $obj->subseq(10,undef,4);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal.\n\n           Allows for negative numbers $obj->subseq(-10,-1). By\n           definition, there is no 0!\n                       -5  -1 1   5\n                gctagcgcccaac atggctcgctg\n\n           This allows to retrieve sequences upstream from given position.\n\n           The precedence is from left to right: if END is given LENGTH is\n           ignored.\n\n Examples: $obj->subseq(-10,undef,10) returns 10 elements before position 1\n           $obj->subseq(4,8) returns elements from the 4th to the 8th, inclusive\n\n Returns : a string\n Errorcode: -1\n Args    : start,  integer, defaults to start of the sequence\n           end,    integer, '' or undef, defaults to end of the sequence\n           length, integer, '' or undef\n           an optional strand (1 or -1) 4th argument \n            if strand argument is not given, it will default to the object\n            argment. This argument is useful when a call is issued from a child\n            of a parent object containing the subseq method\n\n\n#'\n# check the fact about reverse strand!\n# is it feasible? Is it correct? Should we do it? How about exons? Does it\n# work when you ask subseq of an exon?\n# eliminated now (Mon night)\nsub subseq {\n  ##my ($self,$pos1,$pos2,$length,$strand) = @_;\n  my ($self,$pos1,$pos2,$length,$strand) = @_;\n  ##unless (defined ($strand)) { # if optional [strand] argument not given\n  ##  $strand=$self->strand;\n  ##}\n  $strand=$self->strand;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  unless (defined ($pos1)) {\n    #print \"\\n##### DEBUG pos1 not defined\\n\";\n    $startlabel=$self->start;\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos2))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos2))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!)\"; return (-1);\n    ##  }\n    ##}\n    $startlabel=$self->label($pos1);\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  }\n  unless (defined ($pos2)) {\n    #print \"\\n##### pos2 not defined\\n\";\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos1))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos1))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!\"); return (-1);\n    ##  }\n    ##}\n    $endlabel=$self->label($pos2);\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  }\n  #print \"\\n    ####DEBUG: start $startlabel end $endlabel length $length strand $strand\\n\";\n\n  if ($strand == 1) {\n    $str = $self->{'seq'}->down_chain2string($startlabel,$length,$endlabel);\n  } else { # reverse strand\n    $str = $self->{'seq'}->up_chain2string($startlabel,$length,$endlabel);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n  }\n  return $str;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $seq->length();\n  Function: returns the number of nucleotides (or the number of aminoacids)\n            in the entire sequence\n  Returns : an integer\n  Errorcode -1\n  Args    : none\n\n\nsub length {\n  my $self=shift;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  if ($strand == 1) {\n    return $self->{'seq'}->down_subchain_length($start,$end);\n  } else {\n    return $self->{'seq'}->up_subchain_length($start,$end);\n  }\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, alias the common name of the object\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information.\n\n See also: accession_number\n Returns : a string\n Args    : none\n\n\nsub display_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'display_id'} = $value;\n  }\n  return $self->{'display_id'};\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number.\n           Notice that primary_id() provides the unique id for the\n           implemetation, allowing multiple objects to have the same accession\n           number in a particular implementation.\n\n           For objects with no accession_number this method returns \"unknown\".\n Returns : a string\n Args    : none\n\n\nsub accession_number {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'accession_number'} = $value;\n  }\n  unless (exists $self->{'accession_number'}) {\n    return \"unknown\";\n  } else {\n    return $self->{'accession_number'};\n  }\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their own\n           object ids in a way the implementation can control. Clients can\n           expect one id to map to one object.\n\n           For sequences with no primary_id, this method returns\n           a stringified memory location.\n\n Returns : A string\n Args    : None\n\n\n\nsub primary_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'primary_id'} = $value;\n  }\n  unless (exists $self->{'primary_id'}) {\n    return \"$self\";\n  } else {\n    return $self->{'primary_id'};\n  }\n}\n\n=head2 change\n\n Title   : change\n Usage   : $substring = $obj->change('AA', 10);\n Function: changes, modifies, mutates the LiveSequence\n Examples:\n        $obj->change('',   10);      delete nucleotide #10     \n        $obj->change('',   10, 2);   delete two nucleotides starting from #10\n        $obj->change('G',  10);      change nuc #10 to 'G'\n        $obj->change('GA', 10, 4);   replace #10 and 3 following with 'GA'\n        $obj->change('GA', 10, 2));  is same as $obj->change('GA',  10);\n        $obj->change('GA', 10, 0 );  insert 'GA' before nucleotide at #10\n        $obj->change('GA', 10, 1);   GA inserted before #10, #10 deleted\n        $obj->change('GATC', 10, 2); GATC inserted before #10, #10&#11 deleted\n        $obj->change('GATC', 10, 6); GATC inserted before #10, #10-#15 deleted\n\n\n Returns : a string of deleted bases (if any) or 1 (everything OK)\n Errorcode: -1\n Args    : seq,    string, or '' ('' = undef = 0 = deletion)\n           start,  integer\n           length, integer (optional)\n\n\nsub change {\n  &positionchange;\n}\n\n=head2 positionchange\n\n Title   : positionchange\n Function: Exactly like change. I.e. change() defaults to positionchange()\n\n\nsub positionchange {\n  my ($self,$newseq,$position,$length)=@_;\n  unless ($position) {\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  my $label=$self->label($position);\n  unless ($label > 0) { # label not found or error\n    $self->warn(\"No valid label found at that position!\");\n    return (-1);\n  }\n  return ($self->labelchange($newseq,$label,$length));\n}\n\n=head2 labelchange\n\n Title   : labelchange\n Function: Exactly like change but uses a /label/ instead than a position\n           as second argument. This allows for multiple changes in a LiveSeq\n           without the burden of recomputing positions. I.e. for a multiple\n           change in two different points of the LiveSeq, the approach would\n           be the following: fetch the correct labels out of the two different\n           positions (method: label($position)) and then use the labelchange()\n           method to modify the sequence using those labels instead than\n           relying on the positions (that would have modified after the\n           first change).","parameters":[{"label":"$self"},{"label":"$newseq"},{"label":"$label"},{"label":"$length"}],"label":"labelchange($self,$newseq,$label,$length)"},"line":505,"kind":12,"range":{"end":{"line":567,"character":9999},"start":{"line":505,"character":0}},"definition":"sub","detail":"($self,$newseq,$label,$length)","children":[{"containerName":"labelchange","localvar":"my","kind":13,"name":"$self","line":506,"definition":"my"},{"kind":13,"containerName":"labelchange","name":"$newseq","line":506},{"line":506,"kind":13,"containerName":"labelchange","name":"$label"},{"kind":13,"containerName":"labelchange","name":"$length","line":506},{"name":"$self","containerName":"labelchange","kind":13,"line":507},{"kind":12,"containerName":"labelchange","name":"valid","line":507},{"line":507,"name":"$label","kind":13,"containerName":"labelchange"},{"name":"$self","kind":13,"containerName":"labelchange","line":508},{"line":508,"name":"valid","kind":12,"containerName":"labelchange"},{"line":508,"containerName":"labelchange","kind":13,"name":"$label"},{"name":"$self","containerName":"labelchange","kind":13,"line":511},{"line":511,"containerName":"labelchange","kind":12,"name":"labelchange"},{"line":513,"name":"$self","containerName":"labelchange","kind":13},{"line":513,"name":"warn","kind":12,"containerName":"labelchange"},{"line":517,"containerName":"labelchange","kind":13,"name":"$newseq"},{"line":518,"name":"$length","containerName":"labelchange","kind":13},{"line":519,"name":"$length","kind":13,"containerName":"labelchange"},{"containerName":"labelchange","kind":13,"name":"$self","line":520},{"name":"warn","containerName":"labelchange","kind":12,"line":520},{"kind":13,"containerName":"labelchange","name":"$self","line":524},{"line":524,"name":"warn","containerName":"labelchange","kind":12},{"line":527,"containerName":"labelchange","kind":13,"name":"$self"},{"line":527,"kind":12,"containerName":"labelchange","name":"_delete"},{"line":527,"name":"$label","kind":13,"containerName":"labelchange"},{"line":527,"name":"$length","containerName":"labelchange","kind":13},{"definition":"my","line":529,"localvar":"my","kind":13,"containerName":"labelchange","name":"$newseqlength"},{"line":529,"containerName":"labelchange","kind":13,"name":"$newseq"},{"name":"$length","kind":13,"containerName":"labelchange","line":530},{"line":531,"kind":13,"containerName":"labelchange","name":"$length"},{"line":532,"containerName":"labelchange","kind":13,"name":"$self"},{"name":"warn","kind":12,"containerName":"labelchange","line":532},{"name":"$length","containerName":"labelchange","kind":13,"line":536},{"name":"$newseqlength","containerName":"labelchange","kind":13,"line":536},{"containerName":"labelchange","kind":13,"name":"$length","line":538},{"definition":"my","name":"$insertbegin","containerName":"labelchange","localvar":"my","kind":13,"line":539},{"kind":13,"containerName":"labelchange","name":"$insertend","line":539},{"line":539,"name":"$self","containerName":"labelchange","kind":13},{"name":"_praeinsert","kind":12,"containerName":"labelchange","line":539},{"line":539,"containerName":"labelchange","kind":13,"name":"$label"},{"line":539,"name":"$newseq","containerName":"labelchange","kind":13},{"name":"$insertbegin","kind":13,"containerName":"labelchange","line":540},{"line":546,"containerName":"labelchange","kind":13,"name":"$newseqlength"},{"line":546,"containerName":"labelchange","kind":13,"name":"$length"},{"line":547,"kind":13,"containerName":"labelchange","name":"$self"},{"name":"_mutate","kind":12,"containerName":"labelchange","line":547},{"kind":13,"containerName":"labelchange","name":"$label","line":547},{"line":547,"name":"$newseq","containerName":"labelchange","kind":13},{"line":547,"name":"$length","kind":13,"containerName":"labelchange"},{"definition":"my","name":"$strand","containerName":"labelchange","localvar":"my","kind":13,"line":550},{"name":"$self","containerName":"labelchange","kind":13,"line":550},{"kind":12,"containerName":"labelchange","name":"strand","line":550},{"definition":"my","kind":13,"localvar":"my","containerName":"labelchange","name":"$afterendlabel","line":551},{"name":"$self","kind":13,"containerName":"labelchange","line":551},{"kind":12,"containerName":"labelchange","name":"label","line":551},{"containerName":"labelchange","kind":13,"name":"$length","line":551},{"line":551,"name":"$label","kind":13,"containerName":"labelchange"},{"name":"$strand","kind":13,"containerName":"labelchange","line":551},{"line":552,"kind":13,"containerName":"labelchange","name":"$afterendlabel"},{"name":"$self","containerName":"labelchange","kind":13,"line":553},{"line":553,"kind":12,"containerName":"labelchange","name":"warn"},{"containerName":"labelchange","localvar":"my","kind":13,"name":"$deleted","line":556,"definition":"my"},{"line":556,"kind":13,"containerName":"labelchange","name":"$self"},{"line":556,"containerName":"labelchange","kind":12,"name":"_delete"},{"line":556,"name":"$label","kind":13,"containerName":"labelchange"},{"line":556,"kind":13,"containerName":"labelchange","name":"$length"},{"line":557,"kind":13,"containerName":"labelchange","name":"$deleted"},{"definition":"my","line":560,"localvar":"my","kind":13,"containerName":"labelchange","name":"$insertbegin"},{"line":560,"containerName":"labelchange","kind":13,"name":"$insertend"},{"containerName":"labelchange","kind":13,"name":"$self","line":560},{"line":560,"name":"_praeinsert","containerName":"labelchange","kind":12},{"kind":13,"containerName":"labelchange","name":"$afterendlabel","line":560},{"containerName":"labelchange","kind":13,"name":"$newseq","line":560},{"containerName":"labelchange","kind":13,"name":"$insertbegin","line":561}],"name":"labelchange","containerName":"main::"},{"line":529,"name":"CORE","containerName":"length","kind":12},{"signature":{"label":"_praeinsert($self,$label,$newseq)","documentation":" internal methods for change()\n arguments: label for beginning of deletion, new sequence to insert\n returns: labels of beginning and end of the inserted sequence\n errorcode: -1","parameters":[{"label":"$self"},{"label":"$label"},{"label":"$newseq"}]},"line":574,"range":{"end":{"character":9999,"line":591},"start":{"character":0,"line":574}},"kind":12,"definition":"sub","detail":"($self,$label,$newseq)","children":[{"definition":"my","containerName":"_praeinsert","localvar":"my","kind":13,"name":"$self","line":575},{"line":575,"name":"$label","containerName":"_praeinsert","kind":13},{"containerName":"_praeinsert","kind":13,"name":"$newseq","line":575},{"definition":"my","line":576,"name":"$insertbegin","localvar":"my","containerName":"_praeinsert","kind":13},{"line":576,"containerName":"_praeinsert","kind":13,"name":"$insertend"},{"kind":13,"localvar":"my","containerName":"_praeinsert","name":"$strand","line":577,"definition":"my"},{"line":577,"containerName":"_praeinsert","kind":13,"name":"$self"},{"line":577,"name":"strand","kind":12,"containerName":"_praeinsert"},{"containerName":"_praeinsert","kind":13,"name":"$strand","line":578},{"containerName":"_praeinsert","kind":13,"name":"$insertbegin","line":579},{"name":"$insertend","containerName":"_praeinsert","kind":13,"line":579},{"containerName":"_praeinsert","kind":13,"name":"$self","line":579},{"kind":12,"containerName":"_praeinsert","name":"praeinsert_string","line":579},{"line":579,"kind":13,"containerName":"_praeinsert","name":"$newseq"},{"name":"$label","containerName":"_praeinsert","kind":13,"line":579},{"line":581,"kind":13,"containerName":"_praeinsert","name":"$newseq"},{"containerName":"_praeinsert","kind":13,"name":"$newseq","line":581},{"line":582,"containerName":"_praeinsert","kind":13,"name":"$newseq"},{"kind":13,"containerName":"_praeinsert","name":"$insertend","line":583},{"line":583,"containerName":"_praeinsert","kind":13,"name":"$insertbegin"},{"line":583,"name":"$self","containerName":"_praeinsert","kind":13},{"line":583,"kind":12,"containerName":"_praeinsert","name":"postinsert_string"},{"line":583,"name":"$newseq","kind":13,"containerName":"_praeinsert"},{"line":583,"kind":13,"containerName":"_praeinsert","name":"$label"},{"line":585,"containerName":"_praeinsert","kind":13,"name":"$insertbegin"},{"line":585,"name":"$insertend","kind":13,"containerName":"_praeinsert"},{"line":586,"name":"$self","containerName":"_praeinsert","kind":13},{"line":586,"name":"warn","kind":12,"containerName":"_praeinsert"},{"line":589,"kind":13,"containerName":"_praeinsert","name":"$insertbegin"},{"line":589,"name":"$insertend","containerName":"_praeinsert","kind":13}],"name":"_praeinsert","containerName":"main::"},{"range":{"end":{"line":616,"character":9999},"start":{"character":0,"line":596}},"kind":12,"line":596,"signature":{"parameters":[{"label":"$self"},{"label":"$label"},{"label":"$length"}],"documentation":" arguments: label for beginning of deletion, length of deletion\n returns: string of deleted bases\n errorcode: -1","label":"_delete($self,$label,$length)"},"containerName":"main::","name":"_delete","children":[{"line":597,"name":"$self","containerName":"_delete","localvar":"my","kind":13,"definition":"my"},{"line":597,"kind":13,"containerName":"_delete","name":"$label"},{"line":597,"containerName":"_delete","kind":13,"name":"$length"},{"definition":"my","name":"$strand","localvar":"my","kind":13,"containerName":"_delete","line":598},{"kind":13,"containerName":"_delete","name":"$self","line":598},{"name":"strand","containerName":"_delete","kind":12,"line":598},{"definition":"my","line":599,"localvar":"my","containerName":"_delete","kind":13,"name":"$endlabel"},{"containerName":"_delete","kind":13,"name":"$self","line":599},{"kind":12,"containerName":"_delete","name":"label","line":599},{"line":599,"name":"$length","containerName":"_delete","kind":13},{"kind":13,"containerName":"_delete","name":"$label","line":599},{"containerName":"_delete","kind":13,"name":"$strand","line":599},{"name":"$endlabel","kind":13,"containerName":"_delete","line":600},{"containerName":"_delete","kind":13,"name":"$self","line":601},{"name":"warn","containerName":"_delete","kind":12,"line":601},{"kind":13,"containerName":"_delete","name":"$self","line":605},{"name":"_deletecheck","containerName":"_delete","kind":12,"line":605},{"line":605,"name":"$label","kind":13,"containerName":"_delete"},{"containerName":"_delete","kind":13,"name":"$endlabel","line":605},{"definition":"my","line":606,"name":"$deletedseq","kind":13,"localvar":"my","containerName":"_delete"},{"line":607,"containerName":"_delete","kind":13,"name":"$strand"},{"line":608,"kind":13,"containerName":"_delete","name":"$deletedseq"},{"line":608,"name":"$self","containerName":"_delete","kind":13},{"line":608,"name":"splice_chain","containerName":"_delete","kind":12},{"line":608,"kind":13,"containerName":"_delete","name":"$label"},{"line":608,"containerName":"_delete","kind":13,"name":"$endlabel"},{"line":610,"name":"$deletedseq","containerName":"_delete","kind":13},{"containerName":"_delete","kind":13,"name":"$self","line":610},{"line":610,"name":"splice_chain","kind":12,"containerName":"_delete"},{"kind":13,"containerName":"_delete","name":"$endlabel","line":610},{"name":"$label","kind":13,"containerName":"_delete","line":610},{"containerName":"_delete","kind":13,"name":"$deletedseq","line":611},{"name":"$deletedseq","kind":13,"containerName":"_delete","line":611},{"containerName":"_delete","kind":13,"name":"$deletedseq","line":613},{"kind":13,"containerName":"_delete","name":"$deletedseq","line":615}],"detail":"($self,$label,$length)","definition":"sub"},{"kind":12,"range":{"end":{"line":620,"character":9999},"start":{"line":619,"character":0}},"line":619,"name":"_deletecheck","containerName":"main::","children":[],"definition":"sub"},{"signature":{"label":"_mutate($self,$label,$newseq,$length)","documentation":" arguments: label for beginning of mutation, newsequence, number of mutations\n returns: 1 all OK\n errorcode: -1","parameters":[{"label":"$self"},{"label":"$label"},{"label":"$newseq"},{"label":"$length"}]},"line":625,"range":{"start":{"line":625,"character":0},"end":{"line":678,"character":9999}},"kind":12,"definition":"sub","detail":"($self,$label,$newseq,$length)","children":[{"definition":"my","line":626,"name":"$self","kind":13,"localvar":"my","containerName":"_mutate"},{"line":626,"containerName":"_mutate","kind":13,"name":"$label"},{"containerName":"_mutate","kind":13,"name":"$newseq","line":626},{"line":626,"name":"$length","kind":13,"containerName":"_mutate"},{"line":627,"name":"$i","localvar":"my","kind":13,"containerName":"_mutate","definition":"my"},{"line":627,"name":"$base","kind":13,"containerName":"_mutate"},{"name":"$nextlabel","containerName":"_mutate","kind":13,"line":627},{"line":628,"name":"@labels","containerName":"_mutate","localvar":"my","kind":13,"definition":"my"},{"name":"$strand","localvar":"my","kind":13,"containerName":"_mutate","line":629,"definition":"my"},{"kind":13,"containerName":"_mutate","name":"$self","line":629},{"line":629,"kind":12,"containerName":"_mutate","name":"strand"},{"containerName":"_mutate","kind":13,"name":"$length","line":630},{"line":631,"kind":13,"containerName":"_mutate","name":"@labels"},{"containerName":"_mutate","kind":13,"name":"$label","line":631},{"definition":"my","name":"$endlabel","localvar":"my","kind":13,"containerName":"_mutate","line":633},{"line":633,"name":"$self","kind":13,"containerName":"_mutate"},{"line":633,"containerName":"_mutate","kind":12,"name":"label"},{"line":633,"name":"$length","containerName":"_mutate","kind":13},{"line":633,"kind":13,"containerName":"_mutate","name":"$label"},{"line":633,"name":"$strand","containerName":"_mutate","kind":13},{"line":634,"kind":13,"containerName":"_mutate","name":"$endlabel"},{"line":635,"containerName":"_mutate","kind":13,"name":"$self"},{"line":635,"name":"warn","kind":12,"containerName":"_mutate"},{"line":638,"kind":13,"containerName":"_mutate","name":"$length"},{"line":639,"name":"@labels","containerName":"_mutate","kind":13},{"name":"$label","kind":13,"containerName":"_mutate","line":639},{"containerName":"_mutate","kind":13,"name":"$endlabel","line":639},{"name":"@labels","containerName":"_mutate","kind":13,"line":655},{"name":"$label","containerName":"_mutate","kind":13,"line":655},{"line":656,"name":"$label","kind":13,"containerName":"_mutate"},{"line":656,"name":"$endlabel","containerName":"_mutate","kind":13},{"line":657,"name":"$nextlabel","containerName":"_mutate","kind":13},{"line":657,"kind":13,"containerName":"_mutate","name":"$self"},{"name":"label","kind":12,"containerName":"_mutate","line":657},{"kind":13,"containerName":"_mutate","name":"$label","line":657},{"line":657,"name":"$strand","containerName":"_mutate","kind":13},{"containerName":"_mutate","kind":13,"name":"@labels","line":658},{"line":658,"name":"$nextlabel","kind":13,"containerName":"_mutate"},{"name":"$label","kind":13,"containerName":"_mutate","line":659},{"kind":13,"containerName":"_mutate","name":"$nextlabel","line":659},{"kind":13,"containerName":"_mutate","name":"$strand","line":663},{"kind":13,"containerName":"_mutate","name":"$newseq","line":664},{"line":666,"containerName":"_mutate","localvar":"my","kind":13,"name":"$errorcheck","definition":"my"},{"line":667,"containerName":"_mutate","kind":13,"name":"$i"},{"line":668,"kind":13,"containerName":"_mutate","name":"$base"},{"line":668,"containerName":"_mutate","kind":13,"name":"$newseq"},{"line":669,"name":"$errorcheck","containerName":"_mutate","kind":13},{"line":669,"kind":13,"containerName":"_mutate","name":"$self"},{"name":"set_value_at_label","containerName":"_mutate","kind":12,"line":669},{"line":669,"name":"$base","kind":13,"containerName":"_mutate"},{"line":669,"kind":13,"containerName":"_mutate","name":"$labels"},{"line":669,"name":"$i","kind":13,"containerName":"_mutate"},{"line":670,"name":"$i","containerName":"_mutate","kind":13},{"line":672,"containerName":"_mutate","kind":13,"name":"$errorcheck"},{"line":672,"containerName":"_mutate","kind":13,"name":"$length"},{"line":673,"name":"$self","containerName":"_mutate","kind":13},{"containerName":"_mutate","kind":12,"name":"warn","line":673}],"containerName":"main::","name":"_mutate"},{"signature":{"label":"valid($self,$label)","documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n\n# NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode) = @_;\n  if (defined $unsecuremode && $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    unless ($start) {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length;\n      }\n    } else {\n      unless ($length) {\n\t$end=$self->end;\n      }\n    }\n  } else {\n    if ($start) {\n      unless ($self->{'seq'}->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tunless ($self->{'seq'}->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n\tundef $length;\n      }\n    }\n  }\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,$length,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,$length,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n         : $substring = $obj->subseq(10,undef,4);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal.\n\n           Allows for negative numbers $obj->subseq(-10,-1). By\n           definition, there is no 0!\n                       -5  -1 1   5\n                gctagcgcccaac atggctcgctg\n\n           This allows to retrieve sequences upstream from given position.\n\n           The precedence is from left to right: if END is given LENGTH is\n           ignored.\n\n Examples: $obj->subseq(-10,undef,10) returns 10 elements before position 1\n           $obj->subseq(4,8) returns elements from the 4th to the 8th, inclusive\n\n Returns : a string\n Errorcode: -1\n Args    : start,  integer, defaults to start of the sequence\n           end,    integer, '' or undef, defaults to end of the sequence\n           length, integer, '' or undef\n           an optional strand (1 or -1) 4th argument \n            if strand argument is not given, it will default to the object\n            argment. This argument is useful when a call is issued from a child\n            of a parent object containing the subseq method\n\n\n#'\n# check the fact about reverse strand!\n# is it feasible? Is it correct? Should we do it? How about exons? Does it\n# work when you ask subseq of an exon?\n# eliminated now (Mon night)\nsub subseq {\n  ##my ($self,$pos1,$pos2,$length,$strand) = @_;\n  my ($self,$pos1,$pos2,$length,$strand) = @_;\n  ##unless (defined ($strand)) { # if optional [strand] argument not given\n  ##  $strand=$self->strand;\n  ##}\n  $strand=$self->strand;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  unless (defined ($pos1)) {\n    #print \"\\n##### DEBUG pos1 not defined\\n\";\n    $startlabel=$self->start;\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos2))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos2))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!)\"; return (-1);\n    ##  }\n    ##}\n    $startlabel=$self->label($pos1);\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  }\n  unless (defined ($pos2)) {\n    #print \"\\n##### pos2 not defined\\n\";\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos1))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos1))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!\"); return (-1);\n    ##  }\n    ##}\n    $endlabel=$self->label($pos2);\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  }\n  #print \"\\n    ####DEBUG: start $startlabel end $endlabel length $length strand $strand\\n\";\n\n  if ($strand == 1) {\n    $str = $self->{'seq'}->down_chain2string($startlabel,$length,$endlabel);\n  } else { # reverse strand\n    $str = $self->{'seq'}->up_chain2string($startlabel,$length,$endlabel);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n  }\n  return $str;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $seq->length();\n  Function: returns the number of nucleotides (or the number of aminoacids)\n            in the entire sequence\n  Returns : an integer\n  Errorcode -1\n  Args    : none\n\n\nsub length {\n  my $self=shift;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  if ($strand == 1) {\n    return $self->{'seq'}->down_subchain_length($start,$end);\n  } else {\n    return $self->{'seq'}->up_subchain_length($start,$end);\n  }\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, alias the common name of the object\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information.\n\n See also: accession_number\n Returns : a string\n Args    : none\n\n\nsub display_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'display_id'} = $value;\n  }\n  return $self->{'display_id'};\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number.\n           Notice that primary_id() provides the unique id for the\n           implemetation, allowing multiple objects to have the same accession\n           number in a particular implementation.\n\n           For objects with no accession_number this method returns \"unknown\".\n Returns : a string\n Args    : none\n\n\nsub accession_number {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'accession_number'} = $value;\n  }\n  unless (exists $self->{'accession_number'}) {\n    return \"unknown\";\n  } else {\n    return $self->{'accession_number'};\n  }\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their own\n           object ids in a way the implementation can control. Clients can\n           expect one id to map to one object.\n\n           For sequences with no primary_id, this method returns\n           a stringified memory location.\n\n Returns : A string\n Args    : None\n\n\n\nsub primary_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'primary_id'} = $value;\n  }\n  unless (exists $self->{'primary_id'}) {\n    return \"$self\";\n  } else {\n    return $self->{'primary_id'};\n  }\n}\n\n=head2 change\n\n Title   : change\n Usage   : $substring = $obj->change('AA', 10);\n Function: changes, modifies, mutates the LiveSequence\n Examples:\n        $obj->change('',   10);      delete nucleotide #10     \n        $obj->change('',   10, 2);   delete two nucleotides starting from #10\n        $obj->change('G',  10);      change nuc #10 to 'G'\n        $obj->change('GA', 10, 4);   replace #10 and 3 following with 'GA'\n        $obj->change('GA', 10, 2));  is same as $obj->change('GA',  10);\n        $obj->change('GA', 10, 0 );  insert 'GA' before nucleotide at #10\n        $obj->change('GA', 10, 1);   GA inserted before #10, #10 deleted\n        $obj->change('GATC', 10, 2); GATC inserted before #10, #10&#11 deleted\n        $obj->change('GATC', 10, 6); GATC inserted before #10, #10-#15 deleted\n\n\n Returns : a string of deleted bases (if any) or 1 (everything OK)\n Errorcode: -1\n Args    : seq,    string, or '' ('' = undef = 0 = deletion)\n           start,  integer\n           length, integer (optional)\n\n\nsub change {\n  &positionchange;\n}\n\n=head2 positionchange\n\n Title   : positionchange\n Function: Exactly like change. I.e. change() defaults to positionchange()\n\n\nsub positionchange {\n  my ($self,$newseq,$position,$length)=@_;\n  unless ($position) {\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  my $label=$self->label($position);\n  unless ($label > 0) { # label not found or error\n    $self->warn(\"No valid label found at that position!\");\n    return (-1);\n  }\n  return ($self->labelchange($newseq,$label,$length));\n}\n\n=head2 labelchange\n\n Title   : labelchange\n Function: Exactly like change but uses a /label/ instead than a position\n           as second argument. This allows for multiple changes in a LiveSeq\n           without the burden of recomputing positions. I.e. for a multiple\n           change in two different points of the LiveSeq, the approach would\n           be the following: fetch the correct labels out of the two different\n           positions (method: label($position)) and then use the labelchange()\n           method to modify the sequence using those labels instead than\n           relying on the positions (that would have modified after the\n           first change).\n\n\nsub labelchange {\n  my ($self,$newseq,$label,$length)=@_;\n  unless ($self->valid($label)) {\n    if ($self->{'seq'}->valid($label)) {\n       #$self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change for the object asked but it's ok for DNAlevel change, reverting to that\");\n      shift @_;\n      return($self->{'seq'}->labelchange(@_));\n    } else {\n      $self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change\");\n      return (-1);\n    }\n  }\n  unless ($newseq) { # it means this is a simple deletion\n    if (defined($length)) {\n      unless ($length >= 0) {\n\t$self->warn(\"No sense having length < 0 in a deletion\");\n\treturn (-1);\n      }\n    } else {\n      $self->warn(\"Length not defined for deletion!\");\n      return (-1);\n    }\n    return $self->_delete($label,$length);\n  }\n  my $newseqlength=CORE::length($newseq);\n  if (defined($length)) {\n    unless ($length >= 0) {\n      $self->warn(\"No sense having length < 0 in a change()\");\n      return (-1);\n    }\n  } else {\n    $length=$newseqlength; # defaults to pointmutation(s)\n  }\n  if ($length == 0) { # it means this is a simple insertion, length def&==0\n    my ($insertbegin,$insertend)=$self->_praeinsert($label,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n  if ($newseqlength == $length) { # it means this is simple pointmutation(s)\n    return $self->_mutate($label,$newseq,$length);\n  }\n  # if we arrived here then change is complex mixture\n  my $strand=$self->strand();\n  my $afterendlabel=$self->label($length+1,$label,$strand); # get the label at $length+1 positions after $label\n  unless ($afterendlabel > 0) { # label not found or error\n    $self->warn(\"No valid afterendlabel found for executing the complex mutation!\");\n    return (-1);\n  }\n  my $deleted=$self->_delete($label,$length); # first delete length nucs\n  if ($deleted == -1) { # if errors\n    return (-1);\n  } else { # then insert the newsequence\n    my ($insertbegin,$insertend)=$self->_praeinsert($afterendlabel,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n}\n\n# internal methods for change()\n\n# arguments: label for beginning of deletion, new sequence to insert\n# returns: labels of beginning and end of the inserted sequence\n# errorcode: -1\nsub _praeinsert {\n  my ($self,$label,$newseq)=@_;\n  my ($insertbegin,$insertend);\n  my $strand=$self->strand();\n  if ($strand == 1) {\n    ($insertbegin,$insertend)=($self->{'seq'}->praeinsert_string($newseq,$label));\n  } else { # since it's reverse strand and we insert in forward direction....\n    $newseq=reverse($newseq);\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n    ($insertend,$insertbegin)=($self->{'seq'}->postinsert_string($newseq,$label));\n  }\n  if (($insertbegin==0)||($insertend==0)) {\n    $self->warn(\"Some error occurred while inserting!\");\n    return (-1);\n  } else {\n    return ($insertbegin,$insertend);\n  }\n}\n\n# arguments: label for beginning of deletion, length of deletion\n# returns: string of deleted bases\n# errorcode: -1\nsub _delete {\n  my ($self,$label,$length)=@_;\n  my $strand=$self->strand();\n  my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n  unless ($endlabel > 0) { # label not found or error\n    $self->warn(\"No valid endlabel found for executing the deletion!\");\n    return (-1);\n  }\n  # this is important in Transcript to fix exon structure\n  $self->_deletecheck($label,$endlabel);\n  my $deletedseq;\n  if ($strand == 1) {\n    $deletedseq=$self->{'seq'}->splice_chain($label,undef,$endlabel);\n  } else {\n    $deletedseq=$self->{'seq'}->splice_chain($endlabel,undef,$label);\n    $deletedseq=reverse($deletedseq); # because we are on reverse strand and we cut anyway\n                         # in forward direction\n    $deletedseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  return ($deletedseq);\n}\n\n# empty function, overridden in Transcript, not useful here\nsub _deletecheck {\n}\n\n# arguments: label for beginning of mutation, newsequence, number of mutations\n# returns: 1 all OK\n# errorcode: -1\nsub _mutate {\n  my ($self,$label,$newseq,$length)=@_; # length is equal to length(newseq)\n  my ($i,$base,$nextlabel);\n  my @labels; # array of labels\n  my $strand=$self->strand();\n  if ($length == 1) { # special cases first\n    @labels=($label);\n  } else {\n    my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n    unless ($endlabel > 0) { # label not found or error\n      $self->warn(\"No valid endlabel found for executing the mutation!\");\n      return (-1);\n    }\n    if ($length == 2) { # another special case\n      @labels=($label,$endlabel);\n    } else { # more than 3 bases changed\n      # this wouldn't work for Transcript\n      #my $labelsarrayref;\n      #if ($strand == 1) {\n\t#$labelsarrayref=$self->{'seq'}->down_labels($label,$endlabel);\n      #} else {\n\t#$labelsarrayref=$self->{'seq'}->up_labels($label,$endlabel);\n      #}\n      #@labels=@{$labelsarrayref};\n      #if ($length != scalar(@labels)) { # not enough labels returned\n\t#$self->warn(\"Not enough valid labels found for executing the mutation!\");\n\t#return (-1);\n      #}\n\n      # this should be more general\n      @labels=($label); # put the first one\n      while ($label != $endlabel) {\n\t$nextlabel=$self->label(2,$label,$strand); # retrieve the next label\n\tpush (@labels,$nextlabel);\n\t$label=$nextlabel; # move on reference\n      }\n    }\n  }\n  if ($strand == -1) { # only for reverse strand\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  my $errorcheck; # if not equal to $length after summing for all changes, error did occurr\n  $i = 0;\n  foreach $base (split(//,$newseq)) {\n    $errorcheck += $self->{'seq'}->set_value_at_label($base,$labels[$i]);\n    $i++;\n  }\n  if ($errorcheck != $length) {\n    $self->warn(\"Some error occurred while mutating!\");\n    return (-1);\n  } else {\n    return (1);\n  }\n}\n\n=head2 valid\n\n  Title   : valid\n  Usage   : $boolean = $obj->valid($label)\n  Function: tests if a label exists inside the object\n  Returns : boolean\n  Args    : label\n\n argument: label\n returns: 1 YES 0 NO","parameters":[{"label":"$self"},{"label":"$label"}]},"line":692,"kind":12,"range":{"end":{"character":9999,"line":702},"start":{"character":0,"line":692}},"definition":"sub","detail":"($self,$label)","children":[{"definition":"my","line":693,"name":"$self","kind":13,"localvar":"my","containerName":"valid"},{"name":"$label","kind":13,"containerName":"valid","line":693},{"name":"$checkme","localvar":"my","containerName":"valid","kind":13,"line":694,"definition":"my"},{"line":695,"kind":13,"localvar":"my","containerName":"valid","name":"@labels","definition":"my"},{"containerName":"valid","kind":13,"name":"$self","line":695},{"line":695,"kind":12,"containerName":"valid","name":"all_labels"},{"line":696,"kind":13,"containerName":"valid","name":"$checkme"},{"containerName":"valid","kind":13,"name":"@labels","line":696},{"name":"$label","kind":13,"containerName":"valid","line":697},{"line":697,"name":"$checkme","containerName":"valid","kind":13}],"containerName":"main::","name":"valid"},{"detail":"($self)","definition":"sub","name":"start","containerName":"main::","children":[{"definition":"my","line":716,"name":"$self","localvar":"my","kind":13,"containerName":"start"},{"name":"$self","containerName":"start","kind":13,"line":717}],"signature":{"label":"start($self)","documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n\n# NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode) = @_;\n  if (defined $unsecuremode && $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    unless ($start) {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length;\n      }\n    } else {\n      unless ($length) {\n\t$end=$self->end;\n      }\n    }\n  } else {\n    if ($start) {\n      unless ($self->{'seq'}->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tunless ($self->{'seq'}->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n\tundef $length;\n      }\n    }\n  }\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,$length,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,$length,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n         : $substring = $obj->subseq(10,undef,4);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal.\n\n           Allows for negative numbers $obj->subseq(-10,-1). By\n           definition, there is no 0!\n                       -5  -1 1   5\n                gctagcgcccaac atggctcgctg\n\n           This allows to retrieve sequences upstream from given position.\n\n           The precedence is from left to right: if END is given LENGTH is\n           ignored.\n\n Examples: $obj->subseq(-10,undef,10) returns 10 elements before position 1\n           $obj->subseq(4,8) returns elements from the 4th to the 8th, inclusive\n\n Returns : a string\n Errorcode: -1\n Args    : start,  integer, defaults to start of the sequence\n           end,    integer, '' or undef, defaults to end of the sequence\n           length, integer, '' or undef\n           an optional strand (1 or -1) 4th argument \n            if strand argument is not given, it will default to the object\n            argment. This argument is useful when a call is issued from a child\n            of a parent object containing the subseq method\n\n\n#'\n# check the fact about reverse strand!\n# is it feasible? Is it correct? Should we do it? How about exons? Does it\n# work when you ask subseq of an exon?\n# eliminated now (Mon night)\nsub subseq {\n  ##my ($self,$pos1,$pos2,$length,$strand) = @_;\n  my ($self,$pos1,$pos2,$length,$strand) = @_;\n  ##unless (defined ($strand)) { # if optional [strand] argument not given\n  ##  $strand=$self->strand;\n  ##}\n  $strand=$self->strand;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  unless (defined ($pos1)) {\n    #print \"\\n##### DEBUG pos1 not defined\\n\";\n    $startlabel=$self->start;\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos2))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos2))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!)\"; return (-1);\n    ##  }\n    ##}\n    $startlabel=$self->label($pos1);\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  }\n  unless (defined ($pos2)) {\n    #print \"\\n##### pos2 not defined\\n\";\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos1))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos1))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!\"); return (-1);\n    ##  }\n    ##}\n    $endlabel=$self->label($pos2);\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  }\n  #print \"\\n    ####DEBUG: start $startlabel end $endlabel length $length strand $strand\\n\";\n\n  if ($strand == 1) {\n    $str = $self->{'seq'}->down_chain2string($startlabel,$length,$endlabel);\n  } else { # reverse strand\n    $str = $self->{'seq'}->up_chain2string($startlabel,$length,$endlabel);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n  }\n  return $str;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $seq->length();\n  Function: returns the number of nucleotides (or the number of aminoacids)\n            in the entire sequence\n  Returns : an integer\n  Errorcode -1\n  Args    : none\n\n\nsub length {\n  my $self=shift;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  if ($strand == 1) {\n    return $self->{'seq'}->down_subchain_length($start,$end);\n  } else {\n    return $self->{'seq'}->up_subchain_length($start,$end);\n  }\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, alias the common name of the object\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information.\n\n See also: accession_number\n Returns : a string\n Args    : none\n\n\nsub display_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'display_id'} = $value;\n  }\n  return $self->{'display_id'};\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number.\n           Notice that primary_id() provides the unique id for the\n           implemetation, allowing multiple objects to have the same accession\n           number in a particular implementation.\n\n           For objects with no accession_number this method returns \"unknown\".\n Returns : a string\n Args    : none\n\n\nsub accession_number {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'accession_number'} = $value;\n  }\n  unless (exists $self->{'accession_number'}) {\n    return \"unknown\";\n  } else {\n    return $self->{'accession_number'};\n  }\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their own\n           object ids in a way the implementation can control. Clients can\n           expect one id to map to one object.\n\n           For sequences with no primary_id, this method returns\n           a stringified memory location.\n\n Returns : A string\n Args    : None\n\n\n\nsub primary_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'primary_id'} = $value;\n  }\n  unless (exists $self->{'primary_id'}) {\n    return \"$self\";\n  } else {\n    return $self->{'primary_id'};\n  }\n}\n\n=head2 change\n\n Title   : change\n Usage   : $substring = $obj->change('AA', 10);\n Function: changes, modifies, mutates the LiveSequence\n Examples:\n        $obj->change('',   10);      delete nucleotide #10     \n        $obj->change('',   10, 2);   delete two nucleotides starting from #10\n        $obj->change('G',  10);      change nuc #10 to 'G'\n        $obj->change('GA', 10, 4);   replace #10 and 3 following with 'GA'\n        $obj->change('GA', 10, 2));  is same as $obj->change('GA',  10);\n        $obj->change('GA', 10, 0 );  insert 'GA' before nucleotide at #10\n        $obj->change('GA', 10, 1);   GA inserted before #10, #10 deleted\n        $obj->change('GATC', 10, 2); GATC inserted before #10, #10&#11 deleted\n        $obj->change('GATC', 10, 6); GATC inserted before #10, #10-#15 deleted\n\n\n Returns : a string of deleted bases (if any) or 1 (everything OK)\n Errorcode: -1\n Args    : seq,    string, or '' ('' = undef = 0 = deletion)\n           start,  integer\n           length, integer (optional)\n\n\nsub change {\n  &positionchange;\n}\n\n=head2 positionchange\n\n Title   : positionchange\n Function: Exactly like change. I.e. change() defaults to positionchange()\n\n\nsub positionchange {\n  my ($self,$newseq,$position,$length)=@_;\n  unless ($position) {\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  my $label=$self->label($position);\n  unless ($label > 0) { # label not found or error\n    $self->warn(\"No valid label found at that position!\");\n    return (-1);\n  }\n  return ($self->labelchange($newseq,$label,$length));\n}\n\n=head2 labelchange\n\n Title   : labelchange\n Function: Exactly like change but uses a /label/ instead than a position\n           as second argument. This allows for multiple changes in a LiveSeq\n           without the burden of recomputing positions. I.e. for a multiple\n           change in two different points of the LiveSeq, the approach would\n           be the following: fetch the correct labels out of the two different\n           positions (method: label($position)) and then use the labelchange()\n           method to modify the sequence using those labels instead than\n           relying on the positions (that would have modified after the\n           first change).\n\n\nsub labelchange {\n  my ($self,$newseq,$label,$length)=@_;\n  unless ($self->valid($label)) {\n    if ($self->{'seq'}->valid($label)) {\n       #$self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change for the object asked but it's ok for DNAlevel change, reverting to that\");\n      shift @_;\n      return($self->{'seq'}->labelchange(@_));\n    } else {\n      $self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change\");\n      return (-1);\n    }\n  }\n  unless ($newseq) { # it means this is a simple deletion\n    if (defined($length)) {\n      unless ($length >= 0) {\n\t$self->warn(\"No sense having length < 0 in a deletion\");\n\treturn (-1);\n      }\n    } else {\n      $self->warn(\"Length not defined for deletion!\");\n      return (-1);\n    }\n    return $self->_delete($label,$length);\n  }\n  my $newseqlength=CORE::length($newseq);\n  if (defined($length)) {\n    unless ($length >= 0) {\n      $self->warn(\"No sense having length < 0 in a change()\");\n      return (-1);\n    }\n  } else {\n    $length=$newseqlength; # defaults to pointmutation(s)\n  }\n  if ($length == 0) { # it means this is a simple insertion, length def&==0\n    my ($insertbegin,$insertend)=$self->_praeinsert($label,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n  if ($newseqlength == $length) { # it means this is simple pointmutation(s)\n    return $self->_mutate($label,$newseq,$length);\n  }\n  # if we arrived here then change is complex mixture\n  my $strand=$self->strand();\n  my $afterendlabel=$self->label($length+1,$label,$strand); # get the label at $length+1 positions after $label\n  unless ($afterendlabel > 0) { # label not found or error\n    $self->warn(\"No valid afterendlabel found for executing the complex mutation!\");\n    return (-1);\n  }\n  my $deleted=$self->_delete($label,$length); # first delete length nucs\n  if ($deleted == -1) { # if errors\n    return (-1);\n  } else { # then insert the newsequence\n    my ($insertbegin,$insertend)=$self->_praeinsert($afterendlabel,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n}\n\n# internal methods for change()\n\n# arguments: label for beginning of deletion, new sequence to insert\n# returns: labels of beginning and end of the inserted sequence\n# errorcode: -1\nsub _praeinsert {\n  my ($self,$label,$newseq)=@_;\n  my ($insertbegin,$insertend);\n  my $strand=$self->strand();\n  if ($strand == 1) {\n    ($insertbegin,$insertend)=($self->{'seq'}->praeinsert_string($newseq,$label));\n  } else { # since it's reverse strand and we insert in forward direction....\n    $newseq=reverse($newseq);\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n    ($insertend,$insertbegin)=($self->{'seq'}->postinsert_string($newseq,$label));\n  }\n  if (($insertbegin==0)||($insertend==0)) {\n    $self->warn(\"Some error occurred while inserting!\");\n    return (-1);\n  } else {\n    return ($insertbegin,$insertend);\n  }\n}\n\n# arguments: label for beginning of deletion, length of deletion\n# returns: string of deleted bases\n# errorcode: -1\nsub _delete {\n  my ($self,$label,$length)=@_;\n  my $strand=$self->strand();\n  my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n  unless ($endlabel > 0) { # label not found or error\n    $self->warn(\"No valid endlabel found for executing the deletion!\");\n    return (-1);\n  }\n  # this is important in Transcript to fix exon structure\n  $self->_deletecheck($label,$endlabel);\n  my $deletedseq;\n  if ($strand == 1) {\n    $deletedseq=$self->{'seq'}->splice_chain($label,undef,$endlabel);\n  } else {\n    $deletedseq=$self->{'seq'}->splice_chain($endlabel,undef,$label);\n    $deletedseq=reverse($deletedseq); # because we are on reverse strand and we cut anyway\n                         # in forward direction\n    $deletedseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  return ($deletedseq);\n}\n\n# empty function, overridden in Transcript, not useful here\nsub _deletecheck {\n}\n\n# arguments: label for beginning of mutation, newsequence, number of mutations\n# returns: 1 all OK\n# errorcode: -1\nsub _mutate {\n  my ($self,$label,$newseq,$length)=@_; # length is equal to length(newseq)\n  my ($i,$base,$nextlabel);\n  my @labels; # array of labels\n  my $strand=$self->strand();\n  if ($length == 1) { # special cases first\n    @labels=($label);\n  } else {\n    my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n    unless ($endlabel > 0) { # label not found or error\n      $self->warn(\"No valid endlabel found for executing the mutation!\");\n      return (-1);\n    }\n    if ($length == 2) { # another special case\n      @labels=($label,$endlabel);\n    } else { # more than 3 bases changed\n      # this wouldn't work for Transcript\n      #my $labelsarrayref;\n      #if ($strand == 1) {\n\t#$labelsarrayref=$self->{'seq'}->down_labels($label,$endlabel);\n      #} else {\n\t#$labelsarrayref=$self->{'seq'}->up_labels($label,$endlabel);\n      #}\n      #@labels=@{$labelsarrayref};\n      #if ($length != scalar(@labels)) { # not enough labels returned\n\t#$self->warn(\"Not enough valid labels found for executing the mutation!\");\n\t#return (-1);\n      #}\n\n      # this should be more general\n      @labels=($label); # put the first one\n      while ($label != $endlabel) {\n\t$nextlabel=$self->label(2,$label,$strand); # retrieve the next label\n\tpush (@labels,$nextlabel);\n\t$label=$nextlabel; # move on reference\n      }\n    }\n  }\n  if ($strand == -1) { # only for reverse strand\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  my $errorcheck; # if not equal to $length after summing for all changes, error did occurr\n  $i = 0;\n  foreach $base (split(//,$newseq)) {\n    $errorcheck += $self->{'seq'}->set_value_at_label($base,$labels[$i]);\n    $i++;\n  }\n  if ($errorcheck != $length) {\n    $self->warn(\"Some error occurred while mutating!\");\n    return (-1);\n  } else {\n    return (1);\n  }\n}\n\n=head2 valid\n\n  Title   : valid\n  Usage   : $boolean = $obj->valid($label)\n  Function: tests if a label exists inside the object\n  Returns : boolean\n  Args    : label\n\n\n# argument: label\n# returns: 1 YES 0 NO\nsub valid {\n  my ($self,$label)=@_;\n  my $checkme;\n  my @labels=$self->all_labels;\n  foreach $checkme (@labels) {\n    if ($label == $checkme) {\n      return (1); # found\n    }\n  }\n  return (0); # not found\n}\n\n\n=head2 start\n\n  Title   : start\n  Usage   : $startlabel=$obj->start()\n  Function: returns the label of the first nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none","parameters":[{"label":"$self"}]},"kind":12,"range":{"start":{"line":715,"character":0},"end":{"line":718,"character":9999}},"line":715},{"detail":"($self)","definition":"sub","name":"end","containerName":"main::","children":[{"definition":"my","containerName":"end","localvar":"my","kind":13,"name":"$self","line":731},{"containerName":"end","kind":13,"name":"$self","line":732}],"signature":{"label":"end($self)","documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n\n# NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode) = @_;\n  if (defined $unsecuremode && $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    unless ($start) {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length;\n      }\n    } else {\n      unless ($length) {\n\t$end=$self->end;\n      }\n    }\n  } else {\n    if ($start) {\n      unless ($self->{'seq'}->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tunless ($self->{'seq'}->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n\tundef $length;\n      }\n    }\n  }\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,$length,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,$length,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n         : $substring = $obj->subseq(10,undef,4);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal.\n\n           Allows for negative numbers $obj->subseq(-10,-1). By\n           definition, there is no 0!\n                       -5  -1 1   5\n                gctagcgcccaac atggctcgctg\n\n           This allows to retrieve sequences upstream from given position.\n\n           The precedence is from left to right: if END is given LENGTH is\n           ignored.\n\n Examples: $obj->subseq(-10,undef,10) returns 10 elements before position 1\n           $obj->subseq(4,8) returns elements from the 4th to the 8th, inclusive\n\n Returns : a string\n Errorcode: -1\n Args    : start,  integer, defaults to start of the sequence\n           end,    integer, '' or undef, defaults to end of the sequence\n           length, integer, '' or undef\n           an optional strand (1 or -1) 4th argument \n            if strand argument is not given, it will default to the object\n            argment. This argument is useful when a call is issued from a child\n            of a parent object containing the subseq method\n\n\n#'\n# check the fact about reverse strand!\n# is it feasible? Is it correct? Should we do it? How about exons? Does it\n# work when you ask subseq of an exon?\n# eliminated now (Mon night)\nsub subseq {\n  ##my ($self,$pos1,$pos2,$length,$strand) = @_;\n  my ($self,$pos1,$pos2,$length,$strand) = @_;\n  ##unless (defined ($strand)) { # if optional [strand] argument not given\n  ##  $strand=$self->strand;\n  ##}\n  $strand=$self->strand;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  unless (defined ($pos1)) {\n    #print \"\\n##### DEBUG pos1 not defined\\n\";\n    $startlabel=$self->start;\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos2))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos2))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!)\"; return (-1);\n    ##  }\n    ##}\n    $startlabel=$self->label($pos1);\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  }\n  unless (defined ($pos2)) {\n    #print \"\\n##### pos2 not defined\\n\";\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos1))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos1))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!\"); return (-1);\n    ##  }\n    ##}\n    $endlabel=$self->label($pos2);\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  }\n  #print \"\\n    ####DEBUG: start $startlabel end $endlabel length $length strand $strand\\n\";\n\n  if ($strand == 1) {\n    $str = $self->{'seq'}->down_chain2string($startlabel,$length,$endlabel);\n  } else { # reverse strand\n    $str = $self->{'seq'}->up_chain2string($startlabel,$length,$endlabel);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n  }\n  return $str;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $seq->length();\n  Function: returns the number of nucleotides (or the number of aminoacids)\n            in the entire sequence\n  Returns : an integer\n  Errorcode -1\n  Args    : none\n\n\nsub length {\n  my $self=shift;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  if ($strand == 1) {\n    return $self->{'seq'}->down_subchain_length($start,$end);\n  } else {\n    return $self->{'seq'}->up_subchain_length($start,$end);\n  }\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, alias the common name of the object\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information.\n\n See also: accession_number\n Returns : a string\n Args    : none\n\n\nsub display_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'display_id'} = $value;\n  }\n  return $self->{'display_id'};\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number.\n           Notice that primary_id() provides the unique id for the\n           implemetation, allowing multiple objects to have the same accession\n           number in a particular implementation.\n\n           For objects with no accession_number this method returns \"unknown\".\n Returns : a string\n Args    : none\n\n\nsub accession_number {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'accession_number'} = $value;\n  }\n  unless (exists $self->{'accession_number'}) {\n    return \"unknown\";\n  } else {\n    return $self->{'accession_number'};\n  }\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their own\n           object ids in a way the implementation can control. Clients can\n           expect one id to map to one object.\n\n           For sequences with no primary_id, this method returns\n           a stringified memory location.\n\n Returns : A string\n Args    : None\n\n\n\nsub primary_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'primary_id'} = $value;\n  }\n  unless (exists $self->{'primary_id'}) {\n    return \"$self\";\n  } else {\n    return $self->{'primary_id'};\n  }\n}\n\n=head2 change\n\n Title   : change\n Usage   : $substring = $obj->change('AA', 10);\n Function: changes, modifies, mutates the LiveSequence\n Examples:\n        $obj->change('',   10);      delete nucleotide #10     \n        $obj->change('',   10, 2);   delete two nucleotides starting from #10\n        $obj->change('G',  10);      change nuc #10 to 'G'\n        $obj->change('GA', 10, 4);   replace #10 and 3 following with 'GA'\n        $obj->change('GA', 10, 2));  is same as $obj->change('GA',  10);\n        $obj->change('GA', 10, 0 );  insert 'GA' before nucleotide at #10\n        $obj->change('GA', 10, 1);   GA inserted before #10, #10 deleted\n        $obj->change('GATC', 10, 2); GATC inserted before #10, #10&#11 deleted\n        $obj->change('GATC', 10, 6); GATC inserted before #10, #10-#15 deleted\n\n\n Returns : a string of deleted bases (if any) or 1 (everything OK)\n Errorcode: -1\n Args    : seq,    string, or '' ('' = undef = 0 = deletion)\n           start,  integer\n           length, integer (optional)\n\n\nsub change {\n  &positionchange;\n}\n\n=head2 positionchange\n\n Title   : positionchange\n Function: Exactly like change. I.e. change() defaults to positionchange()\n\n\nsub positionchange {\n  my ($self,$newseq,$position,$length)=@_;\n  unless ($position) {\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  my $label=$self->label($position);\n  unless ($label > 0) { # label not found or error\n    $self->warn(\"No valid label found at that position!\");\n    return (-1);\n  }\n  return ($self->labelchange($newseq,$label,$length));\n}\n\n=head2 labelchange\n\n Title   : labelchange\n Function: Exactly like change but uses a /label/ instead than a position\n           as second argument. This allows for multiple changes in a LiveSeq\n           without the burden of recomputing positions. I.e. for a multiple\n           change in two different points of the LiveSeq, the approach would\n           be the following: fetch the correct labels out of the two different\n           positions (method: label($position)) and then use the labelchange()\n           method to modify the sequence using those labels instead than\n           relying on the positions (that would have modified after the\n           first change).\n\n\nsub labelchange {\n  my ($self,$newseq,$label,$length)=@_;\n  unless ($self->valid($label)) {\n    if ($self->{'seq'}->valid($label)) {\n       #$self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change for the object asked but it's ok for DNAlevel change, reverting to that\");\n      shift @_;\n      return($self->{'seq'}->labelchange(@_));\n    } else {\n      $self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change\");\n      return (-1);\n    }\n  }\n  unless ($newseq) { # it means this is a simple deletion\n    if (defined($length)) {\n      unless ($length >= 0) {\n\t$self->warn(\"No sense having length < 0 in a deletion\");\n\treturn (-1);\n      }\n    } else {\n      $self->warn(\"Length not defined for deletion!\");\n      return (-1);\n    }\n    return $self->_delete($label,$length);\n  }\n  my $newseqlength=CORE::length($newseq);\n  if (defined($length)) {\n    unless ($length >= 0) {\n      $self->warn(\"No sense having length < 0 in a change()\");\n      return (-1);\n    }\n  } else {\n    $length=$newseqlength; # defaults to pointmutation(s)\n  }\n  if ($length == 0) { # it means this is a simple insertion, length def&==0\n    my ($insertbegin,$insertend)=$self->_praeinsert($label,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n  if ($newseqlength == $length) { # it means this is simple pointmutation(s)\n    return $self->_mutate($label,$newseq,$length);\n  }\n  # if we arrived here then change is complex mixture\n  my $strand=$self->strand();\n  my $afterendlabel=$self->label($length+1,$label,$strand); # get the label at $length+1 positions after $label\n  unless ($afterendlabel > 0) { # label not found or error\n    $self->warn(\"No valid afterendlabel found for executing the complex mutation!\");\n    return (-1);\n  }\n  my $deleted=$self->_delete($label,$length); # first delete length nucs\n  if ($deleted == -1) { # if errors\n    return (-1);\n  } else { # then insert the newsequence\n    my ($insertbegin,$insertend)=$self->_praeinsert($afterendlabel,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n}\n\n# internal methods for change()\n\n# arguments: label for beginning of deletion, new sequence to insert\n# returns: labels of beginning and end of the inserted sequence\n# errorcode: -1\nsub _praeinsert {\n  my ($self,$label,$newseq)=@_;\n  my ($insertbegin,$insertend);\n  my $strand=$self->strand();\n  if ($strand == 1) {\n    ($insertbegin,$insertend)=($self->{'seq'}->praeinsert_string($newseq,$label));\n  } else { # since it's reverse strand and we insert in forward direction....\n    $newseq=reverse($newseq);\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n    ($insertend,$insertbegin)=($self->{'seq'}->postinsert_string($newseq,$label));\n  }\n  if (($insertbegin==0)||($insertend==0)) {\n    $self->warn(\"Some error occurred while inserting!\");\n    return (-1);\n  } else {\n    return ($insertbegin,$insertend);\n  }\n}\n\n# arguments: label for beginning of deletion, length of deletion\n# returns: string of deleted bases\n# errorcode: -1\nsub _delete {\n  my ($self,$label,$length)=@_;\n  my $strand=$self->strand();\n  my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n  unless ($endlabel > 0) { # label not found or error\n    $self->warn(\"No valid endlabel found for executing the deletion!\");\n    return (-1);\n  }\n  # this is important in Transcript to fix exon structure\n  $self->_deletecheck($label,$endlabel);\n  my $deletedseq;\n  if ($strand == 1) {\n    $deletedseq=$self->{'seq'}->splice_chain($label,undef,$endlabel);\n  } else {\n    $deletedseq=$self->{'seq'}->splice_chain($endlabel,undef,$label);\n    $deletedseq=reverse($deletedseq); # because we are on reverse strand and we cut anyway\n                         # in forward direction\n    $deletedseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  return ($deletedseq);\n}\n\n# empty function, overridden in Transcript, not useful here\nsub _deletecheck {\n}\n\n# arguments: label for beginning of mutation, newsequence, number of mutations\n# returns: 1 all OK\n# errorcode: -1\nsub _mutate {\n  my ($self,$label,$newseq,$length)=@_; # length is equal to length(newseq)\n  my ($i,$base,$nextlabel);\n  my @labels; # array of labels\n  my $strand=$self->strand();\n  if ($length == 1) { # special cases first\n    @labels=($label);\n  } else {\n    my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n    unless ($endlabel > 0) { # label not found or error\n      $self->warn(\"No valid endlabel found for executing the mutation!\");\n      return (-1);\n    }\n    if ($length == 2) { # another special case\n      @labels=($label,$endlabel);\n    } else { # more than 3 bases changed\n      # this wouldn't work for Transcript\n      #my $labelsarrayref;\n      #if ($strand == 1) {\n\t#$labelsarrayref=$self->{'seq'}->down_labels($label,$endlabel);\n      #} else {\n\t#$labelsarrayref=$self->{'seq'}->up_labels($label,$endlabel);\n      #}\n      #@labels=@{$labelsarrayref};\n      #if ($length != scalar(@labels)) { # not enough labels returned\n\t#$self->warn(\"Not enough valid labels found for executing the mutation!\");\n\t#return (-1);\n      #}\n\n      # this should be more general\n      @labels=($label); # put the first one\n      while ($label != $endlabel) {\n\t$nextlabel=$self->label(2,$label,$strand); # retrieve the next label\n\tpush (@labels,$nextlabel);\n\t$label=$nextlabel; # move on reference\n      }\n    }\n  }\n  if ($strand == -1) { # only for reverse strand\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  my $errorcheck; # if not equal to $length after summing for all changes, error did occurr\n  $i = 0;\n  foreach $base (split(//,$newseq)) {\n    $errorcheck += $self->{'seq'}->set_value_at_label($base,$labels[$i]);\n    $i++;\n  }\n  if ($errorcheck != $length) {\n    $self->warn(\"Some error occurred while mutating!\");\n    return (-1);\n  } else {\n    return (1);\n  }\n}\n\n=head2 valid\n\n  Title   : valid\n  Usage   : $boolean = $obj->valid($label)\n  Function: tests if a label exists inside the object\n  Returns : boolean\n  Args    : label\n\n\n# argument: label\n# returns: 1 YES 0 NO\nsub valid {\n  my ($self,$label)=@_;\n  my $checkme;\n  my @labels=$self->all_labels;\n  foreach $checkme (@labels) {\n    if ($label == $checkme) {\n      return (1); # found\n    }\n  }\n  return (0); # not found\n}\n\n\n=head2 start\n\n  Title   : start\n  Usage   : $startlabel=$obj->start()\n  Function: returns the label of the first nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub start {\n  my ($self) = @_;\n  return $self->{'start'}; # common for all classes BUT DNA (which redefines it) and Transcript (that takes the information from the Exons)\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $endlabel=$obj->end()\n  Function: returns the label of the last nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none","parameters":[{"label":"$self"}]},"kind":12,"range":{"end":{"character":9999,"line":733},"start":{"line":730,"character":0}},"line":730},{"detail":"($self,$strand)","definition":"sub","name":"strand","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"strand","name":"$self","line":747,"definition":"my"},{"line":747,"name":"$strand","kind":13,"containerName":"strand"},{"line":748,"name":"$strand","containerName":"strand","kind":13},{"kind":13,"containerName":"strand","name":"$strand","line":749},{"line":749,"name":"$strand","kind":13,"containerName":"strand"},{"line":750,"kind":13,"containerName":"strand","name":"$self"},{"containerName":"strand","kind":12,"name":"warn","line":750},{"line":752,"kind":13,"containerName":"strand","name":"$self"},{"name":"$strand","containerName":"strand","kind":13,"line":752},{"containerName":"strand","kind":13,"name":"$self","line":755}],"signature":{"label":"strand($self,$strand)","documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n\n# NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode) = @_;\n  if (defined $unsecuremode && $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    unless ($start) {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length;\n      }\n    } else {\n      unless ($length) {\n\t$end=$self->end;\n      }\n    }\n  } else {\n    if ($start) {\n      unless ($self->{'seq'}->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tunless ($self->{'seq'}->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n\tundef $length;\n      }\n    }\n  }\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,$length,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,$length,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n         : $substring = $obj->subseq(10,undef,4);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal.\n\n           Allows for negative numbers $obj->subseq(-10,-1). By\n           definition, there is no 0!\n                       -5  -1 1   5\n                gctagcgcccaac atggctcgctg\n\n           This allows to retrieve sequences upstream from given position.\n\n           The precedence is from left to right: if END is given LENGTH is\n           ignored.\n\n Examples: $obj->subseq(-10,undef,10) returns 10 elements before position 1\n           $obj->subseq(4,8) returns elements from the 4th to the 8th, inclusive\n\n Returns : a string\n Errorcode: -1\n Args    : start,  integer, defaults to start of the sequence\n           end,    integer, '' or undef, defaults to end of the sequence\n           length, integer, '' or undef\n           an optional strand (1 or -1) 4th argument \n            if strand argument is not given, it will default to the object\n            argment. This argument is useful when a call is issued from a child\n            of a parent object containing the subseq method\n\n\n#'\n# check the fact about reverse strand!\n# is it feasible? Is it correct? Should we do it? How about exons? Does it\n# work when you ask subseq of an exon?\n# eliminated now (Mon night)\nsub subseq {\n  ##my ($self,$pos1,$pos2,$length,$strand) = @_;\n  my ($self,$pos1,$pos2,$length,$strand) = @_;\n  ##unless (defined ($strand)) { # if optional [strand] argument not given\n  ##  $strand=$self->strand;\n  ##}\n  $strand=$self->strand;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  unless (defined ($pos1)) {\n    #print \"\\n##### DEBUG pos1 not defined\\n\";\n    $startlabel=$self->start;\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos2))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos2))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!)\"; return (-1);\n    ##  }\n    ##}\n    $startlabel=$self->label($pos1);\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  }\n  unless (defined ($pos2)) {\n    #print \"\\n##### pos2 not defined\\n\";\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos1))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos1))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!\"); return (-1);\n    ##  }\n    ##}\n    $endlabel=$self->label($pos2);\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  }\n  #print \"\\n    ####DEBUG: start $startlabel end $endlabel length $length strand $strand\\n\";\n\n  if ($strand == 1) {\n    $str = $self->{'seq'}->down_chain2string($startlabel,$length,$endlabel);\n  } else { # reverse strand\n    $str = $self->{'seq'}->up_chain2string($startlabel,$length,$endlabel);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n  }\n  return $str;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $seq->length();\n  Function: returns the number of nucleotides (or the number of aminoacids)\n            in the entire sequence\n  Returns : an integer\n  Errorcode -1\n  Args    : none\n\n\nsub length {\n  my $self=shift;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  if ($strand == 1) {\n    return $self->{'seq'}->down_subchain_length($start,$end);\n  } else {\n    return $self->{'seq'}->up_subchain_length($start,$end);\n  }\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, alias the common name of the object\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information.\n\n See also: accession_number\n Returns : a string\n Args    : none\n\n\nsub display_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'display_id'} = $value;\n  }\n  return $self->{'display_id'};\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number.\n           Notice that primary_id() provides the unique id for the\n           implemetation, allowing multiple objects to have the same accession\n           number in a particular implementation.\n\n           For objects with no accession_number this method returns \"unknown\".\n Returns : a string\n Args    : none\n\n\nsub accession_number {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'accession_number'} = $value;\n  }\n  unless (exists $self->{'accession_number'}) {\n    return \"unknown\";\n  } else {\n    return $self->{'accession_number'};\n  }\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their own\n           object ids in a way the implementation can control. Clients can\n           expect one id to map to one object.\n\n           For sequences with no primary_id, this method returns\n           a stringified memory location.\n\n Returns : A string\n Args    : None\n\n\n\nsub primary_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'primary_id'} = $value;\n  }\n  unless (exists $self->{'primary_id'}) {\n    return \"$self\";\n  } else {\n    return $self->{'primary_id'};\n  }\n}\n\n=head2 change\n\n Title   : change\n Usage   : $substring = $obj->change('AA', 10);\n Function: changes, modifies, mutates the LiveSequence\n Examples:\n        $obj->change('',   10);      delete nucleotide #10     \n        $obj->change('',   10, 2);   delete two nucleotides starting from #10\n        $obj->change('G',  10);      change nuc #10 to 'G'\n        $obj->change('GA', 10, 4);   replace #10 and 3 following with 'GA'\n        $obj->change('GA', 10, 2));  is same as $obj->change('GA',  10);\n        $obj->change('GA', 10, 0 );  insert 'GA' before nucleotide at #10\n        $obj->change('GA', 10, 1);   GA inserted before #10, #10 deleted\n        $obj->change('GATC', 10, 2); GATC inserted before #10, #10&#11 deleted\n        $obj->change('GATC', 10, 6); GATC inserted before #10, #10-#15 deleted\n\n\n Returns : a string of deleted bases (if any) or 1 (everything OK)\n Errorcode: -1\n Args    : seq,    string, or '' ('' = undef = 0 = deletion)\n           start,  integer\n           length, integer (optional)\n\n\nsub change {\n  &positionchange;\n}\n\n=head2 positionchange\n\n Title   : positionchange\n Function: Exactly like change. I.e. change() defaults to positionchange()\n\n\nsub positionchange {\n  my ($self,$newseq,$position,$length)=@_;\n  unless ($position) {\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  my $label=$self->label($position);\n  unless ($label > 0) { # label not found or error\n    $self->warn(\"No valid label found at that position!\");\n    return (-1);\n  }\n  return ($self->labelchange($newseq,$label,$length));\n}\n\n=head2 labelchange\n\n Title   : labelchange\n Function: Exactly like change but uses a /label/ instead than a position\n           as second argument. This allows for multiple changes in a LiveSeq\n           without the burden of recomputing positions. I.e. for a multiple\n           change in two different points of the LiveSeq, the approach would\n           be the following: fetch the correct labels out of the two different\n           positions (method: label($position)) and then use the labelchange()\n           method to modify the sequence using those labels instead than\n           relying on the positions (that would have modified after the\n           first change).\n\n\nsub labelchange {\n  my ($self,$newseq,$label,$length)=@_;\n  unless ($self->valid($label)) {\n    if ($self->{'seq'}->valid($label)) {\n       #$self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change for the object asked but it's ok for DNAlevel change, reverting to that\");\n      shift @_;\n      return($self->{'seq'}->labelchange(@_));\n    } else {\n      $self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change\");\n      return (-1);\n    }\n  }\n  unless ($newseq) { # it means this is a simple deletion\n    if (defined($length)) {\n      unless ($length >= 0) {\n\t$self->warn(\"No sense having length < 0 in a deletion\");\n\treturn (-1);\n      }\n    } else {\n      $self->warn(\"Length not defined for deletion!\");\n      return (-1);\n    }\n    return $self->_delete($label,$length);\n  }\n  my $newseqlength=CORE::length($newseq);\n  if (defined($length)) {\n    unless ($length >= 0) {\n      $self->warn(\"No sense having length < 0 in a change()\");\n      return (-1);\n    }\n  } else {\n    $length=$newseqlength; # defaults to pointmutation(s)\n  }\n  if ($length == 0) { # it means this is a simple insertion, length def&==0\n    my ($insertbegin,$insertend)=$self->_praeinsert($label,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n  if ($newseqlength == $length) { # it means this is simple pointmutation(s)\n    return $self->_mutate($label,$newseq,$length);\n  }\n  # if we arrived here then change is complex mixture\n  my $strand=$self->strand();\n  my $afterendlabel=$self->label($length+1,$label,$strand); # get the label at $length+1 positions after $label\n  unless ($afterendlabel > 0) { # label not found or error\n    $self->warn(\"No valid afterendlabel found for executing the complex mutation!\");\n    return (-1);\n  }\n  my $deleted=$self->_delete($label,$length); # first delete length nucs\n  if ($deleted == -1) { # if errors\n    return (-1);\n  } else { # then insert the newsequence\n    my ($insertbegin,$insertend)=$self->_praeinsert($afterendlabel,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n}\n\n# internal methods for change()\n\n# arguments: label for beginning of deletion, new sequence to insert\n# returns: labels of beginning and end of the inserted sequence\n# errorcode: -1\nsub _praeinsert {\n  my ($self,$label,$newseq)=@_;\n  my ($insertbegin,$insertend);\n  my $strand=$self->strand();\n  if ($strand == 1) {\n    ($insertbegin,$insertend)=($self->{'seq'}->praeinsert_string($newseq,$label));\n  } else { # since it's reverse strand and we insert in forward direction....\n    $newseq=reverse($newseq);\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n    ($insertend,$insertbegin)=($self->{'seq'}->postinsert_string($newseq,$label));\n  }\n  if (($insertbegin==0)||($insertend==0)) {\n    $self->warn(\"Some error occurred while inserting!\");\n    return (-1);\n  } else {\n    return ($insertbegin,$insertend);\n  }\n}\n\n# arguments: label for beginning of deletion, length of deletion\n# returns: string of deleted bases\n# errorcode: -1\nsub _delete {\n  my ($self,$label,$length)=@_;\n  my $strand=$self->strand();\n  my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n  unless ($endlabel > 0) { # label not found or error\n    $self->warn(\"No valid endlabel found for executing the deletion!\");\n    return (-1);\n  }\n  # this is important in Transcript to fix exon structure\n  $self->_deletecheck($label,$endlabel);\n  my $deletedseq;\n  if ($strand == 1) {\n    $deletedseq=$self->{'seq'}->splice_chain($label,undef,$endlabel);\n  } else {\n    $deletedseq=$self->{'seq'}->splice_chain($endlabel,undef,$label);\n    $deletedseq=reverse($deletedseq); # because we are on reverse strand and we cut anyway\n                         # in forward direction\n    $deletedseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  return ($deletedseq);\n}\n\n# empty function, overridden in Transcript, not useful here\nsub _deletecheck {\n}\n\n# arguments: label for beginning of mutation, newsequence, number of mutations\n# returns: 1 all OK\n# errorcode: -1\nsub _mutate {\n  my ($self,$label,$newseq,$length)=@_; # length is equal to length(newseq)\n  my ($i,$base,$nextlabel);\n  my @labels; # array of labels\n  my $strand=$self->strand();\n  if ($length == 1) { # special cases first\n    @labels=($label);\n  } else {\n    my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n    unless ($endlabel > 0) { # label not found or error\n      $self->warn(\"No valid endlabel found for executing the mutation!\");\n      return (-1);\n    }\n    if ($length == 2) { # another special case\n      @labels=($label,$endlabel);\n    } else { # more than 3 bases changed\n      # this wouldn't work for Transcript\n      #my $labelsarrayref;\n      #if ($strand == 1) {\n\t#$labelsarrayref=$self->{'seq'}->down_labels($label,$endlabel);\n      #} else {\n\t#$labelsarrayref=$self->{'seq'}->up_labels($label,$endlabel);\n      #}\n      #@labels=@{$labelsarrayref};\n      #if ($length != scalar(@labels)) { # not enough labels returned\n\t#$self->warn(\"Not enough valid labels found for executing the mutation!\");\n\t#return (-1);\n      #}\n\n      # this should be more general\n      @labels=($label); # put the first one\n      while ($label != $endlabel) {\n\t$nextlabel=$self->label(2,$label,$strand); # retrieve the next label\n\tpush (@labels,$nextlabel);\n\t$label=$nextlabel; # move on reference\n      }\n    }\n  }\n  if ($strand == -1) { # only for reverse strand\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  my $errorcheck; # if not equal to $length after summing for all changes, error did occurr\n  $i = 0;\n  foreach $base (split(//,$newseq)) {\n    $errorcheck += $self->{'seq'}->set_value_at_label($base,$labels[$i]);\n    $i++;\n  }\n  if ($errorcheck != $length) {\n    $self->warn(\"Some error occurred while mutating!\");\n    return (-1);\n  } else {\n    return (1);\n  }\n}\n\n=head2 valid\n\n  Title   : valid\n  Usage   : $boolean = $obj->valid($label)\n  Function: tests if a label exists inside the object\n  Returns : boolean\n  Args    : label\n\n\n# argument: label\n# returns: 1 YES 0 NO\nsub valid {\n  my ($self,$label)=@_;\n  my $checkme;\n  my @labels=$self->all_labels;\n  foreach $checkme (@labels) {\n    if ($label == $checkme) {\n      return (1); # found\n    }\n  }\n  return (0); # not found\n}\n\n\n=head2 start\n\n  Title   : start\n  Usage   : $startlabel=$obj->start()\n  Function: returns the label of the first nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub start {\n  my ($self) = @_;\n  return $self->{'start'}; # common for all classes BUT DNA (which redefines it) and Transcript (that takes the information from the Exons)\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $endlabel=$obj->end()\n  Function: returns the label of the last nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub end {\n  my ($self) = @_;\n  return $self->{'end'};\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand=$obj->strand()\n            $obj->strand($strand)\n  Function: gets or sets strand information, being 1 or -1 (forward or reverse)\n  Returns : -1 or 1\n  Args    : none OR -1 or 1","parameters":[{"label":"$self"},{"label":"$strand"}]},"kind":12,"range":{"start":{"character":0,"line":746},"end":{"character":9999,"line":756}},"line":746},{"signature":{"documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n\n# NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode) = @_;\n  if (defined $unsecuremode && $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    unless ($start) {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length;\n      }\n    } else {\n      unless ($length) {\n\t$end=$self->end;\n      }\n    }\n  } else {\n    if ($start) {\n      unless ($self->{'seq'}->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tunless ($self->{'seq'}->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n\tundef $length;\n      }\n    }\n  }\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,$length,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,$length,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n         : $substring = $obj->subseq(10,undef,4);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal.\n\n           Allows for negative numbers $obj->subseq(-10,-1). By\n           definition, there is no 0!\n                       -5  -1 1   5\n                gctagcgcccaac atggctcgctg\n\n           This allows to retrieve sequences upstream from given position.\n\n           The precedence is from left to right: if END is given LENGTH is\n           ignored.\n\n Examples: $obj->subseq(-10,undef,10) returns 10 elements before position 1\n           $obj->subseq(4,8) returns elements from the 4th to the 8th, inclusive\n\n Returns : a string\n Errorcode: -1\n Args    : start,  integer, defaults to start of the sequence\n           end,    integer, '' or undef, defaults to end of the sequence\n           length, integer, '' or undef\n           an optional strand (1 or -1) 4th argument \n            if strand argument is not given, it will default to the object\n            argment. This argument is useful when a call is issued from a child\n            of a parent object containing the subseq method\n\n\n#'\n# check the fact about reverse strand!\n# is it feasible? Is it correct? Should we do it? How about exons? Does it\n# work when you ask subseq of an exon?\n# eliminated now (Mon night)\nsub subseq {\n  ##my ($self,$pos1,$pos2,$length,$strand) = @_;\n  my ($self,$pos1,$pos2,$length,$strand) = @_;\n  ##unless (defined ($strand)) { # if optional [strand] argument not given\n  ##  $strand=$self->strand;\n  ##}\n  $strand=$self->strand;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  unless (defined ($pos1)) {\n    #print \"\\n##### DEBUG pos1 not defined\\n\";\n    $startlabel=$self->start;\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos2))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos2))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!)\"; return (-1);\n    ##  }\n    ##}\n    $startlabel=$self->label($pos1);\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  }\n  unless (defined ($pos2)) {\n    #print \"\\n##### pos2 not defined\\n\";\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos1))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos1))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!\"); return (-1);\n    ##  }\n    ##}\n    $endlabel=$self->label($pos2);\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  }\n  #print \"\\n    ####DEBUG: start $startlabel end $endlabel length $length strand $strand\\n\";\n\n  if ($strand == 1) {\n    $str = $self->{'seq'}->down_chain2string($startlabel,$length,$endlabel);\n  } else { # reverse strand\n    $str = $self->{'seq'}->up_chain2string($startlabel,$length,$endlabel);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n  }\n  return $str;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $seq->length();\n  Function: returns the number of nucleotides (or the number of aminoacids)\n            in the entire sequence\n  Returns : an integer\n  Errorcode -1\n  Args    : none\n\n\nsub length {\n  my $self=shift;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  if ($strand == 1) {\n    return $self->{'seq'}->down_subchain_length($start,$end);\n  } else {\n    return $self->{'seq'}->up_subchain_length($start,$end);\n  }\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, alias the common name of the object\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information.\n\n See also: accession_number\n Returns : a string\n Args    : none\n\n\nsub display_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'display_id'} = $value;\n  }\n  return $self->{'display_id'};\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number.\n           Notice that primary_id() provides the unique id for the\n           implemetation, allowing multiple objects to have the same accession\n           number in a particular implementation.\n\n           For objects with no accession_number this method returns \"unknown\".\n Returns : a string\n Args    : none\n\n\nsub accession_number {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'accession_number'} = $value;\n  }\n  unless (exists $self->{'accession_number'}) {\n    return \"unknown\";\n  } else {\n    return $self->{'accession_number'};\n  }\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their own\n           object ids in a way the implementation can control. Clients can\n           expect one id to map to one object.\n\n           For sequences with no primary_id, this method returns\n           a stringified memory location.\n\n Returns : A string\n Args    : None\n\n\n\nsub primary_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'primary_id'} = $value;\n  }\n  unless (exists $self->{'primary_id'}) {\n    return \"$self\";\n  } else {\n    return $self->{'primary_id'};\n  }\n}\n\n=head2 change\n\n Title   : change\n Usage   : $substring = $obj->change('AA', 10);\n Function: changes, modifies, mutates the LiveSequence\n Examples:\n        $obj->change('',   10);      delete nucleotide #10     \n        $obj->change('',   10, 2);   delete two nucleotides starting from #10\n        $obj->change('G',  10);      change nuc #10 to 'G'\n        $obj->change('GA', 10, 4);   replace #10 and 3 following with 'GA'\n        $obj->change('GA', 10, 2));  is same as $obj->change('GA',  10);\n        $obj->change('GA', 10, 0 );  insert 'GA' before nucleotide at #10\n        $obj->change('GA', 10, 1);   GA inserted before #10, #10 deleted\n        $obj->change('GATC', 10, 2); GATC inserted before #10, #10&#11 deleted\n        $obj->change('GATC', 10, 6); GATC inserted before #10, #10-#15 deleted\n\n\n Returns : a string of deleted bases (if any) or 1 (everything OK)\n Errorcode: -1\n Args    : seq,    string, or '' ('' = undef = 0 = deletion)\n           start,  integer\n           length, integer (optional)\n\n\nsub change {\n  &positionchange;\n}\n\n=head2 positionchange\n\n Title   : positionchange\n Function: Exactly like change. I.e. change() defaults to positionchange()\n\n\nsub positionchange {\n  my ($self,$newseq,$position,$length)=@_;\n  unless ($position) {\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  my $label=$self->label($position);\n  unless ($label > 0) { # label not found or error\n    $self->warn(\"No valid label found at that position!\");\n    return (-1);\n  }\n  return ($self->labelchange($newseq,$label,$length));\n}\n\n=head2 labelchange\n\n Title   : labelchange\n Function: Exactly like change but uses a /label/ instead than a position\n           as second argument. This allows for multiple changes in a LiveSeq\n           without the burden of recomputing positions. I.e. for a multiple\n           change in two different points of the LiveSeq, the approach would\n           be the following: fetch the correct labels out of the two different\n           positions (method: label($position)) and then use the labelchange()\n           method to modify the sequence using those labels instead than\n           relying on the positions (that would have modified after the\n           first change).\n\n\nsub labelchange {\n  my ($self,$newseq,$label,$length)=@_;\n  unless ($self->valid($label)) {\n    if ($self->{'seq'}->valid($label)) {\n       #$self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change for the object asked but it's ok for DNAlevel change, reverting to that\");\n      shift @_;\n      return($self->{'seq'}->labelchange(@_));\n    } else {\n      $self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change\");\n      return (-1);\n    }\n  }\n  unless ($newseq) { # it means this is a simple deletion\n    if (defined($length)) {\n      unless ($length >= 0) {\n\t$self->warn(\"No sense having length < 0 in a deletion\");\n\treturn (-1);\n      }\n    } else {\n      $self->warn(\"Length not defined for deletion!\");\n      return (-1);\n    }\n    return $self->_delete($label,$length);\n  }\n  my $newseqlength=CORE::length($newseq);\n  if (defined($length)) {\n    unless ($length >= 0) {\n      $self->warn(\"No sense having length < 0 in a change()\");\n      return (-1);\n    }\n  } else {\n    $length=$newseqlength; # defaults to pointmutation(s)\n  }\n  if ($length == 0) { # it means this is a simple insertion, length def&==0\n    my ($insertbegin,$insertend)=$self->_praeinsert($label,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n  if ($newseqlength == $length) { # it means this is simple pointmutation(s)\n    return $self->_mutate($label,$newseq,$length);\n  }\n  # if we arrived here then change is complex mixture\n  my $strand=$self->strand();\n  my $afterendlabel=$self->label($length+1,$label,$strand); # get the label at $length+1 positions after $label\n  unless ($afterendlabel > 0) { # label not found or error\n    $self->warn(\"No valid afterendlabel found for executing the complex mutation!\");\n    return (-1);\n  }\n  my $deleted=$self->_delete($label,$length); # first delete length nucs\n  if ($deleted == -1) { # if errors\n    return (-1);\n  } else { # then insert the newsequence\n    my ($insertbegin,$insertend)=$self->_praeinsert($afterendlabel,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n}\n\n# internal methods for change()\n\n# arguments: label for beginning of deletion, new sequence to insert\n# returns: labels of beginning and end of the inserted sequence\n# errorcode: -1\nsub _praeinsert {\n  my ($self,$label,$newseq)=@_;\n  my ($insertbegin,$insertend);\n  my $strand=$self->strand();\n  if ($strand == 1) {\n    ($insertbegin,$insertend)=($self->{'seq'}->praeinsert_string($newseq,$label));\n  } else { # since it's reverse strand and we insert in forward direction....\n    $newseq=reverse($newseq);\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n    ($insertend,$insertbegin)=($self->{'seq'}->postinsert_string($newseq,$label));\n  }\n  if (($insertbegin==0)||($insertend==0)) {\n    $self->warn(\"Some error occurred while inserting!\");\n    return (-1);\n  } else {\n    return ($insertbegin,$insertend);\n  }\n}\n\n# arguments: label for beginning of deletion, length of deletion\n# returns: string of deleted bases\n# errorcode: -1\nsub _delete {\n  my ($self,$label,$length)=@_;\n  my $strand=$self->strand();\n  my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n  unless ($endlabel > 0) { # label not found or error\n    $self->warn(\"No valid endlabel found for executing the deletion!\");\n    return (-1);\n  }\n  # this is important in Transcript to fix exon structure\n  $self->_deletecheck($label,$endlabel);\n  my $deletedseq;\n  if ($strand == 1) {\n    $deletedseq=$self->{'seq'}->splice_chain($label,undef,$endlabel);\n  } else {\n    $deletedseq=$self->{'seq'}->splice_chain($endlabel,undef,$label);\n    $deletedseq=reverse($deletedseq); # because we are on reverse strand and we cut anyway\n                         # in forward direction\n    $deletedseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  return ($deletedseq);\n}\n\n# empty function, overridden in Transcript, not useful here\nsub _deletecheck {\n}\n\n# arguments: label for beginning of mutation, newsequence, number of mutations\n# returns: 1 all OK\n# errorcode: -1\nsub _mutate {\n  my ($self,$label,$newseq,$length)=@_; # length is equal to length(newseq)\n  my ($i,$base,$nextlabel);\n  my @labels; # array of labels\n  my $strand=$self->strand();\n  if ($length == 1) { # special cases first\n    @labels=($label);\n  } else {\n    my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n    unless ($endlabel > 0) { # label not found or error\n      $self->warn(\"No valid endlabel found for executing the mutation!\");\n      return (-1);\n    }\n    if ($length == 2) { # another special case\n      @labels=($label,$endlabel);\n    } else { # more than 3 bases changed\n      # this wouldn't work for Transcript\n      #my $labelsarrayref;\n      #if ($strand == 1) {\n\t#$labelsarrayref=$self->{'seq'}->down_labels($label,$endlabel);\n      #} else {\n\t#$labelsarrayref=$self->{'seq'}->up_labels($label,$endlabel);\n      #}\n      #@labels=@{$labelsarrayref};\n      #if ($length != scalar(@labels)) { # not enough labels returned\n\t#$self->warn(\"Not enough valid labels found for executing the mutation!\");\n\t#return (-1);\n      #}\n\n      # this should be more general\n      @labels=($label); # put the first one\n      while ($label != $endlabel) {\n\t$nextlabel=$self->label(2,$label,$strand); # retrieve the next label\n\tpush (@labels,$nextlabel);\n\t$label=$nextlabel; # move on reference\n      }\n    }\n  }\n  if ($strand == -1) { # only for reverse strand\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  my $errorcheck; # if not equal to $length after summing for all changes, error did occurr\n  $i = 0;\n  foreach $base (split(//,$newseq)) {\n    $errorcheck += $self->{'seq'}->set_value_at_label($base,$labels[$i]);\n    $i++;\n  }\n  if ($errorcheck != $length) {\n    $self->warn(\"Some error occurred while mutating!\");\n    return (-1);\n  } else {\n    return (1);\n  }\n}\n\n=head2 valid\n\n  Title   : valid\n  Usage   : $boolean = $obj->valid($label)\n  Function: tests if a label exists inside the object\n  Returns : boolean\n  Args    : label\n\n\n# argument: label\n# returns: 1 YES 0 NO\nsub valid {\n  my ($self,$label)=@_;\n  my $checkme;\n  my @labels=$self->all_labels;\n  foreach $checkme (@labels) {\n    if ($label == $checkme) {\n      return (1); # found\n    }\n  }\n  return (0); # not found\n}\n\n\n=head2 start\n\n  Title   : start\n  Usage   : $startlabel=$obj->start()\n  Function: returns the label of the first nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub start {\n  my ($self) = @_;\n  return $self->{'start'}; # common for all classes BUT DNA (which redefines it) and Transcript (that takes the information from the Exons)\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $endlabel=$obj->end()\n  Function: returns the label of the last nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub end {\n  my ($self) = @_;\n  return $self->{'end'};\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand=$obj->strand()\n            $obj->strand($strand)\n  Function: gets or sets strand information, being 1 or -1 (forward or reverse)\n  Returns : -1 or 1\n  Args    : none OR -1 or 1\n\n\nsub strand {\n  my ($self,$strand) = @_;\n  if ($strand) {\n    if (($strand != 1)&&($strand != -1)) {\n      $self->warn(\"strand information not changed because strand identifier not valid\");\n    } else {\n      $self->{'strand'} = $strand;\n    }\n  }\n  return $self->{'strand'};\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n Returns : a string either 'dna','rna','protein'.\n Args    : none","parameters":[{"label":"$self"},{"label":"$value"}],"label":"alphabet($self,$value)"},"line":771,"range":{"end":{"line":783,"character":9999},"start":{"line":771,"character":0}},"kind":12,"definition":"sub","detail":"($self,$value)","children":[{"localvar":"my","kind":13,"containerName":"alphabet","name":"%valid_type","line":772,"definition":"my"},{"kind":13,"localvar":"my","containerName":"alphabet","name":"$self","line":773,"definition":"my"},{"line":773,"kind":13,"containerName":"alphabet","name":"$value"},{"name":"$value","kind":13,"containerName":"alphabet","line":774},{"name":"$value","kind":13,"containerName":"alphabet","line":775},{"kind":13,"containerName":"alphabet","name":"$value","line":775},{"line":776,"kind":13,"containerName":"alphabet","name":"$value"},{"line":776,"kind":13,"containerName":"alphabet","name":"$value"},{"line":777,"kind":13,"containerName":"alphabet","name":"$valid_type"},{"name":"$value","containerName":"alphabet","kind":13,"line":777},{"name":"$self","containerName":"alphabet","kind":13,"line":778},{"name":"warn","containerName":"alphabet","kind":12,"line":778},{"line":780,"containerName":"alphabet","kind":13,"name":"$self"},{"containerName":"alphabet","kind":13,"name":"$value","line":780},{"line":782,"name":"$self","kind":13,"containerName":"alphabet"}],"name":"alphabet","containerName":"main::"},{"signature":{"label":"coordinate_start($self,$label)","documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n\n# NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode) = @_;\n  if (defined $unsecuremode && $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    unless ($start) {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length;\n      }\n    } else {\n      unless ($length) {\n\t$end=$self->end;\n      }\n    }\n  } else {\n    if ($start) {\n      unless ($self->{'seq'}->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tunless ($self->{'seq'}->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n\tundef $length;\n      }\n    }\n  }\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,$length,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,$length,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n         : $substring = $obj->subseq(10,undef,4);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal.\n\n           Allows for negative numbers $obj->subseq(-10,-1). By\n           definition, there is no 0!\n                       -5  -1 1   5\n                gctagcgcccaac atggctcgctg\n\n           This allows to retrieve sequences upstream from given position.\n\n           The precedence is from left to right: if END is given LENGTH is\n           ignored.\n\n Examples: $obj->subseq(-10,undef,10) returns 10 elements before position 1\n           $obj->subseq(4,8) returns elements from the 4th to the 8th, inclusive\n\n Returns : a string\n Errorcode: -1\n Args    : start,  integer, defaults to start of the sequence\n           end,    integer, '' or undef, defaults to end of the sequence\n           length, integer, '' or undef\n           an optional strand (1 or -1) 4th argument \n            if strand argument is not given, it will default to the object\n            argment. This argument is useful when a call is issued from a child\n            of a parent object containing the subseq method\n\n\n#'\n# check the fact about reverse strand!\n# is it feasible? Is it correct? Should we do it? How about exons? Does it\n# work when you ask subseq of an exon?\n# eliminated now (Mon night)\nsub subseq {\n  ##my ($self,$pos1,$pos2,$length,$strand) = @_;\n  my ($self,$pos1,$pos2,$length,$strand) = @_;\n  ##unless (defined ($strand)) { # if optional [strand] argument not given\n  ##  $strand=$self->strand;\n  ##}\n  $strand=$self->strand;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  unless (defined ($pos1)) {\n    #print \"\\n##### DEBUG pos1 not defined\\n\";\n    $startlabel=$self->start;\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos2))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos2))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!)\"; return (-1);\n    ##  }\n    ##}\n    $startlabel=$self->label($pos1);\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  }\n  unless (defined ($pos2)) {\n    #print \"\\n##### pos2 not defined\\n\";\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos1))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos1))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!\"); return (-1);\n    ##  }\n    ##}\n    $endlabel=$self->label($pos2);\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  }\n  #print \"\\n    ####DEBUG: start $startlabel end $endlabel length $length strand $strand\\n\";\n\n  if ($strand == 1) {\n    $str = $self->{'seq'}->down_chain2string($startlabel,$length,$endlabel);\n  } else { # reverse strand\n    $str = $self->{'seq'}->up_chain2string($startlabel,$length,$endlabel);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n  }\n  return $str;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $seq->length();\n  Function: returns the number of nucleotides (or the number of aminoacids)\n            in the entire sequence\n  Returns : an integer\n  Errorcode -1\n  Args    : none\n\n\nsub length {\n  my $self=shift;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  if ($strand == 1) {\n    return $self->{'seq'}->down_subchain_length($start,$end);\n  } else {\n    return $self->{'seq'}->up_subchain_length($start,$end);\n  }\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, alias the common name of the object\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information.\n\n See also: accession_number\n Returns : a string\n Args    : none\n\n\nsub display_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'display_id'} = $value;\n  }\n  return $self->{'display_id'};\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number.\n           Notice that primary_id() provides the unique id for the\n           implemetation, allowing multiple objects to have the same accession\n           number in a particular implementation.\n\n           For objects with no accession_number this method returns \"unknown\".\n Returns : a string\n Args    : none\n\n\nsub accession_number {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'accession_number'} = $value;\n  }\n  unless (exists $self->{'accession_number'}) {\n    return \"unknown\";\n  } else {\n    return $self->{'accession_number'};\n  }\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their own\n           object ids in a way the implementation can control. Clients can\n           expect one id to map to one object.\n\n           For sequences with no primary_id, this method returns\n           a stringified memory location.\n\n Returns : A string\n Args    : None\n\n\n\nsub primary_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'primary_id'} = $value;\n  }\n  unless (exists $self->{'primary_id'}) {\n    return \"$self\";\n  } else {\n    return $self->{'primary_id'};\n  }\n}\n\n=head2 change\n\n Title   : change\n Usage   : $substring = $obj->change('AA', 10);\n Function: changes, modifies, mutates the LiveSequence\n Examples:\n        $obj->change('',   10);      delete nucleotide #10     \n        $obj->change('',   10, 2);   delete two nucleotides starting from #10\n        $obj->change('G',  10);      change nuc #10 to 'G'\n        $obj->change('GA', 10, 4);   replace #10 and 3 following with 'GA'\n        $obj->change('GA', 10, 2));  is same as $obj->change('GA',  10);\n        $obj->change('GA', 10, 0 );  insert 'GA' before nucleotide at #10\n        $obj->change('GA', 10, 1);   GA inserted before #10, #10 deleted\n        $obj->change('GATC', 10, 2); GATC inserted before #10, #10&#11 deleted\n        $obj->change('GATC', 10, 6); GATC inserted before #10, #10-#15 deleted\n\n\n Returns : a string of deleted bases (if any) or 1 (everything OK)\n Errorcode: -1\n Args    : seq,    string, or '' ('' = undef = 0 = deletion)\n           start,  integer\n           length, integer (optional)\n\n\nsub change {\n  &positionchange;\n}\n\n=head2 positionchange\n\n Title   : positionchange\n Function: Exactly like change. I.e. change() defaults to positionchange()\n\n\nsub positionchange {\n  my ($self,$newseq,$position,$length)=@_;\n  unless ($position) {\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  my $label=$self->label($position);\n  unless ($label > 0) { # label not found or error\n    $self->warn(\"No valid label found at that position!\");\n    return (-1);\n  }\n  return ($self->labelchange($newseq,$label,$length));\n}\n\n=head2 labelchange\n\n Title   : labelchange\n Function: Exactly like change but uses a /label/ instead than a position\n           as second argument. This allows for multiple changes in a LiveSeq\n           without the burden of recomputing positions. I.e. for a multiple\n           change in two different points of the LiveSeq, the approach would\n           be the following: fetch the correct labels out of the two different\n           positions (method: label($position)) and then use the labelchange()\n           method to modify the sequence using those labels instead than\n           relying on the positions (that would have modified after the\n           first change).\n\n\nsub labelchange {\n  my ($self,$newseq,$label,$length)=@_;\n  unless ($self->valid($label)) {\n    if ($self->{'seq'}->valid($label)) {\n       #$self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change for the object asked but it's ok for DNAlevel change, reverting to that\");\n      shift @_;\n      return($self->{'seq'}->labelchange(@_));\n    } else {\n      $self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change\");\n      return (-1);\n    }\n  }\n  unless ($newseq) { # it means this is a simple deletion\n    if (defined($length)) {\n      unless ($length >= 0) {\n\t$self->warn(\"No sense having length < 0 in a deletion\");\n\treturn (-1);\n      }\n    } else {\n      $self->warn(\"Length not defined for deletion!\");\n      return (-1);\n    }\n    return $self->_delete($label,$length);\n  }\n  my $newseqlength=CORE::length($newseq);\n  if (defined($length)) {\n    unless ($length >= 0) {\n      $self->warn(\"No sense having length < 0 in a change()\");\n      return (-1);\n    }\n  } else {\n    $length=$newseqlength; # defaults to pointmutation(s)\n  }\n  if ($length == 0) { # it means this is a simple insertion, length def&==0\n    my ($insertbegin,$insertend)=$self->_praeinsert($label,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n  if ($newseqlength == $length) { # it means this is simple pointmutation(s)\n    return $self->_mutate($label,$newseq,$length);\n  }\n  # if we arrived here then change is complex mixture\n  my $strand=$self->strand();\n  my $afterendlabel=$self->label($length+1,$label,$strand); # get the label at $length+1 positions after $label\n  unless ($afterendlabel > 0) { # label not found or error\n    $self->warn(\"No valid afterendlabel found for executing the complex mutation!\");\n    return (-1);\n  }\n  my $deleted=$self->_delete($label,$length); # first delete length nucs\n  if ($deleted == -1) { # if errors\n    return (-1);\n  } else { # then insert the newsequence\n    my ($insertbegin,$insertend)=$self->_praeinsert($afterendlabel,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n}\n\n# internal methods for change()\n\n# arguments: label for beginning of deletion, new sequence to insert\n# returns: labels of beginning and end of the inserted sequence\n# errorcode: -1\nsub _praeinsert {\n  my ($self,$label,$newseq)=@_;\n  my ($insertbegin,$insertend);\n  my $strand=$self->strand();\n  if ($strand == 1) {\n    ($insertbegin,$insertend)=($self->{'seq'}->praeinsert_string($newseq,$label));\n  } else { # since it's reverse strand and we insert in forward direction....\n    $newseq=reverse($newseq);\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n    ($insertend,$insertbegin)=($self->{'seq'}->postinsert_string($newseq,$label));\n  }\n  if (($insertbegin==0)||($insertend==0)) {\n    $self->warn(\"Some error occurred while inserting!\");\n    return (-1);\n  } else {\n    return ($insertbegin,$insertend);\n  }\n}\n\n# arguments: label for beginning of deletion, length of deletion\n# returns: string of deleted bases\n# errorcode: -1\nsub _delete {\n  my ($self,$label,$length)=@_;\n  my $strand=$self->strand();\n  my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n  unless ($endlabel > 0) { # label not found or error\n    $self->warn(\"No valid endlabel found for executing the deletion!\");\n    return (-1);\n  }\n  # this is important in Transcript to fix exon structure\n  $self->_deletecheck($label,$endlabel);\n  my $deletedseq;\n  if ($strand == 1) {\n    $deletedseq=$self->{'seq'}->splice_chain($label,undef,$endlabel);\n  } else {\n    $deletedseq=$self->{'seq'}->splice_chain($endlabel,undef,$label);\n    $deletedseq=reverse($deletedseq); # because we are on reverse strand and we cut anyway\n                         # in forward direction\n    $deletedseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  return ($deletedseq);\n}\n\n# empty function, overridden in Transcript, not useful here\nsub _deletecheck {\n}\n\n# arguments: label for beginning of mutation, newsequence, number of mutations\n# returns: 1 all OK\n# errorcode: -1\nsub _mutate {\n  my ($self,$label,$newseq,$length)=@_; # length is equal to length(newseq)\n  my ($i,$base,$nextlabel);\n  my @labels; # array of labels\n  my $strand=$self->strand();\n  if ($length == 1) { # special cases first\n    @labels=($label);\n  } else {\n    my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n    unless ($endlabel > 0) { # label not found or error\n      $self->warn(\"No valid endlabel found for executing the mutation!\");\n      return (-1);\n    }\n    if ($length == 2) { # another special case\n      @labels=($label,$endlabel);\n    } else { # more than 3 bases changed\n      # this wouldn't work for Transcript\n      #my $labelsarrayref;\n      #if ($strand == 1) {\n\t#$labelsarrayref=$self->{'seq'}->down_labels($label,$endlabel);\n      #} else {\n\t#$labelsarrayref=$self->{'seq'}->up_labels($label,$endlabel);\n      #}\n      #@labels=@{$labelsarrayref};\n      #if ($length != scalar(@labels)) { # not enough labels returned\n\t#$self->warn(\"Not enough valid labels found for executing the mutation!\");\n\t#return (-1);\n      #}\n\n      # this should be more general\n      @labels=($label); # put the first one\n      while ($label != $endlabel) {\n\t$nextlabel=$self->label(2,$label,$strand); # retrieve the next label\n\tpush (@labels,$nextlabel);\n\t$label=$nextlabel; # move on reference\n      }\n    }\n  }\n  if ($strand == -1) { # only for reverse strand\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  my $errorcheck; # if not equal to $length after summing for all changes, error did occurr\n  $i = 0;\n  foreach $base (split(//,$newseq)) {\n    $errorcheck += $self->{'seq'}->set_value_at_label($base,$labels[$i]);\n    $i++;\n  }\n  if ($errorcheck != $length) {\n    $self->warn(\"Some error occurred while mutating!\");\n    return (-1);\n  } else {\n    return (1);\n  }\n}\n\n=head2 valid\n\n  Title   : valid\n  Usage   : $boolean = $obj->valid($label)\n  Function: tests if a label exists inside the object\n  Returns : boolean\n  Args    : label\n\n\n# argument: label\n# returns: 1 YES 0 NO\nsub valid {\n  my ($self,$label)=@_;\n  my $checkme;\n  my @labels=$self->all_labels;\n  foreach $checkme (@labels) {\n    if ($label == $checkme) {\n      return (1); # found\n    }\n  }\n  return (0); # not found\n}\n\n\n=head2 start\n\n  Title   : start\n  Usage   : $startlabel=$obj->start()\n  Function: returns the label of the first nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub start {\n  my ($self) = @_;\n  return $self->{'start'}; # common for all classes BUT DNA (which redefines it) and Transcript (that takes the information from the Exons)\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $endlabel=$obj->end()\n  Function: returns the label of the last nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub end {\n  my ($self) = @_;\n  return $self->{'end'};\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand=$obj->strand()\n            $obj->strand($strand)\n  Function: gets or sets strand information, being 1 or -1 (forward or reverse)\n  Returns : -1 or 1\n  Args    : none OR -1 or 1\n\n\nsub strand {\n  my ($self,$strand) = @_;\n  if ($strand) {\n    if (($strand != 1)&&($strand != -1)) {\n      $self->warn(\"strand information not changed because strand identifier not valid\");\n    } else {\n      $self->{'strand'} = $strand;\n    }\n  }\n  return $self->{'strand'};\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n Returns : a string either 'dna','rna','protein'.\n Args    : none\n\n\n\nsub alphabet {\n  my %valid_type = map {$_, 1} qw( dna rna protein );\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $value = 'dna' if $value =~ /dna/i;\n    $value = 'rna' if $value =~ /rna/i;\n    unless ( $valid_type{$value} ) {\n      $self->warn(\"Molecular type '$value' is not a valid type\");\n    }\n    $self->{'alphabet'} = $value;\n  }\n  return $self->{'alphabet'};\n}\n\n=head2 coordinate_start\n\n  Title   : coordinate_start\n  Usage   : $coordstartlabel=$obj->coordinate_start()\n          : $coordstartlabel=$obj->coordinate_start($label)\n  Function: returns and optionally sets the first label of the coordinate\n            system used\n            For some objects only labels inside the object or in frame (for\n            Translation objects) will be allowed to get set as coordinate start\n\n  Returns : label. It returns 0 if label not found.\n  Errorcode -1 \n  Args    : an optional reference $label that is position 1","parameters":[{"label":"$self"},{"label":"$label"}]},"kind":12,"range":{"end":{"line":817,"character":9999},"start":{"line":802,"character":0}},"line":802,"detail":"($self,$label)","definition":"sub","name":"coordinate_start","containerName":"main::","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"coordinate_start","line":803},{"line":803,"name":"$label","containerName":"coordinate_start","kind":13},{"name":"$label","kind":13,"containerName":"coordinate_start","line":804},{"line":805,"name":"$self","kind":13,"containerName":"coordinate_start"},{"line":805,"containerName":"coordinate_start","kind":12,"name":"valid"},{"line":805,"name":"$label","containerName":"coordinate_start","kind":13},{"line":806,"kind":13,"containerName":"coordinate_start","name":"$self"},{"line":806,"name":"$label","kind":13,"containerName":"coordinate_start"},{"line":808,"kind":13,"containerName":"coordinate_start","name":"$self"},{"containerName":"coordinate_start","kind":12,"name":"warn","line":808},{"definition":"my","line":811,"localvar":"my","kind":13,"containerName":"coordinate_start","name":"$coord_start"},{"line":811,"kind":13,"containerName":"coordinate_start","name":"$self"},{"kind":13,"containerName":"coordinate_start","name":"$coord_start","line":812},{"containerName":"coordinate_start","kind":13,"name":"$coord_start","line":813},{"line":815,"name":"$self","kind":13,"containerName":"coordinate_start"},{"line":815,"name":"start","kind":12,"containerName":"coordinate_start"}]},{"signature":{"label":"label($self,$position,$firstlabel,$strand)","parameters":[{"label":"$self"},{"label":"$position"},{"label":"$firstlabel"},{"label":"$strand"}],"documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n\n# NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode) = @_;\n  if (defined $unsecuremode && $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    unless ($start) {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length;\n      }\n    } else {\n      unless ($length) {\n\t$end=$self->end;\n      }\n    }\n  } else {\n    if ($start) {\n      unless ($self->{'seq'}->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tunless ($self->{'seq'}->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n\tundef $length;\n      }\n    }\n  }\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,$length,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,$length,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n         : $substring = $obj->subseq(10,undef,4);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal.\n\n           Allows for negative numbers $obj->subseq(-10,-1). By\n           definition, there is no 0!\n                       -5  -1 1   5\n                gctagcgcccaac atggctcgctg\n\n           This allows to retrieve sequences upstream from given position.\n\n           The precedence is from left to right: if END is given LENGTH is\n           ignored.\n\n Examples: $obj->subseq(-10,undef,10) returns 10 elements before position 1\n           $obj->subseq(4,8) returns elements from the 4th to the 8th, inclusive\n\n Returns : a string\n Errorcode: -1\n Args    : start,  integer, defaults to start of the sequence\n           end,    integer, '' or undef, defaults to end of the sequence\n           length, integer, '' or undef\n           an optional strand (1 or -1) 4th argument \n            if strand argument is not given, it will default to the object\n            argment. This argument is useful when a call is issued from a child\n            of a parent object containing the subseq method\n\n\n#'\n# check the fact about reverse strand!\n# is it feasible? Is it correct? Should we do it? How about exons? Does it\n# work when you ask subseq of an exon?\n# eliminated now (Mon night)\nsub subseq {\n  ##my ($self,$pos1,$pos2,$length,$strand) = @_;\n  my ($self,$pos1,$pos2,$length,$strand) = @_;\n  ##unless (defined ($strand)) { # if optional [strand] argument not given\n  ##  $strand=$self->strand;\n  ##}\n  $strand=$self->strand;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  unless (defined ($pos1)) {\n    #print \"\\n##### DEBUG pos1 not defined\\n\";\n    $startlabel=$self->start;\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos2))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos2))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!)\"; return (-1);\n    ##  }\n    ##}\n    $startlabel=$self->label($pos1);\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  }\n  unless (defined ($pos2)) {\n    #print \"\\n##### pos2 not defined\\n\";\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos1))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos1))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!\"); return (-1);\n    ##  }\n    ##}\n    $endlabel=$self->label($pos2);\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  }\n  #print \"\\n    ####DEBUG: start $startlabel end $endlabel length $length strand $strand\\n\";\n\n  if ($strand == 1) {\n    $str = $self->{'seq'}->down_chain2string($startlabel,$length,$endlabel);\n  } else { # reverse strand\n    $str = $self->{'seq'}->up_chain2string($startlabel,$length,$endlabel);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n  }\n  return $str;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $seq->length();\n  Function: returns the number of nucleotides (or the number of aminoacids)\n            in the entire sequence\n  Returns : an integer\n  Errorcode -1\n  Args    : none\n\n\nsub length {\n  my $self=shift;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  if ($strand == 1) {\n    return $self->{'seq'}->down_subchain_length($start,$end);\n  } else {\n    return $self->{'seq'}->up_subchain_length($start,$end);\n  }\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, alias the common name of the object\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information.\n\n See also: accession_number\n Returns : a string\n Args    : none\n\n\nsub display_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'display_id'} = $value;\n  }\n  return $self->{'display_id'};\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number.\n           Notice that primary_id() provides the unique id for the\n           implemetation, allowing multiple objects to have the same accession\n           number in a particular implementation.\n\n           For objects with no accession_number this method returns \"unknown\".\n Returns : a string\n Args    : none\n\n\nsub accession_number {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'accession_number'} = $value;\n  }\n  unless (exists $self->{'accession_number'}) {\n    return \"unknown\";\n  } else {\n    return $self->{'accession_number'};\n  }\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their own\n           object ids in a way the implementation can control. Clients can\n           expect one id to map to one object.\n\n           For sequences with no primary_id, this method returns\n           a stringified memory location.\n\n Returns : A string\n Args    : None\n\n\n\nsub primary_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'primary_id'} = $value;\n  }\n  unless (exists $self->{'primary_id'}) {\n    return \"$self\";\n  } else {\n    return $self->{'primary_id'};\n  }\n}\n\n=head2 change\n\n Title   : change\n Usage   : $substring = $obj->change('AA', 10);\n Function: changes, modifies, mutates the LiveSequence\n Examples:\n        $obj->change('',   10);      delete nucleotide #10     \n        $obj->change('',   10, 2);   delete two nucleotides starting from #10\n        $obj->change('G',  10);      change nuc #10 to 'G'\n        $obj->change('GA', 10, 4);   replace #10 and 3 following with 'GA'\n        $obj->change('GA', 10, 2));  is same as $obj->change('GA',  10);\n        $obj->change('GA', 10, 0 );  insert 'GA' before nucleotide at #10\n        $obj->change('GA', 10, 1);   GA inserted before #10, #10 deleted\n        $obj->change('GATC', 10, 2); GATC inserted before #10, #10&#11 deleted\n        $obj->change('GATC', 10, 6); GATC inserted before #10, #10-#15 deleted\n\n\n Returns : a string of deleted bases (if any) or 1 (everything OK)\n Errorcode: -1\n Args    : seq,    string, or '' ('' = undef = 0 = deletion)\n           start,  integer\n           length, integer (optional)\n\n\nsub change {\n  &positionchange;\n}\n\n=head2 positionchange\n\n Title   : positionchange\n Function: Exactly like change. I.e. change() defaults to positionchange()\n\n\nsub positionchange {\n  my ($self,$newseq,$position,$length)=@_;\n  unless ($position) {\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  my $label=$self->label($position);\n  unless ($label > 0) { # label not found or error\n    $self->warn(\"No valid label found at that position!\");\n    return (-1);\n  }\n  return ($self->labelchange($newseq,$label,$length));\n}\n\n=head2 labelchange\n\n Title   : labelchange\n Function: Exactly like change but uses a /label/ instead than a position\n           as second argument. This allows for multiple changes in a LiveSeq\n           without the burden of recomputing positions. I.e. for a multiple\n           change in two different points of the LiveSeq, the approach would\n           be the following: fetch the correct labels out of the two different\n           positions (method: label($position)) and then use the labelchange()\n           method to modify the sequence using those labels instead than\n           relying on the positions (that would have modified after the\n           first change).\n\n\nsub labelchange {\n  my ($self,$newseq,$label,$length)=@_;\n  unless ($self->valid($label)) {\n    if ($self->{'seq'}->valid($label)) {\n       #$self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change for the object asked but it's ok for DNAlevel change, reverting to that\");\n      shift @_;\n      return($self->{'seq'}->labelchange(@_));\n    } else {\n      $self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change\");\n      return (-1);\n    }\n  }\n  unless ($newseq) { # it means this is a simple deletion\n    if (defined($length)) {\n      unless ($length >= 0) {\n\t$self->warn(\"No sense having length < 0 in a deletion\");\n\treturn (-1);\n      }\n    } else {\n      $self->warn(\"Length not defined for deletion!\");\n      return (-1);\n    }\n    return $self->_delete($label,$length);\n  }\n  my $newseqlength=CORE::length($newseq);\n  if (defined($length)) {\n    unless ($length >= 0) {\n      $self->warn(\"No sense having length < 0 in a change()\");\n      return (-1);\n    }\n  } else {\n    $length=$newseqlength; # defaults to pointmutation(s)\n  }\n  if ($length == 0) { # it means this is a simple insertion, length def&==0\n    my ($insertbegin,$insertend)=$self->_praeinsert($label,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n  if ($newseqlength == $length) { # it means this is simple pointmutation(s)\n    return $self->_mutate($label,$newseq,$length);\n  }\n  # if we arrived here then change is complex mixture\n  my $strand=$self->strand();\n  my $afterendlabel=$self->label($length+1,$label,$strand); # get the label at $length+1 positions after $label\n  unless ($afterendlabel > 0) { # label not found or error\n    $self->warn(\"No valid afterendlabel found for executing the complex mutation!\");\n    return (-1);\n  }\n  my $deleted=$self->_delete($label,$length); # first delete length nucs\n  if ($deleted == -1) { # if errors\n    return (-1);\n  } else { # then insert the newsequence\n    my ($insertbegin,$insertend)=$self->_praeinsert($afterendlabel,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n}\n\n# internal methods for change()\n\n# arguments: label for beginning of deletion, new sequence to insert\n# returns: labels of beginning and end of the inserted sequence\n# errorcode: -1\nsub _praeinsert {\n  my ($self,$label,$newseq)=@_;\n  my ($insertbegin,$insertend);\n  my $strand=$self->strand();\n  if ($strand == 1) {\n    ($insertbegin,$insertend)=($self->{'seq'}->praeinsert_string($newseq,$label));\n  } else { # since it's reverse strand and we insert in forward direction....\n    $newseq=reverse($newseq);\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n    ($insertend,$insertbegin)=($self->{'seq'}->postinsert_string($newseq,$label));\n  }\n  if (($insertbegin==0)||($insertend==0)) {\n    $self->warn(\"Some error occurred while inserting!\");\n    return (-1);\n  } else {\n    return ($insertbegin,$insertend);\n  }\n}\n\n# arguments: label for beginning of deletion, length of deletion\n# returns: string of deleted bases\n# errorcode: -1\nsub _delete {\n  my ($self,$label,$length)=@_;\n  my $strand=$self->strand();\n  my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n  unless ($endlabel > 0) { # label not found or error\n    $self->warn(\"No valid endlabel found for executing the deletion!\");\n    return (-1);\n  }\n  # this is important in Transcript to fix exon structure\n  $self->_deletecheck($label,$endlabel);\n  my $deletedseq;\n  if ($strand == 1) {\n    $deletedseq=$self->{'seq'}->splice_chain($label,undef,$endlabel);\n  } else {\n    $deletedseq=$self->{'seq'}->splice_chain($endlabel,undef,$label);\n    $deletedseq=reverse($deletedseq); # because we are on reverse strand and we cut anyway\n                         # in forward direction\n    $deletedseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  return ($deletedseq);\n}\n\n# empty function, overridden in Transcript, not useful here\nsub _deletecheck {\n}\n\n# arguments: label for beginning of mutation, newsequence, number of mutations\n# returns: 1 all OK\n# errorcode: -1\nsub _mutate {\n  my ($self,$label,$newseq,$length)=@_; # length is equal to length(newseq)\n  my ($i,$base,$nextlabel);\n  my @labels; # array of labels\n  my $strand=$self->strand();\n  if ($length == 1) { # special cases first\n    @labels=($label);\n  } else {\n    my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n    unless ($endlabel > 0) { # label not found or error\n      $self->warn(\"No valid endlabel found for executing the mutation!\");\n      return (-1);\n    }\n    if ($length == 2) { # another special case\n      @labels=($label,$endlabel);\n    } else { # more than 3 bases changed\n      # this wouldn't work for Transcript\n      #my $labelsarrayref;\n      #if ($strand == 1) {\n\t#$labelsarrayref=$self->{'seq'}->down_labels($label,$endlabel);\n      #} else {\n\t#$labelsarrayref=$self->{'seq'}->up_labels($label,$endlabel);\n      #}\n      #@labels=@{$labelsarrayref};\n      #if ($length != scalar(@labels)) { # not enough labels returned\n\t#$self->warn(\"Not enough valid labels found for executing the mutation!\");\n\t#return (-1);\n      #}\n\n      # this should be more general\n      @labels=($label); # put the first one\n      while ($label != $endlabel) {\n\t$nextlabel=$self->label(2,$label,$strand); # retrieve the next label\n\tpush (@labels,$nextlabel);\n\t$label=$nextlabel; # move on reference\n      }\n    }\n  }\n  if ($strand == -1) { # only for reverse strand\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  my $errorcheck; # if not equal to $length after summing for all changes, error did occurr\n  $i = 0;\n  foreach $base (split(//,$newseq)) {\n    $errorcheck += $self->{'seq'}->set_value_at_label($base,$labels[$i]);\n    $i++;\n  }\n  if ($errorcheck != $length) {\n    $self->warn(\"Some error occurred while mutating!\");\n    return (-1);\n  } else {\n    return (1);\n  }\n}\n\n=head2 valid\n\n  Title   : valid\n  Usage   : $boolean = $obj->valid($label)\n  Function: tests if a label exists inside the object\n  Returns : boolean\n  Args    : label\n\n\n# argument: label\n# returns: 1 YES 0 NO\nsub valid {\n  my ($self,$label)=@_;\n  my $checkme;\n  my @labels=$self->all_labels;\n  foreach $checkme (@labels) {\n    if ($label == $checkme) {\n      return (1); # found\n    }\n  }\n  return (0); # not found\n}\n\n\n=head2 start\n\n  Title   : start\n  Usage   : $startlabel=$obj->start()\n  Function: returns the label of the first nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub start {\n  my ($self) = @_;\n  return $self->{'start'}; # common for all classes BUT DNA (which redefines it) and Transcript (that takes the information from the Exons)\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $endlabel=$obj->end()\n  Function: returns the label of the last nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub end {\n  my ($self) = @_;\n  return $self->{'end'};\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand=$obj->strand()\n            $obj->strand($strand)\n  Function: gets or sets strand information, being 1 or -1 (forward or reverse)\n  Returns : -1 or 1\n  Args    : none OR -1 or 1\n\n\nsub strand {\n  my ($self,$strand) = @_;\n  if ($strand) {\n    if (($strand != 1)&&($strand != -1)) {\n      $self->warn(\"strand information not changed because strand identifier not valid\");\n    } else {\n      $self->{'strand'} = $strand;\n    }\n  }\n  return $self->{'strand'};\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n Returns : a string either 'dna','rna','protein'.\n Args    : none\n\n\n\nsub alphabet {\n  my %valid_type = map {$_, 1} qw( dna rna protein );\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $value = 'dna' if $value =~ /dna/i;\n    $value = 'rna' if $value =~ /rna/i;\n    unless ( $valid_type{$value} ) {\n      $self->warn(\"Molecular type '$value' is not a valid type\");\n    }\n    $self->{'alphabet'} = $value;\n  }\n  return $self->{'alphabet'};\n}\n\n=head2 coordinate_start\n\n  Title   : coordinate_start\n  Usage   : $coordstartlabel=$obj->coordinate_start()\n          : $coordstartlabel=$obj->coordinate_start($label)\n  Function: returns and optionally sets the first label of the coordinate\n            system used\n            For some objects only labels inside the object or in frame (for\n            Translation objects) will be allowed to get set as coordinate start\n\n  Returns : label. It returns 0 if label not found.\n  Errorcode -1 \n  Args    : an optional reference $label that is position 1\n\n\n\nsub coordinate_start {\n  my ($self,$label) = @_;\n  if ($label) {\n    if ($self->valid($label)) {\n      $self->{'coordinate_start'} = $label;\n    } else {\n      $self->warn(\"The label you are trying to set as coordinate_start is not valid for this object\");\n    }\n  }\n  my $coord_start = $self->{'coordinate_start'};\n  if ($coord_start) { \n    return $coord_start;\n  } else {\n    return $self->start();\n  }\n}\n\n=head2 label\n\n  Title   : label\n  Usage   : $seq->label($position)\n          : $seq->label($position,$firstlabel)\n  Examples: $nextlabel=$seq->label(2,$label) -> retrieves the following label\n          : $prevlabel=$seq->label(-1,$label) -> retrieves the preceding label\n\n  Function: returns the label of the nucleotide at $position from current\n            coordinate start\n  Returns : a label. It returns 0 if label not found.\n  Errorcode -1 \n  Args    : a position, \n            an optional reference $firstlabel that is to be used as position 1\n            an optional strand (1 or -1) argument \n             if strand argument is not given, it will default to the object\n             argument. This argument is useful when a call is issued from a child\n             of a parent object containing the subseq method"},"line":841,"range":{"start":{"line":841,"character":0},"end":{"line":868,"character":9999}},"kind":12,"definition":"sub","detail":"($self,$position,$firstlabel,$strand)","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"label","line":842},{"line":842,"containerName":"label","kind":13,"name":"$position"},{"containerName":"label","kind":13,"name":"$firstlabel","line":842},{"line":842,"containerName":"label","kind":13,"name":"$strand"},{"definition":"my","line":843,"name":"$label","kind":13,"localvar":"my","containerName":"label"},{"containerName":"label","kind":13,"name":"$firstlabel","line":844},{"line":845,"containerName":"label","kind":13,"name":"$firstlabel"},{"kind":13,"containerName":"label","name":"$self","line":845},{"line":845,"kind":12,"containerName":"label","name":"coordinate_start"},{"name":"$position","kind":13,"containerName":"label","line":847},{"name":"$self","containerName":"label","kind":13,"line":848},{"containerName":"label","kind":12,"name":"warn","line":848},{"line":851,"name":"$strand","kind":13,"containerName":"label"},{"line":852,"name":"$strand","kind":13,"containerName":"label"},{"containerName":"label","kind":13,"name":"$self","line":852},{"line":852,"name":"strand","containerName":"label","kind":12},{"name":"$strand","kind":13,"containerName":"label","line":854},{"line":855,"containerName":"label","kind":13,"name":"$position"},{"line":856,"kind":13,"containerName":"label","name":"$label"},{"name":"$self","kind":13,"containerName":"label","line":856},{"kind":12,"containerName":"label","name":"down_get_label_at_pos","line":856},{"line":856,"containerName":"label","kind":13,"name":"$position"},{"line":856,"name":"$firstlabel","kind":13,"containerName":"label"},{"line":858,"name":"$label","containerName":"label","kind":13},{"containerName":"label","kind":13,"name":"$self","line":858},{"line":858,"name":"up_get_label_at_pos","kind":12,"containerName":"label"},{"name":"$position","containerName":"label","kind":13,"line":858},{"containerName":"label","kind":13,"name":"$firstlabel","line":858},{"line":861,"kind":13,"containerName":"label","name":"$position"},{"containerName":"label","kind":13,"name":"$label","line":862},{"kind":13,"containerName":"label","name":"$self","line":862},{"line":862,"name":"up_get_label_at_pos","containerName":"label","kind":12},{"name":"$position","containerName":"label","kind":13,"line":862},{"name":"$firstlabel","containerName":"label","kind":13,"line":862},{"line":864,"kind":13,"containerName":"label","name":"$label"},{"line":864,"name":"$self","kind":13,"containerName":"label"},{"name":"down_get_label_at_pos","containerName":"label","kind":12,"line":864},{"containerName":"label","kind":13,"name":"$position","line":864},{"line":864,"name":"$firstlabel","containerName":"label","kind":13},{"name":"$label","containerName":"label","kind":13,"line":867}],"containerName":"main::","name":"label"},{"line":889,"kind":12,"range":{"start":{"line":889,"character":0},"end":{"line":918,"character":9999}},"signature":{"label":"position($self,$label,$firstlabel,$strand)","parameters":[{"label":"$self"},{"label":"$label"},{"label":"$firstlabel"},{"label":"$strand"}],"documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n\n# NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode) = @_;\n  if (defined $unsecuremode && $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    unless ($start) {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length;\n      }\n    } else {\n      unless ($length) {\n\t$end=$self->end;\n      }\n    }\n  } else {\n    if ($start) {\n      unless ($self->{'seq'}->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tunless ($self->{'seq'}->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n\tundef $length;\n      }\n    }\n  }\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,$length,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,$length,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n         : $substring = $obj->subseq(10,undef,4);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal.\n\n           Allows for negative numbers $obj->subseq(-10,-1). By\n           definition, there is no 0!\n                       -5  -1 1   5\n                gctagcgcccaac atggctcgctg\n\n           This allows to retrieve sequences upstream from given position.\n\n           The precedence is from left to right: if END is given LENGTH is\n           ignored.\n\n Examples: $obj->subseq(-10,undef,10) returns 10 elements before position 1\n           $obj->subseq(4,8) returns elements from the 4th to the 8th, inclusive\n\n Returns : a string\n Errorcode: -1\n Args    : start,  integer, defaults to start of the sequence\n           end,    integer, '' or undef, defaults to end of the sequence\n           length, integer, '' or undef\n           an optional strand (1 or -1) 4th argument \n            if strand argument is not given, it will default to the object\n            argment. This argument is useful when a call is issued from a child\n            of a parent object containing the subseq method\n\n\n#'\n# check the fact about reverse strand!\n# is it feasible? Is it correct? Should we do it? How about exons? Does it\n# work when you ask subseq of an exon?\n# eliminated now (Mon night)\nsub subseq {\n  ##my ($self,$pos1,$pos2,$length,$strand) = @_;\n  my ($self,$pos1,$pos2,$length,$strand) = @_;\n  ##unless (defined ($strand)) { # if optional [strand] argument not given\n  ##  $strand=$self->strand;\n  ##}\n  $strand=$self->strand;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  unless (defined ($pos1)) {\n    #print \"\\n##### DEBUG pos1 not defined\\n\";\n    $startlabel=$self->start;\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos2))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos2))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!)\"; return (-1);\n    ##  }\n    ##}\n    $startlabel=$self->label($pos1);\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  }\n  unless (defined ($pos2)) {\n    #print \"\\n##### pos2 not defined\\n\";\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos1))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos1))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!\"); return (-1);\n    ##  }\n    ##}\n    $endlabel=$self->label($pos2);\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  }\n  #print \"\\n    ####DEBUG: start $startlabel end $endlabel length $length strand $strand\\n\";\n\n  if ($strand == 1) {\n    $str = $self->{'seq'}->down_chain2string($startlabel,$length,$endlabel);\n  } else { # reverse strand\n    $str = $self->{'seq'}->up_chain2string($startlabel,$length,$endlabel);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n  }\n  return $str;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $seq->length();\n  Function: returns the number of nucleotides (or the number of aminoacids)\n            in the entire sequence\n  Returns : an integer\n  Errorcode -1\n  Args    : none\n\n\nsub length {\n  my $self=shift;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  if ($strand == 1) {\n    return $self->{'seq'}->down_subchain_length($start,$end);\n  } else {\n    return $self->{'seq'}->up_subchain_length($start,$end);\n  }\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, alias the common name of the object\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information.\n\n See also: accession_number\n Returns : a string\n Args    : none\n\n\nsub display_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'display_id'} = $value;\n  }\n  return $self->{'display_id'};\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number.\n           Notice that primary_id() provides the unique id for the\n           implemetation, allowing multiple objects to have the same accession\n           number in a particular implementation.\n\n           For objects with no accession_number this method returns \"unknown\".\n Returns : a string\n Args    : none\n\n\nsub accession_number {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'accession_number'} = $value;\n  }\n  unless (exists $self->{'accession_number'}) {\n    return \"unknown\";\n  } else {\n    return $self->{'accession_number'};\n  }\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their own\n           object ids in a way the implementation can control. Clients can\n           expect one id to map to one object.\n\n           For sequences with no primary_id, this method returns\n           a stringified memory location.\n\n Returns : A string\n Args    : None\n\n\n\nsub primary_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'primary_id'} = $value;\n  }\n  unless (exists $self->{'primary_id'}) {\n    return \"$self\";\n  } else {\n    return $self->{'primary_id'};\n  }\n}\n\n=head2 change\n\n Title   : change\n Usage   : $substring = $obj->change('AA', 10);\n Function: changes, modifies, mutates the LiveSequence\n Examples:\n        $obj->change('',   10);      delete nucleotide #10     \n        $obj->change('',   10, 2);   delete two nucleotides starting from #10\n        $obj->change('G',  10);      change nuc #10 to 'G'\n        $obj->change('GA', 10, 4);   replace #10 and 3 following with 'GA'\n        $obj->change('GA', 10, 2));  is same as $obj->change('GA',  10);\n        $obj->change('GA', 10, 0 );  insert 'GA' before nucleotide at #10\n        $obj->change('GA', 10, 1);   GA inserted before #10, #10 deleted\n        $obj->change('GATC', 10, 2); GATC inserted before #10, #10&#11 deleted\n        $obj->change('GATC', 10, 6); GATC inserted before #10, #10-#15 deleted\n\n\n Returns : a string of deleted bases (if any) or 1 (everything OK)\n Errorcode: -1\n Args    : seq,    string, or '' ('' = undef = 0 = deletion)\n           start,  integer\n           length, integer (optional)\n\n\nsub change {\n  &positionchange;\n}\n\n=head2 positionchange\n\n Title   : positionchange\n Function: Exactly like change. I.e. change() defaults to positionchange()\n\n\nsub positionchange {\n  my ($self,$newseq,$position,$length)=@_;\n  unless ($position) {\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  my $label=$self->label($position);\n  unless ($label > 0) { # label not found or error\n    $self->warn(\"No valid label found at that position!\");\n    return (-1);\n  }\n  return ($self->labelchange($newseq,$label,$length));\n}\n\n=head2 labelchange\n\n Title   : labelchange\n Function: Exactly like change but uses a /label/ instead than a position\n           as second argument. This allows for multiple changes in a LiveSeq\n           without the burden of recomputing positions. I.e. for a multiple\n           change in two different points of the LiveSeq, the approach would\n           be the following: fetch the correct labels out of the two different\n           positions (method: label($position)) and then use the labelchange()\n           method to modify the sequence using those labels instead than\n           relying on the positions (that would have modified after the\n           first change).\n\n\nsub labelchange {\n  my ($self,$newseq,$label,$length)=@_;\n  unless ($self->valid($label)) {\n    if ($self->{'seq'}->valid($label)) {\n       #$self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change for the object asked but it's ok for DNAlevel change, reverting to that\");\n      shift @_;\n      return($self->{'seq'}->labelchange(@_));\n    } else {\n      $self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change\");\n      return (-1);\n    }\n  }\n  unless ($newseq) { # it means this is a simple deletion\n    if (defined($length)) {\n      unless ($length >= 0) {\n\t$self->warn(\"No sense having length < 0 in a deletion\");\n\treturn (-1);\n      }\n    } else {\n      $self->warn(\"Length not defined for deletion!\");\n      return (-1);\n    }\n    return $self->_delete($label,$length);\n  }\n  my $newseqlength=CORE::length($newseq);\n  if (defined($length)) {\n    unless ($length >= 0) {\n      $self->warn(\"No sense having length < 0 in a change()\");\n      return (-1);\n    }\n  } else {\n    $length=$newseqlength; # defaults to pointmutation(s)\n  }\n  if ($length == 0) { # it means this is a simple insertion, length def&==0\n    my ($insertbegin,$insertend)=$self->_praeinsert($label,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n  if ($newseqlength == $length) { # it means this is simple pointmutation(s)\n    return $self->_mutate($label,$newseq,$length);\n  }\n  # if we arrived here then change is complex mixture\n  my $strand=$self->strand();\n  my $afterendlabel=$self->label($length+1,$label,$strand); # get the label at $length+1 positions after $label\n  unless ($afterendlabel > 0) { # label not found or error\n    $self->warn(\"No valid afterendlabel found for executing the complex mutation!\");\n    return (-1);\n  }\n  my $deleted=$self->_delete($label,$length); # first delete length nucs\n  if ($deleted == -1) { # if errors\n    return (-1);\n  } else { # then insert the newsequence\n    my ($insertbegin,$insertend)=$self->_praeinsert($afterendlabel,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n}\n\n# internal methods for change()\n\n# arguments: label for beginning of deletion, new sequence to insert\n# returns: labels of beginning and end of the inserted sequence\n# errorcode: -1\nsub _praeinsert {\n  my ($self,$label,$newseq)=@_;\n  my ($insertbegin,$insertend);\n  my $strand=$self->strand();\n  if ($strand == 1) {\n    ($insertbegin,$insertend)=($self->{'seq'}->praeinsert_string($newseq,$label));\n  } else { # since it's reverse strand and we insert in forward direction....\n    $newseq=reverse($newseq);\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n    ($insertend,$insertbegin)=($self->{'seq'}->postinsert_string($newseq,$label));\n  }\n  if (($insertbegin==0)||($insertend==0)) {\n    $self->warn(\"Some error occurred while inserting!\");\n    return (-1);\n  } else {\n    return ($insertbegin,$insertend);\n  }\n}\n\n# arguments: label for beginning of deletion, length of deletion\n# returns: string of deleted bases\n# errorcode: -1\nsub _delete {\n  my ($self,$label,$length)=@_;\n  my $strand=$self->strand();\n  my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n  unless ($endlabel > 0) { # label not found or error\n    $self->warn(\"No valid endlabel found for executing the deletion!\");\n    return (-1);\n  }\n  # this is important in Transcript to fix exon structure\n  $self->_deletecheck($label,$endlabel);\n  my $deletedseq;\n  if ($strand == 1) {\n    $deletedseq=$self->{'seq'}->splice_chain($label,undef,$endlabel);\n  } else {\n    $deletedseq=$self->{'seq'}->splice_chain($endlabel,undef,$label);\n    $deletedseq=reverse($deletedseq); # because we are on reverse strand and we cut anyway\n                         # in forward direction\n    $deletedseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  return ($deletedseq);\n}\n\n# empty function, overridden in Transcript, not useful here\nsub _deletecheck {\n}\n\n# arguments: label for beginning of mutation, newsequence, number of mutations\n# returns: 1 all OK\n# errorcode: -1\nsub _mutate {\n  my ($self,$label,$newseq,$length)=@_; # length is equal to length(newseq)\n  my ($i,$base,$nextlabel);\n  my @labels; # array of labels\n  my $strand=$self->strand();\n  if ($length == 1) { # special cases first\n    @labels=($label);\n  } else {\n    my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n    unless ($endlabel > 0) { # label not found or error\n      $self->warn(\"No valid endlabel found for executing the mutation!\");\n      return (-1);\n    }\n    if ($length == 2) { # another special case\n      @labels=($label,$endlabel);\n    } else { # more than 3 bases changed\n      # this wouldn't work for Transcript\n      #my $labelsarrayref;\n      #if ($strand == 1) {\n\t#$labelsarrayref=$self->{'seq'}->down_labels($label,$endlabel);\n      #} else {\n\t#$labelsarrayref=$self->{'seq'}->up_labels($label,$endlabel);\n      #}\n      #@labels=@{$labelsarrayref};\n      #if ($length != scalar(@labels)) { # not enough labels returned\n\t#$self->warn(\"Not enough valid labels found for executing the mutation!\");\n\t#return (-1);\n      #}\n\n      # this should be more general\n      @labels=($label); # put the first one\n      while ($label != $endlabel) {\n\t$nextlabel=$self->label(2,$label,$strand); # retrieve the next label\n\tpush (@labels,$nextlabel);\n\t$label=$nextlabel; # move on reference\n      }\n    }\n  }\n  if ($strand == -1) { # only for reverse strand\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  my $errorcheck; # if not equal to $length after summing for all changes, error did occurr\n  $i = 0;\n  foreach $base (split(//,$newseq)) {\n    $errorcheck += $self->{'seq'}->set_value_at_label($base,$labels[$i]);\n    $i++;\n  }\n  if ($errorcheck != $length) {\n    $self->warn(\"Some error occurred while mutating!\");\n    return (-1);\n  } else {\n    return (1);\n  }\n}\n\n=head2 valid\n\n  Title   : valid\n  Usage   : $boolean = $obj->valid($label)\n  Function: tests if a label exists inside the object\n  Returns : boolean\n  Args    : label\n\n\n# argument: label\n# returns: 1 YES 0 NO\nsub valid {\n  my ($self,$label)=@_;\n  my $checkme;\n  my @labels=$self->all_labels;\n  foreach $checkme (@labels) {\n    if ($label == $checkme) {\n      return (1); # found\n    }\n  }\n  return (0); # not found\n}\n\n\n=head2 start\n\n  Title   : start\n  Usage   : $startlabel=$obj->start()\n  Function: returns the label of the first nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub start {\n  my ($self) = @_;\n  return $self->{'start'}; # common for all classes BUT DNA (which redefines it) and Transcript (that takes the information from the Exons)\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $endlabel=$obj->end()\n  Function: returns the label of the last nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub end {\n  my ($self) = @_;\n  return $self->{'end'};\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand=$obj->strand()\n            $obj->strand($strand)\n  Function: gets or sets strand information, being 1 or -1 (forward or reverse)\n  Returns : -1 or 1\n  Args    : none OR -1 or 1\n\n\nsub strand {\n  my ($self,$strand) = @_;\n  if ($strand) {\n    if (($strand != 1)&&($strand != -1)) {\n      $self->warn(\"strand information not changed because strand identifier not valid\");\n    } else {\n      $self->{'strand'} = $strand;\n    }\n  }\n  return $self->{'strand'};\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n Returns : a string either 'dna','rna','protein'.\n Args    : none\n\n\n\nsub alphabet {\n  my %valid_type = map {$_, 1} qw( dna rna protein );\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $value = 'dna' if $value =~ /dna/i;\n    $value = 'rna' if $value =~ /rna/i;\n    unless ( $valid_type{$value} ) {\n      $self->warn(\"Molecular type '$value' is not a valid type\");\n    }\n    $self->{'alphabet'} = $value;\n  }\n  return $self->{'alphabet'};\n}\n\n=head2 coordinate_start\n\n  Title   : coordinate_start\n  Usage   : $coordstartlabel=$obj->coordinate_start()\n          : $coordstartlabel=$obj->coordinate_start($label)\n  Function: returns and optionally sets the first label of the coordinate\n            system used\n            For some objects only labels inside the object or in frame (for\n            Translation objects) will be allowed to get set as coordinate start\n\n  Returns : label. It returns 0 if label not found.\n  Errorcode -1 \n  Args    : an optional reference $label that is position 1\n\n\n\nsub coordinate_start {\n  my ($self,$label) = @_;\n  if ($label) {\n    if ($self->valid($label)) {\n      $self->{'coordinate_start'} = $label;\n    } else {\n      $self->warn(\"The label you are trying to set as coordinate_start is not valid for this object\");\n    }\n  }\n  my $coord_start = $self->{'coordinate_start'};\n  if ($coord_start) { \n    return $coord_start;\n  } else {\n    return $self->start();\n  }\n}\n\n=head2 label\n\n  Title   : label\n  Usage   : $seq->label($position)\n          : $seq->label($position,$firstlabel)\n  Examples: $nextlabel=$seq->label(2,$label) -> retrieves the following label\n          : $prevlabel=$seq->label(-1,$label) -> retrieves the preceding label\n\n  Function: returns the label of the nucleotide at $position from current\n            coordinate start\n  Returns : a label. It returns 0 if label not found.\n  Errorcode -1 \n  Args    : a position, \n            an optional reference $firstlabel that is to be used as position 1\n            an optional strand (1 or -1) argument \n             if strand argument is not given, it will default to the object\n             argument. This argument is useful when a call is issued from a child\n             of a parent object containing the subseq method\n\n\n\nsub label {\n  my ($self,$position,$firstlabel,$strand)=@_;\n  my $label;\n  unless (defined ($firstlabel)) {\n    $firstlabel=$self->coordinate_start;\n  }\n  unless ($position) {  # if position = 0 complain ?\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  unless (defined ($strand)) { # if optional [strand] argument not given\n    $strand=$self->strand;\n  }\n  if ($strand == 1) {\n    if ($position > 0) {\n      $label=$self->{'seq'}->down_get_label_at_pos($position,$firstlabel)\n    } else { # if < 0\n      $label=$self->{'seq'}->up_get_label_at_pos(1 - $position,$firstlabel)\n    }\n  } else {\n    if ($position > 0) {\n      $label=$self->{'seq'}->up_get_label_at_pos($position,$firstlabel)\n    } else { # if < 0\n      $label=$self->{'seq'}->down_get_label_at_pos(1 - $position,$firstlabel)\n    }\n  }\n  return $label;\n}\n\n\n=head2 position\n\n  Title   : position\n  Usage   : $seq->position($label)\n          : $seq->position($label,$firstlabel)\n  Function: returns the position of nucleotide at $label\n  Returns : the position of the label from current coordinate start\n  Errorcode 0\n  Args    : a label pointing to a certain nucleotide (e.g. start of exon)\n            an optional \"firstlabel\" as reference to count from\n            an optional strand (1 or -1) argument \n             if strand argument is not given, it will default to the object\n             argument. This argument is useful when a call is issued from a child\n             of a parent object containing the subseq method"},"children":[{"line":890,"localvar":"my","kind":13,"containerName":"position","name":"$self","definition":"my"},{"line":890,"containerName":"position","kind":13,"name":"$label"},{"line":890,"kind":13,"containerName":"position","name":"$firstlabel"},{"containerName":"position","kind":13,"name":"$strand","line":890},{"line":891,"name":"$strand","containerName":"position","kind":13},{"containerName":"position","kind":13,"name":"$strand","line":892},{"containerName":"position","kind":13,"name":"$self","line":892},{"line":892,"containerName":"position","kind":12,"name":"strand"},{"line":894,"name":"$firstlabel","containerName":"position","kind":13},{"name":"$firstlabel","kind":13,"containerName":"position","line":895},{"containerName":"position","kind":13,"name":"$self","line":895},{"name":"coordinate_start","containerName":"position","kind":12,"line":895},{"line":897,"name":"$self","containerName":"position","kind":13},{"line":897,"name":"valid","kind":12,"containerName":"position"},{"line":897,"kind":13,"containerName":"position","name":"$label"},{"line":898,"kind":13,"containerName":"position","name":"$self"},{"name":"warn","kind":12,"containerName":"position","line":898},{"line":901,"containerName":"position","kind":13,"name":"$firstlabel"},{"name":"$label","kind":13,"containerName":"position","line":901},{"definition":"my","name":"$coordpos","containerName":"position","localvar":"my","kind":13,"line":904},{"kind":13,"containerName":"position","name":"$position0","line":904},{"containerName":"position","kind":13,"name":"$position","line":904},{"line":905,"containerName":"position","kind":13,"name":"$position0"},{"line":905,"name":"$self","kind":13,"containerName":"position"},{"kind":12,"containerName":"position","name":"down_get_pos_of_label","line":905},{"name":"$label","kind":13,"containerName":"position","line":905},{"line":906,"name":"$coordpos","containerName":"position","kind":13},{"name":"$self","containerName":"position","kind":13,"line":906},{"line":906,"kind":12,"containerName":"position","name":"down_get_pos_of_label"},{"line":906,"name":"$firstlabel","kind":13,"containerName":"position"},{"containerName":"position","kind":13,"name":"$position","line":907},{"name":"$position0","kind":13,"containerName":"position","line":907},{"name":"$coordpos","kind":13,"containerName":"position","line":907},{"line":908,"name":"$position","kind":13,"containerName":"position"},{"line":909,"name":"$position","containerName":"position","kind":13},{"line":911,"containerName":"position","kind":13,"name":"$strand"},{"line":913,"name":"$position","kind":13,"containerName":"position"},{"line":916,"name":"$position","containerName":"position","kind":13}],"containerName":"main::","name":"position","definition":"sub","detail":"($self,$label,$firstlabel,$strand)"},{"detail":"($self,$firstlabel,$secondlabel,$strand)","definition":"sub","containerName":"main::","name":"follows","children":[{"definition":"my","line":942,"name":"$self","localvar":"my","containerName":"follows","kind":13},{"line":942,"name":"$firstlabel","kind":13,"containerName":"follows"},{"line":942,"name":"$secondlabel","kind":13,"containerName":"follows"},{"line":942,"kind":13,"containerName":"follows","name":"$strand"},{"containerName":"follows","kind":13,"name":"$strand","line":943},{"line":944,"containerName":"follows","kind":13,"name":"$strand"},{"line":944,"name":"$self","kind":13,"containerName":"follows"},{"line":944,"kind":12,"containerName":"follows","name":"strand"},{"containerName":"follows","kind":13,"name":"$strand","line":946},{"line":947,"name":"$self","containerName":"follows","kind":13},{"name":"is_downstream","kind":12,"containerName":"follows","line":947},{"kind":13,"containerName":"follows","name":"$firstlabel","line":947},{"line":947,"containerName":"follows","kind":13,"name":"$secondlabel"},{"line":949,"name":"$self","kind":13,"containerName":"follows"},{"line":949,"name":"is_upstream","containerName":"follows","kind":12},{"containerName":"follows","kind":13,"name":"$firstlabel","line":949},{"line":949,"name":"$secondlabel","kind":13,"containerName":"follows"}],"signature":{"documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n\n# NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode) = @_;\n  if (defined $unsecuremode && $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    unless ($start) {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length;\n      }\n    } else {\n      unless ($length) {\n\t$end=$self->end;\n      }\n    }\n  } else {\n    if ($start) {\n      unless ($self->{'seq'}->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tunless ($self->{'seq'}->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n\tundef $length;\n      }\n    }\n  }\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,$length,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,$length,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n         : $substring = $obj->subseq(10,undef,4);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal.\n\n           Allows for negative numbers $obj->subseq(-10,-1). By\n           definition, there is no 0!\n                       -5  -1 1   5\n                gctagcgcccaac atggctcgctg\n\n           This allows to retrieve sequences upstream from given position.\n\n           The precedence is from left to right: if END is given LENGTH is\n           ignored.\n\n Examples: $obj->subseq(-10,undef,10) returns 10 elements before position 1\n           $obj->subseq(4,8) returns elements from the 4th to the 8th, inclusive\n\n Returns : a string\n Errorcode: -1\n Args    : start,  integer, defaults to start of the sequence\n           end,    integer, '' or undef, defaults to end of the sequence\n           length, integer, '' or undef\n           an optional strand (1 or -1) 4th argument \n            if strand argument is not given, it will default to the object\n            argment. This argument is useful when a call is issued from a child\n            of a parent object containing the subseq method\n\n\n#'\n# check the fact about reverse strand!\n# is it feasible? Is it correct? Should we do it? How about exons? Does it\n# work when you ask subseq of an exon?\n# eliminated now (Mon night)\nsub subseq {\n  ##my ($self,$pos1,$pos2,$length,$strand) = @_;\n  my ($self,$pos1,$pos2,$length,$strand) = @_;\n  ##unless (defined ($strand)) { # if optional [strand] argument not given\n  ##  $strand=$self->strand;\n  ##}\n  $strand=$self->strand;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  unless (defined ($pos1)) {\n    #print \"\\n##### DEBUG pos1 not defined\\n\";\n    $startlabel=$self->start;\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos2))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos2))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!)\"; return (-1);\n    ##  }\n    ##}\n    $startlabel=$self->label($pos1);\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  }\n  unless (defined ($pos2)) {\n    #print \"\\n##### pos2 not defined\\n\";\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos1))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos1))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!\"); return (-1);\n    ##  }\n    ##}\n    $endlabel=$self->label($pos2);\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  }\n  #print \"\\n    ####DEBUG: start $startlabel end $endlabel length $length strand $strand\\n\";\n\n  if ($strand == 1) {\n    $str = $self->{'seq'}->down_chain2string($startlabel,$length,$endlabel);\n  } else { # reverse strand\n    $str = $self->{'seq'}->up_chain2string($startlabel,$length,$endlabel);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n  }\n  return $str;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $seq->length();\n  Function: returns the number of nucleotides (or the number of aminoacids)\n            in the entire sequence\n  Returns : an integer\n  Errorcode -1\n  Args    : none\n\n\nsub length {\n  my $self=shift;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  if ($strand == 1) {\n    return $self->{'seq'}->down_subchain_length($start,$end);\n  } else {\n    return $self->{'seq'}->up_subchain_length($start,$end);\n  }\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, alias the common name of the object\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information.\n\n See also: accession_number\n Returns : a string\n Args    : none\n\n\nsub display_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'display_id'} = $value;\n  }\n  return $self->{'display_id'};\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number.\n           Notice that primary_id() provides the unique id for the\n           implemetation, allowing multiple objects to have the same accession\n           number in a particular implementation.\n\n           For objects with no accession_number this method returns \"unknown\".\n Returns : a string\n Args    : none\n\n\nsub accession_number {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'accession_number'} = $value;\n  }\n  unless (exists $self->{'accession_number'}) {\n    return \"unknown\";\n  } else {\n    return $self->{'accession_number'};\n  }\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their own\n           object ids in a way the implementation can control. Clients can\n           expect one id to map to one object.\n\n           For sequences with no primary_id, this method returns\n           a stringified memory location.\n\n Returns : A string\n Args    : None\n\n\n\nsub primary_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'primary_id'} = $value;\n  }\n  unless (exists $self->{'primary_id'}) {\n    return \"$self\";\n  } else {\n    return $self->{'primary_id'};\n  }\n}\n\n=head2 change\n\n Title   : change\n Usage   : $substring = $obj->change('AA', 10);\n Function: changes, modifies, mutates the LiveSequence\n Examples:\n        $obj->change('',   10);      delete nucleotide #10     \n        $obj->change('',   10, 2);   delete two nucleotides starting from #10\n        $obj->change('G',  10);      change nuc #10 to 'G'\n        $obj->change('GA', 10, 4);   replace #10 and 3 following with 'GA'\n        $obj->change('GA', 10, 2));  is same as $obj->change('GA',  10);\n        $obj->change('GA', 10, 0 );  insert 'GA' before nucleotide at #10\n        $obj->change('GA', 10, 1);   GA inserted before #10, #10 deleted\n        $obj->change('GATC', 10, 2); GATC inserted before #10, #10&#11 deleted\n        $obj->change('GATC', 10, 6); GATC inserted before #10, #10-#15 deleted\n\n\n Returns : a string of deleted bases (if any) or 1 (everything OK)\n Errorcode: -1\n Args    : seq,    string, or '' ('' = undef = 0 = deletion)\n           start,  integer\n           length, integer (optional)\n\n\nsub change {\n  &positionchange;\n}\n\n=head2 positionchange\n\n Title   : positionchange\n Function: Exactly like change. I.e. change() defaults to positionchange()\n\n\nsub positionchange {\n  my ($self,$newseq,$position,$length)=@_;\n  unless ($position) {\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  my $label=$self->label($position);\n  unless ($label > 0) { # label not found or error\n    $self->warn(\"No valid label found at that position!\");\n    return (-1);\n  }\n  return ($self->labelchange($newseq,$label,$length));\n}\n\n=head2 labelchange\n\n Title   : labelchange\n Function: Exactly like change but uses a /label/ instead than a position\n           as second argument. This allows for multiple changes in a LiveSeq\n           without the burden of recomputing positions. I.e. for a multiple\n           change in two different points of the LiveSeq, the approach would\n           be the following: fetch the correct labels out of the two different\n           positions (method: label($position)) and then use the labelchange()\n           method to modify the sequence using those labels instead than\n           relying on the positions (that would have modified after the\n           first change).\n\n\nsub labelchange {\n  my ($self,$newseq,$label,$length)=@_;\n  unless ($self->valid($label)) {\n    if ($self->{'seq'}->valid($label)) {\n       #$self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change for the object asked but it's ok for DNAlevel change, reverting to that\");\n      shift @_;\n      return($self->{'seq'}->labelchange(@_));\n    } else {\n      $self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change\");\n      return (-1);\n    }\n  }\n  unless ($newseq) { # it means this is a simple deletion\n    if (defined($length)) {\n      unless ($length >= 0) {\n\t$self->warn(\"No sense having length < 0 in a deletion\");\n\treturn (-1);\n      }\n    } else {\n      $self->warn(\"Length not defined for deletion!\");\n      return (-1);\n    }\n    return $self->_delete($label,$length);\n  }\n  my $newseqlength=CORE::length($newseq);\n  if (defined($length)) {\n    unless ($length >= 0) {\n      $self->warn(\"No sense having length < 0 in a change()\");\n      return (-1);\n    }\n  } else {\n    $length=$newseqlength; # defaults to pointmutation(s)\n  }\n  if ($length == 0) { # it means this is a simple insertion, length def&==0\n    my ($insertbegin,$insertend)=$self->_praeinsert($label,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n  if ($newseqlength == $length) { # it means this is simple pointmutation(s)\n    return $self->_mutate($label,$newseq,$length);\n  }\n  # if we arrived here then change is complex mixture\n  my $strand=$self->strand();\n  my $afterendlabel=$self->label($length+1,$label,$strand); # get the label at $length+1 positions after $label\n  unless ($afterendlabel > 0) { # label not found or error\n    $self->warn(\"No valid afterendlabel found for executing the complex mutation!\");\n    return (-1);\n  }\n  my $deleted=$self->_delete($label,$length); # first delete length nucs\n  if ($deleted == -1) { # if errors\n    return (-1);\n  } else { # then insert the newsequence\n    my ($insertbegin,$insertend)=$self->_praeinsert($afterendlabel,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n}\n\n# internal methods for change()\n\n# arguments: label for beginning of deletion, new sequence to insert\n# returns: labels of beginning and end of the inserted sequence\n# errorcode: -1\nsub _praeinsert {\n  my ($self,$label,$newseq)=@_;\n  my ($insertbegin,$insertend);\n  my $strand=$self->strand();\n  if ($strand == 1) {\n    ($insertbegin,$insertend)=($self->{'seq'}->praeinsert_string($newseq,$label));\n  } else { # since it's reverse strand and we insert in forward direction....\n    $newseq=reverse($newseq);\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n    ($insertend,$insertbegin)=($self->{'seq'}->postinsert_string($newseq,$label));\n  }\n  if (($insertbegin==0)||($insertend==0)) {\n    $self->warn(\"Some error occurred while inserting!\");\n    return (-1);\n  } else {\n    return ($insertbegin,$insertend);\n  }\n}\n\n# arguments: label for beginning of deletion, length of deletion\n# returns: string of deleted bases\n# errorcode: -1\nsub _delete {\n  my ($self,$label,$length)=@_;\n  my $strand=$self->strand();\n  my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n  unless ($endlabel > 0) { # label not found or error\n    $self->warn(\"No valid endlabel found for executing the deletion!\");\n    return (-1);\n  }\n  # this is important in Transcript to fix exon structure\n  $self->_deletecheck($label,$endlabel);\n  my $deletedseq;\n  if ($strand == 1) {\n    $deletedseq=$self->{'seq'}->splice_chain($label,undef,$endlabel);\n  } else {\n    $deletedseq=$self->{'seq'}->splice_chain($endlabel,undef,$label);\n    $deletedseq=reverse($deletedseq); # because we are on reverse strand and we cut anyway\n                         # in forward direction\n    $deletedseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  return ($deletedseq);\n}\n\n# empty function, overridden in Transcript, not useful here\nsub _deletecheck {\n}\n\n# arguments: label for beginning of mutation, newsequence, number of mutations\n# returns: 1 all OK\n# errorcode: -1\nsub _mutate {\n  my ($self,$label,$newseq,$length)=@_; # length is equal to length(newseq)\n  my ($i,$base,$nextlabel);\n  my @labels; # array of labels\n  my $strand=$self->strand();\n  if ($length == 1) { # special cases first\n    @labels=($label);\n  } else {\n    my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n    unless ($endlabel > 0) { # label not found or error\n      $self->warn(\"No valid endlabel found for executing the mutation!\");\n      return (-1);\n    }\n    if ($length == 2) { # another special case\n      @labels=($label,$endlabel);\n    } else { # more than 3 bases changed\n      # this wouldn't work for Transcript\n      #my $labelsarrayref;\n      #if ($strand == 1) {\n\t#$labelsarrayref=$self->{'seq'}->down_labels($label,$endlabel);\n      #} else {\n\t#$labelsarrayref=$self->{'seq'}->up_labels($label,$endlabel);\n      #}\n      #@labels=@{$labelsarrayref};\n      #if ($length != scalar(@labels)) { # not enough labels returned\n\t#$self->warn(\"Not enough valid labels found for executing the mutation!\");\n\t#return (-1);\n      #}\n\n      # this should be more general\n      @labels=($label); # put the first one\n      while ($label != $endlabel) {\n\t$nextlabel=$self->label(2,$label,$strand); # retrieve the next label\n\tpush (@labels,$nextlabel);\n\t$label=$nextlabel; # move on reference\n      }\n    }\n  }\n  if ($strand == -1) { # only for reverse strand\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  my $errorcheck; # if not equal to $length after summing for all changes, error did occurr\n  $i = 0;\n  foreach $base (split(//,$newseq)) {\n    $errorcheck += $self->{'seq'}->set_value_at_label($base,$labels[$i]);\n    $i++;\n  }\n  if ($errorcheck != $length) {\n    $self->warn(\"Some error occurred while mutating!\");\n    return (-1);\n  } else {\n    return (1);\n  }\n}\n\n=head2 valid\n\n  Title   : valid\n  Usage   : $boolean = $obj->valid($label)\n  Function: tests if a label exists inside the object\n  Returns : boolean\n  Args    : label\n\n\n# argument: label\n# returns: 1 YES 0 NO\nsub valid {\n  my ($self,$label)=@_;\n  my $checkme;\n  my @labels=$self->all_labels;\n  foreach $checkme (@labels) {\n    if ($label == $checkme) {\n      return (1); # found\n    }\n  }\n  return (0); # not found\n}\n\n\n=head2 start\n\n  Title   : start\n  Usage   : $startlabel=$obj->start()\n  Function: returns the label of the first nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub start {\n  my ($self) = @_;\n  return $self->{'start'}; # common for all classes BUT DNA (which redefines it) and Transcript (that takes the information from the Exons)\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $endlabel=$obj->end()\n  Function: returns the label of the last nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub end {\n  my ($self) = @_;\n  return $self->{'end'};\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand=$obj->strand()\n            $obj->strand($strand)\n  Function: gets or sets strand information, being 1 or -1 (forward or reverse)\n  Returns : -1 or 1\n  Args    : none OR -1 or 1\n\n\nsub strand {\n  my ($self,$strand) = @_;\n  if ($strand) {\n    if (($strand != 1)&&($strand != -1)) {\n      $self->warn(\"strand information not changed because strand identifier not valid\");\n    } else {\n      $self->{'strand'} = $strand;\n    }\n  }\n  return $self->{'strand'};\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n Returns : a string either 'dna','rna','protein'.\n Args    : none\n\n\n\nsub alphabet {\n  my %valid_type = map {$_, 1} qw( dna rna protein );\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $value = 'dna' if $value =~ /dna/i;\n    $value = 'rna' if $value =~ /rna/i;\n    unless ( $valid_type{$value} ) {\n      $self->warn(\"Molecular type '$value' is not a valid type\");\n    }\n    $self->{'alphabet'} = $value;\n  }\n  return $self->{'alphabet'};\n}\n\n=head2 coordinate_start\n\n  Title   : coordinate_start\n  Usage   : $coordstartlabel=$obj->coordinate_start()\n          : $coordstartlabel=$obj->coordinate_start($label)\n  Function: returns and optionally sets the first label of the coordinate\n            system used\n            For some objects only labels inside the object or in frame (for\n            Translation objects) will be allowed to get set as coordinate start\n\n  Returns : label. It returns 0 if label not found.\n  Errorcode -1 \n  Args    : an optional reference $label that is position 1\n\n\n\nsub coordinate_start {\n  my ($self,$label) = @_;\n  if ($label) {\n    if ($self->valid($label)) {\n      $self->{'coordinate_start'} = $label;\n    } else {\n      $self->warn(\"The label you are trying to set as coordinate_start is not valid for this object\");\n    }\n  }\n  my $coord_start = $self->{'coordinate_start'};\n  if ($coord_start) { \n    return $coord_start;\n  } else {\n    return $self->start();\n  }\n}\n\n=head2 label\n\n  Title   : label\n  Usage   : $seq->label($position)\n          : $seq->label($position,$firstlabel)\n  Examples: $nextlabel=$seq->label(2,$label) -> retrieves the following label\n          : $prevlabel=$seq->label(-1,$label) -> retrieves the preceding label\n\n  Function: returns the label of the nucleotide at $position from current\n            coordinate start\n  Returns : a label. It returns 0 if label not found.\n  Errorcode -1 \n  Args    : a position, \n            an optional reference $firstlabel that is to be used as position 1\n            an optional strand (1 or -1) argument \n             if strand argument is not given, it will default to the object\n             argument. This argument is useful when a call is issued from a child\n             of a parent object containing the subseq method\n\n\n\nsub label {\n  my ($self,$position,$firstlabel,$strand)=@_;\n  my $label;\n  unless (defined ($firstlabel)) {\n    $firstlabel=$self->coordinate_start;\n  }\n  unless ($position) {  # if position = 0 complain ?\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  unless (defined ($strand)) { # if optional [strand] argument not given\n    $strand=$self->strand;\n  }\n  if ($strand == 1) {\n    if ($position > 0) {\n      $label=$self->{'seq'}->down_get_label_at_pos($position,$firstlabel)\n    } else { # if < 0\n      $label=$self->{'seq'}->up_get_label_at_pos(1 - $position,$firstlabel)\n    }\n  } else {\n    if ($position > 0) {\n      $label=$self->{'seq'}->up_get_label_at_pos($position,$firstlabel)\n    } else { # if < 0\n      $label=$self->{'seq'}->down_get_label_at_pos(1 - $position,$firstlabel)\n    }\n  }\n  return $label;\n}\n\n\n=head2 position\n\n  Title   : position\n  Usage   : $seq->position($label)\n          : $seq->position($label,$firstlabel)\n  Function: returns the position of nucleotide at $label\n  Returns : the position of the label from current coordinate start\n  Errorcode 0\n  Args    : a label pointing to a certain nucleotide (e.g. start of exon)\n            an optional \"firstlabel\" as reference to count from\n            an optional strand (1 or -1) argument \n             if strand argument is not given, it will default to the object\n             argument. This argument is useful when a call is issued from a child\n             of a parent object containing the subseq method\n\n\n\nsub position {\n  my ($self,$label,$firstlabel,$strand)=@_;\n  unless (defined ($strand)) { # if optional [strand] argument not given\n    $strand=$self->strand;\n  }\n  unless (defined ($firstlabel)) {\n    $firstlabel=$self->coordinate_start;\n  }\n  unless ($self->valid($label)) {\n    $self->warn(\"label not valid\");\n    return (0);\n  }\n  if ($firstlabel == $label) {\n    return (1);\n  }\n  my ($coordpos,$position0,$position);\n  $position0=$self->{'seq'}->down_get_pos_of_label($label);\n  $coordpos=$self->{'seq'}->down_get_pos_of_label($firstlabel);\n  $position=$position0-$coordpos+1;\n  if ($position <= 0) {\n    $position--;\n  }\n  if ($strand == -1) {\n    #print \"\\n----------DEBUGSEQPOS label $label firstlabel $firstlabel strand $strand: position=\",1-$position;\n    return (1-$position);\n  } else {\n    #print \"\\n----------DEBUGSEQPOS label $label firstlabel $firstlabel strand $strand: position=\",$position;\n    return ($position);\n  }\n}\n\n=head2 follows\n\n  Title   : follows\n  Usage   : $seq->follows($firstlabel,$secondlabel)\n          : $seq->follows($firstlabel,$secondlabel,$strand)\n  Function: checks if SECONDlabel follows FIRSTlabel, undependent of the strand\n            i.e. it checks downstream for forward strand and\n            upstream for reverse strand\n  Returns : 1 or 0\n  Errorcode -1\n  Args    : two labels\n            an optional strand (1 or -1) argument \n             if strand argument is not given, it will default to the object\n             argument. This argument is useful when a call is issued from a child\n             of a parent object containing the subseq method\n\n'\n wraparound to is_downstream and is_upstream that chooses the correct one\n depending on the strand","parameters":[{"label":"$self"},{"label":"$firstlabel"},{"label":"$secondlabel"},{"label":"$strand"}],"label":"follows($self,$firstlabel,$secondlabel,$strand)"},"kind":12,"range":{"end":{"character":9999,"line":951},"start":{"line":941,"character":0}},"line":941},{"line":1057,"kind":12,"range":{"start":{"character":0,"line":1057},"end":{"line":1067,"character":9999}},"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n\n# NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode) = @_;\n  if (defined $unsecuremode && $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    unless ($start) {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length;\n      }\n    } else {\n      unless ($length) {\n\t$end=$self->end;\n      }\n    }\n  } else {\n    if ($start) {\n      unless ($self->{'seq'}->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tunless ($self->{'seq'}->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n\tundef $length;\n      }\n    }\n  }\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,$length,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,$length,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n         : $substring = $obj->subseq(10,undef,4);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal.\n\n           Allows for negative numbers $obj->subseq(-10,-1). By\n           definition, there is no 0!\n                       -5  -1 1   5\n                gctagcgcccaac atggctcgctg\n\n           This allows to retrieve sequences upstream from given position.\n\n           The precedence is from left to right: if END is given LENGTH is\n           ignored.\n\n Examples: $obj->subseq(-10,undef,10) returns 10 elements before position 1\n           $obj->subseq(4,8) returns elements from the 4th to the 8th, inclusive\n\n Returns : a string\n Errorcode: -1\n Args    : start,  integer, defaults to start of the sequence\n           end,    integer, '' or undef, defaults to end of the sequence\n           length, integer, '' or undef\n           an optional strand (1 or -1) 4th argument \n            if strand argument is not given, it will default to the object\n            argment. This argument is useful when a call is issued from a child\n            of a parent object containing the subseq method\n\n\n#'\n# check the fact about reverse strand!\n# is it feasible? Is it correct? Should we do it? How about exons? Does it\n# work when you ask subseq of an exon?\n# eliminated now (Mon night)\nsub subseq {\n  ##my ($self,$pos1,$pos2,$length,$strand) = @_;\n  my ($self,$pos1,$pos2,$length,$strand) = @_;\n  ##unless (defined ($strand)) { # if optional [strand] argument not given\n  ##  $strand=$self->strand;\n  ##}\n  $strand=$self->strand;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  unless (defined ($pos1)) {\n    #print \"\\n##### DEBUG pos1 not defined\\n\";\n    $startlabel=$self->start;\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos2))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos2))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!)\"; return (-1);\n    ##  }\n    ##}\n    $startlabel=$self->label($pos1);\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  }\n  unless (defined ($pos2)) {\n    #print \"\\n##### pos2 not defined\\n\";\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos1))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos1))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!\"); return (-1);\n    ##  }\n    ##}\n    $endlabel=$self->label($pos2);\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  }\n  #print \"\\n    ####DEBUG: start $startlabel end $endlabel length $length strand $strand\\n\";\n\n  if ($strand == 1) {\n    $str = $self->{'seq'}->down_chain2string($startlabel,$length,$endlabel);\n  } else { # reverse strand\n    $str = $self->{'seq'}->up_chain2string($startlabel,$length,$endlabel);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n  }\n  return $str;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $seq->length();\n  Function: returns the number of nucleotides (or the number of aminoacids)\n            in the entire sequence\n  Returns : an integer\n  Errorcode -1\n  Args    : none\n\n\nsub length {\n  my $self=shift;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  if ($strand == 1) {\n    return $self->{'seq'}->down_subchain_length($start,$end);\n  } else {\n    return $self->{'seq'}->up_subchain_length($start,$end);\n  }\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, alias the common name of the object\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information.\n\n See also: accession_number\n Returns : a string\n Args    : none\n\n\nsub display_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'display_id'} = $value;\n  }\n  return $self->{'display_id'};\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number.\n           Notice that primary_id() provides the unique id for the\n           implemetation, allowing multiple objects to have the same accession\n           number in a particular implementation.\n\n           For objects with no accession_number this method returns \"unknown\".\n Returns : a string\n Args    : none\n\n\nsub accession_number {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'accession_number'} = $value;\n  }\n  unless (exists $self->{'accession_number'}) {\n    return \"unknown\";\n  } else {\n    return $self->{'accession_number'};\n  }\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their own\n           object ids in a way the implementation can control. Clients can\n           expect one id to map to one object.\n\n           For sequences with no primary_id, this method returns\n           a stringified memory location.\n\n Returns : A string\n Args    : None\n\n\n\nsub primary_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'primary_id'} = $value;\n  }\n  unless (exists $self->{'primary_id'}) {\n    return \"$self\";\n  } else {\n    return $self->{'primary_id'};\n  }\n}\n\n=head2 change\n\n Title   : change\n Usage   : $substring = $obj->change('AA', 10);\n Function: changes, modifies, mutates the LiveSequence\n Examples:\n        $obj->change('',   10);      delete nucleotide #10     \n        $obj->change('',   10, 2);   delete two nucleotides starting from #10\n        $obj->change('G',  10);      change nuc #10 to 'G'\n        $obj->change('GA', 10, 4);   replace #10 and 3 following with 'GA'\n        $obj->change('GA', 10, 2));  is same as $obj->change('GA',  10);\n        $obj->change('GA', 10, 0 );  insert 'GA' before nucleotide at #10\n        $obj->change('GA', 10, 1);   GA inserted before #10, #10 deleted\n        $obj->change('GATC', 10, 2); GATC inserted before #10, #10&#11 deleted\n        $obj->change('GATC', 10, 6); GATC inserted before #10, #10-#15 deleted\n\n\n Returns : a string of deleted bases (if any) or 1 (everything OK)\n Errorcode: -1\n Args    : seq,    string, or '' ('' = undef = 0 = deletion)\n           start,  integer\n           length, integer (optional)\n\n\nsub change {\n  &positionchange;\n}\n\n=head2 positionchange\n\n Title   : positionchange\n Function: Exactly like change. I.e. change() defaults to positionchange()\n\n\nsub positionchange {\n  my ($self,$newseq,$position,$length)=@_;\n  unless ($position) {\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  my $label=$self->label($position);\n  unless ($label > 0) { # label not found or error\n    $self->warn(\"No valid label found at that position!\");\n    return (-1);\n  }\n  return ($self->labelchange($newseq,$label,$length));\n}\n\n=head2 labelchange\n\n Title   : labelchange\n Function: Exactly like change but uses a /label/ instead than a position\n           as second argument. This allows for multiple changes in a LiveSeq\n           without the burden of recomputing positions. I.e. for a multiple\n           change in two different points of the LiveSeq, the approach would\n           be the following: fetch the correct labels out of the two different\n           positions (method: label($position)) and then use the labelchange()\n           method to modify the sequence using those labels instead than\n           relying on the positions (that would have modified after the\n           first change).\n\n\nsub labelchange {\n  my ($self,$newseq,$label,$length)=@_;\n  unless ($self->valid($label)) {\n    if ($self->{'seq'}->valid($label)) {\n       #$self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change for the object asked but it's ok for DNAlevel change, reverting to that\");\n      shift @_;\n      return($self->{'seq'}->labelchange(@_));\n    } else {\n      $self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change\");\n      return (-1);\n    }\n  }\n  unless ($newseq) { # it means this is a simple deletion\n    if (defined($length)) {\n      unless ($length >= 0) {\n\t$self->warn(\"No sense having length < 0 in a deletion\");\n\treturn (-1);\n      }\n    } else {\n      $self->warn(\"Length not defined for deletion!\");\n      return (-1);\n    }\n    return $self->_delete($label,$length);\n  }\n  my $newseqlength=CORE::length($newseq);\n  if (defined($length)) {\n    unless ($length >= 0) {\n      $self->warn(\"No sense having length < 0 in a change()\");\n      return (-1);\n    }\n  } else {\n    $length=$newseqlength; # defaults to pointmutation(s)\n  }\n  if ($length == 0) { # it means this is a simple insertion, length def&==0\n    my ($insertbegin,$insertend)=$self->_praeinsert($label,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n  if ($newseqlength == $length) { # it means this is simple pointmutation(s)\n    return $self->_mutate($label,$newseq,$length);\n  }\n  # if we arrived here then change is complex mixture\n  my $strand=$self->strand();\n  my $afterendlabel=$self->label($length+1,$label,$strand); # get the label at $length+1 positions after $label\n  unless ($afterendlabel > 0) { # label not found or error\n    $self->warn(\"No valid afterendlabel found for executing the complex mutation!\");\n    return (-1);\n  }\n  my $deleted=$self->_delete($label,$length); # first delete length nucs\n  if ($deleted == -1) { # if errors\n    return (-1);\n  } else { # then insert the newsequence\n    my ($insertbegin,$insertend)=$self->_praeinsert($afterendlabel,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n}\n\n# internal methods for change()\n\n# arguments: label for beginning of deletion, new sequence to insert\n# returns: labels of beginning and end of the inserted sequence\n# errorcode: -1\nsub _praeinsert {\n  my ($self,$label,$newseq)=@_;\n  my ($insertbegin,$insertend);\n  my $strand=$self->strand();\n  if ($strand == 1) {\n    ($insertbegin,$insertend)=($self->{'seq'}->praeinsert_string($newseq,$label));\n  } else { # since it's reverse strand and we insert in forward direction....\n    $newseq=reverse($newseq);\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n    ($insertend,$insertbegin)=($self->{'seq'}->postinsert_string($newseq,$label));\n  }\n  if (($insertbegin==0)||($insertend==0)) {\n    $self->warn(\"Some error occurred while inserting!\");\n    return (-1);\n  } else {\n    return ($insertbegin,$insertend);\n  }\n}\n\n# arguments: label for beginning of deletion, length of deletion\n# returns: string of deleted bases\n# errorcode: -1\nsub _delete {\n  my ($self,$label,$length)=@_;\n  my $strand=$self->strand();\n  my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n  unless ($endlabel > 0) { # label not found or error\n    $self->warn(\"No valid endlabel found for executing the deletion!\");\n    return (-1);\n  }\n  # this is important in Transcript to fix exon structure\n  $self->_deletecheck($label,$endlabel);\n  my $deletedseq;\n  if ($strand == 1) {\n    $deletedseq=$self->{'seq'}->splice_chain($label,undef,$endlabel);\n  } else {\n    $deletedseq=$self->{'seq'}->splice_chain($endlabel,undef,$label);\n    $deletedseq=reverse($deletedseq); # because we are on reverse strand and we cut anyway\n                         # in forward direction\n    $deletedseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  return ($deletedseq);\n}\n\n# empty function, overridden in Transcript, not useful here\nsub _deletecheck {\n}\n\n# arguments: label for beginning of mutation, newsequence, number of mutations\n# returns: 1 all OK\n# errorcode: -1\nsub _mutate {\n  my ($self,$label,$newseq,$length)=@_; # length is equal to length(newseq)\n  my ($i,$base,$nextlabel);\n  my @labels; # array of labels\n  my $strand=$self->strand();\n  if ($length == 1) { # special cases first\n    @labels=($label);\n  } else {\n    my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n    unless ($endlabel > 0) { # label not found or error\n      $self->warn(\"No valid endlabel found for executing the mutation!\");\n      return (-1);\n    }\n    if ($length == 2) { # another special case\n      @labels=($label,$endlabel);\n    } else { # more than 3 bases changed\n      # this wouldn't work for Transcript\n      #my $labelsarrayref;\n      #if ($strand == 1) {\n\t#$labelsarrayref=$self->{'seq'}->down_labels($label,$endlabel);\n      #} else {\n\t#$labelsarrayref=$self->{'seq'}->up_labels($label,$endlabel);\n      #}\n      #@labels=@{$labelsarrayref};\n      #if ($length != scalar(@labels)) { # not enough labels returned\n\t#$self->warn(\"Not enough valid labels found for executing the mutation!\");\n\t#return (-1);\n      #}\n\n      # this should be more general\n      @labels=($label); # put the first one\n      while ($label != $endlabel) {\n\t$nextlabel=$self->label(2,$label,$strand); # retrieve the next label\n\tpush (@labels,$nextlabel);\n\t$label=$nextlabel; # move on reference\n      }\n    }\n  }\n  if ($strand == -1) { # only for reverse strand\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  my $errorcheck; # if not equal to $length after summing for all changes, error did occurr\n  $i = 0;\n  foreach $base (split(//,$newseq)) {\n    $errorcheck += $self->{'seq'}->set_value_at_label($base,$labels[$i]);\n    $i++;\n  }\n  if ($errorcheck != $length) {\n    $self->warn(\"Some error occurred while mutating!\");\n    return (-1);\n  } else {\n    return (1);\n  }\n}\n\n=head2 valid\n\n  Title   : valid\n  Usage   : $boolean = $obj->valid($label)\n  Function: tests if a label exists inside the object\n  Returns : boolean\n  Args    : label\n\n\n# argument: label\n# returns: 1 YES 0 NO\nsub valid {\n  my ($self,$label)=@_;\n  my $checkme;\n  my @labels=$self->all_labels;\n  foreach $checkme (@labels) {\n    if ($label == $checkme) {\n      return (1); # found\n    }\n  }\n  return (0); # not found\n}\n\n\n=head2 start\n\n  Title   : start\n  Usage   : $startlabel=$obj->start()\n  Function: returns the label of the first nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub start {\n  my ($self) = @_;\n  return $self->{'start'}; # common for all classes BUT DNA (which redefines it) and Transcript (that takes the information from the Exons)\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $endlabel=$obj->end()\n  Function: returns the label of the last nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub end {\n  my ($self) = @_;\n  return $self->{'end'};\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand=$obj->strand()\n            $obj->strand($strand)\n  Function: gets or sets strand information, being 1 or -1 (forward or reverse)\n  Returns : -1 or 1\n  Args    : none OR -1 or 1\n\n\nsub strand {\n  my ($self,$strand) = @_;\n  if ($strand) {\n    if (($strand != 1)&&($strand != -1)) {\n      $self->warn(\"strand information not changed because strand identifier not valid\");\n    } else {\n      $self->{'strand'} = $strand;\n    }\n  }\n  return $self->{'strand'};\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n Returns : a string either 'dna','rna','protein'.\n Args    : none\n\n\n\nsub alphabet {\n  my %valid_type = map {$_, 1} qw( dna rna protein );\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $value = 'dna' if $value =~ /dna/i;\n    $value = 'rna' if $value =~ /rna/i;\n    unless ( $valid_type{$value} ) {\n      $self->warn(\"Molecular type '$value' is not a valid type\");\n    }\n    $self->{'alphabet'} = $value;\n  }\n  return $self->{'alphabet'};\n}\n\n=head2 coordinate_start\n\n  Title   : coordinate_start\n  Usage   : $coordstartlabel=$obj->coordinate_start()\n          : $coordstartlabel=$obj->coordinate_start($label)\n  Function: returns and optionally sets the first label of the coordinate\n            system used\n            For some objects only labels inside the object or in frame (for\n            Translation objects) will be allowed to get set as coordinate start\n\n  Returns : label. It returns 0 if label not found.\n  Errorcode -1 \n  Args    : an optional reference $label that is position 1\n\n\n\nsub coordinate_start {\n  my ($self,$label) = @_;\n  if ($label) {\n    if ($self->valid($label)) {\n      $self->{'coordinate_start'} = $label;\n    } else {\n      $self->warn(\"The label you are trying to set as coordinate_start is not valid for this object\");\n    }\n  }\n  my $coord_start = $self->{'coordinate_start'};\n  if ($coord_start) { \n    return $coord_start;\n  } else {\n    return $self->start();\n  }\n}\n\n=head2 label\n\n  Title   : label\n  Usage   : $seq->label($position)\n          : $seq->label($position,$firstlabel)\n  Examples: $nextlabel=$seq->label(2,$label) -> retrieves the following label\n          : $prevlabel=$seq->label(-1,$label) -> retrieves the preceding label\n\n  Function: returns the label of the nucleotide at $position from current\n            coordinate start\n  Returns : a label. It returns 0 if label not found.\n  Errorcode -1 \n  Args    : a position, \n            an optional reference $firstlabel that is to be used as position 1\n            an optional strand (1 or -1) argument \n             if strand argument is not given, it will default to the object\n             argument. This argument is useful when a call is issued from a child\n             of a parent object containing the subseq method\n\n\n\nsub label {\n  my ($self,$position,$firstlabel,$strand)=@_;\n  my $label;\n  unless (defined ($firstlabel)) {\n    $firstlabel=$self->coordinate_start;\n  }\n  unless ($position) {  # if position = 0 complain ?\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  unless (defined ($strand)) { # if optional [strand] argument not given\n    $strand=$self->strand;\n  }\n  if ($strand == 1) {\n    if ($position > 0) {\n      $label=$self->{'seq'}->down_get_label_at_pos($position,$firstlabel)\n    } else { # if < 0\n      $label=$self->{'seq'}->up_get_label_at_pos(1 - $position,$firstlabel)\n    }\n  } else {\n    if ($position > 0) {\n      $label=$self->{'seq'}->up_get_label_at_pos($position,$firstlabel)\n    } else { # if < 0\n      $label=$self->{'seq'}->down_get_label_at_pos(1 - $position,$firstlabel)\n    }\n  }\n  return $label;\n}\n\n\n=head2 position\n\n  Title   : position\n  Usage   : $seq->position($label)\n          : $seq->position($label,$firstlabel)\n  Function: returns the position of nucleotide at $label\n  Returns : the position of the label from current coordinate start\n  Errorcode 0\n  Args    : a label pointing to a certain nucleotide (e.g. start of exon)\n            an optional \"firstlabel\" as reference to count from\n            an optional strand (1 or -1) argument \n             if strand argument is not given, it will default to the object\n             argument. This argument is useful when a call is issued from a child\n             of a parent object containing the subseq method\n\n\n\nsub position {\n  my ($self,$label,$firstlabel,$strand)=@_;\n  unless (defined ($strand)) { # if optional [strand] argument not given\n    $strand=$self->strand;\n  }\n  unless (defined ($firstlabel)) {\n    $firstlabel=$self->coordinate_start;\n  }\n  unless ($self->valid($label)) {\n    $self->warn(\"label not valid\");\n    return (0);\n  }\n  if ($firstlabel == $label) {\n    return (1);\n  }\n  my ($coordpos,$position0,$position);\n  $position0=$self->{'seq'}->down_get_pos_of_label($label);\n  $coordpos=$self->{'seq'}->down_get_pos_of_label($firstlabel);\n  $position=$position0-$coordpos+1;\n  if ($position <= 0) {\n    $position--;\n  }\n  if ($strand == -1) {\n    #print \"\\n----------DEBUGSEQPOS label $label firstlabel $firstlabel strand $strand: position=\",1-$position;\n    return (1-$position);\n  } else {\n    #print \"\\n----------DEBUGSEQPOS label $label firstlabel $firstlabel strand $strand: position=\",$position;\n    return ($position);\n  }\n}\n\n=head2 follows\n\n  Title   : follows\n  Usage   : $seq->follows($firstlabel,$secondlabel)\n          : $seq->follows($firstlabel,$secondlabel,$strand)\n  Function: checks if SECONDlabel follows FIRSTlabel, undependent of the strand\n            i.e. it checks downstream for forward strand and\n            upstream for reverse strand\n  Returns : 1 or 0\n  Errorcode -1\n  Args    : two labels\n            an optional strand (1 or -1) argument \n             if strand argument is not given, it will default to the object\n             argument. This argument is useful when a call is issued from a child\n             of a parent object containing the subseq method\n\n\n#'\n# wraparound to is_downstream and is_upstream that chooses the correct one\n# depending on the strand\nsub follows {\n  my ($self,$firstlabel,$secondlabel,$strand)=@_;\n  unless (defined ($strand)) { # if optional [strand] argument not given\n    $strand=$self->strand;\n  }\n  if ($strand == 1) {\n    return ($self->{'seq'}->is_downstream($firstlabel,$secondlabel));\n  } else {\n    return ($self->{'seq'}->is_upstream($firstlabel,$secondlabel));\n  }\n}\n#\n#=head2 translate\n#\n# Title   : translate\n# Usage   : $protein_seq = $obj->translate\n# Function: Provides the translation of the DNA sequence\n#\t    using full IUPAC ambiguities in DNA/RNA and amino acid codes.\n#\n#\t    The resulting translation is identical to EMBL/TREMBL database \n#\t    translations.\n#\n# Returns : a string\n# Args    : character for terminator (optional) defaults to '*'\n#\t    character for unknown amino acid (optional) defaults to 'X'\n#\t    frame (optional) valid values 0, 1, 3, defaults to 0\n#\t    codon table id (optional) defaults to 1\n#\n#=cut\n#\n#sub translate {\n#  my ($self) = shift;\n#  return ($self->translate_string($self->seq,@_));\n#}\n#\n#=head2 translate_string\n#\n# Title   : translate_string\n# Usage   : $protein_seq = $obj->translate_string(\"attcgtgttgatcgatta\");\n# Function: Like translate, but can be used to translate subsequences after\n#\t    having retrieved them as string.\n# Args    : 1st argument is a string. Optional following arguments: like in\n#\t    the translate method\n#\n#=cut\n#\n#\n#sub translate_string {\n#  my($self) = shift;\n#  my($seq) = shift;\n#  my($stop, $unknown, $frame, $tableid) = @_;\n#  my($i, $len, $output) = (0,0,'');\n#  my($codon)   = \"\";\n#  my $aa;\n#\n#\n#  ## User can pass in symbol for stop and unknown codons\n#  unless(defined($stop) and $stop ne '')    { $stop = \"*\"; }\n#  unless(defined($unknown) and $unknown ne '') { $unknown = \"X\"; }\n#  unless(defined($frame) and $frame ne '') { $frame = 0; }\n#\n#  ## the codon table ID \n#  if ($self->translation_table) {\n#    $tableid = $self->translation_table;\n#  }\n#  unless(defined($tableid) and $tableid ne '')    { $tableid = 1; }\n#\n#  ##Error if monomer is \"Amino\"\n#  $self->warn(\"Can't translate an amino acid sequence.\") \n#      if (defined $self->alphabet && $self->alphabet eq 'protein');\n#\n#  ##Error if frame is not 0, 1 or 2\n#  $self->warn(\"Valid values for frame are 0, 1, 2, not [$frame].\")\n#      unless ($frame == 0 or $frame == 1 or $frame == 2);\n#\n#  #thows a warning if ID is invalid \n#  my $codonTable = Bio::Tools::CodonTable->new( -id => $tableid);\n#\n#  # deal with frame offset.\n#  if( $frame ) {\n#      $seq = substr ($seq,$frame);\n#  }\n#\n#  for $codon ( grep { CORE::length == 3 } split(/(.{3})/, $seq) ) {\n#      my $aa = $codonTable->translate($codon);\n#      if ($aa eq '*') {\n#\t    $output .= $stop;\n#      }\n#      elsif ($aa eq 'X') {\n#\t    $output .= $unknown;\n#      }\n#      else { \n#\t   $output .= $aa ;\n#      }   \n#  }\n#  #if( substr($output,-1,1) eq $stop ) {\n#  #    chop $output;\n#  #}\n#\n#  return ($output);\n#}\n\n=head2 gene\n\n Title   : gene\n Usage   : my $gene=$obj->gene;\n Function: Gets or sets the reference to the LiveSeq::Gene object.\n           Objects that are features of a LiveSeq Gene will have this\n           attribute set automatically.\n\n Returns : reference to an object of class Gene\n Note    : if Gene object is not set, this method will return 0;\n Args    : none or reference to object of class Bio::LiveSeq::Gene","label":"gene($self,$value)"},"children":[{"name":"$self","localvar":"my","containerName":"gene","kind":13,"line":1058,"definition":"my"},{"line":1058,"containerName":"gene","kind":13,"name":"$value"},{"containerName":"gene","kind":13,"name":"$value","line":1059},{"name":"$self","kind":13,"containerName":"gene","line":1060},{"line":1060,"name":"$value","containerName":"gene","kind":13},{"containerName":"gene","kind":13,"name":"$self","line":1062},{"kind":13,"containerName":"gene","name":"$self","line":1065}],"containerName":"main::","name":"gene","definition":"sub","detail":"($self,$value)"},{"definition":"sub","children":[{"line":1081,"name":"$self","containerName":"obj_valid","localvar":"my","kind":13,"definition":"my"},{"line":1082,"containerName":"obj_valid","kind":13,"name":"$self"},{"line":1082,"containerName":"obj_valid","kind":12,"name":"valid"},{"name":"$self","containerName":"obj_valid","kind":13,"line":1082},{"line":1082,"containerName":"obj_valid","kind":12,"name":"start"},{"containerName":"obj_valid","kind":13,"name":"$self","line":1082},{"line":1082,"containerName":"obj_valid","kind":12,"name":"valid"},{"containerName":"obj_valid","kind":13,"name":"$self","line":1082},{"line":1082,"name":"end","containerName":"obj_valid","kind":12}],"containerName":"main::","name":"obj_valid","line":1080,"kind":12,"range":{"start":{"line":1080,"character":0},"end":{"character":9999,"line":1086}}},{"detail":"($self,$value)","definition":"sub","name":"name","containerName":"main::","children":[{"line":1101,"kind":13,"localvar":"my","containerName":"name","name":"$self","definition":"my"},{"name":"$value","containerName":"name","kind":13,"line":1101},{"line":1102,"name":"$value","kind":13,"containerName":"name"},{"name":"$self","containerName":"name","kind":13,"line":1103},{"kind":13,"containerName":"name","name":"$value","line":1103},{"name":"$self","kind":13,"containerName":"name","line":1105},{"line":1108,"containerName":"name","kind":13,"name":"$self"}],"signature":{"label":"name($self,$value)","documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n\n# NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode) = @_;\n  if (defined $unsecuremode && $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    unless ($start) {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length;\n      }\n    } else {\n      unless ($length) {\n\t$end=$self->end;\n      }\n    }\n  } else {\n    if ($start) {\n      unless ($self->{'seq'}->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tunless ($self->{'seq'}->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n\tundef $length;\n      }\n    }\n  }\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,$length,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,$length,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n         : $substring = $obj->subseq(10,undef,4);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal.\n\n           Allows for negative numbers $obj->subseq(-10,-1). By\n           definition, there is no 0!\n                       -5  -1 1   5\n                gctagcgcccaac atggctcgctg\n\n           This allows to retrieve sequences upstream from given position.\n\n           The precedence is from left to right: if END is given LENGTH is\n           ignored.\n\n Examples: $obj->subseq(-10,undef,10) returns 10 elements before position 1\n           $obj->subseq(4,8) returns elements from the 4th to the 8th, inclusive\n\n Returns : a string\n Errorcode: -1\n Args    : start,  integer, defaults to start of the sequence\n           end,    integer, '' or undef, defaults to end of the sequence\n           length, integer, '' or undef\n           an optional strand (1 or -1) 4th argument \n            if strand argument is not given, it will default to the object\n            argment. This argument is useful when a call is issued from a child\n            of a parent object containing the subseq method\n\n\n#'\n# check the fact about reverse strand!\n# is it feasible? Is it correct? Should we do it? How about exons? Does it\n# work when you ask subseq of an exon?\n# eliminated now (Mon night)\nsub subseq {\n  ##my ($self,$pos1,$pos2,$length,$strand) = @_;\n  my ($self,$pos1,$pos2,$length,$strand) = @_;\n  ##unless (defined ($strand)) { # if optional [strand] argument not given\n  ##  $strand=$self->strand;\n  ##}\n  $strand=$self->strand;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  unless (defined ($pos1)) {\n    #print \"\\n##### DEBUG pos1 not defined\\n\";\n    $startlabel=$self->start;\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos2))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos2))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!)\"; return (-1);\n    ##  }\n    ##}\n    $startlabel=$self->label($pos1);\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  }\n  unless (defined ($pos2)) {\n    #print \"\\n##### pos2 not defined\\n\";\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos1))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos1))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!\"); return (-1);\n    ##  }\n    ##}\n    $endlabel=$self->label($pos2);\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  }\n  #print \"\\n    ####DEBUG: start $startlabel end $endlabel length $length strand $strand\\n\";\n\n  if ($strand == 1) {\n    $str = $self->{'seq'}->down_chain2string($startlabel,$length,$endlabel);\n  } else { # reverse strand\n    $str = $self->{'seq'}->up_chain2string($startlabel,$length,$endlabel);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n  }\n  return $str;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $seq->length();\n  Function: returns the number of nucleotides (or the number of aminoacids)\n            in the entire sequence\n  Returns : an integer\n  Errorcode -1\n  Args    : none\n\n\nsub length {\n  my $self=shift;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  if ($strand == 1) {\n    return $self->{'seq'}->down_subchain_length($start,$end);\n  } else {\n    return $self->{'seq'}->up_subchain_length($start,$end);\n  }\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, alias the common name of the object\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information.\n\n See also: accession_number\n Returns : a string\n Args    : none\n\n\nsub display_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'display_id'} = $value;\n  }\n  return $self->{'display_id'};\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number.\n           Notice that primary_id() provides the unique id for the\n           implemetation, allowing multiple objects to have the same accession\n           number in a particular implementation.\n\n           For objects with no accession_number this method returns \"unknown\".\n Returns : a string\n Args    : none\n\n\nsub accession_number {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'accession_number'} = $value;\n  }\n  unless (exists $self->{'accession_number'}) {\n    return \"unknown\";\n  } else {\n    return $self->{'accession_number'};\n  }\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their own\n           object ids in a way the implementation can control. Clients can\n           expect one id to map to one object.\n\n           For sequences with no primary_id, this method returns\n           a stringified memory location.\n\n Returns : A string\n Args    : None\n\n\n\nsub primary_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'primary_id'} = $value;\n  }\n  unless (exists $self->{'primary_id'}) {\n    return \"$self\";\n  } else {\n    return $self->{'primary_id'};\n  }\n}\n\n=head2 change\n\n Title   : change\n Usage   : $substring = $obj->change('AA', 10);\n Function: changes, modifies, mutates the LiveSequence\n Examples:\n        $obj->change('',   10);      delete nucleotide #10     \n        $obj->change('',   10, 2);   delete two nucleotides starting from #10\n        $obj->change('G',  10);      change nuc #10 to 'G'\n        $obj->change('GA', 10, 4);   replace #10 and 3 following with 'GA'\n        $obj->change('GA', 10, 2));  is same as $obj->change('GA',  10);\n        $obj->change('GA', 10, 0 );  insert 'GA' before nucleotide at #10\n        $obj->change('GA', 10, 1);   GA inserted before #10, #10 deleted\n        $obj->change('GATC', 10, 2); GATC inserted before #10, #10&#11 deleted\n        $obj->change('GATC', 10, 6); GATC inserted before #10, #10-#15 deleted\n\n\n Returns : a string of deleted bases (if any) or 1 (everything OK)\n Errorcode: -1\n Args    : seq,    string, or '' ('' = undef = 0 = deletion)\n           start,  integer\n           length, integer (optional)\n\n\nsub change {\n  &positionchange;\n}\n\n=head2 positionchange\n\n Title   : positionchange\n Function: Exactly like change. I.e. change() defaults to positionchange()\n\n\nsub positionchange {\n  my ($self,$newseq,$position,$length)=@_;\n  unless ($position) {\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  my $label=$self->label($position);\n  unless ($label > 0) { # label not found or error\n    $self->warn(\"No valid label found at that position!\");\n    return (-1);\n  }\n  return ($self->labelchange($newseq,$label,$length));\n}\n\n=head2 labelchange\n\n Title   : labelchange\n Function: Exactly like change but uses a /label/ instead than a position\n           as second argument. This allows for multiple changes in a LiveSeq\n           without the burden of recomputing positions. I.e. for a multiple\n           change in two different points of the LiveSeq, the approach would\n           be the following: fetch the correct labels out of the two different\n           positions (method: label($position)) and then use the labelchange()\n           method to modify the sequence using those labels instead than\n           relying on the positions (that would have modified after the\n           first change).\n\n\nsub labelchange {\n  my ($self,$newseq,$label,$length)=@_;\n  unless ($self->valid($label)) {\n    if ($self->{'seq'}->valid($label)) {\n       #$self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change for the object asked but it's ok for DNAlevel change, reverting to that\");\n      shift @_;\n      return($self->{'seq'}->labelchange(@_));\n    } else {\n      $self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change\");\n      return (-1);\n    }\n  }\n  unless ($newseq) { # it means this is a simple deletion\n    if (defined($length)) {\n      unless ($length >= 0) {\n\t$self->warn(\"No sense having length < 0 in a deletion\");\n\treturn (-1);\n      }\n    } else {\n      $self->warn(\"Length not defined for deletion!\");\n      return (-1);\n    }\n    return $self->_delete($label,$length);\n  }\n  my $newseqlength=CORE::length($newseq);\n  if (defined($length)) {\n    unless ($length >= 0) {\n      $self->warn(\"No sense having length < 0 in a change()\");\n      return (-1);\n    }\n  } else {\n    $length=$newseqlength; # defaults to pointmutation(s)\n  }\n  if ($length == 0) { # it means this is a simple insertion, length def&==0\n    my ($insertbegin,$insertend)=$self->_praeinsert($label,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n  if ($newseqlength == $length) { # it means this is simple pointmutation(s)\n    return $self->_mutate($label,$newseq,$length);\n  }\n  # if we arrived here then change is complex mixture\n  my $strand=$self->strand();\n  my $afterendlabel=$self->label($length+1,$label,$strand); # get the label at $length+1 positions after $label\n  unless ($afterendlabel > 0) { # label not found or error\n    $self->warn(\"No valid afterendlabel found for executing the complex mutation!\");\n    return (-1);\n  }\n  my $deleted=$self->_delete($label,$length); # first delete length nucs\n  if ($deleted == -1) { # if errors\n    return (-1);\n  } else { # then insert the newsequence\n    my ($insertbegin,$insertend)=$self->_praeinsert($afterendlabel,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n}\n\n# internal methods for change()\n\n# arguments: label for beginning of deletion, new sequence to insert\n# returns: labels of beginning and end of the inserted sequence\n# errorcode: -1\nsub _praeinsert {\n  my ($self,$label,$newseq)=@_;\n  my ($insertbegin,$insertend);\n  my $strand=$self->strand();\n  if ($strand == 1) {\n    ($insertbegin,$insertend)=($self->{'seq'}->praeinsert_string($newseq,$label));\n  } else { # since it's reverse strand and we insert in forward direction....\n    $newseq=reverse($newseq);\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n    ($insertend,$insertbegin)=($self->{'seq'}->postinsert_string($newseq,$label));\n  }\n  if (($insertbegin==0)||($insertend==0)) {\n    $self->warn(\"Some error occurred while inserting!\");\n    return (-1);\n  } else {\n    return ($insertbegin,$insertend);\n  }\n}\n\n# arguments: label for beginning of deletion, length of deletion\n# returns: string of deleted bases\n# errorcode: -1\nsub _delete {\n  my ($self,$label,$length)=@_;\n  my $strand=$self->strand();\n  my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n  unless ($endlabel > 0) { # label not found or error\n    $self->warn(\"No valid endlabel found for executing the deletion!\");\n    return (-1);\n  }\n  # this is important in Transcript to fix exon structure\n  $self->_deletecheck($label,$endlabel);\n  my $deletedseq;\n  if ($strand == 1) {\n    $deletedseq=$self->{'seq'}->splice_chain($label,undef,$endlabel);\n  } else {\n    $deletedseq=$self->{'seq'}->splice_chain($endlabel,undef,$label);\n    $deletedseq=reverse($deletedseq); # because we are on reverse strand and we cut anyway\n                         # in forward direction\n    $deletedseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  return ($deletedseq);\n}\n\n# empty function, overridden in Transcript, not useful here\nsub _deletecheck {\n}\n\n# arguments: label for beginning of mutation, newsequence, number of mutations\n# returns: 1 all OK\n# errorcode: -1\nsub _mutate {\n  my ($self,$label,$newseq,$length)=@_; # length is equal to length(newseq)\n  my ($i,$base,$nextlabel);\n  my @labels; # array of labels\n  my $strand=$self->strand();\n  if ($length == 1) { # special cases first\n    @labels=($label);\n  } else {\n    my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n    unless ($endlabel > 0) { # label not found or error\n      $self->warn(\"No valid endlabel found for executing the mutation!\");\n      return (-1);\n    }\n    if ($length == 2) { # another special case\n      @labels=($label,$endlabel);\n    } else { # more than 3 bases changed\n      # this wouldn't work for Transcript\n      #my $labelsarrayref;\n      #if ($strand == 1) {\n\t#$labelsarrayref=$self->{'seq'}->down_labels($label,$endlabel);\n      #} else {\n\t#$labelsarrayref=$self->{'seq'}->up_labels($label,$endlabel);\n      #}\n      #@labels=@{$labelsarrayref};\n      #if ($length != scalar(@labels)) { # not enough labels returned\n\t#$self->warn(\"Not enough valid labels found for executing the mutation!\");\n\t#return (-1);\n      #}\n\n      # this should be more general\n      @labels=($label); # put the first one\n      while ($label != $endlabel) {\n\t$nextlabel=$self->label(2,$label,$strand); # retrieve the next label\n\tpush (@labels,$nextlabel);\n\t$label=$nextlabel; # move on reference\n      }\n    }\n  }\n  if ($strand == -1) { # only for reverse strand\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  my $errorcheck; # if not equal to $length after summing for all changes, error did occurr\n  $i = 0;\n  foreach $base (split(//,$newseq)) {\n    $errorcheck += $self->{'seq'}->set_value_at_label($base,$labels[$i]);\n    $i++;\n  }\n  if ($errorcheck != $length) {\n    $self->warn(\"Some error occurred while mutating!\");\n    return (-1);\n  } else {\n    return (1);\n  }\n}\n\n=head2 valid\n\n  Title   : valid\n  Usage   : $boolean = $obj->valid($label)\n  Function: tests if a label exists inside the object\n  Returns : boolean\n  Args    : label\n\n\n# argument: label\n# returns: 1 YES 0 NO\nsub valid {\n  my ($self,$label)=@_;\n  my $checkme;\n  my @labels=$self->all_labels;\n  foreach $checkme (@labels) {\n    if ($label == $checkme) {\n      return (1); # found\n    }\n  }\n  return (0); # not found\n}\n\n\n=head2 start\n\n  Title   : start\n  Usage   : $startlabel=$obj->start()\n  Function: returns the label of the first nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub start {\n  my ($self) = @_;\n  return $self->{'start'}; # common for all classes BUT DNA (which redefines it) and Transcript (that takes the information from the Exons)\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $endlabel=$obj->end()\n  Function: returns the label of the last nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub end {\n  my ($self) = @_;\n  return $self->{'end'};\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand=$obj->strand()\n            $obj->strand($strand)\n  Function: gets or sets strand information, being 1 or -1 (forward or reverse)\n  Returns : -1 or 1\n  Args    : none OR -1 or 1\n\n\nsub strand {\n  my ($self,$strand) = @_;\n  if ($strand) {\n    if (($strand != 1)&&($strand != -1)) {\n      $self->warn(\"strand information not changed because strand identifier not valid\");\n    } else {\n      $self->{'strand'} = $strand;\n    }\n  }\n  return $self->{'strand'};\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n Returns : a string either 'dna','rna','protein'.\n Args    : none\n\n\n\nsub alphabet {\n  my %valid_type = map {$_, 1} qw( dna rna protein );\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $value = 'dna' if $value =~ /dna/i;\n    $value = 'rna' if $value =~ /rna/i;\n    unless ( $valid_type{$value} ) {\n      $self->warn(\"Molecular type '$value' is not a valid type\");\n    }\n    $self->{'alphabet'} = $value;\n  }\n  return $self->{'alphabet'};\n}\n\n=head2 coordinate_start\n\n  Title   : coordinate_start\n  Usage   : $coordstartlabel=$obj->coordinate_start()\n          : $coordstartlabel=$obj->coordinate_start($label)\n  Function: returns and optionally sets the first label of the coordinate\n            system used\n            For some objects only labels inside the object or in frame (for\n            Translation objects) will be allowed to get set as coordinate start\n\n  Returns : label. It returns 0 if label not found.\n  Errorcode -1 \n  Args    : an optional reference $label that is position 1\n\n\n\nsub coordinate_start {\n  my ($self,$label) = @_;\n  if ($label) {\n    if ($self->valid($label)) {\n      $self->{'coordinate_start'} = $label;\n    } else {\n      $self->warn(\"The label you are trying to set as coordinate_start is not valid for this object\");\n    }\n  }\n  my $coord_start = $self->{'coordinate_start'};\n  if ($coord_start) { \n    return $coord_start;\n  } else {\n    return $self->start();\n  }\n}\n\n=head2 label\n\n  Title   : label\n  Usage   : $seq->label($position)\n          : $seq->label($position,$firstlabel)\n  Examples: $nextlabel=$seq->label(2,$label) -> retrieves the following label\n          : $prevlabel=$seq->label(-1,$label) -> retrieves the preceding label\n\n  Function: returns the label of the nucleotide at $position from current\n            coordinate start\n  Returns : a label. It returns 0 if label not found.\n  Errorcode -1 \n  Args    : a position, \n            an optional reference $firstlabel that is to be used as position 1\n            an optional strand (1 or -1) argument \n             if strand argument is not given, it will default to the object\n             argument. This argument is useful when a call is issued from a child\n             of a parent object containing the subseq method\n\n\n\nsub label {\n  my ($self,$position,$firstlabel,$strand)=@_;\n  my $label;\n  unless (defined ($firstlabel)) {\n    $firstlabel=$self->coordinate_start;\n  }\n  unless ($position) {  # if position = 0 complain ?\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  unless (defined ($strand)) { # if optional [strand] argument not given\n    $strand=$self->strand;\n  }\n  if ($strand == 1) {\n    if ($position > 0) {\n      $label=$self->{'seq'}->down_get_label_at_pos($position,$firstlabel)\n    } else { # if < 0\n      $label=$self->{'seq'}->up_get_label_at_pos(1 - $position,$firstlabel)\n    }\n  } else {\n    if ($position > 0) {\n      $label=$self->{'seq'}->up_get_label_at_pos($position,$firstlabel)\n    } else { # if < 0\n      $label=$self->{'seq'}->down_get_label_at_pos(1 - $position,$firstlabel)\n    }\n  }\n  return $label;\n}\n\n\n=head2 position\n\n  Title   : position\n  Usage   : $seq->position($label)\n          : $seq->position($label,$firstlabel)\n  Function: returns the position of nucleotide at $label\n  Returns : the position of the label from current coordinate start\n  Errorcode 0\n  Args    : a label pointing to a certain nucleotide (e.g. start of exon)\n            an optional \"firstlabel\" as reference to count from\n            an optional strand (1 or -1) argument \n             if strand argument is not given, it will default to the object\n             argument. This argument is useful when a call is issued from a child\n             of a parent object containing the subseq method\n\n\n\nsub position {\n  my ($self,$label,$firstlabel,$strand)=@_;\n  unless (defined ($strand)) { # if optional [strand] argument not given\n    $strand=$self->strand;\n  }\n  unless (defined ($firstlabel)) {\n    $firstlabel=$self->coordinate_start;\n  }\n  unless ($self->valid($label)) {\n    $self->warn(\"label not valid\");\n    return (0);\n  }\n  if ($firstlabel == $label) {\n    return (1);\n  }\n  my ($coordpos,$position0,$position);\n  $position0=$self->{'seq'}->down_get_pos_of_label($label);\n  $coordpos=$self->{'seq'}->down_get_pos_of_label($firstlabel);\n  $position=$position0-$coordpos+1;\n  if ($position <= 0) {\n    $position--;\n  }\n  if ($strand == -1) {\n    #print \"\\n----------DEBUGSEQPOS label $label firstlabel $firstlabel strand $strand: position=\",1-$position;\n    return (1-$position);\n  } else {\n    #print \"\\n----------DEBUGSEQPOS label $label firstlabel $firstlabel strand $strand: position=\",$position;\n    return ($position);\n  }\n}\n\n=head2 follows\n\n  Title   : follows\n  Usage   : $seq->follows($firstlabel,$secondlabel)\n          : $seq->follows($firstlabel,$secondlabel,$strand)\n  Function: checks if SECONDlabel follows FIRSTlabel, undependent of the strand\n            i.e. it checks downstream for forward strand and\n            upstream for reverse strand\n  Returns : 1 or 0\n  Errorcode -1\n  Args    : two labels\n            an optional strand (1 or -1) argument \n             if strand argument is not given, it will default to the object\n             argument. This argument is useful when a call is issued from a child\n             of a parent object containing the subseq method\n\n\n#'\n# wraparound to is_downstream and is_upstream that chooses the correct one\n# depending on the strand\nsub follows {\n  my ($self,$firstlabel,$secondlabel,$strand)=@_;\n  unless (defined ($strand)) { # if optional [strand] argument not given\n    $strand=$self->strand;\n  }\n  if ($strand == 1) {\n    return ($self->{'seq'}->is_downstream($firstlabel,$secondlabel));\n  } else {\n    return ($self->{'seq'}->is_upstream($firstlabel,$secondlabel));\n  }\n}\n#\n#=head2 translate\n#\n# Title   : translate\n# Usage   : $protein_seq = $obj->translate\n# Function: Provides the translation of the DNA sequence\n#\t    using full IUPAC ambiguities in DNA/RNA and amino acid codes.\n#\n#\t    The resulting translation is identical to EMBL/TREMBL database \n#\t    translations.\n#\n# Returns : a string\n# Args    : character for terminator (optional) defaults to '*'\n#\t    character for unknown amino acid (optional) defaults to 'X'\n#\t    frame (optional) valid values 0, 1, 3, defaults to 0\n#\t    codon table id (optional) defaults to 1\n#\n#=cut\n#\n#sub translate {\n#  my ($self) = shift;\n#  return ($self->translate_string($self->seq,@_));\n#}\n#\n#=head2 translate_string\n#\n# Title   : translate_string\n# Usage   : $protein_seq = $obj->translate_string(\"attcgtgttgatcgatta\");\n# Function: Like translate, but can be used to translate subsequences after\n#\t    having retrieved them as string.\n# Args    : 1st argument is a string. Optional following arguments: like in\n#\t    the translate method\n#\n#=cut\n#\n#\n#sub translate_string {\n#  my($self) = shift;\n#  my($seq) = shift;\n#  my($stop, $unknown, $frame, $tableid) = @_;\n#  my($i, $len, $output) = (0,0,'');\n#  my($codon)   = \"\";\n#  my $aa;\n#\n#\n#  ## User can pass in symbol for stop and unknown codons\n#  unless(defined($stop) and $stop ne '')    { $stop = \"*\"; }\n#  unless(defined($unknown) and $unknown ne '') { $unknown = \"X\"; }\n#  unless(defined($frame) and $frame ne '') { $frame = 0; }\n#\n#  ## the codon table ID \n#  if ($self->translation_table) {\n#    $tableid = $self->translation_table;\n#  }\n#  unless(defined($tableid) and $tableid ne '')    { $tableid = 1; }\n#\n#  ##Error if monomer is \"Amino\"\n#  $self->warn(\"Can't translate an amino acid sequence.\") \n#      if (defined $self->alphabet && $self->alphabet eq 'protein');\n#\n#  ##Error if frame is not 0, 1 or 2\n#  $self->warn(\"Valid values for frame are 0, 1, 2, not [$frame].\")\n#      unless ($frame == 0 or $frame == 1 or $frame == 2);\n#\n#  #thows a warning if ID is invalid \n#  my $codonTable = Bio::Tools::CodonTable->new( -id => $tableid);\n#\n#  # deal with frame offset.\n#  if( $frame ) {\n#      $seq = substr ($seq,$frame);\n#  }\n#\n#  for $codon ( grep { CORE::length == 3 } split(/(.{3})/, $seq) ) {\n#      my $aa = $codonTable->translate($codon);\n#      if ($aa eq '*') {\n#\t    $output .= $stop;\n#      }\n#      elsif ($aa eq 'X') {\n#\t    $output .= $unknown;\n#      }\n#      else { \n#\t   $output .= $aa ;\n#      }   \n#  }\n#  #if( substr($output,-1,1) eq $stop ) {\n#  #    chop $output;\n#  #}\n#\n#  return ($output);\n#}\n\n=head2 gene\n\n Title   : gene\n Usage   : my $gene=$obj->gene;\n Function: Gets or sets the reference to the LiveSeq::Gene object.\n           Objects that are features of a LiveSeq Gene will have this\n           attribute set automatically.\n\n Returns : reference to an object of class Gene\n Note    : if Gene object is not set, this method will return 0;\n Args    : none or reference to object of class Bio::LiveSeq::Gene\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'gene'} = $value;\n  }\n  unless (exists $self->{'gene'}) {\n    return (0);\n  } else {\n    return $self->{'gene'};\n  }\n}\n\n=head2 obj_valid\n\n Title   : obj_valid\n Usage   : if ($obj->obj_valid) {do something;}\n Function: Checks if start and end labels are still valid for the ojbect,\n           i.e. tests if the LiveSeq object is still valid\n Returns : boolean\n Args    : none\n\n\nsub obj_valid {\n  my $self=shift;\n  unless (($self->{'seq'}->valid($self->start()))&&($self->{'seq'}->valid($self->end()))) {\n    return (0);\n  }\n  return (1);\n}\n\n=head2 name\n\n Title   : name\n Usage   : $name = $obj->name;\n         : $name = $obj->name(\"ABCD\");\n Function: Returns or sets the name of the object.\n           If there is no name, it will return \"unknown\";\n Returns : A string\n Args    : None","parameters":[{"label":"$self"},{"label":"$value"}]},"kind":12,"range":{"start":{"line":1100,"character":0},"end":{"character":9999,"line":1110}},"line":1100},{"definition":"sub","detail":"($self,$value)","children":[{"line":1125,"name":"$self","localvar":"my","containerName":"desc","kind":13,"definition":"my"},{"kind":13,"containerName":"desc","name":"$value","line":1125},{"kind":13,"containerName":"desc","name":"$value","line":1126},{"containerName":"desc","kind":13,"name":"$self","line":1127},{"name":"$value","kind":13,"containerName":"desc","line":1127},{"kind":13,"containerName":"desc","name":"$self","line":1129},{"kind":13,"containerName":"desc","name":"$self","line":1132}],"name":"desc","containerName":"main::","signature":{"label":"desc($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n\n# NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode) = @_;\n  if (defined $unsecuremode && $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    unless ($start) {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length;\n      }\n    } else {\n      unless ($length) {\n\t$end=$self->end;\n      }\n    }\n  } else {\n    if ($start) {\n      unless ($self->{'seq'}->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tunless ($self->{'seq'}->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n\tundef $length;\n      }\n    }\n  }\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,$length,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,$length,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n         : $substring = $obj->subseq(10,undef,4);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal.\n\n           Allows for negative numbers $obj->subseq(-10,-1). By\n           definition, there is no 0!\n                       -5  -1 1   5\n                gctagcgcccaac atggctcgctg\n\n           This allows to retrieve sequences upstream from given position.\n\n           The precedence is from left to right: if END is given LENGTH is\n           ignored.\n\n Examples: $obj->subseq(-10,undef,10) returns 10 elements before position 1\n           $obj->subseq(4,8) returns elements from the 4th to the 8th, inclusive\n\n Returns : a string\n Errorcode: -1\n Args    : start,  integer, defaults to start of the sequence\n           end,    integer, '' or undef, defaults to end of the sequence\n           length, integer, '' or undef\n           an optional strand (1 or -1) 4th argument \n            if strand argument is not given, it will default to the object\n            argment. This argument is useful when a call is issued from a child\n            of a parent object containing the subseq method\n\n\n#'\n# check the fact about reverse strand!\n# is it feasible? Is it correct? Should we do it? How about exons? Does it\n# work when you ask subseq of an exon?\n# eliminated now (Mon night)\nsub subseq {\n  ##my ($self,$pos1,$pos2,$length,$strand) = @_;\n  my ($self,$pos1,$pos2,$length,$strand) = @_;\n  ##unless (defined ($strand)) { # if optional [strand] argument not given\n  ##  $strand=$self->strand;\n  ##}\n  $strand=$self->strand;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  unless (defined ($pos1)) {\n    #print \"\\n##### DEBUG pos1 not defined\\n\";\n    $startlabel=$self->start;\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos2))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos2))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!)\"; return (-1);\n    ##  }\n    ##}\n    $startlabel=$self->label($pos1);\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  }\n  unless (defined ($pos2)) {\n    #print \"\\n##### pos2 not defined\\n\";\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos1))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos1))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!\"); return (-1);\n    ##  }\n    ##}\n    $endlabel=$self->label($pos2);\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  }\n  #print \"\\n    ####DEBUG: start $startlabel end $endlabel length $length strand $strand\\n\";\n\n  if ($strand == 1) {\n    $str = $self->{'seq'}->down_chain2string($startlabel,$length,$endlabel);\n  } else { # reverse strand\n    $str = $self->{'seq'}->up_chain2string($startlabel,$length,$endlabel);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n  }\n  return $str;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $seq->length();\n  Function: returns the number of nucleotides (or the number of aminoacids)\n            in the entire sequence\n  Returns : an integer\n  Errorcode -1\n  Args    : none\n\n\nsub length {\n  my $self=shift;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  if ($strand == 1) {\n    return $self->{'seq'}->down_subchain_length($start,$end);\n  } else {\n    return $self->{'seq'}->up_subchain_length($start,$end);\n  }\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, alias the common name of the object\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information.\n\n See also: accession_number\n Returns : a string\n Args    : none\n\n\nsub display_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'display_id'} = $value;\n  }\n  return $self->{'display_id'};\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number.\n           Notice that primary_id() provides the unique id for the\n           implemetation, allowing multiple objects to have the same accession\n           number in a particular implementation.\n\n           For objects with no accession_number this method returns \"unknown\".\n Returns : a string\n Args    : none\n\n\nsub accession_number {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'accession_number'} = $value;\n  }\n  unless (exists $self->{'accession_number'}) {\n    return \"unknown\";\n  } else {\n    return $self->{'accession_number'};\n  }\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their own\n           object ids in a way the implementation can control. Clients can\n           expect one id to map to one object.\n\n           For sequences with no primary_id, this method returns\n           a stringified memory location.\n\n Returns : A string\n Args    : None\n\n\n\nsub primary_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'primary_id'} = $value;\n  }\n  unless (exists $self->{'primary_id'}) {\n    return \"$self\";\n  } else {\n    return $self->{'primary_id'};\n  }\n}\n\n=head2 change\n\n Title   : change\n Usage   : $substring = $obj->change('AA', 10);\n Function: changes, modifies, mutates the LiveSequence\n Examples:\n        $obj->change('',   10);      delete nucleotide #10     \n        $obj->change('',   10, 2);   delete two nucleotides starting from #10\n        $obj->change('G',  10);      change nuc #10 to 'G'\n        $obj->change('GA', 10, 4);   replace #10 and 3 following with 'GA'\n        $obj->change('GA', 10, 2));  is same as $obj->change('GA',  10);\n        $obj->change('GA', 10, 0 );  insert 'GA' before nucleotide at #10\n        $obj->change('GA', 10, 1);   GA inserted before #10, #10 deleted\n        $obj->change('GATC', 10, 2); GATC inserted before #10, #10&#11 deleted\n        $obj->change('GATC', 10, 6); GATC inserted before #10, #10-#15 deleted\n\n\n Returns : a string of deleted bases (if any) or 1 (everything OK)\n Errorcode: -1\n Args    : seq,    string, or '' ('' = undef = 0 = deletion)\n           start,  integer\n           length, integer (optional)\n\n\nsub change {\n  &positionchange;\n}\n\n=head2 positionchange\n\n Title   : positionchange\n Function: Exactly like change. I.e. change() defaults to positionchange()\n\n\nsub positionchange {\n  my ($self,$newseq,$position,$length)=@_;\n  unless ($position) {\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  my $label=$self->label($position);\n  unless ($label > 0) { # label not found or error\n    $self->warn(\"No valid label found at that position!\");\n    return (-1);\n  }\n  return ($self->labelchange($newseq,$label,$length));\n}\n\n=head2 labelchange\n\n Title   : labelchange\n Function: Exactly like change but uses a /label/ instead than a position\n           as second argument. This allows for multiple changes in a LiveSeq\n           without the burden of recomputing positions. I.e. for a multiple\n           change in two different points of the LiveSeq, the approach would\n           be the following: fetch the correct labels out of the two different\n           positions (method: label($position)) and then use the labelchange()\n           method to modify the sequence using those labels instead than\n           relying on the positions (that would have modified after the\n           first change).\n\n\nsub labelchange {\n  my ($self,$newseq,$label,$length)=@_;\n  unless ($self->valid($label)) {\n    if ($self->{'seq'}->valid($label)) {\n       #$self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change for the object asked but it's ok for DNAlevel change, reverting to that\");\n      shift @_;\n      return($self->{'seq'}->labelchange(@_));\n    } else {\n      $self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change\");\n      return (-1);\n    }\n  }\n  unless ($newseq) { # it means this is a simple deletion\n    if (defined($length)) {\n      unless ($length >= 0) {\n\t$self->warn(\"No sense having length < 0 in a deletion\");\n\treturn (-1);\n      }\n    } else {\n      $self->warn(\"Length not defined for deletion!\");\n      return (-1);\n    }\n    return $self->_delete($label,$length);\n  }\n  my $newseqlength=CORE::length($newseq);\n  if (defined($length)) {\n    unless ($length >= 0) {\n      $self->warn(\"No sense having length < 0 in a change()\");\n      return (-1);\n    }\n  } else {\n    $length=$newseqlength; # defaults to pointmutation(s)\n  }\n  if ($length == 0) { # it means this is a simple insertion, length def&==0\n    my ($insertbegin,$insertend)=$self->_praeinsert($label,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n  if ($newseqlength == $length) { # it means this is simple pointmutation(s)\n    return $self->_mutate($label,$newseq,$length);\n  }\n  # if we arrived here then change is complex mixture\n  my $strand=$self->strand();\n  my $afterendlabel=$self->label($length+1,$label,$strand); # get the label at $length+1 positions after $label\n  unless ($afterendlabel > 0) { # label not found or error\n    $self->warn(\"No valid afterendlabel found for executing the complex mutation!\");\n    return (-1);\n  }\n  my $deleted=$self->_delete($label,$length); # first delete length nucs\n  if ($deleted == -1) { # if errors\n    return (-1);\n  } else { # then insert the newsequence\n    my ($insertbegin,$insertend)=$self->_praeinsert($afterendlabel,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n}\n\n# internal methods for change()\n\n# arguments: label for beginning of deletion, new sequence to insert\n# returns: labels of beginning and end of the inserted sequence\n# errorcode: -1\nsub _praeinsert {\n  my ($self,$label,$newseq)=@_;\n  my ($insertbegin,$insertend);\n  my $strand=$self->strand();\n  if ($strand == 1) {\n    ($insertbegin,$insertend)=($self->{'seq'}->praeinsert_string($newseq,$label));\n  } else { # since it's reverse strand and we insert in forward direction....\n    $newseq=reverse($newseq);\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n    ($insertend,$insertbegin)=($self->{'seq'}->postinsert_string($newseq,$label));\n  }\n  if (($insertbegin==0)||($insertend==0)) {\n    $self->warn(\"Some error occurred while inserting!\");\n    return (-1);\n  } else {\n    return ($insertbegin,$insertend);\n  }\n}\n\n# arguments: label for beginning of deletion, length of deletion\n# returns: string of deleted bases\n# errorcode: -1\nsub _delete {\n  my ($self,$label,$length)=@_;\n  my $strand=$self->strand();\n  my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n  unless ($endlabel > 0) { # label not found or error\n    $self->warn(\"No valid endlabel found for executing the deletion!\");\n    return (-1);\n  }\n  # this is important in Transcript to fix exon structure\n  $self->_deletecheck($label,$endlabel);\n  my $deletedseq;\n  if ($strand == 1) {\n    $deletedseq=$self->{'seq'}->splice_chain($label,undef,$endlabel);\n  } else {\n    $deletedseq=$self->{'seq'}->splice_chain($endlabel,undef,$label);\n    $deletedseq=reverse($deletedseq); # because we are on reverse strand and we cut anyway\n                         # in forward direction\n    $deletedseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  return ($deletedseq);\n}\n\n# empty function, overridden in Transcript, not useful here\nsub _deletecheck {\n}\n\n# arguments: label for beginning of mutation, newsequence, number of mutations\n# returns: 1 all OK\n# errorcode: -1\nsub _mutate {\n  my ($self,$label,$newseq,$length)=@_; # length is equal to length(newseq)\n  my ($i,$base,$nextlabel);\n  my @labels; # array of labels\n  my $strand=$self->strand();\n  if ($length == 1) { # special cases first\n    @labels=($label);\n  } else {\n    my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n    unless ($endlabel > 0) { # label not found or error\n      $self->warn(\"No valid endlabel found for executing the mutation!\");\n      return (-1);\n    }\n    if ($length == 2) { # another special case\n      @labels=($label,$endlabel);\n    } else { # more than 3 bases changed\n      # this wouldn't work for Transcript\n      #my $labelsarrayref;\n      #if ($strand == 1) {\n\t#$labelsarrayref=$self->{'seq'}->down_labels($label,$endlabel);\n      #} else {\n\t#$labelsarrayref=$self->{'seq'}->up_labels($label,$endlabel);\n      #}\n      #@labels=@{$labelsarrayref};\n      #if ($length != scalar(@labels)) { # not enough labels returned\n\t#$self->warn(\"Not enough valid labels found for executing the mutation!\");\n\t#return (-1);\n      #}\n\n      # this should be more general\n      @labels=($label); # put the first one\n      while ($label != $endlabel) {\n\t$nextlabel=$self->label(2,$label,$strand); # retrieve the next label\n\tpush (@labels,$nextlabel);\n\t$label=$nextlabel; # move on reference\n      }\n    }\n  }\n  if ($strand == -1) { # only for reverse strand\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  my $errorcheck; # if not equal to $length after summing for all changes, error did occurr\n  $i = 0;\n  foreach $base (split(//,$newseq)) {\n    $errorcheck += $self->{'seq'}->set_value_at_label($base,$labels[$i]);\n    $i++;\n  }\n  if ($errorcheck != $length) {\n    $self->warn(\"Some error occurred while mutating!\");\n    return (-1);\n  } else {\n    return (1);\n  }\n}\n\n=head2 valid\n\n  Title   : valid\n  Usage   : $boolean = $obj->valid($label)\n  Function: tests if a label exists inside the object\n  Returns : boolean\n  Args    : label\n\n\n# argument: label\n# returns: 1 YES 0 NO\nsub valid {\n  my ($self,$label)=@_;\n  my $checkme;\n  my @labels=$self->all_labels;\n  foreach $checkme (@labels) {\n    if ($label == $checkme) {\n      return (1); # found\n    }\n  }\n  return (0); # not found\n}\n\n\n=head2 start\n\n  Title   : start\n  Usage   : $startlabel=$obj->start()\n  Function: returns the label of the first nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub start {\n  my ($self) = @_;\n  return $self->{'start'}; # common for all classes BUT DNA (which redefines it) and Transcript (that takes the information from the Exons)\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $endlabel=$obj->end()\n  Function: returns the label of the last nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub end {\n  my ($self) = @_;\n  return $self->{'end'};\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand=$obj->strand()\n            $obj->strand($strand)\n  Function: gets or sets strand information, being 1 or -1 (forward or reverse)\n  Returns : -1 or 1\n  Args    : none OR -1 or 1\n\n\nsub strand {\n  my ($self,$strand) = @_;\n  if ($strand) {\n    if (($strand != 1)&&($strand != -1)) {\n      $self->warn(\"strand information not changed because strand identifier not valid\");\n    } else {\n      $self->{'strand'} = $strand;\n    }\n  }\n  return $self->{'strand'};\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n Returns : a string either 'dna','rna','protein'.\n Args    : none\n\n\n\nsub alphabet {\n  my %valid_type = map {$_, 1} qw( dna rna protein );\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $value = 'dna' if $value =~ /dna/i;\n    $value = 'rna' if $value =~ /rna/i;\n    unless ( $valid_type{$value} ) {\n      $self->warn(\"Molecular type '$value' is not a valid type\");\n    }\n    $self->{'alphabet'} = $value;\n  }\n  return $self->{'alphabet'};\n}\n\n=head2 coordinate_start\n\n  Title   : coordinate_start\n  Usage   : $coordstartlabel=$obj->coordinate_start()\n          : $coordstartlabel=$obj->coordinate_start($label)\n  Function: returns and optionally sets the first label of the coordinate\n            system used\n            For some objects only labels inside the object or in frame (for\n            Translation objects) will be allowed to get set as coordinate start\n\n  Returns : label. It returns 0 if label not found.\n  Errorcode -1 \n  Args    : an optional reference $label that is position 1\n\n\n\nsub coordinate_start {\n  my ($self,$label) = @_;\n  if ($label) {\n    if ($self->valid($label)) {\n      $self->{'coordinate_start'} = $label;\n    } else {\n      $self->warn(\"The label you are trying to set as coordinate_start is not valid for this object\");\n    }\n  }\n  my $coord_start = $self->{'coordinate_start'};\n  if ($coord_start) { \n    return $coord_start;\n  } else {\n    return $self->start();\n  }\n}\n\n=head2 label\n\n  Title   : label\n  Usage   : $seq->label($position)\n          : $seq->label($position,$firstlabel)\n  Examples: $nextlabel=$seq->label(2,$label) -> retrieves the following label\n          : $prevlabel=$seq->label(-1,$label) -> retrieves the preceding label\n\n  Function: returns the label of the nucleotide at $position from current\n            coordinate start\n  Returns : a label. It returns 0 if label not found.\n  Errorcode -1 \n  Args    : a position, \n            an optional reference $firstlabel that is to be used as position 1\n            an optional strand (1 or -1) argument \n             if strand argument is not given, it will default to the object\n             argument. This argument is useful when a call is issued from a child\n             of a parent object containing the subseq method\n\n\n\nsub label {\n  my ($self,$position,$firstlabel,$strand)=@_;\n  my $label;\n  unless (defined ($firstlabel)) {\n    $firstlabel=$self->coordinate_start;\n  }\n  unless ($position) {  # if position = 0 complain ?\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  unless (defined ($strand)) { # if optional [strand] argument not given\n    $strand=$self->strand;\n  }\n  if ($strand == 1) {\n    if ($position > 0) {\n      $label=$self->{'seq'}->down_get_label_at_pos($position,$firstlabel)\n    } else { # if < 0\n      $label=$self->{'seq'}->up_get_label_at_pos(1 - $position,$firstlabel)\n    }\n  } else {\n    if ($position > 0) {\n      $label=$self->{'seq'}->up_get_label_at_pos($position,$firstlabel)\n    } else { # if < 0\n      $label=$self->{'seq'}->down_get_label_at_pos(1 - $position,$firstlabel)\n    }\n  }\n  return $label;\n}\n\n\n=head2 position\n\n  Title   : position\n  Usage   : $seq->position($label)\n          : $seq->position($label,$firstlabel)\n  Function: returns the position of nucleotide at $label\n  Returns : the position of the label from current coordinate start\n  Errorcode 0\n  Args    : a label pointing to a certain nucleotide (e.g. start of exon)\n            an optional \"firstlabel\" as reference to count from\n            an optional strand (1 or -1) argument \n             if strand argument is not given, it will default to the object\n             argument. This argument is useful when a call is issued from a child\n             of a parent object containing the subseq method\n\n\n\nsub position {\n  my ($self,$label,$firstlabel,$strand)=@_;\n  unless (defined ($strand)) { # if optional [strand] argument not given\n    $strand=$self->strand;\n  }\n  unless (defined ($firstlabel)) {\n    $firstlabel=$self->coordinate_start;\n  }\n  unless ($self->valid($label)) {\n    $self->warn(\"label not valid\");\n    return (0);\n  }\n  if ($firstlabel == $label) {\n    return (1);\n  }\n  my ($coordpos,$position0,$position);\n  $position0=$self->{'seq'}->down_get_pos_of_label($label);\n  $coordpos=$self->{'seq'}->down_get_pos_of_label($firstlabel);\n  $position=$position0-$coordpos+1;\n  if ($position <= 0) {\n    $position--;\n  }\n  if ($strand == -1) {\n    #print \"\\n----------DEBUGSEQPOS label $label firstlabel $firstlabel strand $strand: position=\",1-$position;\n    return (1-$position);\n  } else {\n    #print \"\\n----------DEBUGSEQPOS label $label firstlabel $firstlabel strand $strand: position=\",$position;\n    return ($position);\n  }\n}\n\n=head2 follows\n\n  Title   : follows\n  Usage   : $seq->follows($firstlabel,$secondlabel)\n          : $seq->follows($firstlabel,$secondlabel,$strand)\n  Function: checks if SECONDlabel follows FIRSTlabel, undependent of the strand\n            i.e. it checks downstream for forward strand and\n            upstream for reverse strand\n  Returns : 1 or 0\n  Errorcode -1\n  Args    : two labels\n            an optional strand (1 or -1) argument \n             if strand argument is not given, it will default to the object\n             argument. This argument is useful when a call is issued from a child\n             of a parent object containing the subseq method\n\n\n#'\n# wraparound to is_downstream and is_upstream that chooses the correct one\n# depending on the strand\nsub follows {\n  my ($self,$firstlabel,$secondlabel,$strand)=@_;\n  unless (defined ($strand)) { # if optional [strand] argument not given\n    $strand=$self->strand;\n  }\n  if ($strand == 1) {\n    return ($self->{'seq'}->is_downstream($firstlabel,$secondlabel));\n  } else {\n    return ($self->{'seq'}->is_upstream($firstlabel,$secondlabel));\n  }\n}\n#\n#=head2 translate\n#\n# Title   : translate\n# Usage   : $protein_seq = $obj->translate\n# Function: Provides the translation of the DNA sequence\n#\t    using full IUPAC ambiguities in DNA/RNA and amino acid codes.\n#\n#\t    The resulting translation is identical to EMBL/TREMBL database \n#\t    translations.\n#\n# Returns : a string\n# Args    : character for terminator (optional) defaults to '*'\n#\t    character for unknown amino acid (optional) defaults to 'X'\n#\t    frame (optional) valid values 0, 1, 3, defaults to 0\n#\t    codon table id (optional) defaults to 1\n#\n#=cut\n#\n#sub translate {\n#  my ($self) = shift;\n#  return ($self->translate_string($self->seq,@_));\n#}\n#\n#=head2 translate_string\n#\n# Title   : translate_string\n# Usage   : $protein_seq = $obj->translate_string(\"attcgtgttgatcgatta\");\n# Function: Like translate, but can be used to translate subsequences after\n#\t    having retrieved them as string.\n# Args    : 1st argument is a string. Optional following arguments: like in\n#\t    the translate method\n#\n#=cut\n#\n#\n#sub translate_string {\n#  my($self) = shift;\n#  my($seq) = shift;\n#  my($stop, $unknown, $frame, $tableid) = @_;\n#  my($i, $len, $output) = (0,0,'');\n#  my($codon)   = \"\";\n#  my $aa;\n#\n#\n#  ## User can pass in symbol for stop and unknown codons\n#  unless(defined($stop) and $stop ne '')    { $stop = \"*\"; }\n#  unless(defined($unknown) and $unknown ne '') { $unknown = \"X\"; }\n#  unless(defined($frame) and $frame ne '') { $frame = 0; }\n#\n#  ## the codon table ID \n#  if ($self->translation_table) {\n#    $tableid = $self->translation_table;\n#  }\n#  unless(defined($tableid) and $tableid ne '')    { $tableid = 1; }\n#\n#  ##Error if monomer is \"Amino\"\n#  $self->warn(\"Can't translate an amino acid sequence.\") \n#      if (defined $self->alphabet && $self->alphabet eq 'protein');\n#\n#  ##Error if frame is not 0, 1 or 2\n#  $self->warn(\"Valid values for frame are 0, 1, 2, not [$frame].\")\n#      unless ($frame == 0 or $frame == 1 or $frame == 2);\n#\n#  #thows a warning if ID is invalid \n#  my $codonTable = Bio::Tools::CodonTable->new( -id => $tableid);\n#\n#  # deal with frame offset.\n#  if( $frame ) {\n#      $seq = substr ($seq,$frame);\n#  }\n#\n#  for $codon ( grep { CORE::length == 3 } split(/(.{3})/, $seq) ) {\n#      my $aa = $codonTable->translate($codon);\n#      if ($aa eq '*') {\n#\t    $output .= $stop;\n#      }\n#      elsif ($aa eq 'X') {\n#\t    $output .= $unknown;\n#      }\n#      else { \n#\t   $output .= $aa ;\n#      }   \n#  }\n#  #if( substr($output,-1,1) eq $stop ) {\n#  #    chop $output;\n#  #}\n#\n#  return ($output);\n#}\n\n=head2 gene\n\n Title   : gene\n Usage   : my $gene=$obj->gene;\n Function: Gets or sets the reference to the LiveSeq::Gene object.\n           Objects that are features of a LiveSeq Gene will have this\n           attribute set automatically.\n\n Returns : reference to an object of class Gene\n Note    : if Gene object is not set, this method will return 0;\n Args    : none or reference to object of class Bio::LiveSeq::Gene\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'gene'} = $value;\n  }\n  unless (exists $self->{'gene'}) {\n    return (0);\n  } else {\n    return $self->{'gene'};\n  }\n}\n\n=head2 obj_valid\n\n Title   : obj_valid\n Usage   : if ($obj->obj_valid) {do something;}\n Function: Checks if start and end labels are still valid for the ojbect,\n           i.e. tests if the LiveSeq object is still valid\n Returns : boolean\n Args    : none\n\n\nsub obj_valid {\n  my $self=shift;\n  unless (($self->{'seq'}->valid($self->start()))&&($self->{'seq'}->valid($self->end()))) {\n    return (0);\n  }\n  return (1);\n}\n\n=head2 name\n\n Title   : name\n Usage   : $name = $obj->name;\n         : $name = $obj->name(\"ABCD\");\n Function: Returns or sets the name of the object.\n           If there is no name, it will return \"unknown\";\n Returns : A string\n Args    : None\n\n\nsub name {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'name'} = $value;\n  }\n  unless (exists $self->{'name'}) {\n    return \"unknown\";\n  } else {\n    return $self->{'name'};\n  }\n}\n\n=head2 desc\n\n Title   : desc\n Usage   : $desc = $obj->desc;\n         : $desc = $obj->desc(\"ABCD\");\n Function: Returns or sets the description of the object.\n           If there is no description, it will return \"unknown\";\n Returns : A string\n Args    : None"},"line":1124,"kind":12,"range":{"start":{"line":1124,"character":0},"end":{"character":9999,"line":1134}}},{"line":1148,"kind":12,"range":{"start":{"line":1148,"character":0},"end":{"character":9999,"line":1158}},"signature":{"label":"source($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n\n# NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode) = @_;\n  if (defined $unsecuremode && $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    unless ($start) {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length;\n      }\n    } else {\n      unless ($length) {\n\t$end=$self->end;\n      }\n    }\n  } else {\n    if ($start) {\n      unless ($self->{'seq'}->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tunless ($self->{'seq'}->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n\tundef $length;\n      }\n    }\n  }\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,$length,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,$length,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n         : $substring = $obj->subseq(10,undef,4);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal.\n\n           Allows for negative numbers $obj->subseq(-10,-1). By\n           definition, there is no 0!\n                       -5  -1 1   5\n                gctagcgcccaac atggctcgctg\n\n           This allows to retrieve sequences upstream from given position.\n\n           The precedence is from left to right: if END is given LENGTH is\n           ignored.\n\n Examples: $obj->subseq(-10,undef,10) returns 10 elements before position 1\n           $obj->subseq(4,8) returns elements from the 4th to the 8th, inclusive\n\n Returns : a string\n Errorcode: -1\n Args    : start,  integer, defaults to start of the sequence\n           end,    integer, '' or undef, defaults to end of the sequence\n           length, integer, '' or undef\n           an optional strand (1 or -1) 4th argument \n            if strand argument is not given, it will default to the object\n            argment. This argument is useful when a call is issued from a child\n            of a parent object containing the subseq method\n\n\n#'\n# check the fact about reverse strand!\n# is it feasible? Is it correct? Should we do it? How about exons? Does it\n# work when you ask subseq of an exon?\n# eliminated now (Mon night)\nsub subseq {\n  ##my ($self,$pos1,$pos2,$length,$strand) = @_;\n  my ($self,$pos1,$pos2,$length,$strand) = @_;\n  ##unless (defined ($strand)) { # if optional [strand] argument not given\n  ##  $strand=$self->strand;\n  ##}\n  $strand=$self->strand;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  unless (defined ($pos1)) {\n    #print \"\\n##### DEBUG pos1 not defined\\n\";\n    $startlabel=$self->start;\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos2))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos2))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!)\"; return (-1);\n    ##  }\n    ##}\n    $startlabel=$self->label($pos1);\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  }\n  unless (defined ($pos2)) {\n    #print \"\\n##### pos2 not defined\\n\";\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos1))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos1))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!\"); return (-1);\n    ##  }\n    ##}\n    $endlabel=$self->label($pos2);\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  }\n  #print \"\\n    ####DEBUG: start $startlabel end $endlabel length $length strand $strand\\n\";\n\n  if ($strand == 1) {\n    $str = $self->{'seq'}->down_chain2string($startlabel,$length,$endlabel);\n  } else { # reverse strand\n    $str = $self->{'seq'}->up_chain2string($startlabel,$length,$endlabel);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n  }\n  return $str;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $seq->length();\n  Function: returns the number of nucleotides (or the number of aminoacids)\n            in the entire sequence\n  Returns : an integer\n  Errorcode -1\n  Args    : none\n\n\nsub length {\n  my $self=shift;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  if ($strand == 1) {\n    return $self->{'seq'}->down_subchain_length($start,$end);\n  } else {\n    return $self->{'seq'}->up_subchain_length($start,$end);\n  }\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, alias the common name of the object\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information.\n\n See also: accession_number\n Returns : a string\n Args    : none\n\n\nsub display_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'display_id'} = $value;\n  }\n  return $self->{'display_id'};\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number.\n           Notice that primary_id() provides the unique id for the\n           implemetation, allowing multiple objects to have the same accession\n           number in a particular implementation.\n\n           For objects with no accession_number this method returns \"unknown\".\n Returns : a string\n Args    : none\n\n\nsub accession_number {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'accession_number'} = $value;\n  }\n  unless (exists $self->{'accession_number'}) {\n    return \"unknown\";\n  } else {\n    return $self->{'accession_number'};\n  }\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their own\n           object ids in a way the implementation can control. Clients can\n           expect one id to map to one object.\n\n           For sequences with no primary_id, this method returns\n           a stringified memory location.\n\n Returns : A string\n Args    : None\n\n\n\nsub primary_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'primary_id'} = $value;\n  }\n  unless (exists $self->{'primary_id'}) {\n    return \"$self\";\n  } else {\n    return $self->{'primary_id'};\n  }\n}\n\n=head2 change\n\n Title   : change\n Usage   : $substring = $obj->change('AA', 10);\n Function: changes, modifies, mutates the LiveSequence\n Examples:\n        $obj->change('',   10);      delete nucleotide #10     \n        $obj->change('',   10, 2);   delete two nucleotides starting from #10\n        $obj->change('G',  10);      change nuc #10 to 'G'\n        $obj->change('GA', 10, 4);   replace #10 and 3 following with 'GA'\n        $obj->change('GA', 10, 2));  is same as $obj->change('GA',  10);\n        $obj->change('GA', 10, 0 );  insert 'GA' before nucleotide at #10\n        $obj->change('GA', 10, 1);   GA inserted before #10, #10 deleted\n        $obj->change('GATC', 10, 2); GATC inserted before #10, #10&#11 deleted\n        $obj->change('GATC', 10, 6); GATC inserted before #10, #10-#15 deleted\n\n\n Returns : a string of deleted bases (if any) or 1 (everything OK)\n Errorcode: -1\n Args    : seq,    string, or '' ('' = undef = 0 = deletion)\n           start,  integer\n           length, integer (optional)\n\n\nsub change {\n  &positionchange;\n}\n\n=head2 positionchange\n\n Title   : positionchange\n Function: Exactly like change. I.e. change() defaults to positionchange()\n\n\nsub positionchange {\n  my ($self,$newseq,$position,$length)=@_;\n  unless ($position) {\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  my $label=$self->label($position);\n  unless ($label > 0) { # label not found or error\n    $self->warn(\"No valid label found at that position!\");\n    return (-1);\n  }\n  return ($self->labelchange($newseq,$label,$length));\n}\n\n=head2 labelchange\n\n Title   : labelchange\n Function: Exactly like change but uses a /label/ instead than a position\n           as second argument. This allows for multiple changes in a LiveSeq\n           without the burden of recomputing positions. I.e. for a multiple\n           change in two different points of the LiveSeq, the approach would\n           be the following: fetch the correct labels out of the two different\n           positions (method: label($position)) and then use the labelchange()\n           method to modify the sequence using those labels instead than\n           relying on the positions (that would have modified after the\n           first change).\n\n\nsub labelchange {\n  my ($self,$newseq,$label,$length)=@_;\n  unless ($self->valid($label)) {\n    if ($self->{'seq'}->valid($label)) {\n       #$self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change for the object asked but it's ok for DNAlevel change, reverting to that\");\n      shift @_;\n      return($self->{'seq'}->labelchange(@_));\n    } else {\n      $self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change\");\n      return (-1);\n    }\n  }\n  unless ($newseq) { # it means this is a simple deletion\n    if (defined($length)) {\n      unless ($length >= 0) {\n\t$self->warn(\"No sense having length < 0 in a deletion\");\n\treturn (-1);\n      }\n    } else {\n      $self->warn(\"Length not defined for deletion!\");\n      return (-1);\n    }\n    return $self->_delete($label,$length);\n  }\n  my $newseqlength=CORE::length($newseq);\n  if (defined($length)) {\n    unless ($length >= 0) {\n      $self->warn(\"No sense having length < 0 in a change()\");\n      return (-1);\n    }\n  } else {\n    $length=$newseqlength; # defaults to pointmutation(s)\n  }\n  if ($length == 0) { # it means this is a simple insertion, length def&==0\n    my ($insertbegin,$insertend)=$self->_praeinsert($label,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n  if ($newseqlength == $length) { # it means this is simple pointmutation(s)\n    return $self->_mutate($label,$newseq,$length);\n  }\n  # if we arrived here then change is complex mixture\n  my $strand=$self->strand();\n  my $afterendlabel=$self->label($length+1,$label,$strand); # get the label at $length+1 positions after $label\n  unless ($afterendlabel > 0) { # label not found or error\n    $self->warn(\"No valid afterendlabel found for executing the complex mutation!\");\n    return (-1);\n  }\n  my $deleted=$self->_delete($label,$length); # first delete length nucs\n  if ($deleted == -1) { # if errors\n    return (-1);\n  } else { # then insert the newsequence\n    my ($insertbegin,$insertend)=$self->_praeinsert($afterendlabel,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n}\n\n# internal methods for change()\n\n# arguments: label for beginning of deletion, new sequence to insert\n# returns: labels of beginning and end of the inserted sequence\n# errorcode: -1\nsub _praeinsert {\n  my ($self,$label,$newseq)=@_;\n  my ($insertbegin,$insertend);\n  my $strand=$self->strand();\n  if ($strand == 1) {\n    ($insertbegin,$insertend)=($self->{'seq'}->praeinsert_string($newseq,$label));\n  } else { # since it's reverse strand and we insert in forward direction....\n    $newseq=reverse($newseq);\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n    ($insertend,$insertbegin)=($self->{'seq'}->postinsert_string($newseq,$label));\n  }\n  if (($insertbegin==0)||($insertend==0)) {\n    $self->warn(\"Some error occurred while inserting!\");\n    return (-1);\n  } else {\n    return ($insertbegin,$insertend);\n  }\n}\n\n# arguments: label for beginning of deletion, length of deletion\n# returns: string of deleted bases\n# errorcode: -1\nsub _delete {\n  my ($self,$label,$length)=@_;\n  my $strand=$self->strand();\n  my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n  unless ($endlabel > 0) { # label not found or error\n    $self->warn(\"No valid endlabel found for executing the deletion!\");\n    return (-1);\n  }\n  # this is important in Transcript to fix exon structure\n  $self->_deletecheck($label,$endlabel);\n  my $deletedseq;\n  if ($strand == 1) {\n    $deletedseq=$self->{'seq'}->splice_chain($label,undef,$endlabel);\n  } else {\n    $deletedseq=$self->{'seq'}->splice_chain($endlabel,undef,$label);\n    $deletedseq=reverse($deletedseq); # because we are on reverse strand and we cut anyway\n                         # in forward direction\n    $deletedseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  return ($deletedseq);\n}\n\n# empty function, overridden in Transcript, not useful here\nsub _deletecheck {\n}\n\n# arguments: label for beginning of mutation, newsequence, number of mutations\n# returns: 1 all OK\n# errorcode: -1\nsub _mutate {\n  my ($self,$label,$newseq,$length)=@_; # length is equal to length(newseq)\n  my ($i,$base,$nextlabel);\n  my @labels; # array of labels\n  my $strand=$self->strand();\n  if ($length == 1) { # special cases first\n    @labels=($label);\n  } else {\n    my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n    unless ($endlabel > 0) { # label not found or error\n      $self->warn(\"No valid endlabel found for executing the mutation!\");\n      return (-1);\n    }\n    if ($length == 2) { # another special case\n      @labels=($label,$endlabel);\n    } else { # more than 3 bases changed\n      # this wouldn't work for Transcript\n      #my $labelsarrayref;\n      #if ($strand == 1) {\n\t#$labelsarrayref=$self->{'seq'}->down_labels($label,$endlabel);\n      #} else {\n\t#$labelsarrayref=$self->{'seq'}->up_labels($label,$endlabel);\n      #}\n      #@labels=@{$labelsarrayref};\n      #if ($length != scalar(@labels)) { # not enough labels returned\n\t#$self->warn(\"Not enough valid labels found for executing the mutation!\");\n\t#return (-1);\n      #}\n\n      # this should be more general\n      @labels=($label); # put the first one\n      while ($label != $endlabel) {\n\t$nextlabel=$self->label(2,$label,$strand); # retrieve the next label\n\tpush (@labels,$nextlabel);\n\t$label=$nextlabel; # move on reference\n      }\n    }\n  }\n  if ($strand == -1) { # only for reverse strand\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  my $errorcheck; # if not equal to $length after summing for all changes, error did occurr\n  $i = 0;\n  foreach $base (split(//,$newseq)) {\n    $errorcheck += $self->{'seq'}->set_value_at_label($base,$labels[$i]);\n    $i++;\n  }\n  if ($errorcheck != $length) {\n    $self->warn(\"Some error occurred while mutating!\");\n    return (-1);\n  } else {\n    return (1);\n  }\n}\n\n=head2 valid\n\n  Title   : valid\n  Usage   : $boolean = $obj->valid($label)\n  Function: tests if a label exists inside the object\n  Returns : boolean\n  Args    : label\n\n\n# argument: label\n# returns: 1 YES 0 NO\nsub valid {\n  my ($self,$label)=@_;\n  my $checkme;\n  my @labels=$self->all_labels;\n  foreach $checkme (@labels) {\n    if ($label == $checkme) {\n      return (1); # found\n    }\n  }\n  return (0); # not found\n}\n\n\n=head2 start\n\n  Title   : start\n  Usage   : $startlabel=$obj->start()\n  Function: returns the label of the first nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub start {\n  my ($self) = @_;\n  return $self->{'start'}; # common for all classes BUT DNA (which redefines it) and Transcript (that takes the information from the Exons)\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $endlabel=$obj->end()\n  Function: returns the label of the last nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub end {\n  my ($self) = @_;\n  return $self->{'end'};\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand=$obj->strand()\n            $obj->strand($strand)\n  Function: gets or sets strand information, being 1 or -1 (forward or reverse)\n  Returns : -1 or 1\n  Args    : none OR -1 or 1\n\n\nsub strand {\n  my ($self,$strand) = @_;\n  if ($strand) {\n    if (($strand != 1)&&($strand != -1)) {\n      $self->warn(\"strand information not changed because strand identifier not valid\");\n    } else {\n      $self->{'strand'} = $strand;\n    }\n  }\n  return $self->{'strand'};\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n Returns : a string either 'dna','rna','protein'.\n Args    : none\n\n\n\nsub alphabet {\n  my %valid_type = map {$_, 1} qw( dna rna protein );\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $value = 'dna' if $value =~ /dna/i;\n    $value = 'rna' if $value =~ /rna/i;\n    unless ( $valid_type{$value} ) {\n      $self->warn(\"Molecular type '$value' is not a valid type\");\n    }\n    $self->{'alphabet'} = $value;\n  }\n  return $self->{'alphabet'};\n}\n\n=head2 coordinate_start\n\n  Title   : coordinate_start\n  Usage   : $coordstartlabel=$obj->coordinate_start()\n          : $coordstartlabel=$obj->coordinate_start($label)\n  Function: returns and optionally sets the first label of the coordinate\n            system used\n            For some objects only labels inside the object or in frame (for\n            Translation objects) will be allowed to get set as coordinate start\n\n  Returns : label. It returns 0 if label not found.\n  Errorcode -1 \n  Args    : an optional reference $label that is position 1\n\n\n\nsub coordinate_start {\n  my ($self,$label) = @_;\n  if ($label) {\n    if ($self->valid($label)) {\n      $self->{'coordinate_start'} = $label;\n    } else {\n      $self->warn(\"The label you are trying to set as coordinate_start is not valid for this object\");\n    }\n  }\n  my $coord_start = $self->{'coordinate_start'};\n  if ($coord_start) { \n    return $coord_start;\n  } else {\n    return $self->start();\n  }\n}\n\n=head2 label\n\n  Title   : label\n  Usage   : $seq->label($position)\n          : $seq->label($position,$firstlabel)\n  Examples: $nextlabel=$seq->label(2,$label) -> retrieves the following label\n          : $prevlabel=$seq->label(-1,$label) -> retrieves the preceding label\n\n  Function: returns the label of the nucleotide at $position from current\n            coordinate start\n  Returns : a label. It returns 0 if label not found.\n  Errorcode -1 \n  Args    : a position, \n            an optional reference $firstlabel that is to be used as position 1\n            an optional strand (1 or -1) argument \n             if strand argument is not given, it will default to the object\n             argument. This argument is useful when a call is issued from a child\n             of a parent object containing the subseq method\n\n\n\nsub label {\n  my ($self,$position,$firstlabel,$strand)=@_;\n  my $label;\n  unless (defined ($firstlabel)) {\n    $firstlabel=$self->coordinate_start;\n  }\n  unless ($position) {  # if position = 0 complain ?\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  unless (defined ($strand)) { # if optional [strand] argument not given\n    $strand=$self->strand;\n  }\n  if ($strand == 1) {\n    if ($position > 0) {\n      $label=$self->{'seq'}->down_get_label_at_pos($position,$firstlabel)\n    } else { # if < 0\n      $label=$self->{'seq'}->up_get_label_at_pos(1 - $position,$firstlabel)\n    }\n  } else {\n    if ($position > 0) {\n      $label=$self->{'seq'}->up_get_label_at_pos($position,$firstlabel)\n    } else { # if < 0\n      $label=$self->{'seq'}->down_get_label_at_pos(1 - $position,$firstlabel)\n    }\n  }\n  return $label;\n}\n\n\n=head2 position\n\n  Title   : position\n  Usage   : $seq->position($label)\n          : $seq->position($label,$firstlabel)\n  Function: returns the position of nucleotide at $label\n  Returns : the position of the label from current coordinate start\n  Errorcode 0\n  Args    : a label pointing to a certain nucleotide (e.g. start of exon)\n            an optional \"firstlabel\" as reference to count from\n            an optional strand (1 or -1) argument \n             if strand argument is not given, it will default to the object\n             argument. This argument is useful when a call is issued from a child\n             of a parent object containing the subseq method\n\n\n\nsub position {\n  my ($self,$label,$firstlabel,$strand)=@_;\n  unless (defined ($strand)) { # if optional [strand] argument not given\n    $strand=$self->strand;\n  }\n  unless (defined ($firstlabel)) {\n    $firstlabel=$self->coordinate_start;\n  }\n  unless ($self->valid($label)) {\n    $self->warn(\"label not valid\");\n    return (0);\n  }\n  if ($firstlabel == $label) {\n    return (1);\n  }\n  my ($coordpos,$position0,$position);\n  $position0=$self->{'seq'}->down_get_pos_of_label($label);\n  $coordpos=$self->{'seq'}->down_get_pos_of_label($firstlabel);\n  $position=$position0-$coordpos+1;\n  if ($position <= 0) {\n    $position--;\n  }\n  if ($strand == -1) {\n    #print \"\\n----------DEBUGSEQPOS label $label firstlabel $firstlabel strand $strand: position=\",1-$position;\n    return (1-$position);\n  } else {\n    #print \"\\n----------DEBUGSEQPOS label $label firstlabel $firstlabel strand $strand: position=\",$position;\n    return ($position);\n  }\n}\n\n=head2 follows\n\n  Title   : follows\n  Usage   : $seq->follows($firstlabel,$secondlabel)\n          : $seq->follows($firstlabel,$secondlabel,$strand)\n  Function: checks if SECONDlabel follows FIRSTlabel, undependent of the strand\n            i.e. it checks downstream for forward strand and\n            upstream for reverse strand\n  Returns : 1 or 0\n  Errorcode -1\n  Args    : two labels\n            an optional strand (1 or -1) argument \n             if strand argument is not given, it will default to the object\n             argument. This argument is useful when a call is issued from a child\n             of a parent object containing the subseq method\n\n\n#'\n# wraparound to is_downstream and is_upstream that chooses the correct one\n# depending on the strand\nsub follows {\n  my ($self,$firstlabel,$secondlabel,$strand)=@_;\n  unless (defined ($strand)) { # if optional [strand] argument not given\n    $strand=$self->strand;\n  }\n  if ($strand == 1) {\n    return ($self->{'seq'}->is_downstream($firstlabel,$secondlabel));\n  } else {\n    return ($self->{'seq'}->is_upstream($firstlabel,$secondlabel));\n  }\n}\n#\n#=head2 translate\n#\n# Title   : translate\n# Usage   : $protein_seq = $obj->translate\n# Function: Provides the translation of the DNA sequence\n#\t    using full IUPAC ambiguities in DNA/RNA and amino acid codes.\n#\n#\t    The resulting translation is identical to EMBL/TREMBL database \n#\t    translations.\n#\n# Returns : a string\n# Args    : character for terminator (optional) defaults to '*'\n#\t    character for unknown amino acid (optional) defaults to 'X'\n#\t    frame (optional) valid values 0, 1, 3, defaults to 0\n#\t    codon table id (optional) defaults to 1\n#\n#=cut\n#\n#sub translate {\n#  my ($self) = shift;\n#  return ($self->translate_string($self->seq,@_));\n#}\n#\n#=head2 translate_string\n#\n# Title   : translate_string\n# Usage   : $protein_seq = $obj->translate_string(\"attcgtgttgatcgatta\");\n# Function: Like translate, but can be used to translate subsequences after\n#\t    having retrieved them as string.\n# Args    : 1st argument is a string. Optional following arguments: like in\n#\t    the translate method\n#\n#=cut\n#\n#\n#sub translate_string {\n#  my($self) = shift;\n#  my($seq) = shift;\n#  my($stop, $unknown, $frame, $tableid) = @_;\n#  my($i, $len, $output) = (0,0,'');\n#  my($codon)   = \"\";\n#  my $aa;\n#\n#\n#  ## User can pass in symbol for stop and unknown codons\n#  unless(defined($stop) and $stop ne '')    { $stop = \"*\"; }\n#  unless(defined($unknown) and $unknown ne '') { $unknown = \"X\"; }\n#  unless(defined($frame) and $frame ne '') { $frame = 0; }\n#\n#  ## the codon table ID \n#  if ($self->translation_table) {\n#    $tableid = $self->translation_table;\n#  }\n#  unless(defined($tableid) and $tableid ne '')    { $tableid = 1; }\n#\n#  ##Error if monomer is \"Amino\"\n#  $self->warn(\"Can't translate an amino acid sequence.\") \n#      if (defined $self->alphabet && $self->alphabet eq 'protein');\n#\n#  ##Error if frame is not 0, 1 or 2\n#  $self->warn(\"Valid values for frame are 0, 1, 2, not [$frame].\")\n#      unless ($frame == 0 or $frame == 1 or $frame == 2);\n#\n#  #thows a warning if ID is invalid \n#  my $codonTable = Bio::Tools::CodonTable->new( -id => $tableid);\n#\n#  # deal with frame offset.\n#  if( $frame ) {\n#      $seq = substr ($seq,$frame);\n#  }\n#\n#  for $codon ( grep { CORE::length == 3 } split(/(.{3})/, $seq) ) {\n#      my $aa = $codonTable->translate($codon);\n#      if ($aa eq '*') {\n#\t    $output .= $stop;\n#      }\n#      elsif ($aa eq 'X') {\n#\t    $output .= $unknown;\n#      }\n#      else { \n#\t   $output .= $aa ;\n#      }   \n#  }\n#  #if( substr($output,-1,1) eq $stop ) {\n#  #    chop $output;\n#  #}\n#\n#  return ($output);\n#}\n\n=head2 gene\n\n Title   : gene\n Usage   : my $gene=$obj->gene;\n Function: Gets or sets the reference to the LiveSeq::Gene object.\n           Objects that are features of a LiveSeq Gene will have this\n           attribute set automatically.\n\n Returns : reference to an object of class Gene\n Note    : if Gene object is not set, this method will return 0;\n Args    : none or reference to object of class Bio::LiveSeq::Gene\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'gene'} = $value;\n  }\n  unless (exists $self->{'gene'}) {\n    return (0);\n  } else {\n    return $self->{'gene'};\n  }\n}\n\n=head2 obj_valid\n\n Title   : obj_valid\n Usage   : if ($obj->obj_valid) {do something;}\n Function: Checks if start and end labels are still valid for the ojbect,\n           i.e. tests if the LiveSeq object is still valid\n Returns : boolean\n Args    : none\n\n\nsub obj_valid {\n  my $self=shift;\n  unless (($self->{'seq'}->valid($self->start()))&&($self->{'seq'}->valid($self->end()))) {\n    return (0);\n  }\n  return (1);\n}\n\n=head2 name\n\n Title   : name\n Usage   : $name = $obj->name;\n         : $name = $obj->name(\"ABCD\");\n Function: Returns or sets the name of the object.\n           If there is no name, it will return \"unknown\";\n Returns : A string\n Args    : None\n\n\nsub name {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'name'} = $value;\n  }\n  unless (exists $self->{'name'}) {\n    return \"unknown\";\n  } else {\n    return $self->{'name'};\n  }\n}\n\n=head2 desc\n\n Title   : desc\n Usage   : $desc = $obj->desc;\n         : $desc = $obj->desc(\"ABCD\");\n Function: Returns or sets the description of the object.\n           If there is no description, it will return \"unknown\";\n Returns : A string\n Args    : None\n\n\nsub desc {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'desc'} = $value;\n  }\n  unless (exists $self->{'desc'}) {\n    return \"unknown\";\n  } else {\n    return $self->{'desc'};\n  }\n}\n\n=head2 source\n\n Title   : source\n Usage   : $name = $obj->source;\n         : $name = $obj->source(\"Homo sapiens\");\n Function: Returns or sets the organism that is source of the object.\n           If there is no source, it will return \"unknown\";\n Returns : A string\n Args    : None"},"children":[{"line":1149,"name":"$self","localvar":"my","kind":13,"containerName":"source","definition":"my"},{"line":1149,"containerName":"source","kind":13,"name":"$value"},{"name":"$value","containerName":"source","kind":13,"line":1150},{"name":"$self","kind":13,"containerName":"source","line":1151},{"line":1151,"name":"$value","containerName":"source","kind":13},{"name":"$self","containerName":"source","kind":13,"line":1153},{"name":"$self","containerName":"source","kind":13,"line":1156}],"containerName":"main::","name":"source","definition":"sub","detail":"($self,$value)"},{"children":[{"line":1161,"name":"$self","localvar":"my","containerName":"delete_Obj","kind":13,"definition":"my"},{"line":1162,"name":"@values","kind":13,"localvar":"my","containerName":"delete_Obj","definition":"my"},{"kind":13,"containerName":"delete_Obj","name":"$self","line":1162}],"name":"delete_Obj","containerName":"main::","definition":"sub","line":1160,"kind":12,"range":{"end":{"character":9999,"line":1162},"start":{"character":0,"line":1160}}},{"line":1163,"localvar":"my","containerName":null,"kind":13,"name":"@keys","definition":"my"},{"containerName":null,"kind":13,"name":"$self","line":1163},{"line":1165,"containerName":null,"localvar":"my","kind":13,"name":"$key","definition":"my"},{"containerName":null,"kind":13,"name":"@keys","line":1165},{"name":"%self","containerName":null,"kind":13,"line":1166},{"containerName":null,"kind":13,"name":"$key","line":1166},{"definition":"my","line":1168,"name":"$value","localvar":"my","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"@values","line":1168},{"line":1169,"name":"%value","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$value","line":1172},{"line":1172,"containerName":"main::","kind":12,"name":"delete_Obj"},{"kind":13,"containerName":null,"name":"%value","line":1174},{"line":1175,"name":"@array","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"name":"$value","containerName":null,"kind":13,"line":1175},{"line":1176,"containerName":null,"localvar":"my","kind":13,"name":"$element","definition":"my"},{"kind":13,"containerName":null,"name":"$element","line":1177},{"name":"@array","kind":13,"containerName":null,"line":1177},{"line":1179,"name":"$element","containerName":null,"kind":13},{"line":1179,"containerName":"main::","kind":12,"name":"delete_Obj"},{"line":1182,"name":"%value","kind":13,"containerName":null},{"line":1183,"name":"%hash","localvar":"my","containerName":null,"kind":13,"definition":"my"},{"kind":13,"containerName":null,"name":"$value","line":1183},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"$element","line":1184},{"name":"$element","kind":13,"containerName":null,"line":1185},{"line":1185,"name":"%hash","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$element","line":1187},{"name":"delete_Obj","kind":12,"containerName":"main::","line":1187}],"version":5}