{"version":5,"vars":[{"line":111,"containerName":"","kind":2,"name":"base"},{"definition":"sub","detail":"($class,@args)","children":[{"name":"$class","localvar":"my","containerName":"new","kind":13,"line":114,"definition":"my"},{"name":"@args","kind":13,"containerName":"new","line":114},{"line":115,"localvar":"my","kind":13,"containerName":"new","name":"$self","definition":"my"},{"line":116,"kind":13,"containerName":"new","name":"$self"},{"line":117,"name":"$self","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$class","line":117},{"line":119,"name":"$seq","localvar":"my","kind":13,"containerName":"new","definition":"my"},{"name":"$seqori","containerName":"new","kind":13,"line":119},{"name":"$pos","kind":13,"containerName":"new","line":119},{"name":"$len","containerName":"new","kind":13,"line":119},{"line":119,"name":"$label","containerName":"new","kind":13},{"name":"$self","kind":13,"containerName":"new","line":120},{"name":"_rearrange","containerName":"new","kind":12,"line":120},{"line":125,"name":"@args","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$seq","line":127},{"kind":13,"containerName":"new","name":"$self","line":127},{"line":127,"kind":12,"containerName":"new","name":"seq"},{"kind":13,"containerName":"new","name":"$seq","line":127},{"name":"$seqori","containerName":"new","kind":13,"line":128},{"line":128,"name":"$self","containerName":"new","kind":13},{"line":128,"kind":12,"containerName":"new","name":"seqori"},{"line":128,"name":"$seqori","containerName":"new","kind":13},{"name":"$pos","containerName":"new","kind":13,"line":129},{"containerName":"new","kind":13,"name":"$self","line":129},{"name":"pos","containerName":"new","kind":12,"line":129},{"line":129,"name":"$pos","containerName":"new","kind":13},{"line":130,"name":"$len","kind":13,"containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":130},{"kind":12,"containerName":"new","name":"len","line":130},{"line":130,"name":"$len","containerName":"new","kind":13},{"line":132,"containerName":"new","kind":13,"name":"$self"}],"containerName":"main::","name":"new","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"","label":"new($class,@args)"},"line":113,"kind":12,"range":{"start":{"line":113,"character":0},"end":{"line":133,"character":9999}}},{"line":152,"kind":12,"range":{"start":{"character":0,"line":152},"end":{"character":9999,"line":158}},"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Mutation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LiveSeq::Mutation\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutation - Mutation event descriptor class\n\n=head1 SYNOPSIS\n\n  # full descrition of a point mutation\n  $mutation1a = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -seqori => 'T',\n\t\t\t\t\t      -pos  => 100,\n\t\t\t\t\t      -len => 1 # optional, defaults to length(seq)\n\t\t\t\t\t     );\n\n  # minimal information for a point mutation\n  $mutation1b = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -pos  => 100\n\t\t\t\t\t      );\n  # insertion\n  $mutation2 = Bio::LiveSeq::Mutation->new ( -seq => 'ATT',\n\t\t\t\t\t     -pos  => 100,\n\t\t\t\t\t     -len => 0\n\t\t\t\t\t     );\n  # deletion\n  $mutation3 = Bio::LiveSeq::Mutation->new ( -seq => '',  # optional\n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n  # complex\n  $mutation4 = Bio::LiveSeq::Mutation->new ( -seq => 'CC', \n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n\n\n=head1 DESCRIPTION\n\nThis class describes a local mutation event using minimalistic\ndescription.  It is not necessary to know anything about the original\nsequence. You need to give the changed sequence, the position of the\nmutation in the (unidentified) reference sequence, and the length of\nthe affected subsequence in the reference sequence. If the original\nallele sequence is given, the objects applying the mutation into the\nreference sequence (e.g. L<Bio::LiveSeq::Mutator>) might check for its\nvalidity.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutation;\nuse strict;\n\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($seq, $seqori, $pos, $len, $label) =\n\t    $self->_rearrange([qw(SEQ\n\t\t\t\t  SEQORI\n\t\t\t\t  POS\n\t\t\t\t  LEN\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $seq && $self->seq($seq);\n    $seqori && $self->seqori($seqori);\n    $pos && $self->pos($pos);\n    defined($len) && $self->len($len); # defined() added otherwise won't work for len==0\n    \n    return $self; # success - we hope!\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $obj->seq();\n Function: \n\n            Sets and returns the mutated sequence. No checking is done\n            to validate the symbols.\n\n Example : \n Returns : string\n Args    : integer","label":"seq($self,$value)"},"children":[{"localvar":"my","containerName":"seq","kind":13,"name":"$self","line":153,"definition":"my"},{"line":153,"kind":13,"containerName":"seq","name":"$value"},{"kind":13,"containerName":"seq","name":"$value","line":154},{"kind":13,"containerName":"seq","name":"$self","line":155},{"kind":13,"containerName":"seq","name":"$value","line":155},{"name":"$self","containerName":"seq","kind":13,"line":157}],"containerName":"main::","name":"seq","definition":"sub","detail":"($self,$value)"},{"definition":"sub","detail":"($self,$value)","children":[{"localvar":"my","containerName":"seqori","kind":13,"name":"$self","line":179,"definition":"my"},{"name":"$value","containerName":"seqori","kind":13,"line":179},{"line":180,"name":"$value","kind":13,"containerName":"seqori"},{"name":"$self","containerName":"seqori","kind":13,"line":181},{"line":181,"containerName":"seqori","kind":13,"name":"$value"},{"name":"$self","containerName":"seqori","kind":13,"line":183}],"name":"seqori","containerName":"main::","signature":{"label":"seqori($self,$value)","documentation":"1;\n# $Id: Mutation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LiveSeq::Mutation\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutation - Mutation event descriptor class\n\n=head1 SYNOPSIS\n\n  # full descrition of a point mutation\n  $mutation1a = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -seqori => 'T',\n\t\t\t\t\t      -pos  => 100,\n\t\t\t\t\t      -len => 1 # optional, defaults to length(seq)\n\t\t\t\t\t     );\n\n  # minimal information for a point mutation\n  $mutation1b = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -pos  => 100\n\t\t\t\t\t      );\n  # insertion\n  $mutation2 = Bio::LiveSeq::Mutation->new ( -seq => 'ATT',\n\t\t\t\t\t     -pos  => 100,\n\t\t\t\t\t     -len => 0\n\t\t\t\t\t     );\n  # deletion\n  $mutation3 = Bio::LiveSeq::Mutation->new ( -seq => '',  # optional\n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n  # complex\n  $mutation4 = Bio::LiveSeq::Mutation->new ( -seq => 'CC', \n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n\n\n=head1 DESCRIPTION\n\nThis class describes a local mutation event using minimalistic\ndescription.  It is not necessary to know anything about the original\nsequence. You need to give the changed sequence, the position of the\nmutation in the (unidentified) reference sequence, and the length of\nthe affected subsequence in the reference sequence. If the original\nallele sequence is given, the objects applying the mutation into the\nreference sequence (e.g. L<Bio::LiveSeq::Mutator>) might check for its\nvalidity.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutation;\nuse strict;\n\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($seq, $seqori, $pos, $len, $label) =\n\t    $self->_rearrange([qw(SEQ\n\t\t\t\t  SEQORI\n\t\t\t\t  POS\n\t\t\t\t  LEN\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $seq && $self->seq($seq);\n    $seqori && $self->seqori($seqori);\n    $pos && $self->pos($pos);\n    defined($len) && $self->len($len); # defined() added otherwise won't work for len==0\n    \n    return $self; # success - we hope!\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $obj->seq();\n Function: \n\n            Sets and returns the mutated sequence. No checking is done\n            to validate the symbols.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub seq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'seq'} = $value;\n    }\n    return $self->{'seq'} || '';\n}\n\n\n=head2 seqori\n\n Title   : seqori\n Usage   : $obj->seqori();\n Function: \n\n            Sets and returns the original subsequence in the reference\n            sequence. No checking is done to validate the symbols.\n            Optional value.\n\n Example : \n Returns : string\n Args    : string","parameters":[{"label":"$self"},{"label":"$value"}]},"line":178,"range":{"start":{"character":0,"line":178},"end":{"character":9999,"line":184}},"kind":12},{"range":{"end":{"character":9999,"line":213},"start":{"character":0,"line":203}},"kind":12,"line":203,"signature":{"label":"pos($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Mutation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LiveSeq::Mutation\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutation - Mutation event descriptor class\n\n=head1 SYNOPSIS\n\n  # full descrition of a point mutation\n  $mutation1a = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -seqori => 'T',\n\t\t\t\t\t      -pos  => 100,\n\t\t\t\t\t      -len => 1 # optional, defaults to length(seq)\n\t\t\t\t\t     );\n\n  # minimal information for a point mutation\n  $mutation1b = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -pos  => 100\n\t\t\t\t\t      );\n  # insertion\n  $mutation2 = Bio::LiveSeq::Mutation->new ( -seq => 'ATT',\n\t\t\t\t\t     -pos  => 100,\n\t\t\t\t\t     -len => 0\n\t\t\t\t\t     );\n  # deletion\n  $mutation3 = Bio::LiveSeq::Mutation->new ( -seq => '',  # optional\n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n  # complex\n  $mutation4 = Bio::LiveSeq::Mutation->new ( -seq => 'CC', \n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n\n\n=head1 DESCRIPTION\n\nThis class describes a local mutation event using minimalistic\ndescription.  It is not necessary to know anything about the original\nsequence. You need to give the changed sequence, the position of the\nmutation in the (unidentified) reference sequence, and the length of\nthe affected subsequence in the reference sequence. If the original\nallele sequence is given, the objects applying the mutation into the\nreference sequence (e.g. L<Bio::LiveSeq::Mutator>) might check for its\nvalidity.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutation;\nuse strict;\n\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($seq, $seqori, $pos, $len, $label) =\n\t    $self->_rearrange([qw(SEQ\n\t\t\t\t  SEQORI\n\t\t\t\t  POS\n\t\t\t\t  LEN\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $seq && $self->seq($seq);\n    $seqori && $self->seqori($seqori);\n    $pos && $self->pos($pos);\n    defined($len) && $self->len($len); # defined() added otherwise won't work for len==0\n    \n    return $self; # success - we hope!\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $obj->seq();\n Function: \n\n            Sets and returns the mutated sequence. No checking is done\n            to validate the symbols.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub seq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'seq'} = $value;\n    }\n    return $self->{'seq'} || '';\n}\n\n\n=head2 seqori\n\n Title   : seqori\n Usage   : $obj->seqori();\n Function: \n\n            Sets and returns the original subsequence in the reference\n            sequence. No checking is done to validate the symbols.\n            Optional value.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub seqori {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'seqori'} = $value;\n    }\n    return $self->{'seqori'} || '';\n}\n\n\n=head2 pos\n\n Title   : pos\n Usage   : $obj->pos();\n Function: \n\n            Sets and returns the position of the first element in the\n            sequence.\n\n Example : \n Returns : string\n Args    : integer"},"containerName":"main::","name":"pos","children":[{"line":204,"name":"$self","localvar":"my","kind":13,"containerName":"pos","definition":"my"},{"containerName":"pos","kind":13,"name":"$value","line":204},{"line":205,"name":"$value","kind":13,"containerName":"pos"},{"kind":13,"containerName":"pos","name":"$value","line":206},{"line":207,"name":"$self","kind":13,"containerName":"pos"},{"line":207,"containerName":"pos","kind":12,"name":"throw"},{"containerName":"pos","kind":13,"name":"$self","line":209},{"line":209,"name":"$value","containerName":"pos","kind":13},{"line":212,"name":"$self","containerName":"pos","kind":13}],"detail":"($self,$value)","definition":"sub"},{"range":{"end":{"line":240,"character":9999},"start":{"line":231,"character":0}},"kind":12,"line":231,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Mutation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LiveSeq::Mutation\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutation - Mutation event descriptor class\n\n=head1 SYNOPSIS\n\n  # full descrition of a point mutation\n  $mutation1a = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -seqori => 'T',\n\t\t\t\t\t      -pos  => 100,\n\t\t\t\t\t      -len => 1 # optional, defaults to length(seq)\n\t\t\t\t\t     );\n\n  # minimal information for a point mutation\n  $mutation1b = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -pos  => 100\n\t\t\t\t\t      );\n  # insertion\n  $mutation2 = Bio::LiveSeq::Mutation->new ( -seq => 'ATT',\n\t\t\t\t\t     -pos  => 100,\n\t\t\t\t\t     -len => 0\n\t\t\t\t\t     );\n  # deletion\n  $mutation3 = Bio::LiveSeq::Mutation->new ( -seq => '',  # optional\n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n  # complex\n  $mutation4 = Bio::LiveSeq::Mutation->new ( -seq => 'CC', \n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n\n\n=head1 DESCRIPTION\n\nThis class describes a local mutation event using minimalistic\ndescription.  It is not necessary to know anything about the original\nsequence. You need to give the changed sequence, the position of the\nmutation in the (unidentified) reference sequence, and the length of\nthe affected subsequence in the reference sequence. If the original\nallele sequence is given, the objects applying the mutation into the\nreference sequence (e.g. L<Bio::LiveSeq::Mutator>) might check for its\nvalidity.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutation;\nuse strict;\n\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($seq, $seqori, $pos, $len, $label) =\n\t    $self->_rearrange([qw(SEQ\n\t\t\t\t  SEQORI\n\t\t\t\t  POS\n\t\t\t\t  LEN\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $seq && $self->seq($seq);\n    $seqori && $self->seqori($seqori);\n    $pos && $self->pos($pos);\n    defined($len) && $self->len($len); # defined() added otherwise won't work for len==0\n    \n    return $self; # success - we hope!\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $obj->seq();\n Function: \n\n            Sets and returns the mutated sequence. No checking is done\n            to validate the symbols.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub seq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'seq'} = $value;\n    }\n    return $self->{'seq'} || '';\n}\n\n\n=head2 seqori\n\n Title   : seqori\n Usage   : $obj->seqori();\n Function: \n\n            Sets and returns the original subsequence in the reference\n            sequence. No checking is done to validate the symbols.\n            Optional value.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub seqori {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'seqori'} = $value;\n    }\n    return $self->{'seqori'} || '';\n}\n\n\n=head2 pos\n\n Title   : pos\n Usage   : $obj->pos();\n Function: \n\n            Sets and returns the position of the first element in the\n            sequence.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub pos {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ( $value !~ /^([+-])?\\d+$/ ) {\n\t    $self->throw(\"[$value] for pos has to be an integer\\n\");\n\t} else {\n\t    $self->{'pos'} = $value;\n\t}\n    }\n    return $self->{'pos'};\n}\n\n=head2 len\n\n Title   : len\n Usage   : $obj->len();\n Function: \n\n            Sets and returns the len of the affected original allele\n            sequence.  If value is not set, defaults to the lenght of\n            the mutated sequence (seq).\n\n Example : \n Returns : string\n Args    : string","label":"len($self,$value)"},"containerName":"main::","name":"len","children":[{"definition":"my","containerName":"len","localvar":"my","kind":13,"name":"$self","line":232},{"containerName":"len","kind":13,"name":"$value","line":232},{"line":233,"name":"$value","kind":13,"containerName":"len"},{"name":"$self","kind":13,"containerName":"len","line":234},{"containerName":"len","kind":13,"name":"$value","line":234},{"kind":13,"containerName":"len","name":"$self","line":236},{"name":"$self","containerName":"len","kind":13,"line":237},{"name":"$self","kind":13,"containerName":"len","line":239}],"detail":"($self,$value)","definition":"sub"},{"signature":{"label":"label($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Mutation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LiveSeq::Mutation\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutation - Mutation event descriptor class\n\n=head1 SYNOPSIS\n\n  # full descrition of a point mutation\n  $mutation1a = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -seqori => 'T',\n\t\t\t\t\t      -pos  => 100,\n\t\t\t\t\t      -len => 1 # optional, defaults to length(seq)\n\t\t\t\t\t     );\n\n  # minimal information for a point mutation\n  $mutation1b = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -pos  => 100\n\t\t\t\t\t      );\n  # insertion\n  $mutation2 = Bio::LiveSeq::Mutation->new ( -seq => 'ATT',\n\t\t\t\t\t     -pos  => 100,\n\t\t\t\t\t     -len => 0\n\t\t\t\t\t     );\n  # deletion\n  $mutation3 = Bio::LiveSeq::Mutation->new ( -seq => '',  # optional\n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n  # complex\n  $mutation4 = Bio::LiveSeq::Mutation->new ( -seq => 'CC', \n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n\n\n=head1 DESCRIPTION\n\nThis class describes a local mutation event using minimalistic\ndescription.  It is not necessary to know anything about the original\nsequence. You need to give the changed sequence, the position of the\nmutation in the (unidentified) reference sequence, and the length of\nthe affected subsequence in the reference sequence. If the original\nallele sequence is given, the objects applying the mutation into the\nreference sequence (e.g. L<Bio::LiveSeq::Mutator>) might check for its\nvalidity.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutation;\nuse strict;\n\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($seq, $seqori, $pos, $len, $label) =\n\t    $self->_rearrange([qw(SEQ\n\t\t\t\t  SEQORI\n\t\t\t\t  POS\n\t\t\t\t  LEN\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $seq && $self->seq($seq);\n    $seqori && $self->seqori($seqori);\n    $pos && $self->pos($pos);\n    defined($len) && $self->len($len); # defined() added otherwise won't work for len==0\n    \n    return $self; # success - we hope!\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $obj->seq();\n Function: \n\n            Sets and returns the mutated sequence. No checking is done\n            to validate the symbols.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub seq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'seq'} = $value;\n    }\n    return $self->{'seq'} || '';\n}\n\n\n=head2 seqori\n\n Title   : seqori\n Usage   : $obj->seqori();\n Function: \n\n            Sets and returns the original subsequence in the reference\n            sequence. No checking is done to validate the symbols.\n            Optional value.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub seqori {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'seqori'} = $value;\n    }\n    return $self->{'seqori'} || '';\n}\n\n\n=head2 pos\n\n Title   : pos\n Usage   : $obj->pos();\n Function: \n\n            Sets and returns the position of the first element in the\n            sequence.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub pos {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ( $value !~ /^([+-])?\\d+$/ ) {\n\t    $self->throw(\"[$value] for pos has to be an integer\\n\");\n\t} else {\n\t    $self->{'pos'} = $value;\n\t}\n    }\n    return $self->{'pos'};\n}\n\n=head2 len\n\n Title   : len\n Usage   : $obj->len();\n Function: \n\n            Sets and returns the len of the affected original allele\n            sequence.  If value is not set, defaults to the lenght of\n            the mutated sequence (seq).\n\n Example : \n Returns : string\n Args    : string\n\n\nsub len {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'len'} = $value;\n  }\n   if ( ! exists $self->{'len'} ) {\n       return length $self->{'seq'};\n   }\n   return $self->{'len'};\n}\n\n=head2 label\n\n Title   : label\n Usage   : $obj->label();\n Function: \n\n            Sets and returns the label of the affected original allele\n            location. Label is a stable identifier whereas location\n            can be changed by mutations. Label comes from\n            l<Bio::LiveSeq::Gene>.\n\n Example : \n Returns : string\n Args    : string"},"range":{"start":{"line":259,"character":0},"end":{"character":9999,"line":268}},"kind":12,"line":259,"detail":"($self,$value)","definition":"sub","name":"label","containerName":"main::","children":[{"containerName":"label","localvar":"my","kind":13,"name":"$self","line":260,"definition":"my"},{"kind":13,"containerName":"label","name":"$value","line":260},{"name":"$value","containerName":"label","kind":13,"line":261},{"name":"$self","kind":13,"containerName":"label","line":262},{"line":262,"name":"$value","containerName":"label","kind":13},{"line":264,"name":"$self","containerName":"label","kind":13},{"line":267,"containerName":"label","kind":13,"name":"$self"}]},{"detail":"($self,$value)","definition":"sub","name":"transpos","containerName":"main::","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"transpos","line":290,"definition":"my"},{"containerName":"transpos","kind":13,"name":"$value","line":290},{"line":291,"kind":13,"containerName":"transpos","name":"$value"},{"kind":13,"containerName":"transpos","name":"$value","line":292},{"line":293,"containerName":"transpos","kind":13,"name":"$self"},{"name":"throw","containerName":"transpos","kind":12,"line":293},{"kind":13,"containerName":"transpos","name":"$self","line":295},{"containerName":"transpos","kind":13,"name":"$value","line":295},{"line":298,"name":"$self","containerName":"transpos","kind":13}],"signature":{"label":"transpos($self,$value)","documentation":"1;\n# $Id: Mutation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LiveSeq::Mutation\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutation - Mutation event descriptor class\n\n=head1 SYNOPSIS\n\n  # full descrition of a point mutation\n  $mutation1a = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -seqori => 'T',\n\t\t\t\t\t      -pos  => 100,\n\t\t\t\t\t      -len => 1 # optional, defaults to length(seq)\n\t\t\t\t\t     );\n\n  # minimal information for a point mutation\n  $mutation1b = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -pos  => 100\n\t\t\t\t\t      );\n  # insertion\n  $mutation2 = Bio::LiveSeq::Mutation->new ( -seq => 'ATT',\n\t\t\t\t\t     -pos  => 100,\n\t\t\t\t\t     -len => 0\n\t\t\t\t\t     );\n  # deletion\n  $mutation3 = Bio::LiveSeq::Mutation->new ( -seq => '',  # optional\n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n  # complex\n  $mutation4 = Bio::LiveSeq::Mutation->new ( -seq => 'CC', \n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n\n\n=head1 DESCRIPTION\n\nThis class describes a local mutation event using minimalistic\ndescription.  It is not necessary to know anything about the original\nsequence. You need to give the changed sequence, the position of the\nmutation in the (unidentified) reference sequence, and the length of\nthe affected subsequence in the reference sequence. If the original\nallele sequence is given, the objects applying the mutation into the\nreference sequence (e.g. L<Bio::LiveSeq::Mutator>) might check for its\nvalidity.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutation;\nuse strict;\n\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($seq, $seqori, $pos, $len, $label) =\n\t    $self->_rearrange([qw(SEQ\n\t\t\t\t  SEQORI\n\t\t\t\t  POS\n\t\t\t\t  LEN\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $seq && $self->seq($seq);\n    $seqori && $self->seqori($seqori);\n    $pos && $self->pos($pos);\n    defined($len) && $self->len($len); # defined() added otherwise won't work for len==0\n    \n    return $self; # success - we hope!\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $obj->seq();\n Function: \n\n            Sets and returns the mutated sequence. No checking is done\n            to validate the symbols.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub seq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'seq'} = $value;\n    }\n    return $self->{'seq'} || '';\n}\n\n\n=head2 seqori\n\n Title   : seqori\n Usage   : $obj->seqori();\n Function: \n\n            Sets and returns the original subsequence in the reference\n            sequence. No checking is done to validate the symbols.\n            Optional value.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub seqori {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'seqori'} = $value;\n    }\n    return $self->{'seqori'} || '';\n}\n\n\n=head2 pos\n\n Title   : pos\n Usage   : $obj->pos();\n Function: \n\n            Sets and returns the position of the first element in the\n            sequence.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub pos {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ( $value !~ /^([+-])?\\d+$/ ) {\n\t    $self->throw(\"[$value] for pos has to be an integer\\n\");\n\t} else {\n\t    $self->{'pos'} = $value;\n\t}\n    }\n    return $self->{'pos'};\n}\n\n=head2 len\n\n Title   : len\n Usage   : $obj->len();\n Function: \n\n            Sets and returns the len of the affected original allele\n            sequence.  If value is not set, defaults to the lenght of\n            the mutated sequence (seq).\n\n Example : \n Returns : string\n Args    : string\n\n\nsub len {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'len'} = $value;\n  }\n   if ( ! exists $self->{'len'} ) {\n       return length $self->{'seq'};\n   }\n   return $self->{'len'};\n}\n\n=head2 label\n\n Title   : label\n Usage   : $obj->label();\n Function: \n\n            Sets and returns the label of the affected original allele\n            location. Label is a stable identifier whereas location\n            can be changed by mutations. Label comes from\n            l<Bio::LiveSeq::Gene>.\n\n Example : \n Returns : string\n Args    : string\n\n\nsub label {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'label'} = $value;\n   }\n   if ( ! exists $self->{'label'} ) {\n       return;\n   } \n   return $self->{'label'};\n}\n\n\n=head2 transpos\n\n Title   : transpos\n Usage   : $obj->transpos();\n Function: \n\n            Sets and returns the transcript position of the mutation.\n            Set when associated with a reference sequence. Value\n            depends on reference molecule and the co-ordinate system\n            used.\n\n Example : \n Returns : string\n Args    : integer","parameters":[{"label":"$self"},{"label":"$value"}]},"range":{"end":{"character":9999,"line":299},"start":{"character":0,"line":289}},"kind":12,"line":289},{"name":"issue","containerName":"main::","children":[{"name":"$self","localvar":"my","containerName":"issue","kind":13,"line":320,"definition":"my"},{"line":320,"name":"$value","containerName":"issue","kind":13},{"containerName":"issue","kind":13,"name":"$value","line":321},{"line":322,"name":"$value","kind":13,"containerName":"issue"},{"name":"$self","containerName":"issue","kind":13,"line":323},{"line":323,"name":"throw","containerName":"issue","kind":12},{"line":325,"kind":13,"containerName":"issue","name":"$self"},{"line":325,"kind":13,"containerName":"issue","name":"$value"},{"containerName":"issue","kind":13,"name":"$self","line":328}],"detail":"($self,$value)","definition":"sub","range":{"start":{"line":319,"character":0},"end":{"line":329,"character":9999}},"kind":12,"line":319,"signature":{"label":"issue($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Mutation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LiveSeq::Mutation\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutation - Mutation event descriptor class\n\n=head1 SYNOPSIS\n\n  # full descrition of a point mutation\n  $mutation1a = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -seqori => 'T',\n\t\t\t\t\t      -pos  => 100,\n\t\t\t\t\t      -len => 1 # optional, defaults to length(seq)\n\t\t\t\t\t     );\n\n  # minimal information for a point mutation\n  $mutation1b = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -pos  => 100\n\t\t\t\t\t      );\n  # insertion\n  $mutation2 = Bio::LiveSeq::Mutation->new ( -seq => 'ATT',\n\t\t\t\t\t     -pos  => 100,\n\t\t\t\t\t     -len => 0\n\t\t\t\t\t     );\n  # deletion\n  $mutation3 = Bio::LiveSeq::Mutation->new ( -seq => '',  # optional\n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n  # complex\n  $mutation4 = Bio::LiveSeq::Mutation->new ( -seq => 'CC', \n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n\n\n=head1 DESCRIPTION\n\nThis class describes a local mutation event using minimalistic\ndescription.  It is not necessary to know anything about the original\nsequence. You need to give the changed sequence, the position of the\nmutation in the (unidentified) reference sequence, and the length of\nthe affected subsequence in the reference sequence. If the original\nallele sequence is given, the objects applying the mutation into the\nreference sequence (e.g. L<Bio::LiveSeq::Mutator>) might check for its\nvalidity.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutation;\nuse strict;\n\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($seq, $seqori, $pos, $len, $label) =\n\t    $self->_rearrange([qw(SEQ\n\t\t\t\t  SEQORI\n\t\t\t\t  POS\n\t\t\t\t  LEN\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $seq && $self->seq($seq);\n    $seqori && $self->seqori($seqori);\n    $pos && $self->pos($pos);\n    defined($len) && $self->len($len); # defined() added otherwise won't work for len==0\n    \n    return $self; # success - we hope!\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $obj->seq();\n Function: \n\n            Sets and returns the mutated sequence. No checking is done\n            to validate the symbols.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub seq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'seq'} = $value;\n    }\n    return $self->{'seq'} || '';\n}\n\n\n=head2 seqori\n\n Title   : seqori\n Usage   : $obj->seqori();\n Function: \n\n            Sets and returns the original subsequence in the reference\n            sequence. No checking is done to validate the symbols.\n            Optional value.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub seqori {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'seqori'} = $value;\n    }\n    return $self->{'seqori'} || '';\n}\n\n\n=head2 pos\n\n Title   : pos\n Usage   : $obj->pos();\n Function: \n\n            Sets and returns the position of the first element in the\n            sequence.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub pos {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ( $value !~ /^([+-])?\\d+$/ ) {\n\t    $self->throw(\"[$value] for pos has to be an integer\\n\");\n\t} else {\n\t    $self->{'pos'} = $value;\n\t}\n    }\n    return $self->{'pos'};\n}\n\n=head2 len\n\n Title   : len\n Usage   : $obj->len();\n Function: \n\n            Sets and returns the len of the affected original allele\n            sequence.  If value is not set, defaults to the lenght of\n            the mutated sequence (seq).\n\n Example : \n Returns : string\n Args    : string\n\n\nsub len {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'len'} = $value;\n  }\n   if ( ! exists $self->{'len'} ) {\n       return length $self->{'seq'};\n   }\n   return $self->{'len'};\n}\n\n=head2 label\n\n Title   : label\n Usage   : $obj->label();\n Function: \n\n            Sets and returns the label of the affected original allele\n            location. Label is a stable identifier whereas location\n            can be changed by mutations. Label comes from\n            l<Bio::LiveSeq::Gene>.\n\n Example : \n Returns : string\n Args    : string\n\n\nsub label {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'label'} = $value;\n   }\n   if ( ! exists $self->{'label'} ) {\n       return;\n   } \n   return $self->{'label'};\n}\n\n\n=head2 transpos\n\n Title   : transpos\n Usage   : $obj->transpos();\n Function: \n\n            Sets and returns the transcript position of the mutation.\n            Set when associated with a reference sequence. Value\n            depends on reference molecule and the co-ordinate system\n            used.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub transpos {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ( $value !~ /^([+-])?\\d+$/ ) {\n\t    $self->throw(\"[$value] for transpos has to be an integer\\n\");\n\t} else {\n\t    $self->{'transpos'} = $value;\n\t}\n    }\n    return $self->{'transpos'};\n}\n\n\n=head2 issue\n\n Title   : issue\n Usage   : $obj->issue();\n Function: \n\n            Sets and returns the position of the mutation in an array\n            of mutations to be issued. Set after the validity of the\n            mutation has been confirmed.\n\n Example : \n Returns : string\n Args    : integer"}},{"signature":{"label":"prelabel($self,$value)","documentation":"1;\n# $Id: Mutation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LiveSeq::Mutation\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutation - Mutation event descriptor class\n\n=head1 SYNOPSIS\n\n  # full descrition of a point mutation\n  $mutation1a = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -seqori => 'T',\n\t\t\t\t\t      -pos  => 100,\n\t\t\t\t\t      -len => 1 # optional, defaults to length(seq)\n\t\t\t\t\t     );\n\n  # minimal information for a point mutation\n  $mutation1b = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -pos  => 100\n\t\t\t\t\t      );\n  # insertion\n  $mutation2 = Bio::LiveSeq::Mutation->new ( -seq => 'ATT',\n\t\t\t\t\t     -pos  => 100,\n\t\t\t\t\t     -len => 0\n\t\t\t\t\t     );\n  # deletion\n  $mutation3 = Bio::LiveSeq::Mutation->new ( -seq => '',  # optional\n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n  # complex\n  $mutation4 = Bio::LiveSeq::Mutation->new ( -seq => 'CC', \n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n\n\n=head1 DESCRIPTION\n\nThis class describes a local mutation event using minimalistic\ndescription.  It is not necessary to know anything about the original\nsequence. You need to give the changed sequence, the position of the\nmutation in the (unidentified) reference sequence, and the length of\nthe affected subsequence in the reference sequence. If the original\nallele sequence is given, the objects applying the mutation into the\nreference sequence (e.g. L<Bio::LiveSeq::Mutator>) might check for its\nvalidity.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutation;\nuse strict;\n\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($seq, $seqori, $pos, $len, $label) =\n\t    $self->_rearrange([qw(SEQ\n\t\t\t\t  SEQORI\n\t\t\t\t  POS\n\t\t\t\t  LEN\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $seq && $self->seq($seq);\n    $seqori && $self->seqori($seqori);\n    $pos && $self->pos($pos);\n    defined($len) && $self->len($len); # defined() added otherwise won't work for len==0\n    \n    return $self; # success - we hope!\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $obj->seq();\n Function: \n\n            Sets and returns the mutated sequence. No checking is done\n            to validate the symbols.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub seq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'seq'} = $value;\n    }\n    return $self->{'seq'} || '';\n}\n\n\n=head2 seqori\n\n Title   : seqori\n Usage   : $obj->seqori();\n Function: \n\n            Sets and returns the original subsequence in the reference\n            sequence. No checking is done to validate the symbols.\n            Optional value.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub seqori {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'seqori'} = $value;\n    }\n    return $self->{'seqori'} || '';\n}\n\n\n=head2 pos\n\n Title   : pos\n Usage   : $obj->pos();\n Function: \n\n            Sets and returns the position of the first element in the\n            sequence.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub pos {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ( $value !~ /^([+-])?\\d+$/ ) {\n\t    $self->throw(\"[$value] for pos has to be an integer\\n\");\n\t} else {\n\t    $self->{'pos'} = $value;\n\t}\n    }\n    return $self->{'pos'};\n}\n\n=head2 len\n\n Title   : len\n Usage   : $obj->len();\n Function: \n\n            Sets and returns the len of the affected original allele\n            sequence.  If value is not set, defaults to the lenght of\n            the mutated sequence (seq).\n\n Example : \n Returns : string\n Args    : string\n\n\nsub len {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'len'} = $value;\n  }\n   if ( ! exists $self->{'len'} ) {\n       return length $self->{'seq'};\n   }\n   return $self->{'len'};\n}\n\n=head2 label\n\n Title   : label\n Usage   : $obj->label();\n Function: \n\n            Sets and returns the label of the affected original allele\n            location. Label is a stable identifier whereas location\n            can be changed by mutations. Label comes from\n            l<Bio::LiveSeq::Gene>.\n\n Example : \n Returns : string\n Args    : string\n\n\nsub label {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'label'} = $value;\n   }\n   if ( ! exists $self->{'label'} ) {\n       return;\n   } \n   return $self->{'label'};\n}\n\n\n=head2 transpos\n\n Title   : transpos\n Usage   : $obj->transpos();\n Function: \n\n            Sets and returns the transcript position of the mutation.\n            Set when associated with a reference sequence. Value\n            depends on reference molecule and the co-ordinate system\n            used.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub transpos {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ( $value !~ /^([+-])?\\d+$/ ) {\n\t    $self->throw(\"[$value] for transpos has to be an integer\\n\");\n\t} else {\n\t    $self->{'transpos'} = $value;\n\t}\n    }\n    return $self->{'transpos'};\n}\n\n\n=head2 issue\n\n Title   : issue\n Usage   : $obj->issue();\n Function: \n\n            Sets and returns the position of the mutation in an array\n            of mutations to be issued. Set after the validity of the\n            mutation has been confirmed.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub issue {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ( $value !~ /^([+-])?\\d+$/ ) {\n\t    $self->throw(\"[$value] for issue has to be an integer\\n\");\n\t} else {\n\t    $self->{'issue'} = $value;\n\t}\n    }\n    return $self->{'issue'};\n}\n\n\n=head2 prelabel\n\n Title   : prelabel\n Usage   : $obj->prelabel();\n Function: \n\n            Sets and returns the prelabel of the affected original allele\n            location. Prelabel is a stable identifier whereas location\n            can be changed by mutations. Prelabel comes from\n            l<Bio::LiveSeq::Gene>.\n\n Example : \n Returns : string\n Args    : string","parameters":[{"label":"$self"},{"label":"$value"}]},"range":{"end":{"line":358,"character":9999},"start":{"line":349,"character":0}},"kind":12,"line":349,"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"prelabel","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"prelabel","line":350,"definition":"my"},{"kind":13,"containerName":"prelabel","name":"$value","line":350},{"name":"$value","kind":13,"containerName":"prelabel","line":351},{"line":352,"containerName":"prelabel","kind":13,"name":"$self"},{"line":352,"kind":13,"containerName":"prelabel","name":"$value"},{"line":354,"name":"$self","kind":13,"containerName":"prelabel"},{"line":357,"kind":13,"containerName":"prelabel","name":"$self"}]},{"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"postlabel","children":[{"definition":"my","line":379,"name":"$self","containerName":"postlabel","localvar":"my","kind":13},{"containerName":"postlabel","kind":13,"name":"$value","line":379},{"kind":13,"containerName":"postlabel","name":"$value","line":380},{"name":"$self","containerName":"postlabel","kind":13,"line":381},{"name":"$value","containerName":"postlabel","kind":13,"line":381},{"line":383,"name":"$self","kind":13,"containerName":"postlabel"},{"line":386,"containerName":"postlabel","kind":13,"name":"$self"}],"signature":{"label":"postlabel($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Mutation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LiveSeq::Mutation\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutation - Mutation event descriptor class\n\n=head1 SYNOPSIS\n\n  # full descrition of a point mutation\n  $mutation1a = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -seqori => 'T',\n\t\t\t\t\t      -pos  => 100,\n\t\t\t\t\t      -len => 1 # optional, defaults to length(seq)\n\t\t\t\t\t     );\n\n  # minimal information for a point mutation\n  $mutation1b = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -pos  => 100\n\t\t\t\t\t      );\n  # insertion\n  $mutation2 = Bio::LiveSeq::Mutation->new ( -seq => 'ATT',\n\t\t\t\t\t     -pos  => 100,\n\t\t\t\t\t     -len => 0\n\t\t\t\t\t     );\n  # deletion\n  $mutation3 = Bio::LiveSeq::Mutation->new ( -seq => '',  # optional\n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n  # complex\n  $mutation4 = Bio::LiveSeq::Mutation->new ( -seq => 'CC', \n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n\n\n=head1 DESCRIPTION\n\nThis class describes a local mutation event using minimalistic\ndescription.  It is not necessary to know anything about the original\nsequence. You need to give the changed sequence, the position of the\nmutation in the (unidentified) reference sequence, and the length of\nthe affected subsequence in the reference sequence. If the original\nallele sequence is given, the objects applying the mutation into the\nreference sequence (e.g. L<Bio::LiveSeq::Mutator>) might check for its\nvalidity.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutation;\nuse strict;\n\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($seq, $seqori, $pos, $len, $label) =\n\t    $self->_rearrange([qw(SEQ\n\t\t\t\t  SEQORI\n\t\t\t\t  POS\n\t\t\t\t  LEN\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $seq && $self->seq($seq);\n    $seqori && $self->seqori($seqori);\n    $pos && $self->pos($pos);\n    defined($len) && $self->len($len); # defined() added otherwise won't work for len==0\n    \n    return $self; # success - we hope!\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $obj->seq();\n Function: \n\n            Sets and returns the mutated sequence. No checking is done\n            to validate the symbols.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub seq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'seq'} = $value;\n    }\n    return $self->{'seq'} || '';\n}\n\n\n=head2 seqori\n\n Title   : seqori\n Usage   : $obj->seqori();\n Function: \n\n            Sets and returns the original subsequence in the reference\n            sequence. No checking is done to validate the symbols.\n            Optional value.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub seqori {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'seqori'} = $value;\n    }\n    return $self->{'seqori'} || '';\n}\n\n\n=head2 pos\n\n Title   : pos\n Usage   : $obj->pos();\n Function: \n\n            Sets and returns the position of the first element in the\n            sequence.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub pos {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ( $value !~ /^([+-])?\\d+$/ ) {\n\t    $self->throw(\"[$value] for pos has to be an integer\\n\");\n\t} else {\n\t    $self->{'pos'} = $value;\n\t}\n    }\n    return $self->{'pos'};\n}\n\n=head2 len\n\n Title   : len\n Usage   : $obj->len();\n Function: \n\n            Sets and returns the len of the affected original allele\n            sequence.  If value is not set, defaults to the lenght of\n            the mutated sequence (seq).\n\n Example : \n Returns : string\n Args    : string\n\n\nsub len {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'len'} = $value;\n  }\n   if ( ! exists $self->{'len'} ) {\n       return length $self->{'seq'};\n   }\n   return $self->{'len'};\n}\n\n=head2 label\n\n Title   : label\n Usage   : $obj->label();\n Function: \n\n            Sets and returns the label of the affected original allele\n            location. Label is a stable identifier whereas location\n            can be changed by mutations. Label comes from\n            l<Bio::LiveSeq::Gene>.\n\n Example : \n Returns : string\n Args    : string\n\n\nsub label {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'label'} = $value;\n   }\n   if ( ! exists $self->{'label'} ) {\n       return;\n   } \n   return $self->{'label'};\n}\n\n\n=head2 transpos\n\n Title   : transpos\n Usage   : $obj->transpos();\n Function: \n\n            Sets and returns the transcript position of the mutation.\n            Set when associated with a reference sequence. Value\n            depends on reference molecule and the co-ordinate system\n            used.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub transpos {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ( $value !~ /^([+-])?\\d+$/ ) {\n\t    $self->throw(\"[$value] for transpos has to be an integer\\n\");\n\t} else {\n\t    $self->{'transpos'} = $value;\n\t}\n    }\n    return $self->{'transpos'};\n}\n\n\n=head2 issue\n\n Title   : issue\n Usage   : $obj->issue();\n Function: \n\n            Sets and returns the position of the mutation in an array\n            of mutations to be issued. Set after the validity of the\n            mutation has been confirmed.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub issue {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ( $value !~ /^([+-])?\\d+$/ ) {\n\t    $self->throw(\"[$value] for issue has to be an integer\\n\");\n\t} else {\n\t    $self->{'issue'} = $value;\n\t}\n    }\n    return $self->{'issue'};\n}\n\n\n=head2 prelabel\n\n Title   : prelabel\n Usage   : $obj->prelabel();\n Function: \n\n            Sets and returns the prelabel of the affected original allele\n            location. Prelabel is a stable identifier whereas location\n            can be changed by mutations. Prelabel comes from\n            l<Bio::LiveSeq::Gene>.\n\n Example : \n Returns : string\n Args    : string\n\n\nsub prelabel {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'prelabel'} = $value;\n   }\n   if ( ! exists $self->{'prelabel'} ) {\n       return;\n   } \n   return $self->{'prelabel'};\n}\n\n\n=head2 postlabel\n\n Title   : postlabel\n Usage   : $obj->postlabel();\n Function: \n\n            Sets and returns the postlabel of the affected original allele\n            location. Postlabel is a stable identifier whereas location\n            can be changed by mutations. Postlabel comes from\n            l<Bio::LiveSeq::Gene>.\n\n Example : \n Returns : string\n Args    : string"},"range":{"end":{"character":9999,"line":387},"start":{"character":0,"line":378}},"kind":12,"line":378},{"signature":{"label":"lastlabel($self,$value)","documentation":"1;\n# $Id: Mutation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LiveSeq::Mutation\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutation - Mutation event descriptor class\n\n=head1 SYNOPSIS\n\n  # full descrition of a point mutation\n  $mutation1a = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -seqori => 'T',\n\t\t\t\t\t      -pos  => 100,\n\t\t\t\t\t      -len => 1 # optional, defaults to length(seq)\n\t\t\t\t\t     );\n\n  # minimal information for a point mutation\n  $mutation1b = Bio::LiveSeq::Mutation->new ( -seq => 'A',\n\t\t\t\t\t      -pos  => 100\n\t\t\t\t\t      );\n  # insertion\n  $mutation2 = Bio::LiveSeq::Mutation->new ( -seq => 'ATT',\n\t\t\t\t\t     -pos  => 100,\n\t\t\t\t\t     -len => 0\n\t\t\t\t\t     );\n  # deletion\n  $mutation3 = Bio::LiveSeq::Mutation->new ( -seq => '',  # optional\n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n  # complex\n  $mutation4 = Bio::LiveSeq::Mutation->new ( -seq => 'CC', \n\t\t\t\t\t     -seqori => 'TTG',  # optional\n\t\t\t\t\t     -pos  => 100\n\t\t\t\t\t     -len => 3\n\t\t\t\t\t     );\n\n\n=head1 DESCRIPTION\n\nThis class describes a local mutation event using minimalistic\ndescription.  It is not necessary to know anything about the original\nsequence. You need to give the changed sequence, the position of the\nmutation in the (unidentified) reference sequence, and the length of\nthe affected subsequence in the reference sequence. If the original\nallele sequence is given, the objects applying the mutation into the\nreference sequence (e.g. L<Bio::LiveSeq::Mutator>) might check for its\nvalidity.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutation;\nuse strict;\n\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($seq, $seqori, $pos, $len, $label) =\n\t    $self->_rearrange([qw(SEQ\n\t\t\t\t  SEQORI\n\t\t\t\t  POS\n\t\t\t\t  LEN\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $seq && $self->seq($seq);\n    $seqori && $self->seqori($seqori);\n    $pos && $self->pos($pos);\n    defined($len) && $self->len($len); # defined() added otherwise won't work for len==0\n    \n    return $self; # success - we hope!\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $obj->seq();\n Function: \n\n            Sets and returns the mutated sequence. No checking is done\n            to validate the symbols.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub seq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'seq'} = $value;\n    }\n    return $self->{'seq'} || '';\n}\n\n\n=head2 seqori\n\n Title   : seqori\n Usage   : $obj->seqori();\n Function: \n\n            Sets and returns the original subsequence in the reference\n            sequence. No checking is done to validate the symbols.\n            Optional value.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub seqori {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'seqori'} = $value;\n    }\n    return $self->{'seqori'} || '';\n}\n\n\n=head2 pos\n\n Title   : pos\n Usage   : $obj->pos();\n Function: \n\n            Sets and returns the position of the first element in the\n            sequence.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub pos {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ( $value !~ /^([+-])?\\d+$/ ) {\n\t    $self->throw(\"[$value] for pos has to be an integer\\n\");\n\t} else {\n\t    $self->{'pos'} = $value;\n\t}\n    }\n    return $self->{'pos'};\n}\n\n=head2 len\n\n Title   : len\n Usage   : $obj->len();\n Function: \n\n            Sets and returns the len of the affected original allele\n            sequence.  If value is not set, defaults to the lenght of\n            the mutated sequence (seq).\n\n Example : \n Returns : string\n Args    : string\n\n\nsub len {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'len'} = $value;\n  }\n   if ( ! exists $self->{'len'} ) {\n       return length $self->{'seq'};\n   }\n   return $self->{'len'};\n}\n\n=head2 label\n\n Title   : label\n Usage   : $obj->label();\n Function: \n\n            Sets and returns the label of the affected original allele\n            location. Label is a stable identifier whereas location\n            can be changed by mutations. Label comes from\n            l<Bio::LiveSeq::Gene>.\n\n Example : \n Returns : string\n Args    : string\n\n\nsub label {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'label'} = $value;\n   }\n   if ( ! exists $self->{'label'} ) {\n       return;\n   } \n   return $self->{'label'};\n}\n\n\n=head2 transpos\n\n Title   : transpos\n Usage   : $obj->transpos();\n Function: \n\n            Sets and returns the transcript position of the mutation.\n            Set when associated with a reference sequence. Value\n            depends on reference molecule and the co-ordinate system\n            used.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub transpos {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ( $value !~ /^([+-])?\\d+$/ ) {\n\t    $self->throw(\"[$value] for transpos has to be an integer\\n\");\n\t} else {\n\t    $self->{'transpos'} = $value;\n\t}\n    }\n    return $self->{'transpos'};\n}\n\n\n=head2 issue\n\n Title   : issue\n Usage   : $obj->issue();\n Function: \n\n            Sets and returns the position of the mutation in an array\n            of mutations to be issued. Set after the validity of the\n            mutation has been confirmed.\n\n Example : \n Returns : string\n Args    : integer\n\n\n\nsub issue {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ( $value !~ /^([+-])?\\d+$/ ) {\n\t    $self->throw(\"[$value] for issue has to be an integer\\n\");\n\t} else {\n\t    $self->{'issue'} = $value;\n\t}\n    }\n    return $self->{'issue'};\n}\n\n\n=head2 prelabel\n\n Title   : prelabel\n Usage   : $obj->prelabel();\n Function: \n\n            Sets and returns the prelabel of the affected original allele\n            location. Prelabel is a stable identifier whereas location\n            can be changed by mutations. Prelabel comes from\n            l<Bio::LiveSeq::Gene>.\n\n Example : \n Returns : string\n Args    : string\n\n\nsub prelabel {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'prelabel'} = $value;\n   }\n   if ( ! exists $self->{'prelabel'} ) {\n       return;\n   } \n   return $self->{'prelabel'};\n}\n\n\n=head2 postlabel\n\n Title   : postlabel\n Usage   : $obj->postlabel();\n Function: \n\n            Sets and returns the postlabel of the affected original allele\n            location. Postlabel is a stable identifier whereas location\n            can be changed by mutations. Postlabel comes from\n            l<Bio::LiveSeq::Gene>.\n\n Example : \n Returns : string\n Args    : string\n\n\nsub postlabel {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'postlabel'} = $value;\n   }\n   if ( ! exists $self->{'postlabel'} ) {\n       return;\n   } \n   return $self->{'postlabel'};\n}\n\n\n=head2 lastlabel\n\n Title   : lastlabel\n Usage   : $obj->lastlabel();\n Function: \n\n            Sets and returns the lastlabel of the affected original allele\n            location. Lastlabel is a stable identifier whereas location\n            can be changed by mutations. Lastlabel comes from\n            l<Bio::LiveSeq::Gene>.\n\n Example : \n Returns : string\n Args    : string","parameters":[{"label":"$self"},{"label":"$value"}]},"kind":12,"range":{"start":{"character":0,"line":407},"end":{"line":416,"character":9999}},"line":407,"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"lastlabel","children":[{"line":408,"containerName":"lastlabel","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":408,"name":"$value","kind":13,"containerName":"lastlabel"},{"line":409,"kind":13,"containerName":"lastlabel","name":"$value"},{"line":410,"kind":13,"containerName":"lastlabel","name":"$self"},{"name":"$value","containerName":"lastlabel","kind":13,"line":410},{"name":"$self","containerName":"lastlabel","kind":13,"line":412},{"containerName":"lastlabel","kind":13,"name":"$self","line":415}]}]}