{"vars":[{"name":"base","kind":2,"containerName":"","line":120},{"definition":"sub","name":"_type_stamp","containerName":"main::","children":[],"kind":12,"range":{"start":{"character":0,"line":122},"end":{"line":124,"character":9999}},"line":122},{"range":{"end":{"character":9999,"line":128},"start":{"line":126,"character":0}},"kind":12,"line":126,"name":"_version","containerName":"main::","children":[],"definition":"sub"},{"signature":{"label":"_index_file($self,$file,$i)","parameters":[{"label":"$self"},{"label":"$file"},{"label":"$i"}],"documentation":"__END__\n# $Id: Swissprot.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::Swissprot\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::Swissprot - Interface for indexing one or more\nSwissprot files.\n\n=head1 SYNOPSIS\n\n  # Make an index for one or more Swissprot files:\n\n    use Bio::Index::Swissprot;\n    use strict;\n\n    my $index_file_name = shift;\n    my $inx = Bio::Index::Swissprot->new(\n        -filename => $index_file_name,\n        -write_flag => 1);\n    $inx->make_index(@ARGV);\n\n  # Print out several sequences present in the index in Genbank\n  # format:\n\n    use Bio::Index::Swissprot;\n    use Bio::SeqIO;\n    use strict;\n\n    my $out = Bio::SeqIO->new( -format => 'genbank',\n                               -fh => \\*STDOUT );\n    my $index_file_name = shift;\n    my $inx = Bio::Index::Swissprot->new(-filename => $index_file_name);\n\n    foreach my $id (@ARGV) {\n        my $seq = $inx->fetch($id); # Returns a Bio::Seq object\n        $out->write_seq($seq);\n    }\n\n    # alternatively\n    my ($id, $acc);\n    my $seq1 = $inx->get_Seq_by_id($id);\n    my $seq2 = $inx->get_Seq_by_acc($acc);\n\n=head1 DESCRIPTION\n\nBy default the index that is created uses the AC and ID identifiers\nas keys. This module inherits functions for managing dbm files from \nBio::Index::Abstract.pm, and provides the basic functionality \nfor indexing Swissprot files and retrieving Sequence objects from \nthem. For best results 'use strict'.\n\nYou can also set or customize the unique key used to retrieve by \nwriting your own function and calling the id_parser() method.\nFor example:\n\n   $inx->id_parser(\\&get_id);\n   # make the index\n   $inx->make_index($index_file_name);\n\n   # here is where the retrieval key is specified\n   sub get_id {\n      my $line = shift;\n      $line =~ /^KW\\s+([A-Z]+)/i;\n      $1;\n   }\n\n=head1 FEED_BACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nAlso lorenz@ist.org, bosborne at alum.mit.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n# Let's begin the code...\n\npackage Bio::Index::Swissprot;\n\nuse strict;\n\nuse Bio::Seq;\n\nuse base qw(Bio::Index::AbstractSeq);\n\nsub _type_stamp {\n\treturn '__Swissprot_FLAT__'; # What kind of index are we?\n}\n\nsub _version {\n\treturn 0.1;\n}\n\n=head2 _index_file\n\n  Title   : _index_file\n  Usage   : $index->_index_file( $file_name, $i )\n  Function: Specialist function to index Swissprot format files.\n            Is provided with a filename and an integer\n            by make_index in its SUPER class.\n  Example : \n  Returns : \n  Args    : "},"range":{"end":{"character":9999,"line":170},"start":{"character":0,"line":143}},"kind":12,"line":143,"detail":"($self,$file,$i)","definition":"sub","name":"_index_file","containerName":"main::","children":[{"localvar":"my","containerName":"_index_file","kind":13,"name":"$self","line":145,"definition":"my"},{"kind":13,"containerName":"_index_file","name":"$file","line":145},{"line":145,"name":"$i","containerName":"_index_file","kind":13},{"definition":"my","line":148,"containerName":"_index_file","localvar":"my","kind":13,"name":"$begin"},{"name":"$id_parser","containerName":"_index_file","localvar":"my","kind":13,"line":150,"definition":"my"},{"line":150,"name":"$self","kind":13,"containerName":"_index_file"},{"line":150,"name":"id_parser","containerName":"_index_file","kind":12},{"line":152,"kind":13,"localvar":"my","containerName":"_index_file","name":"$SWISSPROT","definition":"my"},{"line":152,"name":"$file","kind":13,"containerName":"_index_file"},{"line":152,"name":"$self","kind":13,"containerName":"_index_file"},{"kind":12,"containerName":"_index_file","name":"throw","line":152},{"containerName":"_index_file","localvar":"my","kind":13,"name":"%done_ids","line":154,"definition":"my"},{"line":155,"containerName":"_index_file","kind":13,"name":"$SWISSPROT"},{"name":"$begin","kind":13,"containerName":"_index_file","line":157},{"containerName":"_index_file","kind":13,"name":"$SWISSPROT","line":157},{"definition":"my","line":159,"name":"$id","localvar":"my","kind":13,"containerName":"_index_file"},{"line":160,"name":"$done_ids","kind":13,"containerName":"_index_file"},{"name":"$id","kind":13,"containerName":"_index_file","line":160},{"line":161,"name":"$self","containerName":"_index_file","kind":13},{"kind":12,"containerName":"_index_file","name":"add_record","line":161},{"name":"$id","kind":13,"containerName":"_index_file","line":161},{"line":161,"kind":13,"containerName":"_index_file","name":"$i"},{"containerName":"_index_file","kind":13,"name":"$begin","line":161},{"containerName":"_index_file","kind":13,"name":"$id","line":161},{"line":162,"name":"$done_ids","kind":13,"containerName":"_index_file"},{"kind":13,"containerName":"_index_file","name":"$id","line":162},{"kind":13,"containerName":"_index_file","name":"%done_ids","line":165},{"line":168,"kind":13,"containerName":"_index_file","name":"$SWISSPROT"}]},{"line":159,"kind":12,"name":"id_parser"},{"line":187,"kind":12,"range":{"end":{"line":194,"character":9999},"start":{"line":187,"character":0}},"signature":{"label":"id_parser($self,$code)","parameters":[{"label":"$self"},{"label":"$code"}],"documentation":"__END__\n# $Id: Swissprot.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::Swissprot\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::Swissprot - Interface for indexing one or more\nSwissprot files.\n\n=head1 SYNOPSIS\n\n  # Make an index for one or more Swissprot files:\n\n    use Bio::Index::Swissprot;\n    use strict;\n\n    my $index_file_name = shift;\n    my $inx = Bio::Index::Swissprot->new(\n        -filename => $index_file_name,\n        -write_flag => 1);\n    $inx->make_index(@ARGV);\n\n  # Print out several sequences present in the index in Genbank\n  # format:\n\n    use Bio::Index::Swissprot;\n    use Bio::SeqIO;\n    use strict;\n\n    my $out = Bio::SeqIO->new( -format => 'genbank',\n                               -fh => \\*STDOUT );\n    my $index_file_name = shift;\n    my $inx = Bio::Index::Swissprot->new(-filename => $index_file_name);\n\n    foreach my $id (@ARGV) {\n        my $seq = $inx->fetch($id); # Returns a Bio::Seq object\n        $out->write_seq($seq);\n    }\n\n    # alternatively\n    my ($id, $acc);\n    my $seq1 = $inx->get_Seq_by_id($id);\n    my $seq2 = $inx->get_Seq_by_acc($acc);\n\n=head1 DESCRIPTION\n\nBy default the index that is created uses the AC and ID identifiers\nas keys. This module inherits functions for managing dbm files from \nBio::Index::Abstract.pm, and provides the basic functionality \nfor indexing Swissprot files and retrieving Sequence objects from \nthem. For best results 'use strict'.\n\nYou can also set or customize the unique key used to retrieve by \nwriting your own function and calling the id_parser() method.\nFor example:\n\n   $inx->id_parser(\\&get_id);\n   # make the index\n   $inx->make_index($index_file_name);\n\n   # here is where the retrieval key is specified\n   sub get_id {\n      my $line = shift;\n      $line =~ /^KW\\s+([A-Z]+)/i;\n      $1;\n   }\n\n=head1 FEED_BACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nAlso lorenz@ist.org, bosborne at alum.mit.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n# Let's begin the code...\n\npackage Bio::Index::Swissprot;\n\nuse strict;\n\nuse Bio::Seq;\n\nuse base qw(Bio::Index::AbstractSeq);\n\nsub _type_stamp {\n\treturn '__Swissprot_FLAT__'; # What kind of index are we?\n}\n\nsub _version {\n\treturn 0.1;\n}\n\n=head2 _index_file\n\n  Title   : _index_file\n  Usage   : $index->_index_file( $file_name, $i )\n  Function: Specialist function to index Swissprot format files.\n            Is provided with a filename and an integer\n            by make_index in its SUPER class.\n  Example : \n  Returns : \n  Args    : \n\n\nsub _index_file {\n\t# $file is file name, $i is number of file being indexed\n\tmy( $self, $file, $i ) = @_;\n\n\t# Offset from start of file\n\tmy $begin = 0;\n\n\tmy $id_parser = $self->id_parser;\n\n\topen my $SWISSPROT,'<',$file or $self->throw(\"Can't read file: $file\");\n    \n        my %done_ids;\n\twhile (<$SWISSPROT>) {\n\t\tif (/^ID\\s+\\S+/) {\n\t\t\t$begin = tell($SWISSPROT) - length( $_ );\n\t\t}\n\t\tfor my $id (&$id_parser($_)) {\n                        next if exists $done_ids{$id};\n  \t\t\t$self->add_record($id, $i, $begin) if $id;\n                        $done_ids{$id} = 1;\n\t\t}\n        if (m{//}) {\n            %done_ids = ();\n        }\n\t}\n\tclose $SWISSPROT;\n\treturn 1;\n}\n\n=head2 id_parser\n\n  Title   : id_parser\n  Usage   : $index->id_parser( CODE )\n  Function: Stores or returns the code used by record_id to\n            parse the ID for record from a string.\n            Returns \\&default_id_parser (see below) if not\n            set. An entry will be added to\n            the index for each string in the list returned.\n  Example : $index->id_parser( \\&my_id_parser )\n  Returns : ref to CODE if called without arguments\n  Args    : CODE"},"children":[{"line":188,"name":"$self","localvar":"my","kind":13,"containerName":"id_parser","definition":"my"},{"line":188,"name":"$code","kind":13,"containerName":"id_parser"},{"kind":13,"containerName":"id_parser","name":"$code","line":190},{"line":191,"name":"$self","kind":13,"containerName":"id_parser"},{"line":191,"containerName":"id_parser","kind":13,"name":"$code"},{"name":"$self","containerName":"id_parser","kind":13,"line":193}],"name":"id_parser","containerName":"main::","definition":"sub","detail":"($self,$code)"},{"line":193,"name":"default_id_parser","kind":12},{"definition":"sub","children":[{"definition":"my","line":209,"localvar":"my","containerName":"default_id_parser","kind":13,"name":"$line"},{"containerName":"default_id_parser","kind":13,"name":"$line","line":210},{"line":213,"name":"$line","kind":13,"containerName":"default_id_parser"}],"name":"default_id_parser","containerName":"main::","line":208,"range":{"end":{"line":216,"character":9999},"start":{"character":0,"line":208}},"kind":12},{"definition":"sub","name":"_file_format","containerName":"main::","children":[],"range":{"end":{"line":232,"character":9999},"start":{"line":230,"character":0}},"kind":12,"line":230}],"version":5}