{"version":5,"vars":[{"kind":2,"containerName":"","name":"vars","line":92},{"containerName":"","kind":2,"name":"base","line":102},{"kind":13,"containerName":null,"name":"$LOCREG","line":106},{"signature":{"parameters":[{"label":"$self"},{"label":"$locstr"},{"label":"$op"}],"documentation":"1;\n# $Id: FTLocationFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Factory::FTLocationFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n#\n# (c) Hilmar Lapp, hlapp at gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Factory::FTLocationFactory - A FeatureTable Location Parser\n\n=head1 SYNOPSIS\n\n    # parse a string into a location object\n    $loc = Bio::Factory::FTLocationFactory->from_string(\"join(100..200, \n                                                         400..500\");\n\n=head1 DESCRIPTION\n\nImplementation of string-encoded location parsing for the Genbank feature\ntable encoding of locations.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl-dot-org\nChris Fields, cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Factory::FTLocationFactory;\nuse vars qw($LOCREG);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Location::Simple;\nuse Bio::Location::Split;\nuse Bio::Location::Fuzzy;\n\n\nuse base qw(Bio::Root::Root Bio::Factory::LocationFactoryI);\n\nBEGIN {\n    # the below is an optimized regex obj. from J. Freidl's Mastering Reg Exp.\n    $LOCREG = qr{\n                (?>\n                [^()]+\n                |\n                \\(\n                (??{$LOCREG})\n                \\)\n                )*\n                }x;     \n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Factory::FTLocationFactory->new();\n Function: Builds a new Bio::Factory::FTLocationFactory object \n Returns : an instance of Bio::Factory::FTLocationFactory\n Args    :\n\n\n=head2 from_string\n\n Title   : from_string\n Usage   : $loc = $locfactory->from_string(\"100..200\");\n Function: Parses the given string and returns a Bio::LocationI implementing\n           object representing the location encoded by the string.\n\n           This implementation parses the Genbank feature table\n           encoding of locations.\n Example :\n Returns : A Bio::LocationI implementing object.\n Args    : A string.","label":"from_string($self,$locstr,$op)"},"line":142,"kind":12,"range":{"end":{"character":9999,"line":228},"start":{"character":0,"line":142}},"definition":"sub","detail":"($self,$locstr,$op)","children":[{"definition":"my","line":143,"containerName":"from_string","localvar":"my","kind":13,"name":"$self"},{"line":143,"name":"$locstr","containerName":"from_string","kind":13},{"containerName":"from_string","kind":13,"name":"$op","line":143},{"definition":"my","kind":13,"localvar":"my","containerName":"from_string","name":"$loc","line":144},{"name":"$op","containerName":"from_string","kind":13,"line":152},{"line":154,"name":"$locstr","containerName":"from_string","kind":13},{"line":157,"name":"$locstr","containerName":"from_string","kind":13},{"line":160,"kind":13,"containerName":"from_string","name":"$locstr"},{"line":162,"kind":13,"localvar":"my","containerName":"from_string","name":"$beg","definition":"my"},{"line":162,"name":"$mid","kind":13,"containerName":"from_string"},{"name":"$end","kind":13,"containerName":"from_string","line":162},{"line":163,"name":"@sublocs","kind":13,"localvar":"my","containerName":"from_string","definition":"my"},{"line":163,"name":"$beg","kind":13,"containerName":"from_string"},{"line":163,"containerName":"from_string","kind":13,"name":"$mid"},{"kind":13,"containerName":"from_string","name":"$end","line":163},{"definition":"my","name":"@loc_objs","kind":13,"localvar":"my","containerName":"from_string","line":165},{"line":166,"name":"$loc_obj","containerName":"from_string","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"from_string","name":"@sublocs","line":169},{"line":170,"kind":13,"localvar":"my","containerName":"from_string","name":"$subloc","definition":"my"},{"containerName":"from_string","kind":13,"name":"@sublocs","line":170},{"kind":13,"containerName":"from_string","name":"$subloc","line":171},{"definition":"my","line":172,"name":"$oparg","localvar":"my","kind":13,"containerName":"from_string"},{"line":172,"name":"$subloc","containerName":"from_string","kind":13},{"line":172,"name":"$subloc","containerName":"from_string","kind":13},{"name":"$subloc","containerName":"from_string","kind":13,"line":173},{"line":173,"name":"$subloc","containerName":"from_string","kind":13},{"line":173,"kind":13,"containerName":"from_string","name":"$subloc"},{"containerName":"from_string","kind":13,"name":"$oparg","line":175},{"line":176,"localvar":"my","kind":13,"containerName":"from_string","name":"$sub","definition":"my"},{"name":"@sublocs","kind":13,"containerName":"from_string","line":176},{"line":178,"name":"$oparg","kind":13,"containerName":"from_string"},{"line":178,"name":"$oparg","containerName":"from_string","kind":13},{"name":"$oparg","kind":13,"containerName":"from_string","line":178},{"line":179,"name":"$sub","kind":13,"containerName":"from_string"},{"definition":"my","line":180,"name":"@splitlocs","kind":13,"localvar":"my","containerName":"from_string"},{"line":180,"name":"$sub","kind":13,"containerName":"from_string"},{"line":181,"name":"$loc_obj","containerName":"from_string","kind":13},{"line":181,"kind":12,"containerName":"from_string","name":"new"},{"line":182,"name":"$oparg","kind":13,"containerName":"from_string"},{"name":"$splitloc","kind":13,"localvar":"my","containerName":"from_string","line":183,"definition":"my"},{"line":183,"containerName":"from_string","kind":13,"name":"@splitlocs"},{"name":"$splitloc","kind":13,"containerName":"from_string","line":184},{"definition":"my","kind":13,"localvar":"my","containerName":"from_string","name":"$sobj","line":185},{"containerName":"from_string","kind":13,"name":"$splitloc","line":186},{"definition":"my","localvar":"my","kind":13,"containerName":"from_string","name":"$comploc","line":187},{"name":"$sobj","kind":13,"containerName":"from_string","line":188},{"kind":13,"containerName":"from_string","name":"$self","line":188},{"line":188,"kind":12,"containerName":"from_string","name":"_parse_location"},{"line":188,"containerName":"from_string","kind":13,"name":"$comploc"},{"name":"$sobj","containerName":"from_string","kind":13,"line":189},{"line":189,"name":"strand","kind":12,"containerName":"from_string"},{"name":"$sobj","containerName":"from_string","kind":13,"line":191},{"line":191,"containerName":"from_string","kind":13,"name":"$self"},{"name":"_parse_location","containerName":"from_string","kind":12,"line":191},{"line":191,"name":"$splitloc","kind":13,"containerName":"from_string"},{"line":193,"name":"$loc_obj","kind":13,"containerName":"from_string"},{"line":193,"name":"add_sub_Location","containerName":"from_string","kind":12},{"line":193,"containerName":"from_string","kind":13,"name":"$sobj"},{"line":196,"containerName":"from_string","kind":13,"name":"$loc_obj"},{"line":196,"kind":13,"containerName":"from_string","name":"$self"},{"kind":12,"containerName":"from_string","name":"from_string","line":196},{"kind":13,"containerName":"from_string","name":"$sub","line":196},{"name":"$oparg","kind":13,"containerName":"from_string","line":196},{"line":199,"kind":13,"containerName":"from_string","name":"$loc_obj"},{"line":199,"kind":12,"containerName":"from_string","name":"splittype"},{"kind":13,"containerName":"from_string","name":"$oparg","line":199},{"name":"$oparg","kind":13,"containerName":"from_string","line":199},{"line":204,"containerName":"from_string","kind":13,"name":"$loc_obj"},{"name":"$self","kind":13,"containerName":"from_string","line":204},{"line":204,"kind":12,"containerName":"from_string","name":"from_string"},{"name":"$subloc","kind":13,"containerName":"from_string","line":204},{"line":206,"name":"$loc_obj","containerName":"from_string","kind":13},{"line":206,"name":"strand","kind":12,"containerName":"from_string"},{"line":206,"name":"$op","kind":13,"containerName":"from_string"},{"line":206,"kind":13,"containerName":"from_string","name":"$op"},{"kind":13,"containerName":"from_string","name":"@loc_objs","line":207},{"containerName":"from_string","kind":13,"name":"$loc_obj","line":207},{"kind":13,"localvar":"my","containerName":"from_string","name":"$ct","line":209,"definition":"my"},{"line":209,"containerName":"from_string","kind":13,"name":"@loc_objs"},{"line":210,"containerName":"from_string","kind":13,"name":"$op"},{"name":"$op","containerName":"from_string","kind":13,"line":210},{"line":210,"containerName":"from_string","kind":13,"name":"$op"},{"name":"$op","containerName":"from_string","kind":13,"line":210},{"line":211,"name":"$ct","kind":13,"containerName":"from_string"},{"line":212,"name":"$self","containerName":"from_string","kind":13},{"line":212,"name":"throw","kind":12,"containerName":"from_string"},{"line":213,"containerName":"from_string","kind":13,"name":"@loc_objs"},{"line":215,"kind":13,"containerName":"from_string","name":"$ct"},{"kind":13,"containerName":"from_string","name":"$loc","line":216},{"name":"new","kind":12,"containerName":"from_string","line":216},{"kind":13,"containerName":"from_string","name":"$loc","line":217},{"kind":12,"containerName":"from_string","name":"add_sub_Location","line":217},{"name":"@loc_objs","kind":13,"containerName":"from_string","line":217},{"line":217,"kind":13,"containerName":"from_string","name":"@loc_objs"},{"line":218,"containerName":"from_string","kind":13,"name":"$loc"},{"line":220,"name":"$loc","containerName":"from_string","kind":13},{"name":"@loc_objs","kind":13,"containerName":"from_string","line":220},{"line":221,"name":"$loc","kind":13,"containerName":"from_string"},{"line":224,"name":"$loc","kind":13,"containerName":"from_string"},{"kind":13,"containerName":"from_string","name":"$self","line":224},{"line":224,"containerName":"from_string","kind":12,"name":"_parse_location"},{"kind":13,"containerName":"from_string","name":"$locstr","line":224},{"name":"$loc","kind":13,"containerName":"from_string","line":225},{"kind":12,"containerName":"from_string","name":"strand","line":225},{"name":"$op","containerName":"from_string","kind":13,"line":225},{"name":"$op","kind":13,"containerName":"from_string","line":225},{"line":227,"containerName":"from_string","kind":13,"name":"$loc"}],"name":"from_string","containerName":"main::"},{"kind":12,"name":"SUBLOCS","line":168},{"line":181,"name":"Bio","containerName":"Location::Split","kind":12},{"containerName":"Location::Split","kind":12,"name":"Bio","line":216},{"name":"_parse_location","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"_parse_location","name":"$self","line":244,"definition":"my"},{"line":244,"containerName":"_parse_location","kind":13,"name":"$locstr"},{"name":"$loc","kind":13,"localvar":"my","containerName":"_parse_location","line":245,"definition":"my"},{"line":245,"containerName":"_parse_location","kind":13,"name":"$seqid"},{"line":248,"name":"$locstr","containerName":"_parse_location","kind":13},{"line":250,"name":"$seqid","containerName":"_parse_location","kind":13},{"line":251,"kind":13,"containerName":"_parse_location","name":"$locstr"},{"line":255,"kind":13,"localvar":"my","containerName":"_parse_location","name":"$start","definition":"my"},{"name":"$end","kind":13,"containerName":"_parse_location","line":255},{"kind":13,"containerName":"_parse_location","name":"$locstr","line":255},{"name":"$start","kind":13,"containerName":"_parse_location","line":260},{"line":260,"name":"$start","kind":13,"containerName":"_parse_location"},{"line":261,"kind":13,"containerName":"_parse_location","name":"$end"},{"name":"$end","containerName":"_parse_location","kind":13,"line":261},{"kind":13,"localvar":"my","containerName":"_parse_location","name":"$loctype","line":265,"definition":"my"},{"name":"$loctype","kind":13,"containerName":"_parse_location","line":267},{"containerName":"_parse_location","kind":13,"name":"$locstr","line":267},{"name":"$locstr","kind":13,"containerName":"_parse_location","line":267},{"definition":"my","line":269,"name":"$locclass","kind":13,"localvar":"my","containerName":"_parse_location"},{"kind":13,"containerName":"_parse_location","name":"$end","line":270},{"name":"$locstr","containerName":"_parse_location","kind":13,"line":271},{"kind":13,"containerName":"_parse_location","name":"$start","line":272},{"name":"$end","kind":13,"containerName":"_parse_location","line":273},{"name":"$loctype","containerName":"_parse_location","kind":13,"line":274},{"containerName":"_parse_location","kind":13,"name":"$locclass","line":275},{"containerName":"_parse_location","kind":13,"name":"$end","line":276},{"line":276,"kind":13,"containerName":"_parse_location","name":"$start"},{"name":"$loctype","kind":13,"containerName":"_parse_location","line":276},{"line":278,"name":"$end","containerName":"_parse_location","kind":13},{"name":"$start","containerName":"_parse_location","kind":13,"line":278},{"line":284,"name":"$start_num","localvar":"my","containerName":"_parse_location","kind":13,"definition":"my"},{"line":284,"kind":13,"containerName":"_parse_location","name":"$end_num"},{"kind":13,"containerName":"_parse_location","name":"$start","line":284},{"containerName":"_parse_location","kind":13,"name":"$end","line":284},{"line":285,"name":"$start","containerName":"_parse_location","kind":13},{"kind":13,"containerName":"_parse_location","name":"$end","line":285},{"kind":13,"containerName":"_parse_location","name":"$locclass","line":286},{"containerName":"_parse_location","kind":13,"name":"$start","line":287},{"containerName":"_parse_location","kind":13,"name":"$start_num","line":288},{"containerName":"_parse_location","kind":13,"name":"$start_num","line":290},{"kind":13,"containerName":"_parse_location","name":"$end","line":292},{"containerName":"_parse_location","kind":13,"name":"$end_num","line":293},{"line":294,"containerName":"_parse_location","kind":13,"name":"$end_num"},{"line":296,"localvar":"my","kind":13,"containerName":"_parse_location","name":"$strand","definition":"my"},{"containerName":"_parse_location","kind":13,"name":"$start_num","line":298},{"name":"$end_num","kind":13,"containerName":"_parse_location","line":298},{"containerName":"_parse_location","kind":13,"name":"$loctype","line":298},{"name":"$start","containerName":"_parse_location","kind":13,"line":299},{"name":"$end","kind":13,"containerName":"_parse_location","line":299},{"line":299,"kind":13,"containerName":"_parse_location","name":"$strand"},{"name":"$end","kind":13,"containerName":"_parse_location","line":299},{"kind":13,"containerName":"_parse_location","name":"$start","line":299},{"line":302,"containerName":"_parse_location","kind":13,"name":"$loc"},{"name":"$locclass","kind":13,"containerName":"_parse_location","line":302},{"line":302,"kind":12,"containerName":"_parse_location","name":"new"},{"line":302,"kind":13,"containerName":"_parse_location","name":"$self"},{"line":302,"name":"verbose","containerName":"_parse_location","kind":12},{"kind":13,"containerName":"_parse_location","name":"$start","line":303},{"containerName":"_parse_location","kind":13,"name":"$end","line":304},{"containerName":"_parse_location","kind":13,"name":"$strand","line":305},{"line":306,"name":"$loctype","kind":13,"containerName":"_parse_location"},{"line":308,"kind":13,"containerName":"_parse_location","name":"$seqid"},{"containerName":"_parse_location","kind":13,"name":"$loc","line":309},{"containerName":"_parse_location","kind":12,"name":"is_remote","line":309},{"name":"$loc","containerName":"_parse_location","kind":13,"line":310},{"kind":12,"containerName":"_parse_location","name":"seq_id","line":310},{"kind":13,"containerName":"_parse_location","name":"$seqid","line":310},{"line":314,"kind":13,"containerName":"_parse_location","name":"$loc"}],"detail":"($self,$locstr)","definition":"sub","range":{"end":{"character":9999,"line":315},"start":{"character":0,"line":243}},"kind":12,"line":243,"signature":{"label":"_parse_location($self,$locstr)","parameters":[{"label":"$self"},{"label":"$locstr"}],"documentation":"1;\n# $Id: FTLocationFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Factory::FTLocationFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n#\n# (c) Hilmar Lapp, hlapp at gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Factory::FTLocationFactory - A FeatureTable Location Parser\n\n=head1 SYNOPSIS\n\n    # parse a string into a location object\n    $loc = Bio::Factory::FTLocationFactory->from_string(\"join(100..200, \n                                                         400..500\");\n\n=head1 DESCRIPTION\n\nImplementation of string-encoded location parsing for the Genbank feature\ntable encoding of locations.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl-dot-org\nChris Fields, cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Factory::FTLocationFactory;\nuse vars qw($LOCREG);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Location::Simple;\nuse Bio::Location::Split;\nuse Bio::Location::Fuzzy;\n\n\nuse base qw(Bio::Root::Root Bio::Factory::LocationFactoryI);\n\nBEGIN {\n    # the below is an optimized regex obj. from J. Freidl's Mastering Reg Exp.\n    $LOCREG = qr{\n                (?>\n                [^()]+\n                |\n                \\(\n                (??{$LOCREG})\n                \\)\n                )*\n                }x;     \n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Factory::FTLocationFactory->new();\n Function: Builds a new Bio::Factory::FTLocationFactory object \n Returns : an instance of Bio::Factory::FTLocationFactory\n Args    :\n\n\n=head2 from_string\n\n Title   : from_string\n Usage   : $loc = $locfactory->from_string(\"100..200\");\n Function: Parses the given string and returns a Bio::LocationI implementing\n           object representing the location encoded by the string.\n\n           This implementation parses the Genbank feature table\n           encoding of locations.\n Example :\n Returns : A Bio::LocationI implementing object.\n Args    : A string.\n\n\nsub from_string {\n    my ($self,$locstr,$op) = @_;\n    my $loc;\n    \n    #$self->debug(\"$locstr\\n\");\n    \n    # $op for operator (error handling)\n    \n    # run on first pass only\n    # Note : These location types are now deprecated in GenBank (Oct. 2006)\n    if (!defined($op)) {\n        # convert all (X.Y) to [X.Y]\n        $locstr =~ s{\\((\\d+\\.\\d+)\\)}{\\[$1\\]}g;\n        # convert ABC123:(X..Y) to ABC123:[X..Y]\n        # we should never see the above\n        $locstr =~ s{:\\((\\d+\\.{2}\\d+)\\)}{:\\[$1\\]}g;\n    }\n    \n    if ($locstr =~ m{(.*?)\\(($LOCREG)\\)(.*)}o) { # any matching parentheses?\n\n        my ($beg, $mid, $end) = ($1, $2, $3);\n        my (@sublocs) = (split(q(,),$beg), $mid, split(q(,),$end));\n        \n        my @loc_objs;\n        my $loc_obj;\n        \n        SUBLOCS:\n        while (@sublocs) {\n            my $subloc = shift @sublocs;\n            next if !$subloc;\n            my $oparg = ($subloc eq 'join'   || $subloc eq 'bond' ||\n                         $subloc eq 'order'  || $subloc eq 'complement') ? $subloc : undef;\n            # has operator, requires further work (recurse)\n            if ($oparg) {\n                my $sub = shift @sublocs;\n                # simple split operators (no recursive calls needed)\n                if (($oparg eq 'join' || $oparg eq 'order' || $oparg eq 'bond' )\n                     && $sub !~ m{(?:join|order|bond)}) {\n                    my @splitlocs = split(q(,), $sub);\n                    $loc_obj = Bio::Location::Split->new(-verbose => 1,\n                                                         -splittype => $oparg);\n                    while (my $splitloc = shift @splitlocs) {\n                        next unless $splitloc;\n                        my $sobj;\n                        if ($splitloc =~ m{\\(($LOCREG)\\)}) {\n                            my $comploc = $1;\n                            $sobj = $self->_parse_location($comploc);\n                            $sobj->strand(-1);\n                        } else {\n                            $sobj = $self->_parse_location($splitloc);\n                        }\n                        $loc_obj->add_sub_Location($sobj);\n                    }\n                } else {\n                    $loc_obj = $self->from_string($sub, $oparg);\n                    # reinsure the operator is set correctly for this level\n                    # unless it is complement\n                    $loc_obj->splittype($oparg) unless $oparg eq 'complement';\n                }\n            }\n            # no operator, simple or fuzzy \n            else {\n                $loc_obj = $self->from_string($subloc,1);\n            }\n            $loc_obj->strand(-1) if ($op && $op eq 'complement');\n            push @loc_objs, $loc_obj;\n        }\n        my $ct = @loc_objs;\n        if ($op && !($op eq 'join' || $op eq 'order' || $op eq 'bond')\n                && $ct > 1 ) {\n            $self->throw(\"Bad operator $op: had multiple locations \".\n                         scalar(@loc_objs).\", should be SplitLocationI\");\n        }\n        if ($ct > 1) {\n            $loc = Bio::Location::Split->new();\n            $loc->add_sub_Location(shift @loc_objs) while (@loc_objs);\n            return $loc;\n        } else {\n            $loc = shift @loc_objs;\n            return $loc;\n        }\n    } else { # simple location(s)\n        $loc = $self->_parse_location($locstr);\n        $loc->strand(-1) if ($op && $op eq 'complement');\n    }\n    return $loc;\n}\n\n=head2 _parse_location\n\n Title   : _parse_location\n Usage   : $loc = $locfactory->_parse_location( $loc_string)\n\n Function: Parses the given location string and returns a location object \n           with start() and end() and strand() set appropriately.\n           Note that this method is private.\n Returns : A Bio::LocationI implementing object or undef on failure\n Args    : location string"}}]}