{"vars":[{"line":95,"kind":2,"containerName":"","name":"base"},{"signature":{"label":"new($caller,@args)","parameters":[{"label":"$caller"},{"label":"@args"}],"documentation":"1;\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::IO\n#\n#   based on the Bio::SeqIO module\n#       by Ewan Birney <birney@ebi.ac.uk>\n#       and Lincoln Stein  <lstein@cshl.org>\n#\n# Copyright Robson Francisco de Souza\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::IO - Handler for Assembly::IO Formats\n\n=head1 SYNOPSIS\n\n    use Bio::Assembly::IO;\n\n    $in  = Bio::Assembly::IO->new(-file=>\"<inputfilename\",\n                                  -format=>'phrap');\n    $out = Bio::Assembly::IO->new(-file=>\">outputfilename\",\n                                  -format=>'phrap');\n\n    while ( my $scaffold = $in->next_assembly() ) {\n       # do something with Bio::Assembly::Scaffold instance\n       # ...\n       $out->write_assembly(-scaffold => $scaffold);\n    }\n\n    $in->close;\n    $out->close;\n\n=head1 DESCRIPTION\n\nBio::Assembly::IO is a handler module for formats in the Assembly::IO set\n(e.g. Bio::Assembly::IO::phrap).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nRobson Francisco de Souza\n\nE-mail: rfsouza@citri.iq.usp.br\n\n=head1 CONTRIBUTORS\n\n#\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Assembly::IO;\n\n\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : Bio::Assembly::IO->new(-file =>$filename,-format=>'format')\n Function: Returns a new assembly stream\n Returns : A Bio::Assembly::IO::Handler initialised\n           with the appropriate format\n Args    : -file => $filename\n           -format => format"},"line":109,"kind":12,"range":{"end":{"character":9999,"line":135},"start":{"line":109,"character":0}},"definition":"sub","detail":"($caller,@args)","children":[{"definition":"my","line":110,"name":"$caller","localvar":"my","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"@args","line":110},{"definition":"my","localvar":"my","containerName":"new","kind":13,"name":"$class","line":111},{"name":"$caller","kind":13,"containerName":"new","line":111},{"containerName":"new","kind":13,"name":"$caller","line":111},{"kind":13,"containerName":"new","name":"$class","line":115},{"kind":13,"localvar":"my","containerName":"new","name":"$self","line":116,"definition":"my"},{"line":116,"kind":13,"containerName":"new","name":"$class"},{"containerName":"new","kind":13,"name":"@args","line":116},{"containerName":"new","kind":13,"name":"$self","line":117},{"line":117,"name":"_initialize","containerName":"new","kind":12},{"line":117,"name":"@args","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$self","line":118},{"definition":"my","localvar":"my","kind":13,"containerName":"new","name":"%param","line":121},{"name":"@args","kind":13,"containerName":"new","line":121},{"line":122,"name":"@param","containerName":"new","kind":13},{"name":"%param","containerName":"new","kind":13,"line":122},{"name":"%param","kind":13,"containerName":"new","line":122},{"line":124,"name":"$class","containerName":"new","kind":13},{"line":124,"kind":12,"containerName":"new","name":"throw"},{"name":"$param","containerName":"new","kind":13,"line":125},{"line":125,"kind":13,"containerName":"new","name":"$ARGV"},{"localvar":"my","containerName":"new","kind":13,"name":"$format","line":127,"definition":"my"},{"line":127,"name":"$param","kind":13,"containerName":"new"},{"name":"$class","kind":13,"containerName":"new","line":128},{"line":128,"name":"_guess_format","containerName":"new","kind":12},{"kind":13,"containerName":"new","name":"$param","line":128},{"kind":13,"containerName":"new","name":"$ARGV","line":128},{"name":"$format","kind":13,"containerName":"new","line":129},{"containerName":"new","kind":13,"name":"$class","line":132},{"name":"_load_format_module","kind":12,"containerName":"new","line":132},{"line":132,"name":"$format","kind":13,"containerName":"new"},{"kind":12,"containerName":"new","name":"new","line":133},{"kind":13,"containerName":"new","name":"@args","line":133}],"containerName":"main::","name":"new"},{"line":116,"containerName":"new","kind":12,"name":"SUPER"},{"detail":"($self,@args)","definition":"sub","containerName":"main::","name":"_initialize","children":[{"line":140,"name":"$self","containerName":"_initialize","localvar":"my","kind":13,"definition":"my"},{"name":"@args","kind":13,"containerName":"_initialize","line":140},{"line":142,"containerName":"_initialize","kind":13,"name":"$self"},{"line":142,"name":"_initialize_io","containerName":"_initialize","kind":12},{"name":"@args","containerName":"_initialize","kind":13,"line":142}],"signature":{"label":"_initialize($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":" _initialize is chained for all SeqIO classes"},"range":{"start":{"line":139,"character":0},"end":{"character":9999,"line":143}},"kind":12,"line":139},{"range":{"start":{"character":0,"line":155},"end":{"line":158,"character":9999}},"kind":12,"line":155,"signature":{"label":"next_assembly($self,$seq)","parameters":[{"label":"$self"},{"label":"$seq"}],"documentation":"1;\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::IO\n#\n#   based on the Bio::SeqIO module\n#       by Ewan Birney <birney@ebi.ac.uk>\n#       and Lincoln Stein  <lstein@cshl.org>\n#\n# Copyright Robson Francisco de Souza\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::IO - Handler for Assembly::IO Formats\n\n=head1 SYNOPSIS\n\n    use Bio::Assembly::IO;\n\n    $in  = Bio::Assembly::IO->new(-file=>\"<inputfilename\",\n                                  -format=>'phrap');\n    $out = Bio::Assembly::IO->new(-file=>\">outputfilename\",\n                                  -format=>'phrap');\n\n    while ( my $scaffold = $in->next_assembly() ) {\n       # do something with Bio::Assembly::Scaffold instance\n       # ...\n       $out->write_assembly(-scaffold => $scaffold);\n    }\n\n    $in->close;\n    $out->close;\n\n=head1 DESCRIPTION\n\nBio::Assembly::IO is a handler module for formats in the Assembly::IO set\n(e.g. Bio::Assembly::IO::phrap).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nRobson Francisco de Souza\n\nE-mail: rfsouza@citri.iq.usp.br\n\n=head1 CONTRIBUTORS\n\n#\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Assembly::IO;\n\n\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : Bio::Assembly::IO->new(-file =>$filename,-format=>'format')\n Function: Returns a new assembly stream\n Returns : A Bio::Assembly::IO::Handler initialised\n           with the appropriate format\n Args    : -file => $filename\n           -format => format\n\n\nsub new {\n    my ($caller,@args) = @_;\n    my $class = ref($caller) || $caller;\n\n    # or do we want to call SUPER on an object if $caller is an\n    # object?\n    if( $class =~ /Bio::Assembly::IO::(\\S+)/ ) {\n\tmy ($self) = $class->SUPER::new(@args);\n\t$self->_initialize(@args);\n\treturn $self;\n    } else {\n\n\tmy %param = @args;\n\t@param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n\n\t$class->throw(\"Need at least a file name to proceed!\")\n\t    unless (defined $param{'-file'} || defined $ARGV[0]);\n\n\tmy $format = $param{'-format'} ||\n\t    $class->_guess_format( $param{-file} || $ARGV[0] );\n\t$format = \"\\L$format\";\t# normalize capitalization to lower case\n\n\t# normalize capitalization\n\treturn unless( $class->_load_format_module($format) );\n\treturn \"Bio::Assembly::IO::$format\"->new(@args);\n    }\n}\n\n# _initialize is chained for all SeqIO classes\n\nsub _initialize {\n    my($self, @args) = @_;\n    # initialize the IO part\n    $self->_initialize_io(@args);\n}\n\n=head2 next_assembly\n\n Title   : next_assembly\n Usage   : $cluster = $stream->next_assembly()\n Function: Reads the next assembly object from the stream and returns it.\n Returns : a Bio::Assembly::ScaffoldI compliant object\n Args    : none"},"containerName":"main::","name":"next_assembly","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"next_assembly","line":156},{"kind":13,"containerName":"next_assembly","name":"$seq","line":156},{"line":157,"kind":13,"containerName":"next_assembly","name":"$self"},{"name":"throw","kind":12,"containerName":"next_assembly","line":157}],"detail":"($self,$seq)","definition":"sub"},{"kind":12,"range":{"start":{"character":0,"line":170},"end":{"character":9999,"line":172}},"line":170,"definition":"sub","name":"write_assembly","containerName":"main::","children":[{"line":171,"name":"throw_not_implemented","containerName":"write_assembly","kind":12}]},{"signature":{"parameters":[{"label":"$self"},{"label":"$format"}],"documentation":"1;\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::IO\n#\n#   based on the Bio::SeqIO module\n#       by Ewan Birney <birney@ebi.ac.uk>\n#       and Lincoln Stein  <lstein@cshl.org>\n#\n# Copyright Robson Francisco de Souza\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::IO - Handler for Assembly::IO Formats\n\n=head1 SYNOPSIS\n\n    use Bio::Assembly::IO;\n\n    $in  = Bio::Assembly::IO->new(-file=>\"<inputfilename\",\n                                  -format=>'phrap');\n    $out = Bio::Assembly::IO->new(-file=>\">outputfilename\",\n                                  -format=>'phrap');\n\n    while ( my $scaffold = $in->next_assembly() ) {\n       # do something with Bio::Assembly::Scaffold instance\n       # ...\n       $out->write_assembly(-scaffold => $scaffold);\n    }\n\n    $in->close;\n    $out->close;\n\n=head1 DESCRIPTION\n\nBio::Assembly::IO is a handler module for formats in the Assembly::IO set\n(e.g. Bio::Assembly::IO::phrap).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nRobson Francisco de Souza\n\nE-mail: rfsouza@citri.iq.usp.br\n\n=head1 CONTRIBUTORS\n\n#\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Assembly::IO;\n\n\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : Bio::Assembly::IO->new(-file =>$filename,-format=>'format')\n Function: Returns a new assembly stream\n Returns : A Bio::Assembly::IO::Handler initialised\n           with the appropriate format\n Args    : -file => $filename\n           -format => format\n\n\nsub new {\n    my ($caller,@args) = @_;\n    my $class = ref($caller) || $caller;\n\n    # or do we want to call SUPER on an object if $caller is an\n    # object?\n    if( $class =~ /Bio::Assembly::IO::(\\S+)/ ) {\n\tmy ($self) = $class->SUPER::new(@args);\n\t$self->_initialize(@args);\n\treturn $self;\n    } else {\n\n\tmy %param = @args;\n\t@param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n\n\t$class->throw(\"Need at least a file name to proceed!\")\n\t    unless (defined $param{'-file'} || defined $ARGV[0]);\n\n\tmy $format = $param{'-format'} ||\n\t    $class->_guess_format( $param{-file} || $ARGV[0] );\n\t$format = \"\\L$format\";\t# normalize capitalization to lower case\n\n\t# normalize capitalization\n\treturn unless( $class->_load_format_module($format) );\n\treturn \"Bio::Assembly::IO::$format\"->new(@args);\n    }\n}\n\n# _initialize is chained for all SeqIO classes\n\nsub _initialize {\n    my($self, @args) = @_;\n    # initialize the IO part\n    $self->_initialize_io(@args);\n}\n\n=head2 next_assembly\n\n Title   : next_assembly\n Usage   : $cluster = $stream->next_assembly()\n Function: Reads the next assembly object from the stream and returns it.\n Returns : a Bio::Assembly::ScaffoldI compliant object\n Args    : none\n\n\nsub next_assembly {\n   my ($self, $seq) = @_;\n   $self->throw(\"Sorry, you cannot read from a generic Bio::Assembly::IO object.\");\n}\n\n=head2 write_assembly\n\n  Title   : write_assembly\n  Usage   : $ass_io->write_assembly($assembly)\n  Function: Write the assembly object in Phrap compatible ACE format\n  Returns : 1 on success, 0 for error\n  Args    : A Bio::Assembly::Scaffold object\n\n\nsub write_assembly {\n   shift->throw_not_implemented;\n}\n\n=head2 _load_format_module\n\n Title   : _load_format_module\n Usage   : *INTERNAL Assembly::IO stuff*\n Function: Loads up (like use) a module at run time on demand\n Example :\n Returns :\n Args    :","label":"_load_format_module($self,$format)"},"line":185,"range":{"end":{"line":201,"character":9999},"start":{"character":0,"line":185}},"kind":12,"definition":"sub","detail":"($self,$format)","children":[{"definition":"my","line":186,"name":"$self","kind":13,"localvar":"my","containerName":"_load_format_module"},{"line":186,"name":"$format","kind":13,"containerName":"_load_format_module"},{"definition":"my","line":187,"localvar":"my","kind":13,"containerName":"_load_format_module","name":"$module"},{"line":187,"kind":13,"containerName":"_load_format_module","name":"$format"},{"definition":"my","kind":13,"localvar":"my","containerName":"_load_format_module","name":"$ok","line":188},{"name":"$ok","containerName":"_load_format_module","kind":13,"line":191},{"name":"$self","containerName":"_load_format_module","kind":13,"line":191},{"line":191,"name":"_load_module","kind":12,"containerName":"_load_format_module"},{"containerName":"_load_format_module","kind":13,"name":"$module","line":191},{"name":"$ok","kind":13,"containerName":"_load_format_module","line":200}],"containerName":"main::","name":"_load_format_module"},{"line":216,"kind":12,"range":{"end":{"line":223,"character":9999},"start":{"line":216,"character":0}},"children":[{"definition":"my","line":217,"kind":13,"localvar":"my","containerName":"_guess_format","name":"$class"},{"localvar":"my","kind":13,"containerName":"_guess_format","name":"$arg","line":218,"definition":"my"},{"name":"$arg","containerName":"_guess_format","kind":13,"line":220},{"line":221,"name":"$arg","containerName":"_guess_format","kind":13},{"name":"$arg","kind":13,"containerName":"_guess_format","line":222}],"name":"_guess_format","containerName":"main::","definition":"sub"},{"kind":12,"range":{"end":{"line":229,"character":9999},"start":{"line":225,"character":0}},"line":225,"definition":"sub","name":"DESTROY","containerName":"main::","children":[{"line":226,"containerName":"DESTROY","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":228,"name":"$self","kind":13,"containerName":"DESTROY"},{"kind":12,"containerName":"DESTROY","name":"close","line":228}]},{"children":[{"name":"$class","localvar":"my","containerName":"TIEHANDLE","kind":13,"line":235,"definition":"my"},{"name":"$val","kind":13,"containerName":"TIEHANDLE","line":235},{"line":236,"containerName":"TIEHANDLE","kind":13,"name":"$val"},{"name":"$class","kind":13,"containerName":"TIEHANDLE","line":236}],"containerName":"main::","name":"TIEHANDLE","definition":"sub","detail":"($class,$val)","line":234,"range":{"end":{"line":237,"character":9999},"start":{"character":0,"line":234}},"kind":12,"signature":{"parameters":[{"label":"$class"},{"label":"$val"}],"documentation":" I need some direction on these!! The module works so I haven't fiddled with them!\n Me neither! (rfsouza)","label":"TIEHANDLE($class,$val)"}},{"name":"READLINE","containerName":"main::","children":[{"line":240,"name":"$self","localvar":"my","kind":13,"containerName":"READLINE","definition":"my"},{"kind":13,"containerName":"READLINE","name":"$self","line":241},{"line":241,"name":"next_seq","kind":12,"containerName":"READLINE"},{"definition":"my","line":242,"localvar":"my","containerName":"READLINE","kind":13,"name":"@list"},{"name":"$obj","kind":13,"containerName":"READLINE","line":242},{"kind":13,"containerName":"READLINE","name":"@list","line":243},{"line":243,"name":"$obj","containerName":"READLINE","kind":13},{"line":243,"kind":13,"containerName":"READLINE","name":"$obj"},{"containerName":"READLINE","kind":13,"name":"$self","line":243},{"containerName":"READLINE","kind":12,"name":"next_seq","line":243},{"containerName":"READLINE","kind":13,"name":"@list","line":244}],"definition":"sub","range":{"start":{"line":239,"character":0},"end":{"character":9999,"line":245}},"kind":12,"line":239},{"children":[{"line":248,"kind":13,"localvar":"my","containerName":"PRINT","name":"$self","definition":"my"},{"line":249,"name":"$self","kind":13,"containerName":"PRINT"},{"line":249,"kind":12,"containerName":"PRINT","name":"write_seq"}],"name":"PRINT","containerName":"main::","definition":"sub","line":247,"kind":12,"range":{"end":{"character":9999,"line":250},"start":{"line":247,"character":0}}}],"version":5}