{"vars":[{"line":91,"name":"vars","kind":2,"containerName":""},{"line":97,"containerName":"","kind":2,"name":"base"},{"line":100,"name":"$DEFAULTIDLENGTH","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$DEFAULTLINELEN","line":101},{"containerName":null,"kind":13,"name":"$DEFAULTTAGLEN","line":102},{"signature":{"label":"_initialize($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: phylip.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::phylip\n#\n# Copyright Heikki Lehvaslaiho\n#\n\n=head1 NAME\n\nBio::AlignIO::phylip - PHYLIP format sequence input/output stream\n\n=head1 SYNOPSIS\n\n# Do not use this module directly.  Use it via the Bio::AlignIO class.\n\n    use Bio::AlignIO;\n    use Bio::SimpleAlign;\n    #you can set the name length to something other than the default 10\n    #if you use a version of phylip (hacked) that accepts ids > 10\n    my $phylipstream = Bio::AlignIO->new(-format  => 'phylip',\n                                        -fh      => \\*STDOUT,\n                                        -idlength=>30);\n    # convert data from one format to another\n    my $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                          -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n    # do it again with phylip sequential format format\n    $phylipstream->interleaved(0);\n    # can also initialize the object like this\n    $phylipstream = Bio::AlignIO->new(-interleaved => 0,\n                                     -format => 'phylip',\n                                     -fh   => \\*STDOUT,\n                                     -idlength=>10);\n    $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                       -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::SimpleAlign objects to and from PHYLIP\nfotmat. By deafult it works with the interleaved format. By specifying\nthe flag -interleaved =E<gt> 0 in the initialization the module can\nread or write data in sequential format.\n\nLong IDs up to 50 characters are supported by flag -longid =E<gt>\n1. ID strings can be surrounded by single quoted. They are mandatory\nonly if the IDs contain spaces. \n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Heikki Lehvaslaiho and Jason Stajich\n\nEmail: heikki at ebi.ac.uk\nEmail: jason at bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::phylip;\nuse vars qw($DEFAULTIDLENGTH $DEFAULTLINELEN $DEFAULTTAGLEN);\nuse strict;\n\nuse Bio::SimpleAlign;\nuse POSIX; # for the rounding call\n\nuse base qw(Bio::AlignIO);\n\nBEGIN {\n    $DEFAULTIDLENGTH = 10;\n    $DEFAULTLINELEN = 60;\n    $DEFAULTTAGLEN = 10;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $alignio = Bio::AlignIO->new(-format => 'phylip'\n\t\t\t\t\t  -file   => '>file',\n\t\t\t\t\t  -idlength => 10,\n\t\t\t\t\t  -idlinebreak => 1);\n Function: Initialize a new L<Bio::AlignIO::phylip> reader or writer\n Returns : L<Bio::AlignIO> object\n Args    : [specific for writing of phylip format files]\n           -idlength => integer - length of the id (will pad w/\n\t\t\t\t\t\t    spaces if needed)\n           -interleaved => boolean - whether interleaved\n                                     or sequential format required\n           -line_length  => integer of how long a sequence lines should be\n           -idlinebreak => insert a line break after the sequence id\n                           so that sequence starts on the next line\n           -flag_SI => whether or not write a \"S\" or \"I\" just after\n                       the num.seq. and line len., in the first line\n           -tag_length => integer of how long the tags have to be in\n                         each line between the space separator. set it\n                         to 0 to have 1 tag only.\n           -wrap_sequential => boolean for whether or not sequential\n                                   format should be broken up or a single line\n                                   default is false (single line)\n           -longid => boolean for allowing arbitrary long IDs (default is false)"},"range":{"start":{"line":134,"character":0},"end":{"line":157,"character":9999}},"kind":12,"line":134,"detail":"($self,@args)","definition":"sub","containerName":"main::","name":"_initialize","children":[{"kind":13,"localvar":"my","containerName":"_initialize","name":"$self","line":135,"definition":"my"},{"name":"@args","kind":13,"containerName":"_initialize","line":135},{"name":"$self","kind":13,"containerName":"_initialize","line":136},{"line":136,"name":"@args","kind":13,"containerName":"_initialize"},{"line":138,"name":"$interleave","kind":13,"localvar":"my","containerName":"_initialize","definition":"my"},{"line":138,"name":"$linelen","containerName":"_initialize","kind":13},{"kind":13,"containerName":"_initialize","name":"$idlinebreak","line":138},{"line":139,"containerName":"_initialize","kind":13,"name":"$idlength"},{"line":139,"name":"$flag_SI","kind":13,"containerName":"_initialize"},{"name":"$tag_length","kind":13,"containerName":"_initialize","line":139},{"line":139,"containerName":"_initialize","kind":13,"name":"$ws"},{"name":"$longid","kind":13,"containerName":"_initialize","line":139},{"line":140,"containerName":"_initialize","kind":13,"name":"$self"},{"line":140,"name":"_rearrange","containerName":"_initialize","kind":12},{"kind":13,"containerName":"_initialize","name":"@args","line":147},{"kind":13,"containerName":"_initialize","name":"$self","line":148},{"line":148,"name":"interleaved","kind":12,"containerName":"_initialize"},{"name":"$interleave","containerName":"_initialize","kind":13,"line":148},{"line":148,"name":"$interleave","containerName":"_initialize","kind":13},{"name":"$self","containerName":"_initialize","kind":13,"line":149},{"containerName":"_initialize","kind":12,"name":"idlength","line":149},{"name":"$idlength","containerName":"_initialize","kind":13,"line":149},{"line":149,"name":"$DEFAULTIDLENGTH","containerName":"_initialize","kind":13},{"line":150,"kind":13,"containerName":"_initialize","name":"$self"},{"line":150,"name":"id_linebreak","containerName":"_initialize","kind":12},{"line":150,"name":"$idlinebreak","containerName":"_initialize","kind":13},{"name":"$self","containerName":"_initialize","kind":13,"line":151},{"line":151,"name":"line_length","containerName":"_initialize","kind":12},{"name":"$linelen","containerName":"_initialize","kind":13,"line":151},{"kind":13,"containerName":"_initialize","name":"$linelen","line":151},{"line":151,"name":"$linelen","kind":13,"containerName":"_initialize"},{"line":152,"name":"$self","containerName":"_initialize","kind":13},{"line":152,"name":"flag_SI","kind":12,"containerName":"_initialize"},{"kind":13,"containerName":"_initialize","name":"$flag_SI","line":152},{"name":"$self","containerName":"_initialize","kind":13,"line":153},{"line":153,"containerName":"_initialize","kind":12,"name":"tag_length"},{"line":153,"kind":13,"containerName":"_initialize","name":"$tag_length"},{"line":153,"name":"$tag_length","kind":13,"containerName":"_initialize"},{"name":"$DEFAULTTAGLEN","kind":13,"containerName":"_initialize","line":153},{"line":154,"name":"$self","containerName":"_initialize","kind":13},{"containerName":"_initialize","kind":12,"name":"wrap_sequential","line":154},{"line":154,"name":"$ws","kind":13,"containerName":"_initialize"},{"line":155,"name":"$self","containerName":"_initialize","kind":13},{"containerName":"_initialize","kind":12,"name":"longid","line":155},{"containerName":"_initialize","kind":13,"name":"$longid","line":155}]},{"containerName":"_initialize","kind":12,"name":"SUPER","line":136},{"containerName":"main::","name":"next_aln","children":[{"definition":"my","line":172,"name":"$self","localvar":"my","kind":13,"containerName":"next_aln"},{"definition":"my","line":173,"name":"$entry","kind":13,"localvar":"my","containerName":"next_aln"},{"line":174,"containerName":"next_aln","localvar":"my","kind":13,"name":"$seqcount","definition":"my"},{"name":"$residuecount","kind":13,"containerName":"next_aln","line":174},{"line":174,"containerName":"next_aln","kind":13,"name":"%hash"},{"name":"$name","containerName":"next_aln","kind":13,"line":174},{"line":174,"kind":13,"containerName":"next_aln","name":"$str"},{"line":175,"kind":13,"containerName":"next_aln","name":"@names"},{"line":175,"kind":13,"containerName":"next_aln","name":"$seqname"},{"name":"$start","containerName":"next_aln","kind":13,"line":175},{"line":175,"name":"$end","kind":13,"containerName":"next_aln"},{"line":175,"kind":13,"containerName":"next_aln","name":"$count"},{"kind":13,"containerName":"next_aln","name":"$seq","line":175},{"containerName":"next_aln","localvar":"my","kind":13,"name":"$aln","line":177,"definition":"my"},{"line":177,"name":"new","kind":12,"containerName":"next_aln"},{"kind":13,"containerName":"next_aln","name":"$entry","line":178},{"kind":13,"containerName":"next_aln","name":"$self","line":178},{"line":178,"containerName":"next_aln","kind":12,"name":"_readline"},{"name":"$seqcount","kind":13,"containerName":"next_aln","line":179},{"line":179,"containerName":"next_aln","kind":13,"name":"$residuecount"},{"name":"$entry","kind":13,"containerName":"next_aln","line":179},{"kind":13,"containerName":"next_aln","name":"$seqcount","line":180},{"line":180,"containerName":"next_aln","kind":13,"name":"$residuecount"},{"definition":"my","name":"$idlen","localvar":"my","kind":13,"containerName":"next_aln","line":183},{"containerName":"next_aln","kind":13,"name":"$self","line":183},{"name":"idlength","kind":12,"containerName":"next_aln","line":183},{"line":184,"name":"$count","kind":13,"containerName":"next_aln"},{"definition":"my","line":185,"localvar":"my","kind":13,"containerName":"next_aln","name":"$iter"},{"line":186,"localvar":"my","containerName":"next_aln","kind":13,"name":"$interleaved","definition":"my"},{"containerName":"next_aln","kind":13,"name":"$self","line":186},{"name":"interleaved","containerName":"next_aln","kind":12,"line":186},{"containerName":"next_aln","kind":13,"name":"$entry","line":187},{"name":"$self","kind":13,"containerName":"next_aln","line":187},{"line":187,"containerName":"next_aln","kind":12,"name":"_readline"},{"containerName":"next_aln","kind":13,"name":"$entry","line":188},{"containerName":"next_aln","kind":13,"name":"$interleaved","line":188},{"line":190,"name":"$entry","containerName":"next_aln","kind":13},{"name":"$self","containerName":"next_aln","kind":13,"line":191},{"name":"_pushback","kind":12,"containerName":"next_aln","line":191},{"name":"$entry","kind":13,"containerName":"next_aln","line":191},{"line":194,"name":"$self","containerName":"next_aln","kind":13},{"kind":12,"containerName":"next_aln","name":"longid","line":194},{"line":194,"name":"$entry","kind":13,"containerName":"next_aln"},{"line":195,"containerName":"next_aln","kind":13,"name":"$entry"},{"name":"$entry","containerName":"next_aln","kind":13,"line":196},{"kind":13,"containerName":"next_aln","name":"$name","line":197},{"name":"$str","kind":13,"containerName":"next_aln","line":198},{"name":"$entry","kind":13,"containerName":"next_aln","line":200},{"line":201,"name":"$name","containerName":"next_aln","kind":13},{"name":"$str","containerName":"next_aln","kind":13,"line":202},{"line":205,"name":"$name","kind":13,"containerName":"next_aln"},{"containerName":"next_aln","kind":13,"name":"@names","line":207},{"line":207,"containerName":"next_aln","kind":13,"name":"$name"},{"containerName":"next_aln","kind":13,"name":"$str","line":208},{"containerName":"next_aln","kind":13,"name":"$count","line":209},{"line":209,"containerName":"next_aln","kind":13,"name":"@names"},{"line":210,"name":"$hash","kind":13,"containerName":"next_aln"},{"line":210,"name":"$count","containerName":"next_aln","kind":13},{"kind":13,"containerName":"next_aln","name":"$str","line":210},{"name":"$entry","kind":13,"containerName":"next_aln","line":212},{"name":"$interleaved","containerName":"next_aln","kind":13,"line":213},{"kind":13,"containerName":"next_aln","name":"$str","line":214},{"kind":13,"containerName":"next_aln","name":"$str","line":215},{"containerName":"next_aln","kind":13,"name":"$count","line":216},{"containerName":"next_aln","kind":13,"name":"@names","line":216},{"name":"$hash","kind":13,"containerName":"next_aln","line":217},{"kind":13,"containerName":"next_aln","name":"$count","line":217},{"line":217,"name":"$str","kind":13,"containerName":"next_aln"},{"line":218,"containerName":"next_aln","kind":13,"name":"$entry"},{"line":219,"name":"$entry","kind":13,"containerName":"next_aln"},{"kind":13,"containerName":"next_aln","name":"$name","line":221},{"kind":13,"containerName":"next_aln","name":"$str","line":222},{"line":223,"containerName":"next_aln","kind":13,"name":"$name"},{"line":224,"kind":13,"containerName":"next_aln","name":"$name"},{"line":226,"containerName":"next_aln","kind":13,"name":"@names"},{"line":226,"name":"$name","kind":13,"containerName":"next_aln"},{"kind":13,"containerName":"next_aln","name":"$str","line":227},{"kind":13,"containerName":"next_aln","name":"$count","line":228},{"line":228,"name":"@names","containerName":"next_aln","kind":13},{"line":229,"kind":13,"containerName":"next_aln","name":"$hash"},{"containerName":"next_aln","kind":13,"name":"$count","line":229},{"line":229,"kind":13,"containerName":"next_aln","name":"$str"},{"line":230,"kind":13,"containerName":"next_aln","name":"$interleaved"},{"line":231,"name":"$entry","containerName":"next_aln","kind":13},{"line":232,"kind":13,"containerName":"next_aln","name":"$entry"},{"line":233,"name":"$name","containerName":"next_aln","kind":13},{"containerName":"next_aln","kind":13,"name":"$str","line":234},{"kind":13,"containerName":"next_aln","name":"$name","line":235},{"line":236,"kind":13,"containerName":"next_aln","name":"$name"},{"name":"@names","kind":13,"containerName":"next_aln","line":237},{"line":237,"containerName":"next_aln","kind":13,"name":"$name"},{"line":238,"containerName":"next_aln","kind":13,"name":"$str"},{"line":239,"name":"$count","containerName":"next_aln","kind":13},{"containerName":"next_aln","kind":13,"name":"@names","line":239},{"name":"$hash","containerName":"next_aln","kind":13,"line":240},{"containerName":"next_aln","kind":13,"name":"$count","line":240},{"name":"$str","kind":13,"containerName":"next_aln","line":240},{"containerName":"next_aln","kind":13,"name":"$self","line":242},{"name":"debug","containerName":"next_aln","kind":12,"line":242},{"name":"$self","containerName":"next_aln","kind":13,"line":245},{"line":245,"name":"throw","containerName":"next_aln","kind":12},{"line":245,"name":"$count","containerName":"next_aln","kind":13},{"line":245,"kind":13,"containerName":"next_aln","name":"$seqcount"},{"line":248,"name":"$interleaved","kind":13,"containerName":"next_aln"},{"line":250,"name":"$count","containerName":"next_aln","kind":13},{"name":"$entry","kind":13,"containerName":"next_aln","line":251},{"line":251,"kind":13,"containerName":"next_aln","name":"$self"},{"line":251,"name":"_readline","containerName":"next_aln","kind":12},{"line":253,"name":"$entry","containerName":"next_aln","kind":13},{"kind":13,"containerName":"next_aln","name":"$self","line":254},{"line":254,"name":"_pushback","kind":12,"containerName":"next_aln"},{"name":"$entry","kind":13,"containerName":"next_aln","line":254},{"line":257,"name":"$count","containerName":"next_aln","kind":13},{"containerName":"next_aln","kind":13,"name":"$entry","line":257},{"line":258,"kind":13,"containerName":"next_aln","name":"$entry"},{"line":259,"containerName":"next_aln","kind":13,"name":"$str"},{"line":260,"containerName":"next_aln","kind":13,"name":"$str"},{"line":261,"containerName":"next_aln","kind":13,"name":"$count"},{"line":262,"name":"$hash","containerName":"next_aln","kind":13},{"line":262,"containerName":"next_aln","kind":13,"name":"$count"},{"line":262,"kind":13,"containerName":"next_aln","name":"$str"},{"line":264,"name":"$self","containerName":"next_aln","kind":13},{"kind":12,"containerName":"next_aln","name":"throw","line":264},{"line":264,"kind":13,"containerName":"next_aln","name":"$count"},{"containerName":"next_aln","kind":13,"name":"$seqcount","line":264},{"line":267,"name":"@names","kind":13,"containerName":"next_aln"},{"line":270,"name":"$count","kind":13,"containerName":"next_aln"},{"line":271,"name":"$name","containerName":"next_aln","kind":13},{"name":"@names","containerName":"next_aln","kind":13,"line":271},{"line":272,"kind":13,"containerName":"next_aln","name":"$count"},{"line":273,"kind":13,"containerName":"next_aln","name":"$name"},{"line":274,"kind":13,"containerName":"next_aln","name":"$seqname"},{"containerName":"next_aln","kind":13,"name":"$start","line":275},{"line":276,"kind":13,"containerName":"next_aln","name":"$end"},{"name":"$seqname","kind":13,"containerName":"next_aln","line":278},{"name":"$name","kind":13,"containerName":"next_aln","line":278},{"containerName":"next_aln","kind":13,"name":"$start","line":279},{"line":280,"kind":13,"containerName":"next_aln","name":"$str"},{"line":280,"name":"$hash","containerName":"next_aln","kind":13},{"line":280,"name":"$count","kind":13,"containerName":"next_aln"},{"kind":13,"containerName":"next_aln","name":"$str","line":281},{"name":"$end","kind":13,"containerName":"next_aln","line":282},{"line":282,"name":"$str","containerName":"next_aln","kind":13},{"kind":13,"containerName":"next_aln","name":"$self","line":285},{"line":285,"containerName":"next_aln","kind":12,"name":"throw"},{"line":285,"kind":13,"containerName":"next_aln","name":"$hash"},{"name":"$count","containerName":"next_aln","kind":13,"line":285},{"containerName":"next_aln","kind":13,"name":"$hash","line":286},{"line":286,"name":"$count","containerName":"next_aln","kind":13},{"line":286,"kind":13,"containerName":"next_aln","name":"$residuecount"},{"kind":13,"containerName":"next_aln","name":"$seq","line":288},{"line":288,"name":"new","containerName":"next_aln","kind":12},{"line":288,"containerName":"next_aln","kind":13,"name":"$hash"},{"containerName":"next_aln","kind":13,"name":"$count","line":288},{"line":289,"containerName":"next_aln","kind":13,"name":"$seqname"},{"name":"$start","containerName":"next_aln","kind":13,"line":290},{"name":"$end","containerName":"next_aln","kind":13,"line":291},{"line":293,"kind":13,"containerName":"next_aln","name":"$aln"},{"line":293,"name":"add_seq","containerName":"next_aln","kind":12},{"line":293,"containerName":"next_aln","kind":13,"name":"$seq"},{"containerName":"next_aln","kind":13,"name":"$aln","line":296},{"line":296,"containerName":"next_aln","kind":13,"name":"$aln"},{"line":296,"containerName":"next_aln","kind":12,"name":"num_sequences"}],"definition":"sub","kind":12,"range":{"end":{"character":9999,"line":298},"start":{"line":171,"character":0}},"line":171},{"line":177,"name":"Bio","containerName":"SimpleAlign","kind":12},{"kind":12,"containerName":"length","name":"CORE","line":285},{"line":286,"kind":12,"containerName":"length","name":"CORE"},{"line":288,"kind":12,"containerName":"LocatableSeq","name":"Bio"},{"children":[{"line":312,"name":"$self","localvar":"my","containerName":"write_aln","kind":13,"definition":"my"},{"name":"@aln","kind":13,"containerName":"write_aln","line":312},{"definition":"my","line":313,"localvar":"my","kind":13,"containerName":"write_aln","name":"$count"},{"name":"$wrapped","localvar":"my","containerName":"write_aln","kind":13,"line":314,"definition":"my"},{"line":315,"localvar":"my","containerName":"write_aln","kind":13,"name":"$maxname","definition":"my"},{"definition":"my","line":316,"name":"$width","localvar":"my","kind":13,"containerName":"write_aln"},{"kind":13,"containerName":"write_aln","name":"$self","line":316},{"kind":12,"containerName":"write_aln","name":"line_length","line":316},{"definition":"my","containerName":"write_aln","localvar":"my","kind":13,"name":"$length","line":317},{"line":317,"name":"$date","kind":13,"containerName":"write_aln"},{"containerName":"write_aln","kind":13,"name":"$name","line":317},{"line":317,"containerName":"write_aln","kind":13,"name":"$seq"},{"line":317,"name":"$miss","kind":13,"containerName":"write_aln"},{"line":317,"name":"$pad","kind":13,"containerName":"write_aln"},{"line":318,"name":"%hash","kind":13,"containerName":"write_aln"},{"name":"@arr","kind":13,"containerName":"write_aln","line":318},{"containerName":"write_aln","kind":13,"name":"$tempcount","line":318},{"line":318,"containerName":"write_aln","kind":13,"name":"$index"},{"name":"$idlength","containerName":"write_aln","kind":13,"line":318},{"line":318,"containerName":"write_aln","kind":13,"name":"$flag_SI"},{"kind":13,"containerName":"write_aln","name":"$line_length","line":318},{"line":318,"name":"$tag_length","kind":13,"containerName":"write_aln"},{"definition":"my","line":320,"name":"$aln","localvar":"my","containerName":"write_aln","kind":13},{"line":320,"name":"@aln","containerName":"write_aln","kind":13},{"name":"$aln","kind":13,"containerName":"write_aln","line":321},{"name":"$aln","containerName":"write_aln","kind":13,"line":321},{"line":321,"name":"isa","kind":12,"containerName":"write_aln"},{"containerName":"write_aln","kind":13,"name":"$self","line":322},{"name":"warn","containerName":"write_aln","kind":12,"line":322},{"containerName":"write_aln","kind":13,"name":"$self","line":325},{"line":325,"containerName":"write_aln","kind":12,"name":"throw"},{"name":"$aln","kind":13,"containerName":"write_aln","line":326},{"line":326,"containerName":"write_aln","kind":12,"name":"is_flush"},{"kind":13,"containerName":"write_aln","name":"$flag_SI","line":328},{"kind":13,"containerName":"write_aln","name":"$self","line":328},{"line":328,"name":"flag_SI","kind":12,"containerName":"write_aln"},{"line":329,"containerName":"write_aln","kind":13,"name":"$aln"},{"name":"set_displayname_flat","kind":12,"containerName":"write_aln","line":329},{"containerName":"write_aln","kind":13,"name":"$length","line":330},{"line":330,"kind":13,"containerName":"write_aln","name":"$aln"},{"line":330,"name":"length","containerName":"write_aln","kind":12},{"line":331,"containerName":"write_aln","kind":13,"name":"$flag_SI"},{"line":332,"kind":13,"containerName":"write_aln","name":"$self"},{"line":332,"name":"interleaved","kind":12,"containerName":"write_aln"},{"name":"$self","kind":13,"containerName":"write_aln","line":333},{"containerName":"write_aln","kind":12,"name":"_print","line":333},{"line":333,"name":"$aln","containerName":"write_aln","kind":13},{"line":333,"name":"num_sequences","containerName":"write_aln","kind":12},{"line":333,"kind":13,"containerName":"write_aln","name":"$aln"},{"name":"length","containerName":"write_aln","kind":12,"line":333},{"line":335,"containerName":"write_aln","kind":13,"name":"$self"},{"line":335,"name":"_print","containerName":"write_aln","kind":12},{"kind":13,"containerName":"write_aln","name":"$aln","line":335},{"line":335,"name":"num_sequences","kind":12,"containerName":"write_aln"},{"name":"$aln","kind":13,"containerName":"write_aln","line":335},{"line":335,"containerName":"write_aln","kind":12,"name":"length"},{"kind":13,"containerName":"write_aln","name":"$self","line":338},{"line":338,"containerName":"write_aln","kind":12,"name":"_print"},{"line":338,"containerName":"write_aln","kind":13,"name":"$aln"},{"line":338,"name":"num_sequences","containerName":"write_aln","kind":12},{"line":338,"name":"$aln","kind":13,"containerName":"write_aln"},{"line":338,"containerName":"write_aln","kind":12,"name":"length"},{"line":341,"name":"$idlength","containerName":"write_aln","kind":13},{"containerName":"write_aln","kind":13,"name":"$self","line":341},{"containerName":"write_aln","kind":12,"name":"idlength","line":341},{"line":342,"containerName":"write_aln","kind":13,"name":"$line_length"},{"kind":13,"containerName":"write_aln","name":"$self","line":342},{"containerName":"write_aln","kind":12,"name":"line_length","line":342},{"line":343,"kind":13,"containerName":"write_aln","name":"$tag_length"},{"kind":13,"containerName":"write_aln","name":"$self","line":343},{"name":"tag_length","containerName":"write_aln","kind":12,"line":343},{"line":344,"name":"$seq","kind":13,"containerName":"write_aln"},{"line":344,"kind":13,"containerName":"write_aln","name":"$aln"},{"line":344,"containerName":"write_aln","kind":12,"name":"each_seq"},{"line":345,"containerName":"write_aln","kind":13,"name":"$name"},{"name":"$aln","kind":13,"containerName":"write_aln","line":345},{"line":345,"name":"displayname","kind":12,"containerName":"write_aln"},{"line":345,"name":"$seq","kind":13,"containerName":"write_aln"},{"name":"get_nse","kind":12,"containerName":"write_aln","line":345},{"containerName":"write_aln","kind":13,"name":"$self","line":346},{"line":346,"name":"longid","containerName":"write_aln","kind":12},{"line":347,"containerName":"write_aln","kind":13,"name":"$self"},{"line":347,"containerName":"write_aln","kind":12,"name":"warn"},{"name":"$name","kind":13,"containerName":"write_aln","line":348},{"line":349,"name":"$name","kind":13,"containerName":"write_aln"},{"line":351,"name":"$name","containerName":"write_aln","kind":13},{"line":351,"name":"$name","containerName":"write_aln","kind":13},{"name":"$idlength","containerName":"write_aln","kind":13,"line":351},{"name":"$name","kind":13,"containerName":"write_aln","line":351},{"containerName":"write_aln","kind":13,"name":"$idlength","line":351},{"name":"$name","kind":13,"containerName":"write_aln","line":352},{"line":352,"name":"$idlength","containerName":"write_aln","kind":13},{"line":352,"name":"$name","containerName":"write_aln","kind":13},{"line":353,"name":"$self","containerName":"write_aln","kind":13},{"line":353,"containerName":"write_aln","kind":12,"name":"interleaved"},{"kind":13,"containerName":"write_aln","name":"$name","line":354},{"containerName":"write_aln","kind":13,"name":"$self","line":355},{"line":355,"name":"id_linebreak","kind":12,"containerName":"write_aln"},{"line":356,"kind":13,"containerName":"write_aln","name":"$name"},{"definition":"my","name":"$seq","localvar":"my","kind":13,"containerName":"write_aln","line":360},{"line":360,"kind":13,"containerName":"write_aln","name":"$seq"},{"name":"seq","containerName":"write_aln","kind":12,"line":360},{"line":361,"name":"$seq","kind":13,"containerName":"write_aln"},{"line":362,"containerName":"write_aln","kind":13,"name":"$hash"},{"name":"$name","containerName":"write_aln","kind":13,"line":362},{"line":362,"kind":13,"containerName":"write_aln","name":"$seq"},{"kind":13,"containerName":"write_aln","name":"@arr","line":363},{"line":363,"kind":13,"containerName":"write_aln","name":"$name"},{"line":366,"containerName":"write_aln","kind":13,"name":"$self"},{"name":"interleaved","containerName":"write_aln","kind":12,"line":366},{"containerName":"write_aln","localvar":"my","kind":13,"name":"$numtags","line":367,"definition":"my"},{"name":"$tag_length","containerName":"write_aln","kind":13,"line":368},{"line":368,"containerName":"write_aln","kind":13,"name":"$line_length"},{"line":369,"containerName":"write_aln","kind":13,"name":"$numtags"},{"line":369,"kind":13,"containerName":"write_aln","name":"$line_length"},{"name":"$tag_length","kind":13,"containerName":"write_aln","line":369},{"line":370,"kind":13,"containerName":"write_aln","name":"$line_length"},{"name":"$tag_length","containerName":"write_aln","kind":13,"line":370},{"kind":13,"containerName":"write_aln","name":"$numtags","line":370},{"name":"$numtags","containerName":"write_aln","kind":13,"line":372},{"line":374,"name":"$count","containerName":"write_aln","kind":13},{"name":"$length","containerName":"write_aln","kind":13,"line":374},{"name":"$name","kind":13,"containerName":"write_aln","line":377},{"line":377,"containerName":"write_aln","kind":13,"name":"@arr"},{"definition":"my","localvar":"my","containerName":"write_aln","kind":13,"name":"$dispname","line":378},{"line":378,"name":"$name","containerName":"write_aln","kind":13},{"line":379,"containerName":"write_aln","kind":13,"name":"$dispname"},{"name":"$wrapped","kind":13,"containerName":"write_aln","line":379},{"line":380,"containerName":"write_aln","kind":13,"name":"$self"},{"kind":12,"containerName":"write_aln","name":"_print","line":380},{"kind":13,"containerName":"write_aln","name":"$idlength","line":380},{"name":"$dispname","containerName":"write_aln","kind":13,"line":380},{"name":"$tempcount","kind":13,"containerName":"write_aln","line":381},{"line":381,"kind":13,"containerName":"write_aln","name":"$count"},{"line":382,"containerName":"write_aln","kind":13,"name":"$index"},{"line":383,"name":"$self","containerName":"write_aln","kind":13},{"line":383,"name":"debug","kind":12,"containerName":"write_aln"},{"kind":13,"containerName":"write_aln","name":"$count","line":383},{"name":"%100000","kind":13,"containerName":"write_aln","line":383},{"name":"$tempcount","kind":13,"containerName":"write_aln","line":384},{"name":"$tag_length","containerName":"write_aln","kind":13,"line":384},{"line":384,"name":"$length","containerName":"write_aln","kind":13},{"line":385,"containerName":"write_aln","kind":13,"name":"$index"},{"name":"$numtags","containerName":"write_aln","kind":13,"line":385},{"line":386,"kind":13,"containerName":"write_aln","name":"$self"},{"line":386,"kind":12,"containerName":"write_aln","name":"_print"},{"line":386,"containerName":"write_aln","kind":13,"name":"$hash"},{"name":"$name","containerName":"write_aln","kind":13,"line":386},{"line":387,"name":"$tempcount","containerName":"write_aln","kind":13},{"kind":13,"containerName":"write_aln","name":"$tag_length","line":388},{"line":389,"containerName":"write_aln","kind":13,"name":"$tempcount"},{"line":389,"name":"$tag_length","kind":13,"containerName":"write_aln"},{"line":390,"name":"$index","containerName":"write_aln","kind":13},{"containerName":"write_aln","kind":13,"name":"$index","line":393},{"containerName":"write_aln","kind":13,"name":"$numtags","line":393},{"name":"$self","containerName":"write_aln","kind":13,"line":395},{"line":395,"kind":12,"containerName":"write_aln","name":"_print"},{"line":395,"name":"$hash","containerName":"write_aln","kind":13},{"name":"$name","kind":13,"containerName":"write_aln","line":395},{"line":396,"kind":13,"containerName":"write_aln","name":"$tempcount"},{"name":"$tempcount","kind":13,"containerName":"write_aln","line":397},{"name":"$tag_length","containerName":"write_aln","kind":13,"line":397},{"line":399,"kind":13,"containerName":"write_aln","name":"$self"},{"line":399,"containerName":"write_aln","kind":12,"name":"_print"},{"line":401,"kind":13,"containerName":"write_aln","name":"$self"},{"containerName":"write_aln","kind":12,"name":"_print","line":401},{"line":402,"containerName":"write_aln","kind":13,"name":"$count"},{"line":402,"kind":13,"containerName":"write_aln","name":"$tempcount"},{"line":403,"name":"$wrapped","kind":13,"containerName":"write_aln"},{"name":"$name","kind":13,"containerName":"write_aln","line":406},{"line":406,"name":"@arr","containerName":"write_aln","kind":13},{"definition":"my","localvar":"my","containerName":"write_aln","kind":13,"name":"$dispname","line":407},{"line":407,"kind":13,"containerName":"write_aln","name":"$name"},{"definition":"my","name":"$line","localvar":"my","containerName":"write_aln","kind":13,"line":408},{"line":408,"name":"$dispname","containerName":"write_aln","kind":13},{"line":408,"kind":13,"containerName":"write_aln","name":"$hash"},{"line":408,"name":"$name","kind":13,"containerName":"write_aln"},{"kind":13,"containerName":"write_aln","name":"$self","line":409},{"line":409,"containerName":"write_aln","kind":12,"name":"wrap_sequential"},{"line":410,"name":"$line","kind":13,"containerName":"write_aln"},{"containerName":"write_aln","kind":13,"name":"$self","line":412},{"containerName":"write_aln","kind":12,"name":"_print","line":412},{"line":412,"name":"$line","containerName":"write_aln","kind":13},{"name":"$self","kind":13,"containerName":"write_aln","line":416},{"line":416,"name":"flush","containerName":"write_aln","kind":12},{"name":"$self","containerName":"write_aln","kind":13,"line":416},{"containerName":"write_aln","kind":12,"name":"_flush_on_write","line":416},{"line":416,"name":"$self","containerName":"write_aln","kind":13},{"name":"_fh","containerName":"write_aln","kind":12,"line":416}],"containerName":"main::","name":"write_aln","definition":"sub","detail":"($self,@aln)","line":311,"range":{"end":{"line":418,"character":9999},"start":{"character":0,"line":311}},"kind":12,"signature":{"label":"write_aln($self,@aln)","parameters":[{"label":"$self"},{"label":"@aln"}],"documentation":"1;\n# $Id: phylip.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::phylip\n#\n# Copyright Heikki Lehvaslaiho\n#\n\n=head1 NAME\n\nBio::AlignIO::phylip - PHYLIP format sequence input/output stream\n\n=head1 SYNOPSIS\n\n# Do not use this module directly.  Use it via the Bio::AlignIO class.\n\n    use Bio::AlignIO;\n    use Bio::SimpleAlign;\n    #you can set the name length to something other than the default 10\n    #if you use a version of phylip (hacked) that accepts ids > 10\n    my $phylipstream = Bio::AlignIO->new(-format  => 'phylip',\n                                        -fh      => \\*STDOUT,\n                                        -idlength=>30);\n    # convert data from one format to another\n    my $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                          -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n    # do it again with phylip sequential format format\n    $phylipstream->interleaved(0);\n    # can also initialize the object like this\n    $phylipstream = Bio::AlignIO->new(-interleaved => 0,\n                                     -format => 'phylip',\n                                     -fh   => \\*STDOUT,\n                                     -idlength=>10);\n    $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                       -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::SimpleAlign objects to and from PHYLIP\nfotmat. By deafult it works with the interleaved format. By specifying\nthe flag -interleaved =E<gt> 0 in the initialization the module can\nread or write data in sequential format.\n\nLong IDs up to 50 characters are supported by flag -longid =E<gt>\n1. ID strings can be surrounded by single quoted. They are mandatory\nonly if the IDs contain spaces. \n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Heikki Lehvaslaiho and Jason Stajich\n\nEmail: heikki at ebi.ac.uk\nEmail: jason at bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::phylip;\nuse vars qw($DEFAULTIDLENGTH $DEFAULTLINELEN $DEFAULTTAGLEN);\nuse strict;\n\nuse Bio::SimpleAlign;\nuse POSIX; # for the rounding call\n\nuse base qw(Bio::AlignIO);\n\nBEGIN {\n    $DEFAULTIDLENGTH = 10;\n    $DEFAULTLINELEN = 60;\n    $DEFAULTTAGLEN = 10;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $alignio = Bio::AlignIO->new(-format => 'phylip'\n\t\t\t\t\t  -file   => '>file',\n\t\t\t\t\t  -idlength => 10,\n\t\t\t\t\t  -idlinebreak => 1);\n Function: Initialize a new L<Bio::AlignIO::phylip> reader or writer\n Returns : L<Bio::AlignIO> object\n Args    : [specific for writing of phylip format files]\n           -idlength => integer - length of the id (will pad w/\n\t\t\t\t\t\t    spaces if needed)\n           -interleaved => boolean - whether interleaved\n                                     or sequential format required\n           -line_length  => integer of how long a sequence lines should be\n           -idlinebreak => insert a line break after the sequence id\n                           so that sequence starts on the next line\n           -flag_SI => whether or not write a \"S\" or \"I\" just after\n                       the num.seq. and line len., in the first line\n           -tag_length => integer of how long the tags have to be in\n                         each line between the space separator. set it\n                         to 0 to have 1 tag only.\n           -wrap_sequential => boolean for whether or not sequential\n                                   format should be broken up or a single line\n                                   default is false (single line)\n           -longid => boolean for allowing arbitrary long IDs (default is false)\n\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n\n  my ($interleave,$linelen,$idlinebreak,\n      $idlength, $flag_SI, $tag_length,$ws, $longid) =\n          $self->_rearrange([qw(INTERLEAVED\n                                LINE_LENGTH\n                                IDLINEBREAK\n                                IDLENGTH\n                                FLAG_SI\n                                TAG_LENGTH\n\t\t\t\tWRAP_SEQUENTIAL\n                                LONGID)],@args);\n  $self->interleaved($interleave ? 1 : 0) if defined $interleave;\n  $self->idlength($idlength || $DEFAULTIDLENGTH);\n  $self->id_linebreak(1) if( $idlinebreak );\n  $self->line_length($linelen) if defined $linelen && $linelen > 0;\n  $self->flag_SI(1) if ( $flag_SI );\n  $self->tag_length($tag_length) if ( $tag_length || $DEFAULTTAGLEN );\n  $self->wrap_sequential($ws ? 1 : 0);\n  $self->longid($longid ? 1 : 0);\n  1;\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream.\n           Throws an exception if trying to read in PHYLIP\n           sequential format.\n Returns : L<Bio::SimpleAlign> object\n Args    :\n\n\nsub next_aln {\n    my $self = shift;\n    my $entry;\n    my ($seqcount, $residuecount, %hash, $name,$str,\n\t@names,$seqname,$start,$end,$count,$seq);\n\n    my $aln =  Bio::SimpleAlign->new(-source => 'phylip');\n    $entry = $self->_readline and\n        ($seqcount, $residuecount) = $entry =~ /\\s*(\\d+)\\s+(\\d+)/;\n    return unless $seqcount and $residuecount;\n\n    # first alignment section\n    my $idlen = $self->idlength;\n    $count = 0;\n    my $iter = 1;\n    my $interleaved = $self->interleaved;\n    while( $entry = $self->_readline) {\n\tlast if( $entry =~ /^\\s?$/ && $interleaved );\n\n\tif( $entry =~ /^\\s+(\\d+)\\s+(\\d+)\\s*$/) {\n\t    $self->_pushback($entry);\n\t    last;\n\t}\n\tif( $self->longid  && $entry =~ /\\w/ ) {\n\t    if ($entry =~ /'/) {\n\t\t$entry =~ /^\\s*'([^']+)'\\s+(.+)$/;\n\t\t$name = $1;\n\t\t$str = $2;\n\t    } else {\n\t\t$entry =~ /^\\s*([^\\s]+)\\s+(.+)$/;\n\t\t$name = $1;\n\t\t$str = $2;\n\t    }\n#\t    $name =~ s/[\\s\\/]/_/g; # not sure how wise is it to do this\n\t    $name =~ s/_+$//; # remove any trailing _'s\n\t    \n\t    push @names, $name;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} = $str;\n\n\t} elsif( $entry =~ /^\\s+(.+)$/ ) {\n\t    $interleaved = 0;\n\t    $str = $1;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} .= $str;\n\t} elsif( $entry =~ /^(.{$idlen})\\s+(.*)\\s$/ ||\n\t\t $entry =~ /^(.{$idlen})(\\S{$idlen}\\s+.+)\\s$/ # Handle weirdnes s when id is too long\n\t\t ) {\n\t    $name = $1;\n\t    $str = $2;\n\t    $name =~ s/[\\s\\/]/_/g;\n\t    $name =~ s/_+$//; # remove any trailing _'s\n\n\t    push @names, $name;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} = $str;\n\t} elsif( $interleaved ) {\n\t    if( $entry =~ /^(\\S+)\\s+(.+)/ ||\n\t\t$entry =~ /^(.{$idlen})(.*)\\s$/ ) {\n\t\t$name = $1;\n\t\t$str = $2;\n\t\t$name =~ s/[\\s\\/]/_/g;\n\t\t$name =~ s/_+$//; # remove any trailing _'s\n\t\tpush @names, $name;\n\t\t$str =~ s/\\s//g;\n\t\t$count = scalar @names;\n\t\t$hash{$count} = $str;\n\t    } else {\n\t\t$self->debug(\"unmatched line: $entry\");\n\t    }\n\t}\n\t$self->throw(\"Not a valid interleaved PHYLIP file!\") if $count > $seqcount;\n    }\n\n    if( $interleaved ) {\n\t# interleaved sections\n\t$count = 0;\n\twhile( $entry = $self->_readline) {\n            # finish current entry\n\t    if($entry =~/\\s*\\d+\\s+\\d+/){\n\t\t$self->_pushback($entry);\n\t\tlast;\n\t    }\n\t    $count = 0, next if $entry =~ /^\\s$/;\n\t    $entry =~ /\\s*(.*)$/ && do {\n\t\t$str = $1;\n\t\t$str =~ s/\\s//g;\n\t\t$count++;\n\t\t$hash{$count} .= $str;\n\t    };\n\t    $self->throw(\"Not a valid interleaved PHYLIP file! [$count,$seqcount] ($entry)\") if $count > $seqcount;\n\t}\n    }\n    return if scalar @names < 1;\n\n    # sequence creation\n    $count = 0;\n    foreach $name ( @names ) {\n\t$count++;\n\tif( $name =~ /(\\S+)\\/(\\d+)-(\\d+)/ ) {\n\t    $seqname = $1;\n\t    $start = $2;\n\t    $end = $3;\n\t} else {\n\t    $seqname=$name;\n\t    $start = 1;\n\t    $str = $hash{$count};\n\t    $str =~ s/[^A-Za-z]//g;\n\t    $end = length($str);\n\t}\n\t# consistency test\n\t$self->throw(\"Length of sequence [$seqname] is not [$residuecount] it is \".CORE::length($hash{$count}).\"! \")\n\t    unless CORE::length($hash{$count}) == $residuecount;\n\n       $seq = Bio::LocatableSeq->new('-seq'=>$hash{$count},\n\t\t\t\t    '-id'=>$seqname,\n\t\t\t\t    '-start'=>$start,\n\t\t\t\t    '-end'=>$end,\n\t\t\t\t   );\n\t$aln->add_seq($seq);\n\n   }\n   return $aln if $aln->num_sequences;\n   return;\n}\n\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the $aln object into the stream in MSF format\n Returns : 1 for success and 0 for error\n Args    : L<Bio::Align::AlignI> object"}},{"name":"floor","kind":12,"line":369},{"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","line":432,"name":"$self","kind":13,"localvar":"my","containerName":"interleaved"},{"line":432,"containerName":"interleaved","kind":13,"name":"$value"},{"kind":13,"containerName":"interleaved","name":"$value","line":433},{"line":434,"name":"$value","kind":13,"containerName":"interleaved"},{"line":434,"kind":13,"containerName":"interleaved","name":"$self"},{"kind":13,"containerName":"interleaved","name":"$self","line":435},{"line":437,"containerName":"interleaved","kind":13,"name":"$self"},{"containerName":"interleaved","kind":13,"name":"$self","line":438}],"name":"interleaved","containerName":"main::","signature":{"label":"interleaved($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: phylip.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::phylip\n#\n# Copyright Heikki Lehvaslaiho\n#\n\n=head1 NAME\n\nBio::AlignIO::phylip - PHYLIP format sequence input/output stream\n\n=head1 SYNOPSIS\n\n# Do not use this module directly.  Use it via the Bio::AlignIO class.\n\n    use Bio::AlignIO;\n    use Bio::SimpleAlign;\n    #you can set the name length to something other than the default 10\n    #if you use a version of phylip (hacked) that accepts ids > 10\n    my $phylipstream = Bio::AlignIO->new(-format  => 'phylip',\n                                        -fh      => \\*STDOUT,\n                                        -idlength=>30);\n    # convert data from one format to another\n    my $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                          -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n    # do it again with phylip sequential format format\n    $phylipstream->interleaved(0);\n    # can also initialize the object like this\n    $phylipstream = Bio::AlignIO->new(-interleaved => 0,\n                                     -format => 'phylip',\n                                     -fh   => \\*STDOUT,\n                                     -idlength=>10);\n    $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                       -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::SimpleAlign objects to and from PHYLIP\nfotmat. By deafult it works with the interleaved format. By specifying\nthe flag -interleaved =E<gt> 0 in the initialization the module can\nread or write data in sequential format.\n\nLong IDs up to 50 characters are supported by flag -longid =E<gt>\n1. ID strings can be surrounded by single quoted. They are mandatory\nonly if the IDs contain spaces. \n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Heikki Lehvaslaiho and Jason Stajich\n\nEmail: heikki at ebi.ac.uk\nEmail: jason at bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::phylip;\nuse vars qw($DEFAULTIDLENGTH $DEFAULTLINELEN $DEFAULTTAGLEN);\nuse strict;\n\nuse Bio::SimpleAlign;\nuse POSIX; # for the rounding call\n\nuse base qw(Bio::AlignIO);\n\nBEGIN {\n    $DEFAULTIDLENGTH = 10;\n    $DEFAULTLINELEN = 60;\n    $DEFAULTTAGLEN = 10;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $alignio = Bio::AlignIO->new(-format => 'phylip'\n\t\t\t\t\t  -file   => '>file',\n\t\t\t\t\t  -idlength => 10,\n\t\t\t\t\t  -idlinebreak => 1);\n Function: Initialize a new L<Bio::AlignIO::phylip> reader or writer\n Returns : L<Bio::AlignIO> object\n Args    : [specific for writing of phylip format files]\n           -idlength => integer - length of the id (will pad w/\n\t\t\t\t\t\t    spaces if needed)\n           -interleaved => boolean - whether interleaved\n                                     or sequential format required\n           -line_length  => integer of how long a sequence lines should be\n           -idlinebreak => insert a line break after the sequence id\n                           so that sequence starts on the next line\n           -flag_SI => whether or not write a \"S\" or \"I\" just after\n                       the num.seq. and line len., in the first line\n           -tag_length => integer of how long the tags have to be in\n                         each line between the space separator. set it\n                         to 0 to have 1 tag only.\n           -wrap_sequential => boolean for whether or not sequential\n                                   format should be broken up or a single line\n                                   default is false (single line)\n           -longid => boolean for allowing arbitrary long IDs (default is false)\n\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n\n  my ($interleave,$linelen,$idlinebreak,\n      $idlength, $flag_SI, $tag_length,$ws, $longid) =\n          $self->_rearrange([qw(INTERLEAVED\n                                LINE_LENGTH\n                                IDLINEBREAK\n                                IDLENGTH\n                                FLAG_SI\n                                TAG_LENGTH\n\t\t\t\tWRAP_SEQUENTIAL\n                                LONGID)],@args);\n  $self->interleaved($interleave ? 1 : 0) if defined $interleave;\n  $self->idlength($idlength || $DEFAULTIDLENGTH);\n  $self->id_linebreak(1) if( $idlinebreak );\n  $self->line_length($linelen) if defined $linelen && $linelen > 0;\n  $self->flag_SI(1) if ( $flag_SI );\n  $self->tag_length($tag_length) if ( $tag_length || $DEFAULTTAGLEN );\n  $self->wrap_sequential($ws ? 1 : 0);\n  $self->longid($longid ? 1 : 0);\n  1;\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream.\n           Throws an exception if trying to read in PHYLIP\n           sequential format.\n Returns : L<Bio::SimpleAlign> object\n Args    :\n\n\nsub next_aln {\n    my $self = shift;\n    my $entry;\n    my ($seqcount, $residuecount, %hash, $name,$str,\n\t@names,$seqname,$start,$end,$count,$seq);\n\n    my $aln =  Bio::SimpleAlign->new(-source => 'phylip');\n    $entry = $self->_readline and\n        ($seqcount, $residuecount) = $entry =~ /\\s*(\\d+)\\s+(\\d+)/;\n    return unless $seqcount and $residuecount;\n\n    # first alignment section\n    my $idlen = $self->idlength;\n    $count = 0;\n    my $iter = 1;\n    my $interleaved = $self->interleaved;\n    while( $entry = $self->_readline) {\n\tlast if( $entry =~ /^\\s?$/ && $interleaved );\n\n\tif( $entry =~ /^\\s+(\\d+)\\s+(\\d+)\\s*$/) {\n\t    $self->_pushback($entry);\n\t    last;\n\t}\n\tif( $self->longid  && $entry =~ /\\w/ ) {\n\t    if ($entry =~ /'/) {\n\t\t$entry =~ /^\\s*'([^']+)'\\s+(.+)$/;\n\t\t$name = $1;\n\t\t$str = $2;\n\t    } else {\n\t\t$entry =~ /^\\s*([^\\s]+)\\s+(.+)$/;\n\t\t$name = $1;\n\t\t$str = $2;\n\t    }\n#\t    $name =~ s/[\\s\\/]/_/g; # not sure how wise is it to do this\n\t    $name =~ s/_+$//; # remove any trailing _'s\n\t    \n\t    push @names, $name;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} = $str;\n\n\t} elsif( $entry =~ /^\\s+(.+)$/ ) {\n\t    $interleaved = 0;\n\t    $str = $1;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} .= $str;\n\t} elsif( $entry =~ /^(.{$idlen})\\s+(.*)\\s$/ ||\n\t\t $entry =~ /^(.{$idlen})(\\S{$idlen}\\s+.+)\\s$/ # Handle weirdnes s when id is too long\n\t\t ) {\n\t    $name = $1;\n\t    $str = $2;\n\t    $name =~ s/[\\s\\/]/_/g;\n\t    $name =~ s/_+$//; # remove any trailing _'s\n\n\t    push @names, $name;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} = $str;\n\t} elsif( $interleaved ) {\n\t    if( $entry =~ /^(\\S+)\\s+(.+)/ ||\n\t\t$entry =~ /^(.{$idlen})(.*)\\s$/ ) {\n\t\t$name = $1;\n\t\t$str = $2;\n\t\t$name =~ s/[\\s\\/]/_/g;\n\t\t$name =~ s/_+$//; # remove any trailing _'s\n\t\tpush @names, $name;\n\t\t$str =~ s/\\s//g;\n\t\t$count = scalar @names;\n\t\t$hash{$count} = $str;\n\t    } else {\n\t\t$self->debug(\"unmatched line: $entry\");\n\t    }\n\t}\n\t$self->throw(\"Not a valid interleaved PHYLIP file!\") if $count > $seqcount;\n    }\n\n    if( $interleaved ) {\n\t# interleaved sections\n\t$count = 0;\n\twhile( $entry = $self->_readline) {\n            # finish current entry\n\t    if($entry =~/\\s*\\d+\\s+\\d+/){\n\t\t$self->_pushback($entry);\n\t\tlast;\n\t    }\n\t    $count = 0, next if $entry =~ /^\\s$/;\n\t    $entry =~ /\\s*(.*)$/ && do {\n\t\t$str = $1;\n\t\t$str =~ s/\\s//g;\n\t\t$count++;\n\t\t$hash{$count} .= $str;\n\t    };\n\t    $self->throw(\"Not a valid interleaved PHYLIP file! [$count,$seqcount] ($entry)\") if $count > $seqcount;\n\t}\n    }\n    return if scalar @names < 1;\n\n    # sequence creation\n    $count = 0;\n    foreach $name ( @names ) {\n\t$count++;\n\tif( $name =~ /(\\S+)\\/(\\d+)-(\\d+)/ ) {\n\t    $seqname = $1;\n\t    $start = $2;\n\t    $end = $3;\n\t} else {\n\t    $seqname=$name;\n\t    $start = 1;\n\t    $str = $hash{$count};\n\t    $str =~ s/[^A-Za-z]//g;\n\t    $end = length($str);\n\t}\n\t# consistency test\n\t$self->throw(\"Length of sequence [$seqname] is not [$residuecount] it is \".CORE::length($hash{$count}).\"! \")\n\t    unless CORE::length($hash{$count}) == $residuecount;\n\n       $seq = Bio::LocatableSeq->new('-seq'=>$hash{$count},\n\t\t\t\t    '-id'=>$seqname,\n\t\t\t\t    '-start'=>$start,\n\t\t\t\t    '-end'=>$end,\n\t\t\t\t   );\n\t$aln->add_seq($seq);\n\n   }\n   return $aln if $aln->num_sequences;\n   return;\n}\n\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the $aln object into the stream in MSF format\n Returns : 1 for success and 0 for error\n Args    : L<Bio::Align::AlignI> object\n\n\nsub write_aln {\n    my ($self,@aln) = @_;\n    my $count = 0;\n    my $wrapped = 0;\n    my $maxname;\n    my $width = $self->line_length();\n    my ($length,$date,$name,$seq,$miss,$pad,\n\t%hash,@arr,$tempcount,$index,$idlength,$flag_SI,$line_length, $tag_length);\n\n    foreach my $aln (@aln) {\n\tif( ! $aln || ! $aln->isa('Bio::Align::AlignI')  ) {\n\t    $self->warn(\"Must provide a Bio::Align::AlignI object when calling write_aln\");\n\t    next;\n\t}\n\t$self->throw(\"All sequences in the alignment must be the same length\")\n\t    unless $aln->is_flush(1) ;\n\n        $flag_SI = $self->flag_SI();\n\t$aln->set_displayname_flat(); # plain\n\t$length  = $aln->length();\n        if ($flag_SI) {\n            if ($self->interleaved() ) {\n                $self->_print (sprintf(\" %s %s I\\n\", $aln->num_sequences, $aln->length));\n            } else {\n                $self->_print (sprintf(\" %s %s S\\n\", $aln->num_sequences, $aln->length));\n            }\n        } else {\n            $self->_print (sprintf(\" %s %s\\n\", $aln->num_sequences, $aln->length));\n        }\n\n\t$idlength = $self->idlength();\n\t$line_length = $self->line_length();\n\t$tag_length = $self->tag_length();\n\tforeach $seq ( $aln->each_seq() ) {\n\t    $name = $aln->displayname($seq->get_nse);\n\t    if ($self->longid) {\n\t\t$self->warn(\"The lenght of the name is over 50 chars long [$name]\") \n\t\t    if length($name) > 50; \n\t\t$name = \"'$name'  \"\n\t    } else {\n\t\t$name = substr($name, 0, $idlength) if length($name) > $idlength;\n\t\t$name = sprintf(\"%-\".$idlength.\"s\",$name);\n\t\tif( $self->interleaved() ) {\n\t\t    $name .= '   ' ;\n\t\t} elsif( $self->id_linebreak) {\n\t\t    $name .= \"\\n\";\n\t\t}\n\t    }\n\t    #phylip needs dashes not dots\n\t    my $seq = $seq->seq();\n\t    $seq =~ s/\\./-/g;\n\t    $hash{$name} = $seq;\n\t    push(@arr,$name);\n\t}\n\n\tif( $self->interleaved() ) {\n            my $numtags;\n            if ($tag_length <= $line_length) {\n                $numtags = floor($line_length/$tag_length);\n                $line_length = $tag_length*$numtags;\n            } else {\n                $numtags = 1;\n            }\n\t    while( $count < $length ) {\n\n\t\t# there is another block to go!\n\t\tforeach $name ( @arr ) {\n\t\t    my $dispname = $name;\n\t\t    $dispname = '' if $wrapped;\n\t\t    $self->_print (sprintf(\"%\".($idlength+3).\"s\",$dispname));\n\t\t    $tempcount = $count;\n                    $index = 0;\n                    $self->debug(\"residue count: $count\\n\") if ($count%100000 == 0);\n\t\t    while( ($tempcount + $tag_length < $length) &&\n\t\t\t   ($index < $numtags)  ) {\n\t\t\t$self->_print (sprintf(\"%s \",substr($hash{$name},\n\t\t\t\t\t\t\t    $tempcount,\n\t\t\t\t\t\t\t    $tag_length)));\n\t\t\t$tempcount += $tag_length;\n\t\t\t$index++;\n\t\t    }\n\t\t    # last\n\t\t    if( $index < $numtags) {\n\t\t\t# space to print!\n\t\t\t$self->_print (sprintf(\"%s \",substr($hash{$name},\n\t\t\t\t\t\t\t    $tempcount)));\n\t\t\t$tempcount += $tag_length;\n\t\t    }\n\t\t    $self->_print (\"\\n\");\n\t\t}\n\t\t$self->_print (\"\\n\");\n\t\t$count = $tempcount;\n\t\t$wrapped = 1;\n\t    }\n\t} else {\n\t    foreach $name ( @arr ) {\n\t\tmy $dispname = $name;\n\t\tmy $line = sprintf(\"%s%s\\n\",$dispname,$hash{$name});\n\t\tif( $self->wrap_sequential ) {\n\t\t    $line =~ s/(.{1,$width})/$1\\n/g;\n\t\t}\n\t\t$self->_print ($line);\n\t    }\n\t}\n    }\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n    return 1;\n}\n\n=head2 interleaved\n\n Title   : interleaved\n Usage   : my $interleaved = $obj->interleaved\n Function: Get/Set Interleaved status\n Returns : boolean\n Args    : boolean"},"line":431,"range":{"end":{"line":439,"character":9999},"start":{"character":0,"line":431}},"kind":12},{"line":454,"range":{"end":{"character":9999,"line":461},"start":{"line":454,"character":0}},"kind":12,"signature":{"label":"flag_SI($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: phylip.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::phylip\n#\n# Copyright Heikki Lehvaslaiho\n#\n\n=head1 NAME\n\nBio::AlignIO::phylip - PHYLIP format sequence input/output stream\n\n=head1 SYNOPSIS\n\n# Do not use this module directly.  Use it via the Bio::AlignIO class.\n\n    use Bio::AlignIO;\n    use Bio::SimpleAlign;\n    #you can set the name length to something other than the default 10\n    #if you use a version of phylip (hacked) that accepts ids > 10\n    my $phylipstream = Bio::AlignIO->new(-format  => 'phylip',\n                                        -fh      => \\*STDOUT,\n                                        -idlength=>30);\n    # convert data from one format to another\n    my $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                          -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n    # do it again with phylip sequential format format\n    $phylipstream->interleaved(0);\n    # can also initialize the object like this\n    $phylipstream = Bio::AlignIO->new(-interleaved => 0,\n                                     -format => 'phylip',\n                                     -fh   => \\*STDOUT,\n                                     -idlength=>10);\n    $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                       -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::SimpleAlign objects to and from PHYLIP\nfotmat. By deafult it works with the interleaved format. By specifying\nthe flag -interleaved =E<gt> 0 in the initialization the module can\nread or write data in sequential format.\n\nLong IDs up to 50 characters are supported by flag -longid =E<gt>\n1. ID strings can be surrounded by single quoted. They are mandatory\nonly if the IDs contain spaces. \n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Heikki Lehvaslaiho and Jason Stajich\n\nEmail: heikki at ebi.ac.uk\nEmail: jason at bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::phylip;\nuse vars qw($DEFAULTIDLENGTH $DEFAULTLINELEN $DEFAULTTAGLEN);\nuse strict;\n\nuse Bio::SimpleAlign;\nuse POSIX; # for the rounding call\n\nuse base qw(Bio::AlignIO);\n\nBEGIN {\n    $DEFAULTIDLENGTH = 10;\n    $DEFAULTLINELEN = 60;\n    $DEFAULTTAGLEN = 10;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $alignio = Bio::AlignIO->new(-format => 'phylip'\n\t\t\t\t\t  -file   => '>file',\n\t\t\t\t\t  -idlength => 10,\n\t\t\t\t\t  -idlinebreak => 1);\n Function: Initialize a new L<Bio::AlignIO::phylip> reader or writer\n Returns : L<Bio::AlignIO> object\n Args    : [specific for writing of phylip format files]\n           -idlength => integer - length of the id (will pad w/\n\t\t\t\t\t\t    spaces if needed)\n           -interleaved => boolean - whether interleaved\n                                     or sequential format required\n           -line_length  => integer of how long a sequence lines should be\n           -idlinebreak => insert a line break after the sequence id\n                           so that sequence starts on the next line\n           -flag_SI => whether or not write a \"S\" or \"I\" just after\n                       the num.seq. and line len., in the first line\n           -tag_length => integer of how long the tags have to be in\n                         each line between the space separator. set it\n                         to 0 to have 1 tag only.\n           -wrap_sequential => boolean for whether or not sequential\n                                   format should be broken up or a single line\n                                   default is false (single line)\n           -longid => boolean for allowing arbitrary long IDs (default is false)\n\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n\n  my ($interleave,$linelen,$idlinebreak,\n      $idlength, $flag_SI, $tag_length,$ws, $longid) =\n          $self->_rearrange([qw(INTERLEAVED\n                                LINE_LENGTH\n                                IDLINEBREAK\n                                IDLENGTH\n                                FLAG_SI\n                                TAG_LENGTH\n\t\t\t\tWRAP_SEQUENTIAL\n                                LONGID)],@args);\n  $self->interleaved($interleave ? 1 : 0) if defined $interleave;\n  $self->idlength($idlength || $DEFAULTIDLENGTH);\n  $self->id_linebreak(1) if( $idlinebreak );\n  $self->line_length($linelen) if defined $linelen && $linelen > 0;\n  $self->flag_SI(1) if ( $flag_SI );\n  $self->tag_length($tag_length) if ( $tag_length || $DEFAULTTAGLEN );\n  $self->wrap_sequential($ws ? 1 : 0);\n  $self->longid($longid ? 1 : 0);\n  1;\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream.\n           Throws an exception if trying to read in PHYLIP\n           sequential format.\n Returns : L<Bio::SimpleAlign> object\n Args    :\n\n\nsub next_aln {\n    my $self = shift;\n    my $entry;\n    my ($seqcount, $residuecount, %hash, $name,$str,\n\t@names,$seqname,$start,$end,$count,$seq);\n\n    my $aln =  Bio::SimpleAlign->new(-source => 'phylip');\n    $entry = $self->_readline and\n        ($seqcount, $residuecount) = $entry =~ /\\s*(\\d+)\\s+(\\d+)/;\n    return unless $seqcount and $residuecount;\n\n    # first alignment section\n    my $idlen = $self->idlength;\n    $count = 0;\n    my $iter = 1;\n    my $interleaved = $self->interleaved;\n    while( $entry = $self->_readline) {\n\tlast if( $entry =~ /^\\s?$/ && $interleaved );\n\n\tif( $entry =~ /^\\s+(\\d+)\\s+(\\d+)\\s*$/) {\n\t    $self->_pushback($entry);\n\t    last;\n\t}\n\tif( $self->longid  && $entry =~ /\\w/ ) {\n\t    if ($entry =~ /'/) {\n\t\t$entry =~ /^\\s*'([^']+)'\\s+(.+)$/;\n\t\t$name = $1;\n\t\t$str = $2;\n\t    } else {\n\t\t$entry =~ /^\\s*([^\\s]+)\\s+(.+)$/;\n\t\t$name = $1;\n\t\t$str = $2;\n\t    }\n#\t    $name =~ s/[\\s\\/]/_/g; # not sure how wise is it to do this\n\t    $name =~ s/_+$//; # remove any trailing _'s\n\t    \n\t    push @names, $name;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} = $str;\n\n\t} elsif( $entry =~ /^\\s+(.+)$/ ) {\n\t    $interleaved = 0;\n\t    $str = $1;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} .= $str;\n\t} elsif( $entry =~ /^(.{$idlen})\\s+(.*)\\s$/ ||\n\t\t $entry =~ /^(.{$idlen})(\\S{$idlen}\\s+.+)\\s$/ # Handle weirdnes s when id is too long\n\t\t ) {\n\t    $name = $1;\n\t    $str = $2;\n\t    $name =~ s/[\\s\\/]/_/g;\n\t    $name =~ s/_+$//; # remove any trailing _'s\n\n\t    push @names, $name;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} = $str;\n\t} elsif( $interleaved ) {\n\t    if( $entry =~ /^(\\S+)\\s+(.+)/ ||\n\t\t$entry =~ /^(.{$idlen})(.*)\\s$/ ) {\n\t\t$name = $1;\n\t\t$str = $2;\n\t\t$name =~ s/[\\s\\/]/_/g;\n\t\t$name =~ s/_+$//; # remove any trailing _'s\n\t\tpush @names, $name;\n\t\t$str =~ s/\\s//g;\n\t\t$count = scalar @names;\n\t\t$hash{$count} = $str;\n\t    } else {\n\t\t$self->debug(\"unmatched line: $entry\");\n\t    }\n\t}\n\t$self->throw(\"Not a valid interleaved PHYLIP file!\") if $count > $seqcount;\n    }\n\n    if( $interleaved ) {\n\t# interleaved sections\n\t$count = 0;\n\twhile( $entry = $self->_readline) {\n            # finish current entry\n\t    if($entry =~/\\s*\\d+\\s+\\d+/){\n\t\t$self->_pushback($entry);\n\t\tlast;\n\t    }\n\t    $count = 0, next if $entry =~ /^\\s$/;\n\t    $entry =~ /\\s*(.*)$/ && do {\n\t\t$str = $1;\n\t\t$str =~ s/\\s//g;\n\t\t$count++;\n\t\t$hash{$count} .= $str;\n\t    };\n\t    $self->throw(\"Not a valid interleaved PHYLIP file! [$count,$seqcount] ($entry)\") if $count > $seqcount;\n\t}\n    }\n    return if scalar @names < 1;\n\n    # sequence creation\n    $count = 0;\n    foreach $name ( @names ) {\n\t$count++;\n\tif( $name =~ /(\\S+)\\/(\\d+)-(\\d+)/ ) {\n\t    $seqname = $1;\n\t    $start = $2;\n\t    $end = $3;\n\t} else {\n\t    $seqname=$name;\n\t    $start = 1;\n\t    $str = $hash{$count};\n\t    $str =~ s/[^A-Za-z]//g;\n\t    $end = length($str);\n\t}\n\t# consistency test\n\t$self->throw(\"Length of sequence [$seqname] is not [$residuecount] it is \".CORE::length($hash{$count}).\"! \")\n\t    unless CORE::length($hash{$count}) == $residuecount;\n\n       $seq = Bio::LocatableSeq->new('-seq'=>$hash{$count},\n\t\t\t\t    '-id'=>$seqname,\n\t\t\t\t    '-start'=>$start,\n\t\t\t\t    '-end'=>$end,\n\t\t\t\t   );\n\t$aln->add_seq($seq);\n\n   }\n   return $aln if $aln->num_sequences;\n   return;\n}\n\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the $aln object into the stream in MSF format\n Returns : 1 for success and 0 for error\n Args    : L<Bio::Align::AlignI> object\n\n\nsub write_aln {\n    my ($self,@aln) = @_;\n    my $count = 0;\n    my $wrapped = 0;\n    my $maxname;\n    my $width = $self->line_length();\n    my ($length,$date,$name,$seq,$miss,$pad,\n\t%hash,@arr,$tempcount,$index,$idlength,$flag_SI,$line_length, $tag_length);\n\n    foreach my $aln (@aln) {\n\tif( ! $aln || ! $aln->isa('Bio::Align::AlignI')  ) {\n\t    $self->warn(\"Must provide a Bio::Align::AlignI object when calling write_aln\");\n\t    next;\n\t}\n\t$self->throw(\"All sequences in the alignment must be the same length\")\n\t    unless $aln->is_flush(1) ;\n\n        $flag_SI = $self->flag_SI();\n\t$aln->set_displayname_flat(); # plain\n\t$length  = $aln->length();\n        if ($flag_SI) {\n            if ($self->interleaved() ) {\n                $self->_print (sprintf(\" %s %s I\\n\", $aln->num_sequences, $aln->length));\n            } else {\n                $self->_print (sprintf(\" %s %s S\\n\", $aln->num_sequences, $aln->length));\n            }\n        } else {\n            $self->_print (sprintf(\" %s %s\\n\", $aln->num_sequences, $aln->length));\n        }\n\n\t$idlength = $self->idlength();\n\t$line_length = $self->line_length();\n\t$tag_length = $self->tag_length();\n\tforeach $seq ( $aln->each_seq() ) {\n\t    $name = $aln->displayname($seq->get_nse);\n\t    if ($self->longid) {\n\t\t$self->warn(\"The lenght of the name is over 50 chars long [$name]\") \n\t\t    if length($name) > 50; \n\t\t$name = \"'$name'  \"\n\t    } else {\n\t\t$name = substr($name, 0, $idlength) if length($name) > $idlength;\n\t\t$name = sprintf(\"%-\".$idlength.\"s\",$name);\n\t\tif( $self->interleaved() ) {\n\t\t    $name .= '   ' ;\n\t\t} elsif( $self->id_linebreak) {\n\t\t    $name .= \"\\n\";\n\t\t}\n\t    }\n\t    #phylip needs dashes not dots\n\t    my $seq = $seq->seq();\n\t    $seq =~ s/\\./-/g;\n\t    $hash{$name} = $seq;\n\t    push(@arr,$name);\n\t}\n\n\tif( $self->interleaved() ) {\n            my $numtags;\n            if ($tag_length <= $line_length) {\n                $numtags = floor($line_length/$tag_length);\n                $line_length = $tag_length*$numtags;\n            } else {\n                $numtags = 1;\n            }\n\t    while( $count < $length ) {\n\n\t\t# there is another block to go!\n\t\tforeach $name ( @arr ) {\n\t\t    my $dispname = $name;\n\t\t    $dispname = '' if $wrapped;\n\t\t    $self->_print (sprintf(\"%\".($idlength+3).\"s\",$dispname));\n\t\t    $tempcount = $count;\n                    $index = 0;\n                    $self->debug(\"residue count: $count\\n\") if ($count%100000 == 0);\n\t\t    while( ($tempcount + $tag_length < $length) &&\n\t\t\t   ($index < $numtags)  ) {\n\t\t\t$self->_print (sprintf(\"%s \",substr($hash{$name},\n\t\t\t\t\t\t\t    $tempcount,\n\t\t\t\t\t\t\t    $tag_length)));\n\t\t\t$tempcount += $tag_length;\n\t\t\t$index++;\n\t\t    }\n\t\t    # last\n\t\t    if( $index < $numtags) {\n\t\t\t# space to print!\n\t\t\t$self->_print (sprintf(\"%s \",substr($hash{$name},\n\t\t\t\t\t\t\t    $tempcount)));\n\t\t\t$tempcount += $tag_length;\n\t\t    }\n\t\t    $self->_print (\"\\n\");\n\t\t}\n\t\t$self->_print (\"\\n\");\n\t\t$count = $tempcount;\n\t\t$wrapped = 1;\n\t    }\n\t} else {\n\t    foreach $name ( @arr ) {\n\t\tmy $dispname = $name;\n\t\tmy $line = sprintf(\"%s%s\\n\",$dispname,$hash{$name});\n\t\tif( $self->wrap_sequential ) {\n\t\t    $line =~ s/(.{1,$width})/$1\\n/g;\n\t\t}\n\t\t$self->_print ($line);\n\t    }\n\t}\n    }\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n    return 1;\n}\n\n=head2 interleaved\n\n Title   : interleaved\n Usage   : my $interleaved = $obj->interleaved\n Function: Get/Set Interleaved status\n Returns : boolean\n Args    : boolean\n\n\n\nsub interleaved {\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       if ($value) {$self->{'_interleaved'} = 1 }\n       else {$self->{'_interleaved'} = 0 }\n   }\n   return 1 unless defined $self->{'_interleaved'};\n   return $self->{'_interleaved'};\n}\n\n=head2 flag_SI\n\n Title   : flag_SI\n Usage   : my $flag = $obj->flag_SI\n Function: Get/Set if the Sequential/Interleaved flag has to be shown\n           after the number of sequences and sequence length\n Example :\n Returns : boolean\n Args    : boolean"},"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"flag_SI","line":455,"definition":"my"},{"line":455,"containerName":"flag_SI","kind":13,"name":"$value"},{"line":456,"name":"$previous","localvar":"my","kind":13,"containerName":"flag_SI","definition":"my"},{"name":"$self","containerName":"flag_SI","kind":13,"line":456},{"name":"$value","containerName":"flag_SI","kind":13,"line":457},{"line":458,"name":"$self","containerName":"flag_SI","kind":13},{"line":458,"name":"$value","kind":13,"containerName":"flag_SI"},{"line":460,"name":"$previous","containerName":"flag_SI","kind":13}],"containerName":"main::","name":"flag_SI","definition":"sub","detail":"($self,$value)"},{"signature":{"label":"idlength($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: phylip.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::phylip\n#\n# Copyright Heikki Lehvaslaiho\n#\n\n=head1 NAME\n\nBio::AlignIO::phylip - PHYLIP format sequence input/output stream\n\n=head1 SYNOPSIS\n\n# Do not use this module directly.  Use it via the Bio::AlignIO class.\n\n    use Bio::AlignIO;\n    use Bio::SimpleAlign;\n    #you can set the name length to something other than the default 10\n    #if you use a version of phylip (hacked) that accepts ids > 10\n    my $phylipstream = Bio::AlignIO->new(-format  => 'phylip',\n                                        -fh      => \\*STDOUT,\n                                        -idlength=>30);\n    # convert data from one format to another\n    my $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                          -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n    # do it again with phylip sequential format format\n    $phylipstream->interleaved(0);\n    # can also initialize the object like this\n    $phylipstream = Bio::AlignIO->new(-interleaved => 0,\n                                     -format => 'phylip',\n                                     -fh   => \\*STDOUT,\n                                     -idlength=>10);\n    $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                       -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::SimpleAlign objects to and from PHYLIP\nfotmat. By deafult it works with the interleaved format. By specifying\nthe flag -interleaved =E<gt> 0 in the initialization the module can\nread or write data in sequential format.\n\nLong IDs up to 50 characters are supported by flag -longid =E<gt>\n1. ID strings can be surrounded by single quoted. They are mandatory\nonly if the IDs contain spaces. \n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Heikki Lehvaslaiho and Jason Stajich\n\nEmail: heikki at ebi.ac.uk\nEmail: jason at bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::phylip;\nuse vars qw($DEFAULTIDLENGTH $DEFAULTLINELEN $DEFAULTTAGLEN);\nuse strict;\n\nuse Bio::SimpleAlign;\nuse POSIX; # for the rounding call\n\nuse base qw(Bio::AlignIO);\n\nBEGIN {\n    $DEFAULTIDLENGTH = 10;\n    $DEFAULTLINELEN = 60;\n    $DEFAULTTAGLEN = 10;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $alignio = Bio::AlignIO->new(-format => 'phylip'\n\t\t\t\t\t  -file   => '>file',\n\t\t\t\t\t  -idlength => 10,\n\t\t\t\t\t  -idlinebreak => 1);\n Function: Initialize a new L<Bio::AlignIO::phylip> reader or writer\n Returns : L<Bio::AlignIO> object\n Args    : [specific for writing of phylip format files]\n           -idlength => integer - length of the id (will pad w/\n\t\t\t\t\t\t    spaces if needed)\n           -interleaved => boolean - whether interleaved\n                                     or sequential format required\n           -line_length  => integer of how long a sequence lines should be\n           -idlinebreak => insert a line break after the sequence id\n                           so that sequence starts on the next line\n           -flag_SI => whether or not write a \"S\" or \"I\" just after\n                       the num.seq. and line len., in the first line\n           -tag_length => integer of how long the tags have to be in\n                         each line between the space separator. set it\n                         to 0 to have 1 tag only.\n           -wrap_sequential => boolean for whether or not sequential\n                                   format should be broken up or a single line\n                                   default is false (single line)\n           -longid => boolean for allowing arbitrary long IDs (default is false)\n\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n\n  my ($interleave,$linelen,$idlinebreak,\n      $idlength, $flag_SI, $tag_length,$ws, $longid) =\n          $self->_rearrange([qw(INTERLEAVED\n                                LINE_LENGTH\n                                IDLINEBREAK\n                                IDLENGTH\n                                FLAG_SI\n                                TAG_LENGTH\n\t\t\t\tWRAP_SEQUENTIAL\n                                LONGID)],@args);\n  $self->interleaved($interleave ? 1 : 0) if defined $interleave;\n  $self->idlength($idlength || $DEFAULTIDLENGTH);\n  $self->id_linebreak(1) if( $idlinebreak );\n  $self->line_length($linelen) if defined $linelen && $linelen > 0;\n  $self->flag_SI(1) if ( $flag_SI );\n  $self->tag_length($tag_length) if ( $tag_length || $DEFAULTTAGLEN );\n  $self->wrap_sequential($ws ? 1 : 0);\n  $self->longid($longid ? 1 : 0);\n  1;\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream.\n           Throws an exception if trying to read in PHYLIP\n           sequential format.\n Returns : L<Bio::SimpleAlign> object\n Args    :\n\n\nsub next_aln {\n    my $self = shift;\n    my $entry;\n    my ($seqcount, $residuecount, %hash, $name,$str,\n\t@names,$seqname,$start,$end,$count,$seq);\n\n    my $aln =  Bio::SimpleAlign->new(-source => 'phylip');\n    $entry = $self->_readline and\n        ($seqcount, $residuecount) = $entry =~ /\\s*(\\d+)\\s+(\\d+)/;\n    return unless $seqcount and $residuecount;\n\n    # first alignment section\n    my $idlen = $self->idlength;\n    $count = 0;\n    my $iter = 1;\n    my $interleaved = $self->interleaved;\n    while( $entry = $self->_readline) {\n\tlast if( $entry =~ /^\\s?$/ && $interleaved );\n\n\tif( $entry =~ /^\\s+(\\d+)\\s+(\\d+)\\s*$/) {\n\t    $self->_pushback($entry);\n\t    last;\n\t}\n\tif( $self->longid  && $entry =~ /\\w/ ) {\n\t    if ($entry =~ /'/) {\n\t\t$entry =~ /^\\s*'([^']+)'\\s+(.+)$/;\n\t\t$name = $1;\n\t\t$str = $2;\n\t    } else {\n\t\t$entry =~ /^\\s*([^\\s]+)\\s+(.+)$/;\n\t\t$name = $1;\n\t\t$str = $2;\n\t    }\n#\t    $name =~ s/[\\s\\/]/_/g; # not sure how wise is it to do this\n\t    $name =~ s/_+$//; # remove any trailing _'s\n\t    \n\t    push @names, $name;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} = $str;\n\n\t} elsif( $entry =~ /^\\s+(.+)$/ ) {\n\t    $interleaved = 0;\n\t    $str = $1;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} .= $str;\n\t} elsif( $entry =~ /^(.{$idlen})\\s+(.*)\\s$/ ||\n\t\t $entry =~ /^(.{$idlen})(\\S{$idlen}\\s+.+)\\s$/ # Handle weirdnes s when id is too long\n\t\t ) {\n\t    $name = $1;\n\t    $str = $2;\n\t    $name =~ s/[\\s\\/]/_/g;\n\t    $name =~ s/_+$//; # remove any trailing _'s\n\n\t    push @names, $name;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} = $str;\n\t} elsif( $interleaved ) {\n\t    if( $entry =~ /^(\\S+)\\s+(.+)/ ||\n\t\t$entry =~ /^(.{$idlen})(.*)\\s$/ ) {\n\t\t$name = $1;\n\t\t$str = $2;\n\t\t$name =~ s/[\\s\\/]/_/g;\n\t\t$name =~ s/_+$//; # remove any trailing _'s\n\t\tpush @names, $name;\n\t\t$str =~ s/\\s//g;\n\t\t$count = scalar @names;\n\t\t$hash{$count} = $str;\n\t    } else {\n\t\t$self->debug(\"unmatched line: $entry\");\n\t    }\n\t}\n\t$self->throw(\"Not a valid interleaved PHYLIP file!\") if $count > $seqcount;\n    }\n\n    if( $interleaved ) {\n\t# interleaved sections\n\t$count = 0;\n\twhile( $entry = $self->_readline) {\n            # finish current entry\n\t    if($entry =~/\\s*\\d+\\s+\\d+/){\n\t\t$self->_pushback($entry);\n\t\tlast;\n\t    }\n\t    $count = 0, next if $entry =~ /^\\s$/;\n\t    $entry =~ /\\s*(.*)$/ && do {\n\t\t$str = $1;\n\t\t$str =~ s/\\s//g;\n\t\t$count++;\n\t\t$hash{$count} .= $str;\n\t    };\n\t    $self->throw(\"Not a valid interleaved PHYLIP file! [$count,$seqcount] ($entry)\") if $count > $seqcount;\n\t}\n    }\n    return if scalar @names < 1;\n\n    # sequence creation\n    $count = 0;\n    foreach $name ( @names ) {\n\t$count++;\n\tif( $name =~ /(\\S+)\\/(\\d+)-(\\d+)/ ) {\n\t    $seqname = $1;\n\t    $start = $2;\n\t    $end = $3;\n\t} else {\n\t    $seqname=$name;\n\t    $start = 1;\n\t    $str = $hash{$count};\n\t    $str =~ s/[^A-Za-z]//g;\n\t    $end = length($str);\n\t}\n\t# consistency test\n\t$self->throw(\"Length of sequence [$seqname] is not [$residuecount] it is \".CORE::length($hash{$count}).\"! \")\n\t    unless CORE::length($hash{$count}) == $residuecount;\n\n       $seq = Bio::LocatableSeq->new('-seq'=>$hash{$count},\n\t\t\t\t    '-id'=>$seqname,\n\t\t\t\t    '-start'=>$start,\n\t\t\t\t    '-end'=>$end,\n\t\t\t\t   );\n\t$aln->add_seq($seq);\n\n   }\n   return $aln if $aln->num_sequences;\n   return;\n}\n\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the $aln object into the stream in MSF format\n Returns : 1 for success and 0 for error\n Args    : L<Bio::Align::AlignI> object\n\n\nsub write_aln {\n    my ($self,@aln) = @_;\n    my $count = 0;\n    my $wrapped = 0;\n    my $maxname;\n    my $width = $self->line_length();\n    my ($length,$date,$name,$seq,$miss,$pad,\n\t%hash,@arr,$tempcount,$index,$idlength,$flag_SI,$line_length, $tag_length);\n\n    foreach my $aln (@aln) {\n\tif( ! $aln || ! $aln->isa('Bio::Align::AlignI')  ) {\n\t    $self->warn(\"Must provide a Bio::Align::AlignI object when calling write_aln\");\n\t    next;\n\t}\n\t$self->throw(\"All sequences in the alignment must be the same length\")\n\t    unless $aln->is_flush(1) ;\n\n        $flag_SI = $self->flag_SI();\n\t$aln->set_displayname_flat(); # plain\n\t$length  = $aln->length();\n        if ($flag_SI) {\n            if ($self->interleaved() ) {\n                $self->_print (sprintf(\" %s %s I\\n\", $aln->num_sequences, $aln->length));\n            } else {\n                $self->_print (sprintf(\" %s %s S\\n\", $aln->num_sequences, $aln->length));\n            }\n        } else {\n            $self->_print (sprintf(\" %s %s\\n\", $aln->num_sequences, $aln->length));\n        }\n\n\t$idlength = $self->idlength();\n\t$line_length = $self->line_length();\n\t$tag_length = $self->tag_length();\n\tforeach $seq ( $aln->each_seq() ) {\n\t    $name = $aln->displayname($seq->get_nse);\n\t    if ($self->longid) {\n\t\t$self->warn(\"The lenght of the name is over 50 chars long [$name]\") \n\t\t    if length($name) > 50; \n\t\t$name = \"'$name'  \"\n\t    } else {\n\t\t$name = substr($name, 0, $idlength) if length($name) > $idlength;\n\t\t$name = sprintf(\"%-\".$idlength.\"s\",$name);\n\t\tif( $self->interleaved() ) {\n\t\t    $name .= '   ' ;\n\t\t} elsif( $self->id_linebreak) {\n\t\t    $name .= \"\\n\";\n\t\t}\n\t    }\n\t    #phylip needs dashes not dots\n\t    my $seq = $seq->seq();\n\t    $seq =~ s/\\./-/g;\n\t    $hash{$name} = $seq;\n\t    push(@arr,$name);\n\t}\n\n\tif( $self->interleaved() ) {\n            my $numtags;\n            if ($tag_length <= $line_length) {\n                $numtags = floor($line_length/$tag_length);\n                $line_length = $tag_length*$numtags;\n            } else {\n                $numtags = 1;\n            }\n\t    while( $count < $length ) {\n\n\t\t# there is another block to go!\n\t\tforeach $name ( @arr ) {\n\t\t    my $dispname = $name;\n\t\t    $dispname = '' if $wrapped;\n\t\t    $self->_print (sprintf(\"%\".($idlength+3).\"s\",$dispname));\n\t\t    $tempcount = $count;\n                    $index = 0;\n                    $self->debug(\"residue count: $count\\n\") if ($count%100000 == 0);\n\t\t    while( ($tempcount + $tag_length < $length) &&\n\t\t\t   ($index < $numtags)  ) {\n\t\t\t$self->_print (sprintf(\"%s \",substr($hash{$name},\n\t\t\t\t\t\t\t    $tempcount,\n\t\t\t\t\t\t\t    $tag_length)));\n\t\t\t$tempcount += $tag_length;\n\t\t\t$index++;\n\t\t    }\n\t\t    # last\n\t\t    if( $index < $numtags) {\n\t\t\t# space to print!\n\t\t\t$self->_print (sprintf(\"%s \",substr($hash{$name},\n\t\t\t\t\t\t\t    $tempcount)));\n\t\t\t$tempcount += $tag_length;\n\t\t    }\n\t\t    $self->_print (\"\\n\");\n\t\t}\n\t\t$self->_print (\"\\n\");\n\t\t$count = $tempcount;\n\t\t$wrapped = 1;\n\t    }\n\t} else {\n\t    foreach $name ( @arr ) {\n\t\tmy $dispname = $name;\n\t\tmy $line = sprintf(\"%s%s\\n\",$dispname,$hash{$name});\n\t\tif( $self->wrap_sequential ) {\n\t\t    $line =~ s/(.{1,$width})/$1\\n/g;\n\t\t}\n\t\t$self->_print ($line);\n\t    }\n\t}\n    }\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n    return 1;\n}\n\n=head2 interleaved\n\n Title   : interleaved\n Usage   : my $interleaved = $obj->interleaved\n Function: Get/Set Interleaved status\n Returns : boolean\n Args    : boolean\n\n\n\nsub interleaved {\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       if ($value) {$self->{'_interleaved'} = 1 }\n       else {$self->{'_interleaved'} = 0 }\n   }\n   return 1 unless defined $self->{'_interleaved'};\n   return $self->{'_interleaved'};\n}\n\n=head2 flag_SI\n\n Title   : flag_SI\n Usage   : my $flag = $obj->flag_SI\n Function: Get/Set if the Sequential/Interleaved flag has to be shown\n           after the number of sequences and sequence length\n Example :\n Returns : boolean\n Args    : boolean\n\n\n\nsub flag_SI{\n   my ($self,$value) = @_;\n   my $previous = $self->{'_flag_SI'};\n   if( defined $value ) {\n       $self->{'_flag_SI'} = $value;\n   }\n   return $previous;\n}\n\n=head2 idlength\n\n Title   : idlength\n Usage   : my $idlength = $obj->idlength\n Function: Get/Set value of id length\n Returns : string\n Args    : string"},"line":474,"range":{"start":{"character":0,"line":474},"end":{"character":9999,"line":480}},"kind":12,"definition":"sub","detail":"($self,$value)","children":[{"line":475,"name":"$self","localvar":"my","kind":13,"containerName":"idlength","definition":"my"},{"line":475,"kind":13,"containerName":"idlength","name":"$value"},{"line":476,"kind":13,"containerName":"idlength","name":"$value"},{"line":477,"name":"$self","kind":13,"containerName":"idlength"},{"line":477,"containerName":"idlength","kind":13,"name":"$value"},{"containerName":"idlength","kind":13,"name":"$self","line":479}],"name":"idlength","containerName":"main::"},{"name":"line_length","containerName":"main::","children":[{"name":"$self","containerName":"line_length","localvar":"my","kind":13,"line":494,"definition":"my"},{"name":"$value","containerName":"line_length","kind":13,"line":494},{"line":495,"name":"$value","kind":13,"containerName":"line_length"},{"line":496,"containerName":"line_length","kind":13,"name":"$self"},{"name":"$value","kind":13,"containerName":"line_length","line":496},{"kind":13,"containerName":"line_length","name":"$self","line":498},{"name":"$DEFAULTLINELEN","containerName":"line_length","kind":13,"line":498}],"detail":"($self,$value)","definition":"sub","range":{"end":{"line":500,"character":9999},"start":{"character":0,"line":493}},"kind":12,"line":493,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: phylip.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::phylip\n#\n# Copyright Heikki Lehvaslaiho\n#\n\n=head1 NAME\n\nBio::AlignIO::phylip - PHYLIP format sequence input/output stream\n\n=head1 SYNOPSIS\n\n# Do not use this module directly.  Use it via the Bio::AlignIO class.\n\n    use Bio::AlignIO;\n    use Bio::SimpleAlign;\n    #you can set the name length to something other than the default 10\n    #if you use a version of phylip (hacked) that accepts ids > 10\n    my $phylipstream = Bio::AlignIO->new(-format  => 'phylip',\n                                        -fh      => \\*STDOUT,\n                                        -idlength=>30);\n    # convert data from one format to another\n    my $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                          -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n    # do it again with phylip sequential format format\n    $phylipstream->interleaved(0);\n    # can also initialize the object like this\n    $phylipstream = Bio::AlignIO->new(-interleaved => 0,\n                                     -format => 'phylip',\n                                     -fh   => \\*STDOUT,\n                                     -idlength=>10);\n    $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                       -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::SimpleAlign objects to and from PHYLIP\nfotmat. By deafult it works with the interleaved format. By specifying\nthe flag -interleaved =E<gt> 0 in the initialization the module can\nread or write data in sequential format.\n\nLong IDs up to 50 characters are supported by flag -longid =E<gt>\n1. ID strings can be surrounded by single quoted. They are mandatory\nonly if the IDs contain spaces. \n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Heikki Lehvaslaiho and Jason Stajich\n\nEmail: heikki at ebi.ac.uk\nEmail: jason at bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::phylip;\nuse vars qw($DEFAULTIDLENGTH $DEFAULTLINELEN $DEFAULTTAGLEN);\nuse strict;\n\nuse Bio::SimpleAlign;\nuse POSIX; # for the rounding call\n\nuse base qw(Bio::AlignIO);\n\nBEGIN {\n    $DEFAULTIDLENGTH = 10;\n    $DEFAULTLINELEN = 60;\n    $DEFAULTTAGLEN = 10;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $alignio = Bio::AlignIO->new(-format => 'phylip'\n\t\t\t\t\t  -file   => '>file',\n\t\t\t\t\t  -idlength => 10,\n\t\t\t\t\t  -idlinebreak => 1);\n Function: Initialize a new L<Bio::AlignIO::phylip> reader or writer\n Returns : L<Bio::AlignIO> object\n Args    : [specific for writing of phylip format files]\n           -idlength => integer - length of the id (will pad w/\n\t\t\t\t\t\t    spaces if needed)\n           -interleaved => boolean - whether interleaved\n                                     or sequential format required\n           -line_length  => integer of how long a sequence lines should be\n           -idlinebreak => insert a line break after the sequence id\n                           so that sequence starts on the next line\n           -flag_SI => whether or not write a \"S\" or \"I\" just after\n                       the num.seq. and line len., in the first line\n           -tag_length => integer of how long the tags have to be in\n                         each line between the space separator. set it\n                         to 0 to have 1 tag only.\n           -wrap_sequential => boolean for whether or not sequential\n                                   format should be broken up or a single line\n                                   default is false (single line)\n           -longid => boolean for allowing arbitrary long IDs (default is false)\n\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n\n  my ($interleave,$linelen,$idlinebreak,\n      $idlength, $flag_SI, $tag_length,$ws, $longid) =\n          $self->_rearrange([qw(INTERLEAVED\n                                LINE_LENGTH\n                                IDLINEBREAK\n                                IDLENGTH\n                                FLAG_SI\n                                TAG_LENGTH\n\t\t\t\tWRAP_SEQUENTIAL\n                                LONGID)],@args);\n  $self->interleaved($interleave ? 1 : 0) if defined $interleave;\n  $self->idlength($idlength || $DEFAULTIDLENGTH);\n  $self->id_linebreak(1) if( $idlinebreak );\n  $self->line_length($linelen) if defined $linelen && $linelen > 0;\n  $self->flag_SI(1) if ( $flag_SI );\n  $self->tag_length($tag_length) if ( $tag_length || $DEFAULTTAGLEN );\n  $self->wrap_sequential($ws ? 1 : 0);\n  $self->longid($longid ? 1 : 0);\n  1;\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream.\n           Throws an exception if trying to read in PHYLIP\n           sequential format.\n Returns : L<Bio::SimpleAlign> object\n Args    :\n\n\nsub next_aln {\n    my $self = shift;\n    my $entry;\n    my ($seqcount, $residuecount, %hash, $name,$str,\n\t@names,$seqname,$start,$end,$count,$seq);\n\n    my $aln =  Bio::SimpleAlign->new(-source => 'phylip');\n    $entry = $self->_readline and\n        ($seqcount, $residuecount) = $entry =~ /\\s*(\\d+)\\s+(\\d+)/;\n    return unless $seqcount and $residuecount;\n\n    # first alignment section\n    my $idlen = $self->idlength;\n    $count = 0;\n    my $iter = 1;\n    my $interleaved = $self->interleaved;\n    while( $entry = $self->_readline) {\n\tlast if( $entry =~ /^\\s?$/ && $interleaved );\n\n\tif( $entry =~ /^\\s+(\\d+)\\s+(\\d+)\\s*$/) {\n\t    $self->_pushback($entry);\n\t    last;\n\t}\n\tif( $self->longid  && $entry =~ /\\w/ ) {\n\t    if ($entry =~ /'/) {\n\t\t$entry =~ /^\\s*'([^']+)'\\s+(.+)$/;\n\t\t$name = $1;\n\t\t$str = $2;\n\t    } else {\n\t\t$entry =~ /^\\s*([^\\s]+)\\s+(.+)$/;\n\t\t$name = $1;\n\t\t$str = $2;\n\t    }\n#\t    $name =~ s/[\\s\\/]/_/g; # not sure how wise is it to do this\n\t    $name =~ s/_+$//; # remove any trailing _'s\n\t    \n\t    push @names, $name;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} = $str;\n\n\t} elsif( $entry =~ /^\\s+(.+)$/ ) {\n\t    $interleaved = 0;\n\t    $str = $1;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} .= $str;\n\t} elsif( $entry =~ /^(.{$idlen})\\s+(.*)\\s$/ ||\n\t\t $entry =~ /^(.{$idlen})(\\S{$idlen}\\s+.+)\\s$/ # Handle weirdnes s when id is too long\n\t\t ) {\n\t    $name = $1;\n\t    $str = $2;\n\t    $name =~ s/[\\s\\/]/_/g;\n\t    $name =~ s/_+$//; # remove any trailing _'s\n\n\t    push @names, $name;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} = $str;\n\t} elsif( $interleaved ) {\n\t    if( $entry =~ /^(\\S+)\\s+(.+)/ ||\n\t\t$entry =~ /^(.{$idlen})(.*)\\s$/ ) {\n\t\t$name = $1;\n\t\t$str = $2;\n\t\t$name =~ s/[\\s\\/]/_/g;\n\t\t$name =~ s/_+$//; # remove any trailing _'s\n\t\tpush @names, $name;\n\t\t$str =~ s/\\s//g;\n\t\t$count = scalar @names;\n\t\t$hash{$count} = $str;\n\t    } else {\n\t\t$self->debug(\"unmatched line: $entry\");\n\t    }\n\t}\n\t$self->throw(\"Not a valid interleaved PHYLIP file!\") if $count > $seqcount;\n    }\n\n    if( $interleaved ) {\n\t# interleaved sections\n\t$count = 0;\n\twhile( $entry = $self->_readline) {\n            # finish current entry\n\t    if($entry =~/\\s*\\d+\\s+\\d+/){\n\t\t$self->_pushback($entry);\n\t\tlast;\n\t    }\n\t    $count = 0, next if $entry =~ /^\\s$/;\n\t    $entry =~ /\\s*(.*)$/ && do {\n\t\t$str = $1;\n\t\t$str =~ s/\\s//g;\n\t\t$count++;\n\t\t$hash{$count} .= $str;\n\t    };\n\t    $self->throw(\"Not a valid interleaved PHYLIP file! [$count,$seqcount] ($entry)\") if $count > $seqcount;\n\t}\n    }\n    return if scalar @names < 1;\n\n    # sequence creation\n    $count = 0;\n    foreach $name ( @names ) {\n\t$count++;\n\tif( $name =~ /(\\S+)\\/(\\d+)-(\\d+)/ ) {\n\t    $seqname = $1;\n\t    $start = $2;\n\t    $end = $3;\n\t} else {\n\t    $seqname=$name;\n\t    $start = 1;\n\t    $str = $hash{$count};\n\t    $str =~ s/[^A-Za-z]//g;\n\t    $end = length($str);\n\t}\n\t# consistency test\n\t$self->throw(\"Length of sequence [$seqname] is not [$residuecount] it is \".CORE::length($hash{$count}).\"! \")\n\t    unless CORE::length($hash{$count}) == $residuecount;\n\n       $seq = Bio::LocatableSeq->new('-seq'=>$hash{$count},\n\t\t\t\t    '-id'=>$seqname,\n\t\t\t\t    '-start'=>$start,\n\t\t\t\t    '-end'=>$end,\n\t\t\t\t   );\n\t$aln->add_seq($seq);\n\n   }\n   return $aln if $aln->num_sequences;\n   return;\n}\n\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the $aln object into the stream in MSF format\n Returns : 1 for success and 0 for error\n Args    : L<Bio::Align::AlignI> object\n\n\nsub write_aln {\n    my ($self,@aln) = @_;\n    my $count = 0;\n    my $wrapped = 0;\n    my $maxname;\n    my $width = $self->line_length();\n    my ($length,$date,$name,$seq,$miss,$pad,\n\t%hash,@arr,$tempcount,$index,$idlength,$flag_SI,$line_length, $tag_length);\n\n    foreach my $aln (@aln) {\n\tif( ! $aln || ! $aln->isa('Bio::Align::AlignI')  ) {\n\t    $self->warn(\"Must provide a Bio::Align::AlignI object when calling write_aln\");\n\t    next;\n\t}\n\t$self->throw(\"All sequences in the alignment must be the same length\")\n\t    unless $aln->is_flush(1) ;\n\n        $flag_SI = $self->flag_SI();\n\t$aln->set_displayname_flat(); # plain\n\t$length  = $aln->length();\n        if ($flag_SI) {\n            if ($self->interleaved() ) {\n                $self->_print (sprintf(\" %s %s I\\n\", $aln->num_sequences, $aln->length));\n            } else {\n                $self->_print (sprintf(\" %s %s S\\n\", $aln->num_sequences, $aln->length));\n            }\n        } else {\n            $self->_print (sprintf(\" %s %s\\n\", $aln->num_sequences, $aln->length));\n        }\n\n\t$idlength = $self->idlength();\n\t$line_length = $self->line_length();\n\t$tag_length = $self->tag_length();\n\tforeach $seq ( $aln->each_seq() ) {\n\t    $name = $aln->displayname($seq->get_nse);\n\t    if ($self->longid) {\n\t\t$self->warn(\"The lenght of the name is over 50 chars long [$name]\") \n\t\t    if length($name) > 50; \n\t\t$name = \"'$name'  \"\n\t    } else {\n\t\t$name = substr($name, 0, $idlength) if length($name) > $idlength;\n\t\t$name = sprintf(\"%-\".$idlength.\"s\",$name);\n\t\tif( $self->interleaved() ) {\n\t\t    $name .= '   ' ;\n\t\t} elsif( $self->id_linebreak) {\n\t\t    $name .= \"\\n\";\n\t\t}\n\t    }\n\t    #phylip needs dashes not dots\n\t    my $seq = $seq->seq();\n\t    $seq =~ s/\\./-/g;\n\t    $hash{$name} = $seq;\n\t    push(@arr,$name);\n\t}\n\n\tif( $self->interleaved() ) {\n            my $numtags;\n            if ($tag_length <= $line_length) {\n                $numtags = floor($line_length/$tag_length);\n                $line_length = $tag_length*$numtags;\n            } else {\n                $numtags = 1;\n            }\n\t    while( $count < $length ) {\n\n\t\t# there is another block to go!\n\t\tforeach $name ( @arr ) {\n\t\t    my $dispname = $name;\n\t\t    $dispname = '' if $wrapped;\n\t\t    $self->_print (sprintf(\"%\".($idlength+3).\"s\",$dispname));\n\t\t    $tempcount = $count;\n                    $index = 0;\n                    $self->debug(\"residue count: $count\\n\") if ($count%100000 == 0);\n\t\t    while( ($tempcount + $tag_length < $length) &&\n\t\t\t   ($index < $numtags)  ) {\n\t\t\t$self->_print (sprintf(\"%s \",substr($hash{$name},\n\t\t\t\t\t\t\t    $tempcount,\n\t\t\t\t\t\t\t    $tag_length)));\n\t\t\t$tempcount += $tag_length;\n\t\t\t$index++;\n\t\t    }\n\t\t    # last\n\t\t    if( $index < $numtags) {\n\t\t\t# space to print!\n\t\t\t$self->_print (sprintf(\"%s \",substr($hash{$name},\n\t\t\t\t\t\t\t    $tempcount)));\n\t\t\t$tempcount += $tag_length;\n\t\t    }\n\t\t    $self->_print (\"\\n\");\n\t\t}\n\t\t$self->_print (\"\\n\");\n\t\t$count = $tempcount;\n\t\t$wrapped = 1;\n\t    }\n\t} else {\n\t    foreach $name ( @arr ) {\n\t\tmy $dispname = $name;\n\t\tmy $line = sprintf(\"%s%s\\n\",$dispname,$hash{$name});\n\t\tif( $self->wrap_sequential ) {\n\t\t    $line =~ s/(.{1,$width})/$1\\n/g;\n\t\t}\n\t\t$self->_print ($line);\n\t    }\n\t}\n    }\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n    return 1;\n}\n\n=head2 interleaved\n\n Title   : interleaved\n Usage   : my $interleaved = $obj->interleaved\n Function: Get/Set Interleaved status\n Returns : boolean\n Args    : boolean\n\n\n\nsub interleaved {\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       if ($value) {$self->{'_interleaved'} = 1 }\n       else {$self->{'_interleaved'} = 0 }\n   }\n   return 1 unless defined $self->{'_interleaved'};\n   return $self->{'_interleaved'};\n}\n\n=head2 flag_SI\n\n Title   : flag_SI\n Usage   : my $flag = $obj->flag_SI\n Function: Get/Set if the Sequential/Interleaved flag has to be shown\n           after the number of sequences and sequence length\n Example :\n Returns : boolean\n Args    : boolean\n\n\n\nsub flag_SI{\n   my ($self,$value) = @_;\n   my $previous = $self->{'_flag_SI'};\n   if( defined $value ) {\n       $self->{'_flag_SI'} = $value;\n   }\n   return $previous;\n}\n\n=head2 idlength\n\n Title   : idlength\n Usage   : my $idlength = $obj->idlength\n Function: Get/Set value of id length\n Returns : string\n Args    : string\n\n\n\nsub idlength {\n\tmy($self,$value) = @_;\n\tif (defined $value){\n\t   $self->{'_idlength'} = $value;\n\t}\n\treturn $self->{'_idlength'};\n}\n\n=head2 line_length\n\n Title   : line_length\n Usage   : $obj->line_length($newval)\n Function:\n Returns : value of line_length\n Args    : newvalue (optional)","label":"line_length($self,$value)"}},{"children":[{"containerName":"tag_length","localvar":"my","kind":13,"name":"$self","line":515,"definition":"my"},{"line":515,"kind":13,"containerName":"tag_length","name":"$value"},{"containerName":"tag_length","kind":13,"name":"$value","line":516},{"line":517,"name":"$self","containerName":"tag_length","kind":13},{"line":517,"name":"$value","containerName":"tag_length","kind":13},{"line":519,"name":"$self","containerName":"tag_length","kind":13},{"containerName":"tag_length","kind":13,"name":"$DEFAULTTAGLEN","line":519}],"containerName":"main::","name":"tag_length","definition":"sub","detail":"($self,$value)","line":514,"range":{"end":{"line":520,"character":9999},"start":{"line":514,"character":0}},"kind":12,"signature":{"documentation":"1;\n# $Id: phylip.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::phylip\n#\n# Copyright Heikki Lehvaslaiho\n#\n\n=head1 NAME\n\nBio::AlignIO::phylip - PHYLIP format sequence input/output stream\n\n=head1 SYNOPSIS\n\n# Do not use this module directly.  Use it via the Bio::AlignIO class.\n\n    use Bio::AlignIO;\n    use Bio::SimpleAlign;\n    #you can set the name length to something other than the default 10\n    #if you use a version of phylip (hacked) that accepts ids > 10\n    my $phylipstream = Bio::AlignIO->new(-format  => 'phylip',\n                                        -fh      => \\*STDOUT,\n                                        -idlength=>30);\n    # convert data from one format to another\n    my $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                          -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n    # do it again with phylip sequential format format\n    $phylipstream->interleaved(0);\n    # can also initialize the object like this\n    $phylipstream = Bio::AlignIO->new(-interleaved => 0,\n                                     -format => 'phylip',\n                                     -fh   => \\*STDOUT,\n                                     -idlength=>10);\n    $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                       -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::SimpleAlign objects to and from PHYLIP\nfotmat. By deafult it works with the interleaved format. By specifying\nthe flag -interleaved =E<gt> 0 in the initialization the module can\nread or write data in sequential format.\n\nLong IDs up to 50 characters are supported by flag -longid =E<gt>\n1. ID strings can be surrounded by single quoted. They are mandatory\nonly if the IDs contain spaces. \n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Heikki Lehvaslaiho and Jason Stajich\n\nEmail: heikki at ebi.ac.uk\nEmail: jason at bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::phylip;\nuse vars qw($DEFAULTIDLENGTH $DEFAULTLINELEN $DEFAULTTAGLEN);\nuse strict;\n\nuse Bio::SimpleAlign;\nuse POSIX; # for the rounding call\n\nuse base qw(Bio::AlignIO);\n\nBEGIN {\n    $DEFAULTIDLENGTH = 10;\n    $DEFAULTLINELEN = 60;\n    $DEFAULTTAGLEN = 10;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $alignio = Bio::AlignIO->new(-format => 'phylip'\n\t\t\t\t\t  -file   => '>file',\n\t\t\t\t\t  -idlength => 10,\n\t\t\t\t\t  -idlinebreak => 1);\n Function: Initialize a new L<Bio::AlignIO::phylip> reader or writer\n Returns : L<Bio::AlignIO> object\n Args    : [specific for writing of phylip format files]\n           -idlength => integer - length of the id (will pad w/\n\t\t\t\t\t\t    spaces if needed)\n           -interleaved => boolean - whether interleaved\n                                     or sequential format required\n           -line_length  => integer of how long a sequence lines should be\n           -idlinebreak => insert a line break after the sequence id\n                           so that sequence starts on the next line\n           -flag_SI => whether or not write a \"S\" or \"I\" just after\n                       the num.seq. and line len., in the first line\n           -tag_length => integer of how long the tags have to be in\n                         each line between the space separator. set it\n                         to 0 to have 1 tag only.\n           -wrap_sequential => boolean for whether or not sequential\n                                   format should be broken up or a single line\n                                   default is false (single line)\n           -longid => boolean for allowing arbitrary long IDs (default is false)\n\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n\n  my ($interleave,$linelen,$idlinebreak,\n      $idlength, $flag_SI, $tag_length,$ws, $longid) =\n          $self->_rearrange([qw(INTERLEAVED\n                                LINE_LENGTH\n                                IDLINEBREAK\n                                IDLENGTH\n                                FLAG_SI\n                                TAG_LENGTH\n\t\t\t\tWRAP_SEQUENTIAL\n                                LONGID)],@args);\n  $self->interleaved($interleave ? 1 : 0) if defined $interleave;\n  $self->idlength($idlength || $DEFAULTIDLENGTH);\n  $self->id_linebreak(1) if( $idlinebreak );\n  $self->line_length($linelen) if defined $linelen && $linelen > 0;\n  $self->flag_SI(1) if ( $flag_SI );\n  $self->tag_length($tag_length) if ( $tag_length || $DEFAULTTAGLEN );\n  $self->wrap_sequential($ws ? 1 : 0);\n  $self->longid($longid ? 1 : 0);\n  1;\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream.\n           Throws an exception if trying to read in PHYLIP\n           sequential format.\n Returns : L<Bio::SimpleAlign> object\n Args    :\n\n\nsub next_aln {\n    my $self = shift;\n    my $entry;\n    my ($seqcount, $residuecount, %hash, $name,$str,\n\t@names,$seqname,$start,$end,$count,$seq);\n\n    my $aln =  Bio::SimpleAlign->new(-source => 'phylip');\n    $entry = $self->_readline and\n        ($seqcount, $residuecount) = $entry =~ /\\s*(\\d+)\\s+(\\d+)/;\n    return unless $seqcount and $residuecount;\n\n    # first alignment section\n    my $idlen = $self->idlength;\n    $count = 0;\n    my $iter = 1;\n    my $interleaved = $self->interleaved;\n    while( $entry = $self->_readline) {\n\tlast if( $entry =~ /^\\s?$/ && $interleaved );\n\n\tif( $entry =~ /^\\s+(\\d+)\\s+(\\d+)\\s*$/) {\n\t    $self->_pushback($entry);\n\t    last;\n\t}\n\tif( $self->longid  && $entry =~ /\\w/ ) {\n\t    if ($entry =~ /'/) {\n\t\t$entry =~ /^\\s*'([^']+)'\\s+(.+)$/;\n\t\t$name = $1;\n\t\t$str = $2;\n\t    } else {\n\t\t$entry =~ /^\\s*([^\\s]+)\\s+(.+)$/;\n\t\t$name = $1;\n\t\t$str = $2;\n\t    }\n#\t    $name =~ s/[\\s\\/]/_/g; # not sure how wise is it to do this\n\t    $name =~ s/_+$//; # remove any trailing _'s\n\t    \n\t    push @names, $name;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} = $str;\n\n\t} elsif( $entry =~ /^\\s+(.+)$/ ) {\n\t    $interleaved = 0;\n\t    $str = $1;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} .= $str;\n\t} elsif( $entry =~ /^(.{$idlen})\\s+(.*)\\s$/ ||\n\t\t $entry =~ /^(.{$idlen})(\\S{$idlen}\\s+.+)\\s$/ # Handle weirdnes s when id is too long\n\t\t ) {\n\t    $name = $1;\n\t    $str = $2;\n\t    $name =~ s/[\\s\\/]/_/g;\n\t    $name =~ s/_+$//; # remove any trailing _'s\n\n\t    push @names, $name;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} = $str;\n\t} elsif( $interleaved ) {\n\t    if( $entry =~ /^(\\S+)\\s+(.+)/ ||\n\t\t$entry =~ /^(.{$idlen})(.*)\\s$/ ) {\n\t\t$name = $1;\n\t\t$str = $2;\n\t\t$name =~ s/[\\s\\/]/_/g;\n\t\t$name =~ s/_+$//; # remove any trailing _'s\n\t\tpush @names, $name;\n\t\t$str =~ s/\\s//g;\n\t\t$count = scalar @names;\n\t\t$hash{$count} = $str;\n\t    } else {\n\t\t$self->debug(\"unmatched line: $entry\");\n\t    }\n\t}\n\t$self->throw(\"Not a valid interleaved PHYLIP file!\") if $count > $seqcount;\n    }\n\n    if( $interleaved ) {\n\t# interleaved sections\n\t$count = 0;\n\twhile( $entry = $self->_readline) {\n            # finish current entry\n\t    if($entry =~/\\s*\\d+\\s+\\d+/){\n\t\t$self->_pushback($entry);\n\t\tlast;\n\t    }\n\t    $count = 0, next if $entry =~ /^\\s$/;\n\t    $entry =~ /\\s*(.*)$/ && do {\n\t\t$str = $1;\n\t\t$str =~ s/\\s//g;\n\t\t$count++;\n\t\t$hash{$count} .= $str;\n\t    };\n\t    $self->throw(\"Not a valid interleaved PHYLIP file! [$count,$seqcount] ($entry)\") if $count > $seqcount;\n\t}\n    }\n    return if scalar @names < 1;\n\n    # sequence creation\n    $count = 0;\n    foreach $name ( @names ) {\n\t$count++;\n\tif( $name =~ /(\\S+)\\/(\\d+)-(\\d+)/ ) {\n\t    $seqname = $1;\n\t    $start = $2;\n\t    $end = $3;\n\t} else {\n\t    $seqname=$name;\n\t    $start = 1;\n\t    $str = $hash{$count};\n\t    $str =~ s/[^A-Za-z]//g;\n\t    $end = length($str);\n\t}\n\t# consistency test\n\t$self->throw(\"Length of sequence [$seqname] is not [$residuecount] it is \".CORE::length($hash{$count}).\"! \")\n\t    unless CORE::length($hash{$count}) == $residuecount;\n\n       $seq = Bio::LocatableSeq->new('-seq'=>$hash{$count},\n\t\t\t\t    '-id'=>$seqname,\n\t\t\t\t    '-start'=>$start,\n\t\t\t\t    '-end'=>$end,\n\t\t\t\t   );\n\t$aln->add_seq($seq);\n\n   }\n   return $aln if $aln->num_sequences;\n   return;\n}\n\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the $aln object into the stream in MSF format\n Returns : 1 for success and 0 for error\n Args    : L<Bio::Align::AlignI> object\n\n\nsub write_aln {\n    my ($self,@aln) = @_;\n    my $count = 0;\n    my $wrapped = 0;\n    my $maxname;\n    my $width = $self->line_length();\n    my ($length,$date,$name,$seq,$miss,$pad,\n\t%hash,@arr,$tempcount,$index,$idlength,$flag_SI,$line_length, $tag_length);\n\n    foreach my $aln (@aln) {\n\tif( ! $aln || ! $aln->isa('Bio::Align::AlignI')  ) {\n\t    $self->warn(\"Must provide a Bio::Align::AlignI object when calling write_aln\");\n\t    next;\n\t}\n\t$self->throw(\"All sequences in the alignment must be the same length\")\n\t    unless $aln->is_flush(1) ;\n\n        $flag_SI = $self->flag_SI();\n\t$aln->set_displayname_flat(); # plain\n\t$length  = $aln->length();\n        if ($flag_SI) {\n            if ($self->interleaved() ) {\n                $self->_print (sprintf(\" %s %s I\\n\", $aln->num_sequences, $aln->length));\n            } else {\n                $self->_print (sprintf(\" %s %s S\\n\", $aln->num_sequences, $aln->length));\n            }\n        } else {\n            $self->_print (sprintf(\" %s %s\\n\", $aln->num_sequences, $aln->length));\n        }\n\n\t$idlength = $self->idlength();\n\t$line_length = $self->line_length();\n\t$tag_length = $self->tag_length();\n\tforeach $seq ( $aln->each_seq() ) {\n\t    $name = $aln->displayname($seq->get_nse);\n\t    if ($self->longid) {\n\t\t$self->warn(\"The lenght of the name is over 50 chars long [$name]\") \n\t\t    if length($name) > 50; \n\t\t$name = \"'$name'  \"\n\t    } else {\n\t\t$name = substr($name, 0, $idlength) if length($name) > $idlength;\n\t\t$name = sprintf(\"%-\".$idlength.\"s\",$name);\n\t\tif( $self->interleaved() ) {\n\t\t    $name .= '   ' ;\n\t\t} elsif( $self->id_linebreak) {\n\t\t    $name .= \"\\n\";\n\t\t}\n\t    }\n\t    #phylip needs dashes not dots\n\t    my $seq = $seq->seq();\n\t    $seq =~ s/\\./-/g;\n\t    $hash{$name} = $seq;\n\t    push(@arr,$name);\n\t}\n\n\tif( $self->interleaved() ) {\n            my $numtags;\n            if ($tag_length <= $line_length) {\n                $numtags = floor($line_length/$tag_length);\n                $line_length = $tag_length*$numtags;\n            } else {\n                $numtags = 1;\n            }\n\t    while( $count < $length ) {\n\n\t\t# there is another block to go!\n\t\tforeach $name ( @arr ) {\n\t\t    my $dispname = $name;\n\t\t    $dispname = '' if $wrapped;\n\t\t    $self->_print (sprintf(\"%\".($idlength+3).\"s\",$dispname));\n\t\t    $tempcount = $count;\n                    $index = 0;\n                    $self->debug(\"residue count: $count\\n\") if ($count%100000 == 0);\n\t\t    while( ($tempcount + $tag_length < $length) &&\n\t\t\t   ($index < $numtags)  ) {\n\t\t\t$self->_print (sprintf(\"%s \",substr($hash{$name},\n\t\t\t\t\t\t\t    $tempcount,\n\t\t\t\t\t\t\t    $tag_length)));\n\t\t\t$tempcount += $tag_length;\n\t\t\t$index++;\n\t\t    }\n\t\t    # last\n\t\t    if( $index < $numtags) {\n\t\t\t# space to print!\n\t\t\t$self->_print (sprintf(\"%s \",substr($hash{$name},\n\t\t\t\t\t\t\t    $tempcount)));\n\t\t\t$tempcount += $tag_length;\n\t\t    }\n\t\t    $self->_print (\"\\n\");\n\t\t}\n\t\t$self->_print (\"\\n\");\n\t\t$count = $tempcount;\n\t\t$wrapped = 1;\n\t    }\n\t} else {\n\t    foreach $name ( @arr ) {\n\t\tmy $dispname = $name;\n\t\tmy $line = sprintf(\"%s%s\\n\",$dispname,$hash{$name});\n\t\tif( $self->wrap_sequential ) {\n\t\t    $line =~ s/(.{1,$width})/$1\\n/g;\n\t\t}\n\t\t$self->_print ($line);\n\t    }\n\t}\n    }\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n    return 1;\n}\n\n=head2 interleaved\n\n Title   : interleaved\n Usage   : my $interleaved = $obj->interleaved\n Function: Get/Set Interleaved status\n Returns : boolean\n Args    : boolean\n\n\n\nsub interleaved {\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       if ($value) {$self->{'_interleaved'} = 1 }\n       else {$self->{'_interleaved'} = 0 }\n   }\n   return 1 unless defined $self->{'_interleaved'};\n   return $self->{'_interleaved'};\n}\n\n=head2 flag_SI\n\n Title   : flag_SI\n Usage   : my $flag = $obj->flag_SI\n Function: Get/Set if the Sequential/Interleaved flag has to be shown\n           after the number of sequences and sequence length\n Example :\n Returns : boolean\n Args    : boolean\n\n\n\nsub flag_SI{\n   my ($self,$value) = @_;\n   my $previous = $self->{'_flag_SI'};\n   if( defined $value ) {\n       $self->{'_flag_SI'} = $value;\n   }\n   return $previous;\n}\n\n=head2 idlength\n\n Title   : idlength\n Usage   : my $idlength = $obj->idlength\n Function: Get/Set value of id length\n Returns : string\n Args    : string\n\n\n\nsub idlength {\n\tmy($self,$value) = @_;\n\tif (defined $value){\n\t   $self->{'_idlength'} = $value;\n\t}\n\treturn $self->{'_idlength'};\n}\n\n=head2 line_length\n\n Title   : line_length\n Usage   : $obj->line_length($newval)\n Function:\n Returns : value of line_length\n Args    : newvalue (optional)\n\n\n\nsub line_length{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_line_length'} = $value;\n    }\n    return $self->{'_line_length'} || $DEFAULTLINELEN;\n\n}\n\n=head2 tag_length\n\n Title   : tag_length\n Usage   : $obj->tag_length($newval)\n Function:\n Example : my $tag_length = $obj->tag_length\n Returns : value of the length for each space-separated tag in a line\n Args    : newvalue (optional) - set to zero to have one tag per line","parameters":[{"label":"$self"},{"label":"$value"}],"label":"tag_length($self,$value)"}},{"line":534,"range":{"end":{"character":9999,"line":540},"start":{"line":534,"character":0}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: phylip.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::phylip\n#\n# Copyright Heikki Lehvaslaiho\n#\n\n=head1 NAME\n\nBio::AlignIO::phylip - PHYLIP format sequence input/output stream\n\n=head1 SYNOPSIS\n\n# Do not use this module directly.  Use it via the Bio::AlignIO class.\n\n    use Bio::AlignIO;\n    use Bio::SimpleAlign;\n    #you can set the name length to something other than the default 10\n    #if you use a version of phylip (hacked) that accepts ids > 10\n    my $phylipstream = Bio::AlignIO->new(-format  => 'phylip',\n                                        -fh      => \\*STDOUT,\n                                        -idlength=>30);\n    # convert data from one format to another\n    my $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                          -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n    # do it again with phylip sequential format format\n    $phylipstream->interleaved(0);\n    # can also initialize the object like this\n    $phylipstream = Bio::AlignIO->new(-interleaved => 0,\n                                     -format => 'phylip',\n                                     -fh   => \\*STDOUT,\n                                     -idlength=>10);\n    $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                       -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::SimpleAlign objects to and from PHYLIP\nfotmat. By deafult it works with the interleaved format. By specifying\nthe flag -interleaved =E<gt> 0 in the initialization the module can\nread or write data in sequential format.\n\nLong IDs up to 50 characters are supported by flag -longid =E<gt>\n1. ID strings can be surrounded by single quoted. They are mandatory\nonly if the IDs contain spaces. \n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Heikki Lehvaslaiho and Jason Stajich\n\nEmail: heikki at ebi.ac.uk\nEmail: jason at bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::phylip;\nuse vars qw($DEFAULTIDLENGTH $DEFAULTLINELEN $DEFAULTTAGLEN);\nuse strict;\n\nuse Bio::SimpleAlign;\nuse POSIX; # for the rounding call\n\nuse base qw(Bio::AlignIO);\n\nBEGIN {\n    $DEFAULTIDLENGTH = 10;\n    $DEFAULTLINELEN = 60;\n    $DEFAULTTAGLEN = 10;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $alignio = Bio::AlignIO->new(-format => 'phylip'\n\t\t\t\t\t  -file   => '>file',\n\t\t\t\t\t  -idlength => 10,\n\t\t\t\t\t  -idlinebreak => 1);\n Function: Initialize a new L<Bio::AlignIO::phylip> reader or writer\n Returns : L<Bio::AlignIO> object\n Args    : [specific for writing of phylip format files]\n           -idlength => integer - length of the id (will pad w/\n\t\t\t\t\t\t    spaces if needed)\n           -interleaved => boolean - whether interleaved\n                                     or sequential format required\n           -line_length  => integer of how long a sequence lines should be\n           -idlinebreak => insert a line break after the sequence id\n                           so that sequence starts on the next line\n           -flag_SI => whether or not write a \"S\" or \"I\" just after\n                       the num.seq. and line len., in the first line\n           -tag_length => integer of how long the tags have to be in\n                         each line between the space separator. set it\n                         to 0 to have 1 tag only.\n           -wrap_sequential => boolean for whether or not sequential\n                                   format should be broken up or a single line\n                                   default is false (single line)\n           -longid => boolean for allowing arbitrary long IDs (default is false)\n\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n\n  my ($interleave,$linelen,$idlinebreak,\n      $idlength, $flag_SI, $tag_length,$ws, $longid) =\n          $self->_rearrange([qw(INTERLEAVED\n                                LINE_LENGTH\n                                IDLINEBREAK\n                                IDLENGTH\n                                FLAG_SI\n                                TAG_LENGTH\n\t\t\t\tWRAP_SEQUENTIAL\n                                LONGID)],@args);\n  $self->interleaved($interleave ? 1 : 0) if defined $interleave;\n  $self->idlength($idlength || $DEFAULTIDLENGTH);\n  $self->id_linebreak(1) if( $idlinebreak );\n  $self->line_length($linelen) if defined $linelen && $linelen > 0;\n  $self->flag_SI(1) if ( $flag_SI );\n  $self->tag_length($tag_length) if ( $tag_length || $DEFAULTTAGLEN );\n  $self->wrap_sequential($ws ? 1 : 0);\n  $self->longid($longid ? 1 : 0);\n  1;\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream.\n           Throws an exception if trying to read in PHYLIP\n           sequential format.\n Returns : L<Bio::SimpleAlign> object\n Args    :\n\n\nsub next_aln {\n    my $self = shift;\n    my $entry;\n    my ($seqcount, $residuecount, %hash, $name,$str,\n\t@names,$seqname,$start,$end,$count,$seq);\n\n    my $aln =  Bio::SimpleAlign->new(-source => 'phylip');\n    $entry = $self->_readline and\n        ($seqcount, $residuecount) = $entry =~ /\\s*(\\d+)\\s+(\\d+)/;\n    return unless $seqcount and $residuecount;\n\n    # first alignment section\n    my $idlen = $self->idlength;\n    $count = 0;\n    my $iter = 1;\n    my $interleaved = $self->interleaved;\n    while( $entry = $self->_readline) {\n\tlast if( $entry =~ /^\\s?$/ && $interleaved );\n\n\tif( $entry =~ /^\\s+(\\d+)\\s+(\\d+)\\s*$/) {\n\t    $self->_pushback($entry);\n\t    last;\n\t}\n\tif( $self->longid  && $entry =~ /\\w/ ) {\n\t    if ($entry =~ /'/) {\n\t\t$entry =~ /^\\s*'([^']+)'\\s+(.+)$/;\n\t\t$name = $1;\n\t\t$str = $2;\n\t    } else {\n\t\t$entry =~ /^\\s*([^\\s]+)\\s+(.+)$/;\n\t\t$name = $1;\n\t\t$str = $2;\n\t    }\n#\t    $name =~ s/[\\s\\/]/_/g; # not sure how wise is it to do this\n\t    $name =~ s/_+$//; # remove any trailing _'s\n\t    \n\t    push @names, $name;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} = $str;\n\n\t} elsif( $entry =~ /^\\s+(.+)$/ ) {\n\t    $interleaved = 0;\n\t    $str = $1;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} .= $str;\n\t} elsif( $entry =~ /^(.{$idlen})\\s+(.*)\\s$/ ||\n\t\t $entry =~ /^(.{$idlen})(\\S{$idlen}\\s+.+)\\s$/ # Handle weirdnes s when id is too long\n\t\t ) {\n\t    $name = $1;\n\t    $str = $2;\n\t    $name =~ s/[\\s\\/]/_/g;\n\t    $name =~ s/_+$//; # remove any trailing _'s\n\n\t    push @names, $name;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} = $str;\n\t} elsif( $interleaved ) {\n\t    if( $entry =~ /^(\\S+)\\s+(.+)/ ||\n\t\t$entry =~ /^(.{$idlen})(.*)\\s$/ ) {\n\t\t$name = $1;\n\t\t$str = $2;\n\t\t$name =~ s/[\\s\\/]/_/g;\n\t\t$name =~ s/_+$//; # remove any trailing _'s\n\t\tpush @names, $name;\n\t\t$str =~ s/\\s//g;\n\t\t$count = scalar @names;\n\t\t$hash{$count} = $str;\n\t    } else {\n\t\t$self->debug(\"unmatched line: $entry\");\n\t    }\n\t}\n\t$self->throw(\"Not a valid interleaved PHYLIP file!\") if $count > $seqcount;\n    }\n\n    if( $interleaved ) {\n\t# interleaved sections\n\t$count = 0;\n\twhile( $entry = $self->_readline) {\n            # finish current entry\n\t    if($entry =~/\\s*\\d+\\s+\\d+/){\n\t\t$self->_pushback($entry);\n\t\tlast;\n\t    }\n\t    $count = 0, next if $entry =~ /^\\s$/;\n\t    $entry =~ /\\s*(.*)$/ && do {\n\t\t$str = $1;\n\t\t$str =~ s/\\s//g;\n\t\t$count++;\n\t\t$hash{$count} .= $str;\n\t    };\n\t    $self->throw(\"Not a valid interleaved PHYLIP file! [$count,$seqcount] ($entry)\") if $count > $seqcount;\n\t}\n    }\n    return if scalar @names < 1;\n\n    # sequence creation\n    $count = 0;\n    foreach $name ( @names ) {\n\t$count++;\n\tif( $name =~ /(\\S+)\\/(\\d+)-(\\d+)/ ) {\n\t    $seqname = $1;\n\t    $start = $2;\n\t    $end = $3;\n\t} else {\n\t    $seqname=$name;\n\t    $start = 1;\n\t    $str = $hash{$count};\n\t    $str =~ s/[^A-Za-z]//g;\n\t    $end = length($str);\n\t}\n\t# consistency test\n\t$self->throw(\"Length of sequence [$seqname] is not [$residuecount] it is \".CORE::length($hash{$count}).\"! \")\n\t    unless CORE::length($hash{$count}) == $residuecount;\n\n       $seq = Bio::LocatableSeq->new('-seq'=>$hash{$count},\n\t\t\t\t    '-id'=>$seqname,\n\t\t\t\t    '-start'=>$start,\n\t\t\t\t    '-end'=>$end,\n\t\t\t\t   );\n\t$aln->add_seq($seq);\n\n   }\n   return $aln if $aln->num_sequences;\n   return;\n}\n\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the $aln object into the stream in MSF format\n Returns : 1 for success and 0 for error\n Args    : L<Bio::Align::AlignI> object\n\n\nsub write_aln {\n    my ($self,@aln) = @_;\n    my $count = 0;\n    my $wrapped = 0;\n    my $maxname;\n    my $width = $self->line_length();\n    my ($length,$date,$name,$seq,$miss,$pad,\n\t%hash,@arr,$tempcount,$index,$idlength,$flag_SI,$line_length, $tag_length);\n\n    foreach my $aln (@aln) {\n\tif( ! $aln || ! $aln->isa('Bio::Align::AlignI')  ) {\n\t    $self->warn(\"Must provide a Bio::Align::AlignI object when calling write_aln\");\n\t    next;\n\t}\n\t$self->throw(\"All sequences in the alignment must be the same length\")\n\t    unless $aln->is_flush(1) ;\n\n        $flag_SI = $self->flag_SI();\n\t$aln->set_displayname_flat(); # plain\n\t$length  = $aln->length();\n        if ($flag_SI) {\n            if ($self->interleaved() ) {\n                $self->_print (sprintf(\" %s %s I\\n\", $aln->num_sequences, $aln->length));\n            } else {\n                $self->_print (sprintf(\" %s %s S\\n\", $aln->num_sequences, $aln->length));\n            }\n        } else {\n            $self->_print (sprintf(\" %s %s\\n\", $aln->num_sequences, $aln->length));\n        }\n\n\t$idlength = $self->idlength();\n\t$line_length = $self->line_length();\n\t$tag_length = $self->tag_length();\n\tforeach $seq ( $aln->each_seq() ) {\n\t    $name = $aln->displayname($seq->get_nse);\n\t    if ($self->longid) {\n\t\t$self->warn(\"The lenght of the name is over 50 chars long [$name]\") \n\t\t    if length($name) > 50; \n\t\t$name = \"'$name'  \"\n\t    } else {\n\t\t$name = substr($name, 0, $idlength) if length($name) > $idlength;\n\t\t$name = sprintf(\"%-\".$idlength.\"s\",$name);\n\t\tif( $self->interleaved() ) {\n\t\t    $name .= '   ' ;\n\t\t} elsif( $self->id_linebreak) {\n\t\t    $name .= \"\\n\";\n\t\t}\n\t    }\n\t    #phylip needs dashes not dots\n\t    my $seq = $seq->seq();\n\t    $seq =~ s/\\./-/g;\n\t    $hash{$name} = $seq;\n\t    push(@arr,$name);\n\t}\n\n\tif( $self->interleaved() ) {\n            my $numtags;\n            if ($tag_length <= $line_length) {\n                $numtags = floor($line_length/$tag_length);\n                $line_length = $tag_length*$numtags;\n            } else {\n                $numtags = 1;\n            }\n\t    while( $count < $length ) {\n\n\t\t# there is another block to go!\n\t\tforeach $name ( @arr ) {\n\t\t    my $dispname = $name;\n\t\t    $dispname = '' if $wrapped;\n\t\t    $self->_print (sprintf(\"%\".($idlength+3).\"s\",$dispname));\n\t\t    $tempcount = $count;\n                    $index = 0;\n                    $self->debug(\"residue count: $count\\n\") if ($count%100000 == 0);\n\t\t    while( ($tempcount + $tag_length < $length) &&\n\t\t\t   ($index < $numtags)  ) {\n\t\t\t$self->_print (sprintf(\"%s \",substr($hash{$name},\n\t\t\t\t\t\t\t    $tempcount,\n\t\t\t\t\t\t\t    $tag_length)));\n\t\t\t$tempcount += $tag_length;\n\t\t\t$index++;\n\t\t    }\n\t\t    # last\n\t\t    if( $index < $numtags) {\n\t\t\t# space to print!\n\t\t\t$self->_print (sprintf(\"%s \",substr($hash{$name},\n\t\t\t\t\t\t\t    $tempcount)));\n\t\t\t$tempcount += $tag_length;\n\t\t    }\n\t\t    $self->_print (\"\\n\");\n\t\t}\n\t\t$self->_print (\"\\n\");\n\t\t$count = $tempcount;\n\t\t$wrapped = 1;\n\t    }\n\t} else {\n\t    foreach $name ( @arr ) {\n\t\tmy $dispname = $name;\n\t\tmy $line = sprintf(\"%s%s\\n\",$dispname,$hash{$name});\n\t\tif( $self->wrap_sequential ) {\n\t\t    $line =~ s/(.{1,$width})/$1\\n/g;\n\t\t}\n\t\t$self->_print ($line);\n\t    }\n\t}\n    }\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n    return 1;\n}\n\n=head2 interleaved\n\n Title   : interleaved\n Usage   : my $interleaved = $obj->interleaved\n Function: Get/Set Interleaved status\n Returns : boolean\n Args    : boolean\n\n\n\nsub interleaved {\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       if ($value) {$self->{'_interleaved'} = 1 }\n       else {$self->{'_interleaved'} = 0 }\n   }\n   return 1 unless defined $self->{'_interleaved'};\n   return $self->{'_interleaved'};\n}\n\n=head2 flag_SI\n\n Title   : flag_SI\n Usage   : my $flag = $obj->flag_SI\n Function: Get/Set if the Sequential/Interleaved flag has to be shown\n           after the number of sequences and sequence length\n Example :\n Returns : boolean\n Args    : boolean\n\n\n\nsub flag_SI{\n   my ($self,$value) = @_;\n   my $previous = $self->{'_flag_SI'};\n   if( defined $value ) {\n       $self->{'_flag_SI'} = $value;\n   }\n   return $previous;\n}\n\n=head2 idlength\n\n Title   : idlength\n Usage   : my $idlength = $obj->idlength\n Function: Get/Set value of id length\n Returns : string\n Args    : string\n\n\n\nsub idlength {\n\tmy($self,$value) = @_;\n\tif (defined $value){\n\t   $self->{'_idlength'} = $value;\n\t}\n\treturn $self->{'_idlength'};\n}\n\n=head2 line_length\n\n Title   : line_length\n Usage   : $obj->line_length($newval)\n Function:\n Returns : value of line_length\n Args    : newvalue (optional)\n\n\n\nsub line_length{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_line_length'} = $value;\n    }\n    return $self->{'_line_length'} || $DEFAULTLINELEN;\n\n}\n\n=head2 tag_length\n\n Title   : tag_length\n Usage   : $obj->tag_length($newval)\n Function:\n Example : my $tag_length = $obj->tag_length\n Returns : value of the length for each space-separated tag in a line\n Args    : newvalue (optional) - set to zero to have one tag per line\n\n\n\nsub tag_length{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_tag_length'} = $value;\n    }\n    return $self->{'_tag_length'} || $DEFAULTTAGLEN;\n}\n\n\n=head2 id_linebreak\n\n Title   : id_linebreak\n Usage   : $obj->id_linebreak($newval)\n Function:\n Returns : value of id_linebreak\n Args    : newvalue (optional)","label":"id_linebreak($self,$value)"},"children":[{"name":"$self","containerName":"id_linebreak","localvar":"my","kind":13,"line":535,"definition":"my"},{"name":"$value","containerName":"id_linebreak","kind":13,"line":535},{"line":536,"name":"$value","kind":13,"containerName":"id_linebreak"},{"line":537,"name":"$self","kind":13,"containerName":"id_linebreak"},{"line":537,"name":"$value","kind":13,"containerName":"id_linebreak"},{"name":"$self","kind":13,"containerName":"id_linebreak","line":539}],"name":"id_linebreak","containerName":"main::","definition":"sub","detail":"($self,$value)"},{"signature":{"label":"wrap_sequential($self,$value)","documentation":"1;\n# $Id: phylip.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::phylip\n#\n# Copyright Heikki Lehvaslaiho\n#\n\n=head1 NAME\n\nBio::AlignIO::phylip - PHYLIP format sequence input/output stream\n\n=head1 SYNOPSIS\n\n# Do not use this module directly.  Use it via the Bio::AlignIO class.\n\n    use Bio::AlignIO;\n    use Bio::SimpleAlign;\n    #you can set the name length to something other than the default 10\n    #if you use a version of phylip (hacked) that accepts ids > 10\n    my $phylipstream = Bio::AlignIO->new(-format  => 'phylip',\n                                        -fh      => \\*STDOUT,\n                                        -idlength=>30);\n    # convert data from one format to another\n    my $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                          -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n    # do it again with phylip sequential format format\n    $phylipstream->interleaved(0);\n    # can also initialize the object like this\n    $phylipstream = Bio::AlignIO->new(-interleaved => 0,\n                                     -format => 'phylip',\n                                     -fh   => \\*STDOUT,\n                                     -idlength=>10);\n    $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                       -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::SimpleAlign objects to and from PHYLIP\nfotmat. By deafult it works with the interleaved format. By specifying\nthe flag -interleaved =E<gt> 0 in the initialization the module can\nread or write data in sequential format.\n\nLong IDs up to 50 characters are supported by flag -longid =E<gt>\n1. ID strings can be surrounded by single quoted. They are mandatory\nonly if the IDs contain spaces. \n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Heikki Lehvaslaiho and Jason Stajich\n\nEmail: heikki at ebi.ac.uk\nEmail: jason at bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::phylip;\nuse vars qw($DEFAULTIDLENGTH $DEFAULTLINELEN $DEFAULTTAGLEN);\nuse strict;\n\nuse Bio::SimpleAlign;\nuse POSIX; # for the rounding call\n\nuse base qw(Bio::AlignIO);\n\nBEGIN {\n    $DEFAULTIDLENGTH = 10;\n    $DEFAULTLINELEN = 60;\n    $DEFAULTTAGLEN = 10;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $alignio = Bio::AlignIO->new(-format => 'phylip'\n\t\t\t\t\t  -file   => '>file',\n\t\t\t\t\t  -idlength => 10,\n\t\t\t\t\t  -idlinebreak => 1);\n Function: Initialize a new L<Bio::AlignIO::phylip> reader or writer\n Returns : L<Bio::AlignIO> object\n Args    : [specific for writing of phylip format files]\n           -idlength => integer - length of the id (will pad w/\n\t\t\t\t\t\t    spaces if needed)\n           -interleaved => boolean - whether interleaved\n                                     or sequential format required\n           -line_length  => integer of how long a sequence lines should be\n           -idlinebreak => insert a line break after the sequence id\n                           so that sequence starts on the next line\n           -flag_SI => whether or not write a \"S\" or \"I\" just after\n                       the num.seq. and line len., in the first line\n           -tag_length => integer of how long the tags have to be in\n                         each line between the space separator. set it\n                         to 0 to have 1 tag only.\n           -wrap_sequential => boolean for whether or not sequential\n                                   format should be broken up or a single line\n                                   default is false (single line)\n           -longid => boolean for allowing arbitrary long IDs (default is false)\n\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n\n  my ($interleave,$linelen,$idlinebreak,\n      $idlength, $flag_SI, $tag_length,$ws, $longid) =\n          $self->_rearrange([qw(INTERLEAVED\n                                LINE_LENGTH\n                                IDLINEBREAK\n                                IDLENGTH\n                                FLAG_SI\n                                TAG_LENGTH\n\t\t\t\tWRAP_SEQUENTIAL\n                                LONGID)],@args);\n  $self->interleaved($interleave ? 1 : 0) if defined $interleave;\n  $self->idlength($idlength || $DEFAULTIDLENGTH);\n  $self->id_linebreak(1) if( $idlinebreak );\n  $self->line_length($linelen) if defined $linelen && $linelen > 0;\n  $self->flag_SI(1) if ( $flag_SI );\n  $self->tag_length($tag_length) if ( $tag_length || $DEFAULTTAGLEN );\n  $self->wrap_sequential($ws ? 1 : 0);\n  $self->longid($longid ? 1 : 0);\n  1;\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream.\n           Throws an exception if trying to read in PHYLIP\n           sequential format.\n Returns : L<Bio::SimpleAlign> object\n Args    :\n\n\nsub next_aln {\n    my $self = shift;\n    my $entry;\n    my ($seqcount, $residuecount, %hash, $name,$str,\n\t@names,$seqname,$start,$end,$count,$seq);\n\n    my $aln =  Bio::SimpleAlign->new(-source => 'phylip');\n    $entry = $self->_readline and\n        ($seqcount, $residuecount) = $entry =~ /\\s*(\\d+)\\s+(\\d+)/;\n    return unless $seqcount and $residuecount;\n\n    # first alignment section\n    my $idlen = $self->idlength;\n    $count = 0;\n    my $iter = 1;\n    my $interleaved = $self->interleaved;\n    while( $entry = $self->_readline) {\n\tlast if( $entry =~ /^\\s?$/ && $interleaved );\n\n\tif( $entry =~ /^\\s+(\\d+)\\s+(\\d+)\\s*$/) {\n\t    $self->_pushback($entry);\n\t    last;\n\t}\n\tif( $self->longid  && $entry =~ /\\w/ ) {\n\t    if ($entry =~ /'/) {\n\t\t$entry =~ /^\\s*'([^']+)'\\s+(.+)$/;\n\t\t$name = $1;\n\t\t$str = $2;\n\t    } else {\n\t\t$entry =~ /^\\s*([^\\s]+)\\s+(.+)$/;\n\t\t$name = $1;\n\t\t$str = $2;\n\t    }\n#\t    $name =~ s/[\\s\\/]/_/g; # not sure how wise is it to do this\n\t    $name =~ s/_+$//; # remove any trailing _'s\n\t    \n\t    push @names, $name;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} = $str;\n\n\t} elsif( $entry =~ /^\\s+(.+)$/ ) {\n\t    $interleaved = 0;\n\t    $str = $1;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} .= $str;\n\t} elsif( $entry =~ /^(.{$idlen})\\s+(.*)\\s$/ ||\n\t\t $entry =~ /^(.{$idlen})(\\S{$idlen}\\s+.+)\\s$/ # Handle weirdnes s when id is too long\n\t\t ) {\n\t    $name = $1;\n\t    $str = $2;\n\t    $name =~ s/[\\s\\/]/_/g;\n\t    $name =~ s/_+$//; # remove any trailing _'s\n\n\t    push @names, $name;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} = $str;\n\t} elsif( $interleaved ) {\n\t    if( $entry =~ /^(\\S+)\\s+(.+)/ ||\n\t\t$entry =~ /^(.{$idlen})(.*)\\s$/ ) {\n\t\t$name = $1;\n\t\t$str = $2;\n\t\t$name =~ s/[\\s\\/]/_/g;\n\t\t$name =~ s/_+$//; # remove any trailing _'s\n\t\tpush @names, $name;\n\t\t$str =~ s/\\s//g;\n\t\t$count = scalar @names;\n\t\t$hash{$count} = $str;\n\t    } else {\n\t\t$self->debug(\"unmatched line: $entry\");\n\t    }\n\t}\n\t$self->throw(\"Not a valid interleaved PHYLIP file!\") if $count > $seqcount;\n    }\n\n    if( $interleaved ) {\n\t# interleaved sections\n\t$count = 0;\n\twhile( $entry = $self->_readline) {\n            # finish current entry\n\t    if($entry =~/\\s*\\d+\\s+\\d+/){\n\t\t$self->_pushback($entry);\n\t\tlast;\n\t    }\n\t    $count = 0, next if $entry =~ /^\\s$/;\n\t    $entry =~ /\\s*(.*)$/ && do {\n\t\t$str = $1;\n\t\t$str =~ s/\\s//g;\n\t\t$count++;\n\t\t$hash{$count} .= $str;\n\t    };\n\t    $self->throw(\"Not a valid interleaved PHYLIP file! [$count,$seqcount] ($entry)\") if $count > $seqcount;\n\t}\n    }\n    return if scalar @names < 1;\n\n    # sequence creation\n    $count = 0;\n    foreach $name ( @names ) {\n\t$count++;\n\tif( $name =~ /(\\S+)\\/(\\d+)-(\\d+)/ ) {\n\t    $seqname = $1;\n\t    $start = $2;\n\t    $end = $3;\n\t} else {\n\t    $seqname=$name;\n\t    $start = 1;\n\t    $str = $hash{$count};\n\t    $str =~ s/[^A-Za-z]//g;\n\t    $end = length($str);\n\t}\n\t# consistency test\n\t$self->throw(\"Length of sequence [$seqname] is not [$residuecount] it is \".CORE::length($hash{$count}).\"! \")\n\t    unless CORE::length($hash{$count}) == $residuecount;\n\n       $seq = Bio::LocatableSeq->new('-seq'=>$hash{$count},\n\t\t\t\t    '-id'=>$seqname,\n\t\t\t\t    '-start'=>$start,\n\t\t\t\t    '-end'=>$end,\n\t\t\t\t   );\n\t$aln->add_seq($seq);\n\n   }\n   return $aln if $aln->num_sequences;\n   return;\n}\n\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the $aln object into the stream in MSF format\n Returns : 1 for success and 0 for error\n Args    : L<Bio::Align::AlignI> object\n\n\nsub write_aln {\n    my ($self,@aln) = @_;\n    my $count = 0;\n    my $wrapped = 0;\n    my $maxname;\n    my $width = $self->line_length();\n    my ($length,$date,$name,$seq,$miss,$pad,\n\t%hash,@arr,$tempcount,$index,$idlength,$flag_SI,$line_length, $tag_length);\n\n    foreach my $aln (@aln) {\n\tif( ! $aln || ! $aln->isa('Bio::Align::AlignI')  ) {\n\t    $self->warn(\"Must provide a Bio::Align::AlignI object when calling write_aln\");\n\t    next;\n\t}\n\t$self->throw(\"All sequences in the alignment must be the same length\")\n\t    unless $aln->is_flush(1) ;\n\n        $flag_SI = $self->flag_SI();\n\t$aln->set_displayname_flat(); # plain\n\t$length  = $aln->length();\n        if ($flag_SI) {\n            if ($self->interleaved() ) {\n                $self->_print (sprintf(\" %s %s I\\n\", $aln->num_sequences, $aln->length));\n            } else {\n                $self->_print (sprintf(\" %s %s S\\n\", $aln->num_sequences, $aln->length));\n            }\n        } else {\n            $self->_print (sprintf(\" %s %s\\n\", $aln->num_sequences, $aln->length));\n        }\n\n\t$idlength = $self->idlength();\n\t$line_length = $self->line_length();\n\t$tag_length = $self->tag_length();\n\tforeach $seq ( $aln->each_seq() ) {\n\t    $name = $aln->displayname($seq->get_nse);\n\t    if ($self->longid) {\n\t\t$self->warn(\"The lenght of the name is over 50 chars long [$name]\") \n\t\t    if length($name) > 50; \n\t\t$name = \"'$name'  \"\n\t    } else {\n\t\t$name = substr($name, 0, $idlength) if length($name) > $idlength;\n\t\t$name = sprintf(\"%-\".$idlength.\"s\",$name);\n\t\tif( $self->interleaved() ) {\n\t\t    $name .= '   ' ;\n\t\t} elsif( $self->id_linebreak) {\n\t\t    $name .= \"\\n\";\n\t\t}\n\t    }\n\t    #phylip needs dashes not dots\n\t    my $seq = $seq->seq();\n\t    $seq =~ s/\\./-/g;\n\t    $hash{$name} = $seq;\n\t    push(@arr,$name);\n\t}\n\n\tif( $self->interleaved() ) {\n            my $numtags;\n            if ($tag_length <= $line_length) {\n                $numtags = floor($line_length/$tag_length);\n                $line_length = $tag_length*$numtags;\n            } else {\n                $numtags = 1;\n            }\n\t    while( $count < $length ) {\n\n\t\t# there is another block to go!\n\t\tforeach $name ( @arr ) {\n\t\t    my $dispname = $name;\n\t\t    $dispname = '' if $wrapped;\n\t\t    $self->_print (sprintf(\"%\".($idlength+3).\"s\",$dispname));\n\t\t    $tempcount = $count;\n                    $index = 0;\n                    $self->debug(\"residue count: $count\\n\") if ($count%100000 == 0);\n\t\t    while( ($tempcount + $tag_length < $length) &&\n\t\t\t   ($index < $numtags)  ) {\n\t\t\t$self->_print (sprintf(\"%s \",substr($hash{$name},\n\t\t\t\t\t\t\t    $tempcount,\n\t\t\t\t\t\t\t    $tag_length)));\n\t\t\t$tempcount += $tag_length;\n\t\t\t$index++;\n\t\t    }\n\t\t    # last\n\t\t    if( $index < $numtags) {\n\t\t\t# space to print!\n\t\t\t$self->_print (sprintf(\"%s \",substr($hash{$name},\n\t\t\t\t\t\t\t    $tempcount)));\n\t\t\t$tempcount += $tag_length;\n\t\t    }\n\t\t    $self->_print (\"\\n\");\n\t\t}\n\t\t$self->_print (\"\\n\");\n\t\t$count = $tempcount;\n\t\t$wrapped = 1;\n\t    }\n\t} else {\n\t    foreach $name ( @arr ) {\n\t\tmy $dispname = $name;\n\t\tmy $line = sprintf(\"%s%s\\n\",$dispname,$hash{$name});\n\t\tif( $self->wrap_sequential ) {\n\t\t    $line =~ s/(.{1,$width})/$1\\n/g;\n\t\t}\n\t\t$self->_print ($line);\n\t    }\n\t}\n    }\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n    return 1;\n}\n\n=head2 interleaved\n\n Title   : interleaved\n Usage   : my $interleaved = $obj->interleaved\n Function: Get/Set Interleaved status\n Returns : boolean\n Args    : boolean\n\n\n\nsub interleaved {\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       if ($value) {$self->{'_interleaved'} = 1 }\n       else {$self->{'_interleaved'} = 0 }\n   }\n   return 1 unless defined $self->{'_interleaved'};\n   return $self->{'_interleaved'};\n}\n\n=head2 flag_SI\n\n Title   : flag_SI\n Usage   : my $flag = $obj->flag_SI\n Function: Get/Set if the Sequential/Interleaved flag has to be shown\n           after the number of sequences and sequence length\n Example :\n Returns : boolean\n Args    : boolean\n\n\n\nsub flag_SI{\n   my ($self,$value) = @_;\n   my $previous = $self->{'_flag_SI'};\n   if( defined $value ) {\n       $self->{'_flag_SI'} = $value;\n   }\n   return $previous;\n}\n\n=head2 idlength\n\n Title   : idlength\n Usage   : my $idlength = $obj->idlength\n Function: Get/Set value of id length\n Returns : string\n Args    : string\n\n\n\nsub idlength {\n\tmy($self,$value) = @_;\n\tif (defined $value){\n\t   $self->{'_idlength'} = $value;\n\t}\n\treturn $self->{'_idlength'};\n}\n\n=head2 line_length\n\n Title   : line_length\n Usage   : $obj->line_length($newval)\n Function:\n Returns : value of line_length\n Args    : newvalue (optional)\n\n\n\nsub line_length{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_line_length'} = $value;\n    }\n    return $self->{'_line_length'} || $DEFAULTLINELEN;\n\n}\n\n=head2 tag_length\n\n Title   : tag_length\n Usage   : $obj->tag_length($newval)\n Function:\n Example : my $tag_length = $obj->tag_length\n Returns : value of the length for each space-separated tag in a line\n Args    : newvalue (optional) - set to zero to have one tag per line\n\n\n\nsub tag_length{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_tag_length'} = $value;\n    }\n    return $self->{'_tag_length'} || $DEFAULTTAGLEN;\n}\n\n\n=head2 id_linebreak\n\n Title   : id_linebreak\n Usage   : $obj->id_linebreak($newval)\n Function:\n Returns : value of id_linebreak\n Args    : newvalue (optional)\n\n\n\nsub id_linebreak{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_id_linebreak'} = $value;\n    }\n    return $self->{'_id_linebreak'} || 0;\n}\n\n\n=head2 wrap_sequential\n\n Title   : wrap_sequential\n Usage   : $obj->wrap_sequential($newval)\n Function:\n Returns : value of wrap_sequential\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}]},"line":554,"range":{"start":{"line":554,"character":0},"end":{"character":9999,"line":560}},"kind":12,"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"wrap_sequential","name":"$self","line":555},{"containerName":"wrap_sequential","kind":13,"name":"$value","line":555},{"line":556,"kind":13,"containerName":"wrap_sequential","name":"$value"},{"name":"$self","containerName":"wrap_sequential","kind":13,"line":557},{"containerName":"wrap_sequential","kind":13,"name":"$value","line":557},{"line":559,"name":"$self","containerName":"wrap_sequential","kind":13}],"name":"wrap_sequential","containerName":"main::"},{"definition":"sub","detail":"($self,$value)","children":[{"line":574,"name":"$self","localvar":"my","kind":13,"containerName":"longid","definition":"my"},{"line":574,"name":"$value","kind":13,"containerName":"longid"},{"name":"$value","containerName":"longid","kind":13,"line":575},{"name":"$self","containerName":"longid","kind":13,"line":576},{"name":"$value","kind":13,"containerName":"longid","line":576},{"line":578,"kind":13,"containerName":"longid","name":"$self"}],"name":"longid","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: phylip.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::phylip\n#\n# Copyright Heikki Lehvaslaiho\n#\n\n=head1 NAME\n\nBio::AlignIO::phylip - PHYLIP format sequence input/output stream\n\n=head1 SYNOPSIS\n\n# Do not use this module directly.  Use it via the Bio::AlignIO class.\n\n    use Bio::AlignIO;\n    use Bio::SimpleAlign;\n    #you can set the name length to something other than the default 10\n    #if you use a version of phylip (hacked) that accepts ids > 10\n    my $phylipstream = Bio::AlignIO->new(-format  => 'phylip',\n                                        -fh      => \\*STDOUT,\n                                        -idlength=>30);\n    # convert data from one format to another\n    my $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                          -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n    # do it again with phylip sequential format format\n    $phylipstream->interleaved(0);\n    # can also initialize the object like this\n    $phylipstream = Bio::AlignIO->new(-interleaved => 0,\n                                     -format => 'phylip',\n                                     -fh   => \\*STDOUT,\n                                     -idlength=>10);\n    $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                       -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::SimpleAlign objects to and from PHYLIP\nfotmat. By deafult it works with the interleaved format. By specifying\nthe flag -interleaved =E<gt> 0 in the initialization the module can\nread or write data in sequential format.\n\nLong IDs up to 50 characters are supported by flag -longid =E<gt>\n1. ID strings can be surrounded by single quoted. They are mandatory\nonly if the IDs contain spaces. \n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Heikki Lehvaslaiho and Jason Stajich\n\nEmail: heikki at ebi.ac.uk\nEmail: jason at bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::phylip;\nuse vars qw($DEFAULTIDLENGTH $DEFAULTLINELEN $DEFAULTTAGLEN);\nuse strict;\n\nuse Bio::SimpleAlign;\nuse POSIX; # for the rounding call\n\nuse base qw(Bio::AlignIO);\n\nBEGIN {\n    $DEFAULTIDLENGTH = 10;\n    $DEFAULTLINELEN = 60;\n    $DEFAULTTAGLEN = 10;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $alignio = Bio::AlignIO->new(-format => 'phylip'\n\t\t\t\t\t  -file   => '>file',\n\t\t\t\t\t  -idlength => 10,\n\t\t\t\t\t  -idlinebreak => 1);\n Function: Initialize a new L<Bio::AlignIO::phylip> reader or writer\n Returns : L<Bio::AlignIO> object\n Args    : [specific for writing of phylip format files]\n           -idlength => integer - length of the id (will pad w/\n\t\t\t\t\t\t    spaces if needed)\n           -interleaved => boolean - whether interleaved\n                                     or sequential format required\n           -line_length  => integer of how long a sequence lines should be\n           -idlinebreak => insert a line break after the sequence id\n                           so that sequence starts on the next line\n           -flag_SI => whether or not write a \"S\" or \"I\" just after\n                       the num.seq. and line len., in the first line\n           -tag_length => integer of how long the tags have to be in\n                         each line between the space separator. set it\n                         to 0 to have 1 tag only.\n           -wrap_sequential => boolean for whether or not sequential\n                                   format should be broken up or a single line\n                                   default is false (single line)\n           -longid => boolean for allowing arbitrary long IDs (default is false)\n\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n\n  my ($interleave,$linelen,$idlinebreak,\n      $idlength, $flag_SI, $tag_length,$ws, $longid) =\n          $self->_rearrange([qw(INTERLEAVED\n                                LINE_LENGTH\n                                IDLINEBREAK\n                                IDLENGTH\n                                FLAG_SI\n                                TAG_LENGTH\n\t\t\t\tWRAP_SEQUENTIAL\n                                LONGID)],@args);\n  $self->interleaved($interleave ? 1 : 0) if defined $interleave;\n  $self->idlength($idlength || $DEFAULTIDLENGTH);\n  $self->id_linebreak(1) if( $idlinebreak );\n  $self->line_length($linelen) if defined $linelen && $linelen > 0;\n  $self->flag_SI(1) if ( $flag_SI );\n  $self->tag_length($tag_length) if ( $tag_length || $DEFAULTTAGLEN );\n  $self->wrap_sequential($ws ? 1 : 0);\n  $self->longid($longid ? 1 : 0);\n  1;\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream.\n           Throws an exception if trying to read in PHYLIP\n           sequential format.\n Returns : L<Bio::SimpleAlign> object\n Args    :\n\n\nsub next_aln {\n    my $self = shift;\n    my $entry;\n    my ($seqcount, $residuecount, %hash, $name,$str,\n\t@names,$seqname,$start,$end,$count,$seq);\n\n    my $aln =  Bio::SimpleAlign->new(-source => 'phylip');\n    $entry = $self->_readline and\n        ($seqcount, $residuecount) = $entry =~ /\\s*(\\d+)\\s+(\\d+)/;\n    return unless $seqcount and $residuecount;\n\n    # first alignment section\n    my $idlen = $self->idlength;\n    $count = 0;\n    my $iter = 1;\n    my $interleaved = $self->interleaved;\n    while( $entry = $self->_readline) {\n\tlast if( $entry =~ /^\\s?$/ && $interleaved );\n\n\tif( $entry =~ /^\\s+(\\d+)\\s+(\\d+)\\s*$/) {\n\t    $self->_pushback($entry);\n\t    last;\n\t}\n\tif( $self->longid  && $entry =~ /\\w/ ) {\n\t    if ($entry =~ /'/) {\n\t\t$entry =~ /^\\s*'([^']+)'\\s+(.+)$/;\n\t\t$name = $1;\n\t\t$str = $2;\n\t    } else {\n\t\t$entry =~ /^\\s*([^\\s]+)\\s+(.+)$/;\n\t\t$name = $1;\n\t\t$str = $2;\n\t    }\n#\t    $name =~ s/[\\s\\/]/_/g; # not sure how wise is it to do this\n\t    $name =~ s/_+$//; # remove any trailing _'s\n\t    \n\t    push @names, $name;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} = $str;\n\n\t} elsif( $entry =~ /^\\s+(.+)$/ ) {\n\t    $interleaved = 0;\n\t    $str = $1;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} .= $str;\n\t} elsif( $entry =~ /^(.{$idlen})\\s+(.*)\\s$/ ||\n\t\t $entry =~ /^(.{$idlen})(\\S{$idlen}\\s+.+)\\s$/ # Handle weirdnes s when id is too long\n\t\t ) {\n\t    $name = $1;\n\t    $str = $2;\n\t    $name =~ s/[\\s\\/]/_/g;\n\t    $name =~ s/_+$//; # remove any trailing _'s\n\n\t    push @names, $name;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} = $str;\n\t} elsif( $interleaved ) {\n\t    if( $entry =~ /^(\\S+)\\s+(.+)/ ||\n\t\t$entry =~ /^(.{$idlen})(.*)\\s$/ ) {\n\t\t$name = $1;\n\t\t$str = $2;\n\t\t$name =~ s/[\\s\\/]/_/g;\n\t\t$name =~ s/_+$//; # remove any trailing _'s\n\t\tpush @names, $name;\n\t\t$str =~ s/\\s//g;\n\t\t$count = scalar @names;\n\t\t$hash{$count} = $str;\n\t    } else {\n\t\t$self->debug(\"unmatched line: $entry\");\n\t    }\n\t}\n\t$self->throw(\"Not a valid interleaved PHYLIP file!\") if $count > $seqcount;\n    }\n\n    if( $interleaved ) {\n\t# interleaved sections\n\t$count = 0;\n\twhile( $entry = $self->_readline) {\n            # finish current entry\n\t    if($entry =~/\\s*\\d+\\s+\\d+/){\n\t\t$self->_pushback($entry);\n\t\tlast;\n\t    }\n\t    $count = 0, next if $entry =~ /^\\s$/;\n\t    $entry =~ /\\s*(.*)$/ && do {\n\t\t$str = $1;\n\t\t$str =~ s/\\s//g;\n\t\t$count++;\n\t\t$hash{$count} .= $str;\n\t    };\n\t    $self->throw(\"Not a valid interleaved PHYLIP file! [$count,$seqcount] ($entry)\") if $count > $seqcount;\n\t}\n    }\n    return if scalar @names < 1;\n\n    # sequence creation\n    $count = 0;\n    foreach $name ( @names ) {\n\t$count++;\n\tif( $name =~ /(\\S+)\\/(\\d+)-(\\d+)/ ) {\n\t    $seqname = $1;\n\t    $start = $2;\n\t    $end = $3;\n\t} else {\n\t    $seqname=$name;\n\t    $start = 1;\n\t    $str = $hash{$count};\n\t    $str =~ s/[^A-Za-z]//g;\n\t    $end = length($str);\n\t}\n\t# consistency test\n\t$self->throw(\"Length of sequence [$seqname] is not [$residuecount] it is \".CORE::length($hash{$count}).\"! \")\n\t    unless CORE::length($hash{$count}) == $residuecount;\n\n       $seq = Bio::LocatableSeq->new('-seq'=>$hash{$count},\n\t\t\t\t    '-id'=>$seqname,\n\t\t\t\t    '-start'=>$start,\n\t\t\t\t    '-end'=>$end,\n\t\t\t\t   );\n\t$aln->add_seq($seq);\n\n   }\n   return $aln if $aln->num_sequences;\n   return;\n}\n\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the $aln object into the stream in MSF format\n Returns : 1 for success and 0 for error\n Args    : L<Bio::Align::AlignI> object\n\n\nsub write_aln {\n    my ($self,@aln) = @_;\n    my $count = 0;\n    my $wrapped = 0;\n    my $maxname;\n    my $width = $self->line_length();\n    my ($length,$date,$name,$seq,$miss,$pad,\n\t%hash,@arr,$tempcount,$index,$idlength,$flag_SI,$line_length, $tag_length);\n\n    foreach my $aln (@aln) {\n\tif( ! $aln || ! $aln->isa('Bio::Align::AlignI')  ) {\n\t    $self->warn(\"Must provide a Bio::Align::AlignI object when calling write_aln\");\n\t    next;\n\t}\n\t$self->throw(\"All sequences in the alignment must be the same length\")\n\t    unless $aln->is_flush(1) ;\n\n        $flag_SI = $self->flag_SI();\n\t$aln->set_displayname_flat(); # plain\n\t$length  = $aln->length();\n        if ($flag_SI) {\n            if ($self->interleaved() ) {\n                $self->_print (sprintf(\" %s %s I\\n\", $aln->num_sequences, $aln->length));\n            } else {\n                $self->_print (sprintf(\" %s %s S\\n\", $aln->num_sequences, $aln->length));\n            }\n        } else {\n            $self->_print (sprintf(\" %s %s\\n\", $aln->num_sequences, $aln->length));\n        }\n\n\t$idlength = $self->idlength();\n\t$line_length = $self->line_length();\n\t$tag_length = $self->tag_length();\n\tforeach $seq ( $aln->each_seq() ) {\n\t    $name = $aln->displayname($seq->get_nse);\n\t    if ($self->longid) {\n\t\t$self->warn(\"The lenght of the name is over 50 chars long [$name]\") \n\t\t    if length($name) > 50; \n\t\t$name = \"'$name'  \"\n\t    } else {\n\t\t$name = substr($name, 0, $idlength) if length($name) > $idlength;\n\t\t$name = sprintf(\"%-\".$idlength.\"s\",$name);\n\t\tif( $self->interleaved() ) {\n\t\t    $name .= '   ' ;\n\t\t} elsif( $self->id_linebreak) {\n\t\t    $name .= \"\\n\";\n\t\t}\n\t    }\n\t    #phylip needs dashes not dots\n\t    my $seq = $seq->seq();\n\t    $seq =~ s/\\./-/g;\n\t    $hash{$name} = $seq;\n\t    push(@arr,$name);\n\t}\n\n\tif( $self->interleaved() ) {\n            my $numtags;\n            if ($tag_length <= $line_length) {\n                $numtags = floor($line_length/$tag_length);\n                $line_length = $tag_length*$numtags;\n            } else {\n                $numtags = 1;\n            }\n\t    while( $count < $length ) {\n\n\t\t# there is another block to go!\n\t\tforeach $name ( @arr ) {\n\t\t    my $dispname = $name;\n\t\t    $dispname = '' if $wrapped;\n\t\t    $self->_print (sprintf(\"%\".($idlength+3).\"s\",$dispname));\n\t\t    $tempcount = $count;\n                    $index = 0;\n                    $self->debug(\"residue count: $count\\n\") if ($count%100000 == 0);\n\t\t    while( ($tempcount + $tag_length < $length) &&\n\t\t\t   ($index < $numtags)  ) {\n\t\t\t$self->_print (sprintf(\"%s \",substr($hash{$name},\n\t\t\t\t\t\t\t    $tempcount,\n\t\t\t\t\t\t\t    $tag_length)));\n\t\t\t$tempcount += $tag_length;\n\t\t\t$index++;\n\t\t    }\n\t\t    # last\n\t\t    if( $index < $numtags) {\n\t\t\t# space to print!\n\t\t\t$self->_print (sprintf(\"%s \",substr($hash{$name},\n\t\t\t\t\t\t\t    $tempcount)));\n\t\t\t$tempcount += $tag_length;\n\t\t    }\n\t\t    $self->_print (\"\\n\");\n\t\t}\n\t\t$self->_print (\"\\n\");\n\t\t$count = $tempcount;\n\t\t$wrapped = 1;\n\t    }\n\t} else {\n\t    foreach $name ( @arr ) {\n\t\tmy $dispname = $name;\n\t\tmy $line = sprintf(\"%s%s\\n\",$dispname,$hash{$name});\n\t\tif( $self->wrap_sequential ) {\n\t\t    $line =~ s/(.{1,$width})/$1\\n/g;\n\t\t}\n\t\t$self->_print ($line);\n\t    }\n\t}\n    }\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n    return 1;\n}\n\n=head2 interleaved\n\n Title   : interleaved\n Usage   : my $interleaved = $obj->interleaved\n Function: Get/Set Interleaved status\n Returns : boolean\n Args    : boolean\n\n\n\nsub interleaved {\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       if ($value) {$self->{'_interleaved'} = 1 }\n       else {$self->{'_interleaved'} = 0 }\n   }\n   return 1 unless defined $self->{'_interleaved'};\n   return $self->{'_interleaved'};\n}\n\n=head2 flag_SI\n\n Title   : flag_SI\n Usage   : my $flag = $obj->flag_SI\n Function: Get/Set if the Sequential/Interleaved flag has to be shown\n           after the number of sequences and sequence length\n Example :\n Returns : boolean\n Args    : boolean\n\n\n\nsub flag_SI{\n   my ($self,$value) = @_;\n   my $previous = $self->{'_flag_SI'};\n   if( defined $value ) {\n       $self->{'_flag_SI'} = $value;\n   }\n   return $previous;\n}\n\n=head2 idlength\n\n Title   : idlength\n Usage   : my $idlength = $obj->idlength\n Function: Get/Set value of id length\n Returns : string\n Args    : string\n\n\n\nsub idlength {\n\tmy($self,$value) = @_;\n\tif (defined $value){\n\t   $self->{'_idlength'} = $value;\n\t}\n\treturn $self->{'_idlength'};\n}\n\n=head2 line_length\n\n Title   : line_length\n Usage   : $obj->line_length($newval)\n Function:\n Returns : value of line_length\n Args    : newvalue (optional)\n\n\n\nsub line_length{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_line_length'} = $value;\n    }\n    return $self->{'_line_length'} || $DEFAULTLINELEN;\n\n}\n\n=head2 tag_length\n\n Title   : tag_length\n Usage   : $obj->tag_length($newval)\n Function:\n Example : my $tag_length = $obj->tag_length\n Returns : value of the length for each space-separated tag in a line\n Args    : newvalue (optional) - set to zero to have one tag per line\n\n\n\nsub tag_length{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_tag_length'} = $value;\n    }\n    return $self->{'_tag_length'} || $DEFAULTTAGLEN;\n}\n\n\n=head2 id_linebreak\n\n Title   : id_linebreak\n Usage   : $obj->id_linebreak($newval)\n Function:\n Returns : value of id_linebreak\n Args    : newvalue (optional)\n\n\n\nsub id_linebreak{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_id_linebreak'} = $value;\n    }\n    return $self->{'_id_linebreak'} || 0;\n}\n\n\n=head2 wrap_sequential\n\n Title   : wrap_sequential\n Usage   : $obj->wrap_sequential($newval)\n Function:\n Returns : value of wrap_sequential\n Args    : newvalue (optional)\n\n\n\nsub wrap_sequential{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_wrap_sequential'} = $value;\n    }\n    return $self->{'_wrap_sequential'} || 0;\n}\n\n=head2 longid\n\n Title   : longid\n Usage   : $obj->longid($newval)\n Function:\n Returns : value of longid\n Args    : newvalue (optional)","label":"longid($self,$value)"},"line":573,"range":{"end":{"line":579,"character":9999},"start":{"line":573,"character":0}},"kind":12}],"version":5}