{"version":5,"vars":[{"line":68,"name":"vars","containerName":"","kind":2},{"line":70,"kind":12,"name":"strict"},{"containerName":"","kind":2,"name":"base","line":73},{"line":76,"name":"%valid_type","kind":13,"containerName":null},{"range":{"end":{"line":114,"character":9999},"start":{"line":103,"character":0}},"kind":12,"line":103,"signature":{"label":"_initialize($self,@args)","documentation":"1;\n# $Id: nexus.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::nexus\n#\n# Copyright Heikki Lehvaslaiho\n#\n\n=head1 NAME\n\nBio::AlignIO::nexus - NEXUS format sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the L<Bio::AlignIO> class.\n\n    use Bio::AlignIO;\n\n    my $in = Bio::AlignIO->new(-format => 'nexus',\n                              -file   => 'aln.nexus');\n    while( my $aln = $in->next_aln ) {\n        # do something with the alignment\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform L<Bio::Align::AlignI> objects to and from NEXUS\ndata blocks. See method documentation for supported NEXUS features.\n\n=head1 ACKNOWLEDGEMENTS\n\nWill Fisher has written an excellent standalone NEXUS format parser in\nPerl, readnexus. A number of tricks were adapted from it.\n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Heikki Lehvaslaiho\n\nEmail: heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::nexus;\nuse vars qw(%valid_type);\nuse strict;\nno strict \"refs\";\n\n\nuse base qw(Bio::AlignIO);\n\nBEGIN {\n    %valid_type = map {$_, 1} qw( dna rna protein standard );\n    # standard throws error: inherited from Bio::PrimarySeq\n}\n\n=head2 new\n\n Title   : new\n Usage   : $alignio = Bio::AlignIO->new(-format => 'nexus', -file => 'filename');\n Function: returns a new Bio::AlignIO object to handle clustalw files\n Returns : Bio::AlignIO::clustalw object\n Args    : -verbose => verbosity setting (-1,0,1,2)\n           -file    => name of file to read in or with \">\" - writeout\n           -fh      => alternative to -file param - provide a filehandle \n                       to read from/write to \n           -format  => type of Alignment Format to process or produce\n\n           Customization of nexus flavor output\n\n           -show_symbols => print the symbols=\"ATGC\" in the data definition\n                            (MrBayes does not like this)\n                            boolean [default is 1] \n           -show_endblock => print an 'endblock;' at the end of the data\n                            (MyBayes does not like this)\n                            boolean [default is 1] ","parameters":[{"label":"$self"},{"label":"@args"}]},"containerName":"main::","name":"_initialize","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"_initialize","name":"$self","line":104},{"line":104,"containerName":"_initialize","kind":13,"name":"@args"},{"line":105,"kind":13,"containerName":"_initialize","name":"$self"},{"line":105,"kind":13,"containerName":"_initialize","name":"@args"},{"line":106,"localvar":"my","containerName":"_initialize","kind":13,"name":"$show_symbols","definition":"my"},{"line":106,"name":"$endblock","kind":13,"containerName":"_initialize"},{"name":"$self","containerName":"_initialize","kind":13,"line":107},{"kind":12,"containerName":"_initialize","name":"_rearrange","line":107},{"line":107,"kind":13,"containerName":"_initialize","name":"@args"},{"definition":"my","line":108,"localvar":"my","kind":13,"containerName":"_initialize","name":"@names"},{"definition":"my","line":109,"name":"$v","localvar":"my","containerName":"_initialize","kind":13},{"line":109,"name":"$show_symbols","kind":13,"containerName":"_initialize"},{"kind":13,"containerName":"_initialize","name":"$endblock","line":109},{"line":110,"containerName":"_initialize","kind":13,"name":"$v"},{"line":110,"name":"$v","containerName":"_initialize","kind":13},{"line":111,"containerName":"_initialize","localvar":"my","kind":13,"name":"$n","definition":"my"},{"line":111,"name":"@names","kind":13,"containerName":"_initialize"},{"line":112,"name":"$self","kind":13,"containerName":"_initialize"},{"name":"flag","containerName":"_initialize","kind":12,"line":112},{"line":112,"containerName":"_initialize","kind":13,"name":"$n"},{"containerName":"_initialize","kind":13,"name":"$v","line":112}],"detail":"($self,@args)","definition":"sub"},{"line":105,"name":"SUPER","containerName":"_initialize","kind":12},{"containerName":"main::","name":"next_aln","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"next_aln","line":143},{"line":144,"name":"$entry","localvar":"my","kind":13,"containerName":"next_aln","definition":"my"},{"definition":"my","kind":13,"localvar":"my","containerName":"next_aln","name":"$aln_name","line":145},{"name":"$seqcount","kind":13,"containerName":"next_aln","line":145},{"line":145,"containerName":"next_aln","kind":13,"name":"$residuecount"},{"name":"%hash","kind":13,"containerName":"next_aln","line":145},{"line":145,"kind":13,"containerName":"next_aln","name":"$alphabet"},{"name":"$match","containerName":"next_aln","kind":13,"line":146},{"line":146,"containerName":"next_aln","kind":13,"name":"$gap"},{"line":146,"kind":13,"containerName":"next_aln","name":"$missing"},{"containerName":"next_aln","kind":13,"name":"$equate","line":146},{"line":146,"containerName":"next_aln","kind":13,"name":"$interleave"},{"line":147,"name":"$name","kind":13,"containerName":"next_aln"},{"line":147,"name":"$str","containerName":"next_aln","kind":13},{"kind":13,"containerName":"next_aln","name":"@names","line":147},{"line":147,"name":"$seqname","containerName":"next_aln","kind":13},{"name":"$start","kind":13,"containerName":"next_aln","line":147},{"name":"$end","containerName":"next_aln","kind":13,"line":147},{"name":"$count","kind":13,"containerName":"next_aln","line":147},{"name":"$seq","containerName":"next_aln","kind":13,"line":147},{"line":148,"containerName":"next_aln","kind":13,"name":"$Bio"},{"line":149,"kind":13,"containerName":"next_aln","name":"$Bio"},{"definition":"my","name":"$aln","containerName":"next_aln","localvar":"my","kind":13,"line":150},{"line":150,"name":"new","containerName":"next_aln","kind":12},{"containerName":"next_aln","kind":13,"name":"$entry","line":153},{"line":153,"kind":13,"containerName":"next_aln","name":"$self"},{"line":153,"containerName":"next_aln","kind":12,"name":"_readline"},{"line":154,"name":"$entry","containerName":"next_aln","kind":13},{"name":"$self","containerName":"next_aln","kind":13,"line":154},{"containerName":"next_aln","kind":12,"name":"_readline","line":154},{"name":"$entry","kind":13,"containerName":"next_aln","line":154},{"kind":13,"containerName":"next_aln","name":"$entry","line":154},{"line":156,"name":"$entry","containerName":"next_aln","kind":13},{"name":"$self","kind":13,"containerName":"next_aln","line":157},{"name":"throw","containerName":"next_aln","kind":12,"line":157},{"containerName":"next_aln","kind":13,"name":"$entry","line":158},{"kind":13,"containerName":"next_aln","name":"$entry","line":158},{"containerName":"next_aln","kind":13,"name":"$entry","line":162},{"kind":13,"containerName":"next_aln","name":"$self","line":162},{"name":"_readline","kind":12,"containerName":"next_aln","line":162},{"line":163,"kind":13,"containerName":"next_aln","name":"$entry"},{"line":164,"containerName":"next_aln","kind":13,"name":"$aln_name"},{"line":167,"containerName":"next_aln","kind":13,"name":"$aln_name"},{"name":"$aln","containerName":"next_aln","kind":13,"line":167},{"name":"id","kind":12,"containerName":"next_aln","line":167},{"line":167,"kind":13,"containerName":"next_aln","name":"$aln_name"},{"line":167,"name":"$aln_name","containerName":"next_aln","kind":13},{"localvar":"my","containerName":"next_aln","kind":13,"name":"$incomment","line":170,"definition":"my"},{"line":171,"kind":13,"containerName":"next_aln","name":"$entry"},{"kind":13,"containerName":"next_aln","name":"$self","line":171},{"kind":12,"containerName":"next_aln","name":"_readline","line":171},{"name":"$entry","containerName":"next_aln","kind":13,"line":172},{"line":175,"containerName":"next_aln","kind":13,"name":"$incomment"},{"line":178,"name":"$incomment","containerName":"next_aln","kind":13},{"line":180,"name":"$incomment","containerName":"next_aln","kind":13},{"line":189,"containerName":"next_aln","kind":13,"name":"$seqcount"},{"line":190,"name":"$residuecount","kind":13,"containerName":"next_aln"},{"line":191,"name":"$match","kind":13,"containerName":"next_aln"},{"line":192,"kind":13,"containerName":"next_aln","name":"$gap"},{"line":193,"containerName":"next_aln","kind":13,"name":"$missing"},{"line":194,"kind":13,"containerName":"next_aln","name":"$equate"},{"name":"$alphabet","kind":13,"containerName":"next_aln","line":195},{"name":"$interleave","kind":13,"containerName":"next_aln","line":196},{"line":200,"containerName":"next_aln","kind":13,"name":"$self"},{"kind":12,"containerName":"next_aln","name":"throw","line":200},{"kind":13,"containerName":"next_aln","name":"$alphabet","line":201},{"containerName":"next_aln","kind":13,"name":"$self","line":202},{"line":202,"containerName":"next_aln","kind":12,"name":"throw"},{"line":203,"kind":13,"containerName":"next_aln","name":"$valid_type"},{"containerName":"next_aln","kind":13,"name":"$alphabet","line":203},{"line":204,"name":"$self","containerName":"next_aln","kind":13},{"name":"throw","kind":12,"containerName":"next_aln","line":204},{"name":"$gap","containerName":"next_aln","kind":13,"line":205},{"line":205,"kind":13,"containerName":"next_aln","name":"$gap"},{"line":206,"name":"$self","containerName":"next_aln","kind":13},{"kind":12,"containerName":"next_aln","name":"throw","line":206},{"line":207,"name":"$missing","containerName":"next_aln","kind":13},{"line":207,"kind":13,"containerName":"next_aln","name":"$missing"},{"line":209,"containerName":"next_aln","kind":13,"name":"$aln"},{"name":"gap_char","containerName":"next_aln","kind":12,"line":209},{"line":209,"name":"$gap","containerName":"next_aln","kind":13},{"kind":13,"containerName":"next_aln","name":"$aln","line":210},{"line":210,"name":"missing_char","containerName":"next_aln","kind":12},{"name":"$missing","containerName":"next_aln","kind":13,"line":210},{"line":216,"name":"$entry","kind":13,"containerName":"next_aln"},{"line":216,"name":"$self","containerName":"next_aln","kind":13},{"containerName":"next_aln","kind":12,"name":"_readline","line":216},{"name":"$entry","containerName":"next_aln","kind":13,"line":217},{"name":"$self","kind":13,"containerName":"next_aln","line":218},{"name":"_pushback","containerName":"next_aln","kind":12,"line":218},{"containerName":"next_aln","kind":13,"name":"$entry","line":218},{"line":227,"containerName":"next_aln","kind":13,"name":"@names"},{"name":"$entry","containerName":"next_aln","kind":13,"line":228},{"name":"$self","kind":13,"containerName":"next_aln","line":228},{"kind":12,"containerName":"next_aln","name":"_readline","line":228},{"line":229,"containerName":"next_aln","kind":13,"name":"$entry"},{"line":234,"kind":13,"containerName":"next_aln","name":"$interleave"},{"line":234,"containerName":"next_aln","kind":13,"name":"$count"},{"line":234,"containerName":"next_aln","kind":13,"name":"$count"},{"line":234,"name":"$seqcount","kind":13,"containerName":"next_aln"},{"line":245,"containerName":"next_aln","kind":13,"name":"$name"},{"kind":13,"containerName":"next_aln","name":"$str","line":249},{"name":"$str","kind":13,"containerName":"next_aln","line":253},{"line":254,"kind":13,"containerName":"next_aln","name":"$self"},{"containerName":"next_aln","kind":12,"name":"_readline","line":254},{"name":"$str_tmp","localvar":"my","containerName":"next_aln","kind":13,"line":255,"definition":"my"},{"line":256,"kind":13,"containerName":"next_aln","name":"$str_tmp"},{"line":257,"name":"$str","kind":13,"containerName":"next_aln"},{"containerName":"next_aln","kind":13,"name":"$str_tmp","line":257},{"line":258,"containerName":"next_aln","kind":13,"name":"$str"},{"containerName":"next_aln","kind":13,"name":"$residuecount","line":258},{"line":261,"kind":13,"containerName":"next_aln","name":"$name"},{"name":"@names","kind":13,"containerName":"next_aln","line":262},{"name":"$name","kind":13,"containerName":"next_aln","line":262},{"name":"$str","containerName":"next_aln","kind":13,"line":264},{"line":265,"name":"$count","containerName":"next_aln","kind":13},{"name":"@names","containerName":"next_aln","kind":13,"line":265},{"line":266,"containerName":"next_aln","kind":13,"name":"$hash"},{"containerName":"next_aln","kind":13,"name":"$count","line":266},{"line":266,"kind":13,"containerName":"next_aln","name":"$str"},{"name":"$self","kind":13,"containerName":"next_aln","line":268},{"name":"throw","kind":12,"containerName":"next_aln","line":268},{"name":"$count","containerName":"next_aln","kind":13,"line":268},{"kind":13,"containerName":"next_aln","name":"$seqcount","line":268},{"name":"$count","kind":13,"containerName":"next_aln","line":274},{"name":"$interleave","kind":13,"containerName":"next_aln","line":275},{"containerName":"next_aln","kind":13,"name":"$entry","line":276},{"kind":13,"containerName":"next_aln","name":"$self","line":276},{"line":276,"kind":12,"containerName":"next_aln","name":"_readline"},{"name":"$entry","containerName":"next_aln","kind":13,"line":277},{"name":"$hash","containerName":"next_aln","kind":13,"line":287},{"name":"$count","kind":13,"containerName":"next_aln","line":287},{"line":287,"containerName":"next_aln","kind":13,"name":"$str"},{"line":289,"containerName":"next_aln","kind":13,"name":"$self"},{"line":289,"name":"throw","kind":12,"containerName":"next_aln"},{"containerName":"next_aln","kind":13,"name":"$count","line":290},{"line":290,"name":"$seqcount","kind":13,"containerName":"next_aln"}],"definition":"sub","kind":12,"range":{"start":{"character":0,"line":142},"end":{"line":293,"character":9999}},"line":142},{"line":148,"name":"LocatableSeq","containerName":"OTHER_SYMBOLS","kind":12},{"name":"LocatableSeq","containerName":"GAP_SYMBOLS","kind":12,"line":149},{"name":"Bio","containerName":"SimpleAlign","kind":12,"line":150},{"kind":13,"containerName":null,"name":"@names","line":295},{"name":"$count","containerName":null,"kind":13,"line":298},{"name":"$name","containerName":null,"kind":13,"line":299},{"name":"@names","containerName":null,"kind":13,"line":299},{"kind":13,"containerName":null,"name":"$count","line":300},{"line":301,"containerName":null,"kind":13,"name":"%name"},{"line":302,"containerName":null,"kind":13,"name":"$seqname"},{"kind":13,"containerName":null,"name":"$start","line":303},{"containerName":null,"kind":13,"name":"%end","line":304},{"line":306,"containerName":null,"kind":13,"name":"$seqname"},{"containerName":null,"kind":13,"name":"$name","line":306},{"kind":13,"containerName":null,"name":"$start","line":307},{"containerName":null,"kind":13,"name":"$str","line":308},{"containerName":null,"kind":13,"name":"%hash","line":308},{"name":"$count","containerName":null,"kind":13,"line":308},{"line":309,"containerName":null,"kind":13,"name":"$str"},{"kind":13,"containerName":null,"name":"$end","line":310},{"line":310,"name":"$str","kind":13,"containerName":null},{"name":"$self","containerName":null,"kind":13,"line":314},{"kind":12,"containerName":"main::","name":"throw","line":314},{"line":314,"containerName":"length","kind":12,"name":"CORE"},{"line":314,"name":"%hash","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$count","line":314},{"containerName":"length","kind":12,"name":"CORE","line":315},{"line":315,"kind":13,"containerName":null,"name":"%hash"},{"line":315,"kind":13,"containerName":null,"name":"$count"},{"kind":13,"containerName":null,"name":"$residuecount","line":315},{"line":317,"name":"$seq","containerName":null,"kind":13},{"containerName":"LocatableSeq","kind":12,"name":"Bio","line":317},{"kind":12,"containerName":"main::","name":"new","line":317},{"line":317,"kind":13,"containerName":null,"name":"%hash"},{"line":317,"containerName":null,"kind":13,"name":"$count"},{"name":"$seqname","containerName":null,"kind":13,"line":318},{"line":319,"name":"$start","containerName":null,"kind":13},{"name":"$end","containerName":null,"kind":13,"line":320},{"line":322,"containerName":null,"kind":13,"name":"$alphabet"},{"name":"$aln","containerName":null,"kind":13,"line":323},{"name":"add_seq","containerName":"main::","kind":12,"line":323},{"line":323,"name":"$seq","containerName":null,"kind":13},{"line":327,"name":"$aln","kind":13,"containerName":null},{"name":"unmatch","kind":12,"containerName":"main::","line":327},{"containerName":null,"kind":13,"name":"$match","line":327},{"line":327,"containerName":null,"kind":13,"name":"$match"},{"name":"%equate","containerName":null,"kind":13,"line":330},{"name":"$aln","kind":13,"containerName":null,"line":331},{"name":"map_chars","kind":12,"containerName":"main::","line":331},{"name":"$equate","kind":13,"containerName":null,"line":331},{"line":334,"name":"$entry","kind":13,"containerName":null},{"line":335,"kind":13,"containerName":null,"name":"%entry"},{"containerName":null,"kind":13,"name":"$entry","line":336},{"name":"$self","kind":13,"containerName":null,"line":336},{"line":336,"kind":12,"containerName":"main::","name":"_readline"},{"kind":13,"containerName":null,"name":"$aln","line":339},{"kind":13,"containerName":null,"name":"$aln","line":339},{"line":339,"name":"num_sequences","containerName":"main::","kind":12},{"signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"_read_taxlabels($self)"},"line":343,"kind":12,"range":{"end":{"character":9999,"line":356},"start":{"character":0,"line":343}},"definition":"sub","detail":"($self)","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"_read_taxlabels","line":344},{"definition":"my","line":345,"containerName":"_read_taxlabels","localvar":"my","kind":13,"name":"$name"},{"containerName":"_read_taxlabels","kind":13,"name":"@names","line":345},{"localvar":"my","containerName":"_read_taxlabels","kind":13,"name":"$entry","line":346,"definition":"my"},{"kind":13,"containerName":"_read_taxlabels","name":"$self","line":346},{"line":346,"containerName":"_read_taxlabels","kind":12,"name":"_readline"},{"name":"$entry","containerName":"_read_taxlabels","kind":13,"line":347},{"line":348,"name":"$entry","kind":13,"containerName":"_read_taxlabels"},{"containerName":"_read_taxlabels","kind":13,"name":"$name","line":349},{"containerName":"_read_taxlabels","kind":13,"name":"$name","line":350},{"line":351,"containerName":"_read_taxlabels","kind":13,"name":"$name"},{"kind":13,"containerName":"_read_taxlabels","name":"@names","line":352},{"containerName":"_read_taxlabels","kind":13,"name":"$name","line":352},{"line":355,"name":"@names","containerName":"_read_taxlabels","kind":13}],"name":"_read_taxlabels","containerName":"main::"},{"definition":"sub","detail":"($self,@aln)","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"write_aln","name":"$self","line":372},{"name":"@aln","containerName":"write_aln","kind":13,"line":372},{"containerName":"write_aln","localvar":"my","kind":13,"name":"$count","line":373,"definition":"my"},{"name":"$wrapped","kind":13,"localvar":"my","containerName":"write_aln","line":374,"definition":"my"},{"line":375,"name":"$maxname","localvar":"my","kind":13,"containerName":"write_aln","definition":"my"},{"definition":"my","name":"$length","containerName":"write_aln","localvar":"my","kind":13,"line":376},{"line":376,"containerName":"write_aln","kind":13,"name":"$date"},{"containerName":"write_aln","kind":13,"name":"$name","line":376},{"line":376,"name":"$seq","containerName":"write_aln","kind":13},{"line":376,"kind":13,"containerName":"write_aln","name":"$miss"},{"line":376,"name":"$pad","kind":13,"containerName":"write_aln"},{"name":"%hash","containerName":"write_aln","kind":13,"line":376},{"line":376,"name":"@arr","containerName":"write_aln","kind":13},{"kind":13,"containerName":"write_aln","name":"$tempcount","line":376},{"line":376,"name":"$index","kind":13,"containerName":"write_aln"},{"definition":"my","localvar":"my","containerName":"write_aln","kind":13,"name":"$match","line":377},{"line":377,"name":"$missing","containerName":"write_aln","kind":13},{"name":"$gap","containerName":"write_aln","kind":13,"line":377},{"containerName":"write_aln","kind":13,"name":"$symbols","line":377},{"definition":"my","name":"$aln","containerName":"write_aln","localvar":"my","kind":13,"line":379},{"name":"@aln","containerName":"write_aln","kind":13,"line":379},{"name":"$aln","containerName":"write_aln","kind":13,"line":380},{"line":380,"kind":13,"containerName":"write_aln","name":"$aln"},{"kind":12,"containerName":"write_aln","name":"isa","line":380},{"name":"$self","containerName":"write_aln","kind":13,"line":381},{"containerName":"write_aln","kind":12,"name":"warn","line":381},{"line":384,"name":"$self","containerName":"write_aln","kind":13},{"name":"throw","kind":12,"containerName":"write_aln","line":384},{"kind":13,"containerName":"write_aln","name":"$aln","line":385},{"line":385,"kind":12,"containerName":"write_aln","name":"is_flush"},{"line":385,"name":"$self","kind":13,"containerName":"write_aln"},{"name":"verbose","kind":12,"containerName":"write_aln","line":385},{"containerName":"write_aln","kind":13,"name":"$length","line":387},{"containerName":"write_aln","kind":13,"name":"$aln","line":387},{"line":387,"containerName":"write_aln","kind":12,"name":"length"},{"name":"$self","kind":13,"containerName":"write_aln","line":389},{"line":389,"kind":12,"containerName":"write_aln","name":"_print"},{"name":"$aln","kind":13,"containerName":"write_aln","line":390},{"line":390,"name":"id","containerName":"write_aln","kind":12},{"line":390,"kind":13,"containerName":"write_aln","name":"$aln"},{"name":"num_sequences","kind":12,"containerName":"write_aln","line":390},{"line":390,"containerName":"write_aln","kind":13,"name":"$length"},{"line":391,"name":"$match","kind":13,"containerName":"write_aln"},{"name":"$aln","kind":13,"containerName":"write_aln","line":391},{"containerName":"write_aln","kind":12,"name":"match_char","line":391},{"name":"$aln","kind":13,"containerName":"write_aln","line":391},{"name":"match_char","kind":12,"containerName":"write_aln","line":391},{"line":392,"kind":13,"containerName":"write_aln","name":"$missing"},{"containerName":"write_aln","kind":13,"name":"$aln","line":392},{"line":392,"name":"missing_char","kind":12,"containerName":"write_aln"},{"line":392,"name":"$aln","kind":13,"containerName":"write_aln"},{"line":392,"kind":12,"containerName":"write_aln","name":"missing_char"},{"line":393,"name":"$gap","kind":13,"containerName":"write_aln"},{"line":393,"kind":13,"containerName":"write_aln","name":"$aln"},{"line":393,"containerName":"write_aln","kind":12,"name":"gap_char"},{"name":"$aln","containerName":"write_aln","kind":13,"line":393},{"line":393,"kind":12,"containerName":"write_aln","name":"gap_char"},{"name":"$symbols","kind":13,"containerName":"write_aln","line":395},{"name":"$aln","containerName":"write_aln","kind":13,"line":395},{"line":395,"kind":12,"containerName":"write_aln","name":"symbol_chars"},{"name":"$self","containerName":"write_aln","kind":13,"line":396},{"line":396,"kind":12,"containerName":"write_aln","name":"flag"},{"line":396,"kind":13,"containerName":"write_aln","name":"$aln"},{"kind":12,"containerName":"write_aln","name":"symbol_chars","line":396},{"line":397,"kind":13,"containerName":"write_aln","name":"$self"},{"name":"_print","containerName":"write_aln","kind":12,"line":397},{"name":"$aln","containerName":"write_aln","kind":13,"line":399},{"kind":12,"containerName":"write_aln","name":"get_seq_by_pos","line":399},{"line":399,"name":"alphabet","containerName":"write_aln","kind":12},{"name":"$match","containerName":"write_aln","kind":13,"line":399},{"line":400,"name":"$missing","containerName":"write_aln","kind":13},{"line":400,"kind":13,"containerName":"write_aln","name":"$gap"},{"line":400,"name":"$symbols","kind":13,"containerName":"write_aln"},{"localvar":"my","containerName":"write_aln","kind":13,"name":"$indent","line":403,"definition":"my"},{"line":403,"kind":13,"containerName":"write_aln","name":"$aln"},{"name":"maxdisplayname_length","kind":12,"containerName":"write_aln","line":403},{"containerName":"write_aln","kind":13,"name":"$aln","line":405},{"line":405,"name":"set_displayname_flat","containerName":"write_aln","kind":12},{"containerName":"write_aln","kind":13,"name":"$seq","line":406},{"containerName":"write_aln","kind":13,"name":"$aln","line":406},{"name":"each_seq","containerName":"write_aln","kind":12,"line":406},{"definition":"my","line":407,"containerName":"write_aln","localvar":"my","kind":13,"name":"$nmid"},{"line":407,"name":"$aln","containerName":"write_aln","kind":13},{"containerName":"write_aln","kind":12,"name":"displayname","line":407},{"name":"$seq","kind":13,"containerName":"write_aln","line":407},{"line":407,"name":"get_nse","kind":12,"containerName":"write_aln"},{"line":408,"containerName":"write_aln","kind":13,"name":"$nmid"},{"containerName":"write_aln","kind":13,"name":"$name","line":413},{"name":"$nmid","containerName":"write_aln","kind":13,"line":413},{"line":415,"name":"$name","kind":13,"containerName":"write_aln"},{"line":415,"name":"$nmid","kind":13,"containerName":"write_aln"},{"kind":13,"containerName":"write_aln","name":"$hash","line":417},{"name":"$name","kind":13,"containerName":"write_aln","line":417},{"line":417,"name":"$seq","kind":13,"containerName":"write_aln"},{"name":"seq","containerName":"write_aln","kind":12,"line":417},{"line":418,"name":"@arr","containerName":"write_aln","kind":13},{"line":418,"name":"$name","containerName":"write_aln","kind":13},{"line":421,"kind":13,"containerName":"write_aln","name":"$count"},{"kind":13,"containerName":"write_aln","name":"$length","line":421},{"line":423,"name":"$name","kind":13,"containerName":"write_aln"},{"line":423,"containerName":"write_aln","kind":13,"name":"@arr"},{"line":424,"name":"$dispname","kind":13,"localvar":"my","containerName":"write_aln","definition":"my"},{"containerName":"write_aln","kind":13,"name":"$name","line":424},{"line":426,"name":"$self","kind":13,"containerName":"write_aln"},{"line":426,"name":"_print","kind":12,"containerName":"write_aln"},{"line":426,"containerName":"write_aln","kind":13,"name":"$dispname"},{"name":"$tempcount","kind":13,"containerName":"write_aln","line":427},{"name":"$count","kind":13,"containerName":"write_aln","line":427},{"kind":13,"containerName":"write_aln","name":"$index","line":428},{"line":429,"name":"$tempcount","containerName":"write_aln","kind":13},{"name":"$length","kind":13,"containerName":"write_aln","line":429},{"line":429,"kind":13,"containerName":"write_aln","name":"$index"},{"kind":13,"containerName":"write_aln","name":"$self","line":430},{"kind":12,"containerName":"write_aln","name":"_print","line":430},{"name":"$hash","kind":13,"containerName":"write_aln","line":430},{"line":430,"containerName":"write_aln","kind":13,"name":"$name"},{"name":"$tempcount","containerName":"write_aln","kind":13,"line":430},{"line":431,"kind":13,"containerName":"write_aln","name":"$tempcount"},{"name":"$index","kind":13,"containerName":"write_aln","line":432},{"line":435,"containerName":"write_aln","kind":13,"name":"$index"},{"line":437,"kind":13,"containerName":"write_aln","name":"$self"},{"line":437,"name":"_print","containerName":"write_aln","kind":12},{"kind":13,"containerName":"write_aln","name":"$hash","line":437},{"line":437,"name":"$name","kind":13,"containerName":"write_aln"},{"kind":13,"containerName":"write_aln","name":"$tempcount","line":437},{"line":438,"kind":13,"containerName":"write_aln","name":"$tempcount"},{"name":"$self","containerName":"write_aln","kind":13,"line":440},{"name":"_print","containerName":"write_aln","kind":12,"line":440},{"name":"$self","kind":13,"containerName":"write_aln","line":442},{"name":"_print","containerName":"write_aln","kind":12,"line":442},{"containerName":"write_aln","kind":13,"name":"$count","line":443},{"line":443,"name":"$tempcount","containerName":"write_aln","kind":13},{"kind":13,"containerName":"write_aln","name":"$wrapped","line":444},{"kind":13,"containerName":"write_aln","name":"$self","line":446},{"line":446,"containerName":"write_aln","kind":12,"name":"flag"},{"containerName":"write_aln","kind":13,"name":"$self","line":447},{"name":"_print","kind":12,"containerName":"write_aln","line":447},{"kind":13,"containerName":"write_aln","name":"$self","line":449},{"line":449,"name":"_print","containerName":"write_aln","kind":12},{"line":452,"name":"$self","containerName":"write_aln","kind":13},{"line":452,"containerName":"write_aln","kind":12,"name":"flush"},{"line":452,"containerName":"write_aln","kind":13,"name":"$self"},{"line":452,"name":"_flush_on_write","containerName":"write_aln","kind":12},{"name":"$self","containerName":"write_aln","kind":13,"line":452},{"kind":12,"containerName":"write_aln","name":"_fh","line":452}],"name":"write_aln","containerName":"main::","signature":{"label":"write_aln($self,@aln)","documentation":"1;\n# $Id: nexus.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::nexus\n#\n# Copyright Heikki Lehvaslaiho\n#\n\n=head1 NAME\n\nBio::AlignIO::nexus - NEXUS format sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the L<Bio::AlignIO> class.\n\n    use Bio::AlignIO;\n\n    my $in = Bio::AlignIO->new(-format => 'nexus',\n                              -file   => 'aln.nexus');\n    while( my $aln = $in->next_aln ) {\n        # do something with the alignment\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform L<Bio::Align::AlignI> objects to and from NEXUS\ndata blocks. See method documentation for supported NEXUS features.\n\n=head1 ACKNOWLEDGEMENTS\n\nWill Fisher has written an excellent standalone NEXUS format parser in\nPerl, readnexus. A number of tricks were adapted from it.\n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Heikki Lehvaslaiho\n\nEmail: heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::nexus;\nuse vars qw(%valid_type);\nuse strict;\nno strict \"refs\";\n\n\nuse base qw(Bio::AlignIO);\n\nBEGIN {\n    %valid_type = map {$_, 1} qw( dna rna protein standard );\n    # standard throws error: inherited from Bio::PrimarySeq\n}\n\n=head2 new\n\n Title   : new\n Usage   : $alignio = Bio::AlignIO->new(-format => 'nexus', -file => 'filename');\n Function: returns a new Bio::AlignIO object to handle clustalw files\n Returns : Bio::AlignIO::clustalw object\n Args    : -verbose => verbosity setting (-1,0,1,2)\n           -file    => name of file to read in or with \">\" - writeout\n           -fh      => alternative to -file param - provide a filehandle \n                       to read from/write to \n           -format  => type of Alignment Format to process or produce\n\n           Customization of nexus flavor output\n\n           -show_symbols => print the symbols=\"ATGC\" in the data definition\n                            (MrBayes does not like this)\n                            boolean [default is 1] \n           -show_endblock => print an 'endblock;' at the end of the data\n                            (MyBayes does not like this)\n                            boolean [default is 1] \n\n\nsub _initialize {\n    my ($self, @args) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($show_symbols, $endblock) = \n\t$self->_rearrange([qw(SHOW_SYMBOLS SHOW_ENDBLOCK)], @args);\n    my @names = qw(symbols endblock);\n    for my $v ( $show_symbols, $endblock ) {\n\t$v = 1 unless defined $v; # default value is 1\n\tmy $n = shift @names;\n\t$self->flag($n, $v);\n    }\n}\n\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: Returns the next alignment in the stream.\n\n           Supports the following NEXUS format features:\n           - The file has to start with '#NEXUS'\n           - Reads in the name of the alignment from a comment\n             (anything after 'TITLE: ') .\n           - Sequence names can be given in a taxa block, too.\n           - If matchchar notation is used, converts\n             them back to sequence characters.\n           - Does character conversions specified in the\n             NEXUS equate command.\n           - Sequence names of type 'Homo sapiens' and\n             Homo_sapiens are treated identically.\n\n Returns : L<Bio::Align::AlignI> object\n Args    :\n\n\n\n\nsub next_aln {\n    my $self = shift;\n    my $entry;\n    my ($aln_name, $seqcount, $residuecount, %hash, $alphabet,\n\t$match, $gap, $missing, $equate, $interleave,\n\t$name,$str,@names,$seqname,$start,$end,$count,$seq);\n    local $Bio::LocatableSeq::OTHER_SYMBOLS = '\\*\\?\\.';\n    local $Bio::LocatableSeq::GAP_SYMBOLS = '\\-';\n    my $aln =  Bio::SimpleAlign->new(-source => 'nexus');\n\n    # file starts with '#NEXUS' but we allow white space only lines before it\n    $entry = $self->_readline;\n    $entry = $self->_readline while defined $entry && $entry =~ /^\\s+$/;\n\n    return unless $entry;\n    $self->throw(\"Not a valid interleaved NEXUS file! [#NEXUS] not starting the file\\n$entry\")\n\tunless ($entry && $entry =~ /^#NEXUS/i);\n\n    # skip anything before either the taxa or data block\n    # but read in the optional title in a comment\n    while (defined($entry = $self->_readline)) {\n\tlocal ($_) = $entry;\n\t/\\[TITLE. *([^\\]]+)]\\s+/i and $aln_name = $1;\n\tlast if /^begin +data/i || /^begin +taxa/i;\n    }\n    $aln_name =~ s/\\s/_/g and $aln->id($aln_name) if $aln_name;\n\n    # data and taxa blocks\n    my $incomment;\n    while (defined ($entry = $self->_readline)) {\n\tlocal ($_) =  $entry;\n\tnext if s/\\[[^\\]]+\\]//g; # remove comments\n\tif( s/\\[[^\\]]+$// ) {\n\t    $incomment = 1;\n\t\t # skip line if it is now empty or contains only whitespace\n\t    next if /^\\s*$/;\n\t} elsif($incomment) {\n\t    if( s/^[^\\]]*\\]// ) {\n\t\t\t $incomment = 0;\n\t    } else {\n\t\t\t next;\n\t    }\n\t} elsif( /taxlabels/i ) {\n\t    # doesn't deal with taxlabels adequately and can mess things up!\n\t    # @names = $self->_read_taxlabels;\n\t} else {\n\n\t    /ntax\\s*=\\s*(\\d+)/i        and $seqcount = $1;\n\t    /nchar\\s*=\\s*(\\d+)/i       and $residuecount = $1;\n\t    /matchchar\\s*=\\s*(.)/i     and $match = $1;\n\t    /gap\\s*=\\s*(.)/i           and $gap = $1;\n\t    /missing\\s*=\\s*(.)/i       and $missing = $1;\n\t    /equate\\s*=\\s*\\\"([^\\\"]+)/i and $equate = $1;  # \"e.g. equate=\"T=C G=A\";\n\t    /datatype\\s*=\\s*(\\w+)/i    and $alphabet = lc $1;\n\t    /interleave/i              and $interleave = 1 ;\n\t    last if /matrix/io;\n\t}\n    }\n    $self->throw(\"Not a valid NEXUS sequence file. Datatype not specified.\")\n\tunless $alphabet;\n    $self->throw(\"Not a valid NEXUS sequence file. Datatype should not be [$alphabet]\")\n\tunless $valid_type{$alphabet};\n    $self->throw(\"\\\"$gap\\\" is not a valid gap character. For compatability, gap char can not be one of: ()[]{}/\\,;:=*'`\\\"<>^\")\n    \tif $gap && $gap =~ /[\\(\\)\\[\\]\\{\\}\\/\\\\\\,\\;\\:\\=\\*\\'\\`\\<\\>\\^]/;\n    $self->throw(\"\\\"$missing\\\" is not a valid missing character. For compatability, missing char can not be one of: ()[]{}/\\,;:=*'`\\\"<>^\")\n    \tif $missing && $missing =~ /[\\(\\)\\[\\]\\{\\}\\/\\\\\\,\\;\\:\\=\\*\\'\\`\\<\\>\\^]/;\n\n    $aln->gap_char($gap);\n    $aln->missing_char($missing);\n\n    #\n    # if data is not right after the matrix line\n    #  read the empty lines out\n    #\n    while ($entry = $self->_readline) {\n\tunless ($entry =~ /^\\s+$/) {\n\t    $self->_pushback($entry);\n\t    last;\n\t}\n    }\n\n    #\n    # matrix command\n    #\n    # first alignment section\n    if (@names == 0) {\t\t# taxa block did not exist\n\twhile ($entry = $self->_readline) {\n\t\tlocal ($_) =  $entry;\n\t\tif( s/\\[[^\\]]+\\]//g ) { #]  remove comments\n\t\t\tnext if /^\\s*$/; \n\t\t\t# skip line if it is now empty or contains only whitespace\n\t\t}\n\t\tif ($interleave && defined$count && ($count <= $seqcount)) {\n\t\t\t/^\\s+$/ and last;\n\t\t} else {\n\t\t\t/^\\s+$/ and next;\n\t\t}\n\t\t/^\\s*;/ and last;\t# stop if colon at end of matrix is on it's own line\n\t\t#/^\\s*;\\s*$/ and last;\n\t\tif ( /^\\s*([\\\"\\'](.+?)[\\\"\\']|(\\S+))\\s+(.*)\\s*$/ ) {\t\n\t\t\t# get single and double quoted names, or all the first \n         # nonwhite word as the name, and remained is seq\n\t\t\t#if (/^\\s*('([^']*?)'|([^']\\S*))\\s+(.*)$/) { #'\n\t\t\t$name = ($2 || $3);\n\t\t\tif  ($4) {\n\t\t\t\t# seq is on same line as name\n\t\t\t\t# this is the usual NEXUS format\n\t\t\t\t$str = $4;\n\t\t\t} else {\n\t\t\t\t# otherwise get seq from following lines. No comments allowed\n\t\t\t\t# a less common matrix format, usually used for very long seqs\n\t\t\t\t$str='';\n\t\t\t\twhile (local ($_) = $self->_readline) {\n\t\t\t\t\tmy $str_tmp = $_;\n\t\t\t\t\t$str_tmp =~ s/[\\s;]//g;\n\t\t\t\t\t$str .= $str_tmp;\n\t\t\t\t\tlast if length$str == $residuecount;\n\t\t\t\t}\n\t\t\t}\n\t\t\t$name =~ s/ /_/g;\n\t\t\tpush @names, $name;\n\n\t\t\t$str =~ s/[\\s;]//g;\n\t\t\t$count =  @names;\n\t\t\t$hash{$count} = $str;\n\t\t}\n\t\t$self->throw(\"Not a valid interleaved NEXUS file! seqcount [$count] > predeclared [$seqcount] in the first section\") if $count > $seqcount;\n\t\t/;/ and last;\t# stop if colon at end of matrix is on the same line as the last seq\n\t}\n}\n\n    # interleaved sections\n    $count = 0;\n    if ( $interleave ) {\t# only read next section if file is interleaved\n\twhile( $entry = $self->_readline) {\n\t    local ($_) =  $entry;\n\t    if( s/\\[[^\\]]+\\]//g ) { #]  remove comments\n\t\tnext if /^\\s*$/; # skip line if it is now empty or contains only whitespace\n\t    }\n\t    /^\\s*;/ and last;\t\t# stop if colon at end of matrix is on it's own line\n\t    $count = 0, next if $entry =~ /^\\s*$/;\n\t    if (/^\\s*('([^']*?)'|([^']\\S*))\\s+(.*)$/) { #'\n\t\t$str = $4;\n\t\t$str =~ s/[\\s;]//g;\n\t\t$count++;\n\t\t$hash{$count} .= $str;\n\t    };\n\t    $self->throw(\"Not a valid interleaved NEXUS file!\n    \t\tseqcount [$count] > predeclared [$seqcount] \") if $count > $seqcount;\n\t    /;/ and last;\t# stop if colon at end of matrix is on the same line as the last seq\n\t}\n    }\n\n    return 0 if @names < 1;\n\n    # sequence creation\n    $count = 0;\n    foreach $name ( @names ) {\n\t$count++;\n\tif( $name =~ /(\\S+)\\/(\\d+)-(\\d+)/ ) {\n\t    $seqname = $1;\n\t    $start = $2;\n\t    $end = $3;\n\t} else {\n\t    $seqname=$name;\n\t    $start = 1;\n\t    $str = $hash{$count};\n\t    $str =~ s/[$Bio::LocatableSeq::GAP_SYMBOLS]//g;\n\t    $end = length($str);\n\t}\n\n\t# consistency test\n\t$self->throw(\"Length of sequence [$seqname] is not [$residuecount]; got\".CORE::length($hash{$count}))\n\t    unless CORE::length($hash{$count}) == $residuecount;\n\n\t$seq = Bio::LocatableSeq->new('-seq'=>$hash{$count},\n\t\t\t\t     '-id'=>$seqname,\n\t\t\t\t     '-start'=>$start,\n\t\t\t\t     '-end'=>$end,\n\t\t\t\t     'alphabet'=>$alphabet\n\t\t\t\t     );\n\t$aln->add_seq($seq);\n    }\n\n    # if matchchar is used\n    $aln->unmatch($match) if $match;\n\n    # if equate ( e.g. equate=\"T=C G=A\") is used\n    if ($equate) {\n\t$aln->map_chars($1, $2) while $equate =~ /(\\S)=(\\S)/g;\n    }\n\n    while  (defined $entry &&\n\t    $entry !~ /endblock/i) {\n        $entry = $self->_readline;\n    }\n\n    return $aln if $aln->num_sequences;\n\treturn;\n}\n\nsub _read_taxlabels {\n    my ($self) = @_;\n    my ($name, @names);\n    while (my $entry = $self->_readline) {\n\tlast if $entry =~ m/^\\s*(END)?;/i;\n\tif( $entry =~ m/\\s*(\\S+)\\s+/ ) {\n\t    ($name) = ($1);\n\t    $name =~ s/\\[[^\\[]+\\]//g;\n\t    $name =~ s/\\W/_/g;\n\t    push @names, $name;\n\t}\n    }\n    return @names;\n}\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: Writes the $aln object into the stream in interleaved NEXUS\n           format. Everything is written into a data block.\n           SimpleAlign methods match_char, missing_char and gap_char must be set\n           if you want to see them in the output.\n Returns : 1 for success and 0 for error\n Args    : L<Bio::Align::AlignI> object","parameters":[{"label":"$self"},{"label":"@aln"}]},"line":371,"kind":12,"range":{"start":{"line":371,"character":0},"end":{"line":454,"character":9999}}},{"children":[{"definition":"my","line":468,"name":"$self","kind":13,"localvar":"my","containerName":"flag"},{"containerName":"flag","kind":13,"name":"$name","line":468},{"containerName":"flag","kind":13,"name":"$val","line":468},{"line":469,"kind":13,"containerName":"flag","name":"$self"},{"name":"$name","kind":13,"containerName":"flag","line":469},{"containerName":"flag","kind":13,"name":"$val","line":469},{"line":469,"containerName":"flag","kind":13,"name":"$val"},{"line":470,"containerName":"flag","kind":13,"name":"$self"},{"kind":13,"containerName":"flag","name":"$name","line":470}],"name":"flag","containerName":"main::","definition":"sub","detail":"($self,$name,$val)","line":467,"range":{"start":{"character":0,"line":467},"end":{"character":9999,"line":471}},"kind":12,"signature":{"documentation":"1;\n# $Id: nexus.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::nexus\n#\n# Copyright Heikki Lehvaslaiho\n#\n\n=head1 NAME\n\nBio::AlignIO::nexus - NEXUS format sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the L<Bio::AlignIO> class.\n\n    use Bio::AlignIO;\n\n    my $in = Bio::AlignIO->new(-format => 'nexus',\n                              -file   => 'aln.nexus');\n    while( my $aln = $in->next_aln ) {\n        # do something with the alignment\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform L<Bio::Align::AlignI> objects to and from NEXUS\ndata blocks. See method documentation for supported NEXUS features.\n\n=head1 ACKNOWLEDGEMENTS\n\nWill Fisher has written an excellent standalone NEXUS format parser in\nPerl, readnexus. A number of tricks were adapted from it.\n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Heikki Lehvaslaiho\n\nEmail: heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::nexus;\nuse vars qw(%valid_type);\nuse strict;\nno strict \"refs\";\n\n\nuse base qw(Bio::AlignIO);\n\nBEGIN {\n    %valid_type = map {$_, 1} qw( dna rna protein standard );\n    # standard throws error: inherited from Bio::PrimarySeq\n}\n\n=head2 new\n\n Title   : new\n Usage   : $alignio = Bio::AlignIO->new(-format => 'nexus', -file => 'filename');\n Function: returns a new Bio::AlignIO object to handle clustalw files\n Returns : Bio::AlignIO::clustalw object\n Args    : -verbose => verbosity setting (-1,0,1,2)\n           -file    => name of file to read in or with \">\" - writeout\n           -fh      => alternative to -file param - provide a filehandle \n                       to read from/write to \n           -format  => type of Alignment Format to process or produce\n\n           Customization of nexus flavor output\n\n           -show_symbols => print the symbols=\"ATGC\" in the data definition\n                            (MrBayes does not like this)\n                            boolean [default is 1] \n           -show_endblock => print an 'endblock;' at the end of the data\n                            (MyBayes does not like this)\n                            boolean [default is 1] \n\n\nsub _initialize {\n    my ($self, @args) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($show_symbols, $endblock) = \n\t$self->_rearrange([qw(SHOW_SYMBOLS SHOW_ENDBLOCK)], @args);\n    my @names = qw(symbols endblock);\n    for my $v ( $show_symbols, $endblock ) {\n\t$v = 1 unless defined $v; # default value is 1\n\tmy $n = shift @names;\n\t$self->flag($n, $v);\n    }\n}\n\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: Returns the next alignment in the stream.\n\n           Supports the following NEXUS format features:\n           - The file has to start with '#NEXUS'\n           - Reads in the name of the alignment from a comment\n             (anything after 'TITLE: ') .\n           - Sequence names can be given in a taxa block, too.\n           - If matchchar notation is used, converts\n             them back to sequence characters.\n           - Does character conversions specified in the\n             NEXUS equate command.\n           - Sequence names of type 'Homo sapiens' and\n             Homo_sapiens are treated identically.\n\n Returns : L<Bio::Align::AlignI> object\n Args    :\n\n\n\n\nsub next_aln {\n    my $self = shift;\n    my $entry;\n    my ($aln_name, $seqcount, $residuecount, %hash, $alphabet,\n\t$match, $gap, $missing, $equate, $interleave,\n\t$name,$str,@names,$seqname,$start,$end,$count,$seq);\n    local $Bio::LocatableSeq::OTHER_SYMBOLS = '\\*\\?\\.';\n    local $Bio::LocatableSeq::GAP_SYMBOLS = '\\-';\n    my $aln =  Bio::SimpleAlign->new(-source => 'nexus');\n\n    # file starts with '#NEXUS' but we allow white space only lines before it\n    $entry = $self->_readline;\n    $entry = $self->_readline while defined $entry && $entry =~ /^\\s+$/;\n\n    return unless $entry;\n    $self->throw(\"Not a valid interleaved NEXUS file! [#NEXUS] not starting the file\\n$entry\")\n\tunless ($entry && $entry =~ /^#NEXUS/i);\n\n    # skip anything before either the taxa or data block\n    # but read in the optional title in a comment\n    while (defined($entry = $self->_readline)) {\n\tlocal ($_) = $entry;\n\t/\\[TITLE. *([^\\]]+)]\\s+/i and $aln_name = $1;\n\tlast if /^begin +data/i || /^begin +taxa/i;\n    }\n    $aln_name =~ s/\\s/_/g and $aln->id($aln_name) if $aln_name;\n\n    # data and taxa blocks\n    my $incomment;\n    while (defined ($entry = $self->_readline)) {\n\tlocal ($_) =  $entry;\n\tnext if s/\\[[^\\]]+\\]//g; # remove comments\n\tif( s/\\[[^\\]]+$// ) {\n\t    $incomment = 1;\n\t\t # skip line if it is now empty or contains only whitespace\n\t    next if /^\\s*$/;\n\t} elsif($incomment) {\n\t    if( s/^[^\\]]*\\]// ) {\n\t\t\t $incomment = 0;\n\t    } else {\n\t\t\t next;\n\t    }\n\t} elsif( /taxlabels/i ) {\n\t    # doesn't deal with taxlabels adequately and can mess things up!\n\t    # @names = $self->_read_taxlabels;\n\t} else {\n\n\t    /ntax\\s*=\\s*(\\d+)/i        and $seqcount = $1;\n\t    /nchar\\s*=\\s*(\\d+)/i       and $residuecount = $1;\n\t    /matchchar\\s*=\\s*(.)/i     and $match = $1;\n\t    /gap\\s*=\\s*(.)/i           and $gap = $1;\n\t    /missing\\s*=\\s*(.)/i       and $missing = $1;\n\t    /equate\\s*=\\s*\\\"([^\\\"]+)/i and $equate = $1;  # \"e.g. equate=\"T=C G=A\";\n\t    /datatype\\s*=\\s*(\\w+)/i    and $alphabet = lc $1;\n\t    /interleave/i              and $interleave = 1 ;\n\t    last if /matrix/io;\n\t}\n    }\n    $self->throw(\"Not a valid NEXUS sequence file. Datatype not specified.\")\n\tunless $alphabet;\n    $self->throw(\"Not a valid NEXUS sequence file. Datatype should not be [$alphabet]\")\n\tunless $valid_type{$alphabet};\n    $self->throw(\"\\\"$gap\\\" is not a valid gap character. For compatability, gap char can not be one of: ()[]{}/\\,;:=*'`\\\"<>^\")\n    \tif $gap && $gap =~ /[\\(\\)\\[\\]\\{\\}\\/\\\\\\,\\;\\:\\=\\*\\'\\`\\<\\>\\^]/;\n    $self->throw(\"\\\"$missing\\\" is not a valid missing character. For compatability, missing char can not be one of: ()[]{}/\\,;:=*'`\\\"<>^\")\n    \tif $missing && $missing =~ /[\\(\\)\\[\\]\\{\\}\\/\\\\\\,\\;\\:\\=\\*\\'\\`\\<\\>\\^]/;\n\n    $aln->gap_char($gap);\n    $aln->missing_char($missing);\n\n    #\n    # if data is not right after the matrix line\n    #  read the empty lines out\n    #\n    while ($entry = $self->_readline) {\n\tunless ($entry =~ /^\\s+$/) {\n\t    $self->_pushback($entry);\n\t    last;\n\t}\n    }\n\n    #\n    # matrix command\n    #\n    # first alignment section\n    if (@names == 0) {\t\t# taxa block did not exist\n\twhile ($entry = $self->_readline) {\n\t\tlocal ($_) =  $entry;\n\t\tif( s/\\[[^\\]]+\\]//g ) { #]  remove comments\n\t\t\tnext if /^\\s*$/; \n\t\t\t# skip line if it is now empty or contains only whitespace\n\t\t}\n\t\tif ($interleave && defined$count && ($count <= $seqcount)) {\n\t\t\t/^\\s+$/ and last;\n\t\t} else {\n\t\t\t/^\\s+$/ and next;\n\t\t}\n\t\t/^\\s*;/ and last;\t# stop if colon at end of matrix is on it's own line\n\t\t#/^\\s*;\\s*$/ and last;\n\t\tif ( /^\\s*([\\\"\\'](.+?)[\\\"\\']|(\\S+))\\s+(.*)\\s*$/ ) {\t\n\t\t\t# get single and double quoted names, or all the first \n         # nonwhite word as the name, and remained is seq\n\t\t\t#if (/^\\s*('([^']*?)'|([^']\\S*))\\s+(.*)$/) { #'\n\t\t\t$name = ($2 || $3);\n\t\t\tif  ($4) {\n\t\t\t\t# seq is on same line as name\n\t\t\t\t# this is the usual NEXUS format\n\t\t\t\t$str = $4;\n\t\t\t} else {\n\t\t\t\t# otherwise get seq from following lines. No comments allowed\n\t\t\t\t# a less common matrix format, usually used for very long seqs\n\t\t\t\t$str='';\n\t\t\t\twhile (local ($_) = $self->_readline) {\n\t\t\t\t\tmy $str_tmp = $_;\n\t\t\t\t\t$str_tmp =~ s/[\\s;]//g;\n\t\t\t\t\t$str .= $str_tmp;\n\t\t\t\t\tlast if length$str == $residuecount;\n\t\t\t\t}\n\t\t\t}\n\t\t\t$name =~ s/ /_/g;\n\t\t\tpush @names, $name;\n\n\t\t\t$str =~ s/[\\s;]//g;\n\t\t\t$count =  @names;\n\t\t\t$hash{$count} = $str;\n\t\t}\n\t\t$self->throw(\"Not a valid interleaved NEXUS file! seqcount [$count] > predeclared [$seqcount] in the first section\") if $count > $seqcount;\n\t\t/;/ and last;\t# stop if colon at end of matrix is on the same line as the last seq\n\t}\n}\n\n    # interleaved sections\n    $count = 0;\n    if ( $interleave ) {\t# only read next section if file is interleaved\n\twhile( $entry = $self->_readline) {\n\t    local ($_) =  $entry;\n\t    if( s/\\[[^\\]]+\\]//g ) { #]  remove comments\n\t\tnext if /^\\s*$/; # skip line if it is now empty or contains only whitespace\n\t    }\n\t    /^\\s*;/ and last;\t\t# stop if colon at end of matrix is on it's own line\n\t    $count = 0, next if $entry =~ /^\\s*$/;\n\t    if (/^\\s*('([^']*?)'|([^']\\S*))\\s+(.*)$/) { #'\n\t\t$str = $4;\n\t\t$str =~ s/[\\s;]//g;\n\t\t$count++;\n\t\t$hash{$count} .= $str;\n\t    };\n\t    $self->throw(\"Not a valid interleaved NEXUS file!\n    \t\tseqcount [$count] > predeclared [$seqcount] \") if $count > $seqcount;\n\t    /;/ and last;\t# stop if colon at end of matrix is on the same line as the last seq\n\t}\n    }\n\n    return 0 if @names < 1;\n\n    # sequence creation\n    $count = 0;\n    foreach $name ( @names ) {\n\t$count++;\n\tif( $name =~ /(\\S+)\\/(\\d+)-(\\d+)/ ) {\n\t    $seqname = $1;\n\t    $start = $2;\n\t    $end = $3;\n\t} else {\n\t    $seqname=$name;\n\t    $start = 1;\n\t    $str = $hash{$count};\n\t    $str =~ s/[$Bio::LocatableSeq::GAP_SYMBOLS]//g;\n\t    $end = length($str);\n\t}\n\n\t# consistency test\n\t$self->throw(\"Length of sequence [$seqname] is not [$residuecount]; got\".CORE::length($hash{$count}))\n\t    unless CORE::length($hash{$count}) == $residuecount;\n\n\t$seq = Bio::LocatableSeq->new('-seq'=>$hash{$count},\n\t\t\t\t     '-id'=>$seqname,\n\t\t\t\t     '-start'=>$start,\n\t\t\t\t     '-end'=>$end,\n\t\t\t\t     'alphabet'=>$alphabet\n\t\t\t\t     );\n\t$aln->add_seq($seq);\n    }\n\n    # if matchchar is used\n    $aln->unmatch($match) if $match;\n\n    # if equate ( e.g. equate=\"T=C G=A\") is used\n    if ($equate) {\n\t$aln->map_chars($1, $2) while $equate =~ /(\\S)=(\\S)/g;\n    }\n\n    while  (defined $entry &&\n\t    $entry !~ /endblock/i) {\n        $entry = $self->_readline;\n    }\n\n    return $aln if $aln->num_sequences;\n\treturn;\n}\n\nsub _read_taxlabels {\n    my ($self) = @_;\n    my ($name, @names);\n    while (my $entry = $self->_readline) {\n\tlast if $entry =~ m/^\\s*(END)?;/i;\n\tif( $entry =~ m/\\s*(\\S+)\\s+/ ) {\n\t    ($name) = ($1);\n\t    $name =~ s/\\[[^\\[]+\\]//g;\n\t    $name =~ s/\\W/_/g;\n\t    push @names, $name;\n\t}\n    }\n    return @names;\n}\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: Writes the $aln object into the stream in interleaved NEXUS\n           format. Everything is written into a data block.\n           SimpleAlign methods match_char, missing_char and gap_char must be set\n           if you want to see them in the output.\n Returns : 1 for success and 0 for error\n Args    : L<Bio::Align::AlignI> object\n\n\nsub write_aln {\n    my ($self,@aln) = @_;\n    my $count = 0;\n    my $wrapped = 0;\n    my $maxname;\n    my ($length,$date,$name,$seq,$miss,$pad,%hash,@arr,$tempcount,$index );\n    my ($match, $missing, $gap,$symbols) = ('', '', '','');\n\n    foreach my $aln (@aln) {\n\tif( ! $aln || ! $aln->isa('Bio::Align::AlignI')  ) {\n\t    $self->warn(\"Must provide a Bio::Align::AlignI object when calling write_aln\");\n\t    next;\n\t}\n\t$self->throw(\"All sequences in the alignment must be the same length\")\n\t    unless $aln->is_flush($self->verbose);\n\n\t$length  = $aln->length();\n\n\t$self->_print (sprintf(\"#NEXUS\\n[TITLE: %s]\\n\\nbegin data;\\ndimensions ntax=%s nchar=%s;\\n\",\n\t\t\t       $aln->id, $aln->num_sequences, $length));\n\t$match = \"match=\". $aln->match_char if $aln->match_char;\n\t$missing = \"missing=\". $aln->missing_char if $aln->missing_char;\n\t$gap = \"gap=\". $aln->gap_char if $aln->gap_char;\n\n\t$symbols = 'symbols=\"'.join('',$aln->symbol_chars). '\"' \n\t    if( $self->flag('symbols') && $aln->symbol_chars);\n\t$self->_print \n\t    (sprintf(\"format interleave datatype=%s %s %s %s %s;\\n\\nmatrix\\n\",\n\t\t     $aln->get_seq_by_pos(1)->alphabet, $match, \n\t\t     $missing, $gap, $symbols));\n\n                     # account for single quotes round names\n\tmy $indent = $aln->maxdisplayname_length+2;\n\n\t$aln->set_displayname_flat();\n\tforeach $seq ( $aln->each_seq() ) {\n\t    my $nmid = $aln->displayname($seq->get_nse());\n\t    if( $nmid =~ /[^\\w\\d\\.]/ ) {\n              # put name in single quotes incase it contains any of\n              # the following chars: ()[]{}/\\,;:=*'\"`+-<> that are not\n              # allowed in PAUP* and possible other software\n\n\t\t$name = sprintf(\"%-${indent}s\", \"\\'\" . $nmid . \"\\'\");\n\t    } else { \n\t\t$name = sprintf(\"%-${indent}s\", $nmid);\n\t    }\n\t    $hash{$name} = $seq->seq;\n\t    push(@arr,$name);\n\t}\n\n\twhile( $count < $length ) {\n\t    # there is another block to go!\n\t    foreach $name ( @arr ) {\n\t\tmy $dispname = $name;\n#\t\t $dispname = '' if $wrapped;\n\t\t$self->_print (sprintf(\"%${indent}s  \",$dispname));\n\t\t$tempcount = $count;\n\t\t$index = 0;\n\t\twhile( ($tempcount + 10 < $length) && ($index < 5)  ) {\n\t\t    $self->_print (sprintf(\"%s \",substr($hash{$name},$tempcount,10)));\n\t\t    $tempcount += 10;\n\t\t    $index++;\n\t\t}\n\t\t# last\n\t\tif( $index < 5) {\n\t\t    # space to print!\n\t\t    $self->_print (sprintf(\"%s \",substr($hash{$name},$tempcount)));\n\t\t    $tempcount += 10;\n\t\t}\n\t\t$self->_print (\"\\n\");\n\t    }\n\t    $self->_print (\"\\n\\n\");\n\t    $count = $tempcount;\n\t    $wrapped = 1;\n\t}\n\tif( $self->flag('endblock') ) {\n\t    $self->_print (\";\\n\\nendblock;\\n\");\n\t} else { \n\t    $self->_print (\";\\n\\nend;\\n\");\n\t}\n    }\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n    return 1;\n}\n\n=head2 flag\n\n Title   : flag\n Usage   : $obj->flag($name,$value)\n Function: Get/Set a flag value\n Returns : value of flag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)","parameters":[{"label":"$self"},{"label":"$name"},{"label":"$val"}],"label":"flag($self,$name,$val)"}}]}