{"version":5,"vars":[{"name":"base","kind":2,"containerName":"","line":77},{"range":{"start":{"line":80,"character":0},"end":{"character":9999,"line":88}},"kind":12,"line":80,"signature":{"label":"_initialize($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":""},"containerName":"main::","name":"_initialize","children":[{"line":81,"kind":13,"localvar":"my","containerName":"_initialize","name":"$self","definition":"my"},{"kind":13,"containerName":"_initialize","name":"@args","line":81},{"line":82,"name":"$self","kind":13,"containerName":"_initialize"},{"line":82,"name":"@args","containerName":"_initialize","kind":13},{"kind":13,"containerName":"_initialize","name":"$self","line":83},{"line":83,"name":"sequence_factory","kind":12,"containerName":"_initialize"},{"name":"$self","containerName":"_initialize","kind":13,"line":84},{"line":84,"kind":12,"containerName":"_initialize","name":"sequence_factory"},{"name":"new","containerName":"_initialize","kind":12,"line":85},{"kind":13,"containerName":"_initialize","name":"$self","line":85},{"name":"verbose","kind":12,"containerName":"_initialize","line":85}],"detail":"($self,@args)","definition":"sub"},{"containerName":"_initialize","kind":12,"name":"SUPER","line":82},{"line":84,"kind":12,"containerName":"Seq::SeqFactory","name":"Bio"},{"detail":"($self)","definition":"sub","containerName":"main::","name":"next_seq","children":[{"line":102,"localvar":"my","containerName":"next_seq","kind":13,"name":"$self","definition":"my"},{"definition":"my","localvar":"my","kind":13,"containerName":"next_seq","name":"$largeseq","line":103},{"kind":13,"containerName":"next_seq","name":"$self","line":103},{"name":"sequence_factory","containerName":"next_seq","kind":12,"line":103},{"name":"create","kind":12,"containerName":"next_seq","line":103},{"definition":"my","line":104,"name":"$id","localvar":"my","containerName":"next_seq","kind":13},{"line":104,"containerName":"next_seq","kind":13,"name":"$fulldesc"},{"line":104,"containerName":"next_seq","kind":13,"name":"$entry"},{"definition":"my","line":105,"name":"$count","containerName":"next_seq","localvar":"my","kind":13},{"definition":"my","containerName":"next_seq","localvar":"my","kind":13,"name":"$seen","line":106},{"line":107,"containerName":"next_seq","kind":13,"name":"$entry"},{"line":107,"kind":13,"containerName":"next_seq","name":"$self"},{"name":"_readline","containerName":"next_seq","kind":12,"line":107},{"containerName":"next_seq","kind":13,"name":"$seen","line":108},{"name":"$entry","kind":13,"containerName":"next_seq","line":108},{"line":109,"kind":13,"containerName":"next_seq","name":"$self"},{"line":109,"containerName":"next_seq","kind":12,"name":"_pushback"},{"line":109,"containerName":"next_seq","kind":13,"name":"$entry"},{"name":"$largeseq","containerName":"next_seq","kind":13,"line":110},{"line":112,"kind":13,"containerName":"next_seq","name":"$entry"},{"line":112,"kind":13,"containerName":"next_seq","name":"$seen"},{"line":113,"name":"$entry","containerName":"next_seq","kind":13},{"line":114,"kind":13,"containerName":"next_seq","name":"$seen"},{"name":"$id","kind":13,"containerName":"next_seq","line":115},{"line":115,"name":"$fulldesc","containerName":"next_seq","kind":13},{"line":116,"kind":13,"containerName":"next_seq","name":"$self"},{"name":"warn","kind":12,"containerName":"next_seq","line":116},{"line":117,"containerName":"next_seq","kind":13,"name":"$largeseq"},{"line":117,"name":"display_id","containerName":"next_seq","kind":12},{"line":117,"name":"$id","containerName":"next_seq","kind":13},{"line":118,"name":"$largeseq","kind":13,"containerName":"next_seq"},{"line":118,"name":"primary_id","containerName":"next_seq","kind":12},{"line":118,"name":"$id","kind":13,"containerName":"next_seq"},{"containerName":"next_seq","kind":13,"name":"$largeseq","line":119},{"name":"desc","containerName":"next_seq","kind":12,"line":119},{"line":119,"kind":13,"containerName":"next_seq","name":"$fulldesc"},{"name":"$entry","containerName":"next_seq","kind":13,"line":121},{"line":122,"name":"$largeseq","kind":13,"containerName":"next_seq"},{"containerName":"next_seq","kind":12,"name":"add_sequence_as_string","line":122},{"kind":13,"containerName":"next_seq","name":"$entry","line":122},{"line":124,"kind":13,"containerName":"next_seq","name":"$count"},{"name":"$self","kind":13,"containerName":"next_seq","line":124},{"kind":12,"containerName":"next_seq","name":"verbose","line":124},{"line":126,"kind":13,"containerName":"next_seq","name":"$seen"},{"line":127,"kind":13,"containerName":"next_seq","name":"$largeseq"}],"signature":{"documentation":"1;\n#\n# BioPerl module for Bio::AlignIO::largemultifasta\n\n#   based on the Bio::SeqIO::largefasta module\n#       by Ewan Birney <birney@ebi.ac.uk>\n#       and Lincoln Stein  <lstein@cshl.org>\n#\n#       and the SimpleAlign.pm module of Ewan Birney\n#\n# Copyright Albert Vilella\n#\n# You may distribute this module under the same terms as perl itself\n# _history\n# January 20, 2004\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::largemultifasta - Largemultifasta MSA Sequence\ninput/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the L<Bio::AlignIO> class.\n\n=head1 DESCRIPTION\n\nThis object can transform L<Bio::SimpleAlign> objects to and from\nlargemultifasta flat file databases.  This is for the fasta sequence\nformat NOT FastA analysis program.  To process the pairwise alignments\nfrom a FastA (FastX, FastN, FastP, tFastA, etc) use the Bio::SearchIO\nmodule.\n\nReimplementation of Bio::AlignIO::fasta modules so that creates\ntemporary files instead of keeping the whole sequences in memory.\n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Albert Vilella, Heikki Lehvaslaiho\n\nEmail: avilella-at-gmail-dot-com, heikki-at-bioperl-dot-org\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::largemultifasta;\nuse strict;\n\nuse Bio::Seq::LargeLocatableSeq;\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::AlignIO Bio::SeqIO Bio::SimpleAlign);\n\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n\t\t\t      (-verbose => $self->verbose(),\n\t\t\t       -type => 'Bio::Seq::LargeLocatableSeq'));\n  }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream while taking care\n           of the length\n Returns : Bio::Seq object\n Args    : NONE","parameters":[{"label":"$self"}],"label":"next_seq($self)"},"range":{"end":{"character":9999,"line":128},"start":{"character":0,"line":101}},"kind":12,"line":101},{"children":[{"definition":"my","line":143,"containerName":"next_aln","localvar":"my","kind":13,"name":"$self"},{"name":"$largeseq","localvar":"my","kind":13,"containerName":"next_aln","line":144,"definition":"my"},{"definition":"my","name":"$aln","localvar":"my","containerName":"next_aln","kind":13,"line":145},{"line":145,"name":"new","containerName":"next_aln","kind":12},{"line":146,"containerName":"next_aln","kind":13,"name":"$largeseq"},{"line":146,"name":"$self","kind":13,"containerName":"next_aln"},{"name":"next_seq","kind":12,"containerName":"next_aln","line":146},{"name":"$aln","containerName":"next_aln","kind":13,"line":147},{"kind":12,"containerName":"next_aln","name":"add_seq","line":147},{"kind":13,"containerName":"next_aln","name":"$largeseq","line":147},{"kind":13,"containerName":"next_aln","name":"$self","line":148},{"name":"debug","containerName":"next_aln","kind":12,"line":148},{"name":"$alnlen","localvar":"my","kind":13,"containerName":"next_aln","line":151,"definition":"my"},{"name":"$aln","kind":13,"containerName":"next_aln","line":151},{"line":151,"name":"length","containerName":"next_aln","kind":12},{"line":152,"localvar":"my","containerName":"next_aln","kind":13,"name":"$largeseq","definition":"my"},{"line":152,"name":"$aln","containerName":"next_aln","kind":13},{"line":152,"containerName":"next_aln","kind":12,"name":"each_seq"},{"line":153,"kind":13,"containerName":"next_aln","name":"$largeseq"},{"containerName":"next_aln","kind":12,"name":"length","line":153},{"kind":13,"containerName":"next_aln","name":"$alnlen","line":153},{"line":154,"name":"$diff","containerName":"next_aln","localvar":"my","kind":13,"definition":"my"},{"name":"$alnlen","containerName":"next_aln","kind":13,"line":154},{"containerName":"next_aln","kind":13,"name":"$largeseq","line":154},{"name":"length","kind":12,"containerName":"next_aln","line":154},{"line":155,"kind":13,"containerName":"next_aln","name":"$largeseq"},{"line":155,"containerName":"next_aln","kind":12,"name":"seq"},{"name":"$diff","containerName":"next_aln","kind":13,"line":155},{"line":159,"name":"$aln","containerName":"next_aln","kind":13},{"kind":13,"containerName":"next_aln","name":"$aln","line":159},{"line":159,"kind":12,"containerName":"next_aln","name":"num_sequences"}],"containerName":"main::","name":"next_aln","definition":"sub","line":142,"range":{"start":{"character":0,"line":142},"end":{"character":9999,"line":162}},"kind":12},{"kind":12,"containerName":"SimpleAlign","name":"Bio","line":145},{"children":[{"definition":"my","line":176,"name":"$self","localvar":"my","kind":13,"containerName":"write_aln"},{"name":"@aln","containerName":"write_aln","kind":13,"line":176},{"line":177,"name":"$seq","localvar":"my","containerName":"write_aln","kind":13,"definition":"my"},{"line":177,"kind":13,"containerName":"write_aln","name":"$desc"},{"line":177,"containerName":"write_aln","kind":13,"name":"$rseq"},{"line":177,"name":"$name","kind":13,"containerName":"write_aln"},{"line":177,"containerName":"write_aln","kind":13,"name":"$count"},{"line":177,"kind":13,"containerName":"write_aln","name":"$length"},{"line":177,"kind":13,"containerName":"write_aln","name":"$seqsub"},{"line":179,"name":"$aln","kind":13,"localvar":"my","containerName":"write_aln","definition":"my"},{"line":179,"name":"@aln","kind":13,"containerName":"write_aln"},{"kind":13,"containerName":"write_aln","name":"$aln","line":180},{"line":180,"name":"$aln","containerName":"write_aln","kind":13},{"name":"isa","containerName":"write_aln","kind":12,"line":180},{"line":181,"name":"$self","containerName":"write_aln","kind":13},{"line":181,"kind":12,"containerName":"write_aln","name":"warn"},{"kind":13,"containerName":"write_aln","name":"$rseq","line":184},{"containerName":"write_aln","kind":13,"name":"$aln","line":184},{"name":"each_seq","containerName":"write_aln","kind":12,"line":184},{"line":185,"name":"$name","containerName":"write_aln","kind":13},{"name":"$aln","kind":13,"containerName":"write_aln","line":185},{"name":"displayname","kind":12,"containerName":"write_aln","line":185},{"line":185,"name":"$rseq","containerName":"write_aln","kind":13},{"line":185,"containerName":"write_aln","kind":12,"name":"get_nse"},{"line":186,"name":"$seq","kind":13,"containerName":"write_aln"},{"line":186,"name":"$rseq","containerName":"write_aln","kind":13},{"line":186,"name":"seq","kind":12,"containerName":"write_aln"},{"line":187,"name":"$desc","containerName":"write_aln","kind":13},{"kind":13,"containerName":"write_aln","name":"$rseq","line":187},{"line":187,"kind":12,"containerName":"write_aln","name":"description"},{"containerName":"write_aln","kind":13,"name":"$self","line":188},{"line":188,"kind":12,"containerName":"write_aln","name":"_print"},{"line":189,"kind":13,"containerName":"write_aln","name":"$count"},{"line":190,"name":"$length","containerName":"write_aln","kind":13},{"line":190,"containerName":"write_aln","kind":13,"name":"$seq"},{"name":"$count","kind":13,"containerName":"write_aln","line":191},{"kind":13,"containerName":"write_aln","name":"$length","line":191},{"containerName":"write_aln","kind":13,"name":"$seqsub","line":192},{"kind":13,"containerName":"write_aln","name":"$seq","line":192},{"kind":13,"containerName":"write_aln","name":"$count","line":192},{"name":"$self","containerName":"write_aln","kind":13,"line":193},{"name":"_print","containerName":"write_aln","kind":12,"line":193},{"line":194,"kind":13,"containerName":"write_aln","name":"$count"},{"name":"$self","containerName":"write_aln","kind":13,"line":198},{"line":198,"containerName":"write_aln","kind":12,"name":"flush"},{"kind":13,"containerName":"write_aln","name":"$self","line":198},{"line":198,"name":"_flush_on_write","kind":12,"containerName":"write_aln"},{"line":198,"name":"$self","containerName":"write_aln","kind":13},{"line":198,"name":"_fh","containerName":"write_aln","kind":12}],"containerName":"main::","name":"write_aln","definition":"sub","detail":"($self,@aln)","line":175,"kind":12,"range":{"start":{"character":0,"line":175},"end":{"character":9999,"line":200}},"signature":{"documentation":"1;\n#\n# BioPerl module for Bio::AlignIO::largemultifasta\n\n#   based on the Bio::SeqIO::largefasta module\n#       by Ewan Birney <birney@ebi.ac.uk>\n#       and Lincoln Stein  <lstein@cshl.org>\n#\n#       and the SimpleAlign.pm module of Ewan Birney\n#\n# Copyright Albert Vilella\n#\n# You may distribute this module under the same terms as perl itself\n# _history\n# January 20, 2004\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::largemultifasta - Largemultifasta MSA Sequence\ninput/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the L<Bio::AlignIO> class.\n\n=head1 DESCRIPTION\n\nThis object can transform L<Bio::SimpleAlign> objects to and from\nlargemultifasta flat file databases.  This is for the fasta sequence\nformat NOT FastA analysis program.  To process the pairwise alignments\nfrom a FastA (FastX, FastN, FastP, tFastA, etc) use the Bio::SearchIO\nmodule.\n\nReimplementation of Bio::AlignIO::fasta modules so that creates\ntemporary files instead of keeping the whole sequences in memory.\n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Albert Vilella, Heikki Lehvaslaiho\n\nEmail: avilella-at-gmail-dot-com, heikki-at-bioperl-dot-org\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::largemultifasta;\nuse strict;\n\nuse Bio::Seq::LargeLocatableSeq;\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::AlignIO Bio::SeqIO Bio::SimpleAlign);\n\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n\t\t\t      (-verbose => $self->verbose(),\n\t\t\t       -type => 'Bio::Seq::LargeLocatableSeq'));\n  }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream while taking care\n           of the length\n Returns : Bio::Seq object\n Args    : NONE\n\n\nsub next_seq {\n    my ($self) = @_;\n    my $largeseq = $self->sequence_factory->create();\n    my ($id,$fulldesc,$entry);\n    my $count = 0;\n    my $seen = 0;\n    while( defined ($entry = $self->_readline) ) {\n\tif( $seen == 1 && $entry =~ /^\\s*>/ ) {\n\t    $self->_pushback($entry);\n\t    return $largeseq;\n\t}\n\tif ( ($entry eq '>')  ) { $seen = 1; next; }\n\telsif( $entry =~ /\\s*>(.+?)$/ ) {\n\t    $seen = 1;\n\t    ($id,$fulldesc) = ($1 =~ /^\\s*(\\S+)\\s*(.*)$/)\n\t\tor $self->warn(\"Can't parse fasta header\");\n\t    $largeseq->display_id($id);\n\t    $largeseq->primary_id($id);\n\t    $largeseq->desc($fulldesc);\n\t} else {\n\t    $entry =~ s/\\s+//g;\n\t    $largeseq->add_sequence_as_string($entry);\n\t}\n\t(++$count % 1000 == 0 && $self->verbose() > 0) && print \"line $count\\n\";\n    }\n    if( ! $seen ) { return; }\n    return $largeseq;\n}\n\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream.\n Returns : L<Bio::Align::AlignI> object - returns 0 on end of file\n\t    or on error\n Args    : NONE\n\n\nsub next_aln {\n    my $self = shift;\n    my $largeseq;\n    my $aln =  Bio::SimpleAlign->new();\n    while (defined ($largeseq = $self->next_seq) ) {\n        $aln->add_seq($largeseq);\n        $self->debug(\"sequence readed\\n\");\n    }\n\n    my $alnlen = $aln->length;\n    foreach my $largeseq ( $aln->each_seq ) {\n\tif( $largeseq->length < $alnlen ) {\n\t    my ($diff) = ($alnlen - $largeseq->length);\n\t    $largeseq->seq(\"-\" x $diff);\n\t}\n    }\n\n    return $aln if $aln->num_sequences;\n\treturn;\n\n}\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the $aln object into the stream in largemultifasta format\n Returns : 1 for success and 0 for error\n Args    : L<Bio::Align::AlignI> object","parameters":[{"label":"$self"},{"label":"@aln"}],"label":"write_aln($self,@aln)"}}]}