{"vars":[{"kind":2,"line":94,"name":"base","containerName":""},{"children":[{"localvar":"my","name":"$class","definition":"my","containerName":"new","line":97,"kind":13},{"line":97,"kind":13,"containerName":"new","name":"@args"},{"line":98,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"new"},{"line":98,"kind":13,"containerName":"new","name":"$class"},{"name":"@args","containerName":"new","line":98,"kind":13},{"localvar":"my","containerName":"new","definition":"my","name":"$is_reference","line":100,"kind":13},{"kind":13,"line":100,"name":"$repeat_unit","containerName":"new"},{"name":"$repeat_count","containerName":"new","kind":13,"line":100},{"name":"$self","containerName":"new","line":101,"kind":13},{"containerName":"new","name":"_rearrange","kind":12,"line":101},{"name":"@args","containerName":"new","kind":13,"line":105},{"name":"$is_reference","containerName":"new","kind":13,"line":107},{"kind":13,"line":107,"containerName":"new","name":"$self"},{"name":"is_reference","containerName":"new","line":107,"kind":12},{"kind":13,"line":107,"name":"$is_reference","containerName":"new"},{"line":108,"kind":13,"containerName":"new","name":"$repeat_unit"},{"containerName":"new","name":"$self","line":108,"kind":13},{"line":108,"kind":12,"containerName":"new","name":"repeat_unit"},{"line":108,"kind":13,"containerName":"new","name":"$repeat_unit"},{"containerName":"new","name":"$repeat_count","line":109,"kind":13},{"line":109,"kind":13,"name":"$self","containerName":"new"},{"kind":12,"line":109,"name":"repeat_count","containerName":"new"},{"name":"$repeat_count","containerName":"new","kind":13,"line":109},{"kind":13,"line":111,"name":"$self","containerName":"new"}],"line":96,"kind":12,"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"","label":"new($class,@args)"},"detail":"($class,@args)","definition":"sub","containerName":"main::","range":{"start":{"line":96,"character":0},"end":{"line":112,"character":9999}},"name":"new"},{"kind":12,"line":98,"name":"SUPER","containerName":"new"},{"line":129,"children":[{"kind":13,"line":130,"containerName":"is_reference","definition":"my","name":"$self","localvar":"my"},{"containerName":"is_reference","name":"$value","kind":13,"line":130},{"line":131,"kind":13,"name":"$value","containerName":"is_reference"},{"kind":13,"line":132,"name":"$value","containerName":"is_reference"},{"line":132,"kind":13,"name":"$value","containerName":"is_reference"},{"line":132,"kind":13,"name":"$value","containerName":"is_reference"},{"line":133,"kind":13,"name":"$self","containerName":"is_reference"},{"name":"$value","containerName":"is_reference","kind":13,"line":133},{"kind":13,"line":135,"containerName":"is_reference","name":"$self"},{"kind":13,"line":139,"name":"$self","containerName":"is_reference"}],"kind":12,"detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: Allele.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::Allele\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::Allele - Sequence object with allele-specific attributes\n\n=head1 SYNOPSIS\n\n  $allele1 = Bio::Variation::Allele->new ( -seq => 'A',\n                                           -id  => 'AC00001.1',\n                                           -alphabet => 'dna',\n                                           -is_reference => 1\n                                         );\n\n=head1 DESCRIPTION\n\nList of alleles describe known sequence alternatives in a variable region.\nAlleles are contained in Bio::Variation::VariantI complying objects.\nSee L<Bio::Variation::VariantI> for details.\n\nBio::Varation::Alleles are PrimarySeqI complying objects which can\ncontain database cross references as specified in\nBio::DBLinkContainerI interface, too.\n\nA lot of the complexity with dealing with Allele objects are caused by\nnull alleles; Allele objects that have zero length sequence string.\n\nIn addition describing the allele by its sequence , it possible to\ngive describe repeat structure within the sequence. This done using\nmethods repeat_unit (e.g. 'ca') and repeat_count (e.g. 7).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Variation::Allele;\n\nuse strict;\n\n# Object preamble - inheritance\n\n\nuse base qw(Bio::PrimarySeq Bio::DBLinkContainerI);\n\nsub new {\n    my($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($is_reference, $repeat_unit, $repeat_count) =\n\t   $self->_rearrange([qw(IS_REFERENCE\n\t\t\t\t REPEAT_UNIT\n\t\t\t\t REPEAT_COUNT\n\t\t\t\t )],\n\t\t\t     @args);\n\n    $is_reference && $self->is_reference($is_reference);\n    $repeat_unit && $self->repeat_unit($repeat_unit);\n    $repeat_count && $self->repeat_count($repeat_count);\n\n    return $self; # success - we hope!\n}\n\n\n=head2 is_reference\n\n Title   : is_reference\n Usage   : $obj->is_reference()\n Function: sets and returns boolean values. \n           Unset values return false.\n Example : $obj->is_reference()\n Returns : boolean\n Args    : optional true of false value","parameters":[{"label":"$self"},{"label":"$value"}],"label":"is_reference($self,$value)"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":129},"end":{"line":141,"character":9999}},"name":"is_reference"},{"line":157,"children":[{"name":"$self","definition":"my","containerName":"add_DBLink","localvar":"my","kind":13,"line":158},{"name":"$com","containerName":"add_DBLink","kind":13,"line":158},{"name":"$com","containerName":"add_DBLink","kind":13,"line":159},{"kind":12,"line":159,"name":"isa","containerName":"add_DBLink"},{"line":160,"kind":13,"name":"$self","containerName":"add_DBLink"},{"containerName":"add_DBLink","name":"throw","kind":12,"line":160},{"name":"$self","containerName":"add_DBLink","line":162,"kind":13}],"kind":12,"detail":"($self,$com)","signature":{"label":"add_DBLink($self,$com)","documentation":"1;\n# $Id: Allele.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::Allele\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::Allele - Sequence object with allele-specific attributes\n\n=head1 SYNOPSIS\n\n  $allele1 = Bio::Variation::Allele->new ( -seq => 'A',\n                                           -id  => 'AC00001.1',\n                                           -alphabet => 'dna',\n                                           -is_reference => 1\n                                         );\n\n=head1 DESCRIPTION\n\nList of alleles describe known sequence alternatives in a variable region.\nAlleles are contained in Bio::Variation::VariantI complying objects.\nSee L<Bio::Variation::VariantI> for details.\n\nBio::Varation::Alleles are PrimarySeqI complying objects which can\ncontain database cross references as specified in\nBio::DBLinkContainerI interface, too.\n\nA lot of the complexity with dealing with Allele objects are caused by\nnull alleles; Allele objects that have zero length sequence string.\n\nIn addition describing the allele by its sequence , it possible to\ngive describe repeat structure within the sequence. This done using\nmethods repeat_unit (e.g. 'ca') and repeat_count (e.g. 7).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Variation::Allele;\n\nuse strict;\n\n# Object preamble - inheritance\n\n\nuse base qw(Bio::PrimarySeq Bio::DBLinkContainerI);\n\nsub new {\n    my($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($is_reference, $repeat_unit, $repeat_count) =\n\t   $self->_rearrange([qw(IS_REFERENCE\n\t\t\t\t REPEAT_UNIT\n\t\t\t\t REPEAT_COUNT\n\t\t\t\t )],\n\t\t\t     @args);\n\n    $is_reference && $self->is_reference($is_reference);\n    $repeat_unit && $self->repeat_unit($repeat_unit);\n    $repeat_count && $self->repeat_count($repeat_count);\n\n    return $self; # success - we hope!\n}\n\n\n=head2 is_reference\n\n Title   : is_reference\n Usage   : $obj->is_reference()\n Function: sets and returns boolean values. \n           Unset values return false.\n Example : $obj->is_reference()\n Returns : boolean\n Args    : optional true of false value\n\n\n\n\nsub is_reference {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$value ? ($value = 1) : ($value = 0);\n\t$self->{'is_reference'} = $value;\n    }\n    if( ! exists $self->{'is_reference'} ) {\n\treturn 0;\n    } \n    else {\n\treturn $self->{'is_reference'};\n    }\n}\n\n\n=head2 add_DBLink\n\n Title   : add_DBLink\n Usage   : $self->add_DBLink($ref)\n Function: adds a link object\n Example :\n Returns : \n Args    :","parameters":[{"label":"$self"},{"label":"$com"}]},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":157},"end":{"character":9999,"line":162}},"name":"add_DBLink"},{"name":"$com","containerName":null,"line":162,"kind":13},{"name":"each_DBLink","range":{"start":{"character":0,"line":177},"end":{"character":9999,"line":179}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Allele.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::Allele\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::Allele - Sequence object with allele-specific attributes\n\n=head1 SYNOPSIS\n\n  $allele1 = Bio::Variation::Allele->new ( -seq => 'A',\n                                           -id  => 'AC00001.1',\n                                           -alphabet => 'dna',\n                                           -is_reference => 1\n                                         );\n\n=head1 DESCRIPTION\n\nList of alleles describe known sequence alternatives in a variable region.\nAlleles are contained in Bio::Variation::VariantI complying objects.\nSee L<Bio::Variation::VariantI> for details.\n\nBio::Varation::Alleles are PrimarySeqI complying objects which can\ncontain database cross references as specified in\nBio::DBLinkContainerI interface, too.\n\nA lot of the complexity with dealing with Allele objects are caused by\nnull alleles; Allele objects that have zero length sequence string.\n\nIn addition describing the allele by its sequence , it possible to\ngive describe repeat structure within the sequence. This done using\nmethods repeat_unit (e.g. 'ca') and repeat_count (e.g. 7).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Variation::Allele;\n\nuse strict;\n\n# Object preamble - inheritance\n\n\nuse base qw(Bio::PrimarySeq Bio::DBLinkContainerI);\n\nsub new {\n    my($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($is_reference, $repeat_unit, $repeat_count) =\n\t   $self->_rearrange([qw(IS_REFERENCE\n\t\t\t\t REPEAT_UNIT\n\t\t\t\t REPEAT_COUNT\n\t\t\t\t )],\n\t\t\t     @args);\n\n    $is_reference && $self->is_reference($is_reference);\n    $repeat_unit && $self->repeat_unit($repeat_unit);\n    $repeat_count && $self->repeat_count($repeat_count);\n\n    return $self; # success - we hope!\n}\n\n\n=head2 is_reference\n\n Title   : is_reference\n Usage   : $obj->is_reference()\n Function: sets and returns boolean values. \n           Unset values return false.\n Example : $obj->is_reference()\n Returns : boolean\n Args    : optional true of false value\n\n\n\n\nsub is_reference {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$value ? ($value = 1) : ($value = 0);\n\t$self->{'is_reference'} = $value;\n    }\n    if( ! exists $self->{'is_reference'} ) {\n\treturn 0;\n    } \n    else {\n\treturn $self->{'is_reference'};\n    }\n}\n\n\n=head2 add_DBLink\n\n Title   : add_DBLink\n Usage   : $self->add_DBLink($ref)\n Function: adds a link object\n Example :\n Returns : \n Args    :\n\n\n\n\nsub add_DBLink{\n   my ($self,$com) = @_;\n   if( ! $com->isa('Bio::Annotation::DBLink') ) {\n       $self->throw(\"Is not a link object but a  [$com]\");\n   }\n   push(@{$self->{'link'}},$com);\n}\n\n=head2 each_DBLink\n\n Title   : each_DBLink\n Usage   : foreach $ref ( $self->each_DBlink() )\n Function: gets an array of DBlink of objects\n Example :\n Returns : \n Args    :","label":"each_DBLink($self)"},"kind":12,"line":177,"children":[{"name":"$self","definition":"my","containerName":"each_DBLink","localvar":"my","kind":13,"line":178},{"containerName":"each_DBLink","name":"$self","line":179,"kind":13}]},{"kind":12,"children":[{"kind":13,"line":198,"definition":"my","name":"$self","containerName":"repeat_unit","localvar":"my"},{"kind":13,"line":198,"containerName":"repeat_unit","name":"$value"},{"kind":13,"line":199,"name":"$value","containerName":"repeat_unit"},{"containerName":"repeat_unit","name":"$self","line":200,"kind":13},{"line":200,"kind":13,"name":"$value","containerName":"repeat_unit"},{"line":202,"kind":13,"name":"$self","containerName":"repeat_unit"},{"line":202,"kind":13,"name":"$self","containerName":"repeat_unit"},{"line":202,"kind":13,"name":"$self","containerName":"repeat_unit"},{"line":203,"kind":13,"containerName":"repeat_unit","name":"$self"},{"kind":12,"line":203,"containerName":"repeat_unit","name":"warn"},{"kind":13,"line":204,"name":"$self","containerName":"repeat_unit"},{"kind":13,"line":204,"containerName":"repeat_unit","name":"$self"},{"kind":13,"line":204,"name":"$self","containerName":"repeat_unit"},{"line":206,"kind":13,"name":"$self","containerName":"repeat_unit"}],"line":197,"definition":"sub","containerName":"main::","signature":{"label":"repeat_unit($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Allele.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::Allele\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::Allele - Sequence object with allele-specific attributes\n\n=head1 SYNOPSIS\n\n  $allele1 = Bio::Variation::Allele->new ( -seq => 'A',\n                                           -id  => 'AC00001.1',\n                                           -alphabet => 'dna',\n                                           -is_reference => 1\n                                         );\n\n=head1 DESCRIPTION\n\nList of alleles describe known sequence alternatives in a variable region.\nAlleles are contained in Bio::Variation::VariantI complying objects.\nSee L<Bio::Variation::VariantI> for details.\n\nBio::Varation::Alleles are PrimarySeqI complying objects which can\ncontain database cross references as specified in\nBio::DBLinkContainerI interface, too.\n\nA lot of the complexity with dealing with Allele objects are caused by\nnull alleles; Allele objects that have zero length sequence string.\n\nIn addition describing the allele by its sequence , it possible to\ngive describe repeat structure within the sequence. This done using\nmethods repeat_unit (e.g. 'ca') and repeat_count (e.g. 7).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Variation::Allele;\n\nuse strict;\n\n# Object preamble - inheritance\n\n\nuse base qw(Bio::PrimarySeq Bio::DBLinkContainerI);\n\nsub new {\n    my($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($is_reference, $repeat_unit, $repeat_count) =\n\t   $self->_rearrange([qw(IS_REFERENCE\n\t\t\t\t REPEAT_UNIT\n\t\t\t\t REPEAT_COUNT\n\t\t\t\t )],\n\t\t\t     @args);\n\n    $is_reference && $self->is_reference($is_reference);\n    $repeat_unit && $self->repeat_unit($repeat_unit);\n    $repeat_count && $self->repeat_count($repeat_count);\n\n    return $self; # success - we hope!\n}\n\n\n=head2 is_reference\n\n Title   : is_reference\n Usage   : $obj->is_reference()\n Function: sets and returns boolean values. \n           Unset values return false.\n Example : $obj->is_reference()\n Returns : boolean\n Args    : optional true of false value\n\n\n\n\nsub is_reference {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$value ? ($value = 1) : ($value = 0);\n\t$self->{'is_reference'} = $value;\n    }\n    if( ! exists $self->{'is_reference'} ) {\n\treturn 0;\n    } \n    else {\n\treturn $self->{'is_reference'};\n    }\n}\n\n\n=head2 add_DBLink\n\n Title   : add_DBLink\n Usage   : $self->add_DBLink($ref)\n Function: adds a link object\n Example :\n Returns : \n Args    :\n\n\n\n\nsub add_DBLink{\n   my ($self,$com) = @_;\n   if( ! $com->isa('Bio::Annotation::DBLink') ) {\n       $self->throw(\"Is not a link object but a  [$com]\");\n   }\n   push(@{$self->{'link'}},$com);\n}\n\n=head2 each_DBLink\n\n Title   : each_DBLink\n Usage   : foreach $ref ( $self->each_DBlink() )\n Function: gets an array of DBlink of objects\n Example :\n Returns : \n Args    :\n\n\n\nsub each_DBLink{\n   my ($self) = @_;   \n   return @{$self->{'link'}}; \n}\n\n=head2 repeat_unit\n\n Title   : repeat_unit\n Usage   : $obj->repeat_unit('ca');\n Function: \n\n            Sets and returns the sequence of the repeat_unit the\n            allele is composed of.\n\n Example : \n Returns : string\n Args    : string"},"detail":"($self,$value)","name":"repeat_unit","range":{"start":{"character":0,"line":197},"end":{"line":207,"character":9999}}},{"signature":{"label":"repeat_count($self,$value)","documentation":"1;\n# $Id: Allele.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::Allele\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::Allele - Sequence object with allele-specific attributes\n\n=head1 SYNOPSIS\n\n  $allele1 = Bio::Variation::Allele->new ( -seq => 'A',\n                                           -id  => 'AC00001.1',\n                                           -alphabet => 'dna',\n                                           -is_reference => 1\n                                         );\n\n=head1 DESCRIPTION\n\nList of alleles describe known sequence alternatives in a variable region.\nAlleles are contained in Bio::Variation::VariantI complying objects.\nSee L<Bio::Variation::VariantI> for details.\n\nBio::Varation::Alleles are PrimarySeqI complying objects which can\ncontain database cross references as specified in\nBio::DBLinkContainerI interface, too.\n\nA lot of the complexity with dealing with Allele objects are caused by\nnull alleles; Allele objects that have zero length sequence string.\n\nIn addition describing the allele by its sequence , it possible to\ngive describe repeat structure within the sequence. This done using\nmethods repeat_unit (e.g. 'ca') and repeat_count (e.g. 7).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Variation::Allele;\n\nuse strict;\n\n# Object preamble - inheritance\n\n\nuse base qw(Bio::PrimarySeq Bio::DBLinkContainerI);\n\nsub new {\n    my($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($is_reference, $repeat_unit, $repeat_count) =\n\t   $self->_rearrange([qw(IS_REFERENCE\n\t\t\t\t REPEAT_UNIT\n\t\t\t\t REPEAT_COUNT\n\t\t\t\t )],\n\t\t\t     @args);\n\n    $is_reference && $self->is_reference($is_reference);\n    $repeat_unit && $self->repeat_unit($repeat_unit);\n    $repeat_count && $self->repeat_count($repeat_count);\n\n    return $self; # success - we hope!\n}\n\n\n=head2 is_reference\n\n Title   : is_reference\n Usage   : $obj->is_reference()\n Function: sets and returns boolean values. \n           Unset values return false.\n Example : $obj->is_reference()\n Returns : boolean\n Args    : optional true of false value\n\n\n\n\nsub is_reference {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$value ? ($value = 1) : ($value = 0);\n\t$self->{'is_reference'} = $value;\n    }\n    if( ! exists $self->{'is_reference'} ) {\n\treturn 0;\n    } \n    else {\n\treturn $self->{'is_reference'};\n    }\n}\n\n\n=head2 add_DBLink\n\n Title   : add_DBLink\n Usage   : $self->add_DBLink($ref)\n Function: adds a link object\n Example :\n Returns : \n Args    :\n\n\n\n\nsub add_DBLink{\n   my ($self,$com) = @_;\n   if( ! $com->isa('Bio::Annotation::DBLink') ) {\n       $self->throw(\"Is not a link object but a  [$com]\");\n   }\n   push(@{$self->{'link'}},$com);\n}\n\n=head2 each_DBLink\n\n Title   : each_DBLink\n Usage   : foreach $ref ( $self->each_DBlink() )\n Function: gets an array of DBlink of objects\n Example :\n Returns : \n Args    :\n\n\n\nsub each_DBLink{\n   my ($self) = @_;   \n   return @{$self->{'link'}}; \n}\n\n=head2 repeat_unit\n\n Title   : repeat_unit\n Usage   : $obj->repeat_unit('ca');\n Function: \n\n            Sets and returns the sequence of the repeat_unit the\n            allele is composed of.\n\n Example : \n Returns : string\n Args    : string\n\n\nsub repeat_unit {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'repeat_unit'} = $value;\n    }\n    if ($self->{'seq'} && $self->{'repeat_unit'} && $self->{'repeat_count'} ) {\n\t$self->warn(\"Repeats do not add up!\") \n\t    if ( $self->{'repeat_unit'} x $self->{'repeat_count'})  ne $self->{'seq'};\n    }\n    return $self->{'repeat_unit'};\n}\n\n=head2 repeat_count\n\n Title   : repeat_count\n Usage   : $obj->repeat_count();\n Function: \n\n            Sets and returns the number of repeat units in the allele.\n\n Example : \n Returns : string\n Args    : string","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":225,"containerName":"repeat_count","definition":"my","name":"$self","localvar":"my"},{"containerName":"repeat_count","name":"$value","line":225,"kind":13},{"name":"$value","containerName":"repeat_count","kind":13,"line":226},{"kind":13,"line":227,"name":"$value","containerName":"repeat_count"},{"name":"$self","containerName":"repeat_count","kind":13,"line":228},{"name":"throw","containerName":"repeat_count","line":228,"kind":12},{"line":230,"kind":13,"containerName":"repeat_count","name":"$self"},{"containerName":"repeat_count","name":"$value","line":230,"kind":13},{"kind":13,"line":233,"containerName":"repeat_count","name":"$self"},{"line":233,"kind":13,"name":"$self","containerName":"repeat_count"},{"containerName":"repeat_count","name":"$self","kind":13,"line":233},{"containerName":"repeat_count","name":"$self","line":234,"kind":13},{"kind":12,"line":234,"containerName":"repeat_count","name":"warn"},{"kind":13,"line":235,"name":"$self","containerName":"repeat_count"},{"kind":13,"line":235,"containerName":"repeat_count","name":"$self"},{"kind":13,"line":235,"name":"$self","containerName":"repeat_count"},{"name":"$self","containerName":"repeat_count","line":237,"kind":13}],"line":224,"kind":12,"range":{"start":{"character":0,"line":224},"end":{"line":238,"character":9999}},"name":"repeat_count"},{"name":"count","range":{"end":{"character":9999,"line":264},"start":{"character":0,"line":254}},"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"count($self,$value)","documentation":"1;\n# $Id: Allele.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::Allele\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::Allele - Sequence object with allele-specific attributes\n\n=head1 SYNOPSIS\n\n  $allele1 = Bio::Variation::Allele->new ( -seq => 'A',\n                                           -id  => 'AC00001.1',\n                                           -alphabet => 'dna',\n                                           -is_reference => 1\n                                         );\n\n=head1 DESCRIPTION\n\nList of alleles describe known sequence alternatives in a variable region.\nAlleles are contained in Bio::Variation::VariantI complying objects.\nSee L<Bio::Variation::VariantI> for details.\n\nBio::Varation::Alleles are PrimarySeqI complying objects which can\ncontain database cross references as specified in\nBio::DBLinkContainerI interface, too.\n\nA lot of the complexity with dealing with Allele objects are caused by\nnull alleles; Allele objects that have zero length sequence string.\n\nIn addition describing the allele by its sequence , it possible to\ngive describe repeat structure within the sequence. This done using\nmethods repeat_unit (e.g. 'ca') and repeat_count (e.g. 7).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Variation::Allele;\n\nuse strict;\n\n# Object preamble - inheritance\n\n\nuse base qw(Bio::PrimarySeq Bio::DBLinkContainerI);\n\nsub new {\n    my($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($is_reference, $repeat_unit, $repeat_count) =\n\t   $self->_rearrange([qw(IS_REFERENCE\n\t\t\t\t REPEAT_UNIT\n\t\t\t\t REPEAT_COUNT\n\t\t\t\t )],\n\t\t\t     @args);\n\n    $is_reference && $self->is_reference($is_reference);\n    $repeat_unit && $self->repeat_unit($repeat_unit);\n    $repeat_count && $self->repeat_count($repeat_count);\n\n    return $self; # success - we hope!\n}\n\n\n=head2 is_reference\n\n Title   : is_reference\n Usage   : $obj->is_reference()\n Function: sets and returns boolean values. \n           Unset values return false.\n Example : $obj->is_reference()\n Returns : boolean\n Args    : optional true of false value\n\n\n\n\nsub is_reference {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$value ? ($value = 1) : ($value = 0);\n\t$self->{'is_reference'} = $value;\n    }\n    if( ! exists $self->{'is_reference'} ) {\n\treturn 0;\n    } \n    else {\n\treturn $self->{'is_reference'};\n    }\n}\n\n\n=head2 add_DBLink\n\n Title   : add_DBLink\n Usage   : $self->add_DBLink($ref)\n Function: adds a link object\n Example :\n Returns : \n Args    :\n\n\n\n\nsub add_DBLink{\n   my ($self,$com) = @_;\n   if( ! $com->isa('Bio::Annotation::DBLink') ) {\n       $self->throw(\"Is not a link object but a  [$com]\");\n   }\n   push(@{$self->{'link'}},$com);\n}\n\n=head2 each_DBLink\n\n Title   : each_DBLink\n Usage   : foreach $ref ( $self->each_DBlink() )\n Function: gets an array of DBlink of objects\n Example :\n Returns : \n Args    :\n\n\n\nsub each_DBLink{\n   my ($self) = @_;   \n   return @{$self->{'link'}}; \n}\n\n=head2 repeat_unit\n\n Title   : repeat_unit\n Usage   : $obj->repeat_unit('ca');\n Function: \n\n            Sets and returns the sequence of the repeat_unit the\n            allele is composed of.\n\n Example : \n Returns : string\n Args    : string\n\n\nsub repeat_unit {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'repeat_unit'} = $value;\n    }\n    if ($self->{'seq'} && $self->{'repeat_unit'} && $self->{'repeat_count'} ) {\n\t$self->warn(\"Repeats do not add up!\") \n\t    if ( $self->{'repeat_unit'} x $self->{'repeat_count'})  ne $self->{'seq'};\n    }\n    return $self->{'repeat_unit'};\n}\n\n=head2 repeat_count\n\n Title   : repeat_count\n Usage   : $obj->repeat_count();\n Function: \n\n            Sets and returns the number of repeat units in the allele.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub repeat_count {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif (  not $value =~ /^\\d+$/ ) {\n\t    $self->throw(\"[$value] for repeat_count has to be a positive integer\\n\");\n\t} else {\n\t    $self->{'repeat_count'} = $value;\n\t}\n    }\n    if ($self->{'seq'} && $self->{'repeat_unit'} && $self->{'repeat_count'} ) {\n\t$self->warn(\"Repeats do not add up!\") \n\t    if ( $self->{'repeat_unit'} x $self->{'repeat_count'})  ne $self->{'seq'};\n    }\n    return $self->{'repeat_count'};\n}\n\n=head2 count\n\n Title   : count\n Usage   : $obj->count();\n Function: \n\n            Sets and returns the number of times this allele was observed.\n\n Example : \n Returns : string\n Args    : string","parameters":[{"label":"$self"},{"label":"$value"}]},"kind":12,"line":254,"children":[{"kind":13,"line":255,"containerName":"count","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":255,"name":"$value","containerName":"count"},{"containerName":"count","name":"$value","line":256,"kind":13},{"name":"$value","containerName":"count","kind":13,"line":257},{"containerName":"count","name":"$self","kind":13,"line":258},{"name":"throw","containerName":"count","kind":12,"line":258},{"line":260,"kind":13,"containerName":"count","name":"$self"},{"line":260,"kind":13,"containerName":"count","name":"$value"},{"kind":13,"line":263,"name":"$self","containerName":"count"}]},{"kind":12,"children":[{"kind":13,"line":283,"containerName":"frequency","name":"$self","definition":"my","localvar":"my"},{"containerName":"frequency","name":"$value","line":283,"kind":13},{"kind":13,"line":284,"containerName":"frequency","name":"$value"},{"name":"$value","containerName":"frequency","line":285,"kind":13},{"name":"$self","containerName":"frequency","line":286,"kind":13},{"kind":12,"line":286,"name":"throw","containerName":"frequency"},{"kind":13,"line":288,"containerName":"frequency","name":"$self"},{"kind":13,"line":288,"containerName":"frequency","name":"$value"},{"kind":13,"line":291,"name":"$self","containerName":"frequency"}],"line":282,"definition":"sub","containerName":"main::","signature":{"label":"frequency($self,$value)","documentation":"1;\n# $Id: Allele.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::Allele\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::Allele - Sequence object with allele-specific attributes\n\n=head1 SYNOPSIS\n\n  $allele1 = Bio::Variation::Allele->new ( -seq => 'A',\n                                           -id  => 'AC00001.1',\n                                           -alphabet => 'dna',\n                                           -is_reference => 1\n                                         );\n\n=head1 DESCRIPTION\n\nList of alleles describe known sequence alternatives in a variable region.\nAlleles are contained in Bio::Variation::VariantI complying objects.\nSee L<Bio::Variation::VariantI> for details.\n\nBio::Varation::Alleles are PrimarySeqI complying objects which can\ncontain database cross references as specified in\nBio::DBLinkContainerI interface, too.\n\nA lot of the complexity with dealing with Allele objects are caused by\nnull alleles; Allele objects that have zero length sequence string.\n\nIn addition describing the allele by its sequence , it possible to\ngive describe repeat structure within the sequence. This done using\nmethods repeat_unit (e.g. 'ca') and repeat_count (e.g. 7).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Variation::Allele;\n\nuse strict;\n\n# Object preamble - inheritance\n\n\nuse base qw(Bio::PrimarySeq Bio::DBLinkContainerI);\n\nsub new {\n    my($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($is_reference, $repeat_unit, $repeat_count) =\n\t   $self->_rearrange([qw(IS_REFERENCE\n\t\t\t\t REPEAT_UNIT\n\t\t\t\t REPEAT_COUNT\n\t\t\t\t )],\n\t\t\t     @args);\n\n    $is_reference && $self->is_reference($is_reference);\n    $repeat_unit && $self->repeat_unit($repeat_unit);\n    $repeat_count && $self->repeat_count($repeat_count);\n\n    return $self; # success - we hope!\n}\n\n\n=head2 is_reference\n\n Title   : is_reference\n Usage   : $obj->is_reference()\n Function: sets and returns boolean values. \n           Unset values return false.\n Example : $obj->is_reference()\n Returns : boolean\n Args    : optional true of false value\n\n\n\n\nsub is_reference {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$value ? ($value = 1) : ($value = 0);\n\t$self->{'is_reference'} = $value;\n    }\n    if( ! exists $self->{'is_reference'} ) {\n\treturn 0;\n    } \n    else {\n\treturn $self->{'is_reference'};\n    }\n}\n\n\n=head2 add_DBLink\n\n Title   : add_DBLink\n Usage   : $self->add_DBLink($ref)\n Function: adds a link object\n Example :\n Returns : \n Args    :\n\n\n\n\nsub add_DBLink{\n   my ($self,$com) = @_;\n   if( ! $com->isa('Bio::Annotation::DBLink') ) {\n       $self->throw(\"Is not a link object but a  [$com]\");\n   }\n   push(@{$self->{'link'}},$com);\n}\n\n=head2 each_DBLink\n\n Title   : each_DBLink\n Usage   : foreach $ref ( $self->each_DBlink() )\n Function: gets an array of DBlink of objects\n Example :\n Returns : \n Args    :\n\n\n\nsub each_DBLink{\n   my ($self) = @_;   \n   return @{$self->{'link'}}; \n}\n\n=head2 repeat_unit\n\n Title   : repeat_unit\n Usage   : $obj->repeat_unit('ca');\n Function: \n\n            Sets and returns the sequence of the repeat_unit the\n            allele is composed of.\n\n Example : \n Returns : string\n Args    : string\n\n\nsub repeat_unit {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'repeat_unit'} = $value;\n    }\n    if ($self->{'seq'} && $self->{'repeat_unit'} && $self->{'repeat_count'} ) {\n\t$self->warn(\"Repeats do not add up!\") \n\t    if ( $self->{'repeat_unit'} x $self->{'repeat_count'})  ne $self->{'seq'};\n    }\n    return $self->{'repeat_unit'};\n}\n\n=head2 repeat_count\n\n Title   : repeat_count\n Usage   : $obj->repeat_count();\n Function: \n\n            Sets and returns the number of repeat units in the allele.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub repeat_count {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif (  not $value =~ /^\\d+$/ ) {\n\t    $self->throw(\"[$value] for repeat_count has to be a positive integer\\n\");\n\t} else {\n\t    $self->{'repeat_count'} = $value;\n\t}\n    }\n    if ($self->{'seq'} && $self->{'repeat_unit'} && $self->{'repeat_count'} ) {\n\t$self->warn(\"Repeats do not add up!\") \n\t    if ( $self->{'repeat_unit'} x $self->{'repeat_count'})  ne $self->{'seq'};\n    }\n    return $self->{'repeat_count'};\n}\n\n=head2 count\n\n Title   : count\n Usage   : $obj->count();\n Function: \n\n            Sets and returns the number of times this allele was observed.\n\n Example : \n Returns : string\n Args    : string\n\n\nsub count {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif (  not $value =~ /^\\d+$/ ) {\n\t    $self->throw(\"[$value] for count has to be a positive integer\\n\");\n\t} else {\n\t    $self->{'count'} = $value;\n\t}\n    }\n    return $self->{'count'};\n}\n\n\n=head2 frequency\n\n Title   : frequency\n Usage   : $obj->frequency();\n Function: \n\n            Sets and returns the frequency of the allele in the observed\n            population.\n\n Example : \n Returns : string\n Args    : string","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)","name":"frequency","range":{"end":{"character":9999,"line":292},"start":{"line":282,"character":0}}}],"version":5}