{"vars":[{"line":86,"kind":2,"containerName":"","name":"base"},{"range":{"start":{"character":0,"line":109},"end":{"line":113,"character":9999}},"name":"delete_feature","line":109,"children":[{"localvar":"my","containerName":"delete_feature","name":"$self","definition":"my","line":110,"kind":13},{"containerName":"delete_feature","name":"$feature","kind":13,"line":110},{"containerName":"delete_feature","name":"$transcript","line":110,"kind":13},{"kind":13,"line":110,"name":"$gene","containerName":"delete_feature"},{"name":"$self","containerName":"delete_feature","line":112,"kind":13},{"containerName":"delete_feature","name":"throw_not_implemented","line":112,"kind":12}],"kind":12,"detail":"($self,$feature,$transcript,$gene)","signature":{"documentation":"1;\n# $Id: UpdateableSeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::UpdateableSeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by David Block <dblock@gene.pbi.nrc.ca>\n#\n# Copyright David Block\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::UpdateableSeqI - Descendant of Bio::SeqI that allows updates\n\n=head1 SYNOPSIS\n\nSee Bio::SeqI for most of the documentation.\nSee the documentation of the methods for further details.\n\n=head1 DESCRIPTION\n\nBio::UpdateableSeqI is an interface for Sequence objects which are\nexpected to allow users to perform basic editing functions (update/delete)\non their component SeqFeatures.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - David Block\n\nEmail dblock@gene.pbi.nrc.ca\n\n=head1 CONTRIBUTORS\n\nEwan Birney forced me to this...\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::UpdateableSeqI;\nuse strict;\nuse Carp;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\n\nuse base qw(Bio::SeqI);\n\n\n=head2 delete_feature\n\n Title   : delete_feature\n Usage   : my $orphanlist=$self->delete_feature($feature,$transcript,$gene);\n Function: deletes the specified $feature from the given transcript, if $transcript is sent and exists and $feature is a feature of $transcript,\n           or from $gene if the $feature is a feature of $gene, or from $self if $transcript and $gene are not sent.  Keeps track of the features\n           of the $gene object that may be left as orphans and returns them as a listref.\n Example : I want to delete transcript 'abc' of gene 'def', with three exons, leaving only transcript 'ghi' with two exons.\n           This will leave exons 1 and 3 part of 'ghi', but exon 2 will become an orphan.\n           my $orphanlist=$seq->delete_feature($transcript{'abc'},undef,$gene{'def'});\n           $orphanlist is a reference to a list containing $exon{'2'};\n Returns : a listref of orphaned features after the deletion of $feature (optional)\n Args    : $feature - the feature to be deleted\n           $transcript - the transcript containing the $feature, so that a $feature can be removed from only one transcript when there are multiple\n                         transcripts in a gene.\n           $gene - the gene containing the $transcript and/or the $feature","parameters":[{"label":"$self"},{"label":"$feature"},{"label":"$transcript"},{"label":"$gene"}],"label":"delete_feature($self,$feature,$transcript,$gene)"},"containerName":"main::","definition":"sub"}],"version":5}