{"version":5,"vars":[{"kind":13,"line":82,"containerName":"main::","name":"$TaxonNameLen","definition":"our"},{"containerName":"","name":"strict","line":82,"kind":2},{"kind":2,"line":84,"containerName":"","name":"base"},{"range":{"start":{"character":0,"line":97},"end":{"line":107,"character":9999}},"name":"_initialize","definition":"sub","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"_initialize","localvar":"my","kind":13,"line":98},{"name":"$self","containerName":"_initialize","kind":13,"line":99},{"line":100,"kind":13,"localvar":"my","name":"$name_length","definition":"my","containerName":"_initialize"},{"kind":13,"line":100,"name":"$self","containerName":"_initialize"},{"name":"_rearrange","containerName":"_initialize","kind":12,"line":100},{"name":"$self","containerName":"_initialize","kind":13,"line":106},{"kind":12,"line":106,"containerName":"_initialize","name":"name_length"},{"containerName":"_initialize","name":"$name_length","line":106,"kind":13},{"containerName":"_initialize","name":"$name_length","line":106,"kind":13},{"containerName":"_initialize","name":"$TaxonNameLen","line":106,"kind":13}],"line":97,"kind":12},{"containerName":"_initialize","name":"SUPER","kind":12,"line":99},{"name":"write_tree","range":{"end":{"line":232,"character":9999},"start":{"line":127,"character":0}},"containerName":"main::","definition":"sub","detail":"($self,$tree,@args)","signature":{"label":"write_tree($self,$tree,@args)","documentation":"1;\n# $Id: pag.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO::pag\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO::pag - Bio::TreeIO driver for Pagel format\n\n=head1 SYNOPSIS\n\n  use Bio::TreeIO;\n  my $in = Bio::TreeIO->new(-format => 'nexus',\n                            -file   => 't/data/adh.mb_tree.nexus');\n\n  my $out = Bio::TreeIO->new(-format => 'pag');\n  while( my $tree = $in->next_tree ) {\n    $out->write_tree($tree);\n  }\n\n=head1 DESCRIPTION\n\nConvert a Bio::TreeIO to Pagel format.\nMore information here http://www.evolution.reading.ac.uk/index.html\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO::pag;\nuse strict;\n\nour $TaxonNameLen = 10;\n\nuse base qw(Bio::TreeIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO::pag->new();\n Function: Builds a new Bio::TreeIO::pag object \n Returns : an instance of Bio::TreeIO::pag\n Args    : -file/-fh for filename or filehandles\n           -name_length for minimum name length (default = 10)\n\n\nsub _initialize {\n    my $self = shift;\n    $self->SUPER::_initialize(@_);\n    my ( $name_length ) = $self->_rearrange(\n        [\n            qw(NAME_LENGTH)\n        ],\n        @_\n    );\n    $self->name_length( defined $name_length ? $name_length : $TaxonNameLen );\n}\n\n=head2 write_tree\n\n Title   : write_tree\n Usage   :\n Function: Write a tree out in Pagel format\n           Some options are only appropriate for bayesianmultistate and\n           the simpler output is only proper for discrete\n Returns : none\n Args    : -no_outgroups => (number)\n           -print_header => 0/1 (leave 0 for discrete, 1 for bayesianms)\n           -special_node => special node - not sure what they wanted to do here\n           -keep_outgroup => 0/1 (keep the outgroup node in the output)\n           -outgroup_ancestor => Bio::Tree::Node (if we want to exclude or include the outgroup this is what we operate on)\n           -tree_no       => a tree number label - only useful for BayesianMultistate","parameters":[{"label":"$self"},{"label":"$tree"},{"label":"@args"}]},"kind":12,"line":127,"children":[{"line":128,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"write_tree"},{"containerName":"write_tree","name":"$tree","kind":13,"line":128},{"kind":13,"line":128,"containerName":"write_tree","name":"@args"},{"name":"$keep_outgroup","definition":"my","containerName":"write_tree","localvar":"my","kind":13,"line":129},{"kind":13,"line":130,"containerName":"write_tree","name":"$print_header"},{"name":"$no_outgroups","containerName":"write_tree","line":131,"kind":13},{"name":"$special_node","containerName":"write_tree","kind":13,"line":132},{"containerName":"write_tree","name":"$outgroup_ancestor","line":133,"kind":13},{"kind":13,"line":134,"containerName":"write_tree","name":"$tree_no"},{"localvar":"my","containerName":"write_tree","name":"$name_len","definition":"my","line":135,"kind":13},{"containerName":"write_tree","name":"$self","kind":13,"line":135},{"containerName":"write_tree","name":"name_length","line":135,"kind":12},{"containerName":"write_tree","name":"@args","kind":13,"line":136},{"name":"$no_outgroups","containerName":"write_tree","line":137,"kind":13},{"line":138,"kind":13,"containerName":"write_tree","name":"$print_header"},{"line":139,"kind":13,"containerName":"write_tree","name":"$special_node"},{"containerName":"write_tree","name":"$outgroup_ancestor","line":140,"kind":13},{"line":141,"kind":13,"containerName":"write_tree","name":"$tree_no"},{"containerName":"write_tree","name":"$keep_outgroup","kind":13,"line":142},{"kind":13,"line":142,"name":"$self","containerName":"write_tree"},{"kind":12,"line":142,"name":"_rearrange","containerName":"write_tree"},{"containerName":"write_tree","name":"@args","kind":13,"line":150},{"name":"$newname_base","definition":"my","containerName":"write_tree","localvar":"my","kind":13,"line":152},{"kind":13,"line":154,"name":"$root","definition":"my","containerName":"write_tree","localvar":"my"},{"name":"$tree","containerName":"write_tree","line":154,"kind":13},{"containerName":"write_tree","name":"get_root_node","line":154,"kind":12},{"kind":13,"line":155,"containerName":"write_tree","name":"$eps","definition":"my","localvar":"my"},{"localvar":"my","name":"%chars","definition":"my","containerName":"write_tree","line":156,"kind":13},{"kind":13,"line":156,"containerName":"write_tree","name":"%names"},{"kind":13,"line":157,"containerName":"write_tree","definition":"my","name":"@nodes","localvar":"my"},{"kind":13,"line":157,"name":"$tree","containerName":"write_tree"},{"line":157,"kind":12,"containerName":"write_tree","name":"get_nodes"},{"localvar":"my","name":"$species_ct","definition":"my","containerName":"write_tree","line":158,"kind":13},{"containerName":"write_tree","name":"$traitct","definition":"my","localvar":"my","kind":13,"line":159},{"definition":"my","name":"$node","containerName":"write_tree","localvar":"my","kind":13,"line":160},{"kind":13,"line":160,"containerName":"write_tree","name":"@nodes"},{"name":"$special_node","containerName":"write_tree","line":161,"kind":13},{"kind":13,"line":161,"name":"$node","containerName":"write_tree"},{"line":161,"kind":13,"containerName":"write_tree","name":"$special_node"},{"kind":13,"line":162,"definition":"my","name":"$no_of_tree_nodes","containerName":"write_tree","localvar":"my"},{"containerName":"write_tree","name":"@nodes","kind":13,"line":162},{"line":163,"kind":13,"localvar":"my","containerName":"write_tree","name":"$node_name","definition":"my"},{"name":"$no_of_tree_nodes","containerName":"write_tree","line":163,"kind":13},{"name":"$names","containerName":"write_tree","kind":13,"line":164},{"containerName":"write_tree","name":"$node","kind":13,"line":164},{"line":164,"kind":12,"containerName":"write_tree","name":"internal_id"},{"containerName":"write_tree","name":"$node_name","line":164,"kind":13},{"containerName":"write_tree","name":"$node","kind":13,"line":166},{"containerName":"write_tree","name":"is_Leaf","line":166,"kind":12},{"kind":13,"line":167,"name":"$species_ct","containerName":"write_tree"},{"localvar":"my","definition":"my","name":"$node_name","containerName":"write_tree","line":169,"kind":13},{"name":"$node","containerName":"write_tree","line":169,"kind":13},{"containerName":"write_tree","name":"id","kind":12,"line":169},{"containerName":"write_tree","name":"$node_name","line":170,"kind":13},{"kind":13,"line":170,"name":"$name_len","containerName":"write_tree"},{"kind":13,"line":171,"containerName":"write_tree","name":"$self"},{"line":171,"kind":12,"containerName":"write_tree","name":"warn"},{"containerName":"write_tree","name":"$node_name","kind":13,"line":173},{"kind":13,"line":173,"containerName":"write_tree","name":"$node_name"},{"kind":13,"line":173,"containerName":"write_tree","name":"$name_len"},{"line":177,"kind":13,"containerName":"write_tree","name":"$names"},{"kind":13,"line":177,"name":"$node","containerName":"write_tree"},{"containerName":"write_tree","name":"internal_id","line":177,"kind":12},{"name":"$node_name","containerName":"write_tree","line":177,"kind":13},{"line":178,"kind":13,"localvar":"my","containerName":"write_tree","definition":"my","name":"@tags"},{"containerName":"write_tree","name":"$node","kind":13,"line":178},{"containerName":"write_tree","name":"get_all_tags","line":178,"kind":12},{"kind":13,"line":179,"containerName":"write_tree","name":"@charstates","definition":"my","localvar":"my"},{"name":"$node","containerName":"write_tree","kind":13,"line":179},{"line":179,"kind":12,"containerName":"write_tree","name":"get_tag_values"},{"name":"@tags","containerName":"write_tree","line":179,"kind":13},{"line":180,"kind":13,"containerName":"write_tree","name":"$traitct"},{"name":"@charstates","containerName":"write_tree","kind":13,"line":180},{"containerName":"write_tree","name":"$traitct","line":180,"kind":13},{"kind":13,"line":181,"containerName":"write_tree","name":"$chars"},{"line":181,"kind":13,"containerName":"write_tree","name":"$node"},{"kind":12,"line":181,"name":"internal_id","containerName":"write_tree"},{"name":"@charstates","containerName":"write_tree","line":181,"kind":13},{"name":"$names","containerName":"write_tree","line":183,"kind":13},{"containerName":"write_tree","name":"$node","kind":13,"line":183},{"kind":12,"line":183,"name":"internal_id","containerName":"write_tree"},{"kind":13,"line":183,"name":"$newname_base","containerName":"write_tree"},{"kind":13,"line":188,"containerName":"write_tree","name":"$print_header"},{"containerName":"write_tree","name":"$keep_outgroup","line":189,"kind":13},{"name":"$self","containerName":"write_tree","kind":13,"line":190},{"name":"_print","containerName":"write_tree","line":190,"kind":12},{"kind":13,"line":190,"containerName":"write_tree","name":"$species_ct"},{"containerName":"write_tree","name":"$traitct","line":190,"kind":13},{"line":192,"kind":13,"name":"$self","containerName":"write_tree"},{"line":192,"kind":12,"containerName":"write_tree","name":"_print"},{"line":192,"kind":13,"containerName":"write_tree","name":"$species_ct"},{"kind":13,"line":192,"name":"$no_outgroups","containerName":"write_tree"},{"containerName":"write_tree","name":"$traitct","line":192,"kind":13},{"name":"@ancestors","definition":"my","containerName":"write_tree","localvar":"my","kind":13,"line":196},{"kind":13,"line":197,"name":"$keep_outgroup","containerName":"write_tree"},{"name":"@ancestors","containerName":"write_tree","kind":13,"line":198},{"line":198,"kind":13,"name":"$root","containerName":"write_tree"},{"kind":13,"line":200,"name":"@ancestors","containerName":"write_tree"},{"containerName":"write_tree","name":"$root","line":200,"kind":13},{"kind":13,"line":200,"containerName":"write_tree","name":"$outgroup_ancestor"},{"kind":13,"line":202,"definition":"my","name":"@rest","containerName":"write_tree","localvar":"my"},{"containerName":"write_tree","definition":"my","name":"$node","localvar":"my","kind":13,"line":203},{"kind":13,"line":203,"containerName":"write_tree","name":"@nodes"},{"kind":13,"line":204,"name":"$i","definition":"my","containerName":"write_tree","localvar":"my"},{"name":"$anc","definition":"my","containerName":"write_tree","localvar":"my","kind":13,"line":205},{"kind":13,"line":205,"containerName":"write_tree","name":"@ancestors"},{"containerName":"write_tree","name":"$anc","line":206,"kind":13},{"line":206,"kind":13,"name":"$node","containerName":"write_tree"},{"line":206,"kind":13,"containerName":"write_tree","name":"$anc"},{"name":"$i","containerName":"write_tree","line":206,"kind":13},{"name":"$i","containerName":"write_tree","kind":13,"line":208},{"localvar":"my","containerName":"write_tree","name":"$current_name","definition":"my","line":209,"kind":13},{"containerName":"write_tree","name":"$names","line":209,"kind":13},{"name":"$node","containerName":"write_tree","line":209,"kind":13},{"kind":12,"line":209,"name":"internal_id","containerName":"write_tree"},{"localvar":"my","name":"$branch_length_to_output","definition":"my","containerName":"write_tree","line":210,"kind":13},{"containerName":"write_tree","name":"$node","line":211,"kind":13},{"name":"branch_length","containerName":"write_tree","line":211,"kind":12},{"containerName":"write_tree","name":"$eps","line":211,"kind":13},{"line":212,"kind":13,"localvar":"my","definition":"my","name":"$msg_nodename","containerName":"write_tree"},{"kind":13,"line":212,"containerName":"write_tree","name":"$current_name"},{"name":"$msg_nodename","containerName":"write_tree","kind":13,"line":213},{"line":215,"kind":13,"name":"$node","containerName":"write_tree"},{"containerName":"write_tree","name":"branch_length","kind":12,"line":215},{"kind":13,"line":217,"name":"$branch_length_to_output","containerName":"write_tree"},{"name":"$eps","containerName":"write_tree","kind":13,"line":217},{"line":219,"kind":13,"name":"$branch_length_to_output","containerName":"write_tree"},{"name":"$node","containerName":"write_tree","kind":13,"line":219},{"line":219,"kind":12,"name":"branch_length","containerName":"write_tree"},{"name":"@line","definition":"my","containerName":"write_tree","localvar":"my","kind":13,"line":221},{"containerName":"write_tree","name":"$current_name","line":221,"kind":13},{"name":"$names","containerName":"write_tree","line":222,"kind":13},{"containerName":"write_tree","name":"$node","kind":13,"line":222},{"containerName":"write_tree","name":"ancestor","kind":12,"line":222},{"line":222,"kind":12,"containerName":"write_tree","name":"internal_id"},{"name":"$branch_length_to_output","containerName":"write_tree","kind":13,"line":223},{"line":225,"kind":13,"name":"$node","containerName":"write_tree"},{"kind":12,"line":225,"name":"is_Leaf","containerName":"write_tree"},{"containerName":"write_tree","name":"@line","kind":13,"line":226},{"name":"$chars","containerName":"write_tree","line":226,"kind":13},{"name":"$node","containerName":"write_tree","line":226,"kind":13},{"kind":12,"line":226,"name":"internal_id","containerName":"write_tree"},{"containerName":"write_tree","name":"$self","line":227,"kind":13},{"kind":12,"line":227,"containerName":"write_tree","name":"_print"},{"name":"@line","containerName":"write_tree","kind":13,"line":227},{"name":"@rest","containerName":"write_tree","kind":13,"line":229},{"line":229,"kind":13,"name":"@line","containerName":"write_tree"}]},{"name":"@rest","containerName":null,"kind":13,"line":233},{"line":234,"kind":13,"name":"$self","containerName":null},{"containerName":"main::","name":"_print","line":234,"kind":12},{"kind":13,"line":234,"containerName":null,"name":"$_"},{"name":"next_tree","range":{"end":{"line":253,"character":9999},"start":{"line":250,"character":0}},"kind":12,"line":250,"children":[{"kind":13,"line":251,"name":"$self","definition":"my","containerName":"next_tree","localvar":"my"},{"line":251,"kind":13,"containerName":"next_tree","name":"@args"},{"containerName":"next_tree","name":"$self","line":252,"kind":13},{"name":"throw_not_implemented","containerName":"next_tree","kind":12,"line":252}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"next_tree($self,@args)","documentation":"","parameters":[{"label":"$self"},{"label":"@args"}]}},{"line":265,"children":[{"localvar":"my","containerName":"name_length","name":"$self","definition":"my","line":266,"kind":13},{"line":266,"kind":13,"containerName":"name_length","name":"$val"},{"kind":13,"line":267,"name":"$self","containerName":"name_length"},{"line":267,"kind":13,"name":"$val","containerName":"name_length"},{"kind":13,"line":267,"name":"$val","containerName":"name_length"},{"line":268,"kind":13,"containerName":"name_length","name":"$self"}],"kind":12,"detail":"($self,$val)","signature":{"label":"name_length($self,$val)","documentation":"","parameters":[{"label":"$self"},{"label":"$val"}]},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":265},"end":{"character":9999,"line":269}},"name":"name_length"}]}