{"version":5,"vars":[{"name":"base","containerName":"","line":89,"kind":2},{"name":"_initialize","range":{"start":{"character":0,"line":91},"end":{"character":9999,"line":95}},"definition":"sub","containerName":"main::","signature":{"label":"_initialize($self,%args)","documentation":"","parameters":[{"label":"$self"},{"label":"%args"}]},"detail":"($self,%args)","kind":12,"children":[{"containerName":"_initialize","definition":"my","name":"$self","localvar":"my","kind":13,"line":92},{"containerName":"_initialize","name":"%args","line":92,"kind":13},{"kind":13,"line":93,"name":"$args","containerName":"_initialize"},{"line":94,"kind":13,"name":"$self","containerName":"_initialize"},{"name":"%args","containerName":"_initialize","kind":13,"line":94}],"line":91},{"containerName":"_initialize","name":"SUPER","line":94,"kind":12},{"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: nhx.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO::nhx\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Aaron Mackey <amackey@virginia.edu>\n#\n# Copyright Aaron Mackey\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO::nhx - TreeIO implementation for parsing \n    Newick/New Hampshire eXtendend (NHX) format.\n\n=head1 SYNOPSIS\n\n  # do not use this module directly\n  use Bio::TreeIO;\n  my $treeio = Bio::TreeIO->new(-format => 'nhx', -file => 'tree.dnd');\n  my $tree = $treeio->next_tree;\n\n=head1 DESCRIPTION\n\nThis module handles parsing and writing of Newick/New Hampshire eXtended (NHX) format.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted viax the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey\n\nEmail amackey-at-virginia.edu\n\n=head1 CONTRIBUTORS\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO::nhx;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Tree::NodeNHX;\nuse Bio::Event::EventGeneratorI;\n#use XML::Handler::Subs;\n\n\nuse base qw(Bio::TreeIO);\n\nsub _initialize {\n  my($self, %args) = @_;\n  $args{-nodetype} ||= 'Bio::Tree::NodeNHX';\n  $self->SUPER::_initialize(%args);\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $treeio->next_tree\n Function: Gets the next tree in the stream\n Returns : Bio::Tree::TreeI\n Args    : none","parameters":[{"label":"$self"}],"label":"next_tree($self)"},"detail":"($self)","kind":12,"children":[{"localvar":"my","containerName":"next_tree","name":"$self","definition":"my","line":109,"kind":13},{"name":"$self","containerName":"next_tree","line":111,"kind":13},{"kind":12,"line":111,"name":"_readline","containerName":"next_tree"},{"containerName":"next_tree","name":"$self","line":113,"kind":13},{"line":113,"kind":12,"containerName":"next_tree","name":"debug"},{"containerName":"next_tree","definition":"my","name":"$chars","localvar":"my","kind":13,"line":114},{"containerName":"next_tree","name":"$self","kind":13,"line":115},{"kind":12,"line":115,"containerName":"next_tree","name":"_eventHandler"},{"line":115,"kind":12,"name":"start_document","containerName":"next_tree"},{"line":116,"kind":13,"localvar":"my","definition":"my","name":"$prev_event","containerName":"next_tree"},{"containerName":"next_tree","name":"$lastevent","kind":13,"line":116},{"line":116,"kind":13,"containerName":"next_tree","name":"$last_leaf_event"},{"line":117,"kind":13,"localvar":"my","containerName":"next_tree","definition":"my","name":"@ch"},{"line":118,"kind":13,"localvar":"my","name":"$ch","definition":"my","containerName":"next_tree"},{"line":118,"kind":13,"containerName":"next_tree","name":"@ch"},{"containerName":"next_tree","name":"$ch","line":119,"kind":13},{"containerName":"next_tree","name":"$self","kind":13,"line":120},{"containerName":"next_tree","name":"_eventHandler","kind":12,"line":120},{"kind":12,"line":120,"name":"in_element","containerName":"next_tree"},{"line":121,"kind":13,"name":"$self","containerName":"next_tree"},{"name":"_eventHandler","containerName":"next_tree","line":121,"kind":12},{"containerName":"next_tree","name":"end_element","kind":12,"line":121},{"line":122,"kind":13,"name":"$self","containerName":"next_tree"},{"kind":12,"line":122,"name":"_eventHandler","containerName":"next_tree"},{"containerName":"next_tree","name":"end_document","kind":12,"line":122},{"line":123,"kind":13,"containerName":"next_tree","name":"$ch"},{"name":"$chars","containerName":"next_tree","kind":13,"line":124},{"line":125,"kind":13,"name":"$lastevent","containerName":"next_tree"},{"name":"$self","containerName":"next_tree","line":126,"kind":13},{"name":"_eventHandler","containerName":"next_tree","line":126,"kind":12},{"line":126,"kind":12,"name":"start_element","containerName":"next_tree"},{"name":"$self","containerName":"next_tree","line":127,"kind":13},{"kind":12,"line":127,"containerName":"next_tree","name":"_eventHandler"},{"line":127,"kind":12,"name":"characters","containerName":"next_tree"},{"line":127,"kind":13,"containerName":"next_tree","name":"$chars"},{"containerName":"next_tree","name":"$self","kind":13,"line":128},{"line":128,"kind":12,"containerName":"next_tree","name":"_eventHandler"},{"containerName":"next_tree","name":"end_element","line":128,"kind":12},{"name":"$lastevent","containerName":"next_tree","line":129,"kind":13},{"line":129,"kind":13,"name":"$prev_event","containerName":"next_tree"},{"containerName":"next_tree","name":"$self","line":131,"kind":13},{"kind":12,"line":131,"name":"debug","containerName":"next_tree"},{"name":"$self","containerName":"next_tree","kind":13,"line":132},{"kind":12,"line":132,"name":"_eventHandler","containerName":"next_tree"},{"line":132,"kind":12,"containerName":"next_tree","name":"start_element"},{"containerName":"next_tree","name":"$self","kind":13,"line":133},{"containerName":"next_tree","name":"_eventHandler","kind":12,"line":133},{"line":133,"kind":12,"name":"start_element","containerName":"next_tree"},{"containerName":"next_tree","name":"$self","kind":13,"line":134},{"containerName":"next_tree","name":"_eventHandler","line":134,"kind":12},{"kind":12,"line":134,"containerName":"next_tree","name":"characters"},{"containerName":"next_tree","name":"$chars","kind":13,"line":134},{"containerName":"next_tree","name":"$self","kind":13,"line":135},{"line":135,"kind":12,"containerName":"next_tree","name":"_eventHandler"},{"line":135,"kind":12,"name":"end_element","containerName":"next_tree"},{"line":138,"kind":13,"containerName":"next_tree","name":"$self"},{"line":138,"kind":12,"name":"_eventHandler","containerName":"next_tree"},{"line":138,"kind":12,"name":"start_element","containerName":"next_tree"},{"kind":13,"line":140,"containerName":"next_tree","definition":"my","name":"$leafstatus","localvar":"my"},{"line":140,"kind":13,"name":"$last_leaf_event","containerName":"next_tree"},{"containerName":"next_tree","name":"$self","kind":13,"line":141},{"containerName":"next_tree","name":"_eventHandler","kind":12,"line":141},{"kind":12,"line":141,"name":"start_element","containerName":"next_tree"},{"name":"$self","containerName":"next_tree","line":142,"kind":13},{"line":142,"kind":12,"name":"_eventHandler","containerName":"next_tree"},{"line":142,"kind":12,"name":"characters","containerName":"next_tree"},{"containerName":"next_tree","name":"$leafstatus","line":142,"kind":13},{"name":"$self","containerName":"next_tree","line":143,"kind":13},{"name":"_eventHandler","containerName":"next_tree","line":143,"kind":12},{"kind":12,"line":143,"name":"end_element","containerName":"next_tree"},{"line":144,"kind":13,"name":"$chars","containerName":"next_tree"},{"line":146,"kind":13,"containerName":"next_tree","name":"$self"},{"kind":12,"line":146,"containerName":"next_tree","name":"_eventHandler"},{"name":"start_element","containerName":"next_tree","kind":12,"line":146},{"kind":13,"line":147,"containerName":"next_tree","name":"$ch"},{"name":"$chars","containerName":"next_tree","line":148,"kind":13},{"kind":13,"line":149,"containerName":"next_tree","name":"$self"},{"kind":12,"line":149,"name":"_eventHandler","containerName":"next_tree"},{"name":"start_element","containerName":"next_tree","line":149,"kind":12},{"name":"$ch","containerName":"next_tree","kind":13,"line":150},{"kind":13,"line":151,"containerName":"next_tree","name":"$chars"},{"name":"$lastevent","containerName":"next_tree","line":152,"kind":13},{"kind":13,"line":153,"containerName":"next_tree","name":"$self"},{"kind":12,"line":153,"containerName":"next_tree","name":"_eventHandler"},{"name":"within_element","containerName":"next_tree","line":153,"kind":12},{"name":"$self","containerName":"next_tree","kind":13,"line":154},{"kind":12,"line":154,"name":"_eventHandler","containerName":"next_tree"},{"kind":12,"line":154,"name":"start_element","containerName":"next_tree"},{"line":155,"kind":13,"name":"$self","containerName":"next_tree"},{"containerName":"next_tree","name":"_eventHandler","line":155,"kind":12},{"name":"characters","containerName":"next_tree","kind":12,"line":155},{"name":"$chars","containerName":"next_tree","line":155,"kind":13},{"name":"$self","containerName":"next_tree","line":156,"kind":13},{"line":156,"kind":12,"name":"_eventHandler","containerName":"next_tree"},{"name":"end_element","containerName":"next_tree","line":156,"kind":12},{"line":158,"kind":13,"containerName":"next_tree","name":"$self"},{"kind":12,"line":158,"containerName":"next_tree","name":"throw"},{"kind":13,"line":161,"containerName":"next_tree","name":"$self"},{"kind":12,"line":161,"name":"debug","containerName":"next_tree"},{"name":"$self","containerName":"next_tree","kind":13,"line":162},{"line":162,"kind":12,"name":"_eventHandler","containerName":"next_tree"},{"kind":12,"line":162,"name":"start_element","containerName":"next_tree"},{"name":"$self","containerName":"next_tree","kind":13,"line":163},{"kind":12,"line":163,"name":"_eventHandler","containerName":"next_tree"},{"kind":12,"line":163,"containerName":"next_tree","name":"start_element"},{"name":"$self","containerName":"next_tree","kind":13,"line":164},{"name":"_eventHandler","containerName":"next_tree","kind":12,"line":164},{"line":164,"kind":12,"containerName":"next_tree","name":"characters"},{"kind":13,"line":164,"containerName":"next_tree","name":"$chars"},{"line":165,"kind":13,"containerName":"next_tree","name":"$self"},{"name":"_eventHandler","containerName":"next_tree","kind":12,"line":165},{"line":165,"kind":12,"containerName":"next_tree","name":"end_element"},{"name":"$lastevent","containerName":"next_tree","kind":13,"line":167},{"kind":13,"line":168,"name":"$self","containerName":"next_tree"},{"kind":12,"line":168,"containerName":"next_tree","name":"_eventHandler"},{"line":168,"kind":12,"name":"start_element","containerName":"next_tree"},{"line":175,"kind":13,"localvar":"my","definition":"my","name":"$leafstatus","containerName":"next_tree"},{"line":175,"kind":13,"name":"$last_leaf_event","containerName":"next_tree"},{"kind":13,"line":176,"name":"$self","containerName":"next_tree"},{"name":"_eventHandler","containerName":"next_tree","kind":12,"line":176},{"line":176,"kind":12,"name":"start_element","containerName":"next_tree"},{"kind":13,"line":177,"name":"$self","containerName":"next_tree"},{"containerName":"next_tree","name":"_eventHandler","line":177,"kind":12},{"name":"characters","containerName":"next_tree","kind":12,"line":177},{"kind":13,"line":177,"containerName":"next_tree","name":"$leafstatus"},{"kind":13,"line":178,"containerName":"next_tree","name":"$self"},{"containerName":"next_tree","name":"_eventHandler","kind":12,"line":178},{"name":"end_element","containerName":"next_tree","line":178,"kind":12},{"containerName":"next_tree","name":"$self","line":180,"kind":13},{"kind":12,"line":180,"containerName":"next_tree","name":"_eventHandler"},{"containerName":"next_tree","name":"end_element","kind":12,"line":180},{"line":181,"kind":13,"name":"$self","containerName":"next_tree"},{"containerName":"next_tree","name":"_eventHandler","line":181,"kind":12},{"line":181,"kind":12,"containerName":"next_tree","name":"end_element"},{"name":"$chars","containerName":"next_tree","line":182,"kind":13},{"kind":13,"line":183,"containerName":"next_tree","name":"$last_leaf_event"},{"containerName":"next_tree","name":"$ch","line":183,"kind":13},{"containerName":"next_tree","name":"$ch","kind":13,"line":185},{"line":186,"kind":13,"containerName":"next_tree","name":"$chars"},{"line":187,"kind":13,"containerName":"next_tree","name":"$lastevent"},{"name":"$self","containerName":"next_tree","line":188,"kind":13},{"containerName":"next_tree","name":"_eventHandler","kind":12,"line":188},{"name":"start_element","containerName":"next_tree","line":188,"kind":12},{"line":189,"kind":13,"containerName":"next_tree","name":"$self"},{"kind":12,"line":189,"containerName":"next_tree","name":"_eventHandler"},{"name":"characters","containerName":"next_tree","kind":12,"line":189},{"containerName":"next_tree","name":"$chars","line":189,"kind":13},{"containerName":"next_tree","name":"$self","kind":13,"line":190},{"containerName":"next_tree","name":"_eventHandler","line":190,"kind":12},{"containerName":"next_tree","name":"end_element","line":190,"kind":12},{"line":191,"kind":13,"name":"$lastevent","containerName":"next_tree"},{"line":191,"kind":13,"name":"$prev_event","containerName":"next_tree"},{"name":"$self","containerName":"next_tree","kind":13,"line":193},{"containerName":"next_tree","name":"debug","line":193,"kind":12},{"containerName":"next_tree","name":"$self","line":194,"kind":13},{"line":194,"kind":12,"name":"_eventHandler","containerName":"next_tree"},{"kind":12,"line":194,"name":"start_element","containerName":"next_tree"},{"kind":13,"line":195,"name":"$self","containerName":"next_tree"},{"containerName":"next_tree","name":"_eventHandler","line":195,"kind":12},{"containerName":"next_tree","name":"start_element","kind":12,"line":195},{"kind":13,"line":196,"name":"$self","containerName":"next_tree"},{"containerName":"next_tree","name":"_eventHandler","kind":12,"line":196},{"name":"characters","containerName":"next_tree","kind":12,"line":196},{"kind":13,"line":196,"name":"$chars","containerName":"next_tree"},{"kind":13,"line":197,"name":"$self","containerName":"next_tree"},{"kind":12,"line":197,"name":"_eventHandler","containerName":"next_tree"},{"name":"end_element","containerName":"next_tree","line":197,"kind":12},{"containerName":"next_tree","name":"$lastevent","kind":13,"line":199},{"name":"$self","containerName":"next_tree","kind":13,"line":200},{"line":200,"kind":12,"name":"_eventHandler","containerName":"next_tree"},{"kind":12,"line":200,"name":"start_element","containerName":"next_tree"},{"kind":13,"line":202,"name":"$self","containerName":"next_tree"},{"kind":12,"line":202,"name":"_eventHandler","containerName":"next_tree"},{"kind":12,"line":202,"name":"end_element","containerName":"next_tree"},{"kind":13,"line":203,"name":"$chars","containerName":"next_tree"},{"name":"$last_leaf_event","containerName":"next_tree","line":204,"kind":13},{"kind":13,"line":204,"name":"$ch","containerName":"next_tree"},{"kind":13,"line":205,"name":"$ch","containerName":"next_tree"},{"containerName":"next_tree","name":"$self","kind":13,"line":206},{"name":"_eventHandler","containerName":"next_tree","kind":12,"line":206},{"containerName":"next_tree","name":"within_element","kind":12,"line":206},{"line":207,"kind":13,"name":"$lastevent","containerName":"next_tree"},{"kind":13,"line":208,"name":"$self","containerName":"next_tree"},{"kind":12,"line":208,"name":"_eventHandler","containerName":"next_tree"},{"kind":12,"line":208,"name":"start_element","containerName":"next_tree"},{"name":"$self","containerName":"next_tree","line":209,"kind":13},{"containerName":"next_tree","name":"_eventHandler","line":209,"kind":12},{"containerName":"next_tree","name":"characters","line":209,"kind":12},{"containerName":"next_tree","name":"$chars","kind":13,"line":209},{"name":"$self","containerName":"next_tree","kind":13,"line":210},{"name":"_eventHandler","containerName":"next_tree","kind":12,"line":210},{"line":210,"kind":12,"name":"end_element","containerName":"next_tree"},{"kind":13,"line":211,"containerName":"next_tree","name":"$chars"},{"line":213,"kind":13,"containerName":"next_tree","name":"$chars"},{"containerName":"next_tree","name":"$chars","line":214,"kind":13},{"name":"$self","containerName":"next_tree","kind":13,"line":216},{"name":"throw","containerName":"next_tree","line":216,"kind":12},{"containerName":"next_tree","name":"$lastevent","kind":13,"line":219},{"line":220,"kind":13,"name":"$self","containerName":"next_tree"},{"line":220,"kind":12,"name":"debug","containerName":"next_tree"},{"kind":13,"line":221,"name":"$self","containerName":"next_tree"},{"kind":12,"line":221,"containerName":"next_tree","name":"_eventHandler"},{"containerName":"next_tree","name":"start_element","line":221,"kind":12},{"name":"$self","containerName":"next_tree","line":222,"kind":13},{"name":"_eventHandler","containerName":"next_tree","kind":12,"line":222},{"kind":12,"line":222,"containerName":"next_tree","name":"start_element"},{"kind":13,"line":223,"containerName":"next_tree","name":"$self"},{"containerName":"next_tree","name":"_eventHandler","kind":12,"line":223},{"line":223,"kind":12,"containerName":"next_tree","name":"characters"},{"line":223,"kind":13,"name":"$chars","containerName":"next_tree"},{"line":224,"kind":13,"containerName":"next_tree","name":"$self"},{"name":"_eventHandler","containerName":"next_tree","kind":12,"line":224},{"line":224,"kind":12,"containerName":"next_tree","name":"end_element"},{"kind":13,"line":225,"name":"$chars","containerName":"next_tree"},{"containerName":"next_tree","name":"$ch","line":227,"kind":13},{"line":228,"kind":13,"name":"$self","containerName":"next_tree"},{"name":"_eventHandler","containerName":"next_tree","kind":12,"line":228},{"line":228,"kind":12,"containerName":"next_tree","name":"within_element"},{"line":229,"kind":13,"containerName":"next_tree","name":"$self"},{"kind":12,"line":229,"name":"_eventHandler","containerName":"next_tree"},{"line":229,"kind":12,"name":"start_element","containerName":"next_tree"},{"containerName":"next_tree","name":"$self","kind":13,"line":230},{"name":"_eventHandler","containerName":"next_tree","line":230,"kind":12},{"kind":12,"line":230,"name":"characters","containerName":"next_tree"},{"name":"$chars","containerName":"next_tree","kind":13,"line":230},{"line":231,"kind":13,"name":"$self","containerName":"next_tree"},{"name":"_eventHandler","containerName":"next_tree","line":231,"kind":12},{"kind":12,"line":231,"containerName":"next_tree","name":"end_element"},{"name":"$chars","containerName":"next_tree","kind":13,"line":232},{"containerName":"next_tree","name":"$chars","line":234,"kind":13},{"kind":13,"line":234,"name":"$ch","containerName":"next_tree"},{"kind":13,"line":236,"name":"$ch","containerName":"next_tree"},{"line":237,"kind":13,"name":"$self","containerName":"next_tree"},{"name":"_eventHandler","containerName":"next_tree","line":237,"kind":12},{"kind":12,"line":237,"name":"within_element","containerName":"next_tree"},{"kind":13,"line":238,"containerName":"next_tree","name":"$lastevent"},{"kind":13,"line":239,"name":"$self","containerName":"next_tree"},{"kind":12,"line":239,"name":"_eventHandler","containerName":"next_tree"},{"name":"start_element","containerName":"next_tree","line":239,"kind":12},{"kind":13,"line":240,"containerName":"next_tree","name":"$self"},{"name":"_eventHandler","containerName":"next_tree","kind":12,"line":240},{"containerName":"next_tree","name":"characters","kind":12,"line":240},{"kind":13,"line":240,"name":"$chars","containerName":"next_tree"},{"kind":13,"line":241,"containerName":"next_tree","name":"$self"},{"containerName":"next_tree","name":"_eventHandler","kind":12,"line":241},{"containerName":"next_tree","name":"end_element","line":241,"kind":12},{"line":242,"kind":13,"name":"$chars","containerName":"next_tree"},{"containerName":"next_tree","name":"$self","kind":13,"line":243},{"line":243,"kind":12,"containerName":"next_tree","name":"_eventHandler"},{"kind":12,"line":243,"containerName":"next_tree","name":"end_element"},{"name":"$chars","containerName":"next_tree","kind":13,"line":245},{"containerName":"next_tree","name":"$self","line":246,"kind":13},{"kind":12,"line":246,"name":"throw","containerName":"next_tree"},{"line":248,"kind":13,"name":"$chars","containerName":"next_tree"},{"name":"$self","containerName":"next_tree","line":249,"kind":13},{"containerName":"next_tree","name":"_eventHandler","line":249,"kind":12},{"kind":12,"line":249,"containerName":"next_tree","name":"end_element"},{"name":"$chars","containerName":"next_tree","line":252,"kind":13},{"kind":13,"line":252,"name":"$ch","containerName":"next_tree"},{"kind":13,"line":256,"containerName":"next_tree","name":"$chars"},{"name":"$ch","containerName":"next_tree","line":256,"kind":13},{"name":"$prev_event","containerName":"next_tree","kind":13,"line":259},{"name":"$lastevent","containerName":"next_tree","line":259,"kind":13},{"containerName":"next_tree","name":"$lastevent","line":260,"kind":13},{"name":"$ch","containerName":"next_tree","line":260,"kind":13}],"line":108,"name":"next_tree","range":{"end":{"character":9999,"line":263},"start":{"character":0,"line":108}}},{"name":"Name","line":126,"kind":12},{"name":"Name","kind":12,"line":128},{"name":"Name","line":138,"kind":12},{"kind":12,"line":146,"name":"Name"},{"kind":12,"line":208,"name":"Name"},{"line":210,"kind":12,"name":"Name"},{"name":"Name","line":229,"kind":12},{"line":231,"kind":12,"name":"Name"},{"name":"Name","line":239,"kind":12},{"line":241,"kind":12,"name":"Name"},{"line":243,"kind":12,"name":"Name"},{"kind":12,"line":249,"name":"Name"},{"range":{"start":{"line":275,"character":0},"end":{"character":9999,"line":295}},"name":"write_tree","detail":"($self,@trees)","signature":{"label":"write_tree($self,@trees)","parameters":[{"label":"$self"},{"label":"@trees"}],"documentation":"1;\n# $Id: nhx.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO::nhx\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Aaron Mackey <amackey@virginia.edu>\n#\n# Copyright Aaron Mackey\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO::nhx - TreeIO implementation for parsing \n    Newick/New Hampshire eXtendend (NHX) format.\n\n=head1 SYNOPSIS\n\n  # do not use this module directly\n  use Bio::TreeIO;\n  my $treeio = Bio::TreeIO->new(-format => 'nhx', -file => 'tree.dnd');\n  my $tree = $treeio->next_tree;\n\n=head1 DESCRIPTION\n\nThis module handles parsing and writing of Newick/New Hampshire eXtended (NHX) format.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted viax the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey\n\nEmail amackey-at-virginia.edu\n\n=head1 CONTRIBUTORS\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO::nhx;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Tree::NodeNHX;\nuse Bio::Event::EventGeneratorI;\n#use XML::Handler::Subs;\n\n\nuse base qw(Bio::TreeIO);\n\nsub _initialize {\n  my($self, %args) = @_;\n  $args{-nodetype} ||= 'Bio::Tree::NodeNHX';\n  $self->SUPER::_initialize(%args);\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $treeio->next_tree\n Function: Gets the next tree in the stream\n Returns : Bio::Tree::TreeI\n Args    : none\n\n\n\nsub next_tree{\n    my ($self) = @_;\n    local $/ = \";\\n\";\n    return unless $_ = $self->_readline;\n    s/\\s+//g;\n    $self->debug(\"entry is $_\\n\");\n    my $chars = '';\n    $self->_eventHandler->start_document;\n    my ($prev_event,$lastevent,$last_leaf_event) = ('','','');\n    my @ch = split(//, $_);\n    foreach my $ch  (@ch) {\n\tif( $ch eq ';' ) { \t   \n\t    $self->_eventHandler->in_element('node') && \n\t\t$self->_eventHandler->end_element( {'Name' => 'node'});\n\t    return $self->_eventHandler->end_document;\n\t} elsif ($ch eq '[') {\n\t    if ( length $chars ) {\n\t\tif ( $lastevent eq ':' ) {\n\t\t    $self->_eventHandler->start_element( { Name => 'branch_length' } );\n\t\t    $self->_eventHandler->characters($chars);\n\t\t    $self->_eventHandler->end_element( { Name => 'branch_length' });\n\t\t    $lastevent = $prev_event;\n\t\t} else {\n\t\t    $self->debug(\"id with no branchlength is $chars\\n\");\n\t\t    $self->_eventHandler->start_element( { 'Name' => 'node' } );\n\t\t    $self->_eventHandler->start_element( { 'Name' => 'id' } );\n\t\t    $self->_eventHandler->characters($chars);\n\t\t    $self->_eventHandler->end_element( { 'Name' => 'id' } );\t\t   \n\t\t}\n\t    } else {\n\t\t$self->_eventHandler->start_element( { Name => 'node' } );\n\t    }\n\t    my $leafstatus = ( $last_leaf_event ne ')' ) ? 1 : 0;\n\t    $self->_eventHandler->start_element({'Name' => 'leaf'});\n\t    $self->_eventHandler->characters($leafstatus);\n\t    $self->_eventHandler->end_element({'Name' => 'leaf'});\t   \n\t    $chars = '';\n\t    \n\t    $self->_eventHandler->start_element( { Name => 'nhx_tag' });\n\t} elsif( $ch eq '(' ) {\n\t    $chars = '';\n\t    $self->_eventHandler->start_element( {'Name' => 'tree'} );\n\t} elsif($ch eq ')' ) {\n\t    if( length $chars ) {\n\t\tif( $lastevent eq ':') {\n\t\t    unless ($self->_eventHandler->within_element('nhx_tag')) {\n\t\t\t$self->_eventHandler->start_element( { 'Name' => 'branch_length'});\n\t\t\t$self->_eventHandler->characters($chars);\n\t\t\t$self->_eventHandler->end_element( {'Name' => 'branch_length'});\n\t\t    } else {\n\t\t\t$self->throw(\"malformed input; end of node ) before ] found\");\n\t\t    }\n\t\t} else { \n\t\t    $self->debug(\"id with no branchlength is '$chars'\\n\");\n\t\t    $self->_eventHandler->start_element( { 'Name' => 'node' } );\n\t\t    $self->_eventHandler->start_element( { 'Name' => 'id' } );\n\t\t    $self->_eventHandler->characters($chars);\n\t\t    $self->_eventHandler->end_element( { 'Name' => 'id' } );\n\t\t}\n\t    } elsif ( $lastevent ne ']' ) {\n\t\t$self->_eventHandler->start_element( {'Name' => 'node'} );\n\t    }\n\t    # problem here is that we need to detect if we coming up on\n\t    # the end of a leaf node or a labeled internal node\n\t    # each can have [] and each can have :, but only leaves are \n\t    # NOT proceeded by a ')'\n\t    # the [] events throw us off\n\t    my $leafstatus = ( $last_leaf_event ne ')' ) ? 1 : 0;\n\t    $self->_eventHandler->start_element({'Name' => 'leaf'});\n\t    $self->_eventHandler->characters($leafstatus);\n\t    $self->_eventHandler->end_element({'Name' => 'leaf'});\t   \n\t    \n\t    $self->_eventHandler->end_element( {'Name' => 'node'} );\n\t    $self->_eventHandler->end_element( {'Name' => 'tree'} );\n\t    $chars = '';\n\t    $last_leaf_event = $ch;\n\n\t} elsif ( $ch eq ',' ) {\n\t    if( length $chars ) {\n\t\tif( $lastevent eq ':' ) {\n\t\t    $self->_eventHandler->start_element( { 'Name' => 'branch_length'});\n\t\t    $self->_eventHandler->characters($chars);\n\t\t    $self->_eventHandler->end_element( {'Name' => 'branch_length'});\n\t\t    $lastevent = $prev_event;\n\t\t} else { \n\t\t    $self->debug(\"id with no branchlength is $chars, last event was $lastevent\\n\");\n\t\t    $self->_eventHandler->start_element( { 'Name' => 'node' } );\n\t\t    $self->_eventHandler->start_element( { 'Name' => 'id' } );\n\t\t    $self->_eventHandler->characters($chars);\n\t\t    $self->_eventHandler->end_element( { 'Name' => 'id' } );\n\t\t}   \n\t    } elsif ( $lastevent ne ']' ) {\n\t\t$self->_eventHandler->start_element( { 'Name' => 'node' } );\n\t    }\n\t    $self->_eventHandler->end_element( {'Name' => 'node'} );\n\t    $chars = '';\n\t    $last_leaf_event = $ch;\n\t} elsif( $ch eq ':' ) {\n\t    if ($self->_eventHandler->within_element('nhx_tag')) {\n\t\tif ($lastevent eq '=') {\n\t\t    $self->_eventHandler->start_element( { Name => 'tag_value' } );\n\t\t    $self->_eventHandler->characters($chars);\n\t\t    $self->_eventHandler->end_element( { Name => 'tag_value' } );\n\t\t    $chars = '';\n\t\t} else {\n\t\t    if ($chars eq '&&NHX') {\n\t\t\t$chars = ''; # get rid of &&NHX:\n\t\t    } else {\n\t\t\t$self->throw(\"Unrecognized, non \\&\\&NHX string: >>$chars<<; lastevent is $lastevent\");\n\t\t    }\n\t\t}\n\t    } elsif ($lastevent ne ']') {\n\t\t$self->debug(\"id with a branchlength coming is $chars\\n\");\n\t\t$self->_eventHandler->start_element( { 'Name' => 'node' } );\n\t\t$self->_eventHandler->start_element( { 'Name' => 'id' } );\n\t\t$self->_eventHandler->characters($chars);\n\t\t$self->_eventHandler->end_element( { 'Name' => 'id' } );\n\t\t$chars = '';\n\t    }\n\t} elsif ( $ch eq '=' ) {\n\t    if ($self->_eventHandler->within_element('nhx_tag')) {\n\t\t$self->_eventHandler->start_element( { Name => 'tag_name' } );\n\t\t$self->_eventHandler->characters($chars);\n\t\t$self->_eventHandler->end_element( { Name => 'tag_name' } );\n\t\t$chars = '';\n\t    } else {\n\t\t$chars .= $ch;\n\t    }\n\t} elsif ( $ch eq ']' ) {\n\t    if ($self->_eventHandler->within_element('nhx_tag') ) {\n\t\tif( $lastevent eq '=' ) {\n\t\t    $self->_eventHandler->start_element( { Name => 'tag_value' } );\n\t\t    $self->_eventHandler->characters($chars);\n\t\t    $self->_eventHandler->end_element( { Name => 'tag_value' } );\t\t    \n\t\t    $chars = '';\n\t\t    $self->_eventHandler->end_element( { Name => 'nhx_tag' } );\n\t\t} else {\n\t\t    if ($chars ne '&&NHX') {\n\t\t\t$self->throw(\"Unrecognized, non \\&\\&NHX string: >>$chars<<; lastevent is $lastevent\");\n\t\t    }\n\t\t    $chars = '';\n\t\t    $self->_eventHandler->end_element( { Name => 'nhx_tag' } );\n\t\t}\n\t    } else {\n\t\t$chars .= $ch;\n\t\tnext;\n\t    }\n\t} else { \t   \n\t    $chars .= $ch;\n\t    next;\n\t}\n\t$prev_event = $lastevent;\n\t$lastevent = $ch;\n    }       \n    return;\n}\n\n=head2 write_tree\n\n Title   : write_tree\n Usage   : $treeio->write_tree($tree);\n Function: Write a tree out to data stream in nhx format\n Returns : none\n Args    : Bio::Tree::TreeI object"},"containerName":"main::","definition":"sub","line":275,"children":[{"kind":13,"line":276,"name":"$self","definition":"my","containerName":"write_tree","localvar":"my"},{"name":"@trees","containerName":"write_tree","line":276,"kind":13},{"line":277,"kind":13,"localvar":"my","containerName":"write_tree","name":"$nl","definition":"my"},{"name":"$self","containerName":"write_tree","line":277,"kind":13},{"kind":12,"line":277,"name":"newline_each_node","containerName":"write_tree"},{"kind":13,"line":278,"name":"$tree","definition":"my","containerName":"write_tree","localvar":"my"},{"kind":13,"line":278,"containerName":"write_tree","name":"@trees"},{"kind":13,"line":279,"containerName":"write_tree","name":"@data","definition":"my","localvar":"my"},{"line":279,"kind":13,"name":"$tree","containerName":"write_tree"},{"containerName":"write_tree","name":"get_root_node","kind":12,"line":279},{"kind":13,"line":279,"name":"$nl","containerName":"write_tree"},{"containerName":"write_tree","name":"$data","line":283,"kind":13},{"kind":13,"line":284,"containerName":"write_tree","name":"$data"},{"line":286,"kind":13,"name":"$nl","containerName":"write_tree"},{"containerName":"write_tree","name":"$data","line":287,"kind":13},{"line":288,"kind":13,"containerName":"write_tree","name":"$self"},{"name":"_print","containerName":"write_tree","line":288,"kind":12},{"name":"@data","containerName":"write_tree","line":288,"kind":13},{"line":290,"kind":13,"name":"$self","containerName":"write_tree"},{"kind":12,"line":290,"name":"_print","containerName":"write_tree"},{"containerName":"write_tree","name":"@data","kind":13,"line":290},{"line":293,"kind":13,"containerName":"write_tree","name":"$self"},{"containerName":"write_tree","name":"flush","kind":12,"line":293},{"containerName":"write_tree","name":"$self","kind":13,"line":293},{"kind":12,"line":293,"containerName":"write_tree","name":"_flush_on_write"},{"kind":13,"line":293,"containerName":"write_tree","name":"$self"},{"kind":12,"line":293,"name":"_fh","containerName":"write_tree"}],"kind":12},{"name":"_write_tree_Helper","kind":12,"line":279},{"range":{"start":{"character":0,"line":297},"end":{"character":9999,"line":343}},"name":"_write_tree_Helper","signature":{"label":"_write_tree_Helper($node,$nl)","documentation":"","parameters":[{"label":"$node"},{"label":"$nl"}]},"detail":"($node,$nl)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":298,"containerName":"_write_tree_Helper","name":"$node","definition":"my","localvar":"my"},{"name":"$nl","containerName":"_write_tree_Helper","line":298,"kind":13},{"kind":13,"line":299,"containerName":"_write_tree_Helper","name":"$node"},{"line":301,"kind":13,"name":"$node","containerName":"_write_tree_Helper"},{"kind":13,"line":301,"name":"$node","containerName":"_write_tree_Helper"},{"localvar":"my","containerName":"_write_tree_Helper","definition":"my","name":"@data","line":302,"kind":13},{"kind":13,"line":304,"containerName":"_write_tree_Helper","definition":"my","name":"$n","localvar":"my"},{"kind":13,"line":304,"name":"$node","containerName":"_write_tree_Helper"},{"line":304,"kind":12,"containerName":"_write_tree_Helper","name":"each_Descendent"},{"name":"@data","containerName":"_write_tree_Helper","line":305,"kind":13},{"kind":13,"line":305,"containerName":"_write_tree_Helper","name":"$n"},{"line":305,"kind":13,"name":"$nl","containerName":"_write_tree_Helper"},{"line":308,"kind":13,"containerName":"_write_tree_Helper","name":"@data"},{"name":"$nl","containerName":"_write_tree_Helper","kind":13,"line":309},{"containerName":"_write_tree_Helper","name":"$data","line":310,"kind":13},{"line":310,"kind":13,"containerName":"_write_tree_Helper","name":"$data"},{"name":"$data","containerName":"_write_tree_Helper","line":311,"kind":13},{"kind":13,"line":313,"name":"$data","containerName":"_write_tree_Helper"},{"containerName":"_write_tree_Helper","name":"$data","line":313,"kind":13},{"containerName":"_write_tree_Helper","name":"$data","kind":13,"line":314},{"localvar":"my","definition":"my","name":"$id","containerName":"_write_tree_Helper","line":317,"kind":13},{"kind":13,"line":317,"containerName":"_write_tree_Helper","name":"$node"},{"line":317,"kind":12,"containerName":"_write_tree_Helper","name":"id"},{"name":"$data","containerName":"_write_tree_Helper","line":318,"kind":13},{"line":318,"kind":13,"containerName":"_write_tree_Helper","name":"$id"},{"containerName":"_write_tree_Helper","name":"$id","line":318,"kind":13},{"localvar":"my","containerName":"_write_tree_Helper","name":"$blen","definition":"my","line":319,"kind":13},{"containerName":"_write_tree_Helper","name":"$node","line":319,"kind":13},{"line":319,"kind":12,"name":"branch_length","containerName":"_write_tree_Helper"},{"kind":13,"line":320,"name":"$data","containerName":"_write_tree_Helper"},{"name":"$blen","containerName":"_write_tree_Helper","line":320,"kind":13},{"containerName":"_write_tree_Helper","name":"$blen","line":320,"kind":13},{"localvar":"my","definition":"my","name":"@tags","containerName":"_write_tree_Helper","line":323,"kind":13},{"line":323,"kind":13,"name":"$node","containerName":"_write_tree_Helper"},{"containerName":"_write_tree_Helper","name":"get_all_tags","line":323,"kind":12},{"name":"$node","containerName":"_write_tree_Helper","line":324,"kind":13},{"line":324,"kind":12,"containerName":"_write_tree_Helper","name":"ancestor"},{"kind":13,"line":324,"containerName":"_write_tree_Helper","name":"@tags"},{"containerName":"_write_tree_Helper","name":"$data","kind":13,"line":325},{"name":"$node","containerName":"_write_tree_Helper","kind":13,"line":327},{"line":327,"kind":12,"name":"get_tag_values","containerName":"_write_tree_Helper"},{"name":"@tags","containerName":"_write_tree_Helper","line":328,"kind":13},{"kind":13,"line":331,"containerName":"_write_tree_Helper","name":"$nl"},{"name":"$data","containerName":"_write_tree_Helper","kind":13,"line":332},{"line":332,"kind":13,"name":"$data","containerName":"_write_tree_Helper"},{"name":"$data","containerName":"_write_tree_Helper","line":333,"kind":13},{"containerName":"_write_tree_Helper","name":"$data","line":335,"kind":13},{"line":335,"kind":13,"name":"$data","containerName":"_write_tree_Helper"},{"line":336,"kind":13,"containerName":"_write_tree_Helper","name":"$data"},{"kind":13,"line":340,"containerName":"_write_tree_Helper","name":"@data"},{"name":"$node","containerName":"_write_tree_Helper","line":340,"kind":13},{"containerName":"_write_tree_Helper","name":"to_string","kind":12,"line":340},{"name":"@data","containerName":"_write_tree_Helper","line":342,"kind":13}],"line":297,"kind":12}]}