{"vars":[{"containerName":"","name":"base","kind":2,"line":88},{"signature":{"documentation":"1;\n# $Id: TreeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::TreeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::TreeI - A Tree object suitable for lots of things, designed\n  originally for Phylogenetic Trees.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Tree::TreeI somehow\n  # like from a TreeIO\n  my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n  my $tree   = $treeio->next_tree;\n  my @nodes  = $tree->get_nodes;\n  my @leaves = $tree->get_leaf_nodes;\n  my $root   = $tree->get_root_node;\n\n=head1 DESCRIPTION\n\nThis object holds a pointer to the Root of a Tree which is a\nBio::Tree::NodeI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey, amackey@virginia.edu\nElia Stupka,  elia@fugu-sg.org\nSendu Bala,   bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::TreeI;\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Tree::NodeI objects\n Returns : array of Tree::NodeI objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order","parameters":[{"label":"$self"}],"label":"get_nodes($self)"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"name":"$self","definition":"my","containerName":"get_nodes","localvar":"my","kind":13,"line":102},{"line":103,"kind":13,"name":"$self","containerName":"get_nodes"},{"containerName":"get_nodes","name":"throw_not_implemented","line":103,"kind":12}],"line":101,"kind":12,"range":{"end":{"character":9999,"line":104},"start":{"character":0,"line":101}},"name":"get_nodes"},{"children":[{"line":118,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"get_root_node"},{"name":"$self","containerName":"get_root_node","line":119,"kind":13},{"line":119,"kind":12,"containerName":"get_root_node","name":"throw_not_implemented"}],"line":117,"kind":12,"signature":{"label":"get_root_node($self)","documentation":"1;\n# $Id: TreeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::TreeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::TreeI - A Tree object suitable for lots of things, designed\n  originally for Phylogenetic Trees.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Tree::TreeI somehow\n  # like from a TreeIO\n  my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n  my $tree   = $treeio->next_tree;\n  my @nodes  = $tree->get_nodes;\n  my @leaves = $tree->get_leaf_nodes;\n  my $root   = $tree->get_root_node;\n\n=head1 DESCRIPTION\n\nThis object holds a pointer to the Root of a Tree which is a\nBio::Tree::NodeI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey, amackey@virginia.edu\nElia Stupka,  elia@fugu-sg.org\nSendu Bala,   bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::TreeI;\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Tree::NodeI objects\n Returns : array of Tree::NodeI objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Tree::NodeI object\n Args    : none","parameters":[{"label":"$self"}]},"detail":"($self)","definition":"sub","containerName":"main::","range":{"start":{"line":117,"character":0},"end":{"character":9999,"line":120}},"name":"get_root_node"},{"name":"number_nodes","range":{"start":{"line":132,"character":0},"end":{"line":139,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: TreeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::TreeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::TreeI - A Tree object suitable for lots of things, designed\n  originally for Phylogenetic Trees.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Tree::TreeI somehow\n  # like from a TreeIO\n  my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n  my $tree   = $treeio->next_tree;\n  my @nodes  = $tree->get_nodes;\n  my @leaves = $tree->get_leaf_nodes;\n  my $root   = $tree->get_root_node;\n\n=head1 DESCRIPTION\n\nThis object holds a pointer to the Root of a Tree which is a\nBio::Tree::NodeI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey, amackey@virginia.edu\nElia Stupka,  elia@fugu-sg.org\nSendu Bala,   bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::TreeI;\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Tree::NodeI objects\n Returns : array of Tree::NodeI objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Tree::NodeI object\n Args    : none\n\n\nsub get_root_node{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 number_nodes\n\n Title   : number_nodes\n Usage   : my $size = $tree->number_nodes\n Function: Find the number of nodes in the tree.\n Returns : int\n Args    : none","label":"number_nodes($self)"},"kind":12,"line":132,"children":[{"localvar":"my","containerName":"number_nodes","name":"$self","definition":"my","line":133,"kind":13},{"localvar":"my","containerName":"number_nodes","definition":"my","name":"$root","line":134,"kind":13},{"name":"$self","containerName":"number_nodes","line":134,"kind":13},{"kind":12,"line":134,"name":"get_root_node","containerName":"number_nodes"},{"containerName":"number_nodes","name":"$root","kind":13,"line":135},{"kind":13,"line":135,"containerName":"number_nodes","name":"$root"},{"name":"isa","containerName":"number_nodes","kind":12,"line":135},{"containerName":"number_nodes","name":"$root","kind":13,"line":136},{"line":136,"kind":12,"containerName":"number_nodes","name":"descendent_count"}]},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: TreeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::TreeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::TreeI - A Tree object suitable for lots of things, designed\n  originally for Phylogenetic Trees.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Tree::TreeI somehow\n  # like from a TreeIO\n  my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n  my $tree   = $treeio->next_tree;\n  my @nodes  = $tree->get_nodes;\n  my @leaves = $tree->get_leaf_nodes;\n  my $root   = $tree->get_root_node;\n\n=head1 DESCRIPTION\n\nThis object holds a pointer to the Root of a Tree which is a\nBio::Tree::NodeI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey, amackey@virginia.edu\nElia Stupka,  elia@fugu-sg.org\nSendu Bala,   bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::TreeI;\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Tree::NodeI objects\n Returns : array of Tree::NodeI objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Tree::NodeI object\n Args    : none\n\n\nsub get_root_node{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 number_nodes\n\n Title   : number_nodes\n Usage   : my $size = $tree->number_nodes\n Function: Find the number of nodes in the tree.\n Returns : int\n Args    : none\n\n\nsub number_nodes{\n   my ($self) = @_;\n   my $root = $self->get_root_node;\n   if( defined $root && $root->isa('Bio::Tree::NodeI'))  {\n       return ($root->descendent_count + 1);\n   }\n   return 0;\n}\n\n=head2 total_branch_length\n\n Title   : total_branch_length\n Usage   : my $size = $tree->total_branch_length\n Function: Returns the sum of the length of all branches\n Returns : integer\n Args    : none","label":"total_branch_length($self)"},"detail":"($self)","kind":12,"children":[{"name":"$self","definition":"my","containerName":"total_branch_length","localvar":"my","kind":13,"line":152},{"name":"$self","containerName":"total_branch_length","line":153,"kind":13},{"name":"throw_not_implemented","containerName":"total_branch_length","kind":12,"line":153}],"line":151,"name":"total_branch_length","range":{"end":{"character":9999,"line":154},"start":{"character":0,"line":151}}},{"kind":12,"line":169,"children":[{"definition":"my","name":"$self","containerName":"height","localvar":"my","kind":13,"line":170},{"containerName":"height","name":"$nodect","definition":"my","localvar":"my","kind":13,"line":171},{"containerName":"height","name":"$self","line":171,"kind":13},{"line":171,"kind":12,"name":"number_nodes","containerName":"height"},{"containerName":"height","name":"$nodect","kind":13,"line":172},{"name":"$nodect","containerName":"height","kind":13,"line":173}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"height($self)","documentation":"1;\n# $Id: TreeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::TreeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::TreeI - A Tree object suitable for lots of things, designed\n  originally for Phylogenetic Trees.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Tree::TreeI somehow\n  # like from a TreeIO\n  my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n  my $tree   = $treeio->next_tree;\n  my @nodes  = $tree->get_nodes;\n  my @leaves = $tree->get_leaf_nodes;\n  my $root   = $tree->get_root_node;\n\n=head1 DESCRIPTION\n\nThis object holds a pointer to the Root of a Tree which is a\nBio::Tree::NodeI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey, amackey@virginia.edu\nElia Stupka,  elia@fugu-sg.org\nSendu Bala,   bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::TreeI;\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Tree::NodeI objects\n Returns : array of Tree::NodeI objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Tree::NodeI object\n Args    : none\n\n\nsub get_root_node{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 number_nodes\n\n Title   : number_nodes\n Usage   : my $size = $tree->number_nodes\n Function: Find the number of nodes in the tree.\n Returns : int\n Args    : none\n\n\nsub number_nodes{\n   my ($self) = @_;\n   my $root = $self->get_root_node;\n   if( defined $root && $root->isa('Bio::Tree::NodeI'))  {\n       return ($root->descendent_count + 1);\n   }\n   return 0;\n}\n\n=head2 total_branch_length\n\n Title   : total_branch_length\n Usage   : my $size = $tree->total_branch_length\n Function: Returns the sum of the length of all branches\n Returns : integer\n Args    : none\n\n\nsub total_branch_length {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 height\n\n Title   : height\n Usage   : my $height = $tree->height\n Function: Gets the height of tree - this LOG_2($number_nodes)\n           WARNING: this is only true for strict binary trees.  The TreeIO\n           system is capable of building non-binary trees, for which this\n           method will currently return an incorrect value!!\n Returns : integer\n Args    : none","parameters":[{"label":"$self"}]},"name":"height","range":{"start":{"character":0,"line":169},"end":{"line":174,"character":9999}}},{"range":{"start":{"line":187,"character":0},"end":{"character":9999,"line":190}},"name":"id","children":[{"line":188,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"id"},{"name":"@args","containerName":"id","line":188,"kind":13},{"containerName":"id","name":"$self","line":189,"kind":13},{"name":"throw_not_implemented","containerName":"id","line":189,"kind":12}],"line":187,"kind":12,"signature":{"documentation":"1;\n# $Id: TreeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::TreeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::TreeI - A Tree object suitable for lots of things, designed\n  originally for Phylogenetic Trees.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Tree::TreeI somehow\n  # like from a TreeIO\n  my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n  my $tree   = $treeio->next_tree;\n  my @nodes  = $tree->get_nodes;\n  my @leaves = $tree->get_leaf_nodes;\n  my $root   = $tree->get_root_node;\n\n=head1 DESCRIPTION\n\nThis object holds a pointer to the Root of a Tree which is a\nBio::Tree::NodeI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey, amackey@virginia.edu\nElia Stupka,  elia@fugu-sg.org\nSendu Bala,   bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::TreeI;\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Tree::NodeI objects\n Returns : array of Tree::NodeI objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Tree::NodeI object\n Args    : none\n\n\nsub get_root_node{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 number_nodes\n\n Title   : number_nodes\n Usage   : my $size = $tree->number_nodes\n Function: Find the number of nodes in the tree.\n Returns : int\n Args    : none\n\n\nsub number_nodes{\n   my ($self) = @_;\n   my $root = $self->get_root_node;\n   if( defined $root && $root->isa('Bio::Tree::NodeI'))  {\n       return ($root->descendent_count + 1);\n   }\n   return 0;\n}\n\n=head2 total_branch_length\n\n Title   : total_branch_length\n Usage   : my $size = $tree->total_branch_length\n Function: Returns the sum of the length of all branches\n Returns : integer\n Args    : none\n\n\nsub total_branch_length {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 height\n\n Title   : height\n Usage   : my $height = $tree->height\n Function: Gets the height of tree - this LOG_2($number_nodes)\n           WARNING: this is only true for strict binary trees.  The TreeIO\n           system is capable of building non-binary trees, for which this\n           method will currently return an incorrect value!!\n Returns : integer\n Args    : none\n\n\nsub height{\n   my ($self) = @_;\n   my $nodect =  $self->number_nodes;\n   return 0 if( ! $nodect ); \n   return log($nodect) / log(2);\n}\n\n=head2 id\n\n Title   : id\n Usage   : my $id = $tree->id();\n Function: An id value for the tree\n Returns : scalar\n Args    : ","parameters":[{"label":"$self"},{"label":"@args"}],"label":"id($self,@args)"},"detail":"($self,@args)","definition":"sub","containerName":"main::"},{"name":"score","range":{"end":{"line":208,"character":9999},"start":{"character":0,"line":205}},"kind":12,"line":205,"children":[{"kind":13,"line":206,"name":"$self","definition":"my","containerName":"score","localvar":"my"},{"containerName":"score","name":"$value","line":206,"kind":13},{"kind":13,"line":207,"containerName":"score","name":"$self"},{"line":207,"kind":12,"containerName":"score","name":"throw_not_implemented"}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"score($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: TreeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::TreeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::TreeI - A Tree object suitable for lots of things, designed\n  originally for Phylogenetic Trees.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Tree::TreeI somehow\n  # like from a TreeIO\n  my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n  my $tree   = $treeio->next_tree;\n  my @nodes  = $tree->get_nodes;\n  my @leaves = $tree->get_leaf_nodes;\n  my $root   = $tree->get_root_node;\n\n=head1 DESCRIPTION\n\nThis object holds a pointer to the Root of a Tree which is a\nBio::Tree::NodeI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey, amackey@virginia.edu\nElia Stupka,  elia@fugu-sg.org\nSendu Bala,   bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::TreeI;\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Tree::NodeI objects\n Returns : array of Tree::NodeI objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Tree::NodeI object\n Args    : none\n\n\nsub get_root_node{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 number_nodes\n\n Title   : number_nodes\n Usage   : my $size = $tree->number_nodes\n Function: Find the number of nodes in the tree.\n Returns : int\n Args    : none\n\n\nsub number_nodes{\n   my ($self) = @_;\n   my $root = $self->get_root_node;\n   if( defined $root && $root->isa('Bio::Tree::NodeI'))  {\n       return ($root->descendent_count + 1);\n   }\n   return 0;\n}\n\n=head2 total_branch_length\n\n Title   : total_branch_length\n Usage   : my $size = $tree->total_branch_length\n Function: Returns the sum of the length of all branches\n Returns : integer\n Args    : none\n\n\nsub total_branch_length {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 height\n\n Title   : height\n Usage   : my $height = $tree->height\n Function: Gets the height of tree - this LOG_2($number_nodes)\n           WARNING: this is only true for strict binary trees.  The TreeIO\n           system is capable of building non-binary trees, for which this\n           method will currently return an incorrect value!!\n Returns : integer\n Args    : none\n\n\nsub height{\n   my ($self) = @_;\n   my $nodect =  $self->number_nodes;\n   return 0 if( ! $nodect ); \n   return log($nodect) / log(2);\n}\n\n=head2 id\n\n Title   : id\n Usage   : my $id = $tree->id();\n Function: An id value for the tree\n Returns : scalar\n Args    : \n\n\n\nsub id{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 score\n\n Title   : score\n Usage   : $obj->score($newval)\n Function: Sets the associated score with this tree\n           This is a generic slot which is probably best used \n           for log likelihood or other overall tree score\n Returns : value of score\n Args    : newvalue (optional)"}},{"detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: TreeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::TreeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::TreeI - A Tree object suitable for lots of things, designed\n  originally for Phylogenetic Trees.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Tree::TreeI somehow\n  # like from a TreeIO\n  my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n  my $tree   = $treeio->next_tree;\n  my @nodes  = $tree->get_nodes;\n  my @leaves = $tree->get_leaf_nodes;\n  my $root   = $tree->get_root_node;\n\n=head1 DESCRIPTION\n\nThis object holds a pointer to the Root of a Tree which is a\nBio::Tree::NodeI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey, amackey@virginia.edu\nElia Stupka,  elia@fugu-sg.org\nSendu Bala,   bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::TreeI;\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Tree::NodeI objects\n Returns : array of Tree::NodeI objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Tree::NodeI object\n Args    : none\n\n\nsub get_root_node{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 number_nodes\n\n Title   : number_nodes\n Usage   : my $size = $tree->number_nodes\n Function: Find the number of nodes in the tree.\n Returns : int\n Args    : none\n\n\nsub number_nodes{\n   my ($self) = @_;\n   my $root = $self->get_root_node;\n   if( defined $root && $root->isa('Bio::Tree::NodeI'))  {\n       return ($root->descendent_count + 1);\n   }\n   return 0;\n}\n\n=head2 total_branch_length\n\n Title   : total_branch_length\n Usage   : my $size = $tree->total_branch_length\n Function: Returns the sum of the length of all branches\n Returns : integer\n Args    : none\n\n\nsub total_branch_length {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 height\n\n Title   : height\n Usage   : my $height = $tree->height\n Function: Gets the height of tree - this LOG_2($number_nodes)\n           WARNING: this is only true for strict binary trees.  The TreeIO\n           system is capable of building non-binary trees, for which this\n           method will currently return an incorrect value!!\n Returns : integer\n Args    : none\n\n\nsub height{\n   my ($self) = @_;\n   my $nodect =  $self->number_nodes;\n   return 0 if( ! $nodect ); \n   return log($nodect) / log(2);\n}\n\n=head2 id\n\n Title   : id\n Usage   : my $id = $tree->id();\n Function: An id value for the tree\n Returns : scalar\n Args    : \n\n\n\nsub id{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 score\n\n Title   : score\n Usage   : $obj->score($newval)\n Function: Sets the associated score with this tree\n           This is a generic slot which is probably best used \n           for log likelihood or other overall tree score\n Returns : value of score\n Args    : newvalue (optional)\n\n\n\nsub score{\n   my ($self,$value) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 get_leaf_nodes\n\n Title   : get_leaf_nodes\n Usage   : my @leaves = $tree->get_leaf_nodes()\n Function: Returns the leaves (tips) of the tree\n Returns : Array of Bio::Tree::NodeI objects\n Args    : none","label":"get_leaf_nodes($self)"},"containerName":"main::","definition":"sub","line":221,"children":[{"kind":13,"line":222,"containerName":"get_leaf_nodes","name":"$self","definition":"my","localvar":"my"},{"containerName":"get_leaf_nodes","name":"is_Leaf","line":223,"kind":12},{"containerName":"get_leaf_nodes","name":"$self","kind":13,"line":223},{"name":"get_nodes","containerName":"get_leaf_nodes","line":223,"kind":12}],"kind":12,"range":{"end":{"character":9999,"line":224},"start":{"line":221,"character":0}},"name":"get_leaf_nodes"},{"line":243,"children":[{"containerName":"set_tag_value","name":"throw_not_implemented","line":244,"kind":12}],"kind":12,"range":{"start":{"line":243,"character":0},"end":{"line":245,"character":9999}},"containerName":"main::","definition":"sub","name":"set_tag_value"},{"kind":12,"line":259,"children":[{"kind":12,"line":260,"name":"throw_not_implemented","containerName":"add_tag_value"}],"containerName":"main::","definition":"sub","name":"add_tag_value","range":{"end":{"line":261,"character":9999},"start":{"line":259,"character":0}}},{"kind":12,"line":274,"children":[{"kind":12,"line":275,"name":"throw_not_implemented","containerName":"remove_tag"}],"containerName":"main::","name":"remove_tag","definition":"sub","range":{"end":{"line":276,"character":9999},"start":{"character":0,"line":274}}},{"children":[{"containerName":"remove_all_tags","name":"throw_not_implemented","kind":12,"line":290}],"line":289,"kind":12,"range":{"end":{"character":9999,"line":291},"start":{"character":0,"line":289}},"name":"remove_all_tags","definition":"sub","containerName":"main::"},{"range":{"end":{"character":9999,"line":306},"start":{"character":0,"line":304}},"name":"get_all_tags","definition":"sub","containerName":"main::","children":[{"line":305,"kind":12,"containerName":"get_all_tags","name":"throw_not_implemented"}],"line":304,"kind":12},{"definition":"sub","name":"get_tag_values","containerName":"main::","range":{"start":{"character":0,"line":319},"end":{"line":321,"character":9999}},"kind":12,"children":[{"line":320,"kind":12,"containerName":"get_tag_values","name":"throw_not_implemented"}],"line":319},{"kind":12,"children":[{"name":"throw_not_implemented","containerName":"has_tag","line":335,"kind":12}],"line":334,"definition":"sub","name":"has_tag","containerName":"main::","range":{"start":{"character":0,"line":334},"end":{"line":336,"character":9999}}}],"version":5}