{"vars":[{"containerName":"","name":"base","line":110,"kind":2},{"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Tree.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::Tree - An Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Nodes which make up a tree.\n\n=head1 IMPLEMENTATION NOTE\n\nThis implementation of Bio::Tree::Tree contains Bio::Tree:::NodeI; mainly linked\nvia the root node. As NodeI can potentially contain circular references (as\nnodes will need to refer to both parent and child nodes), Bio::Tree::Tree will\nremove those circular references when the object is garbage-collected. This has\nsome side effects; primarily, one must keep the Tree in scope or have at least\none reference to it if working with nodes. The fix is to count the references to\nthe nodes and if it is greater than expected retain all of them, but it requires\nan additional prereq and thus may not be worth the effort.  This only shows up\nin minor edge cases, though (see Bug #2869).\n\nExample of issue:\n\n  # tree is not assigned to a variable, so passes from memory after\n  # root node is passed\n  my $root = Bio::TreeIO->new(-format => 'newick', -file => 'foo.txt')->next_tree\n\t\t ->get_root_node;\n  \n  # gets nothing, as all Node links are broken when Tree is garbage-collected above\n  my @descendents = $root->get_all_Descendents;\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\nSendu Bala   bix@sendu.me.uk\nMark A. Jensen maj@fortinbras.us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::Tree->new();\n Function: Builds a new Bio::Tree::Tree object \n Returns : Bio::Tree::Tree\n Args    : -root     => L<Bio::Tree::NodeI> object which is the root\n             OR\n           -node     => L<Bio::Tree::NodeI> object from which the root will be\n                        determined\n\n           -nodelete => boolean, whether or not to try and cleanup all\n                                 the nodes when this this tree goes out\n                                 of scope.\n           -id       => optional tree ID\n           -score    => optional tree score value"},"detail":"($class,@args)","definition":"sub","containerName":"main::","children":[{"localvar":"my","definition":"my","name":"$class","containerName":"new","line":132,"kind":13},{"line":132,"kind":13,"name":"@args","containerName":"new"},{"kind":13,"line":134,"containerName":"new","name":"$self","definition":"my","localvar":"my"},{"line":134,"kind":13,"containerName":"new","name":"$class"},{"kind":13,"line":134,"containerName":"new","name":"@args"},{"name":"$self","containerName":"new","line":135,"kind":13},{"name":"$self","containerName":"new","line":136,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":137},{"kind":12,"line":137,"name":"_register_for_cleanup","containerName":"new"},{"localvar":"my","definition":"my","name":"$root","containerName":"new","line":138,"kind":13},{"kind":13,"line":138,"name":"$node","containerName":"new"},{"kind":13,"line":138,"containerName":"new","name":"$nodel"},{"containerName":"new","name":"$id","line":138,"kind":13},{"kind":13,"line":138,"containerName":"new","name":"$score"},{"name":"$self","containerName":"new","kind":13,"line":138},{"kind":12,"line":138,"containerName":"new","name":"_rearrange"},{"name":"@args","containerName":"new","kind":13,"line":139},{"containerName":"new","name":"$node","kind":13,"line":141},{"name":"$root","containerName":"new","kind":13,"line":141},{"kind":13,"line":142,"containerName":"new","name":"$self"},{"name":"throw","containerName":"new","line":142,"kind":12},{"kind":13,"line":142,"containerName":"new","name":"$node"},{"containerName":"new","name":"$node","kind":13,"line":142},{"containerName":"new","name":"isa","kind":12,"line":142},{"line":143,"kind":13,"localvar":"my","containerName":"new","name":"@lineage","definition":"my"},{"name":"$self","containerName":"new","kind":13,"line":143},{"line":143,"kind":12,"name":"get_lineage_nodes","containerName":"new"},{"kind":13,"line":143,"containerName":"new","name":"$node"},{"name":"$root","containerName":"new","kind":13,"line":144},{"kind":13,"line":144,"name":"@lineage","containerName":"new"},{"containerName":"new","name":"$node","kind":13,"line":144},{"containerName":"new","name":"$node","line":148,"kind":13},{"kind":12,"line":148,"name":"isa","containerName":"new"},{"containerName":"new","name":"@lineage","line":149,"kind":13},{"containerName":"new","name":"$node","line":149,"kind":13},{"kind":13,"line":149,"containerName":"new","name":"$node"},{"name":"$root","containerName":"new","kind":13,"line":149},{"kind":13,"line":150,"name":"$ancestor","definition":"my","containerName":"new","localvar":"my"},{"name":"$root","containerName":"new","kind":13,"line":150},{"definition":"my","name":"$lineage_node","containerName":"new","localvar":"my","kind":13,"line":151},{"line":151,"kind":13,"name":"@lineage","containerName":"new"},{"kind":13,"line":152,"name":"$lineage_node","containerName":"new"},{"line":152,"kind":12,"containerName":"new","name":"ancestor"},{"containerName":"new","name":"$ancestor","line":152,"kind":13},{"line":153,"kind":13,"containerName":"new","name":"$ancestor"},{"name":"$lineage_node","containerName":"new","kind":13,"line":153},{"kind":13,"line":156,"name":"$root","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":157},{"line":157,"kind":12,"containerName":"new","name":"set_root_node"},{"name":"$root","containerName":"new","kind":13,"line":157},{"line":160,"kind":13,"containerName":"new","name":"$self"},{"name":"nodelete","containerName":"new","kind":12,"line":160},{"containerName":"new","name":"$nodel","kind":13,"line":160},{"kind":13,"line":161,"containerName":"new","name":"$self"},{"kind":12,"line":161,"containerName":"new","name":"id"},{"containerName":"new","name":"$id","line":161,"kind":13},{"line":161,"kind":13,"containerName":"new","name":"$id"},{"kind":13,"line":162,"name":"$self","containerName":"new"},{"line":162,"kind":12,"containerName":"new","name":"score"},{"name":"$score","containerName":"new","kind":13,"line":162},{"line":162,"kind":13,"name":"$score","containerName":"new"},{"containerName":"new","name":"$self","line":163,"kind":13}],"line":131,"kind":12,"range":{"end":{"line":164,"character":9999},"start":{"line":131,"character":0}},"name":"new"},{"containerName":"new","name":"SUPER","line":134,"kind":12},{"name":"cleanup_tree","line":137,"kind":12},{"kind":12,"children":[{"definition":"my","name":"$self","containerName":"nodelete","localvar":"my","kind":13,"line":180},{"kind":13,"line":181,"containerName":"nodelete","name":"$self"},{"line":182,"kind":13,"name":"$self","containerName":"nodelete"}],"line":179,"name":"nodelete","definition":"sub","containerName":"main::","range":{"end":{"line":183,"character":9999},"start":{"character":0,"line":179}}},{"range":{"start":{"line":196,"character":0},"end":{"line":216,"character":9999}},"name":"get_nodes","detail":"($self,@args)","signature":{"documentation":"1;\n# $Id: Tree.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::Tree - An Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Nodes which make up a tree.\n\n=head1 IMPLEMENTATION NOTE\n\nThis implementation of Bio::Tree::Tree contains Bio::Tree:::NodeI; mainly linked\nvia the root node. As NodeI can potentially contain circular references (as\nnodes will need to refer to both parent and child nodes), Bio::Tree::Tree will\nremove those circular references when the object is garbage-collected. This has\nsome side effects; primarily, one must keep the Tree in scope or have at least\none reference to it if working with nodes. The fix is to count the references to\nthe nodes and if it is greater than expected retain all of them, but it requires\nan additional prereq and thus may not be worth the effort.  This only shows up\nin minor edge cases, though (see Bug #2869).\n\nExample of issue:\n\n  # tree is not assigned to a variable, so passes from memory after\n  # root node is passed\n  my $root = Bio::TreeIO->new(-format => 'newick', -file => 'foo.txt')->next_tree\n\t\t ->get_root_node;\n  \n  # gets nothing, as all Node links are broken when Tree is garbage-collected above\n  my @descendents = $root->get_all_Descendents;\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\nSendu Bala   bix@sendu.me.uk\nMark A. Jensen maj@fortinbras.us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::Tree->new();\n Function: Builds a new Bio::Tree::Tree object \n Returns : Bio::Tree::Tree\n Args    : -root     => L<Bio::Tree::NodeI> object which is the root\n             OR\n           -node     => L<Bio::Tree::NodeI> object from which the root will be\n                        determined\n\n           -nodelete => boolean, whether or not to try and cleanup all\n                                 the nodes when this this tree goes out\n                                 of scope.\n           -id       => optional tree ID\n           -score    => optional tree score value\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n  $self->_register_for_cleanup(\\&cleanup_tree);\n  my ($root,$node,$nodel,$id,$score)= $self->_rearrange([qw(ROOT NODE NODELETE \n                              ID SCORE)], @args);\n  \n  if ($node && ! $root) {\n    $self->throw(\"Must supply a Bio::Tree::NodeI\") unless ref($node) && $node->isa('Bio::Tree::NodeI');\n    my @lineage = $self->get_lineage_nodes($node);\n    $root = shift(@lineage) || $node;\n    \n    # to stop us pulling in entire database of a Bio::Taxon when we later do\n    # get_nodes() or similar, specifically set ancestor() for each node\n    if ($node->isa('Bio::Taxon')) {\n      push(@lineage, $node) unless $node eq $root;\n      my $ancestor = $root;\n      foreach my $lineage_node (@lineage) {\n        $lineage_node->ancestor($ancestor);\n      } continue { $ancestor = $lineage_node; }\n    }\n  }\n  if ($root) {\n    $self->set_root_node($root);\n  }\n  \n  $self->nodelete($nodel || 0);\n  $self->id($id)       if defined $id;\n  $self->score($score) if defined $score;\n  return $self;\n}\n\n\n=head2 nodelete\n\n Title   : nodelete\n Usage   : $obj->nodelete($newval)\n Function: Get/Set Boolean whether or not to delete the underlying\n           nodes when it goes out of scope.  By default this is false\n           meaning trees are cleaned up.\n Returns : boolean\n Args    : on set, new boolean value\n\n\nsub nodelete{\n    my $self = shift;\n    return $self->{'nodelete'} = shift if @_;\n    return $self->{'nodelete'};\n}\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Tree::NodeI objects\n Returns : array of Bio::Tree::NodeI objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order","parameters":[{"label":"$self"},{"label":"@args"}],"label":"get_nodes($self,@args)"},"containerName":"main::","definition":"sub","line":196,"children":[{"line":197,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"get_nodes"},{"name":"@args","containerName":"get_nodes","line":197,"kind":13},{"name":"$order","definition":"my","containerName":"get_nodes","localvar":"my","kind":13,"line":199},{"line":199,"kind":13,"name":"$sortby","containerName":"get_nodes"},{"kind":13,"line":199,"name":"$self","containerName":"get_nodes"},{"kind":12,"line":199,"name":"_rearrange","containerName":"get_nodes"},{"name":"@args","containerName":"get_nodes","kind":13,"line":199},{"kind":13,"line":200,"containerName":"get_nodes","name":"$order"},{"containerName":"get_nodes","name":"$sortby","kind":13,"line":201},{"line":202,"kind":13,"localvar":"my","containerName":"get_nodes","name":"$node","definition":"my"},{"containerName":"get_nodes","name":"$self","line":202,"kind":13},{"kind":12,"line":202,"containerName":"get_nodes","name":"get_root_node"},{"name":"$order","containerName":"get_nodes","line":203,"kind":13},{"kind":13,"line":204,"definition":"my","name":"@children","containerName":"get_nodes","localvar":"my"},{"containerName":"get_nodes","name":"$node","kind":13,"line":204},{"line":205,"kind":13,"containerName":"get_nodes","name":"@children"},{"line":206,"kind":13,"containerName":"get_nodes","name":"@children"},{"containerName":"get_nodes","name":"each_Descendent","line":206,"kind":12},{"containerName":"get_nodes","name":"$sortby","kind":13,"line":206},{"containerName":"get_nodes","name":"@children","kind":13,"line":208},{"name":"$order","containerName":"get_nodes","kind":13,"line":211},{"localvar":"my","definition":"my","name":"@children","containerName":"get_nodes","line":213,"kind":13},{"line":213,"kind":13,"containerName":"get_nodes","name":"$node"},{"kind":13,"line":213,"name":"$node","containerName":"get_nodes"},{"containerName":"get_nodes","name":"get_all_Descendents","kind":12,"line":213},{"kind":13,"line":213,"containerName":"get_nodes","name":"$sortby"},{"name":"@children","containerName":"get_nodes","kind":13,"line":214}],"kind":12},{"name":"get_root_node","range":{"end":{"line":233,"character":9999},"start":{"line":230,"character":0}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"get_root_node($self)","documentation":"1;\n# $Id: Tree.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::Tree - An Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Nodes which make up a tree.\n\n=head1 IMPLEMENTATION NOTE\n\nThis implementation of Bio::Tree::Tree contains Bio::Tree:::NodeI; mainly linked\nvia the root node. As NodeI can potentially contain circular references (as\nnodes will need to refer to both parent and child nodes), Bio::Tree::Tree will\nremove those circular references when the object is garbage-collected. This has\nsome side effects; primarily, one must keep the Tree in scope or have at least\none reference to it if working with nodes. The fix is to count the references to\nthe nodes and if it is greater than expected retain all of them, but it requires\nan additional prereq and thus may not be worth the effort.  This only shows up\nin minor edge cases, though (see Bug #2869).\n\nExample of issue:\n\n  # tree is not assigned to a variable, so passes from memory after\n  # root node is passed\n  my $root = Bio::TreeIO->new(-format => 'newick', -file => 'foo.txt')->next_tree\n\t\t ->get_root_node;\n  \n  # gets nothing, as all Node links are broken when Tree is garbage-collected above\n  my @descendents = $root->get_all_Descendents;\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\nSendu Bala   bix@sendu.me.uk\nMark A. Jensen maj@fortinbras.us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::Tree->new();\n Function: Builds a new Bio::Tree::Tree object \n Returns : Bio::Tree::Tree\n Args    : -root     => L<Bio::Tree::NodeI> object which is the root\n             OR\n           -node     => L<Bio::Tree::NodeI> object from which the root will be\n                        determined\n\n           -nodelete => boolean, whether or not to try and cleanup all\n                                 the nodes when this this tree goes out\n                                 of scope.\n           -id       => optional tree ID\n           -score    => optional tree score value\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n  $self->_register_for_cleanup(\\&cleanup_tree);\n  my ($root,$node,$nodel,$id,$score)= $self->_rearrange([qw(ROOT NODE NODELETE \n                              ID SCORE)], @args);\n  \n  if ($node && ! $root) {\n    $self->throw(\"Must supply a Bio::Tree::NodeI\") unless ref($node) && $node->isa('Bio::Tree::NodeI');\n    my @lineage = $self->get_lineage_nodes($node);\n    $root = shift(@lineage) || $node;\n    \n    # to stop us pulling in entire database of a Bio::Taxon when we later do\n    # get_nodes() or similar, specifically set ancestor() for each node\n    if ($node->isa('Bio::Taxon')) {\n      push(@lineage, $node) unless $node eq $root;\n      my $ancestor = $root;\n      foreach my $lineage_node (@lineage) {\n        $lineage_node->ancestor($ancestor);\n      } continue { $ancestor = $lineage_node; }\n    }\n  }\n  if ($root) {\n    $self->set_root_node($root);\n  }\n  \n  $self->nodelete($nodel || 0);\n  $self->id($id)       if defined $id;\n  $self->score($score) if defined $score;\n  return $self;\n}\n\n\n=head2 nodelete\n\n Title   : nodelete\n Usage   : $obj->nodelete($newval)\n Function: Get/Set Boolean whether or not to delete the underlying\n           nodes when it goes out of scope.  By default this is false\n           meaning trees are cleaned up.\n Returns : boolean\n Args    : on set, new boolean value\n\n\nsub nodelete{\n    my $self = shift;\n    return $self->{'nodelete'} = shift if @_;\n    return $self->{'nodelete'};\n}\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Tree::NodeI objects\n Returns : array of Bio::Tree::NodeI objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self, @args) = @_;\n   \n   my ($order, $sortby) = $self->_rearrange([qw(ORDER SORTBY)],@args);\n   $order ||= 'depth';\n   $sortby ||= 'none';\n   my $node = $self->get_root_node || return;\n   if ($order =~ m/^b|(breadth)$/oi) {\n       my @children = ($node);\n       for (@children) {\n        push @children, $_->each_Descendent($sortby);\n       }\n       return @children;\n   }\n\n   if ($order =~ m/^d|(depth)$/oi) {\n       # this is depth-first search I believe\n       my @children = ($node,$node->get_all_Descendents($sortby));\n       return @children;\n   }\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Tree::NodeI object\n Args    : none","parameters":[{"label":"$self"}]},"kind":12,"line":230,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"get_root_node","line":231,"kind":13},{"kind":13,"line":232,"name":"$self","containerName":"get_root_node"}]},{"kind":12,"line":245,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"set_root_node","line":246,"kind":13},{"name":"$value","definition":"my","containerName":"set_root_node","localvar":"my","kind":13,"line":248},{"kind":13,"line":249,"containerName":"set_root_node","name":"$value"},{"containerName":"set_root_node","name":"$value","line":250,"kind":13},{"kind":12,"line":250,"containerName":"set_root_node","name":"isa"},{"kind":13,"line":251,"containerName":"set_root_node","name":"$self"},{"name":"warn","containerName":"set_root_node","line":251,"kind":12},{"kind":13,"line":252,"containerName":"set_root_node","name":"$self"},{"containerName":"set_root_node","name":"get_root_node","line":252,"kind":12},{"containerName":"set_root_node","name":"$self","kind":13,"line":254},{"line":254,"kind":13,"containerName":"set_root_node","name":"$value"},{"name":"$self","containerName":"set_root_node","line":256,"kind":13},{"name":"get_root_node","containerName":"set_root_node","line":256,"kind":12}],"containerName":"main::","definition":"sub","name":"set_root_node","range":{"end":{"line":257,"character":9999},"start":{"character":0,"line":245}}},{"children":[{"kind":12,"line":269,"containerName":"total_branch_length","name":"subtree_length"}],"line":269,"kind":12,"range":{"start":{"character":0,"line":269},"end":{"line":269,"character":9999}},"name":"total_branch_length","definition":"sub","containerName":"main::"},{"range":{"start":{"character":0,"line":283},"end":{"line":292,"character":9999}},"definition":"sub","name":"subtree_length","containerName":"main::","children":[{"localvar":"my","containerName":"subtree_length","definition":"my","name":"$tree","line":284,"kind":13},{"kind":13,"line":285,"containerName":"subtree_length","definition":"my","name":"$node","localvar":"my"},{"name":"$tree","containerName":"subtree_length","line":285,"kind":13},{"kind":12,"line":285,"containerName":"subtree_length","name":"get_root_node"},{"containerName":"subtree_length","name":"$node","line":286,"kind":13},{"line":287,"kind":13,"localvar":"my","name":"$sum","definition":"my","containerName":"subtree_length"},{"kind":13,"line":288,"containerName":"subtree_length","name":"$node"},{"name":"get_all_Descendents","containerName":"subtree_length","line":288,"kind":12},{"kind":13,"line":289,"containerName":"subtree_length","name":"$sum"},{"name":"branch_length","containerName":"subtree_length","kind":12,"line":289},{"name":"$sum","containerName":"subtree_length","line":291,"kind":13}],"line":283,"kind":12},{"detail":"($self,$val)","signature":{"documentation":"1;\n# $Id: Tree.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::Tree - An Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Nodes which make up a tree.\n\n=head1 IMPLEMENTATION NOTE\n\nThis implementation of Bio::Tree::Tree contains Bio::Tree:::NodeI; mainly linked\nvia the root node. As NodeI can potentially contain circular references (as\nnodes will need to refer to both parent and child nodes), Bio::Tree::Tree will\nremove those circular references when the object is garbage-collected. This has\nsome side effects; primarily, one must keep the Tree in scope or have at least\none reference to it if working with nodes. The fix is to count the references to\nthe nodes and if it is greater than expected retain all of them, but it requires\nan additional prereq and thus may not be worth the effort.  This only shows up\nin minor edge cases, though (see Bug #2869).\n\nExample of issue:\n\n  # tree is not assigned to a variable, so passes from memory after\n  # root node is passed\n  my $root = Bio::TreeIO->new(-format => 'newick', -file => 'foo.txt')->next_tree\n\t\t ->get_root_node;\n  \n  # gets nothing, as all Node links are broken when Tree is garbage-collected above\n  my @descendents = $root->get_all_Descendents;\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\nSendu Bala   bix@sendu.me.uk\nMark A. Jensen maj@fortinbras.us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::Tree->new();\n Function: Builds a new Bio::Tree::Tree object \n Returns : Bio::Tree::Tree\n Args    : -root     => L<Bio::Tree::NodeI> object which is the root\n             OR\n           -node     => L<Bio::Tree::NodeI> object from which the root will be\n                        determined\n\n           -nodelete => boolean, whether or not to try and cleanup all\n                                 the nodes when this this tree goes out\n                                 of scope.\n           -id       => optional tree ID\n           -score    => optional tree score value\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n  $self->_register_for_cleanup(\\&cleanup_tree);\n  my ($root,$node,$nodel,$id,$score)= $self->_rearrange([qw(ROOT NODE NODELETE \n                              ID SCORE)], @args);\n  \n  if ($node && ! $root) {\n    $self->throw(\"Must supply a Bio::Tree::NodeI\") unless ref($node) && $node->isa('Bio::Tree::NodeI');\n    my @lineage = $self->get_lineage_nodes($node);\n    $root = shift(@lineage) || $node;\n    \n    # to stop us pulling in entire database of a Bio::Taxon when we later do\n    # get_nodes() or similar, specifically set ancestor() for each node\n    if ($node->isa('Bio::Taxon')) {\n      push(@lineage, $node) unless $node eq $root;\n      my $ancestor = $root;\n      foreach my $lineage_node (@lineage) {\n        $lineage_node->ancestor($ancestor);\n      } continue { $ancestor = $lineage_node; }\n    }\n  }\n  if ($root) {\n    $self->set_root_node($root);\n  }\n  \n  $self->nodelete($nodel || 0);\n  $self->id($id)       if defined $id;\n  $self->score($score) if defined $score;\n  return $self;\n}\n\n\n=head2 nodelete\n\n Title   : nodelete\n Usage   : $obj->nodelete($newval)\n Function: Get/Set Boolean whether or not to delete the underlying\n           nodes when it goes out of scope.  By default this is false\n           meaning trees are cleaned up.\n Returns : boolean\n Args    : on set, new boolean value\n\n\nsub nodelete{\n    my $self = shift;\n    return $self->{'nodelete'} = shift if @_;\n    return $self->{'nodelete'};\n}\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Tree::NodeI objects\n Returns : array of Bio::Tree::NodeI objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self, @args) = @_;\n   \n   my ($order, $sortby) = $self->_rearrange([qw(ORDER SORTBY)],@args);\n   $order ||= 'depth';\n   $sortby ||= 'none';\n   my $node = $self->get_root_node || return;\n   if ($order =~ m/^b|(breadth)$/oi) {\n       my @children = ($node);\n       for (@children) {\n        push @children, $_->each_Descendent($sortby);\n       }\n       return @children;\n   }\n\n   if ($order =~ m/^d|(depth)$/oi) {\n       # this is depth-first search I believe\n       my @children = ($node,$node->get_all_Descendents($sortby));\n       return @children;\n   }\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Tree::NodeI object\n Args    : none\n\n\n\nsub get_root_node{\n   my ($self) = @_;\n   return $self->{'_rootnode'};\n}\n\n=head2 set_root_node\n\n Title   : set_root_node\n Usage   : $tree->set_root_node($node)\n Function: Set the Root Node for the Tree\n Returns : Bio::Tree::NodeI\n Args    : Bio::Tree::NodeI\n\n\nsub set_root_node{\n   my $self = shift;\n   if( @_ ) { \n       my $value = shift;\n       if( defined $value && \n       ! $value->isa('Bio::Tree::NodeI') ) { \n       $self->warn(\"Trying to set the root node to $value which is not a Bio::Tree::NodeI\");\n       return $self->get_root_node;\n       }\n       $self->{'_rootnode'} = $value;\n   } \n   return $self->get_root_node;\n}\n\n=head2 total_branch_length\n\n Title   : total_branch_length\n Usage   : my $size = $tree->total_branch_length\n Function: Returns the sum of the length of all branches\n Returns : real\n Args    : none\n\n\nsub total_branch_length { shift->subtree_length }\n\n=head2 subtree_length\n\n Title   : subtree_length\n Usage   : my $subtree_size = $tree->subtree_length($internal_node)\n Function: Returns the sum of the length of all branches in a subtree\n           under the node. Calculates the size of the whole tree\n           without an argument (but only if root node is defined)\n Returns : real or undef\n Args    : Bio::Tree::NodeI object, defaults to the root node\n\n\nsub subtree_length {\n    my $tree = shift;\n    my $node = shift || $tree->get_root_node;\n    return unless $node;\n    my $sum = 0;\n    for ( $node->get_all_Descendents ) {\n    $sum += $_->branch_length || 0;\n    }\n    return $sum;\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : my $id = $tree->id();\n Function: An id value for the tree\n Returns : scalar\n Args    : [optional] new value to set","parameters":[{"label":"$self"},{"label":"$val"}],"label":"id($self,$val)"},"containerName":"main::","definition":"sub","line":306,"children":[{"containerName":"id","name":"$self","definition":"my","localvar":"my","kind":13,"line":307},{"containerName":"id","name":"$val","line":307,"kind":13},{"kind":13,"line":308,"containerName":"id","name":"$val"},{"name":"$self","containerName":"id","line":309,"kind":13},{"name":"$val","containerName":"id","line":309,"kind":13},{"name":"$self","containerName":"id","line":311,"kind":13}],"kind":12,"range":{"start":{"line":306,"character":0},"end":{"line":312,"character":9999}},"name":"id"},{"name":"score","range":{"end":{"character":9999,"line":333},"start":{"line":327,"character":0}},"definition":"sub","containerName":"main::","signature":{"label":"score($self,$val)","documentation":"1;\n# $Id: Tree.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::Tree - An Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Nodes which make up a tree.\n\n=head1 IMPLEMENTATION NOTE\n\nThis implementation of Bio::Tree::Tree contains Bio::Tree:::NodeI; mainly linked\nvia the root node. As NodeI can potentially contain circular references (as\nnodes will need to refer to both parent and child nodes), Bio::Tree::Tree will\nremove those circular references when the object is garbage-collected. This has\nsome side effects; primarily, one must keep the Tree in scope or have at least\none reference to it if working with nodes. The fix is to count the references to\nthe nodes and if it is greater than expected retain all of them, but it requires\nan additional prereq and thus may not be worth the effort.  This only shows up\nin minor edge cases, though (see Bug #2869).\n\nExample of issue:\n\n  # tree is not assigned to a variable, so passes from memory after\n  # root node is passed\n  my $root = Bio::TreeIO->new(-format => 'newick', -file => 'foo.txt')->next_tree\n\t\t ->get_root_node;\n  \n  # gets nothing, as all Node links are broken when Tree is garbage-collected above\n  my @descendents = $root->get_all_Descendents;\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\nSendu Bala   bix@sendu.me.uk\nMark A. Jensen maj@fortinbras.us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::Tree->new();\n Function: Builds a new Bio::Tree::Tree object \n Returns : Bio::Tree::Tree\n Args    : -root     => L<Bio::Tree::NodeI> object which is the root\n             OR\n           -node     => L<Bio::Tree::NodeI> object from which the root will be\n                        determined\n\n           -nodelete => boolean, whether or not to try and cleanup all\n                                 the nodes when this this tree goes out\n                                 of scope.\n           -id       => optional tree ID\n           -score    => optional tree score value\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n  $self->_register_for_cleanup(\\&cleanup_tree);\n  my ($root,$node,$nodel,$id,$score)= $self->_rearrange([qw(ROOT NODE NODELETE \n                              ID SCORE)], @args);\n  \n  if ($node && ! $root) {\n    $self->throw(\"Must supply a Bio::Tree::NodeI\") unless ref($node) && $node->isa('Bio::Tree::NodeI');\n    my @lineage = $self->get_lineage_nodes($node);\n    $root = shift(@lineage) || $node;\n    \n    # to stop us pulling in entire database of a Bio::Taxon when we later do\n    # get_nodes() or similar, specifically set ancestor() for each node\n    if ($node->isa('Bio::Taxon')) {\n      push(@lineage, $node) unless $node eq $root;\n      my $ancestor = $root;\n      foreach my $lineage_node (@lineage) {\n        $lineage_node->ancestor($ancestor);\n      } continue { $ancestor = $lineage_node; }\n    }\n  }\n  if ($root) {\n    $self->set_root_node($root);\n  }\n  \n  $self->nodelete($nodel || 0);\n  $self->id($id)       if defined $id;\n  $self->score($score) if defined $score;\n  return $self;\n}\n\n\n=head2 nodelete\n\n Title   : nodelete\n Usage   : $obj->nodelete($newval)\n Function: Get/Set Boolean whether or not to delete the underlying\n           nodes when it goes out of scope.  By default this is false\n           meaning trees are cleaned up.\n Returns : boolean\n Args    : on set, new boolean value\n\n\nsub nodelete{\n    my $self = shift;\n    return $self->{'nodelete'} = shift if @_;\n    return $self->{'nodelete'};\n}\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Tree::NodeI objects\n Returns : array of Bio::Tree::NodeI objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self, @args) = @_;\n   \n   my ($order, $sortby) = $self->_rearrange([qw(ORDER SORTBY)],@args);\n   $order ||= 'depth';\n   $sortby ||= 'none';\n   my $node = $self->get_root_node || return;\n   if ($order =~ m/^b|(breadth)$/oi) {\n       my @children = ($node);\n       for (@children) {\n        push @children, $_->each_Descendent($sortby);\n       }\n       return @children;\n   }\n\n   if ($order =~ m/^d|(depth)$/oi) {\n       # this is depth-first search I believe\n       my @children = ($node,$node->get_all_Descendents($sortby));\n       return @children;\n   }\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Tree::NodeI object\n Args    : none\n\n\n\nsub get_root_node{\n   my ($self) = @_;\n   return $self->{'_rootnode'};\n}\n\n=head2 set_root_node\n\n Title   : set_root_node\n Usage   : $tree->set_root_node($node)\n Function: Set the Root Node for the Tree\n Returns : Bio::Tree::NodeI\n Args    : Bio::Tree::NodeI\n\n\nsub set_root_node{\n   my $self = shift;\n   if( @_ ) { \n       my $value = shift;\n       if( defined $value && \n       ! $value->isa('Bio::Tree::NodeI') ) { \n       $self->warn(\"Trying to set the root node to $value which is not a Bio::Tree::NodeI\");\n       return $self->get_root_node;\n       }\n       $self->{'_rootnode'} = $value;\n   } \n   return $self->get_root_node;\n}\n\n=head2 total_branch_length\n\n Title   : total_branch_length\n Usage   : my $size = $tree->total_branch_length\n Function: Returns the sum of the length of all branches\n Returns : real\n Args    : none\n\n\nsub total_branch_length { shift->subtree_length }\n\n=head2 subtree_length\n\n Title   : subtree_length\n Usage   : my $subtree_size = $tree->subtree_length($internal_node)\n Function: Returns the sum of the length of all branches in a subtree\n           under the node. Calculates the size of the whole tree\n           without an argument (but only if root node is defined)\n Returns : real or undef\n Args    : Bio::Tree::NodeI object, defaults to the root node\n\n\nsub subtree_length {\n    my $tree = shift;\n    my $node = shift || $tree->get_root_node;\n    return unless $node;\n    my $sum = 0;\n    for ( $node->get_all_Descendents ) {\n    $sum += $_->branch_length || 0;\n    }\n    return $sum;\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : my $id = $tree->id();\n Function: An id value for the tree\n Returns : scalar\n Args    : [optional] new value to set\n\n\n\nsub id{\n   my ($self,$val) = @_;\n   if( defined $val ) { \n       $self->{'_treeid'} = $val;\n   }\n   return $self->{'_treeid'};\n}\n\n=head2 score\n\n Title   : score\n Usage   : $obj->score($newval)\n Function: Sets the associated score with this tree\n           This is a generic slot which is probably best used \n           for log likelihood or other overall tree score\n Returns : value of score\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$val"}]},"detail":"($self,$val)","kind":12,"children":[{"line":328,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"score"},{"name":"$val","containerName":"score","line":328,"kind":13},{"line":329,"kind":13,"name":"$val","containerName":"score"},{"kind":13,"line":330,"name":"$self","containerName":"score"},{"kind":13,"line":330,"containerName":"score","name":"$val"},{"kind":13,"line":332,"name":"$self","containerName":"score"}],"line":327},{"line":375,"children":[{"containerName":"as_text","name":"$self","definition":"my","localvar":"my","kind":13,"line":376},{"localvar":"my","name":"$format","definition":"my","containerName":"as_text","line":377,"kind":13},{"localvar":"my","containerName":"as_text","name":"@parms","definition":"my","line":378,"kind":13},{"line":379,"kind":13,"localvar":"my","containerName":"as_text","definition":"my","name":"$iomod"},{"name":"$self","containerName":"as_text","kind":13,"line":380},{"name":"_load_module","containerName":"as_text","kind":12,"line":380},{"name":"$iomod","containerName":"as_text","kind":13,"line":380},{"localvar":"my","containerName":"as_text","name":"$io","definition":"my","line":382,"kind":13},{"line":382,"kind":13,"containerName":"as_text","name":"$iomod"},{"containerName":"as_text","name":"new","kind":12,"line":382},{"line":382,"kind":13,"containerName":"as_text","name":"$format"},{"name":"devnull","containerName":"as_text","line":382,"kind":12},{"localvar":"my","name":"$iowtH","definition":"my","containerName":"as_text","line":384,"kind":13},{"line":384,"kind":13,"containerName":"as_text","name":"$iomod"},{"name":"$format","containerName":"as_text","line":386,"kind":13},{"kind":13,"line":388,"name":"@parms","containerName":"as_text"},{"kind":13,"line":388,"containerName":"as_text","name":"$io"},{"line":388,"kind":12,"containerName":"as_text","name":"bootstrap_style"},{"line":388,"kind":13,"containerName":"as_text","name":"$io"},{"kind":12,"line":388,"containerName":"as_text","name":"order_by"},{"kind":13,"line":392,"containerName":"as_text","name":"@parms"},{"containerName":"as_text","name":"@parms","line":396,"kind":13},{"line":400,"kind":13,"containerName":"as_text","name":"$self"},{"name":"throw","containerName":"as_text","kind":12,"line":400},{"name":"$data","definition":"my","containerName":"as_text","localvar":"my","kind":13,"line":405},{"containerName":"as_text","name":"$iowtH","line":405,"kind":13},{"containerName":"as_text","name":"$self","kind":13,"line":405},{"containerName":"as_text","name":"get_root_node","line":405,"kind":12},{"name":"@parms","containerName":"as_text","line":405,"kind":13},{"name":"$format","containerName":"as_text","kind":13,"line":407},{"containerName":"as_text","name":"$data","line":411,"kind":13}],"kind":12,"range":{"start":{"line":375,"character":0},"end":{"line":413,"character":9999}},"containerName":"main::","name":"as_text","definition":"sub"},{"name":"File","containerName":"Spec","line":382,"kind":12},{"kind":12,"line":383,"name":"strict"},{"line":384,"kind":12,"name":"CODE"},{"containerName":"","name":"strict","kind":2,"line":386},{"line":408,"kind":12,"name":"data"},{"kind":12,"children":[{"name":"$self","definition":"my","containerName":"set_tag_value","localvar":"my","kind":13,"line":432},{"name":"$tag","containerName":"set_tag_value","line":432,"kind":13},{"containerName":"set_tag_value","name":"@values","kind":13,"line":432},{"name":"$tag","containerName":"set_tag_value","line":433,"kind":13},{"containerName":"set_tag_value","name":"@values","line":433,"kind":13},{"name":"$self","containerName":"set_tag_value","kind":13,"line":434},{"name":"warn","containerName":"set_tag_value","line":434,"kind":12},{"name":"$self","containerName":"set_tag_value","kind":13,"line":436},{"name":"remove_tag","containerName":"set_tag_value","line":436,"kind":12},{"line":436,"kind":13,"containerName":"set_tag_value","name":"$tag"},{"name":"$self","containerName":"set_tag_value","kind":13,"line":437},{"line":437,"kind":13,"containerName":"set_tag_value","name":"$tag"}],"line":431,"definition":"sub","containerName":"main::","signature":{"label":"set_tag_value($self,$tag,@values)","documentation":"1;\n# $Id: Tree.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::Tree - An Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Nodes which make up a tree.\n\n=head1 IMPLEMENTATION NOTE\n\nThis implementation of Bio::Tree::Tree contains Bio::Tree:::NodeI; mainly linked\nvia the root node. As NodeI can potentially contain circular references (as\nnodes will need to refer to both parent and child nodes), Bio::Tree::Tree will\nremove those circular references when the object is garbage-collected. This has\nsome side effects; primarily, one must keep the Tree in scope or have at least\none reference to it if working with nodes. The fix is to count the references to\nthe nodes and if it is greater than expected retain all of them, but it requires\nan additional prereq and thus may not be worth the effort.  This only shows up\nin minor edge cases, though (see Bug #2869).\n\nExample of issue:\n\n  # tree is not assigned to a variable, so passes from memory after\n  # root node is passed\n  my $root = Bio::TreeIO->new(-format => 'newick', -file => 'foo.txt')->next_tree\n\t\t ->get_root_node;\n  \n  # gets nothing, as all Node links are broken when Tree is garbage-collected above\n  my @descendents = $root->get_all_Descendents;\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\nSendu Bala   bix@sendu.me.uk\nMark A. Jensen maj@fortinbras.us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::Tree->new();\n Function: Builds a new Bio::Tree::Tree object \n Returns : Bio::Tree::Tree\n Args    : -root     => L<Bio::Tree::NodeI> object which is the root\n             OR\n           -node     => L<Bio::Tree::NodeI> object from which the root will be\n                        determined\n\n           -nodelete => boolean, whether or not to try and cleanup all\n                                 the nodes when this this tree goes out\n                                 of scope.\n           -id       => optional tree ID\n           -score    => optional tree score value\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n  $self->_register_for_cleanup(\\&cleanup_tree);\n  my ($root,$node,$nodel,$id,$score)= $self->_rearrange([qw(ROOT NODE NODELETE \n                              ID SCORE)], @args);\n  \n  if ($node && ! $root) {\n    $self->throw(\"Must supply a Bio::Tree::NodeI\") unless ref($node) && $node->isa('Bio::Tree::NodeI');\n    my @lineage = $self->get_lineage_nodes($node);\n    $root = shift(@lineage) || $node;\n    \n    # to stop us pulling in entire database of a Bio::Taxon when we later do\n    # get_nodes() or similar, specifically set ancestor() for each node\n    if ($node->isa('Bio::Taxon')) {\n      push(@lineage, $node) unless $node eq $root;\n      my $ancestor = $root;\n      foreach my $lineage_node (@lineage) {\n        $lineage_node->ancestor($ancestor);\n      } continue { $ancestor = $lineage_node; }\n    }\n  }\n  if ($root) {\n    $self->set_root_node($root);\n  }\n  \n  $self->nodelete($nodel || 0);\n  $self->id($id)       if defined $id;\n  $self->score($score) if defined $score;\n  return $self;\n}\n\n\n=head2 nodelete\n\n Title   : nodelete\n Usage   : $obj->nodelete($newval)\n Function: Get/Set Boolean whether or not to delete the underlying\n           nodes when it goes out of scope.  By default this is false\n           meaning trees are cleaned up.\n Returns : boolean\n Args    : on set, new boolean value\n\n\nsub nodelete{\n    my $self = shift;\n    return $self->{'nodelete'} = shift if @_;\n    return $self->{'nodelete'};\n}\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Tree::NodeI objects\n Returns : array of Bio::Tree::NodeI objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self, @args) = @_;\n   \n   my ($order, $sortby) = $self->_rearrange([qw(ORDER SORTBY)],@args);\n   $order ||= 'depth';\n   $sortby ||= 'none';\n   my $node = $self->get_root_node || return;\n   if ($order =~ m/^b|(breadth)$/oi) {\n       my @children = ($node);\n       for (@children) {\n        push @children, $_->each_Descendent($sortby);\n       }\n       return @children;\n   }\n\n   if ($order =~ m/^d|(depth)$/oi) {\n       # this is depth-first search I believe\n       my @children = ($node,$node->get_all_Descendents($sortby));\n       return @children;\n   }\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Tree::NodeI object\n Args    : none\n\n\n\nsub get_root_node{\n   my ($self) = @_;\n   return $self->{'_rootnode'};\n}\n\n=head2 set_root_node\n\n Title   : set_root_node\n Usage   : $tree->set_root_node($node)\n Function: Set the Root Node for the Tree\n Returns : Bio::Tree::NodeI\n Args    : Bio::Tree::NodeI\n\n\nsub set_root_node{\n   my $self = shift;\n   if( @_ ) { \n       my $value = shift;\n       if( defined $value && \n       ! $value->isa('Bio::Tree::NodeI') ) { \n       $self->warn(\"Trying to set the root node to $value which is not a Bio::Tree::NodeI\");\n       return $self->get_root_node;\n       }\n       $self->{'_rootnode'} = $value;\n   } \n   return $self->get_root_node;\n}\n\n=head2 total_branch_length\n\n Title   : total_branch_length\n Usage   : my $size = $tree->total_branch_length\n Function: Returns the sum of the length of all branches\n Returns : real\n Args    : none\n\n\nsub total_branch_length { shift->subtree_length }\n\n=head2 subtree_length\n\n Title   : subtree_length\n Usage   : my $subtree_size = $tree->subtree_length($internal_node)\n Function: Returns the sum of the length of all branches in a subtree\n           under the node. Calculates the size of the whole tree\n           without an argument (but only if root node is defined)\n Returns : real or undef\n Args    : Bio::Tree::NodeI object, defaults to the root node\n\n\nsub subtree_length {\n    my $tree = shift;\n    my $node = shift || $tree->get_root_node;\n    return unless $node;\n    my $sum = 0;\n    for ( $node->get_all_Descendents ) {\n    $sum += $_->branch_length || 0;\n    }\n    return $sum;\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : my $id = $tree->id();\n Function: An id value for the tree\n Returns : scalar\n Args    : [optional] new value to set\n\n\n\nsub id{\n   my ($self,$val) = @_;\n   if( defined $val ) { \n       $self->{'_treeid'} = $val;\n   }\n   return $self->{'_treeid'};\n}\n\n=head2 score\n\n Title   : score\n Usage   : $obj->score($newval)\n Function: Sets the associated score with this tree\n           This is a generic slot which is probably best used \n           for log likelihood or other overall tree score\n Returns : value of score\n Args    : newvalue (optional)\n\n\n\nsub score{\n   my ($self,$val) = @_;\n   if( defined $val ) { \n       $self->{'_score'} = $val;\n   }\n   return $self->{'_score'};\n}\n\n\n# decorated interface TreeI Implements this\n\n=head2 height\n\n Title   : height\n Usage   : my $height = $tree->height\n Function: Gets the height of tree - this LOG_2($number_nodes)\n           WARNING: this is only true for strict binary trees.  The TreeIO\n           system is capable of building non-binary trees, for which this\n           method will currently return an incorrect value!!\n Returns : integer\n Args    : none\n\n=head2 number_nodes\n\n Title   : number_nodes\n Usage   : my $size = $tree->number_nodes\n Function: Returns the number of nodes in the tree\n Returns : integer\n Args    : none\n\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   : my $tree_as_string = $tree->as_text($format)\n Function: Returns the tree as a string representation in the \n           desired format (currently 'newick', 'nhx', or \n           'tabtree')\n Returns : scalar string\n Args    : format type as specified by Bio::TreeIO\n Note    : This method loads the Bio::TreeIO::$format module\n           on the fly, and commandeers the _write_tree_Helper\n           routine therein to create the tree string. \n\n\nsub as_text {\n    my $self = shift;\n    my $format = shift;\n    my @parms;\n    my $iomod = \"Bio::TreeIO::$format\";\n    $self->_load_module($iomod);\n    # following currently not really necessary, but who knows?\n    my $io = $iomod->new(-format=>$format, -file=>File::Spec->devnull());\n    no strict \"refs\";\n    my $iowtH = *{$iomod.\"::_write_tree_Helper\"}{CODE};\n    use strict \"refs\";\n    for ($format) {\n\t/newick/ && do {\n\t    @parms = ( $io->bootstrap_style, $io->order_by, 0 );\n\t    last;\n\t};\n\t/nhx/ && do {\n\t    @parms = ( 0 );\n\t    last;\n\t};\n\t/tabtree/ && do {\n\t    @parms = ( \"\" );\n\t    last;\n\t};\n\t# default\n\t$self->throw(\"as_text does not allow format '$format'\") \n    }\n\t\n\n    # newline_each_node...\n    my $data = [$iowtH->($self->get_root_node, @parms)];\n\n    if ($format eq 'tabtree') {\n\treturn $$data[0].\"\\n\";\n    }\n    else {\n\treturn join(\",\", @$data).\";\\n\";\n    }\n}\n\n=head2 Methods for associating Tag/Values with a Tree\n\nThese methods associate tag/value pairs with a Tree\n\n=head2 set_tag_value\n\n Title   : set_tag_value\n Usage   : $tree->set_tag_value($tag,$value)\n           $tree->set_tag_value($tag,@values)\n Function: Sets a tag value(s) to a tree. Replaces old values.\n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag","parameters":[{"label":"$self"},{"label":"$tag"},{"label":"@values"}]},"detail":"($self,$tag,@values)","name":"set_tag_value","range":{"end":{"line":437,"character":9999},"start":{"character":0,"line":431}}},{"containerName":null,"name":"@values","kind":13,"line":437},{"name":"%self","containerName":null,"line":438,"kind":13},{"line":438,"kind":13,"containerName":null,"name":"$tag"},{"name":"add_tag_value","range":{"end":{"character":9999,"line":457},"start":{"character":0,"line":452}},"definition":"sub","containerName":"main::","signature":{"label":"add_tag_value($self,$tag,$value)","documentation":"1;\n# $Id: Tree.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::Tree - An Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Nodes which make up a tree.\n\n=head1 IMPLEMENTATION NOTE\n\nThis implementation of Bio::Tree::Tree contains Bio::Tree:::NodeI; mainly linked\nvia the root node. As NodeI can potentially contain circular references (as\nnodes will need to refer to both parent and child nodes), Bio::Tree::Tree will\nremove those circular references when the object is garbage-collected. This has\nsome side effects; primarily, one must keep the Tree in scope or have at least\none reference to it if working with nodes. The fix is to count the references to\nthe nodes and if it is greater than expected retain all of them, but it requires\nan additional prereq and thus may not be worth the effort.  This only shows up\nin minor edge cases, though (see Bug #2869).\n\nExample of issue:\n\n  # tree is not assigned to a variable, so passes from memory after\n  # root node is passed\n  my $root = Bio::TreeIO->new(-format => 'newick', -file => 'foo.txt')->next_tree\n\t\t ->get_root_node;\n  \n  # gets nothing, as all Node links are broken when Tree is garbage-collected above\n  my @descendents = $root->get_all_Descendents;\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\nSendu Bala   bix@sendu.me.uk\nMark A. Jensen maj@fortinbras.us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::Tree->new();\n Function: Builds a new Bio::Tree::Tree object \n Returns : Bio::Tree::Tree\n Args    : -root     => L<Bio::Tree::NodeI> object which is the root\n             OR\n           -node     => L<Bio::Tree::NodeI> object from which the root will be\n                        determined\n\n           -nodelete => boolean, whether or not to try and cleanup all\n                                 the nodes when this this tree goes out\n                                 of scope.\n           -id       => optional tree ID\n           -score    => optional tree score value\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n  $self->_register_for_cleanup(\\&cleanup_tree);\n  my ($root,$node,$nodel,$id,$score)= $self->_rearrange([qw(ROOT NODE NODELETE \n                              ID SCORE)], @args);\n  \n  if ($node && ! $root) {\n    $self->throw(\"Must supply a Bio::Tree::NodeI\") unless ref($node) && $node->isa('Bio::Tree::NodeI');\n    my @lineage = $self->get_lineage_nodes($node);\n    $root = shift(@lineage) || $node;\n    \n    # to stop us pulling in entire database of a Bio::Taxon when we later do\n    # get_nodes() or similar, specifically set ancestor() for each node\n    if ($node->isa('Bio::Taxon')) {\n      push(@lineage, $node) unless $node eq $root;\n      my $ancestor = $root;\n      foreach my $lineage_node (@lineage) {\n        $lineage_node->ancestor($ancestor);\n      } continue { $ancestor = $lineage_node; }\n    }\n  }\n  if ($root) {\n    $self->set_root_node($root);\n  }\n  \n  $self->nodelete($nodel || 0);\n  $self->id($id)       if defined $id;\n  $self->score($score) if defined $score;\n  return $self;\n}\n\n\n=head2 nodelete\n\n Title   : nodelete\n Usage   : $obj->nodelete($newval)\n Function: Get/Set Boolean whether or not to delete the underlying\n           nodes when it goes out of scope.  By default this is false\n           meaning trees are cleaned up.\n Returns : boolean\n Args    : on set, new boolean value\n\n\nsub nodelete{\n    my $self = shift;\n    return $self->{'nodelete'} = shift if @_;\n    return $self->{'nodelete'};\n}\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Tree::NodeI objects\n Returns : array of Bio::Tree::NodeI objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self, @args) = @_;\n   \n   my ($order, $sortby) = $self->_rearrange([qw(ORDER SORTBY)],@args);\n   $order ||= 'depth';\n   $sortby ||= 'none';\n   my $node = $self->get_root_node || return;\n   if ($order =~ m/^b|(breadth)$/oi) {\n       my @children = ($node);\n       for (@children) {\n        push @children, $_->each_Descendent($sortby);\n       }\n       return @children;\n   }\n\n   if ($order =~ m/^d|(depth)$/oi) {\n       # this is depth-first search I believe\n       my @children = ($node,$node->get_all_Descendents($sortby));\n       return @children;\n   }\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Tree::NodeI object\n Args    : none\n\n\n\nsub get_root_node{\n   my ($self) = @_;\n   return $self->{'_rootnode'};\n}\n\n=head2 set_root_node\n\n Title   : set_root_node\n Usage   : $tree->set_root_node($node)\n Function: Set the Root Node for the Tree\n Returns : Bio::Tree::NodeI\n Args    : Bio::Tree::NodeI\n\n\nsub set_root_node{\n   my $self = shift;\n   if( @_ ) { \n       my $value = shift;\n       if( defined $value && \n       ! $value->isa('Bio::Tree::NodeI') ) { \n       $self->warn(\"Trying to set the root node to $value which is not a Bio::Tree::NodeI\");\n       return $self->get_root_node;\n       }\n       $self->{'_rootnode'} = $value;\n   } \n   return $self->get_root_node;\n}\n\n=head2 total_branch_length\n\n Title   : total_branch_length\n Usage   : my $size = $tree->total_branch_length\n Function: Returns the sum of the length of all branches\n Returns : real\n Args    : none\n\n\nsub total_branch_length { shift->subtree_length }\n\n=head2 subtree_length\n\n Title   : subtree_length\n Usage   : my $subtree_size = $tree->subtree_length($internal_node)\n Function: Returns the sum of the length of all branches in a subtree\n           under the node. Calculates the size of the whole tree\n           without an argument (but only if root node is defined)\n Returns : real or undef\n Args    : Bio::Tree::NodeI object, defaults to the root node\n\n\nsub subtree_length {\n    my $tree = shift;\n    my $node = shift || $tree->get_root_node;\n    return unless $node;\n    my $sum = 0;\n    for ( $node->get_all_Descendents ) {\n    $sum += $_->branch_length || 0;\n    }\n    return $sum;\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : my $id = $tree->id();\n Function: An id value for the tree\n Returns : scalar\n Args    : [optional] new value to set\n\n\n\nsub id{\n   my ($self,$val) = @_;\n   if( defined $val ) { \n       $self->{'_treeid'} = $val;\n   }\n   return $self->{'_treeid'};\n}\n\n=head2 score\n\n Title   : score\n Usage   : $obj->score($newval)\n Function: Sets the associated score with this tree\n           This is a generic slot which is probably best used \n           for log likelihood or other overall tree score\n Returns : value of score\n Args    : newvalue (optional)\n\n\n\nsub score{\n   my ($self,$val) = @_;\n   if( defined $val ) { \n       $self->{'_score'} = $val;\n   }\n   return $self->{'_score'};\n}\n\n\n# decorated interface TreeI Implements this\n\n=head2 height\n\n Title   : height\n Usage   : my $height = $tree->height\n Function: Gets the height of tree - this LOG_2($number_nodes)\n           WARNING: this is only true for strict binary trees.  The TreeIO\n           system is capable of building non-binary trees, for which this\n           method will currently return an incorrect value!!\n Returns : integer\n Args    : none\n\n=head2 number_nodes\n\n Title   : number_nodes\n Usage   : my $size = $tree->number_nodes\n Function: Returns the number of nodes in the tree\n Returns : integer\n Args    : none\n\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   : my $tree_as_string = $tree->as_text($format)\n Function: Returns the tree as a string representation in the \n           desired format (currently 'newick', 'nhx', or \n           'tabtree')\n Returns : scalar string\n Args    : format type as specified by Bio::TreeIO\n Note    : This method loads the Bio::TreeIO::$format module\n           on the fly, and commandeers the _write_tree_Helper\n           routine therein to create the tree string. \n\n\nsub as_text {\n    my $self = shift;\n    my $format = shift;\n    my @parms;\n    my $iomod = \"Bio::TreeIO::$format\";\n    $self->_load_module($iomod);\n    # following currently not really necessary, but who knows?\n    my $io = $iomod->new(-format=>$format, -file=>File::Spec->devnull());\n    no strict \"refs\";\n    my $iowtH = *{$iomod.\"::_write_tree_Helper\"}{CODE};\n    use strict \"refs\";\n    for ($format) {\n\t/newick/ && do {\n\t    @parms = ( $io->bootstrap_style, $io->order_by, 0 );\n\t    last;\n\t};\n\t/nhx/ && do {\n\t    @parms = ( 0 );\n\t    last;\n\t};\n\t/tabtree/ && do {\n\t    @parms = ( \"\" );\n\t    last;\n\t};\n\t# default\n\t$self->throw(\"as_text does not allow format '$format'\") \n    }\n\t\n\n    # newline_each_node...\n    my $data = [$iowtH->($self->get_root_node, @parms)];\n\n    if ($format eq 'tabtree') {\n\treturn $$data[0].\"\\n\";\n    }\n    else {\n\treturn join(\",\", @$data).\";\\n\";\n    }\n}\n\n=head2 Methods for associating Tag/Values with a Tree\n\nThese methods associate tag/value pairs with a Tree\n\n=head2 set_tag_value\n\n Title   : set_tag_value\n Usage   : $tree->set_tag_value($tag,$value)\n           $tree->set_tag_value($tag,@values)\n Function: Sets a tag value(s) to a tree. Replaces old values.\n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag\n\n\nsub set_tag_value{\n    my ($self,$tag,@values) = @_;\n    if( ! defined $tag || ! scalar @values ) {\n    $self->warn(\"cannot call set_tag_value with an undefined value\");\n    }\n    $self->remove_tag ($tag);\n    map { push @{$self->{'_tags'}->{$tag}}, $_ } @values;\n    return scalar @{$self->{'_tags'}->{$tag}};\n}\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $tree->add_tag_value($tag,$value)\n Function: Adds a tag value to a tree \n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag","parameters":[{"label":"$self"},{"label":"$tag"},{"label":"$value"}]},"detail":"($self,$tag,$value)","kind":12,"children":[{"containerName":"add_tag_value","name":"$self","definition":"my","localvar":"my","kind":13,"line":453},{"name":"$tag","containerName":"add_tag_value","kind":13,"line":453},{"kind":13,"line":453,"containerName":"add_tag_value","name":"$value"},{"kind":13,"line":454,"containerName":"add_tag_value","name":"$tag"},{"line":454,"kind":13,"containerName":"add_tag_value","name":"$value"},{"line":455,"kind":13,"name":"$self","containerName":"add_tag_value"},{"name":"warn","containerName":"add_tag_value","kind":12,"line":455},{"name":"$self","containerName":"add_tag_value","kind":13,"line":457},{"kind":13,"line":457,"name":"$tag","containerName":"add_tag_value"}],"line":452},{"kind":13,"line":457,"name":"$value","containerName":null},{"kind":13,"line":458,"containerName":null,"name":"%self"},{"containerName":null,"name":"$tag","line":458,"kind":13},{"line":472,"children":[{"kind":13,"line":473,"containerName":"remove_tag","definition":"my","name":"$self","localvar":"my"},{"name":"$tag","containerName":"remove_tag","line":473,"kind":13},{"kind":13,"line":474,"name":"$self","containerName":"remove_tag"},{"containerName":"remove_tag","name":"$tag","line":474,"kind":13},{"kind":13,"line":475,"name":"$self","containerName":"remove_tag"},{"name":"$tag","containerName":"remove_tag","line":475,"kind":13},{"containerName":"remove_tag","name":"$self","line":476,"kind":13},{"line":476,"kind":13,"containerName":"remove_tag","name":"$tag"}],"kind":12,"detail":"($self,$tag)","signature":{"label":"remove_tag($self,$tag)","documentation":"1;\n# $Id: Tree.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::Tree - An Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Nodes which make up a tree.\n\n=head1 IMPLEMENTATION NOTE\n\nThis implementation of Bio::Tree::Tree contains Bio::Tree:::NodeI; mainly linked\nvia the root node. As NodeI can potentially contain circular references (as\nnodes will need to refer to both parent and child nodes), Bio::Tree::Tree will\nremove those circular references when the object is garbage-collected. This has\nsome side effects; primarily, one must keep the Tree in scope or have at least\none reference to it if working with nodes. The fix is to count the references to\nthe nodes and if it is greater than expected retain all of them, but it requires\nan additional prereq and thus may not be worth the effort.  This only shows up\nin minor edge cases, though (see Bug #2869).\n\nExample of issue:\n\n  # tree is not assigned to a variable, so passes from memory after\n  # root node is passed\n  my $root = Bio::TreeIO->new(-format => 'newick', -file => 'foo.txt')->next_tree\n\t\t ->get_root_node;\n  \n  # gets nothing, as all Node links are broken when Tree is garbage-collected above\n  my @descendents = $root->get_all_Descendents;\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\nSendu Bala   bix@sendu.me.uk\nMark A. Jensen maj@fortinbras.us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::Tree->new();\n Function: Builds a new Bio::Tree::Tree object \n Returns : Bio::Tree::Tree\n Args    : -root     => L<Bio::Tree::NodeI> object which is the root\n             OR\n           -node     => L<Bio::Tree::NodeI> object from which the root will be\n                        determined\n\n           -nodelete => boolean, whether or not to try and cleanup all\n                                 the nodes when this this tree goes out\n                                 of scope.\n           -id       => optional tree ID\n           -score    => optional tree score value\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n  $self->_register_for_cleanup(\\&cleanup_tree);\n  my ($root,$node,$nodel,$id,$score)= $self->_rearrange([qw(ROOT NODE NODELETE \n                              ID SCORE)], @args);\n  \n  if ($node && ! $root) {\n    $self->throw(\"Must supply a Bio::Tree::NodeI\") unless ref($node) && $node->isa('Bio::Tree::NodeI');\n    my @lineage = $self->get_lineage_nodes($node);\n    $root = shift(@lineage) || $node;\n    \n    # to stop us pulling in entire database of a Bio::Taxon when we later do\n    # get_nodes() or similar, specifically set ancestor() for each node\n    if ($node->isa('Bio::Taxon')) {\n      push(@lineage, $node) unless $node eq $root;\n      my $ancestor = $root;\n      foreach my $lineage_node (@lineage) {\n        $lineage_node->ancestor($ancestor);\n      } continue { $ancestor = $lineage_node; }\n    }\n  }\n  if ($root) {\n    $self->set_root_node($root);\n  }\n  \n  $self->nodelete($nodel || 0);\n  $self->id($id)       if defined $id;\n  $self->score($score) if defined $score;\n  return $self;\n}\n\n\n=head2 nodelete\n\n Title   : nodelete\n Usage   : $obj->nodelete($newval)\n Function: Get/Set Boolean whether or not to delete the underlying\n           nodes when it goes out of scope.  By default this is false\n           meaning trees are cleaned up.\n Returns : boolean\n Args    : on set, new boolean value\n\n\nsub nodelete{\n    my $self = shift;\n    return $self->{'nodelete'} = shift if @_;\n    return $self->{'nodelete'};\n}\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Tree::NodeI objects\n Returns : array of Bio::Tree::NodeI objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self, @args) = @_;\n   \n   my ($order, $sortby) = $self->_rearrange([qw(ORDER SORTBY)],@args);\n   $order ||= 'depth';\n   $sortby ||= 'none';\n   my $node = $self->get_root_node || return;\n   if ($order =~ m/^b|(breadth)$/oi) {\n       my @children = ($node);\n       for (@children) {\n        push @children, $_->each_Descendent($sortby);\n       }\n       return @children;\n   }\n\n   if ($order =~ m/^d|(depth)$/oi) {\n       # this is depth-first search I believe\n       my @children = ($node,$node->get_all_Descendents($sortby));\n       return @children;\n   }\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Tree::NodeI object\n Args    : none\n\n\n\nsub get_root_node{\n   my ($self) = @_;\n   return $self->{'_rootnode'};\n}\n\n=head2 set_root_node\n\n Title   : set_root_node\n Usage   : $tree->set_root_node($node)\n Function: Set the Root Node for the Tree\n Returns : Bio::Tree::NodeI\n Args    : Bio::Tree::NodeI\n\n\nsub set_root_node{\n   my $self = shift;\n   if( @_ ) { \n       my $value = shift;\n       if( defined $value && \n       ! $value->isa('Bio::Tree::NodeI') ) { \n       $self->warn(\"Trying to set the root node to $value which is not a Bio::Tree::NodeI\");\n       return $self->get_root_node;\n       }\n       $self->{'_rootnode'} = $value;\n   } \n   return $self->get_root_node;\n}\n\n=head2 total_branch_length\n\n Title   : total_branch_length\n Usage   : my $size = $tree->total_branch_length\n Function: Returns the sum of the length of all branches\n Returns : real\n Args    : none\n\n\nsub total_branch_length { shift->subtree_length }\n\n=head2 subtree_length\n\n Title   : subtree_length\n Usage   : my $subtree_size = $tree->subtree_length($internal_node)\n Function: Returns the sum of the length of all branches in a subtree\n           under the node. Calculates the size of the whole tree\n           without an argument (but only if root node is defined)\n Returns : real or undef\n Args    : Bio::Tree::NodeI object, defaults to the root node\n\n\nsub subtree_length {\n    my $tree = shift;\n    my $node = shift || $tree->get_root_node;\n    return unless $node;\n    my $sum = 0;\n    for ( $node->get_all_Descendents ) {\n    $sum += $_->branch_length || 0;\n    }\n    return $sum;\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : my $id = $tree->id();\n Function: An id value for the tree\n Returns : scalar\n Args    : [optional] new value to set\n\n\n\nsub id{\n   my ($self,$val) = @_;\n   if( defined $val ) { \n       $self->{'_treeid'} = $val;\n   }\n   return $self->{'_treeid'};\n}\n\n=head2 score\n\n Title   : score\n Usage   : $obj->score($newval)\n Function: Sets the associated score with this tree\n           This is a generic slot which is probably best used \n           for log likelihood or other overall tree score\n Returns : value of score\n Args    : newvalue (optional)\n\n\n\nsub score{\n   my ($self,$val) = @_;\n   if( defined $val ) { \n       $self->{'_score'} = $val;\n   }\n   return $self->{'_score'};\n}\n\n\n# decorated interface TreeI Implements this\n\n=head2 height\n\n Title   : height\n Usage   : my $height = $tree->height\n Function: Gets the height of tree - this LOG_2($number_nodes)\n           WARNING: this is only true for strict binary trees.  The TreeIO\n           system is capable of building non-binary trees, for which this\n           method will currently return an incorrect value!!\n Returns : integer\n Args    : none\n\n=head2 number_nodes\n\n Title   : number_nodes\n Usage   : my $size = $tree->number_nodes\n Function: Returns the number of nodes in the tree\n Returns : integer\n Args    : none\n\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   : my $tree_as_string = $tree->as_text($format)\n Function: Returns the tree as a string representation in the \n           desired format (currently 'newick', 'nhx', or \n           'tabtree')\n Returns : scalar string\n Args    : format type as specified by Bio::TreeIO\n Note    : This method loads the Bio::TreeIO::$format module\n           on the fly, and commandeers the _write_tree_Helper\n           routine therein to create the tree string. \n\n\nsub as_text {\n    my $self = shift;\n    my $format = shift;\n    my @parms;\n    my $iomod = \"Bio::TreeIO::$format\";\n    $self->_load_module($iomod);\n    # following currently not really necessary, but who knows?\n    my $io = $iomod->new(-format=>$format, -file=>File::Spec->devnull());\n    no strict \"refs\";\n    my $iowtH = *{$iomod.\"::_write_tree_Helper\"}{CODE};\n    use strict \"refs\";\n    for ($format) {\n\t/newick/ && do {\n\t    @parms = ( $io->bootstrap_style, $io->order_by, 0 );\n\t    last;\n\t};\n\t/nhx/ && do {\n\t    @parms = ( 0 );\n\t    last;\n\t};\n\t/tabtree/ && do {\n\t    @parms = ( \"\" );\n\t    last;\n\t};\n\t# default\n\t$self->throw(\"as_text does not allow format '$format'\") \n    }\n\t\n\n    # newline_each_node...\n    my $data = [$iowtH->($self->get_root_node, @parms)];\n\n    if ($format eq 'tabtree') {\n\treturn $$data[0].\"\\n\";\n    }\n    else {\n\treturn join(\",\", @$data).\";\\n\";\n    }\n}\n\n=head2 Methods for associating Tag/Values with a Tree\n\nThese methods associate tag/value pairs with a Tree\n\n=head2 set_tag_value\n\n Title   : set_tag_value\n Usage   : $tree->set_tag_value($tag,$value)\n           $tree->set_tag_value($tag,@values)\n Function: Sets a tag value(s) to a tree. Replaces old values.\n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag\n\n\nsub set_tag_value{\n    my ($self,$tag,@values) = @_;\n    if( ! defined $tag || ! scalar @values ) {\n    $self->warn(\"cannot call set_tag_value with an undefined value\");\n    }\n    $self->remove_tag ($tag);\n    map { push @{$self->{'_tags'}->{$tag}}, $_ } @values;\n    return scalar @{$self->{'_tags'}->{$tag}};\n}\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $tree->add_tag_value($tag,$value)\n Function: Adds a tag value to a tree \n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag\n\n\nsub add_tag_value{\n    my ($self,$tag,$value) = @_;\n    if( ! defined $tag || ! defined $value ) {\n    $self->warn(\"cannot call add_tag_value with an undefined value\");\n    }\n    push @{$self->{'_tags'}->{$tag}}, $value;\n    return scalar @{$self->{'_tags'}->{$tag}};\n}\n\n=head2 remove_tag\n\n Title   : remove_tag\n Usage   : $tree->remove_tag($tag)\n Function: Remove the tag and all values for this tag\n Returns : boolean representing success (0 if tag does not exist)\n Args    : $tag - tagname to remove","parameters":[{"label":"$self"},{"label":"$tag"}]},"containerName":"main::","definition":"sub","range":{"start":{"line":472,"character":0},"end":{"character":9999,"line":480}},"name":"remove_tag"},{"range":{"end":{"character":9999,"line":496},"start":{"character":0,"line":492}},"name":"remove_all_tags","signature":{"label":"remove_all_tags($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Tree.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::Tree - An Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Nodes which make up a tree.\n\n=head1 IMPLEMENTATION NOTE\n\nThis implementation of Bio::Tree::Tree contains Bio::Tree:::NodeI; mainly linked\nvia the root node. As NodeI can potentially contain circular references (as\nnodes will need to refer to both parent and child nodes), Bio::Tree::Tree will\nremove those circular references when the object is garbage-collected. This has\nsome side effects; primarily, one must keep the Tree in scope or have at least\none reference to it if working with nodes. The fix is to count the references to\nthe nodes and if it is greater than expected retain all of them, but it requires\nan additional prereq and thus may not be worth the effort.  This only shows up\nin minor edge cases, though (see Bug #2869).\n\nExample of issue:\n\n  # tree is not assigned to a variable, so passes from memory after\n  # root node is passed\n  my $root = Bio::TreeIO->new(-format => 'newick', -file => 'foo.txt')->next_tree\n\t\t ->get_root_node;\n  \n  # gets nothing, as all Node links are broken when Tree is garbage-collected above\n  my @descendents = $root->get_all_Descendents;\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\nSendu Bala   bix@sendu.me.uk\nMark A. Jensen maj@fortinbras.us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::Tree->new();\n Function: Builds a new Bio::Tree::Tree object \n Returns : Bio::Tree::Tree\n Args    : -root     => L<Bio::Tree::NodeI> object which is the root\n             OR\n           -node     => L<Bio::Tree::NodeI> object from which the root will be\n                        determined\n\n           -nodelete => boolean, whether or not to try and cleanup all\n                                 the nodes when this this tree goes out\n                                 of scope.\n           -id       => optional tree ID\n           -score    => optional tree score value\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n  $self->_register_for_cleanup(\\&cleanup_tree);\n  my ($root,$node,$nodel,$id,$score)= $self->_rearrange([qw(ROOT NODE NODELETE \n                              ID SCORE)], @args);\n  \n  if ($node && ! $root) {\n    $self->throw(\"Must supply a Bio::Tree::NodeI\") unless ref($node) && $node->isa('Bio::Tree::NodeI');\n    my @lineage = $self->get_lineage_nodes($node);\n    $root = shift(@lineage) || $node;\n    \n    # to stop us pulling in entire database of a Bio::Taxon when we later do\n    # get_nodes() or similar, specifically set ancestor() for each node\n    if ($node->isa('Bio::Taxon')) {\n      push(@lineage, $node) unless $node eq $root;\n      my $ancestor = $root;\n      foreach my $lineage_node (@lineage) {\n        $lineage_node->ancestor($ancestor);\n      } continue { $ancestor = $lineage_node; }\n    }\n  }\n  if ($root) {\n    $self->set_root_node($root);\n  }\n  \n  $self->nodelete($nodel || 0);\n  $self->id($id)       if defined $id;\n  $self->score($score) if defined $score;\n  return $self;\n}\n\n\n=head2 nodelete\n\n Title   : nodelete\n Usage   : $obj->nodelete($newval)\n Function: Get/Set Boolean whether or not to delete the underlying\n           nodes when it goes out of scope.  By default this is false\n           meaning trees are cleaned up.\n Returns : boolean\n Args    : on set, new boolean value\n\n\nsub nodelete{\n    my $self = shift;\n    return $self->{'nodelete'} = shift if @_;\n    return $self->{'nodelete'};\n}\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Tree::NodeI objects\n Returns : array of Bio::Tree::NodeI objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self, @args) = @_;\n   \n   my ($order, $sortby) = $self->_rearrange([qw(ORDER SORTBY)],@args);\n   $order ||= 'depth';\n   $sortby ||= 'none';\n   my $node = $self->get_root_node || return;\n   if ($order =~ m/^b|(breadth)$/oi) {\n       my @children = ($node);\n       for (@children) {\n        push @children, $_->each_Descendent($sortby);\n       }\n       return @children;\n   }\n\n   if ($order =~ m/^d|(depth)$/oi) {\n       # this is depth-first search I believe\n       my @children = ($node,$node->get_all_Descendents($sortby));\n       return @children;\n   }\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Tree::NodeI object\n Args    : none\n\n\n\nsub get_root_node{\n   my ($self) = @_;\n   return $self->{'_rootnode'};\n}\n\n=head2 set_root_node\n\n Title   : set_root_node\n Usage   : $tree->set_root_node($node)\n Function: Set the Root Node for the Tree\n Returns : Bio::Tree::NodeI\n Args    : Bio::Tree::NodeI\n\n\nsub set_root_node{\n   my $self = shift;\n   if( @_ ) { \n       my $value = shift;\n       if( defined $value && \n       ! $value->isa('Bio::Tree::NodeI') ) { \n       $self->warn(\"Trying to set the root node to $value which is not a Bio::Tree::NodeI\");\n       return $self->get_root_node;\n       }\n       $self->{'_rootnode'} = $value;\n   } \n   return $self->get_root_node;\n}\n\n=head2 total_branch_length\n\n Title   : total_branch_length\n Usage   : my $size = $tree->total_branch_length\n Function: Returns the sum of the length of all branches\n Returns : real\n Args    : none\n\n\nsub total_branch_length { shift->subtree_length }\n\n=head2 subtree_length\n\n Title   : subtree_length\n Usage   : my $subtree_size = $tree->subtree_length($internal_node)\n Function: Returns the sum of the length of all branches in a subtree\n           under the node. Calculates the size of the whole tree\n           without an argument (but only if root node is defined)\n Returns : real or undef\n Args    : Bio::Tree::NodeI object, defaults to the root node\n\n\nsub subtree_length {\n    my $tree = shift;\n    my $node = shift || $tree->get_root_node;\n    return unless $node;\n    my $sum = 0;\n    for ( $node->get_all_Descendents ) {\n    $sum += $_->branch_length || 0;\n    }\n    return $sum;\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : my $id = $tree->id();\n Function: An id value for the tree\n Returns : scalar\n Args    : [optional] new value to set\n\n\n\nsub id{\n   my ($self,$val) = @_;\n   if( defined $val ) { \n       $self->{'_treeid'} = $val;\n   }\n   return $self->{'_treeid'};\n}\n\n=head2 score\n\n Title   : score\n Usage   : $obj->score($newval)\n Function: Sets the associated score with this tree\n           This is a generic slot which is probably best used \n           for log likelihood or other overall tree score\n Returns : value of score\n Args    : newvalue (optional)\n\n\n\nsub score{\n   my ($self,$val) = @_;\n   if( defined $val ) { \n       $self->{'_score'} = $val;\n   }\n   return $self->{'_score'};\n}\n\n\n# decorated interface TreeI Implements this\n\n=head2 height\n\n Title   : height\n Usage   : my $height = $tree->height\n Function: Gets the height of tree - this LOG_2($number_nodes)\n           WARNING: this is only true for strict binary trees.  The TreeIO\n           system is capable of building non-binary trees, for which this\n           method will currently return an incorrect value!!\n Returns : integer\n Args    : none\n\n=head2 number_nodes\n\n Title   : number_nodes\n Usage   : my $size = $tree->number_nodes\n Function: Returns the number of nodes in the tree\n Returns : integer\n Args    : none\n\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   : my $tree_as_string = $tree->as_text($format)\n Function: Returns the tree as a string representation in the \n           desired format (currently 'newick', 'nhx', or \n           'tabtree')\n Returns : scalar string\n Args    : format type as specified by Bio::TreeIO\n Note    : This method loads the Bio::TreeIO::$format module\n           on the fly, and commandeers the _write_tree_Helper\n           routine therein to create the tree string. \n\n\nsub as_text {\n    my $self = shift;\n    my $format = shift;\n    my @parms;\n    my $iomod = \"Bio::TreeIO::$format\";\n    $self->_load_module($iomod);\n    # following currently not really necessary, but who knows?\n    my $io = $iomod->new(-format=>$format, -file=>File::Spec->devnull());\n    no strict \"refs\";\n    my $iowtH = *{$iomod.\"::_write_tree_Helper\"}{CODE};\n    use strict \"refs\";\n    for ($format) {\n\t/newick/ && do {\n\t    @parms = ( $io->bootstrap_style, $io->order_by, 0 );\n\t    last;\n\t};\n\t/nhx/ && do {\n\t    @parms = ( 0 );\n\t    last;\n\t};\n\t/tabtree/ && do {\n\t    @parms = ( \"\" );\n\t    last;\n\t};\n\t# default\n\t$self->throw(\"as_text does not allow format '$format'\") \n    }\n\t\n\n    # newline_each_node...\n    my $data = [$iowtH->($self->get_root_node, @parms)];\n\n    if ($format eq 'tabtree') {\n\treturn $$data[0].\"\\n\";\n    }\n    else {\n\treturn join(\",\", @$data).\";\\n\";\n    }\n}\n\n=head2 Methods for associating Tag/Values with a Tree\n\nThese methods associate tag/value pairs with a Tree\n\n=head2 set_tag_value\n\n Title   : set_tag_value\n Usage   : $tree->set_tag_value($tag,$value)\n           $tree->set_tag_value($tag,@values)\n Function: Sets a tag value(s) to a tree. Replaces old values.\n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag\n\n\nsub set_tag_value{\n    my ($self,$tag,@values) = @_;\n    if( ! defined $tag || ! scalar @values ) {\n    $self->warn(\"cannot call set_tag_value with an undefined value\");\n    }\n    $self->remove_tag ($tag);\n    map { push @{$self->{'_tags'}->{$tag}}, $_ } @values;\n    return scalar @{$self->{'_tags'}->{$tag}};\n}\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $tree->add_tag_value($tag,$value)\n Function: Adds a tag value to a tree \n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag\n\n\nsub add_tag_value{\n    my ($self,$tag,$value) = @_;\n    if( ! defined $tag || ! defined $value ) {\n    $self->warn(\"cannot call add_tag_value with an undefined value\");\n    }\n    push @{$self->{'_tags'}->{$tag}}, $value;\n    return scalar @{$self->{'_tags'}->{$tag}};\n}\n\n=head2 remove_tag\n\n Title   : remove_tag\n Usage   : $tree->remove_tag($tag)\n Function: Remove the tag and all values for this tag\n Returns : boolean representing success (0 if tag does not exist)\n Args    : $tag - tagname to remove\n\n\n\nsub remove_tag {\n   my ($self,$tag) = @_;\n   if( exists $self->{'_tags'}->{$tag} ) {\n       $self->{'_tags'}->{$tag} = undef;\n       delete $self->{'_tags'}->{$tag};\n       return 1;\n   }\n   return 0;\n}\n\n=head2 remove_all_tags\n\n Title   : remove_all_tags\n Usage   : $tree->remove_all_tags()\n Function: Removes all tags \n Returns : None\n Args    : None"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"remove_all_tags","localvar":"my","kind":13,"line":493},{"containerName":"remove_all_tags","name":"$self","line":494,"kind":13}],"line":492,"kind":12},{"range":{"start":{"character":0,"line":508},"end":{"line":510,"character":9999}},"name":"get_all_tags","line":508,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"get_all_tags","line":509,"kind":13},{"line":510,"kind":13,"localvar":"my","containerName":"get_all_tags","definition":"my","name":"@tags"},{"line":510,"kind":13,"containerName":"get_all_tags","name":"$self"}],"kind":12,"detail":"($self)","signature":{"documentation":"1;\n# $Id: Tree.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::Tree - An Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Nodes which make up a tree.\n\n=head1 IMPLEMENTATION NOTE\n\nThis implementation of Bio::Tree::Tree contains Bio::Tree:::NodeI; mainly linked\nvia the root node. As NodeI can potentially contain circular references (as\nnodes will need to refer to both parent and child nodes), Bio::Tree::Tree will\nremove those circular references when the object is garbage-collected. This has\nsome side effects; primarily, one must keep the Tree in scope or have at least\none reference to it if working with nodes. The fix is to count the references to\nthe nodes and if it is greater than expected retain all of them, but it requires\nan additional prereq and thus may not be worth the effort.  This only shows up\nin minor edge cases, though (see Bug #2869).\n\nExample of issue:\n\n  # tree is not assigned to a variable, so passes from memory after\n  # root node is passed\n  my $root = Bio::TreeIO->new(-format => 'newick', -file => 'foo.txt')->next_tree\n\t\t ->get_root_node;\n  \n  # gets nothing, as all Node links are broken when Tree is garbage-collected above\n  my @descendents = $root->get_all_Descendents;\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\nSendu Bala   bix@sendu.me.uk\nMark A. Jensen maj@fortinbras.us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::Tree->new();\n Function: Builds a new Bio::Tree::Tree object \n Returns : Bio::Tree::Tree\n Args    : -root     => L<Bio::Tree::NodeI> object which is the root\n             OR\n           -node     => L<Bio::Tree::NodeI> object from which the root will be\n                        determined\n\n           -nodelete => boolean, whether or not to try and cleanup all\n                                 the nodes when this this tree goes out\n                                 of scope.\n           -id       => optional tree ID\n           -score    => optional tree score value\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n  $self->_register_for_cleanup(\\&cleanup_tree);\n  my ($root,$node,$nodel,$id,$score)= $self->_rearrange([qw(ROOT NODE NODELETE \n                              ID SCORE)], @args);\n  \n  if ($node && ! $root) {\n    $self->throw(\"Must supply a Bio::Tree::NodeI\") unless ref($node) && $node->isa('Bio::Tree::NodeI');\n    my @lineage = $self->get_lineage_nodes($node);\n    $root = shift(@lineage) || $node;\n    \n    # to stop us pulling in entire database of a Bio::Taxon when we later do\n    # get_nodes() or similar, specifically set ancestor() for each node\n    if ($node->isa('Bio::Taxon')) {\n      push(@lineage, $node) unless $node eq $root;\n      my $ancestor = $root;\n      foreach my $lineage_node (@lineage) {\n        $lineage_node->ancestor($ancestor);\n      } continue { $ancestor = $lineage_node; }\n    }\n  }\n  if ($root) {\n    $self->set_root_node($root);\n  }\n  \n  $self->nodelete($nodel || 0);\n  $self->id($id)       if defined $id;\n  $self->score($score) if defined $score;\n  return $self;\n}\n\n\n=head2 nodelete\n\n Title   : nodelete\n Usage   : $obj->nodelete($newval)\n Function: Get/Set Boolean whether or not to delete the underlying\n           nodes when it goes out of scope.  By default this is false\n           meaning trees are cleaned up.\n Returns : boolean\n Args    : on set, new boolean value\n\n\nsub nodelete{\n    my $self = shift;\n    return $self->{'nodelete'} = shift if @_;\n    return $self->{'nodelete'};\n}\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Tree::NodeI objects\n Returns : array of Bio::Tree::NodeI objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self, @args) = @_;\n   \n   my ($order, $sortby) = $self->_rearrange([qw(ORDER SORTBY)],@args);\n   $order ||= 'depth';\n   $sortby ||= 'none';\n   my $node = $self->get_root_node || return;\n   if ($order =~ m/^b|(breadth)$/oi) {\n       my @children = ($node);\n       for (@children) {\n        push @children, $_->each_Descendent($sortby);\n       }\n       return @children;\n   }\n\n   if ($order =~ m/^d|(depth)$/oi) {\n       # this is depth-first search I believe\n       my @children = ($node,$node->get_all_Descendents($sortby));\n       return @children;\n   }\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Tree::NodeI object\n Args    : none\n\n\n\nsub get_root_node{\n   my ($self) = @_;\n   return $self->{'_rootnode'};\n}\n\n=head2 set_root_node\n\n Title   : set_root_node\n Usage   : $tree->set_root_node($node)\n Function: Set the Root Node for the Tree\n Returns : Bio::Tree::NodeI\n Args    : Bio::Tree::NodeI\n\n\nsub set_root_node{\n   my $self = shift;\n   if( @_ ) { \n       my $value = shift;\n       if( defined $value && \n       ! $value->isa('Bio::Tree::NodeI') ) { \n       $self->warn(\"Trying to set the root node to $value which is not a Bio::Tree::NodeI\");\n       return $self->get_root_node;\n       }\n       $self->{'_rootnode'} = $value;\n   } \n   return $self->get_root_node;\n}\n\n=head2 total_branch_length\n\n Title   : total_branch_length\n Usage   : my $size = $tree->total_branch_length\n Function: Returns the sum of the length of all branches\n Returns : real\n Args    : none\n\n\nsub total_branch_length { shift->subtree_length }\n\n=head2 subtree_length\n\n Title   : subtree_length\n Usage   : my $subtree_size = $tree->subtree_length($internal_node)\n Function: Returns the sum of the length of all branches in a subtree\n           under the node. Calculates the size of the whole tree\n           without an argument (but only if root node is defined)\n Returns : real or undef\n Args    : Bio::Tree::NodeI object, defaults to the root node\n\n\nsub subtree_length {\n    my $tree = shift;\n    my $node = shift || $tree->get_root_node;\n    return unless $node;\n    my $sum = 0;\n    for ( $node->get_all_Descendents ) {\n    $sum += $_->branch_length || 0;\n    }\n    return $sum;\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : my $id = $tree->id();\n Function: An id value for the tree\n Returns : scalar\n Args    : [optional] new value to set\n\n\n\nsub id{\n   my ($self,$val) = @_;\n   if( defined $val ) { \n       $self->{'_treeid'} = $val;\n   }\n   return $self->{'_treeid'};\n}\n\n=head2 score\n\n Title   : score\n Usage   : $obj->score($newval)\n Function: Sets the associated score with this tree\n           This is a generic slot which is probably best used \n           for log likelihood or other overall tree score\n Returns : value of score\n Args    : newvalue (optional)\n\n\n\nsub score{\n   my ($self,$val) = @_;\n   if( defined $val ) { \n       $self->{'_score'} = $val;\n   }\n   return $self->{'_score'};\n}\n\n\n# decorated interface TreeI Implements this\n\n=head2 height\n\n Title   : height\n Usage   : my $height = $tree->height\n Function: Gets the height of tree - this LOG_2($number_nodes)\n           WARNING: this is only true for strict binary trees.  The TreeIO\n           system is capable of building non-binary trees, for which this\n           method will currently return an incorrect value!!\n Returns : integer\n Args    : none\n\n=head2 number_nodes\n\n Title   : number_nodes\n Usage   : my $size = $tree->number_nodes\n Function: Returns the number of nodes in the tree\n Returns : integer\n Args    : none\n\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   : my $tree_as_string = $tree->as_text($format)\n Function: Returns the tree as a string representation in the \n           desired format (currently 'newick', 'nhx', or \n           'tabtree')\n Returns : scalar string\n Args    : format type as specified by Bio::TreeIO\n Note    : This method loads the Bio::TreeIO::$format module\n           on the fly, and commandeers the _write_tree_Helper\n           routine therein to create the tree string. \n\n\nsub as_text {\n    my $self = shift;\n    my $format = shift;\n    my @parms;\n    my $iomod = \"Bio::TreeIO::$format\";\n    $self->_load_module($iomod);\n    # following currently not really necessary, but who knows?\n    my $io = $iomod->new(-format=>$format, -file=>File::Spec->devnull());\n    no strict \"refs\";\n    my $iowtH = *{$iomod.\"::_write_tree_Helper\"}{CODE};\n    use strict \"refs\";\n    for ($format) {\n\t/newick/ && do {\n\t    @parms = ( $io->bootstrap_style, $io->order_by, 0 );\n\t    last;\n\t};\n\t/nhx/ && do {\n\t    @parms = ( 0 );\n\t    last;\n\t};\n\t/tabtree/ && do {\n\t    @parms = ( \"\" );\n\t    last;\n\t};\n\t# default\n\t$self->throw(\"as_text does not allow format '$format'\") \n    }\n\t\n\n    # newline_each_node...\n    my $data = [$iowtH->($self->get_root_node, @parms)];\n\n    if ($format eq 'tabtree') {\n\treturn $$data[0].\"\\n\";\n    }\n    else {\n\treturn join(\",\", @$data).\";\\n\";\n    }\n}\n\n=head2 Methods for associating Tag/Values with a Tree\n\nThese methods associate tag/value pairs with a Tree\n\n=head2 set_tag_value\n\n Title   : set_tag_value\n Usage   : $tree->set_tag_value($tag,$value)\n           $tree->set_tag_value($tag,@values)\n Function: Sets a tag value(s) to a tree. Replaces old values.\n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag\n\n\nsub set_tag_value{\n    my ($self,$tag,@values) = @_;\n    if( ! defined $tag || ! scalar @values ) {\n    $self->warn(\"cannot call set_tag_value with an undefined value\");\n    }\n    $self->remove_tag ($tag);\n    map { push @{$self->{'_tags'}->{$tag}}, $_ } @values;\n    return scalar @{$self->{'_tags'}->{$tag}};\n}\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $tree->add_tag_value($tag,$value)\n Function: Adds a tag value to a tree \n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag\n\n\nsub add_tag_value{\n    my ($self,$tag,$value) = @_;\n    if( ! defined $tag || ! defined $value ) {\n    $self->warn(\"cannot call add_tag_value with an undefined value\");\n    }\n    push @{$self->{'_tags'}->{$tag}}, $value;\n    return scalar @{$self->{'_tags'}->{$tag}};\n}\n\n=head2 remove_tag\n\n Title   : remove_tag\n Usage   : $tree->remove_tag($tag)\n Function: Remove the tag and all values for this tag\n Returns : boolean representing success (0 if tag does not exist)\n Args    : $tag - tagname to remove\n\n\n\nsub remove_tag {\n   my ($self,$tag) = @_;\n   if( exists $self->{'_tags'}->{$tag} ) {\n       $self->{'_tags'}->{$tag} = undef;\n       delete $self->{'_tags'}->{$tag};\n       return 1;\n   }\n   return 0;\n}\n\n=head2 remove_all_tags\n\n Title   : remove_all_tags\n Usage   : $tree->remove_all_tags()\n Function: Removes all tags \n Returns : None\n Args    : None\n\n\nsub remove_all_tags{\n   my ($self) = @_;\n   $self->{'_tags'} = {};\n   return;\n}\n\n=head2 get_all_tags\n\n Title   : get_all_tags\n Usage   : my @tags = $tree->get_all_tags()\n Function: Gets all the tag names for this Tree\n Returns : Array of tagnames\n Args    : None","parameters":[{"label":"$self"}],"label":"get_all_tags($self)"},"containerName":"main::","definition":"sub"},{"line":511,"kind":13,"name":"@tags","containerName":null},{"signature":{"documentation":"1;\n# $Id: Tree.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::Tree - An Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Nodes which make up a tree.\n\n=head1 IMPLEMENTATION NOTE\n\nThis implementation of Bio::Tree::Tree contains Bio::Tree:::NodeI; mainly linked\nvia the root node. As NodeI can potentially contain circular references (as\nnodes will need to refer to both parent and child nodes), Bio::Tree::Tree will\nremove those circular references when the object is garbage-collected. This has\nsome side effects; primarily, one must keep the Tree in scope or have at least\none reference to it if working with nodes. The fix is to count the references to\nthe nodes and if it is greater than expected retain all of them, but it requires\nan additional prereq and thus may not be worth the effort.  This only shows up\nin minor edge cases, though (see Bug #2869).\n\nExample of issue:\n\n  # tree is not assigned to a variable, so passes from memory after\n  # root node is passed\n  my $root = Bio::TreeIO->new(-format => 'newick', -file => 'foo.txt')->next_tree\n\t\t ->get_root_node;\n  \n  # gets nothing, as all Node links are broken when Tree is garbage-collected above\n  my @descendents = $root->get_all_Descendents;\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\nSendu Bala   bix@sendu.me.uk\nMark A. Jensen maj@fortinbras.us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::Tree->new();\n Function: Builds a new Bio::Tree::Tree object \n Returns : Bio::Tree::Tree\n Args    : -root     => L<Bio::Tree::NodeI> object which is the root\n             OR\n           -node     => L<Bio::Tree::NodeI> object from which the root will be\n                        determined\n\n           -nodelete => boolean, whether or not to try and cleanup all\n                                 the nodes when this this tree goes out\n                                 of scope.\n           -id       => optional tree ID\n           -score    => optional tree score value\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n  $self->_register_for_cleanup(\\&cleanup_tree);\n  my ($root,$node,$nodel,$id,$score)= $self->_rearrange([qw(ROOT NODE NODELETE \n                              ID SCORE)], @args);\n  \n  if ($node && ! $root) {\n    $self->throw(\"Must supply a Bio::Tree::NodeI\") unless ref($node) && $node->isa('Bio::Tree::NodeI');\n    my @lineage = $self->get_lineage_nodes($node);\n    $root = shift(@lineage) || $node;\n    \n    # to stop us pulling in entire database of a Bio::Taxon when we later do\n    # get_nodes() or similar, specifically set ancestor() for each node\n    if ($node->isa('Bio::Taxon')) {\n      push(@lineage, $node) unless $node eq $root;\n      my $ancestor = $root;\n      foreach my $lineage_node (@lineage) {\n        $lineage_node->ancestor($ancestor);\n      } continue { $ancestor = $lineage_node; }\n    }\n  }\n  if ($root) {\n    $self->set_root_node($root);\n  }\n  \n  $self->nodelete($nodel || 0);\n  $self->id($id)       if defined $id;\n  $self->score($score) if defined $score;\n  return $self;\n}\n\n\n=head2 nodelete\n\n Title   : nodelete\n Usage   : $obj->nodelete($newval)\n Function: Get/Set Boolean whether or not to delete the underlying\n           nodes when it goes out of scope.  By default this is false\n           meaning trees are cleaned up.\n Returns : boolean\n Args    : on set, new boolean value\n\n\nsub nodelete{\n    my $self = shift;\n    return $self->{'nodelete'} = shift if @_;\n    return $self->{'nodelete'};\n}\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Tree::NodeI objects\n Returns : array of Bio::Tree::NodeI objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self, @args) = @_;\n   \n   my ($order, $sortby) = $self->_rearrange([qw(ORDER SORTBY)],@args);\n   $order ||= 'depth';\n   $sortby ||= 'none';\n   my $node = $self->get_root_node || return;\n   if ($order =~ m/^b|(breadth)$/oi) {\n       my @children = ($node);\n       for (@children) {\n        push @children, $_->each_Descendent($sortby);\n       }\n       return @children;\n   }\n\n   if ($order =~ m/^d|(depth)$/oi) {\n       # this is depth-first search I believe\n       my @children = ($node,$node->get_all_Descendents($sortby));\n       return @children;\n   }\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Tree::NodeI object\n Args    : none\n\n\n\nsub get_root_node{\n   my ($self) = @_;\n   return $self->{'_rootnode'};\n}\n\n=head2 set_root_node\n\n Title   : set_root_node\n Usage   : $tree->set_root_node($node)\n Function: Set the Root Node for the Tree\n Returns : Bio::Tree::NodeI\n Args    : Bio::Tree::NodeI\n\n\nsub set_root_node{\n   my $self = shift;\n   if( @_ ) { \n       my $value = shift;\n       if( defined $value && \n       ! $value->isa('Bio::Tree::NodeI') ) { \n       $self->warn(\"Trying to set the root node to $value which is not a Bio::Tree::NodeI\");\n       return $self->get_root_node;\n       }\n       $self->{'_rootnode'} = $value;\n   } \n   return $self->get_root_node;\n}\n\n=head2 total_branch_length\n\n Title   : total_branch_length\n Usage   : my $size = $tree->total_branch_length\n Function: Returns the sum of the length of all branches\n Returns : real\n Args    : none\n\n\nsub total_branch_length { shift->subtree_length }\n\n=head2 subtree_length\n\n Title   : subtree_length\n Usage   : my $subtree_size = $tree->subtree_length($internal_node)\n Function: Returns the sum of the length of all branches in a subtree\n           under the node. Calculates the size of the whole tree\n           without an argument (but only if root node is defined)\n Returns : real or undef\n Args    : Bio::Tree::NodeI object, defaults to the root node\n\n\nsub subtree_length {\n    my $tree = shift;\n    my $node = shift || $tree->get_root_node;\n    return unless $node;\n    my $sum = 0;\n    for ( $node->get_all_Descendents ) {\n    $sum += $_->branch_length || 0;\n    }\n    return $sum;\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : my $id = $tree->id();\n Function: An id value for the tree\n Returns : scalar\n Args    : [optional] new value to set\n\n\n\nsub id{\n   my ($self,$val) = @_;\n   if( defined $val ) { \n       $self->{'_treeid'} = $val;\n   }\n   return $self->{'_treeid'};\n}\n\n=head2 score\n\n Title   : score\n Usage   : $obj->score($newval)\n Function: Sets the associated score with this tree\n           This is a generic slot which is probably best used \n           for log likelihood or other overall tree score\n Returns : value of score\n Args    : newvalue (optional)\n\n\n\nsub score{\n   my ($self,$val) = @_;\n   if( defined $val ) { \n       $self->{'_score'} = $val;\n   }\n   return $self->{'_score'};\n}\n\n\n# decorated interface TreeI Implements this\n\n=head2 height\n\n Title   : height\n Usage   : my $height = $tree->height\n Function: Gets the height of tree - this LOG_2($number_nodes)\n           WARNING: this is only true for strict binary trees.  The TreeIO\n           system is capable of building non-binary trees, for which this\n           method will currently return an incorrect value!!\n Returns : integer\n Args    : none\n\n=head2 number_nodes\n\n Title   : number_nodes\n Usage   : my $size = $tree->number_nodes\n Function: Returns the number of nodes in the tree\n Returns : integer\n Args    : none\n\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   : my $tree_as_string = $tree->as_text($format)\n Function: Returns the tree as a string representation in the \n           desired format (currently 'newick', 'nhx', or \n           'tabtree')\n Returns : scalar string\n Args    : format type as specified by Bio::TreeIO\n Note    : This method loads the Bio::TreeIO::$format module\n           on the fly, and commandeers the _write_tree_Helper\n           routine therein to create the tree string. \n\n\nsub as_text {\n    my $self = shift;\n    my $format = shift;\n    my @parms;\n    my $iomod = \"Bio::TreeIO::$format\";\n    $self->_load_module($iomod);\n    # following currently not really necessary, but who knows?\n    my $io = $iomod->new(-format=>$format, -file=>File::Spec->devnull());\n    no strict \"refs\";\n    my $iowtH = *{$iomod.\"::_write_tree_Helper\"}{CODE};\n    use strict \"refs\";\n    for ($format) {\n\t/newick/ && do {\n\t    @parms = ( $io->bootstrap_style, $io->order_by, 0 );\n\t    last;\n\t};\n\t/nhx/ && do {\n\t    @parms = ( 0 );\n\t    last;\n\t};\n\t/tabtree/ && do {\n\t    @parms = ( \"\" );\n\t    last;\n\t};\n\t# default\n\t$self->throw(\"as_text does not allow format '$format'\") \n    }\n\t\n\n    # newline_each_node...\n    my $data = [$iowtH->($self->get_root_node, @parms)];\n\n    if ($format eq 'tabtree') {\n\treturn $$data[0].\"\\n\";\n    }\n    else {\n\treturn join(\",\", @$data).\";\\n\";\n    }\n}\n\n=head2 Methods for associating Tag/Values with a Tree\n\nThese methods associate tag/value pairs with a Tree\n\n=head2 set_tag_value\n\n Title   : set_tag_value\n Usage   : $tree->set_tag_value($tag,$value)\n           $tree->set_tag_value($tag,@values)\n Function: Sets a tag value(s) to a tree. Replaces old values.\n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag\n\n\nsub set_tag_value{\n    my ($self,$tag,@values) = @_;\n    if( ! defined $tag || ! scalar @values ) {\n    $self->warn(\"cannot call set_tag_value with an undefined value\");\n    }\n    $self->remove_tag ($tag);\n    map { push @{$self->{'_tags'}->{$tag}}, $_ } @values;\n    return scalar @{$self->{'_tags'}->{$tag}};\n}\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $tree->add_tag_value($tag,$value)\n Function: Adds a tag value to a tree \n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag\n\n\nsub add_tag_value{\n    my ($self,$tag,$value) = @_;\n    if( ! defined $tag || ! defined $value ) {\n    $self->warn(\"cannot call add_tag_value with an undefined value\");\n    }\n    push @{$self->{'_tags'}->{$tag}}, $value;\n    return scalar @{$self->{'_tags'}->{$tag}};\n}\n\n=head2 remove_tag\n\n Title   : remove_tag\n Usage   : $tree->remove_tag($tag)\n Function: Remove the tag and all values for this tag\n Returns : boolean representing success (0 if tag does not exist)\n Args    : $tag - tagname to remove\n\n\n\nsub remove_tag {\n   my ($self,$tag) = @_;\n   if( exists $self->{'_tags'}->{$tag} ) {\n       $self->{'_tags'}->{$tag} = undef;\n       delete $self->{'_tags'}->{$tag};\n       return 1;\n   }\n   return 0;\n}\n\n=head2 remove_all_tags\n\n Title   : remove_all_tags\n Usage   : $tree->remove_all_tags()\n Function: Removes all tags \n Returns : None\n Args    : None\n\n\nsub remove_all_tags{\n   my ($self) = @_;\n   $self->{'_tags'} = {};\n   return;\n}\n\n=head2 get_all_tags\n\n Title   : get_all_tags\n Usage   : my @tags = $tree->get_all_tags()\n Function: Gets all the tag names for this Tree\n Returns : Array of tagnames\n Args    : None\n\n\nsub get_all_tags{\n   my ($self) = @_;\n   my @tags = sort keys %{$self->{'_tags'} || {}};\n   return @tags;\n}\n\n=head2 get_tag_values\n\n Title   : get_tag_values\n Usage   : my @values = $tree->get_tag_values($tag)\n Function: Gets the values for given tag ($tag)\n Returns : Array of values or empty list if tag does not exist\n Args    : $tag - tag name","parameters":[{"label":"$self"},{"label":"$tag"}],"label":"get_tag_values($self,$tag)"},"detail":"($self,$tag)","definition":"sub","containerName":"main::","children":[{"containerName":"get_tag_values","name":"$self","definition":"my","localvar":"my","kind":13,"line":525},{"line":525,"kind":13,"name":"$tag","containerName":"get_tag_values"},{"name":"$self","containerName":"get_tag_values","line":526,"kind":13},{"line":526,"kind":13,"name":"$tag","containerName":"get_tag_values"}],"line":524,"kind":12,"range":{"start":{"line":524,"character":0},"end":{"character":9999,"line":526}},"name":"get_tag_values"},{"kind":13,"line":527,"name":"%self","containerName":null},{"containerName":null,"name":"@tag","line":527,"kind":13},{"range":{"start":{"line":540,"character":0},"end":{"line":543,"character":9999}},"name":"has_tag","children":[{"name":"$self","definition":"my","containerName":"has_tag","localvar":"my","kind":13,"line":541},{"kind":13,"line":541,"containerName":"has_tag","name":"$tag"},{"containerName":"has_tag","name":"$self","line":542,"kind":13},{"line":542,"kind":13,"name":"$tag","containerName":"has_tag"}],"line":540,"kind":12,"signature":{"label":"has_tag($self,$tag)","parameters":[{"label":"$self"},{"label":"$tag"}],"documentation":"1;\n# $Id: Tree.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::Tree - An Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Nodes which make up a tree.\n\n=head1 IMPLEMENTATION NOTE\n\nThis implementation of Bio::Tree::Tree contains Bio::Tree:::NodeI; mainly linked\nvia the root node. As NodeI can potentially contain circular references (as\nnodes will need to refer to both parent and child nodes), Bio::Tree::Tree will\nremove those circular references when the object is garbage-collected. This has\nsome side effects; primarily, one must keep the Tree in scope or have at least\none reference to it if working with nodes. The fix is to count the references to\nthe nodes and if it is greater than expected retain all of them, but it requires\nan additional prereq and thus may not be worth the effort.  This only shows up\nin minor edge cases, though (see Bug #2869).\n\nExample of issue:\n\n  # tree is not assigned to a variable, so passes from memory after\n  # root node is passed\n  my $root = Bio::TreeIO->new(-format => 'newick', -file => 'foo.txt')->next_tree\n\t\t ->get_root_node;\n  \n  # gets nothing, as all Node links are broken when Tree is garbage-collected above\n  my @descendents = $root->get_all_Descendents;\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\nSendu Bala   bix@sendu.me.uk\nMark A. Jensen maj@fortinbras.us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::Tree->new();\n Function: Builds a new Bio::Tree::Tree object \n Returns : Bio::Tree::Tree\n Args    : -root     => L<Bio::Tree::NodeI> object which is the root\n             OR\n           -node     => L<Bio::Tree::NodeI> object from which the root will be\n                        determined\n\n           -nodelete => boolean, whether or not to try and cleanup all\n                                 the nodes when this this tree goes out\n                                 of scope.\n           -id       => optional tree ID\n           -score    => optional tree score value\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n  $self->_register_for_cleanup(\\&cleanup_tree);\n  my ($root,$node,$nodel,$id,$score)= $self->_rearrange([qw(ROOT NODE NODELETE \n                              ID SCORE)], @args);\n  \n  if ($node && ! $root) {\n    $self->throw(\"Must supply a Bio::Tree::NodeI\") unless ref($node) && $node->isa('Bio::Tree::NodeI');\n    my @lineage = $self->get_lineage_nodes($node);\n    $root = shift(@lineage) || $node;\n    \n    # to stop us pulling in entire database of a Bio::Taxon when we later do\n    # get_nodes() or similar, specifically set ancestor() for each node\n    if ($node->isa('Bio::Taxon')) {\n      push(@lineage, $node) unless $node eq $root;\n      my $ancestor = $root;\n      foreach my $lineage_node (@lineage) {\n        $lineage_node->ancestor($ancestor);\n      } continue { $ancestor = $lineage_node; }\n    }\n  }\n  if ($root) {\n    $self->set_root_node($root);\n  }\n  \n  $self->nodelete($nodel || 0);\n  $self->id($id)       if defined $id;\n  $self->score($score) if defined $score;\n  return $self;\n}\n\n\n=head2 nodelete\n\n Title   : nodelete\n Usage   : $obj->nodelete($newval)\n Function: Get/Set Boolean whether or not to delete the underlying\n           nodes when it goes out of scope.  By default this is false\n           meaning trees are cleaned up.\n Returns : boolean\n Args    : on set, new boolean value\n\n\nsub nodelete{\n    my $self = shift;\n    return $self->{'nodelete'} = shift if @_;\n    return $self->{'nodelete'};\n}\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Tree::NodeI objects\n Returns : array of Bio::Tree::NodeI objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self, @args) = @_;\n   \n   my ($order, $sortby) = $self->_rearrange([qw(ORDER SORTBY)],@args);\n   $order ||= 'depth';\n   $sortby ||= 'none';\n   my $node = $self->get_root_node || return;\n   if ($order =~ m/^b|(breadth)$/oi) {\n       my @children = ($node);\n       for (@children) {\n        push @children, $_->each_Descendent($sortby);\n       }\n       return @children;\n   }\n\n   if ($order =~ m/^d|(depth)$/oi) {\n       # this is depth-first search I believe\n       my @children = ($node,$node->get_all_Descendents($sortby));\n       return @children;\n   }\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Tree::NodeI object\n Args    : none\n\n\n\nsub get_root_node{\n   my ($self) = @_;\n   return $self->{'_rootnode'};\n}\n\n=head2 set_root_node\n\n Title   : set_root_node\n Usage   : $tree->set_root_node($node)\n Function: Set the Root Node for the Tree\n Returns : Bio::Tree::NodeI\n Args    : Bio::Tree::NodeI\n\n\nsub set_root_node{\n   my $self = shift;\n   if( @_ ) { \n       my $value = shift;\n       if( defined $value && \n       ! $value->isa('Bio::Tree::NodeI') ) { \n       $self->warn(\"Trying to set the root node to $value which is not a Bio::Tree::NodeI\");\n       return $self->get_root_node;\n       }\n       $self->{'_rootnode'} = $value;\n   } \n   return $self->get_root_node;\n}\n\n=head2 total_branch_length\n\n Title   : total_branch_length\n Usage   : my $size = $tree->total_branch_length\n Function: Returns the sum of the length of all branches\n Returns : real\n Args    : none\n\n\nsub total_branch_length { shift->subtree_length }\n\n=head2 subtree_length\n\n Title   : subtree_length\n Usage   : my $subtree_size = $tree->subtree_length($internal_node)\n Function: Returns the sum of the length of all branches in a subtree\n           under the node. Calculates the size of the whole tree\n           without an argument (but only if root node is defined)\n Returns : real or undef\n Args    : Bio::Tree::NodeI object, defaults to the root node\n\n\nsub subtree_length {\n    my $tree = shift;\n    my $node = shift || $tree->get_root_node;\n    return unless $node;\n    my $sum = 0;\n    for ( $node->get_all_Descendents ) {\n    $sum += $_->branch_length || 0;\n    }\n    return $sum;\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : my $id = $tree->id();\n Function: An id value for the tree\n Returns : scalar\n Args    : [optional] new value to set\n\n\n\nsub id{\n   my ($self,$val) = @_;\n   if( defined $val ) { \n       $self->{'_treeid'} = $val;\n   }\n   return $self->{'_treeid'};\n}\n\n=head2 score\n\n Title   : score\n Usage   : $obj->score($newval)\n Function: Sets the associated score with this tree\n           This is a generic slot which is probably best used \n           for log likelihood or other overall tree score\n Returns : value of score\n Args    : newvalue (optional)\n\n\n\nsub score{\n   my ($self,$val) = @_;\n   if( defined $val ) { \n       $self->{'_score'} = $val;\n   }\n   return $self->{'_score'};\n}\n\n\n# decorated interface TreeI Implements this\n\n=head2 height\n\n Title   : height\n Usage   : my $height = $tree->height\n Function: Gets the height of tree - this LOG_2($number_nodes)\n           WARNING: this is only true for strict binary trees.  The TreeIO\n           system is capable of building non-binary trees, for which this\n           method will currently return an incorrect value!!\n Returns : integer\n Args    : none\n\n=head2 number_nodes\n\n Title   : number_nodes\n Usage   : my $size = $tree->number_nodes\n Function: Returns the number of nodes in the tree\n Returns : integer\n Args    : none\n\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   : my $tree_as_string = $tree->as_text($format)\n Function: Returns the tree as a string representation in the \n           desired format (currently 'newick', 'nhx', or \n           'tabtree')\n Returns : scalar string\n Args    : format type as specified by Bio::TreeIO\n Note    : This method loads the Bio::TreeIO::$format module\n           on the fly, and commandeers the _write_tree_Helper\n           routine therein to create the tree string. \n\n\nsub as_text {\n    my $self = shift;\n    my $format = shift;\n    my @parms;\n    my $iomod = \"Bio::TreeIO::$format\";\n    $self->_load_module($iomod);\n    # following currently not really necessary, but who knows?\n    my $io = $iomod->new(-format=>$format, -file=>File::Spec->devnull());\n    no strict \"refs\";\n    my $iowtH = *{$iomod.\"::_write_tree_Helper\"}{CODE};\n    use strict \"refs\";\n    for ($format) {\n\t/newick/ && do {\n\t    @parms = ( $io->bootstrap_style, $io->order_by, 0 );\n\t    last;\n\t};\n\t/nhx/ && do {\n\t    @parms = ( 0 );\n\t    last;\n\t};\n\t/tabtree/ && do {\n\t    @parms = ( \"\" );\n\t    last;\n\t};\n\t# default\n\t$self->throw(\"as_text does not allow format '$format'\") \n    }\n\t\n\n    # newline_each_node...\n    my $data = [$iowtH->($self->get_root_node, @parms)];\n\n    if ($format eq 'tabtree') {\n\treturn $$data[0].\"\\n\";\n    }\n    else {\n\treturn join(\",\", @$data).\";\\n\";\n    }\n}\n\n=head2 Methods for associating Tag/Values with a Tree\n\nThese methods associate tag/value pairs with a Tree\n\n=head2 set_tag_value\n\n Title   : set_tag_value\n Usage   : $tree->set_tag_value($tag,$value)\n           $tree->set_tag_value($tag,@values)\n Function: Sets a tag value(s) to a tree. Replaces old values.\n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag\n\n\nsub set_tag_value{\n    my ($self,$tag,@values) = @_;\n    if( ! defined $tag || ! scalar @values ) {\n    $self->warn(\"cannot call set_tag_value with an undefined value\");\n    }\n    $self->remove_tag ($tag);\n    map { push @{$self->{'_tags'}->{$tag}}, $_ } @values;\n    return scalar @{$self->{'_tags'}->{$tag}};\n}\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $tree->add_tag_value($tag,$value)\n Function: Adds a tag value to a tree \n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag\n\n\nsub add_tag_value{\n    my ($self,$tag,$value) = @_;\n    if( ! defined $tag || ! defined $value ) {\n    $self->warn(\"cannot call add_tag_value with an undefined value\");\n    }\n    push @{$self->{'_tags'}->{$tag}}, $value;\n    return scalar @{$self->{'_tags'}->{$tag}};\n}\n\n=head2 remove_tag\n\n Title   : remove_tag\n Usage   : $tree->remove_tag($tag)\n Function: Remove the tag and all values for this tag\n Returns : boolean representing success (0 if tag does not exist)\n Args    : $tag - tagname to remove\n\n\n\nsub remove_tag {\n   my ($self,$tag) = @_;\n   if( exists $self->{'_tags'}->{$tag} ) {\n       $self->{'_tags'}->{$tag} = undef;\n       delete $self->{'_tags'}->{$tag};\n       return 1;\n   }\n   return 0;\n}\n\n=head2 remove_all_tags\n\n Title   : remove_all_tags\n Usage   : $tree->remove_all_tags()\n Function: Removes all tags \n Returns : None\n Args    : None\n\n\nsub remove_all_tags{\n   my ($self) = @_;\n   $self->{'_tags'} = {};\n   return;\n}\n\n=head2 get_all_tags\n\n Title   : get_all_tags\n Usage   : my @tags = $tree->get_all_tags()\n Function: Gets all the tag names for this Tree\n Returns : Array of tagnames\n Args    : None\n\n\nsub get_all_tags{\n   my ($self) = @_;\n   my @tags = sort keys %{$self->{'_tags'} || {}};\n   return @tags;\n}\n\n=head2 get_tag_values\n\n Title   : get_tag_values\n Usage   : my @values = $tree->get_tag_values($tag)\n Function: Gets the values for given tag ($tag)\n Returns : Array of values or empty list if tag does not exist\n Args    : $tag - tag name\n\n\nsub get_tag_values{\n   my ($self,$tag) = @_;\n   return wantarray ? @{$self->{'_tags'}->{$tag} || []} :\n                     (@{$self->{'_tags'}->{$tag} || []})[0];\n}\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $tree->has_tag($tag)\n Function: Boolean test if tag exists in the Tree\n Returns : Boolean\n Args    : $tag - tagname"},"detail":"($self,$tag)","definition":"sub","containerName":"main::"},{"kind":12,"line":547,"children":[{"kind":13,"line":548,"definition":"my","name":"$self","containerName":"cleanup_tree","localvar":"my"},{"line":549,"kind":13,"name":"$self","containerName":"cleanup_tree"},{"kind":12,"line":549,"containerName":"cleanup_tree","name":"nodelete"},{"localvar":"my","containerName":"cleanup_tree","name":"$node","definition":"my","line":550,"kind":13},{"line":550,"kind":13,"containerName":"cleanup_tree","name":"$self"},{"kind":12,"line":550,"name":"get_nodes","containerName":"cleanup_tree"},{"name":"$node","containerName":"cleanup_tree","line":553,"kind":13},{"containerName":"cleanup_tree","name":"node_cleanup","kind":12,"line":553},{"line":554,"kind":13,"name":"$node","containerName":"cleanup_tree"},{"name":"$self","containerName":"cleanup_tree","kind":13,"line":557}],"containerName":"main::","definition":"sub","name":"cleanup_tree","range":{"start":{"line":547,"character":0},"end":{"character":9999,"line":558}}}],"version":5}