{"version":5,"vars":[{"containerName":"","name":"base","kind":2,"line":84},{"name":"assess_bootstrap","range":{"start":{"character":0,"line":109},"end":{"character":9999,"line":144}},"kind":12,"children":[{"kind":13,"line":110,"name":"$self","definition":"my","containerName":"assess_bootstrap","localvar":"my"},{"line":110,"kind":13,"containerName":"assess_bootstrap","name":"$bs_trees"},{"line":110,"kind":13,"containerName":"assess_bootstrap","name":"$guide_tree"},{"localvar":"my","definition":"my","name":"@consensus","containerName":"assess_bootstrap","line":111,"kind":13},{"line":115,"kind":13,"localvar":"my","definition":"my","name":"%lookup","containerName":"assess_bootstrap"},{"line":115,"kind":13,"name":"%internal","containerName":"assess_bootstrap"},{"localvar":"my","definition":"my","name":"$i","containerName":"assess_bootstrap","line":116,"kind":13},{"localvar":"my","containerName":"assess_bootstrap","definition":"my","name":"$tree","line":117,"kind":13},{"line":117,"kind":13,"name":"$guide_tree","containerName":"assess_bootstrap"},{"containerName":"assess_bootstrap","name":"$bs_trees","line":117,"kind":13},{"containerName":"assess_bootstrap","definition":"my","name":"@allnodes","localvar":"my","kind":13,"line":122},{"name":"$tree","containerName":"assess_bootstrap","line":122,"kind":13},{"kind":12,"line":122,"containerName":"assess_bootstrap","name":"get_nodes"},{"localvar":"my","name":"@internalnodes","definition":"my","containerName":"assess_bootstrap","line":123,"kind":13},{"line":123,"kind":12,"containerName":"assess_bootstrap","name":"is_Leaf"},{"containerName":"assess_bootstrap","name":"@allnodes","line":123,"kind":13},{"line":124,"kind":13,"localvar":"my","containerName":"assess_bootstrap","definition":"my","name":"$node"},{"name":"@internalnodes","containerName":"assess_bootstrap","kind":13,"line":124},{"containerName":"assess_bootstrap","definition":"my","name":"@tips","localvar":"my","kind":13,"line":125},{"kind":12,"line":125,"containerName":"assess_bootstrap","name":"id"},{"line":126,"kind":12,"name":"is_Leaf","containerName":"assess_bootstrap"},{"kind":13,"line":126,"containerName":"assess_bootstrap","name":"$node"},{"kind":12,"line":126,"containerName":"assess_bootstrap","name":"get_all_Descendents"},{"line":127,"kind":13,"localvar":"my","definition":"my","name":"$id","containerName":"assess_bootstrap"},{"line":127,"kind":13,"containerName":"assess_bootstrap","name":"@tips"},{"name":"$i","containerName":"assess_bootstrap","kind":13,"line":128},{"line":129,"kind":13,"containerName":"assess_bootstrap","name":"$internal"},{"name":"$id","containerName":"assess_bootstrap","line":129,"kind":13},{"line":129,"kind":13,"containerName":"assess_bootstrap","name":"$node"},{"name":"internal_id","containerName":"assess_bootstrap","line":129,"kind":12},{"containerName":"assess_bootstrap","name":"$lookup","line":131,"kind":13},{"kind":13,"line":131,"name":"$id","containerName":"assess_bootstrap"},{"line":134,"kind":13,"containerName":"assess_bootstrap","name":"$i"},{"kind":13,"line":136,"containerName":"assess_bootstrap","name":"@save","definition":"my","localvar":"my"},{"line":137,"kind":13,"localvar":"my","containerName":"assess_bootstrap","definition":"my","name":"$l"},{"kind":13,"line":137,"name":"%lookup","containerName":"assess_bootstrap"},{"line":138,"kind":13,"name":"$internal","containerName":"assess_bootstrap"},{"line":138,"kind":13,"name":"$l","containerName":"assess_bootstrap"},{"containerName":"assess_bootstrap","definition":"my","name":"$intnode","localvar":"my","kind":13,"line":139},{"name":"$guide_tree","containerName":"assess_bootstrap","line":139,"kind":13},{"containerName":"assess_bootstrap","name":"find_node","kind":12,"line":139},{"line":139,"kind":13,"containerName":"assess_bootstrap","name":"$internal"},{"line":139,"kind":13,"containerName":"assess_bootstrap","name":"$l"},{"kind":13,"line":140,"containerName":"assess_bootstrap","name":"$intnode"},{"line":140,"kind":12,"name":"bootstrap","containerName":"assess_bootstrap"},{"line":140,"kind":13,"name":"$lookup","containerName":"assess_bootstrap"},{"containerName":"assess_bootstrap","name":"$l","kind":13,"line":140},{"kind":13,"line":140,"name":"$i","containerName":"assess_bootstrap"},{"containerName":"assess_bootstrap","name":"$guide_tree","line":143,"kind":13}],"line":109,"definition":"sub","containerName":"main::","signature":{"label":"assess_bootstrap($self,$bs_trees,$guide_tree)","documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::Statistics - Calculate certain statistics for a Tree\n\n=head1 SYNOPSIS\n\n  use Bio::Tree::Statistics;\n\n=head1 DESCRIPTION\n\nThis should be where Tree statistics are calculated.  It was\npreviously where statistics from a Coalescent simulation.\n\nIt now contains several methods for calculating L<Tree-Trait\nstatistics>.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason AT bioperl.org\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho, heikki at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::Statistics;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::Statistics->new();\n Function: Builds a new Bio::Tree::Statistics object \n Returns : Bio::Tree::Statistics\n Args    :\n\n\n\n\n=head2 assess_bootstrap\n\n Title   : assess_bootstrap\n Usage   : my $tree_with_bs = $stats->assess_bootstrap(\\@bs_trees);\n Function: Calculates the bootstrap for internal nodes based on\n Returns : L<Bio::Tree::TreeI>\n Args    : Arrayref of L<Bio::Tree::TreeI>s","parameters":[{"label":"$self"},{"label":"$bs_trees"},{"label":"$guide_tree"}]},"detail":"($self,$bs_trees,$guide_tree)"},{"name":"cherries","range":{"end":{"character":9999,"line":184},"start":{"character":0,"line":163}},"kind":12,"children":[{"containerName":"cherries","name":"$self","definition":"my","localvar":"my","kind":13,"line":164},{"localvar":"my","name":"$tree","definition":"my","containerName":"cherries","line":165,"kind":13},{"kind":13,"line":166,"containerName":"cherries","definition":"my","name":"$node","localvar":"my"},{"name":"$tree","containerName":"cherries","kind":13,"line":166},{"kind":12,"line":166,"containerName":"cherries","name":"get_root_node"},{"line":168,"kind":13,"localvar":"my","containerName":"cherries","name":"$cherries","definition":"my"},{"localvar":"my","containerName":"cherries","name":"@descs","definition":"my","line":169,"kind":13},{"name":"$node","containerName":"cherries","kind":13,"line":169},{"name":"each_Descendent","containerName":"cherries","kind":12,"line":169},{"line":171,"kind":13,"name":"$descs","containerName":"cherries"},{"kind":12,"line":171,"containerName":"cherries","name":"is_Leaf"},{"line":171,"kind":13,"containerName":"cherries","name":"$descs"},{"containerName":"cherries","name":"is_Leaf","line":171,"kind":12},{"kind":13,"line":172,"containerName":"cherries","name":"$descs"},{"name":"$cherries","containerName":"cherries","kind":13,"line":173},{"containerName":"cherries","name":"$cherries","line":175,"kind":13},{"kind":13,"line":179,"definition":"my","name":"$desc","containerName":"cherries","localvar":"my"},{"line":179,"kind":13,"containerName":"cherries","name":"@descs"},{"kind":13,"line":180,"name":"$cherries","containerName":"cherries"},{"name":"$self","containerName":"cherries","line":180,"kind":13},{"name":"cherries","containerName":"cherries","line":180,"kind":12},{"name":"$tree","containerName":"cherries","line":180,"kind":13},{"containerName":"cherries","name":"$desc","line":180,"kind":13},{"containerName":"cherries","name":"$cherries","kind":13,"line":183}],"line":163,"definition":"sub","containerName":"main::","signature":{"label":"cherries($;$)","documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::Statistics - Calculate certain statistics for a Tree\n\n=head1 SYNOPSIS\n\n  use Bio::Tree::Statistics;\n\n=head1 DESCRIPTION\n\nThis should be where Tree statistics are calculated.  It was\npreviously where statistics from a Coalescent simulation.\n\nIt now contains several methods for calculating L<Tree-Trait\nstatistics>.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason AT bioperl.org\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho, heikki at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::Statistics;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::Statistics->new();\n Function: Builds a new Bio::Tree::Statistics object \n Returns : Bio::Tree::Statistics\n Args    :\n\n\n\n\n=head2 assess_bootstrap\n\n Title   : assess_bootstrap\n Usage   : my $tree_with_bs = $stats->assess_bootstrap(\\@bs_trees);\n Function: Calculates the bootstrap for internal nodes based on\n Returns : L<Bio::Tree::TreeI>\n Args    : Arrayref of L<Bio::Tree::TreeI>s\n\n\n\nsub assess_bootstrap{\n   my ($self,$bs_trees,$guide_tree) = @_;\n   my @consensus;\n\n   # internal nodes are defined by their children\n\n   my (%lookup,%internal);\n   my $i = 0;\n   for my $tree ( $guide_tree, @$bs_trees ) {\n       # Do this as a top down approach, can probably be\n       # improved by caching internal node states, but not going\n       # to worry about it right now.\n\n       my @allnodes = $tree->get_nodes;\n       my @internalnodes = grep { ! $_->is_Leaf } @allnodes;\n       for my $node ( @internalnodes ) {\n\t   my @tips = sort map { $_->id } \n\t              grep { $_->is_Leaf() } $node->get_all_Descendents;\n\t   my $id = \"(\".join(\",\", @tips).\")\";\n\t   if( $i == 0 ) {\n\t       $internal{$id} = $node->internal_id;\n\t   } else { \n\t       $lookup{$id}++;\n\t   }\n       }\n       $i++;\n   }\n   my @save;\n   for my $l ( keys %lookup ) {\n       if( defined $internal{$l} ) {#&& $lookup{$l} > $min_seen ) {\n\t   my $intnode = $guide_tree->find_node(-internal_id => $internal{$l});\n\t   $intnode->bootstrap(sprintf(\"%d\",100 * $lookup{$l} / $i));\n       }\n   }\n   return $guide_tree;\n}\n\n\n\n=head2 cherries\n\n  Example    : cherries($tree, $node);\n  Description: Count number of paired leaf nodes\n               in a binary tree\n  Returns    : integer\n  Exceptions : \n  Args       : 1. Bio::Tree::TreeI object\n               2. Bio::Tree::NodeI object within the tree, optional\n\nCommonly used statistics assume a binary tree, but this methods\nreturns a value even for trees with polytomies.","parameters":[{"label":"$;$"}]},"detail":"($;$)"},{"children":[{"name":"$self","definition":"my","containerName":"fitch","localvar":"my","kind":13,"line":232},{"kind":13,"line":233,"containerName":"fitch","definition":"my","name":"$tree","localvar":"my"},{"localvar":"my","containerName":"fitch","name":"$key","definition":"my","line":234,"kind":13},{"line":234,"kind":13,"containerName":"fitch","name":"$self"},{"line":234,"kind":12,"containerName":"fitch","name":"throw"},{"kind":13,"line":235,"definition":"my","name":"$node","containerName":"fitch","localvar":"my"},{"kind":13,"line":235,"containerName":"fitch","name":"$tree"},{"containerName":"fitch","name":"get_root_node","line":235,"kind":12},{"line":237,"kind":13,"containerName":"fitch","name":"$self"},{"name":"fitch_up","containerName":"fitch","kind":12,"line":237},{"line":237,"kind":13,"containerName":"fitch","name":"$tree"},{"line":237,"kind":13,"containerName":"fitch","name":"$key"},{"kind":13,"line":237,"name":"$node","containerName":"fitch"},{"line":238,"kind":13,"name":"$self","containerName":"fitch"},{"line":238,"kind":12,"name":"fitch_down","containerName":"fitch"},{"containerName":"fitch","name":"$tree","kind":13,"line":238},{"containerName":"fitch","name":"$node","line":238,"kind":13}],"line":231,"kind":12,"range":{"start":{"line":231,"character":0},"end":{"line":239,"character":9999}},"definition":"sub","name":"fitch","containerName":"main::"},{"kind":12,"line":264,"children":[{"kind":12,"line":264,"name":"fitch_up","containerName":"ps"}],"containerName":"main::","name":"ps","definition":"sub","range":{"end":{"line":264,"character":9999},"start":{"character":0,"line":264}}},{"name":"fitch_up","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":287},"end":{"line":332,"character":9999}},"kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"fitch_up","line":288,"kind":13},{"name":"$tree","definition":"my","containerName":"fitch_up","localvar":"my","kind":13,"line":289},{"containerName":"fitch_up","name":"$key","definition":"my","localvar":"my","kind":13,"line":290},{"containerName":"fitch_up","name":"$self","line":290,"kind":13},{"kind":12,"line":290,"containerName":"fitch_up","name":"throw"},{"line":291,"kind":13,"localvar":"my","containerName":"fitch_up","definition":"my","name":"$node"},{"line":291,"kind":13,"containerName":"fitch_up","name":"$tree"},{"kind":12,"line":291,"containerName":"fitch_up","name":"get_root_node"},{"line":293,"kind":13,"containerName":"fitch_up","name":"$node"},{"containerName":"fitch_up","name":"is_Leaf","kind":12,"line":293},{"name":"$self","containerName":"fitch_up","line":294,"kind":13},{"kind":12,"line":294,"containerName":"fitch_up","name":"throw"},{"line":294,"kind":13,"name":"$node","containerName":"fitch_up"},{"kind":12,"line":294,"containerName":"fitch_up","name":"internal_id"},{"kind":13,"line":295,"name":"$node","containerName":"fitch_up"},{"name":"has_tag","containerName":"fitch_up","line":295,"kind":12},{"containerName":"fitch_up","name":"$key","line":295,"kind":13},{"name":"$node","containerName":"fitch_up","line":296,"kind":13},{"line":296,"kind":12,"name":"set_tag_value","containerName":"fitch_up"},{"containerName":"fitch_up","name":"$node","line":296,"kind":13},{"line":296,"kind":12,"name":"get_tag_values","containerName":"fitch_up"},{"kind":13,"line":296,"containerName":"fitch_up","name":"$key"},{"containerName":"fitch_up","name":"$node","kind":13,"line":297},{"kind":12,"line":297,"containerName":"fitch_up","name":"set_tag_value"},{"definition":"my","name":"$child","containerName":"fitch_up","localvar":"my","kind":13,"line":301},{"line":301,"kind":13,"containerName":"fitch_up","name":"$node"},{"kind":12,"line":301,"containerName":"fitch_up","name":"each_Descendent"},{"containerName":"fitch_up","name":"$self","line":302,"kind":13},{"containerName":"fitch_up","name":"fitch_up","kind":12,"line":302},{"line":302,"kind":13,"name":"$tree","containerName":"fitch_up"},{"name":"$key","containerName":"fitch_up","kind":13,"line":302},{"kind":13,"line":302,"containerName":"fitch_up","name":"$child"},{"line":305,"kind":13,"localvar":"my","containerName":"fitch_up","definition":"my","name":"%intersection"},{"kind":13,"line":306,"name":"%union","definition":"my","containerName":"fitch_up","localvar":"my"},{"name":"$score","definition":"my","containerName":"fitch_up","localvar":"my","kind":13,"line":307},{"definition":"my","name":"$child","containerName":"fitch_up","localvar":"my","kind":13,"line":309},{"kind":13,"line":309,"containerName":"fitch_up","name":"$node"},{"containerName":"fitch_up","name":"each_Descendent","kind":12,"line":309},{"line":310,"kind":13,"localvar":"my","definition":"my","name":"$trait","containerName":"fitch_up"},{"line":310,"kind":13,"name":"$child","containerName":"fitch_up"},{"line":310,"kind":12,"name":"get_tag_values","containerName":"fitch_up"},{"name":"$intersection","containerName":"fitch_up","line":311,"kind":13},{"containerName":"fitch_up","name":"$trait","kind":13,"line":311},{"line":311,"kind":13,"containerName":"fitch_up","name":"$union"},{"kind":13,"line":311,"containerName":"fitch_up","name":"$trait"},{"kind":13,"line":312,"name":"$union","containerName":"fitch_up"},{"name":"$trait","containerName":"fitch_up","line":312,"kind":13},{"containerName":"fitch_up","name":"$score","kind":13,"line":314},{"name":"$child","containerName":"fitch_up","line":314,"kind":13},{"line":314,"kind":12,"containerName":"fitch_up","name":"get_tag_values"},{"name":"%intersection","containerName":"fitch_up","kind":13,"line":317},{"kind":13,"line":318,"containerName":"fitch_up","name":"$node"},{"containerName":"fitch_up","name":"set_tag_value","line":318,"kind":12},{"line":318,"kind":13,"name":"%intersection","containerName":"fitch_up"},{"containerName":"fitch_up","name":"$node","kind":13,"line":319},{"containerName":"fitch_up","name":"set_tag_value","line":319,"kind":12},{"line":319,"kind":13,"containerName":"fitch_up","name":"$score"},{"name":"$node","containerName":"fitch_up","line":321,"kind":13},{"name":"set_tag_value","containerName":"fitch_up","line":321,"kind":12},{"containerName":"fitch_up","name":"%union","line":321,"kind":13},{"name":"$node","containerName":"fitch_up","kind":13,"line":322},{"kind":12,"line":322,"name":"set_tag_value","containerName":"fitch_up"},{"containerName":"fitch_up","name":"$score","kind":13,"line":322},{"kind":13,"line":325,"name":"$self","containerName":"fitch_up"},{"line":325,"kind":12,"name":"verbose","containerName":"fitch_up"},{"containerName":"fitch_up","name":"$node","kind":13,"line":327},{"containerName":"fitch_up","name":"internal_id","line":327,"kind":12},{"line":327,"kind":13,"containerName":"fitch_up","name":"$node"},{"line":327,"kind":12,"name":"id","containerName":"fitch_up"},{"name":"$node","containerName":"fitch_up","kind":13,"line":328},{"line":328,"kind":12,"name":"get_tag_values","containerName":"fitch_up"},{"name":"$node","containerName":"fitch_up","kind":13,"line":329},{"kind":12,"line":329,"containerName":"fitch_up","name":"get_tag_values"},{"line":331,"kind":13,"containerName":"fitch_up","name":"$node"},{"kind":12,"line":331,"name":"get_tag_values","containerName":"fitch_up"}],"line":287},{"line":355,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"fitch_down","line":356,"kind":13},{"kind":13,"line":357,"containerName":"fitch_down","definition":"my","name":"$tree","localvar":"my"},{"kind":13,"line":358,"containerName":"fitch_down","name":"$node","definition":"my","localvar":"my"},{"kind":13,"line":358,"name":"$tree","containerName":"fitch_down"},{"name":"get_root_node","containerName":"fitch_down","kind":12,"line":358},{"line":360,"kind":13,"localvar":"my","containerName":"fitch_down","name":"$key","definition":"my"},{"line":361,"kind":13,"containerName":"fitch_down","name":"$self"},{"name":"throw","containerName":"fitch_down","line":361,"kind":12},{"containerName":"fitch_down","name":"$node","line":361,"kind":13},{"containerName":"fitch_down","name":"internal_id","line":361,"kind":12},{"name":"$node","containerName":"fitch_down","kind":13,"line":362},{"name":"has_tag","containerName":"fitch_down","kind":12,"line":362},{"line":362,"kind":13,"name":"$key","containerName":"fitch_down"},{"kind":13,"line":364,"name":"$nodev","definition":"my","containerName":"fitch_down","localvar":"my"},{"kind":13,"line":365,"name":"$trait","definition":"my","containerName":"fitch_down","localvar":"my"},{"line":365,"kind":13,"containerName":"fitch_down","name":"$node"},{"line":365,"kind":12,"containerName":"fitch_down","name":"get_tag_values"},{"name":"$key","containerName":"fitch_down","kind":13,"line":365},{"name":"$nodev","containerName":"fitch_down","kind":13,"line":366},{"name":"$trait","containerName":"fitch_down","kind":13,"line":366},{"definition":"my","name":"$child","containerName":"fitch_down","localvar":"my","kind":13,"line":369},{"containerName":"fitch_down","name":"$node","kind":13,"line":369},{"line":369,"kind":12,"name":"each_Descendent","containerName":"fitch_down"},{"kind":13,"line":370,"name":"$child","containerName":"fitch_down"},{"name":"is_Leaf","containerName":"fitch_down","kind":12,"line":370},{"localvar":"my","containerName":"fitch_down","definition":"my","name":"$intersection","line":372,"kind":13},{"name":"$trait","definition":"my","containerName":"fitch_down","localvar":"my","kind":13,"line":373},{"containerName":"fitch_down","name":"$child","line":373,"kind":13},{"kind":12,"line":373,"name":"get_tag_values","containerName":"fitch_down"},{"line":373,"kind":13,"name":"$key","containerName":"fitch_down"},{"line":374,"kind":13,"name":"$intersection","containerName":"fitch_down"},{"name":"$trait","containerName":"fitch_down","line":374,"kind":13},{"name":"$nodev","containerName":"fitch_down","kind":13,"line":374},{"line":374,"kind":13,"name":"$trait","containerName":"fitch_down"},{"name":"$self","containerName":"fitch_down","kind":13,"line":377},{"name":"fitch_down","containerName":"fitch_down","line":377,"kind":12},{"line":377,"kind":13,"containerName":"fitch_down","name":"$tree"},{"name":"$child","containerName":"fitch_down","kind":13,"line":377},{"name":"$child","containerName":"fitch_down","line":378,"kind":13},{"containerName":"fitch_down","name":"set_tag_value","kind":12,"line":378},{"line":378,"kind":13,"containerName":"fitch_down","name":"$key"},{"kind":13,"line":378,"containerName":"fitch_down","name":"$intersection"}],"kind":12,"range":{"end":{"character":9999,"line":381},"start":{"line":355,"character":0}},"containerName":"main::","name":"fitch_down","definition":"sub"},{"containerName":"main::","definition":"sub","name":"_persistence","range":{"end":{"line":425,"character":9999},"start":{"line":405,"character":0}},"kind":12,"line":405,"children":[{"kind":13,"line":406,"containerName":"_persistence","name":"$self","definition":"my","localvar":"my"},{"definition":"my","name":"$tree","containerName":"_persistence","localvar":"my","kind":13,"line":407},{"kind":13,"line":408,"containerName":"_persistence","name":"$node","definition":"my","localvar":"my"},{"kind":13,"line":409,"definition":"my","name":"$value","containerName":"_persistence","localvar":"my"},{"kind":13,"line":409,"name":"$self","containerName":"_persistence"},{"line":409,"kind":12,"containerName":"_persistence","name":"throw"},{"kind":13,"line":412,"containerName":"_persistence","definition":"my","name":"$key","localvar":"my"},{"containerName":"_persistence","name":"$self","kind":13,"line":414},{"kind":12,"line":414,"containerName":"_persistence","name":"throw"},{"kind":13,"line":414,"containerName":"_persistence","name":"$node"},{"name":"isa","containerName":"_persistence","kind":12,"line":414},{"line":416,"kind":13,"name":"$node","containerName":"_persistence"},{"line":416,"kind":12,"name":"get_tag_values","containerName":"_persistence"},{"name":"$key","containerName":"_persistence","kind":13,"line":416},{"kind":13,"line":416,"containerName":"_persistence","name":"$value"},{"containerName":"_persistence","name":"$node","line":417,"kind":13},{"name":"is_Leaf","containerName":"_persistence","kind":12,"line":417},{"kind":13,"line":419,"name":"$persistence","definition":"my","containerName":"_persistence","localvar":"my"},{"localvar":"my","name":"$child","definition":"my","containerName":"_persistence","line":420,"kind":13},{"line":420,"kind":13,"containerName":"_persistence","name":"$node"},{"name":"each_Descendent","containerName":"_persistence","line":420,"kind":12},{"kind":13,"line":421,"definition":"my","name":"$pers","containerName":"_persistence","localvar":"my"},{"kind":13,"line":421,"containerName":"_persistence","name":"$self"},{"line":421,"kind":12,"containerName":"_persistence","name":"_persistence"},{"kind":13,"line":421,"name":"$tree","containerName":"_persistence"},{"line":421,"kind":13,"name":"$child","containerName":"_persistence"},{"containerName":"_persistence","name":"$value","kind":13,"line":421},{"line":422,"kind":13,"name":"$persistence","containerName":"_persistence"},{"kind":13,"line":422,"containerName":"_persistence","name":"$pers"},{"containerName":"_persistence","name":"$pers","line":422,"kind":13},{"name":"$persistence","containerName":"_persistence","kind":13,"line":422},{"name":"$persistence","containerName":"_persistence","kind":13,"line":424}]},{"line":427,"children":[{"line":428,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"persistence"},{"definition":"my","name":"$tree","containerName":"persistence","localvar":"my","kind":13,"line":429},{"containerName":"persistence","name":"$node","definition":"my","localvar":"my","kind":13,"line":430},{"name":"$tree","containerName":"persistence","line":430,"kind":13},{"kind":12,"line":430,"name":"get_root_node","containerName":"persistence"},{"name":"$self","containerName":"persistence","kind":13,"line":431},{"line":431,"kind":12,"containerName":"persistence","name":"throw"},{"name":"$node","containerName":"persistence","line":431,"kind":13},{"name":"isa","containerName":"persistence","line":431,"kind":12},{"line":433,"kind":13,"localvar":"my","name":"$key","definition":"my","containerName":"persistence"},{"localvar":"my","containerName":"persistence","definition":"my","name":"$value","line":434,"kind":13},{"kind":13,"line":434,"containerName":"persistence","name":"$node"},{"name":"get_tag_values","containerName":"persistence","line":434,"kind":12},{"kind":13,"line":434,"name":"$key","containerName":"persistence"},{"containerName":"persistence","name":"$persistence","definition":"my","localvar":"my","kind":13,"line":437},{"containerName":"persistence","name":"$self","line":437,"kind":13},{"name":"_persistence","containerName":"persistence","kind":12,"line":437},{"kind":13,"line":437,"name":"$tree","containerName":"persistence"},{"kind":13,"line":437,"containerName":"persistence","name":"$node"},{"name":"$value","containerName":"persistence","kind":13,"line":437},{"line":438,"kind":13,"containerName":"persistence","name":"$node"},{"kind":12,"line":438,"name":"set_tag_value","containerName":"persistence"},{"line":438,"kind":13,"containerName":"persistence","name":"$persistence"},{"line":439,"kind":13,"containerName":"persistence","name":"$persistence"}],"kind":12,"range":{"start":{"character":0,"line":427},"end":{"line":440,"character":9999}},"containerName":"main::","definition":"sub","name":"persistence"},{"range":{"start":{"line":458,"character":0},"end":{"line":481,"character":9999}},"containerName":"main::","name":"_count_subclusters","definition":"sub","line":458,"children":[{"localvar":"my","containerName":"_count_subclusters","name":"$self","definition":"my","line":459,"kind":13},{"kind":13,"line":460,"definition":"my","name":"$tree","containerName":"_count_subclusters","localvar":"my"},{"kind":13,"line":461,"containerName":"_count_subclusters","name":"$node","definition":"my","localvar":"my"},{"kind":13,"line":462,"containerName":"_count_subclusters","name":"$value","definition":"my","localvar":"my"},{"kind":13,"line":462,"name":"$self","containerName":"_count_subclusters"},{"name":"throw","containerName":"_count_subclusters","kind":12,"line":462},{"localvar":"my","containerName":"_count_subclusters","definition":"my","name":"$key","line":464,"kind":13},{"name":"$self","containerName":"_count_subclusters","line":466,"kind":13},{"containerName":"_count_subclusters","name":"throw","kind":12,"line":466},{"kind":13,"line":466,"containerName":"_count_subclusters","name":"$node"},{"kind":12,"line":466,"name":"internal_id","containerName":"_count_subclusters"},{"kind":13,"line":467,"containerName":"_count_subclusters","name":"$node"},{"line":467,"kind":12,"name":"has_tag","containerName":"_count_subclusters"},{"line":467,"kind":13,"name":"$key","containerName":"_count_subclusters"},{"line":469,"kind":13,"name":"$node","containerName":"_count_subclusters"},{"kind":12,"line":469,"name":"get_tag_values","containerName":"_count_subclusters"},{"kind":13,"line":469,"containerName":"_count_subclusters","name":"$key"},{"line":469,"kind":13,"name":"$value","containerName":"_count_subclusters"},{"kind":13,"line":470,"containerName":"_count_subclusters","name":"$node"},{"containerName":"_count_subclusters","name":"get_tag_values","kind":12,"line":470},{"line":473,"kind":13,"localvar":"my","definition":"my","name":"$count","containerName":"_count_subclusters"},{"localvar":"my","name":"$child","definition":"my","containerName":"_count_subclusters","line":474,"kind":13},{"kind":13,"line":474,"containerName":"_count_subclusters","name":"$node"},{"kind":12,"line":474,"name":"each_Descendent","containerName":"_count_subclusters"},{"line":475,"kind":13,"name":"$count","containerName":"_count_subclusters"},{"kind":13,"line":475,"containerName":"_count_subclusters","name":"$self"},{"name":"_count_subclusters","containerName":"_count_subclusters","line":475,"kind":12},{"containerName":"_count_subclusters","name":"$tree","line":475,"kind":13},{"kind":13,"line":475,"containerName":"_count_subclusters","name":"$child"},{"kind":13,"line":475,"name":"$value","containerName":"_count_subclusters"},{"containerName":"_count_subclusters","name":"$count","kind":13,"line":477}],"kind":12},{"children":[{"localvar":"my","containerName":"count_subclusters","name":"$self","definition":"my","line":484,"kind":13},{"localvar":"my","containerName":"count_subclusters","name":"$tree","definition":"my","line":485,"kind":13},{"localvar":"my","containerName":"count_subclusters","definition":"my","name":"$node","line":486,"kind":13},{"containerName":"count_subclusters","name":"$tree","line":486,"kind":13},{"containerName":"count_subclusters","name":"get_root_node","line":486,"kind":12},{"containerName":"count_subclusters","name":"$self","kind":13,"line":487},{"containerName":"count_subclusters","name":"throw","kind":12,"line":487},{"containerName":"count_subclusters","name":"$node","kind":13,"line":487},{"kind":12,"line":487,"name":"isa","containerName":"count_subclusters"},{"line":489,"kind":13,"localvar":"my","containerName":"count_subclusters","definition":"my","name":"$key"},{"localvar":"my","containerName":"count_subclusters","definition":"my","name":"$value","line":490,"kind":13},{"containerName":"count_subclusters","name":"$node","kind":13,"line":490},{"containerName":"count_subclusters","name":"get_tag_values","kind":12,"line":490},{"containerName":"count_subclusters","name":"$key","kind":13,"line":490},{"containerName":"count_subclusters","name":"$self","kind":13,"line":492},{"line":492,"kind":12,"name":"_count_subclusters","containerName":"count_subclusters"},{"name":"$tree","containerName":"count_subclusters","line":492,"kind":13},{"containerName":"count_subclusters","name":"$node","line":492,"kind":13},{"kind":13,"line":492,"containerName":"count_subclusters","name":"$value"}],"line":483,"kind":12,"range":{"end":{"line":493,"character":9999},"start":{"line":483,"character":0}},"name":"count_subclusters","definition":"sub","containerName":"main::"},{"definition":"sub","name":"_count_leaves","containerName":"main::","range":{"start":{"line":511,"character":0},"end":{"line":533,"character":9999}},"kind":12,"children":[{"containerName":"_count_leaves","definition":"my","name":"$self","localvar":"my","kind":13,"line":512},{"name":"$tree","definition":"my","containerName":"_count_leaves","localvar":"my","kind":13,"line":513},{"containerName":"_count_leaves","name":"$node","definition":"my","localvar":"my","kind":13,"line":514},{"line":514,"kind":13,"containerName":"_count_leaves","name":"$tree"},{"name":"get_root_node","containerName":"_count_leaves","kind":12,"line":514},{"kind":13,"line":515,"containerName":"_count_leaves","name":"$value","definition":"my","localvar":"my"},{"line":517,"kind":13,"localvar":"my","name":"$key","definition":"my","containerName":"_count_leaves"},{"kind":13,"line":519,"name":"$self","containerName":"_count_leaves"},{"name":"throw","containerName":"_count_leaves","line":519,"kind":12},{"kind":13,"line":519,"name":"$node","containerName":"_count_leaves"},{"line":519,"kind":12,"containerName":"_count_leaves","name":"internal_id"},{"line":520,"kind":13,"name":"$node","containerName":"_count_leaves"},{"line":520,"kind":12,"name":"has_tag","containerName":"_count_leaves"},{"kind":13,"line":520,"name":"$key","containerName":"_count_leaves"},{"containerName":"_count_leaves","name":"$node","kind":13,"line":522},{"line":522,"kind":12,"name":"get_tag_values","containerName":"_count_leaves"},{"containerName":"_count_leaves","name":"$key","kind":13,"line":522},{"kind":13,"line":522,"name":"$value","containerName":"_count_leaves"},{"containerName":"_count_leaves","name":"$node","line":524,"kind":13},{"kind":12,"line":524,"name":"is_Leaf","containerName":"_count_leaves"},{"definition":"my","name":"$count","containerName":"_count_leaves","localvar":"my","kind":13,"line":526},{"line":527,"kind":13,"localvar":"my","definition":"my","name":"$child","containerName":"_count_leaves"},{"name":"$node","containerName":"_count_leaves","kind":13,"line":527},{"name":"each_Descendent","containerName":"_count_leaves","kind":12,"line":527},{"containerName":"_count_leaves","name":"$count","line":528,"kind":13},{"kind":13,"line":528,"containerName":"_count_leaves","name":"$self"},{"line":528,"kind":12,"name":"_count_leaves","containerName":"_count_leaves"},{"line":528,"kind":13,"name":"$tree","containerName":"_count_leaves"},{"line":528,"kind":13,"containerName":"_count_leaves","name":"$child"},{"name":"$value","containerName":"_count_leaves","kind":13,"line":528},{"kind":13,"line":530,"containerName":"_count_leaves","name":"$count"}],"line":511},{"range":{"start":{"character":0,"line":535},"end":{"line":545,"character":9999}},"definition":"sub","name":"count_leaves","containerName":"main::","children":[{"line":536,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"count_leaves"},{"localvar":"my","containerName":"count_leaves","name":"$tree","definition":"my","line":537,"kind":13},{"localvar":"my","definition":"my","name":"$node","containerName":"count_leaves","line":538,"kind":13},{"name":"$tree","containerName":"count_leaves","line":538,"kind":13},{"name":"get_root_node","containerName":"count_leaves","line":538,"kind":12},{"name":"$self","containerName":"count_leaves","kind":13,"line":539},{"containerName":"count_leaves","name":"throw","line":539,"kind":12},{"containerName":"count_leaves","name":"$node","line":539,"kind":13},{"kind":12,"line":539,"name":"isa","containerName":"count_leaves"},{"kind":13,"line":541,"name":"$key","definition":"my","containerName":"count_leaves","localvar":"my"},{"kind":13,"line":542,"containerName":"count_leaves","definition":"my","name":"$value","localvar":"my"},{"line":542,"kind":13,"name":"$node","containerName":"count_leaves"},{"kind":12,"line":542,"name":"get_tag_values","containerName":"count_leaves"},{"containerName":"count_leaves","name":"$key","kind":13,"line":542},{"name":"$self","containerName":"count_leaves","line":544,"kind":13},{"containerName":"count_leaves","name":"_count_leaves","line":544,"kind":12},{"line":544,"kind":13,"containerName":"count_leaves","name":"$tree"},{"kind":13,"line":544,"containerName":"count_leaves","name":"$node"},{"name":"$value","containerName":"count_leaves","kind":13,"line":544}],"line":535,"kind":12},{"range":{"start":{"character":0,"line":562},"end":{"line":583,"character":9999}},"containerName":"main::","name":"_phylotype_length","definition":"sub","line":562,"children":[{"localvar":"my","containerName":"_phylotype_length","definition":"my","name":"$self","line":563,"kind":13},{"kind":13,"line":564,"containerName":"_phylotype_length","definition":"my","name":"$tree","localvar":"my"},{"line":565,"kind":13,"localvar":"my","containerName":"_phylotype_length","definition":"my","name":"$node"},{"localvar":"my","containerName":"_phylotype_length","definition":"my","name":"$value","line":566,"kind":13},{"localvar":"my","containerName":"_phylotype_length","name":"$key","definition":"my","line":568,"kind":13},{"name":"$self","containerName":"_phylotype_length","kind":13,"line":570},{"name":"throw","containerName":"_phylotype_length","kind":12,"line":570},{"containerName":"_phylotype_length","name":"$node","kind":13,"line":570},{"kind":12,"line":570,"containerName":"_phylotype_length","name":"internal_id"},{"name":"$node","containerName":"_phylotype_length","kind":13,"line":571},{"containerName":"_phylotype_length","name":"has_tag","line":571,"kind":12},{"kind":13,"line":571,"containerName":"_phylotype_length","name":"$key"},{"containerName":"_phylotype_length","name":"$node","line":573,"kind":13},{"name":"get_tag_values","containerName":"_phylotype_length","kind":12,"line":573},{"line":573,"kind":13,"name":"$key","containerName":"_phylotype_length"},{"name":"$value","containerName":"_phylotype_length","kind":13,"line":573},{"containerName":"_phylotype_length","name":"$node","line":574,"kind":13},{"kind":12,"line":574,"name":"branch_length","containerName":"_phylotype_length"},{"kind":13,"line":574,"containerName":"_phylotype_length","name":"$node"},{"name":"is_Leaf","containerName":"_phylotype_length","line":574,"kind":12},{"line":576,"kind":13,"localvar":"my","containerName":"_phylotype_length","definition":"my","name":"$length"},{"localvar":"my","name":"$child","definition":"my","containerName":"_phylotype_length","line":577,"kind":13},{"name":"$node","containerName":"_phylotype_length","line":577,"kind":13},{"containerName":"_phylotype_length","name":"each_Descendent","line":577,"kind":12},{"kind":13,"line":578,"name":"$sub_len","definition":"my","containerName":"_phylotype_length","localvar":"my"},{"line":578,"kind":13,"name":"$self","containerName":"_phylotype_length"},{"name":"_phylotype_length","containerName":"_phylotype_length","kind":12,"line":578},{"containerName":"_phylotype_length","name":"$tree","line":578,"kind":13},{"line":578,"kind":13,"containerName":"_phylotype_length","name":"$child"},{"name":"$value","containerName":"_phylotype_length","kind":13,"line":578},{"line":579,"kind":13,"name":"$length","containerName":"_phylotype_length"},{"line":579,"kind":13,"containerName":"_phylotype_length","name":"$sub_len"},{"kind":13,"line":580,"containerName":"_phylotype_length","name":"$length"},{"kind":13,"line":580,"name":"$child","containerName":"_phylotype_length"},{"containerName":"_phylotype_length","name":"branch_length","line":580,"kind":12},{"line":580,"kind":13,"name":"$child","containerName":"_phylotype_length"},{"containerName":"_phylotype_length","name":"is_Leaf","line":580,"kind":12},{"containerName":"_phylotype_length","name":"$sub_len","line":580,"kind":13},{"kind":13,"line":582,"name":"$length","containerName":"_phylotype_length"}],"kind":12},{"children":[{"line":587,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"phylotype_length"},{"line":588,"kind":13,"localvar":"my","containerName":"phylotype_length","name":"$tree","definition":"my"},{"line":589,"kind":13,"localvar":"my","containerName":"phylotype_length","name":"$node","definition":"my"},{"name":"$tree","containerName":"phylotype_length","line":589,"kind":13},{"kind":12,"line":589,"containerName":"phylotype_length","name":"get_root_node"},{"localvar":"my","containerName":"phylotype_length","definition":"my","name":"$key","line":591,"kind":13},{"containerName":"phylotype_length","name":"$value","definition":"my","localvar":"my","kind":13,"line":592},{"name":"$node","containerName":"phylotype_length","kind":13,"line":592},{"containerName":"phylotype_length","name":"get_tag_values","line":592,"kind":12},{"line":592,"kind":13,"name":"$key","containerName":"phylotype_length"},{"containerName":"phylotype_length","name":"$self","kind":13,"line":594},{"line":594,"kind":12,"name":"_phylotype_length","containerName":"phylotype_length"},{"name":"$tree","containerName":"phylotype_length","kind":13,"line":594},{"kind":13,"line":594,"containerName":"phylotype_length","name":"$node"},{"name":"$value","containerName":"phylotype_length","line":594,"kind":13}],"line":586,"kind":12,"range":{"start":{"line":586,"character":0},"end":{"character":9999,"line":595}},"definition":"sub","name":"phylotype_length","containerName":"main::"},{"line":612,"children":[{"containerName":"_sum_of_leaf_distances","name":"$self","definition":"my","localvar":"my","kind":13,"line":613},{"kind":13,"line":614,"definition":"my","name":"$tree","containerName":"_sum_of_leaf_distances","localvar":"my"},{"containerName":"_sum_of_leaf_distances","definition":"my","name":"$node","localvar":"my","kind":13,"line":615},{"localvar":"my","definition":"my","name":"$value","containerName":"_sum_of_leaf_distances","line":616,"kind":13},{"name":"$key","definition":"my","containerName":"_sum_of_leaf_distances","localvar":"my","kind":13,"line":618},{"kind":13,"line":620,"name":"$self","containerName":"_sum_of_leaf_distances"},{"name":"throw","containerName":"_sum_of_leaf_distances","line":620,"kind":12},{"line":620,"kind":13,"name":"$node","containerName":"_sum_of_leaf_distances"},{"containerName":"_sum_of_leaf_distances","name":"internal_id","line":620,"kind":12},{"containerName":"_sum_of_leaf_distances","name":"$node","line":621,"kind":13},{"line":621,"kind":12,"name":"has_tag","containerName":"_sum_of_leaf_distances"},{"containerName":"_sum_of_leaf_distances","name":"$key","kind":13,"line":621},{"kind":13,"line":622,"name":"$node","containerName":"_sum_of_leaf_distances"},{"line":622,"kind":12,"name":"get_tag_values","containerName":"_sum_of_leaf_distances"},{"kind":13,"line":622,"containerName":"_sum_of_leaf_distances","name":"$key"},{"name":"$value","containerName":"_sum_of_leaf_distances","line":622,"kind":13},{"name":"$node","containerName":"_sum_of_leaf_distances","kind":13,"line":624},{"line":624,"kind":12,"name":"is_Leaf","containerName":"_sum_of_leaf_distances"},{"name":"$length","definition":"my","containerName":"_sum_of_leaf_distances","localvar":"my","kind":13,"line":626},{"kind":13,"line":627,"containerName":"_sum_of_leaf_distances","definition":"my","name":"$child","localvar":"my"},{"kind":13,"line":627,"containerName":"_sum_of_leaf_distances","name":"$node"},{"line":627,"kind":12,"name":"each_Descendent","containerName":"_sum_of_leaf_distances"},{"containerName":"_sum_of_leaf_distances","name":"$length","line":628,"kind":13},{"name":"$self","containerName":"_sum_of_leaf_distances","kind":13,"line":628},{"line":628,"kind":12,"name":"_count_leaves","containerName":"_sum_of_leaf_distances"},{"containerName":"_sum_of_leaf_distances","name":"$tree","kind":13,"line":628},{"line":628,"kind":13,"name":"$child","containerName":"_sum_of_leaf_distances"},{"containerName":"_sum_of_leaf_distances","name":"$value","line":628,"kind":13},{"kind":13,"line":628,"containerName":"_sum_of_leaf_distances","name":"$child"},{"containerName":"_sum_of_leaf_distances","name":"branch_length","line":628,"kind":12},{"containerName":"_sum_of_leaf_distances","name":"$self","kind":13,"line":629},{"line":629,"kind":12,"name":"_sum_of_leaf_distances","containerName":"_sum_of_leaf_distances"},{"name":"$tree","containerName":"_sum_of_leaf_distances","kind":13,"line":629},{"line":629,"kind":13,"name":"$child","containerName":"_sum_of_leaf_distances"},{"name":"$value","containerName":"_sum_of_leaf_distances","kind":13,"line":629},{"kind":13,"line":631,"name":"$length","containerName":"_sum_of_leaf_distances"}],"kind":12,"range":{"end":{"character":9999,"line":632},"start":{"character":0,"line":612}},"containerName":"main::","definition":"sub","name":"_sum_of_leaf_distances"},{"kind":12,"children":[{"localvar":"my","containerName":"sum_of_leaf_distances","name":"$self","definition":"my","line":635,"kind":13},{"localvar":"my","containerName":"sum_of_leaf_distances","name":"$tree","definition":"my","line":636,"kind":13},{"containerName":"sum_of_leaf_distances","definition":"my","name":"$node","localvar":"my","kind":13,"line":637},{"line":637,"kind":13,"name":"$tree","containerName":"sum_of_leaf_distances"},{"line":637,"kind":12,"containerName":"sum_of_leaf_distances","name":"get_root_node"},{"kind":13,"line":639,"name":"$key","definition":"my","containerName":"sum_of_leaf_distances","localvar":"my"},{"kind":13,"line":640,"containerName":"sum_of_leaf_distances","name":"$value","definition":"my","localvar":"my"},{"kind":13,"line":640,"containerName":"sum_of_leaf_distances","name":"$node"},{"containerName":"sum_of_leaf_distances","name":"get_tag_values","kind":12,"line":640},{"kind":13,"line":640,"containerName":"sum_of_leaf_distances","name":"$key"},{"line":642,"kind":13,"containerName":"sum_of_leaf_distances","name":"$self"},{"name":"_sum_of_leaf_distances","containerName":"sum_of_leaf_distances","line":642,"kind":12},{"line":642,"kind":13,"containerName":"sum_of_leaf_distances","name":"$tree"},{"containerName":"sum_of_leaf_distances","name":"$node","line":642,"kind":13},{"line":642,"kind":13,"containerName":"sum_of_leaf_distances","name":"$value"}],"line":634,"name":"sum_of_leaf_distances","definition":"sub","containerName":"main::","range":{"end":{"line":643,"character":9999},"start":{"line":634,"character":0}}},{"range":{"end":{"line":667,"character":9999},"start":{"character":0,"line":660}},"definition":"sub","name":"genetic_diversity","containerName":"main::","children":[{"containerName":"genetic_diversity","definition":"my","name":"$self","localvar":"my","kind":13,"line":661},{"kind":13,"line":662,"containerName":"genetic_diversity","definition":"my","name":"$tree","localvar":"my"},{"kind":13,"line":663,"containerName":"genetic_diversity","name":"$node","definition":"my","localvar":"my"},{"line":663,"kind":13,"name":"$tree","containerName":"genetic_diversity"},{"line":663,"kind":12,"name":"get_root_node","containerName":"genetic_diversity"},{"line":665,"kind":13,"containerName":"genetic_diversity","name":"$self"},{"kind":12,"line":665,"containerName":"genetic_diversity","name":"sum_of_leaf_distances"},{"containerName":"genetic_diversity","name":"$tree","kind":13,"line":665},{"line":665,"kind":13,"containerName":"genetic_diversity","name":"$node"},{"containerName":"genetic_diversity","name":"$self","line":666,"kind":13},{"kind":12,"line":666,"name":"count_leaves","containerName":"genetic_diversity"},{"line":666,"kind":13,"containerName":"genetic_diversity","name":"$tree"},{"containerName":"genetic_diversity","name":"$node","line":666,"kind":13}],"line":660,"kind":12},{"range":{"end":{"line":695,"character":9999},"start":{"line":686,"character":0}},"name":"statratio","definition":"sub","containerName":"main::","children":[{"kind":13,"line":687,"containerName":"statratio","definition":"my","name":"$self","localvar":"my"},{"line":688,"kind":13,"localvar":"my","containerName":"statratio","name":"$tree","definition":"my"},{"line":689,"kind":13,"localvar":"my","containerName":"statratio","name":"$node","definition":"my"},{"containerName":"statratio","name":"$tree","line":689,"kind":13},{"kind":12,"line":689,"containerName":"statratio","name":"get_root_node"},{"kind":13,"line":691,"containerName":"statratio","definition":"my","name":"$div","localvar":"my"},{"containerName":"statratio","name":"$self","line":691,"kind":13},{"containerName":"statratio","name":"genetic_diversity","kind":12,"line":691},{"kind":13,"line":691,"containerName":"statratio","name":"$tree"},{"containerName":"statratio","name":"$node","line":691,"kind":13},{"kind":13,"line":692,"containerName":"statratio","name":"$div"},{"line":693,"kind":13,"name":"$node","containerName":"statratio"},{"containerName":"statratio","name":"branch_length","kind":12,"line":693},{"kind":13,"line":693,"name":"$div","containerName":"statratio"}],"line":686,"kind":12},{"children":[{"line":721,"kind":13,"localvar":"my","containerName":"_node_ai","name":"$self","definition":"my"},{"definition":"my","name":"$node","containerName":"_node_ai","localvar":"my","kind":13,"line":722},{"localvar":"my","name":"$key","definition":"my","containerName":"_node_ai","line":723,"kind":13},{"kind":13,"line":725,"containerName":"_node_ai","name":"$traits","definition":"my","localvar":"my"},{"containerName":"_node_ai","definition":"my","name":"$leaf_count","localvar":"my","kind":13,"line":726},{"name":"$desc","definition":"my","containerName":"_node_ai","localvar":"my","kind":13,"line":727},{"kind":13,"line":727,"containerName":"_node_ai","name":"$node"},{"containerName":"_node_ai","name":"get_all_Descendents","kind":12,"line":727},{"line":728,"kind":13,"containerName":"_node_ai","name":"$desc"},{"name":"is_Leaf","containerName":"_node_ai","kind":12,"line":728},{"name":"$leaf_count","containerName":"_node_ai","line":729,"kind":13},{"containerName":"_node_ai","name":"$self","line":730,"kind":13},{"line":730,"kind":12,"containerName":"_node_ai","name":"throw"},{"kind":13,"line":730,"name":"$desc","containerName":"_node_ai"},{"line":730,"kind":12,"containerName":"_node_ai","name":"id"},{"line":731,"kind":13,"name":"$desc","containerName":"_node_ai"},{"name":"has_tag","containerName":"_node_ai","line":731,"kind":12},{"line":731,"kind":13,"name":"$key","containerName":"_node_ai"},{"line":732,"kind":13,"localvar":"my","definition":"my","name":"$trait","containerName":"_node_ai"},{"name":"$desc","containerName":"_node_ai","line":732,"kind":13},{"containerName":"_node_ai","name":"get_tag_values","kind":12,"line":732},{"line":732,"kind":13,"containerName":"_node_ai","name":"$key"},{"name":"$traits","containerName":"_node_ai","kind":13,"line":733},{"line":733,"kind":13,"containerName":"_node_ai","name":"$trait"},{"line":735,"kind":13,"localvar":"my","containerName":"_node_ai","name":"$most_common","definition":"my"},{"name":"$traits","containerName":"_node_ai","kind":13,"line":736},{"kind":13,"line":737,"containerName":"_node_ai","name":"$most_common"},{"line":737,"kind":13,"containerName":"_node_ai","name":"$traits"},{"name":"$traits","containerName":"_node_ai","line":737,"kind":13},{"line":737,"kind":13,"containerName":"_node_ai","name":"$most_common"},{"line":739,"kind":13,"containerName":"_node_ai","name":"$most_common"},{"kind":13,"line":739,"name":"$leaf_count","containerName":"_node_ai"},{"name":"$leaf_count","containerName":"_node_ai","kind":13,"line":739}],"line":720,"kind":12,"range":{"start":{"line":720,"character":0},"end":{"line":740,"character":9999}},"definition":"sub","name":"_node_ai","containerName":"main::"},{"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"ai","line":743,"kind":13},{"kind":13,"line":744,"name":"$tree","definition":"my","containerName":"ai","localvar":"my"},{"kind":13,"line":745,"containerName":"ai","definition":"my","name":"$key","localvar":"my"},{"name":"$self","containerName":"ai","line":745,"kind":13},{"kind":12,"line":745,"name":"throw","containerName":"ai"},{"kind":13,"line":746,"containerName":"ai","definition":"my","name":"$start_node","localvar":"my"},{"line":746,"kind":13,"name":"$tree","containerName":"ai"},{"kind":12,"line":746,"containerName":"ai","name":"get_root_node"},{"name":"$start_node","containerName":"ai","line":747,"kind":13},{"kind":13,"line":749,"name":"$sum","definition":"my","containerName":"ai","localvar":"my"},{"containerName":"ai","name":"$node","definition":"my","localvar":"my","kind":13,"line":750},{"name":"$start_node","containerName":"ai","kind":13,"line":750},{"kind":12,"line":750,"containerName":"ai","name":"get_all_Descendents"},{"kind":13,"line":751,"name":"$node","containerName":"ai"},{"line":751,"kind":12,"containerName":"ai","name":"is_Leaf"},{"containerName":"ai","name":"$sum","kind":13,"line":752},{"kind":13,"line":752,"name":"$self","containerName":"ai"},{"containerName":"ai","name":"_node_ai","kind":12,"line":752},{"containerName":"ai","name":"$node","kind":13,"line":752},{"kind":13,"line":752,"containerName":"ai","name":"$key"},{"containerName":"ai","name":"$sum","kind":13,"line":754}],"line":742,"kind":12,"range":{"end":{"line":755,"character":9999},"start":{"line":742,"character":0}},"definition":"sub","name":"ai","containerName":"main::"},{"children":[{"line":791,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_node_mc"},{"definition":"my","name":"$node","containerName":"_node_mc","localvar":"my","kind":13,"line":792},{"localvar":"my","containerName":"_node_mc","definition":"my","name":"$key","line":793,"kind":13},{"kind":13,"line":795,"definition":"my","name":"$traits","containerName":"_node_mc","localvar":"my"},{"localvar":"my","containerName":"_node_mc","name":"$leaf_count","definition":"my","line":796,"kind":13},{"kind":13,"line":797,"name":"$node2","definition":"my","containerName":"_node_mc","localvar":"my"},{"containerName":"_node_mc","name":"$node","line":797,"kind":13},{"containerName":"_node_mc","name":"get_all_Descendents","line":797,"kind":12},{"kind":13,"line":798,"containerName":"_node_mc","name":"$node2"},{"line":798,"kind":12,"containerName":"_node_mc","name":"is_Leaf"},{"name":"$leaf_count","containerName":"_node_mc","kind":13,"line":799},{"containerName":"_node_mc","definition":"my","name":"$trait","localvar":"my","kind":13,"line":800},{"name":"$node2","containerName":"_node_mc","line":800,"kind":13},{"line":800,"kind":12,"name":"get_tag_values","containerName":"_node_mc"},{"kind":13,"line":800,"containerName":"_node_mc","name":"$key"},{"containerName":"_node_mc","name":"$traits","line":801,"kind":13},{"line":801,"kind":13,"name":"$trait","containerName":"_node_mc"},{"name":"$traits","containerName":"_node_mc","kind":13,"line":803}],"line":790,"kind":12,"range":{"end":{"line":804,"character":9999},"start":{"line":790,"character":0}},"definition":"sub","name":"_node_mc","containerName":"main::"},{"containerName":"main::","name":"mc","definition":"sub","range":{"end":{"line":833,"character":9999},"start":{"line":807,"character":0}},"kind":12,"line":807,"children":[{"line":808,"kind":13,"localvar":"my","containerName":"mc","name":"$self","definition":"my"},{"line":809,"kind":13,"localvar":"my","name":"$tree","definition":"my","containerName":"mc"},{"definition":"my","name":"$key","containerName":"mc","localvar":"my","kind":13,"line":810},{"kind":13,"line":811,"definition":"my","name":"$start_node","containerName":"mc","localvar":"my"},{"kind":13,"line":811,"containerName":"mc","name":"$tree"},{"line":811,"kind":12,"name":"get_root_node","containerName":"mc"},{"line":812,"kind":13,"name":"$start_node","containerName":"mc"},{"containerName":"mc","name":"$sum","definition":"my","localvar":"my","kind":13,"line":814},{"kind":13,"line":815,"containerName":"mc","name":"$keys","definition":"my","localvar":"my"},{"localvar":"my","containerName":"mc","definition":"my","name":"$node","line":816,"kind":13},{"kind":13,"line":816,"containerName":"mc","name":"$start_node"},{"kind":12,"line":816,"name":"get_all_Descendents","containerName":"mc"},{"containerName":"mc","name":"$node","kind":13,"line":817},{"line":817,"kind":12,"name":"is_Leaf","containerName":"mc"},{"containerName":"mc","definition":"my","name":"$traits","localvar":"my","kind":13,"line":818},{"line":818,"kind":13,"containerName":"mc","name":"$self"},{"containerName":"mc","name":"_node_mc","line":818,"kind":12},{"name":"$node","containerName":"mc","line":818,"kind":13},{"name":"$key","containerName":"mc","kind":13,"line":818},{"kind":13,"line":819,"name":"$traits","containerName":"mc"},{"containerName":"mc","name":"$value","definition":"my","localvar":"my","kind":13,"line":820},{"line":820,"kind":13,"containerName":"mc","name":"$traits"},{"kind":13,"line":821,"name":"$warnings","containerName":"mc"},{"line":822,"kind":13,"containerName":"mc","name":"$sum"},{"name":"$value","containerName":"mc","kind":13,"line":822},{"kind":13,"line":822,"containerName":"mc","name":"$traits"},{"containerName":"mc","name":"$value","line":822,"kind":13},{"name":"$sum","containerName":"mc","line":823,"kind":13},{"name":"$value","containerName":"mc","kind":13,"line":823},{"name":"$traits","containerName":"mc","line":823,"kind":13},{"line":823,"kind":13,"containerName":"mc","name":"$value"},{"containerName":"mc","name":"$keys","kind":13,"line":825},{"line":825,"kind":13,"containerName":"mc","name":"$traits"},{"localvar":"my","definition":"my","name":"$value","containerName":"mc","line":829,"kind":13},{"kind":13,"line":830,"containerName":"mc","name":"$sum"},{"name":"$value","containerName":"mc","kind":13,"line":830},{"line":830,"kind":13,"name":"$sum","containerName":"mc"},{"kind":13,"line":830,"name":"$value","containerName":"mc"},{"line":832,"kind":13,"name":"$sum","containerName":"mc"}]}]}