{"vars":[{"containerName":"","name":"vars","line":86,"kind":2},{"kind":13,"line":88,"containerName":null,"name":"$UIDCOUNTER"},{"name":"strict","containerName":"","kind":2,"line":88},{"containerName":"","name":"base","kind":2,"line":93},{"name":"new","range":{"start":{"line":113,"character":0},"end":{"line":119,"character":9999}},"kind":12,"children":[{"name":"$class","definition":"my","containerName":"new","localvar":"my","kind":13,"line":114},{"kind":13,"line":114,"containerName":"new","name":"@args"},{"localvar":"my","containerName":"new","name":"$self","definition":"my","line":116,"kind":13},{"line":116,"kind":13,"name":"$class","containerName":"new"},{"kind":13,"line":116,"containerName":"new","name":"@args"},{"containerName":"new","name":"$self","line":117,"kind":13},{"name":"individual","containerName":"new","line":117,"kind":12},{"line":117,"kind":12,"containerName":"new","name":"new"},{"containerName":"new","name":"@args","line":117,"kind":13},{"containerName":"new","name":"$self","line":118,"kind":13}],"line":113,"definition":"sub","containerName":"main::","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: AlleleNode.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::AlleleNode\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::AlleleNode - A Node with Alleles attached\n\n=head1 SYNOPSIS\n\n  use Bio::Tree::AlleleNode;\n\n=head1 DESCRIPTION\n\nAlleleNodes are basic L<Bio::Tree::Node>s with the added ability to\nadd Genotypes alleles as defined by the L<Bio::PopGen::IndividualI>\ninterface.  Genotypes are defined by the L<Bio::PopGen::GenotypeI>\ninterface, you will probably want to use the L<Bio::PopGen::Genotype>\nimplementation.\n\nThis is implemented via containment to avoid multiple inheritance\nproblems.  Their is a L<Bio::PopGen::Individual> object which handles\nthe L<Bio::PopGen::IndividualI> interface, and is accessible via the\nL<Bio::Tree::AlleleNode::individual> method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n=head1 HISTORY\n\nThis module was re-written to be a combination of\nL<Bio::PopGen::Individual> and L<Bio::Tree::Node> primarily for use in\nL<Bio::PopGen::Simulation::Coalescent> simulations.\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::AlleleNode;\nuse vars qw($UIDCOUNTER);\nuse strict;\nBEGIN { $UIDCOUNTER = 1 }\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::Tree::Node Bio::PopGen::IndividualI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::AlleleNode->new();\n Function: Builds a new Bio::Tree::AlleleNode() object \n Returns : an instance of Bio::Tree::AlleleNode\n Args    : -unique_id     => $id,\n           -genotypes     => \\@genotypes\n           -left          => pointer to Left descendent (optional)\n           -right         => pointer to Right descenent (optional)\n\t   -branch_length => branch length [integer] (optional)\n           -bootstrap     => value   bootstrap value (string)\n           -description   => description of node\n           -id            => human readable (unique) id for node\n                             Should NOT contain the characters \n                             '();:'"},"detail":"($class,@args)"},{"line":116,"kind":12,"name":"SUPER","containerName":"new"},{"line":117,"kind":12,"containerName":"PopGen::Individual","name":"Bio"},{"range":{"start":{"character":0,"line":132},"end":{"character":9999,"line":139}},"name":"individual","signature":{"label":"individual($self,$newval)","parameters":[{"label":"$self"},{"label":"$newval"}],"documentation":"1;\n# $Id: AlleleNode.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::AlleleNode\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::AlleleNode - A Node with Alleles attached\n\n=head1 SYNOPSIS\n\n  use Bio::Tree::AlleleNode;\n\n=head1 DESCRIPTION\n\nAlleleNodes are basic L<Bio::Tree::Node>s with the added ability to\nadd Genotypes alleles as defined by the L<Bio::PopGen::IndividualI>\ninterface.  Genotypes are defined by the L<Bio::PopGen::GenotypeI>\ninterface, you will probably want to use the L<Bio::PopGen::Genotype>\nimplementation.\n\nThis is implemented via containment to avoid multiple inheritance\nproblems.  Their is a L<Bio::PopGen::Individual> object which handles\nthe L<Bio::PopGen::IndividualI> interface, and is accessible via the\nL<Bio::Tree::AlleleNode::individual> method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n=head1 HISTORY\n\nThis module was re-written to be a combination of\nL<Bio::PopGen::Individual> and L<Bio::Tree::Node> primarily for use in\nL<Bio::PopGen::Simulation::Coalescent> simulations.\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::AlleleNode;\nuse vars qw($UIDCOUNTER);\nuse strict;\nBEGIN { $UIDCOUNTER = 1 }\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::Tree::Node Bio::PopGen::IndividualI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::AlleleNode->new();\n Function: Builds a new Bio::Tree::AlleleNode() object \n Returns : an instance of Bio::Tree::AlleleNode\n Args    : -unique_id     => $id,\n           -genotypes     => \\@genotypes\n           -left          => pointer to Left descendent (optional)\n           -right         => pointer to Right descenent (optional)\n\t   -branch_length => branch length [integer] (optional)\n           -bootstrap     => value   bootstrap value (string)\n           -description   => description of node\n           -id            => human readable (unique) id for node\n                             Should NOT contain the characters \n                             '();:'\n\nsub new { \n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    $self->individual( Bio::PopGen::Individual->new(@args));\n    return $self;\n}\n\n=head2 individual\n\n Title   : individual\n Usage   : $obj->individual($newval)\n Function: Get/Set Access to the underlying individual object\n Returns : L<Bio::PopGen::Individual> object\n Args    : on set, new value (L<Bio::PopGen::Individual>)"},"detail":"($self,$newval)","definition":"sub","containerName":"main::","children":[{"containerName":"individual","definition":"my","name":"$self","localvar":"my","kind":13,"line":133},{"kind":13,"line":133,"containerName":"individual","name":"$newval"},{"line":134,"kind":13,"containerName":"individual","name":"$newval"},{"line":134,"kind":13,"containerName":"individual","name":"$self"},{"name":"$newval","containerName":"individual","line":135,"kind":13},{"containerName":"individual","name":"new","line":135,"kind":12},{"kind":13,"line":135,"containerName":"individual","name":"$newval"},{"name":"$self","containerName":"individual","kind":13,"line":136},{"kind":13,"line":136,"containerName":"individual","name":"$newval"},{"containerName":"individual","name":"$self","line":138,"kind":13}],"line":132,"kind":12},{"name":"Bio","containerName":"PopGen::Individual","kind":12,"line":135},{"kind":12,"line":157,"children":[{"line":158,"kind":13,"localvar":"my","containerName":"unique_id","definition":"my","name":"$self"},{"containerName":"unique_id","name":"$self","line":159,"kind":13},{"line":159,"kind":12,"name":"individual","containerName":"unique_id"},{"containerName":"unique_id","name":"unique_id","kind":12,"line":159}],"containerName":"main::","name":"unique_id","definition":"sub","range":{"end":{"line":160,"character":9999},"start":{"line":157,"character":0}}},{"line":172,"children":[{"line":173,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"num_of_results"},{"name":"$self","containerName":"num_of_results","line":174,"kind":13},{"name":"individual","containerName":"num_of_results","kind":12,"line":174},{"containerName":"num_of_results","name":"num_of_results","kind":12,"line":174}],"kind":12,"range":{"end":{"character":9999,"line":175},"start":{"line":172,"character":0}},"containerName":"main::","definition":"sub","name":"num_of_results"},{"range":{"end":{"character":9999,"line":192},"start":{"line":189,"character":0}},"definition":"sub","name":"add_Genotype","containerName":"main::","children":[{"name":"$self","definition":"my","containerName":"add_Genotype","localvar":"my","kind":13,"line":190},{"line":191,"kind":13,"name":"$self","containerName":"add_Genotype"},{"line":191,"kind":12,"containerName":"add_Genotype","name":"individual"},{"kind":12,"line":191,"name":"add_Genotype","containerName":"add_Genotype"}],"line":189,"kind":12},{"children":[{"line":206,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"reset_Genotypes"},{"containerName":"reset_Genotypes","name":"$self","kind":13,"line":207},{"name":"individual","containerName":"reset_Genotypes","kind":12,"line":207},{"containerName":"reset_Genotypes","name":"reset_Genotypes","kind":12,"line":207}],"line":205,"kind":12,"range":{"start":{"line":205,"character":0},"end":{"character":9999,"line":208}},"name":"reset_Genotypes","definition":"sub","containerName":"main::"},{"line":221,"children":[{"name":"$self","definition":"my","containerName":"remove_Genotype","localvar":"my","kind":13,"line":222},{"kind":13,"line":223,"containerName":"remove_Genotype","name":"$self"},{"containerName":"remove_Genotype","name":"individual","line":223,"kind":12},{"line":223,"kind":12,"containerName":"remove_Genotype","name":"remove_Genotype"}],"kind":12,"range":{"end":{"character":9999,"line":224},"start":{"character":0,"line":221}},"containerName":"main::","name":"remove_Genotype","definition":"sub"},{"line":238,"children":[{"kind":13,"line":239,"containerName":"get_Genotypes","definition":"my","name":"$self","localvar":"my"},{"name":"$self","containerName":"get_Genotypes","line":240,"kind":13},{"kind":12,"line":240,"containerName":"get_Genotypes","name":"individual"},{"name":"get_Genotypes","containerName":"get_Genotypes","line":240,"kind":12}],"kind":12,"range":{"end":{"character":9999,"line":241},"start":{"line":238,"character":0}},"containerName":"main::","definition":"sub","name":"get_Genotypes"},{"kind":12,"line":255,"children":[{"localvar":"my","containerName":"has_Marker","name":"$self","definition":"my","line":256,"kind":13},{"name":"$self","containerName":"has_Marker","line":257,"kind":13},{"containerName":"has_Marker","name":"individual","line":257,"kind":12},{"name":"has_Marker","containerName":"has_Marker","line":257,"kind":12}],"containerName":"main::","definition":"sub","name":"has_Marker","range":{"end":{"line":258,"character":9999},"start":{"character":0,"line":255}}},{"line":271,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"get_marker_names","line":272,"kind":13},{"line":273,"kind":13,"name":"$self","containerName":"get_marker_names"},{"line":273,"kind":12,"name":"individual","containerName":"get_marker_names"},{"line":273,"kind":12,"containerName":"get_marker_names","name":"get_marker_names"}],"kind":12,"range":{"start":{"character":0,"line":271},"end":{"line":274,"character":9999}},"containerName":"main::","name":"get_marker_names","definition":"sub"}],"version":5}