{"version":5,"vars":[{"name":"strict","kind":12,"line":130},{"line":130,"kind":2,"containerName":"","name":"strict"},{"kind":12,"line":136,"containerName":"Ext::Align","name":"Bio"},{"kind":2,"line":145,"name":"base","containerName":""},{"range":{"end":{"line":187,"character":9999},"start":{"line":149,"character":0}},"name":"new","line":149,"children":[{"name":"$class","definition":"my","containerName":"new","localvar":"my","kind":13,"line":150},{"kind":13,"line":150,"containerName":"new","name":"@args"},{"localvar":"my","containerName":"new","name":"$self","definition":"my","line":152,"kind":13},{"line":152,"kind":13,"name":"$class","containerName":"new"},{"line":152,"kind":13,"containerName":"new","name":"@args"},{"localvar":"my","name":"$matrix","definition":"my","containerName":"new","line":154,"kind":13},{"name":"$gap","containerName":"new","line":154,"kind":13},{"kind":13,"line":154,"containerName":"new","name":"$ext"},{"name":"$self","containerName":"new","kind":13,"line":154},{"line":154,"kind":12,"name":"_rearrange","containerName":"new"},{"kind":13,"line":157,"name":"@args","containerName":"new"},{"line":161,"kind":13,"containerName":"new","name":"$matrix"},{"name":"$matrix","containerName":"new","line":161,"kind":13},{"containerName":"new","name":"$matrix","line":162,"kind":13},{"name":"$self","containerName":"new","line":165,"kind":13},{"kind":12,"line":165,"name":"matrix","containerName":"new"},{"line":165,"kind":13,"containerName":"new","name":"$matrix"},{"line":166,"kind":13,"containerName":"new","name":"$self"},{"name":"gap","containerName":"new","kind":12,"line":166},{"name":"$gap","containerName":"new","line":166,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":167},{"name":"ext","containerName":"new","kind":12,"line":167},{"name":"$ext","containerName":"new","line":167,"kind":13},{"line":171,"kind":13,"name":"$gap","containerName":"new"},{"kind":13,"line":172,"name":"$gap","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":173},{"containerName":"new","name":"gap","kind":12,"line":173},{"containerName":"new","name":"$gap","line":173,"kind":13},{"kind":13,"line":175,"name":"$self","containerName":"new"},{"kind":12,"line":175,"containerName":"new","name":"throw"},{"name":"$ext","containerName":"new","kind":13,"line":178},{"kind":13,"line":179,"name":"$ext","containerName":"new"},{"kind":13,"line":180,"name":"$self","containerName":"new"},{"containerName":"new","name":"ext","line":180,"kind":12},{"kind":13,"line":180,"containerName":"new","name":"$ext"},{"name":"$self","containerName":"new","kind":13,"line":182},{"kind":12,"line":182,"containerName":"new","name":"throw"},{"name":"$self","containerName":"new","kind":13,"line":186}],"kind":12,"detail":"($class,@args)","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":""},"containerName":"main::","definition":"sub"},{"name":"SUPER","containerName":"new","kind":12,"line":152},{"range":{"end":{"line":304,"character":9999},"start":{"character":0,"line":201}},"name":"pairwise_alignment","detail":"($self,$seq1,$seq2)","signature":{"parameters":[{"label":"$self"},{"label":"$seq1"},{"label":"$seq2"}],"documentation":"1;\n## $Id: pSW.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n#\n# BioPerl module for Bio::Tools::pSW\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::pSW - pairwise Smith Waterman object\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::pSW;\n    use Bio::AlignIO;\n    my $factory = Bio::Tools::pSW->new( '-matrix' => 'blosum62.bla',\n\t\t\t\t       '-gap' => 12,\n\t\t\t\t       '-ext' => 2,\n\t\t\t\t       );\n\n    #use the factory to make some output\n\n    $factory->align_and_show($seq1,$seq2,STDOUT);\n\n    # make a Bio::SimpleAlign and do something with it\n\n    my $aln = $factory->pairwise_alignment($seq1,$seq2);\n    my $alnout = Bio::AlignIO->new(-format => 'msf',\n\t\t\t\t  -fh     => \\*STDOUT);\n\n    $alnout->write_aln($aln);\n\n=head1 INSTALLATION\n\nThis module is included with the central Bioperl distribution:\n\n   http://bio.perl.org/Core/Latest\n   ftp://bio.perl.org/pub/DIST\n\nFollow the installation instructions included in the INSTALL file.\n\n=head1 DESCRIPTION\n\npSW is an Alignment Factory for protein sequences. It builds pairwise\nalignments using the Smith-Waterman algorithm. The alignment algorithm is\nimplemented in C and added in using an XS extension. The XS extension basically\ncomes from the Wise2 package, but has been slimmed down to only be the\nalignment part of that (this is a good thing!). The XS extension comes\nfrom the bioperl-ext package which is distributed along with bioperl.\nI<Warning:> This package will not work if you have not compiled the\nbioperl-ext package.\n\nThe mixture of C and Perl is ideal for this sort of \nproblem. Here are some plus points for this strategy: \n\n=over 2\n\n* Speed and Memory \n\nThe algorithm is actually implemented in C, which means it is faster than\na pure perl implementation (I have never done one, so I have no idea\nhow faster) and will use considerably less memory, as it efficiently\nassigns memory for the calculation.\n\n* Algorithm efficiency\n\nThe algorithm was written using Dynamite, and so contains an automatic\nswitch to the linear space divide-and-conquer method. This means you\ncould effectively align very large sequences without killing your machine\n(it could take a while though!).\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists \n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/           \n\n=head1 AUTHOR\n\nEwan Birney, birney-at-sanger.ac.uk or birney-at-ebi.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with an underscore \"_\".\n\n\n# Let the code begin...\n\npackage Bio::Tools::pSW;\nuse strict;\nno strict ( 'refs');\n\nBEGIN {\n    eval {\n\trequire Bio::Ext::Align;\n    };\n    if ( $@ ) {\n\tdie(\"\\nThe C-compiled engine for Smith Waterman alignments (Bio::Ext::Align) has not been installed.\\n Please read the install the bioperl-ext package\\n\\n\");\n\texit(1);\n    }\n}\n\nuse Bio::SimpleAlign;\n\n\nuse base qw(Bio::Tools::AlignFactory);\n\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n\n  my($matrix,$gap,$ext) = $self->_rearrange([qw(MATRIX\n\t\t\t\t\t\tGAP\n\t\t\t\t\t\tEXT\n\t\t\t\t\t\t)],@args);\n  \n  #default values - we have to load matrix into memory, so \n  # we need to check it out now\n  if( ! defined $matrix || !($matrix =~ /\\w/) ) {\n      $matrix = 'blosum62.bla';\n  }\n\n  $self->matrix($matrix); # will throw exception if it can't load it\n  $self->gap(12) unless defined $gap;\n  $self->ext(2) unless defined $ext;\n\n  # I'm pretty sure I am not doing this right... ho hum...\n  # This was not roght ($gap and $ext could not be 0) It is fixed now /AE\n  if(  defined $gap ) {\n      if( $gap =~ /^\\d+$/ ) {\n\t  $self->gap($gap);\n      } else {\n\t  $self->throw(\"Gap penalty must be a number, not [$gap]\");\n      }\n  }\n  if( defined $ext ) {\n      if( $ext =~ /^\\d+$/ )  {\n\t  $self->ext($ext);\n      } else {\n\t  $self->throw(\"Extension penalty must be a number, not [$ext]\");\n      }\n  }\n \n  return $self; \n}\n\n\n=head2 pairwise_alignment\n\n Title   : pairwise_alignment\n Usage   : $aln = $factory->pairwise_alignment($seq1,$seq2)\n Function: Makes a SimpleAlign object from two sequences\n Returns : A SimpleAlign object\n Args    :","label":"pairwise_alignment($self,$seq1,$seq2)"},"containerName":"main::","definition":"sub","line":201,"children":[{"definition":"my","name":"$self","containerName":"pairwise_alignment","localvar":"my","kind":13,"line":202},{"name":"$seq1","containerName":"pairwise_alignment","kind":13,"line":202},{"line":202,"kind":13,"containerName":"pairwise_alignment","name":"$seq2"},{"localvar":"my","containerName":"pairwise_alignment","name":"$t1","definition":"my","line":203,"kind":13},{"name":"$t2","containerName":"pairwise_alignment","line":203,"kind":13},{"name":"$aln","containerName":"pairwise_alignment","line":203,"kind":13},{"kind":13,"line":203,"name":"$out","containerName":"pairwise_alignment"},{"kind":13,"line":203,"containerName":"pairwise_alignment","name":"@str1"},{"name":"@str2","containerName":"pairwise_alignment","kind":13,"line":203},{"kind":13,"line":203,"containerName":"pairwise_alignment","name":"@ostr1"},{"containerName":"pairwise_alignment","name":"@ostr2","line":203,"kind":13},{"name":"$alc","containerName":"pairwise_alignment","line":203,"kind":13},{"name":"$tstr","containerName":"pairwise_alignment","line":203,"kind":13},{"containerName":"pairwise_alignment","name":"$tid","line":203,"kind":13},{"name":"$start1","containerName":"pairwise_alignment","kind":13,"line":203},{"line":203,"kind":13,"name":"$end1","containerName":"pairwise_alignment"},{"containerName":"pairwise_alignment","name":"$start2","kind":13,"line":203},{"line":203,"kind":13,"name":"$end2","containerName":"pairwise_alignment"},{"containerName":"pairwise_alignment","name":"$alctemp","kind":13,"line":203},{"line":205,"kind":13,"name":"$seq1","containerName":"pairwise_alignment"},{"kind":13,"line":205,"name":"$seq1","containerName":"pairwise_alignment"},{"name":"isa","containerName":"pairwise_alignment","kind":12,"line":205},{"line":206,"kind":13,"name":"$seq2","containerName":"pairwise_alignment"},{"containerName":"pairwise_alignment","name":"$seq2","line":206,"kind":13},{"containerName":"pairwise_alignment","name":"isa","kind":12,"line":206},{"containerName":"pairwise_alignment","name":"$self","kind":13,"line":207},{"line":207,"kind":12,"name":"warn","containerName":"pairwise_alignment"},{"containerName":"pairwise_alignment","name":"$seq1","line":211,"kind":13},{"name":"length","containerName":"pairwise_alignment","kind":12,"line":211},{"line":212,"kind":13,"name":"$seq2","containerName":"pairwise_alignment"},{"name":"length","containerName":"pairwise_alignment","line":212,"kind":12},{"kind":13,"line":213,"name":"$self","containerName":"pairwise_alignment"},{"containerName":"pairwise_alignment","name":"warn","line":213,"kind":12},{"name":"$self","containerName":"pairwise_alignment","line":216,"kind":13},{"line":216,"kind":12,"containerName":"pairwise_alignment","name":"set_memory_and_report"},{"name":"$seq1","containerName":"pairwise_alignment","line":218,"kind":13},{"containerName":"pairwise_alignment","name":"display_id","kind":12,"line":218},{"line":218,"kind":13,"name":"$seq1","containerName":"pairwise_alignment"},{"line":218,"kind":12,"name":"id","containerName":"pairwise_alignment"},{"kind":13,"line":219,"name":"$seq2","containerName":"pairwise_alignment"},{"name":"display_id","containerName":"pairwise_alignment","line":219,"kind":12},{"name":"$seq2","containerName":"pairwise_alignment","line":219,"kind":13},{"line":219,"kind":12,"containerName":"pairwise_alignment","name":"id"},{"name":"$t1","containerName":"pairwise_alignment","kind":13,"line":221},{"name":"$seq1","containerName":"pairwise_alignment","kind":13,"line":221},{"kind":12,"line":221,"containerName":"pairwise_alignment","name":"id"},{"name":"$seq1","containerName":"pairwise_alignment","kind":13,"line":222},{"line":222,"kind":12,"name":"seq","containerName":"pairwise_alignment"},{"kind":13,"line":223,"containerName":"pairwise_alignment","name":"$t2"},{"line":223,"kind":13,"containerName":"pairwise_alignment","name":"$seq2"},{"containerName":"pairwise_alignment","name":"id","kind":12,"line":223},{"name":"$seq2","containerName":"pairwise_alignment","kind":13,"line":224},{"name":"seq","containerName":"pairwise_alignment","kind":12,"line":224},{"name":"$aln","containerName":"pairwise_alignment","kind":13,"line":225},{"containerName":"pairwise_alignment","name":"$t1","line":225,"kind":13},{"kind":13,"line":225,"containerName":"pairwise_alignment","name":"$t2"},{"line":225,"kind":13,"name":"$self","containerName":"pairwise_alignment"},{"name":"$self","containerName":"pairwise_alignment","kind":13,"line":225},{"line":225,"kind":12,"containerName":"pairwise_alignment","name":"gap"},{"containerName":"pairwise_alignment","name":"$self","kind":13,"line":225},{"name":"ext","containerName":"pairwise_alignment","line":225,"kind":12},{"kind":13,"line":226,"name":"$aln","containerName":"pairwise_alignment"},{"name":"$aln","containerName":"pairwise_alignment","line":226,"kind":13},{"kind":13,"line":227,"containerName":"pairwise_alignment","name":"$self"},{"kind":12,"line":227,"name":"throw","containerName":"pairwise_alignment"},{"containerName":"pairwise_alignment","name":"$t1","line":232,"kind":13},{"containerName":"pairwise_alignment","name":"$t2","line":232,"kind":13},{"kind":13,"line":239,"name":"@str1","containerName":"pairwise_alignment"},{"line":239,"kind":13,"name":"$seq1","containerName":"pairwise_alignment"},{"line":239,"kind":12,"containerName":"pairwise_alignment","name":"seq"},{"containerName":"pairwise_alignment","name":"@str2","line":240,"kind":13},{"containerName":"pairwise_alignment","name":"$seq2","line":240,"kind":13},{"containerName":"pairwise_alignment","name":"seq","kind":12,"line":240},{"name":"$start1","containerName":"pairwise_alignment","kind":13,"line":248},{"kind":13,"line":248,"name":"$aln","containerName":"pairwise_alignment"},{"name":"start","containerName":"pairwise_alignment","line":248,"kind":12},{"name":"alu","containerName":"pairwise_alignment","kind":12,"line":248},{"name":"start","containerName":"pairwise_alignment","line":248,"kind":12},{"containerName":"pairwise_alignment","name":"$start2","line":249,"kind":13},{"containerName":"pairwise_alignment","name":"$aln","line":249,"kind":13},{"containerName":"pairwise_alignment","name":"start","line":249,"kind":12},{"containerName":"pairwise_alignment","name":"alu","kind":12,"line":249},{"name":"start","containerName":"pairwise_alignment","kind":12,"line":249},{"kind":13,"line":253,"containerName":"pairwise_alignment","name":"$alc"},{"containerName":"pairwise_alignment","name":"$aln","kind":13,"line":253},{"containerName":"pairwise_alignment","name":"start","line":253,"kind":12},{"name":"$alc","containerName":"pairwise_alignment","kind":13,"line":253},{"kind":12,"line":253,"containerName":"pairwise_alignment","name":"at_end"},{"line":253,"kind":13,"name":"$alc","containerName":"pairwise_alignment"},{"kind":13,"line":253,"name":"$alc","containerName":"pairwise_alignment"},{"name":"next","containerName":"pairwise_alignment","line":253,"kind":12},{"kind":13,"line":254,"name":"$alc","containerName":"pairwise_alignment"},{"line":254,"kind":12,"name":"alu","containerName":"pairwise_alignment"},{"name":"text_label","containerName":"pairwise_alignment","line":254,"kind":12},{"kind":13,"line":255,"name":"@ostr1","containerName":"pairwise_alignment"},{"name":"$str1","containerName":"pairwise_alignment","kind":13,"line":255},{"line":255,"kind":13,"name":"$alc","containerName":"pairwise_alignment"},{"containerName":"pairwise_alignment","name":"alu","line":255,"kind":12},{"containerName":"pairwise_alignment","name":"start","line":255,"kind":12},{"kind":13,"line":258,"containerName":"pairwise_alignment","name":"@ostr1"},{"name":"$alc","containerName":"pairwise_alignment","kind":13,"line":261},{"containerName":"pairwise_alignment","name":"alu","kind":12,"line":261},{"containerName":"pairwise_alignment","name":"text_label","line":261,"kind":12},{"kind":13,"line":262,"name":"@ostr2","containerName":"pairwise_alignment"},{"line":262,"kind":13,"containerName":"pairwise_alignment","name":"$str2"},{"containerName":"pairwise_alignment","name":"$alc","kind":13,"line":262},{"kind":12,"line":262,"name":"alu","containerName":"pairwise_alignment"},{"containerName":"pairwise_alignment","name":"start","line":262,"kind":12},{"containerName":"pairwise_alignment","name":"@ostr2","kind":13,"line":265},{"kind":13,"line":267,"name":"$alctemp","containerName":"pairwise_alignment"},{"containerName":"pairwise_alignment","name":"$alc","line":267,"kind":13},{"kind":13,"line":277,"name":"$end1","containerName":"pairwise_alignment"},{"containerName":"pairwise_alignment","name":"$alctemp","kind":13,"line":277},{"containerName":"pairwise_alignment","name":"alu","kind":12,"line":277},{"kind":12,"line":277,"containerName":"pairwise_alignment","name":"end"},{"containerName":"pairwise_alignment","name":"$end2","kind":13,"line":278},{"kind":13,"line":278,"name":"$alctemp","containerName":"pairwise_alignment"},{"containerName":"pairwise_alignment","name":"alu","line":278,"kind":12},{"containerName":"pairwise_alignment","name":"end","line":278,"kind":12},{"kind":13,"line":281,"containerName":"pairwise_alignment","name":"$alc"},{"kind":13,"line":282,"name":"$aln","containerName":"pairwise_alignment"},{"line":285,"kind":13,"containerName":"pairwise_alignment","name":"$out"},{"kind":12,"line":285,"name":"new","containerName":"pairwise_alignment"},{"line":287,"kind":13,"name":"$tstr","containerName":"pairwise_alignment"},{"name":"@ostr1","containerName":"pairwise_alignment","kind":13,"line":287},{"kind":13,"line":288,"name":"$tid","containerName":"pairwise_alignment"},{"line":288,"kind":13,"name":"$seq1","containerName":"pairwise_alignment"},{"kind":12,"line":288,"containerName":"pairwise_alignment","name":"id"},{"name":"$out","containerName":"pairwise_alignment","kind":13,"line":289},{"line":289,"kind":12,"name":"add_seq","containerName":"pairwise_alignment"},{"name":"new","containerName":"pairwise_alignment","kind":12,"line":289},{"name":"$tstr","containerName":"pairwise_alignment","kind":13,"line":289},{"containerName":"pairwise_alignment","name":"$start1","kind":13,"line":290},{"kind":13,"line":291,"containerName":"pairwise_alignment","name":"$end1"},{"line":292,"kind":13,"containerName":"pairwise_alignment","name":"$tid"},{"kind":13,"line":294,"name":"$tstr","containerName":"pairwise_alignment"},{"containerName":"pairwise_alignment","name":"@ostr2","line":294,"kind":13},{"kind":13,"line":295,"containerName":"pairwise_alignment","name":"$tid"},{"name":"$seq2","containerName":"pairwise_alignment","kind":13,"line":295},{"name":"id","containerName":"pairwise_alignment","line":295,"kind":12},{"line":296,"kind":13,"containerName":"pairwise_alignment","name":"$out"},{"line":296,"kind":12,"containerName":"pairwise_alignment","name":"add_seq"},{"kind":12,"line":296,"containerName":"pairwise_alignment","name":"new"},{"containerName":"pairwise_alignment","name":"$tstr","line":296,"kind":13},{"containerName":"pairwise_alignment","name":"$start2","kind":13,"line":297},{"kind":13,"line":298,"containerName":"pairwise_alignment","name":"$end2"},{"name":"$tid","containerName":"pairwise_alignment","line":299,"kind":13},{"kind":13,"line":303,"name":"$out","containerName":"pairwise_alignment"}],"kind":12},{"containerName":"Ext::Align::new_Sequence_from_strings","name":"Bio","line":221,"kind":12},{"line":223,"kind":12,"containerName":"Ext::Align::new_Sequence_from_strings","name":"Bio"},{"kind":12,"line":225,"name":"Bio","containerName":"Ext::Align::Align_Sequences_ProteinSmithWaterman"},{"containerName":"SimpleAlign","name":"Bio","line":285,"kind":12},{"containerName":"LocatableSeq","name":"Bio","kind":12,"line":289},{"line":296,"kind":12,"containerName":"LocatableSeq","name":"Bio"},{"name":"align_and_show","range":{"start":{"character":0,"line":313},"end":{"character":9999,"line":345}},"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n## $Id: pSW.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n#\n# BioPerl module for Bio::Tools::pSW\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::pSW - pairwise Smith Waterman object\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::pSW;\n    use Bio::AlignIO;\n    my $factory = Bio::Tools::pSW->new( '-matrix' => 'blosum62.bla',\n\t\t\t\t       '-gap' => 12,\n\t\t\t\t       '-ext' => 2,\n\t\t\t\t       );\n\n    #use the factory to make some output\n\n    $factory->align_and_show($seq1,$seq2,STDOUT);\n\n    # make a Bio::SimpleAlign and do something with it\n\n    my $aln = $factory->pairwise_alignment($seq1,$seq2);\n    my $alnout = Bio::AlignIO->new(-format => 'msf',\n\t\t\t\t  -fh     => \\*STDOUT);\n\n    $alnout->write_aln($aln);\n\n=head1 INSTALLATION\n\nThis module is included with the central Bioperl distribution:\n\n   http://bio.perl.org/Core/Latest\n   ftp://bio.perl.org/pub/DIST\n\nFollow the installation instructions included in the INSTALL file.\n\n=head1 DESCRIPTION\n\npSW is an Alignment Factory for protein sequences. It builds pairwise\nalignments using the Smith-Waterman algorithm. The alignment algorithm is\nimplemented in C and added in using an XS extension. The XS extension basically\ncomes from the Wise2 package, but has been slimmed down to only be the\nalignment part of that (this is a good thing!). The XS extension comes\nfrom the bioperl-ext package which is distributed along with bioperl.\nI<Warning:> This package will not work if you have not compiled the\nbioperl-ext package.\n\nThe mixture of C and Perl is ideal for this sort of \nproblem. Here are some plus points for this strategy: \n\n=over 2\n\n* Speed and Memory \n\nThe algorithm is actually implemented in C, which means it is faster than\na pure perl implementation (I have never done one, so I have no idea\nhow faster) and will use considerably less memory, as it efficiently\nassigns memory for the calculation.\n\n* Algorithm efficiency\n\nThe algorithm was written using Dynamite, and so contains an automatic\nswitch to the linear space divide-and-conquer method. This means you\ncould effectively align very large sequences without killing your machine\n(it could take a while though!).\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists \n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/           \n\n=head1 AUTHOR\n\nEwan Birney, birney-at-sanger.ac.uk or birney-at-ebi.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with an underscore \"_\".\n\n\n# Let the code begin...\n\npackage Bio::Tools::pSW;\nuse strict;\nno strict ( 'refs');\n\nBEGIN {\n    eval {\n\trequire Bio::Ext::Align;\n    };\n    if ( $@ ) {\n\tdie(\"\\nThe C-compiled engine for Smith Waterman alignments (Bio::Ext::Align) has not been installed.\\n Please read the install the bioperl-ext package\\n\\n\");\n\texit(1);\n    }\n}\n\nuse Bio::SimpleAlign;\n\n\nuse base qw(Bio::Tools::AlignFactory);\n\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n\n  my($matrix,$gap,$ext) = $self->_rearrange([qw(MATRIX\n\t\t\t\t\t\tGAP\n\t\t\t\t\t\tEXT\n\t\t\t\t\t\t)],@args);\n  \n  #default values - we have to load matrix into memory, so \n  # we need to check it out now\n  if( ! defined $matrix || !($matrix =~ /\\w/) ) {\n      $matrix = 'blosum62.bla';\n  }\n\n  $self->matrix($matrix); # will throw exception if it can't load it\n  $self->gap(12) unless defined $gap;\n  $self->ext(2) unless defined $ext;\n\n  # I'm pretty sure I am not doing this right... ho hum...\n  # This was not roght ($gap and $ext could not be 0) It is fixed now /AE\n  if(  defined $gap ) {\n      if( $gap =~ /^\\d+$/ ) {\n\t  $self->gap($gap);\n      } else {\n\t  $self->throw(\"Gap penalty must be a number, not [$gap]\");\n      }\n  }\n  if( defined $ext ) {\n      if( $ext =~ /^\\d+$/ )  {\n\t  $self->ext($ext);\n      } else {\n\t  $self->throw(\"Extension penalty must be a number, not [$ext]\");\n      }\n  }\n \n  return $self; \n}\n\n\n=head2 pairwise_alignment\n\n Title   : pairwise_alignment\n Usage   : $aln = $factory->pairwise_alignment($seq1,$seq2)\n Function: Makes a SimpleAlign object from two sequences\n Returns : A SimpleAlign object\n Args    :\n\n\n\nsub pairwise_alignment{\n    my ($self,$seq1,$seq2) = @_;\n    my($t1,$t2,$aln,$out,@str1,@str2,@ostr1,@ostr2,$alc,$tstr,$tid,$start1,$end1,$start2,$end2,$alctemp);\n    \n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI') ||\n\t! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n\t$self->warn(\"Cannot call pairwise_alignment without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n\treturn;\n    }\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2 || \n\t$seq2->length() < 2 ) {\n\t$self->warn(\"cannot align sequences with length less than 2\");\n\treturn;\n    }\n    $self->set_memory_and_report();\n    # create engine objects \n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    $t1  = &Bio::Ext::Align::new_Sequence_from_strings($seq1->id(),\n\t\t\t\t\t\t       $seq1->seq());\n    $t2  = &Bio::Ext::Align::new_Sequence_from_strings($seq2->id(),\n\t\t\t\t\t\t       $seq2->seq());\n    $aln = &Bio::Ext::Align::Align_Sequences_ProteinSmithWaterman($t1,$t2,$self->{'matrix'},-$self->gap,-$self->ext);\n    if( ! defined $aln || $aln == 0 ) {\n\t$self->throw(\"Unable to build an alignment\");\n    }\n\n    # free sequence engine objects\n\n    $t1 = $t2 = 0;\n\n    # now we have to get into the AlnBlock structure and\n    # figure out what is aligned to what...\n\n    # we are going to need the sequences as arrays for convience\n\n    @str1 = split(//, $seq1->seq());\n    @str2 = split(//, $seq2->seq());\n\n    # get out start points\n\n    # The alignment is in alignment coordinates - ie the first\n    # residues starts at -1 and ends at 0. (weird I know).\n    # bio-coordinates are +2 from this...\n\n    $start1 = $aln->start()->alu(0)->start +2;\n    $start2 = $aln->start()->alu(1)->start +2;\n\n    # step along the linked list of alc units...\n\n    for($alc = $aln->start();$alc->at_end() != 1;$alc = $alc->next()) {\n\tif( $alc->alu(0)->text_label eq 'SEQUENCE' ) {\n\t    push(@ostr1,$str1[$alc->alu(0)->start+1]);\n\t} else {\n\t    # assumme it is in insert!\n\t    push(@ostr1,'-');\n\t}\n\n\tif( $alc->alu(1)->text_label eq 'SEQUENCE' ) {\n\t    push(@ostr2,$str2[$alc->alu(1)->start+1]);\n\t} else {\n\t    # assumme it is in insert!\n\t    push(@ostr2,'-');\n\t}\n\t$alctemp = $alc;\n    }\n\n    #\n    # get out end points\n    #\n\n    # end points = real residue end in 'C' coordinates = residue\n    # end in biocoordinates. Oh... the wonder of coordinate systems!\n\n    $end1 = $alctemp->alu(0)->end+1;\n    $end2 = $alctemp->alu(1)->end+1;\n\n    # get rid of the alnblock \n    $alc = 0;\n    $aln = 0;\n\n    # new SimpleAlignment\n    $out = Bio::SimpleAlign->new(); # new SimpleAlignment\n\n    $tstr = join('',@ostr1);\n    $tid = $seq1->id();\n    $out->add_seq(Bio::LocatableSeq->new( -seq=> $tstr,\n\t\t\t\t\t -start => $start1,\n\t\t\t\t\t -end   => $end1,\n\t\t\t\t\t -id=>$tid ));\n\n    $tstr = join('',@ostr2);\n    $tid = $seq2->id();\n    $out->add_seq(Bio::LocatableSeq->new( -seq=> $tstr,\n\t\t\t\t\t -start => $start2,\n\t\t\t\t\t -end => $end2,\n\t\t\t\t\t -id=> $tid ));\n\n    # give'm back the alignment\n\n    return $out;\n}\n\n=head2 align_and_show\n\n Title   : align_and_show\n Usage   : $factory->align_and_show($seq1,$seq2,STDOUT)","parameters":[{"label":"$self"},{"label":"$seq1"},{"label":"$seq2"},{"label":"$fh"}],"label":"align_and_show($self,$seq1,$seq2,$fh)"},"detail":"($self,$seq1,$seq2,$fh)","kind":12,"children":[{"definition":"my","name":"$self","containerName":"align_and_show","localvar":"my","kind":13,"line":314},{"name":"$seq1","containerName":"align_and_show","kind":13,"line":314},{"line":314,"kind":13,"containerName":"align_and_show","name":"$seq2"},{"line":314,"kind":13,"containerName":"align_and_show","name":"$fh"},{"name":"$t1","definition":"my","containerName":"align_and_show","localvar":"my","kind":13,"line":315},{"line":315,"kind":13,"containerName":"align_and_show","name":"$t2"},{"kind":13,"line":315,"containerName":"align_and_show","name":"$aln"},{"kind":13,"line":315,"name":"$id","containerName":"align_and_show"},{"containerName":"align_and_show","name":"$str","line":315,"kind":13},{"kind":13,"line":317,"name":"$seq1","containerName":"align_and_show"},{"name":"$seq1","containerName":"align_and_show","line":317,"kind":13},{"name":"isa","containerName":"align_and_show","kind":12,"line":317},{"containerName":"align_and_show","name":"$seq2","line":318,"kind":13},{"containerName":"align_and_show","name":"$seq2","kind":13,"line":318},{"name":"isa","containerName":"align_and_show","line":318,"kind":12},{"kind":13,"line":319,"name":"$self","containerName":"align_and_show"},{"name":"warn","containerName":"align_and_show","kind":12,"line":319},{"containerName":"align_and_show","name":"$seq1","kind":13,"line":323},{"containerName":"align_and_show","name":"length","kind":12,"line":323},{"name":"$seq2","containerName":"align_and_show","kind":13,"line":324},{"line":324,"kind":12,"name":"length","containerName":"align_and_show"},{"containerName":"align_and_show","name":"$self","line":325,"kind":13},{"name":"warn","containerName":"align_and_show","kind":12,"line":325},{"name":"$fh","containerName":"align_and_show","kind":13,"line":328},{"containerName":"align_and_show","name":"$fh","line":329,"kind":13},{"line":331,"kind":13,"name":"$self","containerName":"align_and_show"},{"kind":12,"line":331,"containerName":"align_and_show","name":"set_memory_and_report"},{"name":"$seq1","containerName":"align_and_show","kind":13,"line":332},{"line":332,"kind":12,"containerName":"align_and_show","name":"display_id"},{"containerName":"align_and_show","name":"$seq1","kind":13,"line":332},{"name":"id","containerName":"align_and_show","kind":12,"line":332},{"name":"$seq2","containerName":"align_and_show","kind":13,"line":333},{"kind":12,"line":333,"name":"display_id","containerName":"align_and_show"},{"line":333,"kind":13,"name":"$seq2","containerName":"align_and_show"},{"containerName":"align_and_show","name":"id","kind":12,"line":333},{"kind":13,"line":335,"name":"$t1","containerName":"align_and_show"},{"line":335,"kind":13,"containerName":"align_and_show","name":"$seq1"},{"name":"id","containerName":"align_and_show","kind":12,"line":335},{"containerName":"align_and_show","name":"$seq1","line":335,"kind":13},{"kind":12,"line":335,"containerName":"align_and_show","name":"seq"},{"kind":13,"line":337,"name":"$t2","containerName":"align_and_show"},{"line":337,"kind":13,"name":"$seq2","containerName":"align_and_show"},{"containerName":"align_and_show","name":"id","line":337,"kind":12},{"kind":13,"line":337,"name":"$seq2","containerName":"align_and_show"},{"line":337,"kind":12,"containerName":"align_and_show","name":"seq"},{"name":"$aln","containerName":"align_and_show","line":338,"kind":13},{"kind":13,"line":338,"containerName":"align_and_show","name":"$t1"},{"line":338,"kind":13,"containerName":"align_and_show","name":"$t2"},{"line":338,"kind":13,"containerName":"align_and_show","name":"$self"},{"line":338,"kind":13,"containerName":"align_and_show","name":"$self"},{"kind":12,"line":338,"containerName":"align_and_show","name":"gap"},{"containerName":"align_and_show","name":"$self","line":338,"kind":13},{"name":"ext","containerName":"align_and_show","line":338,"kind":12},{"name":"$aln","containerName":"align_and_show","line":339,"kind":13},{"line":339,"kind":13,"containerName":"align_and_show","name":"$aln"},{"kind":13,"line":340,"containerName":"align_and_show","name":"$self"},{"kind":12,"line":340,"containerName":"align_and_show","name":"throw"},{"kind":13,"line":343,"containerName":"align_and_show","name":"$aln"},{"kind":13,"line":343,"containerName":"align_and_show","name":"$t1"},{"line":343,"kind":13,"name":"$t2","containerName":"align_and_show"},{"name":"$fh","containerName":"align_and_show","kind":13,"line":343}],"line":313},{"name":"Bio","containerName":"Ext::Align::new_Sequence_from_strings","line":335,"kind":12},{"line":337,"kind":12,"containerName":"Ext::Align::new_Sequence_from_strings","name":"Bio"},{"containerName":"Ext::Align::Align_Sequences_ProteinSmithWaterman","name":"Bio","line":338,"kind":12},{"containerName":"Ext::Align::write_pretty_seq_align","name":"Bio","kind":12,"line":343},{"range":{"start":{"character":0,"line":358},"end":{"character":9999,"line":375}},"name":"matrix","line":358,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"matrix","line":359,"kind":13},{"containerName":"matrix","name":"$comp","kind":13,"line":359},{"definition":"my","name":"$temp","containerName":"matrix","localvar":"my","kind":13,"line":360},{"kind":13,"line":362,"name":"$comp","containerName":"matrix"},{"line":363,"kind":13,"containerName":"matrix","name":"$self"},{"containerName":"matrix","name":"throw","line":363,"kind":12},{"containerName":"matrix","name":"$temp","line":368,"kind":13},{"kind":13,"line":368,"name":"$comp","containerName":"matrix"},{"containerName":"matrix","name":"$temp","line":370,"kind":13},{"containerName":"matrix","name":"$temp","line":370,"kind":13},{"name":"$self","containerName":"matrix","line":371,"kind":13},{"line":371,"kind":12,"containerName":"matrix","name":"throw"},{"containerName":"matrix","name":"$self","line":374,"kind":13},{"name":"$temp","containerName":"matrix","kind":13,"line":374}],"kind":12,"detail":"($self,$comp)","signature":{"label":"matrix($self,$comp)","documentation":"1;\n## $Id: pSW.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n#\n# BioPerl module for Bio::Tools::pSW\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::pSW - pairwise Smith Waterman object\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::pSW;\n    use Bio::AlignIO;\n    my $factory = Bio::Tools::pSW->new( '-matrix' => 'blosum62.bla',\n\t\t\t\t       '-gap' => 12,\n\t\t\t\t       '-ext' => 2,\n\t\t\t\t       );\n\n    #use the factory to make some output\n\n    $factory->align_and_show($seq1,$seq2,STDOUT);\n\n    # make a Bio::SimpleAlign and do something with it\n\n    my $aln = $factory->pairwise_alignment($seq1,$seq2);\n    my $alnout = Bio::AlignIO->new(-format => 'msf',\n\t\t\t\t  -fh     => \\*STDOUT);\n\n    $alnout->write_aln($aln);\n\n=head1 INSTALLATION\n\nThis module is included with the central Bioperl distribution:\n\n   http://bio.perl.org/Core/Latest\n   ftp://bio.perl.org/pub/DIST\n\nFollow the installation instructions included in the INSTALL file.\n\n=head1 DESCRIPTION\n\npSW is an Alignment Factory for protein sequences. It builds pairwise\nalignments using the Smith-Waterman algorithm. The alignment algorithm is\nimplemented in C and added in using an XS extension. The XS extension basically\ncomes from the Wise2 package, but has been slimmed down to only be the\nalignment part of that (this is a good thing!). The XS extension comes\nfrom the bioperl-ext package which is distributed along with bioperl.\nI<Warning:> This package will not work if you have not compiled the\nbioperl-ext package.\n\nThe mixture of C and Perl is ideal for this sort of \nproblem. Here are some plus points for this strategy: \n\n=over 2\n\n* Speed and Memory \n\nThe algorithm is actually implemented in C, which means it is faster than\na pure perl implementation (I have never done one, so I have no idea\nhow faster) and will use considerably less memory, as it efficiently\nassigns memory for the calculation.\n\n* Algorithm efficiency\n\nThe algorithm was written using Dynamite, and so contains an automatic\nswitch to the linear space divide-and-conquer method. This means you\ncould effectively align very large sequences without killing your machine\n(it could take a while though!).\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists \n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/           \n\n=head1 AUTHOR\n\nEwan Birney, birney-at-sanger.ac.uk or birney-at-ebi.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with an underscore \"_\".\n\n\n# Let the code begin...\n\npackage Bio::Tools::pSW;\nuse strict;\nno strict ( 'refs');\n\nBEGIN {\n    eval {\n\trequire Bio::Ext::Align;\n    };\n    if ( $@ ) {\n\tdie(\"\\nThe C-compiled engine for Smith Waterman alignments (Bio::Ext::Align) has not been installed.\\n Please read the install the bioperl-ext package\\n\\n\");\n\texit(1);\n    }\n}\n\nuse Bio::SimpleAlign;\n\n\nuse base qw(Bio::Tools::AlignFactory);\n\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n\n  my($matrix,$gap,$ext) = $self->_rearrange([qw(MATRIX\n\t\t\t\t\t\tGAP\n\t\t\t\t\t\tEXT\n\t\t\t\t\t\t)],@args);\n  \n  #default values - we have to load matrix into memory, so \n  # we need to check it out now\n  if( ! defined $matrix || !($matrix =~ /\\w/) ) {\n      $matrix = 'blosum62.bla';\n  }\n\n  $self->matrix($matrix); # will throw exception if it can't load it\n  $self->gap(12) unless defined $gap;\n  $self->ext(2) unless defined $ext;\n\n  # I'm pretty sure I am not doing this right... ho hum...\n  # This was not roght ($gap and $ext could not be 0) It is fixed now /AE\n  if(  defined $gap ) {\n      if( $gap =~ /^\\d+$/ ) {\n\t  $self->gap($gap);\n      } else {\n\t  $self->throw(\"Gap penalty must be a number, not [$gap]\");\n      }\n  }\n  if( defined $ext ) {\n      if( $ext =~ /^\\d+$/ )  {\n\t  $self->ext($ext);\n      } else {\n\t  $self->throw(\"Extension penalty must be a number, not [$ext]\");\n      }\n  }\n \n  return $self; \n}\n\n\n=head2 pairwise_alignment\n\n Title   : pairwise_alignment\n Usage   : $aln = $factory->pairwise_alignment($seq1,$seq2)\n Function: Makes a SimpleAlign object from two sequences\n Returns : A SimpleAlign object\n Args    :\n\n\n\nsub pairwise_alignment{\n    my ($self,$seq1,$seq2) = @_;\n    my($t1,$t2,$aln,$out,@str1,@str2,@ostr1,@ostr2,$alc,$tstr,$tid,$start1,$end1,$start2,$end2,$alctemp);\n    \n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI') ||\n\t! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n\t$self->warn(\"Cannot call pairwise_alignment without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n\treturn;\n    }\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2 || \n\t$seq2->length() < 2 ) {\n\t$self->warn(\"cannot align sequences with length less than 2\");\n\treturn;\n    }\n    $self->set_memory_and_report();\n    # create engine objects \n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    $t1  = &Bio::Ext::Align::new_Sequence_from_strings($seq1->id(),\n\t\t\t\t\t\t       $seq1->seq());\n    $t2  = &Bio::Ext::Align::new_Sequence_from_strings($seq2->id(),\n\t\t\t\t\t\t       $seq2->seq());\n    $aln = &Bio::Ext::Align::Align_Sequences_ProteinSmithWaterman($t1,$t2,$self->{'matrix'},-$self->gap,-$self->ext);\n    if( ! defined $aln || $aln == 0 ) {\n\t$self->throw(\"Unable to build an alignment\");\n    }\n\n    # free sequence engine objects\n\n    $t1 = $t2 = 0;\n\n    # now we have to get into the AlnBlock structure and\n    # figure out what is aligned to what...\n\n    # we are going to need the sequences as arrays for convience\n\n    @str1 = split(//, $seq1->seq());\n    @str2 = split(//, $seq2->seq());\n\n    # get out start points\n\n    # The alignment is in alignment coordinates - ie the first\n    # residues starts at -1 and ends at 0. (weird I know).\n    # bio-coordinates are +2 from this...\n\n    $start1 = $aln->start()->alu(0)->start +2;\n    $start2 = $aln->start()->alu(1)->start +2;\n\n    # step along the linked list of alc units...\n\n    for($alc = $aln->start();$alc->at_end() != 1;$alc = $alc->next()) {\n\tif( $alc->alu(0)->text_label eq 'SEQUENCE' ) {\n\t    push(@ostr1,$str1[$alc->alu(0)->start+1]);\n\t} else {\n\t    # assumme it is in insert!\n\t    push(@ostr1,'-');\n\t}\n\n\tif( $alc->alu(1)->text_label eq 'SEQUENCE' ) {\n\t    push(@ostr2,$str2[$alc->alu(1)->start+1]);\n\t} else {\n\t    # assumme it is in insert!\n\t    push(@ostr2,'-');\n\t}\n\t$alctemp = $alc;\n    }\n\n    #\n    # get out end points\n    #\n\n    # end points = real residue end in 'C' coordinates = residue\n    # end in biocoordinates. Oh... the wonder of coordinate systems!\n\n    $end1 = $alctemp->alu(0)->end+1;\n    $end2 = $alctemp->alu(1)->end+1;\n\n    # get rid of the alnblock \n    $alc = 0;\n    $aln = 0;\n\n    # new SimpleAlignment\n    $out = Bio::SimpleAlign->new(); # new SimpleAlignment\n\n    $tstr = join('',@ostr1);\n    $tid = $seq1->id();\n    $out->add_seq(Bio::LocatableSeq->new( -seq=> $tstr,\n\t\t\t\t\t -start => $start1,\n\t\t\t\t\t -end   => $end1,\n\t\t\t\t\t -id=>$tid ));\n\n    $tstr = join('',@ostr2);\n    $tid = $seq2->id();\n    $out->add_seq(Bio::LocatableSeq->new( -seq=> $tstr,\n\t\t\t\t\t -start => $start2,\n\t\t\t\t\t -end => $end2,\n\t\t\t\t\t -id=> $tid ));\n\n    # give'm back the alignment\n\n    return $out;\n}\n\n=head2 align_and_show\n\n Title   : align_and_show\n Usage   : $factory->align_and_show($seq1,$seq2,STDOUT)\n\n\nsub align_and_show {\n    my($self,$seq1,$seq2,$fh) = @_;\n    my($t1,$t2,$aln,$id,$str);\n\nif( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI') ||\n\t! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n\t$self->warn(\"Cannot call align_and_show without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n\treturn;\n    }\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2 || \n\t$seq2->length() < 2 ) {\n\t$self->warn(\"cannot align sequences with length less than 2\");\n\treturn;\n    }\n    if( ! defined $fh ) { \n\t$fh = \\*STDOUT;\n    }\n    $self->set_memory_and_report();\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    $t1  = &Bio::Ext::Align::new_Sequence_from_strings($seq1->id(),$seq1->seq());\n\n    $t2  = &Bio::Ext::Align::new_Sequence_from_strings($seq2->id(),$seq2->seq());\n    $aln = &Bio::Ext::Align::Align_Sequences_ProteinSmithWaterman($t1,$t2,$self->{'matrix'},-$self->gap,-$self->ext);\n    if( ! defined $aln || $aln == 0 ) {\n\t$self->throw(\"Unable to build an alignment\");\n    }\n\n    &Bio::Ext::Align::write_pretty_seq_align($aln,$t1,$t2,12,50,$fh);\n\n}\n\n=head2 matrix\n\n Title     : matrix()\n Usage     : $factory->matrix('blosum62.bla');\n Function  : Reads in comparison matrix based on name\n           :\n Returns   : \n Argument  : comparison matrix","parameters":[{"label":"$self"},{"label":"$comp"}]},"containerName":"main::","definition":"sub"},{"containerName":"Ext::Align::CompMat::read_Blast_file_CompMat","name":"Bio","kind":12,"line":368},{"range":{"end":{"character":9999,"line":402},"start":{"character":0,"line":391}},"name":"gap","signature":{"label":"gap($self,$val)","documentation":"1;\n## $Id: pSW.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n#\n# BioPerl module for Bio::Tools::pSW\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::pSW - pairwise Smith Waterman object\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::pSW;\n    use Bio::AlignIO;\n    my $factory = Bio::Tools::pSW->new( '-matrix' => 'blosum62.bla',\n\t\t\t\t       '-gap' => 12,\n\t\t\t\t       '-ext' => 2,\n\t\t\t\t       );\n\n    #use the factory to make some output\n\n    $factory->align_and_show($seq1,$seq2,STDOUT);\n\n    # make a Bio::SimpleAlign and do something with it\n\n    my $aln = $factory->pairwise_alignment($seq1,$seq2);\n    my $alnout = Bio::AlignIO->new(-format => 'msf',\n\t\t\t\t  -fh     => \\*STDOUT);\n\n    $alnout->write_aln($aln);\n\n=head1 INSTALLATION\n\nThis module is included with the central Bioperl distribution:\n\n   http://bio.perl.org/Core/Latest\n   ftp://bio.perl.org/pub/DIST\n\nFollow the installation instructions included in the INSTALL file.\n\n=head1 DESCRIPTION\n\npSW is an Alignment Factory for protein sequences. It builds pairwise\nalignments using the Smith-Waterman algorithm. The alignment algorithm is\nimplemented in C and added in using an XS extension. The XS extension basically\ncomes from the Wise2 package, but has been slimmed down to only be the\nalignment part of that (this is a good thing!). The XS extension comes\nfrom the bioperl-ext package which is distributed along with bioperl.\nI<Warning:> This package will not work if you have not compiled the\nbioperl-ext package.\n\nThe mixture of C and Perl is ideal for this sort of \nproblem. Here are some plus points for this strategy: \n\n=over 2\n\n* Speed and Memory \n\nThe algorithm is actually implemented in C, which means it is faster than\na pure perl implementation (I have never done one, so I have no idea\nhow faster) and will use considerably less memory, as it efficiently\nassigns memory for the calculation.\n\n* Algorithm efficiency\n\nThe algorithm was written using Dynamite, and so contains an automatic\nswitch to the linear space divide-and-conquer method. This means you\ncould effectively align very large sequences without killing your machine\n(it could take a while though!).\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists \n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/           \n\n=head1 AUTHOR\n\nEwan Birney, birney-at-sanger.ac.uk or birney-at-ebi.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with an underscore \"_\".\n\n\n# Let the code begin...\n\npackage Bio::Tools::pSW;\nuse strict;\nno strict ( 'refs');\n\nBEGIN {\n    eval {\n\trequire Bio::Ext::Align;\n    };\n    if ( $@ ) {\n\tdie(\"\\nThe C-compiled engine for Smith Waterman alignments (Bio::Ext::Align) has not been installed.\\n Please read the install the bioperl-ext package\\n\\n\");\n\texit(1);\n    }\n}\n\nuse Bio::SimpleAlign;\n\n\nuse base qw(Bio::Tools::AlignFactory);\n\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n\n  my($matrix,$gap,$ext) = $self->_rearrange([qw(MATRIX\n\t\t\t\t\t\tGAP\n\t\t\t\t\t\tEXT\n\t\t\t\t\t\t)],@args);\n  \n  #default values - we have to load matrix into memory, so \n  # we need to check it out now\n  if( ! defined $matrix || !($matrix =~ /\\w/) ) {\n      $matrix = 'blosum62.bla';\n  }\n\n  $self->matrix($matrix); # will throw exception if it can't load it\n  $self->gap(12) unless defined $gap;\n  $self->ext(2) unless defined $ext;\n\n  # I'm pretty sure I am not doing this right... ho hum...\n  # This was not roght ($gap and $ext could not be 0) It is fixed now /AE\n  if(  defined $gap ) {\n      if( $gap =~ /^\\d+$/ ) {\n\t  $self->gap($gap);\n      } else {\n\t  $self->throw(\"Gap penalty must be a number, not [$gap]\");\n      }\n  }\n  if( defined $ext ) {\n      if( $ext =~ /^\\d+$/ )  {\n\t  $self->ext($ext);\n      } else {\n\t  $self->throw(\"Extension penalty must be a number, not [$ext]\");\n      }\n  }\n \n  return $self; \n}\n\n\n=head2 pairwise_alignment\n\n Title   : pairwise_alignment\n Usage   : $aln = $factory->pairwise_alignment($seq1,$seq2)\n Function: Makes a SimpleAlign object from two sequences\n Returns : A SimpleAlign object\n Args    :\n\n\n\nsub pairwise_alignment{\n    my ($self,$seq1,$seq2) = @_;\n    my($t1,$t2,$aln,$out,@str1,@str2,@ostr1,@ostr2,$alc,$tstr,$tid,$start1,$end1,$start2,$end2,$alctemp);\n    \n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI') ||\n\t! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n\t$self->warn(\"Cannot call pairwise_alignment without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n\treturn;\n    }\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2 || \n\t$seq2->length() < 2 ) {\n\t$self->warn(\"cannot align sequences with length less than 2\");\n\treturn;\n    }\n    $self->set_memory_and_report();\n    # create engine objects \n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    $t1  = &Bio::Ext::Align::new_Sequence_from_strings($seq1->id(),\n\t\t\t\t\t\t       $seq1->seq());\n    $t2  = &Bio::Ext::Align::new_Sequence_from_strings($seq2->id(),\n\t\t\t\t\t\t       $seq2->seq());\n    $aln = &Bio::Ext::Align::Align_Sequences_ProteinSmithWaterman($t1,$t2,$self->{'matrix'},-$self->gap,-$self->ext);\n    if( ! defined $aln || $aln == 0 ) {\n\t$self->throw(\"Unable to build an alignment\");\n    }\n\n    # free sequence engine objects\n\n    $t1 = $t2 = 0;\n\n    # now we have to get into the AlnBlock structure and\n    # figure out what is aligned to what...\n\n    # we are going to need the sequences as arrays for convience\n\n    @str1 = split(//, $seq1->seq());\n    @str2 = split(//, $seq2->seq());\n\n    # get out start points\n\n    # The alignment is in alignment coordinates - ie the first\n    # residues starts at -1 and ends at 0. (weird I know).\n    # bio-coordinates are +2 from this...\n\n    $start1 = $aln->start()->alu(0)->start +2;\n    $start2 = $aln->start()->alu(1)->start +2;\n\n    # step along the linked list of alc units...\n\n    for($alc = $aln->start();$alc->at_end() != 1;$alc = $alc->next()) {\n\tif( $alc->alu(0)->text_label eq 'SEQUENCE' ) {\n\t    push(@ostr1,$str1[$alc->alu(0)->start+1]);\n\t} else {\n\t    # assumme it is in insert!\n\t    push(@ostr1,'-');\n\t}\n\n\tif( $alc->alu(1)->text_label eq 'SEQUENCE' ) {\n\t    push(@ostr2,$str2[$alc->alu(1)->start+1]);\n\t} else {\n\t    # assumme it is in insert!\n\t    push(@ostr2,'-');\n\t}\n\t$alctemp = $alc;\n    }\n\n    #\n    # get out end points\n    #\n\n    # end points = real residue end in 'C' coordinates = residue\n    # end in biocoordinates. Oh... the wonder of coordinate systems!\n\n    $end1 = $alctemp->alu(0)->end+1;\n    $end2 = $alctemp->alu(1)->end+1;\n\n    # get rid of the alnblock \n    $alc = 0;\n    $aln = 0;\n\n    # new SimpleAlignment\n    $out = Bio::SimpleAlign->new(); # new SimpleAlignment\n\n    $tstr = join('',@ostr1);\n    $tid = $seq1->id();\n    $out->add_seq(Bio::LocatableSeq->new( -seq=> $tstr,\n\t\t\t\t\t -start => $start1,\n\t\t\t\t\t -end   => $end1,\n\t\t\t\t\t -id=>$tid ));\n\n    $tstr = join('',@ostr2);\n    $tid = $seq2->id();\n    $out->add_seq(Bio::LocatableSeq->new( -seq=> $tstr,\n\t\t\t\t\t -start => $start2,\n\t\t\t\t\t -end => $end2,\n\t\t\t\t\t -id=> $tid ));\n\n    # give'm back the alignment\n\n    return $out;\n}\n\n=head2 align_and_show\n\n Title   : align_and_show\n Usage   : $factory->align_and_show($seq1,$seq2,STDOUT)\n\n\nsub align_and_show {\n    my($self,$seq1,$seq2,$fh) = @_;\n    my($t1,$t2,$aln,$id,$str);\n\nif( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI') ||\n\t! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n\t$self->warn(\"Cannot call align_and_show without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n\treturn;\n    }\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2 || \n\t$seq2->length() < 2 ) {\n\t$self->warn(\"cannot align sequences with length less than 2\");\n\treturn;\n    }\n    if( ! defined $fh ) { \n\t$fh = \\*STDOUT;\n    }\n    $self->set_memory_and_report();\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    $t1  = &Bio::Ext::Align::new_Sequence_from_strings($seq1->id(),$seq1->seq());\n\n    $t2  = &Bio::Ext::Align::new_Sequence_from_strings($seq2->id(),$seq2->seq());\n    $aln = &Bio::Ext::Align::Align_Sequences_ProteinSmithWaterman($t1,$t2,$self->{'matrix'},-$self->gap,-$self->ext);\n    if( ! defined $aln || $aln == 0 ) {\n\t$self->throw(\"Unable to build an alignment\");\n    }\n\n    &Bio::Ext::Align::write_pretty_seq_align($aln,$t1,$t2,12,50,$fh);\n\n}\n\n=head2 matrix\n\n Title     : matrix()\n Usage     : $factory->matrix('blosum62.bla');\n Function  : Reads in comparison matrix based on name\n           :\n Returns   : \n Argument  : comparison matrix\n\n\nsub matrix {\n    my($self,$comp) = @_;\n    my $temp;\n\n    if( !defined $comp ) {\n\t$self->throw(\"You must have a comparison matrix to set!\");\n    }\n\n    # talking to the engine here...\n\n    $temp = &Bio::Ext::Align::CompMat::read_Blast_file_CompMat($comp);\n\n    if( !(defined $temp) || $temp == 0 ) {\n\t$self->throw(\"$comp cannot be read as a BLAST comparison matrix file\");\n    }\n\n    $self->{'matrix'} = $temp;\n}\n\n\n\n=head2 gap\n\n Title     : gap\n Usage     : $gap = $factory->gap() #get\n           : $factory->gap($value) #set\n Function  : the set get for the gap penalty\n Example   :\n Returns   : gap value \n Arguments : new value","parameters":[{"label":"$self"},{"label":"$val"}]},"detail":"($self,$val)","definition":"sub","containerName":"main::","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"gap","line":392,"kind":13},{"containerName":"gap","name":"$val","line":392,"kind":13},{"name":"$val","containerName":"gap","kind":13,"line":395},{"containerName":"gap","name":"$val","line":396,"kind":13},{"line":397,"kind":13,"name":"$self","containerName":"gap"},{"containerName":"gap","name":"throw","kind":12,"line":397},{"kind":13,"line":399,"name":"$self","containerName":"gap"},{"kind":13,"line":399,"name":"$val","containerName":"gap"},{"line":401,"kind":13,"name":"$self","containerName":"gap"}],"line":391,"kind":12},{"kind":12,"children":[{"definition":"my","name":"$self","containerName":"ext","localvar":"my","kind":13,"line":418},{"kind":13,"line":418,"name":"$val","containerName":"ext"},{"containerName":"ext","name":"$val","kind":13,"line":420},{"name":"$val","containerName":"ext","line":421,"kind":13},{"line":422,"kind":13,"name":"$self","containerName":"ext"},{"containerName":"ext","name":"throw","kind":12,"line":422},{"kind":13,"line":424,"name":"$self","containerName":"ext"},{"kind":13,"line":424,"containerName":"ext","name":"$val"},{"kind":13,"line":426,"name":"$self","containerName":"ext"}],"line":417,"definition":"sub","containerName":"main::","signature":{"label":"ext($self,$val)","documentation":"1;\n## $Id: pSW.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n#\n# BioPerl module for Bio::Tools::pSW\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::pSW - pairwise Smith Waterman object\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::pSW;\n    use Bio::AlignIO;\n    my $factory = Bio::Tools::pSW->new( '-matrix' => 'blosum62.bla',\n\t\t\t\t       '-gap' => 12,\n\t\t\t\t       '-ext' => 2,\n\t\t\t\t       );\n\n    #use the factory to make some output\n\n    $factory->align_and_show($seq1,$seq2,STDOUT);\n\n    # make a Bio::SimpleAlign and do something with it\n\n    my $aln = $factory->pairwise_alignment($seq1,$seq2);\n    my $alnout = Bio::AlignIO->new(-format => 'msf',\n\t\t\t\t  -fh     => \\*STDOUT);\n\n    $alnout->write_aln($aln);\n\n=head1 INSTALLATION\n\nThis module is included with the central Bioperl distribution:\n\n   http://bio.perl.org/Core/Latest\n   ftp://bio.perl.org/pub/DIST\n\nFollow the installation instructions included in the INSTALL file.\n\n=head1 DESCRIPTION\n\npSW is an Alignment Factory for protein sequences. It builds pairwise\nalignments using the Smith-Waterman algorithm. The alignment algorithm is\nimplemented in C and added in using an XS extension. The XS extension basically\ncomes from the Wise2 package, but has been slimmed down to only be the\nalignment part of that (this is a good thing!). The XS extension comes\nfrom the bioperl-ext package which is distributed along with bioperl.\nI<Warning:> This package will not work if you have not compiled the\nbioperl-ext package.\n\nThe mixture of C and Perl is ideal for this sort of \nproblem. Here are some plus points for this strategy: \n\n=over 2\n\n* Speed and Memory \n\nThe algorithm is actually implemented in C, which means it is faster than\na pure perl implementation (I have never done one, so I have no idea\nhow faster) and will use considerably less memory, as it efficiently\nassigns memory for the calculation.\n\n* Algorithm efficiency\n\nThe algorithm was written using Dynamite, and so contains an automatic\nswitch to the linear space divide-and-conquer method. This means you\ncould effectively align very large sequences without killing your machine\n(it could take a while though!).\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists \n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/           \n\n=head1 AUTHOR\n\nEwan Birney, birney-at-sanger.ac.uk or birney-at-ebi.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with an underscore \"_\".\n\n\n# Let the code begin...\n\npackage Bio::Tools::pSW;\nuse strict;\nno strict ( 'refs');\n\nBEGIN {\n    eval {\n\trequire Bio::Ext::Align;\n    };\n    if ( $@ ) {\n\tdie(\"\\nThe C-compiled engine for Smith Waterman alignments (Bio::Ext::Align) has not been installed.\\n Please read the install the bioperl-ext package\\n\\n\");\n\texit(1);\n    }\n}\n\nuse Bio::SimpleAlign;\n\n\nuse base qw(Bio::Tools::AlignFactory);\n\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n\n  my($matrix,$gap,$ext) = $self->_rearrange([qw(MATRIX\n\t\t\t\t\t\tGAP\n\t\t\t\t\t\tEXT\n\t\t\t\t\t\t)],@args);\n  \n  #default values - we have to load matrix into memory, so \n  # we need to check it out now\n  if( ! defined $matrix || !($matrix =~ /\\w/) ) {\n      $matrix = 'blosum62.bla';\n  }\n\n  $self->matrix($matrix); # will throw exception if it can't load it\n  $self->gap(12) unless defined $gap;\n  $self->ext(2) unless defined $ext;\n\n  # I'm pretty sure I am not doing this right... ho hum...\n  # This was not roght ($gap and $ext could not be 0) It is fixed now /AE\n  if(  defined $gap ) {\n      if( $gap =~ /^\\d+$/ ) {\n\t  $self->gap($gap);\n      } else {\n\t  $self->throw(\"Gap penalty must be a number, not [$gap]\");\n      }\n  }\n  if( defined $ext ) {\n      if( $ext =~ /^\\d+$/ )  {\n\t  $self->ext($ext);\n      } else {\n\t  $self->throw(\"Extension penalty must be a number, not [$ext]\");\n      }\n  }\n \n  return $self; \n}\n\n\n=head2 pairwise_alignment\n\n Title   : pairwise_alignment\n Usage   : $aln = $factory->pairwise_alignment($seq1,$seq2)\n Function: Makes a SimpleAlign object from two sequences\n Returns : A SimpleAlign object\n Args    :\n\n\n\nsub pairwise_alignment{\n    my ($self,$seq1,$seq2) = @_;\n    my($t1,$t2,$aln,$out,@str1,@str2,@ostr1,@ostr2,$alc,$tstr,$tid,$start1,$end1,$start2,$end2,$alctemp);\n    \n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI') ||\n\t! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n\t$self->warn(\"Cannot call pairwise_alignment without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n\treturn;\n    }\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2 || \n\t$seq2->length() < 2 ) {\n\t$self->warn(\"cannot align sequences with length less than 2\");\n\treturn;\n    }\n    $self->set_memory_and_report();\n    # create engine objects \n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    $t1  = &Bio::Ext::Align::new_Sequence_from_strings($seq1->id(),\n\t\t\t\t\t\t       $seq1->seq());\n    $t2  = &Bio::Ext::Align::new_Sequence_from_strings($seq2->id(),\n\t\t\t\t\t\t       $seq2->seq());\n    $aln = &Bio::Ext::Align::Align_Sequences_ProteinSmithWaterman($t1,$t2,$self->{'matrix'},-$self->gap,-$self->ext);\n    if( ! defined $aln || $aln == 0 ) {\n\t$self->throw(\"Unable to build an alignment\");\n    }\n\n    # free sequence engine objects\n\n    $t1 = $t2 = 0;\n\n    # now we have to get into the AlnBlock structure and\n    # figure out what is aligned to what...\n\n    # we are going to need the sequences as arrays for convience\n\n    @str1 = split(//, $seq1->seq());\n    @str2 = split(//, $seq2->seq());\n\n    # get out start points\n\n    # The alignment is in alignment coordinates - ie the first\n    # residues starts at -1 and ends at 0. (weird I know).\n    # bio-coordinates are +2 from this...\n\n    $start1 = $aln->start()->alu(0)->start +2;\n    $start2 = $aln->start()->alu(1)->start +2;\n\n    # step along the linked list of alc units...\n\n    for($alc = $aln->start();$alc->at_end() != 1;$alc = $alc->next()) {\n\tif( $alc->alu(0)->text_label eq 'SEQUENCE' ) {\n\t    push(@ostr1,$str1[$alc->alu(0)->start+1]);\n\t} else {\n\t    # assumme it is in insert!\n\t    push(@ostr1,'-');\n\t}\n\n\tif( $alc->alu(1)->text_label eq 'SEQUENCE' ) {\n\t    push(@ostr2,$str2[$alc->alu(1)->start+1]);\n\t} else {\n\t    # assumme it is in insert!\n\t    push(@ostr2,'-');\n\t}\n\t$alctemp = $alc;\n    }\n\n    #\n    # get out end points\n    #\n\n    # end points = real residue end in 'C' coordinates = residue\n    # end in biocoordinates. Oh... the wonder of coordinate systems!\n\n    $end1 = $alctemp->alu(0)->end+1;\n    $end2 = $alctemp->alu(1)->end+1;\n\n    # get rid of the alnblock \n    $alc = 0;\n    $aln = 0;\n\n    # new SimpleAlignment\n    $out = Bio::SimpleAlign->new(); # new SimpleAlignment\n\n    $tstr = join('',@ostr1);\n    $tid = $seq1->id();\n    $out->add_seq(Bio::LocatableSeq->new( -seq=> $tstr,\n\t\t\t\t\t -start => $start1,\n\t\t\t\t\t -end   => $end1,\n\t\t\t\t\t -id=>$tid ));\n\n    $tstr = join('',@ostr2);\n    $tid = $seq2->id();\n    $out->add_seq(Bio::LocatableSeq->new( -seq=> $tstr,\n\t\t\t\t\t -start => $start2,\n\t\t\t\t\t -end => $end2,\n\t\t\t\t\t -id=> $tid ));\n\n    # give'm back the alignment\n\n    return $out;\n}\n\n=head2 align_and_show\n\n Title   : align_and_show\n Usage   : $factory->align_and_show($seq1,$seq2,STDOUT)\n\n\nsub align_and_show {\n    my($self,$seq1,$seq2,$fh) = @_;\n    my($t1,$t2,$aln,$id,$str);\n\nif( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI') ||\n\t! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n\t$self->warn(\"Cannot call align_and_show without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n\treturn;\n    }\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2 || \n\t$seq2->length() < 2 ) {\n\t$self->warn(\"cannot align sequences with length less than 2\");\n\treturn;\n    }\n    if( ! defined $fh ) { \n\t$fh = \\*STDOUT;\n    }\n    $self->set_memory_and_report();\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    $t1  = &Bio::Ext::Align::new_Sequence_from_strings($seq1->id(),$seq1->seq());\n\n    $t2  = &Bio::Ext::Align::new_Sequence_from_strings($seq2->id(),$seq2->seq());\n    $aln = &Bio::Ext::Align::Align_Sequences_ProteinSmithWaterman($t1,$t2,$self->{'matrix'},-$self->gap,-$self->ext);\n    if( ! defined $aln || $aln == 0 ) {\n\t$self->throw(\"Unable to build an alignment\");\n    }\n\n    &Bio::Ext::Align::write_pretty_seq_align($aln,$t1,$t2,12,50,$fh);\n\n}\n\n=head2 matrix\n\n Title     : matrix()\n Usage     : $factory->matrix('blosum62.bla');\n Function  : Reads in comparison matrix based on name\n           :\n Returns   : \n Argument  : comparison matrix\n\n\nsub matrix {\n    my($self,$comp) = @_;\n    my $temp;\n\n    if( !defined $comp ) {\n\t$self->throw(\"You must have a comparison matrix to set!\");\n    }\n\n    # talking to the engine here...\n\n    $temp = &Bio::Ext::Align::CompMat::read_Blast_file_CompMat($comp);\n\n    if( !(defined $temp) || $temp == 0 ) {\n\t$self->throw(\"$comp cannot be read as a BLAST comparison matrix file\");\n    }\n\n    $self->{'matrix'} = $temp;\n}\n\n\n\n=head2 gap\n\n Title     : gap\n Usage     : $gap = $factory->gap() #get\n           : $factory->gap($value) #set\n Function  : the set get for the gap penalty\n Example   :\n Returns   : gap value \n Arguments : new value\n\n\nsub gap {\n    my ($self,$val) = @_;\n    \n\n    if( defined $val ) {\n\tif( $val < 0 ) {    # Fixed so that gap==0 is allowed /AE\n\t    $self->throw(\"Can't have a gap penalty less than 0\");\n\t}\n\t$self->{'gap'} = $val;\n    }\n    return $self->{'gap'};\n}\n\n\n=head2 ext\n\n Title     : ext\n Usage     : $ext = $factory->ext() #get\n           : $factory->ext($value) #set\n Function  : the set get for the ext penalty\n Example   :\n Returns   : ext value \n Arguments : new value","parameters":[{"label":"$self"},{"label":"$val"}]},"detail":"($self,$val)","name":"ext","range":{"end":{"character":9999,"line":427},"start":{"character":0,"line":417}}}]}