{"version":5,"vars":[{"containerName":"","name":"base","line":121,"kind":2},{"name":"_initialize_state","range":{"end":{"character":9999,"line":134},"start":{"line":123,"character":0}},"kind":12,"children":[{"containerName":"_initialize_state","name":"$self","definition":"my","localvar":"my","kind":13,"line":124},{"name":"@args","containerName":"_initialize_state","kind":13,"line":124},{"line":127,"kind":13,"localvar":"my","containerName":"_initialize_state","name":"$make","definition":"my"},{"line":127,"kind":13,"name":"$self","containerName":"_initialize_state"},{"kind":13,"line":127,"containerName":"_initialize_state","name":"@args"},{"containerName":"_initialize_state","name":"$self","line":133,"kind":13},{"kind":12,"line":133,"name":"analysis_method","containerName":"_initialize_state"}],"line":123,"definition":"sub","containerName":"main::","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"@args"}],"label":"_initialize_state($self,@args)"},"detail":"($self,@args)"},{"containerName":"_initialize_state","name":"SUPER","kind":12,"line":127},{"signature":{"documentation":"1;\n# $Id: Results.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Spidey::Results\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ryan Golhar <golharam@umdnj.edu>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Spidey::Results - Results of a Spidey run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Spidey::Results;\n\tmy $spidey = Bio::Tools::Spidey::Results->new(-file => 'result.spidey' );\n\n\t# or\n\n\tmy $spidey = Bio::Tools::Spidey::Results->new( -fh   => \\*INPUT );\n\n\t# get the exons before doing anything else\n\tmy $exonset = $spidey->next_exonset();\n\n\t# parse the results\n\tmy @exons = $exonset->sub_SeqFeature();\n\tprint \"Total no of Exons: \", scalar(@exons), \"\\n\";\n\n\tprint \"Genomic sequence length: \", $spidey->genomic_dna_length(), \"\\n\";\n\n\t# $exonset is-a Bio::SeqFeature::Generic with Bio::Tools::Spidey::Exons\n\t# as sub features\n\tprint \"Delimited on sequence \", $exonset->seq_id(), \" from \", \n\t\t$exonset->start(), \" to \", $exonset->end(), \"\\n\";\n\n\tforeach my $exon ( $exonset->sub_SeqFeature() ) {\n\t\t# $exon is-a Bio::SeqFeature::FeaturePair\n\t\tprint \"Exon from \", $exon->start, \" to \", $exon->end, \n\t\t\t\" on strand \", $exon->strand(), \"\\n\";\n\t\t# you can get out what it matched using the est_hit attribute\n\t\tmy $homol = $exon->est_hit();\n\t\tprint \"Matched to sequence \", $homol->seq_id, \n\t\t\t\" at \", $homol->start,\" to \", $homol->end, \"\\n\";\n\t}\n\n\t# essential if you gave a filename at initialization (otherwise \n  \t# the file stays open)\n\t$spidey->close();\n\n=head1 DESCRIPTION\n\nThe spidey module provides a parser and results object for spidey \noutput. The spidey results are specialised types of SeqFeatures, \nmeaning you can add them to AnnSeq objects fine, and manipulate them \nin the \"normal\" seqfeature manner.\n\nThe spidey Exon objects are Bio::SeqFeature::FeaturePair inherited \nobjects. The $esthit = $exon-E<gt>est_hit() is the alignment as a \nfeature on the matching object (normally, a cDNA), in which the \nstart/end points are where the hit lies.\n\nTo make this module work sensibly you need to run\n\n     spidey -i genomic.fasta -m cDNA.fasta\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ryan Golhar\n\nEmail golharam@umdnj.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Spidey::Results;\nuse strict;\n\nuse File::Basename;\nuse Bio::Root::Root;\nuse Bio::Tools::Spidey::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # call the inherited method first\n    my $make = $self->SUPER::_initialize_state(@args);\n\n#    my ($est_is_first) = $self->_rearrange([qw(ESTFIRST)], @args);\n\n#    delete($self->{'_est_is_first'});\n#    $self->{'_est_is_first'} = $est_is_first if(defined($est_is_first));\n    $self->analysis_method(\"Spidey\");\n}\n\n=head2 analysis_method\n\n Usage     : $spidey->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /Spidey/i.\n Returns   : String\n Argument  : n/a","parameters":[{"label":"$self"},{"label":"$method"}],"label":"analysis_method($self,$method)"},"detail":"($self,$method)","definition":"sub","containerName":"main::","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"analysis_method","line":149,"kind":13},{"kind":13,"line":149,"name":"$method","containerName":"analysis_method"},{"line":150,"kind":13,"containerName":"analysis_method","name":"$method"},{"line":150,"kind":13,"name":"$method","containerName":"analysis_method"},{"name":"$self","containerName":"analysis_method","kind":13,"line":151},{"line":151,"kind":12,"name":"throw","containerName":"analysis_method"},{"line":151,"kind":13,"name":"$self","containerName":"analysis_method"},{"line":153,"kind":13,"containerName":"analysis_method","name":"$self"},{"name":"$method","containerName":"analysis_method","line":153,"kind":13}],"line":147,"kind":12,"range":{"start":{"character":0,"line":147},"end":{"line":154,"character":9999}},"name":"analysis_method"},{"name":"SUPER","containerName":"analysis_method","kind":12,"line":153},{"range":{"end":{"character":9999,"line":325},"start":{"character":0,"line":174}},"name":"parse_next_alignment","signature":{"documentation":"1;\n# $Id: Results.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Spidey::Results\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ryan Golhar <golharam@umdnj.edu>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Spidey::Results - Results of a Spidey run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Spidey::Results;\n\tmy $spidey = Bio::Tools::Spidey::Results->new(-file => 'result.spidey' );\n\n\t# or\n\n\tmy $spidey = Bio::Tools::Spidey::Results->new( -fh   => \\*INPUT );\n\n\t# get the exons before doing anything else\n\tmy $exonset = $spidey->next_exonset();\n\n\t# parse the results\n\tmy @exons = $exonset->sub_SeqFeature();\n\tprint \"Total no of Exons: \", scalar(@exons), \"\\n\";\n\n\tprint \"Genomic sequence length: \", $spidey->genomic_dna_length(), \"\\n\";\n\n\t# $exonset is-a Bio::SeqFeature::Generic with Bio::Tools::Spidey::Exons\n\t# as sub features\n\tprint \"Delimited on sequence \", $exonset->seq_id(), \" from \", \n\t\t$exonset->start(), \" to \", $exonset->end(), \"\\n\";\n\n\tforeach my $exon ( $exonset->sub_SeqFeature() ) {\n\t\t# $exon is-a Bio::SeqFeature::FeaturePair\n\t\tprint \"Exon from \", $exon->start, \" to \", $exon->end, \n\t\t\t\" on strand \", $exon->strand(), \"\\n\";\n\t\t# you can get out what it matched using the est_hit attribute\n\t\tmy $homol = $exon->est_hit();\n\t\tprint \"Matched to sequence \", $homol->seq_id, \n\t\t\t\" at \", $homol->start,\" to \", $homol->end, \"\\n\";\n\t}\n\n\t# essential if you gave a filename at initialization (otherwise \n  \t# the file stays open)\n\t$spidey->close();\n\n=head1 DESCRIPTION\n\nThe spidey module provides a parser and results object for spidey \noutput. The spidey results are specialised types of SeqFeatures, \nmeaning you can add them to AnnSeq objects fine, and manipulate them \nin the \"normal\" seqfeature manner.\n\nThe spidey Exon objects are Bio::SeqFeature::FeaturePair inherited \nobjects. The $esthit = $exon-E<gt>est_hit() is the alignment as a \nfeature on the matching object (normally, a cDNA), in which the \nstart/end points are where the hit lies.\n\nTo make this module work sensibly you need to run\n\n     spidey -i genomic.fasta -m cDNA.fasta\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ryan Golhar\n\nEmail golharam@umdnj.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Spidey::Results;\nuse strict;\n\nuse File::Basename;\nuse Bio::Root::Root;\nuse Bio::Tools::Spidey::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # call the inherited method first\n    my $make = $self->SUPER::_initialize_state(@args);\n\n#    my ($est_is_first) = $self->_rearrange([qw(ESTFIRST)], @args);\n\n#    delete($self->{'_est_is_first'});\n#    $self->{'_est_is_first'} = $est_is_first if(defined($est_is_first));\n    $self->analysis_method(\"Spidey\");\n}\n\n=head2 analysis_method\n\n Usage     : $spidey->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /Spidey/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /Spidey/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 parse_next_alignment\n\n Title   : parse_next_alignment\n Usage   : @exons = $spidey_result->parse_next_alignment;\n           foreach $exon (@exons) {\n               # do something\n           }\n Function: Parses the next alignment of the Spidey result file and returns the\n           found exons as an array of Bio::Tools::Spidey::Exon objects. Call\n           this method repeatedly until an empty array is returned to get the\n           results for all alignments.\n Example :\n Returns : An array of Bio::Tools::Spidey::Exon objects\n Args    :","parameters":[{"label":"$self"}],"label":"parse_next_alignment($self)"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":175,"definition":"my","name":"$self","containerName":"parse_next_alignment","localvar":"my"},{"kind":13,"line":177,"definition":"my","name":"$started","containerName":"parse_next_alignment","localvar":"my"},{"name":"$version","containerName":"parse_next_alignment","line":177,"kind":13},{"line":177,"kind":13,"containerName":"parse_next_alignment","name":"$strand"},{"kind":13,"line":177,"containerName":"parse_next_alignment","name":"$exoncount"},{"localvar":"my","name":"%seq1props","definition":"my","containerName":"parse_next_alignment","line":178,"kind":13},{"name":"%seq2props","containerName":"parse_next_alignment","line":178,"kind":13},{"kind":13,"line":178,"name":"@exons","containerName":"parse_next_alignment"},{"line":182,"kind":13,"name":"$self","containerName":"parse_next_alignment"},{"kind":12,"line":182,"name":"_readline","containerName":"parse_next_alignment"},{"name":"$started","containerName":"parse_next_alignment","line":189,"kind":13},{"name":"$self","containerName":"parse_next_alignment","line":190,"kind":13},{"line":190,"kind":12,"name":"_pushback","containerName":"parse_next_alignment"},{"line":191,"kind":13,"containerName":"parse_next_alignment","name":"@exons"},{"line":193,"kind":13,"containerName":"parse_next_alignment","name":"$version"},{"kind":13,"line":194,"containerName":"parse_next_alignment","name":"$version"},{"name":"$self","containerName":"parse_next_alignment","kind":13,"line":195},{"line":195,"kind":12,"name":"throw","containerName":"parse_next_alignment"},{"line":197,"kind":13,"name":"$started","containerName":"parse_next_alignment"},{"name":"$seq1props","containerName":"parse_next_alignment","kind":13,"line":201},{"line":202,"kind":13,"containerName":"parse_next_alignment","name":"$seq1props"},{"name":"$self","containerName":"parse_next_alignment","line":203,"kind":13},{"name":"genomic_dna_length","containerName":"parse_next_alignment","kind":12,"line":203},{"containerName":"parse_next_alignment","name":"$seq1props","line":203,"kind":13},{"kind":13,"line":208,"containerName":"parse_next_alignment","name":"$seq2props"},{"line":209,"kind":13,"name":"$seq2props","containerName":"parse_next_alignment"},{"name":"$strand","containerName":"parse_next_alignment","line":213,"kind":13},{"kind":13,"line":215,"containerName":"parse_next_alignment","name":"$strand"},{"kind":13,"line":218,"name":"$exoncount","containerName":"parse_next_alignment"},{"name":"$genomic_start","definition":"my","containerName":"parse_next_alignment","localvar":"my","kind":13,"line":220},{"name":"$genomic_stop","containerName":"parse_next_alignment","kind":13,"line":220},{"containerName":"parse_next_alignment","name":"$cdna_start","kind":13,"line":220},{"kind":13,"line":220,"name":"$cdna_stop","containerName":"parse_next_alignment"},{"line":221,"kind":13,"containerName":"parse_next_alignment","name":"$id"},{"name":"$mismatches","containerName":"parse_next_alignment","kind":13,"line":221},{"line":221,"kind":13,"containerName":"parse_next_alignment","name":"$gaps"},{"line":221,"kind":13,"containerName":"parse_next_alignment","name":"$splice_donor"},{"name":"$splice_acceptor","containerName":"parse_next_alignment","line":222,"kind":13},{"containerName":"parse_next_alignment","name":"$uncertain","kind":13,"line":222},{"line":228,"kind":13,"localvar":"my","definition":"my","name":"$ec","containerName":"parse_next_alignment"},{"kind":13,"line":228,"name":"$ec","containerName":"parse_next_alignment"},{"line":228,"kind":13,"name":"$exoncount","containerName":"parse_next_alignment"},{"containerName":"parse_next_alignment","name":"$ec","kind":13,"line":228},{"containerName":"parse_next_alignment","name":"$self","line":229,"kind":13},{"kind":12,"line":229,"containerName":"parse_next_alignment","name":"_readline"},{"name":"$genomic_start","containerName":"parse_next_alignment","line":233,"kind":13},{"containerName":"parse_next_alignment","name":"$genomic_stop","kind":13,"line":234},{"kind":13,"line":235,"containerName":"parse_next_alignment","name":"$cdna_start"},{"name":"$cdna_stop","containerName":"parse_next_alignment","line":236,"kind":13},{"name":"$id","containerName":"parse_next_alignment","kind":13,"line":237},{"line":238,"kind":13,"name":"$mismatches","containerName":"parse_next_alignment"},{"name":"$gaps","containerName":"parse_next_alignment","line":239,"kind":13},{"line":240,"kind":13,"containerName":"parse_next_alignment","name":"$splice_donor"},{"line":241,"kind":13,"name":"$splice_acceptor","containerName":"parse_next_alignment"},{"name":"$uncertain","containerName":"parse_next_alignment","line":242,"kind":13},{"line":244,"kind":13,"name":"$self","containerName":"parse_next_alignment"},{"line":244,"kind":12,"containerName":"parse_next_alignment","name":"throw"},{"line":247,"kind":13,"localvar":"my","containerName":"parse_next_alignment","name":"$exon","definition":"my"},{"name":"new","containerName":"parse_next_alignment","kind":12,"line":248},{"name":"$genomic_start","containerName":"parse_next_alignment","line":248,"kind":13},{"line":249,"kind":13,"name":"$genomic_stop","containerName":"parse_next_alignment"},{"containerName":"parse_next_alignment","name":"$strand","line":250,"kind":13},{"name":"$exon","containerName":"parse_next_alignment","line":251,"kind":13},{"containerName":"parse_next_alignment","name":"seq_id","kind":12,"line":251},{"line":251,"kind":13,"name":"$seq1props","containerName":"parse_next_alignment"},{"kind":13,"line":254,"containerName":"parse_next_alignment","name":"$exon"},{"line":254,"kind":12,"containerName":"parse_next_alignment","name":"feature1"},{"name":"can","containerName":"parse_next_alignment","kind":12,"line":254},{"kind":13,"line":255,"name":"$exon","containerName":"parse_next_alignment"},{"name":"feature1","containerName":"parse_next_alignment","line":255,"kind":12},{"name":"seqlength","containerName":"parse_next_alignment","kind":12,"line":255},{"line":255,"kind":13,"name":"$seq1props","containerName":"parse_next_alignment"},{"line":257,"kind":13,"containerName":"parse_next_alignment","name":"$exon"},{"containerName":"parse_next_alignment","name":"feature1","line":257,"kind":12},{"kind":12,"line":257,"name":"add_tag_value","containerName":"parse_next_alignment"},{"name":"$seq1props","containerName":"parse_next_alignment","line":257,"kind":13},{"definition":"my","name":"$fea2","containerName":"parse_next_alignment","localvar":"my","kind":13,"line":261},{"containerName":"parse_next_alignment","name":"new","line":262,"kind":12},{"containerName":"parse_next_alignment","name":"$cdna_start","kind":13,"line":262},{"kind":13,"line":263,"containerName":"parse_next_alignment","name":"$cdna_stop"},{"line":264,"kind":13,"containerName":"parse_next_alignment","name":"$strand"},{"line":265,"kind":13,"name":"$seq2props","containerName":"parse_next_alignment"},{"containerName":"parse_next_alignment","name":"$fea2","kind":13,"line":267},{"containerName":"parse_next_alignment","name":"seqlength","line":267,"kind":12},{"line":267,"kind":13,"containerName":"parse_next_alignment","name":"$seq2props"},{"containerName":"parse_next_alignment","name":"$exon","line":269,"kind":13},{"line":269,"kind":12,"name":"est_hit","containerName":"parse_next_alignment"},{"line":269,"kind":13,"name":"$fea2","containerName":"parse_next_alignment"},{"name":"$exon","containerName":"parse_next_alignment","kind":13,"line":272},{"name":"source_tag","containerName":"parse_next_alignment","kind":12,"line":272},{"kind":13,"line":272,"containerName":"parse_next_alignment","name":"$self"},{"containerName":"parse_next_alignment","name":"analysis_method","kind":12,"line":272},{"line":273,"kind":13,"name":"$exon","containerName":"parse_next_alignment"},{"kind":12,"line":273,"name":"percentage_id","containerName":"parse_next_alignment"},{"line":274,"kind":13,"containerName":"parse_next_alignment","name":"$exon"},{"line":274,"kind":12,"containerName":"parse_next_alignment","name":"mismatches"},{"line":275,"kind":13,"name":"$exon","containerName":"parse_next_alignment"},{"name":"gaps","containerName":"parse_next_alignment","line":275,"kind":12},{"containerName":"parse_next_alignment","name":"$exon","line":276,"kind":13},{"line":276,"kind":12,"name":"donor","containerName":"parse_next_alignment"},{"containerName":"parse_next_alignment","name":"$exon","line":277,"kind":13},{"name":"acceptor","containerName":"parse_next_alignment","line":277,"kind":12},{"kind":13,"line":280,"name":"@exons","containerName":"parse_next_alignment"},{"name":"$exon","containerName":"parse_next_alignment","kind":13,"line":280},{"line":282,"kind":13,"containerName":"parse_next_alignment","name":"$self"},{"kind":12,"line":282,"name":"throw","containerName":"parse_next_alignment"},{"kind":13,"line":286,"name":"$self","containerName":"parse_next_alignment"},{"kind":12,"line":286,"name":"splicesites","containerName":"parse_next_alignment"},{"line":288,"kind":13,"containerName":"parse_next_alignment","name":"$self"},{"containerName":"parse_next_alignment","name":"est_coverage","kind":12,"line":288},{"containerName":"parse_next_alignment","name":"$self","line":290,"kind":13},{"line":290,"kind":12,"containerName":"parse_next_alignment","name":"overall_percentage_id"},{"name":"$self","containerName":"parse_next_alignment","line":292,"kind":13},{"kind":12,"line":292,"name":"missing_mrna_ends","containerName":"parse_next_alignment"},{"kind":13,"line":294,"name":"$exon_num","definition":"my","containerName":"parse_next_alignment","localvar":"my"},{"line":294,"kind":13,"containerName":"parse_next_alignment","name":"$gen_start"},{"line":294,"kind":13,"containerName":"parse_next_alignment","name":"$gen_stop"},{"name":"$cdna_start","containerName":"parse_next_alignment","line":294,"kind":13},{"kind":13,"line":294,"containerName":"parse_next_alignment","name":"$cdna_stop"},{"kind":13,"line":295,"containerName":"parse_next_alignment","name":"$exon_num"},{"name":"$gen_start","containerName":"parse_next_alignment","line":296,"kind":13},{"name":"$gen_stop","containerName":"parse_next_alignment","kind":13,"line":297},{"line":298,"kind":13,"containerName":"parse_next_alignment","name":"$cdna_start"},{"containerName":"parse_next_alignment","name":"$cdna_stop","line":299,"kind":13},{"kind":13,"line":324,"name":"@exons","containerName":"parse_next_alignment"},{"containerName":"parse_next_alignment","name":"@exons","kind":13,"line":324}],"line":174,"kind":12},{"line":247,"kind":12,"containerName":"Tools::Spidey::Exon","name":"Bio"},{"name":"Bio","containerName":"SeqFeature::Similarity","line":261,"kind":12},{"kind":12,"line":351,"children":[{"containerName":"next_exonset","name":"$self","definition":"my","localvar":"my","kind":13,"line":352},{"name":"$exonset","definition":"my","containerName":"next_exonset","localvar":"my","kind":13,"line":353},{"kind":13,"line":356,"name":"$exons","definition":"my","containerName":"next_exonset","localvar":"my"},{"containerName":"next_exonset","name":"$self","line":356,"kind":13},{"line":356,"kind":12,"containerName":"next_exonset","name":"parse_next_alignment"},{"line":357,"kind":13,"name":"$exons","containerName":"next_exonset"},{"containerName":"next_exonset","name":"$self","kind":13,"line":358},{"kind":12,"line":358,"name":"warn","containerName":"next_exonset"},{"name":"$exons","containerName":"next_exonset","line":361,"kind":13},{"line":362,"kind":12,"name":"new","containerName":"next_exonset"},{"kind":13,"line":366,"containerName":"next_exonset","name":"$exonset"},{"containerName":"next_exonset","name":"new","kind":12,"line":366},{"kind":13,"line":366,"containerName":"next_exonset","name":"$exons"},{"line":366,"kind":12,"name":"start","containerName":"next_exonset"},{"line":367,"kind":13,"containerName":"next_exonset","name":"$exons"},{"kind":12,"line":367,"name":"end","containerName":"next_exonset"},{"containerName":"next_exonset","name":"$exons","line":368,"kind":13},{"containerName":"next_exonset","name":"strand","line":368,"kind":12},{"line":370,"kind":13,"name":"$exonset","containerName":"next_exonset"},{"kind":12,"line":370,"containerName":"next_exonset","name":"source_tag"},{"name":"$exons","containerName":"next_exonset","kind":13,"line":370},{"name":"source_tag","containerName":"next_exonset","line":370,"kind":12},{"kind":13,"line":371,"containerName":"next_exonset","name":"$exonset"},{"containerName":"next_exonset","name":"seq_id","kind":12,"line":371},{"name":"$exons","containerName":"next_exonset","kind":13,"line":371},{"name":"seq_id","containerName":"next_exonset","line":371,"kind":12},{"kind":13,"line":374,"name":"$exon","definition":"my","containerName":"next_exonset","localvar":"my"},{"line":374,"kind":13,"name":"$exons","containerName":"next_exonset"},{"line":375,"kind":13,"containerName":"next_exonset","name":"$exonset"},{"kind":12,"line":375,"containerName":"next_exonset","name":"add_sub_SeqFeature"},{"line":375,"kind":13,"containerName":"next_exonset","name":"$exon"},{"containerName":"next_exonset","name":"$exonset","line":377,"kind":13}],"containerName":"main::","name":"next_exonset","definition":"sub","range":{"end":{"line":378,"character":9999},"start":{"line":351,"character":0}}},{"kind":12,"line":362,"containerName":"SeqFeature::Generic","name":"Bio"},{"name":"Bio","containerName":"SeqFeature::Generic","line":366,"kind":12},{"name":"next_feature","range":{"end":{"line":407,"character":9999},"start":{"character":0,"line":401}},"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Results.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Spidey::Results\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ryan Golhar <golharam@umdnj.edu>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Spidey::Results - Results of a Spidey run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Spidey::Results;\n\tmy $spidey = Bio::Tools::Spidey::Results->new(-file => 'result.spidey' );\n\n\t# or\n\n\tmy $spidey = Bio::Tools::Spidey::Results->new( -fh   => \\*INPUT );\n\n\t# get the exons before doing anything else\n\tmy $exonset = $spidey->next_exonset();\n\n\t# parse the results\n\tmy @exons = $exonset->sub_SeqFeature();\n\tprint \"Total no of Exons: \", scalar(@exons), \"\\n\";\n\n\tprint \"Genomic sequence length: \", $spidey->genomic_dna_length(), \"\\n\";\n\n\t# $exonset is-a Bio::SeqFeature::Generic with Bio::Tools::Spidey::Exons\n\t# as sub features\n\tprint \"Delimited on sequence \", $exonset->seq_id(), \" from \", \n\t\t$exonset->start(), \" to \", $exonset->end(), \"\\n\";\n\n\tforeach my $exon ( $exonset->sub_SeqFeature() ) {\n\t\t# $exon is-a Bio::SeqFeature::FeaturePair\n\t\tprint \"Exon from \", $exon->start, \" to \", $exon->end, \n\t\t\t\" on strand \", $exon->strand(), \"\\n\";\n\t\t# you can get out what it matched using the est_hit attribute\n\t\tmy $homol = $exon->est_hit();\n\t\tprint \"Matched to sequence \", $homol->seq_id, \n\t\t\t\" at \", $homol->start,\" to \", $homol->end, \"\\n\";\n\t}\n\n\t# essential if you gave a filename at initialization (otherwise \n  \t# the file stays open)\n\t$spidey->close();\n\n=head1 DESCRIPTION\n\nThe spidey module provides a parser and results object for spidey \noutput. The spidey results are specialised types of SeqFeatures, \nmeaning you can add them to AnnSeq objects fine, and manipulate them \nin the \"normal\" seqfeature manner.\n\nThe spidey Exon objects are Bio::SeqFeature::FeaturePair inherited \nobjects. The $esthit = $exon-E<gt>est_hit() is the alignment as a \nfeature on the matching object (normally, a cDNA), in which the \nstart/end points are where the hit lies.\n\nTo make this module work sensibly you need to run\n\n     spidey -i genomic.fasta -m cDNA.fasta\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ryan Golhar\n\nEmail golharam@umdnj.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Spidey::Results;\nuse strict;\n\nuse File::Basename;\nuse Bio::Root::Root;\nuse Bio::Tools::Spidey::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # call the inherited method first\n    my $make = $self->SUPER::_initialize_state(@args);\n\n#    my ($est_is_first) = $self->_rearrange([qw(ESTFIRST)], @args);\n\n#    delete($self->{'_est_is_first'});\n#    $self->{'_est_is_first'} = $est_is_first if(defined($est_is_first));\n    $self->analysis_method(\"Spidey\");\n}\n\n=head2 analysis_method\n\n Usage     : $spidey->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /Spidey/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /Spidey/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 parse_next_alignment\n\n Title   : parse_next_alignment\n Usage   : @exons = $spidey_result->parse_next_alignment;\n           foreach $exon (@exons) {\n               # do something\n           }\n Function: Parses the next alignment of the Spidey result file and returns the\n           found exons as an array of Bio::Tools::Spidey::Exon objects. Call\n           this method repeatedly until an empty array is returned to get the\n           results for all alignments.\n Example :\n Returns : An array of Bio::Tools::Spidey::Exon objects\n Args    :\n\n\n\nsub parse_next_alignment {\n    my ($self) = @_;\n    # for strand 1 = plus, -1 = minus\n    my ($started,$version,$strand, $exoncount) = (0,0,0,-1);\n    my (%seq1props,%seq2props,@exons);\n    \n    # we refer to the properties of each seq by reference\n\n    while(defined($_ = $self->_readline())) {\n\tchomp;\n\t#\n\t# bascially, parse a Spidey result...\n\t#\n\t# matches: --SPIDEY version 1.40--\n\tif( /^--SPIDEY\\s+version\\s+(\\d+\\.\\d+)--/) {\n\t    if($started) {\n\t\t$self->_pushback($_);\n\t\treturn \\@exons;\n\t    }\n\t    $version = $1;\n\t    if ($version != 1.40) {\n\t\t$self->throw(\"Spidey parser only designed to work with Spidey v1.40\\n\");\n\t    }\n\t    $started = 1;\n\t} elsif (/^Genomic:\\s+(\\S+)\\s.*,\\s+(\\d+)\\sbp$/ ) {\n\t    # matches: Genomic: lcl|some_name other information, 1234 bp\n\t    # $seq1props{'filename'} = $1;\n\t    $seq1props{'seqname'} = $1;\n\t    $seq1props{'length'} = $2;\t   \n\t    $self->genomic_dna_length($seq1props{'length'});\n\n\t} elsif( /^mRNA:\\s+(\\S+)\\s.*,(?:\\s+mRNA\\s+sequence,)?\\s(\\d+)\\sbp$/ ) {\n\t    # matches: mRNA:\n\t    # $seq2props{'filename'} = $1;\n\t    $seq2props{'seqname'} = $1;\n\t    $seq2props{'length'} = $2;\n\n\t} elsif( /^Strand:/ ) {\n\t    if (/plus/) {\n\t\t$strand = 1;\n\t    } else {\n\t\t$strand = -1;\n\t    }\n\t} elsif( /^Number of exons: (\\d+)/ ) {\n\t    $exoncount = $1;\n\n\t    my ($genomic_start, $genomic_stop, $cdna_start, $cdna_stop,\n\t\t$id, $mismatches, $gaps, $splice_donor, \n\t\t$splice_acceptor, $uncertain);\n\n\t    # the next $exoncount lines contains information\n\t    # about the matches of each exon.  we should parse\n\t    # this information here\n\n\t    for (my $ec = 1; $ec <= $exoncount; $ec++) {\n\t\tif (defined($_ = $self->_readline())) {\n\t\t    chomp;\n\n\t\t    if (/^Exon\\s$ec[\\(\\)-]*:\\s(\\d+)-(\\d+)\\s\\(gen\\)\\s+(\\d+)-(\\d+)\\s\\(mRNA\\)\\s+id\\s([\\d\\.inf-]+)%\\s+mismatches\\s(\\d+)\\s+gaps\\s(\\d+)\\s+splice\\ssite\\s\\(d\\s+a\\):\\s(\\d+)\\s+(\\d+)\\s*(\\w*)/) {\n\t\t\t$genomic_start = $1;\n\t\t\t$genomic_stop = $2;\n\t\t\t$cdna_start = $3;\n\t\t\t$cdna_stop = $4;\n\t\t\t$id = $5;\n\t\t\t$mismatches = $6;\n\t\t\t$gaps = $7;\n\t\t\t$splice_donor = $8;\n\t\t\t$splice_acceptor = $9;\n\t\t\t$uncertain = $10;\n\t\t    } else {\n\t\t\t$self->throw( \"Failed to match anything:\\n$_\\n\");\n\t\t    }\n\n\t\t    my $exon = Bio::Tools::Spidey::Exon->new\n\t\t\t(-start  => $genomic_start,\n\t\t\t -end    => $genomic_stop,\n\t\t\t -strand => $strand);\n\t\t    $exon->seq_id($seq1props{'seqname'});\n\n\t\t    # feature1 is supposed to be initialized to a Similarity object, but we provide a safety net\n\t\t    if ($exon->feature1->can('seqlength')) {\n\t\t\t$exon->feature1->seqlength($seq1props{'length'});\n\t\t    } else {\n\t\t\t$exon->feature1->add_tag_value('seqlength', $seq1props{'length'});\n\t\t    }\n\n\t\t    # create and initialize the feature wrapping the 'hit' (the cDNA)\n\t\t    my $fea2 = Bio::SeqFeature::Similarity->new\n\t\t\t(-start   => $cdna_start,\n\t\t\t -end     => $cdna_stop,\n\t\t\t -strand  => $strand,\n\t\t\t -seq_id  => $seq2props{'seqname'},\n\t\t\t -primary => \"aligning_cDNA\");\n\t\t    $fea2->seqlength($seq2props{'length'});\n\t\t    # store\n\t\t    $exon->est_hit($fea2);\t   \n\n\t\t    # general properties\n\t\t    $exon->source_tag($self->analysis_method());\n\t\t    $exon->percentage_id($5);\n\t\t    $exon->mismatches($6);\n\t\t    $exon->gaps($7);\n\t\t    $exon->donor($8);\n\t\t    $exon->acceptor($9);\n\n\t\t    # push onto array\n\t\t    push(@exons, $exon);\n\t\t} else {\n\t\t    $self->throw(\"Unexpected end of file reached\\n\");\n\t\t}\n\t    }\n\t} elsif( /^Number of splice sites:\\s+(\\d+)/ ) {\n\t    $self->splicesites($1);\t\n\t} elsif( /^mRNA coverage:\\s+(\\d+)%/ ) { \n\t    $self->est_coverage($1);\n\t} elsif(/^overall percent identity:\\s+([\\d\\.]+)%/ ) {\n\t    $self->overall_percentage_id($1);\n\t} elsif(/^Missing mRNA ends:\\s+(\\w+)/ ) {\n\t    $self->missing_mrna_ends($1);\n\t} elsif( /^Exon (\\d+): (\\d+)-(\\d+) \\(gen\\)\\s+(\\d+)-(\\d+) \\(mRNA\\)/ ) {\n\t    my ($exon_num, $gen_start, $gen_stop, $cdna_start, $cdna_stop);\t\t\t\t\t\t\n\t    $exon_num = $1;\n\t    $gen_start = $2;\n\t    $gen_stop = $3;\n\t    $cdna_start = $4;\n\t    $cdna_stop = $5;\t\t\t\n\t} elsif( /No alignment found/ ) {\n\t    return [];\n\t} else {\n\t    #$self->debug(\"unmatched $_\\n\");\n\t}\n    }\n    # Typical format:\n    # \tExon 1: 36375798-36375691 (gen)  1-108 (mRNA)\n    #\n    #\n    #\tCCTCTTTTTCTTTGCAGGGTATATACCCAGTTACTTAGACAAGGATGAGCTATGTGTAGT\n    #        \t   |  ||||||||||||||||||||||||||||||||||||||||||||||\n    #\t          ATGTCAGGGTATATACCCAGTTACTTAGACAAGGATGAGCTATGTGTAGT\n    #\t           M  S  G  Y  I  P  S  Y  L  D  K  D  E  L  C  V  V \n    #\n    #\n    #\tATGTGGGGACAAAGCCACCGGATATCATTATCGCTGCATCACTTGTGAAGGTTGCAAGGT\n    #\t||||||||||||||||||||||||||||||||||||||||||||||||||||||||||\n    #\tATGTGGGGACAAAGCCACCGGATATCATTATCGCTGCATCACTTGTGAAGGTTGCAAG\n    #\t  C  G  D  K  A  T  G  Y  H  Y  R  C  I  T  C  E  G  C  K \n    #\n    #\n    #\tAAATGGCA\n    #\n    @exons ? return \\@exons : return ;\n}\n\n=head2 next_exonset\n\n  Title   : next_exonset\n  Usage   : $exonset = $spidey_result->parse_next_exonset;\n         print \"Exons start at \", $exonset->start(), \n        \"and end at \", $exonset->end(), \"\\n\";\n         for $exon ($exonset->sub_SeqFeature()) {\n\t    # do something\n         }\n  Function: Parses the next alignment of the Spidey result file and returns the\n       set of exons as a container of features. The container is itself\n       a Bio::SeqFeature::Generic object, with the Bio::Tools::Spidey::Exon\n       objects as sub features. Start, end, and strand of the container\n       will represent the total region covered by the exons of this set.\n\n      See the documentation of parse_next_alignment() for further\n      reference about parsing and how the information is stored.\n Example : \n Returns : An Bio::SeqFeature::Generic object holding Bio::Tools::Spidey::Exon\n          objects as sub features.\n Args    :\n\n\nsub next_exonset {\n    my $self = shift;\n    my $exonset;\n\n    # get the next array of exons\n    my $exons = $self->parse_next_alignment();\n    if( ! defined $exons ) {\n        $self->warn(\"No exons returned\");\n        return;\n    } \n    if( @$exons == 0 ) {\n\treturn Bio::SeqFeature::Generic->new();\n    }\n    # create the container of exons as a feature object itself, with the\n    # data of the first exon for initialization\n    $exonset = Bio::SeqFeature::Generic->new('-start' => $exons->[0]->start(),\n\t\t\t\t\t     '-end' => $exons->[-1]->end(),\n\t\t\t\t\t     '-strand' => $exons->[0]->strand(),\n\t\t\t\t\t     '-primary' => \"ExonSet\");\n    $exonset->source_tag($exons->[0]->source_tag());\n    $exonset->seq_id($exons->[0]->seq_id());\n    # now add all exons as sub features, with enabling EXPANsion of the region\n    # covered in total\n    foreach my $exon (@$exons) {\n\t$exonset->add_sub_SeqFeature($exon, 'EXPAND');\n    }\n    return $exonset;\n}\n\n=head2 next_feature\n\n  Title   : next_feature\n  Usage   : while($exonset = $spidey->next_feature()) {\n\t    # do something\n\t   }\n  Function: Does the same as L<next_exonset()>. See there for documentation of\n      the functionality. Call this method repeatedly until FALSE is\n      returned.\n\n      The returned object is actually a SeqFeatureI implementing object.\n      This method is required for classes implementing the\n      SeqAnalysisParserI interface, and is merely an alias for \n      next_exonset() at present.\n\n  Example :\n  Returns : A Bio::SeqFeature::Generic object.\n  Args    :","label":"next_feature($self,@args)"},"kind":12,"line":401,"children":[{"containerName":"next_feature","name":"$self","definition":"my","localvar":"my","kind":13,"line":402},{"containerName":"next_feature","name":"@args","kind":13,"line":402},{"name":"$self","containerName":"next_feature","line":406,"kind":13},{"kind":12,"line":406,"containerName":"next_feature","name":"next_exonset"},{"kind":13,"line":406,"containerName":"next_feature","name":"@args"}]},{"range":{"start":{"line":420,"character":0},"end":{"character":9999,"line":431}},"name":"genomic_dna_length","signature":{"label":"genomic_dna_length($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Results.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Spidey::Results\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ryan Golhar <golharam@umdnj.edu>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Spidey::Results - Results of a Spidey run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Spidey::Results;\n\tmy $spidey = Bio::Tools::Spidey::Results->new(-file => 'result.spidey' );\n\n\t# or\n\n\tmy $spidey = Bio::Tools::Spidey::Results->new( -fh   => \\*INPUT );\n\n\t# get the exons before doing anything else\n\tmy $exonset = $spidey->next_exonset();\n\n\t# parse the results\n\tmy @exons = $exonset->sub_SeqFeature();\n\tprint \"Total no of Exons: \", scalar(@exons), \"\\n\";\n\n\tprint \"Genomic sequence length: \", $spidey->genomic_dna_length(), \"\\n\";\n\n\t# $exonset is-a Bio::SeqFeature::Generic with Bio::Tools::Spidey::Exons\n\t# as sub features\n\tprint \"Delimited on sequence \", $exonset->seq_id(), \" from \", \n\t\t$exonset->start(), \" to \", $exonset->end(), \"\\n\";\n\n\tforeach my $exon ( $exonset->sub_SeqFeature() ) {\n\t\t# $exon is-a Bio::SeqFeature::FeaturePair\n\t\tprint \"Exon from \", $exon->start, \" to \", $exon->end, \n\t\t\t\" on strand \", $exon->strand(), \"\\n\";\n\t\t# you can get out what it matched using the est_hit attribute\n\t\tmy $homol = $exon->est_hit();\n\t\tprint \"Matched to sequence \", $homol->seq_id, \n\t\t\t\" at \", $homol->start,\" to \", $homol->end, \"\\n\";\n\t}\n\n\t# essential if you gave a filename at initialization (otherwise \n  \t# the file stays open)\n\t$spidey->close();\n\n=head1 DESCRIPTION\n\nThe spidey module provides a parser and results object for spidey \noutput. The spidey results are specialised types of SeqFeatures, \nmeaning you can add them to AnnSeq objects fine, and manipulate them \nin the \"normal\" seqfeature manner.\n\nThe spidey Exon objects are Bio::SeqFeature::FeaturePair inherited \nobjects. The $esthit = $exon-E<gt>est_hit() is the alignment as a \nfeature on the matching object (normally, a cDNA), in which the \nstart/end points are where the hit lies.\n\nTo make this module work sensibly you need to run\n\n     spidey -i genomic.fasta -m cDNA.fasta\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ryan Golhar\n\nEmail golharam@umdnj.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Spidey::Results;\nuse strict;\n\nuse File::Basename;\nuse Bio::Root::Root;\nuse Bio::Tools::Spidey::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # call the inherited method first\n    my $make = $self->SUPER::_initialize_state(@args);\n\n#    my ($est_is_first) = $self->_rearrange([qw(ESTFIRST)], @args);\n\n#    delete($self->{'_est_is_first'});\n#    $self->{'_est_is_first'} = $est_is_first if(defined($est_is_first));\n    $self->analysis_method(\"Spidey\");\n}\n\n=head2 analysis_method\n\n Usage     : $spidey->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /Spidey/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /Spidey/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 parse_next_alignment\n\n Title   : parse_next_alignment\n Usage   : @exons = $spidey_result->parse_next_alignment;\n           foreach $exon (@exons) {\n               # do something\n           }\n Function: Parses the next alignment of the Spidey result file and returns the\n           found exons as an array of Bio::Tools::Spidey::Exon objects. Call\n           this method repeatedly until an empty array is returned to get the\n           results for all alignments.\n Example :\n Returns : An array of Bio::Tools::Spidey::Exon objects\n Args    :\n\n\n\nsub parse_next_alignment {\n    my ($self) = @_;\n    # for strand 1 = plus, -1 = minus\n    my ($started,$version,$strand, $exoncount) = (0,0,0,-1);\n    my (%seq1props,%seq2props,@exons);\n    \n    # we refer to the properties of each seq by reference\n\n    while(defined($_ = $self->_readline())) {\n\tchomp;\n\t#\n\t# bascially, parse a Spidey result...\n\t#\n\t# matches: --SPIDEY version 1.40--\n\tif( /^--SPIDEY\\s+version\\s+(\\d+\\.\\d+)--/) {\n\t    if($started) {\n\t\t$self->_pushback($_);\n\t\treturn \\@exons;\n\t    }\n\t    $version = $1;\n\t    if ($version != 1.40) {\n\t\t$self->throw(\"Spidey parser only designed to work with Spidey v1.40\\n\");\n\t    }\n\t    $started = 1;\n\t} elsif (/^Genomic:\\s+(\\S+)\\s.*,\\s+(\\d+)\\sbp$/ ) {\n\t    # matches: Genomic: lcl|some_name other information, 1234 bp\n\t    # $seq1props{'filename'} = $1;\n\t    $seq1props{'seqname'} = $1;\n\t    $seq1props{'length'} = $2;\t   \n\t    $self->genomic_dna_length($seq1props{'length'});\n\n\t} elsif( /^mRNA:\\s+(\\S+)\\s.*,(?:\\s+mRNA\\s+sequence,)?\\s(\\d+)\\sbp$/ ) {\n\t    # matches: mRNA:\n\t    # $seq2props{'filename'} = $1;\n\t    $seq2props{'seqname'} = $1;\n\t    $seq2props{'length'} = $2;\n\n\t} elsif( /^Strand:/ ) {\n\t    if (/plus/) {\n\t\t$strand = 1;\n\t    } else {\n\t\t$strand = -1;\n\t    }\n\t} elsif( /^Number of exons: (\\d+)/ ) {\n\t    $exoncount = $1;\n\n\t    my ($genomic_start, $genomic_stop, $cdna_start, $cdna_stop,\n\t\t$id, $mismatches, $gaps, $splice_donor, \n\t\t$splice_acceptor, $uncertain);\n\n\t    # the next $exoncount lines contains information\n\t    # about the matches of each exon.  we should parse\n\t    # this information here\n\n\t    for (my $ec = 1; $ec <= $exoncount; $ec++) {\n\t\tif (defined($_ = $self->_readline())) {\n\t\t    chomp;\n\n\t\t    if (/^Exon\\s$ec[\\(\\)-]*:\\s(\\d+)-(\\d+)\\s\\(gen\\)\\s+(\\d+)-(\\d+)\\s\\(mRNA\\)\\s+id\\s([\\d\\.inf-]+)%\\s+mismatches\\s(\\d+)\\s+gaps\\s(\\d+)\\s+splice\\ssite\\s\\(d\\s+a\\):\\s(\\d+)\\s+(\\d+)\\s*(\\w*)/) {\n\t\t\t$genomic_start = $1;\n\t\t\t$genomic_stop = $2;\n\t\t\t$cdna_start = $3;\n\t\t\t$cdna_stop = $4;\n\t\t\t$id = $5;\n\t\t\t$mismatches = $6;\n\t\t\t$gaps = $7;\n\t\t\t$splice_donor = $8;\n\t\t\t$splice_acceptor = $9;\n\t\t\t$uncertain = $10;\n\t\t    } else {\n\t\t\t$self->throw( \"Failed to match anything:\\n$_\\n\");\n\t\t    }\n\n\t\t    my $exon = Bio::Tools::Spidey::Exon->new\n\t\t\t(-start  => $genomic_start,\n\t\t\t -end    => $genomic_stop,\n\t\t\t -strand => $strand);\n\t\t    $exon->seq_id($seq1props{'seqname'});\n\n\t\t    # feature1 is supposed to be initialized to a Similarity object, but we provide a safety net\n\t\t    if ($exon->feature1->can('seqlength')) {\n\t\t\t$exon->feature1->seqlength($seq1props{'length'});\n\t\t    } else {\n\t\t\t$exon->feature1->add_tag_value('seqlength', $seq1props{'length'});\n\t\t    }\n\n\t\t    # create and initialize the feature wrapping the 'hit' (the cDNA)\n\t\t    my $fea2 = Bio::SeqFeature::Similarity->new\n\t\t\t(-start   => $cdna_start,\n\t\t\t -end     => $cdna_stop,\n\t\t\t -strand  => $strand,\n\t\t\t -seq_id  => $seq2props{'seqname'},\n\t\t\t -primary => \"aligning_cDNA\");\n\t\t    $fea2->seqlength($seq2props{'length'});\n\t\t    # store\n\t\t    $exon->est_hit($fea2);\t   \n\n\t\t    # general properties\n\t\t    $exon->source_tag($self->analysis_method());\n\t\t    $exon->percentage_id($5);\n\t\t    $exon->mismatches($6);\n\t\t    $exon->gaps($7);\n\t\t    $exon->donor($8);\n\t\t    $exon->acceptor($9);\n\n\t\t    # push onto array\n\t\t    push(@exons, $exon);\n\t\t} else {\n\t\t    $self->throw(\"Unexpected end of file reached\\n\");\n\t\t}\n\t    }\n\t} elsif( /^Number of splice sites:\\s+(\\d+)/ ) {\n\t    $self->splicesites($1);\t\n\t} elsif( /^mRNA coverage:\\s+(\\d+)%/ ) { \n\t    $self->est_coverage($1);\n\t} elsif(/^overall percent identity:\\s+([\\d\\.]+)%/ ) {\n\t    $self->overall_percentage_id($1);\n\t} elsif(/^Missing mRNA ends:\\s+(\\w+)/ ) {\n\t    $self->missing_mrna_ends($1);\n\t} elsif( /^Exon (\\d+): (\\d+)-(\\d+) \\(gen\\)\\s+(\\d+)-(\\d+) \\(mRNA\\)/ ) {\n\t    my ($exon_num, $gen_start, $gen_stop, $cdna_start, $cdna_stop);\t\t\t\t\t\t\n\t    $exon_num = $1;\n\t    $gen_start = $2;\n\t    $gen_stop = $3;\n\t    $cdna_start = $4;\n\t    $cdna_stop = $5;\t\t\t\n\t} elsif( /No alignment found/ ) {\n\t    return [];\n\t} else {\n\t    #$self->debug(\"unmatched $_\\n\");\n\t}\n    }\n    # Typical format:\n    # \tExon 1: 36375798-36375691 (gen)  1-108 (mRNA)\n    #\n    #\n    #\tCCTCTTTTTCTTTGCAGGGTATATACCCAGTTACTTAGACAAGGATGAGCTATGTGTAGT\n    #        \t   |  ||||||||||||||||||||||||||||||||||||||||||||||\n    #\t          ATGTCAGGGTATATACCCAGTTACTTAGACAAGGATGAGCTATGTGTAGT\n    #\t           M  S  G  Y  I  P  S  Y  L  D  K  D  E  L  C  V  V \n    #\n    #\n    #\tATGTGGGGACAAAGCCACCGGATATCATTATCGCTGCATCACTTGTGAAGGTTGCAAGGT\n    #\t||||||||||||||||||||||||||||||||||||||||||||||||||||||||||\n    #\tATGTGGGGACAAAGCCACCGGATATCATTATCGCTGCATCACTTGTGAAGGTTGCAAG\n    #\t  C  G  D  K  A  T  G  Y  H  Y  R  C  I  T  C  E  G  C  K \n    #\n    #\n    #\tAAATGGCA\n    #\n    @exons ? return \\@exons : return ;\n}\n\n=head2 next_exonset\n\n  Title   : next_exonset\n  Usage   : $exonset = $spidey_result->parse_next_exonset;\n         print \"Exons start at \", $exonset->start(), \n        \"and end at \", $exonset->end(), \"\\n\";\n         for $exon ($exonset->sub_SeqFeature()) {\n\t    # do something\n         }\n  Function: Parses the next alignment of the Spidey result file and returns the\n       set of exons as a container of features. The container is itself\n       a Bio::SeqFeature::Generic object, with the Bio::Tools::Spidey::Exon\n       objects as sub features. Start, end, and strand of the container\n       will represent the total region covered by the exons of this set.\n\n      See the documentation of parse_next_alignment() for further\n      reference about parsing and how the information is stored.\n Example : \n Returns : An Bio::SeqFeature::Generic object holding Bio::Tools::Spidey::Exon\n          objects as sub features.\n Args    :\n\n\nsub next_exonset {\n    my $self = shift;\n    my $exonset;\n\n    # get the next array of exons\n    my $exons = $self->parse_next_alignment();\n    if( ! defined $exons ) {\n        $self->warn(\"No exons returned\");\n        return;\n    } \n    if( @$exons == 0 ) {\n\treturn Bio::SeqFeature::Generic->new();\n    }\n    # create the container of exons as a feature object itself, with the\n    # data of the first exon for initialization\n    $exonset = Bio::SeqFeature::Generic->new('-start' => $exons->[0]->start(),\n\t\t\t\t\t     '-end' => $exons->[-1]->end(),\n\t\t\t\t\t     '-strand' => $exons->[0]->strand(),\n\t\t\t\t\t     '-primary' => \"ExonSet\");\n    $exonset->source_tag($exons->[0]->source_tag());\n    $exonset->seq_id($exons->[0]->seq_id());\n    # now add all exons as sub features, with enabling EXPANsion of the region\n    # covered in total\n    foreach my $exon (@$exons) {\n\t$exonset->add_sub_SeqFeature($exon, 'EXPAND');\n    }\n    return $exonset;\n}\n\n=head2 next_feature\n\n  Title   : next_feature\n  Usage   : while($exonset = $spidey->next_feature()) {\n\t    # do something\n\t   }\n  Function: Does the same as L<next_exonset()>. See there for documentation of\n      the functionality. Call this method repeatedly until FALSE is\n      returned.\n\n      The returned object is actually a SeqFeatureI implementing object.\n      This method is required for classes implementing the\n      SeqAnalysisParserI interface, and is merely an alias for \n      next_exonset() at present.\n\n  Example :\n  Returns : A Bio::SeqFeature::Generic object.\n  Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_exonset doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_exonset(@args);\n}\n\n=head2 genomic_dna_length\n\n    Title   : genomic_dna_length\n    Usage   : $spidey->genomic_dna_length();\n    Function: Returns the length of the genomic DNA used in this Spidey result\n    Example :\n    Returns : An integer value.\n    Args    :"},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"genomic_dna_length","line":421,"kind":13},{"line":421,"kind":13,"name":"@args","containerName":"genomic_dna_length"},{"containerName":"genomic_dna_length","definition":"my","name":"$val","localvar":"my","kind":13,"line":422},{"containerName":"genomic_dna_length","name":"@args","kind":13,"line":424},{"line":425,"kind":13,"name":"$val","containerName":"genomic_dna_length"},{"line":425,"kind":13,"name":"@args","containerName":"genomic_dna_length"},{"kind":13,"line":426,"name":"$self","containerName":"genomic_dna_length"},{"name":"$val","containerName":"genomic_dna_length","kind":13,"line":426},{"line":428,"kind":13,"name":"$val","containerName":"genomic_dna_length"},{"kind":13,"line":428,"name":"$self","containerName":"genomic_dna_length"},{"line":430,"kind":13,"name":"$val","containerName":"genomic_dna_length"}],"line":420,"kind":12},{"range":{"start":{"line":444,"character":0},"end":{"character":9999,"line":455}},"name":"splicesites","signature":{"documentation":"1;\n# $Id: Results.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Spidey::Results\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ryan Golhar <golharam@umdnj.edu>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Spidey::Results - Results of a Spidey run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Spidey::Results;\n\tmy $spidey = Bio::Tools::Spidey::Results->new(-file => 'result.spidey' );\n\n\t# or\n\n\tmy $spidey = Bio::Tools::Spidey::Results->new( -fh   => \\*INPUT );\n\n\t# get the exons before doing anything else\n\tmy $exonset = $spidey->next_exonset();\n\n\t# parse the results\n\tmy @exons = $exonset->sub_SeqFeature();\n\tprint \"Total no of Exons: \", scalar(@exons), \"\\n\";\n\n\tprint \"Genomic sequence length: \", $spidey->genomic_dna_length(), \"\\n\";\n\n\t# $exonset is-a Bio::SeqFeature::Generic with Bio::Tools::Spidey::Exons\n\t# as sub features\n\tprint \"Delimited on sequence \", $exonset->seq_id(), \" from \", \n\t\t$exonset->start(), \" to \", $exonset->end(), \"\\n\";\n\n\tforeach my $exon ( $exonset->sub_SeqFeature() ) {\n\t\t# $exon is-a Bio::SeqFeature::FeaturePair\n\t\tprint \"Exon from \", $exon->start, \" to \", $exon->end, \n\t\t\t\" on strand \", $exon->strand(), \"\\n\";\n\t\t# you can get out what it matched using the est_hit attribute\n\t\tmy $homol = $exon->est_hit();\n\t\tprint \"Matched to sequence \", $homol->seq_id, \n\t\t\t\" at \", $homol->start,\" to \", $homol->end, \"\\n\";\n\t}\n\n\t# essential if you gave a filename at initialization (otherwise \n  \t# the file stays open)\n\t$spidey->close();\n\n=head1 DESCRIPTION\n\nThe spidey module provides a parser and results object for spidey \noutput. The spidey results are specialised types of SeqFeatures, \nmeaning you can add them to AnnSeq objects fine, and manipulate them \nin the \"normal\" seqfeature manner.\n\nThe spidey Exon objects are Bio::SeqFeature::FeaturePair inherited \nobjects. The $esthit = $exon-E<gt>est_hit() is the alignment as a \nfeature on the matching object (normally, a cDNA), in which the \nstart/end points are where the hit lies.\n\nTo make this module work sensibly you need to run\n\n     spidey -i genomic.fasta -m cDNA.fasta\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ryan Golhar\n\nEmail golharam@umdnj.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Spidey::Results;\nuse strict;\n\nuse File::Basename;\nuse Bio::Root::Root;\nuse Bio::Tools::Spidey::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # call the inherited method first\n    my $make = $self->SUPER::_initialize_state(@args);\n\n#    my ($est_is_first) = $self->_rearrange([qw(ESTFIRST)], @args);\n\n#    delete($self->{'_est_is_first'});\n#    $self->{'_est_is_first'} = $est_is_first if(defined($est_is_first));\n    $self->analysis_method(\"Spidey\");\n}\n\n=head2 analysis_method\n\n Usage     : $spidey->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /Spidey/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /Spidey/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 parse_next_alignment\n\n Title   : parse_next_alignment\n Usage   : @exons = $spidey_result->parse_next_alignment;\n           foreach $exon (@exons) {\n               # do something\n           }\n Function: Parses the next alignment of the Spidey result file and returns the\n           found exons as an array of Bio::Tools::Spidey::Exon objects. Call\n           this method repeatedly until an empty array is returned to get the\n           results for all alignments.\n Example :\n Returns : An array of Bio::Tools::Spidey::Exon objects\n Args    :\n\n\n\nsub parse_next_alignment {\n    my ($self) = @_;\n    # for strand 1 = plus, -1 = minus\n    my ($started,$version,$strand, $exoncount) = (0,0,0,-1);\n    my (%seq1props,%seq2props,@exons);\n    \n    # we refer to the properties of each seq by reference\n\n    while(defined($_ = $self->_readline())) {\n\tchomp;\n\t#\n\t# bascially, parse a Spidey result...\n\t#\n\t# matches: --SPIDEY version 1.40--\n\tif( /^--SPIDEY\\s+version\\s+(\\d+\\.\\d+)--/) {\n\t    if($started) {\n\t\t$self->_pushback($_);\n\t\treturn \\@exons;\n\t    }\n\t    $version = $1;\n\t    if ($version != 1.40) {\n\t\t$self->throw(\"Spidey parser only designed to work with Spidey v1.40\\n\");\n\t    }\n\t    $started = 1;\n\t} elsif (/^Genomic:\\s+(\\S+)\\s.*,\\s+(\\d+)\\sbp$/ ) {\n\t    # matches: Genomic: lcl|some_name other information, 1234 bp\n\t    # $seq1props{'filename'} = $1;\n\t    $seq1props{'seqname'} = $1;\n\t    $seq1props{'length'} = $2;\t   \n\t    $self->genomic_dna_length($seq1props{'length'});\n\n\t} elsif( /^mRNA:\\s+(\\S+)\\s.*,(?:\\s+mRNA\\s+sequence,)?\\s(\\d+)\\sbp$/ ) {\n\t    # matches: mRNA:\n\t    # $seq2props{'filename'} = $1;\n\t    $seq2props{'seqname'} = $1;\n\t    $seq2props{'length'} = $2;\n\n\t} elsif( /^Strand:/ ) {\n\t    if (/plus/) {\n\t\t$strand = 1;\n\t    } else {\n\t\t$strand = -1;\n\t    }\n\t} elsif( /^Number of exons: (\\d+)/ ) {\n\t    $exoncount = $1;\n\n\t    my ($genomic_start, $genomic_stop, $cdna_start, $cdna_stop,\n\t\t$id, $mismatches, $gaps, $splice_donor, \n\t\t$splice_acceptor, $uncertain);\n\n\t    # the next $exoncount lines contains information\n\t    # about the matches of each exon.  we should parse\n\t    # this information here\n\n\t    for (my $ec = 1; $ec <= $exoncount; $ec++) {\n\t\tif (defined($_ = $self->_readline())) {\n\t\t    chomp;\n\n\t\t    if (/^Exon\\s$ec[\\(\\)-]*:\\s(\\d+)-(\\d+)\\s\\(gen\\)\\s+(\\d+)-(\\d+)\\s\\(mRNA\\)\\s+id\\s([\\d\\.inf-]+)%\\s+mismatches\\s(\\d+)\\s+gaps\\s(\\d+)\\s+splice\\ssite\\s\\(d\\s+a\\):\\s(\\d+)\\s+(\\d+)\\s*(\\w*)/) {\n\t\t\t$genomic_start = $1;\n\t\t\t$genomic_stop = $2;\n\t\t\t$cdna_start = $3;\n\t\t\t$cdna_stop = $4;\n\t\t\t$id = $5;\n\t\t\t$mismatches = $6;\n\t\t\t$gaps = $7;\n\t\t\t$splice_donor = $8;\n\t\t\t$splice_acceptor = $9;\n\t\t\t$uncertain = $10;\n\t\t    } else {\n\t\t\t$self->throw( \"Failed to match anything:\\n$_\\n\");\n\t\t    }\n\n\t\t    my $exon = Bio::Tools::Spidey::Exon->new\n\t\t\t(-start  => $genomic_start,\n\t\t\t -end    => $genomic_stop,\n\t\t\t -strand => $strand);\n\t\t    $exon->seq_id($seq1props{'seqname'});\n\n\t\t    # feature1 is supposed to be initialized to a Similarity object, but we provide a safety net\n\t\t    if ($exon->feature1->can('seqlength')) {\n\t\t\t$exon->feature1->seqlength($seq1props{'length'});\n\t\t    } else {\n\t\t\t$exon->feature1->add_tag_value('seqlength', $seq1props{'length'});\n\t\t    }\n\n\t\t    # create and initialize the feature wrapping the 'hit' (the cDNA)\n\t\t    my $fea2 = Bio::SeqFeature::Similarity->new\n\t\t\t(-start   => $cdna_start,\n\t\t\t -end     => $cdna_stop,\n\t\t\t -strand  => $strand,\n\t\t\t -seq_id  => $seq2props{'seqname'},\n\t\t\t -primary => \"aligning_cDNA\");\n\t\t    $fea2->seqlength($seq2props{'length'});\n\t\t    # store\n\t\t    $exon->est_hit($fea2);\t   \n\n\t\t    # general properties\n\t\t    $exon->source_tag($self->analysis_method());\n\t\t    $exon->percentage_id($5);\n\t\t    $exon->mismatches($6);\n\t\t    $exon->gaps($7);\n\t\t    $exon->donor($8);\n\t\t    $exon->acceptor($9);\n\n\t\t    # push onto array\n\t\t    push(@exons, $exon);\n\t\t} else {\n\t\t    $self->throw(\"Unexpected end of file reached\\n\");\n\t\t}\n\t    }\n\t} elsif( /^Number of splice sites:\\s+(\\d+)/ ) {\n\t    $self->splicesites($1);\t\n\t} elsif( /^mRNA coverage:\\s+(\\d+)%/ ) { \n\t    $self->est_coverage($1);\n\t} elsif(/^overall percent identity:\\s+([\\d\\.]+)%/ ) {\n\t    $self->overall_percentage_id($1);\n\t} elsif(/^Missing mRNA ends:\\s+(\\w+)/ ) {\n\t    $self->missing_mrna_ends($1);\n\t} elsif( /^Exon (\\d+): (\\d+)-(\\d+) \\(gen\\)\\s+(\\d+)-(\\d+) \\(mRNA\\)/ ) {\n\t    my ($exon_num, $gen_start, $gen_stop, $cdna_start, $cdna_stop);\t\t\t\t\t\t\n\t    $exon_num = $1;\n\t    $gen_start = $2;\n\t    $gen_stop = $3;\n\t    $cdna_start = $4;\n\t    $cdna_stop = $5;\t\t\t\n\t} elsif( /No alignment found/ ) {\n\t    return [];\n\t} else {\n\t    #$self->debug(\"unmatched $_\\n\");\n\t}\n    }\n    # Typical format:\n    # \tExon 1: 36375798-36375691 (gen)  1-108 (mRNA)\n    #\n    #\n    #\tCCTCTTTTTCTTTGCAGGGTATATACCCAGTTACTTAGACAAGGATGAGCTATGTGTAGT\n    #        \t   |  ||||||||||||||||||||||||||||||||||||||||||||||\n    #\t          ATGTCAGGGTATATACCCAGTTACTTAGACAAGGATGAGCTATGTGTAGT\n    #\t           M  S  G  Y  I  P  S  Y  L  D  K  D  E  L  C  V  V \n    #\n    #\n    #\tATGTGGGGACAAAGCCACCGGATATCATTATCGCTGCATCACTTGTGAAGGTTGCAAGGT\n    #\t||||||||||||||||||||||||||||||||||||||||||||||||||||||||||\n    #\tATGTGGGGACAAAGCCACCGGATATCATTATCGCTGCATCACTTGTGAAGGTTGCAAG\n    #\t  C  G  D  K  A  T  G  Y  H  Y  R  C  I  T  C  E  G  C  K \n    #\n    #\n    #\tAAATGGCA\n    #\n    @exons ? return \\@exons : return ;\n}\n\n=head2 next_exonset\n\n  Title   : next_exonset\n  Usage   : $exonset = $spidey_result->parse_next_exonset;\n         print \"Exons start at \", $exonset->start(), \n        \"and end at \", $exonset->end(), \"\\n\";\n         for $exon ($exonset->sub_SeqFeature()) {\n\t    # do something\n         }\n  Function: Parses the next alignment of the Spidey result file and returns the\n       set of exons as a container of features. The container is itself\n       a Bio::SeqFeature::Generic object, with the Bio::Tools::Spidey::Exon\n       objects as sub features. Start, end, and strand of the container\n       will represent the total region covered by the exons of this set.\n\n      See the documentation of parse_next_alignment() for further\n      reference about parsing and how the information is stored.\n Example : \n Returns : An Bio::SeqFeature::Generic object holding Bio::Tools::Spidey::Exon\n          objects as sub features.\n Args    :\n\n\nsub next_exonset {\n    my $self = shift;\n    my $exonset;\n\n    # get the next array of exons\n    my $exons = $self->parse_next_alignment();\n    if( ! defined $exons ) {\n        $self->warn(\"No exons returned\");\n        return;\n    } \n    if( @$exons == 0 ) {\n\treturn Bio::SeqFeature::Generic->new();\n    }\n    # create the container of exons as a feature object itself, with the\n    # data of the first exon for initialization\n    $exonset = Bio::SeqFeature::Generic->new('-start' => $exons->[0]->start(),\n\t\t\t\t\t     '-end' => $exons->[-1]->end(),\n\t\t\t\t\t     '-strand' => $exons->[0]->strand(),\n\t\t\t\t\t     '-primary' => \"ExonSet\");\n    $exonset->source_tag($exons->[0]->source_tag());\n    $exonset->seq_id($exons->[0]->seq_id());\n    # now add all exons as sub features, with enabling EXPANsion of the region\n    # covered in total\n    foreach my $exon (@$exons) {\n\t$exonset->add_sub_SeqFeature($exon, 'EXPAND');\n    }\n    return $exonset;\n}\n\n=head2 next_feature\n\n  Title   : next_feature\n  Usage   : while($exonset = $spidey->next_feature()) {\n\t    # do something\n\t   }\n  Function: Does the same as L<next_exonset()>. See there for documentation of\n      the functionality. Call this method repeatedly until FALSE is\n      returned.\n\n      The returned object is actually a SeqFeatureI implementing object.\n      This method is required for classes implementing the\n      SeqAnalysisParserI interface, and is merely an alias for \n      next_exonset() at present.\n\n  Example :\n  Returns : A Bio::SeqFeature::Generic object.\n  Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_exonset doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_exonset(@args);\n}\n\n=head2 genomic_dna_length\n\n    Title   : genomic_dna_length\n    Usage   : $spidey->genomic_dna_length();\n    Function: Returns the length of the genomic DNA used in this Spidey result\n    Example :\n    Returns : An integer value.\n    Args    :\n\n\nsub genomic_dna_length {\n    my ($self, @args) = @_;\n    my $val;\n\n    if(@args) {\n\t$val = shift(@args);\n\t$self->{'genomic_dna_length'} = $val;\n    } else {\n\t$val = $self->{'genomic_dna_length'};\n    }\n    return $val;\n}\n\n=head2 splicesites\n\n    Title   : splicesites\n    Usage   : $spidey->splicesites();\n    Function: Returns the number of splice sites found in this Spidey result\n    Example :\n    Returns : An integer value.\n    Args    :","parameters":[{"label":"$self"},{"label":"@args"}],"label":"splicesites($self,@args)"},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"splicesites","line":445,"kind":13},{"containerName":"splicesites","name":"@args","kind":13,"line":445},{"localvar":"my","name":"$val","definition":"my","containerName":"splicesites","line":446,"kind":13},{"name":"@args","containerName":"splicesites","line":448,"kind":13},{"containerName":"splicesites","name":"$val","line":449,"kind":13},{"line":449,"kind":13,"containerName":"splicesites","name":"@args"},{"name":"$self","containerName":"splicesites","kind":13,"line":450},{"name":"$val","containerName":"splicesites","line":450,"kind":13},{"kind":13,"line":452,"name":"$val","containerName":"splicesites"},{"containerName":"splicesites","name":"$self","line":452,"kind":13},{"line":454,"kind":13,"containerName":"splicesites","name":"$val"}],"line":444,"kind":12},{"name":"est_coverage","range":{"end":{"line":479,"character":9999},"start":{"character":0,"line":468}},"definition":"sub","containerName":"main::","signature":{"label":"est_coverage($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Results.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Spidey::Results\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ryan Golhar <golharam@umdnj.edu>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Spidey::Results - Results of a Spidey run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Spidey::Results;\n\tmy $spidey = Bio::Tools::Spidey::Results->new(-file => 'result.spidey' );\n\n\t# or\n\n\tmy $spidey = Bio::Tools::Spidey::Results->new( -fh   => \\*INPUT );\n\n\t# get the exons before doing anything else\n\tmy $exonset = $spidey->next_exonset();\n\n\t# parse the results\n\tmy @exons = $exonset->sub_SeqFeature();\n\tprint \"Total no of Exons: \", scalar(@exons), \"\\n\";\n\n\tprint \"Genomic sequence length: \", $spidey->genomic_dna_length(), \"\\n\";\n\n\t# $exonset is-a Bio::SeqFeature::Generic with Bio::Tools::Spidey::Exons\n\t# as sub features\n\tprint \"Delimited on sequence \", $exonset->seq_id(), \" from \", \n\t\t$exonset->start(), \" to \", $exonset->end(), \"\\n\";\n\n\tforeach my $exon ( $exonset->sub_SeqFeature() ) {\n\t\t# $exon is-a Bio::SeqFeature::FeaturePair\n\t\tprint \"Exon from \", $exon->start, \" to \", $exon->end, \n\t\t\t\" on strand \", $exon->strand(), \"\\n\";\n\t\t# you can get out what it matched using the est_hit attribute\n\t\tmy $homol = $exon->est_hit();\n\t\tprint \"Matched to sequence \", $homol->seq_id, \n\t\t\t\" at \", $homol->start,\" to \", $homol->end, \"\\n\";\n\t}\n\n\t# essential if you gave a filename at initialization (otherwise \n  \t# the file stays open)\n\t$spidey->close();\n\n=head1 DESCRIPTION\n\nThe spidey module provides a parser and results object for spidey \noutput. The spidey results are specialised types of SeqFeatures, \nmeaning you can add them to AnnSeq objects fine, and manipulate them \nin the \"normal\" seqfeature manner.\n\nThe spidey Exon objects are Bio::SeqFeature::FeaturePair inherited \nobjects. The $esthit = $exon-E<gt>est_hit() is the alignment as a \nfeature on the matching object (normally, a cDNA), in which the \nstart/end points are where the hit lies.\n\nTo make this module work sensibly you need to run\n\n     spidey -i genomic.fasta -m cDNA.fasta\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ryan Golhar\n\nEmail golharam@umdnj.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Spidey::Results;\nuse strict;\n\nuse File::Basename;\nuse Bio::Root::Root;\nuse Bio::Tools::Spidey::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # call the inherited method first\n    my $make = $self->SUPER::_initialize_state(@args);\n\n#    my ($est_is_first) = $self->_rearrange([qw(ESTFIRST)], @args);\n\n#    delete($self->{'_est_is_first'});\n#    $self->{'_est_is_first'} = $est_is_first if(defined($est_is_first));\n    $self->analysis_method(\"Spidey\");\n}\n\n=head2 analysis_method\n\n Usage     : $spidey->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /Spidey/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /Spidey/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 parse_next_alignment\n\n Title   : parse_next_alignment\n Usage   : @exons = $spidey_result->parse_next_alignment;\n           foreach $exon (@exons) {\n               # do something\n           }\n Function: Parses the next alignment of the Spidey result file and returns the\n           found exons as an array of Bio::Tools::Spidey::Exon objects. Call\n           this method repeatedly until an empty array is returned to get the\n           results for all alignments.\n Example :\n Returns : An array of Bio::Tools::Spidey::Exon objects\n Args    :\n\n\n\nsub parse_next_alignment {\n    my ($self) = @_;\n    # for strand 1 = plus, -1 = minus\n    my ($started,$version,$strand, $exoncount) = (0,0,0,-1);\n    my (%seq1props,%seq2props,@exons);\n    \n    # we refer to the properties of each seq by reference\n\n    while(defined($_ = $self->_readline())) {\n\tchomp;\n\t#\n\t# bascially, parse a Spidey result...\n\t#\n\t# matches: --SPIDEY version 1.40--\n\tif( /^--SPIDEY\\s+version\\s+(\\d+\\.\\d+)--/) {\n\t    if($started) {\n\t\t$self->_pushback($_);\n\t\treturn \\@exons;\n\t    }\n\t    $version = $1;\n\t    if ($version != 1.40) {\n\t\t$self->throw(\"Spidey parser only designed to work with Spidey v1.40\\n\");\n\t    }\n\t    $started = 1;\n\t} elsif (/^Genomic:\\s+(\\S+)\\s.*,\\s+(\\d+)\\sbp$/ ) {\n\t    # matches: Genomic: lcl|some_name other information, 1234 bp\n\t    # $seq1props{'filename'} = $1;\n\t    $seq1props{'seqname'} = $1;\n\t    $seq1props{'length'} = $2;\t   \n\t    $self->genomic_dna_length($seq1props{'length'});\n\n\t} elsif( /^mRNA:\\s+(\\S+)\\s.*,(?:\\s+mRNA\\s+sequence,)?\\s(\\d+)\\sbp$/ ) {\n\t    # matches: mRNA:\n\t    # $seq2props{'filename'} = $1;\n\t    $seq2props{'seqname'} = $1;\n\t    $seq2props{'length'} = $2;\n\n\t} elsif( /^Strand:/ ) {\n\t    if (/plus/) {\n\t\t$strand = 1;\n\t    } else {\n\t\t$strand = -1;\n\t    }\n\t} elsif( /^Number of exons: (\\d+)/ ) {\n\t    $exoncount = $1;\n\n\t    my ($genomic_start, $genomic_stop, $cdna_start, $cdna_stop,\n\t\t$id, $mismatches, $gaps, $splice_donor, \n\t\t$splice_acceptor, $uncertain);\n\n\t    # the next $exoncount lines contains information\n\t    # about the matches of each exon.  we should parse\n\t    # this information here\n\n\t    for (my $ec = 1; $ec <= $exoncount; $ec++) {\n\t\tif (defined($_ = $self->_readline())) {\n\t\t    chomp;\n\n\t\t    if (/^Exon\\s$ec[\\(\\)-]*:\\s(\\d+)-(\\d+)\\s\\(gen\\)\\s+(\\d+)-(\\d+)\\s\\(mRNA\\)\\s+id\\s([\\d\\.inf-]+)%\\s+mismatches\\s(\\d+)\\s+gaps\\s(\\d+)\\s+splice\\ssite\\s\\(d\\s+a\\):\\s(\\d+)\\s+(\\d+)\\s*(\\w*)/) {\n\t\t\t$genomic_start = $1;\n\t\t\t$genomic_stop = $2;\n\t\t\t$cdna_start = $3;\n\t\t\t$cdna_stop = $4;\n\t\t\t$id = $5;\n\t\t\t$mismatches = $6;\n\t\t\t$gaps = $7;\n\t\t\t$splice_donor = $8;\n\t\t\t$splice_acceptor = $9;\n\t\t\t$uncertain = $10;\n\t\t    } else {\n\t\t\t$self->throw( \"Failed to match anything:\\n$_\\n\");\n\t\t    }\n\n\t\t    my $exon = Bio::Tools::Spidey::Exon->new\n\t\t\t(-start  => $genomic_start,\n\t\t\t -end    => $genomic_stop,\n\t\t\t -strand => $strand);\n\t\t    $exon->seq_id($seq1props{'seqname'});\n\n\t\t    # feature1 is supposed to be initialized to a Similarity object, but we provide a safety net\n\t\t    if ($exon->feature1->can('seqlength')) {\n\t\t\t$exon->feature1->seqlength($seq1props{'length'});\n\t\t    } else {\n\t\t\t$exon->feature1->add_tag_value('seqlength', $seq1props{'length'});\n\t\t    }\n\n\t\t    # create and initialize the feature wrapping the 'hit' (the cDNA)\n\t\t    my $fea2 = Bio::SeqFeature::Similarity->new\n\t\t\t(-start   => $cdna_start,\n\t\t\t -end     => $cdna_stop,\n\t\t\t -strand  => $strand,\n\t\t\t -seq_id  => $seq2props{'seqname'},\n\t\t\t -primary => \"aligning_cDNA\");\n\t\t    $fea2->seqlength($seq2props{'length'});\n\t\t    # store\n\t\t    $exon->est_hit($fea2);\t   \n\n\t\t    # general properties\n\t\t    $exon->source_tag($self->analysis_method());\n\t\t    $exon->percentage_id($5);\n\t\t    $exon->mismatches($6);\n\t\t    $exon->gaps($7);\n\t\t    $exon->donor($8);\n\t\t    $exon->acceptor($9);\n\n\t\t    # push onto array\n\t\t    push(@exons, $exon);\n\t\t} else {\n\t\t    $self->throw(\"Unexpected end of file reached\\n\");\n\t\t}\n\t    }\n\t} elsif( /^Number of splice sites:\\s+(\\d+)/ ) {\n\t    $self->splicesites($1);\t\n\t} elsif( /^mRNA coverage:\\s+(\\d+)%/ ) { \n\t    $self->est_coverage($1);\n\t} elsif(/^overall percent identity:\\s+([\\d\\.]+)%/ ) {\n\t    $self->overall_percentage_id($1);\n\t} elsif(/^Missing mRNA ends:\\s+(\\w+)/ ) {\n\t    $self->missing_mrna_ends($1);\n\t} elsif( /^Exon (\\d+): (\\d+)-(\\d+) \\(gen\\)\\s+(\\d+)-(\\d+) \\(mRNA\\)/ ) {\n\t    my ($exon_num, $gen_start, $gen_stop, $cdna_start, $cdna_stop);\t\t\t\t\t\t\n\t    $exon_num = $1;\n\t    $gen_start = $2;\n\t    $gen_stop = $3;\n\t    $cdna_start = $4;\n\t    $cdna_stop = $5;\t\t\t\n\t} elsif( /No alignment found/ ) {\n\t    return [];\n\t} else {\n\t    #$self->debug(\"unmatched $_\\n\");\n\t}\n    }\n    # Typical format:\n    # \tExon 1: 36375798-36375691 (gen)  1-108 (mRNA)\n    #\n    #\n    #\tCCTCTTTTTCTTTGCAGGGTATATACCCAGTTACTTAGACAAGGATGAGCTATGTGTAGT\n    #        \t   |  ||||||||||||||||||||||||||||||||||||||||||||||\n    #\t          ATGTCAGGGTATATACCCAGTTACTTAGACAAGGATGAGCTATGTGTAGT\n    #\t           M  S  G  Y  I  P  S  Y  L  D  K  D  E  L  C  V  V \n    #\n    #\n    #\tATGTGGGGACAAAGCCACCGGATATCATTATCGCTGCATCACTTGTGAAGGTTGCAAGGT\n    #\t||||||||||||||||||||||||||||||||||||||||||||||||||||||||||\n    #\tATGTGGGGACAAAGCCACCGGATATCATTATCGCTGCATCACTTGTGAAGGTTGCAAG\n    #\t  C  G  D  K  A  T  G  Y  H  Y  R  C  I  T  C  E  G  C  K \n    #\n    #\n    #\tAAATGGCA\n    #\n    @exons ? return \\@exons : return ;\n}\n\n=head2 next_exonset\n\n  Title   : next_exonset\n  Usage   : $exonset = $spidey_result->parse_next_exonset;\n         print \"Exons start at \", $exonset->start(), \n        \"and end at \", $exonset->end(), \"\\n\";\n         for $exon ($exonset->sub_SeqFeature()) {\n\t    # do something\n         }\n  Function: Parses the next alignment of the Spidey result file and returns the\n       set of exons as a container of features. The container is itself\n       a Bio::SeqFeature::Generic object, with the Bio::Tools::Spidey::Exon\n       objects as sub features. Start, end, and strand of the container\n       will represent the total region covered by the exons of this set.\n\n      See the documentation of parse_next_alignment() for further\n      reference about parsing and how the information is stored.\n Example : \n Returns : An Bio::SeqFeature::Generic object holding Bio::Tools::Spidey::Exon\n          objects as sub features.\n Args    :\n\n\nsub next_exonset {\n    my $self = shift;\n    my $exonset;\n\n    # get the next array of exons\n    my $exons = $self->parse_next_alignment();\n    if( ! defined $exons ) {\n        $self->warn(\"No exons returned\");\n        return;\n    } \n    if( @$exons == 0 ) {\n\treturn Bio::SeqFeature::Generic->new();\n    }\n    # create the container of exons as a feature object itself, with the\n    # data of the first exon for initialization\n    $exonset = Bio::SeqFeature::Generic->new('-start' => $exons->[0]->start(),\n\t\t\t\t\t     '-end' => $exons->[-1]->end(),\n\t\t\t\t\t     '-strand' => $exons->[0]->strand(),\n\t\t\t\t\t     '-primary' => \"ExonSet\");\n    $exonset->source_tag($exons->[0]->source_tag());\n    $exonset->seq_id($exons->[0]->seq_id());\n    # now add all exons as sub features, with enabling EXPANsion of the region\n    # covered in total\n    foreach my $exon (@$exons) {\n\t$exonset->add_sub_SeqFeature($exon, 'EXPAND');\n    }\n    return $exonset;\n}\n\n=head2 next_feature\n\n  Title   : next_feature\n  Usage   : while($exonset = $spidey->next_feature()) {\n\t    # do something\n\t   }\n  Function: Does the same as L<next_exonset()>. See there for documentation of\n      the functionality. Call this method repeatedly until FALSE is\n      returned.\n\n      The returned object is actually a SeqFeatureI implementing object.\n      This method is required for classes implementing the\n      SeqAnalysisParserI interface, and is merely an alias for \n      next_exonset() at present.\n\n  Example :\n  Returns : A Bio::SeqFeature::Generic object.\n  Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_exonset doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_exonset(@args);\n}\n\n=head2 genomic_dna_length\n\n    Title   : genomic_dna_length\n    Usage   : $spidey->genomic_dna_length();\n    Function: Returns the length of the genomic DNA used in this Spidey result\n    Example :\n    Returns : An integer value.\n    Args    :\n\n\nsub genomic_dna_length {\n    my ($self, @args) = @_;\n    my $val;\n\n    if(@args) {\n\t$val = shift(@args);\n\t$self->{'genomic_dna_length'} = $val;\n    } else {\n\t$val = $self->{'genomic_dna_length'};\n    }\n    return $val;\n}\n\n=head2 splicesites\n\n    Title   : splicesites\n    Usage   : $spidey->splicesites();\n    Function: Returns the number of splice sites found in this Spidey result\n    Example :\n    Returns : An integer value.\n    Args    :\n\n\nsub splicesites {\n    my ($self, @args) = @_;\n    my $val;\n\n    if(@args) {\n\t$val = shift(@args);\n\t$self->{'splicesites'} = $val;\n    } else {\n\t$val = $self->{'splicesites'};\n    }\n    return $val;\n}\n\n=head2 est_coverage\n\n    Title   : est_coverage\n    Usage   : $spidey->est_coverage();\n    Function: Returns the percent of est coverage in this Spidey result\n    Example :\n    Returns : An integer value.\n    Args    :"},"detail":"($self,@args)","kind":12,"children":[{"name":"$self","definition":"my","containerName":"est_coverage","localvar":"my","kind":13,"line":469},{"kind":13,"line":469,"name":"@args","containerName":"est_coverage"},{"localvar":"my","name":"$val","definition":"my","containerName":"est_coverage","line":470,"kind":13},{"name":"@args","containerName":"est_coverage","line":472,"kind":13},{"kind":13,"line":473,"containerName":"est_coverage","name":"$val"},{"name":"@args","containerName":"est_coverage","kind":13,"line":473},{"name":"$self","containerName":"est_coverage","line":474,"kind":13},{"containerName":"est_coverage","name":"$val","kind":13,"line":474},{"kind":13,"line":476,"name":"$val","containerName":"est_coverage"},{"kind":13,"line":476,"name":"$self","containerName":"est_coverage"},{"kind":13,"line":478,"name":"$val","containerName":"est_coverage"}],"line":468},{"range":{"end":{"line":503,"character":9999},"start":{"character":0,"line":492}},"name":"overall_percentage_id","detail":"($self,@args)","signature":{"label":"overall_percentage_id($self,@args)","documentation":"1;\n# $Id: Results.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Spidey::Results\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ryan Golhar <golharam@umdnj.edu>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Spidey::Results - Results of a Spidey run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Spidey::Results;\n\tmy $spidey = Bio::Tools::Spidey::Results->new(-file => 'result.spidey' );\n\n\t# or\n\n\tmy $spidey = Bio::Tools::Spidey::Results->new( -fh   => \\*INPUT );\n\n\t# get the exons before doing anything else\n\tmy $exonset = $spidey->next_exonset();\n\n\t# parse the results\n\tmy @exons = $exonset->sub_SeqFeature();\n\tprint \"Total no of Exons: \", scalar(@exons), \"\\n\";\n\n\tprint \"Genomic sequence length: \", $spidey->genomic_dna_length(), \"\\n\";\n\n\t# $exonset is-a Bio::SeqFeature::Generic with Bio::Tools::Spidey::Exons\n\t# as sub features\n\tprint \"Delimited on sequence \", $exonset->seq_id(), \" from \", \n\t\t$exonset->start(), \" to \", $exonset->end(), \"\\n\";\n\n\tforeach my $exon ( $exonset->sub_SeqFeature() ) {\n\t\t# $exon is-a Bio::SeqFeature::FeaturePair\n\t\tprint \"Exon from \", $exon->start, \" to \", $exon->end, \n\t\t\t\" on strand \", $exon->strand(), \"\\n\";\n\t\t# you can get out what it matched using the est_hit attribute\n\t\tmy $homol = $exon->est_hit();\n\t\tprint \"Matched to sequence \", $homol->seq_id, \n\t\t\t\" at \", $homol->start,\" to \", $homol->end, \"\\n\";\n\t}\n\n\t# essential if you gave a filename at initialization (otherwise \n  \t# the file stays open)\n\t$spidey->close();\n\n=head1 DESCRIPTION\n\nThe spidey module provides a parser and results object for spidey \noutput. The spidey results are specialised types of SeqFeatures, \nmeaning you can add them to AnnSeq objects fine, and manipulate them \nin the \"normal\" seqfeature manner.\n\nThe spidey Exon objects are Bio::SeqFeature::FeaturePair inherited \nobjects. The $esthit = $exon-E<gt>est_hit() is the alignment as a \nfeature on the matching object (normally, a cDNA), in which the \nstart/end points are where the hit lies.\n\nTo make this module work sensibly you need to run\n\n     spidey -i genomic.fasta -m cDNA.fasta\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ryan Golhar\n\nEmail golharam@umdnj.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Spidey::Results;\nuse strict;\n\nuse File::Basename;\nuse Bio::Root::Root;\nuse Bio::Tools::Spidey::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # call the inherited method first\n    my $make = $self->SUPER::_initialize_state(@args);\n\n#    my ($est_is_first) = $self->_rearrange([qw(ESTFIRST)], @args);\n\n#    delete($self->{'_est_is_first'});\n#    $self->{'_est_is_first'} = $est_is_first if(defined($est_is_first));\n    $self->analysis_method(\"Spidey\");\n}\n\n=head2 analysis_method\n\n Usage     : $spidey->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /Spidey/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /Spidey/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 parse_next_alignment\n\n Title   : parse_next_alignment\n Usage   : @exons = $spidey_result->parse_next_alignment;\n           foreach $exon (@exons) {\n               # do something\n           }\n Function: Parses the next alignment of the Spidey result file and returns the\n           found exons as an array of Bio::Tools::Spidey::Exon objects. Call\n           this method repeatedly until an empty array is returned to get the\n           results for all alignments.\n Example :\n Returns : An array of Bio::Tools::Spidey::Exon objects\n Args    :\n\n\n\nsub parse_next_alignment {\n    my ($self) = @_;\n    # for strand 1 = plus, -1 = minus\n    my ($started,$version,$strand, $exoncount) = (0,0,0,-1);\n    my (%seq1props,%seq2props,@exons);\n    \n    # we refer to the properties of each seq by reference\n\n    while(defined($_ = $self->_readline())) {\n\tchomp;\n\t#\n\t# bascially, parse a Spidey result...\n\t#\n\t# matches: --SPIDEY version 1.40--\n\tif( /^--SPIDEY\\s+version\\s+(\\d+\\.\\d+)--/) {\n\t    if($started) {\n\t\t$self->_pushback($_);\n\t\treturn \\@exons;\n\t    }\n\t    $version = $1;\n\t    if ($version != 1.40) {\n\t\t$self->throw(\"Spidey parser only designed to work with Spidey v1.40\\n\");\n\t    }\n\t    $started = 1;\n\t} elsif (/^Genomic:\\s+(\\S+)\\s.*,\\s+(\\d+)\\sbp$/ ) {\n\t    # matches: Genomic: lcl|some_name other information, 1234 bp\n\t    # $seq1props{'filename'} = $1;\n\t    $seq1props{'seqname'} = $1;\n\t    $seq1props{'length'} = $2;\t   \n\t    $self->genomic_dna_length($seq1props{'length'});\n\n\t} elsif( /^mRNA:\\s+(\\S+)\\s.*,(?:\\s+mRNA\\s+sequence,)?\\s(\\d+)\\sbp$/ ) {\n\t    # matches: mRNA:\n\t    # $seq2props{'filename'} = $1;\n\t    $seq2props{'seqname'} = $1;\n\t    $seq2props{'length'} = $2;\n\n\t} elsif( /^Strand:/ ) {\n\t    if (/plus/) {\n\t\t$strand = 1;\n\t    } else {\n\t\t$strand = -1;\n\t    }\n\t} elsif( /^Number of exons: (\\d+)/ ) {\n\t    $exoncount = $1;\n\n\t    my ($genomic_start, $genomic_stop, $cdna_start, $cdna_stop,\n\t\t$id, $mismatches, $gaps, $splice_donor, \n\t\t$splice_acceptor, $uncertain);\n\n\t    # the next $exoncount lines contains information\n\t    # about the matches of each exon.  we should parse\n\t    # this information here\n\n\t    for (my $ec = 1; $ec <= $exoncount; $ec++) {\n\t\tif (defined($_ = $self->_readline())) {\n\t\t    chomp;\n\n\t\t    if (/^Exon\\s$ec[\\(\\)-]*:\\s(\\d+)-(\\d+)\\s\\(gen\\)\\s+(\\d+)-(\\d+)\\s\\(mRNA\\)\\s+id\\s([\\d\\.inf-]+)%\\s+mismatches\\s(\\d+)\\s+gaps\\s(\\d+)\\s+splice\\ssite\\s\\(d\\s+a\\):\\s(\\d+)\\s+(\\d+)\\s*(\\w*)/) {\n\t\t\t$genomic_start = $1;\n\t\t\t$genomic_stop = $2;\n\t\t\t$cdna_start = $3;\n\t\t\t$cdna_stop = $4;\n\t\t\t$id = $5;\n\t\t\t$mismatches = $6;\n\t\t\t$gaps = $7;\n\t\t\t$splice_donor = $8;\n\t\t\t$splice_acceptor = $9;\n\t\t\t$uncertain = $10;\n\t\t    } else {\n\t\t\t$self->throw( \"Failed to match anything:\\n$_\\n\");\n\t\t    }\n\n\t\t    my $exon = Bio::Tools::Spidey::Exon->new\n\t\t\t(-start  => $genomic_start,\n\t\t\t -end    => $genomic_stop,\n\t\t\t -strand => $strand);\n\t\t    $exon->seq_id($seq1props{'seqname'});\n\n\t\t    # feature1 is supposed to be initialized to a Similarity object, but we provide a safety net\n\t\t    if ($exon->feature1->can('seqlength')) {\n\t\t\t$exon->feature1->seqlength($seq1props{'length'});\n\t\t    } else {\n\t\t\t$exon->feature1->add_tag_value('seqlength', $seq1props{'length'});\n\t\t    }\n\n\t\t    # create and initialize the feature wrapping the 'hit' (the cDNA)\n\t\t    my $fea2 = Bio::SeqFeature::Similarity->new\n\t\t\t(-start   => $cdna_start,\n\t\t\t -end     => $cdna_stop,\n\t\t\t -strand  => $strand,\n\t\t\t -seq_id  => $seq2props{'seqname'},\n\t\t\t -primary => \"aligning_cDNA\");\n\t\t    $fea2->seqlength($seq2props{'length'});\n\t\t    # store\n\t\t    $exon->est_hit($fea2);\t   \n\n\t\t    # general properties\n\t\t    $exon->source_tag($self->analysis_method());\n\t\t    $exon->percentage_id($5);\n\t\t    $exon->mismatches($6);\n\t\t    $exon->gaps($7);\n\t\t    $exon->donor($8);\n\t\t    $exon->acceptor($9);\n\n\t\t    # push onto array\n\t\t    push(@exons, $exon);\n\t\t} else {\n\t\t    $self->throw(\"Unexpected end of file reached\\n\");\n\t\t}\n\t    }\n\t} elsif( /^Number of splice sites:\\s+(\\d+)/ ) {\n\t    $self->splicesites($1);\t\n\t} elsif( /^mRNA coverage:\\s+(\\d+)%/ ) { \n\t    $self->est_coverage($1);\n\t} elsif(/^overall percent identity:\\s+([\\d\\.]+)%/ ) {\n\t    $self->overall_percentage_id($1);\n\t} elsif(/^Missing mRNA ends:\\s+(\\w+)/ ) {\n\t    $self->missing_mrna_ends($1);\n\t} elsif( /^Exon (\\d+): (\\d+)-(\\d+) \\(gen\\)\\s+(\\d+)-(\\d+) \\(mRNA\\)/ ) {\n\t    my ($exon_num, $gen_start, $gen_stop, $cdna_start, $cdna_stop);\t\t\t\t\t\t\n\t    $exon_num = $1;\n\t    $gen_start = $2;\n\t    $gen_stop = $3;\n\t    $cdna_start = $4;\n\t    $cdna_stop = $5;\t\t\t\n\t} elsif( /No alignment found/ ) {\n\t    return [];\n\t} else {\n\t    #$self->debug(\"unmatched $_\\n\");\n\t}\n    }\n    # Typical format:\n    # \tExon 1: 36375798-36375691 (gen)  1-108 (mRNA)\n    #\n    #\n    #\tCCTCTTTTTCTTTGCAGGGTATATACCCAGTTACTTAGACAAGGATGAGCTATGTGTAGT\n    #        \t   |  ||||||||||||||||||||||||||||||||||||||||||||||\n    #\t          ATGTCAGGGTATATACCCAGTTACTTAGACAAGGATGAGCTATGTGTAGT\n    #\t           M  S  G  Y  I  P  S  Y  L  D  K  D  E  L  C  V  V \n    #\n    #\n    #\tATGTGGGGACAAAGCCACCGGATATCATTATCGCTGCATCACTTGTGAAGGTTGCAAGGT\n    #\t||||||||||||||||||||||||||||||||||||||||||||||||||||||||||\n    #\tATGTGGGGACAAAGCCACCGGATATCATTATCGCTGCATCACTTGTGAAGGTTGCAAG\n    #\t  C  G  D  K  A  T  G  Y  H  Y  R  C  I  T  C  E  G  C  K \n    #\n    #\n    #\tAAATGGCA\n    #\n    @exons ? return \\@exons : return ;\n}\n\n=head2 next_exonset\n\n  Title   : next_exonset\n  Usage   : $exonset = $spidey_result->parse_next_exonset;\n         print \"Exons start at \", $exonset->start(), \n        \"and end at \", $exonset->end(), \"\\n\";\n         for $exon ($exonset->sub_SeqFeature()) {\n\t    # do something\n         }\n  Function: Parses the next alignment of the Spidey result file and returns the\n       set of exons as a container of features. The container is itself\n       a Bio::SeqFeature::Generic object, with the Bio::Tools::Spidey::Exon\n       objects as sub features. Start, end, and strand of the container\n       will represent the total region covered by the exons of this set.\n\n      See the documentation of parse_next_alignment() for further\n      reference about parsing and how the information is stored.\n Example : \n Returns : An Bio::SeqFeature::Generic object holding Bio::Tools::Spidey::Exon\n          objects as sub features.\n Args    :\n\n\nsub next_exonset {\n    my $self = shift;\n    my $exonset;\n\n    # get the next array of exons\n    my $exons = $self->parse_next_alignment();\n    if( ! defined $exons ) {\n        $self->warn(\"No exons returned\");\n        return;\n    } \n    if( @$exons == 0 ) {\n\treturn Bio::SeqFeature::Generic->new();\n    }\n    # create the container of exons as a feature object itself, with the\n    # data of the first exon for initialization\n    $exonset = Bio::SeqFeature::Generic->new('-start' => $exons->[0]->start(),\n\t\t\t\t\t     '-end' => $exons->[-1]->end(),\n\t\t\t\t\t     '-strand' => $exons->[0]->strand(),\n\t\t\t\t\t     '-primary' => \"ExonSet\");\n    $exonset->source_tag($exons->[0]->source_tag());\n    $exonset->seq_id($exons->[0]->seq_id());\n    # now add all exons as sub features, with enabling EXPANsion of the region\n    # covered in total\n    foreach my $exon (@$exons) {\n\t$exonset->add_sub_SeqFeature($exon, 'EXPAND');\n    }\n    return $exonset;\n}\n\n=head2 next_feature\n\n  Title   : next_feature\n  Usage   : while($exonset = $spidey->next_feature()) {\n\t    # do something\n\t   }\n  Function: Does the same as L<next_exonset()>. See there for documentation of\n      the functionality. Call this method repeatedly until FALSE is\n      returned.\n\n      The returned object is actually a SeqFeatureI implementing object.\n      This method is required for classes implementing the\n      SeqAnalysisParserI interface, and is merely an alias for \n      next_exonset() at present.\n\n  Example :\n  Returns : A Bio::SeqFeature::Generic object.\n  Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_exonset doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_exonset(@args);\n}\n\n=head2 genomic_dna_length\n\n    Title   : genomic_dna_length\n    Usage   : $spidey->genomic_dna_length();\n    Function: Returns the length of the genomic DNA used in this Spidey result\n    Example :\n    Returns : An integer value.\n    Args    :\n\n\nsub genomic_dna_length {\n    my ($self, @args) = @_;\n    my $val;\n\n    if(@args) {\n\t$val = shift(@args);\n\t$self->{'genomic_dna_length'} = $val;\n    } else {\n\t$val = $self->{'genomic_dna_length'};\n    }\n    return $val;\n}\n\n=head2 splicesites\n\n    Title   : splicesites\n    Usage   : $spidey->splicesites();\n    Function: Returns the number of splice sites found in this Spidey result\n    Example :\n    Returns : An integer value.\n    Args    :\n\n\nsub splicesites {\n    my ($self, @args) = @_;\n    my $val;\n\n    if(@args) {\n\t$val = shift(@args);\n\t$self->{'splicesites'} = $val;\n    } else {\n\t$val = $self->{'splicesites'};\n    }\n    return $val;\n}\n\n=head2 est_coverage\n\n    Title   : est_coverage\n    Usage   : $spidey->est_coverage();\n    Function: Returns the percent of est coverage in this Spidey result\n    Example :\n    Returns : An integer value.\n    Args    :\n\n\nsub est_coverage {\n     my ($self, @args) = @_;\n     my $val;\n     \n     if(@args) {\n\t $val = shift(@args);\n\t $self->{'est_coverage'} = $val;\n     } else {\n\t $val = $self->{'est_coverage'};\n     }\n     return $val;\n }\n\n=head2 overall_percentage_id\n\n    Title   : overall_percentage_id\n    Usage   : $spidey->overall_percentage_id();\n    Function: Returns the overall percent id in this Spidey result\n    Example :\n    Returns : An float value.\n    Args    :","parameters":[{"label":"$self"},{"label":"@args"}]},"containerName":"main::","definition":"sub","line":492,"children":[{"line":493,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"overall_percentage_id"},{"containerName":"overall_percentage_id","name":"@args","line":493,"kind":13},{"definition":"my","name":"$val","containerName":"overall_percentage_id","localvar":"my","kind":13,"line":494},{"line":496,"kind":13,"containerName":"overall_percentage_id","name":"@args"},{"name":"$val","containerName":"overall_percentage_id","line":497,"kind":13},{"name":"@args","containerName":"overall_percentage_id","kind":13,"line":497},{"name":"$self","containerName":"overall_percentage_id","kind":13,"line":498},{"line":498,"kind":13,"containerName":"overall_percentage_id","name":"$val"},{"kind":13,"line":500,"containerName":"overall_percentage_id","name":"$val"},{"containerName":"overall_percentage_id","name":"$self","kind":13,"line":500},{"kind":13,"line":502,"name":"$val","containerName":"overall_percentage_id"}],"kind":12},{"range":{"start":{"line":516,"character":0},"end":{"line":527,"character":9999}},"name":"missing_mrna_ends","children":[{"localvar":"my","containerName":"missing_mrna_ends","definition":"my","name":"$self","line":517,"kind":13},{"kind":13,"line":517,"containerName":"missing_mrna_ends","name":"@args"},{"containerName":"missing_mrna_ends","name":"$val","definition":"my","localvar":"my","kind":13,"line":518},{"name":"@args","containerName":"missing_mrna_ends","line":520,"kind":13},{"line":521,"kind":13,"containerName":"missing_mrna_ends","name":"$val"},{"line":521,"kind":13,"name":"@args","containerName":"missing_mrna_ends"},{"kind":13,"line":522,"containerName":"missing_mrna_ends","name":"$self"},{"containerName":"missing_mrna_ends","name":"$val","kind":13,"line":522},{"kind":13,"line":524,"containerName":"missing_mrna_ends","name":"$val"},{"containerName":"missing_mrna_ends","name":"$self","kind":13,"line":524},{"name":"$val","containerName":"missing_mrna_ends","kind":13,"line":526}],"line":516,"kind":12,"signature":{"label":"missing_mrna_ends($self,@args)","documentation":"1;\n# $Id: Results.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Spidey::Results\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ryan Golhar <golharam@umdnj.edu>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Spidey::Results - Results of a Spidey run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Spidey::Results;\n\tmy $spidey = Bio::Tools::Spidey::Results->new(-file => 'result.spidey' );\n\n\t# or\n\n\tmy $spidey = Bio::Tools::Spidey::Results->new( -fh   => \\*INPUT );\n\n\t# get the exons before doing anything else\n\tmy $exonset = $spidey->next_exonset();\n\n\t# parse the results\n\tmy @exons = $exonset->sub_SeqFeature();\n\tprint \"Total no of Exons: \", scalar(@exons), \"\\n\";\n\n\tprint \"Genomic sequence length: \", $spidey->genomic_dna_length(), \"\\n\";\n\n\t# $exonset is-a Bio::SeqFeature::Generic with Bio::Tools::Spidey::Exons\n\t# as sub features\n\tprint \"Delimited on sequence \", $exonset->seq_id(), \" from \", \n\t\t$exonset->start(), \" to \", $exonset->end(), \"\\n\";\n\n\tforeach my $exon ( $exonset->sub_SeqFeature() ) {\n\t\t# $exon is-a Bio::SeqFeature::FeaturePair\n\t\tprint \"Exon from \", $exon->start, \" to \", $exon->end, \n\t\t\t\" on strand \", $exon->strand(), \"\\n\";\n\t\t# you can get out what it matched using the est_hit attribute\n\t\tmy $homol = $exon->est_hit();\n\t\tprint \"Matched to sequence \", $homol->seq_id, \n\t\t\t\" at \", $homol->start,\" to \", $homol->end, \"\\n\";\n\t}\n\n\t# essential if you gave a filename at initialization (otherwise \n  \t# the file stays open)\n\t$spidey->close();\n\n=head1 DESCRIPTION\n\nThe spidey module provides a parser and results object for spidey \noutput. The spidey results are specialised types of SeqFeatures, \nmeaning you can add them to AnnSeq objects fine, and manipulate them \nin the \"normal\" seqfeature manner.\n\nThe spidey Exon objects are Bio::SeqFeature::FeaturePair inherited \nobjects. The $esthit = $exon-E<gt>est_hit() is the alignment as a \nfeature on the matching object (normally, a cDNA), in which the \nstart/end points are where the hit lies.\n\nTo make this module work sensibly you need to run\n\n     spidey -i genomic.fasta -m cDNA.fasta\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ryan Golhar\n\nEmail golharam@umdnj.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Spidey::Results;\nuse strict;\n\nuse File::Basename;\nuse Bio::Root::Root;\nuse Bio::Tools::Spidey::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # call the inherited method first\n    my $make = $self->SUPER::_initialize_state(@args);\n\n#    my ($est_is_first) = $self->_rearrange([qw(ESTFIRST)], @args);\n\n#    delete($self->{'_est_is_first'});\n#    $self->{'_est_is_first'} = $est_is_first if(defined($est_is_first));\n    $self->analysis_method(\"Spidey\");\n}\n\n=head2 analysis_method\n\n Usage     : $spidey->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /Spidey/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /Spidey/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 parse_next_alignment\n\n Title   : parse_next_alignment\n Usage   : @exons = $spidey_result->parse_next_alignment;\n           foreach $exon (@exons) {\n               # do something\n           }\n Function: Parses the next alignment of the Spidey result file and returns the\n           found exons as an array of Bio::Tools::Spidey::Exon objects. Call\n           this method repeatedly until an empty array is returned to get the\n           results for all alignments.\n Example :\n Returns : An array of Bio::Tools::Spidey::Exon objects\n Args    :\n\n\n\nsub parse_next_alignment {\n    my ($self) = @_;\n    # for strand 1 = plus, -1 = minus\n    my ($started,$version,$strand, $exoncount) = (0,0,0,-1);\n    my (%seq1props,%seq2props,@exons);\n    \n    # we refer to the properties of each seq by reference\n\n    while(defined($_ = $self->_readline())) {\n\tchomp;\n\t#\n\t# bascially, parse a Spidey result...\n\t#\n\t# matches: --SPIDEY version 1.40--\n\tif( /^--SPIDEY\\s+version\\s+(\\d+\\.\\d+)--/) {\n\t    if($started) {\n\t\t$self->_pushback($_);\n\t\treturn \\@exons;\n\t    }\n\t    $version = $1;\n\t    if ($version != 1.40) {\n\t\t$self->throw(\"Spidey parser only designed to work with Spidey v1.40\\n\");\n\t    }\n\t    $started = 1;\n\t} elsif (/^Genomic:\\s+(\\S+)\\s.*,\\s+(\\d+)\\sbp$/ ) {\n\t    # matches: Genomic: lcl|some_name other information, 1234 bp\n\t    # $seq1props{'filename'} = $1;\n\t    $seq1props{'seqname'} = $1;\n\t    $seq1props{'length'} = $2;\t   \n\t    $self->genomic_dna_length($seq1props{'length'});\n\n\t} elsif( /^mRNA:\\s+(\\S+)\\s.*,(?:\\s+mRNA\\s+sequence,)?\\s(\\d+)\\sbp$/ ) {\n\t    # matches: mRNA:\n\t    # $seq2props{'filename'} = $1;\n\t    $seq2props{'seqname'} = $1;\n\t    $seq2props{'length'} = $2;\n\n\t} elsif( /^Strand:/ ) {\n\t    if (/plus/) {\n\t\t$strand = 1;\n\t    } else {\n\t\t$strand = -1;\n\t    }\n\t} elsif( /^Number of exons: (\\d+)/ ) {\n\t    $exoncount = $1;\n\n\t    my ($genomic_start, $genomic_stop, $cdna_start, $cdna_stop,\n\t\t$id, $mismatches, $gaps, $splice_donor, \n\t\t$splice_acceptor, $uncertain);\n\n\t    # the next $exoncount lines contains information\n\t    # about the matches of each exon.  we should parse\n\t    # this information here\n\n\t    for (my $ec = 1; $ec <= $exoncount; $ec++) {\n\t\tif (defined($_ = $self->_readline())) {\n\t\t    chomp;\n\n\t\t    if (/^Exon\\s$ec[\\(\\)-]*:\\s(\\d+)-(\\d+)\\s\\(gen\\)\\s+(\\d+)-(\\d+)\\s\\(mRNA\\)\\s+id\\s([\\d\\.inf-]+)%\\s+mismatches\\s(\\d+)\\s+gaps\\s(\\d+)\\s+splice\\ssite\\s\\(d\\s+a\\):\\s(\\d+)\\s+(\\d+)\\s*(\\w*)/) {\n\t\t\t$genomic_start = $1;\n\t\t\t$genomic_stop = $2;\n\t\t\t$cdna_start = $3;\n\t\t\t$cdna_stop = $4;\n\t\t\t$id = $5;\n\t\t\t$mismatches = $6;\n\t\t\t$gaps = $7;\n\t\t\t$splice_donor = $8;\n\t\t\t$splice_acceptor = $9;\n\t\t\t$uncertain = $10;\n\t\t    } else {\n\t\t\t$self->throw( \"Failed to match anything:\\n$_\\n\");\n\t\t    }\n\n\t\t    my $exon = Bio::Tools::Spidey::Exon->new\n\t\t\t(-start  => $genomic_start,\n\t\t\t -end    => $genomic_stop,\n\t\t\t -strand => $strand);\n\t\t    $exon->seq_id($seq1props{'seqname'});\n\n\t\t    # feature1 is supposed to be initialized to a Similarity object, but we provide a safety net\n\t\t    if ($exon->feature1->can('seqlength')) {\n\t\t\t$exon->feature1->seqlength($seq1props{'length'});\n\t\t    } else {\n\t\t\t$exon->feature1->add_tag_value('seqlength', $seq1props{'length'});\n\t\t    }\n\n\t\t    # create and initialize the feature wrapping the 'hit' (the cDNA)\n\t\t    my $fea2 = Bio::SeqFeature::Similarity->new\n\t\t\t(-start   => $cdna_start,\n\t\t\t -end     => $cdna_stop,\n\t\t\t -strand  => $strand,\n\t\t\t -seq_id  => $seq2props{'seqname'},\n\t\t\t -primary => \"aligning_cDNA\");\n\t\t    $fea2->seqlength($seq2props{'length'});\n\t\t    # store\n\t\t    $exon->est_hit($fea2);\t   \n\n\t\t    # general properties\n\t\t    $exon->source_tag($self->analysis_method());\n\t\t    $exon->percentage_id($5);\n\t\t    $exon->mismatches($6);\n\t\t    $exon->gaps($7);\n\t\t    $exon->donor($8);\n\t\t    $exon->acceptor($9);\n\n\t\t    # push onto array\n\t\t    push(@exons, $exon);\n\t\t} else {\n\t\t    $self->throw(\"Unexpected end of file reached\\n\");\n\t\t}\n\t    }\n\t} elsif( /^Number of splice sites:\\s+(\\d+)/ ) {\n\t    $self->splicesites($1);\t\n\t} elsif( /^mRNA coverage:\\s+(\\d+)%/ ) { \n\t    $self->est_coverage($1);\n\t} elsif(/^overall percent identity:\\s+([\\d\\.]+)%/ ) {\n\t    $self->overall_percentage_id($1);\n\t} elsif(/^Missing mRNA ends:\\s+(\\w+)/ ) {\n\t    $self->missing_mrna_ends($1);\n\t} elsif( /^Exon (\\d+): (\\d+)-(\\d+) \\(gen\\)\\s+(\\d+)-(\\d+) \\(mRNA\\)/ ) {\n\t    my ($exon_num, $gen_start, $gen_stop, $cdna_start, $cdna_stop);\t\t\t\t\t\t\n\t    $exon_num = $1;\n\t    $gen_start = $2;\n\t    $gen_stop = $3;\n\t    $cdna_start = $4;\n\t    $cdna_stop = $5;\t\t\t\n\t} elsif( /No alignment found/ ) {\n\t    return [];\n\t} else {\n\t    #$self->debug(\"unmatched $_\\n\");\n\t}\n    }\n    # Typical format:\n    # \tExon 1: 36375798-36375691 (gen)  1-108 (mRNA)\n    #\n    #\n    #\tCCTCTTTTTCTTTGCAGGGTATATACCCAGTTACTTAGACAAGGATGAGCTATGTGTAGT\n    #        \t   |  ||||||||||||||||||||||||||||||||||||||||||||||\n    #\t          ATGTCAGGGTATATACCCAGTTACTTAGACAAGGATGAGCTATGTGTAGT\n    #\t           M  S  G  Y  I  P  S  Y  L  D  K  D  E  L  C  V  V \n    #\n    #\n    #\tATGTGGGGACAAAGCCACCGGATATCATTATCGCTGCATCACTTGTGAAGGTTGCAAGGT\n    #\t||||||||||||||||||||||||||||||||||||||||||||||||||||||||||\n    #\tATGTGGGGACAAAGCCACCGGATATCATTATCGCTGCATCACTTGTGAAGGTTGCAAG\n    #\t  C  G  D  K  A  T  G  Y  H  Y  R  C  I  T  C  E  G  C  K \n    #\n    #\n    #\tAAATGGCA\n    #\n    @exons ? return \\@exons : return ;\n}\n\n=head2 next_exonset\n\n  Title   : next_exonset\n  Usage   : $exonset = $spidey_result->parse_next_exonset;\n         print \"Exons start at \", $exonset->start(), \n        \"and end at \", $exonset->end(), \"\\n\";\n         for $exon ($exonset->sub_SeqFeature()) {\n\t    # do something\n         }\n  Function: Parses the next alignment of the Spidey result file and returns the\n       set of exons as a container of features. The container is itself\n       a Bio::SeqFeature::Generic object, with the Bio::Tools::Spidey::Exon\n       objects as sub features. Start, end, and strand of the container\n       will represent the total region covered by the exons of this set.\n\n      See the documentation of parse_next_alignment() for further\n      reference about parsing and how the information is stored.\n Example : \n Returns : An Bio::SeqFeature::Generic object holding Bio::Tools::Spidey::Exon\n          objects as sub features.\n Args    :\n\n\nsub next_exonset {\n    my $self = shift;\n    my $exonset;\n\n    # get the next array of exons\n    my $exons = $self->parse_next_alignment();\n    if( ! defined $exons ) {\n        $self->warn(\"No exons returned\");\n        return;\n    } \n    if( @$exons == 0 ) {\n\treturn Bio::SeqFeature::Generic->new();\n    }\n    # create the container of exons as a feature object itself, with the\n    # data of the first exon for initialization\n    $exonset = Bio::SeqFeature::Generic->new('-start' => $exons->[0]->start(),\n\t\t\t\t\t     '-end' => $exons->[-1]->end(),\n\t\t\t\t\t     '-strand' => $exons->[0]->strand(),\n\t\t\t\t\t     '-primary' => \"ExonSet\");\n    $exonset->source_tag($exons->[0]->source_tag());\n    $exonset->seq_id($exons->[0]->seq_id());\n    # now add all exons as sub features, with enabling EXPANsion of the region\n    # covered in total\n    foreach my $exon (@$exons) {\n\t$exonset->add_sub_SeqFeature($exon, 'EXPAND');\n    }\n    return $exonset;\n}\n\n=head2 next_feature\n\n  Title   : next_feature\n  Usage   : while($exonset = $spidey->next_feature()) {\n\t    # do something\n\t   }\n  Function: Does the same as L<next_exonset()>. See there for documentation of\n      the functionality. Call this method repeatedly until FALSE is\n      returned.\n\n      The returned object is actually a SeqFeatureI implementing object.\n      This method is required for classes implementing the\n      SeqAnalysisParserI interface, and is merely an alias for \n      next_exonset() at present.\n\n  Example :\n  Returns : A Bio::SeqFeature::Generic object.\n  Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_exonset doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_exonset(@args);\n}\n\n=head2 genomic_dna_length\n\n    Title   : genomic_dna_length\n    Usage   : $spidey->genomic_dna_length();\n    Function: Returns the length of the genomic DNA used in this Spidey result\n    Example :\n    Returns : An integer value.\n    Args    :\n\n\nsub genomic_dna_length {\n    my ($self, @args) = @_;\n    my $val;\n\n    if(@args) {\n\t$val = shift(@args);\n\t$self->{'genomic_dna_length'} = $val;\n    } else {\n\t$val = $self->{'genomic_dna_length'};\n    }\n    return $val;\n}\n\n=head2 splicesites\n\n    Title   : splicesites\n    Usage   : $spidey->splicesites();\n    Function: Returns the number of splice sites found in this Spidey result\n    Example :\n    Returns : An integer value.\n    Args    :\n\n\nsub splicesites {\n    my ($self, @args) = @_;\n    my $val;\n\n    if(@args) {\n\t$val = shift(@args);\n\t$self->{'splicesites'} = $val;\n    } else {\n\t$val = $self->{'splicesites'};\n    }\n    return $val;\n}\n\n=head2 est_coverage\n\n    Title   : est_coverage\n    Usage   : $spidey->est_coverage();\n    Function: Returns the percent of est coverage in this Spidey result\n    Example :\n    Returns : An integer value.\n    Args    :\n\n\nsub est_coverage {\n     my ($self, @args) = @_;\n     my $val;\n     \n     if(@args) {\n\t $val = shift(@args);\n\t $self->{'est_coverage'} = $val;\n     } else {\n\t $val = $self->{'est_coverage'};\n     }\n     return $val;\n }\n\n=head2 overall_percentage_id\n\n    Title   : overall_percentage_id\n    Usage   : $spidey->overall_percentage_id();\n    Function: Returns the overall percent id in this Spidey result\n    Example :\n    Returns : An float value.\n    Args    :\n\n\nsub overall_percentage_id {\n    my ($self, @args) = @_;\n    my $val;\n\n    if(@args) {\n\t$val = shift(@args);\n\t$self->{'overall_percentage_id'} = $val;\n    } else {\n\t$val = $self->{'overall_percentage_id'};\n    }\n    return $val;\n}\n\n=head2 missing_mrna_ends\n\n    Title   : missing_mrna_ends\n    Usage   : $spidey->missing_mrna_ends();\n    Function: Returns left/right/neither from Spidey\n    Example :\n    Returns : A string value.\n    Args    :","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","definition":"sub","containerName":"main::"}]}