{"vars":[{"line":110,"kind":2,"containerName":"","name":"base"},{"line":113,"kind":13,"localvar":"my","containerName":null,"name":"%FACTS","definition":"my"},{"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: ExtendedSignalp.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Signalp::ExtendedSignalp\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n#\n# Copyright Emmanuel Quevillon\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Signalp::ExtendedSignalp - enhanced parser for Signalp output\n\n=head1 SYNOPSIS\n\n use Bio::Tools::Signalp::ExtendedSignalp;\n my $params = [qw(maxC maxY maxS meanS D)];\n my $parser = new Bio::Tools::Signalp::ExtendedSignalp(\n                                                       -fh      => $filehandle\n                                                       -factors => $params\n                                                      );\n\n $parser->factors($params);\n while( my $sp_feat = $parser->next_feature ) {\n       #do something\n       #eg\n       push @sp_feat, $sp_feat;\n }\n\n=head1 DESCRIPTION\n\n# Please direct questions and support issues to I<bioperl-l@bioperl.org> \n\nParser module for Signalp.\n\nBased on the EnsEMBL module Bio::EnsEMBL::Pipeline::Runnable::Protein::Signalp\noriginally written by Marc Sohrmann (ms2 a sanger.ac.uk) Written in BioPipe by\nBalamurugan Kumarasamy (savikalpa a fugu-sg.org) Cared for by the Fugu\nInformatics team (fuguteam@fugu-sg.org)\n\nYou may distribute this module under the same terms as perl itself\n\nCompared to the original SignalP, this method allow the user to filter results\nout based on maxC maxY maxS meanS and D factor cutoff for the Neural Network (NN)\nmethod only. The HMM method does not give any filters with 'YES' or 'NO' as result.\n\nThe user must be aware that the filters can only by applied on NN method.\nAlso, to ensure the compability with original Signalp parsing module, the user\nmust know that by default, if filters are empty, max Y and mean S filters are\nautomatically used to filter results.\n\nIf the used gives a list, then the parser will only report protein having 'YES'\nfor each factor.\n\nThis module supports parsing for full, summary and short output form signalp.\nActually, full and summary are equivalent in terms of filtering results.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Based on the Bio::Tools::Signalp module\n Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n\n=head1 APPENDIX\n\n The rest of the documentation details each of the object methods.\n Internal methods are usually preceded with a _\n\n\npackage Bio::Tools::Signalp::ExtendedSignalp;\n\nuse strict;\nuse Data::Dumper;\nuse Bio::SeqFeature::Generic;\n# don't need Bio::Root::Root/IO (already in inheritance tree)\nuse base qw(Bio::Tools::Signalp Bio::Tools::AnalysisResult);\n\n#Supported arguments\nmy $FACTS = {\n\t     'maxC'  => 1,\n\t     'maxS'  => 1,\n\t     'maxY'  => 1,\n\t     'meanS' => 1,\n\t     'D'     => 1,\n\t    };\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Tools::Signalp::ExtendedSignalp();\n Function: Builds a new Bio::Tools::Signalp::ExtendedSignalp object\n Returns : Bio::Tools::Signalp::ExtendedSignalp\n Args    : -fh/-file => $val, # for initing input, see Bio::Root::IO","label":"new($class,@args)"},"detail":"($class,@args)","definition":"sub","containerName":"main::","children":[{"localvar":"my","name":"$class","definition":"my","containerName":"new","line":133,"kind":13},{"line":133,"kind":13,"name":"@args","containerName":"new"},{"line":135,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$self"},{"name":"$class","containerName":"new","kind":13,"line":135},{"name":"@args","containerName":"new","kind":13,"line":135},{"line":136,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"_initialize_io","line":136,"kind":12},{"kind":13,"line":136,"containerName":"new","name":"@args"},{"localvar":"my","containerName":"new","definition":"my","name":"$factors","line":138,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":138},{"kind":12,"line":138,"name":"_rearrange","containerName":"new"},{"name":"@args","containerName":"new","kind":13,"line":138},{"name":"$factors","containerName":"new","line":140,"kind":13},{"containerName":"new","name":"$factors","line":140,"kind":13},{"name":"$factors","containerName":"new","line":141,"kind":13},{"line":141,"kind":13,"name":"$factors","containerName":"new"},{"containerName":"new","name":"$factors","line":144,"kind":13},{"kind":13,"line":146,"name":"$factors","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":146},{"kind":12,"line":146,"name":"factors","containerName":"new"},{"kind":13,"line":146,"containerName":"new","name":"$factors"},{"kind":13,"line":148,"name":"$self","containerName":"new"}],"line":132,"kind":12,"range":{"end":{"character":9999,"line":149},"start":{"line":132,"character":0}},"name":"new"},{"kind":12,"line":135,"name":"SUPER","containerName":"new"},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"documentation":"1;\n# $Id: ExtendedSignalp.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Signalp::ExtendedSignalp\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n#\n# Copyright Emmanuel Quevillon\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Signalp::ExtendedSignalp - enhanced parser for Signalp output\n\n=head1 SYNOPSIS\n\n use Bio::Tools::Signalp::ExtendedSignalp;\n my $params = [qw(maxC maxY maxS meanS D)];\n my $parser = new Bio::Tools::Signalp::ExtendedSignalp(\n                                                       -fh      => $filehandle\n                                                       -factors => $params\n                                                      );\n\n $parser->factors($params);\n while( my $sp_feat = $parser->next_feature ) {\n       #do something\n       #eg\n       push @sp_feat, $sp_feat;\n }\n\n=head1 DESCRIPTION\n\n# Please direct questions and support issues to I<bioperl-l@bioperl.org> \n\nParser module for Signalp.\n\nBased on the EnsEMBL module Bio::EnsEMBL::Pipeline::Runnable::Protein::Signalp\noriginally written by Marc Sohrmann (ms2 a sanger.ac.uk) Written in BioPipe by\nBalamurugan Kumarasamy (savikalpa a fugu-sg.org) Cared for by the Fugu\nInformatics team (fuguteam@fugu-sg.org)\n\nYou may distribute this module under the same terms as perl itself\n\nCompared to the original SignalP, this method allow the user to filter results\nout based on maxC maxY maxS meanS and D factor cutoff for the Neural Network (NN)\nmethod only. The HMM method does not give any filters with 'YES' or 'NO' as result.\n\nThe user must be aware that the filters can only by applied on NN method.\nAlso, to ensure the compability with original Signalp parsing module, the user\nmust know that by default, if filters are empty, max Y and mean S filters are\nautomatically used to filter results.\n\nIf the used gives a list, then the parser will only report protein having 'YES'\nfor each factor.\n\nThis module supports parsing for full, summary and short output form signalp.\nActually, full and summary are equivalent in terms of filtering results.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Based on the Bio::Tools::Signalp module\n Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n\n=head1 APPENDIX\n\n The rest of the documentation details each of the object methods.\n Internal methods are usually preceded with a _\n\n\npackage Bio::Tools::Signalp::ExtendedSignalp;\n\nuse strict;\nuse Data::Dumper;\nuse Bio::SeqFeature::Generic;\n# don't need Bio::Root::Root/IO (already in inheritance tree)\nuse base qw(Bio::Tools::Signalp Bio::Tools::AnalysisResult);\n\n#Supported arguments\nmy $FACTS = {\n\t     'maxC'  => 1,\n\t     'maxS'  => 1,\n\t     'maxY'  => 1,\n\t     'meanS' => 1,\n\t     'D'     => 1,\n\t    };\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Tools::Signalp::ExtendedSignalp();\n Function: Builds a new Bio::Tools::Signalp::ExtendedSignalp object\n Returns : Bio::Tools::Signalp::ExtendedSignalp\n Args    : -fh/-file => $val, # for initing input, see Bio::Root::IO\n\n\n\nsub new {\n      my($class,@args) = @_;\n\n      my $self = $class->SUPER::new(@args);\n      $self->_initialize_io(@args);\n\n      my $factors = $self->_rearrange([qw(FACTORS)], @args);\n      #To behave like the parent module (Bio::Tools::Signalp) we default factors to these two factors\n      if($factors && scalar(@$factors)){\n\t  $factors = $factors;\n      }\n      else{\n\t  $factors = [qw(maxY meanS)];\n      }\n      $factors && $self->factors($factors);\n\t\t\t\t\t\t\n      return $self;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : my $feat = $signalp->next_feature\n Function: Get the next result feature from parser data\n Returns : Bio::SeqFeature::Generic\n Args    : none","parameters":[{"label":"$self"}],"label":"next_feature($self)"},"kind":12,"line":162,"children":[{"containerName":"next_feature","definition":"my","name":"$self","localvar":"my","kind":13,"line":164},{"line":166,"kind":13,"name":"$self","containerName":"next_feature"},{"line":166,"kind":12,"name":"_parsed","containerName":"next_feature"},{"kind":13,"line":167,"name":"$self","containerName":"next_feature"},{"line":167,"kind":12,"containerName":"next_feature","name":"_parse"},{"name":"$self","containerName":"next_feature","line":170,"kind":13}],"name":"next_feature","range":{"start":{"line":162,"character":0},"end":{"line":170,"character":9999}}},{"kind":12,"line":170,"name":"_features"},{"detail":"($self,$hash)","signature":{"label":"_filterok($self,$hash)","documentation":"1;\n# $Id: ExtendedSignalp.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Signalp::ExtendedSignalp\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n#\n# Copyright Emmanuel Quevillon\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Signalp::ExtendedSignalp - enhanced parser for Signalp output\n\n=head1 SYNOPSIS\n\n use Bio::Tools::Signalp::ExtendedSignalp;\n my $params = [qw(maxC maxY maxS meanS D)];\n my $parser = new Bio::Tools::Signalp::ExtendedSignalp(\n                                                       -fh      => $filehandle\n                                                       -factors => $params\n                                                      );\n\n $parser->factors($params);\n while( my $sp_feat = $parser->next_feature ) {\n       #do something\n       #eg\n       push @sp_feat, $sp_feat;\n }\n\n=head1 DESCRIPTION\n\n# Please direct questions and support issues to I<bioperl-l@bioperl.org> \n\nParser module for Signalp.\n\nBased on the EnsEMBL module Bio::EnsEMBL::Pipeline::Runnable::Protein::Signalp\noriginally written by Marc Sohrmann (ms2 a sanger.ac.uk) Written in BioPipe by\nBalamurugan Kumarasamy (savikalpa a fugu-sg.org) Cared for by the Fugu\nInformatics team (fuguteam@fugu-sg.org)\n\nYou may distribute this module under the same terms as perl itself\n\nCompared to the original SignalP, this method allow the user to filter results\nout based on maxC maxY maxS meanS and D factor cutoff for the Neural Network (NN)\nmethod only. The HMM method does not give any filters with 'YES' or 'NO' as result.\n\nThe user must be aware that the filters can only by applied on NN method.\nAlso, to ensure the compability with original Signalp parsing module, the user\nmust know that by default, if filters are empty, max Y and mean S filters are\nautomatically used to filter results.\n\nIf the used gives a list, then the parser will only report protein having 'YES'\nfor each factor.\n\nThis module supports parsing for full, summary and short output form signalp.\nActually, full and summary are equivalent in terms of filtering results.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Based on the Bio::Tools::Signalp module\n Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n\n=head1 APPENDIX\n\n The rest of the documentation details each of the object methods.\n Internal methods are usually preceded with a _\n\n\npackage Bio::Tools::Signalp::ExtendedSignalp;\n\nuse strict;\nuse Data::Dumper;\nuse Bio::SeqFeature::Generic;\n# don't need Bio::Root::Root/IO (already in inheritance tree)\nuse base qw(Bio::Tools::Signalp Bio::Tools::AnalysisResult);\n\n#Supported arguments\nmy $FACTS = {\n\t     'maxC'  => 1,\n\t     'maxS'  => 1,\n\t     'maxY'  => 1,\n\t     'meanS' => 1,\n\t     'D'     => 1,\n\t    };\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Tools::Signalp::ExtendedSignalp();\n Function: Builds a new Bio::Tools::Signalp::ExtendedSignalp object\n Returns : Bio::Tools::Signalp::ExtendedSignalp\n Args    : -fh/-file => $val, # for initing input, see Bio::Root::IO\n\n\n\nsub new {\n      my($class,@args) = @_;\n\n      my $self = $class->SUPER::new(@args);\n      $self->_initialize_io(@args);\n\n      my $factors = $self->_rearrange([qw(FACTORS)], @args);\n      #To behave like the parent module (Bio::Tools::Signalp) we default factors to these two factors\n      if($factors && scalar(@$factors)){\n\t  $factors = $factors;\n      }\n      else{\n\t  $factors = [qw(maxY meanS)];\n      }\n      $factors && $self->factors($factors);\n\t\t\t\t\t\t\n      return $self;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : my $feat = $signalp->next_feature\n Function: Get the next result feature from parser data\n Returns : Bio::SeqFeature::Generic\n Args    : none\n\n\n\nsub next_feature {\n\n    my ($self) = @_;\n\n    if(!$self->_parsed()){\n\t$self->_parse();\n    }\n\n    return shift @{$self->{_features}} || undef;\n\n}\n\n=head2 _filterok\n\n Title   : _filterok\n Usage   : my $feat = $signalp->_filterok\n Function: Check if the factors required by the user are all ok.\n Returns : 1/0\n Args    : hash reference","parameters":[{"label":"$self"},{"label":"$hash"}]},"containerName":"main::","definition":"sub","line":185,"children":[{"kind":13,"line":187,"containerName":"_filterok","definition":"my","name":"$self","localvar":"my"},{"containerName":"_filterok","name":"$hash","line":187,"kind":13},{"line":190,"kind":13,"localvar":"my","name":"$bool","definition":"my","containerName":"_filterok"},{"name":"$bool","containerName":"_filterok","kind":13,"line":193},{"kind":13,"line":193,"name":"$self","containerName":"_filterok"}],"kind":12,"range":{"end":{"line":193,"character":9999},"start":{"line":185,"character":0}},"name":"_filterok"},{"name":"_factors","line":193,"kind":12},{"kind":13,"line":197,"containerName":null,"definition":"my","name":"$fact","localvar":"my"},{"containerName":null,"name":"$self","line":197,"kind":13},{"kind":12,"line":197,"containerName":"main::","name":"factors"},{"name":"%hash","containerName":null,"kind":13,"line":198},{"line":198,"kind":13,"name":"$fact","containerName":null},{"containerName":null,"name":"%hash","line":198,"kind":13},{"name":"%fact","containerName":null,"kind":13,"line":198},{"kind":13,"line":199,"containerName":null,"name":"$bool"},{"name":"$bool","containerName":null,"line":203,"kind":13},{"name":"factors","range":{"end":{"line":236,"character":9999},"start":{"line":218,"character":0}},"containerName":"main::","definition":"sub","detail":"($self,$array)","signature":{"label":"factors($self,$array)","parameters":[{"label":"$self"},{"label":"$array"}],"documentation":"1;\n# $Id: ExtendedSignalp.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Signalp::ExtendedSignalp\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n#\n# Copyright Emmanuel Quevillon\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Signalp::ExtendedSignalp - enhanced parser for Signalp output\n\n=head1 SYNOPSIS\n\n use Bio::Tools::Signalp::ExtendedSignalp;\n my $params = [qw(maxC maxY maxS meanS D)];\n my $parser = new Bio::Tools::Signalp::ExtendedSignalp(\n                                                       -fh      => $filehandle\n                                                       -factors => $params\n                                                      );\n\n $parser->factors($params);\n while( my $sp_feat = $parser->next_feature ) {\n       #do something\n       #eg\n       push @sp_feat, $sp_feat;\n }\n\n=head1 DESCRIPTION\n\n# Please direct questions and support issues to I<bioperl-l@bioperl.org> \n\nParser module for Signalp.\n\nBased on the EnsEMBL module Bio::EnsEMBL::Pipeline::Runnable::Protein::Signalp\noriginally written by Marc Sohrmann (ms2 a sanger.ac.uk) Written in BioPipe by\nBalamurugan Kumarasamy (savikalpa a fugu-sg.org) Cared for by the Fugu\nInformatics team (fuguteam@fugu-sg.org)\n\nYou may distribute this module under the same terms as perl itself\n\nCompared to the original SignalP, this method allow the user to filter results\nout based on maxC maxY maxS meanS and D factor cutoff for the Neural Network (NN)\nmethod only. The HMM method does not give any filters with 'YES' or 'NO' as result.\n\nThe user must be aware that the filters can only by applied on NN method.\nAlso, to ensure the compability with original Signalp parsing module, the user\nmust know that by default, if filters are empty, max Y and mean S filters are\nautomatically used to filter results.\n\nIf the used gives a list, then the parser will only report protein having 'YES'\nfor each factor.\n\nThis module supports parsing for full, summary and short output form signalp.\nActually, full and summary are equivalent in terms of filtering results.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Based on the Bio::Tools::Signalp module\n Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n\n=head1 APPENDIX\n\n The rest of the documentation details each of the object methods.\n Internal methods are usually preceded with a _\n\n\npackage Bio::Tools::Signalp::ExtendedSignalp;\n\nuse strict;\nuse Data::Dumper;\nuse Bio::SeqFeature::Generic;\n# don't need Bio::Root::Root/IO (already in inheritance tree)\nuse base qw(Bio::Tools::Signalp Bio::Tools::AnalysisResult);\n\n#Supported arguments\nmy $FACTS = {\n\t     'maxC'  => 1,\n\t     'maxS'  => 1,\n\t     'maxY'  => 1,\n\t     'meanS' => 1,\n\t     'D'     => 1,\n\t    };\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Tools::Signalp::ExtendedSignalp();\n Function: Builds a new Bio::Tools::Signalp::ExtendedSignalp object\n Returns : Bio::Tools::Signalp::ExtendedSignalp\n Args    : -fh/-file => $val, # for initing input, see Bio::Root::IO\n\n\n\nsub new {\n      my($class,@args) = @_;\n\n      my $self = $class->SUPER::new(@args);\n      $self->_initialize_io(@args);\n\n      my $factors = $self->_rearrange([qw(FACTORS)], @args);\n      #To behave like the parent module (Bio::Tools::Signalp) we default factors to these two factors\n      if($factors && scalar(@$factors)){\n\t  $factors = $factors;\n      }\n      else{\n\t  $factors = [qw(maxY meanS)];\n      }\n      $factors && $self->factors($factors);\n\t\t\t\t\t\t\n      return $self;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : my $feat = $signalp->next_feature\n Function: Get the next result feature from parser data\n Returns : Bio::SeqFeature::Generic\n Args    : none\n\n\n\nsub next_feature {\n\n    my ($self) = @_;\n\n    if(!$self->_parsed()){\n\t$self->_parse();\n    }\n\n    return shift @{$self->{_features}} || undef;\n\n}\n\n=head2 _filterok\n\n Title   : _filterok\n Usage   : my $feat = $signalp->_filterok\n Function: Check if the factors required by the user are all ok.\n Returns : 1/0\n Args    : hash reference\n\n\n\nsub _filterok {\n\n    my($self, $hash) = @_;\n\n    #We hope everything will be fine ;)\n    my $bool = 1;\n\n    #If the user did not give any filter, we keep eveything\n    return $bool unless keys %{$self->{_factors}};\n\n    #If only one of the factors parsed is equal to NO based on the user factors cutoff\n    #Then the filter is not ok.\n    foreach my $fact (keys %{$self->factors()}){\n\tif(exists($hash->{$fact}) && $hash->{$fact} =~ /^N/){\n\t    $bool = 0;\n\t}\n    }\n\n    return $bool;\n\n}\n\n=head2 factors\n\n Title   : factors\n Usage   : my $feat = $signalp->factors\n Function: Get/Set the filters required from the user\n Returns : hash\n Args    : array reference"},"kind":12,"line":218,"children":[{"kind":13,"line":220,"containerName":"factors","name":"$self","definition":"my","localvar":"my"},{"containerName":"factors","name":"$array","kind":13,"line":220},{"kind":13,"line":222,"name":"$array","containerName":"factors"},{"containerName":"factors","name":"$self","line":223,"kind":13},{"kind":13,"line":224,"containerName":"factors","definition":"my","name":"$f","localvar":"my"},{"containerName":"factors","name":"$array","line":224,"kind":13},{"name":"$FACTS","containerName":"factors","line":225,"kind":13},{"line":225,"kind":13,"name":"$f","containerName":"factors"},{"containerName":"factors","name":"$self","line":226,"kind":13},{"containerName":"factors","name":"$f","line":226,"kind":13},{"kind":13,"line":229,"containerName":"factors","name":"$self"},{"containerName":"factors","name":"throw","line":229,"kind":12},{"kind":13,"line":229,"containerName":"factors","name":"$FACTS"},{"name":"$self","containerName":"factors","line":234,"kind":13}]},{"kind":12,"line":223,"name":"_factors"},{"name":"_factors","kind":12,"line":226},{"line":234,"kind":12,"name":"_factors"},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$parsed"}],"documentation":"1;\n# $Id: ExtendedSignalp.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Signalp::ExtendedSignalp\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n#\n# Copyright Emmanuel Quevillon\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Signalp::ExtendedSignalp - enhanced parser for Signalp output\n\n=head1 SYNOPSIS\n\n use Bio::Tools::Signalp::ExtendedSignalp;\n my $params = [qw(maxC maxY maxS meanS D)];\n my $parser = new Bio::Tools::Signalp::ExtendedSignalp(\n                                                       -fh      => $filehandle\n                                                       -factors => $params\n                                                      );\n\n $parser->factors($params);\n while( my $sp_feat = $parser->next_feature ) {\n       #do something\n       #eg\n       push @sp_feat, $sp_feat;\n }\n\n=head1 DESCRIPTION\n\n# Please direct questions and support issues to I<bioperl-l@bioperl.org> \n\nParser module for Signalp.\n\nBased on the EnsEMBL module Bio::EnsEMBL::Pipeline::Runnable::Protein::Signalp\noriginally written by Marc Sohrmann (ms2 a sanger.ac.uk) Written in BioPipe by\nBalamurugan Kumarasamy (savikalpa a fugu-sg.org) Cared for by the Fugu\nInformatics team (fuguteam@fugu-sg.org)\n\nYou may distribute this module under the same terms as perl itself\n\nCompared to the original SignalP, this method allow the user to filter results\nout based on maxC maxY maxS meanS and D factor cutoff for the Neural Network (NN)\nmethod only. The HMM method does not give any filters with 'YES' or 'NO' as result.\n\nThe user must be aware that the filters can only by applied on NN method.\nAlso, to ensure the compability with original Signalp parsing module, the user\nmust know that by default, if filters are empty, max Y and mean S filters are\nautomatically used to filter results.\n\nIf the used gives a list, then the parser will only report protein having 'YES'\nfor each factor.\n\nThis module supports parsing for full, summary and short output form signalp.\nActually, full and summary are equivalent in terms of filtering results.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Based on the Bio::Tools::Signalp module\n Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n\n=head1 APPENDIX\n\n The rest of the documentation details each of the object methods.\n Internal methods are usually preceded with a _\n\n\npackage Bio::Tools::Signalp::ExtendedSignalp;\n\nuse strict;\nuse Data::Dumper;\nuse Bio::SeqFeature::Generic;\n# don't need Bio::Root::Root/IO (already in inheritance tree)\nuse base qw(Bio::Tools::Signalp Bio::Tools::AnalysisResult);\n\n#Supported arguments\nmy $FACTS = {\n\t     'maxC'  => 1,\n\t     'maxS'  => 1,\n\t     'maxY'  => 1,\n\t     'meanS' => 1,\n\t     'D'     => 1,\n\t    };\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Tools::Signalp::ExtendedSignalp();\n Function: Builds a new Bio::Tools::Signalp::ExtendedSignalp object\n Returns : Bio::Tools::Signalp::ExtendedSignalp\n Args    : -fh/-file => $val, # for initing input, see Bio::Root::IO\n\n\n\nsub new {\n      my($class,@args) = @_;\n\n      my $self = $class->SUPER::new(@args);\n      $self->_initialize_io(@args);\n\n      my $factors = $self->_rearrange([qw(FACTORS)], @args);\n      #To behave like the parent module (Bio::Tools::Signalp) we default factors to these two factors\n      if($factors && scalar(@$factors)){\n\t  $factors = $factors;\n      }\n      else{\n\t  $factors = [qw(maxY meanS)];\n      }\n      $factors && $self->factors($factors);\n\t\t\t\t\t\t\n      return $self;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : my $feat = $signalp->next_feature\n Function: Get the next result feature from parser data\n Returns : Bio::SeqFeature::Generic\n Args    : none\n\n\n\nsub next_feature {\n\n    my ($self) = @_;\n\n    if(!$self->_parsed()){\n\t$self->_parse();\n    }\n\n    return shift @{$self->{_features}} || undef;\n\n}\n\n=head2 _filterok\n\n Title   : _filterok\n Usage   : my $feat = $signalp->_filterok\n Function: Check if the factors required by the user are all ok.\n Returns : 1/0\n Args    : hash reference\n\n\n\nsub _filterok {\n\n    my($self, $hash) = @_;\n\n    #We hope everything will be fine ;)\n    my $bool = 1;\n\n    #If the user did not give any filter, we keep eveything\n    return $bool unless keys %{$self->{_factors}};\n\n    #If only one of the factors parsed is equal to NO based on the user factors cutoff\n    #Then the filter is not ok.\n    foreach my $fact (keys %{$self->factors()}){\n\tif(exists($hash->{$fact}) && $hash->{$fact} =~ /^N/){\n\t    $bool = 0;\n\t}\n    }\n\n    return $bool;\n\n}\n\n=head2 factors\n\n Title   : factors\n Usage   : my $feat = $signalp->factors\n Function: Get/Set the filters required from the user\n Returns : hash\n Args    : array reference\n\n\n\nsub factors {\n\n    my($self, $array) = @_;\n\n    if($array){\n\t$self->{_factors} = { };\n\tforeach my $f (@$array){\n\t    if(exists($FACTS->{$f})){\n\t\t$self->{_factors}->{$f} = 1;\n\t    }\n\t    else{\n\t\t$self->throw(\"[$f] incorrect factor. Supported:\\n- \".join(\"\\n- \", keys %$FACTS).\"\\n\");\n\t    }\n\t}\n    }\n\n    return $self->{_factors};\n\n}\n\n=head2 _parsed\n\n Title   : _parsed\n Usage   : obj->_parsed()\n Function: Get/Set if the result is parsed or not\n Returns : 1/0 scalar\n Args    : On set 1","label":"_parsed($self,$parsed)"},"detail":"($self,$parsed)","kind":12,"children":[{"containerName":"_parsed","name":"$self","definition":"my","localvar":"my","kind":13,"line":251},{"kind":13,"line":251,"name":"$parsed","containerName":"_parsed"},{"name":"$parsed","containerName":"_parsed","kind":13,"line":253},{"containerName":"_parsed","name":"$self","line":254,"kind":13},{"containerName":"_parsed","name":"$parsed","kind":13,"line":254},{"line":257,"kind":13,"name":"$self","containerName":"_parsed"}],"line":249,"name":"_parsed","range":{"start":{"character":0,"line":249},"end":{"character":9999,"line":259}}},{"line":254,"kind":12,"name":"_parsed"},{"name":"_parsed","line":257,"kind":12},{"name":"_parse","range":{"start":{"character":0,"line":272},"end":{"character":9999,"line":300}},"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: ExtendedSignalp.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Signalp::ExtendedSignalp\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n#\n# Copyright Emmanuel Quevillon\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Signalp::ExtendedSignalp - enhanced parser for Signalp output\n\n=head1 SYNOPSIS\n\n use Bio::Tools::Signalp::ExtendedSignalp;\n my $params = [qw(maxC maxY maxS meanS D)];\n my $parser = new Bio::Tools::Signalp::ExtendedSignalp(\n                                                       -fh      => $filehandle\n                                                       -factors => $params\n                                                      );\n\n $parser->factors($params);\n while( my $sp_feat = $parser->next_feature ) {\n       #do something\n       #eg\n       push @sp_feat, $sp_feat;\n }\n\n=head1 DESCRIPTION\n\n# Please direct questions and support issues to I<bioperl-l@bioperl.org> \n\nParser module for Signalp.\n\nBased on the EnsEMBL module Bio::EnsEMBL::Pipeline::Runnable::Protein::Signalp\noriginally written by Marc Sohrmann (ms2 a sanger.ac.uk) Written in BioPipe by\nBalamurugan Kumarasamy (savikalpa a fugu-sg.org) Cared for by the Fugu\nInformatics team (fuguteam@fugu-sg.org)\n\nYou may distribute this module under the same terms as perl itself\n\nCompared to the original SignalP, this method allow the user to filter results\nout based on maxC maxY maxS meanS and D factor cutoff for the Neural Network (NN)\nmethod only. The HMM method does not give any filters with 'YES' or 'NO' as result.\n\nThe user must be aware that the filters can only by applied on NN method.\nAlso, to ensure the compability with original Signalp parsing module, the user\nmust know that by default, if filters are empty, max Y and mean S filters are\nautomatically used to filter results.\n\nIf the used gives a list, then the parser will only report protein having 'YES'\nfor each factor.\n\nThis module supports parsing for full, summary and short output form signalp.\nActually, full and summary are equivalent in terms of filtering results.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Based on the Bio::Tools::Signalp module\n Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n\n=head1 APPENDIX\n\n The rest of the documentation details each of the object methods.\n Internal methods are usually preceded with a _\n\n\npackage Bio::Tools::Signalp::ExtendedSignalp;\n\nuse strict;\nuse Data::Dumper;\nuse Bio::SeqFeature::Generic;\n# don't need Bio::Root::Root/IO (already in inheritance tree)\nuse base qw(Bio::Tools::Signalp Bio::Tools::AnalysisResult);\n\n#Supported arguments\nmy $FACTS = {\n\t     'maxC'  => 1,\n\t     'maxS'  => 1,\n\t     'maxY'  => 1,\n\t     'meanS' => 1,\n\t     'D'     => 1,\n\t    };\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Tools::Signalp::ExtendedSignalp();\n Function: Builds a new Bio::Tools::Signalp::ExtendedSignalp object\n Returns : Bio::Tools::Signalp::ExtendedSignalp\n Args    : -fh/-file => $val, # for initing input, see Bio::Root::IO\n\n\n\nsub new {\n      my($class,@args) = @_;\n\n      my $self = $class->SUPER::new(@args);\n      $self->_initialize_io(@args);\n\n      my $factors = $self->_rearrange([qw(FACTORS)], @args);\n      #To behave like the parent module (Bio::Tools::Signalp) we default factors to these two factors\n      if($factors && scalar(@$factors)){\n\t  $factors = $factors;\n      }\n      else{\n\t  $factors = [qw(maxY meanS)];\n      }\n      $factors && $self->factors($factors);\n\t\t\t\t\t\t\n      return $self;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : my $feat = $signalp->next_feature\n Function: Get the next result feature from parser data\n Returns : Bio::SeqFeature::Generic\n Args    : none\n\n\n\nsub next_feature {\n\n    my ($self) = @_;\n\n    if(!$self->_parsed()){\n\t$self->_parse();\n    }\n\n    return shift @{$self->{_features}} || undef;\n\n}\n\n=head2 _filterok\n\n Title   : _filterok\n Usage   : my $feat = $signalp->_filterok\n Function: Check if the factors required by the user are all ok.\n Returns : 1/0\n Args    : hash reference\n\n\n\nsub _filterok {\n\n    my($self, $hash) = @_;\n\n    #We hope everything will be fine ;)\n    my $bool = 1;\n\n    #If the user did not give any filter, we keep eveything\n    return $bool unless keys %{$self->{_factors}};\n\n    #If only one of the factors parsed is equal to NO based on the user factors cutoff\n    #Then the filter is not ok.\n    foreach my $fact (keys %{$self->factors()}){\n\tif(exists($hash->{$fact}) && $hash->{$fact} =~ /^N/){\n\t    $bool = 0;\n\t}\n    }\n\n    return $bool;\n\n}\n\n=head2 factors\n\n Title   : factors\n Usage   : my $feat = $signalp->factors\n Function: Get/Set the filters required from the user\n Returns : hash\n Args    : array reference\n\n\n\nsub factors {\n\n    my($self, $array) = @_;\n\n    if($array){\n\t$self->{_factors} = { };\n\tforeach my $f (@$array){\n\t    if(exists($FACTS->{$f})){\n\t\t$self->{_factors}->{$f} = 1;\n\t    }\n\t    else{\n\t\t$self->throw(\"[$f] incorrect factor. Supported:\\n- \".join(\"\\n- \", keys %$FACTS).\"\\n\");\n\t    }\n\t}\n    }\n\n    return $self->{_factors};\n\n}\n\n=head2 _parsed\n\n Title   : _parsed\n Usage   : obj->_parsed()\n Function: Get/Set if the result is parsed or not\n Returns : 1/0 scalar\n Args    : On set 1\n\n\n\nsub _parsed {\n\n    my($self, $parsed) = @_;\n\n    if(defined($parsed)){\n\t$self->{_parsed} = $parsed;\n    }\n\n    return $self->{_parsed};\n\n}\n\n=head2 _parse\n\n Title   : _parse\n Usage   : obj->_parse\n Function: Parse the SignalP result\n Returns :\n Args    :","parameters":[{"label":"$self"}],"label":"_parse($self)"},"detail":"($self)","kind":12,"children":[{"line":274,"kind":13,"localvar":"my","containerName":"_parse","definition":"my","name":"$self"},{"line":277,"kind":13,"localvar":"my","name":"$line","definition":"my","containerName":"_parse"},{"line":277,"kind":13,"containerName":"_parse","name":"$self"},{"name":"_readline","containerName":"_parse","line":277,"kind":12},{"name":"$line","containerName":"_parse","kind":13,"line":279},{"line":282,"kind":13,"containerName":"_parse","name":"$line"},{"name":"$line","containerName":"_parse","kind":13,"line":284},{"name":"$self","containerName":"_parse","kind":13,"line":285},{"kind":12,"line":285,"containerName":"_parse","name":"_pushback"},{"line":285,"kind":13,"containerName":"_parse","name":"$line"},{"containerName":"_parse","name":"$self","line":286,"kind":13},{"kind":12,"line":286,"containerName":"_parse","name":"_parse_summary_format"},{"line":289,"kind":13,"containerName":"_parse","name":"$line"},{"kind":13,"line":290,"name":"$self","containerName":"_parse"},{"kind":12,"line":290,"name":"_pushback","containerName":"_parse"},{"name":"$line","containerName":"_parse","line":290,"kind":13},{"line":291,"kind":13,"name":"$self","containerName":"_parse"},{"containerName":"_parse","name":"_parse_short_format","kind":12,"line":291},{"containerName":"_parse","name":"$self","line":295,"kind":13},{"containerName":"_parse","name":"throw","kind":12,"line":295}],"line":272},{"name":"_parse_summary_format","range":{"start":{"character":0,"line":313},"end":{"character":9999,"line":336}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"_parse_summary_format($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: ExtendedSignalp.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Signalp::ExtendedSignalp\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n#\n# Copyright Emmanuel Quevillon\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Signalp::ExtendedSignalp - enhanced parser for Signalp output\n\n=head1 SYNOPSIS\n\n use Bio::Tools::Signalp::ExtendedSignalp;\n my $params = [qw(maxC maxY maxS meanS D)];\n my $parser = new Bio::Tools::Signalp::ExtendedSignalp(\n                                                       -fh      => $filehandle\n                                                       -factors => $params\n                                                      );\n\n $parser->factors($params);\n while( my $sp_feat = $parser->next_feature ) {\n       #do something\n       #eg\n       push @sp_feat, $sp_feat;\n }\n\n=head1 DESCRIPTION\n\n# Please direct questions and support issues to I<bioperl-l@bioperl.org> \n\nParser module for Signalp.\n\nBased on the EnsEMBL module Bio::EnsEMBL::Pipeline::Runnable::Protein::Signalp\noriginally written by Marc Sohrmann (ms2 a sanger.ac.uk) Written in BioPipe by\nBalamurugan Kumarasamy (savikalpa a fugu-sg.org) Cared for by the Fugu\nInformatics team (fuguteam@fugu-sg.org)\n\nYou may distribute this module under the same terms as perl itself\n\nCompared to the original SignalP, this method allow the user to filter results\nout based on maxC maxY maxS meanS and D factor cutoff for the Neural Network (NN)\nmethod only. The HMM method does not give any filters with 'YES' or 'NO' as result.\n\nThe user must be aware that the filters can only by applied on NN method.\nAlso, to ensure the compability with original Signalp parsing module, the user\nmust know that by default, if filters are empty, max Y and mean S filters are\nautomatically used to filter results.\n\nIf the used gives a list, then the parser will only report protein having 'YES'\nfor each factor.\n\nThis module supports parsing for full, summary and short output form signalp.\nActually, full and summary are equivalent in terms of filtering results.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Based on the Bio::Tools::Signalp module\n Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n\n=head1 APPENDIX\n\n The rest of the documentation details each of the object methods.\n Internal methods are usually preceded with a _\n\n\npackage Bio::Tools::Signalp::ExtendedSignalp;\n\nuse strict;\nuse Data::Dumper;\nuse Bio::SeqFeature::Generic;\n# don't need Bio::Root::Root/IO (already in inheritance tree)\nuse base qw(Bio::Tools::Signalp Bio::Tools::AnalysisResult);\n\n#Supported arguments\nmy $FACTS = {\n\t     'maxC'  => 1,\n\t     'maxS'  => 1,\n\t     'maxY'  => 1,\n\t     'meanS' => 1,\n\t     'D'     => 1,\n\t    };\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Tools::Signalp::ExtendedSignalp();\n Function: Builds a new Bio::Tools::Signalp::ExtendedSignalp object\n Returns : Bio::Tools::Signalp::ExtendedSignalp\n Args    : -fh/-file => $val, # for initing input, see Bio::Root::IO\n\n\n\nsub new {\n      my($class,@args) = @_;\n\n      my $self = $class->SUPER::new(@args);\n      $self->_initialize_io(@args);\n\n      my $factors = $self->_rearrange([qw(FACTORS)], @args);\n      #To behave like the parent module (Bio::Tools::Signalp) we default factors to these two factors\n      if($factors && scalar(@$factors)){\n\t  $factors = $factors;\n      }\n      else{\n\t  $factors = [qw(maxY meanS)];\n      }\n      $factors && $self->factors($factors);\n\t\t\t\t\t\t\n      return $self;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : my $feat = $signalp->next_feature\n Function: Get the next result feature from parser data\n Returns : Bio::SeqFeature::Generic\n Args    : none\n\n\n\nsub next_feature {\n\n    my ($self) = @_;\n\n    if(!$self->_parsed()){\n\t$self->_parse();\n    }\n\n    return shift @{$self->{_features}} || undef;\n\n}\n\n=head2 _filterok\n\n Title   : _filterok\n Usage   : my $feat = $signalp->_filterok\n Function: Check if the factors required by the user are all ok.\n Returns : 1/0\n Args    : hash reference\n\n\n\nsub _filterok {\n\n    my($self, $hash) = @_;\n\n    #We hope everything will be fine ;)\n    my $bool = 1;\n\n    #If the user did not give any filter, we keep eveything\n    return $bool unless keys %{$self->{_factors}};\n\n    #If only one of the factors parsed is equal to NO based on the user factors cutoff\n    #Then the filter is not ok.\n    foreach my $fact (keys %{$self->factors()}){\n\tif(exists($hash->{$fact}) && $hash->{$fact} =~ /^N/){\n\t    $bool = 0;\n\t}\n    }\n\n    return $bool;\n\n}\n\n=head2 factors\n\n Title   : factors\n Usage   : my $feat = $signalp->factors\n Function: Get/Set the filters required from the user\n Returns : hash\n Args    : array reference\n\n\n\nsub factors {\n\n    my($self, $array) = @_;\n\n    if($array){\n\t$self->{_factors} = { };\n\tforeach my $f (@$array){\n\t    if(exists($FACTS->{$f})){\n\t\t$self->{_factors}->{$f} = 1;\n\t    }\n\t    else{\n\t\t$self->throw(\"[$f] incorrect factor. Supported:\\n- \".join(\"\\n- \", keys %$FACTS).\"\\n\");\n\t    }\n\t}\n    }\n\n    return $self->{_factors};\n\n}\n\n=head2 _parsed\n\n Title   : _parsed\n Usage   : obj->_parsed()\n Function: Get/Set if the result is parsed or not\n Returns : 1/0 scalar\n Args    : On set 1\n\n\n\nsub _parsed {\n\n    my($self, $parsed) = @_;\n\n    if(defined($parsed)){\n\t$self->{_parsed} = $parsed;\n    }\n\n    return $self->{_parsed};\n\n}\n\n=head2 _parse\n\n Title   : _parse\n Usage   : obj->_parse\n Function: Parse the SignalP result\n Returns :\n Args    :\n\n\n\nsub _parse {\n\n    my($self) = @_;\n\n    #Let's read the file...\n    while (my $line = $self->_readline()) {\n\n\tchomp $line;\n\t#We want to be sure to catch the first non empty line to be ablte to determine\n\t#which format we are working with...\n\tnext unless ($line =~ /^>(\\S+)|^# SignalP-[NHM]+ \\S+ predictions/);\n\n\tif($line =~ /^>(\\S+)/){\n\t    $self->_pushback($line);\n\t    $self->_parse_summary_format();\n\t    last;\n\t}\n\telsif($line =~ /^# SignalP-[NHM]+ \\S+ predictions/){\n\t    $self->_pushback($line);\n\t    $self->_parse_short_format();\n\t    last;\n\t}\n\telse{\n\t    $self->throw(\"Unable to determine the format type.\");\n\t}\n    }\n\n    return;\n}\n\n=head2 _parse_summary_format\n\n Title   : _parse_summary_format\n Usage   : $self->_parse_summary_format\n Function: Method to parse summary/full format from signalp output\n           It automatically fills filtered features.\n Returns :\n Args    :"},"kind":12,"line":313,"children":[{"containerName":"_parse_summary_format","name":"$self","definition":"my","localvar":"my","kind":13,"line":315},{"containerName":"_parse_summary_format","name":"$feature","definition":"my","localvar":"my","kind":13,"line":317},{"definition":"my","name":"$ok","containerName":"_parse_summary_format","localvar":"my","kind":13,"line":318},{"definition":"my","name":"$line","containerName":"_parse_summary_format","localvar":"my","kind":13,"line":320},{"line":320,"kind":13,"name":"$self","containerName":"_parse_summary_format"},{"containerName":"_parse_summary_format","name":"_readline","line":320,"kind":12},{"name":"$line","containerName":"_parse_summary_format","kind":13,"line":322},{"kind":13,"line":323,"name":"$self","containerName":"_parse_summary_format"},{"kind":12,"line":323,"name":"_pushback","containerName":"_parse_summary_format"},{"line":323,"kind":13,"name":"$line","containerName":"_parse_summary_format"},{"name":"$feature","containerName":"_parse_summary_format","line":324,"kind":13},{"line":324,"kind":13,"containerName":"_parse_summary_format","name":"$self"},{"containerName":"_parse_summary_format","name":"_parse_nn_result","line":324,"kind":12},{"line":324,"kind":13,"name":"$feature","containerName":"_parse_summary_format"},{"line":326,"kind":13,"name":"$line","containerName":"_parse_summary_format"},{"containerName":"_parse_summary_format","name":"$self","line":327,"kind":13},{"kind":12,"line":327,"containerName":"_parse_summary_format","name":"_pushback"},{"containerName":"_parse_summary_format","name":"$line","kind":13,"line":327},{"containerName":"_parse_summary_format","name":"$feature","kind":13,"line":328},{"name":"$self","containerName":"_parse_summary_format","kind":13,"line":328},{"line":328,"kind":12,"name":"_parse_hmm_result","containerName":"_parse_summary_format"},{"name":"$feature","containerName":"_parse_summary_format","line":328,"kind":13},{"containerName":"_parse_summary_format","name":"$line","kind":13,"line":331},{"kind":13,"line":331,"containerName":"_parse_summary_format","name":"$feature"},{"kind":13,"line":332,"containerName":"_parse_summary_format","definition":"my","name":"$new_feature","localvar":"my"},{"containerName":"_parse_summary_format","name":"$self","line":332,"kind":13},{"containerName":"_parse_summary_format","name":"create_feature","line":332,"kind":12},{"name":"$feature","containerName":"_parse_summary_format","line":332,"kind":13},{"containerName":"_parse_summary_format","name":"$self","line":333,"kind":13},{"line":333,"kind":13,"containerName":"_parse_summary_format","name":"$new_feature"},{"name":"$new_feature","containerName":"_parse_summary_format","kind":13,"line":333},{"containerName":"_parse_summary_format","name":"$feature","line":334,"kind":13}]},{"name":"_features","kind":12,"line":333},{"kind":12,"line":353,"children":[{"line":355,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_parse_nn_result"},{"name":"$feature","containerName":"_parse_nn_result","kind":13,"line":355},{"kind":13,"line":357,"containerName":"_parse_nn_result","definition":"my","name":"$ok","localvar":"my"},{"line":358,"kind":13,"localvar":"my","name":"%facts","definition":"my","containerName":"_parse_nn_result"},{"definition":"my","name":"$line","containerName":"_parse_nn_result","localvar":"my","kind":13,"line":369},{"name":"$self","containerName":"_parse_nn_result","line":369,"kind":13},{"containerName":"_parse_nn_result","name":"_readline","kind":12,"line":369},{"line":371,"kind":13,"containerName":"_parse_nn_result","name":"$line"},{"containerName":"_parse_nn_result","name":"$line","line":373,"kind":13},{"containerName":"_parse_nn_result","name":"$ok","kind":13,"line":374},{"kind":13,"line":378,"name":"$self","containerName":"_parse_nn_result"},{"containerName":"_parse_nn_result","name":"throw","kind":12,"line":378},{"line":378,"kind":13,"containerName":"_parse_nn_result","name":"$ok"},{"line":380,"kind":13,"containerName":"_parse_nn_result","name":"$line"},{"containerName":"_parse_nn_result","name":"$self","line":381,"kind":13},{"line":381,"kind":12,"containerName":"_parse_nn_result","name":"seqname"},{"containerName":"_parse_nn_result","name":"%facts","kind":13,"line":382},{"kind":13,"line":385,"name":"$line","containerName":"_parse_nn_result"},{"line":386,"kind":13,"name":"$feature","containerName":"_parse_nn_result"},{"containerName":"_parse_nn_result","name":"$facts","kind":13,"line":387},{"name":"$line","containerName":"_parse_nn_result","line":390,"kind":13},{"line":391,"kind":13,"name":"$feature","containerName":"_parse_nn_result"},{"containerName":"_parse_nn_result","name":"$facts","kind":13,"line":392},{"kind":13,"line":395,"name":"$line","containerName":"_parse_nn_result"},{"line":396,"kind":13,"name":"$feature","containerName":"_parse_nn_result"},{"containerName":"_parse_nn_result","name":"$facts","line":397,"kind":13},{"line":400,"kind":13,"containerName":"_parse_nn_result","name":"$line"},{"containerName":"_parse_nn_result","name":"$feature","line":401,"kind":13},{"name":"$facts","containerName":"_parse_nn_result","kind":13,"line":402},{"line":405,"kind":13,"containerName":"_parse_nn_result","name":"$line"},{"containerName":"_parse_nn_result","name":"$feature","line":406,"kind":13},{"containerName":"_parse_nn_result","name":"$facts","kind":13,"line":407},{"name":"$line","containerName":"_parse_nn_result","kind":13,"line":411},{"kind":13,"line":415,"name":"$feature","containerName":"_parse_nn_result"},{"containerName":"_parse_nn_result","name":"$line","line":419,"kind":13},{"name":"$self","containerName":"_parse_nn_result","line":424,"kind":13},{"line":424,"kind":12,"containerName":"_parse_nn_result","name":"_filterok"},{"kind":13,"line":424,"name":"%facts","containerName":"_parse_nn_result"},{"line":425,"kind":13,"containerName":"_parse_nn_result","name":"$feature"},{"kind":13,"line":425,"name":"$self","containerName":"_parse_nn_result"},{"name":"seqname","containerName":"_parse_nn_result","line":425,"kind":12},{"name":"$feature","containerName":"_parse_nn_result","kind":13,"line":426},{"containerName":"_parse_nn_result","name":"$feature","kind":13,"line":427},{"name":"$feature","containerName":"_parse_nn_result","line":430,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$feature)","signature":{"documentation":"1;\n# $Id: ExtendedSignalp.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Signalp::ExtendedSignalp\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n#\n# Copyright Emmanuel Quevillon\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Signalp::ExtendedSignalp - enhanced parser for Signalp output\n\n=head1 SYNOPSIS\n\n use Bio::Tools::Signalp::ExtendedSignalp;\n my $params = [qw(maxC maxY maxS meanS D)];\n my $parser = new Bio::Tools::Signalp::ExtendedSignalp(\n                                                       -fh      => $filehandle\n                                                       -factors => $params\n                                                      );\n\n $parser->factors($params);\n while( my $sp_feat = $parser->next_feature ) {\n       #do something\n       #eg\n       push @sp_feat, $sp_feat;\n }\n\n=head1 DESCRIPTION\n\n# Please direct questions and support issues to I<bioperl-l@bioperl.org> \n\nParser module for Signalp.\n\nBased on the EnsEMBL module Bio::EnsEMBL::Pipeline::Runnable::Protein::Signalp\noriginally written by Marc Sohrmann (ms2 a sanger.ac.uk) Written in BioPipe by\nBalamurugan Kumarasamy (savikalpa a fugu-sg.org) Cared for by the Fugu\nInformatics team (fuguteam@fugu-sg.org)\n\nYou may distribute this module under the same terms as perl itself\n\nCompared to the original SignalP, this method allow the user to filter results\nout based on maxC maxY maxS meanS and D factor cutoff for the Neural Network (NN)\nmethod only. The HMM method does not give any filters with 'YES' or 'NO' as result.\n\nThe user must be aware that the filters can only by applied on NN method.\nAlso, to ensure the compability with original Signalp parsing module, the user\nmust know that by default, if filters are empty, max Y and mean S filters are\nautomatically used to filter results.\n\nIf the used gives a list, then the parser will only report protein having 'YES'\nfor each factor.\n\nThis module supports parsing for full, summary and short output form signalp.\nActually, full and summary are equivalent in terms of filtering results.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Based on the Bio::Tools::Signalp module\n Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n\n=head1 APPENDIX\n\n The rest of the documentation details each of the object methods.\n Internal methods are usually preceded with a _\n\n\npackage Bio::Tools::Signalp::ExtendedSignalp;\n\nuse strict;\nuse Data::Dumper;\nuse Bio::SeqFeature::Generic;\n# don't need Bio::Root::Root/IO (already in inheritance tree)\nuse base qw(Bio::Tools::Signalp Bio::Tools::AnalysisResult);\n\n#Supported arguments\nmy $FACTS = {\n\t     'maxC'  => 1,\n\t     'maxS'  => 1,\n\t     'maxY'  => 1,\n\t     'meanS' => 1,\n\t     'D'     => 1,\n\t    };\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Tools::Signalp::ExtendedSignalp();\n Function: Builds a new Bio::Tools::Signalp::ExtendedSignalp object\n Returns : Bio::Tools::Signalp::ExtendedSignalp\n Args    : -fh/-file => $val, # for initing input, see Bio::Root::IO\n\n\n\nsub new {\n      my($class,@args) = @_;\n\n      my $self = $class->SUPER::new(@args);\n      $self->_initialize_io(@args);\n\n      my $factors = $self->_rearrange([qw(FACTORS)], @args);\n      #To behave like the parent module (Bio::Tools::Signalp) we default factors to these two factors\n      if($factors && scalar(@$factors)){\n\t  $factors = $factors;\n      }\n      else{\n\t  $factors = [qw(maxY meanS)];\n      }\n      $factors && $self->factors($factors);\n\t\t\t\t\t\t\n      return $self;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : my $feat = $signalp->next_feature\n Function: Get the next result feature from parser data\n Returns : Bio::SeqFeature::Generic\n Args    : none\n\n\n\nsub next_feature {\n\n    my ($self) = @_;\n\n    if(!$self->_parsed()){\n\t$self->_parse();\n    }\n\n    return shift @{$self->{_features}} || undef;\n\n}\n\n=head2 _filterok\n\n Title   : _filterok\n Usage   : my $feat = $signalp->_filterok\n Function: Check if the factors required by the user are all ok.\n Returns : 1/0\n Args    : hash reference\n\n\n\nsub _filterok {\n\n    my($self, $hash) = @_;\n\n    #We hope everything will be fine ;)\n    my $bool = 1;\n\n    #If the user did not give any filter, we keep eveything\n    return $bool unless keys %{$self->{_factors}};\n\n    #If only one of the factors parsed is equal to NO based on the user factors cutoff\n    #Then the filter is not ok.\n    foreach my $fact (keys %{$self->factors()}){\n\tif(exists($hash->{$fact}) && $hash->{$fact} =~ /^N/){\n\t    $bool = 0;\n\t}\n    }\n\n    return $bool;\n\n}\n\n=head2 factors\n\n Title   : factors\n Usage   : my $feat = $signalp->factors\n Function: Get/Set the filters required from the user\n Returns : hash\n Args    : array reference\n\n\n\nsub factors {\n\n    my($self, $array) = @_;\n\n    if($array){\n\t$self->{_factors} = { };\n\tforeach my $f (@$array){\n\t    if(exists($FACTS->{$f})){\n\t\t$self->{_factors}->{$f} = 1;\n\t    }\n\t    else{\n\t\t$self->throw(\"[$f] incorrect factor. Supported:\\n- \".join(\"\\n- \", keys %$FACTS).\"\\n\");\n\t    }\n\t}\n    }\n\n    return $self->{_factors};\n\n}\n\n=head2 _parsed\n\n Title   : _parsed\n Usage   : obj->_parsed()\n Function: Get/Set if the result is parsed or not\n Returns : 1/0 scalar\n Args    : On set 1\n\n\n\nsub _parsed {\n\n    my($self, $parsed) = @_;\n\n    if(defined($parsed)){\n\t$self->{_parsed} = $parsed;\n    }\n\n    return $self->{_parsed};\n\n}\n\n=head2 _parse\n\n Title   : _parse\n Usage   : obj->_parse\n Function: Parse the SignalP result\n Returns :\n Args    :\n\n\n\nsub _parse {\n\n    my($self) = @_;\n\n    #Let's read the file...\n    while (my $line = $self->_readline()) {\n\n\tchomp $line;\n\t#We want to be sure to catch the first non empty line to be ablte to determine\n\t#which format we are working with...\n\tnext unless ($line =~ /^>(\\S+)|^# SignalP-[NHM]+ \\S+ predictions/);\n\n\tif($line =~ /^>(\\S+)/){\n\t    $self->_pushback($line);\n\t    $self->_parse_summary_format();\n\t    last;\n\t}\n\telsif($line =~ /^# SignalP-[NHM]+ \\S+ predictions/){\n\t    $self->_pushback($line);\n\t    $self->_parse_short_format();\n\t    last;\n\t}\n\telse{\n\t    $self->throw(\"Unable to determine the format type.\");\n\t}\n    }\n\n    return;\n}\n\n=head2 _parse_summary_format\n\n Title   : _parse_summary_format\n Usage   : $self->_parse_summary_format\n Function: Method to parse summary/full format from signalp output\n           It automatically fills filtered features.\n Returns :\n Args    :\n\n\nsub _parse_summary_format {\n\n    my($self) = @_;\n\n    my $feature = undef;\n    my $ok = 0;\n\n    while(my $line = $self->_readline()){\n\n\tif($line =~ /^SignalP-NN result:/){\n\t    $self->_pushback($line);\n\t    $feature = $self->_parse_nn_result($feature);\n\t}\n\tif($line =~ /^SignalP-HMM result:/){\n\t    $self->_pushback($line);\n\t    $feature = $self->_parse_hmm_result($feature);\n\t}\n\n\tif($line =~ /^---------/ && $feature){\n\t    my $new_feature = $self->create_feature($feature);\n\t    push @{$self->{_features}}, $new_feature if $new_feature;\n\t    $feature = undef;\n\t}\n    }\n\n    return;\n}\n\n\n=head2 _parse_nn_result\n\n Title   : _parse_nn_result\n Usage   : obj->_parse_nn_result\n Function: Parses the Neuronal Network (NN) part of the result\n Returns : Hash reference\n Args    :","parameters":[{"label":"$self"},{"label":"$feature"}],"label":"_parse_nn_result($self,$feature)"},"name":"_parse_nn_result","range":{"end":{"line":431,"character":9999},"start":{"character":0,"line":353}}},{"name":"maxCprob","kind":12,"line":386},{"line":387,"kind":12,"name":"maxC"},{"name":"maxYprob","kind":12,"line":391},{"line":392,"kind":12,"name":"maxY"},{"line":396,"kind":12,"name":"maxSprob"},{"name":"maxS","kind":12,"line":397},{"name":"meanSprob","line":401,"kind":12},{"name":"meanS","line":402,"kind":12},{"kind":12,"line":406,"name":"Dprob"},{"kind":12,"line":415,"name":"end"},{"line":425,"kind":12,"name":"name"},{"name":"start","kind":12,"line":426},{"line":427,"kind":12,"name":"nnPrediction"},{"range":{"end":{"character":9999,"line":494},"start":{"character":0,"line":444}},"name":"_parse_hmm_result","signature":{"documentation":"1;\n# $Id: ExtendedSignalp.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Signalp::ExtendedSignalp\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n#\n# Copyright Emmanuel Quevillon\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Signalp::ExtendedSignalp - enhanced parser for Signalp output\n\n=head1 SYNOPSIS\n\n use Bio::Tools::Signalp::ExtendedSignalp;\n my $params = [qw(maxC maxY maxS meanS D)];\n my $parser = new Bio::Tools::Signalp::ExtendedSignalp(\n                                                       -fh      => $filehandle\n                                                       -factors => $params\n                                                      );\n\n $parser->factors($params);\n while( my $sp_feat = $parser->next_feature ) {\n       #do something\n       #eg\n       push @sp_feat, $sp_feat;\n }\n\n=head1 DESCRIPTION\n\n# Please direct questions and support issues to I<bioperl-l@bioperl.org> \n\nParser module for Signalp.\n\nBased on the EnsEMBL module Bio::EnsEMBL::Pipeline::Runnable::Protein::Signalp\noriginally written by Marc Sohrmann (ms2 a sanger.ac.uk) Written in BioPipe by\nBalamurugan Kumarasamy (savikalpa a fugu-sg.org) Cared for by the Fugu\nInformatics team (fuguteam@fugu-sg.org)\n\nYou may distribute this module under the same terms as perl itself\n\nCompared to the original SignalP, this method allow the user to filter results\nout based on maxC maxY maxS meanS and D factor cutoff for the Neural Network (NN)\nmethod only. The HMM method does not give any filters with 'YES' or 'NO' as result.\n\nThe user must be aware that the filters can only by applied on NN method.\nAlso, to ensure the compability with original Signalp parsing module, the user\nmust know that by default, if filters are empty, max Y and mean S filters are\nautomatically used to filter results.\n\nIf the used gives a list, then the parser will only report protein having 'YES'\nfor each factor.\n\nThis module supports parsing for full, summary and short output form signalp.\nActually, full and summary are equivalent in terms of filtering results.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Based on the Bio::Tools::Signalp module\n Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n\n=head1 APPENDIX\n\n The rest of the documentation details each of the object methods.\n Internal methods are usually preceded with a _\n\n\npackage Bio::Tools::Signalp::ExtendedSignalp;\n\nuse strict;\nuse Data::Dumper;\nuse Bio::SeqFeature::Generic;\n# don't need Bio::Root::Root/IO (already in inheritance tree)\nuse base qw(Bio::Tools::Signalp Bio::Tools::AnalysisResult);\n\n#Supported arguments\nmy $FACTS = {\n\t     'maxC'  => 1,\n\t     'maxS'  => 1,\n\t     'maxY'  => 1,\n\t     'meanS' => 1,\n\t     'D'     => 1,\n\t    };\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Tools::Signalp::ExtendedSignalp();\n Function: Builds a new Bio::Tools::Signalp::ExtendedSignalp object\n Returns : Bio::Tools::Signalp::ExtendedSignalp\n Args    : -fh/-file => $val, # for initing input, see Bio::Root::IO\n\n\n\nsub new {\n      my($class,@args) = @_;\n\n      my $self = $class->SUPER::new(@args);\n      $self->_initialize_io(@args);\n\n      my $factors = $self->_rearrange([qw(FACTORS)], @args);\n      #To behave like the parent module (Bio::Tools::Signalp) we default factors to these two factors\n      if($factors && scalar(@$factors)){\n\t  $factors = $factors;\n      }\n      else{\n\t  $factors = [qw(maxY meanS)];\n      }\n      $factors && $self->factors($factors);\n\t\t\t\t\t\t\n      return $self;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : my $feat = $signalp->next_feature\n Function: Get the next result feature from parser data\n Returns : Bio::SeqFeature::Generic\n Args    : none\n\n\n\nsub next_feature {\n\n    my ($self) = @_;\n\n    if(!$self->_parsed()){\n\t$self->_parse();\n    }\n\n    return shift @{$self->{_features}} || undef;\n\n}\n\n=head2 _filterok\n\n Title   : _filterok\n Usage   : my $feat = $signalp->_filterok\n Function: Check if the factors required by the user are all ok.\n Returns : 1/0\n Args    : hash reference\n\n\n\nsub _filterok {\n\n    my($self, $hash) = @_;\n\n    #We hope everything will be fine ;)\n    my $bool = 1;\n\n    #If the user did not give any filter, we keep eveything\n    return $bool unless keys %{$self->{_factors}};\n\n    #If only one of the factors parsed is equal to NO based on the user factors cutoff\n    #Then the filter is not ok.\n    foreach my $fact (keys %{$self->factors()}){\n\tif(exists($hash->{$fact}) && $hash->{$fact} =~ /^N/){\n\t    $bool = 0;\n\t}\n    }\n\n    return $bool;\n\n}\n\n=head2 factors\n\n Title   : factors\n Usage   : my $feat = $signalp->factors\n Function: Get/Set the filters required from the user\n Returns : hash\n Args    : array reference\n\n\n\nsub factors {\n\n    my($self, $array) = @_;\n\n    if($array){\n\t$self->{_factors} = { };\n\tforeach my $f (@$array){\n\t    if(exists($FACTS->{$f})){\n\t\t$self->{_factors}->{$f} = 1;\n\t    }\n\t    else{\n\t\t$self->throw(\"[$f] incorrect factor. Supported:\\n- \".join(\"\\n- \", keys %$FACTS).\"\\n\");\n\t    }\n\t}\n    }\n\n    return $self->{_factors};\n\n}\n\n=head2 _parsed\n\n Title   : _parsed\n Usage   : obj->_parsed()\n Function: Get/Set if the result is parsed or not\n Returns : 1/0 scalar\n Args    : On set 1\n\n\n\nsub _parsed {\n\n    my($self, $parsed) = @_;\n\n    if(defined($parsed)){\n\t$self->{_parsed} = $parsed;\n    }\n\n    return $self->{_parsed};\n\n}\n\n=head2 _parse\n\n Title   : _parse\n Usage   : obj->_parse\n Function: Parse the SignalP result\n Returns :\n Args    :\n\n\n\nsub _parse {\n\n    my($self) = @_;\n\n    #Let's read the file...\n    while (my $line = $self->_readline()) {\n\n\tchomp $line;\n\t#We want to be sure to catch the first non empty line to be ablte to determine\n\t#which format we are working with...\n\tnext unless ($line =~ /^>(\\S+)|^# SignalP-[NHM]+ \\S+ predictions/);\n\n\tif($line =~ /^>(\\S+)/){\n\t    $self->_pushback($line);\n\t    $self->_parse_summary_format();\n\t    last;\n\t}\n\telsif($line =~ /^# SignalP-[NHM]+ \\S+ predictions/){\n\t    $self->_pushback($line);\n\t    $self->_parse_short_format();\n\t    last;\n\t}\n\telse{\n\t    $self->throw(\"Unable to determine the format type.\");\n\t}\n    }\n\n    return;\n}\n\n=head2 _parse_summary_format\n\n Title   : _parse_summary_format\n Usage   : $self->_parse_summary_format\n Function: Method to parse summary/full format from signalp output\n           It automatically fills filtered features.\n Returns :\n Args    :\n\n\nsub _parse_summary_format {\n\n    my($self) = @_;\n\n    my $feature = undef;\n    my $ok = 0;\n\n    while(my $line = $self->_readline()){\n\n\tif($line =~ /^SignalP-NN result:/){\n\t    $self->_pushback($line);\n\t    $feature = $self->_parse_nn_result($feature);\n\t}\n\tif($line =~ /^SignalP-HMM result:/){\n\t    $self->_pushback($line);\n\t    $feature = $self->_parse_hmm_result($feature);\n\t}\n\n\tif($line =~ /^---------/ && $feature){\n\t    my $new_feature = $self->create_feature($feature);\n\t    push @{$self->{_features}}, $new_feature if $new_feature;\n\t    $feature = undef;\n\t}\n    }\n\n    return;\n}\n\n\n=head2 _parse_nn_result\n\n Title   : _parse_nn_result\n Usage   : obj->_parse_nn_result\n Function: Parses the Neuronal Network (NN) part of the result\n Returns : Hash reference\n Args    :\n\n\n\nsub _parse_nn_result {\n\n    my($self, $feature) = @_;\n\n    my $ok   = 0;\n    my %facts;\n\n    #SignalP-NN result:\n    #>MGG_11635.5           length = 100\n    ## Measure  Position  Value  Cutoff  signal peptide?\n    #  max. C    37       0.087   0.32   NO\n    #  max. Y    37       0.042   0.33   NO\n    #  max. S     3       0.062   0.87   NO\n    #  mean S     1-36    0.024   0.48   NO\n    #       D     1-36    0.033   0.43   NO\n\n    while(my $line = $self->_readline()){\n\n\tchomp $line;\n\n\tif($line =~ /^SignalP-NN result:/){\n\t    $ok = 1;\n\t    next;\n\t}\n\n\t$self->throw(\"Wrong line for parsing NN results.\") unless $ok;\n\n\tif ($line=~/^\\>(\\S+)\\s+length/) {\n\t    $self->seqname($1);\n\t    %facts = ();\n\t    next;\n\t}\n\telsif($line =~ /max\\.\\s+C\\s+(\\S+)\\s+\\S+\\s+\\S+\\s+(\\S+)/) {\n\t    $feature->{maxCprob} = $1;\n\t    $facts{maxC} = $2;\n\t    next;\n\t}\n\telsif ($line =~ /max\\.\\s+Y\\s+(\\S+)\\s+\\S+\\s+\\S+\\s+(\\S+)/) {\n\t    $feature->{maxYprob} = $1;\n\t    $facts{maxY} = $2;\n\t    next;\n\t}\n\telsif($line =~ /max\\.\\s+S\\s+(\\S+)\\s+\\S+\\s+\\S+\\s+(\\S+)/) {\n\t    $feature->{maxSprob} = $1;\n\t    $facts{maxS} = $2;\n\t    next;\n\t}\n\telsif ($line=~/mean\\s+S\\s+(\\S+)\\s+\\S+\\s+\\S+\\s+(\\S+)/) {\n\t    $feature->{meanSprob} = $1;\n\t    $facts{meanS} = $2;\n\t    next;\n\t}\n\telsif ($line=~/\\s+D\\s+(\\S+)\\s+\\S+\\s+\\S+\\s+(\\S+)/) {\n\t    $feature->{Dprob} = $1;\n\t    $facts{D} = $2;\n\t    next;\n\t}\n\t#If we don't have this line it means that all the factors cutoff are equal to 'NO'\n\telsif ($line =~ /Most likely cleavage site between pos\\.\\s+(\\d+)/) {\n\t    #if($self->_filterok(\\%facts)){\n\t\t#$feature->{name}       = $self->seqname();\n\t\t#$feature->{start}      = 1;\n\t\t$feature->{end}        = $1 + 1; #To be consistent with end given in short format\n\t    #}\n\t    #return $feature;\n\t}\n\telsif($line =~ /^\\s*$/){\n\t    last;\n\t}\n    }\n\n    if($self->_filterok(\\%facts)){\n\t$feature->{name}  = $self->seqname();\n\t$feature->{start} = 1;\n\t$feature->{nnPrediction} = 'signal-peptide';\n    }\n\n    return $feature;\n}\n\n\n=head2 _parse_hmm_result\n\n Title   : _parse_hmm_result\n Usage   : obj->_parse_hmm_result\n Function: Parses the Hiden Markov Model (HMM) part of the result\n Returns : Hash reference\n Args    :","parameters":[{"label":"$self"},{"label":"$feature_hash"}],"label":"_parse_hmm_result($self,$feature_hash)"},"detail":"($self,$feature_hash)","definition":"sub","containerName":"main::","children":[{"name":"$self","definition":"my","containerName":"_parse_hmm_result","localvar":"my","kind":13,"line":446},{"containerName":"_parse_hmm_result","name":"$feature_hash","line":446,"kind":13},{"kind":13,"line":448,"containerName":"_parse_hmm_result","definition":"my","name":"$ok","localvar":"my"},{"line":457,"kind":13,"localvar":"my","containerName":"_parse_hmm_result","name":"$line","definition":"my"},{"kind":13,"line":457,"containerName":"_parse_hmm_result","name":"$self"},{"containerName":"_parse_hmm_result","name":"_readline","kind":12,"line":457},{"kind":13,"line":459,"name":"$line","containerName":"_parse_hmm_result"},{"kind":13,"line":460,"containerName":"_parse_hmm_result","name":"$line"},{"line":462,"kind":13,"containerName":"_parse_hmm_result","name":"$line"},{"line":463,"kind":13,"name":"$ok","containerName":"_parse_hmm_result"},{"containerName":"_parse_hmm_result","name":"$self","line":467,"kind":13},{"line":467,"kind":12,"containerName":"_parse_hmm_result","name":"throw"},{"kind":13,"line":467,"name":"$ok","containerName":"_parse_hmm_result"},{"name":"$line","containerName":"_parse_hmm_result","line":469,"kind":13},{"containerName":"_parse_hmm_result","name":"$feature_hash","line":471,"kind":13},{"name":"$self","containerName":"_parse_hmm_result","line":471,"kind":13},{"line":471,"kind":12,"name":"seqname","containerName":"_parse_hmm_result"},{"line":473,"kind":13,"containerName":"_parse_hmm_result","name":"$line"},{"line":474,"kind":13,"name":"$feature_hash","containerName":"_parse_hmm_result"},{"line":476,"kind":13,"name":"$line","containerName":"_parse_hmm_result"},{"kind":13,"line":477,"containerName":"_parse_hmm_result","name":"$feature_hash"},{"line":479,"kind":13,"name":"$line","containerName":"_parse_hmm_result"},{"line":480,"kind":13,"name":"$feature_hash","containerName":"_parse_hmm_result"},{"containerName":"_parse_hmm_result","name":"$line","line":482,"kind":13},{"kind":13,"line":483,"containerName":"_parse_hmm_result","name":"$feature_hash"},{"kind":13,"line":487,"containerName":"_parse_hmm_result","name":"$feature_hash"},{"line":487,"kind":13,"containerName":"_parse_hmm_result","name":"$feature_hash"},{"containerName":"_parse_hmm_result","name":"$feature_hash","kind":13,"line":488},{"name":"$feature_hash","containerName":"_parse_hmm_result","kind":13,"line":488},{"name":"$feature_hash","containerName":"_parse_hmm_result","line":493,"kind":13}],"line":444,"kind":12},{"name":"name","kind":12,"line":471},{"name":"hmmPrediction","kind":12,"line":474},{"kind":12,"line":477,"name":"peptideProb"},{"name":"anchorProb","line":480,"kind":12},{"kind":12,"line":483,"name":"cleavageSiteProb"},{"name":"end","line":487,"kind":12},{"name":"end","kind":12,"line":487},{"line":488,"kind":12,"name":"start"},{"kind":12,"line":488,"name":"start"},{"children":[{"line":509,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_parse_short_format"},{"kind":13,"line":511,"definition":"my","name":"$ok","containerName":"_parse_short_format","localvar":"my"},{"line":512,"kind":13,"localvar":"my","definition":"my","name":"$method","containerName":"_parse_short_format"},{"line":513,"kind":13,"name":"$self","containerName":"_parse_short_format"},{"localvar":"my","containerName":"_parse_short_format","name":"$line","definition":"my","line":523,"kind":13},{"kind":13,"line":523,"containerName":"_parse_short_format","name":"$self"},{"kind":12,"line":523,"containerName":"_parse_short_format","name":"_readline"},{"containerName":"_parse_short_format","name":"$line","line":525,"kind":13},{"kind":13,"line":526,"containerName":"_parse_short_format","name":"$line"},{"line":528,"kind":13,"containerName":"_parse_short_format","name":"$line"},{"containerName":"_parse_short_format","name":"$method","line":529,"kind":13},{"name":"$line","containerName":"_parse_short_format","kind":13,"line":529},{"line":530,"kind":13,"name":"$line","containerName":"_parse_short_format"},{"kind":13,"line":537,"containerName":"_parse_short_format","name":"@data","definition":"my","localvar":"my"},{"name":"$line","containerName":"_parse_short_format","kind":13,"line":537},{"name":"$self","containerName":"_parse_short_format","kind":13,"line":538},{"line":538,"kind":12,"containerName":"_parse_short_format","name":"seqname"},{"containerName":"_parse_short_format","name":"$data","line":538,"kind":13},{"kind":13,"line":540,"definition":"my","name":"$factors","containerName":"_parse_short_format","localvar":"my"},{"localvar":"my","name":"$feature","definition":"my","containerName":"_parse_short_format","line":541,"kind":13},{"name":"$method","containerName":"_parse_short_format","kind":13,"line":544},{"containerName":"_parse_short_format","name":"$method","kind":13,"line":544},{"containerName":"_parse_short_format","name":"$feature","line":546,"kind":13},{"name":"$data","containerName":"_parse_short_format","kind":13,"line":546},{"kind":13,"line":547,"name":"$factors","containerName":"_parse_short_format"},{"kind":13,"line":547,"containerName":"_parse_short_format","name":"$data"},{"containerName":"_parse_short_format","name":"$feature","kind":13,"line":548},{"containerName":"_parse_short_format","name":"$data","kind":13,"line":548},{"containerName":"_parse_short_format","name":"$factors","line":549,"kind":13},{"line":549,"kind":13,"containerName":"_parse_short_format","name":"$data"},{"kind":13,"line":550,"containerName":"_parse_short_format","name":"$feature"},{"name":"$data","containerName":"_parse_short_format","kind":13,"line":550},{"kind":13,"line":551,"containerName":"_parse_short_format","name":"$factors"},{"kind":13,"line":551,"containerName":"_parse_short_format","name":"$data"},{"containerName":"_parse_short_format","name":"$feature","line":552,"kind":13},{"containerName":"_parse_short_format","name":"$data","line":552,"kind":13},{"line":553,"kind":13,"name":"$factors","containerName":"_parse_short_format"},{"line":553,"kind":13,"containerName":"_parse_short_format","name":"$data"},{"line":554,"kind":13,"containerName":"_parse_short_format","name":"$feature"},{"containerName":"_parse_short_format","name":"$data","line":554,"kind":13},{"name":"$factors","containerName":"_parse_short_format","kind":13,"line":555},{"name":"$data","containerName":"_parse_short_format","line":555,"kind":13},{"containerName":"_parse_short_format","name":"$feature","line":557,"kind":13},{"kind":13,"line":557,"name":"$data","containerName":"_parse_short_format"},{"containerName":"_parse_short_format","name":"$feature","kind":13,"line":558},{"name":"$method","containerName":"_parse_short_format","line":560,"kind":13},{"containerName":"_parse_short_format","name":"$feature","kind":13,"line":561},{"kind":13,"line":561,"containerName":"_parse_short_format","name":"$data"},{"name":"$feature","containerName":"_parse_short_format","kind":13,"line":562},{"containerName":"_parse_short_format","name":"$data","kind":13,"line":562},{"line":563,"kind":13,"name":"$feature","containerName":"_parse_short_format"},{"containerName":"_parse_short_format","name":"$data","line":563,"kind":13},{"containerName":"_parse_short_format","name":"$method","line":566,"kind":13},{"name":"$feature","containerName":"_parse_short_format","line":568,"kind":13},{"name":"$data","containerName":"_parse_short_format","kind":13,"line":568},{"name":"$feature","containerName":"_parse_short_format","line":569,"kind":13},{"line":569,"kind":13,"name":"$data","containerName":"_parse_short_format"},{"line":570,"kind":13,"name":"$feature","containerName":"_parse_short_format"},{"name":"$data","containerName":"_parse_short_format","kind":13,"line":570},{"name":"$feature","containerName":"_parse_short_format","kind":13,"line":572},{"line":572,"kind":13,"name":"$data","containerName":"_parse_short_format"},{"name":"$self","containerName":"_parse_short_format","kind":13,"line":576},{"name":"_filterok","containerName":"_parse_short_format","line":576,"kind":12},{"line":576,"kind":13,"containerName":"_parse_short_format","name":"$factors"},{"containerName":"_parse_short_format","name":"$feature","kind":13,"line":577},{"containerName":"_parse_short_format","name":"$self","line":577,"kind":13},{"containerName":"_parse_short_format","name":"seqname","line":577,"kind":12},{"line":578,"kind":13,"containerName":"_parse_short_format","name":"$feature"},{"containerName":"_parse_short_format","name":"$feature","kind":13,"line":579},{"kind":13,"line":580,"containerName":"_parse_short_format","name":"$feature"},{"containerName":"_parse_short_format","name":"$feature","kind":13,"line":581},{"name":"$feature","containerName":"_parse_short_format","line":582,"kind":13},{"definition":"my","name":"$new_feat","containerName":"_parse_short_format","localvar":"my","kind":13,"line":584},{"name":"$self","containerName":"_parse_short_format","kind":13,"line":584},{"name":"create_feature","containerName":"_parse_short_format","kind":12,"line":584},{"name":"$feature","containerName":"_parse_short_format","line":584,"kind":13},{"containerName":"_parse_short_format","name":"$self","line":585,"kind":13},{"containerName":"_parse_short_format","name":"$new_feat","kind":13,"line":585},{"line":585,"kind":13,"name":"$new_feat","containerName":"_parse_short_format"}],"line":507,"kind":12,"signature":{"documentation":"1;\n# $Id: ExtendedSignalp.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Signalp::ExtendedSignalp\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n#\n# Copyright Emmanuel Quevillon\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Signalp::ExtendedSignalp - enhanced parser for Signalp output\n\n=head1 SYNOPSIS\n\n use Bio::Tools::Signalp::ExtendedSignalp;\n my $params = [qw(maxC maxY maxS meanS D)];\n my $parser = new Bio::Tools::Signalp::ExtendedSignalp(\n                                                       -fh      => $filehandle\n                                                       -factors => $params\n                                                      );\n\n $parser->factors($params);\n while( my $sp_feat = $parser->next_feature ) {\n       #do something\n       #eg\n       push @sp_feat, $sp_feat;\n }\n\n=head1 DESCRIPTION\n\n# Please direct questions and support issues to I<bioperl-l@bioperl.org> \n\nParser module for Signalp.\n\nBased on the EnsEMBL module Bio::EnsEMBL::Pipeline::Runnable::Protein::Signalp\noriginally written by Marc Sohrmann (ms2 a sanger.ac.uk) Written in BioPipe by\nBalamurugan Kumarasamy (savikalpa a fugu-sg.org) Cared for by the Fugu\nInformatics team (fuguteam@fugu-sg.org)\n\nYou may distribute this module under the same terms as perl itself\n\nCompared to the original SignalP, this method allow the user to filter results\nout based on maxC maxY maxS meanS and D factor cutoff for the Neural Network (NN)\nmethod only. The HMM method does not give any filters with 'YES' or 'NO' as result.\n\nThe user must be aware that the filters can only by applied on NN method.\nAlso, to ensure the compability with original Signalp parsing module, the user\nmust know that by default, if filters are empty, max Y and mean S filters are\nautomatically used to filter results.\n\nIf the used gives a list, then the parser will only report protein having 'YES'\nfor each factor.\n\nThis module supports parsing for full, summary and short output form signalp.\nActually, full and summary are equivalent in terms of filtering results.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Based on the Bio::Tools::Signalp module\n Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n\n=head1 APPENDIX\n\n The rest of the documentation details each of the object methods.\n Internal methods are usually preceded with a _\n\n\npackage Bio::Tools::Signalp::ExtendedSignalp;\n\nuse strict;\nuse Data::Dumper;\nuse Bio::SeqFeature::Generic;\n# don't need Bio::Root::Root/IO (already in inheritance tree)\nuse base qw(Bio::Tools::Signalp Bio::Tools::AnalysisResult);\n\n#Supported arguments\nmy $FACTS = {\n\t     'maxC'  => 1,\n\t     'maxS'  => 1,\n\t     'maxY'  => 1,\n\t     'meanS' => 1,\n\t     'D'     => 1,\n\t    };\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Tools::Signalp::ExtendedSignalp();\n Function: Builds a new Bio::Tools::Signalp::ExtendedSignalp object\n Returns : Bio::Tools::Signalp::ExtendedSignalp\n Args    : -fh/-file => $val, # for initing input, see Bio::Root::IO\n\n\n\nsub new {\n      my($class,@args) = @_;\n\n      my $self = $class->SUPER::new(@args);\n      $self->_initialize_io(@args);\n\n      my $factors = $self->_rearrange([qw(FACTORS)], @args);\n      #To behave like the parent module (Bio::Tools::Signalp) we default factors to these two factors\n      if($factors && scalar(@$factors)){\n\t  $factors = $factors;\n      }\n      else{\n\t  $factors = [qw(maxY meanS)];\n      }\n      $factors && $self->factors($factors);\n\t\t\t\t\t\t\n      return $self;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : my $feat = $signalp->next_feature\n Function: Get the next result feature from parser data\n Returns : Bio::SeqFeature::Generic\n Args    : none\n\n\n\nsub next_feature {\n\n    my ($self) = @_;\n\n    if(!$self->_parsed()){\n\t$self->_parse();\n    }\n\n    return shift @{$self->{_features}} || undef;\n\n}\n\n=head2 _filterok\n\n Title   : _filterok\n Usage   : my $feat = $signalp->_filterok\n Function: Check if the factors required by the user are all ok.\n Returns : 1/0\n Args    : hash reference\n\n\n\nsub _filterok {\n\n    my($self, $hash) = @_;\n\n    #We hope everything will be fine ;)\n    my $bool = 1;\n\n    #If the user did not give any filter, we keep eveything\n    return $bool unless keys %{$self->{_factors}};\n\n    #If only one of the factors parsed is equal to NO based on the user factors cutoff\n    #Then the filter is not ok.\n    foreach my $fact (keys %{$self->factors()}){\n\tif(exists($hash->{$fact}) && $hash->{$fact} =~ /^N/){\n\t    $bool = 0;\n\t}\n    }\n\n    return $bool;\n\n}\n\n=head2 factors\n\n Title   : factors\n Usage   : my $feat = $signalp->factors\n Function: Get/Set the filters required from the user\n Returns : hash\n Args    : array reference\n\n\n\nsub factors {\n\n    my($self, $array) = @_;\n\n    if($array){\n\t$self->{_factors} = { };\n\tforeach my $f (@$array){\n\t    if(exists($FACTS->{$f})){\n\t\t$self->{_factors}->{$f} = 1;\n\t    }\n\t    else{\n\t\t$self->throw(\"[$f] incorrect factor. Supported:\\n- \".join(\"\\n- \", keys %$FACTS).\"\\n\");\n\t    }\n\t}\n    }\n\n    return $self->{_factors};\n\n}\n\n=head2 _parsed\n\n Title   : _parsed\n Usage   : obj->_parsed()\n Function: Get/Set if the result is parsed or not\n Returns : 1/0 scalar\n Args    : On set 1\n\n\n\nsub _parsed {\n\n    my($self, $parsed) = @_;\n\n    if(defined($parsed)){\n\t$self->{_parsed} = $parsed;\n    }\n\n    return $self->{_parsed};\n\n}\n\n=head2 _parse\n\n Title   : _parse\n Usage   : obj->_parse\n Function: Parse the SignalP result\n Returns :\n Args    :\n\n\n\nsub _parse {\n\n    my($self) = @_;\n\n    #Let's read the file...\n    while (my $line = $self->_readline()) {\n\n\tchomp $line;\n\t#We want to be sure to catch the first non empty line to be ablte to determine\n\t#which format we are working with...\n\tnext unless ($line =~ /^>(\\S+)|^# SignalP-[NHM]+ \\S+ predictions/);\n\n\tif($line =~ /^>(\\S+)/){\n\t    $self->_pushback($line);\n\t    $self->_parse_summary_format();\n\t    last;\n\t}\n\telsif($line =~ /^# SignalP-[NHM]+ \\S+ predictions/){\n\t    $self->_pushback($line);\n\t    $self->_parse_short_format();\n\t    last;\n\t}\n\telse{\n\t    $self->throw(\"Unable to determine the format type.\");\n\t}\n    }\n\n    return;\n}\n\n=head2 _parse_summary_format\n\n Title   : _parse_summary_format\n Usage   : $self->_parse_summary_format\n Function: Method to parse summary/full format from signalp output\n           It automatically fills filtered features.\n Returns :\n Args    :\n\n\nsub _parse_summary_format {\n\n    my($self) = @_;\n\n    my $feature = undef;\n    my $ok = 0;\n\n    while(my $line = $self->_readline()){\n\n\tif($line =~ /^SignalP-NN result:/){\n\t    $self->_pushback($line);\n\t    $feature = $self->_parse_nn_result($feature);\n\t}\n\tif($line =~ /^SignalP-HMM result:/){\n\t    $self->_pushback($line);\n\t    $feature = $self->_parse_hmm_result($feature);\n\t}\n\n\tif($line =~ /^---------/ && $feature){\n\t    my $new_feature = $self->create_feature($feature);\n\t    push @{$self->{_features}}, $new_feature if $new_feature;\n\t    $feature = undef;\n\t}\n    }\n\n    return;\n}\n\n\n=head2 _parse_nn_result\n\n Title   : _parse_nn_result\n Usage   : obj->_parse_nn_result\n Function: Parses the Neuronal Network (NN) part of the result\n Returns : Hash reference\n Args    :\n\n\n\nsub _parse_nn_result {\n\n    my($self, $feature) = @_;\n\n    my $ok   = 0;\n    my %facts;\n\n    #SignalP-NN result:\n    #>MGG_11635.5           length = 100\n    ## Measure  Position  Value  Cutoff  signal peptide?\n    #  max. C    37       0.087   0.32   NO\n    #  max. Y    37       0.042   0.33   NO\n    #  max. S     3       0.062   0.87   NO\n    #  mean S     1-36    0.024   0.48   NO\n    #       D     1-36    0.033   0.43   NO\n\n    while(my $line = $self->_readline()){\n\n\tchomp $line;\n\n\tif($line =~ /^SignalP-NN result:/){\n\t    $ok = 1;\n\t    next;\n\t}\n\n\t$self->throw(\"Wrong line for parsing NN results.\") unless $ok;\n\n\tif ($line=~/^\\>(\\S+)\\s+length/) {\n\t    $self->seqname($1);\n\t    %facts = ();\n\t    next;\n\t}\n\telsif($line =~ /max\\.\\s+C\\s+(\\S+)\\s+\\S+\\s+\\S+\\s+(\\S+)/) {\n\t    $feature->{maxCprob} = $1;\n\t    $facts{maxC} = $2;\n\t    next;\n\t}\n\telsif ($line =~ /max\\.\\s+Y\\s+(\\S+)\\s+\\S+\\s+\\S+\\s+(\\S+)/) {\n\t    $feature->{maxYprob} = $1;\n\t    $facts{maxY} = $2;\n\t    next;\n\t}\n\telsif($line =~ /max\\.\\s+S\\s+(\\S+)\\s+\\S+\\s+\\S+\\s+(\\S+)/) {\n\t    $feature->{maxSprob} = $1;\n\t    $facts{maxS} = $2;\n\t    next;\n\t}\n\telsif ($line=~/mean\\s+S\\s+(\\S+)\\s+\\S+\\s+\\S+\\s+(\\S+)/) {\n\t    $feature->{meanSprob} = $1;\n\t    $facts{meanS} = $2;\n\t    next;\n\t}\n\telsif ($line=~/\\s+D\\s+(\\S+)\\s+\\S+\\s+\\S+\\s+(\\S+)/) {\n\t    $feature->{Dprob} = $1;\n\t    $facts{D} = $2;\n\t    next;\n\t}\n\t#If we don't have this line it means that all the factors cutoff are equal to 'NO'\n\telsif ($line =~ /Most likely cleavage site between pos\\.\\s+(\\d+)/) {\n\t    #if($self->_filterok(\\%facts)){\n\t\t#$feature->{name}       = $self->seqname();\n\t\t#$feature->{start}      = 1;\n\t\t$feature->{end}        = $1 + 1; #To be consistent with end given in short format\n\t    #}\n\t    #return $feature;\n\t}\n\telsif($line =~ /^\\s*$/){\n\t    last;\n\t}\n    }\n\n    if($self->_filterok(\\%facts)){\n\t$feature->{name}  = $self->seqname();\n\t$feature->{start} = 1;\n\t$feature->{nnPrediction} = 'signal-peptide';\n    }\n\n    return $feature;\n}\n\n\n=head2 _parse_hmm_result\n\n Title   : _parse_hmm_result\n Usage   : obj->_parse_hmm_result\n Function: Parses the Hiden Markov Model (HMM) part of the result\n Returns : Hash reference\n Args    :\n\n\nsub _parse_hmm_result {\n\n    my ($self, $feature_hash) = @_;\n\n    my $ok = 0;\n\n    #SignalP-HMM result:\n    #>MGG_11635.5\n    #Prediction: Non-secretory protein\n    #Signal peptide probability: 0.000\n    #Signal anchor probability: 0.000\n    #Max cleavage site probability: 0.000 between pos. -1 and  0\n\n    while(my $line = $self->_readline()){\n\n\tchomp $line;\n\tnext if $line =~ /^\\s*$/o;\n\n\tif($line =~ /^SignalP-HMM result:/){\n\t    $ok = 1;\n\t    next;\n\t}\n\n\t$self->throw(\"Wrong line for parsing HMM result.\") unless $ok;\n\n\tif($line =~ /^>(\\S+)/){\n\t    #In case we already seen a name with NN results\n\t    $feature_hash->{name} = $1 unless $self->seqname();\n\t}\n        elsif($line =~ /Prediction: (.+)$/){\n            $feature_hash->{hmmPrediction} = $1;\n        }\n\telsif($line =~ /Signal peptide probability: ([0-9\\.]+)/){\n            $feature_hash->{peptideProb} = $1;\n        }\n\telsif($line =~ /Signal anchor probability: ([0-9\\.]+)/){\n            $feature_hash->{anchorProb} = $1;\n        }\n\telsif($line =~ /Max cleavage site probability: (\\S+) between pos. \\S+ and (\\S+)/){\n\t    $feature_hash->{cleavageSiteProb} = $1;\n\t    #Strange case, if we don't have an end value in NN result (no nn method launched)\n\t    #We try anyway to get an end value, unless this value is lower than 1 which is\n\t    #the start\n\t    $feature_hash->{end}   = $2 if($2 > 1 && !$feature_hash->{end});\n\t    $feature_hash->{start} = 1 unless $feature_hash->{start};\n\t    last;\n\t}\n    }\n\n    return $feature_hash;\n}\n\n=head2 _parse_short_format\n\n Title   : _parse_short_format\n Usage   : $self->_parse_short_format\n Function: Method to parse short format from signalp output\n           It automatically fills filtered features.\n Returns :\n Args    :","parameters":[{"label":"$self"}],"label":"_parse_short_format($self)"},"detail":"($self)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":507},"end":{"line":587,"character":9999}},"name":"_parse_short_format"},{"kind":12,"line":513,"name":"_oformat"},{"name":"maxCprob","line":546,"kind":12},{"line":547,"kind":12,"name":"maxC"},{"line":548,"kind":12,"name":"maxYprob"},{"name":"maxY","line":549,"kind":12},{"line":550,"kind":12,"name":"maxSprob"},{"line":551,"kind":12,"name":"maxS"},{"line":552,"kind":12,"name":"meanSprob"},{"name":"meanS","line":553,"kind":12},{"name":"Dprob","line":554,"kind":12},{"line":557,"kind":12,"name":"end"},{"line":558,"kind":12,"name":"nnPrediction"},{"kind":12,"line":561,"name":"hmmPrediction"},{"name":"cleavageSiteProb","line":562,"kind":12},{"name":"peptideProb","kind":12,"line":563},{"name":"hmmPrediction","line":568,"kind":12},{"kind":12,"line":569,"name":"cleavageSiteProb"},{"kind":12,"line":570,"name":"peptideProb"},{"kind":12,"line":572,"name":"end"},{"kind":12,"line":577,"name":"name"},{"line":578,"kind":12,"name":"start"},{"name":"source","kind":12,"line":579},{"line":580,"kind":12,"name":"primary"},{"name":"program","line":581,"kind":12},{"name":"logic_name","line":582,"kind":12},{"line":585,"kind":12,"name":"_features"},{"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: ExtendedSignalp.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Signalp::ExtendedSignalp\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n#\n# Copyright Emmanuel Quevillon\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Signalp::ExtendedSignalp - enhanced parser for Signalp output\n\n=head1 SYNOPSIS\n\n use Bio::Tools::Signalp::ExtendedSignalp;\n my $params = [qw(maxC maxY maxS meanS D)];\n my $parser = new Bio::Tools::Signalp::ExtendedSignalp(\n                                                       -fh      => $filehandle\n                                                       -factors => $params\n                                                      );\n\n $parser->factors($params);\n while( my $sp_feat = $parser->next_feature ) {\n       #do something\n       #eg\n       push @sp_feat, $sp_feat;\n }\n\n=head1 DESCRIPTION\n\n# Please direct questions and support issues to I<bioperl-l@bioperl.org> \n\nParser module for Signalp.\n\nBased on the EnsEMBL module Bio::EnsEMBL::Pipeline::Runnable::Protein::Signalp\noriginally written by Marc Sohrmann (ms2 a sanger.ac.uk) Written in BioPipe by\nBalamurugan Kumarasamy (savikalpa a fugu-sg.org) Cared for by the Fugu\nInformatics team (fuguteam@fugu-sg.org)\n\nYou may distribute this module under the same terms as perl itself\n\nCompared to the original SignalP, this method allow the user to filter results\nout based on maxC maxY maxS meanS and D factor cutoff for the Neural Network (NN)\nmethod only. The HMM method does not give any filters with 'YES' or 'NO' as result.\n\nThe user must be aware that the filters can only by applied on NN method.\nAlso, to ensure the compability with original Signalp parsing module, the user\nmust know that by default, if filters are empty, max Y and mean S filters are\nautomatically used to filter results.\n\nIf the used gives a list, then the parser will only report protein having 'YES'\nfor each factor.\n\nThis module supports parsing for full, summary and short output form signalp.\nActually, full and summary are equivalent in terms of filtering results.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Based on the Bio::Tools::Signalp module\n Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n\n=head1 APPENDIX\n\n The rest of the documentation details each of the object methods.\n Internal methods are usually preceded with a _\n\n\npackage Bio::Tools::Signalp::ExtendedSignalp;\n\nuse strict;\nuse Data::Dumper;\nuse Bio::SeqFeature::Generic;\n# don't need Bio::Root::Root/IO (already in inheritance tree)\nuse base qw(Bio::Tools::Signalp Bio::Tools::AnalysisResult);\n\n#Supported arguments\nmy $FACTS = {\n\t     'maxC'  => 1,\n\t     'maxS'  => 1,\n\t     'maxY'  => 1,\n\t     'meanS' => 1,\n\t     'D'     => 1,\n\t    };\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Tools::Signalp::ExtendedSignalp();\n Function: Builds a new Bio::Tools::Signalp::ExtendedSignalp object\n Returns : Bio::Tools::Signalp::ExtendedSignalp\n Args    : -fh/-file => $val, # for initing input, see Bio::Root::IO\n\n\n\nsub new {\n      my($class,@args) = @_;\n\n      my $self = $class->SUPER::new(@args);\n      $self->_initialize_io(@args);\n\n      my $factors = $self->_rearrange([qw(FACTORS)], @args);\n      #To behave like the parent module (Bio::Tools::Signalp) we default factors to these two factors\n      if($factors && scalar(@$factors)){\n\t  $factors = $factors;\n      }\n      else{\n\t  $factors = [qw(maxY meanS)];\n      }\n      $factors && $self->factors($factors);\n\t\t\t\t\t\t\n      return $self;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : my $feat = $signalp->next_feature\n Function: Get the next result feature from parser data\n Returns : Bio::SeqFeature::Generic\n Args    : none\n\n\n\nsub next_feature {\n\n    my ($self) = @_;\n\n    if(!$self->_parsed()){\n\t$self->_parse();\n    }\n\n    return shift @{$self->{_features}} || undef;\n\n}\n\n=head2 _filterok\n\n Title   : _filterok\n Usage   : my $feat = $signalp->_filterok\n Function: Check if the factors required by the user are all ok.\n Returns : 1/0\n Args    : hash reference\n\n\n\nsub _filterok {\n\n    my($self, $hash) = @_;\n\n    #We hope everything will be fine ;)\n    my $bool = 1;\n\n    #If the user did not give any filter, we keep eveything\n    return $bool unless keys %{$self->{_factors}};\n\n    #If only one of the factors parsed is equal to NO based on the user factors cutoff\n    #Then the filter is not ok.\n    foreach my $fact (keys %{$self->factors()}){\n\tif(exists($hash->{$fact}) && $hash->{$fact} =~ /^N/){\n\t    $bool = 0;\n\t}\n    }\n\n    return $bool;\n\n}\n\n=head2 factors\n\n Title   : factors\n Usage   : my $feat = $signalp->factors\n Function: Get/Set the filters required from the user\n Returns : hash\n Args    : array reference\n\n\n\nsub factors {\n\n    my($self, $array) = @_;\n\n    if($array){\n\t$self->{_factors} = { };\n\tforeach my $f (@$array){\n\t    if(exists($FACTS->{$f})){\n\t\t$self->{_factors}->{$f} = 1;\n\t    }\n\t    else{\n\t\t$self->throw(\"[$f] incorrect factor. Supported:\\n- \".join(\"\\n- \", keys %$FACTS).\"\\n\");\n\t    }\n\t}\n    }\n\n    return $self->{_factors};\n\n}\n\n=head2 _parsed\n\n Title   : _parsed\n Usage   : obj->_parsed()\n Function: Get/Set if the result is parsed or not\n Returns : 1/0 scalar\n Args    : On set 1\n\n\n\nsub _parsed {\n\n    my($self, $parsed) = @_;\n\n    if(defined($parsed)){\n\t$self->{_parsed} = $parsed;\n    }\n\n    return $self->{_parsed};\n\n}\n\n=head2 _parse\n\n Title   : _parse\n Usage   : obj->_parse\n Function: Parse the SignalP result\n Returns :\n Args    :\n\n\n\nsub _parse {\n\n    my($self) = @_;\n\n    #Let's read the file...\n    while (my $line = $self->_readline()) {\n\n\tchomp $line;\n\t#We want to be sure to catch the first non empty line to be ablte to determine\n\t#which format we are working with...\n\tnext unless ($line =~ /^>(\\S+)|^# SignalP-[NHM]+ \\S+ predictions/);\n\n\tif($line =~ /^>(\\S+)/){\n\t    $self->_pushback($line);\n\t    $self->_parse_summary_format();\n\t    last;\n\t}\n\telsif($line =~ /^# SignalP-[NHM]+ \\S+ predictions/){\n\t    $self->_pushback($line);\n\t    $self->_parse_short_format();\n\t    last;\n\t}\n\telse{\n\t    $self->throw(\"Unable to determine the format type.\");\n\t}\n    }\n\n    return;\n}\n\n=head2 _parse_summary_format\n\n Title   : _parse_summary_format\n Usage   : $self->_parse_summary_format\n Function: Method to parse summary/full format from signalp output\n           It automatically fills filtered features.\n Returns :\n Args    :\n\n\nsub _parse_summary_format {\n\n    my($self) = @_;\n\n    my $feature = undef;\n    my $ok = 0;\n\n    while(my $line = $self->_readline()){\n\n\tif($line =~ /^SignalP-NN result:/){\n\t    $self->_pushback($line);\n\t    $feature = $self->_parse_nn_result($feature);\n\t}\n\tif($line =~ /^SignalP-HMM result:/){\n\t    $self->_pushback($line);\n\t    $feature = $self->_parse_hmm_result($feature);\n\t}\n\n\tif($line =~ /^---------/ && $feature){\n\t    my $new_feature = $self->create_feature($feature);\n\t    push @{$self->{_features}}, $new_feature if $new_feature;\n\t    $feature = undef;\n\t}\n    }\n\n    return;\n}\n\n\n=head2 _parse_nn_result\n\n Title   : _parse_nn_result\n Usage   : obj->_parse_nn_result\n Function: Parses the Neuronal Network (NN) part of the result\n Returns : Hash reference\n Args    :\n\n\n\nsub _parse_nn_result {\n\n    my($self, $feature) = @_;\n\n    my $ok   = 0;\n    my %facts;\n\n    #SignalP-NN result:\n    #>MGG_11635.5           length = 100\n    ## Measure  Position  Value  Cutoff  signal peptide?\n    #  max. C    37       0.087   0.32   NO\n    #  max. Y    37       0.042   0.33   NO\n    #  max. S     3       0.062   0.87   NO\n    #  mean S     1-36    0.024   0.48   NO\n    #       D     1-36    0.033   0.43   NO\n\n    while(my $line = $self->_readline()){\n\n\tchomp $line;\n\n\tif($line =~ /^SignalP-NN result:/){\n\t    $ok = 1;\n\t    next;\n\t}\n\n\t$self->throw(\"Wrong line for parsing NN results.\") unless $ok;\n\n\tif ($line=~/^\\>(\\S+)\\s+length/) {\n\t    $self->seqname($1);\n\t    %facts = ();\n\t    next;\n\t}\n\telsif($line =~ /max\\.\\s+C\\s+(\\S+)\\s+\\S+\\s+\\S+\\s+(\\S+)/) {\n\t    $feature->{maxCprob} = $1;\n\t    $facts{maxC} = $2;\n\t    next;\n\t}\n\telsif ($line =~ /max\\.\\s+Y\\s+(\\S+)\\s+\\S+\\s+\\S+\\s+(\\S+)/) {\n\t    $feature->{maxYprob} = $1;\n\t    $facts{maxY} = $2;\n\t    next;\n\t}\n\telsif($line =~ /max\\.\\s+S\\s+(\\S+)\\s+\\S+\\s+\\S+\\s+(\\S+)/) {\n\t    $feature->{maxSprob} = $1;\n\t    $facts{maxS} = $2;\n\t    next;\n\t}\n\telsif ($line=~/mean\\s+S\\s+(\\S+)\\s+\\S+\\s+\\S+\\s+(\\S+)/) {\n\t    $feature->{meanSprob} = $1;\n\t    $facts{meanS} = $2;\n\t    next;\n\t}\n\telsif ($line=~/\\s+D\\s+(\\S+)\\s+\\S+\\s+\\S+\\s+(\\S+)/) {\n\t    $feature->{Dprob} = $1;\n\t    $facts{D} = $2;\n\t    next;\n\t}\n\t#If we don't have this line it means that all the factors cutoff are equal to 'NO'\n\telsif ($line =~ /Most likely cleavage site between pos\\.\\s+(\\d+)/) {\n\t    #if($self->_filterok(\\%facts)){\n\t\t#$feature->{name}       = $self->seqname();\n\t\t#$feature->{start}      = 1;\n\t\t$feature->{end}        = $1 + 1; #To be consistent with end given in short format\n\t    #}\n\t    #return $feature;\n\t}\n\telsif($line =~ /^\\s*$/){\n\t    last;\n\t}\n    }\n\n    if($self->_filterok(\\%facts)){\n\t$feature->{name}  = $self->seqname();\n\t$feature->{start} = 1;\n\t$feature->{nnPrediction} = 'signal-peptide';\n    }\n\n    return $feature;\n}\n\n\n=head2 _parse_hmm_result\n\n Title   : _parse_hmm_result\n Usage   : obj->_parse_hmm_result\n Function: Parses the Hiden Markov Model (HMM) part of the result\n Returns : Hash reference\n Args    :\n\n\nsub _parse_hmm_result {\n\n    my ($self, $feature_hash) = @_;\n\n    my $ok = 0;\n\n    #SignalP-HMM result:\n    #>MGG_11635.5\n    #Prediction: Non-secretory protein\n    #Signal peptide probability: 0.000\n    #Signal anchor probability: 0.000\n    #Max cleavage site probability: 0.000 between pos. -1 and  0\n\n    while(my $line = $self->_readline()){\n\n\tchomp $line;\n\tnext if $line =~ /^\\s*$/o;\n\n\tif($line =~ /^SignalP-HMM result:/){\n\t    $ok = 1;\n\t    next;\n\t}\n\n\t$self->throw(\"Wrong line for parsing HMM result.\") unless $ok;\n\n\tif($line =~ /^>(\\S+)/){\n\t    #In case we already seen a name with NN results\n\t    $feature_hash->{name} = $1 unless $self->seqname();\n\t}\n        elsif($line =~ /Prediction: (.+)$/){\n            $feature_hash->{hmmPrediction} = $1;\n        }\n\telsif($line =~ /Signal peptide probability: ([0-9\\.]+)/){\n            $feature_hash->{peptideProb} = $1;\n        }\n\telsif($line =~ /Signal anchor probability: ([0-9\\.]+)/){\n            $feature_hash->{anchorProb} = $1;\n        }\n\telsif($line =~ /Max cleavage site probability: (\\S+) between pos. \\S+ and (\\S+)/){\n\t    $feature_hash->{cleavageSiteProb} = $1;\n\t    #Strange case, if we don't have an end value in NN result (no nn method launched)\n\t    #We try anyway to get an end value, unless this value is lower than 1 which is\n\t    #the start\n\t    $feature_hash->{end}   = $2 if($2 > 1 && !$feature_hash->{end});\n\t    $feature_hash->{start} = 1 unless $feature_hash->{start};\n\t    last;\n\t}\n    }\n\n    return $feature_hash;\n}\n\n=head2 _parse_short_format\n\n Title   : _parse_short_format\n Usage   : $self->_parse_short_format\n Function: Method to parse short format from signalp output\n           It automatically fills filtered features.\n Returns :\n Args    :\n\n\nsub _parse_short_format {\n\n                                my($self) = @_;\n\n    my $ok = 0;\n    my $method = undef;\n    $self->{_oformat} = 'short';\n\n    #Output example\n    # SignalP-NN euk predictions                                   \t                # SignalP-HMM euk predictions\n    # name                Cmax  pos ?  Ymax  pos ?  Smax  pos ?  Smean ?  D     ? \t# name      !  Cmax  pos ?  Sprob ?\n    #Q5A8M1_CANAL          0.085  27 N  0.190  35 N  0.936  27 Y  0.418 N  0.304 N\tQ5A8M1_CANAL  Q  0.001  35 N  0.002 N\n    #O74127_YARLI          0.121  21 N  0.284  21 N  0.953  11 Y  0.826 Y  0.555 Y\tO74127_YARLI  S  0.485  23 N  0.668 Y\n    #Q5VJ86_9PEZI          0.355  24 Y  0.375  24 Y  0.798  12 N  0.447 N  0.411 N\tQ5VJ86_9PEZI  Q  0.180  23 N  0.339 N\n    #Q5A8U5_CANAL          0.085  27 N  0.190  35 N  0.936  27 Y  0.418 N  0.304 N\tQ5A8U5_CANAL  Q  0.001  35 N  0.002 N\n\n    while(my $line = $self->_readline()){\n\t\n\tchomp $line;\n\tnext if $line =~ /^\\s*$|^# name/;\n\n\tif($line =~ /^#/){\n\t    $method = $line =~ /SignalP-NN .+ SignalP-HMM/ ?\n\t                                            'both' : $line =~ /SignalP-NN/ ?\n\t\t\t\t\t\t\t                      'nn' : 'hmm';\n\t    next;\n\t}\n\n\t#$self->throw(\"It looks like the format is not 'short' format.\") unless($ok);\n\n\tmy @data = split(/\\s+/, $line);\n\t$self->seqname($data[0]);\n\n\tmy $factors = { };\n\tmy $feature = { };\n\n\t#NN results gives more fields than HMM\n\tif($method eq 'both' || $method eq 'nn'){\n\n\t    $feature->{maxCprob} = $data[1];\n\t    $factors->{maxC}     = $data[3];\n\t    $feature->{maxYprob} = $data[4];\n\t    $factors->{maxY}     = $data[6];\n\t    $feature->{maxSprob} = $data[7];\n\t    $factors->{maxS}     = $data[9];\n\t    $feature->{meanSprob}= $data[10];\n\t    $factors->{meanS}    = $data[11];\n\t    $feature->{Dprob}    = $data[12];\n\t    $factors->{D}        = $data[13];\n\t    #It looks like the max Y position is reported as the most likely cleavage position\n\t    $feature->{end}      = $data[5];\n\t    $feature->{nnPrediction} = 'signal-peptide';\n\n\t    if($method eq 'both'){\n\t\t$feature->{hmmPrediction}    = $data[15] eq 'Q' ? 'Non-secretory protein' : 'Signal peptide';\n\t\t$feature->{cleavageSiteProb} = $data[16];\n\t\t$feature->{peptideProb}      = $data[19];\n\t    }\n\t}\n\telsif($method eq 'hmm'){\n\t    #In short output anchor probability is not given\n\t    $feature->{hmmPrediction}    = $data[1] eq 'Q' ? 'Non-secretory protein' : 'Signal peptide';\n\t    $feature->{cleavageSiteProb} = $data[2];\n\t    $feature->{peptideProb}      = $data[5];\n\t    #It looks like the max cleavage probability position is given by the Cmax proability\n\t    $feature->{end} = $data[3];\n\t}\n\n\t#Unfortunately, we cannot parse the filters for hmm method.\n\tif($self->_filterok($factors)){\n\t    $feature->{name}        = $self->seqname();\n\t    $feature->{start}       = 1;\n\t    $feature->{source}      = 'Signalp';\n\t    $feature->{primary}     = 'signal_peptide';\n\t    $feature->{program}     = 'Signalp';\n\t    $feature->{logic_name}  = 'signal_peptide';\n\n\t    my $new_feat = $self->create_feature($feature);\n\t    push @{$self->{_features}}, $new_feat if $new_feat;\n\t}\n    }\n\n    return;\n}\n\n=head2 create_feature\n\n Title   : create_feature\n Usage   : obj->create_feature(\\%feature)\n Function: Internal(not to be used directly)\n Returns :\n Args    :","parameters":[{"label":"$self"},{"label":"$feat"}],"label":"create_feature($self,$feat)"},"detail":"($self,$feat)","kind":12,"children":[{"localvar":"my","containerName":"create_feature","name":"$self","definition":"my","line":605,"kind":13},{"name":"$feat","containerName":"create_feature","kind":13,"line":605},{"name":"$feat","containerName":"create_feature","kind":13,"line":608},{"name":"$feat","containerName":"create_feature","kind":13,"line":608},{"kind":13,"line":608,"name":"$feat","containerName":"create_feature"},{"containerName":"create_feature","name":"$feature","definition":"my","localvar":"my","kind":13,"line":613},{"kind":12,"line":613,"name":"new","containerName":"create_feature"},{"containerName":"create_feature","name":"$feat","line":614,"kind":13},{"name":"$feat","containerName":"create_feature","kind":13,"line":615},{"name":"$feat","containerName":"create_feature","kind":13,"line":616},{"containerName":"create_feature","name":"$feat","line":617,"kind":13},{"containerName":"create_feature","name":"$feat","kind":13,"line":617},{"kind":13,"line":623,"containerName":"create_feature","name":"$feature"},{"name":"add_tag_value","containerName":"create_feature","kind":12,"line":623},{"line":623,"kind":13,"containerName":"create_feature","name":"$feat"},{"containerName":"create_feature","name":"$feature","kind":13,"line":624},{"containerName":"create_feature","name":"add_tag_value","kind":12,"line":624},{"kind":13,"line":624,"name":"$feat","containerName":"create_feature"},{"containerName":"create_feature","name":"$feature","line":625,"kind":13},{"name":"add_tag_value","containerName":"create_feature","kind":12,"line":625},{"name":"$feat","containerName":"create_feature","line":625,"kind":13},{"containerName":"create_feature","name":"$feature","kind":13,"line":626},{"line":626,"kind":12,"containerName":"create_feature","name":"add_tag_value"},{"name":"$feature","containerName":"create_feature","line":627,"kind":13},{"kind":12,"line":627,"containerName":"create_feature","name":"add_tag_value"},{"line":627,"kind":13,"name":"$feat","containerName":"create_feature"},{"containerName":"create_feature","name":"$feature","line":628,"kind":13},{"containerName":"create_feature","name":"add_tag_value","kind":12,"line":628},{"kind":13,"line":628,"containerName":"create_feature","name":"$feat"},{"kind":13,"line":629,"containerName":"create_feature","name":"$feature"},{"line":629,"kind":12,"containerName":"create_feature","name":"add_tag_value"},{"name":"$feat","containerName":"create_feature","kind":13,"line":629},{"containerName":"create_feature","name":"$feat","line":629,"kind":13},{"containerName":"create_feature","name":"$feature","kind":13,"line":630},{"line":630,"kind":12,"name":"add_tag_value","containerName":"create_feature"},{"containerName":"create_feature","name":"$feat","kind":13,"line":630},{"kind":13,"line":630,"containerName":"create_feature","name":"$feat"},{"name":"$feature","containerName":"create_feature","line":631,"kind":13},{"kind":12,"line":631,"containerName":"create_feature","name":"add_tag_value"},{"containerName":"create_feature","name":"$feat","line":631,"kind":13},{"line":631,"kind":13,"name":"$feat","containerName":"create_feature"},{"containerName":"create_feature","name":"$feature","line":632,"kind":13},{"containerName":"create_feature","name":"add_tag_value","line":632,"kind":12},{"containerName":"create_feature","name":"$feat","kind":13,"line":632},{"containerName":"create_feature","name":"$feat","kind":13,"line":632},{"name":"$feature","containerName":"create_feature","kind":13,"line":633},{"line":633,"kind":12,"containerName":"create_feature","name":"add_tag_value"},{"containerName":"create_feature","name":"$feat","kind":13,"line":633},{"containerName":"create_feature","name":"$feat","line":633,"kind":13},{"kind":13,"line":634,"containerName":"create_feature","name":"$feature"},{"line":634,"kind":12,"name":"add_tag_value","containerName":"create_feature"},{"kind":13,"line":634,"name":"$feat","containerName":"create_feature"},{"containerName":"create_feature","name":"$feat","kind":13,"line":634},{"containerName":"create_feature","name":"$feature","line":635,"kind":13},{"name":"add_tag_value","containerName":"create_feature","kind":12,"line":635},{"name":"$feat","containerName":"create_feature","line":635,"kind":13},{"containerName":"create_feature","name":"$feat","kind":13,"line":635},{"containerName":"create_feature","name":"$feature","line":637,"kind":13}],"line":603,"name":"create_feature","range":{"start":{"character":0,"line":603},"end":{"character":9999,"line":639}}},{"name":"name","line":608,"kind":12},{"name":"start","kind":12,"line":608},{"kind":12,"line":608,"name":"end"},{"containerName":"SeqFeature::Generic","name":"Bio","kind":12,"line":613},{"name":"name","line":614,"kind":12},{"kind":12,"line":615,"name":"start"},{"line":616,"kind":12,"name":"end"},{"kind":12,"line":617,"name":"peptideProb"},{"line":617,"kind":12,"name":"peptideProb"},{"name":"peptideProb","kind":12,"line":623},{"kind":12,"line":624,"name":"anchorProb"},{"kind":12,"line":625,"name":"anchorProb"},{"name":"primary","line":627,"kind":12},{"line":628,"kind":12,"name":"hmmPrediction"},{"name":"cleavageSiteProb","line":629,"kind":12},{"kind":12,"line":629,"name":"cleavageSiteProb"},{"name":"nnPrediction","line":630,"kind":12},{"name":"nnPrediction","line":630,"kind":12},{"kind":12,"line":631,"name":"maxCprob"},{"kind":12,"line":631,"name":"maxCprob"},{"kind":12,"line":632,"name":"maxSprob"},{"line":632,"kind":12,"name":"maxSprob"},{"line":633,"kind":12,"name":"maxYprob"},{"kind":12,"line":633,"name":"maxYprob"},{"kind":12,"line":634,"name":"meanSprob"},{"name":"meanSprob","line":634,"kind":12},{"line":635,"kind":12,"name":"Dprob"},{"name":"Dprob","line":635,"kind":12},{"kind":12,"line":652,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"seqname","line":653,"kind":13},{"line":653,"kind":13,"containerName":"seqname","name":"$seqname"},{"name":"$seqname","containerName":"seqname","line":655,"kind":13},{"kind":13,"line":656,"containerName":"seqname","name":"$self"},{"line":656,"kind":13,"name":"$seqname","containerName":"seqname"},{"kind":13,"line":659,"name":"$self","containerName":"seqname"}],"containerName":"main::","definition":"sub","detail":"($self,$seqname)","signature":{"label":"seqname($self,$seqname)","parameters":[{"label":"$self"},{"label":"$seqname"}],"documentation":"1;\n# $Id: ExtendedSignalp.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Signalp::ExtendedSignalp\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n#\n# Copyright Emmanuel Quevillon\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Signalp::ExtendedSignalp - enhanced parser for Signalp output\n\n=head1 SYNOPSIS\n\n use Bio::Tools::Signalp::ExtendedSignalp;\n my $params = [qw(maxC maxY maxS meanS D)];\n my $parser = new Bio::Tools::Signalp::ExtendedSignalp(\n                                                       -fh      => $filehandle\n                                                       -factors => $params\n                                                      );\n\n $parser->factors($params);\n while( my $sp_feat = $parser->next_feature ) {\n       #do something\n       #eg\n       push @sp_feat, $sp_feat;\n }\n\n=head1 DESCRIPTION\n\n# Please direct questions and support issues to I<bioperl-l@bioperl.org> \n\nParser module for Signalp.\n\nBased on the EnsEMBL module Bio::EnsEMBL::Pipeline::Runnable::Protein::Signalp\noriginally written by Marc Sohrmann (ms2 a sanger.ac.uk) Written in BioPipe by\nBalamurugan Kumarasamy (savikalpa a fugu-sg.org) Cared for by the Fugu\nInformatics team (fuguteam@fugu-sg.org)\n\nYou may distribute this module under the same terms as perl itself\n\nCompared to the original SignalP, this method allow the user to filter results\nout based on maxC maxY maxS meanS and D factor cutoff for the Neural Network (NN)\nmethod only. The HMM method does not give any filters with 'YES' or 'NO' as result.\n\nThe user must be aware that the filters can only by applied on NN method.\nAlso, to ensure the compability with original Signalp parsing module, the user\nmust know that by default, if filters are empty, max Y and mean S filters are\nautomatically used to filter results.\n\nIf the used gives a list, then the parser will only report protein having 'YES'\nfor each factor.\n\nThis module supports parsing for full, summary and short output form signalp.\nActually, full and summary are equivalent in terms of filtering results.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Based on the Bio::Tools::Signalp module\n Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n\n=head1 APPENDIX\n\n The rest of the documentation details each of the object methods.\n Internal methods are usually preceded with a _\n\n\npackage Bio::Tools::Signalp::ExtendedSignalp;\n\nuse strict;\nuse Data::Dumper;\nuse Bio::SeqFeature::Generic;\n# don't need Bio::Root::Root/IO (already in inheritance tree)\nuse base qw(Bio::Tools::Signalp Bio::Tools::AnalysisResult);\n\n#Supported arguments\nmy $FACTS = {\n\t     'maxC'  => 1,\n\t     'maxS'  => 1,\n\t     'maxY'  => 1,\n\t     'meanS' => 1,\n\t     'D'     => 1,\n\t    };\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Tools::Signalp::ExtendedSignalp();\n Function: Builds a new Bio::Tools::Signalp::ExtendedSignalp object\n Returns : Bio::Tools::Signalp::ExtendedSignalp\n Args    : -fh/-file => $val, # for initing input, see Bio::Root::IO\n\n\n\nsub new {\n      my($class,@args) = @_;\n\n      my $self = $class->SUPER::new(@args);\n      $self->_initialize_io(@args);\n\n      my $factors = $self->_rearrange([qw(FACTORS)], @args);\n      #To behave like the parent module (Bio::Tools::Signalp) we default factors to these two factors\n      if($factors && scalar(@$factors)){\n\t  $factors = $factors;\n      }\n      else{\n\t  $factors = [qw(maxY meanS)];\n      }\n      $factors && $self->factors($factors);\n\t\t\t\t\t\t\n      return $self;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : my $feat = $signalp->next_feature\n Function: Get the next result feature from parser data\n Returns : Bio::SeqFeature::Generic\n Args    : none\n\n\n\nsub next_feature {\n\n    my ($self) = @_;\n\n    if(!$self->_parsed()){\n\t$self->_parse();\n    }\n\n    return shift @{$self->{_features}} || undef;\n\n}\n\n=head2 _filterok\n\n Title   : _filterok\n Usage   : my $feat = $signalp->_filterok\n Function: Check if the factors required by the user are all ok.\n Returns : 1/0\n Args    : hash reference\n\n\n\nsub _filterok {\n\n    my($self, $hash) = @_;\n\n    #We hope everything will be fine ;)\n    my $bool = 1;\n\n    #If the user did not give any filter, we keep eveything\n    return $bool unless keys %{$self->{_factors}};\n\n    #If only one of the factors parsed is equal to NO based on the user factors cutoff\n    #Then the filter is not ok.\n    foreach my $fact (keys %{$self->factors()}){\n\tif(exists($hash->{$fact}) && $hash->{$fact} =~ /^N/){\n\t    $bool = 0;\n\t}\n    }\n\n    return $bool;\n\n}\n\n=head2 factors\n\n Title   : factors\n Usage   : my $feat = $signalp->factors\n Function: Get/Set the filters required from the user\n Returns : hash\n Args    : array reference\n\n\n\nsub factors {\n\n    my($self, $array) = @_;\n\n    if($array){\n\t$self->{_factors} = { };\n\tforeach my $f (@$array){\n\t    if(exists($FACTS->{$f})){\n\t\t$self->{_factors}->{$f} = 1;\n\t    }\n\t    else{\n\t\t$self->throw(\"[$f] incorrect factor. Supported:\\n- \".join(\"\\n- \", keys %$FACTS).\"\\n\");\n\t    }\n\t}\n    }\n\n    return $self->{_factors};\n\n}\n\n=head2 _parsed\n\n Title   : _parsed\n Usage   : obj->_parsed()\n Function: Get/Set if the result is parsed or not\n Returns : 1/0 scalar\n Args    : On set 1\n\n\n\nsub _parsed {\n\n    my($self, $parsed) = @_;\n\n    if(defined($parsed)){\n\t$self->{_parsed} = $parsed;\n    }\n\n    return $self->{_parsed};\n\n}\n\n=head2 _parse\n\n Title   : _parse\n Usage   : obj->_parse\n Function: Parse the SignalP result\n Returns :\n Args    :\n\n\n\nsub _parse {\n\n    my($self) = @_;\n\n    #Let's read the file...\n    while (my $line = $self->_readline()) {\n\n\tchomp $line;\n\t#We want to be sure to catch the first non empty line to be ablte to determine\n\t#which format we are working with...\n\tnext unless ($line =~ /^>(\\S+)|^# SignalP-[NHM]+ \\S+ predictions/);\n\n\tif($line =~ /^>(\\S+)/){\n\t    $self->_pushback($line);\n\t    $self->_parse_summary_format();\n\t    last;\n\t}\n\telsif($line =~ /^# SignalP-[NHM]+ \\S+ predictions/){\n\t    $self->_pushback($line);\n\t    $self->_parse_short_format();\n\t    last;\n\t}\n\telse{\n\t    $self->throw(\"Unable to determine the format type.\");\n\t}\n    }\n\n    return;\n}\n\n=head2 _parse_summary_format\n\n Title   : _parse_summary_format\n Usage   : $self->_parse_summary_format\n Function: Method to parse summary/full format from signalp output\n           It automatically fills filtered features.\n Returns :\n Args    :\n\n\nsub _parse_summary_format {\n\n    my($self) = @_;\n\n    my $feature = undef;\n    my $ok = 0;\n\n    while(my $line = $self->_readline()){\n\n\tif($line =~ /^SignalP-NN result:/){\n\t    $self->_pushback($line);\n\t    $feature = $self->_parse_nn_result($feature);\n\t}\n\tif($line =~ /^SignalP-HMM result:/){\n\t    $self->_pushback($line);\n\t    $feature = $self->_parse_hmm_result($feature);\n\t}\n\n\tif($line =~ /^---------/ && $feature){\n\t    my $new_feature = $self->create_feature($feature);\n\t    push @{$self->{_features}}, $new_feature if $new_feature;\n\t    $feature = undef;\n\t}\n    }\n\n    return;\n}\n\n\n=head2 _parse_nn_result\n\n Title   : _parse_nn_result\n Usage   : obj->_parse_nn_result\n Function: Parses the Neuronal Network (NN) part of the result\n Returns : Hash reference\n Args    :\n\n\n\nsub _parse_nn_result {\n\n    my($self, $feature) = @_;\n\n    my $ok   = 0;\n    my %facts;\n\n    #SignalP-NN result:\n    #>MGG_11635.5           length = 100\n    ## Measure  Position  Value  Cutoff  signal peptide?\n    #  max. C    37       0.087   0.32   NO\n    #  max. Y    37       0.042   0.33   NO\n    #  max. S     3       0.062   0.87   NO\n    #  mean S     1-36    0.024   0.48   NO\n    #       D     1-36    0.033   0.43   NO\n\n    while(my $line = $self->_readline()){\n\n\tchomp $line;\n\n\tif($line =~ /^SignalP-NN result:/){\n\t    $ok = 1;\n\t    next;\n\t}\n\n\t$self->throw(\"Wrong line for parsing NN results.\") unless $ok;\n\n\tif ($line=~/^\\>(\\S+)\\s+length/) {\n\t    $self->seqname($1);\n\t    %facts = ();\n\t    next;\n\t}\n\telsif($line =~ /max\\.\\s+C\\s+(\\S+)\\s+\\S+\\s+\\S+\\s+(\\S+)/) {\n\t    $feature->{maxCprob} = $1;\n\t    $facts{maxC} = $2;\n\t    next;\n\t}\n\telsif ($line =~ /max\\.\\s+Y\\s+(\\S+)\\s+\\S+\\s+\\S+\\s+(\\S+)/) {\n\t    $feature->{maxYprob} = $1;\n\t    $facts{maxY} = $2;\n\t    next;\n\t}\n\telsif($line =~ /max\\.\\s+S\\s+(\\S+)\\s+\\S+\\s+\\S+\\s+(\\S+)/) {\n\t    $feature->{maxSprob} = $1;\n\t    $facts{maxS} = $2;\n\t    next;\n\t}\n\telsif ($line=~/mean\\s+S\\s+(\\S+)\\s+\\S+\\s+\\S+\\s+(\\S+)/) {\n\t    $feature->{meanSprob} = $1;\n\t    $facts{meanS} = $2;\n\t    next;\n\t}\n\telsif ($line=~/\\s+D\\s+(\\S+)\\s+\\S+\\s+\\S+\\s+(\\S+)/) {\n\t    $feature->{Dprob} = $1;\n\t    $facts{D} = $2;\n\t    next;\n\t}\n\t#If we don't have this line it means that all the factors cutoff are equal to 'NO'\n\telsif ($line =~ /Most likely cleavage site between pos\\.\\s+(\\d+)/) {\n\t    #if($self->_filterok(\\%facts)){\n\t\t#$feature->{name}       = $self->seqname();\n\t\t#$feature->{start}      = 1;\n\t\t$feature->{end}        = $1 + 1; #To be consistent with end given in short format\n\t    #}\n\t    #return $feature;\n\t}\n\telsif($line =~ /^\\s*$/){\n\t    last;\n\t}\n    }\n\n    if($self->_filterok(\\%facts)){\n\t$feature->{name}  = $self->seqname();\n\t$feature->{start} = 1;\n\t$feature->{nnPrediction} = 'signal-peptide';\n    }\n\n    return $feature;\n}\n\n\n=head2 _parse_hmm_result\n\n Title   : _parse_hmm_result\n Usage   : obj->_parse_hmm_result\n Function: Parses the Hiden Markov Model (HMM) part of the result\n Returns : Hash reference\n Args    :\n\n\nsub _parse_hmm_result {\n\n    my ($self, $feature_hash) = @_;\n\n    my $ok = 0;\n\n    #SignalP-HMM result:\n    #>MGG_11635.5\n    #Prediction: Non-secretory protein\n    #Signal peptide probability: 0.000\n    #Signal anchor probability: 0.000\n    #Max cleavage site probability: 0.000 between pos. -1 and  0\n\n    while(my $line = $self->_readline()){\n\n\tchomp $line;\n\tnext if $line =~ /^\\s*$/o;\n\n\tif($line =~ /^SignalP-HMM result:/){\n\t    $ok = 1;\n\t    next;\n\t}\n\n\t$self->throw(\"Wrong line for parsing HMM result.\") unless $ok;\n\n\tif($line =~ /^>(\\S+)/){\n\t    #In case we already seen a name with NN results\n\t    $feature_hash->{name} = $1 unless $self->seqname();\n\t}\n        elsif($line =~ /Prediction: (.+)$/){\n            $feature_hash->{hmmPrediction} = $1;\n        }\n\telsif($line =~ /Signal peptide probability: ([0-9\\.]+)/){\n            $feature_hash->{peptideProb} = $1;\n        }\n\telsif($line =~ /Signal anchor probability: ([0-9\\.]+)/){\n            $feature_hash->{anchorProb} = $1;\n        }\n\telsif($line =~ /Max cleavage site probability: (\\S+) between pos. \\S+ and (\\S+)/){\n\t    $feature_hash->{cleavageSiteProb} = $1;\n\t    #Strange case, if we don't have an end value in NN result (no nn method launched)\n\t    #We try anyway to get an end value, unless this value is lower than 1 which is\n\t    #the start\n\t    $feature_hash->{end}   = $2 if($2 > 1 && !$feature_hash->{end});\n\t    $feature_hash->{start} = 1 unless $feature_hash->{start};\n\t    last;\n\t}\n    }\n\n    return $feature_hash;\n}\n\n=head2 _parse_short_format\n\n Title   : _parse_short_format\n Usage   : $self->_parse_short_format\n Function: Method to parse short format from signalp output\n           It automatically fills filtered features.\n Returns :\n Args    :\n\n\nsub _parse_short_format {\n\n                                my($self) = @_;\n\n    my $ok = 0;\n    my $method = undef;\n    $self->{_oformat} = 'short';\n\n    #Output example\n    # SignalP-NN euk predictions                                   \t                # SignalP-HMM euk predictions\n    # name                Cmax  pos ?  Ymax  pos ?  Smax  pos ?  Smean ?  D     ? \t# name      !  Cmax  pos ?  Sprob ?\n    #Q5A8M1_CANAL          0.085  27 N  0.190  35 N  0.936  27 Y  0.418 N  0.304 N\tQ5A8M1_CANAL  Q  0.001  35 N  0.002 N\n    #O74127_YARLI          0.121  21 N  0.284  21 N  0.953  11 Y  0.826 Y  0.555 Y\tO74127_YARLI  S  0.485  23 N  0.668 Y\n    #Q5VJ86_9PEZI          0.355  24 Y  0.375  24 Y  0.798  12 N  0.447 N  0.411 N\tQ5VJ86_9PEZI  Q  0.180  23 N  0.339 N\n    #Q5A8U5_CANAL          0.085  27 N  0.190  35 N  0.936  27 Y  0.418 N  0.304 N\tQ5A8U5_CANAL  Q  0.001  35 N  0.002 N\n\n    while(my $line = $self->_readline()){\n\t\n\tchomp $line;\n\tnext if $line =~ /^\\s*$|^# name/;\n\n\tif($line =~ /^#/){\n\t    $method = $line =~ /SignalP-NN .+ SignalP-HMM/ ?\n\t                                            'both' : $line =~ /SignalP-NN/ ?\n\t\t\t\t\t\t\t                      'nn' : 'hmm';\n\t    next;\n\t}\n\n\t#$self->throw(\"It looks like the format is not 'short' format.\") unless($ok);\n\n\tmy @data = split(/\\s+/, $line);\n\t$self->seqname($data[0]);\n\n\tmy $factors = { };\n\tmy $feature = { };\n\n\t#NN results gives more fields than HMM\n\tif($method eq 'both' || $method eq 'nn'){\n\n\t    $feature->{maxCprob} = $data[1];\n\t    $factors->{maxC}     = $data[3];\n\t    $feature->{maxYprob} = $data[4];\n\t    $factors->{maxY}     = $data[6];\n\t    $feature->{maxSprob} = $data[7];\n\t    $factors->{maxS}     = $data[9];\n\t    $feature->{meanSprob}= $data[10];\n\t    $factors->{meanS}    = $data[11];\n\t    $feature->{Dprob}    = $data[12];\n\t    $factors->{D}        = $data[13];\n\t    #It looks like the max Y position is reported as the most likely cleavage position\n\t    $feature->{end}      = $data[5];\n\t    $feature->{nnPrediction} = 'signal-peptide';\n\n\t    if($method eq 'both'){\n\t\t$feature->{hmmPrediction}    = $data[15] eq 'Q' ? 'Non-secretory protein' : 'Signal peptide';\n\t\t$feature->{cleavageSiteProb} = $data[16];\n\t\t$feature->{peptideProb}      = $data[19];\n\t    }\n\t}\n\telsif($method eq 'hmm'){\n\t    #In short output anchor probability is not given\n\t    $feature->{hmmPrediction}    = $data[1] eq 'Q' ? 'Non-secretory protein' : 'Signal peptide';\n\t    $feature->{cleavageSiteProb} = $data[2];\n\t    $feature->{peptideProb}      = $data[5];\n\t    #It looks like the max cleavage probability position is given by the Cmax proability\n\t    $feature->{end} = $data[3];\n\t}\n\n\t#Unfortunately, we cannot parse the filters for hmm method.\n\tif($self->_filterok($factors)){\n\t    $feature->{name}        = $self->seqname();\n\t    $feature->{start}       = 1;\n\t    $feature->{source}      = 'Signalp';\n\t    $feature->{primary}     = 'signal_peptide';\n\t    $feature->{program}     = 'Signalp';\n\t    $feature->{logic_name}  = 'signal_peptide';\n\n\t    my $new_feat = $self->create_feature($feature);\n\t    push @{$self->{_features}}, $new_feat if $new_feat;\n\t}\n    }\n\n    return;\n}\n\n=head2 create_feature\n\n Title   : create_feature\n Usage   : obj->create_feature(\\%feature)\n Function: Internal(not to be used directly)\n Returns :\n Args    :\n\n\n\nsub create_feature {\n\n    my ($self, $feat) = @_;\n\n    #If we don't have neither start nor end, we return.\n    unless($feat->{name} && $feat->{start} && $feat->{end}){\n\treturn;\n    }\n\n    # create feature object\n    my $feature = Bio::SeqFeature::Generic->new(\n\t\t\t\t\t\t-seq_id     => $feat->{name},\n\t\t\t\t\t\t-start      => $feat->{start},\n\t\t\t\t\t\t-end        => $feat->{end},\n\t\t\t\t\t\t-score      => defined($feat->{peptideProb}) ? $feat->{peptideProb} : '',\n\t\t\t\t\t\t-source     => 'Signalp',\n\t\t\t\t\t\t-primary    => 'signal_peptide',\n\t\t\t\t\t\t-logic_name => 'signal_peptide',\n\t\t\t\t\t       );\n\n    $feature->add_tag_value('peptideProb', $feat->{peptideProb});\n    $feature->add_tag_value('anchorProb', $feat->{anchorProb});\n    $feature->add_tag_value('evalue',$feat->{anchorProb});\n    $feature->add_tag_value('percent_id','NULL');\n    $feature->add_tag_value(\"hid\",$feat->{primary});\n    $feature->add_tag_value('signalpPrediction', $feat->{hmmPrediction});\n    $feature->add_tag_value('cleavageSiteProb', $feat->{cleavageSiteProb}) if($feat->{cleavageSiteProb});\n    $feature->add_tag_value('nnPrediction', $feat->{nnPrediction})         if($feat->{nnPrediction});\n    $feature->add_tag_value('maxCprob', $feat->{maxCprob})   if(defined($feat->{maxCprob}));\n    $feature->add_tag_value('maxSprob', $feat->{maxSprob})   if(defined($feat->{maxSprob}));\n    $feature->add_tag_value('maxYprob', $feat->{maxYprob})   if(defined($feat->{maxYprob}));\n    $feature->add_tag_value('meanSprob', $feat->{meanSprob}) if(defined($feat->{meanSprob}));\n    $feature->add_tag_value('Dprob', $feat->{Dprob})         if(defined($feat->{Dprob}));\n\n    return $feature;\n\n}\n\n=head2 seqname\n\n Title   : seqname\n Usage   : obj->seqname($name)\n Function: Internal(not to be used directly)\n Returns :\n Args    :"},"name":"seqname","range":{"start":{"line":652,"character":0},"end":{"line":661,"character":9999}}}],"version":5}