{"vars":[{"line":129,"kind":2,"name":"base","containerName":""},{"signature":{"label":"new($proto,%args)","documentation":"1;\n# BioPerl module for Bio::Tools::SiRNA::Ruleset::saigo\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::SiRNA::Ruleset::saigo - Perl object implementing the Saigo\ngroup's rules for designing small inhibitory RNAs\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Instead, use Bio::Tools::SiRNA and\nspecify the saigo ruleset:\n\n  use Bio::Tools::SiRNA;\n\n  my $sirna_designer = Bio::Tools::SiRNA->new( -target => $bio_seq,\n                                               -rules  => 'saigo'\n    );\n  my @pairs = $sirna_designer->design;\n\n  foreach $pair (@pairs) {\n      my $sense_oligo_sequence = $pair->sense->seq;\n      my $antisense_oligo_sequence = $pair->antisense->seq;\n\n      # print out results\n      print join (\"\\t\", $pair->start, $pair->end, $pair->rank,\n                  $sense_oligo_sequence, $antisense_oligo_sequence), \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis package implements the rules for designing siRNA reagents\npublished by Ui-Tei et al (2004).  The rules are:\n\n=over 5\n\n* 1.\n\nThe first base in the sense strand of the duplex must be a G or C\n\n* 2.\n\nThe first base in the antisense strand of the duplex must be an A or U\n\n* 3.\n\nThe first 7 nucleotides in the antisense strand of the duplex must be\nA or U\n\n* 4.\n\nThere cannot be more than 9 consecutive G or C nucleotides\n\n* 5.\n\nThe first 12 nucleotides in the sense strand of the duplex should have\n33-66% GC\n\n\nThe module inherits from Bio::Tools::SiRNA.  See the documentation for\nthat module for information on how to specify the target and recover\nthe SiRNA duplex information.\n\n=head2 EXPORT\n\nNone.\n\n=head1 SEE ALSO\n\nL<Bio::Tools::SiRNA>, \nL<Bio::SeqFeature::SiRNA::Pair>,\nL<Bio::SeqFeature::SiRNA::Oligo>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDonald Jackson (donald.jackson@bms.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::SiRNA::Ruleset::saigo;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Tools::SiRNA);\n\n=head2 new\n\n  Title\t: new\n  Usage  : Do not call directly - use Bio::Tools::SiRNA->new instead.\n  Returns : Bio::Tools::SiRNA::Ruleset::saigo object\n  Args\t: none","parameters":[{"label":"$proto"},{"label":"%args"}]},"detail":"($proto,%args)","definition":"sub","containerName":"main::","children":[{"line":141,"kind":13,"localvar":"my","name":"$proto","definition":"my","containerName":"new"},{"kind":13,"line":141,"name":"%args","containerName":"new"},{"line":142,"kind":13,"localvar":"my","definition":"my","name":"$class","containerName":"new"},{"name":"$proto","containerName":"new","kind":13,"line":142},{"containerName":"new","name":"$proto","kind":13,"line":142},{"containerName":"new","name":"$args","kind":13,"line":144},{"line":146,"kind":13,"containerName":"new","name":"$class"},{"line":146,"kind":13,"containerName":"new","name":"%args"}],"line":140,"kind":12,"range":{"end":{"character":9999,"line":147},"start":{"line":140,"character":0}},"name":"new"},{"line":146,"kind":12,"containerName":"new","name":"SUPER"},{"line":149,"children":[{"kind":13,"line":150,"definition":"my","name":"$self","containerName":"_get_oligos","localvar":"my"},{"localvar":"my","containerName":"_get_oligos","name":"$targseq","definition":"my","line":152,"kind":13},{"name":"$targstart","containerName":"_get_oligos","kind":13,"line":152},{"kind":13,"line":152,"name":"$self","containerName":"_get_oligos"},{"kind":12,"line":152,"name":"_get_targetregion","containerName":"_get_oligos"},{"containerName":"_get_oligos","name":"$i","definition":"my","localvar":"my","kind":13,"line":154},{"containerName":"_get_oligos","name":"$targseq","kind":13,"line":154},{"localvar":"my","name":"$testseq","definition":"my","containerName":"_get_oligos","line":155,"kind":13},{"kind":13,"line":155,"containerName":"_get_oligos","name":"$targseq"},{"containerName":"_get_oligos","name":"$i","line":155,"kind":13},{"kind":13,"line":156,"containerName":"_get_oligos","name":"$self"},{"containerName":"_get_oligos","name":"add_oligos","kind":12,"line":156},{"line":156,"kind":13,"containerName":"_get_oligos","name":"$testseq"},{"line":156,"kind":13,"name":"$targstart","containerName":"_get_oligos"},{"name":"$i","containerName":"_get_oligos","kind":13,"line":156},{"containerName":"_get_oligos","name":"$self","line":156,"kind":13},{"line":156,"kind":12,"containerName":"_get_oligos","name":"_oligo_ok"},{"line":156,"kind":13,"containerName":"_get_oligos","name":"$testseq"}],"kind":12,"detail":"($self)","signature":{"label":"_get_oligos($self)","parameters":[{"label":"$self"}],"documentation":""},"containerName":"main::","definition":"sub","range":{"end":{"line":158,"character":9999},"start":{"character":0,"line":149}},"name":"_get_oligos"},{"range":{"start":{"character":0,"line":161},"end":{"character":9999,"line":169}},"name":"_get_sense","line":161,"children":[{"line":162,"kind":13,"localvar":"my","containerName":"_get_sense","name":"$self","definition":"my"},{"name":"$target","containerName":"_get_sense","line":162,"kind":13},{"line":164,"kind":13,"name":"$target","containerName":"_get_sense"},{"kind":13,"line":166,"name":"$target","containerName":"_get_sense"},{"containerName":"_get_sense","name":"$target","line":168,"kind":13}],"kind":12,"detail":"($self,$target)","signature":{"parameters":[{"label":"$self"},{"label":"$target"}],"documentation":"","label":"_get_sense($self,$target)"},"containerName":"main::","definition":"sub"},{"detail":"($self,$target)","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$target"}],"label":"_get_anti($self,$target)"},"containerName":"main::","definition":"sub","line":171,"children":[{"localvar":"my","containerName":"_get_anti","definition":"my","name":"$self","line":172,"kind":13},{"line":172,"kind":13,"containerName":"_get_anti","name":"$target"},{"containerName":"_get_anti","definition":"my","name":"@target","localvar":"my","kind":13,"line":173},{"line":173,"kind":13,"name":"$target","containerName":"_get_anti"},{"kind":13,"line":174,"definition":"my","name":"$nt","containerName":"_get_anti","localvar":"my"},{"line":174,"kind":13,"name":"@antitarget","containerName":"_get_anti"},{"name":"$nt","containerName":"_get_anti","line":176,"kind":13},{"kind":13,"line":176,"containerName":"_get_anti","name":"@target"},{"containerName":"_get_anti","name":"@antitarget","kind":13,"line":177},{"containerName":"_get_anti","name":"$self","line":177,"kind":13},{"line":177,"kind":12,"name":"_comp","containerName":"_get_anti"},{"containerName":"_get_anti","name":"$nt","line":177,"kind":13},{"line":179,"kind":13,"localvar":"my","containerName":"_get_anti","name":"$anti","definition":"my"},{"name":"@antitarget","containerName":"_get_anti","line":179,"kind":13},{"line":181,"kind":13,"containerName":"_get_anti","name":"$anti"},{"name":"$anti","containerName":"_get_anti","line":183,"kind":13},{"containerName":"_get_anti","name":"$anti","line":185,"kind":13}],"kind":12,"range":{"start":{"line":171,"character":0},"end":{"line":186,"character":9999}},"name":"_get_anti"},{"children":[{"localvar":"my","containerName":"_oligo_ok","definition":"my","name":"$self","line":189,"kind":13},{"line":189,"kind":13,"containerName":"_oligo_ok","name":"$testseq"},{"name":"$self","containerName":"_oligo_ok","line":191,"kind":13},{"line":191,"kind":12,"name":"debug","containerName":"_oligo_ok"},{"kind":13,"line":193,"containerName":"_oligo_ok","definition":"my","name":"@testseq","localvar":"my"},{"name":"$testseq","containerName":"_oligo_ok","kind":13,"line":193},{"containerName":"_oligo_ok","name":"$testseq","line":195,"kind":13},{"containerName":"_oligo_ok","name":"$self","line":196,"kind":13},{"containerName":"_oligo_ok","name":"debug","kind":12,"line":196},{"line":200,"kind":13,"containerName":"_oligo_ok","name":"$testseq"},{"name":"$self","containerName":"_oligo_ok","line":201,"kind":13},{"containerName":"_oligo_ok","name":"debug","line":201,"kind":12},{"localvar":"my","containerName":"_oligo_ok","definition":"my","name":"$atcount_3p","line":206,"kind":13},{"line":206,"kind":13,"name":"@testseq","containerName":"_oligo_ok"},{"name":"$atcount_3p","containerName":"_oligo_ok","line":207,"kind":13},{"line":208,"kind":13,"name":"$self","containerName":"_oligo_ok"},{"kind":12,"line":208,"name":"debug","containerName":"_oligo_ok"},{"localvar":"my","name":"$gccount_5p","definition":"my","containerName":"_oligo_ok","line":212,"kind":13},{"name":"@testseq","containerName":"_oligo_ok","kind":13,"line":212},{"name":"$gccount_5p","containerName":"_oligo_ok","line":213,"kind":13},{"kind":13,"line":214,"name":"$self","containerName":"_oligo_ok"},{"kind":12,"line":214,"containerName":"_oligo_ok","name":"debug"},{"kind":13,"line":217,"name":"$gccount_5p","containerName":"_oligo_ok"},{"line":218,"kind":13,"containerName":"_oligo_ok","name":"$self"},{"name":"debug","containerName":"_oligo_ok","kind":12,"line":218},{"containerName":"_oligo_ok","name":"$testseq","kind":13,"line":223},{"line":224,"kind":13,"containerName":"_oligo_ok","name":"$self"},{"kind":12,"line":224,"name":"debug","containerName":"_oligo_ok"},{"name":"$self","containerName":"_oligo_ok","kind":13,"line":228},{"containerName":"_oligo_ok","name":"debug","kind":12,"line":228}],"line":188,"kind":12,"signature":{"label":"_oligo_ok($self,$testseq)","parameters":[{"label":"$self"},{"label":"$testseq"}],"documentation":""},"detail":"($self,$testseq)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":188},"end":{"character":9999,"line":230}},"name":"_oligo_ok"}],"version":5}