{"version":5,"vars":[{"name":"base","containerName":"","kind":2,"line":75},{"detail":"($class,@args)","signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: Hmmpfam.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::Tools::Hmmpfam\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by  Balamurugan Kumarasamy\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n#\n\n=head1 NAME\n\nBio::Tools::Hmmpfam - Parser for Hmmpfam program\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Hmmpfam;\n  my @hmmpfam_feat;\n  my $hmmpfam_parser = Bio::Tools::Hmmpfam->new(-fh =>$filehandle );\n  while( my $hmmpfam_feat = $hmmpfam_parser->next_result ) {\n        push @hmmpfam_feat, $hmmpfam_feat;\n  }\n\n=head1 DESCRIPTION\n\nParser for Hmmpfam  program.  See also L<Bio::SearchIO::hmmer>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n User feedback is an integral part of the evolution of this and other\n Bioperl modules. Send your comments and suggestions preferably to\n the Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Balamurugan Kumarasamy\n\n Email: fugui@worf.fugu-sg.org\n\n=head1 APPENDIX\n\n The rest of the documentation details each of the object methods.\n Internal methods are usually preceded with a _\n\n\n\npackage Bio::Tools::Hmmpfam;\nuse strict;\n\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Generic;\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Hmmpfam->new(-fh=>$filehandle);\n Function: Builds a new Bio::Tools::Hmmpfam object\n Returns : Bio::Tools::Hmmpfam\n Args    : -filename\n           -fh (filehandle)","parameters":[{"label":"$class"},{"label":"@args"}]},"containerName":"main::","definition":"sub","line":90,"children":[{"line":91,"kind":13,"localvar":"my","definition":"my","name":"$class","containerName":"new"},{"kind":13,"line":91,"containerName":"new","name":"@args"},{"containerName":"new","definition":"my","name":"$self","localvar":"my","kind":13,"line":93},{"line":93,"kind":13,"name":"$class","containerName":"new"},{"line":93,"kind":13,"containerName":"new","name":"@args"},{"name":"$self","containerName":"new","kind":13,"line":94},{"kind":12,"line":94,"containerName":"new","name":"_initialize_io"},{"containerName":"new","name":"@args","line":94,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":96}],"kind":12,"range":{"start":{"line":90,"character":0},"end":{"character":9999,"line":97}},"name":"new"},{"line":93,"kind":12,"name":"SUPER","containerName":"new"},{"definition":"sub","containerName":"main::","signature":{"label":"next_result($self)","documentation":"1;\n# $Id: Hmmpfam.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::Tools::Hmmpfam\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by  Balamurugan Kumarasamy\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n#\n\n=head1 NAME\n\nBio::Tools::Hmmpfam - Parser for Hmmpfam program\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Hmmpfam;\n  my @hmmpfam_feat;\n  my $hmmpfam_parser = Bio::Tools::Hmmpfam->new(-fh =>$filehandle );\n  while( my $hmmpfam_feat = $hmmpfam_parser->next_result ) {\n        push @hmmpfam_feat, $hmmpfam_feat;\n  }\n\n=head1 DESCRIPTION\n\nParser for Hmmpfam  program.  See also L<Bio::SearchIO::hmmer>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n User feedback is an integral part of the evolution of this and other\n Bioperl modules. Send your comments and suggestions preferably to\n the Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Balamurugan Kumarasamy\n\n Email: fugui@worf.fugu-sg.org\n\n=head1 APPENDIX\n\n The rest of the documentation details each of the object methods.\n Internal methods are usually preceded with a _\n\n\n\npackage Bio::Tools::Hmmpfam;\nuse strict;\n\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Generic;\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Hmmpfam->new(-fh=>$filehandle);\n Function: Builds a new Bio::Tools::Hmmpfam object\n Returns : Bio::Tools::Hmmpfam\n Args    : -filename\n           -fh (filehandle)\n\n\nsub new {\n      my($class,@args) = @_;\n\n      my $self = $class->SUPER::new(@args);\n      $self->_initialize_io(@args);\n\n      return $self;\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $feat = $hmmpfam_parser->next_result\n Function: Get the next result set from parser data\n Returns : L<Bio::SeqFeature::Generic>\n Args    : none","parameters":[{"label":"$self"}]},"detail":"($self)","kind":12,"children":[{"line":111,"kind":13,"localvar":"my","containerName":"next_result","name":"$self","definition":"my"},{"localvar":"my","containerName":"next_result","definition":"my","name":"$filehandle","line":112,"kind":13},{"definition":"my","name":"$line","containerName":"next_result","localvar":"my","kind":13,"line":114},{"definition":"my","name":"$id","containerName":"next_result","localvar":"my","kind":13,"line":116},{"name":"$self","containerName":"next_result","line":117,"kind":13},{"kind":12,"line":117,"name":"_readline","containerName":"next_result"},{"containerName":"next_result","name":"$line","kind":13,"line":118},{"line":119,"kind":13,"name":"$line","containerName":"next_result"},{"line":121,"kind":13,"name":"$line","containerName":"next_result"},{"localvar":"my","name":"$rest","definition":"my","containerName":"next_result","line":122,"kind":13},{"name":"$self","containerName":"next_result","line":122,"kind":13},{"name":"_readline","containerName":"next_result","kind":12,"line":122},{"kind":13,"line":122,"name":"$rest","containerName":"next_result"},{"name":"$line","containerName":"next_result","kind":13,"line":125},{"line":127,"kind":13,"containerName":"next_result","name":"$line"},{"kind":13,"line":128,"containerName":"next_result","name":"$id"},{"containerName":"next_result","name":"$self","line":129,"kind":13},{"containerName":"next_result","name":"seqname","kind":12,"line":129},{"name":"$id","containerName":"next_result","line":129,"kind":13},{"localvar":"my","containerName":"next_result","name":"$hid","definition":"my","line":132,"kind":13},{"line":132,"kind":13,"name":"$start","containerName":"next_result"},{"containerName":"next_result","name":"$end","line":132,"kind":13},{"name":"$hstart","containerName":"next_result","kind":13,"line":132},{"containerName":"next_result","name":"$hend","kind":13,"line":132},{"line":132,"kind":13,"containerName":"next_result","name":"$score"},{"name":"$evalue","containerName":"next_result","line":132,"kind":13},{"containerName":"next_result","name":"$line","line":132,"kind":13},{"kind":13,"line":133,"containerName":"next_result","name":"%feature","definition":"my","localvar":"my"},{"containerName":"next_result","name":"$feature","line":135,"kind":13},{"containerName":"next_result","name":"$self","line":135,"kind":13},{"name":"seqname","containerName":"next_result","line":135,"kind":12},{"name":"$feature","containerName":"next_result","line":136,"kind":13},{"line":136,"kind":13,"name":"$score","containerName":"next_result"},{"containerName":"next_result","name":"$feature","kind":13,"line":137},{"containerName":"next_result","name":"$evalue","kind":13,"line":137},{"kind":13,"line":138,"name":"$feature","containerName":"next_result"},{"kind":13,"line":138,"name":"$feature","containerName":"next_result"},{"name":"$feature","containerName":"next_result","kind":13,"line":139},{"containerName":"next_result","name":"$start","line":139,"kind":13},{"name":"$feature","containerName":"next_result","line":140,"kind":13},{"containerName":"next_result","name":"$end","line":140,"kind":13},{"kind":13,"line":141,"containerName":"next_result","name":"$feature"},{"line":141,"kind":13,"containerName":"next_result","name":"$hid"},{"containerName":"next_result","name":"$feature","kind":13,"line":142},{"name":"$hstart","containerName":"next_result","kind":13,"line":142},{"line":143,"kind":13,"containerName":"next_result","name":"$feature"},{"kind":13,"line":143,"containerName":"next_result","name":"$hend"},{"name":"$feature","containerName":"next_result","line":144,"kind":13},{"line":145,"kind":13,"name":"$feature","containerName":"next_result"},{"containerName":"next_result","name":"$hid","line":145,"kind":13},{"name":"$feature","containerName":"next_result","kind":13,"line":146},{"containerName":"next_result","name":"$feature","kind":13,"line":147},{"kind":13,"line":148,"containerName":"next_result","name":"$feature"},{"kind":13,"line":149,"containerName":"next_result","name":"$new_feat","definition":"my","localvar":"my"},{"name":"$self","containerName":"next_result","line":149,"kind":13},{"kind":12,"line":149,"containerName":"next_result","name":"create_feature"},{"containerName":"next_result","name":"%feature","kind":13,"line":149},{"name":"$new_feat","containerName":"next_result","line":151,"kind":13}],"line":110,"name":"next_result","range":{"start":{"character":0,"line":110},"end":{"line":157,"character":9999}}},{"kind":12,"line":135,"name":"name"},{"line":136,"kind":12,"name":"raw_score"},{"name":"p_value","kind":12,"line":137},{"name":"score","line":138,"kind":12},{"line":138,"kind":12,"name":"p_value"},{"line":139,"kind":12,"name":"start"},{"line":140,"kind":12,"name":"end"},{"line":141,"kind":12,"name":"hname"},{"line":142,"kind":12,"name":"hstart"},{"name":"hend","line":143,"kind":12},{"name":"source","line":144,"kind":12},{"name":"primary","line":145,"kind":12},{"kind":12,"line":146,"name":"program"},{"name":"db","kind":12,"line":147},{"name":"logic_name","line":148,"kind":12},{"range":{"start":{"character":0,"line":170},"end":{"character":9999,"line":202}},"name":"create_feature","signature":{"label":"create_feature($self,$feat)","parameters":[{"label":"$self"},{"label":"$feat"}],"documentation":"1;\n# $Id: Hmmpfam.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::Tools::Hmmpfam\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by  Balamurugan Kumarasamy\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n#\n\n=head1 NAME\n\nBio::Tools::Hmmpfam - Parser for Hmmpfam program\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Hmmpfam;\n  my @hmmpfam_feat;\n  my $hmmpfam_parser = Bio::Tools::Hmmpfam->new(-fh =>$filehandle );\n  while( my $hmmpfam_feat = $hmmpfam_parser->next_result ) {\n        push @hmmpfam_feat, $hmmpfam_feat;\n  }\n\n=head1 DESCRIPTION\n\nParser for Hmmpfam  program.  See also L<Bio::SearchIO::hmmer>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n User feedback is an integral part of the evolution of this and other\n Bioperl modules. Send your comments and suggestions preferably to\n the Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Balamurugan Kumarasamy\n\n Email: fugui@worf.fugu-sg.org\n\n=head1 APPENDIX\n\n The rest of the documentation details each of the object methods.\n Internal methods are usually preceded with a _\n\n\n\npackage Bio::Tools::Hmmpfam;\nuse strict;\n\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Generic;\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Hmmpfam->new(-fh=>$filehandle);\n Function: Builds a new Bio::Tools::Hmmpfam object\n Returns : Bio::Tools::Hmmpfam\n Args    : -filename\n           -fh (filehandle)\n\n\nsub new {\n      my($class,@args) = @_;\n\n      my $self = $class->SUPER::new(@args);\n      $self->_initialize_io(@args);\n\n      return $self;\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $feat = $hmmpfam_parser->next_result\n Function: Get the next result set from parser data\n Returns : L<Bio::SeqFeature::Generic>\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $filehandle;\n    \n my $line;\n\n    my $id;\n    while ($_=$self->_readline()) {\n         $line = $_;\n         chomp $line;\n    \n        if ( $line=~m/^Alignments of top-scoring domains/ ) {\n          while( my $rest = $self->_readline() ) { last if $rest =~ m!^//! }\n        }\n\n        next if ($line=~m/^Model/ || /^\\-/ || /^$/);\n        \n        if ($line=~m/^Query sequence:\\s+(\\S+)/) {\n           $id = $1;\n           $self->seqname($id);\n        }\n       \n       if (my ($hid, $start, $end, $hstart, $hend, $score, $evalue) = $line=~m/^(\\S+)\\s+\\S+\\s+(\\d+)\\s+(\\d+)\\s+\\S+\\s+(\\d+)\\s+(\\d+)\\s+\\S+\\s+(\\S+)\\s+(\\S+)/) {\n            my %feature;\n            \n            ($feature{name}) = $self->seqname;\n            $feature{raw_score} = $score;\n            $feature{p_value} = sprintf (\"%.3e\", $evalue);\n            $feature{score} = $feature{p_value};\n            $feature{start} = $start;\n            $feature{end} = $end;\n            $feature{hname} = $hid;\n            $feature{hstart} = $hstart;\n            $feature{hend} = $hend;\n            ($feature{source}) = 'pfam';\n            $feature{primary} = $hid;\n            ($feature{program}) = 'pfam';\n            ($feature{db}) = 'db1';\n            ($feature{logic_name}) = 'hmmpfam';\n            my $new_feat = $self->create_feature (\\%feature);\n            return $new_feat\n        \n        }\n        next;\n\n    }\n    return;\n}\n\n=head2 create_feature\n\n Title   : create_feature\n Usage   : my $feat=$hmmpfam_parser->create_feature($feature,$seqname)\n Function: creates a SeqFeature Generic object\n Returns : L<Bio::SeqFeature::Generic>\n Args    :"},"detail":"($self,$feat)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":171,"name":"$self","definition":"my","containerName":"create_feature","localvar":"my"},{"kind":13,"line":171,"name":"$feat","containerName":"create_feature"},{"line":175,"kind":13,"localvar":"my","containerName":"create_feature","definition":"my","name":"$feature1"},{"line":175,"kind":12,"containerName":"create_feature","name":"new"},{"name":"$feat","containerName":"create_feature","kind":13,"line":175},{"name":"$feat","containerName":"create_feature","kind":13,"line":176},{"line":177,"kind":13,"containerName":"create_feature","name":"$feat"},{"line":178,"kind":13,"name":"$feat","containerName":"create_feature"},{"name":"$feat","containerName":"create_feature","line":179,"kind":13},{"name":"$feat","containerName":"create_feature","kind":13,"line":180},{"name":"$feature2","definition":"my","containerName":"create_feature","localvar":"my","kind":13,"line":185},{"name":"new","containerName":"create_feature","kind":12,"line":185},{"name":"$feat","containerName":"create_feature","kind":13,"line":186},{"containerName":"create_feature","name":"$feat","line":187,"kind":13},{"kind":13,"line":193,"definition":"my","name":"$featurepair","containerName":"create_feature","localvar":"my"},{"name":"new","containerName":"create_feature","line":193,"kind":12},{"containerName":"create_feature","name":"$featurepair","line":194,"kind":13},{"name":"feature1","containerName":"create_feature","line":194,"kind":12},{"line":194,"kind":13,"containerName":"create_feature","name":"$feature1"},{"kind":13,"line":195,"name":"$featurepair","containerName":"create_feature"},{"line":195,"kind":12,"containerName":"create_feature","name":"feature2"},{"name":"$feature2","containerName":"create_feature","line":195,"kind":13},{"kind":13,"line":197,"name":"$featurepair","containerName":"create_feature"},{"containerName":"create_feature","name":"add_tag_value","kind":12,"line":197},{"containerName":"create_feature","name":"$feat","kind":13,"line":197},{"name":"$featurepair","containerName":"create_feature","kind":13,"line":198},{"containerName":"create_feature","name":"add_tag_value","line":198,"kind":12},{"line":199,"kind":13,"name":"$featurepair","containerName":"create_feature"},{"name":"add_tag_value","containerName":"create_feature","line":199,"kind":12},{"line":199,"kind":13,"name":"$feat","containerName":"create_feature"},{"line":200,"kind":13,"name":"$featurepair","containerName":"create_feature"}],"line":170,"kind":12},{"kind":12,"line":175,"containerName":"SeqFeature::Generic","name":"Bio"},{"name":"name","kind":12,"line":175},{"line":176,"kind":12,"name":"start"},{"name":"end","kind":12,"line":177},{"kind":12,"line":178,"name":"score"},{"name":"source","line":179,"kind":12},{"line":180,"kind":12,"name":"primary"},{"kind":12,"line":185,"name":"Bio","containerName":"SeqFeature::Generic"},{"name":"hstart","line":186,"kind":12},{"line":187,"kind":12,"name":"hend"},{"kind":12,"line":193,"containerName":"SeqFeature::FeaturePair","name":"Bio"},{"name":"p_value","line":197,"kind":12},{"name":"primary","line":199,"kind":12},{"range":{"end":{"line":224,"character":9999},"start":{"line":214,"character":0}},"name":"seqname","children":[{"kind":13,"line":215,"definition":"my","name":"$self","containerName":"seqname","localvar":"my"},{"line":215,"kind":13,"containerName":"seqname","name":"$seqname"},{"line":217,"kind":13,"containerName":"seqname","name":"$seqname"},{"name":"$self","containerName":"seqname","kind":13,"line":219},{"name":"$seqname","containerName":"seqname","line":219,"kind":13},{"line":222,"kind":13,"name":"$self","containerName":"seqname"}],"line":214,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$seqname"}],"documentation":"1;\n# $Id: Hmmpfam.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::Tools::Hmmpfam\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by  Balamurugan Kumarasamy\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n#\n\n=head1 NAME\n\nBio::Tools::Hmmpfam - Parser for Hmmpfam program\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Hmmpfam;\n  my @hmmpfam_feat;\n  my $hmmpfam_parser = Bio::Tools::Hmmpfam->new(-fh =>$filehandle );\n  while( my $hmmpfam_feat = $hmmpfam_parser->next_result ) {\n        push @hmmpfam_feat, $hmmpfam_feat;\n  }\n\n=head1 DESCRIPTION\n\nParser for Hmmpfam  program.  See also L<Bio::SearchIO::hmmer>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n User feedback is an integral part of the evolution of this and other\n Bioperl modules. Send your comments and suggestions preferably to\n the Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Balamurugan Kumarasamy\n\n Email: fugui@worf.fugu-sg.org\n\n=head1 APPENDIX\n\n The rest of the documentation details each of the object methods.\n Internal methods are usually preceded with a _\n\n\n\npackage Bio::Tools::Hmmpfam;\nuse strict;\n\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Generic;\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Hmmpfam->new(-fh=>$filehandle);\n Function: Builds a new Bio::Tools::Hmmpfam object\n Returns : Bio::Tools::Hmmpfam\n Args    : -filename\n           -fh (filehandle)\n\n\nsub new {\n      my($class,@args) = @_;\n\n      my $self = $class->SUPER::new(@args);\n      $self->_initialize_io(@args);\n\n      return $self;\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $feat = $hmmpfam_parser->next_result\n Function: Get the next result set from parser data\n Returns : L<Bio::SeqFeature::Generic>\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $filehandle;\n    \n my $line;\n\n    my $id;\n    while ($_=$self->_readline()) {\n         $line = $_;\n         chomp $line;\n    \n        if ( $line=~m/^Alignments of top-scoring domains/ ) {\n          while( my $rest = $self->_readline() ) { last if $rest =~ m!^//! }\n        }\n\n        next if ($line=~m/^Model/ || /^\\-/ || /^$/);\n        \n        if ($line=~m/^Query sequence:\\s+(\\S+)/) {\n           $id = $1;\n           $self->seqname($id);\n        }\n       \n       if (my ($hid, $start, $end, $hstart, $hend, $score, $evalue) = $line=~m/^(\\S+)\\s+\\S+\\s+(\\d+)\\s+(\\d+)\\s+\\S+\\s+(\\d+)\\s+(\\d+)\\s+\\S+\\s+(\\S+)\\s+(\\S+)/) {\n            my %feature;\n            \n            ($feature{name}) = $self->seqname;\n            $feature{raw_score} = $score;\n            $feature{p_value} = sprintf (\"%.3e\", $evalue);\n            $feature{score} = $feature{p_value};\n            $feature{start} = $start;\n            $feature{end} = $end;\n            $feature{hname} = $hid;\n            $feature{hstart} = $hstart;\n            $feature{hend} = $hend;\n            ($feature{source}) = 'pfam';\n            $feature{primary} = $hid;\n            ($feature{program}) = 'pfam';\n            ($feature{db}) = 'db1';\n            ($feature{logic_name}) = 'hmmpfam';\n            my $new_feat = $self->create_feature (\\%feature);\n            return $new_feat\n        \n        }\n        next;\n\n    }\n    return;\n}\n\n=head2 create_feature\n\n Title   : create_feature\n Usage   : my $feat=$hmmpfam_parser->create_feature($feature,$seqname)\n Function: creates a SeqFeature Generic object\n Returns : L<Bio::SeqFeature::Generic>\n Args    :\n\n\n\nsub create_feature {\n    my ($self, $feat) = @_;\n\n\n\n    my $feature1= Bio::SeqFeature::Generic->new( -seq_id  =>$feat->{name},\n                                                -start      =>$feat->{start},\n                                                -end        =>$feat->{end},\n                                                -score      =>$feat->{score},\n                                                -source     =>$feat->{source},\n                                                -primary    =>$feat->{primary},\n                                                   );\n    \n\n\n    my $feature2= Bio::SeqFeature::Generic->new(\n                                                 -start      =>$feat->{hstart},\n                                                 -end        =>$feat->{hend},\n                                                  );\n\n\n\n\n    my $featurepair = Bio::SeqFeature::FeaturePair->new;\n    $featurepair->feature1 ($feature1);\n    $featurepair->feature2 ($feature2);\n   \n   $featurepair->add_tag_value('evalue',$feat->{p_value});\n   $featurepair->add_tag_value('percent_id','NULL');\n   $featurepair->add_tag_value(\"hid\",$feat->{primary});\n    return  $featurepair; \n        \n}\n\n=head2 seqname\n\n Title   :   seqname\n Usage   :   obj->seqname($seqname)\n Function:   Internal(not to be used directly)\n Returns :\n Args    :   seqname","label":"seqname($self,$seqname)"},"detail":"($self,$seqname)","definition":"sub","containerName":"main::"}]}