{"vars":[{"containerName":"","name":"base","line":113,"kind":2},{"localvar":"my","containerName":null,"definition":"my","name":"%ExonTags","line":115,"kind":13},{"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"","label":"_initialize_state($self,@args)"},"kind":12,"line":120,"children":[{"definition":"my","name":"$self","containerName":"_initialize_state","localvar":"my","kind":13,"line":121},{"kind":13,"line":121,"containerName":"_initialize_state","name":"@args"},{"containerName":"_initialize_state","name":"$self","line":124,"kind":13},{"line":124,"kind":13,"containerName":"_initialize_state","name":"@args"},{"line":127,"kind":13,"name":"$self","containerName":"_initialize_state"},{"kind":13,"line":128,"name":"$self","containerName":"_initialize_state"},{"line":130,"kind":13,"containerName":"_initialize_state","name":"$self"},{"name":"$self","containerName":"_initialize_state","line":132,"kind":13}],"name":"_initialize_state","range":{"end":{"line":133,"character":9999},"start":{"line":120,"character":0}}},{"line":124,"kind":12,"name":"SUPER","containerName":"_initialize_state"},{"definition":"sub","containerName":"main::","signature":{"label":"analysis_method($self,$method)","documentation":"1;\n# $Id: Genscan.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Genscan\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Genscan - Results of one Genscan run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Genscan;\n\n   $genscan = Bio::Tools::Genscan->new(-file => 'result.genscan');\n   # filehandle:\n   $genscan = Bio::Tools::Genscan->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $genscan->next_feature() is the same\n   while($gene = $genscan->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene, which inherits\n       # off Bio::SeqFeature::Gene::Transcript.\n       #\n       # $gene->exons() returns an array of \n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n       # singleton exons: \n       ($single_exon) = $gene->exons();\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $genscan->close();\n\n=head1 DESCRIPTION\n\nThe Genscan module provides a parser for Genscan gene structure prediction\noutput. It parses one gene prediction into a Bio::SeqFeature::Gene::Transcript-\nderived object.\n\nThis module also implements the Bio::SeqAnalysisParserI interface, and thus\ncan be used wherever such an object fits. See L<Bio::SeqAnalysisParserI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Genscan;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nmy %ExonTags = ('Init' => 'Initial',\n\t\t'Intr' => 'Internal',\n\t\t'Term' => 'Terminal',\n\t\t'Sngl' => '');\n    \nsub _initialize_state {\n    my ($self,@args) = @_;\n    \n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $genscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /genscan/i.\n Returns   : String\n Argument  : n/a","parameters":[{"label":"$self"},{"label":"$method"}]},"detail":"($self,$method)","kind":12,"children":[{"containerName":"analysis_method","definition":"my","name":"$self","localvar":"my","kind":13,"line":148},{"kind":13,"line":148,"name":"$method","containerName":"analysis_method"},{"name":"$method","containerName":"analysis_method","kind":13,"line":149},{"kind":13,"line":149,"containerName":"analysis_method","name":"$method"},{"kind":13,"line":150,"name":"$self","containerName":"analysis_method"},{"line":150,"kind":12,"name":"throw","containerName":"analysis_method"},{"name":"$self","containerName":"analysis_method","line":150,"kind":13},{"name":"$self","containerName":"analysis_method","kind":13,"line":152},{"line":152,"kind":13,"containerName":"analysis_method","name":"$method"}],"line":146,"name":"analysis_method","range":{"end":{"line":153,"character":9999},"start":{"character":0,"line":146}}},{"name":"SUPER","containerName":"analysis_method","kind":12,"line":152},{"definition":"sub","containerName":"main::","signature":{"label":"next_feature($self,@args)","documentation":"1;\n# $Id: Genscan.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Genscan\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Genscan - Results of one Genscan run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Genscan;\n\n   $genscan = Bio::Tools::Genscan->new(-file => 'result.genscan');\n   # filehandle:\n   $genscan = Bio::Tools::Genscan->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $genscan->next_feature() is the same\n   while($gene = $genscan->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene, which inherits\n       # off Bio::SeqFeature::Gene::Transcript.\n       #\n       # $gene->exons() returns an array of \n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n       # singleton exons: \n       ($single_exon) = $gene->exons();\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $genscan->close();\n\n=head1 DESCRIPTION\n\nThe Genscan module provides a parser for Genscan gene structure prediction\noutput. It parses one gene prediction into a Bio::SeqFeature::Gene::Transcript-\nderived object.\n\nThis module also implements the Bio::SeqAnalysisParserI interface, and thus\ncan be used wherever such an object fits. See L<Bio::SeqAnalysisParserI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Genscan;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nmy %ExonTags = ('Init' => 'Initial',\n\t\t'Intr' => 'Internal',\n\t\t'Term' => 'Terminal',\n\t\t'Sngl' => '');\n    \nsub _initialize_state {\n    my ($self,@args) = @_;\n    \n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $genscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /genscan/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /genscan/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $genscan->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Genscan result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","kind":12,"children":[{"containerName":"next_feature","name":"$self","definition":"my","localvar":"my","kind":13,"line":176},{"name":"@args","containerName":"next_feature","kind":13,"line":176},{"kind":13,"line":180,"name":"$self","containerName":"next_feature"},{"name":"next_prediction","containerName":"next_feature","kind":12,"line":180},{"containerName":"next_feature","name":"@args","line":180,"kind":13}],"line":175,"name":"next_feature","range":{"end":{"character":9999,"line":181},"start":{"character":0,"line":175}}},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Genscan.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Genscan\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Genscan - Results of one Genscan run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Genscan;\n\n   $genscan = Bio::Tools::Genscan->new(-file => 'result.genscan');\n   # filehandle:\n   $genscan = Bio::Tools::Genscan->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $genscan->next_feature() is the same\n   while($gene = $genscan->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene, which inherits\n       # off Bio::SeqFeature::Gene::Transcript.\n       #\n       # $gene->exons() returns an array of \n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n       # singleton exons: \n       ($single_exon) = $gene->exons();\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $genscan->close();\n\n=head1 DESCRIPTION\n\nThe Genscan module provides a parser for Genscan gene structure prediction\noutput. It parses one gene prediction into a Bio::SeqFeature::Gene::Transcript-\nderived object.\n\nThis module also implements the Bio::SeqAnalysisParserI interface, and thus\ncan be used wherever such an object fits. See L<Bio::SeqAnalysisParserI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Genscan;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nmy %ExonTags = ('Init' => 'Initial',\n\t\t'Intr' => 'Internal',\n\t\t'Term' => 'Terminal',\n\t\t'Sngl' => '');\n    \nsub _initialize_state {\n    my ($self,@args) = @_;\n    \n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $genscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /genscan/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /genscan/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $genscan->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Genscan result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $genscan->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Genscan result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :","label":"next_prediction($self)"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"next_prediction","line":199,"kind":13},{"localvar":"my","containerName":"next_prediction","definition":"my","name":"$gene","line":200,"kind":13},{"name":"$self","containerName":"next_prediction","kind":13,"line":203},{"line":203,"kind":12,"name":"_parse_predictions","containerName":"next_prediction"},{"kind":13,"line":203,"containerName":"next_prediction","name":"$self"},{"name":"_predictions_parsed","containerName":"next_prediction","line":203,"kind":12},{"name":"$gene","containerName":"next_prediction","kind":13,"line":206},{"line":206,"kind":13,"containerName":"next_prediction","name":"$self"},{"line":206,"kind":12,"name":"_prediction","containerName":"next_prediction"},{"containerName":"next_prediction","name":"$gene","kind":13,"line":208},{"line":211,"kind":13,"localvar":"my","definition":"my","name":"$id","containerName":"next_prediction"},{"line":211,"kind":13,"containerName":"next_prediction","name":"$seq"},{"line":213,"kind":13,"localvar":"my","containerName":"next_prediction","name":"$seqobj","definition":"my"},{"kind":13,"line":213,"containerName":"next_prediction","name":"$self"},{"containerName":"next_prediction","name":"$seqobj","kind":13,"line":214},{"line":216,"kind":13,"containerName":"next_prediction","name":"$id"},{"line":216,"kind":13,"name":"$seq","containerName":"next_prediction"},{"name":"$self","containerName":"next_prediction","kind":13,"line":216},{"kind":12,"line":216,"containerName":"next_prediction","name":"_read_fasta_seq"},{"kind":13,"line":218,"containerName":"next_prediction","name":"$id"},{"line":218,"kind":13,"containerName":"next_prediction","name":"$seq"},{"containerName":"next_prediction","name":"$seqobj","line":219,"kind":13},{"name":"new","containerName":"next_prediction","kind":12,"line":219},{"kind":13,"line":219,"containerName":"next_prediction","name":"$seq"},{"line":220,"kind":13,"containerName":"next_prediction","name":"$id"},{"kind":13,"line":224,"name":"$seqobj","containerName":"next_prediction"},{"name":"$gene","containerName":"next_prediction","line":229,"kind":13},{"kind":12,"line":229,"containerName":"next_prediction","name":"primary_tag"},{"line":230,"kind":13,"localvar":"my","name":"$prednr","definition":"my","containerName":"next_prediction"},{"containerName":"next_prediction","name":"$seqobj","kind":13,"line":231},{"containerName":"next_prediction","name":"display_id","kind":12,"line":231},{"containerName":"next_prediction","name":"$self","line":233,"kind":13},{"containerName":"next_prediction","name":"$seqobj","kind":13,"line":233},{"line":235,"kind":13,"containerName":"next_prediction","name":"$gene"},{"kind":12,"line":235,"containerName":"next_prediction","name":"predicted_protein"},{"kind":13,"line":235,"name":"$seqobj","containerName":"next_prediction"},{"containerName":"next_prediction","name":"$self","kind":13,"line":237},{"name":"_has_cds","containerName":"next_prediction","line":237,"kind":12},{"containerName":"next_prediction","name":"$id","kind":13,"line":238},{"line":238,"kind":13,"name":"$seq","containerName":"next_prediction"},{"containerName":"next_prediction","name":"$self","kind":13,"line":238},{"containerName":"next_prediction","name":"_read_fasta_seq","line":238,"kind":12},{"kind":13,"line":239,"containerName":"next_prediction","name":"$seqobj"},{"line":239,"kind":12,"containerName":"next_prediction","name":"new"},{"kind":13,"line":239,"name":"$seq","containerName":"next_prediction"},{"containerName":"next_prediction","name":"$id","line":240,"kind":13},{"line":242,"kind":13,"name":"$gene","containerName":"next_prediction"},{"line":242,"kind":12,"name":"predicted_cds","containerName":"next_prediction"},{"line":242,"kind":13,"containerName":"next_prediction","name":"$seqobj"}],"line":198,"kind":12,"range":{"end":{"line":245,"character":9999},"start":{"character":0,"line":198}},"name":"next_prediction"},{"containerName":"PrimarySeq","name":"Bio","kind":12,"line":219},{"line":239,"kind":12,"containerName":"PrimarySeq","name":"Bio"},{"kind":13,"line":248,"containerName":null,"name":"$gene"},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Genscan.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Genscan\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Genscan - Results of one Genscan run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Genscan;\n\n   $genscan = Bio::Tools::Genscan->new(-file => 'result.genscan');\n   # filehandle:\n   $genscan = Bio::Tools::Genscan->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $genscan->next_feature() is the same\n   while($gene = $genscan->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene, which inherits\n       # off Bio::SeqFeature::Gene::Transcript.\n       #\n       # $gene->exons() returns an array of \n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n       # singleton exons: \n       ($single_exon) = $gene->exons();\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $genscan->close();\n\n=head1 DESCRIPTION\n\nThe Genscan module provides a parser for Genscan gene structure prediction\noutput. It parses one gene prediction into a Bio::SeqFeature::Gene::Transcript-\nderived object.\n\nThis module also implements the Bio::SeqAnalysisParserI interface, and thus\ncan be used wherever such an object fits. See L<Bio::SeqAnalysisParserI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Genscan;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nmy %ExonTags = ('Init' => 'Initial',\n\t\t'Intr' => 'Internal',\n\t\t'Term' => 'Terminal',\n\t\t'Sngl' => '');\n    \nsub _initialize_state {\n    my ($self,@args) = @_;\n    \n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $genscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /genscan/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /genscan/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $genscan->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Genscan result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $genscan->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Genscan result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n\n    # get next gene structure\n    $gene = $self->_prediction();\n\n    if($gene) {\n\t# fill in predicted protein, and if available the predicted CDS\n\t#\n\tmy ($id, $seq);\n\t# use the seq stack if there's a seq on it\n\tmy $seqobj = pop(@{$self->{'_seqstack'}});\n\tif(! $seqobj) {\n\t    # otherwise read from input stream\n\t    ($id, $seq) = $self->_read_fasta_seq();\n\t    # there may be no sequence at all, or none any more\n\t    if($id && $seq) {\n\t\t$seqobj = Bio::PrimarySeq->new('-seq' => $seq,\n\t\t\t\t\t       '-display_id' => $id,\n\t\t\t\t\t       '-alphabet' => \"protein\");\n\t    }\n\t}\n\tif($seqobj) {\n\t    # check that prediction number matches the prediction number\n\t    # indicated in the sequence id (there may be incomplete gene\n\t    # predictions that contain only signals with no associated protein\n\t    # and CDS, like promoters, poly-A sites etc)\n\t    $gene->primary_tag() =~ /[^0-9]([0-9]+)$/;\n\t    my $prednr = $1;\n\t    if($seqobj->display_id() !~ /_predicted_\\w+_$prednr\\|/) {\n\t\t# this is not our sequence, so push back for next prediction\n\t\tpush(@{$self->{'_seqstack'}}, $seqobj);\n\t    } else {\n\t\t$gene->predicted_protein($seqobj);\n\t\t# CDS prediction, too?\n\t\tif($self->_has_cds()) {\n\t\t    ($id, $seq) = $self->_read_fasta_seq();\n\t\t    $seqobj = Bio::PrimarySeq->new('-seq' => $seq,\n\t\t\t\t\t\t   '-display_id' => $id,\n\t\t\t\t\t\t   '-alphabet' => \"dna\");\n\t\t    $gene->predicted_cds($seqobj);\n\t\t}\n\t    }\n\t}\n    }\n\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : ","label":"_parse_predictions($self)"},"detail":"($self)","kind":12,"children":[{"localvar":"my","containerName":"_parse_predictions","name":"$self","definition":"my","line":263,"kind":13},{"kind":13,"line":264,"name":"$gene","definition":"my","containerName":"_parse_predictions","localvar":"my"},{"localvar":"my","containerName":"_parse_predictions","definition":"my","name":"$seqname","line":265,"kind":13},{"line":267,"kind":13,"name":"$self","containerName":"_parse_predictions"},{"name":"_readline","containerName":"_parse_predictions","kind":12,"line":267},{"line":270,"kind":13,"localvar":"my","containerName":"_parse_predictions","definition":"my","name":"$prednr"},{"containerName":"_parse_predictions","definition":"my","name":"$signalnr","localvar":"my","kind":13,"line":271},{"name":"$gene","containerName":"_parse_predictions","kind":13,"line":272},{"kind":13,"line":273,"containerName":"_parse_predictions","name":"$gene"},{"name":"new","containerName":"_parse_predictions","line":273,"kind":12},{"localvar":"my","name":"@flds","definition":"my","containerName":"_parse_predictions","line":279,"kind":13},{"kind":13,"line":281,"definition":"my","name":"$predobj","containerName":"_parse_predictions","localvar":"my"},{"localvar":"my","containerName":"_parse_predictions","definition":"my","name":"$is_exon","line":282,"kind":13},{"name":"$flds","containerName":"_parse_predictions","line":282,"kind":13},{"kind":13,"line":282,"containerName":"_parse_predictions","name":"%ExonTags"},{"containerName":"_parse_predictions","name":"$is_exon","kind":13,"line":283},{"kind":13,"line":284,"name":"$predobj","containerName":"_parse_predictions"},{"line":284,"kind":12,"name":"new","containerName":"_parse_predictions"},{"name":"$predobj","containerName":"_parse_predictions","line":287,"kind":13},{"line":287,"kind":12,"name":"new","containerName":"_parse_predictions"},{"name":"$predobj","containerName":"_parse_predictions","line":290,"kind":13},{"kind":12,"line":290,"name":"source_tag","containerName":"_parse_predictions"},{"line":291,"kind":13,"name":"$predobj","containerName":"_parse_predictions"},{"line":291,"kind":12,"name":"score","containerName":"_parse_predictions"},{"name":"$flds","containerName":"_parse_predictions","kind":13,"line":291},{"name":"$predobj","containerName":"_parse_predictions","line":292,"kind":13},{"line":292,"kind":12,"name":"strand","containerName":"_parse_predictions"},{"kind":13,"line":292,"containerName":"_parse_predictions","name":"$flds"},{"line":293,"kind":13,"localvar":"my","containerName":"_parse_predictions","name":"$start","definition":"my"},{"containerName":"_parse_predictions","name":"$end","kind":13,"line":293},{"kind":13,"line":293,"name":"@flds","containerName":"_parse_predictions"},{"containerName":"_parse_predictions","name":"$predobj","kind":13,"line":294},{"name":"strand","containerName":"_parse_predictions","line":294,"kind":12},{"kind":13,"line":295,"containerName":"_parse_predictions","name":"$predobj"},{"kind":12,"line":295,"name":"start","containerName":"_parse_predictions"},{"kind":13,"line":295,"name":"$start","containerName":"_parse_predictions"},{"containerName":"_parse_predictions","name":"$predobj","kind":13,"line":296},{"kind":12,"line":296,"name":"end","containerName":"_parse_predictions"},{"name":"$end","containerName":"_parse_predictions","line":296,"kind":13},{"name":"$predobj","containerName":"_parse_predictions","line":298,"kind":13},{"kind":12,"line":298,"name":"end","containerName":"_parse_predictions"},{"containerName":"_parse_predictions","name":"$start","line":298,"kind":13},{"kind":13,"line":299,"containerName":"_parse_predictions","name":"$predobj"},{"name":"start","containerName":"_parse_predictions","kind":12,"line":299},{"kind":13,"line":299,"name":"$end","containerName":"_parse_predictions"},{"line":303,"kind":13,"name":"$is_exon","containerName":"_parse_predictions"},{"containerName":"_parse_predictions","name":"$predobj","line":305,"kind":13},{"name":"start_signal_score","containerName":"_parse_predictions","line":305,"kind":12},{"name":"$flds","containerName":"_parse_predictions","kind":13,"line":305},{"line":306,"kind":13,"containerName":"_parse_predictions","name":"$predobj"},{"line":306,"kind":12,"containerName":"_parse_predictions","name":"end_signal_score"},{"line":306,"kind":13,"name":"$flds","containerName":"_parse_predictions"},{"kind":13,"line":307,"containerName":"_parse_predictions","name":"$predobj"},{"line":307,"kind":12,"containerName":"_parse_predictions","name":"coding_signal_score"},{"line":307,"kind":13,"containerName":"_parse_predictions","name":"$flds"},{"name":"$predobj","containerName":"_parse_predictions","line":308,"kind":13},{"kind":12,"line":308,"name":"significance","containerName":"_parse_predictions"},{"name":"$flds","containerName":"_parse_predictions","kind":13,"line":308},{"kind":13,"line":309,"name":"$predobj","containerName":"_parse_predictions"},{"name":"primary_tag","containerName":"_parse_predictions","line":309,"kind":12},{"name":"$ExonTags","containerName":"_parse_predictions","line":309,"kind":13},{"name":"$flds","containerName":"_parse_predictions","line":309,"kind":13},{"line":310,"kind":13,"containerName":"_parse_predictions","name":"$predobj"},{"line":310,"kind":12,"containerName":"_parse_predictions","name":"is_coding"},{"localvar":"my","definition":"my","name":"$cod_offset","containerName":"_parse_predictions","line":317,"kind":13},{"name":"$predobj","containerName":"_parse_predictions","line":318,"kind":13},{"containerName":"_parse_predictions","name":"strand","kind":12,"line":318},{"line":319,"kind":13,"name":"$cod_offset","containerName":"_parse_predictions"},{"line":319,"kind":13,"containerName":"_parse_predictions","name":"$flds"},{"line":319,"kind":13,"containerName":"_parse_predictions","name":"$predobj"},{"name":"start","containerName":"_parse_predictions","line":319,"kind":12},{"name":"$cod_offset","containerName":"_parse_predictions","line":322,"kind":13},{"containerName":"_parse_predictions","name":"$cod_offset","kind":13,"line":322},{"name":"$cod_offset","containerName":"_parse_predictions","line":328,"kind":13},{"line":328,"kind":13,"name":"$flds","containerName":"_parse_predictions"},{"line":328,"kind":13,"containerName":"_parse_predictions","name":"$predobj"},{"line":328,"kind":12,"name":"end","containerName":"_parse_predictions"},{"line":332,"kind":13,"name":"$cod_offset","containerName":"_parse_predictions"},{"kind":13,"line":332,"containerName":"_parse_predictions","name":"$cod_offset"},{"kind":13,"line":333,"containerName":"_parse_predictions","name":"$cod_offset"},{"kind":13,"line":333,"containerName":"_parse_predictions","name":"$cod_offset"},{"containerName":"_parse_predictions","name":"$predobj","kind":13,"line":338},{"line":338,"kind":12,"name":"frame","containerName":"_parse_predictions"},{"kind":13,"line":338,"name":"$cod_offset","containerName":"_parse_predictions"},{"containerName":"_parse_predictions","name":"$gene","kind":13,"line":340},{"name":"add_exon","containerName":"_parse_predictions","kind":12,"line":340},{"containerName":"_parse_predictions","name":"$predobj","kind":13,"line":340},{"containerName":"_parse_predictions","name":"$ExonTags","kind":13,"line":340},{"containerName":"_parse_predictions","name":"$flds","line":340,"kind":13},{"line":341,"kind":13,"containerName":"_parse_predictions","name":"$flds"},{"containerName":"_parse_predictions","name":"$predobj","line":342,"kind":13},{"name":"primary_tag","containerName":"_parse_predictions","line":342,"kind":12},{"kind":13,"line":343,"name":"$gene","containerName":"_parse_predictions"},{"line":343,"kind":12,"name":"poly_A_site","containerName":"_parse_predictions"},{"line":343,"kind":13,"containerName":"_parse_predictions","name":"$predobj"},{"line":344,"kind":13,"name":"$flds","containerName":"_parse_predictions"},{"line":345,"kind":13,"containerName":"_parse_predictions","name":"$predobj"},{"line":345,"kind":12,"name":"primary_tag","containerName":"_parse_predictions"},{"kind":13,"line":346,"containerName":"_parse_predictions","name":"$gene"},{"containerName":"_parse_predictions","name":"add_promoter","kind":12,"line":346},{"line":346,"kind":13,"name":"$predobj","containerName":"_parse_predictions"},{"name":"$gene","containerName":"_parse_predictions","kind":13,"line":350},{"containerName":"_parse_predictions","name":"$gene","line":352,"kind":13},{"containerName":"_parse_predictions","name":"seq_id","line":352,"kind":12},{"kind":13,"line":352,"containerName":"_parse_predictions","name":"$seqname"},{"kind":13,"line":353,"containerName":"_parse_predictions","name":"$self"},{"containerName":"_parse_predictions","name":"_add_prediction","line":353,"kind":12},{"name":"$gene","containerName":"_parse_predictions","kind":13,"line":353},{"name":"$gene","containerName":"_parse_predictions","line":354,"kind":13},{"kind":13,"line":358,"name":"$self","containerName":"_parse_predictions"},{"kind":12,"line":358,"containerName":"_parse_predictions","name":"analysis_method"},{"containerName":"_parse_predictions","name":"$self","line":359,"kind":13},{"kind":12,"line":359,"name":"analysis_method_version","containerName":"_parse_predictions"},{"name":"$seqname","containerName":"_parse_predictions","kind":13,"line":363},{"containerName":"_parse_predictions","name":"$self","line":368,"kind":13},{"kind":12,"line":368,"name":"analysis_subject","containerName":"_parse_predictions"},{"line":373,"kind":13,"containerName":"_parse_predictions","name":"$self"},{"name":"_has_cds","containerName":"_parse_predictions","kind":12,"line":373},{"localvar":"my","containerName":"_parse_predictions","name":"$entry","definition":"my","line":478,"kind":13},{"kind":13,"line":478,"name":"$self","containerName":"_parse_predictions"},{"line":478,"kind":12,"containerName":"_parse_predictions","name":"_readline"},{"containerName":"_parse_predictions","name":"$entry","kind":13,"line":479},{"name":"$entry","containerName":"_parse_predictions","line":480,"kind":13},{"kind":13,"line":482,"containerName":"_parse_predictions","name":"$entry"},{"containerName":"_parse_predictions","name":"$self","line":483,"kind":13},{"kind":12,"line":483,"name":"_readline","containerName":"_parse_predictions"},{"name":"$entry","containerName":"_parse_predictions","line":484,"kind":13},{"name":"$entry","containerName":"_parse_predictions","kind":13,"line":488},{"containerName":"_parse_predictions","name":"$entry","kind":13,"line":490},{"kind":13,"line":491,"containerName":"_parse_predictions","name":"$id"},{"kind":13,"line":492,"containerName":"_parse_predictions","name":"$seq"},{"kind":13,"line":494,"name":"$self","containerName":"_parse_predictions"},{"kind":12,"line":494,"name":"throw","containerName":"_parse_predictions"},{"line":496,"kind":13,"containerName":"_parse_predictions","name":"$seq"},{"line":498,"kind":13,"containerName":"_parse_predictions","name":"$id"},{"line":498,"kind":13,"name":"$seq","containerName":"_parse_predictions"}],"line":262,"name":"_parse_predictions","range":{"start":{}}},{"kind":12,"line":273,"containerName":"Tools::Prediction::Gene","name":"Bio"},{"name":"Bio","containerName":"Tools::Prediction::Exon","kind":12,"line":284},{"containerName":"SeqFeature::Generic","name":"Bio","line":287,"kind":12},{"name":"flds","line":291,"kind":12}],"version":5}