{"vars":[{"containerName":"","name":"vars","line":83,"kind":2},{"line":93,"kind":2,"containerName":"","name":"base"},{"kind":13,"line":95,"name":"$Srctag","containerName":null},{"kind":12,"line":108,"children":[{"kind":13,"line":109,"name":"$class","definition":"my","containerName":"new","localvar":"my"},{"line":109,"kind":13,"name":"@args","containerName":"new"},{"localvar":"my","containerName":"new","definition":"my","name":"$self","line":110,"kind":13},{"name":"$class","containerName":"new","kind":13,"line":110},{"name":"@args","containerName":"new","kind":13,"line":110},{"name":"$self","containerName":"new","line":111,"kind":13}],"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Genomewise.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Genomewise\n#\n# Copyright Jason Stajich <jason-at-bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Genomewise - Results of one Genomewise run\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Genomewise;\n  my $gw = Bio::Tools::Genomewise(-file=>\"genomewise.out\");\n\n  while (my $gene = $gw->next_prediction){\n      my @transcripts = $gene->transcripts;\n      foreach my $t(@transcripts){\n        my @exons =  $t->exons;\n        foreach my $e(@exons){\n            print $e->start.\" \".$e->end.\"\\n\";\n        }\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is the parser for the output of Genewise. It takes either a file\nhandle or a file name and returns a\nBio::SeqFeature::Gene::GeneStructure object.  You will need to specify\nthe proper target sequence id on the object with the\n$feature-E<gt>seq_id($seqid).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Fugu Team, Jason Stajich \n\n Email: fugui-at-worf.fugu-sg.org\n        jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Genomewise;\nuse vars qw($Srctag);\nuse strict;\n\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Gene::Exon;\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Gene::Transcript;\nuse Bio::SeqFeature::Gene::GeneStructure;\n\nuse base qw(Bio::Tools::Genewise);\n\n$Srctag = 'genomewise';\n\n=head2 new\n\n Title   : new\n Usage   : $obj->new(-file=>\"genewise.out\");\n           $obj->new(-fh=>\\*GW);\n Function: Constructor for genomewise wrapper. Takes either a file or filehandle\n Example :\n Returns : L<Bio::Tools::Genomewise>","label":"new($class,@args)"},"name":"new","range":{"start":{"character":0,"line":108},"end":{"character":9999,"line":112}}},{"kind":12,"line":110,"name":"SUPER","containerName":"new"},{"kind":12,"line":171,"children":[{"definition":"my","name":"$self","containerName":"next_prediction","localvar":"my","kind":13,"line":172},{"line":174,"kind":13,"localvar":"my","containerName":"next_prediction","name":"$genes","definition":"my"},{"name":"$self","containerName":"next_prediction","line":175,"kind":13},{"line":175,"kind":12,"name":"_readline","containerName":"next_prediction"},{"kind":13,"line":176,"containerName":"next_prediction","name":"$self"},{"containerName":"next_prediction","name":"debug","line":176,"kind":12},{"kind":13,"line":180,"name":"$genes","containerName":"next_prediction"},{"containerName":"next_prediction","name":"new","line":181,"kind":12},{"kind":13,"line":181,"containerName":"next_prediction","name":"$Srctag"},{"kind":13,"line":182,"name":"$self","containerName":"next_prediction"},{"line":182,"kind":12,"containerName":"next_prediction","name":"_target_id"},{"kind":13,"line":184,"name":"$self","containerName":"next_prediction"},{"kind":12,"line":184,"name":"_readline","containerName":"next_prediction"},{"kind":13,"line":185,"name":"$self","containerName":"next_prediction"},{"containerName":"next_prediction","name":"debug","kind":12,"line":185},{"containerName":"next_prediction","name":"$self","line":188,"kind":13},{"containerName":"next_prediction","name":"warn","line":188,"kind":12},{"localvar":"my","name":"$transcript","definition":"my","containerName":"next_prediction","line":191,"kind":13},{"containerName":"next_prediction","name":"new","line":192,"kind":12},{"kind":13,"line":192,"name":"$Srctag","containerName":"next_prediction"},{"name":"$self","containerName":"next_prediction","kind":13,"line":193},{"kind":12,"line":193,"containerName":"next_prediction","name":"_target_id"},{"line":197,"kind":13,"localvar":"my","definition":"my","name":"$nbr","containerName":"next_prediction"},{"kind":13,"line":198,"containerName":"next_prediction","name":"$self"},{"line":198,"kind":12,"name":"_readline","containerName":"next_prediction"},{"line":199,"kind":13,"containerName":"next_prediction","name":"$self"},{"line":199,"kind":12,"containerName":"next_prediction","name":"debug"},{"kind":13,"line":202,"name":"$self","containerName":"next_prediction"},{"kind":12,"line":202,"containerName":"next_prediction","name":"_pushback"},{"line":205,"kind":13,"localvar":"my","name":"$e_start","definition":"my","containerName":"next_prediction"},{"name":"$e_end","containerName":"next_prediction","kind":13,"line":205},{"containerName":"next_prediction","name":"$phase","line":205,"kind":13},{"line":205,"kind":13,"containerName":"next_prediction","name":"$e_strand"},{"name":"$e_start","containerName":"next_prediction","line":207,"kind":13},{"name":"$e_end","containerName":"next_prediction","kind":13,"line":207},{"containerName":"next_prediction","name":"$e_strand","line":207,"kind":13},{"containerName":"next_prediction","name":"$self","kind":13,"line":207},{"name":"_get_strand","containerName":"next_prediction","line":207,"kind":12},{"name":"$e_start","containerName":"next_prediction","line":207,"kind":13},{"line":208,"kind":13,"containerName":"next_prediction","name":"$e_end"},{"containerName":"next_prediction","name":"$transcript","kind":13,"line":209},{"name":"strand","containerName":"next_prediction","kind":12,"line":209},{"name":"$e_strand","containerName":"next_prediction","line":209,"kind":13},{"line":209,"kind":13,"name":"$transcript","containerName":"next_prediction"},{"name":"strand","containerName":"next_prediction","kind":12,"line":209},{"containerName":"next_prediction","definition":"my","name":"$exon","localvar":"my","kind":13,"line":211},{"containerName":"next_prediction","name":"new","kind":12,"line":211},{"kind":13,"line":212,"containerName":"next_prediction","name":"$self"},{"name":"_target_id","containerName":"next_prediction","line":212,"kind":12},{"kind":13,"line":213,"containerName":"next_prediction","name":"$Srctag"},{"name":"$e_start","containerName":"next_prediction","kind":13,"line":214},{"containerName":"next_prediction","name":"$e_end","line":215,"kind":13},{"line":216,"kind":13,"containerName":"next_prediction","name":"$phase"},{"line":217,"kind":13,"name":"$e_strand","containerName":"next_prediction"},{"line":218,"kind":13,"containerName":"next_prediction","name":"$exon"},{"containerName":"next_prediction","name":"add_tag_value","kind":12,"line":218},{"line":218,"kind":13,"name":"$nbr","containerName":"next_prediction"},{"kind":13,"line":219,"name":"$exon","containerName":"next_prediction"},{"name":"add_tag_value","containerName":"next_prediction","line":219,"kind":12},{"line":219,"kind":13,"name":"$phase","containerName":"next_prediction"},{"line":220,"kind":13,"name":"$transcript","containerName":"next_prediction"},{"line":220,"kind":12,"name":"add_exon","containerName":"next_prediction"},{"kind":13,"line":220,"containerName":"next_prediction","name":"$exon"},{"name":"$genes","containerName":"next_prediction","line":222,"kind":13},{"kind":12,"line":222,"containerName":"next_prediction","name":"add_transcript"},{"name":"$transcript","containerName":"next_prediction","line":222,"kind":13},{"kind":13,"line":226,"name":"$genes","containerName":"next_prediction"}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"next_prediction($self)","documentation":"1;\n# $Id: Genomewise.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Genomewise\n#\n# Copyright Jason Stajich <jason-at-bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Genomewise - Results of one Genomewise run\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Genomewise;\n  my $gw = Bio::Tools::Genomewise(-file=>\"genomewise.out\");\n\n  while (my $gene = $gw->next_prediction){\n      my @transcripts = $gene->transcripts;\n      foreach my $t(@transcripts){\n        my @exons =  $t->exons;\n        foreach my $e(@exons){\n            print $e->start.\" \".$e->end.\"\\n\";\n        }\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is the parser for the output of Genewise. It takes either a file\nhandle or a file name and returns a\nBio::SeqFeature::Gene::GeneStructure object.  You will need to specify\nthe proper target sequence id on the object with the\n$feature-E<gt>seq_id($seqid).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Fugu Team, Jason Stajich \n\n Email: fugui-at-worf.fugu-sg.org\n        jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Genomewise;\nuse vars qw($Srctag);\nuse strict;\n\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Gene::Exon;\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Gene::Transcript;\nuse Bio::SeqFeature::Gene::GeneStructure;\n\nuse base qw(Bio::Tools::Genewise);\n\n$Srctag = 'genomewise';\n\n=head2 new\n\n Title   : new\n Usage   : $obj->new(-file=>\"genewise.out\");\n           $obj->new(-fh=>\\*GW);\n Function: Constructor for genomewise wrapper. Takes either a file or filehandle\n Example :\n Returns : L<Bio::Tools::Genomewise>\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  return $self;\n}\n\n=head2 _get_strand\n\n Title   : _get_strand\n Usage   : $obj->_get_strand\n Function: takes start and end values, swap them if start>end and returns end\n Example :\n Returns :$start,$end,$strand\n\n\n=head2 score\n\n Title   : score\n Usage   : $obj->score\n Function: get/set for score info\n Example :\n Returns : a score value\n\n\n=head2 _prot_id\n\n Title   : _prot_id\n Usage   : $obj->_prot_id\n Function: get/set for protein id \n Example :\n Returns :a protein id\n\n\n=head2 _target_id\n\n Title   : _target_id\n Usage   : $obj->_target_id\n Function: get/set for genomic sequence id\n Example :\n Returns :a target id\n\n\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $genewise->next_prediction()) {\n                  # do something\n           }\n Function: Returns the gene structure prediction of the Genomewise result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : a Bio::SeqFeature::Gene::GeneStructure object\n Args    :","parameters":[{"label":"$self"}]},"name":"next_prediction","range":{"end":{"line":227,"character":9999},"start":{"character":0,"line":171}}},{"name":"Bio","containerName":"SeqFeature::Gene::GeneStructure","line":180,"kind":12},{"name":"Bio","containerName":"SeqFeature::Gene::Transcript","line":191,"kind":12},{"name":"Bio","containerName":"SeqFeature::Gene::Exon","kind":12,"line":211}],"version":5}