{"vars":[{"kind":2,"line":85,"name":"base","containerName":""},{"children":[{"line":98,"kind":13,"localvar":"my","name":"$class","definition":"my","containerName":"new"},{"line":98,"kind":13,"name":"@args","containerName":"new"},{"line":100,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"new"},{"containerName":"new","name":"$class","kind":13,"line":100},{"containerName":"new","name":"@args","kind":13,"line":100},{"name":"$self","containerName":"new","line":101,"kind":13},{"name":"_initialize_io","containerName":"new","line":101,"kind":12},{"name":"@args","containerName":"new","line":101,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":103}],"line":97,"kind":12,"signature":{"documentation":"1;\n# $Id: FootPrinter.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::Tools::FootPrinter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::FootPrinter - write sequence features in FootPrinter format\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::FootPrinter;\n\n    my $tool = Bio::Tools::FootPrinter->new(-file=>\"footprinter.out\");\n\n    while (my $result = $tool->next_feature){\n      foreach my $feat($result->sub_SeqFeature){\n        print $result->seq_id.\"\\t\".$feat->start.\"\\t\".$feat->end.\"\\t\".$feat->seq->seq.\"\\n\";\n      }\n    }\n\n=head1 DESCRIPTION\n\nThis module writes sequence features in FootPrinter format. \nSee L<http://bio.cs.washington.edu/software.html> for more details.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon \n\nEmail shawnh@fugu-sg.org \n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::FootPrinter;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::FootPrinter->new();\n Function: Builds a new Bio::Tools::FootPrinter object \n Returns : Bio::Tools::FootPrinter\n Args    : -fh/-file => $val, # for initing input, see Bio::Root::IO","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"detail":"($class,@args)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":104},"start":{"character":0,"line":97}},"name":"new"},{"line":100,"kind":12,"containerName":"new","name":"SUPER"},{"children":[{"name":"$self","definition":"my","containerName":"next_feature","localvar":"my","kind":13,"line":117},{"containerName":"next_feature","name":"$self","kind":13,"line":118},{"line":118,"kind":12,"name":"_parse_predictions","containerName":"next_feature"},{"kind":13,"line":118,"name":"$self","containerName":"next_feature"},{"line":118,"kind":12,"name":"_predictions_parsed","containerName":"next_feature"},{"line":119,"kind":13,"name":"$self","containerName":"next_feature"}],"line":116,"kind":12,"signature":{"documentation":"1;\n# $Id: FootPrinter.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::Tools::FootPrinter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::FootPrinter - write sequence features in FootPrinter format\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::FootPrinter;\n\n    my $tool = Bio::Tools::FootPrinter->new(-file=>\"footprinter.out\");\n\n    while (my $result = $tool->next_feature){\n      foreach my $feat($result->sub_SeqFeature){\n        print $result->seq_id.\"\\t\".$feat->start.\"\\t\".$feat->end.\"\\t\".$feat->seq->seq.\"\\n\";\n      }\n    }\n\n=head1 DESCRIPTION\n\nThis module writes sequence features in FootPrinter format. \nSee L<http://bio.cs.washington.edu/software.html> for more details.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon \n\nEmail shawnh@fugu-sg.org \n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::FootPrinter;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::FootPrinter->new();\n Function: Builds a new Bio::Tools::FootPrinter object \n Returns : Bio::Tools::FootPrinter\n Args    : -fh/-file => $val, # for initing input, see Bio::Root::IO\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->_initialize_io(@args);\n\n  return $self;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : my $r = $footprint->next_feature\n Function: Get the next feature from parser data\n Returns : L<Bio::SeqFeature::Generic> \n Args    : none","parameters":[{"label":"$self"}],"label":"next_feature($self)"},"detail":"($self)","definition":"sub","containerName":"main::","range":{"end":{"line":119,"character":9999},"start":{"line":116,"character":0}},"name":"next_feature"},{"kind":12,"line":133,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_add_feature","line":134,"kind":13},{"containerName":"_add_feature","name":"$feat","kind":13,"line":134},{"line":135,"kind":13,"containerName":"_add_feature","name":"$feat"},{"name":"$self","containerName":"_add_feature","kind":13,"line":136},{"containerName":"_add_feature","name":"$feat","kind":13,"line":136}],"containerName":"main::","definition":"sub","detail":"($self,$feat)","signature":{"label":"_add_feature($self,$feat)","documentation":"1;\n# $Id: FootPrinter.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::Tools::FootPrinter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::FootPrinter - write sequence features in FootPrinter format\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::FootPrinter;\n\n    my $tool = Bio::Tools::FootPrinter->new(-file=>\"footprinter.out\");\n\n    while (my $result = $tool->next_feature){\n      foreach my $feat($result->sub_SeqFeature){\n        print $result->seq_id.\"\\t\".$feat->start.\"\\t\".$feat->end.\"\\t\".$feat->seq->seq.\"\\n\";\n      }\n    }\n\n=head1 DESCRIPTION\n\nThis module writes sequence features in FootPrinter format. \nSee L<http://bio.cs.washington.edu/software.html> for more details.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon \n\nEmail shawnh@fugu-sg.org \n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::FootPrinter;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::FootPrinter->new();\n Function: Builds a new Bio::Tools::FootPrinter object \n Returns : Bio::Tools::FootPrinter\n Args    : -fh/-file => $val, # for initing input, see Bio::Root::IO\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->_initialize_io(@args);\n\n  return $self;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : my $r = $footprint->next_feature\n Function: Get the next feature from parser data\n Returns : L<Bio::SeqFeature::Generic> \n Args    : none\n\n\nsub next_feature{\n   my ($self) = @_;\n   $self->_parse_predictions() unless $self->_predictions_parsed();\n   return shift @{$self->{'_feature'}};\n\n}\n\n=head2 _add_feature\n\n Title   : _add_feature\n Usage   : $footprint->_add_feature($feat)\n Function: Add feature to array\n Returns : none\n Args    : none","parameters":[{"label":"$self"},{"label":"$feat"}]},"name":"_add_feature","range":{"end":{"character":9999,"line":137},"start":{"line":133,"character":0}}},{"name":"_parse_predictions","range":{"start":{"line":150,"character":0},"end":{"line":184,"character":9999}},"kind":12,"line":150,"children":[{"kind":13,"line":151,"containerName":"_parse_predictions","name":"$self","definition":"my","localvar":"my"},{"containerName":"_parse_predictions","name":"$seq","definition":"my","localvar":"my","kind":13,"line":153},{"line":153,"kind":13,"name":"$second","containerName":"_parse_predictions"},{"containerName":"_parse_predictions","name":"$third","kind":13,"line":153},{"name":"$name","containerName":"_parse_predictions","kind":13,"line":153},{"kind":13,"line":154,"containerName":"_parse_predictions","name":"$self"},{"containerName":"_parse_predictions","name":"_readline","line":154,"kind":12},{"name":"@array","definition":"my","containerName":"_parse_predictions","localvar":"my","kind":13,"line":156},{"line":159,"kind":13,"name":"@array","containerName":"_parse_predictions"},{"containerName":"_parse_predictions","name":"@array","line":159,"kind":13},{"name":"$name","containerName":"_parse_predictions","kind":13,"line":162},{"containerName":"_parse_predictions","name":"$name","kind":13,"line":163},{"line":164,"kind":13,"localvar":"my","definition":"my","name":"$feat","containerName":"_parse_predictions"},{"kind":13,"line":164,"containerName":"_parse_predictions","name":"$self"},{"line":164,"kind":12,"containerName":"_parse_predictions","name":"_parse"},{"name":"$name","containerName":"_parse_predictions","kind":13,"line":164},{"kind":13,"line":164,"containerName":"_parse_predictions","name":"$seq"},{"containerName":"_parse_predictions","name":"$second","line":164,"kind":13},{"name":"$third","containerName":"_parse_predictions","kind":13,"line":164},{"containerName":"_parse_predictions","name":"$self","line":165,"kind":13},{"containerName":"_parse_predictions","name":"_add_feature","line":165,"kind":12},{"containerName":"_parse_predictions","name":"$feat","line":165,"kind":13},{"kind":13,"line":167,"name":"$name","containerName":"_parse_predictions"},{"containerName":"_parse_predictions","name":"@array","kind":13,"line":167},{"line":168,"kind":13,"name":"$seq","containerName":"_parse_predictions"},{"name":"$array","containerName":"_parse_predictions","kind":13,"line":168},{"kind":13,"line":169,"containerName":"_parse_predictions","name":"$second"},{"name":"$array","containerName":"_parse_predictions","line":169,"kind":13},{"line":170,"kind":13,"name":"$third","containerName":"_parse_predictions"},{"containerName":"_parse_predictions","name":"$array","line":170,"kind":13},{"kind":13,"line":173,"name":"$seq","containerName":"_parse_predictions"},{"name":"$array","containerName":"_parse_predictions","kind":13,"line":173},{"line":174,"kind":13,"name":"$third","containerName":"_parse_predictions"},{"line":174,"kind":13,"name":"$array","containerName":"_parse_predictions"},{"line":177,"kind":13,"name":"$seq","containerName":"_parse_predictions"},{"kind":13,"line":179,"name":"$name","containerName":"_parse_predictions"},{"line":180,"kind":13,"localvar":"my","name":"$feat","definition":"my","containerName":"_parse_predictions"},{"containerName":"_parse_predictions","name":"$self","kind":13,"line":180},{"line":180,"kind":12,"name":"_parse","containerName":"_parse_predictions"},{"containerName":"_parse_predictions","name":"$name","kind":13,"line":180},{"containerName":"_parse_predictions","name":"$seq","line":180,"kind":13},{"containerName":"_parse_predictions","name":"$second","line":180,"kind":13},{"kind":13,"line":180,"containerName":"_parse_predictions","name":"$third"},{"line":181,"kind":13,"containerName":"_parse_predictions","name":"$self"},{"kind":12,"line":181,"containerName":"_parse_predictions","name":"_add_feature"},{"name":"$feat","containerName":"_parse_predictions","kind":13,"line":181},{"containerName":"_parse_predictions","name":"$self","kind":13,"line":183},{"line":183,"kind":12,"name":"_predictions_parsed","containerName":"_parse_predictions"}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"documentation":"1;\n# $Id: FootPrinter.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::Tools::FootPrinter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::FootPrinter - write sequence features in FootPrinter format\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::FootPrinter;\n\n    my $tool = Bio::Tools::FootPrinter->new(-file=>\"footprinter.out\");\n\n    while (my $result = $tool->next_feature){\n      foreach my $feat($result->sub_SeqFeature){\n        print $result->seq_id.\"\\t\".$feat->start.\"\\t\".$feat->end.\"\\t\".$feat->seq->seq.\"\\n\";\n      }\n    }\n\n=head1 DESCRIPTION\n\nThis module writes sequence features in FootPrinter format. \nSee L<http://bio.cs.washington.edu/software.html> for more details.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon \n\nEmail shawnh@fugu-sg.org \n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::FootPrinter;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::FootPrinter->new();\n Function: Builds a new Bio::Tools::FootPrinter object \n Returns : Bio::Tools::FootPrinter\n Args    : -fh/-file => $val, # for initing input, see Bio::Root::IO\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->_initialize_io(@args);\n\n  return $self;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : my $r = $footprint->next_feature\n Function: Get the next feature from parser data\n Returns : L<Bio::SeqFeature::Generic> \n Args    : none\n\n\nsub next_feature{\n   my ($self) = @_;\n   $self->_parse_predictions() unless $self->_predictions_parsed();\n   return shift @{$self->{'_feature'}};\n\n}\n\n=head2 _add_feature\n\n Title   : _add_feature\n Usage   : $footprint->_add_feature($feat)\n Function: Add feature to array\n Returns : none\n Args    : none\n\n\nsub _add_feature {\n    my ($self,$feat) = @_;\n    if($feat){\n        push @{$self->{'_feature'}},$feat;\n    }\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions\n Usage   : my $r = $footprint->_parse_predictions\n Function: do the parsing \n Returns : none \n Args    : none","parameters":[{"label":"$self"}],"label":"_parse_predictions($self)"}},{"name":"array","kind":12,"line":157},{"line":161,"kind":12,"name":"array"},{"signature":{"parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n# $Id: FootPrinter.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::Tools::FootPrinter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::FootPrinter - write sequence features in FootPrinter format\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::FootPrinter;\n\n    my $tool = Bio::Tools::FootPrinter->new(-file=>\"footprinter.out\");\n\n    while (my $result = $tool->next_feature){\n      foreach my $feat($result->sub_SeqFeature){\n        print $result->seq_id.\"\\t\".$feat->start.\"\\t\".$feat->end.\"\\t\".$feat->seq->seq.\"\\n\";\n      }\n    }\n\n=head1 DESCRIPTION\n\nThis module writes sequence features in FootPrinter format. \nSee L<http://bio.cs.washington.edu/software.html> for more details.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon \n\nEmail shawnh@fugu-sg.org \n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::FootPrinter;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::FootPrinter->new();\n Function: Builds a new Bio::Tools::FootPrinter object \n Returns : Bio::Tools::FootPrinter\n Args    : -fh/-file => $val, # for initing input, see Bio::Root::IO\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->_initialize_io(@args);\n\n  return $self;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : my $r = $footprint->next_feature\n Function: Get the next feature from parser data\n Returns : L<Bio::SeqFeature::Generic> \n Args    : none\n\n\nsub next_feature{\n   my ($self) = @_;\n   $self->_parse_predictions() unless $self->_predictions_parsed();\n   return shift @{$self->{'_feature'}};\n\n}\n\n=head2 _add_feature\n\n Title   : _add_feature\n Usage   : $footprint->_add_feature($feat)\n Function: Add feature to array\n Returns : none\n Args    : none\n\n\nsub _add_feature {\n    my ($self,$feat) = @_;\n    if($feat){\n        push @{$self->{'_feature'}},$feat;\n    }\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions\n Usage   : my $r = $footprint->_parse_predictions\n Function: do the parsing \n Returns : none \n Args    : none\n\n\nsub _parse_predictions {\n  my ($self) = @_;\n  $/=\"\";\n  my ($seq,$second,$third,$name);\n  while ($_ = $self->_readline) {\n    chomp;\n    my @array = split(\"\\n\",$_);\n    if ($#array == 5) {\n      # get rid of header\n      shift(@array); shift(@array);\n    }\n    if($#array == 3){\n        if($name){\n            $name=~s/>//;\n            my $feat = $self->_parse($name,$seq,$second,$third);\n            $self->_add_feature($feat);\n        }\n        $name    = shift @array;\n        $seq     = $array[0];\n        $second  = $array[1];\n        $third   = $array[2];\n        next;\n    }\n    $seq        .= $array[0];\n    $third      .= $array[2];\n  }\n  \n  $seq || return;\n  \n  $name=~s/>//;\n  my $feat = $self->_parse($name,$seq,$second,$third);\n  $self->_add_feature($feat);\n\n  $self->_predictions_parsed(1);\n}\n\n=head2 _predictions_parsed\n\n Title   : _predictions_parsed\n Usage   : $footprint->_predictions_parsed(1)\n Function: Get/Set for whether predictions parsed\n Returns : 1/0\n Args    : none","label":"_predictions_parsed($self,$val)"},"detail":"($self,$val)","definition":"sub","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"_predictions_parsed","localvar":"my","kind":13,"line":197},{"line":197,"kind":13,"containerName":"_predictions_parsed","name":"$val"},{"line":198,"kind":13,"name":"$val","containerName":"_predictions_parsed"},{"name":"$self","containerName":"_predictions_parsed","line":199,"kind":13},{"kind":13,"line":199,"containerName":"_predictions_parsed","name":"$val"},{"kind":13,"line":201,"name":"$self","containerName":"_predictions_parsed"}],"line":196,"kind":12,"range":{"start":{"line":196,"character":0},"end":{"character":9999,"line":202}},"name":"_predictions_parsed"},{"name":"_parse","range":{"start":{"line":215,"character":0},"end":{"character":9999,"line":281}},"containerName":"main::","definition":"sub","detail":"($self,$name,$seq,$score,$pattern)","signature":{"label":"_parse($self,$name,$seq,$score,$pattern)","parameters":[{"label":"$self"},{"label":"$name"},{"label":"$seq"},{"label":"$score"},{"label":"$pattern"}],"documentation":"1;\n# $Id: FootPrinter.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::Tools::FootPrinter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::FootPrinter - write sequence features in FootPrinter format\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::FootPrinter;\n\n    my $tool = Bio::Tools::FootPrinter->new(-file=>\"footprinter.out\");\n\n    while (my $result = $tool->next_feature){\n      foreach my $feat($result->sub_SeqFeature){\n        print $result->seq_id.\"\\t\".$feat->start.\"\\t\".$feat->end.\"\\t\".$feat->seq->seq.\"\\n\";\n      }\n    }\n\n=head1 DESCRIPTION\n\nThis module writes sequence features in FootPrinter format. \nSee L<http://bio.cs.washington.edu/software.html> for more details.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon \n\nEmail shawnh@fugu-sg.org \n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::FootPrinter;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::FootPrinter->new();\n Function: Builds a new Bio::Tools::FootPrinter object \n Returns : Bio::Tools::FootPrinter\n Args    : -fh/-file => $val, # for initing input, see Bio::Root::IO\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->_initialize_io(@args);\n\n  return $self;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : my $r = $footprint->next_feature\n Function: Get the next feature from parser data\n Returns : L<Bio::SeqFeature::Generic> \n Args    : none\n\n\nsub next_feature{\n   my ($self) = @_;\n   $self->_parse_predictions() unless $self->_predictions_parsed();\n   return shift @{$self->{'_feature'}};\n\n}\n\n=head2 _add_feature\n\n Title   : _add_feature\n Usage   : $footprint->_add_feature($feat)\n Function: Add feature to array\n Returns : none\n Args    : none\n\n\nsub _add_feature {\n    my ($self,$feat) = @_;\n    if($feat){\n        push @{$self->{'_feature'}},$feat;\n    }\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions\n Usage   : my $r = $footprint->_parse_predictions\n Function: do the parsing \n Returns : none \n Args    : none\n\n\nsub _parse_predictions {\n  my ($self) = @_;\n  $/=\"\";\n  my ($seq,$second,$third,$name);\n  while ($_ = $self->_readline) {\n    chomp;\n    my @array = split(\"\\n\",$_);\n    if ($#array == 5) {\n      # get rid of header\n      shift(@array); shift(@array);\n    }\n    if($#array == 3){\n        if($name){\n            $name=~s/>//;\n            my $feat = $self->_parse($name,$seq,$second,$third);\n            $self->_add_feature($feat);\n        }\n        $name    = shift @array;\n        $seq     = $array[0];\n        $second  = $array[1];\n        $third   = $array[2];\n        next;\n    }\n    $seq        .= $array[0];\n    $third      .= $array[2];\n  }\n  \n  $seq || return;\n  \n  $name=~s/>//;\n  my $feat = $self->_parse($name,$seq,$second,$third);\n  $self->_add_feature($feat);\n\n  $self->_predictions_parsed(1);\n}\n\n=head2 _predictions_parsed\n\n Title   : _predictions_parsed\n Usage   : $footprint->_predictions_parsed(1)\n Function: Get/Set for whether predictions parsed\n Returns : 1/0\n Args    : none\n\n\nsub _predictions_parsed {\n    my ($self,$val) = @_;\n    if($val){\n        $self->{'_predictions_parsed'} = $val;\n    }\n    return $self->{'_predictions_parsed'};\n}\n\n\n=head2 _parse\n\n Title   : _parse\n Usage   : $footprint->_parse($name,$seq,$pattern)\n Function: do the actual parsing\n Returns : L<Bio::SeqFeature::Generic>\n Args    : none"},"kind":12,"line":215,"children":[{"containerName":"_parse","definition":"my","name":"$self","localvar":"my","kind":13,"line":216},{"kind":13,"line":216,"name":"$name","containerName":"_parse"},{"containerName":"_parse","name":"$seq","kind":13,"line":216},{"name":"$score","containerName":"_parse","line":216,"kind":13},{"line":216,"kind":13,"containerName":"_parse","name":"$pattern"},{"containerName":"_parse","name":"@char","definition":"my","localvar":"my","kind":13,"line":217},{"kind":13,"line":217,"name":"$pattern","containerName":"_parse"},{"localvar":"my","containerName":"_parse","name":"@score","definition":"my","line":218,"kind":13},{"containerName":"_parse","name":"$score","kind":13,"line":218},{"definition":"my","name":"$prev","containerName":"_parse","localvar":"my","kind":13,"line":220},{"line":220,"kind":13,"name":"$word","containerName":"_parse"},{"line":220,"kind":13,"containerName":"_parse","name":"@words"},{"containerName":"_parse","name":"@word_scores","kind":13,"line":220},{"name":"$word_score","containerName":"_parse","line":220,"kind":13},{"kind":13,"line":222,"definition":"my","name":"$i","containerName":"_parse","localvar":"my"},{"localvar":"my","containerName":"_parse","name":"$c","definition":"my","line":223,"kind":13},{"kind":13,"line":223,"containerName":"_parse","name":"@char"},{"containerName":"_parse","name":"$word","line":224,"kind":13},{"kind":13,"line":225,"containerName":"_parse","name":"$word"},{"name":"$c","containerName":"_parse","kind":13,"line":225},{"line":226,"kind":13,"containerName":"_parse","name":"$prev"},{"line":226,"kind":13,"name":"$c","containerName":"_parse"},{"containerName":"_parse","name":"$score","line":227,"kind":13},{"name":"$i","containerName":"_parse","line":227,"kind":13},{"line":228,"kind":13,"name":"$score","containerName":"_parse"},{"containerName":"_parse","name":"$i","line":228,"kind":13},{"kind":13,"line":228,"containerName":"_parse","name":"$word_score"},{"line":228,"kind":13,"containerName":"_parse","name":"$score"},{"containerName":"_parse","name":"$i","kind":13,"line":228},{"line":229,"kind":13,"name":"$c","containerName":"_parse"},{"line":229,"kind":13,"containerName":"_parse","name":"$prev"},{"name":"$word","containerName":"_parse","kind":13,"line":230},{"line":230,"kind":13,"containerName":"_parse","name":"$c"},{"line":231,"kind":13,"name":"$prev","containerName":"_parse"},{"kind":13,"line":231,"name":"$c","containerName":"_parse"},{"kind":13,"line":232,"containerName":"_parse","name":"$score"},{"containerName":"_parse","name":"$i","kind":13,"line":232},{"kind":13,"line":233,"name":"$score","containerName":"_parse"},{"name":"$i","containerName":"_parse","line":233,"kind":13},{"name":"$word_score","containerName":"_parse","line":233,"kind":13},{"containerName":"_parse","name":"$score","kind":13,"line":233},{"name":"$i","containerName":"_parse","line":233,"kind":13},{"containerName":"_parse","name":"$word","kind":13,"line":236},{"name":"$word","containerName":"_parse","line":237,"kind":13},{"line":238,"kind":13,"name":"@words","containerName":"_parse"},{"line":238,"kind":13,"containerName":"_parse","name":"$word"},{"kind":13,"line":239,"name":"@word_scores","containerName":"_parse"},{"kind":13,"line":239,"name":"$word_score","containerName":"_parse"},{"name":"$word","containerName":"_parse","kind":13,"line":239},{"line":241,"kind":13,"containerName":"_parse","name":"$word"},{"line":241,"kind":13,"containerName":"_parse","name":"$c"},{"name":"$prev","containerName":"_parse","line":242,"kind":13},{"name":"$c","containerName":"_parse","line":242,"kind":13},{"line":243,"kind":13,"containerName":"_parse","name":"$word_score"},{"kind":13,"line":244,"name":"$score","containerName":"_parse"},{"name":"$i","containerName":"_parse","kind":13,"line":244},{"line":245,"kind":13,"containerName":"_parse","name":"$score"},{"containerName":"_parse","name":"$i","line":245,"kind":13},{"line":245,"kind":13,"name":"$word_score","containerName":"_parse"},{"line":245,"kind":13,"name":"$score","containerName":"_parse"},{"containerName":"_parse","name":"$i","kind":13,"line":245},{"name":"$i","containerName":"_parse","line":247,"kind":13},{"name":"$word","containerName":"_parse","line":249,"kind":13},{"line":250,"kind":13,"name":"$word","containerName":"_parse"},{"line":251,"kind":13,"containerName":"_parse","name":"@words"},{"name":"$word","containerName":"_parse","kind":13,"line":251},{"definition":"my","name":"$last","containerName":"_parse","localvar":"my","kind":13,"line":253},{"line":254,"kind":13,"localvar":"my","containerName":"_parse","definition":"my","name":"$feat"},{"line":254,"kind":12,"name":"new","containerName":"_parse"},{"name":"$name","containerName":"_parse","kind":13,"line":254},{"kind":13,"line":255,"name":"$offset","definition":"my","containerName":"_parse","localvar":"my"},{"line":255,"kind":13,"name":"$i","containerName":"_parse"},{"localvar":"my","containerName":"_parse","definition":"my","name":"$count","line":256,"kind":13},{"localvar":"my","containerName":"_parse","name":"$w","definition":"my","line":257,"kind":13},{"line":257,"kind":13,"containerName":"_parse","name":"@words"},{"containerName":"_parse","name":"$w","line":258,"kind":13},{"name":"$index","definition":"my","containerName":"_parse","localvar":"my","kind":13,"line":259},{"kind":13,"line":259,"name":"$pattern","containerName":"_parse"},{"containerName":"_parse","name":"$w","line":259,"kind":13},{"containerName":"_parse","name":"$offset","kind":13,"line":259},{"name":"$offset","containerName":"_parse","kind":13,"line":260},{"line":260,"kind":13,"containerName":"_parse","name":"$index"},{"containerName":"_parse","name":"$w","line":260,"kind":13},{"kind":13,"line":261,"definition":"my","name":"$subfeat","containerName":"_parse","localvar":"my"},{"name":"new","containerName":"_parse","kind":12,"line":261},{"name":"$count","containerName":"_parse","kind":13,"line":262},{"containerName":"_parse","name":"$index","kind":13,"line":263},{"containerName":"_parse","name":"$index","line":264,"kind":13},{"containerName":"_parse","name":"$w","line":264,"kind":13},{"containerName":"_parse","name":"$word_scores","line":266,"kind":13},{"line":266,"kind":13,"name":"$i","containerName":"_parse"},{"containerName":"_parse","name":"$feat","line":273,"kind":13},{"name":"add_sub_SeqFeature","containerName":"_parse","kind":12,"line":273},{"containerName":"_parse","name":"$subfeat","line":273,"kind":13},{"name":"$i","containerName":"_parse","line":275,"kind":13},{"definition":"my","name":"$priseq","containerName":"_parse","localvar":"my","kind":13,"line":277},{"kind":12,"line":277,"containerName":"_parse","name":"new"},{"kind":13,"line":277,"name":"$name","containerName":"_parse"},{"name":"$seq","containerName":"_parse","kind":13,"line":277},{"kind":13,"line":278,"containerName":"_parse","name":"$feat"},{"line":278,"kind":12,"containerName":"_parse","name":"attach_seq"},{"containerName":"_parse","name":"$priseq","line":278,"kind":13},{"name":"$feat","containerName":"_parse","kind":13,"line":279}]},{"kind":12,"line":254,"name":"Bio","containerName":"SeqFeature::Generic"},{"kind":12,"line":261,"name":"Bio","containerName":"SeqFeature::Generic"},{"line":277,"kind":12,"containerName":"PrimarySeq","name":"Bio"}],"version":5}