{"version":5,"vars":[{"kind":2,"line":71,"name":"base","containerName":""},{"line":84,"children":[{"kind":13,"line":85,"definition":"my","name":"$class","containerName":"new","localvar":"my"},{"name":"@args","containerName":"new","line":85,"kind":13},{"kind":13,"line":87,"containerName":"new","definition":"my","name":"$self","localvar":"my"},{"line":87,"kind":13,"containerName":"new","name":"$class"},{"kind":13,"line":87,"containerName":"new","name":"@args"},{"line":88,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"_initialize_io","kind":12,"line":88},{"line":88,"kind":13,"name":"@args","containerName":"new"},{"containerName":"new","name":"$self","line":90,"kind":13}],"kind":12,"detail":"($class,@args)","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Blat.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Blat\n#\n# Written by Balamurugan Kumarasamy\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n=head1 NAME\n\nBio::Tools::Blat - parser for Blat program\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Blat;\n  my $blat_parser = Bio::Tools::Blat->new(-fh =>$filehandle );\n  while( my $blat_feat = $blat_parser->next_result ) {\n        push @blat_feat, $blat_feat;\n  }\n\n=head1 DESCRIPTION\n\n Parser for Blat program\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n User feedback is an integral part of the evolution of this and other\n Bioperl modules. Send your comments and suggestions preferably to\n the Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\n Report bugs to the Bioperl bug tracking system to help us keep track\n of the bugs and their resolution. Bug reports can be submitted the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Balamurugan Kumarasamy\n\n Email: bala@tll.org.sg\n\n=head1 APPENDIX\n\n The rest of the documentation details each of the object methods.\n Internal methods are usually preceded with a _\n\n\npackage Bio::Tools::Blat;\nuse strict;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Generic;\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Blat->new(-fh=>$filehandle);\n Function: Builds a new Bio::Tools::Blat object\n Returns : Bio::Tools::Blat\n Args    : -filename\n           -fh (filehandle)","label":"new($class,@args)"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":84},"end":{"line":91,"character":9999}},"name":"new"},{"kind":12,"line":87,"name":"SUPER","containerName":"new"},{"range":{"end":{"character":9999,"line":208},"start":{"line":103,"character":0}},"name":"next_result","line":103,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"next_result","line":104,"kind":13},{"kind":13,"line":105,"name":"$filehandle","definition":"my","containerName":"next_result","localvar":"my"},{"line":106,"kind":13,"localvar":"my","containerName":"next_result","name":"$line","definition":"my"},{"kind":13,"line":107,"containerName":"next_result","name":"$id","definition":"my","localvar":"my"},{"kind":13,"line":109,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"_readline","line":109,"kind":12},{"name":"$line","containerName":"next_result","kind":13,"line":111},{"line":112,"kind":13,"containerName":"next_result","name":"$line"},{"localvar":"my","definition":"my","name":"$matches","containerName":"next_result","line":114,"kind":13},{"kind":13,"line":114,"name":"$mismatches","containerName":"next_result"},{"name":"$rep_matches","containerName":"next_result","line":114,"kind":13},{"kind":13,"line":114,"containerName":"next_result","name":"$n_count"},{"containerName":"next_result","name":"$q_num_insert","kind":13,"line":114},{"kind":13,"line":115,"name":"$q_base_insert","containerName":"next_result"},{"containerName":"next_result","name":"$t_num_insert","line":115,"kind":13},{"name":"$t_base_insert","containerName":"next_result","kind":13,"line":115},{"name":"$strand","containerName":"next_result","kind":13,"line":115},{"name":"$q_name","containerName":"next_result","kind":13,"line":115},{"line":116,"kind":13,"containerName":"next_result","name":"$q_length"},{"containerName":"next_result","name":"$q_start","line":116,"kind":13},{"kind":13,"line":116,"containerName":"next_result","name":"$q_end"},{"kind":13,"line":116,"containerName":"next_result","name":"$t_name"},{"containerName":"next_result","name":"$t_length","line":116,"kind":13},{"name":"$t_start","containerName":"next_result","line":117,"kind":13},{"kind":13,"line":117,"name":"$t_end","containerName":"next_result"},{"containerName":"next_result","name":"$block_count","kind":13,"line":117},{"kind":13,"line":117,"name":"$block_sizes","containerName":"next_result"},{"containerName":"next_result","name":"$q_starts","kind":13,"line":117},{"kind":13,"line":119,"name":"$t_starts","containerName":"next_result"},{"localvar":"my","containerName":"next_result","definition":"my","name":"$superfeature","line":121,"kind":13},{"kind":12,"line":121,"containerName":"next_result","name":"new"},{"line":124,"kind":13,"containerName":"next_result","name":"$matches"},{"localvar":"my","containerName":"next_result","definition":"my","name":"%feat1","line":127,"kind":13},{"line":127,"kind":13,"containerName":"next_result","name":"%feat2"},{"kind":13,"line":128,"name":"$feat1","containerName":"next_result"},{"containerName":"next_result","name":"$t_name","kind":13,"line":128},{"containerName":"next_result","name":"$feat2","line":129,"kind":13},{"kind":13,"line":129,"containerName":"next_result","name":"$q_name"},{"containerName":"next_result","name":"$strand","line":131,"kind":13},{"name":"$strand","containerName":"next_result","kind":13,"line":131},{"name":"$feat2","containerName":"next_result","line":133,"kind":13},{"line":134,"kind":13,"containerName":"next_result","name":"$feat1"},{"containerName":"next_result","name":"$strand","line":134,"kind":13},{"kind":13,"line":136,"containerName":"next_result","name":"$percent_id","definition":"my","localvar":"my"},{"kind":13,"line":137,"name":"$matches","containerName":"next_result"},{"line":137,"kind":13,"name":"$rep_matches","containerName":"next_result"},{"kind":13,"line":137,"containerName":"next_result","name":"$matches"},{"containerName":"next_result","name":"$mismatches","line":137,"kind":13},{"line":137,"kind":13,"containerName":"next_result","name":"$rep_matches"},{"line":139,"kind":13,"containerName":"next_result","name":"$q_length"},{"kind":13,"line":140,"containerName":"next_result","name":"$self"},{"kind":12,"line":140,"name":"warn","containerName":"next_result"},{"line":144,"kind":13,"localvar":"my","name":"$score","definition":"my","containerName":"next_result"},{"containerName":"next_result","name":"$matches","kind":13,"line":145},{"line":145,"kind":13,"containerName":"next_result","name":"$mismatches"},{"kind":13,"line":145,"name":"$rep_matches","containerName":"next_result"},{"name":"$q_length","containerName":"next_result","kind":13,"line":145},{"line":148,"kind":13,"localvar":"my","containerName":"next_result","definition":"my","name":"@block_sizes"},{"containerName":"next_result","name":"$block_sizes","line":148,"kind":13},{"containerName":"next_result","name":"@q_start_positions","definition":"my","localvar":"my","kind":13,"line":152},{"containerName":"next_result","name":"$q_starts","line":152,"kind":13},{"line":153,"kind":13,"localvar":"my","containerName":"next_result","definition":"my","name":"@t_start_positions"},{"containerName":"next_result","name":"$t_starts","line":153,"kind":13},{"name":"$superfeature","containerName":"next_result","kind":13,"line":155},{"kind":12,"line":155,"name":"seq_id","containerName":"next_result"},{"kind":13,"line":155,"name":"$q_name","containerName":"next_result"},{"containerName":"next_result","name":"$superfeature","kind":13,"line":156},{"name":"score","containerName":"next_result","kind":12,"line":156},{"line":156,"kind":13,"name":"$score","containerName":"next_result"},{"kind":13,"line":157,"name":"$superfeature","containerName":"next_result"},{"containerName":"next_result","name":"add_tag_value","line":157,"kind":12},{"kind":13,"line":157,"name":"$percent_id","containerName":"next_result"},{"line":162,"kind":13,"localvar":"my","containerName":"next_result","name":"$i","definition":"my"},{"line":162,"kind":13,"containerName":"next_result","name":"$i"},{"line":162,"kind":13,"containerName":"next_result","name":"$block_count"},{"containerName":"next_result","name":"$i","line":162,"kind":13},{"kind":13,"line":164,"name":"$query_start","definition":"my","containerName":"next_result","localvar":"my"},{"line":164,"kind":13,"name":"$query_end","containerName":"next_result"},{"containerName":"next_result","name":"$strand","kind":13,"line":166},{"containerName":"next_result","name":"$query_start","kind":13,"line":167},{"kind":13,"line":167,"containerName":"next_result","name":"$q_start_positions"},{"name":"$i","containerName":"next_result","line":167,"kind":13},{"containerName":"next_result","name":"$query_end","line":168,"kind":13},{"line":168,"kind":13,"containerName":"next_result","name":"$query_start"},{"line":168,"kind":13,"name":"$block_sizes","containerName":"next_result"},{"containerName":"next_result","name":"$i","line":168,"kind":13},{"containerName":"next_result","name":"$query_end","kind":13,"line":170},{"line":170,"kind":13,"name":"$q_length","containerName":"next_result"},{"name":"$q_start_positions","containerName":"next_result","line":170,"kind":13},{"kind":13,"line":170,"containerName":"next_result","name":"$i"},{"line":171,"kind":13,"name":"$query_start","containerName":"next_result"},{"kind":13,"line":171,"name":"$query_end","containerName":"next_result"},{"name":"$block_sizes","containerName":"next_result","line":171,"kind":13},{"kind":13,"line":171,"containerName":"next_result","name":"$i"},{"kind":13,"line":176,"name":"$feat2","containerName":"next_result"},{"name":"$query_start","containerName":"next_result","line":176,"kind":13},{"containerName":"next_result","name":"$feat2","kind":13,"line":177},{"name":"$query_end","containerName":"next_result","line":177,"kind":13},{"name":"$query_end","containerName":"next_result","line":178,"kind":13},{"name":"$query_start","containerName":"next_result","kind":13,"line":178},{"containerName":"next_result","name":"$self","kind":13,"line":179},{"containerName":"next_result","name":"warn","line":179,"kind":12},{"containerName":"next_result","name":"$feat2","line":180,"kind":13},{"containerName":"next_result","name":"$query_start","line":180,"kind":13},{"line":181,"kind":13,"containerName":"next_result","name":"$feat2"},{"kind":13,"line":181,"containerName":"next_result","name":"$query_end"},{"name":"$feat1","containerName":"next_result","kind":13,"line":184},{"name":"$t_start_positions","containerName":"next_result","kind":13,"line":184},{"name":"$i","containerName":"next_result","line":184,"kind":13},{"kind":13,"line":185,"name":"$feat1","containerName":"next_result"},{"name":"$feat1","containerName":"next_result","kind":13,"line":185},{"containerName":"next_result","name":"$block_sizes","line":185,"kind":13},{"line":185,"kind":13,"name":"$i","containerName":"next_result"},{"containerName":"next_result","name":"$feat2","line":188,"kind":13},{"containerName":"next_result","name":"$score","line":188,"kind":13},{"name":"$feat1","containerName":"next_result","line":189,"kind":13},{"name":"$feat2","containerName":"next_result","kind":13,"line":189},{"kind":13,"line":190,"name":"$feat2","containerName":"next_result"},{"name":"$percent_id","containerName":"next_result","line":190,"kind":13},{"containerName":"next_result","name":"$feat1","kind":13,"line":191},{"line":191,"kind":13,"containerName":"next_result","name":"$feat2"},{"kind":13,"line":194,"name":"$feat1","containerName":"next_result"},{"name":"$feat1","containerName":"next_result","line":195,"kind":13},{"containerName":"next_result","name":"$feat1","kind":13,"line":196},{"kind":13,"line":197,"containerName":"next_result","name":"$feat1"},{"name":"$feat1","containerName":"next_result","kind":13,"line":198},{"containerName":"next_result","name":"$feat1","line":199,"kind":13},{"line":200,"kind":13,"containerName":"next_result","name":"$feat2"},{"containerName":"next_result","name":"$feat2","line":201,"kind":13},{"kind":13,"line":203,"containerName":"next_result","definition":"my","name":"$feature_pair","localvar":"my"},{"line":203,"kind":13,"containerName":"next_result","name":"$self"},{"line":203,"kind":12,"name":"create_feature","containerName":"next_result"},{"name":"%feat1","containerName":"next_result","line":203,"kind":13},{"name":"%feat2","containerName":"next_result","line":203,"kind":13},{"containerName":"next_result","name":"$superfeature","line":204,"kind":13},{"name":"add_sub_SeqFeature","containerName":"next_result","kind":12,"line":204},{"line":204,"kind":13,"containerName":"next_result","name":"$feature_pair"},{"line":206,"kind":13,"containerName":"next_result","name":"$superfeature"}],"kind":12,"detail":"($self)","signature":{"label":"next_result($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Blat.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Blat\n#\n# Written by Balamurugan Kumarasamy\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n=head1 NAME\n\nBio::Tools::Blat - parser for Blat program\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Blat;\n  my $blat_parser = Bio::Tools::Blat->new(-fh =>$filehandle );\n  while( my $blat_feat = $blat_parser->next_result ) {\n        push @blat_feat, $blat_feat;\n  }\n\n=head1 DESCRIPTION\n\n Parser for Blat program\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n User feedback is an integral part of the evolution of this and other\n Bioperl modules. Send your comments and suggestions preferably to\n the Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\n Report bugs to the Bioperl bug tracking system to help us keep track\n of the bugs and their resolution. Bug reports can be submitted the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Balamurugan Kumarasamy\n\n Email: bala@tll.org.sg\n\n=head1 APPENDIX\n\n The rest of the documentation details each of the object methods.\n Internal methods are usually preceded with a _\n\n\npackage Bio::Tools::Blat;\nuse strict;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Generic;\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Blat->new(-fh=>$filehandle);\n Function: Builds a new Bio::Tools::Blat object\n Returns : Bio::Tools::Blat\n Args    : -filename\n           -fh (filehandle)\n\n\nsub new {\n      my($class,@args) = @_;\n\n      my $self = $class->SUPER::new(@args);\n      $self->_initialize_io(@args);\n\n      return $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $feat = $blat_parser->next_result\n Function: Get the next result set from parser data\n Returns : L<Bio::SeqFeature::Generic>\n Args    : none"},"containerName":"main::","definition":"sub"},{"name":"Bio","containerName":"SeqFeature::Generic","line":121,"kind":12},{"name":"name","kind":12,"line":128},{"name":"name","line":129,"kind":12},{"name":"strand","line":133,"kind":12},{"kind":12,"line":134,"name":"strand"},{"kind":12,"line":176,"name":"start"},{"line":177,"kind":12,"name":"end"},{"line":180,"kind":12,"name":"end"},{"name":"start","line":181,"kind":12},{"kind":12,"line":184,"name":"start"},{"name":"end","line":185,"kind":12},{"name":"start","line":185,"kind":12},{"name":"score","kind":12,"line":188},{"line":189,"kind":12,"name":"score"},{"name":"score","line":189,"kind":12},{"name":"percent","kind":12,"line":190},{"kind":12,"line":191,"name":"percent"},{"name":"percent","line":191,"kind":12},{"name":"db","line":194,"kind":12},{"kind":12,"line":195,"name":"db_version"},{"name":"program","kind":12,"line":196},{"kind":12,"line":197,"name":"p_version"},{"name":"source","kind":12,"line":198},{"kind":12,"line":199,"name":"primary"},{"name":"source","line":200,"kind":12},{"kind":12,"line":201,"name":"primary"},{"children":[{"name":"$self","definition":"my","containerName":"create_feature","localvar":"my","kind":13,"line":222},{"kind":13,"line":222,"containerName":"create_feature","name":"$feat1"},{"containerName":"create_feature","name":"$feat2","line":222,"kind":13},{"kind":13,"line":223,"containerName":"create_feature","name":"$feature1","definition":"my","localvar":"my"},{"kind":12,"line":223,"name":"new","containerName":"create_feature"},{"line":224,"kind":13,"name":"$feat1","containerName":"create_feature"},{"containerName":"create_feature","name":"$feat1","line":225,"kind":13},{"line":226,"kind":13,"containerName":"create_feature","name":"$feat1"},{"line":227,"kind":13,"containerName":"create_feature","name":"$feat1"},{"name":"$feat1","containerName":"create_feature","kind":13,"line":228},{"containerName":"create_feature","name":"$feat1","kind":13,"line":229},{"name":"$feat1","containerName":"create_feature","kind":13,"line":230},{"localvar":"my","containerName":"create_feature","name":"$feature2","definition":"my","line":232,"kind":13},{"kind":12,"line":232,"containerName":"create_feature","name":"new"},{"kind":13,"line":233,"name":"$feat2","containerName":"create_feature"},{"containerName":"create_feature","name":"$feat2","line":234,"kind":13},{"containerName":"create_feature","name":"$feat2","line":235,"kind":13},{"line":236,"kind":13,"name":"$feat2","containerName":"create_feature"},{"kind":13,"line":237,"name":"$feat2","containerName":"create_feature"},{"containerName":"create_feature","name":"$feat2","line":238,"kind":13},{"line":239,"kind":13,"name":"$feat2","containerName":"create_feature"},{"localvar":"my","definition":"my","name":"$featurepair","containerName":"create_feature","line":241,"kind":13},{"name":"new","containerName":"create_feature","kind":12,"line":241},{"kind":13,"line":242,"name":"$featurepair","containerName":"create_feature"},{"name":"feature1","containerName":"create_feature","kind":12,"line":242},{"containerName":"create_feature","name":"$feature1","line":242,"kind":13},{"line":243,"kind":13,"containerName":"create_feature","name":"$featurepair"},{"kind":12,"line":243,"name":"feature2","containerName":"create_feature"},{"name":"$feature2","containerName":"create_feature","kind":13,"line":243},{"line":245,"kind":13,"containerName":"create_feature","name":"$featurepair"},{"containerName":"create_feature","name":"add_tag_value","kind":12,"line":245},{"line":245,"kind":13,"containerName":"create_feature","name":"$feat2"},{"kind":13,"line":246,"containerName":"create_feature","name":"$featurepair"},{"kind":12,"line":246,"containerName":"create_feature","name":"add_tag_value"},{"name":"$feat2","containerName":"create_feature","line":246,"kind":13},{"line":247,"kind":13,"name":"$featurepair","containerName":"create_feature"},{"containerName":"create_feature","name":"add_tag_value","kind":12,"line":247},{"line":247,"kind":13,"name":"$feat2","containerName":"create_feature"},{"line":248,"kind":13,"name":"$featurepair","containerName":"create_feature"}],"line":221,"kind":12,"signature":{"label":"create_feature($self,$feat1,$feat2)","documentation":"1;\n# $Id: Blat.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Blat\n#\n# Written by Balamurugan Kumarasamy\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n=head1 NAME\n\nBio::Tools::Blat - parser for Blat program\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Blat;\n  my $blat_parser = Bio::Tools::Blat->new(-fh =>$filehandle );\n  while( my $blat_feat = $blat_parser->next_result ) {\n        push @blat_feat, $blat_feat;\n  }\n\n=head1 DESCRIPTION\n\n Parser for Blat program\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n User feedback is an integral part of the evolution of this and other\n Bioperl modules. Send your comments and suggestions preferably to\n the Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\n Report bugs to the Bioperl bug tracking system to help us keep track\n of the bugs and their resolution. Bug reports can be submitted the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Balamurugan Kumarasamy\n\n Email: bala@tll.org.sg\n\n=head1 APPENDIX\n\n The rest of the documentation details each of the object methods.\n Internal methods are usually preceded with a _\n\n\npackage Bio::Tools::Blat;\nuse strict;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Generic;\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Blat->new(-fh=>$filehandle);\n Function: Builds a new Bio::Tools::Blat object\n Returns : Bio::Tools::Blat\n Args    : -filename\n           -fh (filehandle)\n\n\nsub new {\n      my($class,@args) = @_;\n\n      my $self = $class->SUPER::new(@args);\n      $self->_initialize_io(@args);\n\n      return $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $feat = $blat_parser->next_result\n Function: Get the next result set from parser data\n Returns : L<Bio::SeqFeature::Generic>\n Args    : none\n\n\nsub next_result {\n\tmy ($self) = @_;\n\tmy $filehandle;\n\tmy $line;\n\tmy $id;\n\n\twhile ($_=$self->_readline()){\n\t\t# first split on spaces:\n\t\t$line = $_;\n\t\tchomp $line;\n\n\t\tmy ($matches, $mismatches, $rep_matches, $n_count, $q_num_insert,\n\t\t\t $q_base_insert, $t_num_insert, $t_base_insert, $strand, $q_name,\n\t\t\t $q_length, $q_start, $q_end, $t_name, $t_length, \n\t\t\t $t_start, $t_end, $block_count, $block_sizes, $q_starts,\n\t\t\t $t_starts\n\t\t\t) = split;\n\n\t\tmy $superfeature = Bio::SeqFeature::Generic->new();\n\n\t\t# ignore any preceeding text\n\t\tnext unless ( $matches =~/^\\d+$/ );\n\n\t\t# create as many features as blocks there are in each output line\n\t\tmy (%feat1, %feat2);\n\t\t$feat1{name} = $t_name;\n\t\t$feat2{name} = $q_name;\n\n\t\t$strand = $1 if ($strand =~/([+-])[+-]/);\n\n\t\t$feat2{strand} = 1;\n\t\t$feat1{strand} = $strand;\n\n\t\tmy $percent_id = sprintf \"%.2f\",\n\t\t(100 * ($matches + $rep_matches)/( $matches + $mismatches + $rep_matches));\n\n\t\tunless ( $q_length ){\n\t\t\t$self->warn(\"length of query is zero, something is wrong!\");\n\t\t\tnext;\n\t\t}\n\n\t\tmy $score   = sprintf \"%.2f\",\n\t\t(100 * ( $matches + $mismatches + $rep_matches ) / $q_length);\n\n\t\t# size of each block of alignment (inclusive)\n\t\tmy @block_sizes     = split \",\",$block_sizes;\n\n\t\t# start position of each block (you must add 1 as psl output \n\t\t# is off by one in the start coordinate)\n\t\tmy @q_start_positions = split \",\",$q_starts;\n\t\tmy @t_start_positions = split \",\",$t_starts;\n\n\t\t$superfeature->seq_id($q_name);\n\t\t$superfeature->score( $score );\n\t\t$superfeature->add_tag_value('percent_id',$percent_id);\n\n\t\t# each line of output represents one possible entire aligment \n\t\t# of the query (feat1) and the target(feat2)\n\n\t\tfor (my $i=0; $i<$block_count; $i++ ){\n\n\t\t\tmy ($query_start,$query_end);\n\n\t\t\tif ( $strand eq '+' ){\n\t\t\t\t$query_start = $q_start_positions[$i] + 1;\n\t\t\t\t$query_end   = $query_start + $block_sizes[$i] - 1;\n\t\t\t}else{\n\t\t\t\t$query_end   = $q_length  - $q_start_positions[$i];\n\t\t\t\t$query_start = $query_end - $block_sizes[$i] + 1;\n\t\t\t}\n\n\t\t\t#$feat2 {start} = $q_start_positions[$i] + 1;\n\t\t\t#$feat2 {end}   = $feat2{start} + $block_sizes[$i] - 1;\n\t\t\t$feat2 {start} = $query_start;\n\t\t\t$feat2 {end}   = $query_end;\n\t\t\tif ( $query_end <  $query_start ){\n\t\t\t\t$self->warn(\"dodgy feature coordinates: end = $query_end, start = $query_start. Reversing...\");\n\t\t\t\t$feat2 {end}   = $query_start;\n\t\t\t\t$feat2 {start} = $query_end;\n\t\t\t}\n\n\t\t\t$feat1 {start} = $t_start_positions[$i] + 1;\n\t\t\t$feat1 {end}   = $feat1{start} + $block_sizes[$i] - 1;\n\n\t\t\t# we put all the features with the same score and percent_id\n\t\t\t$feat2 {score}   = $score;\n\t\t\t$feat1 {score}   = $feat2 {score};\n\t\t\t$feat2 {percent} = $percent_id;\n\t\t\t$feat1 {percent} = $feat2 {percent};\n\n\t\t\t# other stuff:\n\t\t\t$feat1 {db}         = undef;\n\t\t\t$feat1 {db_version} = undef;\n\t\t\t$feat1 {program}    = 'blat';\n\t\t\t$feat1 {p_version}  = '1';\n\t\t\t$feat1 {source}     = 'blat';\n\t\t\t$feat1 {primary}    = 'similarity';\n\t\t\t$feat2 {source}     = 'blat';\n\t\t\t$feat2 {primary}    = 'similarity';\n\n\t\t\tmy $feature_pair = $self->create_feature(\\%feat1, \\%feat2);\n\t\t\t$superfeature->add_sub_SeqFeature( $feature_pair,'EXPAND');\n\t\t}\n\t\treturn $superfeature;\n\t}\n}\n\n=head2 create_feature\n\n Title   : create_feature\n Usage   : my $feat=$blat_parser->create_feature($feature,$seqname)\n Function: creates a SeqFeature Generic object\n Returns : L<Bio::SeqFeature::Generic>\n Args    :","parameters":[{"label":"$self"},{"label":"$feat1"},{"label":"$feat2"}]},"detail":"($self,$feat1,$feat2)","definition":"sub","containerName":"main::","range":{"start":{"line":221,"character":0},"end":{"character":9999,"line":249}},"name":"create_feature"},{"name":"Bio","containerName":"SeqFeature::Generic","line":223,"kind":12},{"kind":12,"line":224,"name":"name"},{"kind":12,"line":225,"name":"start"},{"name":"end","kind":12,"line":226},{"kind":12,"line":227,"name":"strand"},{"line":228,"kind":12,"name":"score"},{"name":"source","kind":12,"line":229},{"name":"primary","line":230,"kind":12},{"containerName":"SeqFeature::Generic","name":"Bio","line":232,"kind":12},{"name":"name","kind":12,"line":233},{"line":234,"kind":12,"name":"start"},{"kind":12,"line":235,"name":"end"},{"name":"strand","kind":12,"line":236},{"name":"score","line":237,"kind":12},{"line":238,"kind":12,"name":"source"},{"name":"primary","kind":12,"line":239},{"name":"Bio","containerName":"SeqFeature::FeaturePair","kind":12,"line":241},{"name":"percent","line":246,"kind":12},{"line":247,"kind":12,"name":"primary"}]}