{"vars":[{"containerName":"","name":"vars","line":92,"kind":2},{"name":"Common","containerName":"HTML::HeadParser::Bio::SeqFeature::Generic::HTTP::Request","line":95,"kind":2},{"kind":2,"line":97,"containerName":"","name":"base"},{"name":"%cc","containerName":null,"line":100,"kind":13},{"name":"all","line":101,"kind":12},{"line":102,"kind":12,"name":"nucleus"},{"name":"extracellular","line":103,"kind":12},{"line":104,"kind":12,"name":"cytoplasm"},{"name":"peroxisome","line":105,"kind":12},{"name":"glycosome","kind":12,"line":106},{"name":"glyoxisome","kind":12,"line":107},{"name":"golgi","kind":12,"line":108},{"name":"er","line":109,"kind":12},{"line":110,"kind":12,"name":"lysosome"},{"line":111,"kind":12,"name":"endosome"},{"line":112,"kind":12,"name":"plasma_membrane"},{"localvar":"my","containerName":null,"definition":"my","name":"$URL","line":115,"kind":13},{"line":116,"kind":13,"localvar":"my","containerName":null,"name":"$ANALYSIS_NAME","definition":"my"},{"line":117,"kind":13,"localvar":"my","name":"@INPUT_SPEC","definition":"my","containerName":null},{"localvar":"my","containerName":null,"name":"%RESULT_SPEC","definition":"my","line":138,"kind":13},{"definition":"my","name":"%ANALYSIS_SPEC","containerName":null,"localvar":"my","kind":13,"line":148},{"kind":12,"line":148,"name":"name"},{"kind":12,"line":149,"name":"type"},{"name":"version","kind":12,"line":150},{"name":"supplier","line":151,"kind":12},{"name":"description","kind":12,"line":152},{"kind":12,"line":154,"name":"reference"},{"line":157,"children":[{"line":158,"kind":13,"localvar":"my","containerName":"_init","name":"$self","definition":"my"},{"name":"$self","containerName":"_init","line":159,"kind":13},{"line":159,"kind":12,"name":"url","containerName":"_init"},{"containerName":"_init","name":"$URL","line":159,"kind":13},{"name":"$self","containerName":"_init","kind":13,"line":160},{"line":160,"kind":13,"containerName":"_init","name":"$ANALYSIS_SPEC"},{"name":"$self","containerName":"_init","line":161,"kind":13},{"kind":13,"line":161,"name":"$INPUT_SPEC","containerName":"_init"},{"name":"$self","containerName":"_init","kind":13,"line":162},{"line":162,"kind":13,"containerName":"_init","name":"$RESULT_SPEC"},{"line":163,"kind":13,"name":"$self","containerName":"_init"},{"name":"$ANALYSIS_NAME","containerName":"_init","kind":13,"line":163},{"kind":13,"line":164,"name":"$self","containerName":"_init"}],"kind":12,"range":{"end":{"character":9999,"line":165},"start":{"line":157,"character":0}},"containerName":"main::","definition":"sub","name":"_init"},{"range":{"start":{"character":0,"line":178},"end":{"character":9999,"line":198}},"name":"compartment","signature":{"documentation":"1;\n# $Id: ELM.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Analysis::Protein::ELM\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Richard Adams <richard.adams@ed.ac.uk>\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1     NAME\n\nBio::Tools::Analysis::Protein::ELM - a wrapper around the ELM server which predicts short functional motifs on amino acid sequences\n\n=head1     SYNOPSIS\n\n  # get a Bio::Seq object to start with, or a Bio::PrimaryI object.\n\n  my $tool = Bio::Tools::Analysis::Protein::ELM->\n      new(seq => $seqobj->primary_seq() );\t\n  $tool->compartment(['ER', 'Golgi']);\n  $tool->species(9606);\n  $tool->run;\n  my @fts = $tool->Result('Bio::SeqFeatureI');\n  $seqobj->addSeqFeature(@fts);\n\n=head1    DESCRIPTION\n\nThis module is a wrapper around the ELM server L<http://elm.eu.org/>\nwhich predicts short functional motifs on amino acid sequences. \n\nFalse positives can be limited by providing values for the species\nand cellular compartment of the protein. To set the species attribute,\nuse either a L<Bio::Species> object or an NCBI taxon ID number.  To set\nthe cell compartment attribute (any number of compartments can be\nchosen) use an array reference to a list of compartment names.\n\nResults can be obtained either as raw text output, parsed into a\ndata structure, or as Bio::SeqFeature::Generic objects.\n\n=head1 SEE ALSO\n\nL<Bio::SimpleAnalysisI>, \nL<Bio::WebAgent>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk, \n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\nuse strict;\npackage Bio::Tools::Analysis::Protein::ELM;\nuse vars qw(%cc);\nuse HTML::HeadParser;\nuse Bio::SeqFeature::Generic;\nuse HTTP::Request::Common qw(POST);\nuse IO::String;\nuse base qw(Bio::Tools::Analysis::SimpleAnalysisBase);\n\n## valid cell compartments ##\n%cc = (\n      all            => 1,\n      nucleus        => 'GO:0005634',\n      extracellular  => 'GO:0005576',\n      cytoplasm      => 'GO:0005737',\n      peroxisome     => 'GO:0005777',\n      glycosome      => 'GO:0020015',\n      glyoxisome     => 'GO:0009514',\n      golgi          => 'GO:0005794',\n      er             => 'GO:0005783',\n      lysosome       => 'GO:0005764',\n      endosome       => 'GO:0005768',\n      plasma_membrane=> 'GO:0005886',\n\t\t);\n\nmy $URL           = 'http://elm.eu.org/basicELM/cgimodel.py';\nmy $ANALYSIS_NAME = 'ELM';\nmy $INPUT_SPEC    =\n    [\n     {\n      'mandatory' => 'true',\n      'type'      => 'Bio::PrimarySeqI',\n      'name'      => 'seq',\n     },\n     {\n      'mandatory' => 'false',\n      'type'      => 'taxon_id or Bio::Species object',\n      'name'      => 'species',\n      'default'   => '9606',\n     },\n     {\n      'mandatory' => 'false',\n      'type'      => 'string',\n      'name'      => 'compartment',\n      'default'   => [1],\n     },\n    ];\n\nmy  $RESULT_SPEC =\n    {\n     ''                 => 'bulk',              # same as undef\n     'Bio::SeqFeatureI' => 'ARRAY of Bio::SeqFeature::Generic',\n     'parsed'           => '{motif1_name=>{locus=>[],\n\t\t\t\t\t   peptide=>[],\n\t\t\t\t\t   regexp=>[]\n\t\t\t\t\t  },\n\t\t\t    }',\n    };\nmy $ANALYSIS_SPEC= {name        => 'ELM',\n\t\t\t\t    type        => 'Protein',\n                    version     => 'n/a',\n                    supplier    =>'BioComputing Unit, EMBL',\n\t\t\t\t\tdescription =>'Prediction of linear functional motifs\n                                  in proteins',\n\t\t\t\t\treference   => 'NAR, 31:3625-3630'};\n\n\nsub _init {\n    my $self = shift;\n    $self->url($URL);\n    $self->{'_ANALYSIS_SPEC'} = $ANALYSIS_SPEC;\n    $self->{'_INPUT_SPEC'}    = $INPUT_SPEC;\n    $self->{'_RESULT_SPEC'}   = $RESULT_SPEC;\n    $self->{'_ANALYSIS_NAME'} = $ANALYSIS_NAME;\n    return $self;\n}\n\n=head2        compartment\n\n name        : compartment\n usage       : $elm->compartment(['golgi', 'er']);\n purpose     : get/setter for cell compartment specifications\n arguments   : None, single compartment string or ref to array of\n               compartment names.\n returns     : Array of compartment names (default if not previously set).","parameters":[{"label":"$self"},{"label":"$arg"}],"label":"compartment($self,$arg)"},"detail":"($self,$arg)","definition":"sub","containerName":"main::","children":[{"name":"$self","definition":"my","containerName":"compartment","localvar":"my","kind":13,"line":180},{"line":180,"kind":13,"name":"$arg","containerName":"compartment"},{"kind":13,"line":181,"containerName":"compartment","name":"$arg"},{"containerName":"compartment","name":"$arg","line":184,"kind":13},{"kind":13,"line":185,"containerName":"compartment","name":"$arg"},{"name":"$arg","containerName":"compartment","line":185,"kind":13},{"definition":"my","name":"$param","containerName":"compartment","localvar":"my","kind":13,"line":189},{"kind":13,"line":189,"name":"$arg","containerName":"compartment"},{"containerName":"compartment","name":"$cc","kind":13,"line":190},{"containerName":"compartment","name":"$param","line":190,"kind":13},{"line":191,"kind":13,"containerName":"compartment","name":"$self"},{"kind":13,"line":191,"containerName":"compartment","name":"$cc"},{"line":191,"kind":13,"containerName":"compartment","name":"$param"},{"line":193,"kind":13,"containerName":"compartment","name":"$self"},{"name":"warn","containerName":"compartment","line":193,"kind":12},{"containerName":"compartment","name":"%cc","kind":13,"line":194}],"line":178,"kind":12},{"containerName":null,"name":"%self","line":199,"kind":13},{"kind":13,"line":199,"name":"%self","containerName":null},{"containerName":null,"name":"$self","kind":13,"line":200},{"line":200,"kind":12,"name":"input_spec","containerName":"main::"},{"line":214,"children":[{"line":215,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"species"},{"kind":13,"line":215,"containerName":"species","name":"$arg"},{"line":217,"kind":13,"containerName":"species","name":"$arg"},{"line":218,"kind":13,"name":"$arg","containerName":"species"},{"line":218,"kind":13,"containerName":"species","name":"$arg"},{"containerName":"species","name":"isa","kind":12,"line":218},{"containerName":"species","name":"$self","line":219,"kind":13},{"line":219,"kind":13,"containerName":"species","name":"$arg"},{"kind":12,"line":219,"containerName":"species","name":"ncbi_taxid"},{"name":"$arg","containerName":"species","kind":13,"line":220},{"kind":13,"line":221,"containerName":"species","name":"$self"},{"containerName":"species","name":"$arg","line":221,"kind":13},{"containerName":"species","name":"$self","kind":13,"line":223},{"kind":12,"line":223,"name":"warn","containerName":"species"},{"containerName":"species","name":"$self","kind":13,"line":227},{"name":"$self","containerName":"species","line":227,"kind":13},{"containerName":"species","name":"$self","kind":13,"line":228},{"containerName":"species","name":"input_spec","kind":12,"line":228}],"kind":12,"detail":"($self,$arg)","signature":{"parameters":[{"label":"$self"},{"label":"$arg"}],"documentation":"1;\n# $Id: ELM.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Analysis::Protein::ELM\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Richard Adams <richard.adams@ed.ac.uk>\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1     NAME\n\nBio::Tools::Analysis::Protein::ELM - a wrapper around the ELM server which predicts short functional motifs on amino acid sequences\n\n=head1     SYNOPSIS\n\n  # get a Bio::Seq object to start with, or a Bio::PrimaryI object.\n\n  my $tool = Bio::Tools::Analysis::Protein::ELM->\n      new(seq => $seqobj->primary_seq() );\t\n  $tool->compartment(['ER', 'Golgi']);\n  $tool->species(9606);\n  $tool->run;\n  my @fts = $tool->Result('Bio::SeqFeatureI');\n  $seqobj->addSeqFeature(@fts);\n\n=head1    DESCRIPTION\n\nThis module is a wrapper around the ELM server L<http://elm.eu.org/>\nwhich predicts short functional motifs on amino acid sequences. \n\nFalse positives can be limited by providing values for the species\nand cellular compartment of the protein. To set the species attribute,\nuse either a L<Bio::Species> object or an NCBI taxon ID number.  To set\nthe cell compartment attribute (any number of compartments can be\nchosen) use an array reference to a list of compartment names.\n\nResults can be obtained either as raw text output, parsed into a\ndata structure, or as Bio::SeqFeature::Generic objects.\n\n=head1 SEE ALSO\n\nL<Bio::SimpleAnalysisI>, \nL<Bio::WebAgent>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk, \n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\nuse strict;\npackage Bio::Tools::Analysis::Protein::ELM;\nuse vars qw(%cc);\nuse HTML::HeadParser;\nuse Bio::SeqFeature::Generic;\nuse HTTP::Request::Common qw(POST);\nuse IO::String;\nuse base qw(Bio::Tools::Analysis::SimpleAnalysisBase);\n\n## valid cell compartments ##\n%cc = (\n      all            => 1,\n      nucleus        => 'GO:0005634',\n      extracellular  => 'GO:0005576',\n      cytoplasm      => 'GO:0005737',\n      peroxisome     => 'GO:0005777',\n      glycosome      => 'GO:0020015',\n      glyoxisome     => 'GO:0009514',\n      golgi          => 'GO:0005794',\n      er             => 'GO:0005783',\n      lysosome       => 'GO:0005764',\n      endosome       => 'GO:0005768',\n      plasma_membrane=> 'GO:0005886',\n\t\t);\n\nmy $URL           = 'http://elm.eu.org/basicELM/cgimodel.py';\nmy $ANALYSIS_NAME = 'ELM';\nmy $INPUT_SPEC    =\n    [\n     {\n      'mandatory' => 'true',\n      'type'      => 'Bio::PrimarySeqI',\n      'name'      => 'seq',\n     },\n     {\n      'mandatory' => 'false',\n      'type'      => 'taxon_id or Bio::Species object',\n      'name'      => 'species',\n      'default'   => '9606',\n     },\n     {\n      'mandatory' => 'false',\n      'type'      => 'string',\n      'name'      => 'compartment',\n      'default'   => [1],\n     },\n    ];\n\nmy  $RESULT_SPEC =\n    {\n     ''                 => 'bulk',              # same as undef\n     'Bio::SeqFeatureI' => 'ARRAY of Bio::SeqFeature::Generic',\n     'parsed'           => '{motif1_name=>{locus=>[],\n\t\t\t\t\t   peptide=>[],\n\t\t\t\t\t   regexp=>[]\n\t\t\t\t\t  },\n\t\t\t    }',\n    };\nmy $ANALYSIS_SPEC= {name        => 'ELM',\n\t\t\t\t    type        => 'Protein',\n                    version     => 'n/a',\n                    supplier    =>'BioComputing Unit, EMBL',\n\t\t\t\t\tdescription =>'Prediction of linear functional motifs\n                                  in proteins',\n\t\t\t\t\treference   => 'NAR, 31:3625-3630'};\n\n\nsub _init {\n    my $self = shift;\n    $self->url($URL);\n    $self->{'_ANALYSIS_SPEC'} = $ANALYSIS_SPEC;\n    $self->{'_INPUT_SPEC'}    = $INPUT_SPEC;\n    $self->{'_RESULT_SPEC'}   = $RESULT_SPEC;\n    $self->{'_ANALYSIS_NAME'} = $ANALYSIS_NAME;\n    return $self;\n}\n\n=head2        compartment\n\n name        : compartment\n usage       : $elm->compartment(['golgi', 'er']);\n purpose     : get/setter for cell compartment specifications\n arguments   : None, single compartment string or ref to array of\n               compartment names.\n returns     : Array of compartment names (default if not previously set).\n\n\nsub compartment {\n\n    my ($self, $arg) = @_;\n    if ($arg) {\n\n        # convert to array ref if not one already\n\tif (ref ($arg) ne 'ARRAY') {\n            $arg = [$arg];\n\t}\n \n        ## now add params if valid\n\tfor my $param (@$arg) {\n            if (exists($cc{lc($param)})) {\n                push @{$self->{'_compartment'}} , $cc{$param};\n            } else {\n                $self->warn(\"invalid argument ! Must be one of \" .\n                            join \"\\n\", keys %cc );\n            }\n        }                       #end of for loop\n\t\t\t\n    }                           #endif $arg\n    return defined($self->{'_compartment'})? $self->{'_compartment'}\n        : $self->input_spec()->[2]{'default'};\n\n}\n\n=head1      species\n\n name      : species\n usage     : $tool->species('9606');\n purpose   : get/setter for species selction for ELM server\n arguments : none, taxon_id or Bio::Species object\n returns   : a string of the ncbi taxon_id","label":"species($self,$arg)"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":214},"end":{"character":9999,"line":230}},"name":"species"},{"range":{"end":{"character":9999,"line":244},"start":{"character":0,"line":232}},"name":"_run","definition":"sub","containerName":"main::","children":[{"kind":13,"line":233,"containerName":"_run","definition":"my","name":"$self","localvar":"my"},{"line":234,"kind":13,"name":"$self","containerName":"_run"},{"kind":12,"line":234,"containerName":"_run","name":"delay"},{"kind":13,"line":237,"containerName":"_run","name":"$self"},{"name":"status","containerName":"_run","kind":12,"line":237},{"kind":13,"line":243,"definition":"my","name":"@cc_str","containerName":"_run","localvar":"my"},{"localvar":"my","containerName":"_run","name":"@cmpts","definition":"my","line":244,"kind":13},{"line":244,"kind":13,"name":"$self","containerName":"_run"},{"name":"compartment","containerName":"_run","kind":12,"line":244}],"line":232,"kind":12},{"kind":13,"line":245,"containerName":null,"name":"$i","definition":"my","localvar":"my"},{"containerName":null,"name":"$i","line":245,"kind":13},{"line":245,"kind":12,"name":"cmpts"},{"name":"%i","containerName":null,"line":245,"kind":13},{"kind":13,"line":246,"containerName":null,"name":"@cc_str"},{"line":246,"kind":13,"name":"@cc_str","containerName":null},{"kind":13,"line":246,"containerName":null,"name":"@cmpts"},{"kind":13,"line":246,"containerName":null,"name":"$i"},{"line":248,"kind":13,"localvar":"my","containerName":null,"name":"%h","definition":"my"},{"name":"swissprotId","line":248,"kind":12},{"line":249,"kind":12,"name":"sequence"},{"containerName":null,"name":"$self","line":249,"kind":13},{"containerName":"main::","name":"seq","kind":12,"line":249},{"containerName":"main::","name":"seq","kind":12,"line":249},{"name":"userSpecies","line":250,"kind":12},{"line":250,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"line":250,"containerName":"main::","name":"species"},{"kind":12,"line":251,"name":"typedUserSpecies"},{"kind":12,"line":252,"name":"fun"},{"containerName":null,"name":"@cc_str","line":253,"kind":13},{"containerName":null,"name":"@cc_str","line":253,"kind":13},{"name":"%h","containerName":null,"kind":13,"line":253},{"name":"%h","containerName":null,"line":253,"kind":13},{"name":"$request","definition":"my","containerName":null,"localvar":"my","kind":13,"line":256},{"name":"POST","line":256,"kind":12},{"name":"$self","containerName":null,"line":256,"kind":13},{"name":"url","containerName":"main::","kind":12,"line":256},{"name":"Content_Type","kind":12,"line":257},{"kind":12,"line":258,"name":"Content"},{"kind":13,"line":258,"containerName":null,"name":"@cc_str"},{"line":259,"kind":13,"name":"$self","containerName":null},{"name":"debug","containerName":"main::","line":259,"kind":12},{"line":259,"kind":13,"containerName":null,"name":"$request"},{"containerName":"main::","name":"as_string","line":259,"kind":12},{"kind":13,"line":260,"containerName":null,"definition":"my","name":"$r1","localvar":"my"},{"containerName":null,"name":"$self","line":260,"kind":13},{"name":"request","containerName":"main::","line":260,"kind":12},{"name":"$request","containerName":null,"kind":13,"line":260},{"containerName":null,"name":"$r1","line":261,"kind":13},{"containerName":"main::","name":"is_error","line":261,"kind":12},{"line":262,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","name":"warn","kind":12,"line":262},{"kind":13,"line":262,"containerName":null,"name":"$self"},{"containerName":null,"name":"$r1","kind":13,"line":262},{"name":"as_string","containerName":"main::","kind":12,"line":262},{"containerName":null,"definition":"my","name":"$text","localvar":"my","kind":13,"line":266},{"containerName":null,"name":"$r1","line":266,"kind":13},{"name":"content","containerName":"main::","line":266,"kind":12},{"name":"$url","definition":"my","containerName":null,"localvar":"my","kind":13,"line":267},{"containerName":null,"name":"$text","kind":13,"line":267},{"localvar":"my","containerName":null,"name":"$resp2","definition":"my","line":269,"kind":13},{"line":270,"kind":13,"name":"$url","containerName":null},{"kind":13,"line":270,"name":"$URL","containerName":null},{"line":270,"kind":13,"containerName":null,"name":"%url"},{"line":272,"kind":13,"localvar":"my","definition":"my","name":"$req2","containerName":null},{"kind":12,"line":272,"name":"HTTP","containerName":"Request"},{"line":272,"kind":12,"containerName":"main::","name":"new"},{"name":"GET","line":272,"kind":12},{"containerName":null,"name":"$url","kind":13,"line":272},{"localvar":"my","name":"$r2","definition":"my","containerName":null,"line":273,"kind":13},{"line":273,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"line":273,"containerName":"main::","name":"request"},{"kind":13,"line":273,"containerName":null,"name":"$req2"},{"containerName":null,"name":"$r2","line":274,"kind":13},{"containerName":"main::","name":"is_error","kind":12,"line":274},{"name":"$self","containerName":null,"line":275,"kind":13},{"containerName":"main::","name":"warn","line":275,"kind":12},{"name":"$self","containerName":null,"kind":13,"line":275},{"line":275,"kind":13,"name":"$r2","containerName":null},{"containerName":"main::","name":"as_string","kind":12,"line":275},{"containerName":null,"name":"$resp2","line":278,"kind":13},{"kind":13,"line":278,"containerName":null,"name":"$r2"},{"containerName":"main::","name":"content","kind":12,"line":278},{"kind":13,"line":280,"name":"%resp2","containerName":null},{"kind":13,"line":281,"containerName":null,"name":"$self"},{"name":"status","containerName":"main::","line":281,"kind":12},{"name":"$resp2","containerName":null,"kind":13,"line":282},{"name":"%self","containerName":null,"line":283,"kind":13},{"name":"%resp2","containerName":null,"kind":13,"line":283},{"kind":13,"line":286,"name":"$self","containerName":null},{"line":286,"kind":12,"containerName":"main::","name":"verbose"},{"kind":13,"line":287,"name":"$self","containerName":null},{"containerName":"main::","name":"sleep","line":287,"kind":12},{"signature":{"parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n# $Id: ELM.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Analysis::Protein::ELM\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Richard Adams <richard.adams@ed.ac.uk>\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1     NAME\n\nBio::Tools::Analysis::Protein::ELM - a wrapper around the ELM server which predicts short functional motifs on amino acid sequences\n\n=head1     SYNOPSIS\n\n  # get a Bio::Seq object to start with, or a Bio::PrimaryI object.\n\n  my $tool = Bio::Tools::Analysis::Protein::ELM->\n      new(seq => $seqobj->primary_seq() );\t\n  $tool->compartment(['ER', 'Golgi']);\n  $tool->species(9606);\n  $tool->run;\n  my @fts = $tool->Result('Bio::SeqFeatureI');\n  $seqobj->addSeqFeature(@fts);\n\n=head1    DESCRIPTION\n\nThis module is a wrapper around the ELM server L<http://elm.eu.org/>\nwhich predicts short functional motifs on amino acid sequences. \n\nFalse positives can be limited by providing values for the species\nand cellular compartment of the protein. To set the species attribute,\nuse either a L<Bio::Species> object or an NCBI taxon ID number.  To set\nthe cell compartment attribute (any number of compartments can be\nchosen) use an array reference to a list of compartment names.\n\nResults can be obtained either as raw text output, parsed into a\ndata structure, or as Bio::SeqFeature::Generic objects.\n\n=head1 SEE ALSO\n\nL<Bio::SimpleAnalysisI>, \nL<Bio::WebAgent>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk, \n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\nuse strict;\npackage Bio::Tools::Analysis::Protein::ELM;\nuse vars qw(%cc);\nuse HTML::HeadParser;\nuse Bio::SeqFeature::Generic;\nuse HTTP::Request::Common qw(POST);\nuse IO::String;\nuse base qw(Bio::Tools::Analysis::SimpleAnalysisBase);\n\n## valid cell compartments ##\n%cc = (\n      all            => 1,\n      nucleus        => 'GO:0005634',\n      extracellular  => 'GO:0005576',\n      cytoplasm      => 'GO:0005737',\n      peroxisome     => 'GO:0005777',\n      glycosome      => 'GO:0020015',\n      glyoxisome     => 'GO:0009514',\n      golgi          => 'GO:0005794',\n      er             => 'GO:0005783',\n      lysosome       => 'GO:0005764',\n      endosome       => 'GO:0005768',\n      plasma_membrane=> 'GO:0005886',\n\t\t);\n\nmy $URL           = 'http://elm.eu.org/basicELM/cgimodel.py';\nmy $ANALYSIS_NAME = 'ELM';\nmy $INPUT_SPEC    =\n    [\n     {\n      'mandatory' => 'true',\n      'type'      => 'Bio::PrimarySeqI',\n      'name'      => 'seq',\n     },\n     {\n      'mandatory' => 'false',\n      'type'      => 'taxon_id or Bio::Species object',\n      'name'      => 'species',\n      'default'   => '9606',\n     },\n     {\n      'mandatory' => 'false',\n      'type'      => 'string',\n      'name'      => 'compartment',\n      'default'   => [1],\n     },\n    ];\n\nmy  $RESULT_SPEC =\n    {\n     ''                 => 'bulk',              # same as undef\n     'Bio::SeqFeatureI' => 'ARRAY of Bio::SeqFeature::Generic',\n     'parsed'           => '{motif1_name=>{locus=>[],\n\t\t\t\t\t   peptide=>[],\n\t\t\t\t\t   regexp=>[]\n\t\t\t\t\t  },\n\t\t\t    }',\n    };\nmy $ANALYSIS_SPEC= {name        => 'ELM',\n\t\t\t\t    type        => 'Protein',\n                    version     => 'n/a',\n                    supplier    =>'BioComputing Unit, EMBL',\n\t\t\t\t\tdescription =>'Prediction of linear functional motifs\n                                  in proteins',\n\t\t\t\t\treference   => 'NAR, 31:3625-3630'};\n\n\nsub _init {\n    my $self = shift;\n    $self->url($URL);\n    $self->{'_ANALYSIS_SPEC'} = $ANALYSIS_SPEC;\n    $self->{'_INPUT_SPEC'}    = $INPUT_SPEC;\n    $self->{'_RESULT_SPEC'}   = $RESULT_SPEC;\n    $self->{'_ANALYSIS_NAME'} = $ANALYSIS_NAME;\n    return $self;\n}\n\n=head2        compartment\n\n name        : compartment\n usage       : $elm->compartment(['golgi', 'er']);\n purpose     : get/setter for cell compartment specifications\n arguments   : None, single compartment string or ref to array of\n               compartment names.\n returns     : Array of compartment names (default if not previously set).\n\n\nsub compartment {\n\n    my ($self, $arg) = @_;\n    if ($arg) {\n\n        # convert to array ref if not one already\n\tif (ref ($arg) ne 'ARRAY') {\n            $arg = [$arg];\n\t}\n \n        ## now add params if valid\n\tfor my $param (@$arg) {\n            if (exists($cc{lc($param)})) {\n                push @{$self->{'_compartment'}} , $cc{$param};\n            } else {\n                $self->warn(\"invalid argument ! Must be one of \" .\n                            join \"\\n\", keys %cc );\n            }\n        }                       #end of for loop\n\t\t\t\n    }                           #endif $arg\n    return defined($self->{'_compartment'})? $self->{'_compartment'}\n        : $self->input_spec()->[2]{'default'};\n\n}\n\n=head1      species\n\n name      : species\n usage     : $tool->species('9606');\n purpose   : get/setter for species selction for ELM server\n arguments : none, taxon_id or Bio::Species object\n returns   : a string of the ncbi taxon_id\n\n\nsub species {\n    my ($self, $arg) = @_;\n\n    if ($arg) {\n        if (ref($arg) && $arg->isa('Bio::Species')) {\n            $self->{'_species'} = $arg->ncbi_taxid();\n        } elsif ($arg =~ /^\\d+$/) {\n            $self->{'_species'} = $arg;\n        } else {\n            $self->warn(\"Argument must be a Bio::Species object or \". \n                        \" an integer NCBI taxon id. \");\n        }\n    }                           #end if $arg\n    return defined($self->{'_species'})?$self->{'_species'}\n        :$self->input_spec()->[1]{'default'};\n\t\n}\n\nsub  _run {\n    my $self  = shift;\n    $self->delay(1);\n    # delay repeated calls by default by 3 sec, set delay() to change\n    #$self->sleep;\n    $self->status('TERMINATED_BY_ERROR');\n\t\n    #### this deals with being able to submit multiple checkboxed\n    #### slections\n\n    #1st of all make param array\n    my @cc_str;\n    my @cmpts = @{$self->compartment()};\n    for (my $i = 0; $i <= $#cmpts ; $i++) {\n        splice @cc_str, @cc_str, 0,   'userCC',$cmpts[$i];\n    }\n    my %h = (swissprotId      => \"\",\n             sequence         => $self->seq->seq,\n             userSpecies      => $self->species,\n             typedUserSpecies => '',\n             fun              => \"Submit\");\n    splice (@cc_str, @cc_str,0, ( map{$_, $h{$_}} keys %h));\n\n\t\t\n    my $request = POST $self->url(),\n        Content_Type => 'form-data',\n            Content  => \\@cc_str;\n    $self->debug( $request->as_string);\n    my $r1 = $self->request($request);\n    if ( $r1->is_error  ) {\n\t$self->warn(ref($self).\" Request Error:\\n\".$r1->as_string);\n\treturn;\n    }\n\n    my $text = $r1->content;\n    my ($url) = $text =~ /URL=\\S+(fun=\\S+r=\\d)/s; \n    #$url =~ s/amp;//g ;\n    my ($resp2);\n    $url = $URL . \"?\" .$url;\n    while (1) {\n\tmy $req2 = HTTP::Request->new(GET=>$url);\n\tmy $r2 = $self->request ($req2);\n\tif ( $r2->is_error ) {\n\t    $self->warn(ref($self).\" Request Error:\\n\".$r2->as_string);\t    \n\t    return;\n\t} \n\t$resp2 = $r2->content();\n\t\n\tif ($resp2 !~ /patient/s) {\n\t    $self->status('COMPLETED');\n\t    $resp2=~ s/<[^>]+>/ /sg;\n            $self->{'_result'} = $resp2;\n\t    return;\n\t} else {\n\t    print \".\" if $self->verbose > 0;\n\t    $self->sleep(1);\n\t}\n    }\n}\n\n=head1      result\n\n name      : result\n usage     : $tool->result('Bio::SeqFeatureI');\n purpose   : parse results into sequence features or basic data format\n arguments : 1. none    (retrieves raw text without html)\n             2. a value (retrieves data structure)\n             3. 'Bio::SeqFeatureI' (returns array of sequence features)\n                tag names are : {method => 'ELM', motif => motifname,\n                                 peptide => seqeunce of match,\n                                 concensus => regexp of match}.\n returns   : see arguments. ","label":"result($self,$val)"},"detail":"($self,$val)","definition":"sub","containerName":"main::","children":[{"containerName":"result","name":"$self","definition":"my","localvar":"my","kind":13,"line":308},{"line":308,"kind":13,"containerName":"result","name":"$val"},{"containerName":"result","name":"$val","line":309,"kind":13},{"containerName":"result","name":"$self","kind":13,"line":310},{"name":"$self","containerName":"result","line":311,"kind":13},{"containerName":"result","name":"_parse_raw","line":311,"kind":12},{"name":"$val","containerName":"result","line":313,"kind":13},{"localvar":"my","name":"@fts","definition":"my","containerName":"result","line":314,"kind":13},{"name":"$motif","definition":"my","containerName":"result","localvar":"my","kind":13,"line":315},{"name":"$self","containerName":"result","kind":13,"line":315},{"containerName":"result","name":"$i","definition":"my","localvar":"my","kind":13,"line":316},{"kind":13,"line":316,"name":"$i","containerName":"result"},{"containerName":"result","name":"$self","line":316,"kind":13},{"name":"$motif","containerName":"result","kind":13,"line":316},{"line":316,"kind":13,"containerName":"result","name":"$i"},{"definition":"my","name":"$st","containerName":"result","localvar":"my","kind":13,"line":317},{"containerName":"result","name":"$end","kind":13,"line":317},{"containerName":"result","name":"$self","line":317,"kind":13},{"kind":13,"line":317,"containerName":"result","name":"$motif"},{"containerName":"result","name":"$i","kind":13,"line":317},{"kind":13,"line":318,"containerName":"result","name":"@fts"},{"name":"new","containerName":"result","line":318,"kind":12},{"containerName":"result","name":"$st","line":320,"kind":13},{"kind":13,"line":321,"containerName":"result","name":"$end"},{"containerName":"result","name":"$motif","kind":13,"line":326},{"name":"$self","containerName":"result","line":327,"kind":13},{"line":327,"kind":13,"containerName":"result","name":"$motif"},{"kind":13,"line":327,"name":"$i","containerName":"result"},{"name":"$self","containerName":"result","line":328,"kind":13},{"name":"$motif","containerName":"result","kind":13,"line":328},{"containerName":"result","name":"@fts","line":332,"kind":13}],"line":307,"kind":12,"range":{"end":{"character":9999,"line":333},"start":{"line":307,"character":0}},"name":"result"},{"kind":12,"line":318,"name":"Bio","containerName":"SeqFeature::Generic"},{"kind":12,"line":325,"name":"method"},{"name":"motif","kind":12,"line":326},{"kind":12,"line":327,"name":"peptide"},{"name":"concensus","line":328,"kind":12},{"name":"%self","containerName":null,"line":334,"kind":13},{"containerName":null,"name":"%self","kind":13,"line":336},{"containerName":"main::","name":"_parse_raw","definition":"sub","range":{"start":{"character":0,"line":340},"end":{"character":9999,"line":377}},"kind":12,"line":340,"children":[{"kind":13,"line":341,"definition":"my","name":"$self","containerName":"_parse_raw","localvar":"my"},{"name":"$result","definition":"my","containerName":"_parse_raw","localvar":"my","kind":13,"line":342},{"containerName":"_parse_raw","name":"new","kind":12,"line":342},{"name":"$self","containerName":"_parse_raw","kind":13,"line":342},{"line":343,"kind":13,"localvar":"my","definition":"my","name":"$in_results","containerName":"_parse_raw"},{"kind":13,"line":344,"definition":"my","name":"$name","containerName":"_parse_raw","localvar":"my"},{"kind":13,"line":345,"containerName":"_parse_raw","definition":"my","name":"%results","localvar":"my"},{"line":346,"kind":13,"localvar":"my","definition":"my","name":"$last","containerName":"_parse_raw"},{"localvar":"my","containerName":"_parse_raw","definition":"my","name":"$l","line":347,"kind":13},{"kind":13,"line":347,"containerName":"_parse_raw","name":"$result"},{"kind":13,"line":348,"containerName":"_parse_raw","name":"$in_results"},{"kind":13,"line":348,"name":"$l","containerName":"_parse_raw"},{"name":"$in_results","containerName":"_parse_raw","kind":13,"line":349},{"line":350,"kind":13,"name":"$l","containerName":"_parse_raw"},{"line":351,"kind":13,"containerName":"_parse_raw","name":"$in_results"},{"line":353,"kind":13,"localvar":"my","definition":"my","name":"@line_parts","containerName":"_parse_raw"},{"containerName":"_parse_raw","name":"$l","kind":13,"line":353},{"line":354,"kind":13,"name":"@line_parts","containerName":"_parse_raw"},{"line":356,"kind":13,"name":"@line_parts","containerName":"_parse_raw"},{"name":"$line_parts","containerName":"_parse_raw","kind":13,"line":356},{"containerName":"_parse_raw","name":"$name","kind":13,"line":357},{"containerName":"_parse_raw","name":"@line_parts","kind":13,"line":361},{"localvar":"my","name":"$index","definition":"my","containerName":"_parse_raw","line":362,"kind":13},{"localvar":"my","containerName":"_parse_raw","name":"$read_loci","definition":"my","line":363,"kind":13},{"name":"$index","containerName":"_parse_raw","kind":13,"line":364},{"name":"$word","definition":"my","containerName":"_parse_raw","localvar":"my","kind":13,"line":365},{"line":365,"kind":13,"containerName":"_parse_raw","name":"$line_parts"},{"kind":13,"line":365,"name":"$index","containerName":"_parse_raw"},{"line":366,"kind":13,"name":"$read_loci","containerName":"_parse_raw"},{"name":"$word","containerName":"_parse_raw","line":366,"kind":13},{"name":"$name","containerName":"_parse_raw","kind":13,"line":367},{"name":"$word","containerName":"_parse_raw","line":367,"kind":13},{"kind":13,"line":368,"containerName":"_parse_raw","name":"$read_loci"},{"name":"$word","containerName":"_parse_raw","kind":13,"line":368},{"line":369,"kind":13,"containerName":"_parse_raw","name":"$results"},{"line":369,"kind":13,"name":"$name","containerName":"_parse_raw"},{"name":"$word","containerName":"_parse_raw","line":369,"kind":13},{"containerName":"_parse_raw","name":"$word","kind":13,"line":370},{"name":"$read_loci","containerName":"_parse_raw","line":371,"kind":13},{"name":"$results","containerName":"_parse_raw","line":372,"kind":13},{"kind":13,"line":372,"name":"$name","containerName":"_parse_raw"},{"containerName":"_parse_raw","name":"$word","line":372,"kind":13},{"line":377,"kind":13,"name":"$results","containerName":"_parse_raw"},{"name":"$name","containerName":"_parse_raw","kind":13,"line":377}]},{"name":"IO","containerName":"String","kind":12,"line":342},{"name":"line_parts","kind":12,"line":364},{"name":"@line_parts","containerName":null,"kind":13,"line":377},{"name":"line_parts","line":377,"kind":12},{"line":382,"kind":13,"containerName":null,"name":"%self"},{"kind":13,"line":382,"name":"%results","containerName":null}],"version":5}