{"version":5,"vars":[{"containerName":"","name":"vars","line":124,"kind":2},{"kind":2,"line":126,"name":"base","containerName":""},{"line":139,"children":[{"localvar":"my","name":"$class","definition":"my","containerName":"new","line":140,"kind":13},{"containerName":"new","name":"@args","line":140,"kind":13},{"name":"$self","definition":"my","containerName":"new","localvar":"my","kind":13,"line":142},{"line":142,"kind":13,"name":"$class","containerName":"new"},{"containerName":"new","name":"@args","line":142,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":143},{"kind":12,"line":143,"name":"warn","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":145},{"name":"$self","containerName":"new","kind":13,"line":146},{"line":148,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$root"},{"name":"$self","containerName":"new","kind":13,"line":148},{"line":148,"kind":12,"name":"_rearrange","containerName":"new"},{"line":148,"kind":13,"name":"@args","containerName":"new"},{"name":"$root","containerName":"new","line":149,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":149},{"kind":12,"line":149,"containerName":"new","name":"set_root_node"},{"containerName":"new","name":"$root","line":149,"kind":13},{"line":150,"kind":13,"name":"$self","containerName":"new"}],"kind":12,"detail":"($class,@args)","signature":{"documentation":"1;\n# $Id: Tree.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from Bio::Tree::Tree by Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Tree - An Organism Level Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon in combination with\n    # Bio::Tree::Tree instead\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n    my @leaves = $tree->get_leaves;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Taxonomic Nodes which make up a tree.\n\n=head1 EXAMPLES\n\n  use Bio::Species;\n  use Bio::Taxonomy::Tree;\n\n  my $human=Bio::Species->new();\n  my $chimp=Bio::Species->new();\n  my $bonobo=Bio::Species->new();\n\n  $human->classification(qw( sapiens Homo Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $chimp->classification(qw( troglodytes Pan Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $bonobo->classification(qw( paniscus Pan Hominidae\n                              Catarrhini Primates Eutheria\n                              Mammalia Euteleostomi Vertebrata \n                              Craniata Chordata\n                              Metazoa Eukaryota ));\n\n  # ranks passed to $taxonomy match ranks of species\n  my @ranks = ('superkingdom','kingdom','phylum','subphylum',\n               'no rank 1','no rank 2','class','no rank 3','order',\n               'suborder','family','genus','species');\n\n  my $taxonomy=Bio::Taxonomy->new(-ranks => \\@ranks,\n                                 -method => 'trust',\n                                 -order => -1);\n\n\n  my $tree1=Bio::Taxonomy::Tree->new();\n  my $tree2=Bio::Taxonomy::Tree->new();\n\n  $tree1->make_species_branch($human,$taxonomy);\n  $tree2->make_species_branch($chimp,$taxonomy);\n\n  my ($homo_sapiens)=$tree1->get_leaves;\n\n  $tree1->splice($tree2);\n\n  $tree1->add_species($bonobo,$taxonomy);\n\n  my @taxa;\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n  @taxa=();\n  $tree1->remove_branch($homo_sapiens);\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n=head1 FEEDBACK\n\nSee AUTHOR\n\n=head1 AUTHOR - Dan Kortschak\n\nEmail kortschak@rsbs.anu.edu.au\n\n=head1 CONTRIBUTORS\n\nMainly Jason Stajich\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Code begins...\n\n\npackage Bio::Taxonomy::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Taxonomy::Taxon;\n\n# Import rank information from Bio::Taxonomy.pm\nuse vars qw(@RANK %RANK);\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Tree->new();\n Function: Builds a new Bio::Taxonomy::Tree object \n Returns : Bio::Taxonomy::Tree\n Args    : ","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"containerName":"main::","definition":"sub","range":{"end":{"line":151,"character":9999},"start":{"line":139,"character":0}},"name":"new"},{"name":"SUPER","containerName":"new","line":142,"kind":12},{"range":{"start":{"character":0,"line":165},"end":{"line":187,"character":9999}},"name":"get_nodes","detail":"($self,@args)","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Tree.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from Bio::Tree::Tree by Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Tree - An Organism Level Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon in combination with\n    # Bio::Tree::Tree instead\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n    my @leaves = $tree->get_leaves;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Taxonomic Nodes which make up a tree.\n\n=head1 EXAMPLES\n\n  use Bio::Species;\n  use Bio::Taxonomy::Tree;\n\n  my $human=Bio::Species->new();\n  my $chimp=Bio::Species->new();\n  my $bonobo=Bio::Species->new();\n\n  $human->classification(qw( sapiens Homo Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $chimp->classification(qw( troglodytes Pan Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $bonobo->classification(qw( paniscus Pan Hominidae\n                              Catarrhini Primates Eutheria\n                              Mammalia Euteleostomi Vertebrata \n                              Craniata Chordata\n                              Metazoa Eukaryota ));\n\n  # ranks passed to $taxonomy match ranks of species\n  my @ranks = ('superkingdom','kingdom','phylum','subphylum',\n               'no rank 1','no rank 2','class','no rank 3','order',\n               'suborder','family','genus','species');\n\n  my $taxonomy=Bio::Taxonomy->new(-ranks => \\@ranks,\n                                 -method => 'trust',\n                                 -order => -1);\n\n\n  my $tree1=Bio::Taxonomy::Tree->new();\n  my $tree2=Bio::Taxonomy::Tree->new();\n\n  $tree1->make_species_branch($human,$taxonomy);\n  $tree2->make_species_branch($chimp,$taxonomy);\n\n  my ($homo_sapiens)=$tree1->get_leaves;\n\n  $tree1->splice($tree2);\n\n  $tree1->add_species($bonobo,$taxonomy);\n\n  my @taxa;\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n  @taxa=();\n  $tree1->remove_branch($homo_sapiens);\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n=head1 FEEDBACK\n\nSee AUTHOR\n\n=head1 AUTHOR - Dan Kortschak\n\nEmail kortschak@rsbs.anu.edu.au\n\n=head1 CONTRIBUTORS\n\nMainly Jason Stajich\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Code begins...\n\n\npackage Bio::Taxonomy::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Taxonomy::Taxon;\n\n# Import rank information from Bio::Taxonomy.pm\nuse vars qw(@RANK %RANK);\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Tree->new();\n Function: Builds a new Bio::Taxonomy::Tree object \n Returns : Bio::Taxonomy::Tree\n Args    : \n\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Tree is deprecated. Use Bio::Taxon in combination with Bio::Tree::Tree instead.\");\n  \n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n\n  my ($root)= $self->_rearrange([qw(ROOT)], @args);\n  if( $root ) { $self->set_root_node($root); }\n  return $self;\n}\n\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Taxonomy::Taxon objects\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order","label":"get_nodes($self,@args)"},"containerName":"main::","definition":"sub","line":165,"children":[{"kind":13,"line":166,"containerName":"get_nodes","definition":"my","name":"$self","localvar":"my"},{"name":"@args","containerName":"get_nodes","kind":13,"line":166},{"localvar":"my","definition":"my","name":"$order","containerName":"get_nodes","line":168,"kind":13},{"name":"$sortby","containerName":"get_nodes","kind":13,"line":168},{"name":"$self","containerName":"get_nodes","line":168,"kind":13},{"line":168,"kind":12,"containerName":"get_nodes","name":"_rearrange"},{"line":168,"kind":13,"containerName":"get_nodes","name":"@args"},{"containerName":"get_nodes","name":"$order","line":169,"kind":13},{"name":"$sortby","containerName":"get_nodes","kind":13,"line":170},{"kind":13,"line":172,"containerName":"get_nodes","name":"$order"},{"kind":13,"line":173,"definition":"my","name":"$node","containerName":"get_nodes","localvar":"my"},{"containerName":"get_nodes","name":"$self","kind":13,"line":173},{"line":173,"kind":12,"containerName":"get_nodes","name":"get_root_node"},{"localvar":"my","name":"@children","definition":"my","containerName":"get_nodes","line":174,"kind":13},{"containerName":"get_nodes","name":"$node","line":174,"kind":13},{"kind":13,"line":175,"name":"@children","containerName":"get_nodes"},{"kind":13,"line":176,"name":"@children","containerName":"get_nodes"},{"line":176,"kind":12,"containerName":"get_nodes","name":"each_Descendent"},{"name":"$sortby","containerName":"get_nodes","kind":13,"line":176},{"line":178,"kind":13,"name":"@children","containerName":"get_nodes"},{"name":"$order","containerName":"get_nodes","kind":13,"line":181},{"line":183,"kind":13,"localvar":"my","name":"$node","definition":"my","containerName":"get_nodes"},{"name":"$self","containerName":"get_nodes","line":183,"kind":13},{"containerName":"get_nodes","name":"get_root_node","kind":12,"line":183},{"localvar":"my","containerName":"get_nodes","definition":"my","name":"@children","line":184,"kind":13},{"line":184,"kind":13,"containerName":"get_nodes","name":"$node"},{"containerName":"get_nodes","name":"$node","kind":13,"line":184},{"kind":12,"line":184,"containerName":"get_nodes","name":"get_Descendents"},{"line":184,"kind":13,"containerName":"get_nodes","name":"$sortby"},{"containerName":"get_nodes","name":"@children","line":185,"kind":13}],"kind":12},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Tree.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from Bio::Tree::Tree by Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Tree - An Organism Level Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon in combination with\n    # Bio::Tree::Tree instead\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n    my @leaves = $tree->get_leaves;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Taxonomic Nodes which make up a tree.\n\n=head1 EXAMPLES\n\n  use Bio::Species;\n  use Bio::Taxonomy::Tree;\n\n  my $human=Bio::Species->new();\n  my $chimp=Bio::Species->new();\n  my $bonobo=Bio::Species->new();\n\n  $human->classification(qw( sapiens Homo Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $chimp->classification(qw( troglodytes Pan Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $bonobo->classification(qw( paniscus Pan Hominidae\n                              Catarrhini Primates Eutheria\n                              Mammalia Euteleostomi Vertebrata \n                              Craniata Chordata\n                              Metazoa Eukaryota ));\n\n  # ranks passed to $taxonomy match ranks of species\n  my @ranks = ('superkingdom','kingdom','phylum','subphylum',\n               'no rank 1','no rank 2','class','no rank 3','order',\n               'suborder','family','genus','species');\n\n  my $taxonomy=Bio::Taxonomy->new(-ranks => \\@ranks,\n                                 -method => 'trust',\n                                 -order => -1);\n\n\n  my $tree1=Bio::Taxonomy::Tree->new();\n  my $tree2=Bio::Taxonomy::Tree->new();\n\n  $tree1->make_species_branch($human,$taxonomy);\n  $tree2->make_species_branch($chimp,$taxonomy);\n\n  my ($homo_sapiens)=$tree1->get_leaves;\n\n  $tree1->splice($tree2);\n\n  $tree1->add_species($bonobo,$taxonomy);\n\n  my @taxa;\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n  @taxa=();\n  $tree1->remove_branch($homo_sapiens);\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n=head1 FEEDBACK\n\nSee AUTHOR\n\n=head1 AUTHOR - Dan Kortschak\n\nEmail kortschak@rsbs.anu.edu.au\n\n=head1 CONTRIBUTORS\n\nMainly Jason Stajich\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Code begins...\n\n\npackage Bio::Taxonomy::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Taxonomy::Taxon;\n\n# Import rank information from Bio::Taxonomy.pm\nuse vars qw(@RANK %RANK);\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Tree->new();\n Function: Builds a new Bio::Taxonomy::Tree object \n Returns : Bio::Taxonomy::Tree\n Args    : \n\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Tree is deprecated. Use Bio::Taxon in combination with Bio::Tree::Tree instead.\");\n  \n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n\n  my ($root)= $self->_rearrange([qw(ROOT)], @args);\n  if( $root ) { $self->set_root_node($root); }\n  return $self;\n}\n\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Taxonomy::Taxon objects\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self, @args) = @_;\n   \n   my ($order, $sortby) = $self->_rearrange([qw(ORDER SORTBY)],@args);\n   $order ||= 'depth';\n   $sortby ||= 'height';\n\n   if ($order =~ m/^b|(breadth)$/oi) {\n      my $node = $self->get_root_node;\n      my @children = ($node);\n      for (@children) {\n\t   push @children, $_->each_Descendent($sortby);\n      }\n      return @children;\n   }\n\n   if ($order =~ m/^d|(depth)$/oi) {\n       # this is depth-first search I believe\n       my $node = $self->get_root_node;\n       my @children = ($node,$node->get_Descendents($sortby));\n       return @children;\n   }\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Taxonomy::Taxon object\n Args    : none","label":"get_root_node($self)"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":202,"definition":"my","name":"$self","containerName":"get_root_node","localvar":"my"},{"line":203,"kind":13,"name":"$self","containerName":"get_root_node"}],"line":201,"kind":12,"range":{"start":{"line":201,"character":0},"end":{"character":9999,"line":204}},"name":"get_root_node"},{"range":{"start":{"character":0,"line":217},"end":{"character":9999,"line":227}},"name":"set_root_node","signature":{"label":"set_root_node($self,$value)","documentation":"1;\n# $Id: Tree.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from Bio::Tree::Tree by Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Tree - An Organism Level Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon in combination with\n    # Bio::Tree::Tree instead\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n    my @leaves = $tree->get_leaves;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Taxonomic Nodes which make up a tree.\n\n=head1 EXAMPLES\n\n  use Bio::Species;\n  use Bio::Taxonomy::Tree;\n\n  my $human=Bio::Species->new();\n  my $chimp=Bio::Species->new();\n  my $bonobo=Bio::Species->new();\n\n  $human->classification(qw( sapiens Homo Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $chimp->classification(qw( troglodytes Pan Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $bonobo->classification(qw( paniscus Pan Hominidae\n                              Catarrhini Primates Eutheria\n                              Mammalia Euteleostomi Vertebrata \n                              Craniata Chordata\n                              Metazoa Eukaryota ));\n\n  # ranks passed to $taxonomy match ranks of species\n  my @ranks = ('superkingdom','kingdom','phylum','subphylum',\n               'no rank 1','no rank 2','class','no rank 3','order',\n               'suborder','family','genus','species');\n\n  my $taxonomy=Bio::Taxonomy->new(-ranks => \\@ranks,\n                                 -method => 'trust',\n                                 -order => -1);\n\n\n  my $tree1=Bio::Taxonomy::Tree->new();\n  my $tree2=Bio::Taxonomy::Tree->new();\n\n  $tree1->make_species_branch($human,$taxonomy);\n  $tree2->make_species_branch($chimp,$taxonomy);\n\n  my ($homo_sapiens)=$tree1->get_leaves;\n\n  $tree1->splice($tree2);\n\n  $tree1->add_species($bonobo,$taxonomy);\n\n  my @taxa;\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n  @taxa=();\n  $tree1->remove_branch($homo_sapiens);\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n=head1 FEEDBACK\n\nSee AUTHOR\n\n=head1 AUTHOR - Dan Kortschak\n\nEmail kortschak@rsbs.anu.edu.au\n\n=head1 CONTRIBUTORS\n\nMainly Jason Stajich\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Code begins...\n\n\npackage Bio::Taxonomy::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Taxonomy::Taxon;\n\n# Import rank information from Bio::Taxonomy.pm\nuse vars qw(@RANK %RANK);\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Tree->new();\n Function: Builds a new Bio::Taxonomy::Tree object \n Returns : Bio::Taxonomy::Tree\n Args    : \n\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Tree is deprecated. Use Bio::Taxon in combination with Bio::Tree::Tree instead.\");\n  \n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n\n  my ($root)= $self->_rearrange([qw(ROOT)], @args);\n  if( $root ) { $self->set_root_node($root); }\n  return $self;\n}\n\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Taxonomy::Taxon objects\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self, @args) = @_;\n   \n   my ($order, $sortby) = $self->_rearrange([qw(ORDER SORTBY)],@args);\n   $order ||= 'depth';\n   $sortby ||= 'height';\n\n   if ($order =~ m/^b|(breadth)$/oi) {\n      my $node = $self->get_root_node;\n      my @children = ($node);\n      for (@children) {\n\t   push @children, $_->each_Descendent($sortby);\n      }\n      return @children;\n   }\n\n   if ($order =~ m/^d|(depth)$/oi) {\n       # this is depth-first search I believe\n       my $node = $self->get_root_node;\n       my @children = ($node,$node->get_Descendents($sortby));\n       return @children;\n   }\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Taxonomy::Taxon object\n Args    : none\n\n\n\nsub get_root_node{\n   my ($self) = @_;\n   return $self->{'_rootnode'};\n}\n\n=head2 set_root_node\n\n Title   : set_root_node\n Usage   : $tree->set_root_node($node)\n Function: Set the Root Node for the Tree\n Returns : Bio::Taxonomy::Taxon\n Args    : Bio::Taxonomy::Taxon","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"set_root_node","line":218,"kind":13},{"line":218,"kind":13,"containerName":"set_root_node","name":"$value"},{"kind":13,"line":219,"containerName":"set_root_node","name":"$value"},{"kind":13,"line":220,"name":"$value","containerName":"set_root_node"},{"line":220,"kind":12,"name":"isa","containerName":"set_root_node"},{"line":221,"kind":13,"containerName":"set_root_node","name":"$self"},{"containerName":"set_root_node","name":"warn","kind":12,"line":221},{"line":222,"kind":13,"name":"$self","containerName":"set_root_node"},{"name":"get_root_node","containerName":"set_root_node","kind":12,"line":222},{"containerName":"set_root_node","name":"$self","kind":13,"line":224},{"kind":13,"line":224,"containerName":"set_root_node","name":"$value"},{"kind":13,"line":226,"name":"$self","containerName":"set_root_node"},{"containerName":"set_root_node","name":"get_root_node","line":226,"kind":12}],"line":217,"kind":12},{"range":{"end":{"line":254,"character":9999},"start":{"character":0,"line":241}},"name":"get_leaves","children":[{"line":242,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"get_leaves"},{"definition":"my","name":"$node","containerName":"get_leaves","localvar":"my","kind":13,"line":244},{"kind":13,"line":244,"containerName":"get_leaves","name":"$self"},{"kind":12,"line":244,"containerName":"get_leaves","name":"get_root_node"},{"kind":13,"line":245,"containerName":"get_leaves","name":"@leaves","definition":"my","localvar":"my"},{"line":246,"kind":13,"localvar":"my","containerName":"get_leaves","name":"@children","definition":"my"},{"line":246,"kind":13,"name":"$node","containerName":"get_leaves"},{"line":247,"kind":13,"name":"@children","containerName":"get_leaves"},{"line":248,"kind":13,"containerName":"get_leaves","name":"@children"},{"line":248,"kind":12,"containerName":"get_leaves","name":"each_Descendent"},{"containerName":"get_leaves","name":"@children","kind":13,"line":250},{"name":"@leaves","containerName":"get_leaves","kind":13,"line":251},{"containerName":"get_leaves","name":"is_Leaf","kind":12,"line":251},{"line":253,"kind":13,"containerName":"get_leaves","name":"@leaves"}],"line":241,"kind":12,"signature":{"label":"get_leaves($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Tree.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from Bio::Tree::Tree by Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Tree - An Organism Level Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon in combination with\n    # Bio::Tree::Tree instead\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n    my @leaves = $tree->get_leaves;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Taxonomic Nodes which make up a tree.\n\n=head1 EXAMPLES\n\n  use Bio::Species;\n  use Bio::Taxonomy::Tree;\n\n  my $human=Bio::Species->new();\n  my $chimp=Bio::Species->new();\n  my $bonobo=Bio::Species->new();\n\n  $human->classification(qw( sapiens Homo Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $chimp->classification(qw( troglodytes Pan Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $bonobo->classification(qw( paniscus Pan Hominidae\n                              Catarrhini Primates Eutheria\n                              Mammalia Euteleostomi Vertebrata \n                              Craniata Chordata\n                              Metazoa Eukaryota ));\n\n  # ranks passed to $taxonomy match ranks of species\n  my @ranks = ('superkingdom','kingdom','phylum','subphylum',\n               'no rank 1','no rank 2','class','no rank 3','order',\n               'suborder','family','genus','species');\n\n  my $taxonomy=Bio::Taxonomy->new(-ranks => \\@ranks,\n                                 -method => 'trust',\n                                 -order => -1);\n\n\n  my $tree1=Bio::Taxonomy::Tree->new();\n  my $tree2=Bio::Taxonomy::Tree->new();\n\n  $tree1->make_species_branch($human,$taxonomy);\n  $tree2->make_species_branch($chimp,$taxonomy);\n\n  my ($homo_sapiens)=$tree1->get_leaves;\n\n  $tree1->splice($tree2);\n\n  $tree1->add_species($bonobo,$taxonomy);\n\n  my @taxa;\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n  @taxa=();\n  $tree1->remove_branch($homo_sapiens);\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n=head1 FEEDBACK\n\nSee AUTHOR\n\n=head1 AUTHOR - Dan Kortschak\n\nEmail kortschak@rsbs.anu.edu.au\n\n=head1 CONTRIBUTORS\n\nMainly Jason Stajich\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Code begins...\n\n\npackage Bio::Taxonomy::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Taxonomy::Taxon;\n\n# Import rank information from Bio::Taxonomy.pm\nuse vars qw(@RANK %RANK);\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Tree->new();\n Function: Builds a new Bio::Taxonomy::Tree object \n Returns : Bio::Taxonomy::Tree\n Args    : \n\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Tree is deprecated. Use Bio::Taxon in combination with Bio::Tree::Tree instead.\");\n  \n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n\n  my ($root)= $self->_rearrange([qw(ROOT)], @args);\n  if( $root ) { $self->set_root_node($root); }\n  return $self;\n}\n\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Taxonomy::Taxon objects\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self, @args) = @_;\n   \n   my ($order, $sortby) = $self->_rearrange([qw(ORDER SORTBY)],@args);\n   $order ||= 'depth';\n   $sortby ||= 'height';\n\n   if ($order =~ m/^b|(breadth)$/oi) {\n      my $node = $self->get_root_node;\n      my @children = ($node);\n      for (@children) {\n\t   push @children, $_->each_Descendent($sortby);\n      }\n      return @children;\n   }\n\n   if ($order =~ m/^d|(depth)$/oi) {\n       # this is depth-first search I believe\n       my $node = $self->get_root_node;\n       my @children = ($node,$node->get_Descendents($sortby));\n       return @children;\n   }\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Taxonomy::Taxon object\n Args    : none\n\n\n\nsub get_root_node{\n   my ($self) = @_;\n   return $self->{'_rootnode'};\n}\n\n=head2 set_root_node\n\n Title   : set_root_node\n Usage   : $tree->set_root_node($node)\n Function: Set the Root Node for the Tree\n Returns : Bio::Taxonomy::Taxon\n Args    : Bio::Taxonomy::Taxon\n\n\n\nsub set_root_node{\n   my ($self,$value) = @_;\n   if( defined $value ) { \n      if( ! $value->isa('Bio::Taxonomy::Taxon') ) { \n\t   $self->warn(\"Trying to set the root node to $value which is not a Bio::Taxonomy::Taxon\");\n\t   return $self->get_root_node;\n      }\n      $self->{'_rootnode'} = $value;\n   }\n   return $self->get_root_node;\n}\n\n\n=head2 get_leaves\n\n Title   : get_leaves\n Usage   : my @nodes = $tree->get_leaves()\n Function: Return list of Bio::Taxonomy::Taxon objects\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : "},"detail":"($self)","definition":"sub","containerName":"main::"},{"range":{"end":{"character":9999,"line":301},"start":{"character":0,"line":269}},"name":"make_species_branch","signature":{"label":"make_species_branch($self,$species,$taxonomy)","parameters":[{"label":"$self"},{"label":"$species"},{"label":"$taxonomy"}],"documentation":"1;\n# $Id: Tree.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from Bio::Tree::Tree by Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Tree - An Organism Level Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon in combination with\n    # Bio::Tree::Tree instead\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n    my @leaves = $tree->get_leaves;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Taxonomic Nodes which make up a tree.\n\n=head1 EXAMPLES\n\n  use Bio::Species;\n  use Bio::Taxonomy::Tree;\n\n  my $human=Bio::Species->new();\n  my $chimp=Bio::Species->new();\n  my $bonobo=Bio::Species->new();\n\n  $human->classification(qw( sapiens Homo Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $chimp->classification(qw( troglodytes Pan Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $bonobo->classification(qw( paniscus Pan Hominidae\n                              Catarrhini Primates Eutheria\n                              Mammalia Euteleostomi Vertebrata \n                              Craniata Chordata\n                              Metazoa Eukaryota ));\n\n  # ranks passed to $taxonomy match ranks of species\n  my @ranks = ('superkingdom','kingdom','phylum','subphylum',\n               'no rank 1','no rank 2','class','no rank 3','order',\n               'suborder','family','genus','species');\n\n  my $taxonomy=Bio::Taxonomy->new(-ranks => \\@ranks,\n                                 -method => 'trust',\n                                 -order => -1);\n\n\n  my $tree1=Bio::Taxonomy::Tree->new();\n  my $tree2=Bio::Taxonomy::Tree->new();\n\n  $tree1->make_species_branch($human,$taxonomy);\n  $tree2->make_species_branch($chimp,$taxonomy);\n\n  my ($homo_sapiens)=$tree1->get_leaves;\n\n  $tree1->splice($tree2);\n\n  $tree1->add_species($bonobo,$taxonomy);\n\n  my @taxa;\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n  @taxa=();\n  $tree1->remove_branch($homo_sapiens);\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n=head1 FEEDBACK\n\nSee AUTHOR\n\n=head1 AUTHOR - Dan Kortschak\n\nEmail kortschak@rsbs.anu.edu.au\n\n=head1 CONTRIBUTORS\n\nMainly Jason Stajich\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Code begins...\n\n\npackage Bio::Taxonomy::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Taxonomy::Taxon;\n\n# Import rank information from Bio::Taxonomy.pm\nuse vars qw(@RANK %RANK);\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Tree->new();\n Function: Builds a new Bio::Taxonomy::Tree object \n Returns : Bio::Taxonomy::Tree\n Args    : \n\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Tree is deprecated. Use Bio::Taxon in combination with Bio::Tree::Tree instead.\");\n  \n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n\n  my ($root)= $self->_rearrange([qw(ROOT)], @args);\n  if( $root ) { $self->set_root_node($root); }\n  return $self;\n}\n\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Taxonomy::Taxon objects\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self, @args) = @_;\n   \n   my ($order, $sortby) = $self->_rearrange([qw(ORDER SORTBY)],@args);\n   $order ||= 'depth';\n   $sortby ||= 'height';\n\n   if ($order =~ m/^b|(breadth)$/oi) {\n      my $node = $self->get_root_node;\n      my @children = ($node);\n      for (@children) {\n\t   push @children, $_->each_Descendent($sortby);\n      }\n      return @children;\n   }\n\n   if ($order =~ m/^d|(depth)$/oi) {\n       # this is depth-first search I believe\n       my $node = $self->get_root_node;\n       my @children = ($node,$node->get_Descendents($sortby));\n       return @children;\n   }\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Taxonomy::Taxon object\n Args    : none\n\n\n\nsub get_root_node{\n   my ($self) = @_;\n   return $self->{'_rootnode'};\n}\n\n=head2 set_root_node\n\n Title   : set_root_node\n Usage   : $tree->set_root_node($node)\n Function: Set the Root Node for the Tree\n Returns : Bio::Taxonomy::Taxon\n Args    : Bio::Taxonomy::Taxon\n\n\n\nsub set_root_node{\n   my ($self,$value) = @_;\n   if( defined $value ) { \n      if( ! $value->isa('Bio::Taxonomy::Taxon') ) { \n\t   $self->warn(\"Trying to set the root node to $value which is not a Bio::Taxonomy::Taxon\");\n\t   return $self->get_root_node;\n      }\n      $self->{'_rootnode'} = $value;\n   }\n   return $self->get_root_node;\n}\n\n\n=head2 get_leaves\n\n Title   : get_leaves\n Usage   : my @nodes = $tree->get_leaves()\n Function: Return list of Bio::Taxonomy::Taxon objects\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : \n\n\n\nsub get_leaves{\n   my ($self) = @_;\n   \n   my $node = $self->get_root_node;\n   my @leaves;\n   my @children = ($node);\n   for (@children) {\n      push @children, $_->each_Descendent();\n   }\n   for (@children) {\n      push @leaves, $_ if $_->is_Leaf;\n   }\n   return @leaves;\n}\n\n=head2 make_species_branch\n\n Title   : make_species_branch\n Usage   : @nodes = $tree->make_species_branch($species,$taxonomy)\n Function: Return list of Bio::Taxonomy::Taxon objects based on a Bio::Species object\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : Bio::Species and Bio::Taxonomy objects\n\n I'm not happy that make_species_branch and make_branch are seperate routines\n should be able to just make_branch and have it sort things out"},"detail":"($self,$species,$taxonomy)","definition":"sub","containerName":"main::","children":[{"line":270,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"make_species_branch"},{"name":"$species","containerName":"make_species_branch","line":270,"kind":13},{"kind":13,"line":270,"containerName":"make_species_branch","name":"$taxonomy"},{"name":"$species","containerName":"make_species_branch","kind":13,"line":272},{"line":272,"kind":12,"name":"isa","containerName":"make_species_branch"},{"containerName":"make_species_branch","name":"$self","line":273,"kind":13},{"containerName":"make_species_branch","name":"throw","kind":12,"line":273},{"kind":13,"line":275,"name":"$taxonomy","containerName":"make_species_branch"},{"name":"isa","containerName":"make_species_branch","kind":12,"line":275},{"kind":13,"line":276,"name":"$self","containerName":"make_species_branch"},{"line":276,"kind":12,"name":"throw","containerName":"make_species_branch"},{"line":280,"kind":13,"name":"$self","containerName":"make_species_branch"},{"name":"get_root_node","containerName":"make_species_branch","line":280,"kind":12},{"containerName":"make_species_branch","name":"$self","kind":13,"line":281},{"containerName":"make_species_branch","name":"get_root_node","line":281,"kind":12},{"containerName":"make_species_branch","name":"remove_all_Descendents","line":281,"kind":12},{"name":"@nodes","definition":"my","containerName":"make_species_branch","localvar":"my","kind":13,"line":284},{"localvar":"my","containerName":"make_species_branch","name":"@taxa","definition":"my","line":287,"kind":13},{"line":287,"kind":13,"containerName":"make_species_branch","name":"$taxonomy"},{"line":287,"kind":12,"containerName":"make_species_branch","name":"classify"},{"name":"$species","containerName":"make_species_branch","line":287,"kind":13},{"containerName":"make_species_branch","name":"$i","definition":"my","localvar":"my","kind":13,"line":289},{"kind":13,"line":289,"containerName":"make_species_branch","name":"$i"},{"containerName":"make_species_branch","name":"@taxa","line":289,"kind":13},{"line":289,"kind":13,"name":"$i","containerName":"make_species_branch"},{"containerName":"make_species_branch","name":"$nodes","line":290,"kind":13},{"kind":13,"line":290,"name":"$i","containerName":"make_species_branch"},{"kind":12,"line":290,"name":"new","containerName":"make_species_branch"},{"containerName":"make_species_branch","name":"$taxa","line":290,"kind":13},{"line":290,"kind":13,"name":"$i","containerName":"make_species_branch"},{"name":"$taxa","containerName":"make_species_branch","line":291,"kind":13},{"kind":13,"line":291,"name":"$i","containerName":"make_species_branch"},{"localvar":"my","containerName":"make_species_branch","name":"$i","definition":"my","line":294,"kind":13},{"containerName":"make_species_branch","name":"$i","line":294,"kind":13},{"line":294,"kind":13,"name":"@taxa","containerName":"make_species_branch"},{"name":"$i","containerName":"make_species_branch","line":294,"kind":13},{"name":"$nodes","containerName":"make_species_branch","line":295,"kind":13},{"name":"$i","containerName":"make_species_branch","kind":13,"line":295},{"kind":12,"line":295,"containerName":"make_species_branch","name":"add_Descendent"},{"containerName":"make_species_branch","name":"$nodes","kind":13,"line":295},{"containerName":"make_species_branch","name":"$i","kind":13,"line":295},{"containerName":"make_species_branch","name":"$self","kind":13,"line":298},{"containerName":"make_species_branch","name":"set_root_node","kind":12,"line":298},{"containerName":"make_species_branch","name":"$nodes","line":298,"kind":13},{"containerName":"make_species_branch","name":"@nodes","kind":13,"line":300}],"line":269,"kind":12},{"kind":12,"line":290,"name":"Bio","containerName":"Taxonomy::Taxon"},{"name":"make_branch","range":{"start":{"line":315,"character":0},"end":{"character":9999,"line":327}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$node"}],"documentation":"1;\n# $Id: Tree.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from Bio::Tree::Tree by Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Tree - An Organism Level Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon in combination with\n    # Bio::Tree::Tree instead\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n    my @leaves = $tree->get_leaves;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Taxonomic Nodes which make up a tree.\n\n=head1 EXAMPLES\n\n  use Bio::Species;\n  use Bio::Taxonomy::Tree;\n\n  my $human=Bio::Species->new();\n  my $chimp=Bio::Species->new();\n  my $bonobo=Bio::Species->new();\n\n  $human->classification(qw( sapiens Homo Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $chimp->classification(qw( troglodytes Pan Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $bonobo->classification(qw( paniscus Pan Hominidae\n                              Catarrhini Primates Eutheria\n                              Mammalia Euteleostomi Vertebrata \n                              Craniata Chordata\n                              Metazoa Eukaryota ));\n\n  # ranks passed to $taxonomy match ranks of species\n  my @ranks = ('superkingdom','kingdom','phylum','subphylum',\n               'no rank 1','no rank 2','class','no rank 3','order',\n               'suborder','family','genus','species');\n\n  my $taxonomy=Bio::Taxonomy->new(-ranks => \\@ranks,\n                                 -method => 'trust',\n                                 -order => -1);\n\n\n  my $tree1=Bio::Taxonomy::Tree->new();\n  my $tree2=Bio::Taxonomy::Tree->new();\n\n  $tree1->make_species_branch($human,$taxonomy);\n  $tree2->make_species_branch($chimp,$taxonomy);\n\n  my ($homo_sapiens)=$tree1->get_leaves;\n\n  $tree1->splice($tree2);\n\n  $tree1->add_species($bonobo,$taxonomy);\n\n  my @taxa;\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n  @taxa=();\n  $tree1->remove_branch($homo_sapiens);\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n=head1 FEEDBACK\n\nSee AUTHOR\n\n=head1 AUTHOR - Dan Kortschak\n\nEmail kortschak@rsbs.anu.edu.au\n\n=head1 CONTRIBUTORS\n\nMainly Jason Stajich\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Code begins...\n\n\npackage Bio::Taxonomy::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Taxonomy::Taxon;\n\n# Import rank information from Bio::Taxonomy.pm\nuse vars qw(@RANK %RANK);\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Tree->new();\n Function: Builds a new Bio::Taxonomy::Tree object \n Returns : Bio::Taxonomy::Tree\n Args    : \n\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Tree is deprecated. Use Bio::Taxon in combination with Bio::Tree::Tree instead.\");\n  \n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n\n  my ($root)= $self->_rearrange([qw(ROOT)], @args);\n  if( $root ) { $self->set_root_node($root); }\n  return $self;\n}\n\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Taxonomy::Taxon objects\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self, @args) = @_;\n   \n   my ($order, $sortby) = $self->_rearrange([qw(ORDER SORTBY)],@args);\n   $order ||= 'depth';\n   $sortby ||= 'height';\n\n   if ($order =~ m/^b|(breadth)$/oi) {\n      my $node = $self->get_root_node;\n      my @children = ($node);\n      for (@children) {\n\t   push @children, $_->each_Descendent($sortby);\n      }\n      return @children;\n   }\n\n   if ($order =~ m/^d|(depth)$/oi) {\n       # this is depth-first search I believe\n       my $node = $self->get_root_node;\n       my @children = ($node,$node->get_Descendents($sortby));\n       return @children;\n   }\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Taxonomy::Taxon object\n Args    : none\n\n\n\nsub get_root_node{\n   my ($self) = @_;\n   return $self->{'_rootnode'};\n}\n\n=head2 set_root_node\n\n Title   : set_root_node\n Usage   : $tree->set_root_node($node)\n Function: Set the Root Node for the Tree\n Returns : Bio::Taxonomy::Taxon\n Args    : Bio::Taxonomy::Taxon\n\n\n\nsub set_root_node{\n   my ($self,$value) = @_;\n   if( defined $value ) { \n      if( ! $value->isa('Bio::Taxonomy::Taxon') ) { \n\t   $self->warn(\"Trying to set the root node to $value which is not a Bio::Taxonomy::Taxon\");\n\t   return $self->get_root_node;\n      }\n      $self->{'_rootnode'} = $value;\n   }\n   return $self->get_root_node;\n}\n\n\n=head2 get_leaves\n\n Title   : get_leaves\n Usage   : my @nodes = $tree->get_leaves()\n Function: Return list of Bio::Taxonomy::Taxon objects\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : \n\n\n\nsub get_leaves{\n   my ($self) = @_;\n   \n   my $node = $self->get_root_node;\n   my @leaves;\n   my @children = ($node);\n   for (@children) {\n      push @children, $_->each_Descendent();\n   }\n   for (@children) {\n      push @leaves, $_ if $_->is_Leaf;\n   }\n   return @leaves;\n}\n\n=head2 make_species_branch\n\n Title   : make_species_branch\n Usage   : @nodes = $tree->make_species_branch($species,$taxonomy)\n Function: Return list of Bio::Taxonomy::Taxon objects based on a Bio::Species object\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : Bio::Species and Bio::Taxonomy objects\n\n\n# I'm not happy that make_species_branch and make_branch are seperate routines\n# should be able to just make_branch and have it sort things out\n\nsub make_species_branch{\n   my ($self,$species,$taxonomy) = @_;\n   \n   if (! $species->isa('Bio::Species') ) {\n      $self->throw(\"Trying to classify $species which is not a Bio::Species object\");\n   }\n   if (! $taxonomy->isa('Bio::Taxonomy') ) {\n      $self->throw(\"Trying to classify with $taxonomy which is not a Bio::Taxonomy object\");\n   }\n\n   # this is done to make sure we aren't duplicating a path (let God sort them out)\n   if (defined $self->get_root_node) {\n      $self->get_root_node->remove_all_Descendents;\n   }\n\n   my @nodes;\n\n   # nb taxa in [i][0] and ranks in [i][1]\n   my @taxa=$taxonomy->classify($species);\n\n   for (my $i = 0; $i < @taxa; $i++) {\n      $nodes[$i]=Bio::Taxonomy::Taxon->new(-taxon => $taxa[$i][0],\n                                           -rank  => $taxa[$i][1]);\n   }\n\n   for (my $i = 0; $i < @taxa-1; $i++) {\n      $nodes[$i]->add_Descendent($nodes[$i+1]);\n   }\n\n   $self->set_root_node($nodes[0]);\n\n   return @nodes;\n}\n\n\n=head2 make_branch\n\n Title   : make_branch\n Usage   : $tree->make_branch($node)\n Function: Make a linear Bio::Taxonomy::Tree object from a leafish node\n Returns :\n Args    : Bio::Taxonomy::Taxon object","label":"make_branch($self,$node)"},"detail":"($self,$node)","kind":12,"children":[{"containerName":"make_branch","name":"$self","definition":"my","localvar":"my","kind":13,"line":316},{"line":316,"kind":13,"name":"$node","containerName":"make_branch"},{"name":"$self","containerName":"make_branch","kind":13,"line":321},{"containerName":"make_branch","name":"get_root_node","line":321,"kind":12},{"name":"remove_all_Descendents","containerName":"make_branch","line":321,"kind":12},{"kind":13,"line":323,"name":"$node","containerName":"make_branch"},{"name":"ancestor","containerName":"make_branch","kind":12,"line":323},{"line":324,"kind":13,"name":"$self","containerName":"make_branch"},{"name":"set_root_node","containerName":"make_branch","line":324,"kind":12},{"containerName":"make_branch","name":"$node","kind":13,"line":324},{"containerName":"make_branch","name":"$node","line":325,"kind":13},{"name":"$node","containerName":"make_branch","line":325,"kind":13},{"name":"ancestor","containerName":"make_branch","line":325,"kind":12}],"line":315},{"name":"splice","range":{"end":{"character":9999,"line":352},"start":{"character":0,"line":341}},"containerName":"main::","definition":"sub","detail":"($self,$tree)","signature":{"parameters":[{"label":"$self"},{"label":"$tree"}],"documentation":"1;\n# $Id: Tree.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from Bio::Tree::Tree by Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Tree - An Organism Level Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon in combination with\n    # Bio::Tree::Tree instead\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n    my @leaves = $tree->get_leaves;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Taxonomic Nodes which make up a tree.\n\n=head1 EXAMPLES\n\n  use Bio::Species;\n  use Bio::Taxonomy::Tree;\n\n  my $human=Bio::Species->new();\n  my $chimp=Bio::Species->new();\n  my $bonobo=Bio::Species->new();\n\n  $human->classification(qw( sapiens Homo Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $chimp->classification(qw( troglodytes Pan Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $bonobo->classification(qw( paniscus Pan Hominidae\n                              Catarrhini Primates Eutheria\n                              Mammalia Euteleostomi Vertebrata \n                              Craniata Chordata\n                              Metazoa Eukaryota ));\n\n  # ranks passed to $taxonomy match ranks of species\n  my @ranks = ('superkingdom','kingdom','phylum','subphylum',\n               'no rank 1','no rank 2','class','no rank 3','order',\n               'suborder','family','genus','species');\n\n  my $taxonomy=Bio::Taxonomy->new(-ranks => \\@ranks,\n                                 -method => 'trust',\n                                 -order => -1);\n\n\n  my $tree1=Bio::Taxonomy::Tree->new();\n  my $tree2=Bio::Taxonomy::Tree->new();\n\n  $tree1->make_species_branch($human,$taxonomy);\n  $tree2->make_species_branch($chimp,$taxonomy);\n\n  my ($homo_sapiens)=$tree1->get_leaves;\n\n  $tree1->splice($tree2);\n\n  $tree1->add_species($bonobo,$taxonomy);\n\n  my @taxa;\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n  @taxa=();\n  $tree1->remove_branch($homo_sapiens);\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n=head1 FEEDBACK\n\nSee AUTHOR\n\n=head1 AUTHOR - Dan Kortschak\n\nEmail kortschak@rsbs.anu.edu.au\n\n=head1 CONTRIBUTORS\n\nMainly Jason Stajich\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Code begins...\n\n\npackage Bio::Taxonomy::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Taxonomy::Taxon;\n\n# Import rank information from Bio::Taxonomy.pm\nuse vars qw(@RANK %RANK);\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Tree->new();\n Function: Builds a new Bio::Taxonomy::Tree object \n Returns : Bio::Taxonomy::Tree\n Args    : \n\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Tree is deprecated. Use Bio::Taxon in combination with Bio::Tree::Tree instead.\");\n  \n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n\n  my ($root)= $self->_rearrange([qw(ROOT)], @args);\n  if( $root ) { $self->set_root_node($root); }\n  return $self;\n}\n\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Taxonomy::Taxon objects\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self, @args) = @_;\n   \n   my ($order, $sortby) = $self->_rearrange([qw(ORDER SORTBY)],@args);\n   $order ||= 'depth';\n   $sortby ||= 'height';\n\n   if ($order =~ m/^b|(breadth)$/oi) {\n      my $node = $self->get_root_node;\n      my @children = ($node);\n      for (@children) {\n\t   push @children, $_->each_Descendent($sortby);\n      }\n      return @children;\n   }\n\n   if ($order =~ m/^d|(depth)$/oi) {\n       # this is depth-first search I believe\n       my $node = $self->get_root_node;\n       my @children = ($node,$node->get_Descendents($sortby));\n       return @children;\n   }\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Taxonomy::Taxon object\n Args    : none\n\n\n\nsub get_root_node{\n   my ($self) = @_;\n   return $self->{'_rootnode'};\n}\n\n=head2 set_root_node\n\n Title   : set_root_node\n Usage   : $tree->set_root_node($node)\n Function: Set the Root Node for the Tree\n Returns : Bio::Taxonomy::Taxon\n Args    : Bio::Taxonomy::Taxon\n\n\n\nsub set_root_node{\n   my ($self,$value) = @_;\n   if( defined $value ) { \n      if( ! $value->isa('Bio::Taxonomy::Taxon') ) { \n\t   $self->warn(\"Trying to set the root node to $value which is not a Bio::Taxonomy::Taxon\");\n\t   return $self->get_root_node;\n      }\n      $self->{'_rootnode'} = $value;\n   }\n   return $self->get_root_node;\n}\n\n\n=head2 get_leaves\n\n Title   : get_leaves\n Usage   : my @nodes = $tree->get_leaves()\n Function: Return list of Bio::Taxonomy::Taxon objects\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : \n\n\n\nsub get_leaves{\n   my ($self) = @_;\n   \n   my $node = $self->get_root_node;\n   my @leaves;\n   my @children = ($node);\n   for (@children) {\n      push @children, $_->each_Descendent();\n   }\n   for (@children) {\n      push @leaves, $_ if $_->is_Leaf;\n   }\n   return @leaves;\n}\n\n=head2 make_species_branch\n\n Title   : make_species_branch\n Usage   : @nodes = $tree->make_species_branch($species,$taxonomy)\n Function: Return list of Bio::Taxonomy::Taxon objects based on a Bio::Species object\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : Bio::Species and Bio::Taxonomy objects\n\n\n# I'm not happy that make_species_branch and make_branch are seperate routines\n# should be able to just make_branch and have it sort things out\n\nsub make_species_branch{\n   my ($self,$species,$taxonomy) = @_;\n   \n   if (! $species->isa('Bio::Species') ) {\n      $self->throw(\"Trying to classify $species which is not a Bio::Species object\");\n   }\n   if (! $taxonomy->isa('Bio::Taxonomy') ) {\n      $self->throw(\"Trying to classify with $taxonomy which is not a Bio::Taxonomy object\");\n   }\n\n   # this is done to make sure we aren't duplicating a path (let God sort them out)\n   if (defined $self->get_root_node) {\n      $self->get_root_node->remove_all_Descendents;\n   }\n\n   my @nodes;\n\n   # nb taxa in [i][0] and ranks in [i][1]\n   my @taxa=$taxonomy->classify($species);\n\n   for (my $i = 0; $i < @taxa; $i++) {\n      $nodes[$i]=Bio::Taxonomy::Taxon->new(-taxon => $taxa[$i][0],\n                                           -rank  => $taxa[$i][1]);\n   }\n\n   for (my $i = 0; $i < @taxa-1; $i++) {\n      $nodes[$i]->add_Descendent($nodes[$i+1]);\n   }\n\n   $self->set_root_node($nodes[0]);\n\n   return @nodes;\n}\n\n\n=head2 make_branch\n\n Title   : make_branch\n Usage   : $tree->make_branch($node)\n Function: Make a linear Bio::Taxonomy::Tree object from a leafish node\n Returns :\n Args    : Bio::Taxonomy::Taxon object\n\n\n\nsub make_branch{\n   my ($self,$node) = @_;\n\n   # this is done to make sure we aren't duplicating a path (let God sort them out)\n   # note that if you are using a linked set of node which include node \n   # already in the tree, this will break\n   $self->get_root_node->remove_all_Descendents;\n   \n   while (defined $node->ancestor) {\n      $self->set_root_node($node);\n      $node=$node->ancestor;\n   }\n}\n\n\n=head2 splice\n\n Title   : splice\n Usage   : @nodes = $tree->splice($tree)\n Function: Return a of Bio::Taxonomy::Tree object that is a fusion of two\n Returns : array of Bio::Taxonomy::Taxon added to tree\n Args    : Bio::Taxonomy::Tree object","label":"splice($self,$tree)"},"kind":12,"line":341,"children":[{"kind":13,"line":342,"definition":"my","name":"$self","containerName":"splice","localvar":"my"},{"kind":13,"line":342,"containerName":"splice","name":"$tree"},{"kind":13,"line":344,"containerName":"splice","name":"@nodes","definition":"my","localvar":"my"},{"containerName":"splice","definition":"my","name":"@newleaves","localvar":"my","kind":13,"line":346},{"containerName":"splice","name":"$tree","kind":13,"line":346},{"containerName":"splice","name":"get_leaves","line":346,"kind":12},{"containerName":"splice","name":"$leaf","definition":"my","localvar":"my","kind":13,"line":347},{"containerName":"splice","name":"@newleaves","kind":13,"line":347},{"containerName":"splice","name":"@nodes","kind":13,"line":348},{"kind":13,"line":348,"containerName":"splice","name":"$self"},{"name":"add_branch","containerName":"splice","kind":12,"line":348},{"containerName":"splice","name":"$leaf","kind":13,"line":348},{"line":351,"kind":13,"name":"@nodes","containerName":"splice"}]},{"range":{"start":{"character":0,"line":365},"end":{"character":9999,"line":374}},"name":"add_species","signature":{"label":"add_species($self,$species,$taxonomy)","documentation":"1;\n# $Id: Tree.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from Bio::Tree::Tree by Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Tree - An Organism Level Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon in combination with\n    # Bio::Tree::Tree instead\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n    my @leaves = $tree->get_leaves;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Taxonomic Nodes which make up a tree.\n\n=head1 EXAMPLES\n\n  use Bio::Species;\n  use Bio::Taxonomy::Tree;\n\n  my $human=Bio::Species->new();\n  my $chimp=Bio::Species->new();\n  my $bonobo=Bio::Species->new();\n\n  $human->classification(qw( sapiens Homo Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $chimp->classification(qw( troglodytes Pan Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $bonobo->classification(qw( paniscus Pan Hominidae\n                              Catarrhini Primates Eutheria\n                              Mammalia Euteleostomi Vertebrata \n                              Craniata Chordata\n                              Metazoa Eukaryota ));\n\n  # ranks passed to $taxonomy match ranks of species\n  my @ranks = ('superkingdom','kingdom','phylum','subphylum',\n               'no rank 1','no rank 2','class','no rank 3','order',\n               'suborder','family','genus','species');\n\n  my $taxonomy=Bio::Taxonomy->new(-ranks => \\@ranks,\n                                 -method => 'trust',\n                                 -order => -1);\n\n\n  my $tree1=Bio::Taxonomy::Tree->new();\n  my $tree2=Bio::Taxonomy::Tree->new();\n\n  $tree1->make_species_branch($human,$taxonomy);\n  $tree2->make_species_branch($chimp,$taxonomy);\n\n  my ($homo_sapiens)=$tree1->get_leaves;\n\n  $tree1->splice($tree2);\n\n  $tree1->add_species($bonobo,$taxonomy);\n\n  my @taxa;\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n  @taxa=();\n  $tree1->remove_branch($homo_sapiens);\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n=head1 FEEDBACK\n\nSee AUTHOR\n\n=head1 AUTHOR - Dan Kortschak\n\nEmail kortschak@rsbs.anu.edu.au\n\n=head1 CONTRIBUTORS\n\nMainly Jason Stajich\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Code begins...\n\n\npackage Bio::Taxonomy::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Taxonomy::Taxon;\n\n# Import rank information from Bio::Taxonomy.pm\nuse vars qw(@RANK %RANK);\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Tree->new();\n Function: Builds a new Bio::Taxonomy::Tree object \n Returns : Bio::Taxonomy::Tree\n Args    : \n\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Tree is deprecated. Use Bio::Taxon in combination with Bio::Tree::Tree instead.\");\n  \n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n\n  my ($root)= $self->_rearrange([qw(ROOT)], @args);\n  if( $root ) { $self->set_root_node($root); }\n  return $self;\n}\n\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Taxonomy::Taxon objects\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self, @args) = @_;\n   \n   my ($order, $sortby) = $self->_rearrange([qw(ORDER SORTBY)],@args);\n   $order ||= 'depth';\n   $sortby ||= 'height';\n\n   if ($order =~ m/^b|(breadth)$/oi) {\n      my $node = $self->get_root_node;\n      my @children = ($node);\n      for (@children) {\n\t   push @children, $_->each_Descendent($sortby);\n      }\n      return @children;\n   }\n\n   if ($order =~ m/^d|(depth)$/oi) {\n       # this is depth-first search I believe\n       my $node = $self->get_root_node;\n       my @children = ($node,$node->get_Descendents($sortby));\n       return @children;\n   }\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Taxonomy::Taxon object\n Args    : none\n\n\n\nsub get_root_node{\n   my ($self) = @_;\n   return $self->{'_rootnode'};\n}\n\n=head2 set_root_node\n\n Title   : set_root_node\n Usage   : $tree->set_root_node($node)\n Function: Set the Root Node for the Tree\n Returns : Bio::Taxonomy::Taxon\n Args    : Bio::Taxonomy::Taxon\n\n\n\nsub set_root_node{\n   my ($self,$value) = @_;\n   if( defined $value ) { \n      if( ! $value->isa('Bio::Taxonomy::Taxon') ) { \n\t   $self->warn(\"Trying to set the root node to $value which is not a Bio::Taxonomy::Taxon\");\n\t   return $self->get_root_node;\n      }\n      $self->{'_rootnode'} = $value;\n   }\n   return $self->get_root_node;\n}\n\n\n=head2 get_leaves\n\n Title   : get_leaves\n Usage   : my @nodes = $tree->get_leaves()\n Function: Return list of Bio::Taxonomy::Taxon objects\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : \n\n\n\nsub get_leaves{\n   my ($self) = @_;\n   \n   my $node = $self->get_root_node;\n   my @leaves;\n   my @children = ($node);\n   for (@children) {\n      push @children, $_->each_Descendent();\n   }\n   for (@children) {\n      push @leaves, $_ if $_->is_Leaf;\n   }\n   return @leaves;\n}\n\n=head2 make_species_branch\n\n Title   : make_species_branch\n Usage   : @nodes = $tree->make_species_branch($species,$taxonomy)\n Function: Return list of Bio::Taxonomy::Taxon objects based on a Bio::Species object\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : Bio::Species and Bio::Taxonomy objects\n\n\n# I'm not happy that make_species_branch and make_branch are seperate routines\n# should be able to just make_branch and have it sort things out\n\nsub make_species_branch{\n   my ($self,$species,$taxonomy) = @_;\n   \n   if (! $species->isa('Bio::Species') ) {\n      $self->throw(\"Trying to classify $species which is not a Bio::Species object\");\n   }\n   if (! $taxonomy->isa('Bio::Taxonomy') ) {\n      $self->throw(\"Trying to classify with $taxonomy which is not a Bio::Taxonomy object\");\n   }\n\n   # this is done to make sure we aren't duplicating a path (let God sort them out)\n   if (defined $self->get_root_node) {\n      $self->get_root_node->remove_all_Descendents;\n   }\n\n   my @nodes;\n\n   # nb taxa in [i][0] and ranks in [i][1]\n   my @taxa=$taxonomy->classify($species);\n\n   for (my $i = 0; $i < @taxa; $i++) {\n      $nodes[$i]=Bio::Taxonomy::Taxon->new(-taxon => $taxa[$i][0],\n                                           -rank  => $taxa[$i][1]);\n   }\n\n   for (my $i = 0; $i < @taxa-1; $i++) {\n      $nodes[$i]->add_Descendent($nodes[$i+1]);\n   }\n\n   $self->set_root_node($nodes[0]);\n\n   return @nodes;\n}\n\n\n=head2 make_branch\n\n Title   : make_branch\n Usage   : $tree->make_branch($node)\n Function: Make a linear Bio::Taxonomy::Tree object from a leafish node\n Returns :\n Args    : Bio::Taxonomy::Taxon object\n\n\n\nsub make_branch{\n   my ($self,$node) = @_;\n\n   # this is done to make sure we aren't duplicating a path (let God sort them out)\n   # note that if you are using a linked set of node which include node \n   # already in the tree, this will break\n   $self->get_root_node->remove_all_Descendents;\n   \n   while (defined $node->ancestor) {\n      $self->set_root_node($node);\n      $node=$node->ancestor;\n   }\n}\n\n\n=head2 splice\n\n Title   : splice\n Usage   : @nodes = $tree->splice($tree)\n Function: Return a of Bio::Taxonomy::Tree object that is a fusion of two\n Returns : array of Bio::Taxonomy::Taxon added to tree\n Args    : Bio::Taxonomy::Tree object\n\n\n\nsub splice{\n   my ($self,$tree) = @_;\n\n   my @nodes;\n\n   my @newleaves = $tree->get_leaves;\n   foreach my $leaf (@newleaves) {\n      push @nodes,$self->add_branch($leaf);\n   }\n\n   return @nodes;\n}\n\n=head2 add_species\n\n Title   : add_species\n Usage   : @nodes = $tree->add_species($species,$taxonomy)\n Function: Return a of Bio::Taxonomy::Tree object with a new species added\n Returns : array of Bio::Taxonomy::Taxon added to tree\n Args    : Bio::Species object","parameters":[{"label":"$self"},{"label":"$species"},{"label":"$taxonomy"}]},"detail":"($self,$species,$taxonomy)","definition":"sub","containerName":"main::","children":[{"containerName":"add_species","definition":"my","name":"$self","localvar":"my","kind":13,"line":366},{"line":366,"kind":13,"containerName":"add_species","name":"$species"},{"line":366,"kind":13,"containerName":"add_species","name":"$taxonomy"},{"line":368,"kind":13,"localvar":"my","containerName":"add_species","name":"$branch","definition":"my"},{"kind":12,"line":368,"containerName":"add_species","name":"new"},{"kind":13,"line":369,"containerName":"add_species","definition":"my","name":"@nodes","localvar":"my"},{"kind":13,"line":369,"name":"$branch","containerName":"add_species"},{"name":"make_species_branch","containerName":"add_species","line":369,"kind":12},{"line":369,"kind":13,"containerName":"add_species","name":"$species"},{"kind":13,"line":369,"containerName":"add_species","name":"$taxonomy"},{"containerName":"add_species","name":"$newleaf","definition":"my","localvar":"my","kind":13,"line":371},{"name":"$branch","containerName":"add_species","kind":13,"line":371},{"line":371,"kind":12,"containerName":"add_species","name":"get_leaves"},{"containerName":"add_species","name":"$self","kind":13,"line":373},{"line":373,"kind":12,"name":"add_branch","containerName":"add_species"},{"containerName":"add_species","name":"$newleaf","kind":13,"line":373}],"line":365,"kind":12},{"kind":12,"line":368,"name":"Bio","containerName":"Taxonomy::Tree"},{"name":"add_branch","range":{"end":{"character":9999,"line":420},"start":{"line":389,"character":0}},"containerName":"main::","definition":"sub","detail":"($self,$node,$force)","signature":{"label":"add_branch($self,$node,$force)","documentation":"1;\n# $Id: Tree.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from Bio::Tree::Tree by Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Tree - An Organism Level Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon in combination with\n    # Bio::Tree::Tree instead\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n    my @leaves = $tree->get_leaves;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Taxonomic Nodes which make up a tree.\n\n=head1 EXAMPLES\n\n  use Bio::Species;\n  use Bio::Taxonomy::Tree;\n\n  my $human=Bio::Species->new();\n  my $chimp=Bio::Species->new();\n  my $bonobo=Bio::Species->new();\n\n  $human->classification(qw( sapiens Homo Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $chimp->classification(qw( troglodytes Pan Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $bonobo->classification(qw( paniscus Pan Hominidae\n                              Catarrhini Primates Eutheria\n                              Mammalia Euteleostomi Vertebrata \n                              Craniata Chordata\n                              Metazoa Eukaryota ));\n\n  # ranks passed to $taxonomy match ranks of species\n  my @ranks = ('superkingdom','kingdom','phylum','subphylum',\n               'no rank 1','no rank 2','class','no rank 3','order',\n               'suborder','family','genus','species');\n\n  my $taxonomy=Bio::Taxonomy->new(-ranks => \\@ranks,\n                                 -method => 'trust',\n                                 -order => -1);\n\n\n  my $tree1=Bio::Taxonomy::Tree->new();\n  my $tree2=Bio::Taxonomy::Tree->new();\n\n  $tree1->make_species_branch($human,$taxonomy);\n  $tree2->make_species_branch($chimp,$taxonomy);\n\n  my ($homo_sapiens)=$tree1->get_leaves;\n\n  $tree1->splice($tree2);\n\n  $tree1->add_species($bonobo,$taxonomy);\n\n  my @taxa;\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n  @taxa=();\n  $tree1->remove_branch($homo_sapiens);\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n=head1 FEEDBACK\n\nSee AUTHOR\n\n=head1 AUTHOR - Dan Kortschak\n\nEmail kortschak@rsbs.anu.edu.au\n\n=head1 CONTRIBUTORS\n\nMainly Jason Stajich\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Code begins...\n\n\npackage Bio::Taxonomy::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Taxonomy::Taxon;\n\n# Import rank information from Bio::Taxonomy.pm\nuse vars qw(@RANK %RANK);\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Tree->new();\n Function: Builds a new Bio::Taxonomy::Tree object \n Returns : Bio::Taxonomy::Tree\n Args    : \n\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Tree is deprecated. Use Bio::Taxon in combination with Bio::Tree::Tree instead.\");\n  \n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n\n  my ($root)= $self->_rearrange([qw(ROOT)], @args);\n  if( $root ) { $self->set_root_node($root); }\n  return $self;\n}\n\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Taxonomy::Taxon objects\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self, @args) = @_;\n   \n   my ($order, $sortby) = $self->_rearrange([qw(ORDER SORTBY)],@args);\n   $order ||= 'depth';\n   $sortby ||= 'height';\n\n   if ($order =~ m/^b|(breadth)$/oi) {\n      my $node = $self->get_root_node;\n      my @children = ($node);\n      for (@children) {\n\t   push @children, $_->each_Descendent($sortby);\n      }\n      return @children;\n   }\n\n   if ($order =~ m/^d|(depth)$/oi) {\n       # this is depth-first search I believe\n       my $node = $self->get_root_node;\n       my @children = ($node,$node->get_Descendents($sortby));\n       return @children;\n   }\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Taxonomy::Taxon object\n Args    : none\n\n\n\nsub get_root_node{\n   my ($self) = @_;\n   return $self->{'_rootnode'};\n}\n\n=head2 set_root_node\n\n Title   : set_root_node\n Usage   : $tree->set_root_node($node)\n Function: Set the Root Node for the Tree\n Returns : Bio::Taxonomy::Taxon\n Args    : Bio::Taxonomy::Taxon\n\n\n\nsub set_root_node{\n   my ($self,$value) = @_;\n   if( defined $value ) { \n      if( ! $value->isa('Bio::Taxonomy::Taxon') ) { \n\t   $self->warn(\"Trying to set the root node to $value which is not a Bio::Taxonomy::Taxon\");\n\t   return $self->get_root_node;\n      }\n      $self->{'_rootnode'} = $value;\n   }\n   return $self->get_root_node;\n}\n\n\n=head2 get_leaves\n\n Title   : get_leaves\n Usage   : my @nodes = $tree->get_leaves()\n Function: Return list of Bio::Taxonomy::Taxon objects\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : \n\n\n\nsub get_leaves{\n   my ($self) = @_;\n   \n   my $node = $self->get_root_node;\n   my @leaves;\n   my @children = ($node);\n   for (@children) {\n      push @children, $_->each_Descendent();\n   }\n   for (@children) {\n      push @leaves, $_ if $_->is_Leaf;\n   }\n   return @leaves;\n}\n\n=head2 make_species_branch\n\n Title   : make_species_branch\n Usage   : @nodes = $tree->make_species_branch($species,$taxonomy)\n Function: Return list of Bio::Taxonomy::Taxon objects based on a Bio::Species object\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : Bio::Species and Bio::Taxonomy objects\n\n\n# I'm not happy that make_species_branch and make_branch are seperate routines\n# should be able to just make_branch and have it sort things out\n\nsub make_species_branch{\n   my ($self,$species,$taxonomy) = @_;\n   \n   if (! $species->isa('Bio::Species') ) {\n      $self->throw(\"Trying to classify $species which is not a Bio::Species object\");\n   }\n   if (! $taxonomy->isa('Bio::Taxonomy') ) {\n      $self->throw(\"Trying to classify with $taxonomy which is not a Bio::Taxonomy object\");\n   }\n\n   # this is done to make sure we aren't duplicating a path (let God sort them out)\n   if (defined $self->get_root_node) {\n      $self->get_root_node->remove_all_Descendents;\n   }\n\n   my @nodes;\n\n   # nb taxa in [i][0] and ranks in [i][1]\n   my @taxa=$taxonomy->classify($species);\n\n   for (my $i = 0; $i < @taxa; $i++) {\n      $nodes[$i]=Bio::Taxonomy::Taxon->new(-taxon => $taxa[$i][0],\n                                           -rank  => $taxa[$i][1]);\n   }\n\n   for (my $i = 0; $i < @taxa-1; $i++) {\n      $nodes[$i]->add_Descendent($nodes[$i+1]);\n   }\n\n   $self->set_root_node($nodes[0]);\n\n   return @nodes;\n}\n\n\n=head2 make_branch\n\n Title   : make_branch\n Usage   : $tree->make_branch($node)\n Function: Make a linear Bio::Taxonomy::Tree object from a leafish node\n Returns :\n Args    : Bio::Taxonomy::Taxon object\n\n\n\nsub make_branch{\n   my ($self,$node) = @_;\n\n   # this is done to make sure we aren't duplicating a path (let God sort them out)\n   # note that if you are using a linked set of node which include node \n   # already in the tree, this will break\n   $self->get_root_node->remove_all_Descendents;\n   \n   while (defined $node->ancestor) {\n      $self->set_root_node($node);\n      $node=$node->ancestor;\n   }\n}\n\n\n=head2 splice\n\n Title   : splice\n Usage   : @nodes = $tree->splice($tree)\n Function: Return a of Bio::Taxonomy::Tree object that is a fusion of two\n Returns : array of Bio::Taxonomy::Taxon added to tree\n Args    : Bio::Taxonomy::Tree object\n\n\n\nsub splice{\n   my ($self,$tree) = @_;\n\n   my @nodes;\n\n   my @newleaves = $tree->get_leaves;\n   foreach my $leaf (@newleaves) {\n      push @nodes,$self->add_branch($leaf);\n   }\n\n   return @nodes;\n}\n\n=head2 add_species\n\n Title   : add_species\n Usage   : @nodes = $tree->add_species($species,$taxonomy)\n Function: Return a of Bio::Taxonomy::Tree object with a new species added\n Returns : array of Bio::Taxonomy::Taxon added to tree\n Args    : Bio::Species object\n\n\n\nsub add_species{\n   my ($self,$species,$taxonomy) = @_;\n\n   my $branch=Bio::Taxonomy::Tree->new;\n   my @nodes=$branch->make_species_branch($species,$taxonomy);\n\n   my ($newleaf)=$branch->get_leaves;\n  \n   return $self->add_branch($newleaf);\n}\n\n=head2 add_branch\n\n Title   : add_branch\n Usage   : $tree->add_branch($node,boolean)\n Function: Return a of Bio::Taxonomy::Tree object with a new branch added\n Returns : array of Bio::Taxonomy::Taxon objects of the resulting tree\n Args    : Bio::Taxonomy::Taxon object\n           boolean flag to force overwrite of descendent\n             (see Bio::Node->add_Descendent)","parameters":[{"label":"$self"},{"label":"$node"},{"label":"$force"}]},"kind":12,"line":389,"children":[{"line":390,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"add_branch"},{"containerName":"add_branch","name":"$node","line":390,"kind":13},{"line":390,"kind":13,"name":"$force","containerName":"add_branch"},{"line":392,"kind":13,"localvar":"my","containerName":"add_branch","name":"$best_node_level","definition":"my"},{"line":393,"kind":13,"localvar":"my","name":"$best_node","definition":"my","containerName":"add_branch"},{"name":"@nodes","containerName":"add_branch","kind":13,"line":393},{"kind":13,"line":393,"containerName":"add_branch","name":"$common"},{"line":395,"kind":13,"localvar":"my","containerName":"add_branch","name":"@leaves","definition":"my"},{"name":"$self","containerName":"add_branch","line":395,"kind":13},{"containerName":"add_branch","name":"get_leaves","kind":12,"line":395},{"line":396,"kind":13,"localvar":"my","containerName":"add_branch","name":"$leaf","definition":"my"},{"name":"@leaves","containerName":"add_branch","line":396,"kind":13},{"line":397,"kind":13,"containerName":"add_branch","name":"$common"},{"line":397,"kind":13,"name":"$node","containerName":"add_branch"},{"containerName":"add_branch","name":"recent_common_ancestor","line":397,"kind":12},{"line":397,"kind":13,"containerName":"add_branch","name":"$leaf"},{"line":398,"kind":13,"name":"$common","containerName":"add_branch"},{"name":"$common","containerName":"add_branch","kind":13,"line":398},{"containerName":"add_branch","name":"distance_to_root","line":398,"kind":12},{"kind":13,"line":398,"name":"$best_node_level","containerName":"add_branch"},{"containerName":"add_branch","name":"$best_node_level","line":399,"kind":13},{"line":399,"kind":13,"containerName":"add_branch","name":"$common"},{"name":"distance_to_root","containerName":"add_branch","kind":12,"line":399},{"name":"$best_node","containerName":"add_branch","line":400,"kind":13},{"line":400,"kind":13,"name":"$common","containerName":"add_branch"},{"name":"$best_node","containerName":"add_branch","kind":13,"line":404},{"kind":13,"line":406,"containerName":"add_branch","name":"@nodes"},{"containerName":"add_branch","name":"$self","kind":13,"line":406},{"name":"get_root_node","containerName":"add_branch","kind":12,"line":406},{"containerName":"add_branch","name":"$self","line":406,"kind":13},{"name":"get_root_node","containerName":"add_branch","line":406,"kind":12},{"line":406,"kind":12,"name":"get_Descendents","containerName":"add_branch"},{"localvar":"my","containerName":"add_branch","name":"$node","definition":"my","line":407,"kind":13},{"name":"@nodes","containerName":"add_branch","kind":13,"line":407},{"kind":13,"line":408,"containerName":"add_branch","name":"$best_node"},{"line":408,"kind":12,"containerName":"add_branch","name":"id"},{"kind":13,"line":408,"containerName":"add_branch","name":"$best_node"},{"containerName":"add_branch","name":"id","kind":12,"line":408},{"kind":13,"line":408,"containerName":"add_branch","name":"$node"},{"kind":12,"line":408,"name":"id","containerName":"add_branch"},{"containerName":"add_branch","name":"$best_node","line":409,"kind":13},{"kind":12,"line":409,"name":"rank","containerName":"add_branch"},{"line":409,"kind":13,"name":"$node","containerName":"add_branch"},{"kind":12,"line":409,"containerName":"add_branch","name":"rank"},{"kind":13,"line":409,"containerName":"add_branch","name":"$best_node"},{"name":"taxon","containerName":"add_branch","kind":12,"line":409},{"name":"$node","containerName":"add_branch","line":409,"kind":13},{"containerName":"add_branch","name":"taxon","line":409,"kind":12},{"containerName":"add_branch","name":"$best_node","line":410,"kind":13},{"containerName":"add_branch","name":"rank","kind":12,"line":410},{"kind":13,"line":411,"name":"$descendent","definition":"my","containerName":"add_branch","localvar":"my"},{"line":411,"kind":13,"containerName":"add_branch","name":"$common"},{"name":"each_Descendent","containerName":"add_branch","kind":12,"line":411},{"line":412,"kind":13,"name":"$node","containerName":"add_branch"},{"containerName":"add_branch","name":"add_Descendent","kind":12,"line":412},{"name":"$descendent","containerName":"add_branch","kind":13,"line":412},{"name":"$force","containerName":"add_branch","kind":13,"line":412},{"name":"$self","containerName":"add_branch","line":416,"kind":13},{"kind":12,"line":416,"containerName":"add_branch","name":"set_root_node"},{"containerName":"add_branch","name":"$node","line":416,"kind":13},{"line":416,"kind":13,"containerName":"add_branch","name":"$node"},{"name":"distance_to_root","containerName":"add_branch","line":416,"kind":12},{"name":"$common","containerName":"add_branch","line":419,"kind":13},{"containerName":"add_branch","name":"get_Descendents","line":419,"kind":12}]},{"definition":"sub","containerName":"main::","signature":{"label":"remove_branch($self,$node)","documentation":"1;\n# $Id: Tree.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from Bio::Tree::Tree by Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Tree - An Organism Level Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon in combination with\n    # Bio::Tree::Tree instead\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n    my @leaves = $tree->get_leaves;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Taxonomic Nodes which make up a tree.\n\n=head1 EXAMPLES\n\n  use Bio::Species;\n  use Bio::Taxonomy::Tree;\n\n  my $human=Bio::Species->new();\n  my $chimp=Bio::Species->new();\n  my $bonobo=Bio::Species->new();\n\n  $human->classification(qw( sapiens Homo Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $chimp->classification(qw( troglodytes Pan Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $bonobo->classification(qw( paniscus Pan Hominidae\n                              Catarrhini Primates Eutheria\n                              Mammalia Euteleostomi Vertebrata \n                              Craniata Chordata\n                              Metazoa Eukaryota ));\n\n  # ranks passed to $taxonomy match ranks of species\n  my @ranks = ('superkingdom','kingdom','phylum','subphylum',\n               'no rank 1','no rank 2','class','no rank 3','order',\n               'suborder','family','genus','species');\n\n  my $taxonomy=Bio::Taxonomy->new(-ranks => \\@ranks,\n                                 -method => 'trust',\n                                 -order => -1);\n\n\n  my $tree1=Bio::Taxonomy::Tree->new();\n  my $tree2=Bio::Taxonomy::Tree->new();\n\n  $tree1->make_species_branch($human,$taxonomy);\n  $tree2->make_species_branch($chimp,$taxonomy);\n\n  my ($homo_sapiens)=$tree1->get_leaves;\n\n  $tree1->splice($tree2);\n\n  $tree1->add_species($bonobo,$taxonomy);\n\n  my @taxa;\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n  @taxa=();\n  $tree1->remove_branch($homo_sapiens);\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n=head1 FEEDBACK\n\nSee AUTHOR\n\n=head1 AUTHOR - Dan Kortschak\n\nEmail kortschak@rsbs.anu.edu.au\n\n=head1 CONTRIBUTORS\n\nMainly Jason Stajich\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Code begins...\n\n\npackage Bio::Taxonomy::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Taxonomy::Taxon;\n\n# Import rank information from Bio::Taxonomy.pm\nuse vars qw(@RANK %RANK);\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Tree->new();\n Function: Builds a new Bio::Taxonomy::Tree object \n Returns : Bio::Taxonomy::Tree\n Args    : \n\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Tree is deprecated. Use Bio::Taxon in combination with Bio::Tree::Tree instead.\");\n  \n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n\n  my ($root)= $self->_rearrange([qw(ROOT)], @args);\n  if( $root ) { $self->set_root_node($root); }\n  return $self;\n}\n\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Taxonomy::Taxon objects\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self, @args) = @_;\n   \n   my ($order, $sortby) = $self->_rearrange([qw(ORDER SORTBY)],@args);\n   $order ||= 'depth';\n   $sortby ||= 'height';\n\n   if ($order =~ m/^b|(breadth)$/oi) {\n      my $node = $self->get_root_node;\n      my @children = ($node);\n      for (@children) {\n\t   push @children, $_->each_Descendent($sortby);\n      }\n      return @children;\n   }\n\n   if ($order =~ m/^d|(depth)$/oi) {\n       # this is depth-first search I believe\n       my $node = $self->get_root_node;\n       my @children = ($node,$node->get_Descendents($sortby));\n       return @children;\n   }\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Taxonomy::Taxon object\n Args    : none\n\n\n\nsub get_root_node{\n   my ($self) = @_;\n   return $self->{'_rootnode'};\n}\n\n=head2 set_root_node\n\n Title   : set_root_node\n Usage   : $tree->set_root_node($node)\n Function: Set the Root Node for the Tree\n Returns : Bio::Taxonomy::Taxon\n Args    : Bio::Taxonomy::Taxon\n\n\n\nsub set_root_node{\n   my ($self,$value) = @_;\n   if( defined $value ) { \n      if( ! $value->isa('Bio::Taxonomy::Taxon') ) { \n\t   $self->warn(\"Trying to set the root node to $value which is not a Bio::Taxonomy::Taxon\");\n\t   return $self->get_root_node;\n      }\n      $self->{'_rootnode'} = $value;\n   }\n   return $self->get_root_node;\n}\n\n\n=head2 get_leaves\n\n Title   : get_leaves\n Usage   : my @nodes = $tree->get_leaves()\n Function: Return list of Bio::Taxonomy::Taxon objects\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : \n\n\n\nsub get_leaves{\n   my ($self) = @_;\n   \n   my $node = $self->get_root_node;\n   my @leaves;\n   my @children = ($node);\n   for (@children) {\n      push @children, $_->each_Descendent();\n   }\n   for (@children) {\n      push @leaves, $_ if $_->is_Leaf;\n   }\n   return @leaves;\n}\n\n=head2 make_species_branch\n\n Title   : make_species_branch\n Usage   : @nodes = $tree->make_species_branch($species,$taxonomy)\n Function: Return list of Bio::Taxonomy::Taxon objects based on a Bio::Species object\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : Bio::Species and Bio::Taxonomy objects\n\n\n# I'm not happy that make_species_branch and make_branch are seperate routines\n# should be able to just make_branch and have it sort things out\n\nsub make_species_branch{\n   my ($self,$species,$taxonomy) = @_;\n   \n   if (! $species->isa('Bio::Species') ) {\n      $self->throw(\"Trying to classify $species which is not a Bio::Species object\");\n   }\n   if (! $taxonomy->isa('Bio::Taxonomy') ) {\n      $self->throw(\"Trying to classify with $taxonomy which is not a Bio::Taxonomy object\");\n   }\n\n   # this is done to make sure we aren't duplicating a path (let God sort them out)\n   if (defined $self->get_root_node) {\n      $self->get_root_node->remove_all_Descendents;\n   }\n\n   my @nodes;\n\n   # nb taxa in [i][0] and ranks in [i][1]\n   my @taxa=$taxonomy->classify($species);\n\n   for (my $i = 0; $i < @taxa; $i++) {\n      $nodes[$i]=Bio::Taxonomy::Taxon->new(-taxon => $taxa[$i][0],\n                                           -rank  => $taxa[$i][1]);\n   }\n\n   for (my $i = 0; $i < @taxa-1; $i++) {\n      $nodes[$i]->add_Descendent($nodes[$i+1]);\n   }\n\n   $self->set_root_node($nodes[0]);\n\n   return @nodes;\n}\n\n\n=head2 make_branch\n\n Title   : make_branch\n Usage   : $tree->make_branch($node)\n Function: Make a linear Bio::Taxonomy::Tree object from a leafish node\n Returns :\n Args    : Bio::Taxonomy::Taxon object\n\n\n\nsub make_branch{\n   my ($self,$node) = @_;\n\n   # this is done to make sure we aren't duplicating a path (let God sort them out)\n   # note that if you are using a linked set of node which include node \n   # already in the tree, this will break\n   $self->get_root_node->remove_all_Descendents;\n   \n   while (defined $node->ancestor) {\n      $self->set_root_node($node);\n      $node=$node->ancestor;\n   }\n}\n\n\n=head2 splice\n\n Title   : splice\n Usage   : @nodes = $tree->splice($tree)\n Function: Return a of Bio::Taxonomy::Tree object that is a fusion of two\n Returns : array of Bio::Taxonomy::Taxon added to tree\n Args    : Bio::Taxonomy::Tree object\n\n\n\nsub splice{\n   my ($self,$tree) = @_;\n\n   my @nodes;\n\n   my @newleaves = $tree->get_leaves;\n   foreach my $leaf (@newleaves) {\n      push @nodes,$self->add_branch($leaf);\n   }\n\n   return @nodes;\n}\n\n=head2 add_species\n\n Title   : add_species\n Usage   : @nodes = $tree->add_species($species,$taxonomy)\n Function: Return a of Bio::Taxonomy::Tree object with a new species added\n Returns : array of Bio::Taxonomy::Taxon added to tree\n Args    : Bio::Species object\n\n\n\nsub add_species{\n   my ($self,$species,$taxonomy) = @_;\n\n   my $branch=Bio::Taxonomy::Tree->new;\n   my @nodes=$branch->make_species_branch($species,$taxonomy);\n\n   my ($newleaf)=$branch->get_leaves;\n  \n   return $self->add_branch($newleaf);\n}\n\n=head2 add_branch\n\n Title   : add_branch\n Usage   : $tree->add_branch($node,boolean)\n Function: Return a of Bio::Taxonomy::Tree object with a new branch added\n Returns : array of Bio::Taxonomy::Taxon objects of the resulting tree\n Args    : Bio::Taxonomy::Taxon object\n           boolean flag to force overwrite of descendent\n             (see Bio::Node->add_Descendent)\n\n\n\nsub add_branch {\n   my ($self,$node,$force) = @_;\n\n   my $best_node_level=0;\n   my ($best_node,@nodes,$common);\n\n   my @leaves=$self->get_leaves;\n   foreach my $leaf (@leaves) {\n      $common=$node->recent_common_ancestor($leaf); # the root of the part to add\n      if (defined $common && ($common->distance_to_root > $best_node_level)) {\n         $best_node_level = $common->distance_to_root;\n         $best_node = $common;\n      }\n   }\n\n   return unless defined $best_node;\n\n   push @nodes,($self->get_root_node,$self->get_root_node->get_Descendents);\n   foreach my $node (@nodes) {\n      if ((defined $best_node->id && $best_node->id == $node->id) ||\n         ($best_node->rank eq $node->rank && $best_node->taxon eq $node->taxon) &&\n         ($best_node->rank ne 'no rank')) {\n         foreach my $descendent ($common->each_Descendent) {\n            $node->add_Descendent($descendent,$force);\n         }\n      }\n\n      $self->set_root_node($node) if $node->distance_to_root==0;\n   }\n\n   return ($common->get_Descendents);\n}\n\n=head2 remove_branch\n\n Title   : remove_branch\n Usage   : $tree->remove_branch($node)\n Function: remove a branch up to the next multifurcation\n Returns :\n Args    : Bio::Taxonomy::Taxon object","parameters":[{"label":"$self"},{"label":"$node"}]},"detail":"($self,$node)","kind":12,"children":[{"line":434,"kind":13,"localvar":"my","containerName":"remove_branch","definition":"my","name":"$self"},{"name":"$node","containerName":"remove_branch","line":434,"kind":13},{"kind":13,"line":438,"containerName":"remove_branch","name":"$node"},{"name":"ancestor","containerName":"remove_branch","kind":12,"line":438},{"name":"$node","containerName":"remove_branch","line":439,"kind":13},{"kind":12,"line":439,"containerName":"remove_branch","name":"ancestor"},{"containerName":"remove_branch","name":"each_Descendent","kind":12,"line":439},{"kind":13,"line":440,"name":"$node","containerName":"remove_branch"},{"containerName":"remove_branch","name":"$node","kind":13,"line":440},{"name":"ancestor","containerName":"remove_branch","line":440,"kind":12},{"name":"$node","containerName":"remove_branch","kind":13,"line":442},{"line":442,"kind":12,"name":"remove_all_Descendents","containerName":"remove_branch"},{"line":446,"kind":13,"name":"$node","containerName":"remove_branch"},{"name":"ancestor","containerName":"remove_branch","line":446,"kind":12},{"name":"remove_Descendent","containerName":"remove_branch","kind":12,"line":446},{"line":446,"kind":13,"containerName":"remove_branch","name":"$node"}],"line":433,"name":"remove_branch","range":{"start":{"character":0,"line":433},"end":{"line":447,"character":9999}}}]}