{"version":5,"vars":[{"kind":2,"line":108,"name":"base","containerName":""},{"name":"_initialize","range":{"end":{"line":270,"character":9999},"start":{"character":0,"line":176}},"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"_initialize($self,@args)","documentation":"1;\n# $Id: table.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::table\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2005.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2005.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::table - sequence input/output stream from a delimited table\n\n=head1 SYNOPSIS\n\n  #It is probably best not to use this object directly, but\n  #rather go through the SeqIO handler system. Go:\n\n  $stream = Bio::SeqIO->new(-file => $filename, -format => 'table');\n\n  while ( my $seq = $stream->next_seq() ) {\n\t# do something with $seq\n  }\n\n=head1 DESCRIPTION\n\nThis class transforms records in a table-formatted text file into\nBio::Seq objects.\n\nA table-formatted text file of sequence records for the purposes of\nthis module is defined as a text file with each row corresponding to a\nsequence, and the attributes of the sequence being in different\ncolumns. Columns are delimited by a common delimiter, for instance tab\nor comma.\n\nThe module permits specifying which columns hold which type of\nannotation. The semantics of certain attributes, if present, are\npre-defined, e.g., accession number and sequence. Additional\nattributes may be added to the annotation bundle.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\n\nBug reports can be submitted via email or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::table;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::SimpleValue;\n\nuse base qw(Bio::SeqIO);\n\n=head2 new\n\n Title   : new\n Usage   : $stream = Bio::SeqIO->new(-file => $filename, -format => 'table')\n Function: Returns a new seqstream\n Returns : A Bio::SeqIO stream for a table format\n Args    : Named parameters:\n\n             -file    name of file to read\n             -fh      filehandle to attach to\n             -comment leading character(s) introducing a comment line\n             -header  the number of header lines to skip; the first\n                      non-comment header line will be used to obtain\n                      column names; column names will be used as the\n                      default tags for attaching annotation.\n             -delim   the delimiter for columns as a regular expression;\n                      consecutive occurrences of the delimiter will\n                      not be collapsed.\n             -display_id the one-based index of the column containing\n                      the display ID of the sequence\n             -accession_number the one-based index of the column\n                      containing the accession number of the sequence\n             -seq     the one-based index of the column containing\n                      the sequence string of the sequence\n             -species the one-based index of the column containing the\n                      species for the sequence record; if not a\n                      number, will be used as the static species\n                      common to all records\n             -annotation if provided and a scalar (but see below), a\n                      flag whether or not all additional columns are\n                      to be preserved as annotation, the tags used\n                      will either be 'colX' if there is no column\n                      header and where X is the one-based column\n                      index, and otherwise the column headers will be\n                      used as tags;\n\n                      if a reference to an array, or a square\n                      bracket-enclosed string of comma-delimited\n                      values, only those columns (one-based index)\n                      will be preserved as annotation, tags as before;\n\n                      if a reference to a hash, or a curly\n                      braces-enclosed string of comma-delimited key\n                      and value pairs in alternating order, the keys\n                      are one-based column indexes to be preserved,\n                      and the values are the tags under which the\n                      annotation is to be attached; if not provided or\n                      supplied as undef, no additional annotation will\n                      be preserved.\n             -colnames a reference to an array of column labels, or a\n                      string of comma-delimited labels, denoting the\n                      columns to be converted into annotation; this is\n                      an alternative to -annotation and will be\n                      ignored if -annotation is also supplied with a\n                      valid value.\n             -trim    flag determining whether or not all values should\n                      be trimmed of leading and trailing white space\n                      and double quotes\n\n           Additional arguments may be used to e.g. set factories and\n           builders involved in the sequence object creation (see the\n           POD of Bio::SeqIO).","parameters":[{"label":"$self"},{"label":"@args"}]},"kind":12,"line":176,"children":[{"containerName":"_initialize","definition":"my","name":"$self","localvar":"my","kind":13,"line":177},{"containerName":"_initialize","name":"@args","line":177,"kind":13},{"name":"$self","containerName":"_initialize","line":180,"kind":13},{"containerName":"_initialize","name":"@args","kind":13,"line":180},{"containerName":"_initialize","name":"$cmtchars","definition":"my","localvar":"my","kind":13,"line":183},{"containerName":"_initialize","name":"$header","kind":13,"line":184},{"kind":13,"line":185,"containerName":"_initialize","name":"$delim"},{"containerName":"_initialize","name":"$display_id","kind":13,"line":186},{"name":"$accnr","containerName":"_initialize","line":187,"kind":13},{"kind":13,"line":188,"name":"$seq","containerName":"_initialize"},{"containerName":"_initialize","name":"$taxon","kind":13,"line":189},{"containerName":"_initialize","name":"$useann","kind":13,"line":190},{"line":191,"kind":13,"name":"$colnames","containerName":"_initialize"},{"line":192,"kind":13,"name":"$trim","containerName":"_initialize"},{"kind":13,"line":193,"containerName":"_initialize","name":"$self"},{"name":"_rearrange","containerName":"_initialize","line":193,"kind":12},{"kind":13,"line":203,"containerName":"_initialize","name":"@args"},{"kind":13,"line":206,"containerName":"_initialize","name":"$self"},{"containerName":"_initialize","name":"comment_char","line":206,"kind":12},{"line":206,"kind":13,"name":"$cmtchars","containerName":"_initialize"},{"name":"$cmtchars","containerName":"_initialize","kind":13,"line":206},{"containerName":"_initialize","name":"$self","line":207,"kind":13},{"kind":12,"line":207,"name":"comment_char","containerName":"_initialize"},{"kind":13,"line":207,"containerName":"_initialize","name":"$cmtchars"},{"containerName":"_initialize","name":"$self","line":208,"kind":13},{"line":208,"kind":12,"name":"delimiter","containerName":"_initialize"},{"containerName":"_initialize","name":"$delim","line":208,"kind":13},{"containerName":"_initialize","name":"$delim","line":208,"kind":13},{"line":209,"kind":13,"name":"$self","containerName":"_initialize"},{"kind":12,"line":209,"containerName":"_initialize","name":"delimiter"},{"containerName":"_initialize","name":"$delim","line":209,"kind":13},{"line":210,"kind":13,"name":"$self","containerName":"_initialize"},{"kind":12,"line":210,"name":"header","containerName":"_initialize"},{"containerName":"_initialize","name":"$header","line":210,"kind":13},{"kind":13,"line":210,"name":"$header","containerName":"_initialize"},{"name":"$self","containerName":"_initialize","line":211,"kind":13},{"line":211,"kind":12,"containerName":"_initialize","name":"trim_values"},{"line":211,"kind":13,"name":"$trim","containerName":"_initialize"},{"line":211,"kind":13,"containerName":"_initialize","name":"$trim"},{"containerName":"_initialize","definition":"my","name":"$attrs","localvar":"my","kind":13,"line":214},{"line":215,"kind":13,"name":"$attrs","containerName":"_initialize"},{"containerName":"_initialize","name":"$display_id","line":215,"kind":13},{"line":215,"kind":13,"containerName":"_initialize","name":"$display_id"},{"line":216,"kind":13,"name":"$attrs","containerName":"_initialize"},{"kind":13,"line":216,"containerName":"_initialize","name":"$accnr"},{"name":"$accnr","containerName":"_initialize","line":216,"kind":13},{"kind":13,"line":217,"containerName":"_initialize","name":"$attrs"},{"containerName":"_initialize","name":"$seq","line":217,"kind":13},{"containerName":"_initialize","name":"$seq","kind":13,"line":217},{"containerName":"_initialize","name":"$taxon","kind":13,"line":218},{"line":219,"kind":13,"name":"$taxon","containerName":"_initialize"},{"line":219,"kind":13,"name":"$taxon","containerName":"_initialize"},{"name":"$attrs","containerName":"_initialize","line":221,"kind":13},{"name":"$taxon","containerName":"_initialize","kind":13,"line":221},{"containerName":"_initialize","name":"$attrs","line":224,"kind":13},{"name":"new","containerName":"_initialize","kind":12,"line":224},{"kind":13,"line":225,"containerName":"_initialize","name":"$taxon"},{"kind":13,"line":228,"containerName":"_initialize","name":"$self"},{"kind":12,"line":228,"name":"attribute_map","containerName":"_initialize"},{"line":228,"kind":13,"containerName":"_initialize","name":"$attrs"},{"kind":13,"line":231,"containerName":"_initialize","name":"$useann"},{"kind":13,"line":231,"containerName":"_initialize","name":"$useann"},{"kind":13,"line":234,"name":"$useann","containerName":"_initialize"},{"name":"$useann","containerName":"_initialize","line":235,"kind":13},{"line":236,"kind":13,"name":"$useann","containerName":"_initialize"},{"name":"$useann","containerName":"_initialize","line":237,"kind":13},{"name":"$useann","containerName":"_initialize","kind":13,"line":240},{"line":241,"kind":13,"localvar":"my","containerName":"_initialize","definition":"my","name":"$ann_map"},{"line":242,"kind":13,"name":"$useann","containerName":"_initialize"},{"localvar":"my","containerName":"_initialize","name":"$has_header","definition":"my","line":243,"kind":13},{"name":"$self","containerName":"_initialize","kind":13,"line":243},{"name":"header","containerName":"_initialize","line":243,"kind":12},{"line":244,"kind":13,"containerName":"_initialize","name":"$ann_map"},{"line":245,"kind":13,"localvar":"my","containerName":"_initialize","definition":"my","name":"$i"},{"line":245,"kind":13,"name":"$useann","containerName":"_initialize"},{"line":246,"kind":13,"containerName":"_initialize","name":"$ann_map"},{"containerName":"_initialize","name":"$i","line":246,"kind":13},{"name":"$has_header","containerName":"_initialize","kind":13,"line":246},{"containerName":"_initialize","name":"$ann_map","kind":13,"line":250},{"name":"$useann","containerName":"_initialize","line":250,"kind":13},{"name":"$self","containerName":"_initialize","kind":13,"line":252},{"kind":12,"line":252,"name":"annotation_map","containerName":"_initialize"},{"containerName":"_initialize","name":"$ann_map","kind":13,"line":252},{"containerName":"_initialize","name":"$self","line":254,"kind":13},{"name":"keep_annotation","containerName":"_initialize","kind":12,"line":254},{"name":"$useann","containerName":"_initialize","kind":13,"line":254},{"containerName":"_initialize","name":"$colnames","kind":13,"line":254},{"line":256,"kind":13,"containerName":"_initialize","name":"$colnames"},{"line":256,"kind":13,"containerName":"_initialize","name":"$colnames"},{"line":258,"kind":13,"name":"$colnames","containerName":"_initialize"},{"containerName":"_initialize","name":"$colnames","line":259,"kind":13},{"line":259,"kind":13,"containerName":"_initialize","name":"$colnames"},{"containerName":"_initialize","name":"$self","kind":13,"line":261},{"line":261,"kind":12,"containerName":"_initialize","name":"annotation_columns"},{"kind":13,"line":261,"name":"$colnames","containerName":"_initialize"},{"line":261,"kind":13,"containerName":"_initialize","name":"$colnames"},{"kind":13,"line":265,"name":"$self","containerName":"_initialize"},{"line":265,"kind":12,"containerName":"_initialize","name":"sequence_factory"},{"kind":13,"line":266,"name":"$self","containerName":"_initialize"},{"name":"sequence_factory","containerName":"_initialize","line":266,"kind":12},{"kind":12,"line":267,"name":"new","containerName":"_initialize"},{"line":267,"kind":13,"name":"$self","containerName":"_initialize"},{"name":"verbose","containerName":"_initialize","kind":12,"line":267}]},{"containerName":"_initialize","name":"SUPER","kind":12,"line":180},{"name":"Bio","containerName":"Species","kind":12,"line":224},{"kind":12,"line":267,"containerName":"Seq::SeqFactory","name":"Bio"},{"children":[{"line":283,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"next_seq"},{"containerName":"next_seq","name":"$line_ok","definition":"my","localvar":"my","kind":13,"line":286},{"containerName":"next_seq","name":"$self","line":286,"kind":13},{"line":286,"kind":12,"containerName":"next_seq","name":"_next_record"},{"kind":13,"line":289,"containerName":"next_seq","name":"$line_ok"},{"name":"$self","containerName":"next_seq","kind":13,"line":289},{"line":289,"kind":12,"containerName":"next_seq","name":"_header_skipped"},{"line":289,"kind":13,"containerName":"next_seq","name":"$self"},{"line":289,"kind":12,"name":"header","containerName":"next_seq"},{"kind":13,"line":290,"name":"$line_ok","containerName":"next_seq"},{"line":290,"kind":13,"name":"$self","containerName":"next_seq"},{"name":"_parse_header","containerName":"next_seq","kind":12,"line":290},{"kind":13,"line":291,"name":"$self","containerName":"next_seq"},{"containerName":"next_seq","name":"_header_skipped","kind":12,"line":291},{"containerName":"next_seq","name":"$line_ok","kind":13,"line":295},{"kind":13,"line":300,"containerName":"next_seq","definition":"my","name":"@cols","localvar":"my"},{"containerName":"next_seq","name":"$self","line":300,"kind":13},{"kind":12,"line":300,"containerName":"next_seq","name":"_get_row_values"},{"containerName":"next_seq","name":"$self","line":302,"kind":13},{"name":"trim_values","containerName":"next_seq","line":302,"kind":12},{"containerName":"next_seq","definition":"my","name":"$i","localvar":"my","kind":13,"line":303},{"kind":13,"line":303,"containerName":"next_seq","name":"$i"},{"containerName":"next_seq","name":"@cols","kind":13,"line":303},{"containerName":"next_seq","name":"$i","kind":13,"line":303},{"line":304,"kind":13,"name":"$cols","containerName":"next_seq"},{"kind":13,"line":304,"name":"$i","containerName":"next_seq"},{"line":306,"kind":13,"name":"$cols","containerName":"next_seq"},{"containerName":"next_seq","name":"$i","line":306,"kind":13},{"containerName":"next_seq","name":"$cols","line":307,"kind":13},{"kind":13,"line":307,"name":"$i","containerName":"next_seq"},{"containerName":"next_seq","name":"$cols","line":309,"kind":13},{"kind":13,"line":309,"name":"$i","containerName":"next_seq"},{"line":310,"kind":13,"name":"$cols","containerName":"next_seq"},{"containerName":"next_seq","name":"$i","kind":13,"line":310},{"kind":13,"line":316,"containerName":"next_seq","definition":"my","name":"$attrmap","localvar":"my"},{"name":"$self","containerName":"next_seq","kind":13,"line":316},{"line":316,"kind":12,"containerName":"next_seq","name":"_attribute_map"},{"containerName":"next_seq","name":"%params","definition":"my","localvar":"my","kind":13,"line":317},{"line":318,"kind":13,"localvar":"my","containerName":"next_seq","definition":"my","name":"$attr"},{"containerName":"next_seq","name":"$attrmap","kind":13,"line":318},{"name":"$attrmap","containerName":"next_seq","kind":13,"line":319},{"line":319,"kind":13,"containerName":"next_seq","name":"$attr"},{"name":"$attrmap","containerName":"next_seq","kind":13,"line":319},{"containerName":"next_seq","name":"$attr","kind":13,"line":319},{"name":"$params","containerName":"next_seq","kind":13,"line":321},{"name":"$attr","containerName":"next_seq","kind":13,"line":321},{"name":"$cols","containerName":"next_seq","kind":13,"line":321},{"line":321,"kind":13,"containerName":"next_seq","name":"$attrmap"},{"name":"$attr","containerName":"next_seq","kind":13,"line":321},{"name":"$params","containerName":"next_seq","line":324,"kind":13},{"containerName":"next_seq","name":"$attr","kind":13,"line":324},{"containerName":"next_seq","name":"$attrmap","kind":13,"line":324},{"line":324,"kind":13,"containerName":"next_seq","name":"$attr"},{"localvar":"my","definition":"my","name":"$annmap","containerName":"next_seq","line":329,"kind":13},{"line":329,"kind":13,"containerName":"next_seq","name":"$self"},{"kind":12,"line":329,"containerName":"next_seq","name":"_annotation_map"},{"kind":13,"line":330,"containerName":"next_seq","name":"$annmap"},{"containerName":"next_seq","name":"$annmap","kind":13,"line":330},{"kind":13,"line":331,"definition":"my","name":"$anncoll","containerName":"next_seq","localvar":"my"},{"kind":12,"line":331,"name":"new","containerName":"next_seq"},{"containerName":"next_seq","definition":"my","name":"$col","localvar":"my","kind":13,"line":332},{"line":332,"kind":13,"containerName":"next_seq","name":"$annmap"},{"containerName":"next_seq","name":"$cols","kind":13,"line":333},{"kind":13,"line":333,"name":"$col","containerName":"next_seq"},{"kind":13,"line":334,"containerName":"next_seq","name":"$anncoll"},{"kind":12,"line":334,"containerName":"next_seq","name":"add_Annotation"},{"line":335,"kind":12,"containerName":"next_seq","name":"new"},{"containerName":"next_seq","name":"$cols","kind":13,"line":335},{"line":335,"kind":13,"containerName":"next_seq","name":"$col"},{"name":"$annmap","containerName":"next_seq","line":336,"kind":13},{"containerName":"next_seq","name":"$col","kind":13,"line":336},{"containerName":"next_seq","name":"$params","kind":13,"line":338},{"name":"$anncoll","containerName":"next_seq","line":338,"kind":13},{"line":342,"kind":13,"localvar":"my","containerName":"next_seq","definition":"my","name":"$builder"},{"containerName":"next_seq","name":"$self","kind":13,"line":342},{"line":342,"kind":12,"name":"sequence_builder","containerName":"next_seq"},{"line":343,"kind":13,"name":"$builder","containerName":"next_seq"},{"line":343,"kind":12,"containerName":"next_seq","name":"add_slot_value"},{"name":"%params","containerName":"next_seq","line":343,"kind":13},{"kind":13,"line":345,"definition":"my","name":"$seq","containerName":"next_seq","localvar":"my"},{"containerName":"next_seq","name":"$builder","kind":13,"line":345},{"line":345,"kind":12,"containerName":"next_seq","name":"make_object"},{"name":"$seq","containerName":"next_seq","kind":13,"line":348}],"line":282,"kind":12,"range":{"end":{"line":349,"character":9999},"start":{"line":282,"character":0}},"definition":"sub","name":"next_seq","containerName":"main::"},{"containerName":"Annotation::Collection","name":"Bio","kind":12,"line":331},{"name":"Bio","containerName":"Annotation::SimpleValue","kind":12,"line":335},{"line":364,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"comment_char","line":365,"kind":13},{"containerName":"comment_char","name":"$self","kind":13,"line":367},{"containerName":"comment_char","name":"$self","line":368,"kind":13}],"kind":12,"range":{"end":{"line":369,"character":9999},"start":{"line":364,"character":0}},"containerName":"main::","definition":"sub","name":"comment_char"},{"line":388,"children":[{"containerName":"header","name":"$self","definition":"my","localvar":"my","kind":13,"line":389},{"name":"$self","containerName":"header","line":391,"kind":13},{"name":"$self","containerName":"header","kind":13,"line":392}],"kind":12,"range":{"start":{"line":388,"character":0},"end":{"character":9999,"line":393}},"containerName":"main::","definition":"sub","name":"header"},{"kind":12,"line":410,"children":[{"definition":"my","name":"$self","containerName":"delimiter","localvar":"my","kind":13,"line":411},{"kind":13,"line":413,"containerName":"delimiter","name":"$self"},{"kind":13,"line":414,"name":"$self","containerName":"delimiter"}],"containerName":"main::","definition":"sub","name":"delimiter","range":{"end":{"character":9999,"line":415},"start":{"line":410,"character":0}}},{"kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"attribute_map","line":436,"kind":13},{"kind":13,"line":441,"name":"$arg","definition":"my","containerName":"attribute_map","localvar":"my"},{"line":443,"kind":13,"name":"$self","containerName":"attribute_map"},{"line":443,"kind":13,"containerName":"attribute_map","name":"$arg"},{"localvar":"my","containerName":"attribute_map","definition":"my","name":"$attr_map","line":445,"kind":13},{"containerName":"attribute_map","name":"$arg","line":445,"kind":13},{"localvar":"my","definition":"my","name":"$key","containerName":"attribute_map","line":446,"kind":13},{"name":"$attr_map","containerName":"attribute_map","kind":13,"line":446},{"line":447,"kind":13,"containerName":"attribute_map","name":"$attr_map"},{"kind":13,"line":447,"name":"$key","containerName":"attribute_map"},{"line":447,"kind":13,"name":"$attr_map","containerName":"attribute_map"},{"name":"$key","containerName":"attribute_map","line":447,"kind":13},{"line":448,"kind":13,"containerName":"attribute_map","name":"$attr_map"},{"containerName":"attribute_map","name":"$key","line":448,"kind":13},{"kind":13,"line":451,"name":"$self","containerName":"attribute_map"},{"name":"$attr_map","containerName":"attribute_map","kind":13,"line":451},{"kind":13,"line":454,"name":"$self","containerName":"attribute_map"},{"localvar":"my","containerName":"attribute_map","definition":"my","name":"%attr_map","line":456,"kind":13},{"name":"$self","containerName":"attribute_map","kind":13,"line":456}],"line":435,"name":"attribute_map","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":435},"end":{"character":9999,"line":456}}},{"kind":13,"line":457,"containerName":null,"name":"$key","definition":"my","localvar":"my"},{"name":"%attr_map","containerName":null,"line":457,"kind":13},{"kind":13,"line":458,"name":"%attr_map","containerName":null},{"containerName":null,"name":"$key","line":458,"kind":13},{"line":458,"kind":13,"name":"%attr_map","containerName":null},{"containerName":null,"name":"%key","kind":13,"line":458},{"kind":13,"line":459,"containerName":null,"name":"%attr_map"},{"containerName":null,"name":"$key","line":459,"kind":13},{"name":"%attr_map","containerName":null,"kind":13,"line":462},{"kind":12,"line":488,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"annotation_map","line":489,"kind":13},{"localvar":"my","containerName":"annotation_map","name":"$arg","definition":"my","line":494,"kind":13},{"kind":13,"line":496,"containerName":"annotation_map","name":"$self"},{"line":496,"kind":13,"containerName":"annotation_map","name":"$arg"},{"line":498,"kind":13,"localvar":"my","containerName":"annotation_map","name":"$ann_map","definition":"my"},{"name":"$arg","containerName":"annotation_map","kind":13,"line":498},{"containerName":"annotation_map","definition":"my","name":"$key","localvar":"my","kind":13,"line":501},{"line":501,"kind":13,"name":"$a","containerName":"annotation_map"},{"name":"$b","containerName":"annotation_map","line":501,"kind":13},{"containerName":"annotation_map","name":"$ann_map","line":501,"kind":13},{"kind":13,"line":502,"containerName":"annotation_map","name":"$ann_map"},{"line":502,"kind":13,"containerName":"annotation_map","name":"$key"},{"containerName":"annotation_map","name":"$ann_map","line":502,"kind":13},{"kind":13,"line":502,"name":"$key","containerName":"annotation_map"},{"name":"$ann_map","containerName":"annotation_map","kind":13,"line":503},{"containerName":"annotation_map","name":"$key","kind":13,"line":503},{"containerName":"annotation_map","name":"$self","kind":13,"line":505},{"kind":13,"line":505,"containerName":"annotation_map","name":"$ann_map"},{"kind":13,"line":507,"containerName":"annotation_map","name":"$self"},{"kind":12,"line":507,"name":"keep_annotation","containerName":"annotation_map"},{"containerName":"annotation_map","name":"$self","line":510,"kind":13},{"containerName":"annotation_map","definition":"my","name":"%ann_map","localvar":"my","kind":13,"line":512},{"name":"$self","containerName":"annotation_map","kind":13,"line":512}],"containerName":"main::","definition":"sub","name":"annotation_map","range":{"start":{"line":488,"character":0},"end":{"character":9999,"line":512}}},{"localvar":"my","containerName":null,"definition":"my","name":"%key","line":514,"kind":13},{"line":514,"kind":13,"name":"$b","containerName":null},{"name":"$a","containerName":null,"line":514,"kind":13},{"name":"%ann_map","containerName":null,"line":514,"kind":13},{"line":515,"kind":13,"name":"%ann_map","containerName":null},{"name":"$key","containerName":null,"kind":13,"line":515},{"line":515,"kind":13,"containerName":null,"name":"%ann_map"},{"containerName":null,"name":"$key","line":515,"kind":13},{"line":516,"kind":13,"name":"%ann_map","containerName":null},{"name":"$key","containerName":null,"kind":13,"line":516},{"kind":13,"line":518,"containerName":null,"name":"%ann_map"},{"kind":12,"line":538,"children":[{"line":539,"kind":13,"localvar":"my","containerName":"keep_annotation","name":"$self","definition":"my"},{"kind":13,"line":541,"name":"$self","containerName":"keep_annotation"},{"kind":13,"line":542,"name":"$self","containerName":"keep_annotation"}],"containerName":"main::","name":"keep_annotation","definition":"sub","range":{"start":{"line":538,"character":0},"end":{"line":543,"character":9999}}},{"range":{"start":{"character":0,"line":564},"end":{"character":9999,"line":569}},"containerName":"main::","definition":"sub","name":"annotation_columns","line":564,"children":[{"localvar":"my","containerName":"annotation_columns","definition":"my","name":"$self","line":565,"kind":13},{"containerName":"annotation_columns","name":"$self","line":567,"kind":13},{"kind":13,"line":568,"containerName":"annotation_columns","name":"$self"}],"kind":12},{"line":584,"children":[{"line":585,"kind":13,"localvar":"my","containerName":"trim_values","name":"$self","definition":"my"},{"containerName":"trim_values","name":"$self","kind":13,"line":587},{"containerName":"trim_values","name":"$self","line":588,"kind":13}],"kind":12,"range":{"end":{"line":589,"character":9999},"start":{"character":0,"line":584}},"containerName":"main::","definition":"sub","name":"trim_values"},{"range":{"start":{"character":0,"line":617},"end":{"line":621,"character":9999}},"containerName":"main::","name":"_attribute_map","definition":"sub","line":617,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_attribute_map","line":618,"kind":13},{"line":620,"kind":13,"name":"$self","containerName":"_attribute_map"}],"kind":12},{"name":"_annotation_map","definition":"sub","containerName":"main::","range":{"end":{"line":645,"character":9999},"start":{"character":0,"line":641}},"kind":12,"children":[{"kind":13,"line":642,"containerName":"_annotation_map","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":644,"containerName":"_annotation_map","name":"$self"}],"line":641},{"range":{"start":{"line":660,"character":0},"end":{"line":665,"character":9999}},"name":"_header_skipped","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"_header_skipped","definition":"my","name":"$self","line":661,"kind":13},{"containerName":"_header_skipped","name":"$self","kind":13,"line":663},{"containerName":"_header_skipped","name":"$self","kind":13,"line":664}],"line":660,"kind":12},{"containerName":"main::","name":"_next_record","definition":"sub","range":{"start":{"character":0,"line":690},"end":{"character":9999,"line":704}},"kind":12,"line":690,"children":[{"definition":"my","name":"$self","containerName":"_next_record","localvar":"my","kind":13,"line":691},{"localvar":"my","definition":"my","name":"$cmtcc","containerName":"_next_record","line":693,"kind":13},{"line":693,"kind":13,"name":"$self","containerName":"_next_record"},{"kind":12,"line":693,"name":"comment_char","containerName":"_next_record"},{"localvar":"my","definition":"my","name":"$line","containerName":"_next_record","line":694,"kind":13},{"name":"$self","containerName":"_next_record","line":694,"kind":13},{"name":"_readline","containerName":"_next_record","kind":12,"line":694},{"line":697,"kind":13,"name":"$line","containerName":"_next_record"},{"containerName":"_next_record","name":"$cmtcc","line":698,"kind":13},{"kind":13,"line":698,"containerName":"_next_record","name":"$line"},{"containerName":"_next_record","name":"$line","line":699,"kind":13},{"containerName":"_next_record","name":"$line","kind":13,"line":700},{"kind":13,"line":700,"name":"$self","containerName":"_next_record"},{"name":"_readline","containerName":"_next_record","line":700,"kind":12},{"name":"$self","containerName":"_next_record","kind":13,"line":703},{"line":703,"kind":13,"containerName":"_next_record","name":"$line"}]},{"range":{"start":{"character":0,"line":742},"end":{"line":796,"character":9999}},"name":"_parse_header","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"_parse_header","definition":"my","name":"$self","line":743,"kind":13},{"line":747,"kind":13,"containerName":"_parse_header","name":"$self"},{"containerName":"_parse_header","name":"keep_annotation","kind":12,"line":747},{"line":748,"kind":13,"localvar":"my","definition":"my","name":"@colnames","containerName":"_parse_header"},{"containerName":"_parse_header","name":"$self","line":748,"kind":13},{"name":"_get_row_values","containerName":"_parse_header","kind":12,"line":748},{"line":750,"kind":13,"containerName":"_parse_header","name":"$self"},{"line":750,"kind":12,"name":"trim_values","containerName":"_parse_header"},{"containerName":"_parse_header","name":"@colnames","line":752,"kind":13},{"name":"@colnames","containerName":"_parse_header","line":752,"kind":13},{"line":754,"kind":13,"containerName":"_parse_header","name":"@colnames"},{"name":"@colnames","containerName":"_parse_header","kind":13,"line":754},{"localvar":"my","name":"$annmap","definition":"my","containerName":"_parse_header","line":757,"kind":13},{"line":757,"kind":13,"name":"$self","containerName":"_parse_header"},{"containerName":"_parse_header","name":"annotation_map","kind":12,"line":757},{"name":"$annmap","containerName":"_parse_header","line":758,"kind":13},{"kind":13,"line":760,"name":"$anncols","definition":"my","containerName":"_parse_header","localvar":"my"},{"containerName":"_parse_header","name":"$self","line":760,"kind":13},{"name":"annotation_columns","containerName":"_parse_header","kind":12,"line":760},{"kind":13,"line":762,"containerName":"_parse_header","definition":"my","name":"%colmap","localvar":"my"},{"line":762,"kind":13,"name":"@colnames","containerName":"_parse_header"},{"kind":13,"line":763,"containerName":"_parse_header","definition":"my","name":"$col","localvar":"my"},{"containerName":"_parse_header","name":"$anncols","line":763,"kind":13},{"line":764,"kind":13,"containerName":"_parse_header","name":"$colmap"},{"containerName":"_parse_header","name":"$col","line":764,"kind":13},{"containerName":"_parse_header","name":"$self","kind":13,"line":765},{"kind":12,"line":765,"containerName":"_parse_header","name":"throw"},{"line":769,"kind":13,"name":"%colmap","containerName":"_parse_header"},{"line":769,"kind":13,"name":"$anncols","containerName":"_parse_header"},{"kind":13,"line":770,"name":"$i","definition":"my","containerName":"_parse_header","localvar":"my"},{"line":770,"kind":13,"containerName":"_parse_header","name":"$i"},{"name":"@colnames","containerName":"_parse_header","kind":13,"line":770},{"containerName":"_parse_header","name":"$i","kind":13,"line":770},{"kind":13,"line":771,"containerName":"_parse_header","name":"$colmap"},{"kind":13,"line":771,"containerName":"_parse_header","name":"$colnames"},{"kind":13,"line":771,"name":"$i","containerName":"_parse_header"},{"line":772,"kind":13,"containerName":"_parse_header","name":"$annmap"},{"line":772,"kind":13,"name":"$i","containerName":"_parse_header"},{"line":772,"kind":13,"containerName":"_parse_header","name":"$colnames"},{"containerName":"_parse_header","name":"$i","kind":13,"line":772},{"kind":13,"line":777,"containerName":"_parse_header","definition":"my","name":"$i","localvar":"my"},{"containerName":"_parse_header","name":"$i","kind":13,"line":777},{"name":"@colnames","containerName":"_parse_header","kind":13,"line":777},{"containerName":"_parse_header","name":"$i","kind":13,"line":777},{"name":"$annmap","containerName":"_parse_header","kind":13,"line":778},{"kind":13,"line":778,"name":"$i","containerName":"_parse_header"},{"containerName":"_parse_header","name":"$colnames","kind":13,"line":778},{"containerName":"_parse_header","name":"$i","line":778,"kind":13},{"kind":13,"line":781,"definition":"my","name":"$attrcol","containerName":"_parse_header","localvar":"my"},{"containerName":"_parse_header","name":"$self","kind":13,"line":781},{"kind":12,"line":781,"containerName":"_parse_header","name":"attribute_map"},{"kind":13,"line":782,"containerName":"_parse_header","name":"$attrcol"},{"containerName":"_parse_header","name":"$attrcol","kind":13,"line":782},{"line":783,"kind":13,"name":"$annmap","containerName":"_parse_header"},{"kind":13,"line":783,"name":"$attrcol","containerName":"_parse_header"},{"name":"$i","definition":"my","containerName":"_parse_header","localvar":"my","kind":13,"line":789},{"kind":13,"line":789,"name":"$i","containerName":"_parse_header"},{"name":"@colnames","containerName":"_parse_header","kind":13,"line":789},{"kind":13,"line":789,"name":"$i","containerName":"_parse_header"},{"line":790,"kind":13,"name":"$annmap","containerName":"_parse_header"},{"name":"$i","containerName":"_parse_header","kind":13,"line":790},{"containerName":"_parse_header","name":"$annmap","kind":13,"line":790},{"name":"$i","containerName":"_parse_header","kind":13,"line":790},{"containerName":"_parse_header","name":"$annmap","kind":13,"line":791},{"kind":13,"line":791,"name":"$i","containerName":"_parse_header"},{"line":791,"kind":13,"containerName":"_parse_header","name":"$colnames"},{"line":791,"kind":13,"name":"$i","containerName":"_parse_header"},{"line":795,"kind":13,"name":"$self","containerName":"_parse_header"},{"kind":12,"line":795,"name":"annotation_map","containerName":"_parse_header"},{"name":"$annmap","containerName":"_parse_header","kind":13,"line":795}],"line":742,"kind":12},{"line":799,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$header_lines"},{"containerName":null,"name":"$self","line":799,"kind":13},{"kind":12,"line":799,"containerName":"main::","name":"header"},{"kind":13,"line":800,"containerName":null,"name":"$line_ok","definition":"my","localvar":"my"},{"kind":13,"line":801,"name":"$line_ok","containerName":null},{"name":"%header_lines","containerName":null,"kind":13,"line":801},{"containerName":null,"name":"$line_ok","kind":13,"line":802},{"kind":13,"line":802,"name":"$self","containerName":null},{"containerName":"main::","name":"_next_record","kind":12,"line":802},{"name":"$header_lines","containerName":null,"line":803,"kind":13},{"containerName":null,"name":"$line_ok","kind":13,"line":806},{"line":827,"children":[{"kind":13,"line":828,"definition":"my","name":"$self","containerName":"_get_row_values","localvar":"my"},{"containerName":"_get_row_values","name":"$delim","definition":"my","localvar":"my","kind":13,"line":829},{"containerName":"_get_row_values","name":"$self","line":829,"kind":13},{"name":"delimiter","containerName":"_get_row_values","line":829,"kind":12},{"line":830,"kind":13,"localvar":"my","definition":"my","name":"$line","containerName":"_get_row_values"},{"containerName":"_get_row_values","name":"$self","kind":13,"line":830},{"line":831,"kind":13,"containerName":"_get_row_values","name":"$line"},{"definition":"my","name":"@cols","containerName":"_get_row_values","localvar":"my","kind":13,"line":832},{"name":"$line","containerName":"_get_row_values","line":832,"kind":13},{"name":"@cols","containerName":"_get_row_values","kind":13,"line":833}],"kind":12,"range":{"start":{"character":0,"line":827},"end":{"character":9999,"line":834}},"containerName":"main::","name":"_get_row_values","definition":"sub"}]}