{"vars":[{"line":96,"kind":2,"name":"vars","containerName":""},{"containerName":"","name":"base","kind":2,"line":101},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$caller"},{"label":"@args"}],"documentation":"1;\n# $Id: RichSeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::RichSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::RichSeq - Module implementing a sequence created from a rich\nsequence database entry\n\n=head1 SYNOPSIS\n\nSee L<Bio::Seq::RichSeqI> and documentation of methods.\n\n=head1 DESCRIPTION\n\nThis module implements Bio::Seq::RichSeqI, an interface for sequences\ncreated from or created for entries from/of rich sequence databanks,\nlike EMBL, GenBank, and SwissProt. Methods added to the Bio::SeqI\ninterface therefore focus on databank-specific information. Note that\nnot every rich databank format may use all of the properties provided.\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* Bio::Seq::RichSeqI\n\nNote that this includes implementing Bio::PrimarySeqI and Bio::SeqI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::RichSeq;\nuse vars qw($AUTOLOAD);\nuse strict;\n\n\n\nuse base qw(Bio::Seq Bio::Seq::RichSeqI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $seq    = Bio::Seq::RichSeq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                             -id  => 'human_id',\n\t\t\t\t             -accession_number => 'AL000012',\n\t\t\t\t            );\n\n Function: Returns a new seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number\n Returns : a new Bio::Seq::RichSeq object","label":"new($caller,@args)"},"detail":"($caller,@args)","kind":12,"children":[{"line":121,"kind":13,"localvar":"my","containerName":"new","name":"$caller","definition":"my"},{"name":"@args","containerName":"new","kind":13,"line":121},{"line":122,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"new"},{"kind":13,"line":122,"containerName":"new","name":"$caller"},{"containerName":"new","name":"@args","line":122,"kind":13},{"kind":13,"line":124,"containerName":"new","name":"$self"},{"kind":13,"line":125,"containerName":"new","name":"$self"},{"localvar":"my","containerName":"new","definition":"my","name":"$dates","line":127,"kind":13},{"name":"$xtra","containerName":"new","kind":13,"line":127},{"line":127,"kind":13,"name":"$sv","containerName":"new"},{"kind":13,"line":128,"containerName":"new","name":"$keywords"},{"line":128,"kind":13,"containerName":"new","name":"$pid"},{"containerName":"new","name":"$mol","line":128,"kind":13},{"containerName":"new","name":"$division","line":129,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":129},{"kind":12,"line":129,"containerName":"new","name":"_rearrange"},{"line":137,"kind":13,"name":"@args","containerName":"new"},{"containerName":"new","name":"$division","line":138,"kind":13},{"kind":13,"line":138,"containerName":"new","name":"$self"},{"name":"division","containerName":"new","line":138,"kind":12},{"containerName":"new","name":"$division","kind":13,"line":138},{"kind":13,"line":139,"containerName":"new","name":"$mol"},{"line":139,"kind":13,"name":"$self","containerName":"new"},{"kind":12,"line":139,"name":"molecule","containerName":"new"},{"name":"$mol","containerName":"new","kind":13,"line":139},{"containerName":"new","name":"$keywords","line":140,"kind":13},{"line":141,"kind":13,"name":"$keywords","containerName":"new"},{"name":"$keywords","containerName":"new","line":141,"kind":13},{"kind":13,"line":142,"containerName":"new","name":"$self"},{"name":"add_keyword","containerName":"new","line":142,"kind":12},{"line":142,"kind":13,"name":"$keywords","containerName":"new"},{"containerName":"new","name":"$self","line":145,"kind":13},{"kind":12,"line":145,"name":"keywords","containerName":"new"},{"kind":13,"line":145,"name":"$keywords","containerName":"new"},{"line":148,"kind":13,"containerName":"new","name":"$sv"},{"containerName":"new","name":"$self","line":148,"kind":13},{"name":"seq_version","containerName":"new","kind":12,"line":148},{"kind":13,"line":148,"containerName":"new","name":"$sv"},{"containerName":"new","name":"$pid","line":149,"kind":13},{"line":149,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"pid","kind":12,"line":149},{"line":149,"kind":13,"containerName":"new","name":"$pid"},{"containerName":"new","name":"$dates","line":151,"kind":13},{"name":"$dates","containerName":"new","kind":13,"line":152},{"name":"$dates","containerName":"new","kind":13,"line":153},{"kind":13,"line":154,"containerName":"new","name":"$self"},{"line":154,"kind":12,"containerName":"new","name":"add_date"},{"kind":13,"line":157,"name":"$self","containerName":"new"},{"line":157,"kind":12,"name":"add_date","containerName":"new"},{"name":"$dates","containerName":"new","kind":13,"line":157},{"kind":13,"line":161,"containerName":"new","name":"$xtra"},{"line":162,"kind":13,"containerName":"new","name":"$xtra"},{"line":163,"kind":13,"containerName":"new","name":"$xtra"},{"containerName":"new","name":"$self","kind":13,"line":164},{"line":164,"kind":12,"name":"add_secondary_accession","containerName":"new"},{"name":"$self","containerName":"new","line":167,"kind":13},{"kind":12,"line":167,"containerName":"new","name":"add_secondary_accession"},{"line":167,"kind":13,"containerName":"new","name":"$xtra"},{"containerName":"new","name":"$self","line":171,"kind":13}],"line":119,"name":"new","range":{"end":{"character":9999,"line":172},"start":{"character":0,"line":119}}},{"containerName":"new","name":"SUPER","kind":12,"line":122},{"containerName":"main::","name":"division","definition":"sub","range":{"end":{"character":9999,"line":194},"start":{"character":0,"line":186}},"kind":12,"line":186,"children":[{"kind":13,"line":187,"definition":"my","name":"$obj","containerName":"division","localvar":"my"},{"kind":13,"line":189,"name":"$value","definition":"my","containerName":"division","localvar":"my"},{"kind":13,"line":190,"containerName":"division","name":"$obj"},{"containerName":"division","name":"$value","line":190,"kind":13},{"line":192,"kind":13,"containerName":"division","name":"$obj"}]},{"range":{"start":{"line":207,"character":0},"end":{"line":215,"character":9999}},"definition":"sub","name":"molecule","containerName":"main::","children":[{"line":208,"kind":13,"localvar":"my","name":"$obj","definition":"my","containerName":"molecule"},{"containerName":"molecule","name":"$value","definition":"my","localvar":"my","kind":13,"line":210},{"kind":13,"line":211,"containerName":"molecule","name":"$obj"},{"kind":13,"line":211,"name":"$value","containerName":"molecule"},{"containerName":"molecule","name":"$obj","kind":13,"line":213}],"line":207,"kind":12},{"kind":12,"line":234,"children":[{"kind":12,"line":235,"containerName":"add_date","name":"_add_annotation_value"}],"containerName":"main::","name":"add_date","definition":"sub","range":{"end":{"character":9999,"line":236},"start":{"character":0,"line":234}}},{"kind":12,"line":250,"children":[{"containerName":"get_dates","name":"_get_annotation_values","line":251,"kind":12}],"containerName":"main::","name":"get_dates","definition":"sub","range":{"end":{"character":9999,"line":252},"start":{"line":250,"character":0}}},{"range":{"start":{"character":0,"line":267},"end":{"line":272,"character":9999}},"containerName":"main::","definition":"sub","name":"pid","line":267,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"pid","line":268,"kind":13},{"line":270,"kind":13,"name":"$self","containerName":"pid"},{"kind":13,"line":271,"name":"$self","containerName":"pid"}],"kind":12},{"name":"accession","range":{"start":{"line":291,"character":0},"end":{"character":9999,"line":294}},"containerName":"main::","definition":"sub","detail":"($obj,@args)","signature":{"parameters":[{"label":"$obj"},{"label":"@args"}],"documentation":"1;\n# $Id: RichSeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::RichSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::RichSeq - Module implementing a sequence created from a rich\nsequence database entry\n\n=head1 SYNOPSIS\n\nSee L<Bio::Seq::RichSeqI> and documentation of methods.\n\n=head1 DESCRIPTION\n\nThis module implements Bio::Seq::RichSeqI, an interface for sequences\ncreated from or created for entries from/of rich sequence databanks,\nlike EMBL, GenBank, and SwissProt. Methods added to the Bio::SeqI\ninterface therefore focus on databank-specific information. Note that\nnot every rich databank format may use all of the properties provided.\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* Bio::Seq::RichSeqI\n\nNote that this includes implementing Bio::PrimarySeqI and Bio::SeqI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::RichSeq;\nuse vars qw($AUTOLOAD);\nuse strict;\n\n\n\nuse base qw(Bio::Seq Bio::Seq::RichSeqI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $seq    = Bio::Seq::RichSeq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                             -id  => 'human_id',\n\t\t\t\t             -accession_number => 'AL000012',\n\t\t\t\t            );\n\n Function: Returns a new seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number\n Returns : a new Bio::Seq::RichSeq object\n\n\nsub new {\n    # standard new call..\n    my($caller,@args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    \n    $self->{'_dates'} = [];\n    $self->{'_secondary_accession'} = [];\n\n    my ($dates, $xtra, $sv,\n\t$keywords, $pid, $mol, \n\t$division ) = $self->_rearrange([qw(DATES \n\t\t\t\t\t    SECONDARY_ACCESSIONS\n\t\t\t\t\t    SEQ_VERSION \n\t\t\t\t\t    KEYWORDS\n\t\t\t\t\t    PID\n\t\t\t\t\t    MOLECULE\n\t\t\t\t\t    DIVISION\n\t\t\t\t\t    )],\n\t\t\t\t\t@args);\n    defined $division && $self->division($division);\n    defined $mol && $self->molecule($mol);\n    if(defined($keywords)) {\n\tif(ref($keywords) && (ref($keywords) eq \"ARRAY\")) {\n\t    $self->add_keyword(@$keywords);\n\t} else {\n\t    # got a string - use the old API\n\t    $self->keywords($keywords);\n\t}\n    }\n    defined $sv && $self->seq_version($sv);\n    defined $pid && $self->pid($pid);\n\n    if( defined $dates ) {\n\tif( ref($dates) eq \"ARRAY\" ) {\n\t    foreach ( @$dates) {\n\t\t$self->add_date($_);\n\t    } \n\t} else { \n\t    $self->add_date($dates);\n\t}\n    }\n\n    if( defined $xtra ) {\n\tif( ref($xtra) eq \"ARRAY\" ) {\n\t    foreach ( @$xtra) {\n\t\t$self->add_secondary_accession($_);\n\t    } \n\t} else { \n\t    $self->add_secondary_accession($xtra);\n\t}\n    }\n    \n    return $self;\n}\n\n\n=head2 division\n\n Title   : division\n Usage   : $obj->division($newval)\n Function: \n Returns : value of division\n Args    : newvalue (optional)\n\n\n\nsub division {\n   my $obj = shift;\n   if( @_ ) {\n      my $value = shift;\n      $obj->{'_division'} = $value;\n    }\n    return $obj->{'_division'};\n\n}\n\n=head2 molecule\n\n Title   : molecule\n Usage   : $obj->molecule($newval)\n Function: \n Returns : type of molecule (DNA, mRNA)\n Args    : newvalue (optional)\n\n\n\nsub molecule {\n   my $obj = shift;\n   if( @_ ) {\n      my $value = shift;\n      $obj->{'_molecule'} = $value;\n    }\n    return $obj->{'_molecule'};\n\n}\n\n=head2 add_date\n\n Title   : add_date\n Usage   : $self->add_date($datestr)\n Function: adds one or more dates\n\n           This implementation stores dates as keyed annotation, the\n           key being 'date_changed'. You can take advantage of this\n           fact when accessing the annotation collection directly.\n\n Example :\n Returns : \n Args    : a date string or an array of such strings\n\n\n\nsub add_date {\n    return shift->_add_annotation_value('date_changed',@_);\n}\n\n=head2 get_dates\n\n Title   : get_dates\n Usage   : my @dates = $seq->get_dates;\n Function: Get the dates of the sequence (usually, when it was created and\n           changed.\n Returns : an array of date strings\n Args    :\n\n\n\nsub get_dates{\n    return shift->_get_annotation_values('date_changed');\n}\n\n\n=head2 pid\n\n Title   : pid\n Usage   : my $pid = $seq->pid();\n Function: Get (and set, depending on the implementation) the PID property\n           for the sequence.\n Returns : a string\n Args    :\n\n\n\nsub pid{\n    my $self = shift;\n\n    return $self->{'_pid'} = shift if @_;\n    return $self->{'_pid'};\n}\n\n\n=head2 accession\n\n Title   : accession\n Usage   : $obj->accession($newval)\n Function: Whilst the underlying sequence object does not \n           have an accession, so we need one here.\n\n           In this implementation this is merely a synonym for\n           accession_number().\n Example : \n Returns : value of accession\n Args    : newvalue (optional)","label":"accession($obj,@args)"},"kind":12,"line":291,"children":[{"kind":13,"line":292,"containerName":"accession","definition":"my","name":"$obj","localvar":"my"},{"containerName":"accession","name":"@args","line":292,"kind":13},{"name":"$obj","containerName":"accession","line":293,"kind":13},{"name":"accession_number","containerName":"accession","line":293,"kind":12},{"name":"@args","containerName":"accession","kind":13,"line":293}]},{"name":"add_secondary_accession","definition":"sub","containerName":"main::","range":{"start":{"line":314,"character":0},"end":{"line":316,"character":9999}},"kind":12,"children":[{"name":"_add_annotation_value","containerName":"add_secondary_accession","kind":12,"line":315}],"line":314},{"range":{"end":{"line":331,"character":9999},"start":{"line":329,"character":0}},"definition":"sub","name":"get_secondary_accessions","containerName":"main::","children":[{"name":"_get_annotation_values","containerName":"get_secondary_accessions","kind":12,"line":330}],"line":329,"kind":12},{"range":{"end":{"character":9999,"line":349},"start":{"character":0,"line":344}},"containerName":"main::","definition":"sub","name":"seq_version","line":344,"children":[{"localvar":"my","containerName":"seq_version","definition":"my","name":"$self","line":345,"kind":13},{"kind":13,"line":347,"name":"$self","containerName":"seq_version"},{"containerName":"seq_version","name":"$self","kind":13,"line":348}],"kind":12},{"definition":"sub","name":"add_keyword","containerName":"main::","range":{"end":{"character":9999,"line":370},"start":{"line":368,"character":0}},"kind":12,"children":[{"kind":12,"line":369,"containerName":"add_keyword","name":"_add_annotation_value"}],"line":368},{"range":{"end":{"line":385,"character":9999},"start":{"line":383,"character":0}},"name":"get_keywords","definition":"sub","containerName":"main::","children":[{"kind":12,"line":384,"containerName":"get_keywords","name":"_get_annotation_values"}],"line":383,"kind":12},{"definition":"sub","name":"_add_annotation_value","containerName":"main::","range":{"end":{"line":413,"character":9999},"start":{"line":403,"character":0}},"kind":12,"children":[{"line":404,"kind":13,"localvar":"my","containerName":"_add_annotation_value","name":"$self","definition":"my"},{"line":405,"kind":13,"localvar":"my","containerName":"_add_annotation_value","name":"$key","definition":"my"},{"line":407,"kind":13,"localvar":"my","containerName":"_add_annotation_value","definition":"my","name":"$val"},{"line":408,"kind":13,"name":"$self","containerName":"_add_annotation_value"},{"kind":12,"line":408,"name":"annotation","containerName":"_add_annotation_value"},{"kind":12,"line":408,"containerName":"_add_annotation_value","name":"add_Annotation"},{"kind":12,"line":409,"containerName":"_add_annotation_value","name":"new"},{"kind":13,"line":409,"name":"$key","containerName":"_add_annotation_value"},{"containerName":"_add_annotation_value","name":"$val","kind":13,"line":410}],"line":403},{"kind":12,"line":409,"containerName":"Annotation::SimpleValue","name":"Bio"},{"containerName":"main::","definition":"sub","name":"_get_annotation_values","range":{"end":{"line":433,"character":9999},"start":{"line":429,"character":0}},"kind":12,"line":429,"children":[{"localvar":"my","containerName":"_get_annotation_values","definition":"my","name":"$self","line":430,"kind":13},{"name":"value","containerName":"_get_annotation_values","line":432,"kind":12},{"containerName":"_get_annotation_values","name":"$self","line":432,"kind":13},{"containerName":"_get_annotation_values","name":"annotation","line":432,"kind":12},{"containerName":"_get_annotation_values","name":"get_Annotations","line":432,"kind":12}]},{"kind":12,"children":[{"kind":13,"line":442,"name":"$self","definition":"my","containerName":"keywords","localvar":"my"},{"line":447,"kind":13,"localvar":"my","name":"$kwd","definition":"my","containerName":"keywords"},{"name":"$self","containerName":"keywords","kind":13,"line":448},{"name":"add_keyword","containerName":"keywords","line":448,"kind":12},{"line":448,"kind":13,"name":"$kwd","containerName":"keywords"},{"name":"$self","containerName":"keywords","kind":13,"line":452},{"kind":12,"line":452,"name":"get_keywords","containerName":"keywords"}],"line":441,"name":"keywords","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":454},"start":{"line":441,"character":0}}},{"definition":"sub","containerName":"main::","signature":{"label":"each_date($self)","parameters":[{"label":"$self"}],"documentation":""},"detail":"($self)","kind":12,"children":[{"localvar":"my","containerName":"each_date","name":"$self","definition":"my","line":457,"kind":13},{"kind":13,"line":458,"name":"$self","containerName":"each_date"},{"kind":12,"line":458,"name":"warn","containerName":"each_date"},{"name":"$self","containerName":"each_date","line":459,"kind":13},{"kind":12,"line":459,"name":"get_dates","containerName":"each_date"}],"line":456,"name":"each_date","range":{"start":{"line":456,"character":0},"end":{"character":9999,"line":460}}},{"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"each_secondary_accession","line":464,"kind":13},{"name":"$self","containerName":"each_secondary_accession","line":465,"kind":13},{"line":465,"kind":12,"containerName":"each_secondary_accession","name":"warn"},{"line":466,"kind":13,"containerName":"each_secondary_accession","name":"$self"},{"containerName":"each_secondary_accession","name":"get_secondary_accessions","kind":12,"line":466}],"line":463,"kind":12,"signature":{"label":"each_secondary_accession($self)","documentation":"","parameters":[{"label":"$self"}]},"detail":"($self)","definition":"sub","containerName":"main::","range":{"end":{"line":468,"character":9999},"start":{"character":0,"line":463}},"name":"each_secondary_accession"},{"children":[{"line":471,"kind":13,"localvar":"my","definition":"my","name":"$obj","containerName":"sv"},{"line":471,"kind":13,"name":"$value","containerName":"sv"},{"kind":13,"line":472,"containerName":"sv","name":"$obj"},{"line":472,"kind":12,"name":"warn","containerName":"sv"},{"line":473,"kind":13,"containerName":"sv","name":"$obj"},{"line":473,"kind":12,"containerName":"sv","name":"seq_version"},{"containerName":"sv","name":"$value","kind":13,"line":473}],"line":470,"kind":12,"signature":{"parameters":[{"label":"$obj"},{"label":"$value"}],"documentation":"","label":"sv($obj,$value)"},"detail":"($obj,$value)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":474},"start":{"character":0,"line":470}},"name":"sv"}],"version":5}