{"version":5,"vars":[{"line":170,"kind":2,"name":"vars","containerName":""},{"containerName":"","name":"base","line":175,"kind":2},{"name":"$DEFAULT_NAME","containerName":null,"kind":13,"line":180},{"containerName":null,"name":"$GAP","line":181,"kind":13},{"line":182,"kind":13,"name":"$META_GAP","containerName":null},{"name":"new","range":{"end":{"line":225,"character":9999},"start":{"line":202,"character":0}},"definition":"sub","containerName":"main::","signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: Quality.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::Quality\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::Quality - Implementation of sequence with residue quality and trace values\n\n=head1 SYNOPSIS\n\n  use Bio::Seq::Quality;\n\n  # input can be space delimited string or array ref\n  my $qual = '0 1 2 3 4 5 6 7 8 9 11 12';\n  my $trace = '0 5 10 15 20 25 30 35 40 45 50 55';\n\n  my $seq = Bio::Seq::Quality->new\n      ( -qual => $qual,\n        -trace_indices => $trace,\n        -seq =>  'atcgatcgatcg',\n        -id  => 'human_id',\n        -accession_number => 'S000012',\n        -verbose => -1   # to silence deprecated methods\n  );\n\n  my $quals = $seq->qual; # array ref\n  my $traces = $seq->trace;  # array ref\n\n  my $quals = $seq->qual_text; # string\n  my $traces = $seq->trace_text; # string\n\n\n  # get sub values\n  $quals = $seq->subqual(2, 3);  # array ref\n  $traces = $seq->subtrace(2, 3); # array ref\n  $quals = $seq->subqual_text(2, 3); # string\n  $quals = $seq->subtrace_text(2, 3); # string\n\n  # set sub values \n  $seq->subqual(2, 3, \"9 9\");\n  $seq->subtrace(2, 3, \"9 9\");\n\n\n\n=head1 DESCRIPTION\n\nThis object stores base quality values together with the sequence\nstring.\n\nIt is a reimplementation of Chad Matsalla's Bio::Seq::SeqWithQuality\nmodule using Bio::Seq::MetaI. \n\nThe implementation is based on Bio::Seq::Meta::Array. qual() and\ntrace() are base methods to store and retrieve information that have\nextensions to retrieve values as a scalar (e.g. qual_text() ), or get\nor set subvalues (e.g. subqual() ). See L<Bio::Seq::MetaI> for more details.\n\nAll the functional code is in Bio::Seq::Meta::Array.\n\nThere deprecated methods that are included for compatibility with\nBio::Seq::SeqWithQuality. These will print a warning unless verbosity\nof the object is set to be less than zero.\n\n=head2 Differences from Bio::Seq::SeqWithQuality\n\nIt is not possible to fully follow the interface of\nBio::Seq::SeqWithQuality since internally a Bio::Seq::SeqWithQuality\nobject is a composite of two independent objects: a Bio::PrimarySeq\nobject and Bio::Seq::PrimaryQual object. Both of these objects can be\ncreated separately and merged into Bio::Seq::SeqWithQuality.\n\nThis implementation is based on Bio::Seq::Meta::Array that is a subclass\nof Bio::PrimarySeq that stores any number of meta information in\nunnamed arrays.\n\nHere we assume that two meta sets, called 'qual' and 'trace_indices' are\nattached to a sequence. (But there is nothing that prevents you to add\nas many named meta sets as you need using normal meta() methods).\n\nqual() is an alias to meta(), qualat($loc) is an alias to\nsubmeta($loc,$loc).\n\ntrace_indices() in Bio::Seq::SeqWithQuality has been abbreviated to\ntrace() and is an alias to named_meta('trace').\n\nYou can create an object without passing any arguments to the\nconstructor (Bio::Seq::SeqWithQuality fails without alphabet). It will\nwarn about not being able to set alphabet unless you set verbosity of\nthe object to a negative value.\n\nAfter the latest rewrite, the meta information sets (quality and\ntrace) no longer cover all the residues automatically. Methods to\ncheck the length of meta information (L<quality_length>,\nL<trace_length>)and to see if the ends are flushed to the sequence\nhave been added (L<quality_is_flush>, L<trace_is_flush>). To force\nthe old functinality, set L<force_flush> to true.\n\nqual_obj() and seq_obj() methods do not exist!\n\nFinally, there is only one set of descriptors (primary_id, display_id,\naccession_number) for the object.\n\n\n=head1 SEE ALSO\n\nL<Bio::Seq::MetaI>, \nL<Bio::Seq::Meta::Array>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nChad Matsalla, bioinformatics at dieselwurks dot com\n\nDan Bolser, dan dot bolser at gmail dot com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::Quality;\nuse vars qw($DEFAULT_NAME $GAP $META_GAP);\nuse strict;\n\n#use overload '\"\"' => \\&to_string;\n\nuse base qw(Bio::Seq::Meta::Array);\n\n\nBEGIN {\n\n    $DEFAULT_NAME = 'DEFAULT';\n    $GAP = '-';\n    $META_GAP = ' ';\n}\n\n=head2 new\n\n Title   : new\n Usage   : $metaseq = Bio::Seq::Quality->new\n\t        ( -qual => '0 1 2 3 4 5 6 7 8 9 11 12',\n                  -trace => '0 5 10 15 20 25 30 35 40 45 50 55',\n                  -seq =>  'atcgatcgatcg',\n\t          -id  => 'human_id',\n\t          -accession_number => 'S000012',\n\t        );\n Function: Constructor for Bio::Seq::Quality class.\n           Note that you can provide an empty quality and trace strings.\n Returns : a new Bio::Seq::Quality object","parameters":[{"label":"$class"},{"label":"@args"}]},"detail":"($class,@args)","kind":12,"children":[{"kind":13,"line":203,"definition":"my","name":"$class","containerName":"new","localvar":"my"},{"line":203,"kind":13,"name":"@args","containerName":"new"},{"kind":13,"line":205,"name":"$self","definition":"my","containerName":"new","localvar":"my"},{"containerName":"new","name":"$class","kind":13,"line":205},{"line":205,"kind":13,"containerName":"new","name":"@args"},{"localvar":"my","containerName":"new","name":"$meta","definition":"my","line":207,"kind":13},{"containerName":"new","name":"$qual","kind":13,"line":207},{"name":"$trace","containerName":"new","kind":13,"line":207},{"kind":13,"line":207,"name":"$trace_indices","containerName":"new"},{"containerName":"new","name":"$trace_data","kind":13,"line":207},{"kind":13,"line":208,"name":"$self","containerName":"new"},{"kind":12,"line":208,"containerName":"new","name":"_rearrange"},{"kind":13,"line":213,"name":"@args","containerName":"new"},{"line":215,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"$DEFAULT_NAME","line":215,"kind":13},{"line":216,"kind":13,"containerName":"new","name":"$self"},{"kind":13,"line":217,"containerName":"new","name":"$self"},{"name":"$trace_data","containerName":"new","line":217,"kind":13},{"containerName":"new","name":"$meta","line":219,"kind":13},{"name":"$self","containerName":"new","line":219,"kind":13},{"containerName":"new","name":"meta","kind":12,"line":219},{"line":219,"kind":13,"name":"$meta","containerName":"new"},{"containerName":"new","name":"$qual","kind":13,"line":220},{"name":"$self","containerName":"new","line":220,"kind":13},{"name":"qual","containerName":"new","kind":12,"line":220},{"name":"$qual","containerName":"new","line":220,"kind":13},{"kind":13,"line":221,"name":"$trace","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":221},{"line":221,"kind":12,"name":"named_meta","containerName":"new"},{"name":"$trace","containerName":"new","line":221,"kind":13},{"name":"$trace_indices","containerName":"new","line":222,"kind":13},{"kind":13,"line":222,"name":"$self","containerName":"new"},{"kind":12,"line":222,"name":"named_meta","containerName":"new"},{"containerName":"new","name":"$trace_indices","kind":13,"line":222},{"containerName":"new","name":"$self","line":224,"kind":13}],"line":202},{"kind":12,"line":205,"containerName":"new","name":"SUPER"},{"name":"trace_data","line":217,"kind":12},{"kind":12,"line":249,"children":[{"definition":"my","name":"$self","containerName":"qual","localvar":"my","kind":13,"line":250},{"containerName":"qual","definition":"my","name":"$value","localvar":"my","kind":13,"line":251},{"line":252,"kind":13,"containerName":"qual","name":"$value"},{"containerName":"qual","name":"$value","kind":13,"line":252},{"kind":12,"line":253,"containerName":"qual","name":"qual"},{"name":"$value","containerName":"qual","kind":13,"line":253},{"kind":13,"line":253,"containerName":"qual","name":"$value"},{"line":254,"kind":13,"containerName":"qual","name":"$value"},{"line":254,"kind":12,"containerName":"qual","name":"isa"},{"line":255,"kind":13,"name":"$self","containerName":"qual"},{"line":255,"kind":12,"name":"_empty_cache","containerName":"qual"},{"containerName":"qual","name":"$value","kind":13,"line":255},{"containerName":"qual","name":"$self","kind":13,"line":256},{"name":"named_meta","containerName":"qual","kind":12,"line":256},{"containerName":"qual","name":"$DEFAULT_NAME","kind":13,"line":256},{"name":"$value","containerName":"qual","kind":13,"line":256}],"containerName":"main::","name":"qual","definition":"sub","range":{"start":{"character":0,"line":249},"end":{"line":257,"character":9999}}},{"range":{"end":{"character":9999,"line":271},"start":{"line":270,"character":0}},"containerName":"main::","definition":"sub","name":"qual_text","line":270,"children":[{"containerName":"qual_text","name":"submeta","kind":12,"line":271}],"kind":12},{"kind":12,"line":271,"name":"shift"},{"kind":12,"children":[{"kind":12,"line":298,"name":"named_submeta","containerName":"subqual"},{"kind":13,"line":298,"name":"$DEFAULT_NAME","containerName":"subqual"}],"line":297,"name":"subqual","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":299},"start":{"line":297,"character":0}}},{"range":{"end":{"line":313,"character":9999},"start":{"character":0,"line":312}},"containerName":"main::","definition":"sub","name":"subqual_text","line":312,"children":[{"kind":12,"line":313,"containerName":"subqual_text","name":"submeta"}],"kind":12},{"name":"shift","line":313,"kind":12},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"quality_length($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Quality.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::Quality\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::Quality - Implementation of sequence with residue quality and trace values\n\n=head1 SYNOPSIS\n\n  use Bio::Seq::Quality;\n\n  # input can be space delimited string or array ref\n  my $qual = '0 1 2 3 4 5 6 7 8 9 11 12';\n  my $trace = '0 5 10 15 20 25 30 35 40 45 50 55';\n\n  my $seq = Bio::Seq::Quality->new\n      ( -qual => $qual,\n        -trace_indices => $trace,\n        -seq =>  'atcgatcgatcg',\n        -id  => 'human_id',\n        -accession_number => 'S000012',\n        -verbose => -1   # to silence deprecated methods\n  );\n\n  my $quals = $seq->qual; # array ref\n  my $traces = $seq->trace;  # array ref\n\n  my $quals = $seq->qual_text; # string\n  my $traces = $seq->trace_text; # string\n\n\n  # get sub values\n  $quals = $seq->subqual(2, 3);  # array ref\n  $traces = $seq->subtrace(2, 3); # array ref\n  $quals = $seq->subqual_text(2, 3); # string\n  $quals = $seq->subtrace_text(2, 3); # string\n\n  # set sub values \n  $seq->subqual(2, 3, \"9 9\");\n  $seq->subtrace(2, 3, \"9 9\");\n\n\n\n=head1 DESCRIPTION\n\nThis object stores base quality values together with the sequence\nstring.\n\nIt is a reimplementation of Chad Matsalla's Bio::Seq::SeqWithQuality\nmodule using Bio::Seq::MetaI. \n\nThe implementation is based on Bio::Seq::Meta::Array. qual() and\ntrace() are base methods to store and retrieve information that have\nextensions to retrieve values as a scalar (e.g. qual_text() ), or get\nor set subvalues (e.g. subqual() ). See L<Bio::Seq::MetaI> for more details.\n\nAll the functional code is in Bio::Seq::Meta::Array.\n\nThere deprecated methods that are included for compatibility with\nBio::Seq::SeqWithQuality. These will print a warning unless verbosity\nof the object is set to be less than zero.\n\n=head2 Differences from Bio::Seq::SeqWithQuality\n\nIt is not possible to fully follow the interface of\nBio::Seq::SeqWithQuality since internally a Bio::Seq::SeqWithQuality\nobject is a composite of two independent objects: a Bio::PrimarySeq\nobject and Bio::Seq::PrimaryQual object. Both of these objects can be\ncreated separately and merged into Bio::Seq::SeqWithQuality.\n\nThis implementation is based on Bio::Seq::Meta::Array that is a subclass\nof Bio::PrimarySeq that stores any number of meta information in\nunnamed arrays.\n\nHere we assume that two meta sets, called 'qual' and 'trace_indices' are\nattached to a sequence. (But there is nothing that prevents you to add\nas many named meta sets as you need using normal meta() methods).\n\nqual() is an alias to meta(), qualat($loc) is an alias to\nsubmeta($loc,$loc).\n\ntrace_indices() in Bio::Seq::SeqWithQuality has been abbreviated to\ntrace() and is an alias to named_meta('trace').\n\nYou can create an object without passing any arguments to the\nconstructor (Bio::Seq::SeqWithQuality fails without alphabet). It will\nwarn about not being able to set alphabet unless you set verbosity of\nthe object to a negative value.\n\nAfter the latest rewrite, the meta information sets (quality and\ntrace) no longer cover all the residues automatically. Methods to\ncheck the length of meta information (L<quality_length>,\nL<trace_length>)and to see if the ends are flushed to the sequence\nhave been added (L<quality_is_flush>, L<trace_is_flush>). To force\nthe old functinality, set L<force_flush> to true.\n\nqual_obj() and seq_obj() methods do not exist!\n\nFinally, there is only one set of descriptors (primary_id, display_id,\naccession_number) for the object.\n\n\n=head1 SEE ALSO\n\nL<Bio::Seq::MetaI>, \nL<Bio::Seq::Meta::Array>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nChad Matsalla, bioinformatics at dieselwurks dot com\n\nDan Bolser, dan dot bolser at gmail dot com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::Quality;\nuse vars qw($DEFAULT_NAME $GAP $META_GAP);\nuse strict;\n\n#use overload '\"\"' => \\&to_string;\n\nuse base qw(Bio::Seq::Meta::Array);\n\n\nBEGIN {\n\n    $DEFAULT_NAME = 'DEFAULT';\n    $GAP = '-';\n    $META_GAP = ' ';\n}\n\n=head2 new\n\n Title   : new\n Usage   : $metaseq = Bio::Seq::Quality->new\n\t        ( -qual => '0 1 2 3 4 5 6 7 8 9 11 12',\n                  -trace => '0 5 10 15 20 25 30 35 40 45 50 55',\n                  -seq =>  'atcgatcgatcg',\n\t          -id  => 'human_id',\n\t          -accession_number => 'S000012',\n\t        );\n Function: Constructor for Bio::Seq::Quality class.\n           Note that you can provide an empty quality and trace strings.\n Returns : a new Bio::Seq::Quality object\n\n\n\nsub new {\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my($meta, $qual, $trace, $trace_indices, $trace_data) =\n        $self->_rearrange([qw(META\n                              QUAL\n                              TRACE\n                              TRACE_INDICES\n                              TRACE_DATA)],\n                          @args);\n\n    $self->{'_meta'}->{$DEFAULT_NAME} = [];\n    $self->{'_meta'}->{'trace'} = [];\n    $self->{trace_data} = $trace_data;\n\n    $meta && $self->meta($meta);\n    $qual && $self->qual($qual);\n    $trace && $self->named_meta('trace', $trace);\n    $trace_indices && $self->named_meta('trace', $trace_indices);\n\n    return $self;\n}\n\n\n=head2 qual\n\n Title   : qual\n Usage   : $qual_values  = $obj->qual($values_string);\n Function:\n\n           Get and set method for the meta data starting from residue\n           position one. Since it is dependent on the length of the\n           sequence, it needs to be manipulated after the sequence.\n\n           The length of the returned value always matches the length\n           of the sequence.\n\n Returns : reference to an array of meta data\n Args    : new value, string or array ref or Bio::Seq::PrimaryQual, optional\n\nSetting quality values resets the cached good quality ranges that\ndepend on the set threshold value.\n\n\nsub qual {\n    my $self = shift;\n    my $value = shift;\n    $value = $value->qual\n        if ref($value) and ref($value) ne 'ARRAY' and\n           $value->isa('Bio::Seq::PrimaryQual');\n    $self->_empty_cache if $value;\n    $self->named_meta($DEFAULT_NAME, $value);\n}\n\n=head2 qual_text\n\n Title   : qual_text\n Usage   : $qual_values  = $obj->qual_text($values_arrayref);\n Function: Variant of meta() and qual()  guarantied to return a string\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, optional\n\n\nsub qual_text {\n    return join ' ', @{shift->submeta(@_)};\n}\n\n=head2 subqual\n\n Title   : subqual\n Usage   : $subset_of_qual_values = $obj->subqual(10, 20, $value_string);\n           $subset_of_qual_values = $obj->subqual(10, undef, $value_string);\n Function:\n\n           Get and set method for meta data for subsequences.\n\n           Numbering starts from 1 and the number is inclusive, ie 1-2\n           are the first two residue of the sequence. Start cannot be\n           larger than end but can be equal.\n\n           If the second argument is missing the returned values\n           should extend to the end of the sequence.\n\n Returns : A reference to an array\n Args    : integer, start position\n           integer, end position, optional when a third argument present\n           new value, optional\n\n\nsub subqual {\n    shift->named_submeta($DEFAULT_NAME, @_);\n}\n\n=head2 subqual_text\n\n Title   : subqual_text\n Usage   : $meta_values  = $obj->subqual_text(20, $value_string);\n Function: Variant of subqual() returning a stringified\n           representation  of meta data. For details, see L<Bio::Seq::MetaI>.\n Returns : a string\n Args    : new value, optional\n\n\nsub subqual_text {\n    return join ' ', @{shift->submeta(@_)};\n}\n\n\n=head2 quality_length\n\n Title   : quality_length()\n Usage   : $qual_len  = $obj->quality_length();\n Function: return the number of elements in the quality array\n Returns : integer\n Args    : -"},"kind":12,"line":327,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"quality_length","line":328,"kind":13},{"name":"$self","containerName":"quality_length","kind":13,"line":329},{"kind":12,"line":329,"name":"named_meta_length","containerName":"quality_length"}],"name":"quality_length","range":{"end":{"line":330,"character":9999},"start":{"character":0,"line":327}}},{"line":345,"children":[{"kind":12,"line":346,"name":"is_flush","containerName":"quality_is_flush"}],"kind":12,"range":{"start":{"line":345,"character":0},"end":{"line":347,"character":9999}},"containerName":"main::","name":"quality_is_flush","definition":"sub"},{"kind":12,"line":368,"children":[{"containerName":"trace","name":"named_meta","line":369,"kind":12}],"containerName":"main::","definition":"sub","name":"trace","range":{"start":{"character":0,"line":368},"end":{"line":370,"character":9999}}},{"range":{"end":{"character":9999,"line":384},"start":{"character":0,"line":383}},"definition":"sub","name":"trace_text","containerName":"main::","children":[{"line":384,"kind":12,"containerName":"trace_text","name":"named_submeta"}],"line":383,"kind":12},{"name":"shift","kind":12,"line":384},{"definition":"sub","name":"subtrace","containerName":"main::","range":{"start":{"line":411,"character":0},"end":{"line":413,"character":9999}},"kind":12,"children":[{"kind":12,"line":412,"name":"named_submeta","containerName":"subtrace"}],"line":411},{"range":{"start":{"character":0,"line":426},"end":{"line":427,"character":9999}},"containerName":"main::","name":"subtrace_text","definition":"sub","line":426,"children":[{"line":427,"kind":12,"containerName":"subtrace_text","name":"named_submeta"}],"kind":12},{"kind":12,"line":427,"name":"shift"},{"detail":"($self)","signature":{"label":"trace_length($self)","documentation":"1;\n# $Id: Quality.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::Quality\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::Quality - Implementation of sequence with residue quality and trace values\n\n=head1 SYNOPSIS\n\n  use Bio::Seq::Quality;\n\n  # input can be space delimited string or array ref\n  my $qual = '0 1 2 3 4 5 6 7 8 9 11 12';\n  my $trace = '0 5 10 15 20 25 30 35 40 45 50 55';\n\n  my $seq = Bio::Seq::Quality->new\n      ( -qual => $qual,\n        -trace_indices => $trace,\n        -seq =>  'atcgatcgatcg',\n        -id  => 'human_id',\n        -accession_number => 'S000012',\n        -verbose => -1   # to silence deprecated methods\n  );\n\n  my $quals = $seq->qual; # array ref\n  my $traces = $seq->trace;  # array ref\n\n  my $quals = $seq->qual_text; # string\n  my $traces = $seq->trace_text; # string\n\n\n  # get sub values\n  $quals = $seq->subqual(2, 3);  # array ref\n  $traces = $seq->subtrace(2, 3); # array ref\n  $quals = $seq->subqual_text(2, 3); # string\n  $quals = $seq->subtrace_text(2, 3); # string\n\n  # set sub values \n  $seq->subqual(2, 3, \"9 9\");\n  $seq->subtrace(2, 3, \"9 9\");\n\n\n\n=head1 DESCRIPTION\n\nThis object stores base quality values together with the sequence\nstring.\n\nIt is a reimplementation of Chad Matsalla's Bio::Seq::SeqWithQuality\nmodule using Bio::Seq::MetaI. \n\nThe implementation is based on Bio::Seq::Meta::Array. qual() and\ntrace() are base methods to store and retrieve information that have\nextensions to retrieve values as a scalar (e.g. qual_text() ), or get\nor set subvalues (e.g. subqual() ). See L<Bio::Seq::MetaI> for more details.\n\nAll the functional code is in Bio::Seq::Meta::Array.\n\nThere deprecated methods that are included for compatibility with\nBio::Seq::SeqWithQuality. These will print a warning unless verbosity\nof the object is set to be less than zero.\n\n=head2 Differences from Bio::Seq::SeqWithQuality\n\nIt is not possible to fully follow the interface of\nBio::Seq::SeqWithQuality since internally a Bio::Seq::SeqWithQuality\nobject is a composite of two independent objects: a Bio::PrimarySeq\nobject and Bio::Seq::PrimaryQual object. Both of these objects can be\ncreated separately and merged into Bio::Seq::SeqWithQuality.\n\nThis implementation is based on Bio::Seq::Meta::Array that is a subclass\nof Bio::PrimarySeq that stores any number of meta information in\nunnamed arrays.\n\nHere we assume that two meta sets, called 'qual' and 'trace_indices' are\nattached to a sequence. (But there is nothing that prevents you to add\nas many named meta sets as you need using normal meta() methods).\n\nqual() is an alias to meta(), qualat($loc) is an alias to\nsubmeta($loc,$loc).\n\ntrace_indices() in Bio::Seq::SeqWithQuality has been abbreviated to\ntrace() and is an alias to named_meta('trace').\n\nYou can create an object without passing any arguments to the\nconstructor (Bio::Seq::SeqWithQuality fails without alphabet). It will\nwarn about not being able to set alphabet unless you set verbosity of\nthe object to a negative value.\n\nAfter the latest rewrite, the meta information sets (quality and\ntrace) no longer cover all the residues automatically. Methods to\ncheck the length of meta information (L<quality_length>,\nL<trace_length>)and to see if the ends are flushed to the sequence\nhave been added (L<quality_is_flush>, L<trace_is_flush>). To force\nthe old functinality, set L<force_flush> to true.\n\nqual_obj() and seq_obj() methods do not exist!\n\nFinally, there is only one set of descriptors (primary_id, display_id,\naccession_number) for the object.\n\n\n=head1 SEE ALSO\n\nL<Bio::Seq::MetaI>, \nL<Bio::Seq::Meta::Array>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nChad Matsalla, bioinformatics at dieselwurks dot com\n\nDan Bolser, dan dot bolser at gmail dot com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::Quality;\nuse vars qw($DEFAULT_NAME $GAP $META_GAP);\nuse strict;\n\n#use overload '\"\"' => \\&to_string;\n\nuse base qw(Bio::Seq::Meta::Array);\n\n\nBEGIN {\n\n    $DEFAULT_NAME = 'DEFAULT';\n    $GAP = '-';\n    $META_GAP = ' ';\n}\n\n=head2 new\n\n Title   : new\n Usage   : $metaseq = Bio::Seq::Quality->new\n\t        ( -qual => '0 1 2 3 4 5 6 7 8 9 11 12',\n                  -trace => '0 5 10 15 20 25 30 35 40 45 50 55',\n                  -seq =>  'atcgatcgatcg',\n\t          -id  => 'human_id',\n\t          -accession_number => 'S000012',\n\t        );\n Function: Constructor for Bio::Seq::Quality class.\n           Note that you can provide an empty quality and trace strings.\n Returns : a new Bio::Seq::Quality object\n\n\n\nsub new {\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my($meta, $qual, $trace, $trace_indices, $trace_data) =\n        $self->_rearrange([qw(META\n                              QUAL\n                              TRACE\n                              TRACE_INDICES\n                              TRACE_DATA)],\n                          @args);\n\n    $self->{'_meta'}->{$DEFAULT_NAME} = [];\n    $self->{'_meta'}->{'trace'} = [];\n    $self->{trace_data} = $trace_data;\n\n    $meta && $self->meta($meta);\n    $qual && $self->qual($qual);\n    $trace && $self->named_meta('trace', $trace);\n    $trace_indices && $self->named_meta('trace', $trace_indices);\n\n    return $self;\n}\n\n\n=head2 qual\n\n Title   : qual\n Usage   : $qual_values  = $obj->qual($values_string);\n Function:\n\n           Get and set method for the meta data starting from residue\n           position one. Since it is dependent on the length of the\n           sequence, it needs to be manipulated after the sequence.\n\n           The length of the returned value always matches the length\n           of the sequence.\n\n Returns : reference to an array of meta data\n Args    : new value, string or array ref or Bio::Seq::PrimaryQual, optional\n\nSetting quality values resets the cached good quality ranges that\ndepend on the set threshold value.\n\n\nsub qual {\n    my $self = shift;\n    my $value = shift;\n    $value = $value->qual\n        if ref($value) and ref($value) ne 'ARRAY' and\n           $value->isa('Bio::Seq::PrimaryQual');\n    $self->_empty_cache if $value;\n    $self->named_meta($DEFAULT_NAME, $value);\n}\n\n=head2 qual_text\n\n Title   : qual_text\n Usage   : $qual_values  = $obj->qual_text($values_arrayref);\n Function: Variant of meta() and qual()  guarantied to return a string\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, optional\n\n\nsub qual_text {\n    return join ' ', @{shift->submeta(@_)};\n}\n\n=head2 subqual\n\n Title   : subqual\n Usage   : $subset_of_qual_values = $obj->subqual(10, 20, $value_string);\n           $subset_of_qual_values = $obj->subqual(10, undef, $value_string);\n Function:\n\n           Get and set method for meta data for subsequences.\n\n           Numbering starts from 1 and the number is inclusive, ie 1-2\n           are the first two residue of the sequence. Start cannot be\n           larger than end but can be equal.\n\n           If the second argument is missing the returned values\n           should extend to the end of the sequence.\n\n Returns : A reference to an array\n Args    : integer, start position\n           integer, end position, optional when a third argument present\n           new value, optional\n\n\nsub subqual {\n    shift->named_submeta($DEFAULT_NAME, @_);\n}\n\n=head2 subqual_text\n\n Title   : subqual_text\n Usage   : $meta_values  = $obj->subqual_text(20, $value_string);\n Function: Variant of subqual() returning a stringified\n           representation  of meta data. For details, see L<Bio::Seq::MetaI>.\n Returns : a string\n Args    : new value, optional\n\n\nsub subqual_text {\n    return join ' ', @{shift->submeta(@_)};\n}\n\n\n=head2 quality_length\n\n Title   : quality_length()\n Usage   : $qual_len  = $obj->quality_length();\n Function: return the number of elements in the quality array\n Returns : integer\n Args    : -\n\n\nsub quality_length {\n   my ($self) = @_;\n   return $self->named_meta_length('DEFAULT');\n}\n\n\n\n=head2 quality_is_flush\n\n Title   : quality_is_flush\n Usage   : $quality_is_flush  = $obj->quality_is_flush()\n Function: Boolean to tell if the trace length equals the sequence length.\n           Returns true if force_flush() is set.\n Returns : boolean 1 or 0\n Args    : none\n\n\nsub quality_is_flush {\n    return shift->is_flush('quality');\n}\n\n\n=head2 trace\n\n Title   : trace\n Usage   : $trace_values  = $obj->trace($values_string);\n Function:\n\n           Get and set method for the meta data starting from residue\n           position one. Since it is dependent on the length of the\n           sequence, it needs to be manipulated after the sequence.\n\n           The length of the returned value always matches the length\n           of the sequence.\n\n Returns : reference to an array of meta data\n Args    : new value, string or array ref, optional\n\n\nsub trace {\n    return shift->named_meta('trace', shift);\n}\n\n=head2 trace_text\n\n Title   : trace_text\n Usage   : $trace_values  = $obj->trace_text($values_arrayref);\n Function: Variant of meta() and trace()  guarantied to return a string\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, optional\n\n\nsub trace_text {\n    return join ' ', @{shift->named_submeta('trace', @_)};\n}\n\n=head2 subtrace\n\n Title   : subtrace\n Usage   : $subset_of_trace_values = $obj->subtrace(10, 20, $value_string);\n           $subset_of_trace_values = $obj->subtrace(10, undef, $value_string);\n Function:\n\n           Get and set method for meta data for subsequences.\n\n           Numbering starts from 1 and the number is inclusive, ie 1-2\n           are the first two residue of the sequence. Start cannot be\n           larger than end but can be equal.\n\n           If the second argument is missing the returned values\n           should extend to the end of the sequence.\n\n Returns : A reference to an array\n Args    : integer, start position\n           integer, end position, optional when a third argument present\n           new value, optional\n\n\n\nsub subtrace {\n    return shift->named_submeta('trace', @_);\n}\n\n=head2 subtrace_text\n\n Title   : subtrace_text\n Usage   : $meta_values  = $obj->subtrace_text(20, $value_string);\n Function: Variant of subtrace() returning a stringified\n           representation  of meta data. For details, see L<Bio::Seq::MetaI>.\n Returns : a string\n Args    : new value, optional\n\n\nsub subtrace_text {\n    return join ' ', @{shift->named_submeta('trace', @_)};\n}\n\n\n=head2 trace_length\n\n Title   : trace_length()\n Usage   : $trace_len  = $obj->trace_length();\n Function: return the number of elements in the trace set\n Returns : integer\n Args    : -","parameters":[{"label":"$self"}]},"containerName":"main::","definition":"sub","line":441,"children":[{"name":"$self","definition":"my","containerName":"trace_length","localvar":"my","kind":13,"line":442},{"line":443,"kind":13,"containerName":"trace_length","name":"$self"},{"name":"named_meta_length","containerName":"trace_length","kind":12,"line":443}],"kind":12,"range":{"start":{"line":441,"character":0},"end":{"character":9999,"line":444}},"name":"trace_length"},{"children":[{"line":458,"kind":12,"name":"is_flush","containerName":"trace_is_flush"}],"line":457,"kind":12,"range":{"start":{"line":457,"character":0},"end":{"line":459,"character":9999}},"name":"trace_is_flush","definition":"sub","containerName":"main::"},{"containerName":"main::","definition":"sub","name":"get_trace_graph","range":{"end":{"line":491,"character":9999},"start":{"character":0,"line":479}},"kind":12,"line":479,"children":[{"kind":13,"line":481,"containerName":"get_trace_graph","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":482,"definition":"my","name":"$trace","containerName":"get_trace_graph","localvar":"my"},{"line":482,"kind":13,"name":"$scale","containerName":"get_trace_graph"},{"name":"$self","containerName":"get_trace_graph","kind":13,"line":483},{"name":"_rearrange","containerName":"get_trace_graph","kind":12,"line":483},{"name":"$trace","containerName":"get_trace_graph","kind":13,"line":487},{"kind":13,"line":488,"name":"$self","containerName":"get_trace_graph"},{"line":489,"kind":13,"containerName":"get_trace_graph","name":"$trace"},{"name":"$trace","containerName":"get_trace_graph","kind":13,"line":489},{"localvar":"my","containerName":"get_trace_graph","definition":"my","name":"@trace_data","line":490,"kind":13},{"kind":13,"line":490,"name":"$self","containerName":"get_trace_graph"},{"kind":13,"line":490,"containerName":"get_trace_graph","name":"$trace"},{"kind":13,"line":490,"name":"$self","containerName":"get_trace_graph"},{"line":490,"kind":13,"containerName":"get_trace_graph","name":"$trace"},{"containerName":"get_trace_graph","name":"$self","kind":13,"line":491},{"containerName":"get_trace_graph","name":"$trace","line":491,"kind":13}]},{"line":488,"kind":12,"name":"trace_data"},{"line":490,"kind":12,"name":"trace_data"},{"name":"trace_data","kind":12,"line":490},{"kind":12,"line":491,"name":"trace_data"},{"kind":13,"line":492,"name":"$max","definition":"my","containerName":null,"localvar":"my"},{"line":492,"kind":13,"containerName":null,"name":"%self"},{"name":"trace_data","line":492,"kind":12},{"name":"max_height","line":492,"kind":12},{"kind":13,"line":493,"name":"$scale","containerName":null},{"kind":13,"line":493,"name":"%scale","containerName":null},{"line":495,"kind":13,"containerName":null,"name":"@trace_data"},{"name":"$max","containerName":null,"line":495,"kind":13},{"kind":13,"line":495,"containerName":null,"name":"$scale"},{"name":"@trace_data","containerName":null,"kind":13,"line":495},{"name":"@trace_data","containerName":null,"line":497,"kind":13},{"children":[{"localvar":"my","containerName":"threshold","name":"$self","definition":"my","line":514,"kind":13},{"localvar":"my","containerName":"threshold","name":"$value","definition":"my","line":515,"kind":13},{"name":"$value","containerName":"threshold","kind":13,"line":516},{"name":"$self","containerName":"threshold","kind":13,"line":517},{"line":517,"kind":12,"containerName":"threshold","name":"throw"},{"containerName":"threshold","name":"$value","line":518,"kind":13},{"kind":13,"line":519,"name":"$self","containerName":"threshold"},{"line":519,"kind":12,"containerName":"threshold","name":"_empty_cache"},{"containerName":"threshold","name":"$self","kind":13,"line":520},{"kind":13,"line":520,"name":"$self","containerName":"threshold"},{"line":520,"kind":13,"name":"$value","containerName":"threshold"},{"kind":13,"line":521,"containerName":"threshold","name":"$self"},{"containerName":"threshold","name":"$value","kind":13,"line":521},{"kind":13,"line":523,"containerName":"threshold","name":"$self"}],"line":513,"kind":12,"range":{"start":{"character":0,"line":513},"end":{"character":9999,"line":524}},"name":"threshold","definition":"sub","containerName":"main::"},{"name":"_threshold","kind":12,"line":520},{"name":"_threshold","kind":12,"line":520},{"name":"_threshold","kind":12,"line":521},{"name":"_threshold","kind":12,"line":523},{"line":540,"children":[{"kind":13,"line":541,"definition":"my","name":"$self","containerName":"count_clear_ranges","localvar":"my"},{"localvar":"my","name":"$threshold","definition":"my","containerName":"count_clear_ranges","line":542,"kind":13},{"name":"$self","containerName":"count_clear_ranges","line":543,"kind":13},{"name":"threshold","containerName":"count_clear_ranges","kind":12,"line":543},{"line":543,"kind":13,"containerName":"count_clear_ranges","name":"$threshold"},{"line":543,"kind":13,"name":"$threshold","containerName":"count_clear_ranges"},{"line":546,"kind":13,"containerName":"count_clear_ranges","name":"$self"},{"kind":12,"line":546,"name":"_find_clear_ranges","containerName":"count_clear_ranges"},{"name":"$self","containerName":"count_clear_ranges","line":546,"kind":13},{"name":"$self","containerName":"count_clear_ranges","kind":13,"line":548}],"kind":12,"range":{"end":{"line":548,"character":9999},"start":{"character":0,"line":540}},"containerName":"main::","name":"count_clear_ranges","definition":"sub"},{"line":546,"kind":12,"name":"_ranges"},{"kind":12,"line":548,"name":"_ranges"},{"children":[{"line":565,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"clear_ranges_length"},{"kind":13,"line":566,"containerName":"clear_ranges_length","name":"$threshold","definition":"my","localvar":"my"},{"containerName":"clear_ranges_length","name":"$self","kind":13,"line":567},{"kind":12,"line":567,"name":"threshold","containerName":"clear_ranges_length"},{"containerName":"clear_ranges_length","name":"$threshold","line":567,"kind":13},{"kind":13,"line":567,"name":"$threshold","containerName":"clear_ranges_length"},{"name":"$self","containerName":"clear_ranges_length","line":570,"kind":13},{"name":"_find_clear_ranges","containerName":"clear_ranges_length","kind":12,"line":570},{"containerName":"clear_ranges_length","name":"$self","kind":13,"line":570},{"containerName":"clear_ranges_length","definition":"my","name":"$sum","localvar":"my","kind":13,"line":572},{"kind":13,"line":573,"name":"$sum","containerName":"clear_ranges_length"},{"kind":13,"line":573,"containerName":"clear_ranges_length","name":"$self"}],"line":564,"kind":12,"range":{"start":{"character":0,"line":564},"end":{"line":573,"character":9999}},"definition":"sub","name":"clear_ranges_length","containerName":"main::"},{"name":"_ranges","line":570,"kind":12},{"name":"length","line":573,"kind":12},{"kind":12,"line":573,"name":"_ranges"},{"line":574,"kind":13,"name":"$sum","containerName":null},{"children":[{"line":591,"kind":13,"localvar":"my","containerName":"get_clear_range","name":"$self","definition":"my"},{"containerName":"get_clear_range","definition":"my","name":"$threshold","localvar":"my","kind":13,"line":592},{"containerName":"get_clear_range","name":"$self","line":593,"kind":13},{"kind":12,"line":593,"name":"threshold","containerName":"get_clear_range"},{"line":593,"kind":13,"containerName":"get_clear_range","name":"$threshold"},{"line":593,"kind":13,"containerName":"get_clear_range","name":"$threshold"},{"line":596,"kind":13,"containerName":"get_clear_range","name":"$self"},{"containerName":"get_clear_range","name":"_find_clear_ranges","line":596,"kind":12},{"containerName":"get_clear_range","name":"$self","kind":13,"line":596},{"name":"$self","containerName":"get_clear_range","line":599,"kind":13},{"containerName":"get_clear_range","name":"$b","line":602,"kind":13},{"line":602,"kind":13,"name":"$a","containerName":"get_clear_range"},{"containerName":"get_clear_range","name":"$self","line":602,"kind":13}],"line":590,"kind":12,"range":{"end":{"line":602,"character":9999},"start":{"line":590,"character":0}},"definition":"sub","name":"get_clear_range","containerName":"main::"},{"kind":12,"line":596,"name":"_ranges"},{"name":"_ranges","line":599,"kind":12},{"kind":12,"line":602,"name":"length"},{"name":"length","line":602,"kind":12},{"kind":12,"line":602,"name":"_ranges"},{"containerName":"Seq::Quality","name":"Bio","line":604,"kind":12},{"containerName":"main::","name":"new","line":605,"kind":12},{"containerName":null,"name":"$self","kind":13,"line":605},{"kind":12,"line":605,"containerName":"main::","name":"subseq"},{"name":"start","line":605,"kind":12},{"kind":12,"line":605,"name":"end"},{"line":606,"kind":13,"containerName":null,"name":"$self"},{"line":606,"kind":12,"containerName":"main::","name":"subqual"},{"name":"start","kind":12,"line":606},{"line":606,"kind":12,"name":"end"},{"kind":12,"children":[{"kind":13,"line":627,"name":"$self","definition":"my","containerName":"get_all_clean_ranges","localvar":"my"},{"localvar":"my","containerName":"get_all_clean_ranges","name":"$minl","definition":"my","line":628,"kind":13},{"line":630,"kind":13,"containerName":"get_all_clean_ranges","name":"$minl"},{"containerName":"get_all_clean_ranges","name":"$self","kind":13,"line":631},{"name":"throw","containerName":"get_all_clean_ranges","line":631,"kind":12},{"line":632,"kind":13,"containerName":"get_all_clean_ranges","name":"$minl"},{"kind":13,"line":635,"containerName":"get_all_clean_ranges","name":"$self"},{"kind":12,"line":635,"containerName":"get_all_clean_ranges","name":"_find_clear_ranges"},{"name":"$self","containerName":"get_all_clean_ranges","kind":13,"line":635},{"kind":13,"line":638,"containerName":"get_all_clean_ranges","definition":"my","name":"@ranges","localvar":"my"},{"definition":"my","name":"$r","containerName":"get_all_clean_ranges","localvar":"my","kind":13,"line":639},{"line":639,"kind":13,"name":"$b","containerName":"get_all_clean_ranges"},{"name":"$a","containerName":"get_all_clean_ranges","kind":13,"line":639},{"kind":13,"line":639,"containerName":"get_all_clean_ranges","name":"$self"}],"line":626,"name":"get_all_clean_ranges","definition":"sub","containerName":"main::","range":{"end":{"line":639,"character":9999},"start":{"character":0,"line":626}}},{"line":635,"kind":12,"name":"_ranges"},{"kind":12,"line":639,"name":"start"},{"kind":12,"line":639,"name":"start"},{"kind":12,"line":639,"name":"_ranges"},{"containerName":null,"name":"%r","line":640,"kind":13},{"kind":12,"line":640,"name":"length"},{"name":"$minl","containerName":null,"kind":13,"line":640},{"line":642,"kind":13,"containerName":null,"name":"@ranges"},{"name":"Bio","containerName":"Seq::Quality","line":642,"kind":12},{"containerName":"main::","name":"new","kind":12,"line":643},{"line":643,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"line":643,"containerName":"main::","name":"subseq"},{"kind":13,"line":643,"containerName":null,"name":"%r"},{"line":643,"kind":12,"name":"start"},{"line":643,"kind":13,"name":"%r","containerName":null},{"name":"end","kind":12,"line":643},{"kind":13,"line":644,"name":"$self","containerName":null},{"containerName":"main::","name":"subqual","line":644,"kind":12},{"line":644,"kind":13,"name":"%r","containerName":null},{"kind":12,"line":644,"name":"start"},{"line":644,"kind":13,"containerName":null,"name":"%r"},{"line":644,"kind":12,"name":"end"},{"kind":13,"line":647,"containerName":null,"name":"@ranges"},{"range":{"end":{"line":664,"character":9999},"start":{"line":655,"character":0}},"definition":"sub","name":"_find_clear_ranges","containerName":"main::","children":[{"line":656,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_find_clear_ranges"},{"line":658,"kind":13,"name":"$self","containerName":"_find_clear_ranges"},{"containerName":"_find_clear_ranges","name":"throw","line":658,"kind":12},{"kind":13,"line":659,"containerName":"_find_clear_ranges","name":"$self"},{"kind":12,"line":659,"containerName":"_find_clear_ranges","name":"threshold"},{"kind":13,"line":661,"containerName":"_find_clear_ranges","name":"$flag","definition":"my","localvar":"my"},{"kind":13,"line":662,"containerName":"_find_clear_ranges","name":"$threshold","definition":"my","localvar":"my"},{"name":"$self","containerName":"_find_clear_ranges","line":662,"kind":13},{"kind":12,"line":662,"containerName":"_find_clear_ranges","name":"threshold"},{"kind":13,"line":663,"containerName":"_find_clear_ranges","definition":"my","name":"$i","localvar":"my"},{"containerName":"_find_clear_ranges","name":"$q","definition":"my","localvar":"my","kind":13,"line":664},{"containerName":"_find_clear_ranges","name":"$self","line":664,"kind":13},{"kind":12,"line":664,"name":"qual","containerName":"_find_clear_ranges"}],"line":655,"kind":12},{"line":665,"kind":13,"containerName":null,"name":"$i"},{"name":"%flag","containerName":null,"line":667,"kind":13},{"name":"$q","containerName":null,"kind":13,"line":668},{"name":"%threshold","containerName":null,"line":668,"kind":13},{"localvar":"my","containerName":null,"definition":"my","name":"$range","line":669,"kind":13},{"kind":13,"line":670,"name":"%range","containerName":null},{"name":"end","line":670,"kind":12},{"kind":13,"line":670,"containerName":null,"name":"$i"},{"line":671,"kind":13,"name":"%range","containerName":null},{"name":"start","kind":12,"line":671},{"containerName":null,"name":"$flag","line":671,"kind":13},{"kind":13,"line":672,"name":"%range","containerName":null},{"name":"length","line":672,"kind":12},{"name":"$i","containerName":null,"kind":13,"line":672},{"name":"$flag","containerName":null,"kind":13,"line":672},{"name":"%self","containerName":null,"line":673,"kind":13},{"name":"_ranges","kind":12,"line":673},{"kind":13,"line":673,"name":"$range","containerName":null},{"line":674,"kind":13,"containerName":null,"name":"%flag"},{"containerName":null,"name":"$flag","kind":13,"line":677},{"line":677,"kind":13,"name":"$i","containerName":null},{"name":"$q","containerName":null,"line":677,"kind":13},{"kind":13,"line":677,"name":"$threshold","containerName":null},{"name":"%flag","containerName":null,"line":681,"kind":13},{"kind":13,"line":683,"definition":"my","name":"$range","containerName":null,"localvar":"my"},{"line":684,"kind":13,"containerName":null,"name":"%range"},{"kind":12,"line":684,"name":"end"},{"containerName":null,"name":"$i","line":684,"kind":13},{"containerName":null,"name":"%range","line":685,"kind":13},{"kind":12,"line":685,"name":"start"},{"line":685,"kind":13,"containerName":null,"name":"$flag"},{"kind":13,"line":686,"containerName":null,"name":"%range"},{"line":686,"kind":12,"name":"length"},{"containerName":null,"name":"$i","kind":13,"line":686},{"containerName":null,"name":"$flag","kind":13,"line":686},{"containerName":null,"name":"%self","kind":13,"line":687},{"name":"_ranges","kind":12,"line":687},{"name":"$range","containerName":null,"kind":13,"line":687},{"containerName":"main::","definition":"sub","name":"_empty_cache","range":{"start":{"character":0,"line":694},"end":{"line":697,"character":9999}},"kind":12,"line":694,"children":[{"localvar":"my","containerName":"_empty_cache","definition":"my","name":"$self","line":695,"kind":13},{"line":696,"kind":13,"name":"$self","containerName":"_empty_cache"}]},{"line":696,"kind":12,"name":"_ranges"},{"kind":12,"children":[{"localvar":"my","containerName":"trace_indices","definition":"my","name":"$self","line":706,"kind":13},{"name":"$self","containerName":"trace_indices","line":707,"kind":13},{"line":707,"kind":12,"name":"named_meta","containerName":"trace_indices"}],"line":705,"name":"trace_indices","definition":"sub","containerName":"main::","range":{"start":{"line":705,"character":0},"end":{"line":708,"character":9999}}},{"range":{"end":{"character":9999,"line":712},"start":{"line":710,"character":0}},"name":"trace_index_at","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$val"}],"label":"trace_index_at($self,$val)"},"detail":"($self,$val)","definition":"sub","containerName":"main::","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"trace_index_at","line":711,"kind":13},{"kind":13,"line":711,"name":"$val","containerName":"trace_index_at"},{"line":712,"kind":13,"containerName":"trace_index_at","name":"$self"},{"name":"named_submeta","containerName":"trace_index_at","line":712,"kind":12},{"line":712,"kind":13,"containerName":"trace_index_at","name":"$val"},{"kind":13,"line":712,"containerName":"trace_index_at","name":"$val"}],"line":710,"kind":12},{"name":"sub_trace_index","definition":"sub","containerName":"main::","range":{"start":{"line":716,"character":0},"end":{"line":719,"character":9999}},"kind":12,"children":[{"containerName":"sub_trace_index","definition":"my","name":"$self","localvar":"my","kind":13,"line":717},{"name":"$self","containerName":"sub_trace_index","kind":13,"line":718},{"line":718,"kind":12,"containerName":"sub_trace_index","name":"named_submeta"}],"line":716},{"children":[{"kind":13,"line":723,"containerName":"qualat","name":"$self","definition":"my","localvar":"my"},{"containerName":"qualat","name":"$val","line":723,"kind":13},{"containerName":"qualat","name":"$self","line":724,"kind":13},{"name":"submeta","containerName":"qualat","kind":12,"line":724},{"line":724,"kind":13,"containerName":"qualat","name":"$val"},{"name":"$val","containerName":"qualat","kind":13,"line":724}],"line":722,"kind":12,"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$val"}],"label":"qualat($self,$val)"},"detail":"($self,$val)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":724},"start":{"line":722,"character":0}},"name":"qualat"},{"definition":"sub","containerName":"main::","signature":{"label":"baseat($self,$val)","documentation":"","parameters":[{"label":"$self"},{"label":"$val"}]},"detail":"($self,$val)","kind":12,"children":[{"line":729,"kind":13,"localvar":"my","containerName":"baseat","name":"$self","definition":"my"},{"line":729,"kind":13,"containerName":"baseat","name":"$val"},{"line":730,"kind":13,"name":"$self","containerName":"baseat"},{"line":730,"kind":12,"name":"subseq","containerName":"baseat"},{"containerName":"baseat","name":"$val","kind":13,"line":730},{"kind":13,"line":730,"containerName":"baseat","name":"$val"}],"line":728,"name":"baseat","range":{"end":{"character":9999,"line":731},"start":{"line":728,"character":0}}}]}