{"version":5,"vars":[{"kind":2,"line":78,"name":"vars","containerName":""},{"kind":13,"line":84,"name":"$DefaultProgramName","containerName":null},{"line":84,"kind":2,"containerName":"strict::Bio::Search::Result::ResultFactory::Bio::Search::Hit::HitFactory::Bio::Search::HSP","name":"HSPFactory"},{"name":"$DEFAULT_WRITER_CLASS","containerName":null,"line":85,"kind":13},{"name":"%MODEMAP","containerName":null,"kind":13,"line":88},{"name":"%MAPPING","containerName":null,"kind":13,"line":94},{"name":"base","containerName":"","line":133,"kind":2},{"name":"_initialize","range":{"end":{"line":156,"character":9999},"start":{"line":146,"character":0}},"kind":12,"children":[{"line":147,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_initialize"},{"line":147,"kind":13,"containerName":"_initialize","name":"@args"},{"line":148,"kind":13,"containerName":"_initialize","name":"$self"},{"containerName":"_initialize","name":"@args","line":148,"kind":13},{"localvar":"my","containerName":"_initialize","name":"$pname","definition":"my","line":150,"kind":13},{"line":150,"kind":13,"name":"$self","containerName":"_initialize"},{"line":150,"kind":12,"containerName":"_initialize","name":"_rearrange"},{"containerName":"_initialize","name":"@args","line":151,"kind":13},{"name":"$self","containerName":"_initialize","line":152,"kind":13},{"name":"program_name","containerName":"_initialize","line":152,"kind":12},{"line":152,"kind":13,"containerName":"_initialize","name":"$pname"},{"containerName":"_initialize","name":"$DefaultProgramName","kind":13,"line":152},{"kind":13,"line":153,"name":"$self","containerName":"_initialize"},{"containerName":"_initialize","name":"_eventHandler","line":153,"kind":12},{"name":"register_factory","containerName":"_initialize","line":153,"kind":12},{"line":153,"kind":12,"name":"new","containerName":"_initialize"},{"name":"$self","containerName":"_initialize","kind":13,"line":154},{"kind":12,"line":154,"name":"_eventHandler","containerName":"_initialize"},{"kind":12,"line":154,"containerName":"_initialize","name":"register_factory"},{"kind":12,"line":154,"name":"new","containerName":"_initialize"},{"name":"$self","containerName":"_initialize","kind":13,"line":155},{"kind":12,"line":155,"name":"_eventHandler","containerName":"_initialize"},{"name":"register_factory","containerName":"_initialize","line":155,"kind":12},{"containerName":"_initialize","name":"new","kind":12,"line":155}],"line":146,"definition":"sub","containerName":"main::","signature":{"label":"_initialize($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: blasttable.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blasttable\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::blasttable - Driver module for SearchIO for parsing NCBI -m 8/9 format\n\n=head1 SYNOPSIS\n\n  # do not use this module directly\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => $file,\n                                 -format => 'blasttable');\n\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis module will support parsing NCBI -m 8 or -m 9 tabular output\nand WU-BLAST -mformat 2 or -mformat 3 tabular output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::blasttable;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\nuse strict;\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::HSP::HSPFactory;\n\n$DefaultProgramName = 'BLASTN';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\n%MAPPING = ( \n\t     'Hsp_bit-score'  => 'HSP-bits',\n\t     'Hsp_score'      => 'HSP-score',\n\t     'Hsp_evalue'     => 'HSP-evalue',\n\t     'Hsp_query-from' => 'HSP-query_start',\n\t     'Hsp_query-to'   => 'HSP-query_end',\n\t     'Hsp_hit-from'   => 'HSP-hit_start',\n\t     'Hsp_hit-to'     => 'HSP-hit_end',\n\t     'Hsp_positive'   => 'HSP-conserved',\n\t     'Hsp_identity'   => 'HSP-identical',\n\t     'Hsp_mismatches' => 'HSP-mismatches',\n\t     'Hsp_qgapblocks' => 'HSP-query_gapblocks',\n\t     'Hsp_hgapblocks' => 'HSP-hit_gapblocks',\n\t     'Hsp_gaps'       => 'HSP-hsp_gaps',\n\t     'Hsp_hitgaps'    => 'HSP-hit_gaps',\n\t     'Hsp_querygaps'  => 'HSP-query_gaps',\n\t     'Hsp_align-len'  => 'HSP-hsp_length',\n\t     'Hsp_query-frame'=> 'HSP-query_frame',\n\t     'Hsp_hit-frame'  => 'HSP-hit_frame',\n\n\t     'Hit_id'        => 'HIT-name',\n\t     'Hit_len'       => 'HIT-length',\n\t     'Hit_accession' => 'HIT-accession',\n\t     'Hit_def'       => 'HIT-description',\n\t     'Hit_signif'    => 'HIT-significance',\n\t     'Hit_score'     => 'HIT-score',\n\t     'Hit_bits'      => 'HIT-bits',\n\n\t     'Result_program'  => 'RESULT-algorithm_name',\n\t     'Result_version'  => 'RESULT-algorithm_version',\n\t     'Result_query-def'=> 'RESULT-query_name',\n\t     'Result_query-len'=> 'RESULT-query_length',\n\t     'Result_query-acc'=> 'RESULT-query_accession',\n\t     'Result_querydesc'=> 'RESULT-query_description',\n\t     'Result_db'       => 'RESULT-database_name',\n\t     'Result_db-len'   => 'RESULT-database_entries',\n\t     'Result_db-let'   => 'RESULT-database_letters',\n\t     );\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blasttable->new();\n Function: Builds a new Bio::SearchIO::blasttable object \n Returns : an instance of Bio::SearchIO::blasttable\n Args    :"},"detail":"($self,@args)"},{"containerName":"_initialize","name":"SUPER","kind":12,"line":148},{"name":"Bio","containerName":"Search::Result::ResultFactory","kind":12,"line":153},{"containerName":"Search::Hit::HitFactory","name":"Bio","line":154,"kind":12},{"line":155,"kind":12,"containerName":"Search::HSP::HSPFactory","name":"Bio"},{"name":"next_result","range":{"start":{"character":0,"line":170},"end":{"character":9999,"line":297}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"documentation":"1;\n# $Id: blasttable.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blasttable\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::blasttable - Driver module for SearchIO for parsing NCBI -m 8/9 format\n\n=head1 SYNOPSIS\n\n  # do not use this module directly\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => $file,\n                                 -format => 'blasttable');\n\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis module will support parsing NCBI -m 8 or -m 9 tabular output\nand WU-BLAST -mformat 2 or -mformat 3 tabular output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::blasttable;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\nuse strict;\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::HSP::HSPFactory;\n\n$DefaultProgramName = 'BLASTN';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\n%MAPPING = ( \n\t     'Hsp_bit-score'  => 'HSP-bits',\n\t     'Hsp_score'      => 'HSP-score',\n\t     'Hsp_evalue'     => 'HSP-evalue',\n\t     'Hsp_query-from' => 'HSP-query_start',\n\t     'Hsp_query-to'   => 'HSP-query_end',\n\t     'Hsp_hit-from'   => 'HSP-hit_start',\n\t     'Hsp_hit-to'     => 'HSP-hit_end',\n\t     'Hsp_positive'   => 'HSP-conserved',\n\t     'Hsp_identity'   => 'HSP-identical',\n\t     'Hsp_mismatches' => 'HSP-mismatches',\n\t     'Hsp_qgapblocks' => 'HSP-query_gapblocks',\n\t     'Hsp_hgapblocks' => 'HSP-hit_gapblocks',\n\t     'Hsp_gaps'       => 'HSP-hsp_gaps',\n\t     'Hsp_hitgaps'    => 'HSP-hit_gaps',\n\t     'Hsp_querygaps'  => 'HSP-query_gaps',\n\t     'Hsp_align-len'  => 'HSP-hsp_length',\n\t     'Hsp_query-frame'=> 'HSP-query_frame',\n\t     'Hsp_hit-frame'  => 'HSP-hit_frame',\n\n\t     'Hit_id'        => 'HIT-name',\n\t     'Hit_len'       => 'HIT-length',\n\t     'Hit_accession' => 'HIT-accession',\n\t     'Hit_def'       => 'HIT-description',\n\t     'Hit_signif'    => 'HIT-significance',\n\t     'Hit_score'     => 'HIT-score',\n\t     'Hit_bits'      => 'HIT-bits',\n\n\t     'Result_program'  => 'RESULT-algorithm_name',\n\t     'Result_version'  => 'RESULT-algorithm_version',\n\t     'Result_query-def'=> 'RESULT-query_name',\n\t     'Result_query-len'=> 'RESULT-query_length',\n\t     'Result_query-acc'=> 'RESULT-query_accession',\n\t     'Result_querydesc'=> 'RESULT-query_description',\n\t     'Result_db'       => 'RESULT-database_name',\n\t     'Result_db-len'   => 'RESULT-database_entries',\n\t     'Result_db-let'   => 'RESULT-database_letters',\n\t     );\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blasttable->new();\n Function: Builds a new Bio::SearchIO::blasttable object \n Returns : an instance of Bio::SearchIO::blasttable\n Args    :\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n\n    my ($pname) = $self->_rearrange([qw(PROGRAM_NAME)],\n\t\t\t\t    @args);\n    $self->program_name($pname || $DefaultProgramName);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n    $self->_eventHandler->register_factory('hit', Bio::Search::Hit::HitFactory->new(-type => 'Bio::Search::Hit::GenericHit'));\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI>\n Args    : none","parameters":[{"label":"$self"}],"label":"next_result($self)"},"kind":12,"line":170,"children":[{"containerName":"next_result","definition":"my","name":"$self","localvar":"my","kind":13,"line":171},{"kind":13,"line":172,"containerName":"next_result","name":"$lastquery","definition":"my","localvar":"my"},{"line":172,"kind":13,"containerName":"next_result","name":"$lasthit"},{"definition":"my","name":"$alg","containerName":"next_result","localvar":"my","kind":13,"line":175},{"name":"$ver","containerName":"next_result","line":175,"kind":13},{"name":"$self","containerName":"next_result","kind":13,"line":176},{"name":"_readline","containerName":"next_result","line":176,"kind":12},{"kind":13,"line":179,"containerName":"next_result","name":"$alg"},{"kind":13,"line":179,"containerName":"next_result","name":"$ver"},{"kind":13,"line":183,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"program_name","line":183,"kind":12},{"line":183,"kind":13,"containerName":"next_result","name":"$alg"},{"name":"$alg","containerName":"next_result","line":183,"kind":13},{"kind":13,"line":184,"name":"$self","containerName":"next_result"},{"kind":12,"line":184,"containerName":"next_result","name":"element"},{"name":"$ver","containerName":"next_result","kind":13,"line":185},{"containerName":"next_result","name":"$ver","line":185,"kind":13},{"containerName":"next_result","name":"$alg","line":190,"kind":13},{"kind":13,"line":190,"containerName":"next_result","name":"$ver"},{"localvar":"my","definition":"my","name":"@fields","containerName":"next_result","line":195,"kind":13},{"containerName":"next_result","name":"@fields","line":196,"kind":13},{"localvar":"my","name":"$qname","definition":"my","containerName":"next_result","line":197,"kind":13},{"containerName":"next_result","name":"$hname","kind":13,"line":197},{"line":197,"kind":13,"name":"$percent_id","containerName":"next_result"},{"name":"$hsp_len","containerName":"next_result","line":197,"kind":13},{"line":197,"kind":13,"containerName":"next_result","name":"$mismatches"},{"containerName":"next_result","name":"$gapsm","line":197,"kind":13},{"kind":13,"line":198,"name":"$qstart","containerName":"next_result"},{"containerName":"next_result","name":"$qend","line":198,"kind":13},{"containerName":"next_result","name":"$hstart","line":198,"kind":13},{"kind":13,"line":198,"name":"$hend","containerName":"next_result"},{"name":"$evalue","containerName":"next_result","kind":13,"line":198},{"name":"$bits","containerName":"next_result","line":198,"kind":13},{"kind":13,"line":200,"definition":"my","name":"$num_scores","containerName":"next_result","localvar":"my"},{"name":"$raw_score","containerName":"next_result","kind":13,"line":200},{"containerName":"next_result","name":"$identities","kind":13,"line":200},{"containerName":"next_result","name":"$positives","kind":13,"line":200},{"line":200,"kind":13,"containerName":"next_result","name":"$percent_pos"},{"kind":13,"line":201,"name":"$qgap_blocks","containerName":"next_result"},{"containerName":"next_result","name":"$qgaps","kind":13,"line":201},{"name":"$sgap_blocks","containerName":"next_result","kind":13,"line":201},{"kind":13,"line":201,"name":"$sgaps","containerName":"next_result"},{"containerName":"next_result","name":"$qframe","kind":13,"line":201},{"containerName":"next_result","name":"$sframe","kind":13,"line":202},{"kind":13,"line":204,"name":"@fields","containerName":"next_result"},{"containerName":"next_result","name":"$qname","kind":13,"line":205},{"name":"$hname","containerName":"next_result","line":205,"kind":13},{"line":205,"kind":13,"containerName":"next_result","name":"$percent_id"},{"kind":13,"line":205,"containerName":"next_result","name":"$hsp_len"},{"containerName":"next_result","name":"$mismatches","kind":13,"line":205},{"kind":13,"line":205,"name":"$gapsm","containerName":"next_result"},{"containerName":"next_result","name":"$qstart","line":206,"kind":13},{"kind":13,"line":206,"name":"$qend","containerName":"next_result"},{"containerName":"next_result","name":"$hstart","line":206,"kind":13},{"line":206,"kind":13,"containerName":"next_result","name":"$hend"},{"containerName":"next_result","name":"$evalue","line":206,"kind":13},{"containerName":"next_result","name":"$bits","kind":13,"line":206},{"name":"@fields","containerName":"next_result","kind":13,"line":206},{"containerName":"next_result","name":"@fields","line":208,"kind":13},{"kind":13,"line":209,"name":"$qname","containerName":"next_result"},{"containerName":"next_result","name":"$hname","line":209,"kind":13},{"containerName":"next_result","name":"$percent_id","line":209,"kind":13},{"kind":13,"line":209,"containerName":"next_result","name":"$percent_pos"},{"kind":13,"line":209,"name":"$hsp_len","containerName":"next_result"},{"line":209,"kind":13,"name":"$mismatches","containerName":"next_result"},{"containerName":"next_result","name":"$gapsm","line":209,"kind":13},{"containerName":"next_result","name":"$qstart","kind":13,"line":210},{"containerName":"next_result","name":"$qend","line":210,"kind":13},{"kind":13,"line":210,"containerName":"next_result","name":"$hstart"},{"name":"$hend","containerName":"next_result","kind":13,"line":210},{"kind":13,"line":210,"containerName":"next_result","name":"$evalue"},{"name":"$bits","containerName":"next_result","kind":13,"line":210},{"kind":13,"line":210,"name":"@fields","containerName":"next_result"},{"kind":13,"line":213,"containerName":"next_result","name":"@fields"},{"name":"@fields","containerName":"next_result","line":213,"kind":13},{"line":214,"kind":13,"containerName":"next_result","name":"$qname"},{"containerName":"next_result","name":"$hname","kind":13,"line":214},{"name":"$evalue","containerName":"next_result","line":214,"kind":13},{"kind":13,"line":214,"containerName":"next_result","name":"$num_scores"},{"line":214,"kind":13,"containerName":"next_result","name":"$bits"},{"kind":13,"line":214,"containerName":"next_result","name":"$raw_score"},{"containerName":"next_result","name":"$hsp_len","kind":13,"line":214},{"name":"$identities","containerName":"next_result","line":215,"kind":13},{"containerName":"next_result","name":"$positives","kind":13,"line":215},{"line":215,"kind":13,"name":"$mismatches","containerName":"next_result"},{"line":215,"kind":13,"name":"$percent_id","containerName":"next_result"},{"name":"$percent_pos","containerName":"next_result","line":215,"kind":13},{"line":216,"kind":13,"name":"$qgap_blocks","containerName":"next_result"},{"name":"$qgaps","containerName":"next_result","line":216,"kind":13},{"line":216,"kind":13,"name":"$sgap_blocks","containerName":"next_result"},{"containerName":"next_result","name":"$sgaps","line":216,"kind":13},{"kind":13,"line":216,"name":"$qframe","containerName":"next_result"},{"line":216,"kind":13,"containerName":"next_result","name":"$qstart"},{"kind":13,"line":217,"containerName":"next_result","name":"$qend"},{"containerName":"next_result","name":"$sframe","line":217,"kind":13},{"kind":13,"line":217,"name":"$hstart","containerName":"next_result"},{"line":217,"kind":13,"containerName":"next_result","name":"$hend"},{"containerName":"next_result","name":"@fields","kind":13,"line":217},{"line":219,"kind":13,"name":"$gapsm","containerName":"next_result"},{"line":219,"kind":13,"containerName":"next_result","name":"$qgaps"},{"name":"$sgaps","containerName":"next_result","kind":13,"line":219},{"containerName":"next_result","name":"$lastquery","kind":13,"line":223},{"containerName":"next_result","name":"$lastquery","line":224,"kind":13},{"line":224,"kind":13,"containerName":"next_result","name":"$qname"},{"containerName":"next_result","name":"$self","line":225,"kind":13},{"line":225,"kind":12,"containerName":"next_result","name":"end_element"},{"containerName":"next_result","name":"$self","kind":13,"line":226},{"kind":12,"line":226,"name":"end_element","containerName":"next_result"},{"containerName":"next_result","name":"$self","line":227,"kind":13},{"kind":12,"line":227,"name":"_pushback","containerName":"next_result"},{"name":"$self","containerName":"next_result","line":228,"kind":13},{"line":228,"kind":12,"containerName":"next_result","name":"end_document"},{"line":229,"kind":13,"name":"$lastquery","containerName":"next_result"},{"kind":13,"line":230,"containerName":"next_result","name":"$self"},{"kind":13,"line":231,"name":"$self","containerName":"next_result"},{"name":"start_element","containerName":"next_result","kind":12,"line":231},{"line":232,"kind":13,"name":"$self","containerName":"next_result"},{"kind":12,"line":232,"containerName":"next_result","name":"element"},{"line":233,"kind":13,"name":"$alg","containerName":"next_result"},{"kind":13,"line":233,"name":"$self","containerName":"next_result"},{"name":"program_name","containerName":"next_result","kind":12,"line":233},{"line":234,"kind":13,"name":"$self","containerName":"next_result"},{"name":"element","containerName":"next_result","kind":12,"line":234},{"line":235,"kind":13,"containerName":"next_result","name":"$ver"},{"name":"$ver","containerName":"next_result","kind":13,"line":235},{"kind":13,"line":236,"name":"$self","containerName":"next_result"},{"containerName":"next_result","name":"element","line":236,"kind":12},{"kind":13,"line":237,"containerName":"next_result","name":"$qname"},{"name":"$self","containerName":"next_result","line":238,"kind":13},{"containerName":"next_result","name":"start_element","line":238,"kind":12},{"line":239,"kind":13,"name":"$self","containerName":"next_result"},{"containerName":"next_result","name":"element","line":239,"kind":12},{"kind":13,"line":240,"containerName":"next_result","name":"$hname"},{"containerName":"next_result","name":"$self","kind":13,"line":242},{"line":242,"kind":12,"name":"element","containerName":"next_result"},{"name":"$bits","containerName":"next_result","kind":13,"line":243},{"line":245,"kind":13,"containerName":"next_result","name":"$self"},{"line":245,"kind":12,"containerName":"next_result","name":"element"},{"containerName":"next_result","name":"$evalue","line":246,"kind":13},{"line":248,"kind":13,"name":"$lasthit","containerName":"next_result"},{"kind":13,"line":248,"name":"$hname","containerName":"next_result"},{"containerName":"next_result","name":"$self","line":249,"kind":13},{"kind":12,"line":249,"name":"in_element","containerName":"next_result"},{"containerName":"next_result","name":"$self","line":250,"kind":13},{"name":"end_element","containerName":"next_result","kind":12,"line":250},{"line":252,"kind":13,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"start_element","line":252,"kind":12},{"containerName":"next_result","name":"$self","line":253,"kind":13},{"line":253,"kind":12,"name":"element","containerName":"next_result"},{"line":254,"kind":13,"containerName":"next_result","name":"$hname"},{"line":256,"kind":13,"containerName":"next_result","name":"$self"},{"name":"element","containerName":"next_result","kind":12,"line":256},{"kind":13,"line":257,"containerName":"next_result","name":"$bits"},{"line":259,"kind":13,"containerName":"next_result","name":"$self"},{"line":259,"kind":12,"name":"element","containerName":"next_result"},{"kind":13,"line":260,"containerName":"next_result","name":"$evalue"},{"localvar":"my","containerName":"next_result","name":"$identical","definition":"my","line":262,"kind":13},{"name":"$hsp_len","containerName":"next_result","line":262,"kind":13},{"containerName":"next_result","name":"$mismatches","line":262,"kind":13},{"kind":13,"line":262,"containerName":"next_result","name":"$gapsm"},{"line":263,"kind":13,"name":"$self","containerName":"next_result"},{"kind":12,"line":263,"containerName":"next_result","name":"start_element"},{"containerName":"next_result","name":"$self","line":264,"kind":13},{"kind":12,"line":264,"containerName":"next_result","name":"element"},{"containerName":"next_result","name":"$evalue","kind":13,"line":265},{"containerName":"next_result","name":"$self","line":266,"kind":13},{"line":266,"kind":12,"name":"element","containerName":"next_result"},{"name":"$bits","containerName":"next_result","kind":13,"line":267},{"name":"$self","containerName":"next_result","kind":13,"line":268},{"name":"element","containerName":"next_result","line":268,"kind":12},{"kind":13,"line":269,"containerName":"next_result","name":"$identical"},{"line":270,"kind":13,"name":"$self","containerName":"next_result"},{"name":"element","containerName":"next_result","kind":12,"line":270},{"line":271,"kind":13,"name":"$positives","containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":272},{"containerName":"next_result","name":"element","line":272,"kind":12},{"kind":13,"line":273,"containerName":"next_result","name":"$gapsm"},{"kind":13,"line":274,"name":"$self","containerName":"next_result"},{"containerName":"next_result","name":"element","kind":12,"line":274},{"containerName":"next_result","name":"$qstart","kind":13,"line":275},{"line":276,"kind":13,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"element","line":276,"kind":12},{"name":"$qend","containerName":"next_result","kind":13,"line":277},{"line":279,"kind":13,"name":"$self","containerName":"next_result"},{"line":279,"kind":12,"name":"element","containerName":"next_result"},{"name":"$hstart","containerName":"next_result","line":280,"kind":13},{"line":281,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"line":281,"containerName":"next_result","name":"element"},{"containerName":"next_result","name":"$hend","kind":13,"line":282},{"containerName":"next_result","name":"$self","kind":13,"line":283},{"containerName":"next_result","name":"element","kind":12,"line":283},{"containerName":"next_result","name":"$hsp_len","line":284,"kind":13},{"line":285,"kind":13,"containerName":"next_result","name":"$self"},{"name":"end_element","containerName":"next_result","kind":12,"line":285},{"name":"$lastquery","containerName":"next_result","line":286,"kind":13},{"kind":13,"line":286,"name":"$qname","containerName":"next_result"},{"name":"$lasthit","containerName":"next_result","line":287,"kind":13},{"name":"$hname","containerName":"next_result","line":287,"kind":13},{"containerName":"next_result","name":"$lasthit","kind":13,"line":290},{"name":"$lastquery","containerName":"next_result","kind":13,"line":290},{"containerName":"next_result","name":"$self","line":291,"kind":13},{"line":291,"kind":12,"name":"in_element","containerName":"next_result"},{"kind":13,"line":292,"containerName":"next_result","name":"$self"},{"line":292,"kind":12,"name":"end_element","containerName":"next_result"},{"line":294,"kind":13,"containerName":"next_result","name":"$self"},{"name":"end_element","containerName":"next_result","line":294,"kind":12},{"name":"$self","containerName":"next_result","kind":13,"line":295},{"kind":12,"line":295,"name":"end_document","containerName":"next_result"}]},{"name":"start_element","range":{"end":{"line":321,"character":9999},"start":{"line":310,"character":0}},"kind":12,"children":[{"line":311,"kind":13,"localvar":"my","containerName":"start_element","definition":"my","name":"$self"},{"kind":13,"line":311,"containerName":"start_element","name":"$data"},{"kind":13,"line":313,"containerName":"start_element","name":"$nm","definition":"my","localvar":"my"},{"containerName":"start_element","name":"$data","kind":13,"line":313},{"localvar":"my","name":"$type","definition":"my","containerName":"start_element","line":314,"kind":13},{"containerName":"start_element","name":"$MODEMAP","kind":13,"line":314},{"kind":13,"line":314,"name":"$nm","containerName":"start_element"},{"kind":13,"line":315,"name":"$self","containerName":"start_element"},{"containerName":"start_element","name":"_mode","kind":12,"line":315},{"line":315,"kind":13,"containerName":"start_element","name":"$type"},{"name":"$self","containerName":"start_element","line":316,"kind":13},{"name":"_will_handle","containerName":"start_element","kind":12,"line":316},{"containerName":"start_element","name":"$type","line":316,"kind":13},{"line":317,"kind":13,"localvar":"my","name":"$func","definition":"my","containerName":"start_element"},{"containerName":"start_element","name":"$type","line":317,"kind":13},{"containerName":"start_element","name":"$self","kind":13,"line":318},{"name":"_eventHandler","containerName":"start_element","kind":12,"line":318},{"line":318,"kind":13,"name":"$func","containerName":"start_element"},{"containerName":"start_element","name":"$data","kind":13,"line":318},{"containerName":"start_element","name":"$self","line":320,"kind":13},{"containerName":"start_element","name":"$type","kind":13,"line":320}],"line":310,"definition":"sub","containerName":"main::","signature":{"label":"start_element($self,$data)","parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: blasttable.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blasttable\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::blasttable - Driver module for SearchIO for parsing NCBI -m 8/9 format\n\n=head1 SYNOPSIS\n\n  # do not use this module directly\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => $file,\n                                 -format => 'blasttable');\n\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis module will support parsing NCBI -m 8 or -m 9 tabular output\nand WU-BLAST -mformat 2 or -mformat 3 tabular output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::blasttable;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\nuse strict;\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::HSP::HSPFactory;\n\n$DefaultProgramName = 'BLASTN';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\n%MAPPING = ( \n\t     'Hsp_bit-score'  => 'HSP-bits',\n\t     'Hsp_score'      => 'HSP-score',\n\t     'Hsp_evalue'     => 'HSP-evalue',\n\t     'Hsp_query-from' => 'HSP-query_start',\n\t     'Hsp_query-to'   => 'HSP-query_end',\n\t     'Hsp_hit-from'   => 'HSP-hit_start',\n\t     'Hsp_hit-to'     => 'HSP-hit_end',\n\t     'Hsp_positive'   => 'HSP-conserved',\n\t     'Hsp_identity'   => 'HSP-identical',\n\t     'Hsp_mismatches' => 'HSP-mismatches',\n\t     'Hsp_qgapblocks' => 'HSP-query_gapblocks',\n\t     'Hsp_hgapblocks' => 'HSP-hit_gapblocks',\n\t     'Hsp_gaps'       => 'HSP-hsp_gaps',\n\t     'Hsp_hitgaps'    => 'HSP-hit_gaps',\n\t     'Hsp_querygaps'  => 'HSP-query_gaps',\n\t     'Hsp_align-len'  => 'HSP-hsp_length',\n\t     'Hsp_query-frame'=> 'HSP-query_frame',\n\t     'Hsp_hit-frame'  => 'HSP-hit_frame',\n\n\t     'Hit_id'        => 'HIT-name',\n\t     'Hit_len'       => 'HIT-length',\n\t     'Hit_accession' => 'HIT-accession',\n\t     'Hit_def'       => 'HIT-description',\n\t     'Hit_signif'    => 'HIT-significance',\n\t     'Hit_score'     => 'HIT-score',\n\t     'Hit_bits'      => 'HIT-bits',\n\n\t     'Result_program'  => 'RESULT-algorithm_name',\n\t     'Result_version'  => 'RESULT-algorithm_version',\n\t     'Result_query-def'=> 'RESULT-query_name',\n\t     'Result_query-len'=> 'RESULT-query_length',\n\t     'Result_query-acc'=> 'RESULT-query_accession',\n\t     'Result_querydesc'=> 'RESULT-query_description',\n\t     'Result_db'       => 'RESULT-database_name',\n\t     'Result_db-len'   => 'RESULT-database_entries',\n\t     'Result_db-let'   => 'RESULT-database_letters',\n\t     );\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blasttable->new();\n Function: Builds a new Bio::SearchIO::blasttable object \n Returns : an instance of Bio::SearchIO::blasttable\n Args    :\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n\n    my ($pname) = $self->_rearrange([qw(PROGRAM_NAME)],\n\t\t\t\t    @args);\n    $self->program_name($pname || $DefaultProgramName);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n    $self->_eventHandler->register_factory('hit', Bio::Search::Hit::HitFactory->new(-type => 'Bio::Search::Hit::GenericHit'));\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI>\n Args    : none\n\n\n\nsub next_result{\n   my ($self) = @_;\n   my ($lastquery,$lasthit);\n   local $/ = \"\\n\";\n   local $_;\n   my ($alg, $ver);\n   while( defined ($_ = $self->_readline) ) {\n\t  # WU-BLAST -mformat 3 only\n\t  if(m{^#\\s((?:\\S+?)?BLAST[NPX])\\s(\\d+\\.\\d+.+\\d{4}\\])}) {\n            ($alg, $ver) = ($1, $2);\n\t\t\t# only one header for whole file with WU-BLAST\n\t\t\t# so $alg and $ver won't get set properly for\n\t\t\t# each result\n\t\t\t$self->program_name($alg) if $alg;\n\t\t\t$self->element({'Name' => 'Result_version',\n\t\t\t\t\t   \t\t'Data' => $ver}) if $ver;\n            next;\n\t  }\n      # -m 9 only\n      elsif(m{^#\\s+((?:\\S+?)?BLAST[NPX])\\s+(.+)}) {\n            ($alg, $ver) = ($1, $2);\n            next;\n       }\n       next if /^#/ || /^\\s*$/;\n\n\t  my @fields = split;\n      next if @fields == 1;\n\t  my ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t      $qstart,$qend,$hstart,$hend,$evalue,$bits);\n\t  # WU-BLAST-specific\n\t  my ($num_scores, $raw_score, $identities, $positives, $percent_pos,\n\t      $qgap_blocks,$qgaps, $sgap_blocks, $sgaps, $qframe,\n\t      $sframe);\n\t  # NCBI -m8 and -m9\n\t  if (@fields == 12) {\n\t      ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n\t  # NCBI -m8 and -m9, v 2.2.18+\n\t  } elsif (@fields == 13) {\n          ($qname, $hname, $percent_id, $percent_pos, $hsp_len, $mismatches, $gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n      }\n\t  # WU-BLAST -mformat 2 and 3\n\t  elsif ((@fields == 22) or (@fields == 24)) {\n\t      ($qname,$hname,$evalue,$num_scores, $bits, $raw_score, $hsp_len,\n\t       $identities, $positives,$mismatches, $percent_id, $percent_pos,\n\t       $qgap_blocks, $qgaps, $sgap_blocks, $sgaps, $qframe, $qstart,\n\t       $qend, $sframe, $hstart,$hend,) = @fields;\n\t      # we need total gaps in the alignment\n\t      $gapsm=$qgaps+$sgaps;\n\t  }\n\n       # Remember Jim's code is 0 based\n       if( defined $lastquery && \n\t   $lastquery ne $qname ) {\n\t   $self->end_element({'Name' => 'Hit'});\n\t   $self->end_element({'Name' => 'Result'});\n\t   $self->_pushback($_);\n\t   return $self->end_document;\n       } elsif( ! defined $lastquery ) {\n\t   $self->{'_result_count'}++;\n\t   $self->start_element({'Name' => 'Result'});\n\t   $self->element({'Name' => 'Result_program',\n\t\t\t   'Data' => $alg || $self->program_name});\n       $self->element({'Name' => 'Result_version',\n\t\t\t   'Data' => $ver}) if $ver;\n\t   $self->element({'Name' => 'Result_query-def',\n\t\t\t   'Data' => $qname});\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n\t   \n       } elsif( $lasthit ne $hname ) {\n\t   if( $self->in_element('hit') ) {\t       \n\t       $self->end_element({'Name' => 'Hit'});\n\t   }\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n       }\n       my $identical = $hsp_len - $mismatches - $gapsm;\n       $self->start_element({'Name' => 'Hsp'});\n       $self->element({'Name' => 'Hsp_evalue',\t\t\t   \n\t\t       'Data' => $evalue});       \n       $self->element({'Name' => 'Hsp_bit-score',\n\t\t       'Data' => $bits});\n       $self->element({'Name' => 'Hsp_identity',\n\t\t       'Data' => $identical});\n       $self->element({'Name' => 'Hsp_positive',\n\t\t       'Data' => $positives});\n       $self->element({'Name' => 'Hsp_gaps',\n\t\t       'Data' => $gapsm});\n       $self->element({'Name' => 'Hsp_query-from',\n\t\t       'Data' => $qstart});\n       $self->element({'Name' => 'Hsp_query-to',\n\t\t       'Data' => $qend});\n\n       $self->element({'Name' => 'Hsp_hit-from',\n\t\t       'Data' => $hstart });\n       $self->element({'Name' => 'Hsp_hit-to',\n\t\t       'Data' => $hend });\n       $self->element({'Name' => 'Hsp_align-len',\n\t\t       'Data' => $hsp_len});\n       $self->end_element({'Name' => 'Hsp'});\n       $lastquery = $qname;\n       $lasthit   = $hname;\n   }\n   # fencepost\n   if( defined $lasthit && defined $lastquery ) {\n       if( $self->in_element('hit') ) {\n\t   $self->end_element({'Name' => 'Hit'});\n       }\n       $self->end_element({'Name' => 'Result'});\n       return $self->end_document;\n   }\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'"},"detail":"($self,$data)"},{"containerName":null,"name":"%nm","line":322,"kind":13},{"line":323,"kind":13,"containerName":null,"name":"%self"},{"name":"%self","containerName":null,"line":324,"kind":13},{"line":325,"kind":13,"containerName":null,"name":"%self"},{"containerName":"main::","definition":"sub","detail":"($self,$data)","signature":{"parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: blasttable.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blasttable\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::blasttable - Driver module for SearchIO for parsing NCBI -m 8/9 format\n\n=head1 SYNOPSIS\n\n  # do not use this module directly\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => $file,\n                                 -format => 'blasttable');\n\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis module will support parsing NCBI -m 8 or -m 9 tabular output\nand WU-BLAST -mformat 2 or -mformat 3 tabular output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::blasttable;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\nuse strict;\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::HSP::HSPFactory;\n\n$DefaultProgramName = 'BLASTN';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\n%MAPPING = ( \n\t     'Hsp_bit-score'  => 'HSP-bits',\n\t     'Hsp_score'      => 'HSP-score',\n\t     'Hsp_evalue'     => 'HSP-evalue',\n\t     'Hsp_query-from' => 'HSP-query_start',\n\t     'Hsp_query-to'   => 'HSP-query_end',\n\t     'Hsp_hit-from'   => 'HSP-hit_start',\n\t     'Hsp_hit-to'     => 'HSP-hit_end',\n\t     'Hsp_positive'   => 'HSP-conserved',\n\t     'Hsp_identity'   => 'HSP-identical',\n\t     'Hsp_mismatches' => 'HSP-mismatches',\n\t     'Hsp_qgapblocks' => 'HSP-query_gapblocks',\n\t     'Hsp_hgapblocks' => 'HSP-hit_gapblocks',\n\t     'Hsp_gaps'       => 'HSP-hsp_gaps',\n\t     'Hsp_hitgaps'    => 'HSP-hit_gaps',\n\t     'Hsp_querygaps'  => 'HSP-query_gaps',\n\t     'Hsp_align-len'  => 'HSP-hsp_length',\n\t     'Hsp_query-frame'=> 'HSP-query_frame',\n\t     'Hsp_hit-frame'  => 'HSP-hit_frame',\n\n\t     'Hit_id'        => 'HIT-name',\n\t     'Hit_len'       => 'HIT-length',\n\t     'Hit_accession' => 'HIT-accession',\n\t     'Hit_def'       => 'HIT-description',\n\t     'Hit_signif'    => 'HIT-significance',\n\t     'Hit_score'     => 'HIT-score',\n\t     'Hit_bits'      => 'HIT-bits',\n\n\t     'Result_program'  => 'RESULT-algorithm_name',\n\t     'Result_version'  => 'RESULT-algorithm_version',\n\t     'Result_query-def'=> 'RESULT-query_name',\n\t     'Result_query-len'=> 'RESULT-query_length',\n\t     'Result_query-acc'=> 'RESULT-query_accession',\n\t     'Result_querydesc'=> 'RESULT-query_description',\n\t     'Result_db'       => 'RESULT-database_name',\n\t     'Result_db-len'   => 'RESULT-database_entries',\n\t     'Result_db-let'   => 'RESULT-database_letters',\n\t     );\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blasttable->new();\n Function: Builds a new Bio::SearchIO::blasttable object \n Returns : an instance of Bio::SearchIO::blasttable\n Args    :\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n\n    my ($pname) = $self->_rearrange([qw(PROGRAM_NAME)],\n\t\t\t\t    @args);\n    $self->program_name($pname || $DefaultProgramName);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n    $self->_eventHandler->register_factory('hit', Bio::Search::Hit::HitFactory->new(-type => 'Bio::Search::Hit::GenericHit'));\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI>\n Args    : none\n\n\n\nsub next_result{\n   my ($self) = @_;\n   my ($lastquery,$lasthit);\n   local $/ = \"\\n\";\n   local $_;\n   my ($alg, $ver);\n   while( defined ($_ = $self->_readline) ) {\n\t  # WU-BLAST -mformat 3 only\n\t  if(m{^#\\s((?:\\S+?)?BLAST[NPX])\\s(\\d+\\.\\d+.+\\d{4}\\])}) {\n            ($alg, $ver) = ($1, $2);\n\t\t\t# only one header for whole file with WU-BLAST\n\t\t\t# so $alg and $ver won't get set properly for\n\t\t\t# each result\n\t\t\t$self->program_name($alg) if $alg;\n\t\t\t$self->element({'Name' => 'Result_version',\n\t\t\t\t\t   \t\t'Data' => $ver}) if $ver;\n            next;\n\t  }\n      # -m 9 only\n      elsif(m{^#\\s+((?:\\S+?)?BLAST[NPX])\\s+(.+)}) {\n            ($alg, $ver) = ($1, $2);\n            next;\n       }\n       next if /^#/ || /^\\s*$/;\n\n\t  my @fields = split;\n      next if @fields == 1;\n\t  my ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t      $qstart,$qend,$hstart,$hend,$evalue,$bits);\n\t  # WU-BLAST-specific\n\t  my ($num_scores, $raw_score, $identities, $positives, $percent_pos,\n\t      $qgap_blocks,$qgaps, $sgap_blocks, $sgaps, $qframe,\n\t      $sframe);\n\t  # NCBI -m8 and -m9\n\t  if (@fields == 12) {\n\t      ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n\t  # NCBI -m8 and -m9, v 2.2.18+\n\t  } elsif (@fields == 13) {\n          ($qname, $hname, $percent_id, $percent_pos, $hsp_len, $mismatches, $gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n      }\n\t  # WU-BLAST -mformat 2 and 3\n\t  elsif ((@fields == 22) or (@fields == 24)) {\n\t      ($qname,$hname,$evalue,$num_scores, $bits, $raw_score, $hsp_len,\n\t       $identities, $positives,$mismatches, $percent_id, $percent_pos,\n\t       $qgap_blocks, $qgaps, $sgap_blocks, $sgaps, $qframe, $qstart,\n\t       $qend, $sframe, $hstart,$hend,) = @fields;\n\t      # we need total gaps in the alignment\n\t      $gapsm=$qgaps+$sgaps;\n\t  }\n\n       # Remember Jim's code is 0 based\n       if( defined $lastquery && \n\t   $lastquery ne $qname ) {\n\t   $self->end_element({'Name' => 'Hit'});\n\t   $self->end_element({'Name' => 'Result'});\n\t   $self->_pushback($_);\n\t   return $self->end_document;\n       } elsif( ! defined $lastquery ) {\n\t   $self->{'_result_count'}++;\n\t   $self->start_element({'Name' => 'Result'});\n\t   $self->element({'Name' => 'Result_program',\n\t\t\t   'Data' => $alg || $self->program_name});\n       $self->element({'Name' => 'Result_version',\n\t\t\t   'Data' => $ver}) if $ver;\n\t   $self->element({'Name' => 'Result_query-def',\n\t\t\t   'Data' => $qname});\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n\t   \n       } elsif( $lasthit ne $hname ) {\n\t   if( $self->in_element('hit') ) {\t       \n\t       $self->end_element({'Name' => 'Hit'});\n\t   }\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n       }\n       my $identical = $hsp_len - $mismatches - $gapsm;\n       $self->start_element({'Name' => 'Hsp'});\n       $self->element({'Name' => 'Hsp_evalue',\t\t\t   \n\t\t       'Data' => $evalue});       \n       $self->element({'Name' => 'Hsp_bit-score',\n\t\t       'Data' => $bits});\n       $self->element({'Name' => 'Hsp_identity',\n\t\t       'Data' => $identical});\n       $self->element({'Name' => 'Hsp_positive',\n\t\t       'Data' => $positives});\n       $self->element({'Name' => 'Hsp_gaps',\n\t\t       'Data' => $gapsm});\n       $self->element({'Name' => 'Hsp_query-from',\n\t\t       'Data' => $qstart});\n       $self->element({'Name' => 'Hsp_query-to',\n\t\t       'Data' => $qend});\n\n       $self->element({'Name' => 'Hsp_hit-from',\n\t\t       'Data' => $hstart });\n       $self->element({'Name' => 'Hsp_hit-to',\n\t\t       'Data' => $hend });\n       $self->element({'Name' => 'Hsp_align-len',\n\t\t       'Data' => $hsp_len});\n       $self->end_element({'Name' => 'Hsp'});\n       $lastquery = $qname;\n       $lasthit   = $hname;\n   }\n   # fencepost\n   if( defined $lasthit && defined $lastquery ) {\n       if( $self->in_element('hit') ) {\n\t   $self->end_element({'Name' => 'Hit'});\n       }\n       $self->end_element({'Name' => 'Result'});\n       return $self->end_document;\n   }\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'Result') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'","label":"end_element($self,$data)"},"kind":12,"line":341,"children":[{"containerName":"end_element","name":"$self","definition":"my","localvar":"my","kind":13,"line":342},{"line":342,"kind":13,"containerName":"end_element","name":"$data"},{"localvar":"my","name":"$nm","definition":"my","containerName":"end_element","line":343,"kind":13},{"line":343,"kind":13,"name":"$data","containerName":"end_element"},{"name":"$rc","definition":"my","containerName":"end_element","localvar":"my","kind":13,"line":344},{"line":348,"kind":13,"localvar":"my","containerName":"end_element","name":"$type","definition":"my"},{"line":348,"kind":13,"name":"$MODEMAP","containerName":"end_element"},{"name":"$nm","containerName":"end_element","line":348,"kind":13},{"containerName":"end_element","name":"$self","kind":13,"line":349},{"containerName":"end_element","name":"_will_handle","kind":12,"line":349},{"name":"$type","containerName":"end_element","line":349,"kind":13},{"containerName":"end_element","name":"$func","definition":"my","localvar":"my","kind":13,"line":350},{"kind":13,"line":350,"name":"$type","containerName":"end_element"},{"name":"$rc","containerName":"end_element","kind":13,"line":351},{"containerName":"end_element","name":"$self","line":351,"kind":13},{"line":351,"kind":12,"containerName":"end_element","name":"_eventHandler"},{"line":351,"kind":13,"name":"$func","containerName":"end_element"},{"line":351,"kind":13,"name":"$self","containerName":"end_element"},{"line":352,"kind":13,"containerName":"end_element","name":"$self"},{"kind":13,"line":354,"name":"$self","containerName":"end_element"}],"name":"end_element","range":{"end":{"line":356,"character":9999},"start":{"character":0,"line":341}}},{"containerName":null,"name":"%MAPPING","kind":13,"line":356},{"containerName":null,"name":"%nm","line":356,"kind":13},{"containerName":null,"name":"%MAPPING","kind":13,"line":357},{"line":357,"kind":13,"name":"%nm","containerName":null},{"localvar":"my","name":"$key","definition":"my","containerName":null,"line":358,"kind":13},{"name":"%MAPPING","containerName":null,"kind":13,"line":358},{"name":"@nm","containerName":null,"line":358,"kind":13},{"containerName":null,"name":"%self","line":359,"kind":13},{"line":359,"kind":13,"name":"%key","containerName":null},{"name":"%MAPPING","containerName":null,"kind":13,"line":359},{"line":359,"kind":13,"containerName":null,"name":"%nm"},{"containerName":null,"name":"$key","kind":13,"line":359},{"kind":13,"line":359,"containerName":null,"name":"%self"},{"kind":13,"line":361,"name":"%self","containerName":null},{"name":"%MAPPING","containerName":null,"line":361,"kind":13},{"name":"$nm","containerName":null,"line":361,"kind":13},{"name":"%self","containerName":null,"kind":13,"line":361},{"name":"$self","containerName":null,"line":364,"kind":13},{"line":364,"kind":12,"containerName":"main::","name":"warn"},{"containerName":null,"name":"%self","line":366,"kind":13},{"kind":13,"line":368,"name":"%self","containerName":null},{"line":368,"kind":13,"containerName":null,"name":"$rc"},{"kind":13,"line":368,"containerName":null,"name":"$nm"},{"containerName":null,"name":"$rc","line":369,"kind":13},{"kind":12,"children":[{"line":385,"kind":13,"localvar":"my","containerName":"element","name":"$self","definition":"my"},{"containerName":"element","name":"$data","kind":13,"line":385},{"line":386,"kind":13,"name":"$self","containerName":"element"},{"containerName":"element","name":"start_element","kind":12,"line":386},{"name":"$data","containerName":"element","kind":13,"line":386},{"name":"$self","containerName":"element","line":387,"kind":13},{"kind":12,"line":387,"containerName":"element","name":"characters"},{"name":"$data","containerName":"element","line":387,"kind":13},{"name":"$self","containerName":"element","line":388,"kind":13},{"containerName":"element","name":"end_element","line":388,"kind":12},{"kind":13,"line":388,"containerName":"element","name":"$data"}],"line":384,"definition":"sub","containerName":"main::","signature":{"label":"element($self,$data)","documentation":"1;\n# $Id: blasttable.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blasttable\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::blasttable - Driver module for SearchIO for parsing NCBI -m 8/9 format\n\n=head1 SYNOPSIS\n\n  # do not use this module directly\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => $file,\n                                 -format => 'blasttable');\n\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis module will support parsing NCBI -m 8 or -m 9 tabular output\nand WU-BLAST -mformat 2 or -mformat 3 tabular output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::blasttable;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\nuse strict;\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::HSP::HSPFactory;\n\n$DefaultProgramName = 'BLASTN';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\n%MAPPING = ( \n\t     'Hsp_bit-score'  => 'HSP-bits',\n\t     'Hsp_score'      => 'HSP-score',\n\t     'Hsp_evalue'     => 'HSP-evalue',\n\t     'Hsp_query-from' => 'HSP-query_start',\n\t     'Hsp_query-to'   => 'HSP-query_end',\n\t     'Hsp_hit-from'   => 'HSP-hit_start',\n\t     'Hsp_hit-to'     => 'HSP-hit_end',\n\t     'Hsp_positive'   => 'HSP-conserved',\n\t     'Hsp_identity'   => 'HSP-identical',\n\t     'Hsp_mismatches' => 'HSP-mismatches',\n\t     'Hsp_qgapblocks' => 'HSP-query_gapblocks',\n\t     'Hsp_hgapblocks' => 'HSP-hit_gapblocks',\n\t     'Hsp_gaps'       => 'HSP-hsp_gaps',\n\t     'Hsp_hitgaps'    => 'HSP-hit_gaps',\n\t     'Hsp_querygaps'  => 'HSP-query_gaps',\n\t     'Hsp_align-len'  => 'HSP-hsp_length',\n\t     'Hsp_query-frame'=> 'HSP-query_frame',\n\t     'Hsp_hit-frame'  => 'HSP-hit_frame',\n\n\t     'Hit_id'        => 'HIT-name',\n\t     'Hit_len'       => 'HIT-length',\n\t     'Hit_accession' => 'HIT-accession',\n\t     'Hit_def'       => 'HIT-description',\n\t     'Hit_signif'    => 'HIT-significance',\n\t     'Hit_score'     => 'HIT-score',\n\t     'Hit_bits'      => 'HIT-bits',\n\n\t     'Result_program'  => 'RESULT-algorithm_name',\n\t     'Result_version'  => 'RESULT-algorithm_version',\n\t     'Result_query-def'=> 'RESULT-query_name',\n\t     'Result_query-len'=> 'RESULT-query_length',\n\t     'Result_query-acc'=> 'RESULT-query_accession',\n\t     'Result_querydesc'=> 'RESULT-query_description',\n\t     'Result_db'       => 'RESULT-database_name',\n\t     'Result_db-len'   => 'RESULT-database_entries',\n\t     'Result_db-let'   => 'RESULT-database_letters',\n\t     );\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blasttable->new();\n Function: Builds a new Bio::SearchIO::blasttable object \n Returns : an instance of Bio::SearchIO::blasttable\n Args    :\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n\n    my ($pname) = $self->_rearrange([qw(PROGRAM_NAME)],\n\t\t\t\t    @args);\n    $self->program_name($pname || $DefaultProgramName);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n    $self->_eventHandler->register_factory('hit', Bio::Search::Hit::HitFactory->new(-type => 'Bio::Search::Hit::GenericHit'));\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI>\n Args    : none\n\n\n\nsub next_result{\n   my ($self) = @_;\n   my ($lastquery,$lasthit);\n   local $/ = \"\\n\";\n   local $_;\n   my ($alg, $ver);\n   while( defined ($_ = $self->_readline) ) {\n\t  # WU-BLAST -mformat 3 only\n\t  if(m{^#\\s((?:\\S+?)?BLAST[NPX])\\s(\\d+\\.\\d+.+\\d{4}\\])}) {\n            ($alg, $ver) = ($1, $2);\n\t\t\t# only one header for whole file with WU-BLAST\n\t\t\t# so $alg and $ver won't get set properly for\n\t\t\t# each result\n\t\t\t$self->program_name($alg) if $alg;\n\t\t\t$self->element({'Name' => 'Result_version',\n\t\t\t\t\t   \t\t'Data' => $ver}) if $ver;\n            next;\n\t  }\n      # -m 9 only\n      elsif(m{^#\\s+((?:\\S+?)?BLAST[NPX])\\s+(.+)}) {\n            ($alg, $ver) = ($1, $2);\n            next;\n       }\n       next if /^#/ || /^\\s*$/;\n\n\t  my @fields = split;\n      next if @fields == 1;\n\t  my ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t      $qstart,$qend,$hstart,$hend,$evalue,$bits);\n\t  # WU-BLAST-specific\n\t  my ($num_scores, $raw_score, $identities, $positives, $percent_pos,\n\t      $qgap_blocks,$qgaps, $sgap_blocks, $sgaps, $qframe,\n\t      $sframe);\n\t  # NCBI -m8 and -m9\n\t  if (@fields == 12) {\n\t      ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n\t  # NCBI -m8 and -m9, v 2.2.18+\n\t  } elsif (@fields == 13) {\n          ($qname, $hname, $percent_id, $percent_pos, $hsp_len, $mismatches, $gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n      }\n\t  # WU-BLAST -mformat 2 and 3\n\t  elsif ((@fields == 22) or (@fields == 24)) {\n\t      ($qname,$hname,$evalue,$num_scores, $bits, $raw_score, $hsp_len,\n\t       $identities, $positives,$mismatches, $percent_id, $percent_pos,\n\t       $qgap_blocks, $qgaps, $sgap_blocks, $sgaps, $qframe, $qstart,\n\t       $qend, $sframe, $hstart,$hend,) = @fields;\n\t      # we need total gaps in the alignment\n\t      $gapsm=$qgaps+$sgaps;\n\t  }\n\n       # Remember Jim's code is 0 based\n       if( defined $lastquery && \n\t   $lastquery ne $qname ) {\n\t   $self->end_element({'Name' => 'Hit'});\n\t   $self->end_element({'Name' => 'Result'});\n\t   $self->_pushback($_);\n\t   return $self->end_document;\n       } elsif( ! defined $lastquery ) {\n\t   $self->{'_result_count'}++;\n\t   $self->start_element({'Name' => 'Result'});\n\t   $self->element({'Name' => 'Result_program',\n\t\t\t   'Data' => $alg || $self->program_name});\n       $self->element({'Name' => 'Result_version',\n\t\t\t   'Data' => $ver}) if $ver;\n\t   $self->element({'Name' => 'Result_query-def',\n\t\t\t   'Data' => $qname});\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n\t   \n       } elsif( $lasthit ne $hname ) {\n\t   if( $self->in_element('hit') ) {\t       \n\t       $self->end_element({'Name' => 'Hit'});\n\t   }\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n       }\n       my $identical = $hsp_len - $mismatches - $gapsm;\n       $self->start_element({'Name' => 'Hsp'});\n       $self->element({'Name' => 'Hsp_evalue',\t\t\t   \n\t\t       'Data' => $evalue});       \n       $self->element({'Name' => 'Hsp_bit-score',\n\t\t       'Data' => $bits});\n       $self->element({'Name' => 'Hsp_identity',\n\t\t       'Data' => $identical});\n       $self->element({'Name' => 'Hsp_positive',\n\t\t       'Data' => $positives});\n       $self->element({'Name' => 'Hsp_gaps',\n\t\t       'Data' => $gapsm});\n       $self->element({'Name' => 'Hsp_query-from',\n\t\t       'Data' => $qstart});\n       $self->element({'Name' => 'Hsp_query-to',\n\t\t       'Data' => $qend});\n\n       $self->element({'Name' => 'Hsp_hit-from',\n\t\t       'Data' => $hstart });\n       $self->element({'Name' => 'Hsp_hit-to',\n\t\t       'Data' => $hend });\n       $self->element({'Name' => 'Hsp_align-len',\n\t\t       'Data' => $hsp_len});\n       $self->end_element({'Name' => 'Hsp'});\n       $lastquery = $qname;\n       $lasthit   = $hname;\n   }\n   # fencepost\n   if( defined $lasthit && defined $lastquery ) {\n       if( $self->in_element('hit') ) {\n\t   $self->end_element({'Name' => 'Hit'});\n       }\n       $self->end_element({'Name' => 'Result'});\n       return $self->end_document;\n   }\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'Result') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n        \n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'Result' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'","parameters":[{"label":"$self"},{"label":"$data"}]},"detail":"($self,$data)","name":"element","range":{"start":{"line":384,"character":0},"end":{"character":9999,"line":389}}},{"kind":12,"line":403,"children":[{"kind":13,"line":404,"containerName":"characters","name":"$self","definition":"my","localvar":"my"},{"name":"$data","containerName":"characters","line":404,"kind":13},{"name":"$data","containerName":"characters","line":414,"kind":13},{"name":"$data","containerName":"characters","kind":13,"line":415},{"name":"$self","containerName":"characters","kind":13,"line":416},{"containerName":"characters","name":"$data","kind":13,"line":419},{"name":"$data","containerName":"characters","kind":13,"line":420},{"name":"$self","containerName":"characters","kind":13,"line":423},{"name":"in_element","containerName":"characters","kind":12,"line":423},{"line":424,"kind":13,"containerName":"characters","name":"$data"},{"line":426,"kind":13,"containerName":"characters","name":"$self"},{"containerName":"characters","name":"$data","kind":13,"line":426},{"kind":13,"line":426,"containerName":"characters","name":"$data"},{"line":429,"kind":13,"containerName":"characters","name":"$self"},{"line":429,"kind":13,"name":"$data","containerName":"characters"}],"containerName":"main::","definition":"sub","detail":"($self,$data)","signature":{"label":"characters($self,$data)","documentation":"1;\n# $Id: blasttable.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blasttable\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::blasttable - Driver module for SearchIO for parsing NCBI -m 8/9 format\n\n=head1 SYNOPSIS\n\n  # do not use this module directly\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => $file,\n                                 -format => 'blasttable');\n\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis module will support parsing NCBI -m 8 or -m 9 tabular output\nand WU-BLAST -mformat 2 or -mformat 3 tabular output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::blasttable;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\nuse strict;\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::HSP::HSPFactory;\n\n$DefaultProgramName = 'BLASTN';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\n%MAPPING = ( \n\t     'Hsp_bit-score'  => 'HSP-bits',\n\t     'Hsp_score'      => 'HSP-score',\n\t     'Hsp_evalue'     => 'HSP-evalue',\n\t     'Hsp_query-from' => 'HSP-query_start',\n\t     'Hsp_query-to'   => 'HSP-query_end',\n\t     'Hsp_hit-from'   => 'HSP-hit_start',\n\t     'Hsp_hit-to'     => 'HSP-hit_end',\n\t     'Hsp_positive'   => 'HSP-conserved',\n\t     'Hsp_identity'   => 'HSP-identical',\n\t     'Hsp_mismatches' => 'HSP-mismatches',\n\t     'Hsp_qgapblocks' => 'HSP-query_gapblocks',\n\t     'Hsp_hgapblocks' => 'HSP-hit_gapblocks',\n\t     'Hsp_gaps'       => 'HSP-hsp_gaps',\n\t     'Hsp_hitgaps'    => 'HSP-hit_gaps',\n\t     'Hsp_querygaps'  => 'HSP-query_gaps',\n\t     'Hsp_align-len'  => 'HSP-hsp_length',\n\t     'Hsp_query-frame'=> 'HSP-query_frame',\n\t     'Hsp_hit-frame'  => 'HSP-hit_frame',\n\n\t     'Hit_id'        => 'HIT-name',\n\t     'Hit_len'       => 'HIT-length',\n\t     'Hit_accession' => 'HIT-accession',\n\t     'Hit_def'       => 'HIT-description',\n\t     'Hit_signif'    => 'HIT-significance',\n\t     'Hit_score'     => 'HIT-score',\n\t     'Hit_bits'      => 'HIT-bits',\n\n\t     'Result_program'  => 'RESULT-algorithm_name',\n\t     'Result_version'  => 'RESULT-algorithm_version',\n\t     'Result_query-def'=> 'RESULT-query_name',\n\t     'Result_query-len'=> 'RESULT-query_length',\n\t     'Result_query-acc'=> 'RESULT-query_accession',\n\t     'Result_querydesc'=> 'RESULT-query_description',\n\t     'Result_db'       => 'RESULT-database_name',\n\t     'Result_db-len'   => 'RESULT-database_entries',\n\t     'Result_db-let'   => 'RESULT-database_letters',\n\t     );\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blasttable->new();\n Function: Builds a new Bio::SearchIO::blasttable object \n Returns : an instance of Bio::SearchIO::blasttable\n Args    :\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n\n    my ($pname) = $self->_rearrange([qw(PROGRAM_NAME)],\n\t\t\t\t    @args);\n    $self->program_name($pname || $DefaultProgramName);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n    $self->_eventHandler->register_factory('hit', Bio::Search::Hit::HitFactory->new(-type => 'Bio::Search::Hit::GenericHit'));\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI>\n Args    : none\n\n\n\nsub next_result{\n   my ($self) = @_;\n   my ($lastquery,$lasthit);\n   local $/ = \"\\n\";\n   local $_;\n   my ($alg, $ver);\n   while( defined ($_ = $self->_readline) ) {\n\t  # WU-BLAST -mformat 3 only\n\t  if(m{^#\\s((?:\\S+?)?BLAST[NPX])\\s(\\d+\\.\\d+.+\\d{4}\\])}) {\n            ($alg, $ver) = ($1, $2);\n\t\t\t# only one header for whole file with WU-BLAST\n\t\t\t# so $alg and $ver won't get set properly for\n\t\t\t# each result\n\t\t\t$self->program_name($alg) if $alg;\n\t\t\t$self->element({'Name' => 'Result_version',\n\t\t\t\t\t   \t\t'Data' => $ver}) if $ver;\n            next;\n\t  }\n      # -m 9 only\n      elsif(m{^#\\s+((?:\\S+?)?BLAST[NPX])\\s+(.+)}) {\n            ($alg, $ver) = ($1, $2);\n            next;\n       }\n       next if /^#/ || /^\\s*$/;\n\n\t  my @fields = split;\n      next if @fields == 1;\n\t  my ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t      $qstart,$qend,$hstart,$hend,$evalue,$bits);\n\t  # WU-BLAST-specific\n\t  my ($num_scores, $raw_score, $identities, $positives, $percent_pos,\n\t      $qgap_blocks,$qgaps, $sgap_blocks, $sgaps, $qframe,\n\t      $sframe);\n\t  # NCBI -m8 and -m9\n\t  if (@fields == 12) {\n\t      ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n\t  # NCBI -m8 and -m9, v 2.2.18+\n\t  } elsif (@fields == 13) {\n          ($qname, $hname, $percent_id, $percent_pos, $hsp_len, $mismatches, $gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n      }\n\t  # WU-BLAST -mformat 2 and 3\n\t  elsif ((@fields == 22) or (@fields == 24)) {\n\t      ($qname,$hname,$evalue,$num_scores, $bits, $raw_score, $hsp_len,\n\t       $identities, $positives,$mismatches, $percent_id, $percent_pos,\n\t       $qgap_blocks, $qgaps, $sgap_blocks, $sgaps, $qframe, $qstart,\n\t       $qend, $sframe, $hstart,$hend,) = @fields;\n\t      # we need total gaps in the alignment\n\t      $gapsm=$qgaps+$sgaps;\n\t  }\n\n       # Remember Jim's code is 0 based\n       if( defined $lastquery && \n\t   $lastquery ne $qname ) {\n\t   $self->end_element({'Name' => 'Hit'});\n\t   $self->end_element({'Name' => 'Result'});\n\t   $self->_pushback($_);\n\t   return $self->end_document;\n       } elsif( ! defined $lastquery ) {\n\t   $self->{'_result_count'}++;\n\t   $self->start_element({'Name' => 'Result'});\n\t   $self->element({'Name' => 'Result_program',\n\t\t\t   'Data' => $alg || $self->program_name});\n       $self->element({'Name' => 'Result_version',\n\t\t\t   'Data' => $ver}) if $ver;\n\t   $self->element({'Name' => 'Result_query-def',\n\t\t\t   'Data' => $qname});\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n\t   \n       } elsif( $lasthit ne $hname ) {\n\t   if( $self->in_element('hit') ) {\t       \n\t       $self->end_element({'Name' => 'Hit'});\n\t   }\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n       }\n       my $identical = $hsp_len - $mismatches - $gapsm;\n       $self->start_element({'Name' => 'Hsp'});\n       $self->element({'Name' => 'Hsp_evalue',\t\t\t   \n\t\t       'Data' => $evalue});       \n       $self->element({'Name' => 'Hsp_bit-score',\n\t\t       'Data' => $bits});\n       $self->element({'Name' => 'Hsp_identity',\n\t\t       'Data' => $identical});\n       $self->element({'Name' => 'Hsp_positive',\n\t\t       'Data' => $positives});\n       $self->element({'Name' => 'Hsp_gaps',\n\t\t       'Data' => $gapsm});\n       $self->element({'Name' => 'Hsp_query-from',\n\t\t       'Data' => $qstart});\n       $self->element({'Name' => 'Hsp_query-to',\n\t\t       'Data' => $qend});\n\n       $self->element({'Name' => 'Hsp_hit-from',\n\t\t       'Data' => $hstart });\n       $self->element({'Name' => 'Hsp_hit-to',\n\t\t       'Data' => $hend });\n       $self->element({'Name' => 'Hsp_align-len',\n\t\t       'Data' => $hsp_len});\n       $self->end_element({'Name' => 'Hsp'});\n       $lastquery = $qname;\n       $lasthit   = $hname;\n   }\n   # fencepost\n   if( defined $lasthit && defined $lastquery ) {\n       if( $self->in_element('hit') ) {\n\t   $self->end_element({'Name' => 'Hit'});\n       }\n       $self->end_element({'Name' => 'Result'});\n       return $self->end_document;\n   }\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'Result') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n        \n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'Result' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string","parameters":[{"label":"$self"},{"label":"$data"}]},"name":"characters","range":{"start":{"line":403,"character":0},"end":{"character":9999,"line":430}}},{"range":{"start":{"character":0,"line":444},"end":{"line":450,"character":9999}},"name":"_mode","children":[{"containerName":"_mode","definition":"my","name":"$self","localvar":"my","kind":13,"line":445},{"name":"$value","containerName":"_mode","line":445,"kind":13},{"kind":13,"line":446,"containerName":"_mode","name":"$value"},{"kind":13,"line":447,"name":"$self","containerName":"_mode"},{"line":447,"kind":13,"containerName":"_mode","name":"$value"},{"containerName":"_mode","name":"$self","line":449,"kind":13}],"line":444,"kind":12,"signature":{"label":"_mode($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: blasttable.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blasttable\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::blasttable - Driver module for SearchIO for parsing NCBI -m 8/9 format\n\n=head1 SYNOPSIS\n\n  # do not use this module directly\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => $file,\n                                 -format => 'blasttable');\n\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis module will support parsing NCBI -m 8 or -m 9 tabular output\nand WU-BLAST -mformat 2 or -mformat 3 tabular output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::blasttable;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\nuse strict;\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::HSP::HSPFactory;\n\n$DefaultProgramName = 'BLASTN';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\n%MAPPING = ( \n\t     'Hsp_bit-score'  => 'HSP-bits',\n\t     'Hsp_score'      => 'HSP-score',\n\t     'Hsp_evalue'     => 'HSP-evalue',\n\t     'Hsp_query-from' => 'HSP-query_start',\n\t     'Hsp_query-to'   => 'HSP-query_end',\n\t     'Hsp_hit-from'   => 'HSP-hit_start',\n\t     'Hsp_hit-to'     => 'HSP-hit_end',\n\t     'Hsp_positive'   => 'HSP-conserved',\n\t     'Hsp_identity'   => 'HSP-identical',\n\t     'Hsp_mismatches' => 'HSP-mismatches',\n\t     'Hsp_qgapblocks' => 'HSP-query_gapblocks',\n\t     'Hsp_hgapblocks' => 'HSP-hit_gapblocks',\n\t     'Hsp_gaps'       => 'HSP-hsp_gaps',\n\t     'Hsp_hitgaps'    => 'HSP-hit_gaps',\n\t     'Hsp_querygaps'  => 'HSP-query_gaps',\n\t     'Hsp_align-len'  => 'HSP-hsp_length',\n\t     'Hsp_query-frame'=> 'HSP-query_frame',\n\t     'Hsp_hit-frame'  => 'HSP-hit_frame',\n\n\t     'Hit_id'        => 'HIT-name',\n\t     'Hit_len'       => 'HIT-length',\n\t     'Hit_accession' => 'HIT-accession',\n\t     'Hit_def'       => 'HIT-description',\n\t     'Hit_signif'    => 'HIT-significance',\n\t     'Hit_score'     => 'HIT-score',\n\t     'Hit_bits'      => 'HIT-bits',\n\n\t     'Result_program'  => 'RESULT-algorithm_name',\n\t     'Result_version'  => 'RESULT-algorithm_version',\n\t     'Result_query-def'=> 'RESULT-query_name',\n\t     'Result_query-len'=> 'RESULT-query_length',\n\t     'Result_query-acc'=> 'RESULT-query_accession',\n\t     'Result_querydesc'=> 'RESULT-query_description',\n\t     'Result_db'       => 'RESULT-database_name',\n\t     'Result_db-len'   => 'RESULT-database_entries',\n\t     'Result_db-let'   => 'RESULT-database_letters',\n\t     );\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blasttable->new();\n Function: Builds a new Bio::SearchIO::blasttable object \n Returns : an instance of Bio::SearchIO::blasttable\n Args    :\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n\n    my ($pname) = $self->_rearrange([qw(PROGRAM_NAME)],\n\t\t\t\t    @args);\n    $self->program_name($pname || $DefaultProgramName);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n    $self->_eventHandler->register_factory('hit', Bio::Search::Hit::HitFactory->new(-type => 'Bio::Search::Hit::GenericHit'));\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI>\n Args    : none\n\n\n\nsub next_result{\n   my ($self) = @_;\n   my ($lastquery,$lasthit);\n   local $/ = \"\\n\";\n   local $_;\n   my ($alg, $ver);\n   while( defined ($_ = $self->_readline) ) {\n\t  # WU-BLAST -mformat 3 only\n\t  if(m{^#\\s((?:\\S+?)?BLAST[NPX])\\s(\\d+\\.\\d+.+\\d{4}\\])}) {\n            ($alg, $ver) = ($1, $2);\n\t\t\t# only one header for whole file with WU-BLAST\n\t\t\t# so $alg and $ver won't get set properly for\n\t\t\t# each result\n\t\t\t$self->program_name($alg) if $alg;\n\t\t\t$self->element({'Name' => 'Result_version',\n\t\t\t\t\t   \t\t'Data' => $ver}) if $ver;\n            next;\n\t  }\n      # -m 9 only\n      elsif(m{^#\\s+((?:\\S+?)?BLAST[NPX])\\s+(.+)}) {\n            ($alg, $ver) = ($1, $2);\n            next;\n       }\n       next if /^#/ || /^\\s*$/;\n\n\t  my @fields = split;\n      next if @fields == 1;\n\t  my ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t      $qstart,$qend,$hstart,$hend,$evalue,$bits);\n\t  # WU-BLAST-specific\n\t  my ($num_scores, $raw_score, $identities, $positives, $percent_pos,\n\t      $qgap_blocks,$qgaps, $sgap_blocks, $sgaps, $qframe,\n\t      $sframe);\n\t  # NCBI -m8 and -m9\n\t  if (@fields == 12) {\n\t      ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n\t  # NCBI -m8 and -m9, v 2.2.18+\n\t  } elsif (@fields == 13) {\n          ($qname, $hname, $percent_id, $percent_pos, $hsp_len, $mismatches, $gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n      }\n\t  # WU-BLAST -mformat 2 and 3\n\t  elsif ((@fields == 22) or (@fields == 24)) {\n\t      ($qname,$hname,$evalue,$num_scores, $bits, $raw_score, $hsp_len,\n\t       $identities, $positives,$mismatches, $percent_id, $percent_pos,\n\t       $qgap_blocks, $qgaps, $sgap_blocks, $sgaps, $qframe, $qstart,\n\t       $qend, $sframe, $hstart,$hend,) = @fields;\n\t      # we need total gaps in the alignment\n\t      $gapsm=$qgaps+$sgaps;\n\t  }\n\n       # Remember Jim's code is 0 based\n       if( defined $lastquery && \n\t   $lastquery ne $qname ) {\n\t   $self->end_element({'Name' => 'Hit'});\n\t   $self->end_element({'Name' => 'Result'});\n\t   $self->_pushback($_);\n\t   return $self->end_document;\n       } elsif( ! defined $lastquery ) {\n\t   $self->{'_result_count'}++;\n\t   $self->start_element({'Name' => 'Result'});\n\t   $self->element({'Name' => 'Result_program',\n\t\t\t   'Data' => $alg || $self->program_name});\n       $self->element({'Name' => 'Result_version',\n\t\t\t   'Data' => $ver}) if $ver;\n\t   $self->element({'Name' => 'Result_query-def',\n\t\t\t   'Data' => $qname});\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n\t   \n       } elsif( $lasthit ne $hname ) {\n\t   if( $self->in_element('hit') ) {\t       \n\t       $self->end_element({'Name' => 'Hit'});\n\t   }\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n       }\n       my $identical = $hsp_len - $mismatches - $gapsm;\n       $self->start_element({'Name' => 'Hsp'});\n       $self->element({'Name' => 'Hsp_evalue',\t\t\t   \n\t\t       'Data' => $evalue});       \n       $self->element({'Name' => 'Hsp_bit-score',\n\t\t       'Data' => $bits});\n       $self->element({'Name' => 'Hsp_identity',\n\t\t       'Data' => $identical});\n       $self->element({'Name' => 'Hsp_positive',\n\t\t       'Data' => $positives});\n       $self->element({'Name' => 'Hsp_gaps',\n\t\t       'Data' => $gapsm});\n       $self->element({'Name' => 'Hsp_query-from',\n\t\t       'Data' => $qstart});\n       $self->element({'Name' => 'Hsp_query-to',\n\t\t       'Data' => $qend});\n\n       $self->element({'Name' => 'Hsp_hit-from',\n\t\t       'Data' => $hstart });\n       $self->element({'Name' => 'Hsp_hit-to',\n\t\t       'Data' => $hend });\n       $self->element({'Name' => 'Hsp_align-len',\n\t\t       'Data' => $hsp_len});\n       $self->end_element({'Name' => 'Hsp'});\n       $lastquery = $qname;\n       $lasthit   = $hname;\n   }\n   # fencepost\n   if( defined $lasthit && defined $lastquery ) {\n       if( $self->in_element('hit') ) {\n\t   $self->end_element({'Name' => 'Hit'});\n       }\n       $self->end_element({'Name' => 'Result'});\n       return $self->end_document;\n   }\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'Result') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n        \n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'Result' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;   \n\n# deep bug fix: set $self->{'_last_data'} to undef if $$data{Data} is \n# a valid slot, whose value is undef --\n# allows an undef to be propagated to object constructors and\n# handled there as desired; in particular, when Hsp_postive => -conserved\n# is not defined (in BLASTN, e.g.), the value of hsp's {CONSERVED} property is \n# set to the value of {IDENTICAL}.\n#/maj\n#   return unless ( defined $data->{'Data'} ); \n   return unless ( grep /Data/, keys %$data );\n   if ( !defined $data->{'Data'} ) {\n       $self->{'_last_data'} = undef;\n       return;\n   }\n   if( $data->{'Data'} =~ /^\\s+$/ ) {\n       return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n   }\n\n   if( $self->in_element('hsp') && \n       $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ ) {\n       \n       $self->{'_last_hspdata'}->{$data->{'Name'}} .= $data->{'Data'};\n   }  \n   \n   $self->{'_last_data'} = $data->{'Data'}; \n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)"},"detail":"($self,$value)","definition":"sub","containerName":"main::"},{"kind":12,"children":[{"line":466,"kind":13,"localvar":"my","containerName":"within_element","name":"$self","definition":"my"},{"name":"$name","containerName":"within_element","line":466,"kind":13},{"containerName":"within_element","name":"$name","line":467,"kind":13},{"kind":13,"line":468,"containerName":"within_element","name":"$self"},{"name":"$self","containerName":"within_element","line":469,"kind":13}],"line":465,"definition":"sub","containerName":"main::","signature":{"label":"within_element($self,$name)","parameters":[{"label":"$self"},{"label":"$name"}],"documentation":"1;\n# $Id: blasttable.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blasttable\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::blasttable - Driver module for SearchIO for parsing NCBI -m 8/9 format\n\n=head1 SYNOPSIS\n\n  # do not use this module directly\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => $file,\n                                 -format => 'blasttable');\n\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis module will support parsing NCBI -m 8 or -m 9 tabular output\nand WU-BLAST -mformat 2 or -mformat 3 tabular output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::blasttable;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\nuse strict;\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::HSP::HSPFactory;\n\n$DefaultProgramName = 'BLASTN';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\n%MAPPING = ( \n\t     'Hsp_bit-score'  => 'HSP-bits',\n\t     'Hsp_score'      => 'HSP-score',\n\t     'Hsp_evalue'     => 'HSP-evalue',\n\t     'Hsp_query-from' => 'HSP-query_start',\n\t     'Hsp_query-to'   => 'HSP-query_end',\n\t     'Hsp_hit-from'   => 'HSP-hit_start',\n\t     'Hsp_hit-to'     => 'HSP-hit_end',\n\t     'Hsp_positive'   => 'HSP-conserved',\n\t     'Hsp_identity'   => 'HSP-identical',\n\t     'Hsp_mismatches' => 'HSP-mismatches',\n\t     'Hsp_qgapblocks' => 'HSP-query_gapblocks',\n\t     'Hsp_hgapblocks' => 'HSP-hit_gapblocks',\n\t     'Hsp_gaps'       => 'HSP-hsp_gaps',\n\t     'Hsp_hitgaps'    => 'HSP-hit_gaps',\n\t     'Hsp_querygaps'  => 'HSP-query_gaps',\n\t     'Hsp_align-len'  => 'HSP-hsp_length',\n\t     'Hsp_query-frame'=> 'HSP-query_frame',\n\t     'Hsp_hit-frame'  => 'HSP-hit_frame',\n\n\t     'Hit_id'        => 'HIT-name',\n\t     'Hit_len'       => 'HIT-length',\n\t     'Hit_accession' => 'HIT-accession',\n\t     'Hit_def'       => 'HIT-description',\n\t     'Hit_signif'    => 'HIT-significance',\n\t     'Hit_score'     => 'HIT-score',\n\t     'Hit_bits'      => 'HIT-bits',\n\n\t     'Result_program'  => 'RESULT-algorithm_name',\n\t     'Result_version'  => 'RESULT-algorithm_version',\n\t     'Result_query-def'=> 'RESULT-query_name',\n\t     'Result_query-len'=> 'RESULT-query_length',\n\t     'Result_query-acc'=> 'RESULT-query_accession',\n\t     'Result_querydesc'=> 'RESULT-query_description',\n\t     'Result_db'       => 'RESULT-database_name',\n\t     'Result_db-len'   => 'RESULT-database_entries',\n\t     'Result_db-let'   => 'RESULT-database_letters',\n\t     );\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blasttable->new();\n Function: Builds a new Bio::SearchIO::blasttable object \n Returns : an instance of Bio::SearchIO::blasttable\n Args    :\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n\n    my ($pname) = $self->_rearrange([qw(PROGRAM_NAME)],\n\t\t\t\t    @args);\n    $self->program_name($pname || $DefaultProgramName);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n    $self->_eventHandler->register_factory('hit', Bio::Search::Hit::HitFactory->new(-type => 'Bio::Search::Hit::GenericHit'));\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI>\n Args    : none\n\n\n\nsub next_result{\n   my ($self) = @_;\n   my ($lastquery,$lasthit);\n   local $/ = \"\\n\";\n   local $_;\n   my ($alg, $ver);\n   while( defined ($_ = $self->_readline) ) {\n\t  # WU-BLAST -mformat 3 only\n\t  if(m{^#\\s((?:\\S+?)?BLAST[NPX])\\s(\\d+\\.\\d+.+\\d{4}\\])}) {\n            ($alg, $ver) = ($1, $2);\n\t\t\t# only one header for whole file with WU-BLAST\n\t\t\t# so $alg and $ver won't get set properly for\n\t\t\t# each result\n\t\t\t$self->program_name($alg) if $alg;\n\t\t\t$self->element({'Name' => 'Result_version',\n\t\t\t\t\t   \t\t'Data' => $ver}) if $ver;\n            next;\n\t  }\n      # -m 9 only\n      elsif(m{^#\\s+((?:\\S+?)?BLAST[NPX])\\s+(.+)}) {\n            ($alg, $ver) = ($1, $2);\n            next;\n       }\n       next if /^#/ || /^\\s*$/;\n\n\t  my @fields = split;\n      next if @fields == 1;\n\t  my ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t      $qstart,$qend,$hstart,$hend,$evalue,$bits);\n\t  # WU-BLAST-specific\n\t  my ($num_scores, $raw_score, $identities, $positives, $percent_pos,\n\t      $qgap_blocks,$qgaps, $sgap_blocks, $sgaps, $qframe,\n\t      $sframe);\n\t  # NCBI -m8 and -m9\n\t  if (@fields == 12) {\n\t      ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n\t  # NCBI -m8 and -m9, v 2.2.18+\n\t  } elsif (@fields == 13) {\n          ($qname, $hname, $percent_id, $percent_pos, $hsp_len, $mismatches, $gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n      }\n\t  # WU-BLAST -mformat 2 and 3\n\t  elsif ((@fields == 22) or (@fields == 24)) {\n\t      ($qname,$hname,$evalue,$num_scores, $bits, $raw_score, $hsp_len,\n\t       $identities, $positives,$mismatches, $percent_id, $percent_pos,\n\t       $qgap_blocks, $qgaps, $sgap_blocks, $sgaps, $qframe, $qstart,\n\t       $qend, $sframe, $hstart,$hend,) = @fields;\n\t      # we need total gaps in the alignment\n\t      $gapsm=$qgaps+$sgaps;\n\t  }\n\n       # Remember Jim's code is 0 based\n       if( defined $lastquery && \n\t   $lastquery ne $qname ) {\n\t   $self->end_element({'Name' => 'Hit'});\n\t   $self->end_element({'Name' => 'Result'});\n\t   $self->_pushback($_);\n\t   return $self->end_document;\n       } elsif( ! defined $lastquery ) {\n\t   $self->{'_result_count'}++;\n\t   $self->start_element({'Name' => 'Result'});\n\t   $self->element({'Name' => 'Result_program',\n\t\t\t   'Data' => $alg || $self->program_name});\n       $self->element({'Name' => 'Result_version',\n\t\t\t   'Data' => $ver}) if $ver;\n\t   $self->element({'Name' => 'Result_query-def',\n\t\t\t   'Data' => $qname});\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n\t   \n       } elsif( $lasthit ne $hname ) {\n\t   if( $self->in_element('hit') ) {\t       \n\t       $self->end_element({'Name' => 'Hit'});\n\t   }\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n       }\n       my $identical = $hsp_len - $mismatches - $gapsm;\n       $self->start_element({'Name' => 'Hsp'});\n       $self->element({'Name' => 'Hsp_evalue',\t\t\t   \n\t\t       'Data' => $evalue});       \n       $self->element({'Name' => 'Hsp_bit-score',\n\t\t       'Data' => $bits});\n       $self->element({'Name' => 'Hsp_identity',\n\t\t       'Data' => $identical});\n       $self->element({'Name' => 'Hsp_positive',\n\t\t       'Data' => $positives});\n       $self->element({'Name' => 'Hsp_gaps',\n\t\t       'Data' => $gapsm});\n       $self->element({'Name' => 'Hsp_query-from',\n\t\t       'Data' => $qstart});\n       $self->element({'Name' => 'Hsp_query-to',\n\t\t       'Data' => $qend});\n\n       $self->element({'Name' => 'Hsp_hit-from',\n\t\t       'Data' => $hstart });\n       $self->element({'Name' => 'Hsp_hit-to',\n\t\t       'Data' => $hend });\n       $self->element({'Name' => 'Hsp_align-len',\n\t\t       'Data' => $hsp_len});\n       $self->end_element({'Name' => 'Hsp'});\n       $lastquery = $qname;\n       $lasthit   = $hname;\n   }\n   # fencepost\n   if( defined $lasthit && defined $lastquery ) {\n       if( $self->in_element('hit') ) {\n\t   $self->end_element({'Name' => 'Hit'});\n       }\n       $self->end_element({'Name' => 'Result'});\n       return $self->end_document;\n   }\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'Result') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n        \n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'Result' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;   \n\n# deep bug fix: set $self->{'_last_data'} to undef if $$data{Data} is \n# a valid slot, whose value is undef --\n# allows an undef to be propagated to object constructors and\n# handled there as desired; in particular, when Hsp_postive => -conserved\n# is not defined (in BLASTN, e.g.), the value of hsp's {CONSERVED} property is \n# set to the value of {IDENTICAL}.\n#/maj\n#   return unless ( defined $data->{'Data'} ); \n   return unless ( grep /Data/, keys %$data );\n   if ( !defined $data->{'Data'} ) {\n       $self->{'_last_data'} = undef;\n       return;\n   }\n   if( $data->{'Data'} =~ /^\\s+$/ ) {\n       return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n   }\n\n   if( $self->in_element('hsp') && \n       $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ ) {\n       \n       $self->{'_last_hspdata'}->{$data->{'Name'}} .= $data->{'Data'};\n   }  \n   \n   $self->{'_last_data'} = $data->{'Data'}; \n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name "},"detail":"($self,$name)","name":"within_element","range":{"start":{"line":465,"character":0},"end":{"character":9999,"line":469}}},{"containerName":null,"name":"%self","line":470,"kind":13},{"name":"%name","containerName":null,"line":471,"kind":13},{"name":"in_element","range":{"start":{"line":491,"character":0},"end":{"line":495,"character":9999}},"kind":12,"line":491,"children":[{"line":492,"kind":13,"localvar":"my","containerName":"in_element","name":"$self","definition":"my"},{"line":492,"kind":13,"name":"$name","containerName":"in_element"},{"line":493,"kind":13,"name":"$self","containerName":"in_element"},{"name":"$self","containerName":"in_element","line":494,"kind":13},{"containerName":"in_element","name":"$name","kind":13,"line":494}],"containerName":"main::","definition":"sub","detail":"($self,$name)","signature":{"documentation":"1;\n# $Id: blasttable.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blasttable\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::blasttable - Driver module for SearchIO for parsing NCBI -m 8/9 format\n\n=head1 SYNOPSIS\n\n  # do not use this module directly\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => $file,\n                                 -format => 'blasttable');\n\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis module will support parsing NCBI -m 8 or -m 9 tabular output\nand WU-BLAST -mformat 2 or -mformat 3 tabular output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::blasttable;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\nuse strict;\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::HSP::HSPFactory;\n\n$DefaultProgramName = 'BLASTN';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\n%MAPPING = ( \n\t     'Hsp_bit-score'  => 'HSP-bits',\n\t     'Hsp_score'      => 'HSP-score',\n\t     'Hsp_evalue'     => 'HSP-evalue',\n\t     'Hsp_query-from' => 'HSP-query_start',\n\t     'Hsp_query-to'   => 'HSP-query_end',\n\t     'Hsp_hit-from'   => 'HSP-hit_start',\n\t     'Hsp_hit-to'     => 'HSP-hit_end',\n\t     'Hsp_positive'   => 'HSP-conserved',\n\t     'Hsp_identity'   => 'HSP-identical',\n\t     'Hsp_mismatches' => 'HSP-mismatches',\n\t     'Hsp_qgapblocks' => 'HSP-query_gapblocks',\n\t     'Hsp_hgapblocks' => 'HSP-hit_gapblocks',\n\t     'Hsp_gaps'       => 'HSP-hsp_gaps',\n\t     'Hsp_hitgaps'    => 'HSP-hit_gaps',\n\t     'Hsp_querygaps'  => 'HSP-query_gaps',\n\t     'Hsp_align-len'  => 'HSP-hsp_length',\n\t     'Hsp_query-frame'=> 'HSP-query_frame',\n\t     'Hsp_hit-frame'  => 'HSP-hit_frame',\n\n\t     'Hit_id'        => 'HIT-name',\n\t     'Hit_len'       => 'HIT-length',\n\t     'Hit_accession' => 'HIT-accession',\n\t     'Hit_def'       => 'HIT-description',\n\t     'Hit_signif'    => 'HIT-significance',\n\t     'Hit_score'     => 'HIT-score',\n\t     'Hit_bits'      => 'HIT-bits',\n\n\t     'Result_program'  => 'RESULT-algorithm_name',\n\t     'Result_version'  => 'RESULT-algorithm_version',\n\t     'Result_query-def'=> 'RESULT-query_name',\n\t     'Result_query-len'=> 'RESULT-query_length',\n\t     'Result_query-acc'=> 'RESULT-query_accession',\n\t     'Result_querydesc'=> 'RESULT-query_description',\n\t     'Result_db'       => 'RESULT-database_name',\n\t     'Result_db-len'   => 'RESULT-database_entries',\n\t     'Result_db-let'   => 'RESULT-database_letters',\n\t     );\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blasttable->new();\n Function: Builds a new Bio::SearchIO::blasttable object \n Returns : an instance of Bio::SearchIO::blasttable\n Args    :\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n\n    my ($pname) = $self->_rearrange([qw(PROGRAM_NAME)],\n\t\t\t\t    @args);\n    $self->program_name($pname || $DefaultProgramName);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n    $self->_eventHandler->register_factory('hit', Bio::Search::Hit::HitFactory->new(-type => 'Bio::Search::Hit::GenericHit'));\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI>\n Args    : none\n\n\n\nsub next_result{\n   my ($self) = @_;\n   my ($lastquery,$lasthit);\n   local $/ = \"\\n\";\n   local $_;\n   my ($alg, $ver);\n   while( defined ($_ = $self->_readline) ) {\n\t  # WU-BLAST -mformat 3 only\n\t  if(m{^#\\s((?:\\S+?)?BLAST[NPX])\\s(\\d+\\.\\d+.+\\d{4}\\])}) {\n            ($alg, $ver) = ($1, $2);\n\t\t\t# only one header for whole file with WU-BLAST\n\t\t\t# so $alg and $ver won't get set properly for\n\t\t\t# each result\n\t\t\t$self->program_name($alg) if $alg;\n\t\t\t$self->element({'Name' => 'Result_version',\n\t\t\t\t\t   \t\t'Data' => $ver}) if $ver;\n            next;\n\t  }\n      # -m 9 only\n      elsif(m{^#\\s+((?:\\S+?)?BLAST[NPX])\\s+(.+)}) {\n            ($alg, $ver) = ($1, $2);\n            next;\n       }\n       next if /^#/ || /^\\s*$/;\n\n\t  my @fields = split;\n      next if @fields == 1;\n\t  my ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t      $qstart,$qend,$hstart,$hend,$evalue,$bits);\n\t  # WU-BLAST-specific\n\t  my ($num_scores, $raw_score, $identities, $positives, $percent_pos,\n\t      $qgap_blocks,$qgaps, $sgap_blocks, $sgaps, $qframe,\n\t      $sframe);\n\t  # NCBI -m8 and -m9\n\t  if (@fields == 12) {\n\t      ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n\t  # NCBI -m8 and -m9, v 2.2.18+\n\t  } elsif (@fields == 13) {\n          ($qname, $hname, $percent_id, $percent_pos, $hsp_len, $mismatches, $gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n      }\n\t  # WU-BLAST -mformat 2 and 3\n\t  elsif ((@fields == 22) or (@fields == 24)) {\n\t      ($qname,$hname,$evalue,$num_scores, $bits, $raw_score, $hsp_len,\n\t       $identities, $positives,$mismatches, $percent_id, $percent_pos,\n\t       $qgap_blocks, $qgaps, $sgap_blocks, $sgaps, $qframe, $qstart,\n\t       $qend, $sframe, $hstart,$hend,) = @fields;\n\t      # we need total gaps in the alignment\n\t      $gapsm=$qgaps+$sgaps;\n\t  }\n\n       # Remember Jim's code is 0 based\n       if( defined $lastquery && \n\t   $lastquery ne $qname ) {\n\t   $self->end_element({'Name' => 'Hit'});\n\t   $self->end_element({'Name' => 'Result'});\n\t   $self->_pushback($_);\n\t   return $self->end_document;\n       } elsif( ! defined $lastquery ) {\n\t   $self->{'_result_count'}++;\n\t   $self->start_element({'Name' => 'Result'});\n\t   $self->element({'Name' => 'Result_program',\n\t\t\t   'Data' => $alg || $self->program_name});\n       $self->element({'Name' => 'Result_version',\n\t\t\t   'Data' => $ver}) if $ver;\n\t   $self->element({'Name' => 'Result_query-def',\n\t\t\t   'Data' => $qname});\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n\t   \n       } elsif( $lasthit ne $hname ) {\n\t   if( $self->in_element('hit') ) {\t       \n\t       $self->end_element({'Name' => 'Hit'});\n\t   }\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n       }\n       my $identical = $hsp_len - $mismatches - $gapsm;\n       $self->start_element({'Name' => 'Hsp'});\n       $self->element({'Name' => 'Hsp_evalue',\t\t\t   \n\t\t       'Data' => $evalue});       \n       $self->element({'Name' => 'Hsp_bit-score',\n\t\t       'Data' => $bits});\n       $self->element({'Name' => 'Hsp_identity',\n\t\t       'Data' => $identical});\n       $self->element({'Name' => 'Hsp_positive',\n\t\t       'Data' => $positives});\n       $self->element({'Name' => 'Hsp_gaps',\n\t\t       'Data' => $gapsm});\n       $self->element({'Name' => 'Hsp_query-from',\n\t\t       'Data' => $qstart});\n       $self->element({'Name' => 'Hsp_query-to',\n\t\t       'Data' => $qend});\n\n       $self->element({'Name' => 'Hsp_hit-from',\n\t\t       'Data' => $hstart });\n       $self->element({'Name' => 'Hsp_hit-to',\n\t\t       'Data' => $hend });\n       $self->element({'Name' => 'Hsp_align-len',\n\t\t       'Data' => $hsp_len});\n       $self->end_element({'Name' => 'Hsp'});\n       $lastquery = $qname;\n       $lasthit   = $hname;\n   }\n   # fencepost\n   if( defined $lasthit && defined $lastquery ) {\n       if( $self->in_element('hit') ) {\n\t   $self->end_element({'Name' => 'Hit'});\n       }\n       $self->end_element({'Name' => 'Result'});\n       return $self->end_document;\n   }\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'Result') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n        \n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'Result' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;   \n\n# deep bug fix: set $self->{'_last_data'} to undef if $$data{Data} is \n# a valid slot, whose value is undef --\n# allows an undef to be propagated to object constructors and\n# handled there as desired; in particular, when Hsp_postive => -conserved\n# is not defined (in BLASTN, e.g.), the value of hsp's {CONSERVED} property is \n# set to the value of {IDENTICAL}.\n#/maj\n#   return unless ( defined $data->{'Data'} ); \n   return unless ( grep /Data/, keys %$data );\n   if ( !defined $data->{'Data'} ) {\n       $self->{'_last_data'} = undef;\n       return;\n   }\n   if( $data->{'Data'} =~ /^\\s+$/ ) {\n       return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n   }\n\n   if( $self->in_element('hsp') && \n       $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ ) {\n       \n       $self->{'_last_hspdata'}->{$data->{'Name'}} .= $data->{'Data'};\n   }  \n   \n   $self->{'_last_data'} = $data->{'Data'}; \n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element{\n   my ($self,$name) = @_;  \n   return 0 if ( ! defined $name &&\n\t\t ! defined  $self->{'_elements'} ||\n\t\t scalar @{$self->{'_elements'}} == 0) ;\n   foreach (  @{$self->{'_elements'}} ) {\n       if( $_ eq $name  ) {\n\t   return 1;\n       } \n   }\n   return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name ","parameters":[{"label":"$self"},{"label":"$name"}],"label":"in_element($self,$name)"}},{"range":{"start":{"character":0,"line":509},"end":{"character":9999,"line":516}},"name":"start_document","line":509,"children":[{"kind":13,"line":510,"containerName":"start_document","name":"$self","definition":"my","localvar":"my"},{"name":"$self","containerName":"start_document","line":511,"kind":13},{"name":"$self","containerName":"start_document","line":512,"kind":13},{"containerName":"start_document","name":"$self","kind":13,"line":513},{"kind":13,"line":514,"name":"$self","containerName":"start_document"},{"line":515,"kind":13,"name":"$self","containerName":"start_document"}],"kind":12,"detail":"($self)","signature":{"documentation":"1;\n# $Id: blasttable.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blasttable\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::blasttable - Driver module for SearchIO for parsing NCBI -m 8/9 format\n\n=head1 SYNOPSIS\n\n  # do not use this module directly\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => $file,\n                                 -format => 'blasttable');\n\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis module will support parsing NCBI -m 8 or -m 9 tabular output\nand WU-BLAST -mformat 2 or -mformat 3 tabular output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::blasttable;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\nuse strict;\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::HSP::HSPFactory;\n\n$DefaultProgramName = 'BLASTN';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\n%MAPPING = ( \n\t     'Hsp_bit-score'  => 'HSP-bits',\n\t     'Hsp_score'      => 'HSP-score',\n\t     'Hsp_evalue'     => 'HSP-evalue',\n\t     'Hsp_query-from' => 'HSP-query_start',\n\t     'Hsp_query-to'   => 'HSP-query_end',\n\t     'Hsp_hit-from'   => 'HSP-hit_start',\n\t     'Hsp_hit-to'     => 'HSP-hit_end',\n\t     'Hsp_positive'   => 'HSP-conserved',\n\t     'Hsp_identity'   => 'HSP-identical',\n\t     'Hsp_mismatches' => 'HSP-mismatches',\n\t     'Hsp_qgapblocks' => 'HSP-query_gapblocks',\n\t     'Hsp_hgapblocks' => 'HSP-hit_gapblocks',\n\t     'Hsp_gaps'       => 'HSP-hsp_gaps',\n\t     'Hsp_hitgaps'    => 'HSP-hit_gaps',\n\t     'Hsp_querygaps'  => 'HSP-query_gaps',\n\t     'Hsp_align-len'  => 'HSP-hsp_length',\n\t     'Hsp_query-frame'=> 'HSP-query_frame',\n\t     'Hsp_hit-frame'  => 'HSP-hit_frame',\n\n\t     'Hit_id'        => 'HIT-name',\n\t     'Hit_len'       => 'HIT-length',\n\t     'Hit_accession' => 'HIT-accession',\n\t     'Hit_def'       => 'HIT-description',\n\t     'Hit_signif'    => 'HIT-significance',\n\t     'Hit_score'     => 'HIT-score',\n\t     'Hit_bits'      => 'HIT-bits',\n\n\t     'Result_program'  => 'RESULT-algorithm_name',\n\t     'Result_version'  => 'RESULT-algorithm_version',\n\t     'Result_query-def'=> 'RESULT-query_name',\n\t     'Result_query-len'=> 'RESULT-query_length',\n\t     'Result_query-acc'=> 'RESULT-query_accession',\n\t     'Result_querydesc'=> 'RESULT-query_description',\n\t     'Result_db'       => 'RESULT-database_name',\n\t     'Result_db-len'   => 'RESULT-database_entries',\n\t     'Result_db-let'   => 'RESULT-database_letters',\n\t     );\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blasttable->new();\n Function: Builds a new Bio::SearchIO::blasttable object \n Returns : an instance of Bio::SearchIO::blasttable\n Args    :\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n\n    my ($pname) = $self->_rearrange([qw(PROGRAM_NAME)],\n\t\t\t\t    @args);\n    $self->program_name($pname || $DefaultProgramName);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n    $self->_eventHandler->register_factory('hit', Bio::Search::Hit::HitFactory->new(-type => 'Bio::Search::Hit::GenericHit'));\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI>\n Args    : none\n\n\n\nsub next_result{\n   my ($self) = @_;\n   my ($lastquery,$lasthit);\n   local $/ = \"\\n\";\n   local $_;\n   my ($alg, $ver);\n   while( defined ($_ = $self->_readline) ) {\n\t  # WU-BLAST -mformat 3 only\n\t  if(m{^#\\s((?:\\S+?)?BLAST[NPX])\\s(\\d+\\.\\d+.+\\d{4}\\])}) {\n            ($alg, $ver) = ($1, $2);\n\t\t\t# only one header for whole file with WU-BLAST\n\t\t\t# so $alg and $ver won't get set properly for\n\t\t\t# each result\n\t\t\t$self->program_name($alg) if $alg;\n\t\t\t$self->element({'Name' => 'Result_version',\n\t\t\t\t\t   \t\t'Data' => $ver}) if $ver;\n            next;\n\t  }\n      # -m 9 only\n      elsif(m{^#\\s+((?:\\S+?)?BLAST[NPX])\\s+(.+)}) {\n            ($alg, $ver) = ($1, $2);\n            next;\n       }\n       next if /^#/ || /^\\s*$/;\n\n\t  my @fields = split;\n      next if @fields == 1;\n\t  my ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t      $qstart,$qend,$hstart,$hend,$evalue,$bits);\n\t  # WU-BLAST-specific\n\t  my ($num_scores, $raw_score, $identities, $positives, $percent_pos,\n\t      $qgap_blocks,$qgaps, $sgap_blocks, $sgaps, $qframe,\n\t      $sframe);\n\t  # NCBI -m8 and -m9\n\t  if (@fields == 12) {\n\t      ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n\t  # NCBI -m8 and -m9, v 2.2.18+\n\t  } elsif (@fields == 13) {\n          ($qname, $hname, $percent_id, $percent_pos, $hsp_len, $mismatches, $gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n      }\n\t  # WU-BLAST -mformat 2 and 3\n\t  elsif ((@fields == 22) or (@fields == 24)) {\n\t      ($qname,$hname,$evalue,$num_scores, $bits, $raw_score, $hsp_len,\n\t       $identities, $positives,$mismatches, $percent_id, $percent_pos,\n\t       $qgap_blocks, $qgaps, $sgap_blocks, $sgaps, $qframe, $qstart,\n\t       $qend, $sframe, $hstart,$hend,) = @fields;\n\t      # we need total gaps in the alignment\n\t      $gapsm=$qgaps+$sgaps;\n\t  }\n\n       # Remember Jim's code is 0 based\n       if( defined $lastquery && \n\t   $lastquery ne $qname ) {\n\t   $self->end_element({'Name' => 'Hit'});\n\t   $self->end_element({'Name' => 'Result'});\n\t   $self->_pushback($_);\n\t   return $self->end_document;\n       } elsif( ! defined $lastquery ) {\n\t   $self->{'_result_count'}++;\n\t   $self->start_element({'Name' => 'Result'});\n\t   $self->element({'Name' => 'Result_program',\n\t\t\t   'Data' => $alg || $self->program_name});\n       $self->element({'Name' => 'Result_version',\n\t\t\t   'Data' => $ver}) if $ver;\n\t   $self->element({'Name' => 'Result_query-def',\n\t\t\t   'Data' => $qname});\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n\t   \n       } elsif( $lasthit ne $hname ) {\n\t   if( $self->in_element('hit') ) {\t       \n\t       $self->end_element({'Name' => 'Hit'});\n\t   }\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n       }\n       my $identical = $hsp_len - $mismatches - $gapsm;\n       $self->start_element({'Name' => 'Hsp'});\n       $self->element({'Name' => 'Hsp_evalue',\t\t\t   \n\t\t       'Data' => $evalue});       \n       $self->element({'Name' => 'Hsp_bit-score',\n\t\t       'Data' => $bits});\n       $self->element({'Name' => 'Hsp_identity',\n\t\t       'Data' => $identical});\n       $self->element({'Name' => 'Hsp_positive',\n\t\t       'Data' => $positives});\n       $self->element({'Name' => 'Hsp_gaps',\n\t\t       'Data' => $gapsm});\n       $self->element({'Name' => 'Hsp_query-from',\n\t\t       'Data' => $qstart});\n       $self->element({'Name' => 'Hsp_query-to',\n\t\t       'Data' => $qend});\n\n       $self->element({'Name' => 'Hsp_hit-from',\n\t\t       'Data' => $hstart });\n       $self->element({'Name' => 'Hsp_hit-to',\n\t\t       'Data' => $hend });\n       $self->element({'Name' => 'Hsp_align-len',\n\t\t       'Data' => $hsp_len});\n       $self->end_element({'Name' => 'Hsp'});\n       $lastquery = $qname;\n       $lasthit   = $hname;\n   }\n   # fencepost\n   if( defined $lasthit && defined $lastquery ) {\n       if( $self->in_element('hit') ) {\n\t   $self->end_element({'Name' => 'Hit'});\n       }\n       $self->end_element({'Name' => 'Result'});\n       return $self->end_document;\n   }\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'Result') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n        \n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'Result' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;   \n\n# deep bug fix: set $self->{'_last_data'} to undef if $$data{Data} is \n# a valid slot, whose value is undef --\n# allows an undef to be propagated to object constructors and\n# handled there as desired; in particular, when Hsp_postive => -conserved\n# is not defined (in BLASTN, e.g.), the value of hsp's {CONSERVED} property is \n# set to the value of {IDENTICAL}.\n#/maj\n#   return unless ( defined $data->{'Data'} ); \n   return unless ( grep /Data/, keys %$data );\n   if ( !defined $data->{'Data'} ) {\n       $self->{'_last_data'} = undef;\n       return;\n   }\n   if( $data->{'Data'} =~ /^\\s+$/ ) {\n       return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n   }\n\n   if( $self->in_element('hsp') && \n       $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ ) {\n       \n       $self->{'_last_hspdata'}->{$data->{'Name'}} .= $data->{'Data'};\n   }  \n   \n   $self->{'_last_data'} = $data->{'Data'}; \n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element{\n   my ($self,$name) = @_;  \n   return 0 if ( ! defined $name &&\n\t\t ! defined  $self->{'_elements'} ||\n\t\t scalar @{$self->{'_elements'}} == 0) ;\n   foreach (  @{$self->{'_elements'}} ) {\n       if( $_ eq $name  ) {\n\t   return 1;\n       } \n   }\n   return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub in_element{\n   my ($self,$name) = @_;  \n   return 0 if ! defined $self->{'_elements'}->[0];\n   return ( $self->{'_elements'}->[0] eq $name)\n}\n\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handles a start document event\n Returns : none\n Args    : none","parameters":[{"label":"$self"}],"label":"start_document($self)"},"containerName":"main::","definition":"sub"},{"kind":12,"line":530,"children":[{"containerName":"end_document","name":"$self","definition":"my","localvar":"my","kind":13,"line":531},{"containerName":"end_document","name":"@args","line":531,"kind":13},{"kind":13,"line":532,"containerName":"end_document","name":"$self"}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"end_document($self,@args)","documentation":"1;\n# $Id: blasttable.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blasttable\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::blasttable - Driver module for SearchIO for parsing NCBI -m 8/9 format\n\n=head1 SYNOPSIS\n\n  # do not use this module directly\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => $file,\n                                 -format => 'blasttable');\n\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis module will support parsing NCBI -m 8 or -m 9 tabular output\nand WU-BLAST -mformat 2 or -mformat 3 tabular output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::blasttable;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\nuse strict;\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::HSP::HSPFactory;\n\n$DefaultProgramName = 'BLASTN';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\n%MAPPING = ( \n\t     'Hsp_bit-score'  => 'HSP-bits',\n\t     'Hsp_score'      => 'HSP-score',\n\t     'Hsp_evalue'     => 'HSP-evalue',\n\t     'Hsp_query-from' => 'HSP-query_start',\n\t     'Hsp_query-to'   => 'HSP-query_end',\n\t     'Hsp_hit-from'   => 'HSP-hit_start',\n\t     'Hsp_hit-to'     => 'HSP-hit_end',\n\t     'Hsp_positive'   => 'HSP-conserved',\n\t     'Hsp_identity'   => 'HSP-identical',\n\t     'Hsp_mismatches' => 'HSP-mismatches',\n\t     'Hsp_qgapblocks' => 'HSP-query_gapblocks',\n\t     'Hsp_hgapblocks' => 'HSP-hit_gapblocks',\n\t     'Hsp_gaps'       => 'HSP-hsp_gaps',\n\t     'Hsp_hitgaps'    => 'HSP-hit_gaps',\n\t     'Hsp_querygaps'  => 'HSP-query_gaps',\n\t     'Hsp_align-len'  => 'HSP-hsp_length',\n\t     'Hsp_query-frame'=> 'HSP-query_frame',\n\t     'Hsp_hit-frame'  => 'HSP-hit_frame',\n\n\t     'Hit_id'        => 'HIT-name',\n\t     'Hit_len'       => 'HIT-length',\n\t     'Hit_accession' => 'HIT-accession',\n\t     'Hit_def'       => 'HIT-description',\n\t     'Hit_signif'    => 'HIT-significance',\n\t     'Hit_score'     => 'HIT-score',\n\t     'Hit_bits'      => 'HIT-bits',\n\n\t     'Result_program'  => 'RESULT-algorithm_name',\n\t     'Result_version'  => 'RESULT-algorithm_version',\n\t     'Result_query-def'=> 'RESULT-query_name',\n\t     'Result_query-len'=> 'RESULT-query_length',\n\t     'Result_query-acc'=> 'RESULT-query_accession',\n\t     'Result_querydesc'=> 'RESULT-query_description',\n\t     'Result_db'       => 'RESULT-database_name',\n\t     'Result_db-len'   => 'RESULT-database_entries',\n\t     'Result_db-let'   => 'RESULT-database_letters',\n\t     );\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blasttable->new();\n Function: Builds a new Bio::SearchIO::blasttable object \n Returns : an instance of Bio::SearchIO::blasttable\n Args    :\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n\n    my ($pname) = $self->_rearrange([qw(PROGRAM_NAME)],\n\t\t\t\t    @args);\n    $self->program_name($pname || $DefaultProgramName);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n    $self->_eventHandler->register_factory('hit', Bio::Search::Hit::HitFactory->new(-type => 'Bio::Search::Hit::GenericHit'));\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI>\n Args    : none\n\n\n\nsub next_result{\n   my ($self) = @_;\n   my ($lastquery,$lasthit);\n   local $/ = \"\\n\";\n   local $_;\n   my ($alg, $ver);\n   while( defined ($_ = $self->_readline) ) {\n\t  # WU-BLAST -mformat 3 only\n\t  if(m{^#\\s((?:\\S+?)?BLAST[NPX])\\s(\\d+\\.\\d+.+\\d{4}\\])}) {\n            ($alg, $ver) = ($1, $2);\n\t\t\t# only one header for whole file with WU-BLAST\n\t\t\t# so $alg and $ver won't get set properly for\n\t\t\t# each result\n\t\t\t$self->program_name($alg) if $alg;\n\t\t\t$self->element({'Name' => 'Result_version',\n\t\t\t\t\t   \t\t'Data' => $ver}) if $ver;\n            next;\n\t  }\n      # -m 9 only\n      elsif(m{^#\\s+((?:\\S+?)?BLAST[NPX])\\s+(.+)}) {\n            ($alg, $ver) = ($1, $2);\n            next;\n       }\n       next if /^#/ || /^\\s*$/;\n\n\t  my @fields = split;\n      next if @fields == 1;\n\t  my ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t      $qstart,$qend,$hstart,$hend,$evalue,$bits);\n\t  # WU-BLAST-specific\n\t  my ($num_scores, $raw_score, $identities, $positives, $percent_pos,\n\t      $qgap_blocks,$qgaps, $sgap_blocks, $sgaps, $qframe,\n\t      $sframe);\n\t  # NCBI -m8 and -m9\n\t  if (@fields == 12) {\n\t      ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n\t  # NCBI -m8 and -m9, v 2.2.18+\n\t  } elsif (@fields == 13) {\n          ($qname, $hname, $percent_id, $percent_pos, $hsp_len, $mismatches, $gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n      }\n\t  # WU-BLAST -mformat 2 and 3\n\t  elsif ((@fields == 22) or (@fields == 24)) {\n\t      ($qname,$hname,$evalue,$num_scores, $bits, $raw_score, $hsp_len,\n\t       $identities, $positives,$mismatches, $percent_id, $percent_pos,\n\t       $qgap_blocks, $qgaps, $sgap_blocks, $sgaps, $qframe, $qstart,\n\t       $qend, $sframe, $hstart,$hend,) = @fields;\n\t      # we need total gaps in the alignment\n\t      $gapsm=$qgaps+$sgaps;\n\t  }\n\n       # Remember Jim's code is 0 based\n       if( defined $lastquery && \n\t   $lastquery ne $qname ) {\n\t   $self->end_element({'Name' => 'Hit'});\n\t   $self->end_element({'Name' => 'Result'});\n\t   $self->_pushback($_);\n\t   return $self->end_document;\n       } elsif( ! defined $lastquery ) {\n\t   $self->{'_result_count'}++;\n\t   $self->start_element({'Name' => 'Result'});\n\t   $self->element({'Name' => 'Result_program',\n\t\t\t   'Data' => $alg || $self->program_name});\n       $self->element({'Name' => 'Result_version',\n\t\t\t   'Data' => $ver}) if $ver;\n\t   $self->element({'Name' => 'Result_query-def',\n\t\t\t   'Data' => $qname});\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n\t   \n       } elsif( $lasthit ne $hname ) {\n\t   if( $self->in_element('hit') ) {\t       \n\t       $self->end_element({'Name' => 'Hit'});\n\t   }\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n       }\n       my $identical = $hsp_len - $mismatches - $gapsm;\n       $self->start_element({'Name' => 'Hsp'});\n       $self->element({'Name' => 'Hsp_evalue',\t\t\t   \n\t\t       'Data' => $evalue});       \n       $self->element({'Name' => 'Hsp_bit-score',\n\t\t       'Data' => $bits});\n       $self->element({'Name' => 'Hsp_identity',\n\t\t       'Data' => $identical});\n       $self->element({'Name' => 'Hsp_positive',\n\t\t       'Data' => $positives});\n       $self->element({'Name' => 'Hsp_gaps',\n\t\t       'Data' => $gapsm});\n       $self->element({'Name' => 'Hsp_query-from',\n\t\t       'Data' => $qstart});\n       $self->element({'Name' => 'Hsp_query-to',\n\t\t       'Data' => $qend});\n\n       $self->element({'Name' => 'Hsp_hit-from',\n\t\t       'Data' => $hstart });\n       $self->element({'Name' => 'Hsp_hit-to',\n\t\t       'Data' => $hend });\n       $self->element({'Name' => 'Hsp_align-len',\n\t\t       'Data' => $hsp_len});\n       $self->end_element({'Name' => 'Hsp'});\n       $lastquery = $qname;\n       $lasthit   = $hname;\n   }\n   # fencepost\n   if( defined $lasthit && defined $lastquery ) {\n       if( $self->in_element('hit') ) {\n\t   $self->end_element({'Name' => 'Hit'});\n       }\n       $self->end_element({'Name' => 'Result'});\n       return $self->end_document;\n   }\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'Result') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n        \n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'Result' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;   \n\n# deep bug fix: set $self->{'_last_data'} to undef if $$data{Data} is \n# a valid slot, whose value is undef --\n# allows an undef to be propagated to object constructors and\n# handled there as desired; in particular, when Hsp_postive => -conserved\n# is not defined (in BLASTN, e.g.), the value of hsp's {CONSERVED} property is \n# set to the value of {IDENTICAL}.\n#/maj\n#   return unless ( defined $data->{'Data'} ); \n   return unless ( grep /Data/, keys %$data );\n   if ( !defined $data->{'Data'} ) {\n       $self->{'_last_data'} = undef;\n       return;\n   }\n   if( $data->{'Data'} =~ /^\\s+$/ ) {\n       return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n   }\n\n   if( $self->in_element('hsp') && \n       $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ ) {\n       \n       $self->{'_last_hspdata'}->{$data->{'Name'}} .= $data->{'Data'};\n   }  \n   \n   $self->{'_last_data'} = $data->{'Data'}; \n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element{\n   my ($self,$name) = @_;  \n   return 0 if ( ! defined $name &&\n\t\t ! defined  $self->{'_elements'} ||\n\t\t scalar @{$self->{'_elements'}} == 0) ;\n   foreach (  @{$self->{'_elements'}} ) {\n       if( $_ eq $name  ) {\n\t   return 1;\n       } \n   }\n   return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub in_element{\n   my ($self,$name) = @_;  \n   return 0 if ! defined $self->{'_elements'}->[0];\n   return ( $self->{'_elements'}->[0] eq $name)\n}\n\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handles a start document event\n Returns : none\n Args    : none\n\n\n\nsub start_document{\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'} = {};\n    $self->{'_result'}= undef;\n    $self->{'_mode'} = '';\n    $self->{'_elements'} = [];\n}\n\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $eventgenerator->end_document\n Function: Handles an end document event\n Returns : Bio::Search::Result::ResultI object\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}]},"name":"end_document","range":{"end":{"line":533,"character":9999},"start":{"line":530,"character":0}}},{"kind":12,"line":546,"children":[{"containerName":"result_count","name":"$self","definition":"my","localvar":"my","kind":13,"line":547},{"name":"$self","containerName":"result_count","kind":13,"line":548}],"containerName":"main::","name":"result_count","definition":"sub","range":{"end":{"character":9999,"line":549},"start":{"line":546,"character":0}}},{"kind":12,"line":551,"children":[{"line":551,"kind":12,"containerName":"report_count","name":"result_count"}],"containerName":"main::","definition":"sub","name":"report_count","range":{"start":{"line":551,"character":0},"end":{"character":9999,"line":551}}},{"line":565,"children":[{"line":566,"kind":13,"localvar":"my","containerName":"program_name","name":"$self","definition":"my"},{"kind":13,"line":568,"name":"$self","containerName":"program_name"},{"name":"$self","containerName":"program_name","kind":13,"line":569},{"line":569,"kind":13,"name":"$DefaultProgramName","containerName":"program_name"}],"kind":12,"range":{"end":{"line":570,"character":9999},"start":{"character":0,"line":565}},"containerName":"main::","definition":"sub","name":"program_name"},{"range":{"end":{"line":620,"character":9999},"start":{"character":0,"line":611}},"name":"_will_handle","children":[{"line":612,"kind":13,"localvar":"my","containerName":"_will_handle","definition":"my","name":"$self"},{"kind":13,"line":612,"name":"$type","containerName":"_will_handle"},{"line":613,"kind":13,"localvar":"my","containerName":"_will_handle","definition":"my","name":"$handler"},{"containerName":"_will_handle","name":"$self","line":613,"kind":13},{"kind":13,"line":614,"definition":"my","name":"$will_handle","containerName":"_will_handle","localvar":"my"},{"kind":13,"line":614,"name":"$self","containerName":"_will_handle"},{"containerName":"_will_handle","name":"$type","line":614,"kind":13},{"line":615,"kind":13,"name":"$self","containerName":"_will_handle"},{"name":"$type","containerName":"_will_handle","line":615,"kind":13},{"kind":13,"line":616,"containerName":"_will_handle","name":"$self"},{"line":616,"kind":13,"containerName":"_will_handle","name":"$type"},{"containerName":"_will_handle","name":"$handler","kind":13,"line":617},{"name":"will_handle","containerName":"_will_handle","line":617,"kind":12},{"containerName":"_will_handle","name":"$type","kind":13,"line":617},{"kind":13,"line":619,"name":"$will_handle","containerName":"_will_handle"},{"containerName":"_will_handle","name":"$handler","kind":13,"line":619}],"line":611,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"1;\n# $Id: blasttable.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blasttable\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::blasttable - Driver module for SearchIO for parsing NCBI -m 8/9 format\n\n=head1 SYNOPSIS\n\n  # do not use this module directly\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => $file,\n                                 -format => 'blasttable');\n\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis module will support parsing NCBI -m 8 or -m 9 tabular output\nand WU-BLAST -mformat 2 or -mformat 3 tabular output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::blasttable;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\nuse strict;\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::HSP::HSPFactory;\n\n$DefaultProgramName = 'BLASTN';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\n%MAPPING = ( \n\t     'Hsp_bit-score'  => 'HSP-bits',\n\t     'Hsp_score'      => 'HSP-score',\n\t     'Hsp_evalue'     => 'HSP-evalue',\n\t     'Hsp_query-from' => 'HSP-query_start',\n\t     'Hsp_query-to'   => 'HSP-query_end',\n\t     'Hsp_hit-from'   => 'HSP-hit_start',\n\t     'Hsp_hit-to'     => 'HSP-hit_end',\n\t     'Hsp_positive'   => 'HSP-conserved',\n\t     'Hsp_identity'   => 'HSP-identical',\n\t     'Hsp_mismatches' => 'HSP-mismatches',\n\t     'Hsp_qgapblocks' => 'HSP-query_gapblocks',\n\t     'Hsp_hgapblocks' => 'HSP-hit_gapblocks',\n\t     'Hsp_gaps'       => 'HSP-hsp_gaps',\n\t     'Hsp_hitgaps'    => 'HSP-hit_gaps',\n\t     'Hsp_querygaps'  => 'HSP-query_gaps',\n\t     'Hsp_align-len'  => 'HSP-hsp_length',\n\t     'Hsp_query-frame'=> 'HSP-query_frame',\n\t     'Hsp_hit-frame'  => 'HSP-hit_frame',\n\n\t     'Hit_id'        => 'HIT-name',\n\t     'Hit_len'       => 'HIT-length',\n\t     'Hit_accession' => 'HIT-accession',\n\t     'Hit_def'       => 'HIT-description',\n\t     'Hit_signif'    => 'HIT-significance',\n\t     'Hit_score'     => 'HIT-score',\n\t     'Hit_bits'      => 'HIT-bits',\n\n\t     'Result_program'  => 'RESULT-algorithm_name',\n\t     'Result_version'  => 'RESULT-algorithm_version',\n\t     'Result_query-def'=> 'RESULT-query_name',\n\t     'Result_query-len'=> 'RESULT-query_length',\n\t     'Result_query-acc'=> 'RESULT-query_accession',\n\t     'Result_querydesc'=> 'RESULT-query_description',\n\t     'Result_db'       => 'RESULT-database_name',\n\t     'Result_db-len'   => 'RESULT-database_entries',\n\t     'Result_db-let'   => 'RESULT-database_letters',\n\t     );\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blasttable->new();\n Function: Builds a new Bio::SearchIO::blasttable object \n Returns : an instance of Bio::SearchIO::blasttable\n Args    :\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n\n    my ($pname) = $self->_rearrange([qw(PROGRAM_NAME)],\n\t\t\t\t    @args);\n    $self->program_name($pname || $DefaultProgramName);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n    $self->_eventHandler->register_factory('hit', Bio::Search::Hit::HitFactory->new(-type => 'Bio::Search::Hit::GenericHit'));\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI>\n Args    : none\n\n\n\nsub next_result{\n   my ($self) = @_;\n   my ($lastquery,$lasthit);\n   local $/ = \"\\n\";\n   local $_;\n   my ($alg, $ver);\n   while( defined ($_ = $self->_readline) ) {\n\t  # WU-BLAST -mformat 3 only\n\t  if(m{^#\\s((?:\\S+?)?BLAST[NPX])\\s(\\d+\\.\\d+.+\\d{4}\\])}) {\n            ($alg, $ver) = ($1, $2);\n\t\t\t# only one header for whole file with WU-BLAST\n\t\t\t# so $alg and $ver won't get set properly for\n\t\t\t# each result\n\t\t\t$self->program_name($alg) if $alg;\n\t\t\t$self->element({'Name' => 'Result_version',\n\t\t\t\t\t   \t\t'Data' => $ver}) if $ver;\n            next;\n\t  }\n      # -m 9 only\n      elsif(m{^#\\s+((?:\\S+?)?BLAST[NPX])\\s+(.+)}) {\n            ($alg, $ver) = ($1, $2);\n            next;\n       }\n       next if /^#/ || /^\\s*$/;\n\n\t  my @fields = split;\n      next if @fields == 1;\n\t  my ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t      $qstart,$qend,$hstart,$hend,$evalue,$bits);\n\t  # WU-BLAST-specific\n\t  my ($num_scores, $raw_score, $identities, $positives, $percent_pos,\n\t      $qgap_blocks,$qgaps, $sgap_blocks, $sgaps, $qframe,\n\t      $sframe);\n\t  # NCBI -m8 and -m9\n\t  if (@fields == 12) {\n\t      ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n\t  # NCBI -m8 and -m9, v 2.2.18+\n\t  } elsif (@fields == 13) {\n          ($qname, $hname, $percent_id, $percent_pos, $hsp_len, $mismatches, $gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n      }\n\t  # WU-BLAST -mformat 2 and 3\n\t  elsif ((@fields == 22) or (@fields == 24)) {\n\t      ($qname,$hname,$evalue,$num_scores, $bits, $raw_score, $hsp_len,\n\t       $identities, $positives,$mismatches, $percent_id, $percent_pos,\n\t       $qgap_blocks, $qgaps, $sgap_blocks, $sgaps, $qframe, $qstart,\n\t       $qend, $sframe, $hstart,$hend,) = @fields;\n\t      # we need total gaps in the alignment\n\t      $gapsm=$qgaps+$sgaps;\n\t  }\n\n       # Remember Jim's code is 0 based\n       if( defined $lastquery && \n\t   $lastquery ne $qname ) {\n\t   $self->end_element({'Name' => 'Hit'});\n\t   $self->end_element({'Name' => 'Result'});\n\t   $self->_pushback($_);\n\t   return $self->end_document;\n       } elsif( ! defined $lastquery ) {\n\t   $self->{'_result_count'}++;\n\t   $self->start_element({'Name' => 'Result'});\n\t   $self->element({'Name' => 'Result_program',\n\t\t\t   'Data' => $alg || $self->program_name});\n       $self->element({'Name' => 'Result_version',\n\t\t\t   'Data' => $ver}) if $ver;\n\t   $self->element({'Name' => 'Result_query-def',\n\t\t\t   'Data' => $qname});\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n\t   \n       } elsif( $lasthit ne $hname ) {\n\t   if( $self->in_element('hit') ) {\t       \n\t       $self->end_element({'Name' => 'Hit'});\n\t   }\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n       }\n       my $identical = $hsp_len - $mismatches - $gapsm;\n       $self->start_element({'Name' => 'Hsp'});\n       $self->element({'Name' => 'Hsp_evalue',\t\t\t   \n\t\t       'Data' => $evalue});       \n       $self->element({'Name' => 'Hsp_bit-score',\n\t\t       'Data' => $bits});\n       $self->element({'Name' => 'Hsp_identity',\n\t\t       'Data' => $identical});\n       $self->element({'Name' => 'Hsp_positive',\n\t\t       'Data' => $positives});\n       $self->element({'Name' => 'Hsp_gaps',\n\t\t       'Data' => $gapsm});\n       $self->element({'Name' => 'Hsp_query-from',\n\t\t       'Data' => $qstart});\n       $self->element({'Name' => 'Hsp_query-to',\n\t\t       'Data' => $qend});\n\n       $self->element({'Name' => 'Hsp_hit-from',\n\t\t       'Data' => $hstart });\n       $self->element({'Name' => 'Hsp_hit-to',\n\t\t       'Data' => $hend });\n       $self->element({'Name' => 'Hsp_align-len',\n\t\t       'Data' => $hsp_len});\n       $self->end_element({'Name' => 'Hsp'});\n       $lastquery = $qname;\n       $lasthit   = $hname;\n   }\n   # fencepost\n   if( defined $lasthit && defined $lastquery ) {\n       if( $self->in_element('hit') ) {\n\t   $self->end_element({'Name' => 'Hit'});\n       }\n       $self->end_element({'Name' => 'Result'});\n       return $self->end_document;\n   }\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'Result') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n        \n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'Result' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;   \n\n# deep bug fix: set $self->{'_last_data'} to undef if $$data{Data} is \n# a valid slot, whose value is undef --\n# allows an undef to be propagated to object constructors and\n# handled there as desired; in particular, when Hsp_postive => -conserved\n# is not defined (in BLASTN, e.g.), the value of hsp's {CONSERVED} property is \n# set to the value of {IDENTICAL}.\n#/maj\n#   return unless ( defined $data->{'Data'} ); \n   return unless ( grep /Data/, keys %$data );\n   if ( !defined $data->{'Data'} ) {\n       $self->{'_last_data'} = undef;\n       return;\n   }\n   if( $data->{'Data'} =~ /^\\s+$/ ) {\n       return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n   }\n\n   if( $self->in_element('hsp') && \n       $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ ) {\n       \n       $self->{'_last_hspdata'}->{$data->{'Name'}} .= $data->{'Data'};\n   }  \n   \n   $self->{'_last_data'} = $data->{'Data'}; \n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element{\n   my ($self,$name) = @_;  \n   return 0 if ( ! defined $name &&\n\t\t ! defined  $self->{'_elements'} ||\n\t\t scalar @{$self->{'_elements'}} == 0) ;\n   foreach (  @{$self->{'_elements'}} ) {\n       if( $_ eq $name  ) {\n\t   return 1;\n       } \n   }\n   return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub in_element{\n   my ($self,$name) = @_;  \n   return 0 if ! defined $self->{'_elements'}->[0];\n   return ( $self->{'_elements'}->[0] eq $name)\n}\n\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handles a start document event\n Returns : none\n Args    : none\n\n\n\nsub start_document{\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'} = {};\n    $self->{'_result'}= undef;\n    $self->{'_mode'} = '';\n    $self->{'_elements'} = [];\n}\n\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $eventgenerator->end_document\n Function: Handles an end document event\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\n\nsub end_document{\n   my ($self,@args) = @_;\n   return $self->{'_result'};\n}\n\n=head2 result_count\n\n Title   : result_count\n Usage   : my $count = $searchio->result_count\n Function: Returns the number of results we have processed\n Returns : integer\n Args    : none\n\n\n\nsub result_count {\n    my $self = shift;\n    return $self->{'_result_count'};\n}\n\nsub report_count { shift->result_count }\n\n\n=head2 program_name\n\n Title   : program_name\n Usage   : $obj->program_name($newval)\n Function: Get/Set the program name\n Returns : value of program_name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub program_name{\n    my $self = shift;\n\n    $self->{'program_name'} = shift if @_;\n    return $self->{'program_name'} || $DefaultProgramName;\n}\n\n\n=head2 _will_handle\n\n Title   : _will_handle\n Usage   : Private method. For internal use only.\n              if( $self->_will_handle($type) ) { ... }\n Function: Provides an optimized way to check whether or not an element of a \n           given type is to be handled.\n Returns : Reference to EventHandler object if the element type is to be handled.\n           undef if the element type is not to be handled.\n Args    : string containing type of element.\n\nOptimizations:\n\n=over 2\n\n* 1\n\nUsing the cached pointer to the EventHandler to minimize repeated\nlookups.\n\n* 2\n\nCaching the will_handle status for each type that is encountered so\nthat it only need be checked by calling\nhandler-E<gt>will_handle($type) once.\n\n\nThis does not lead to a major savings by itself (only 5-10%).  In\ncombination with other optimizations, or for large parse jobs, the\nsavings good be significant.\n\nTo test against the unoptimized version, remove the parentheses from\naround the third term in the ternary \" ? : \" operator and add two\ncalls to $self-E<gt>_eventHandler().","label":"_will_handle($self,$type)"},"detail":"($self,$type)","definition":"sub","containerName":"main::"}]}