{"vars":[{"line":120,"kind":2,"name":"Align","containerName":"strict::Bio::Ext"},{"containerName":"","name":"base","kind":2,"line":128},{"kind":12,"line":130,"children":[{"localvar":"my","name":"$class","definition":"my","containerName":"new","line":131,"kind":13},{"containerName":"new","name":"@args","kind":13,"line":131},{"localvar":"my","containerName":"new","name":"$self","definition":"my","line":132,"kind":13},{"containerName":"new","name":"$class","kind":13,"line":132},{"kind":13,"line":132,"name":"@args","containerName":"new"},{"definition":"my","name":"$min","containerName":"new","localvar":"my","kind":13,"line":133},{"containerName":"new","name":"$max","line":133,"kind":13},{"line":133,"kind":13,"containerName":"new","name":"$lump"},{"kind":13,"line":134,"containerName":"new","name":"$self"},{"name":"_rearrange","containerName":"new","line":134,"kind":12},{"name":"@args","containerName":"new","line":134,"kind":13},{"line":136,"kind":13,"name":"$min","containerName":"new"},{"name":"$min","containerName":"new","kind":13,"line":137},{"line":140,"kind":13,"name":"$max","containerName":"new"},{"name":"$max","containerName":"new","line":141,"kind":13},{"kind":13,"line":144,"containerName":"new","name":"$lump"},{"line":145,"kind":13,"name":"$lump","containerName":"new"},{"containerName":"new","name":"$self","line":148,"kind":13},{"containerName":"new","name":"_engine","kind":12,"line":148},{"containerName":"new","name":"$min","kind":13,"line":148},{"line":148,"kind":13,"containerName":"new","name":"$max"},{"containerName":"new","name":"$lump","kind":13,"line":148},{"kind":13,"line":150,"name":"$self","containerName":"new"}],"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":""},"name":"new","range":{"start":{"character":0,"line":130},"end":{"character":9999,"line":151}}},{"name":"SUPER","containerName":"new","line":132,"kind":12},{"name":"Bio","containerName":"Ext::Align::new_Histogram","line":148,"kind":12},{"signature":{"label":"add_score($self,$score)","documentation":"__END__\n# $Id: SearchDist.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n#\n# BioPerl module for Bio::SearchDist\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchDist - A perl wrapper around Sean Eddy's histogram object\n\n=head1 SYNOPSIS\n\n  $dis = Bio::SearchDist->new();\n  foreach $score ( @scores ) {\n     $dis->add_score($score);\n  }\n\n  if( $dis->fit_evd() ) {\n    foreach $score ( @scores ) {\n      $evalue = $dis->evalue($score);\n      print \"Score $score had an evalue of $evalue\\n\";\n    }\n  } else {\n    warn(\"Could not fit histogram to an EVD!\");\n  }\n\n=head1 DESCRIPTION\n\nThe Bio::SearchDist object is a wrapper around Sean Eddy's excellent\nhistogram object. The histogram object can bascially take in a number\nof scores which are sensibly distributed somewhere around 0 that come\nfrom a supposed Extreme Value Distribution. Having add all the scores\nfrom a database search via the add_score method you can then fit a\nextreme value distribution using fit_evd(). Once fitted you can then\nget out the evalue for each score (or a new score) using\nevalue($score).\n\nThe fitting procedure is better described in Sean Eddy's own code\n(available from http://hmmer.janelia.org/, or in the histogram.h header\nfile in Compile/SW). Bascially it fits a EVD via a maximum likelhood\nmethod with pruning of the top end of the distribution so that real\npositives are discarded in the fitting procedure. This comes from\nan orginally idea of Richard Mott's and the likelhood fitting\nis from a book by Lawless [should ref here].\n\n\nThe object relies on the fact that the scores are sensibly distributed\naround about 0 and that integer bins are sensible for the\nhistogram. Scores based on bits are often ideal for this (bits based\nscoring mechanisms is what this histogram object was originally\ndesigned for).\n\n\n=head1 CONTACT\n\nThe original code this was based on comes from the histogram module as\npart of the HMMer2 package. Look at http://hmmer.janelia.org/\n\nIts use in Bioperl is via the Compiled XS extension which is cared for\nby Ewan Birney (birney@ebi.ac.uk). Please contact Ewan first about\nthe use of this module\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchDist;\nuse strict;\n\n\nBEGIN {\n    eval {\n\trequire Bio::Ext::Align;\n    };\n    if ( $@ ) {\nprint $@;\n\tprint STDERR (\"\\nThe C-compiled engine for histogram object (Bio::Ext::Align) has not been installed.\\n Please install the bioperl-ext package\\n\\n\");\n\texit(1);\n    }\n}\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my($min, $max, $lump) =\n\t$self->_rearrange([qw(MIN MAX LUMP)], @args);\n\n  if( !  $min ) {\n    $min = -100;\n  }\n\n  if( !  $max ) {\n    $max = +100;\n  }\n\n  if( ! $lump ) {\n    $lump = 50;\n  }\n\n  $self->_engine(&Bio::Ext::Align::new_Histogram($min,$max,$lump));\n\n  return $self;\n}\n\n=head2 add_score\n\n Title   : add_score\n Usage   : $dis->add_score(300);\n Function: Adds a single score to the distribution\n Returns : nothing\n Args    :","parameters":[{"label":"$self"},{"label":"$score"}]},"detail":"($self,$score)","definition":"sub","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"add_score","localvar":"my","kind":13,"line":165},{"kind":13,"line":165,"containerName":"add_score","name":"$score"},{"containerName":"add_score","definition":"my","name":"$eng","localvar":"my","kind":13,"line":166},{"line":167,"kind":13,"name":"$eng","containerName":"add_score"},{"containerName":"add_score","name":"$self","kind":13,"line":167},{"name":"_engine","containerName":"add_score","kind":12,"line":167},{"name":"$eng","containerName":"add_score","line":169,"kind":13},{"name":"add","containerName":"add_score","line":169,"kind":12},{"line":169,"kind":13,"containerName":"add_score","name":"$score"}],"line":164,"kind":12,"range":{"start":{"character":0,"line":164},"end":{"character":9999,"line":170}},"name":"add_score"},{"kind":12,"line":183,"children":[{"kind":13,"line":184,"containerName":"fit_evd","definition":"my","name":"$self","localvar":"my"},{"name":"@args","containerName":"fit_evd","line":184,"kind":13},{"line":186,"kind":13,"name":"$self","containerName":"fit_evd"},{"line":186,"kind":12,"name":"_engine","containerName":"fit_evd"},{"line":186,"kind":12,"name":"fit_EVD","containerName":"fit_evd"}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"__END__\n# $Id: SearchDist.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n#\n# BioPerl module for Bio::SearchDist\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchDist - A perl wrapper around Sean Eddy's histogram object\n\n=head1 SYNOPSIS\n\n  $dis = Bio::SearchDist->new();\n  foreach $score ( @scores ) {\n     $dis->add_score($score);\n  }\n\n  if( $dis->fit_evd() ) {\n    foreach $score ( @scores ) {\n      $evalue = $dis->evalue($score);\n      print \"Score $score had an evalue of $evalue\\n\";\n    }\n  } else {\n    warn(\"Could not fit histogram to an EVD!\");\n  }\n\n=head1 DESCRIPTION\n\nThe Bio::SearchDist object is a wrapper around Sean Eddy's excellent\nhistogram object. The histogram object can bascially take in a number\nof scores which are sensibly distributed somewhere around 0 that come\nfrom a supposed Extreme Value Distribution. Having add all the scores\nfrom a database search via the add_score method you can then fit a\nextreme value distribution using fit_evd(). Once fitted you can then\nget out the evalue for each score (or a new score) using\nevalue($score).\n\nThe fitting procedure is better described in Sean Eddy's own code\n(available from http://hmmer.janelia.org/, or in the histogram.h header\nfile in Compile/SW). Bascially it fits a EVD via a maximum likelhood\nmethod with pruning of the top end of the distribution so that real\npositives are discarded in the fitting procedure. This comes from\nan orginally idea of Richard Mott's and the likelhood fitting\nis from a book by Lawless [should ref here].\n\n\nThe object relies on the fact that the scores are sensibly distributed\naround about 0 and that integer bins are sensible for the\nhistogram. Scores based on bits are often ideal for this (bits based\nscoring mechanisms is what this histogram object was originally\ndesigned for).\n\n\n=head1 CONTACT\n\nThe original code this was based on comes from the histogram module as\npart of the HMMer2 package. Look at http://hmmer.janelia.org/\n\nIts use in Bioperl is via the Compiled XS extension which is cared for\nby Ewan Birney (birney@ebi.ac.uk). Please contact Ewan first about\nthe use of this module\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchDist;\nuse strict;\n\n\nBEGIN {\n    eval {\n\trequire Bio::Ext::Align;\n    };\n    if ( $@ ) {\nprint $@;\n\tprint STDERR (\"\\nThe C-compiled engine for histogram object (Bio::Ext::Align) has not been installed.\\n Please install the bioperl-ext package\\n\\n\");\n\texit(1);\n    }\n}\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my($min, $max, $lump) =\n\t$self->_rearrange([qw(MIN MAX LUMP)], @args);\n\n  if( !  $min ) {\n    $min = -100;\n  }\n\n  if( !  $max ) {\n    $max = +100;\n  }\n\n  if( ! $lump ) {\n    $lump = 50;\n  }\n\n  $self->_engine(&Bio::Ext::Align::new_Histogram($min,$max,$lump));\n\n  return $self;\n}\n\n=head2 add_score\n\n Title   : add_score\n Usage   : $dis->add_score(300);\n Function: Adds a single score to the distribution\n Returns : nothing\n Args    :\n\n\n\nsub add_score{\n   my ($self,$score) = @_;\n   my ($eng);\n   $eng = $self->_engine();\n   #$eng->AddToHistogram($score);\n   $eng->add($score);\n}\n\n=head2 fit_evd\n\n Title   : fit_evd\n Usage   : $dis->fit_evd();\n Function: fits an evd to the current distribution\n Returns : 1 if it fits successfully, 0 if not\n Args    :","label":"fit_evd($self,@args)"},"name":"fit_evd","range":{"end":{"character":9999,"line":187},"start":{"character":0,"line":183}}},{"name":"fit_Gaussian","range":{"end":{"character":9999,"line":209},"start":{"line":201,"character":0}},"containerName":"main::","definition":"sub","detail":"($self,$high)","signature":{"documentation":"__END__\n# $Id: SearchDist.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n#\n# BioPerl module for Bio::SearchDist\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchDist - A perl wrapper around Sean Eddy's histogram object\n\n=head1 SYNOPSIS\n\n  $dis = Bio::SearchDist->new();\n  foreach $score ( @scores ) {\n     $dis->add_score($score);\n  }\n\n  if( $dis->fit_evd() ) {\n    foreach $score ( @scores ) {\n      $evalue = $dis->evalue($score);\n      print \"Score $score had an evalue of $evalue\\n\";\n    }\n  } else {\n    warn(\"Could not fit histogram to an EVD!\");\n  }\n\n=head1 DESCRIPTION\n\nThe Bio::SearchDist object is a wrapper around Sean Eddy's excellent\nhistogram object. The histogram object can bascially take in a number\nof scores which are sensibly distributed somewhere around 0 that come\nfrom a supposed Extreme Value Distribution. Having add all the scores\nfrom a database search via the add_score method you can then fit a\nextreme value distribution using fit_evd(). Once fitted you can then\nget out the evalue for each score (or a new score) using\nevalue($score).\n\nThe fitting procedure is better described in Sean Eddy's own code\n(available from http://hmmer.janelia.org/, or in the histogram.h header\nfile in Compile/SW). Bascially it fits a EVD via a maximum likelhood\nmethod with pruning of the top end of the distribution so that real\npositives are discarded in the fitting procedure. This comes from\nan orginally idea of Richard Mott's and the likelhood fitting\nis from a book by Lawless [should ref here].\n\n\nThe object relies on the fact that the scores are sensibly distributed\naround about 0 and that integer bins are sensible for the\nhistogram. Scores based on bits are often ideal for this (bits based\nscoring mechanisms is what this histogram object was originally\ndesigned for).\n\n\n=head1 CONTACT\n\nThe original code this was based on comes from the histogram module as\npart of the HMMer2 package. Look at http://hmmer.janelia.org/\n\nIts use in Bioperl is via the Compiled XS extension which is cared for\nby Ewan Birney (birney@ebi.ac.uk). Please contact Ewan first about\nthe use of this module\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchDist;\nuse strict;\n\n\nBEGIN {\n    eval {\n\trequire Bio::Ext::Align;\n    };\n    if ( $@ ) {\nprint $@;\n\tprint STDERR (\"\\nThe C-compiled engine for histogram object (Bio::Ext::Align) has not been installed.\\n Please install the bioperl-ext package\\n\\n\");\n\texit(1);\n    }\n}\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my($min, $max, $lump) =\n\t$self->_rearrange([qw(MIN MAX LUMP)], @args);\n\n  if( !  $min ) {\n    $min = -100;\n  }\n\n  if( !  $max ) {\n    $max = +100;\n  }\n\n  if( ! $lump ) {\n    $lump = 50;\n  }\n\n  $self->_engine(&Bio::Ext::Align::new_Histogram($min,$max,$lump));\n\n  return $self;\n}\n\n=head2 add_score\n\n Title   : add_score\n Usage   : $dis->add_score(300);\n Function: Adds a single score to the distribution\n Returns : nothing\n Args    :\n\n\n\nsub add_score{\n   my ($self,$score) = @_;\n   my ($eng);\n   $eng = $self->_engine();\n   #$eng->AddToHistogram($score);\n   $eng->add($score);\n}\n\n=head2 fit_evd\n\n Title   : fit_evd\n Usage   : $dis->fit_evd();\n Function: fits an evd to the current distribution\n Returns : 1 if it fits successfully, 0 if not\n Args    :\n\n\n\nsub fit_evd{\n   my ($self,@args) = @_;\n\n   return $self->_engine()->fit_EVD(10000,1);\n}\n\n=head2 fit_Gaussian\n\n Title   : fit_Gaussian\n Usage   :\n Function:\n Example :\n Returns :\n Args    :","parameters":[{"label":"$self"},{"label":"$high"}],"label":"fit_Gaussian($self,$high)"},"kind":12,"line":201,"children":[{"line":202,"kind":13,"localvar":"my","containerName":"fit_Gaussian","name":"$self","definition":"my"},{"line":202,"kind":13,"containerName":"fit_Gaussian","name":"$high"},{"containerName":"fit_Gaussian","name":"$high","line":204,"kind":13},{"containerName":"fit_Gaussian","name":"$high","line":205,"kind":13},{"kind":13,"line":208,"name":"$self","containerName":"fit_Gaussian"},{"name":"_engine","containerName":"fit_Gaussian","line":208,"kind":12},{"kind":12,"line":208,"name":"fit_Gaussian","containerName":"fit_Gaussian"},{"kind":13,"line":208,"name":"$high","containerName":"fit_Gaussian"}]},{"name":"evalue","range":{"end":{"line":228,"character":9999},"start":{"line":223,"character":0}},"definition":"sub","containerName":"main::","signature":{"label":"evalue($self,$score)","parameters":[{"label":"$self"},{"label":"$score"}],"documentation":"__END__\n# $Id: SearchDist.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n#\n# BioPerl module for Bio::SearchDist\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchDist - A perl wrapper around Sean Eddy's histogram object\n\n=head1 SYNOPSIS\n\n  $dis = Bio::SearchDist->new();\n  foreach $score ( @scores ) {\n     $dis->add_score($score);\n  }\n\n  if( $dis->fit_evd() ) {\n    foreach $score ( @scores ) {\n      $evalue = $dis->evalue($score);\n      print \"Score $score had an evalue of $evalue\\n\";\n    }\n  } else {\n    warn(\"Could not fit histogram to an EVD!\");\n  }\n\n=head1 DESCRIPTION\n\nThe Bio::SearchDist object is a wrapper around Sean Eddy's excellent\nhistogram object. The histogram object can bascially take in a number\nof scores which are sensibly distributed somewhere around 0 that come\nfrom a supposed Extreme Value Distribution. Having add all the scores\nfrom a database search via the add_score method you can then fit a\nextreme value distribution using fit_evd(). Once fitted you can then\nget out the evalue for each score (or a new score) using\nevalue($score).\n\nThe fitting procedure is better described in Sean Eddy's own code\n(available from http://hmmer.janelia.org/, or in the histogram.h header\nfile in Compile/SW). Bascially it fits a EVD via a maximum likelhood\nmethod with pruning of the top end of the distribution so that real\npositives are discarded in the fitting procedure. This comes from\nan orginally idea of Richard Mott's and the likelhood fitting\nis from a book by Lawless [should ref here].\n\n\nThe object relies on the fact that the scores are sensibly distributed\naround about 0 and that integer bins are sensible for the\nhistogram. Scores based on bits are often ideal for this (bits based\nscoring mechanisms is what this histogram object was originally\ndesigned for).\n\n\n=head1 CONTACT\n\nThe original code this was based on comes from the histogram module as\npart of the HMMer2 package. Look at http://hmmer.janelia.org/\n\nIts use in Bioperl is via the Compiled XS extension which is cared for\nby Ewan Birney (birney@ebi.ac.uk). Please contact Ewan first about\nthe use of this module\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchDist;\nuse strict;\n\n\nBEGIN {\n    eval {\n\trequire Bio::Ext::Align;\n    };\n    if ( $@ ) {\nprint $@;\n\tprint STDERR (\"\\nThe C-compiled engine for histogram object (Bio::Ext::Align) has not been installed.\\n Please install the bioperl-ext package\\n\\n\");\n\texit(1);\n    }\n}\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my($min, $max, $lump) =\n\t$self->_rearrange([qw(MIN MAX LUMP)], @args);\n\n  if( !  $min ) {\n    $min = -100;\n  }\n\n  if( !  $max ) {\n    $max = +100;\n  }\n\n  if( ! $lump ) {\n    $lump = 50;\n  }\n\n  $self->_engine(&Bio::Ext::Align::new_Histogram($min,$max,$lump));\n\n  return $self;\n}\n\n=head2 add_score\n\n Title   : add_score\n Usage   : $dis->add_score(300);\n Function: Adds a single score to the distribution\n Returns : nothing\n Args    :\n\n\n\nsub add_score{\n   my ($self,$score) = @_;\n   my ($eng);\n   $eng = $self->_engine();\n   #$eng->AddToHistogram($score);\n   $eng->add($score);\n}\n\n=head2 fit_evd\n\n Title   : fit_evd\n Usage   : $dis->fit_evd();\n Function: fits an evd to the current distribution\n Returns : 1 if it fits successfully, 0 if not\n Args    :\n\n\n\nsub fit_evd{\n   my ($self,@args) = @_;\n\n   return $self->_engine()->fit_EVD(10000,1);\n}\n\n=head2 fit_Gaussian\n\n Title   : fit_Gaussian\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub fit_Gaussian{\n   my ($self,$high) = @_;\n\n   if( ! defined $high ) {\n       $high = 10000;\n   }\n\n   return $self->_engine()->fit_Gaussian($high);\n}\n\n\n=head2 evalue\n\n Title   : evalue\n Usage   : $eval = $dis->evalue($score)\n Function: Returns the evalue of this score\n Returns : float\n Args    :"},"detail":"($self,$score)","kind":12,"children":[{"kind":13,"line":224,"containerName":"evalue","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":224,"name":"$score","containerName":"evalue"},{"kind":13,"line":226,"name":"$self","containerName":"evalue"},{"containerName":"evalue","name":"_engine","line":226,"kind":12},{"containerName":"evalue","name":"evalue","line":226,"kind":12},{"line":226,"kind":13,"containerName":"evalue","name":"$score"}],"line":223},{"signature":{"documentation":"__END__\n# $Id: SearchDist.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n#\n# BioPerl module for Bio::SearchDist\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchDist - A perl wrapper around Sean Eddy's histogram object\n\n=head1 SYNOPSIS\n\n  $dis = Bio::SearchDist->new();\n  foreach $score ( @scores ) {\n     $dis->add_score($score);\n  }\n\n  if( $dis->fit_evd() ) {\n    foreach $score ( @scores ) {\n      $evalue = $dis->evalue($score);\n      print \"Score $score had an evalue of $evalue\\n\";\n    }\n  } else {\n    warn(\"Could not fit histogram to an EVD!\");\n  }\n\n=head1 DESCRIPTION\n\nThe Bio::SearchDist object is a wrapper around Sean Eddy's excellent\nhistogram object. The histogram object can bascially take in a number\nof scores which are sensibly distributed somewhere around 0 that come\nfrom a supposed Extreme Value Distribution. Having add all the scores\nfrom a database search via the add_score method you can then fit a\nextreme value distribution using fit_evd(). Once fitted you can then\nget out the evalue for each score (or a new score) using\nevalue($score).\n\nThe fitting procedure is better described in Sean Eddy's own code\n(available from http://hmmer.janelia.org/, or in the histogram.h header\nfile in Compile/SW). Bascially it fits a EVD via a maximum likelhood\nmethod with pruning of the top end of the distribution so that real\npositives are discarded in the fitting procedure. This comes from\nan orginally idea of Richard Mott's and the likelhood fitting\nis from a book by Lawless [should ref here].\n\n\nThe object relies on the fact that the scores are sensibly distributed\naround about 0 and that integer bins are sensible for the\nhistogram. Scores based on bits are often ideal for this (bits based\nscoring mechanisms is what this histogram object was originally\ndesigned for).\n\n\n=head1 CONTACT\n\nThe original code this was based on comes from the histogram module as\npart of the HMMer2 package. Look at http://hmmer.janelia.org/\n\nIts use in Bioperl is via the Compiled XS extension which is cared for\nby Ewan Birney (birney@ebi.ac.uk). Please contact Ewan first about\nthe use of this module\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchDist;\nuse strict;\n\n\nBEGIN {\n    eval {\n\trequire Bio::Ext::Align;\n    };\n    if ( $@ ) {\nprint $@;\n\tprint STDERR (\"\\nThe C-compiled engine for histogram object (Bio::Ext::Align) has not been installed.\\n Please install the bioperl-ext package\\n\\n\");\n\texit(1);\n    }\n}\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my($min, $max, $lump) =\n\t$self->_rearrange([qw(MIN MAX LUMP)], @args);\n\n  if( !  $min ) {\n    $min = -100;\n  }\n\n  if( !  $max ) {\n    $max = +100;\n  }\n\n  if( ! $lump ) {\n    $lump = 50;\n  }\n\n  $self->_engine(&Bio::Ext::Align::new_Histogram($min,$max,$lump));\n\n  return $self;\n}\n\n=head2 add_score\n\n Title   : add_score\n Usage   : $dis->add_score(300);\n Function: Adds a single score to the distribution\n Returns : nothing\n Args    :\n\n\n\nsub add_score{\n   my ($self,$score) = @_;\n   my ($eng);\n   $eng = $self->_engine();\n   #$eng->AddToHistogram($score);\n   $eng->add($score);\n}\n\n=head2 fit_evd\n\n Title   : fit_evd\n Usage   : $dis->fit_evd();\n Function: fits an evd to the current distribution\n Returns : 1 if it fits successfully, 0 if not\n Args    :\n\n\n\nsub fit_evd{\n   my ($self,@args) = @_;\n\n   return $self->_engine()->fit_EVD(10000,1);\n}\n\n=head2 fit_Gaussian\n\n Title   : fit_Gaussian\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub fit_Gaussian{\n   my ($self,$high) = @_;\n\n   if( ! defined $high ) {\n       $high = 10000;\n   }\n\n   return $self->_engine()->fit_Gaussian($high);\n}\n\n\n=head2 evalue\n\n Title   : evalue\n Usage   : $eval = $dis->evalue($score)\n Function: Returns the evalue of this score\n Returns : float\n Args    :\n\n\n\nsub evalue{\n   my ($self,$score) = @_;\n\n   return $self->_engine()->evalue($score);\n\n}\n\n\n\n=head2 _engine\n\n Title   : _engine\n Usage   : $obj->_engine($newval)\n Function: underlyine bp_sw:: histogram engine\n Returns : value of _engine\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"_engine($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"_engine","localvar":"my","kind":13,"line":244},{"containerName":"_engine","name":"$value","kind":13,"line":244},{"kind":13,"line":245,"containerName":"_engine","name":"$value"},{"line":246,"kind":13,"containerName":"_engine","name":"$self"},{"line":246,"kind":13,"name":"$value","containerName":"_engine"},{"containerName":"_engine","name":"$self","kind":13,"line":248}],"line":243,"kind":12,"range":{"end":{"character":9999,"line":249},"start":{"character":0,"line":243}},"name":"_engine"}],"version":5}