{"vars":[{"containerName":"main::","definition":"our","name":"@ISA","line":7,"kind":13},{"name":"Exporter","containerName":"","line":7,"kind":2},{"definition":"our","name":"@EXPORT","containerName":"main::","line":8,"kind":13},{"line":52,"children":[{"line":54,"kind":13,"localvar":"my","definition":"my","name":"$n","containerName":"interval_tiling"}],"kind":12,"range":{"end":{"line":54,"character":9999},"start":{"character":0,"line":52}},"containerName":"main::","definition":"sub","name":"interval_tiling"},{"localvar":"my","containerName":null,"name":"%input","definition":"my","line":55,"kind":13},{"kind":13,"line":56,"name":"@input","containerName":null},{"line":56,"kind":13,"containerName":null,"name":"@n"},{"kind":13,"line":57,"definition":"my","name":"@active","containerName":null,"localvar":"my"},{"name":"$n","containerName":null,"kind":13,"line":57},{"line":58,"kind":13,"localvar":"my","definition":"my","name":"@hold","containerName":null},{"line":59,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"@tiled_ints"},{"localvar":"my","name":"@ret","definition":"my","containerName":null,"line":60,"kind":13},{"line":61,"kind":13,"name":"@active","containerName":null},{"kind":13,"line":62,"name":"$tgt","definition":"my","containerName":null,"localvar":"my"},{"kind":13,"line":62,"name":"%input","containerName":null},{"localvar":"my","containerName":null,"definition":"my","name":"$tgt_i","line":62,"kind":13},{"containerName":null,"name":"@active","kind":13,"line":62},{"line":63,"kind":13,"containerName":null,"name":"@tiled_ints"},{"kind":13,"line":63,"containerName":null,"name":"$tgt_i"},{"definition":"my","name":"$tgt_not_disjoint","containerName":null,"localvar":"my","kind":13,"line":64},{"line":65,"kind":13,"name":"%tgt_not_disjoint","containerName":null},{"kind":13,"line":66,"name":"$tgt_not_disjoint","containerName":null},{"localvar":"my","definition":"my","name":"$try_i","containerName":null,"line":67,"kind":13},{"containerName":null,"name":"@active","line":67,"kind":13},{"name":"$try","definition":"my","containerName":null,"localvar":"my","kind":13,"line":68},{"kind":13,"line":68,"name":"%input","containerName":null},{"containerName":null,"name":"$try_i","kind":13,"line":68},{"name":"are_disjoint","line":69,"kind":12},{"line":69,"kind":13,"name":"$tgt","containerName":null},{"name":"%try","containerName":null,"line":69,"kind":13},{"line":70,"kind":13,"name":"$tgt","containerName":null},{"name":"min_covering_interval","kind":12,"line":70},{"containerName":null,"name":"$tgt","kind":13,"line":70},{"containerName":null,"name":"$try","line":70,"kind":13},{"containerName":null,"name":"@tiled_ints","kind":13,"line":71},{"containerName":null,"name":"$try_i","line":71,"kind":13},{"line":72,"kind":13,"containerName":null,"name":"%tgt_not_disjoint"},{"name":"@hold","containerName":null,"kind":13,"line":75},{"kind":13,"line":75,"containerName":null,"name":"$try_i"},{"kind":13,"line":78,"containerName":null,"name":"%tgt_not_disjoint"},{"name":"@ret","containerName":null,"kind":13,"line":79},{"kind":13,"line":79,"containerName":null,"name":"@tgt"},{"kind":13,"line":79,"containerName":null,"name":"@tiled_ints"},{"line":80,"kind":13,"name":"@tiled_ints","containerName":null},{"line":82,"kind":13,"name":"@active","containerName":null},{"kind":13,"line":82,"containerName":null,"name":"@hold"},{"name":"@hold","containerName":null,"line":83,"kind":13},{"name":"@ret","containerName":null,"kind":13,"line":86},{"containerName":"main::","name":"decompose_interval","definition":"sub","range":{"end":{"character":9999,"line":114},"start":{"character":0,"line":112}},"kind":12,"line":112,"children":[{"kind":13,"line":114,"name":"@ints","definition":"my","containerName":"decompose_interval","localvar":"my"}]},{"kind":13,"line":115,"name":"%flat","definition":"my","containerName":null,"localvar":"my"},{"name":"@flat","containerName":null,"line":115,"kind":13},{"line":122,"kind":13,"containerName":null,"name":"@ints"},{"containerName":null,"name":"%flat","line":123,"kind":13},{"kind":13,"line":124,"name":"%flat","containerName":null},{"line":125,"kind":13,"containerName":null,"name":"%flat"},{"name":"%flat","containerName":null,"line":126,"kind":13},{"localvar":"my","containerName":null,"name":"@a","definition":"my","line":129,"kind":13},{"containerName":null,"name":"@a","kind":13,"line":130},{"name":"$a","containerName":null,"line":130,"kind":13},{"containerName":null,"name":"$b","kind":13,"line":130},{"kind":13,"line":130,"containerName":null,"name":"%flat"},{"kind":13,"line":132,"containerName":null,"name":"@a"},{"containerName":null,"name":"@a","line":132,"kind":13},{"line":134,"kind":13,"containerName":null,"name":"@flat"},{"kind":13,"line":134,"name":"@a","containerName":null},{"name":"@a","containerName":null,"kind":13,"line":134},{"kind":13,"line":135,"name":"@flat","containerName":null},{"kind":13,"line":135,"containerName":null,"name":"@flat"},{"line":136,"kind":13,"containerName":null,"name":"@flat"},{"containerName":null,"name":"@flat","kind":13,"line":136},{"line":136,"kind":13,"containerName":null,"name":"@flat"},{"name":"@flat","containerName":null,"line":136,"kind":13},{"line":138,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$a"},{"line":138,"kind":13,"containerName":null,"name":"@a"},{"containerName":null,"name":"$a","kind":13,"line":139},{"name":"@flat","containerName":null,"line":139,"kind":13},{"line":140,"kind":13,"containerName":null,"name":"@flat"},{"kind":13,"line":140,"name":"@flat","containerName":null},{"line":142,"kind":13,"containerName":null,"name":"@flat"},{"line":142,"kind":13,"name":"$a","containerName":null},{"line":144,"kind":13,"name":"@flat","containerName":null},{"name":"@flat","containerName":null,"kind":13,"line":144},{"line":144,"kind":13,"containerName":null,"name":"@flat"},{"containerName":null,"name":"@flat","line":145,"kind":13},{"containerName":null,"name":"@flat","line":145,"kind":13},{"localvar":"my","definition":"my","name":"@decomp","containerName":null,"line":148,"kind":13},{"localvar":"my","containerName":null,"name":"$a","definition":"my","line":149,"kind":13},{"containerName":null,"name":"@flat","line":149,"kind":13},{"kind":13,"line":150,"containerName":null,"name":"@decomp"},{"line":150,"kind":13,"name":"$a","containerName":null},{"kind":13,"line":150,"containerName":null,"name":"@flat"},{"definition":"my","name":"@coverage","containerName":null,"localvar":"my","kind":13,"line":155},{"line":156,"kind":13,"localvar":"my","containerName":null,"name":"$i","definition":"my"},{"kind":12,"line":156,"name":"decomp"},{"line":157,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$j"},{"name":"ints","kind":12,"line":157},{"kind":12,"line":158,"name":"are_disjoint"},{"kind":13,"line":158,"containerName":null,"name":"@decomp"},{"line":158,"kind":13,"name":"$i","containerName":null},{"containerName":null,"name":"@ints","kind":13,"line":158},{"kind":13,"line":158,"name":"%j","containerName":null},{"name":"@coverage","containerName":null,"line":159,"kind":13},{"containerName":null,"name":"%i","line":159,"kind":13},{"line":160,"kind":13,"containerName":null,"name":"@coverage"},{"kind":13,"line":160,"containerName":null,"name":"$i"},{"containerName":null,"name":"%j","line":160,"kind":13},{"name":"@coverage","containerName":null,"line":163,"kind":13},{"name":"@i","containerName":null,"kind":13,"line":163},{"kind":13,"line":163,"containerName":null,"name":"%j"},{"kind":13,"line":168,"containerName":null,"name":"@decomp"},{"name":"@coverage","containerName":null,"line":168,"kind":13},{"name":"decomp","line":168,"kind":12},{"containerName":"main::","definition":"sub","detail":"($int1,$int2)","signature":{"parameters":[{"label":"$int1"},{"label":"$int2"}],"documentation":"1;\n#$Id: MapTileUtils.pm 16123 2009-09-17 12:57:27Z cjfields $\npackage Bio::Search::Tiling::MapTileUtils;\nuse strict;\nuse warnings;\nuse Exporter;\n\nBEGIN {\n    our @ISA = qw( Exporter );\n    our @EXPORT = qw( get_intervals_from_hsps \n                      interval_tiling \n                      decompose_interval\n                      _allowable_filters \n                      _set_attributes\n                      _mapping_coeff);\n}\n\n# tiling trials\n# assumed: intervals are [$a0, $a1], with $a0 <= $a1\n=head1 NAME\n\nBio::Search::Tiling::MapTileUtils - utilities for manipulating closed intervals for an HSP tiling algorithm\n\n=head1 SYNOPSIS\n\nNot used directly.\n\n=head1 DESCRIPTION\n\nNot used directly.\n\n=head1 NOTE\n\nAn \"interval\" in this module is defined as an arrayref C<[$a0, $a1]>, where\nC<$a0, $a1> are scalar numbers satisfying C<$a0 E<lt>= $a1>.\n\n=head1 AUTHOR\n\nMark A. Jensen - maj -at- fortinbras -dot- us\n\n=head1 APPENDIX\n\n=head2 interval_tiling    \n\n Title   : interval_tiling()\n Usage   : @tiling = interval_tiling( \\@array_of_intervals )\n Function: Find minimal set of intervals covering the input set\n Returns : array of arrayrefs of the form\n  ( [$interval => [ @indices_of_collapsed_input_intervals ]], ...)\n Args    : arrayref of intervals\n\n\nsub interval_tiling {\n    return unless $_[0]; # no input\n    my $n = scalar @{$_[0]};\n    my %input;\n    @input{(0..$n-1)} = @{$_[0]};\n    my @active = (0..$n-1);\n    my @hold;\n    my @tiled_ints;\n    my @ret;\n    while (@active) {\n\tmy $tgt = $input{my $tgt_i = shift @active};\n\tpush @tiled_ints, $tgt_i;\n\tmy $tgt_not_disjoint = 1;\n\twhile ($tgt_not_disjoint) {\n\t    $tgt_not_disjoint = 0;\n\t    while (my $try_i = shift @active) {\n\t\tmy $try = $input{$try_i};\n\t\tif ( !are_disjoint($tgt, $try) ) {\n\t\t    $tgt = min_covering_interval($tgt,$try);\n\t\t    push @tiled_ints, $try_i;\n\t\t    $tgt_not_disjoint = 1;\n\t\t}\n\t\telse {\n\t\t    push @hold, $try_i;\n\t\t}\n\t    }\n\t    if (!$tgt_not_disjoint) {\n\t\tpush @ret, [ $tgt => [@tiled_ints] ];\n\t\t@tiled_ints = ();\n\t    }\n\t    @active = @hold;\n\t    @hold = ();\n\t}\n    }\n    return @ret;\n}\n\n=head2 decompose_interval\n\n Title   : decompose_interval\n Usage   : @decomposition = decompose_interval( \\@overlappers )\n Function: Calculate the disjoint decomposition of a set of\n           overlapping intervals, each annotated with a list of\n           covering intervals\n Returns : array of arrayrefs of the form\n           ( [[@interval] => [@indices_of_coverers]], ... )\n Args    : arrayref of intervals (arrayrefs like [$a0, $a1], with\n Note    : Each returned interval is associated with a list of indices of the\n           original intervals that cover that decomposition component\n           (scalar size of this list could be called the 'coverage coefficient')\n Note    : Coverage: each component of the decomp is completely contained\n           in the input intervals that overlap it, by construction.\n Caveat  : This routine expects the members of @overlappers to overlap,\n           but doesn't check this.\n\n\n### what if the input intervals don't overlap?? They MUST overlap; that's\n### what interval_tiling() is for.\n\nsub decompose_interval {\n    return unless $_[0]; # no input\n    my @ints = @{$_[0]};\n    my (%flat,@flat);\n    ### this is ok, but need to handle the case where a lh and rh endpoint\n    ### coincide...\n    # decomposition --\n    # flatten:\n    # every lh endpoint generates (lh-1, lh)\n    # every rh endpoint generates (rh, rh+)\n    foreach (@ints) {\n\t$flat{$$_[0]-1}++;\n\t$flat{$$_[0]}++;\n\t$flat{$$_[1]}++;\n\t$flat{$$_[1]+1}++;\n    }\n    # sort, create singletons if nec.\n    my @a;\n    @a = sort {$a<=>$b} keys %flat;\n    # throw out first and last (meeting a boundary condition)\n    shift @a; pop @a;\n    # look for singletons\n    @flat = (shift @a, shift @a);\n    if ( $flat[1]-$flat[0] == 1 ) {\n\t@flat = ($flat[0],$flat[0], $flat[1]);\n    }\n    while (my $a = shift @a) {\n\tif ($a-$flat[-2]==2) {\n\t    push @flat, $flat[-1]; # create singleton interval\n\t}\n\tpush @flat, $a;\n    }\n    if ($flat[-1]-$flat[-2]==1 and @flat % 2) {\n\tpush @flat, $flat[-1];\n    }\n    # component intervals are consecutive pairs\n    my @decomp;\n    while (my $a = shift @flat) {\n\tpush @decomp, [$a, shift @flat];\n    }\n\n    # for each component, return a list of the indices of the input intervals\n    # that cover the component.\n    my @coverage;\n    foreach my $i (0..$#decomp) {\n\tforeach my $j (0..$#ints) {\n\t    unless (are_disjoint($decomp[$i], $ints[$j])) {\n\t\tif (defined $coverage[$i]) {\n\t\t    push @{$coverage[$i]}, $j;\n\t\t}\n\t\telse {\n\t\t    $coverage[$i] = [$j];\n\t\t}\n\t    }\n\t}\n    }\n    return map { [$decomp[$_] => $coverage[$_]] } (0..$#decomp);\n}    \n\n=head2 are_disjoint\n\n Title   : are_disjoint\n Usage   : are_disjoint( [$a0, $a1], [$b0, $b1] )\n Function: Determine if two intervals are disjoint\n Returns : True if the intervals are disjoint, false if they overlap\n Args    : array of two intervals","label":"are_disjoint($int1,$int2)"},"kind":12,"line":181,"children":[{"line":182,"kind":13,"localvar":"my","containerName":"are_disjoint","name":"$int1","definition":"my"},{"containerName":"are_disjoint","name":"$int2","kind":13,"line":182}],"name":"are_disjoint","range":{"start":{"character":0,"line":181},"end":{"line":185,"character":9999}}},{"name":"int1","kind":12,"line":183},{"name":"int2","kind":12,"line":183},{"name":"int2","kind":12,"line":183},{"kind":12,"line":183,"name":"int1"},{"containerName":"main::","definition":"sub","detail":"($int1,$int2)","signature":{"documentation":"1;\n#$Id: MapTileUtils.pm 16123 2009-09-17 12:57:27Z cjfields $\npackage Bio::Search::Tiling::MapTileUtils;\nuse strict;\nuse warnings;\nuse Exporter;\n\nBEGIN {\n    our @ISA = qw( Exporter );\n    our @EXPORT = qw( get_intervals_from_hsps \n                      interval_tiling \n                      decompose_interval\n                      _allowable_filters \n                      _set_attributes\n                      _mapping_coeff);\n}\n\n# tiling trials\n# assumed: intervals are [$a0, $a1], with $a0 <= $a1\n=head1 NAME\n\nBio::Search::Tiling::MapTileUtils - utilities for manipulating closed intervals for an HSP tiling algorithm\n\n=head1 SYNOPSIS\n\nNot used directly.\n\n=head1 DESCRIPTION\n\nNot used directly.\n\n=head1 NOTE\n\nAn \"interval\" in this module is defined as an arrayref C<[$a0, $a1]>, where\nC<$a0, $a1> are scalar numbers satisfying C<$a0 E<lt>= $a1>.\n\n=head1 AUTHOR\n\nMark A. Jensen - maj -at- fortinbras -dot- us\n\n=head1 APPENDIX\n\n=head2 interval_tiling    \n\n Title   : interval_tiling()\n Usage   : @tiling = interval_tiling( \\@array_of_intervals )\n Function: Find minimal set of intervals covering the input set\n Returns : array of arrayrefs of the form\n  ( [$interval => [ @indices_of_collapsed_input_intervals ]], ...)\n Args    : arrayref of intervals\n\n\nsub interval_tiling {\n    return unless $_[0]; # no input\n    my $n = scalar @{$_[0]};\n    my %input;\n    @input{(0..$n-1)} = @{$_[0]};\n    my @active = (0..$n-1);\n    my @hold;\n    my @tiled_ints;\n    my @ret;\n    while (@active) {\n\tmy $tgt = $input{my $tgt_i = shift @active};\n\tpush @tiled_ints, $tgt_i;\n\tmy $tgt_not_disjoint = 1;\n\twhile ($tgt_not_disjoint) {\n\t    $tgt_not_disjoint = 0;\n\t    while (my $try_i = shift @active) {\n\t\tmy $try = $input{$try_i};\n\t\tif ( !are_disjoint($tgt, $try) ) {\n\t\t    $tgt = min_covering_interval($tgt,$try);\n\t\t    push @tiled_ints, $try_i;\n\t\t    $tgt_not_disjoint = 1;\n\t\t}\n\t\telse {\n\t\t    push @hold, $try_i;\n\t\t}\n\t    }\n\t    if (!$tgt_not_disjoint) {\n\t\tpush @ret, [ $tgt => [@tiled_ints] ];\n\t\t@tiled_ints = ();\n\t    }\n\t    @active = @hold;\n\t    @hold = ();\n\t}\n    }\n    return @ret;\n}\n\n=head2 decompose_interval\n\n Title   : decompose_interval\n Usage   : @decomposition = decompose_interval( \\@overlappers )\n Function: Calculate the disjoint decomposition of a set of\n           overlapping intervals, each annotated with a list of\n           covering intervals\n Returns : array of arrayrefs of the form\n           ( [[@interval] => [@indices_of_coverers]], ... )\n Args    : arrayref of intervals (arrayrefs like [$a0, $a1], with\n Note    : Each returned interval is associated with a list of indices of the\n           original intervals that cover that decomposition component\n           (scalar size of this list could be called the 'coverage coefficient')\n Note    : Coverage: each component of the decomp is completely contained\n           in the input intervals that overlap it, by construction.\n Caveat  : This routine expects the members of @overlappers to overlap,\n           but doesn't check this.\n\n\n### what if the input intervals don't overlap?? They MUST overlap; that's\n### what interval_tiling() is for.\n\nsub decompose_interval {\n    return unless $_[0]; # no input\n    my @ints = @{$_[0]};\n    my (%flat,@flat);\n    ### this is ok, but need to handle the case where a lh and rh endpoint\n    ### coincide...\n    # decomposition --\n    # flatten:\n    # every lh endpoint generates (lh-1, lh)\n    # every rh endpoint generates (rh, rh+)\n    foreach (@ints) {\n\t$flat{$$_[0]-1}++;\n\t$flat{$$_[0]}++;\n\t$flat{$$_[1]}++;\n\t$flat{$$_[1]+1}++;\n    }\n    # sort, create singletons if nec.\n    my @a;\n    @a = sort {$a<=>$b} keys %flat;\n    # throw out first and last (meeting a boundary condition)\n    shift @a; pop @a;\n    # look for singletons\n    @flat = (shift @a, shift @a);\n    if ( $flat[1]-$flat[0] == 1 ) {\n\t@flat = ($flat[0],$flat[0], $flat[1]);\n    }\n    while (my $a = shift @a) {\n\tif ($a-$flat[-2]==2) {\n\t    push @flat, $flat[-1]; # create singleton interval\n\t}\n\tpush @flat, $a;\n    }\n    if ($flat[-1]-$flat[-2]==1 and @flat % 2) {\n\tpush @flat, $flat[-1];\n    }\n    # component intervals are consecutive pairs\n    my @decomp;\n    while (my $a = shift @flat) {\n\tpush @decomp, [$a, shift @flat];\n    }\n\n    # for each component, return a list of the indices of the input intervals\n    # that cover the component.\n    my @coverage;\n    foreach my $i (0..$#decomp) {\n\tforeach my $j (0..$#ints) {\n\t    unless (are_disjoint($decomp[$i], $ints[$j])) {\n\t\tif (defined $coverage[$i]) {\n\t\t    push @{$coverage[$i]}, $j;\n\t\t}\n\t\telse {\n\t\t    $coverage[$i] = [$j];\n\t\t}\n\t    }\n\t}\n    }\n    return map { [$decomp[$_] => $coverage[$_]] } (0..$#decomp);\n}    \n\n=head2 are_disjoint\n\n Title   : are_disjoint\n Usage   : are_disjoint( [$a0, $a1], [$b0, $b1] )\n Function: Determine if two intervals are disjoint\n Returns : True if the intervals are disjoint, false if they overlap\n Args    : array of two intervals\n\n\nsub are_disjoint {\n    my ($int1, $int2) = @_;\n    return 1 if ( $$int1[1] < $$int2[0] ) || ( $$int2[1] < $$int1[0]);\n    return 0;\n}\n\n=head2 min_covering_interval\n\n Title   : min_covering_interval \n Usage   : $interval = min_covering_interval( [$a0,$a1],[$b0,$b1] )\n Function: Determine the minimal covering interval for two intervals\n Returns : an interval\n Args    : two intervals","parameters":[{"label":"$int1"},{"label":"$int2"}],"label":"min_covering_interval($int1,$int2)"},"kind":12,"line":197,"children":[{"line":198,"kind":13,"localvar":"my","definition":"my","name":"$int1","containerName":"min_covering_interval"},{"containerName":"min_covering_interval","name":"$int2","line":198,"kind":13},{"line":199,"kind":13,"localvar":"my","containerName":"min_covering_interval","definition":"my","name":"@a"},{"line":199,"kind":13,"name":"$a","containerName":"min_covering_interval"},{"kind":13,"line":199,"containerName":"min_covering_interval","name":"$b"},{"containerName":"min_covering_interval","name":"$int1","line":199,"kind":13},{"name":"$int2","containerName":"min_covering_interval","kind":13,"line":199},{"name":"$a","containerName":"min_covering_interval","kind":13,"line":200},{"containerName":"min_covering_interval","name":"$a","kind":13,"line":200}],"name":"min_covering_interval","range":{"end":{"character":9999,"line":201},"start":{"character":0,"line":197}}},{"line":215,"children":[{"containerName":"get_intervals_from_hsps","name":"$type","definition":"my","localvar":"my","kind":13,"line":216},{"line":217,"kind":13,"localvar":"my","definition":"my","name":"@hsps","containerName":"get_intervals_from_hsps"},{"line":218,"kind":13,"containerName":"get_intervals_from_hsps","name":"$type"},{"name":"@hsps","containerName":"get_intervals_from_hsps","line":219,"kind":13},{"line":219,"kind":13,"name":"$type","containerName":"get_intervals_from_hsps"},{"kind":13,"line":220,"containerName":"get_intervals_from_hsps","name":"$type"},{"containerName":"get_intervals_from_hsps","name":"$type","kind":13,"line":225},{"kind":13,"line":225,"containerName":"get_intervals_from_hsps","name":"$type"},{"kind":13,"line":226,"containerName":"get_intervals_from_hsps","name":"@hsps"},{"line":227,"kind":13,"localvar":"my","definition":"my","name":"@ret","containerName":"get_intervals_from_hsps"},{"kind":13,"line":228,"name":"@hsps","containerName":"get_intervals_from_hsps"},{"kind":13,"line":230,"containerName":"get_intervals_from_hsps","name":"@ret"},{"line":230,"kind":12,"containerName":"get_intervals_from_hsps","name":"range"},{"containerName":"get_intervals_from_hsps","name":"$type","line":230,"kind":13},{"name":"@ret","containerName":"get_intervals_from_hsps","kind":13,"line":232}],"kind":12,"range":{"start":{"line":215,"character":0},"end":{"line":233,"character":9999}},"containerName":"main::","definition":"sub","name":"get_intervals_from_hsps"},{"localvar":"my","definition":"my","name":"%alg_lookup","containerName":null,"line":240,"kind":13},{"children":[{"kind":13,"line":292,"name":"$hit","definition":"my","containerName":"_allowable_filters","localvar":"my"},{"containerName":"_allowable_filters","definition":"my","name":"$type","localvar":"my","kind":13,"line":293},{"containerName":"_allowable_filters","name":"$type","kind":13,"line":294},{"name":"$type","containerName":"_allowable_filters","kind":13,"line":299},{"name":"$type","containerName":"_allowable_filters","kind":13,"line":299},{"kind":13,"line":300,"name":"$alg","definition":"my","containerName":"_allowable_filters","localvar":"my"},{"containerName":"_allowable_filters","name":"$hit","line":300,"kind":13},{"line":300,"kind":12,"containerName":"_allowable_filters","name":"algorithm"},{"name":"$alg","containerName":"_allowable_filters","line":303,"kind":13},{"name":"$alg","containerName":"_allowable_filters","line":303,"kind":13},{"kind":13,"line":303,"name":"$alg","containerName":"_allowable_filters"},{"line":305,"kind":13,"containerName":"_allowable_filters","name":"$hit"},{"kind":12,"line":305,"name":"algorithm","containerName":"_allowable_filters"},{"containerName":"_allowable_filters","name":"$type","line":310,"kind":13},{"kind":13,"line":313,"name":"$type","containerName":"_allowable_filters"}],"line":291,"kind":12,"range":{"start":{"character":0,"line":291},"end":{"line":320,"character":9999}},"definition":"sub","name":"_allowable_filters","containerName":"main::"},{"name":"alg_lookup","line":310,"kind":12},{"name":"alg_lookup","kind":12,"line":313},{"kind":12,"line":336,"children":[{"containerName":"_set_attributes","name":"$self","definition":"my","localvar":"my","kind":13,"line":337},{"line":338,"kind":13,"localvar":"my","containerName":"_set_attributes","definition":"my","name":"$alg"},{"containerName":"_set_attributes","name":"$self","line":338,"kind":13},{"line":338,"kind":12,"containerName":"_set_attributes","name":"hit"},{"kind":12,"line":338,"containerName":"_set_attributes","name":"algorithm"},{"containerName":"_set_attributes","name":"$alg","line":341,"kind":13},{"containerName":"_set_attributes","name":"$alg","kind":13,"line":341},{"line":341,"kind":13,"name":"$alg","containerName":"_set_attributes"},{"line":343,"kind":13,"containerName":"_set_attributes","name":"$alg"},{"name":"$self","containerName":"_set_attributes","kind":13,"line":345},{"name":"$self","containerName":"_set_attributes","kind":13,"line":345},{"line":346,"kind":13,"containerName":"_set_attributes","name":"$self"},{"containerName":"_set_attributes","name":"$self","kind":13,"line":346},{"name":"$self","containerName":"_set_attributes","kind":13,"line":348},{"containerName":"_set_attributes","name":"$self","kind":13,"line":348},{"containerName":"_set_attributes","name":"$self","kind":13,"line":350},{"line":350,"kind":13,"name":"$self","containerName":"_set_attributes"},{"name":"$self","containerName":"_set_attributes","line":355,"kind":13},{"kind":13,"line":355,"name":"$self","containerName":"_set_attributes"},{"line":357,"kind":13,"containerName":"_set_attributes","name":"$self"},{"name":"$self","containerName":"_set_attributes","kind":13,"line":357},{"line":359,"kind":13,"name":"$self","containerName":"_set_attributes"},{"containerName":"_set_attributes","name":"$self","line":359,"kind":13}],"containerName":"main::","definition":"sub","name":"_set_attributes","range":{"end":{"character":9999,"line":360},"start":{"line":336,"character":0}}},{"name":"_mapping_query","line":345,"kind":12},{"line":345,"kind":12,"name":"_mapping_hit"},{"line":346,"kind":12,"name":"_def_context_query"},{"line":346,"kind":12,"name":"_def_context_hit"},{"name":"_has_frame_query","line":348,"kind":12},{"line":348,"kind":12,"name":"_has_frame_hit"},{"line":350,"kind":12,"name":"_has_strand_query"},{"name":"_has_strand_hit","line":350,"kind":12},{"name":"_mapping_query","line":355,"kind":12},{"kind":12,"line":355,"name":"_mapping_hit"},{"kind":12,"line":356,"name":"alg_lookup"},{"line":356,"kind":12,"name":"mapping"},{"kind":12,"line":357,"name":"_def_context_query"},{"name":"_def_context_hit","kind":12,"line":357},{"name":"alg_lookup","kind":12,"line":358},{"name":"def_context","kind":12,"line":358},{"line":359,"kind":12,"name":"_has_frame_query"},{"kind":12,"line":359,"name":"_has_frame_hit"},{"name":"alg_lookup","kind":12,"line":360},{"kind":12,"line":360,"name":"has_frame"},{"line":361,"kind":13,"containerName":null,"name":"%self"},{"line":361,"kind":12,"name":"_has_strand_query"},{"kind":13,"line":361,"name":"%self","containerName":null},{"name":"_has_strand_hit","line":361,"kind":12},{"name":"alg_lookup","kind":12,"line":362},{"name":"has_strand","line":362,"kind":12},{"line":366,"kind":13,"name":"%self","containerName":null},{"name":"_mapping_query","line":366,"kind":12},{"line":366,"kind":13,"name":"%self","containerName":null},{"name":"_mapping_hit","kind":12,"line":366},{"kind":12,"line":367,"name":"alg_lookup"},{"kind":12,"line":367,"name":"mapping"},{"containerName":null,"name":"%self","kind":13,"line":368},{"line":368,"kind":12,"name":"_def_context_query"},{"containerName":null,"name":"%self","kind":13,"line":368},{"kind":12,"line":368,"name":"_def_context_hit"},{"name":"alg_lookup","kind":12,"line":369},{"name":"def_context","line":369,"kind":12},{"containerName":null,"name":"%self","kind":13,"line":370},{"line":370,"kind":12,"name":"_has_frame_query"},{"kind":13,"line":370,"containerName":null,"name":"%self"},{"name":"_has_frame_hit","kind":12,"line":370},{"kind":12,"line":371,"name":"alg_lookup"},{"kind":12,"line":371,"name":"has_frame"},{"kind":13,"line":372,"containerName":null,"name":"%self"},{"kind":12,"line":372,"name":"_has_strand_query"},{"kind":13,"line":372,"containerName":null,"name":"%self"},{"name":"_has_strand_hit","line":372,"kind":12},{"kind":12,"line":373,"name":"alg_lookup"},{"line":373,"kind":12,"name":"has_strand"},{"line":377,"kind":13,"containerName":null,"name":"$self"},{"line":377,"kind":12,"name":"warn","containerName":"main::"},{"name":"%self","containerName":null,"line":378,"kind":13},{"name":"_mapping_query","line":378,"kind":12},{"name":"%self","containerName":null,"kind":13,"line":378},{"line":378,"kind":12,"name":"_mapping_hit"},{"line":379,"kind":13,"name":"%self","containerName":null},{"kind":12,"line":379,"name":"_def_context_query"},{"line":379,"kind":13,"name":"%self","containerName":null},{"kind":12,"line":379,"name":"_def_context_hit"},{"containerName":null,"name":"%self","line":381,"kind":13},{"name":"_has_frame_query","kind":12,"line":381},{"kind":13,"line":381,"name":"%self","containerName":null},{"kind":12,"line":381,"name":"_has_frame_hit"},{"name":"%self","containerName":null,"line":383,"kind":13},{"name":"_has_strand_query","kind":12,"line":383},{"line":383,"kind":13,"name":"%self","containerName":null},{"name":"_has_strand_hit","line":383,"kind":12},{"children":[{"localvar":"my","name":"$obj","definition":"my","containerName":"_mapping_coeff","line":393,"kind":13},{"localvar":"my","containerName":"_mapping_coeff","name":"$type","definition":"my","line":394,"kind":13},{"containerName":"_mapping_coeff","name":"%type_i","definition":"my","localvar":"my","kind":13,"line":395},{"line":396,"kind":13,"containerName":"_mapping_coeff","name":"$obj"},{"line":396,"kind":13,"containerName":"_mapping_coeff","name":"$obj"},{"containerName":"_mapping_coeff","name":"can","kind":12,"line":396},{"containerName":"_mapping_coeff","name":"$obj","line":397,"kind":13},{"kind":12,"line":397,"name":"warn","containerName":"_mapping_coeff"},{"name":"$type","containerName":"_mapping_coeff","line":400,"kind":13},{"kind":13,"line":402,"containerName":"_mapping_coeff","name":"$obj"},{"containerName":"_mapping_coeff","name":"warn","kind":12,"line":402},{"line":405,"kind":13,"name":"$type","containerName":"_mapping_coeff"},{"name":"$type","containerName":"_mapping_coeff","line":405,"kind":13},{"kind":13,"line":406,"containerName":"_mapping_coeff","name":"$alg","definition":"my","localvar":"my"},{"kind":13,"line":406,"name":"$obj","containerName":"_mapping_coeff"},{"containerName":"_mapping_coeff","name":"algorithm","line":406,"kind":12},{"containerName":"_mapping_coeff","name":"$alg","line":409,"kind":13},{"kind":13,"line":409,"name":"$alg","containerName":"_mapping_coeff"},{"name":"$alg","containerName":"_mapping_coeff","line":409,"kind":13},{"kind":13,"line":411,"containerName":"_mapping_coeff","name":"$alg"},{"line":416,"kind":13,"containerName":"_mapping_coeff","name":"$type_i"},{"containerName":"_mapping_coeff","name":"$type","kind":13,"line":416},{"containerName":"_mapping_coeff","name":"$type_i","line":419,"kind":13},{"kind":13,"line":419,"name":"$type","containerName":"_mapping_coeff"}],"line":392,"kind":12,"range":{"start":{"character":0,"line":392},"end":{"character":9999,"line":426}},"name":"_mapping_coeff","definition":"sub","containerName":"main::"},{"line":416,"kind":12,"name":"alg_lookup"},{"line":419,"kind":12,"name":"alg_lookup"},{"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n#$Id: MapTileUtils.pm 16123 2009-09-17 12:57:27Z cjfields $\npackage Bio::Search::Tiling::MapTileUtils;\nuse strict;\nuse warnings;\nuse Exporter;\n\nBEGIN {\n    our @ISA = qw( Exporter );\n    our @EXPORT = qw( get_intervals_from_hsps \n                      interval_tiling \n                      decompose_interval\n                      _allowable_filters \n                      _set_attributes\n                      _mapping_coeff);\n}\n\n# tiling trials\n# assumed: intervals are [$a0, $a1], with $a0 <= $a1\n=head1 NAME\n\nBio::Search::Tiling::MapTileUtils - utilities for manipulating closed intervals for an HSP tiling algorithm\n\n=head1 SYNOPSIS\n\nNot used directly.\n\n=head1 DESCRIPTION\n\nNot used directly.\n\n=head1 NOTE\n\nAn \"interval\" in this module is defined as an arrayref C<[$a0, $a1]>, where\nC<$a0, $a1> are scalar numbers satisfying C<$a0 E<lt>= $a1>.\n\n=head1 AUTHOR\n\nMark A. Jensen - maj -at- fortinbras -dot- us\n\n=head1 APPENDIX\n\n=head2 interval_tiling    \n\n Title   : interval_tiling()\n Usage   : @tiling = interval_tiling( \\@array_of_intervals )\n Function: Find minimal set of intervals covering the input set\n Returns : array of arrayrefs of the form\n  ( [$interval => [ @indices_of_collapsed_input_intervals ]], ...)\n Args    : arrayref of intervals\n\n\nsub interval_tiling {\n    return unless $_[0]; # no input\n    my $n = scalar @{$_[0]};\n    my %input;\n    @input{(0..$n-1)} = @{$_[0]};\n    my @active = (0..$n-1);\n    my @hold;\n    my @tiled_ints;\n    my @ret;\n    while (@active) {\n\tmy $tgt = $input{my $tgt_i = shift @active};\n\tpush @tiled_ints, $tgt_i;\n\tmy $tgt_not_disjoint = 1;\n\twhile ($tgt_not_disjoint) {\n\t    $tgt_not_disjoint = 0;\n\t    while (my $try_i = shift @active) {\n\t\tmy $try = $input{$try_i};\n\t\tif ( !are_disjoint($tgt, $try) ) {\n\t\t    $tgt = min_covering_interval($tgt,$try);\n\t\t    push @tiled_ints, $try_i;\n\t\t    $tgt_not_disjoint = 1;\n\t\t}\n\t\telse {\n\t\t    push @hold, $try_i;\n\t\t}\n\t    }\n\t    if (!$tgt_not_disjoint) {\n\t\tpush @ret, [ $tgt => [@tiled_ints] ];\n\t\t@tiled_ints = ();\n\t    }\n\t    @active = @hold;\n\t    @hold = ();\n\t}\n    }\n    return @ret;\n}\n\n=head2 decompose_interval\n\n Title   : decompose_interval\n Usage   : @decomposition = decompose_interval( \\@overlappers )\n Function: Calculate the disjoint decomposition of a set of\n           overlapping intervals, each annotated with a list of\n           covering intervals\n Returns : array of arrayrefs of the form\n           ( [[@interval] => [@indices_of_coverers]], ... )\n Args    : arrayref of intervals (arrayrefs like [$a0, $a1], with\n Note    : Each returned interval is associated with a list of indices of the\n           original intervals that cover that decomposition component\n           (scalar size of this list could be called the 'coverage coefficient')\n Note    : Coverage: each component of the decomp is completely contained\n           in the input intervals that overlap it, by construction.\n Caveat  : This routine expects the members of @overlappers to overlap,\n           but doesn't check this.\n\n\n### what if the input intervals don't overlap?? They MUST overlap; that's\n### what interval_tiling() is for.\n\nsub decompose_interval {\n    return unless $_[0]; # no input\n    my @ints = @{$_[0]};\n    my (%flat,@flat);\n    ### this is ok, but need to handle the case where a lh and rh endpoint\n    ### coincide...\n    # decomposition --\n    # flatten:\n    # every lh endpoint generates (lh-1, lh)\n    # every rh endpoint generates (rh, rh+)\n    foreach (@ints) {\n\t$flat{$$_[0]-1}++;\n\t$flat{$$_[0]}++;\n\t$flat{$$_[1]}++;\n\t$flat{$$_[1]+1}++;\n    }\n    # sort, create singletons if nec.\n    my @a;\n    @a = sort {$a<=>$b} keys %flat;\n    # throw out first and last (meeting a boundary condition)\n    shift @a; pop @a;\n    # look for singletons\n    @flat = (shift @a, shift @a);\n    if ( $flat[1]-$flat[0] == 1 ) {\n\t@flat = ($flat[0],$flat[0], $flat[1]);\n    }\n    while (my $a = shift @a) {\n\tif ($a-$flat[-2]==2) {\n\t    push @flat, $flat[-1]; # create singleton interval\n\t}\n\tpush @flat, $a;\n    }\n    if ($flat[-1]-$flat[-2]==1 and @flat % 2) {\n\tpush @flat, $flat[-1];\n    }\n    # component intervals are consecutive pairs\n    my @decomp;\n    while (my $a = shift @flat) {\n\tpush @decomp, [$a, shift @flat];\n    }\n\n    # for each component, return a list of the indices of the input intervals\n    # that cover the component.\n    my @coverage;\n    foreach my $i (0..$#decomp) {\n\tforeach my $j (0..$#ints) {\n\t    unless (are_disjoint($decomp[$i], $ints[$j])) {\n\t\tif (defined $coverage[$i]) {\n\t\t    push @{$coverage[$i]}, $j;\n\t\t}\n\t\telse {\n\t\t    $coverage[$i] = [$j];\n\t\t}\n\t    }\n\t}\n    }\n    return map { [$decomp[$_] => $coverage[$_]] } (0..$#decomp);\n}    \n\n=head2 are_disjoint\n\n Title   : are_disjoint\n Usage   : are_disjoint( [$a0, $a1], [$b0, $b1] )\n Function: Determine if two intervals are disjoint\n Returns : True if the intervals are disjoint, false if they overlap\n Args    : array of two intervals\n\n\nsub are_disjoint {\n    my ($int1, $int2) = @_;\n    return 1 if ( $$int1[1] < $$int2[0] ) || ( $$int2[1] < $$int1[0]);\n    return 0;\n}\n\n=head2 min_covering_interval\n\n Title   : min_covering_interval \n Usage   : $interval = min_covering_interval( [$a0,$a1],[$b0,$b1] )\n Function: Determine the minimal covering interval for two intervals\n Returns : an interval\n Args    : two intervals\n\n\nsub min_covering_interval {\n    my ($int1, $int2) = @_;\n    my @a = sort {$a <=> $b} (@$int1, @$int2);\n    return [$a[0],$a[-1]];\n}\n\n=head2 get_intervals_from_hsps\n\n Title   : get_intervals_from_hsps\n Usage   : @intervals = get_intervals_from_hsps($type, @hsp_objects)\n Function: Return array of intervals of the form [ $start, $end ],\n           from an array of hsp objects\n Returns : an array of intervals\n Args    : scalar $type, array of HSPI objects; where $type is one of 'hit',\n           'subject', 'query'\n\n\nsub get_intervals_from_hsps {\n    my $type = shift;\n    my @hsps;\n    if (ref($type) =~ /HSP/) {\n\tpush @hsps, $type;\n\t$type = 'query';\n    }\n    elsif ( !grep /^$type$/,qw( hit subject query ) ) {\n\tdie \"Unknown HSP type '$type'\";\n    }\n    $type = 'hit' if $type eq 'subject';\n    push @hsps, @_;\n    my @ret;\n    foreach (@hsps) {\n#\tpush @ret, [ $_->start($type), $_->end($type)];\n\tpush @ret, [ $_->range($type) ];\n    }\n    return @ret;\n}\n\n# fast, clear, nasty, brutish and short.\n# for _allowable_filters(), _set_mapping()\n# covers BLAST, FAST families\n# FASTA is ambiguous (nt or aa) based on alg name only\n\nmy $alg_lookup = {\n    'N'  => { 'mapping' => [1,1],\n              'def_context' => ['p_','p_'],\n\t      'has_strand' => [1, 1],\n              'has_frame' => [0, 0]},\n    'P'  => { 'mapping' => [1,1],\n              'def_context' => ['all','all'],\n\t      'has_strand' => [0, 0],\n\t      'has_frame' => [0, 0]},\n    'X'  => { 'mapping' => [3, 1],\n              'def_context' => [undef,'all'],\n\t      'has_strand' => [1, 0],\n\t      'has_frame' => [1, 0]}, \n    'Y'  => { 'mapping' => [3, 1],\n              'def_context' => [undef,'all'],\n\t      'has_strand' => [1, 0],\n\t      'has_frame' => [1, 0]}, \n    'TA' => { 'mapping' => [1, 3],\n              'def_context' => ['all',undef],\n\t      'has_strand' => [0, 1],\n\t      'has_frame' => [0, 1]}, \n    'TN' => { 'mapping' => [1, 3],\n              'def_context' => ['p_',undef],\n\t      'has_strand' => [1,1],\n\t      'has_frame' => [0, 1]}, \n    'TX' => { 'mapping' => [3, 3],\n              'def_context' => [undef,undef],\n\t      'has_strand' => [1, 1],\n\t      'has_frame' => [1, 1]}, \n    'TY' => { 'mapping' => [3, 3],\n              'def_context' => [undef,undef],\n\t      'has_strand' => [1, 1],\n\t      'has_frame' => [1, 1]}\n};\n   \n=head2 _allowable_filters\n    \n Title   : _allowable_filters\n Usage   : _allowable_filters($Bio_Search_Hit_HitI, $type)\n Function: Return the HSP filters (strand, frame) allowed, \n           based on the reported algorithm\n Returns : String encoding allowable filters: \n           s = strand, f = frame\n           Empty string if no filters allowed\n           undef if algorithm unrecognized\n Args    : A Bio::Search::Hit::HitI object,\n           scalar $type, one of 'hit', 'subject', 'query';\n           default is 'query'\n\n\nsub _allowable_filters {\n    my $hit = shift;\n    my $type = shift;\n    $type ||= 'q';\n    unless (grep /^$type$/, qw( h q s ) ) {\n\twarn(\"Unknown type '$type'; returning ''\");\n\treturn '';\n    }\n    $type = 'h' if $type eq 's';\n    my $alg = $hit->algorithm;\n\n    # pretreat (i.e., kludge it)\n    $alg =~ /^RPS/ and ($alg) = ($alg =~ /\\(([^)]+)\\)/);\n\n    for ($hit->algorithm) {\n\t/MEGABLAST/i && do {\n\t    return qr/[s]/;\n\t};\n\t/(.?)BLAST(.?)/i && do {\n\t    return $$alg_lookup{$1.$2}{$type};\n\t};\n\t/(.?)FAST(.?)/ && do {\n\t    return $$alg_lookup{$1.$2}{$type};\n\t};\n\tdo { # unrecognized\n\t    last;\n\t};\n    }\n    return;\n}\n\n\n=head2 _set_attributes\n\n Title   : _set_attributes\n Usage   : $tiling->_set_attributes()\n Function: Sets attributes for invocant\n           that depend on algorithm name\n Returns : True on success\n Args    : none\n Note    : setting based on the configuration table\n           %alg_lookup\n\n\nsub _set_attributes {\n    my $self = shift;\n    my $alg = $self->hit->algorithm;\n\n    # pretreat (i.e., kludge it)\n    $alg =~ /^RPS/ and ($alg) = ($alg =~ /\\(([^)]+)\\)/);\n    \n    for ($alg) {\n\t/MEGABLAST/i && do {\n\t    ($self->{_mapping_query},$self->{_mapping_hit}) = (1,1);\n\t    ($self->{_def_context_query},$self->{_def_context_hit}) =\n\t\t('p_','p_');\n\t    ($self->{_has_frame_query},$self->{_has_frame_hit}) =\n\t\t(0, 0);\n\t    ($self->{_has_strand_query},$self->{_has_strand_hit}) =\n\t\t(1, 1);\n\t    last;\n\t};\n\t/(.?)BLAST(.?)/i && do {\n\t    ($self->{_mapping_query},$self->{_mapping_hit}) = \n\t\t@{$$alg_lookup{$1.$2}{mapping}};\n\t    ($self->{_def_context_query},$self->{_def_context_hit}) =\n\t\t@{$$alg_lookup{$1.$2}{def_context}};\n\t    ($self->{_has_frame_query},$self->{_has_frame_hit}) =\t    \n\t\t@{$$alg_lookup{$1.$2}{has_frame}};\n\t    ($self->{_has_strand_query},$self->{_has_strand_hit}) =\t    \n\t\t@{$$alg_lookup{$1.$2}{has_strand}};\n\t    last;\n\t};\n\t/(.?)FAST(.?)/ && do {\n\t    ($self->{_mapping_query},$self->{_mapping_hit}) = \n\t\t@{$$alg_lookup{$1.$2}{mapping}};\n\t    ($self->{_def_context_query},$self->{_def_context_hit}) =\n\t\t@{$$alg_lookup{$1.$2}{def_context}};\n\t    ($self->{_has_frame_query},$self->{_has_frame_hit}) =\t    \n\t\t@{$$alg_lookup{$1.$2}{has_frame}};\n\t    ($self->{_has_strand_query},$self->{_has_strand_hit}) =\t    \n\t\t@{$$alg_lookup{$1.$2}{has_strand}};\n\t    last;\n\t};\n\tdo { # unrecognized\n\t    $self->warn(\"Unrecognized algorithm '$alg'; defaults may not work\");\n\t    ($self->{_mapping_query},$self->{_mapping_hit}) = (1,1);\n\t    ($self->{_def_context_query},$self->{_def_context_hit}) =\n\t\t('all','all');\n\t    ($self->{_has_frame_query},$self->{_has_frame_hit}) =\t    \n\t\t(0,0);\n\t    ($self->{_has_strand_query},$self->{_has_strand_hit}) =\t    \n\t\t(0,0);\n\t    return 0;\n\t    last;\n\t};\n    }\n    return 1;\n}\n           \nsub _mapping_coeff {\n    my $obj = shift;\n    my $type = shift;\n    my %type_i = ( 'query' => 0, 'hit' => 1 );\n    unless ( ref($obj) && $obj->can('algorithm') ) {\n\t$obj->warn(\"Object type unrecognized\");\n\treturn undef;\n    }\n    $type ||= 'query';\n    unless ( grep(/^$type$/, qw( query hit subject ) ) ) {\n\t$obj->warn(\"Sequence type unrecognized\");\n\treturn undef;\n    }\n    $type = 'hit' if $type eq 'subject';\n    my $alg = $obj->algorithm;\n\n    # pretreat (i.e., kludge it)\n    $alg =~ /^RPS/ and ($alg) = ($alg =~ /\\(([^)]+)\\)/);\n    \n    for ($alg) {\n\t/MEGABLAST/i && do {\n\t    return 1;\n\t};\n\t/(.?)BLAST(.?)/i && do {\n\t    return $$alg_lookup{$1.$2}{'mapping'}[$type_i{$type}];\n\t};\n\t/(.?)FAST(.?)/ && do {\n\t    return $$alg_lookup{$1.$2}{'mapping'}[$type_i{$type}];\n\t};\n\tdo { # unrecognized\n\t    last;\n\t};\n    }\n    return;\n}\n\n1;\n# need our own subsequencer for hsps. \n\npackage Bio::Search::HSP::HSPI;\n\nuse strict;\nuse warnings;\n\n=head2 matches_MT\n\n Title   : matches_MT\n Usage   : $hsp->matches($type, $action, $start, $end)\n Purpose   : Get the total number of identical or conserved matches \n             in the query or sbjct sequence for the given HSP. Optionally can\n             report data within a defined interval along the seq.\n Returns   : scalar int \n Args      : \n Comments  : Relies on seq_str('match') to get the string of alignment symbols\n             between the query and sbjct lines which are used for determining\n             the number of identical and conservative matches.\n Note      : Modeled on Bio::Search::HSP::HSPI::matches","parameters":[{"label":"$self"},{"label":"@args"}],"label":"matches_MT($self,@args)"},"detail":"($self,@args)","kind":12,"children":[{"line":453,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"matches_MT"},{"kind":13,"line":453,"containerName":"matches_MT","name":"@args"},{"localvar":"my","definition":"my","name":"$type","containerName":"matches_MT","line":454,"kind":13},{"line":454,"kind":13,"name":"$action","containerName":"matches_MT"},{"name":"$beg","containerName":"matches_MT","line":454,"kind":13},{"name":"$end","containerName":"matches_MT","kind":13,"line":454},{"line":454,"kind":13,"name":"$self","containerName":"matches_MT"},{"line":454,"kind":12,"containerName":"matches_MT","name":"_rearrange"},{"kind":13,"line":454,"containerName":"matches_MT","name":"@args"},{"line":455,"kind":13,"localvar":"my","containerName":"matches_MT","name":"@actions","definition":"my"},{"containerName":"matches_MT","name":"$self","kind":13,"line":458},{"kind":12,"line":458,"name":"throw","containerName":"matches_MT"},{"kind":13,"line":458,"name":"$type","containerName":"matches_MT"},{"containerName":"matches_MT","name":"$self","line":459,"kind":13},{"kind":12,"line":459,"containerName":"matches_MT","name":"throw"},{"kind":13,"line":460,"name":"$type","containerName":"matches_MT"},{"kind":13,"line":460,"name":"$type","containerName":"matches_MT"},{"line":463,"kind":13,"containerName":"matches_MT","name":"$self"},{"name":"throw","containerName":"matches_MT","kind":12,"line":463},{"line":463,"kind":13,"containerName":"matches_MT","name":"$action"},{"name":"$self","containerName":"matches_MT","line":464,"kind":13},{"kind":12,"line":464,"name":"throw","containerName":"matches_MT"},{"line":464,"kind":13,"name":"@actions","containerName":"matches_MT"},{"containerName":"matches_MT","definition":"my","name":"$len_id","localvar":"my","kind":13,"line":466},{"line":466,"kind":13,"containerName":"matches_MT","name":"$len_cons"},{"containerName":"matches_MT","definition":"my","name":"$c","localvar":"my","kind":13,"line":467},{"kind":13,"line":467,"name":"$self","containerName":"matches_MT"},{"name":"$type","containerName":"matches_MT","line":467,"kind":13},{"line":468,"kind":13,"containerName":"matches_MT","name":"$beg"},{"containerName":"matches_MT","name":"$end","kind":13,"line":468},{"name":"$beg","containerName":"matches_MT","line":468,"kind":13},{"name":"$end","containerName":"matches_MT","kind":13,"line":468},{"kind":13,"line":469,"name":"$self","containerName":"matches_MT"},{"name":"throw","containerName":"matches_MT","kind":12,"line":469},{"kind":13,"line":471,"name":"$beg","containerName":"matches_MT"},{"kind":13,"line":471,"name":"$end","containerName":"matches_MT"},{"containerName":"matches_MT","name":"$self","line":471,"kind":13},{"containerName":"matches_MT","name":"seq_str","line":471,"kind":12},{"kind":13,"line":474,"containerName":"matches_MT","name":"$self"},{"kind":12,"line":474,"name":"debug","containerName":"matches_MT"},{"line":474,"kind":13,"name":"$self","containerName":"matches_MT"},{"containerName":"matches_MT","name":"seq_str","kind":12,"line":474},{"line":475,"kind":13,"containerName":"matches_MT","name":"$len_id"},{"name":"$len_cons","containerName":"matches_MT","kind":13,"line":475},{"kind":13,"line":475,"containerName":"matches_MT","name":"$c"},{"containerName":"matches_MT","name":"$self","kind":13,"line":475},{"kind":12,"line":475,"containerName":"matches_MT","name":"num_identical"},{"containerName":"matches_MT","name":"$self","kind":13,"line":475},{"name":"num_conserved","containerName":"matches_MT","line":475,"kind":12},{"containerName":"matches_MT","name":"$action","line":476,"kind":13},{"name":"$len_id","containerName":"matches_MT","line":478,"kind":13},{"kind":13,"line":481,"containerName":"matches_MT","name":"$len_cons"},{"kind":13,"line":484,"name":"$len_id","containerName":"matches_MT"},{"line":484,"kind":13,"name":"$len_cons","containerName":"matches_MT"},{"line":487,"kind":13,"containerName":"matches_MT","name":"$self"},{"containerName":"matches_MT","name":"throw","kind":12,"line":487},{"line":493,"kind":13,"localvar":"my","name":"$start","definition":"my","containerName":"matches_MT"},{"line":493,"kind":13,"name":"$stop","containerName":"matches_MT"},{"kind":13,"line":493,"containerName":"matches_MT","name":"$self"},{"name":"range","containerName":"matches_MT","kind":12,"line":493},{"kind":13,"line":493,"containerName":"matches_MT","name":"$type"},{"line":494,"kind":13,"name":"$beg","containerName":"matches_MT"},{"name":"$start","containerName":"matches_MT","line":494,"kind":13},{"name":"$stop","containerName":"matches_MT","line":494,"kind":13},{"line":494,"kind":13,"containerName":"matches_MT","name":"$end"},{"kind":13,"line":495,"name":"$self","containerName":"matches_MT"},{"line":495,"kind":12,"name":"throw","containerName":"matches_MT"},{"line":499,"kind":13,"localvar":"my","name":"$match_str","definition":"my","containerName":"matches_MT"},{"line":499,"kind":13,"containerName":"matches_MT","name":"$self"},{"name":"seq_str","containerName":"matches_MT","kind":12,"line":499},{"line":500,"kind":13,"name":"$self","containerName":"matches_MT"},{"name":"gaps","containerName":"matches_MT","kind":12,"line":500},{"containerName":"matches_MT","name":"$match_str","line":503,"kind":13},{"line":503,"kind":13,"containerName":"matches_MT","name":"$self"},{"name":"seq_str","containerName":"matches_MT","line":503,"kind":12},{"name":"$tgt","definition":"my","containerName":"matches_MT","localvar":"my","kind":13,"line":504},{"kind":13,"line":504,"containerName":"matches_MT","name":"$self"},{"kind":12,"line":504,"containerName":"matches_MT","name":"seq_str"},{"containerName":"matches_MT","name":"$type","line":504,"kind":13},{"localvar":"my","containerName":"matches_MT","name":"$encode","definition":"my","line":505,"kind":13},{"line":505,"kind":13,"containerName":"matches_MT","name":"$match_str"},{"name":"$tgt","containerName":"matches_MT","line":505,"kind":13},{"localvar":"my","containerName":"matches_MT","name":"$zap","definition":"my","line":506,"kind":13},{"kind":13,"line":507,"containerName":"matches_MT","name":"$encode"},{"line":508,"kind":13,"name":"$tgt","containerName":"matches_MT"},{"containerName":"matches_MT","name":"$match_str","kind":13,"line":509},{"kind":13,"line":509,"name":"$tgt","containerName":"matches_MT"},{"kind":13,"line":509,"name":"$encode","containerName":"matches_MT"},{"kind":13,"line":515,"name":"$seq","definition":"my","containerName":"matches_MT","localvar":"my"},{"kind":13,"line":516,"containerName":"matches_MT","name":"$seq"},{"kind":13,"line":516,"name":"$match_str","containerName":"matches_MT"},{"name":"$beg","containerName":"matches_MT","line":517,"kind":13},{"name":"$start","containerName":"matches_MT","kind":13,"line":517},{"name":"$self","containerName":"matches_MT","kind":13,"line":517},{"containerName":"matches_MT","name":"$type","kind":13,"line":517},{"containerName":"matches_MT","name":"$end","line":518,"kind":13},{"kind":13,"line":518,"name":"$beg","containerName":"matches_MT"},{"containerName":"matches_MT","name":"$self","line":518,"kind":13},{"name":"$type","containerName":"matches_MT","line":518,"kind":13},{"name":"$seq","containerName":"matches_MT","kind":13,"line":521},{"kind":13,"line":522,"name":"$self","containerName":"matches_MT"},{"line":522,"kind":12,"name":"throw","containerName":"matches_MT"},{"containerName":"matches_MT","name":"$seq","kind":13,"line":525},{"containerName":"matches_MT","name":"$len_cons","line":526,"kind":13},{"name":"$seq","containerName":"matches_MT","line":526,"kind":13},{"containerName":"matches_MT","name":"$self","line":526,"kind":13},{"line":526,"kind":13,"name":"$type","containerName":"matches_MT"},{"kind":13,"line":527,"containerName":"matches_MT","name":"$seq"},{"containerName":"matches_MT","name":"$len_id","kind":13,"line":528},{"containerName":"matches_MT","name":"$seq","kind":13,"line":528},{"line":528,"kind":13,"name":"$self","containerName":"matches_MT"},{"name":"$type","containerName":"matches_MT","line":528,"kind":13},{"containerName":"matches_MT","name":"$action","kind":13,"line":529},{"line":531,"kind":13,"containerName":"matches_MT","name":"$len_id"},{"containerName":"matches_MT","name":"$len_cons","kind":13,"line":534},{"containerName":"matches_MT","name":"$len_id","kind":13,"line":537},{"line":537,"kind":13,"containerName":"matches_MT","name":"$len_cons"},{"containerName":"matches_MT","name":"$self","line":540,"kind":13},{"kind":12,"line":540,"name":"throw","containerName":"matches_MT"}],"line":452,"name":"matches_MT","range":{"start":{"line":452,"character":0},"end":{"character":9999,"line":544}}},{"kind":2,"line":453,"containerName":"","name":"warnings"},{"line":467,"kind":12,"name":"Bio","containerName":"Search::Tiling::MapTileUtils::_mapping_coeff"},{"name":"Bio","containerName":"Search::Tiling::MapTileUtils::_mapping_coeff","kind":12,"line":517},{"kind":12,"line":518,"containerName":"Search::Tiling::MapTileUtils::_mapping_coeff","name":"Bio"},{"kind":12,"line":521,"containerName":"length","name":"CORE"},{"line":526,"kind":12,"name":"CORE","containerName":"length"},{"line":526,"kind":12,"name":"Bio","containerName":"Search::Tiling::MapTileUtils::_mapping_coeff"},{"containerName":"length","name":"CORE","line":528,"kind":12},{"kind":12,"line":528,"name":"Bio","containerName":"Search::Tiling::MapTileUtils::_mapping_coeff"},{"range":{"start":{"character":0,"line":549},"end":{"character":9999,"line":574}},"definition":"sub","name":"_ints_as_text","containerName":"main::","children":[{"definition":"my","name":"$ints","containerName":"_ints_as_text","localvar":"my","kind":13,"line":550},{"localvar":"my","definition":"my","name":"@ints","containerName":"_ints_as_text","line":551,"kind":13},{"kind":13,"line":551,"name":"$ints","containerName":"_ints_as_text"},{"definition":"my","name":"%pos","containerName":"_ints_as_text","localvar":"my","kind":13,"line":552},{"line":553,"kind":13,"name":"@ints","containerName":"_ints_as_text"},{"line":554,"kind":13,"name":"$pos","containerName":"_ints_as_text"},{"kind":13,"line":555,"containerName":"_ints_as_text","name":"$pos"},{"line":558,"kind":13,"localvar":"my","definition":"my","name":"@pos","containerName":"_ints_as_text"},{"containerName":"_ints_as_text","name":"$a","kind":13,"line":558},{"name":"$b","containerName":"_ints_as_text","line":558,"kind":13},{"containerName":"_ints_as_text","name":"%pos","line":558,"kind":13},{"kind":13,"line":559,"containerName":"_ints_as_text","name":"@pos"},{"kind":13,"line":559,"containerName":"_ints_as_text","name":"@pos"},{"localvar":"my","containerName":"_ints_as_text","definition":"my","name":"$max","line":561,"kind":13},{"containerName":"_ints_as_text","name":"$max","kind":13,"line":562},{"kind":13,"line":562,"containerName":"_ints_as_text","name":"$max"},{"name":"$max","containerName":"_ints_as_text","kind":13,"line":562},{"line":562,"kind":13,"name":"@pos","containerName":"_ints_as_text"},{"line":563,"kind":13,"localvar":"my","containerName":"_ints_as_text","name":"$j","definition":"my"},{"containerName":"_ints_as_text","name":"$max","kind":13,"line":563},{"name":"$i","definition":"my","containerName":"_ints_as_text","localvar":"my","kind":13,"line":564},{"containerName":"_ints_as_text","name":"$max","line":564,"kind":13},{"kind":13,"line":564,"containerName":"_ints_as_text","name":"$j"},{"localvar":"my","name":"@line","definition":"my","containerName":"_ints_as_text","line":565,"kind":13},{"name":"$j","containerName":"_ints_as_text","kind":13,"line":565},{"containerName":"_ints_as_text","name":"@pos","line":565,"kind":13},{"name":"@line","containerName":"_ints_as_text","kind":13,"line":566},{"containerName":"_ints_as_text","name":"@pos","line":568,"kind":13},{"kind":13,"line":569,"containerName":"_ints_as_text","name":"%pos"},{"kind":13,"line":570,"containerName":"_ints_as_text","name":"@pos"},{"containerName":"_ints_as_text","name":"@pos","kind":13,"line":570},{"containerName":"_ints_as_text","name":"@pos","line":570,"kind":13},{"name":"@ints","containerName":"_ints_as_text","kind":13,"line":571},{"containerName":"_ints_as_text","name":"$pos","kind":13,"line":572},{"kind":13,"line":572,"containerName":"_ints_as_text","name":"$pos"},{"line":572,"kind":13,"name":"$pos","containerName":"_ints_as_text"},{"containerName":"_ints_as_text","name":"@pos","kind":13,"line":572},{"containerName":"_ints_as_text","name":"$pos","kind":13,"line":572}],"line":549,"kind":12},{"line":550,"kind":2,"definition":1,"name":"Bio::Search::Tiling::MapTileUtils"}],"version":5}