{"vars":[{"name":"head1","line":0,"kind":12},{"line":1,"kind":12,"name":"NAME"},{"name":"Bio","containerName":"Search::SearchUtils","line":2,"kind":12},{"kind":12,"line":2,"name":"Utility"},{"name":"functions","line":2,"kind":12},{"definition":"sub","name":"tile_hsps","containerName":"main::","range":{"start":{"character":0,"line":127},"end":{"line":313,"character":9999}},"kind":12,"children":[{"line":129,"kind":13,"localvar":"my","name":"$sbjct","definition":"my","containerName":"tile_hsps"},{"containerName":"tile_hsps","name":"$sbjct","line":133,"kind":13},{"line":133,"kind":12,"containerName":"tile_hsps","name":"tiled_hsps"},{"containerName":"tile_hsps","name":"$sbjct","kind":13,"line":135},{"containerName":"tile_hsps","name":"num_hsps","line":135,"kind":12},{"name":"$sbjct","containerName":"tile_hsps","kind":13,"line":135},{"name":"n","containerName":"tile_hsps","line":135,"kind":12},{"name":"$sbjct","containerName":"tile_hsps","line":137,"kind":13},{"name":"$sbjct","containerName":"tile_hsps","line":140,"kind":13},{"containerName":"tile_hsps","name":"n","kind":12,"line":140},{"containerName":"tile_hsps","name":"$sbjct","kind":13,"line":140},{"name":"num_hsps","containerName":"tile_hsps","kind":12,"line":140},{"line":143,"kind":13,"localvar":"my","containerName":"tile_hsps","name":"$hsp","definition":"my"},{"kind":13,"line":143,"containerName":"tile_hsps","name":"$sbjct"},{"kind":12,"line":143,"name":"hsp","containerName":"tile_hsps"},{"kind":13,"line":144,"name":"$sbjct","containerName":"tile_hsps"},{"line":144,"kind":12,"containerName":"tile_hsps","name":"length_aln"},{"containerName":"tile_hsps","name":"$hsp","kind":13,"line":144},{"containerName":"tile_hsps","name":"length","kind":12,"line":144},{"containerName":"tile_hsps","name":"$sbjct","line":145,"kind":13},{"containerName":"tile_hsps","name":"length_aln","kind":12,"line":145},{"kind":13,"line":145,"containerName":"tile_hsps","name":"$hsp"},{"line":145,"kind":12,"name":"length","containerName":"tile_hsps"},{"kind":13,"line":146,"containerName":"tile_hsps","name":"$sbjct"},{"kind":12,"line":146,"name":"length_aln","containerName":"tile_hsps"},{"name":"$hsp","containerName":"tile_hsps","kind":13,"line":146},{"kind":12,"line":146,"name":"length","containerName":"tile_hsps"},{"kind":13,"line":147,"containerName":"tile_hsps","name":"$sbjct"},{"kind":12,"line":147,"containerName":"tile_hsps","name":"matches"},{"name":"$hsp","containerName":"tile_hsps","kind":13,"line":147},{"kind":12,"line":147,"name":"matches","containerName":"tile_hsps"},{"name":"$sbjct","containerName":"tile_hsps","kind":13,"line":148},{"line":148,"kind":12,"name":"gaps","containerName":"tile_hsps"},{"line":148,"kind":13,"name":"$hsp","containerName":"tile_hsps"},{"kind":12,"line":148,"containerName":"tile_hsps","name":"gaps"},{"containerName":"tile_hsps","name":"$sbjct","kind":13,"line":149},{"containerName":"tile_hsps","name":"gaps","kind":12,"line":149},{"containerName":"tile_hsps","name":"$hsp","kind":13,"line":149},{"containerName":"tile_hsps","name":"gaps","kind":12,"line":149},{"line":151,"kind":13,"name":"$sbjct","containerName":"tile_hsps"},{"name":"$sbjct","containerName":"tile_hsps","line":155,"kind":13},{"line":155,"kind":12,"containerName":"tile_hsps","name":"length_aln"},{"line":156,"kind":13,"containerName":"tile_hsps","name":"$sbjct"},{"kind":12,"line":156,"name":"length_aln","containerName":"tile_hsps"},{"kind":13,"line":157,"containerName":"tile_hsps","name":"$sbjct"},{"line":157,"kind":12,"containerName":"tile_hsps","name":"length_aln"},{"containerName":"tile_hsps","name":"$sbjct","line":158,"kind":13},{"kind":12,"line":158,"name":"matches","containerName":"tile_hsps"},{"containerName":"tile_hsps","name":"$sbjct","line":159,"kind":13},{"name":"gaps","containerName":"tile_hsps","line":159,"kind":12},{"kind":13,"line":160,"containerName":"tile_hsps","name":"$sbjct"},{"line":160,"kind":12,"containerName":"tile_hsps","name":"gaps"},{"localvar":"my","containerName":"tile_hsps","definition":"my","name":"$hsp","line":165,"kind":13},{"containerName":"tile_hsps","name":"$qstart","line":165,"kind":13},{"line":165,"kind":13,"containerName":"tile_hsps","name":"$qstop"},{"line":165,"kind":13,"name":"$sstart","containerName":"tile_hsps"},{"containerName":"tile_hsps","name":"$sstop","kind":13,"line":165},{"localvar":"my","definition":"my","name":"$frame","containerName":"tile_hsps","line":166,"kind":13},{"kind":13,"line":166,"containerName":"tile_hsps","name":"$strand"},{"kind":13,"line":166,"containerName":"tile_hsps","name":"$qstrand"},{"line":166,"kind":13,"containerName":"tile_hsps","name":"$sstrand"},{"kind":13,"line":167,"definition":"my","name":"@qcontigs","containerName":"tile_hsps","localvar":"my"},{"kind":13,"line":167,"containerName":"tile_hsps","name":"@scontigs"},{"kind":13,"line":168,"containerName":"tile_hsps","name":"$qoverlap","definition":"my","localvar":"my"},{"localvar":"my","containerName":"tile_hsps","name":"$soverlap","definition":"my","line":169,"kind":13},{"localvar":"my","name":"$max_overlap","definition":"my","containerName":"tile_hsps","line":170,"kind":13},{"name":"$sbjct","containerName":"tile_hsps","kind":13,"line":170},{"name":"overlap","containerName":"tile_hsps","kind":12,"line":170},{"line":171,"kind":13,"localvar":"my","definition":"my","name":"$hit_qgaps","containerName":"tile_hsps"},{"localvar":"my","containerName":"tile_hsps","definition":"my","name":"$hit_sgaps","line":172,"kind":13},{"localvar":"my","containerName":"tile_hsps","name":"$hit_len_aln","definition":"my","line":173,"kind":13},{"localvar":"my","definition":"my","name":"%start_stop","containerName":"tile_hsps","line":174,"kind":13},{"localvar":"my","containerName":"tile_hsps","name":"$v","definition":"my","line":175,"kind":13},{"kind":13,"line":175,"containerName":"tile_hsps","name":"$sbjct"},{"kind":12,"line":175,"containerName":"tile_hsps","name":"verbose"},{"name":"$hsp","containerName":"tile_hsps","kind":13,"line":176},{"containerName":"tile_hsps","name":"$sbjct","kind":13,"line":176},{"containerName":"tile_hsps","name":"hsps","kind":12,"line":176},{"line":183,"kind":13,"containerName":"tile_hsps","name":"$qstart"},{"line":183,"kind":13,"containerName":"tile_hsps","name":"$qstop"},{"name":"$hsp","containerName":"tile_hsps","kind":13,"line":183},{"name":"range","containerName":"tile_hsps","line":183,"kind":12},{"containerName":"tile_hsps","name":"$sstart","kind":13,"line":184},{"kind":13,"line":184,"containerName":"tile_hsps","name":"$sstop"},{"line":184,"kind":13,"name":"$hsp","containerName":"tile_hsps"},{"kind":12,"line":184,"name":"range","containerName":"tile_hsps"},{"name":"$frame","containerName":"tile_hsps","kind":13,"line":185},{"line":185,"kind":13,"containerName":"tile_hsps","name":"$hsp"},{"line":185,"kind":12,"name":"frame","containerName":"tile_hsps"},{"name":"$frame","containerName":"tile_hsps","kind":13,"line":186},{"name":"$frame","containerName":"tile_hsps","kind":13,"line":186},{"containerName":"tile_hsps","name":"$qstrand","line":188,"kind":13},{"name":"$sstrand","containerName":"tile_hsps","kind":13,"line":188},{"name":"$hsp","containerName":"tile_hsps","line":188,"kind":13},{"name":"query","containerName":"tile_hsps","kind":12,"line":188},{"containerName":"tile_hsps","name":"strand","line":188,"kind":12},{"line":189,"kind":13,"name":"$hsp","containerName":"tile_hsps"},{"name":"hit","containerName":"tile_hsps","line":189,"kind":12},{"line":189,"kind":12,"containerName":"tile_hsps","name":"strand"},{"localvar":"my","containerName":"tile_hsps","name":"$qgaps","definition":"my","line":193,"kind":13},{"name":"$sgaps","containerName":"tile_hsps","kind":13,"line":193},{"containerName":"tile_hsps","name":"$hsp","kind":13,"line":193},{"name":"gaps","containerName":"tile_hsps","kind":12,"line":193},{"name":"$hsp","containerName":"tile_hsps","kind":13,"line":193},{"line":193,"kind":12,"containerName":"tile_hsps","name":"gaps"},{"containerName":"tile_hsps","name":"$hit_qgaps","kind":13,"line":194},{"containerName":"tile_hsps","name":"$qgaps","line":194,"kind":13},{"name":"$hit_sgaps","containerName":"tile_hsps","kind":13,"line":195},{"kind":13,"line":195,"containerName":"tile_hsps","name":"$sgaps"},{"line":196,"kind":13,"containerName":"tile_hsps","name":"$hit_len_aln"},{"line":196,"kind":13,"name":"$hsp","containerName":"tile_hsps"},{"name":"length","containerName":"tile_hsps","kind":12,"line":196},{"line":199,"kind":13,"name":"$qoverlap","containerName":"tile_hsps"},{"containerName":"tile_hsps","name":"$hsp","line":199,"kind":13},{"line":199,"kind":13,"containerName":"tile_hsps","name":"$qstart"},{"kind":13,"line":199,"containerName":"tile_hsps","name":"$qstop"},{"containerName":"tile_hsps","name":"@qcontigs","kind":13,"line":200},{"containerName":"tile_hsps","name":"$max_overlap","kind":13,"line":200},{"containerName":"tile_hsps","name":"$frame","line":200,"kind":13},{"name":"$qstrand","containerName":"tile_hsps","kind":13,"line":201},{"line":205,"kind":13,"name":"$soverlap","containerName":"tile_hsps"},{"containerName":"tile_hsps","name":"$hsp","kind":13,"line":205},{"containerName":"tile_hsps","name":"$sstart","kind":13,"line":205},{"line":205,"kind":13,"containerName":"tile_hsps","name":"$sstop"},{"line":206,"kind":13,"name":"@scontigs","containerName":"tile_hsps"},{"kind":13,"line":206,"name":"$max_overlap","containerName":"tile_hsps"},{"name":"$frame","containerName":"tile_hsps","kind":13,"line":206},{"kind":13,"line":207,"name":"$sstrand","containerName":"tile_hsps"},{"kind":13,"line":211,"name":"$start_stop","containerName":"tile_hsps"},{"containerName":"tile_hsps","name":"$start_stop","kind":13,"line":212},{"name":"$qstart","containerName":"tile_hsps","kind":13,"line":212},{"line":213,"kind":13,"name":"$start_stop","containerName":"tile_hsps"},{"kind":13,"line":213,"name":"$qstop","containerName":"tile_hsps"},{"containerName":"tile_hsps","name":"$start_stop","kind":13,"line":214},{"kind":13,"line":214,"containerName":"tile_hsps","name":"$sstart"},{"name":"$start_stop","containerName":"tile_hsps","kind":13,"line":215},{"kind":13,"line":215,"containerName":"tile_hsps","name":"$sstop"},{"kind":13,"line":217,"name":"$start_stop","containerName":"tile_hsps"},{"containerName":"tile_hsps","name":"$qstart","line":217,"kind":13},{"kind":13,"line":217,"name":"$start_stop","containerName":"tile_hsps"},{"line":218,"kind":13,"containerName":"tile_hsps","name":"$qstart"},{"line":218,"kind":13,"name":"$start_stop","containerName":"tile_hsps"},{"line":219,"kind":13,"name":"$start_stop","containerName":"tile_hsps"},{"name":"$qstop","containerName":"tile_hsps","kind":13,"line":219},{"line":219,"kind":13,"containerName":"tile_hsps","name":"$start_stop"},{"line":220,"kind":13,"containerName":"tile_hsps","name":"$qstop"},{"line":220,"kind":13,"name":"$start_stop","containerName":"tile_hsps"},{"line":221,"kind":13,"name":"$start_stop","containerName":"tile_hsps"},{"name":"$sstart","containerName":"tile_hsps","line":221,"kind":13},{"line":221,"kind":13,"name":"$start_stop","containerName":"tile_hsps"},{"kind":13,"line":222,"name":"$sstart","containerName":"tile_hsps"},{"name":"$start_stop","containerName":"tile_hsps","kind":13,"line":222},{"containerName":"tile_hsps","name":"$start_stop","kind":13,"line":223},{"line":223,"kind":13,"containerName":"tile_hsps","name":"$sstop"},{"name":"$start_stop","containerName":"tile_hsps","kind":13,"line":223},{"containerName":"tile_hsps","name":"$sstop","line":224,"kind":13},{"containerName":"tile_hsps","name":"$start_stop","kind":13,"line":224},{"name":"$sbjct","containerName":"tile_hsps","kind":13,"line":229},{"name":"gaps","containerName":"tile_hsps","line":229,"kind":12},{"line":229,"kind":13,"name":"$hit_qgaps","containerName":"tile_hsps"},{"kind":13,"line":230,"name":"$sbjct","containerName":"tile_hsps"},{"line":230,"kind":12,"name":"gaps","containerName":"tile_hsps"},{"name":"$hit_sgaps","containerName":"tile_hsps","line":230,"kind":13},{"kind":13,"line":231,"containerName":"tile_hsps","name":"$sbjct"},{"name":"length_aln","containerName":"tile_hsps","line":231,"kind":12},{"containerName":"tile_hsps","name":"$hit_len_aln","line":231,"kind":13},{"containerName":"tile_hsps","name":"$sbjct","kind":13,"line":233},{"containerName":"tile_hsps","name":"start","line":233,"kind":12},{"containerName":"tile_hsps","name":"$start_stop","line":233,"kind":13},{"line":234,"kind":13,"containerName":"tile_hsps","name":"$sbjct"},{"containerName":"tile_hsps","name":"end","line":234,"kind":12},{"name":"$start_stop","containerName":"tile_hsps","line":234,"kind":13},{"name":"$sbjct","containerName":"tile_hsps","line":235,"kind":13},{"kind":12,"line":235,"name":"start","containerName":"tile_hsps"},{"line":235,"kind":13,"name":"$start_stop","containerName":"tile_hsps"},{"name":"$sbjct","containerName":"tile_hsps","line":236,"kind":13},{"name":"end","containerName":"tile_hsps","kind":12,"line":236},{"kind":13,"line":236,"containerName":"tile_hsps","name":"$start_stop"},{"definition":"my","name":"%qctg_dat","containerName":"tile_hsps","localvar":"my","kind":13,"line":244},{"kind":13,"line":245,"containerName":"tile_hsps","name":"@qcontigs"},{"kind":13,"line":246,"containerName":"tile_hsps","name":"$frame"},{"name":"$strand","containerName":"tile_hsps","line":246,"kind":13},{"containerName":"tile_hsps","name":"$v","kind":13,"line":248},{"name":"$qctg_dat","containerName":"tile_hsps","kind":13,"line":253},{"line":254,"kind":13,"containerName":"tile_hsps","name":"$qctg_dat"},{"kind":13,"line":255,"containerName":"tile_hsps","name":"$qctg_dat"},{"containerName":"tile_hsps","name":"$qctg_dat","line":256,"kind":13},{"kind":13,"line":256,"containerName":"tile_hsps","name":"$strand"},{"localvar":"my","name":"@sortedkeys","definition":"my","containerName":"tile_hsps","line":260,"kind":13},{"line":260,"kind":13,"containerName":"tile_hsps","name":"$qctg_dat"},{"line":260,"kind":13,"containerName":"tile_hsps","name":"$b"},{"name":"$qctg_dat","containerName":"tile_hsps","kind":13,"line":261},{"containerName":"tile_hsps","name":"$a","line":261,"kind":13},{"line":262,"kind":13,"containerName":"tile_hsps","name":"%qctg_dat"},{"containerName":"tile_hsps","definition":"my","name":"$longest","localvar":"my","kind":13,"line":265},{"kind":13,"line":265,"containerName":"tile_hsps","name":"$sortedkeys"},{"kind":13,"line":267,"containerName":"tile_hsps","name":"$sbjct"},{"line":267,"kind":12,"containerName":"tile_hsps","name":"length_aln"},{"line":267,"kind":13,"name":"$qctg_dat","containerName":"tile_hsps"},{"line":267,"kind":13,"containerName":"tile_hsps","name":"$longest"},{"name":"$sbjct","containerName":"tile_hsps","line":268,"kind":13},{"line":268,"kind":12,"containerName":"tile_hsps","name":"matches"},{"containerName":"tile_hsps","name":"$qctg_dat","line":268,"kind":13},{"name":"$longest","containerName":"tile_hsps","kind":13,"line":268},{"containerName":"tile_hsps","name":"$qctg_dat","kind":13,"line":269},{"name":"$longest","containerName":"tile_hsps","kind":13,"line":269},{"containerName":"tile_hsps","name":"$sbjct","line":270,"kind":13},{"kind":12,"line":270,"containerName":"tile_hsps","name":"strand"},{"kind":13,"line":270,"containerName":"tile_hsps","name":"$qctg_dat"},{"name":"$longest","containerName":"tile_hsps","kind":13,"line":270},{"name":"%sctg_dat","definition":"my","containerName":"tile_hsps","localvar":"my","kind":13,"line":277},{"kind":13,"line":278,"containerName":"tile_hsps","name":"@scontigs"},{"name":"$frame","containerName":"tile_hsps","kind":13,"line":281},{"line":281,"kind":13,"containerName":"tile_hsps","name":"$strand"},{"containerName":"tile_hsps","name":"$sctg_dat","line":282,"kind":13},{"containerName":"tile_hsps","name":"$sctg_dat","kind":13,"line":283},{"kind":13,"line":283,"containerName":"tile_hsps","name":"$frame"},{"kind":13,"line":284,"name":"$sctg_dat","containerName":"tile_hsps"},{"line":284,"kind":13,"containerName":"tile_hsps","name":"$strand"},{"line":287,"kind":13,"name":"@sortedkeys","containerName":"tile_hsps"},{"containerName":"tile_hsps","name":"$sctg_dat","kind":13,"line":287},{"line":287,"kind":13,"name":"$b","containerName":"tile_hsps"},{"line":288,"kind":13,"containerName":"tile_hsps","name":"$sctg_dat"},{"line":288,"kind":13,"name":"$a","containerName":"tile_hsps"},{"containerName":"tile_hsps","name":"%sctg_dat","kind":13,"line":289},{"kind":13,"line":292,"name":"$longest","containerName":"tile_hsps"},{"name":"$sortedkeys","containerName":"tile_hsps","kind":13,"line":292},{"line":294,"kind":13,"name":"$sbjct","containerName":"tile_hsps"},{"line":294,"kind":12,"containerName":"tile_hsps","name":"length_aln"},{"line":294,"kind":13,"name":"$sctg_dat","containerName":"tile_hsps"},{"kind":13,"line":294,"containerName":"tile_hsps","name":"$longest"},{"line":295,"kind":13,"containerName":"tile_hsps","name":"$sbjct"},{"name":"frame","containerName":"tile_hsps","kind":12,"line":295},{"containerName":"tile_hsps","name":"$sctg_dat","kind":13,"line":295},{"containerName":"tile_hsps","name":"$longest","line":295,"kind":13},{"kind":13,"line":296,"containerName":"tile_hsps","name":"$sbjct"},{"containerName":"tile_hsps","name":"strand","kind":12,"line":296},{"line":296,"kind":13,"name":"$sctg_dat","containerName":"tile_hsps"},{"kind":13,"line":296,"containerName":"tile_hsps","name":"$longest"},{"containerName":"tile_hsps","name":"$qoverlap","line":298,"kind":13},{"kind":13,"line":299,"containerName":"tile_hsps","name":"$soverlap"},{"name":"$sbjct","containerName":"tile_hsps","kind":13,"line":299},{"kind":12,"line":299,"containerName":"tile_hsps","name":"ambiguous_aln"},{"kind":13,"line":302,"containerName":"tile_hsps","name":"$sbjct"},{"containerName":"tile_hsps","name":"ambiguous_aln","line":302,"kind":12},{"containerName":"tile_hsps","name":"$soverlap","kind":13,"line":305},{"name":"$sbjct","containerName":"tile_hsps","kind":13,"line":306},{"name":"ambiguous_aln","containerName":"tile_hsps","kind":12,"line":306},{"line":310,"kind":13,"name":"$sbjct","containerName":"tile_hsps"},{"line":312,"kind":13,"name":"@qcontigs","containerName":"tile_hsps"},{"name":"@scontigs","containerName":"tile_hsps","line":312,"kind":13}],"line":127},{"line":129,"kind":2,"containerName":"","name":"strict"},{"name":"_warn_about_no_hsps","line":137,"kind":12},{"name":"_adjust_length_aln","line":151,"kind":12},{"kind":12,"line":199,"name":"_adjust_contigs"},{"line":205,"kind":12,"name":"_adjust_contigs"},{"line":310,"kind":12,"name":"_adjust_length_aln"},{"containerName":"main::","definition":"sub","name":"_adjust_length_aln","range":{"start":{"line":321,"character":0},"end":{"line":329,"character":9999}},"kind":12,"line":321,"children":[{"name":"$sbjct","definition":"my","containerName":"_adjust_length_aln","localvar":"my","kind":13,"line":322},{"containerName":"_adjust_length_aln","definition":"my","name":"$algo","localvar":"my","kind":13,"line":323},{"line":323,"kind":13,"name":"$sbjct","containerName":"_adjust_length_aln"},{"containerName":"_adjust_length_aln","name":"algorithm","line":323,"kind":12},{"line":324,"kind":13,"localvar":"my","containerName":"_adjust_length_aln","definition":"my","name":"$hlen"},{"containerName":"_adjust_length_aln","name":"$sbjct","kind":13,"line":324},{"containerName":"_adjust_length_aln","name":"length_aln","kind":12,"line":324},{"line":325,"kind":13,"localvar":"my","containerName":"_adjust_length_aln","name":"$qlen","definition":"my"},{"kind":13,"line":325,"name":"$sbjct","containerName":"_adjust_length_aln"},{"line":325,"kind":12,"containerName":"_adjust_length_aln","name":"length_aln"},{"name":"$sbjct","containerName":"_adjust_length_aln","kind":13,"line":327},{"name":"length_aln","containerName":"_adjust_length_aln","kind":12,"line":327},{"containerName":"_adjust_length_aln","name":"$algo","kind":13,"line":327},{"kind":13,"line":327,"containerName":"_adjust_length_aln","name":"$hlen"},{"kind":13,"line":328,"name":"$sbjct","containerName":"_adjust_length_aln"},{"name":"length_aln","containerName":"_adjust_length_aln","kind":12,"line":328},{"containerName":"_adjust_length_aln","name":"$algo","kind":13,"line":328},{"line":328,"kind":13,"name":"$qlen","containerName":"_adjust_length_aln"}]},{"name":"logical_length","kind":12,"line":327},{"line":328,"kind":12,"name":"logical_length"},{"line":350,"children":[{"line":351,"kind":13,"localvar":"my","name":"$algo","definition":"my","containerName":"logical_length"},{"name":"$type","containerName":"logical_length","line":351,"kind":13},{"line":351,"kind":13,"containerName":"logical_length","name":"$len"},{"line":352,"kind":13,"localvar":"my","containerName":"logical_length","definition":"my","name":"$logical"},{"name":"$len","containerName":"logical_length","kind":13,"line":352},{"containerName":"logical_length","name":"$algo","line":353,"kind":13},{"line":354,"kind":13,"name":"$logical","containerName":"logical_length"},{"containerName":"logical_length","name":"$len","kind":13,"line":354},{"name":"$type","containerName":"logical_length","kind":13,"line":354},{"name":"$algo","containerName":"logical_length","kind":13,"line":355},{"containerName":"logical_length","name":"$logical","line":356,"kind":13},{"kind":13,"line":356,"name":"$len","containerName":"logical_length"},{"kind":13,"line":356,"name":"$type","containerName":"logical_length"},{"kind":13,"line":357,"name":"$algo","containerName":"logical_length"},{"containerName":"logical_length","name":"$logical","line":358,"kind":13},{"name":"$len","containerName":"logical_length","kind":13,"line":358},{"line":360,"kind":13,"name":"$logical","containerName":"logical_length"}],"kind":12,"detail":"($algo,$type,$len)","signature":{"documentation":"1;\n=head1 NAME\n\nBio::Search::SearchUtils - Utility functions for Bio::Search:: objects\n\n=head1 SYNOPSIS\n\n  # This module is just a collection of subroutines, not an object.\n\n=head1 DESCRIPTION\n\nThe SearchUtils.pm module is a collection of subroutines used\nprimarily by Bio::Search::Hit::HitI objects for some of the additional\nfunctionality, such as HSP tiling. Right now, the SearchUtils is just\na collection of methods, not an object.\n\n=head1 AUTHOR \n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n\npackage Bio::Search::SearchUtils;\nuse Bio::Root::Version;\n\nuse strict;\n\n=head2 tile_hsps\n\n Usage     : tile_hsps( $sbjct );\n           : This is called automatically by methods in Bio::Search::Hit::GenericHit \n           : that rely on having tiled data.\n           :\n           : If you are interested in getting data about the constructed HSP contigs:\n           : my ($qcontigs, $scontigs) = Bio::Search::SearchUtils::tile_hsps($hit);\n           : if (ref $qcontigs) {\n           :    print STDERR \"Query contigs:\\n\";\n           :    foreach (@{$qcontigs}) {\n           :         print \"contig start is $_->{'start'}\\n\";\n           :         print \"contig stop is $_->{'stop'}\\n\";\n           :    }\n           : }\n           : See below for more information about the contig data structure.\n           :\n Purpose   : Collect statistics about the aligned sequences in a set of HSPs.\n           : Calculates the following data across all HSPs: \n           :    -- total alignment length \n           :    -- total identical residues \n           :    -- total conserved residues\n Returns   : If there was only a single HSP (so no tiling was necessary)\n               tile_hsps() returns a list of two non-zero integers.\n             If there were multiple HSP, \n               tile_hsps() returns a list of two array references containin HSP contig data.\n             The first array ref contains a list of HSP contigs on the query sequence.\n             The second array ref contains a list of HSP contigs on the subject sequence.\n             Each contig is a hash reference with the following data fields:\n               'start' => start coordinate of the contig\n               'stop'  => start coordinate of the contig\n               'iden'  => number of identical residues in the contig\n               'cons'  => number of conserved residues in the contig\n               'strand'=> strand of the contig\n               'frame' => frame of the contig\n Argument  : A Bio::Search::Hit::HitI object \n Throws    : n/a\n Comments  :\n           : This method performs more careful summing of data across\n           : all HSPs in the Sbjct object. Only HSPs that are in the same strand \n           : and frame are tiled. Simply summing the data from all HSPs\n           : in the same strand and frame will overestimate the actual \n           : length of the alignment if there is overlap between different HSPs \n           : (often the case).\n           :\n           : The strategy is to tile the HSPs and sum over the\n           : contigs, collecting data separately from overlapping and\n           : non-overlapping regions of each HSP. To facilitate this, the\n           : HSP.pm object now permits extraction of data from sub-sections\n           : of an HSP.\n           : \n           : Additional useful information is collected from the results\n           : of the tiling. It is possible that sub-sequences in\n           : different HSPs will overlap significantly. In this case, it\n           : is impossible to create a single unambiguous alignment by\n           : concatenating the HSPs. The ambiguity may indicate the\n           : presence of multiple, similar domains in one or both of the\n           : aligned sequences. This ambiguity is recorded using the\n           : ambiguous_aln() method.\n           : \n           : This method does not attempt to discern biologically\n           : significant vs. insignificant overlaps. The allowable amount of \n           : overlap can be set with the overlap() method or with the -OVERLAP\n           : parameter used when constructing the Hit object.\n           : \n           : For a given hit, both the query and the sbjct sequences are\n           : tiled independently.\n           : \n           :    -- If only query sequence HSPs overlap, \n           :          this may suggest multiple domains in the sbjct.\n           :    -- If only sbjct sequence HSPs overlap, \n           :          this may suggest multiple domains in the query.\n           :    -- If both query & sbjct sequence HSPs overlap, \n           :          this suggests multiple domains in both.\n           :    -- If neither query & sbjct sequence HSPs overlap, \n           :          this suggests either no multiple domains in either\n           :          sequence OR that both sequences have the same\n           :          distribution of multiple similar domains.\n           : \n           : This method can deal with the special case of when multiple\n           : HSPs exactly overlap.\n           : \n           : Efficiency concerns:\n           :  Speed will be an issue for sequences with numerous HSPs.\n           : \n Bugs      : Currently, tile_hsps() does not properly account for\n           : the number of non-tiled but overlapping HSPs, which becomes a problem\n           : as overlap() grows. Large values overlap() may thus lead to \n           : incorrect statistics for some hits. For best results, keep overlap()\n           : below 5 (DEFAULT IS 2). For more about this, see the \"HSP Tiling and\n           : Ambiguous Alignments\" section in L<Bio::Search::Hit::GenericHit>.\n\nSee Also   : L<_adjust_contigs>(), L<Bio::Search::Hit::GenericHit|Bio::Search::Hit::GenericHit>\n\n\n#--------------\nsub tile_hsps {\n#--------------\n    my $sbjct = shift;\n\n    #print STDERR \"Calling tile_hsps(): $sbjct\\n\";\n    #$sbjct->verbose(1);  # to activate debugging\n    $sbjct->tiled_hsps(1);\n\n    if( $sbjct->num_hsps == 0 || $sbjct->n == 0 ) { \t\t\n\t#print STDERR \"_tile_hsps(): no hsps, nothing to tile! (\", $sbjct->num_hsps, \")\\n\";\n        _warn_about_no_hsps($sbjct);\n        return (undef, undef);\n\n    } elsif( $sbjct->n == 1 or $sbjct->num_hsps == 1) {\n        ## Simple summation scheme. Valid if there is only one HSP.\n\t#print STDERR \"_tile_hsps(): single HSP, easy stats.\\n\";\n\tmy $hsp = $sbjct->hsp;\n\t$sbjct->length_aln('query', $hsp->length('query'));\n\t$sbjct->length_aln('hit', $hsp->length('sbjct'));\n\t$sbjct->length_aln('total', $hsp->length('total'));\n\t$sbjct->matches( $hsp->matches() );\n\t$sbjct->gaps('query', $hsp->gaps('query'));\n\t$sbjct->gaps('sbjct', $hsp->gaps('sbjct'));\n\n        _adjust_length_aln($sbjct);\n\treturn (1, 1);\n    } else {\n\t#print STDERR \"Sbjct: _tile_hsps: summing multiple HSPs\\n\";\n\t$sbjct->length_aln('query', 0);\n\t$sbjct->length_aln('sbjct', 0);\n\t$sbjct->length_aln('total', 0); \n \t$sbjct->matches( 0, 0);\n        $sbjct->gaps('query', 0);\n        $sbjct->gaps('hit', 0);\n    }\n\n    ## More than one HSP. Must tile HSPs.\n#    print \"\\nTiling HSPs for $sbjct\\n\";\n    my($hsp, $qstart, $qstop, $sstart, $sstop);\n    my($frame, $strand, $qstrand, $sstrand);\n    my(@qcontigs, @scontigs);\n    my $qoverlap = 0;\n    my $soverlap = 0;\n    my $max_overlap = $sbjct->overlap;\n    my $hit_qgaps = 0;\n    my $hit_sgaps = 0;\n    my $hit_len_aln = 0;\n    my %start_stop;\n    my $v = $sbjct->verbose;\n    foreach $hsp ( $sbjct->hsps() ) {\n\t#$sbjct->debug( sprintf(\"  HSP: %s %d..%d\\n\",$hsp->query->seq_id, $hsp->query->start, $hsp->hit->end)) if $v > 0; #$hsp->str('query');\n#\tprintf \"  Length = %d; Identical = %d; Conserved = %d; Conserved(1-10): %d\",$hsp->length, $hsp->length(-TYPE=>'iden'), \n#\t$hsp->length(-TYPE=>'cons'),\n#\t$hsp->length(-TYPE=>'cons',\n#\t\t     -START=>0,-STOP=>10); \n\n\t($qstart, $qstop) = $hsp->range('query');\n\t($sstart, $sstop) = $hsp->range('sbjct');\n\t$frame = $hsp->frame('hit');\n\t$frame = -1 unless defined $frame;\n\t\n\t($qstrand, $sstrand) = ($hsp->query->strand,\n\t\t\t\t$hsp->hit->strand);\n\n        # Note: No correction for overlap.\n\t\n\tmy ($qgaps, $sgaps)  = ($hsp->gaps('query'), $hsp->gaps('hit'));\n\t$hit_qgaps += $qgaps;\n\t$hit_sgaps += $sgaps;\n\t$hit_len_aln += $hsp->length;\n\n\t## Collect contigs in the query sequence.\n \t$qoverlap += &_adjust_contigs('query', $hsp, $qstart, $qstop, \n\t\t\t\t     \\@qcontigs, $max_overlap, $frame, \n\t\t\t\t     $qstrand);\n\n\t## Collect contigs in the sbjct sequence \n\t#  (needed for domain data and gapped Blast).\n\t$soverlap += &_adjust_contigs('sbjct', $hsp, $sstart, $sstop, \n\t\t\t\t     \\@scontigs, $max_overlap, $frame, \n\t\t\t\t     $sstrand);\n\n\t## Collect overall start and stop data for query and \n\t#  sbjct over all HSPs.\n\tunless ( defined $start_stop{'qstart'} ) {\n            $start_stop{'qstart'}  = $qstart;\n            $start_stop{'qstop'}   = $qstop;\n            $start_stop{'sstart'}  = $sstart;\n            $start_stop{'sstop'}   = $sstop;\n\t} else {\n\t    $start_stop{'qstart'} = ($qstart < $start_stop{'qstart'} ? \n\t\t\t\t     $qstart : $start_stop{'qstart'} );\n\t    $start_stop{'qstop'}  = ($qstop  > $start_stop{'qstop'} ? \n\t\t\t\t     $qstop  : $start_stop{'qstop'} );\n\t    $start_stop{'sstart'} = ($sstart < $start_stop{'sstart'} ? \n\t\t\t\t     $sstart : $start_stop{'sstart'} );\n\t    $start_stop{'sstop'}  = ($sstop  > $start_stop{'sstop'} ? \n\t\t\t\t     $sstop  : $start_stop{'sstop'} );\n\t}\t    \n    }\n\n    # Store the collected data in the Hit object\n    $sbjct->gaps('query', $hit_qgaps);\n    $sbjct->gaps('hit', $hit_sgaps);\n    $sbjct->length_aln('total', $hit_len_aln);\n    \n    $sbjct->start('query',$start_stop{'qstart'});\n    $sbjct->end('query', $start_stop{'qstop'});\n    $sbjct->start('hit', $start_stop{'sstart'});\n    $sbjct->end('hit', $start_stop{'sstop'});\n    ## Collect data across the collected contigs.\n\n    #$sbjct->debug( \"\\nQUERY CONTIGS:\\n\".\"  gaps = $sbjct->{'_gaps_query'}\\n\");\n\n    # Account for strand/frame.\n    # Strategy: collect data on a per strand+frame basis and \n    #           save the most significant one.\n    my (%qctg_dat);\n    foreach (@qcontigs) {\n        ($frame, $strand) = ($_->{'frame'}, $_->{'strand'});\n        \n        if( $v > 0 ) {\n            #$sbjct->debug(sprintf( \"$frame/$strand len is getting %d for %d..%d\\n\", \n            #\t\t\t   ($_->{'stop'} - $_->{'start'} + 1), $_->{'start'}, $_->{'stop'}));\n        }\n        \n        $qctg_dat{ \"$frame$strand\" }->{'length_aln_query'} += $_->{'stop'} - $_->{'start'} + 1;\n        $qctg_dat{ \"$frame$strand\" }->{'totalIdentical'}   += $_->{'iden'};\n        $qctg_dat{ \"$frame$strand\" }->{'totalConserved'}   += $_->{'cons'};\n        $qctg_dat{ \"$frame$strand\" }->{'qstrand'}   = $strand;\n    }\n\n    # Find longest contig.\n    my @sortedkeys = sort { $qctg_dat{$b}->{'length_aln_query'} \n\t\t\t    <=> $qctg_dat{$a}->{'length_aln_query'} }\n    keys %qctg_dat;\n\n    # Save the largest to the sbjct:\n    my $longest = $sortedkeys[0];\n    #$sbjct->debug( \"longest is \". $qctg_dat{ $longest }->{'length_aln_query'}. \"\\n\");\n    $sbjct->length_aln('query', $qctg_dat{ $longest }->{'length_aln_query'});\n    $sbjct->matches($qctg_dat{ $longest }->{'totalIdentical'},\n                    $qctg_dat{ $longest }->{'totalConserved'});\n    $sbjct->strand('query', $qctg_dat{ $longest }->{'qstrand'});\n\n    ## Collect data for sbjct contigs. Important for gapped Blast.\n    ## The totalIdentical and totalConserved numbers will be the same\n    ## as determined for the query contigs.\n\n    #$sbjct->debug( \"\\nSBJCT CONTIGS:\\n\".\"  gaps = \". $sbjct->gaps('sbjct'). \"\\n\");\n    my (%sctg_dat);\n    foreach(@scontigs) {\n\t#$sbjct->debug(\"  sbjct contig: $_->{'start'} - $_->{'stop'}\\n\".\n\t#\t     \"         iden = $_->{'iden'}; cons = $_->{'cons'}\\n\");\n\t($frame, $strand) = ($_->{'frame'}, $_->{'strand'});\n\t$sctg_dat{ \"$frame$strand\" }->{'length_aln_sbjct'}   += $_->{'stop'} - $_->{'start'} + 1;\n\t$sctg_dat{ \"$frame$strand\" }->{'frame'}  = $frame;\n\t$sctg_dat{ \"$frame$strand\" }->{'sstrand'}  = $strand;\n    }\n    \n    @sortedkeys = sort { $sctg_dat{ $b }->{'length_aln_sbjct'} \n\t\t\t <=> $sctg_dat{ $a }->{'length_aln_sbjct'} \n\t\t     } keys %sctg_dat;\n\n    # Save the largest to the sbjct:\n    $longest = $sortedkeys[0];\n\n    $sbjct->length_aln('sbjct', $sctg_dat{ $longest }->{'length_aln_sbjct'});\n    $sbjct->frame( $sctg_dat{ $longest }->{'frame'} );\n    $sbjct->strand('hit', $sctg_dat{ $longest }->{'sstrand'});\n\n    if($qoverlap) {\n\tif($soverlap) { $sbjct->ambiguous_aln('qs'); \n\t\t\t#$sbjct->debug(\"\\n*** AMBIGUOUS ALIGNMENT: Query and Sbjct\\n\\n\");\n\t\t    }\n\telse { $sbjct->ambiguous_aln('q');\n\t       #$sbjct->debug( \"\\n*** AMBIGUOUS ALIGNMENT: Query\\n\\n\");\n\t   }\n    } elsif($soverlap) { \n\t$sbjct->ambiguous_aln('s'); \n\t#$sbjct->debug( \"\\n*** AMBIGUOUS ALIGNMENT: Sbjct\\n\\n\");\n    }\n\n    _adjust_length_aln($sbjct);\n\n    return ( [@qcontigs], [@scontigs] );\n}\n\n\n\n# Title    : _adjust_length_aln  \n# Usage    : n/a; internal use only; called by tile_hsps.\n# Purpose  : Adjust length of aligment based on BLAST flavor.\n# Comments : See comments in logica_length()\nsub _adjust_length_aln {\n    my $sbjct = shift;\n    my $algo = $sbjct->algorithm;\n    my $hlen = $sbjct->length_aln('sbjct');\n    my $qlen = $sbjct->length_aln('query');\n\n    $sbjct->length_aln('sbjct', logical_length($algo, 'sbjct', $hlen));\n    $sbjct->length_aln('query', logical_length($algo, 'query', $qlen));\n}\n\n=head2 logical_length\n\n Usage     : logical_length( $alg_name, $seq_type, $length );\n Purpose   : Determine the logical length of an aligned sequence based on \n           : algorithm name and sequence type.\n Returns   : integer representing the logical aligned length.\n Argument  : $alg_name = name of algorigthm (e.g., blastx, tblastn)\n           : $seq_type = type of sequence (e.g., query or hit)\n           : $length = physical length of the sequence in the alignment.\n Throws    : n/a\n Comments  : This function is used to account for the fact that number of identities \n             and conserved residues is reported in peptide space while the query \n             length (in the case of BLASTX and TBLASTX) and/or the hit length \n             (in the case of TBLASTN and TBLASTX) are in nucleotide space.\n             The adjustment affects the values reported by the various frac_XXX \n             methods in GenericHit and GenericHSP.","parameters":[{"label":"$algo"},{"label":"$type"},{"label":"$len"}],"label":"logical_length($algo,$type,$len)"},"containerName":"main::","definition":"sub","range":{"start":{"line":350,"character":0},"end":{"character":9999,"line":361}},"name":"logical_length"},{"name":"_adjust_contigs","range":{"start":{"line":385,"character":0},"end":{"character":9999,"line":449}},"definition":"sub","containerName":"main::","signature":{"label":"_adjust_contigs($seqType,$hsp,$start,$stop,$contigs_ref,$max_overlap,$frame,$strand)","documentation":"=head2 _adjust_contigs\n\n Usage     : n/a; internal function called by tile_hsps\n Purpose   : Builds HSP contigs for a given BLAST hit.\n           : Utility method called by _tile_hsps()\n Returns   :\n Argument  :\n Throws    : Exceptions propagated from Bio::Search::Hit::BlastHSP::matches()\n           : for invalid sub-sequence ranges.\n Status    : Experimental\n Comments  : This method supports gapped alignments through a patch by maj\n           : to B:S:HSP:HSPI::matches().\n           : It does not keep track of the number of HSPs that\n           : overlap within the amount specified by overlap().\n           : This will lead to significant tracking errors for large\n           : overlap values.\n\nSee Also   : L<tile_hsps>(), L<Bio::Search::Hit::BlastHSP::matches|Bio::Search::Hit::BlastHSP>\n\n=cut","parameters":[{"label":"$seqType"},{"label":"$hsp"},{"label":"$start"},{"label":"$stop"},{"label":"$contigs_ref"},{"label":"$max_overlap"},{"label":"$frame"},{"label":"$strand"}]},"detail":"($seqType,$hsp,$start,$stop,$contigs_ref,$max_overlap,$frame,$strand)","kind":12,"children":[{"line":386,"kind":13,"localvar":"my","containerName":"_adjust_contigs","definition":"my","name":"$seqType"},{"line":386,"kind":13,"name":"$hsp","containerName":"_adjust_contigs"},{"name":"$start","containerName":"_adjust_contigs","line":386,"kind":13},{"line":386,"kind":13,"name":"$stop","containerName":"_adjust_contigs"},{"containerName":"_adjust_contigs","name":"$contigs_ref","line":386,"kind":13},{"kind":13,"line":387,"containerName":"_adjust_contigs","name":"$max_overlap"},{"line":387,"kind":13,"containerName":"_adjust_contigs","name":"$frame"},{"containerName":"_adjust_contigs","name":"$strand","kind":13,"line":387},{"localvar":"my","definition":"my","name":"$overlap","containerName":"_adjust_contigs","line":388,"kind":13},{"localvar":"my","definition":"my","name":"$numID","containerName":"_adjust_contigs","line":389,"kind":13},{"name":"$numCons","containerName":"_adjust_contigs","line":389,"kind":13},{"line":391,"kind":13,"containerName":"_adjust_contigs","name":"$contigs_ref"},{"name":"$frame","containerName":"_adjust_contigs","line":393,"kind":13},{"kind":13,"line":393,"containerName":"_adjust_contigs","name":"$strand"},{"line":396,"kind":13,"name":"$start","containerName":"_adjust_contigs"},{"line":396,"kind":13,"containerName":"_adjust_contigs","name":"$stop"},{"line":397,"kind":13,"containerName":"_adjust_contigs","name":"$overlap"},{"kind":13,"line":402,"containerName":"_adjust_contigs","name":"$start"},{"containerName":"_adjust_contigs","name":"$stop","line":402,"kind":13},{"line":402,"kind":13,"name":"$max_overlap","containerName":"_adjust_contigs"},{"name":"$numID","containerName":"_adjust_contigs","kind":13,"line":404},{"containerName":"_adjust_contigs","name":"$numCons","kind":13,"line":404},{"line":404,"kind":13,"name":"$hsp","containerName":"_adjust_contigs"},{"name":"matches","containerName":"_adjust_contigs","kind":12,"line":404},{"kind":13,"line":404,"name":"$seqType","containerName":"_adjust_contigs"},{"kind":13,"line":405,"containerName":"_adjust_contigs","name":"$start"},{"name":"$numID","containerName":"_adjust_contigs","kind":13,"line":407},{"line":408,"kind":13,"containerName":"_adjust_contigs","name":"$hsp"},{"name":"warn","containerName":"_adjust_contigs","line":408,"kind":12},{"containerName":"_adjust_contigs","name":"$numID","kind":13,"line":409},{"name":"$numCons","containerName":"_adjust_contigs","line":411,"kind":13},{"containerName":"_adjust_contigs","name":"$hsp","kind":13,"line":412},{"line":412,"kind":12,"containerName":"_adjust_contigs","name":"warn"},{"name":"$numCons","containerName":"_adjust_contigs","line":413,"kind":13},{"kind":13,"line":418,"containerName":"_adjust_contigs","name":"$start"},{"containerName":"_adjust_contigs","name":"$numID","kind":13,"line":419},{"name":"$numCons","containerName":"_adjust_contigs","line":420,"kind":13},{"containerName":"_adjust_contigs","name":"$hsp","kind":13,"line":421},{"line":422,"kind":13,"name":"$overlap","containerName":"_adjust_contigs"},{"line":427,"kind":13,"name":"$stop","containerName":"_adjust_contigs"},{"containerName":"_adjust_contigs","name":"$start","line":427,"kind":13},{"name":"$max_overlap","containerName":"_adjust_contigs","line":427,"kind":13},{"kind":13,"line":429,"containerName":"_adjust_contigs","name":"$numID"},{"containerName":"_adjust_contigs","name":"$numCons","line":429,"kind":13},{"line":429,"kind":13,"name":"$hsp","containerName":"_adjust_contigs"},{"kind":12,"line":429,"name":"matches","containerName":"_adjust_contigs"},{"name":"$seqType","containerName":"_adjust_contigs","kind":13,"line":429},{"containerName":"_adjust_contigs","name":"$stop","kind":13,"line":431},{"kind":13,"line":432,"containerName":"_adjust_contigs","name":"$numID"},{"containerName":"_adjust_contigs","name":"$hsp","kind":13,"line":433},{"containerName":"_adjust_contigs","name":"warn","kind":12,"line":433},{"line":434,"kind":13,"containerName":"_adjust_contigs","name":"$numID"},{"kind":13,"line":436,"name":"$numCons","containerName":"_adjust_contigs"},{"line":437,"kind":13,"containerName":"_adjust_contigs","name":"$hsp"},{"name":"warn","containerName":"_adjust_contigs","line":437,"kind":12},{"kind":13,"line":438,"name":"$numCons","containerName":"_adjust_contigs"},{"name":"$stop","containerName":"_adjust_contigs","kind":13,"line":443},{"line":444,"kind":13,"containerName":"_adjust_contigs","name":"$numID"},{"name":"$numCons","containerName":"_adjust_contigs","kind":13,"line":445},{"kind":13,"line":446,"name":"$hsp","containerName":"_adjust_contigs"},{"kind":13,"line":447,"containerName":"_adjust_contigs","name":"$overlap"}],"line":385},{"name":"hsps","kind":12,"line":421},{"name":"hsps","kind":12,"line":446},{"name":"$overlap","containerName":null,"line":451,"kind":13},{"kind":13,"line":454,"containerName":null,"name":"$overlap"},{"line":454,"kind":13,"containerName":null,"name":"%contigs_ref"},{"containerName":null,"definition":"my","name":"$max","localvar":"my","kind":13,"line":456},{"kind":13,"line":456,"containerName":null,"name":"$contigs_ref"},{"localvar":"my","containerName":null,"definition":"my","name":"$i","line":457,"kind":13},{"kind":13,"line":457,"containerName":null,"name":"%max"},{"line":458,"kind":13,"containerName":null,"name":"@contigs_ref"},{"line":458,"kind":13,"name":"$i","containerName":null},{"localvar":"my","name":"$i_start","definition":"my","containerName":null,"line":459,"kind":13},{"name":"$i_stop","containerName":null,"line":459,"kind":13},{"containerName":null,"name":"@contigs_ref","kind":13,"line":459},{"kind":13,"line":459,"containerName":null,"name":"%i"},{"kind":12,"line":459,"name":"start"},{"line":459,"kind":13,"name":"@contigs_ref","containerName":null},{"kind":13,"line":459,"name":"%i","containerName":null},{"kind":12,"line":459,"name":"stop"},{"kind":13,"line":461,"definition":"my","name":"$u","containerName":null,"localvar":"my"},{"containerName":null,"name":"$i","kind":13,"line":461},{"line":461,"kind":13,"containerName":null,"name":"%max"},{"kind":13,"line":462,"containerName":null,"name":"@contigs_ref"},{"containerName":null,"name":"$u","kind":13,"line":462},{"containerName":null,"definition":"my","name":"$u_start","localvar":"my","kind":13,"line":463},{"name":"$u_stop","containerName":null,"kind":13,"line":463},{"containerName":null,"name":"@contigs_ref","kind":13,"line":463},{"line":463,"kind":13,"containerName":null,"name":"%u"},{"name":"start","kind":12,"line":463},{"line":463,"kind":13,"name":"@contigs_ref","containerName":null},{"name":"%u","containerName":null,"kind":13,"line":463},{"name":"stop","kind":12,"line":463},{"name":"$u_start","containerName":null,"kind":13,"line":465},{"name":"$i_start","containerName":null,"line":465,"kind":13},{"kind":13,"line":465,"containerName":null,"name":"$u_stop"},{"containerName":null,"name":"$i_start","kind":13,"line":465},{"kind":13,"line":465,"name":"%max_overlap","containerName":null},{"localvar":"my","definition":"my","name":"$ids","containerName":null,"line":468,"kind":13},{"kind":13,"line":468,"name":"$cons","containerName":null},{"localvar":"my","containerName":null,"name":"$use_start","definition":"my","line":469,"kind":13},{"line":469,"kind":13,"name":"$i_start","containerName":null},{"localvar":"my","definition":"my","name":"%hsp","containerName":null,"line":470,"kind":13},{"kind":13,"line":470,"containerName":null,"name":"$b"},{"kind":12,"line":470,"name":"end","containerName":"main::"},{"line":470,"kind":13,"containerName":null,"name":"$seqType"},{"containerName":null,"name":"$a","line":470,"kind":13},{"line":470,"kind":12,"name":"end","containerName":"main::"},{"line":470,"kind":13,"name":"$seqType","containerName":null},{"line":470,"kind":13,"name":"@contigs_ref","containerName":null},{"name":"%u","containerName":null,"line":470,"kind":13},{"name":"hsps","kind":12,"line":470},{"line":471,"kind":13,"localvar":"my","definition":"my","name":"$hsp_start","containerName":null},{"line":471,"kind":13,"name":"$hsp","containerName":null},{"containerName":"main::","name":"start","kind":12,"line":471},{"kind":13,"line":471,"name":"$seqType","containerName":null},{"line":472,"kind":13,"containerName":null,"name":"$hsp_start"},{"line":472,"kind":13,"containerName":null,"name":"$use_start"},{"kind":13,"line":474,"containerName":null,"definition":"my","name":"$these_ids","localvar":"my"},{"containerName":null,"name":"%these_cons","line":474,"kind":13},{"containerName":null,"name":"$these_ids","line":476,"kind":13},{"name":"$these_cons","containerName":null,"kind":13,"line":476},{"line":476,"kind":13,"name":"$hsp","containerName":null},{"name":"matches","containerName":"main::","kind":12,"line":476},{"line":476,"kind":13,"name":"$seqType","containerName":null},{"line":476,"kind":13,"containerName":null,"name":"$hsp_start"},{"name":"$use_start","containerName":null,"line":476,"kind":13},{"kind":13,"line":477,"name":"%these_ids","containerName":null},{"name":"$hsp","containerName":null,"line":478,"kind":13},{"kind":12,"line":478,"containerName":"main::","name":"warn"},{"kind":13,"line":479,"containerName":null,"name":"$these_ids"},{"line":481,"kind":13,"name":"%these_cons","containerName":null},{"line":482,"kind":13,"name":"$hsp","containerName":null},{"line":482,"kind":12,"containerName":"main::","name":"warn"},{"name":"%these_cons","containerName":null,"line":483,"kind":13},{"kind":13,"line":488,"containerName":null,"name":"$ids"},{"name":"$these_ids","containerName":null,"line":488,"kind":13},{"containerName":null,"name":"$cons","line":489,"kind":13},{"kind":13,"line":489,"containerName":null,"name":"$these_cons"},{"containerName":null,"name":"$hsp_start","line":492,"kind":13},{"containerName":null,"name":"$u_start","line":492,"kind":13},{"kind":13,"line":493,"name":"$use_start","containerName":null},{"kind":13,"line":493,"name":"$hsp_start","containerName":null},{"line":495,"kind":13,"name":"@contigs_ref","containerName":null},{"name":"%i","containerName":null,"line":495,"kind":13},{"name":"start","line":495,"kind":12},{"name":"$u_start","containerName":null,"kind":13,"line":495},{"kind":13,"line":496,"containerName":null,"name":"@contigs_ref"},{"kind":13,"line":496,"name":"%i","containerName":null},{"line":496,"kind":13,"containerName":null,"name":"$ids"},{"kind":13,"line":497,"containerName":null,"name":"@contigs_ref"},{"name":"%i","containerName":null,"line":497,"kind":13},{"line":497,"kind":13,"containerName":null,"name":"$cons"},{"containerName":null,"name":"@contigs_ref","line":498,"kind":13},{"line":498,"kind":13,"containerName":null,"name":"%i"},{"name":"hsps","kind":12,"line":498},{"name":"@contigs_ref","containerName":null,"kind":13,"line":498},{"containerName":null,"name":"%u","line":498,"kind":13},{"name":"hsps","line":498,"kind":12},{"line":500,"kind":13,"containerName":null,"name":"@contigs_ref"},{"name":"$u","containerName":null,"line":500,"kind":13},{"line":502,"kind":13,"containerName":null,"name":"$u_stop"},{"line":502,"kind":13,"containerName":null,"name":"$i_stop"},{"kind":13,"line":502,"name":"$u_start","containerName":null},{"containerName":null,"name":"$i_stop","line":502,"kind":13},{"containerName":null,"name":"%max_overlap","line":502,"kind":13},{"line":505,"kind":13,"localvar":"my","definition":"my","name":"$ids","containerName":null},{"kind":13,"line":505,"name":"$cons","containerName":null},{"localvar":"my","definition":"my","name":"$use_stop","containerName":null,"line":506,"kind":13},{"kind":13,"line":506,"name":"$i_stop","containerName":null},{"line":507,"kind":13,"localvar":"my","name":"%hsp","definition":"my","containerName":null},{"kind":13,"line":507,"name":"$a","containerName":null},{"kind":12,"line":507,"containerName":"main::","name":"start"},{"containerName":null,"name":"$seqType","kind":13,"line":507},{"containerName":null,"name":"$b","line":507,"kind":13},{"kind":12,"line":507,"name":"start","containerName":"main::"},{"kind":13,"line":507,"containerName":null,"name":"$seqType"},{"line":507,"kind":13,"containerName":null,"name":"@contigs_ref"},{"kind":13,"line":507,"name":"%u","containerName":null},{"name":"hsps","line":507,"kind":12},{"kind":13,"line":508,"containerName":null,"name":"$hsp_end","definition":"my","localvar":"my"},{"line":508,"kind":13,"name":"$hsp","containerName":null},{"containerName":"main::","name":"end","line":508,"kind":12},{"name":"$seqType","containerName":null,"line":508,"kind":13},{"containerName":null,"name":"$hsp_end","kind":13,"line":509},{"name":"$use_stop","containerName":null,"kind":13,"line":509},{"localvar":"my","name":"$these_ids","definition":"my","containerName":null,"line":511,"kind":13},{"kind":13,"line":511,"containerName":null,"name":"%these_cons"},{"name":"$these_ids","containerName":null,"line":513,"kind":13},{"name":"$these_cons","containerName":null,"line":513,"kind":13},{"kind":13,"line":513,"containerName":null,"name":"$hsp"},{"name":"matches","containerName":"main::","line":513,"kind":12},{"line":513,"kind":13,"containerName":null,"name":"$seqType"},{"kind":13,"line":513,"containerName":null,"name":"$use_stop"},{"kind":13,"line":513,"containerName":null,"name":"$hsp_end"},{"kind":13,"line":514,"name":"%these_ids","containerName":null},{"containerName":null,"name":"$hsp","line":515,"kind":13},{"kind":12,"line":515,"containerName":"main::","name":"warn"},{"kind":13,"line":516,"containerName":null,"name":"$these_ids"},{"kind":13,"line":518,"containerName":null,"name":"%these_cons"},{"line":519,"kind":13,"name":"$hsp","containerName":null},{"name":"warn","containerName":"main::","kind":12,"line":519},{"kind":13,"line":520,"containerName":null,"name":"%these_cons"},{"containerName":null,"name":"$ids","line":525,"kind":13},{"name":"$these_ids","containerName":null,"kind":13,"line":525},{"name":"$cons","containerName":null,"line":526,"kind":13},{"line":526,"kind":13,"containerName":null,"name":"$these_cons"},{"line":529,"kind":13,"name":"$hsp_end","containerName":null},{"kind":13,"line":529,"containerName":null,"name":"$u_stop"},{"kind":13,"line":530,"containerName":null,"name":"$use_stop"},{"line":530,"kind":13,"containerName":null,"name":"$hsp_end"},{"line":532,"kind":13,"containerName":null,"name":"@contigs_ref"},{"kind":13,"line":532,"name":"%i","containerName":null},{"kind":13,"line":532,"containerName":null,"name":"$u_stop"},{"containerName":null,"name":"@contigs_ref","kind":13,"line":533},{"line":533,"kind":13,"name":"%i","containerName":null},{"line":533,"kind":13,"containerName":null,"name":"$ids"},{"containerName":null,"name":"@contigs_ref","kind":13,"line":534},{"containerName":null,"name":"%i","kind":13,"line":534},{"kind":13,"line":534,"containerName":null,"name":"$cons"},{"containerName":null,"name":"@contigs_ref","line":535,"kind":13},{"containerName":null,"name":"%i","kind":13,"line":535},{"line":535,"kind":12,"name":"hsps"},{"line":535,"kind":13,"containerName":null,"name":"@contigs_ref"},{"containerName":null,"name":"%u","kind":13,"line":535},{"name":"hsps","kind":12,"line":535},{"containerName":null,"name":"@contigs_ref","kind":13,"line":537},{"containerName":null,"name":"$u","line":537,"kind":13},{"containerName":null,"name":"$u_start","kind":13,"line":539},{"name":"$i_start","containerName":null,"line":539,"kind":13},{"name":"$u_stop","containerName":null,"kind":13,"line":539},{"containerName":null,"name":"%i_stop","kind":13,"line":539},{"containerName":null,"name":"@contigs_ref","kind":13,"line":543},{"kind":13,"line":543,"containerName":null,"name":"$u"},{"line":548,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"@merged"},{"containerName":null,"name":"%contigs_ref","kind":13,"line":549},{"containerName":null,"name":"@merged","kind":13,"line":550},{"name":"$contigs_ref","containerName":null,"kind":13,"line":552},{"containerName":null,"name":"@merged","line":552,"kind":13},{"kind":13,"line":554,"name":"%overlap","containerName":null},{"name":"$numID","containerName":null,"line":556,"kind":13},{"name":"$numCons","containerName":null,"line":556,"kind":13},{"containerName":null,"name":"$hsp","line":556,"kind":13},{"containerName":"main::","name":"matches","kind":12,"line":556},{"containerName":null,"name":"$seqType","line":556,"kind":13},{"kind":13,"line":557,"name":"%numID","containerName":null},{"containerName":null,"name":"$hsp","line":558,"kind":13},{"kind":12,"line":558,"containerName":"main::","name":"warn"},{"containerName":null,"name":"$numID","kind":13,"line":559},{"kind":13,"line":561,"containerName":null,"name":"%numCons"},{"containerName":null,"name":"$hsp","line":562,"kind":13},{"containerName":"main::","name":"warn","kind":12,"line":562},{"containerName":null,"name":"$numCons","line":563,"kind":13},{"containerName":null,"name":"%contigs_ref","line":566,"kind":13},{"kind":13,"line":566,"containerName":null,"name":"$start"},{"line":566,"kind":13,"containerName":null,"name":"$stop"},{"kind":13,"line":567,"containerName":null,"name":"$numID"},{"kind":13,"line":567,"name":"$numCons","containerName":null},{"kind":13,"line":568,"name":"$strand","containerName":null},{"line":568,"kind":13,"name":"@frame","containerName":null},{"kind":13,"line":568,"name":"$hsp","containerName":null},{"name":"$overlap","containerName":null,"line":571,"kind":13},{"kind":12,"line":592,"children":[{"line":593,"kind":13,"localvar":"my","containerName":"get_exponent","definition":"my","name":"$data"},{"containerName":"get_exponent","name":"$num","definition":"my","localvar":"my","kind":13,"line":595},{"name":"$exp","containerName":"get_exponent","kind":13,"line":595},{"kind":13,"line":595,"name":"$data","containerName":"get_exponent"},{"kind":13,"line":597,"containerName":"get_exponent","name":"$exp"},{"kind":13,"line":598,"containerName":"get_exponent","name":"$num"},{"name":"$num","containerName":"get_exponent","kind":13,"line":598},{"line":599,"kind":13,"containerName":"get_exponent","name":"$num"},{"line":599,"kind":13,"name":"$exp","containerName":"get_exponent"},{"name":"$num","containerName":"get_exponent","line":600,"kind":13},{"containerName":"get_exponent","name":"$exp","line":600,"kind":13},{"line":601,"kind":13,"name":"$num","containerName":"get_exponent"},{"kind":13,"line":602,"containerName":"get_exponent","name":"$exp"},{"containerName":"get_exponent","name":"$num","line":603,"kind":13},{"line":604,"kind":13,"containerName":"get_exponent","name":"$exp"},{"kind":13,"line":604,"containerName":"get_exponent","name":"$num"},{"name":"$exp","containerName":"get_exponent","kind":13,"line":606},{"name":"$num","containerName":"get_exponent","kind":13,"line":607},{"name":"$num","containerName":"get_exponent","kind":13,"line":607},{"localvar":"my","containerName":"get_exponent","definition":"my","name":"$c","line":608,"kind":13},{"line":609,"kind":13,"localvar":"my","containerName":"get_exponent","definition":"my","name":"$rev"},{"containerName":"get_exponent","name":"$num","line":610,"kind":13},{"containerName":"get_exponent","name":"$num","kind":13,"line":611},{"name":"$num","containerName":"get_exponent","kind":13,"line":611},{"line":612,"kind":13,"name":"$rev","containerName":"get_exponent"},{"name":"$c","containerName":"get_exponent","line":614,"kind":13},{"containerName":"get_exponent","name":"$num","line":614,"kind":13},{"name":"$c","containerName":"get_exponent","kind":13,"line":615},{"containerName":"get_exponent","name":"$exp","kind":13,"line":615},{"containerName":"get_exponent","name":"$c","kind":13,"line":616},{"line":618,"kind":13,"name":"$exp","containerName":"get_exponent"},{"name":"$exp","containerName":"get_exponent","line":618,"kind":13},{"containerName":"get_exponent","name":"$num","kind":13,"line":618},{"line":618,"kind":13,"name":"$rev","containerName":"get_exponent"},{"line":619,"kind":13,"name":"$exp","containerName":"get_exponent"},{"kind":13,"line":619,"name":"$rev","containerName":"get_exponent"},{"kind":13,"line":621,"name":"$exp","containerName":"get_exponent"}],"containerName":"main::","name":"get_exponent","definition":"sub","range":{"start":{"character":0,"line":592},"end":{"line":622,"character":9999}}},{"name":"CORE","containerName":"length","line":604,"kind":12},{"name":"collapse_nums","definition":"sub","containerName":"main::","range":{"start":{"line":641,"character":0},"end":{"line":670,"character":9999}},"kind":12,"children":[{"kind":13,"line":643,"name":"@a","definition":"my","containerName":"collapse_nums","localvar":"my"},{"localvar":"my","containerName":"collapse_nums","definition":"my","name":"$from","line":644,"kind":13},{"name":"$to","containerName":"collapse_nums","line":644,"kind":13},{"kind":13,"line":644,"name":"$i","containerName":"collapse_nums"},{"kind":13,"line":644,"containerName":"collapse_nums","name":"@ca"},{"line":644,"kind":13,"name":"$consec","containerName":"collapse_nums"},{"name":"$consec","containerName":"collapse_nums","line":646,"kind":13},{"kind":13,"line":647,"name":"$i","containerName":"collapse_nums"},{"line":647,"kind":13,"name":"$i","containerName":"collapse_nums"},{"kind":13,"line":647,"name":"@a","containerName":"collapse_nums"},{"name":"$i","containerName":"collapse_nums","line":647,"kind":13},{"kind":13,"line":648,"containerName":"collapse_nums","name":"$from"},{"name":"$from","containerName":"collapse_nums","kind":13,"line":648},{"containerName":"collapse_nums","name":"$a","kind":13,"line":648},{"name":"$i","containerName":"collapse_nums","kind":13,"line":648},{"line":650,"kind":13,"name":"$a","containerName":"collapse_nums"},{"name":"$i","containerName":"collapse_nums","kind":13,"line":650},{"line":650,"kind":13,"name":"$a","containerName":"collapse_nums"},{"kind":13,"line":650,"name":"$i","containerName":"collapse_nums"},{"name":"$a","containerName":"collapse_nums","line":651,"kind":13},{"kind":13,"line":651,"containerName":"collapse_nums","name":"$i"},{"kind":13,"line":651,"name":"$a","containerName":"collapse_nums"},{"line":651,"kind":13,"name":"$i","containerName":"collapse_nums"},{"kind":13,"line":652,"name":"$to","containerName":"collapse_nums"},{"containerName":"collapse_nums","name":"$a","kind":13,"line":652},{"kind":13,"line":652,"containerName":"collapse_nums","name":"$i"},{"containerName":"collapse_nums","name":"$consec","line":653,"kind":13},{"name":"$consec","containerName":"collapse_nums","line":655,"kind":13},{"name":"$from","containerName":"collapse_nums","kind":13,"line":655},{"name":"$from","containerName":"collapse_nums","line":656,"kind":13},{"line":656,"kind":13,"name":"$consec","containerName":"collapse_nums"},{"containerName":"collapse_nums","name":"@ca","kind":13,"line":657},{"line":657,"kind":13,"containerName":"collapse_nums","name":"$from"},{"containerName":"collapse_nums","name":"$from","line":658,"kind":13},{"name":"$a","containerName":"collapse_nums","kind":13,"line":658},{"containerName":"collapse_nums","name":"$i","kind":13,"line":658},{"line":659,"kind":13,"name":"$consec","containerName":"collapse_nums"},{"containerName":"collapse_nums","name":"$to","line":660,"kind":13},{"name":"$to","containerName":"collapse_nums","line":663,"kind":13},{"name":"$consec","containerName":"collapse_nums","line":664,"kind":13},{"line":664,"kind":13,"name":"$from","containerName":"collapse_nums"},{"name":"$from","containerName":"collapse_nums","line":665,"kind":13},{"line":665,"kind":13,"containerName":"collapse_nums","name":"$consec"},{"line":667,"kind":13,"name":"@ca","containerName":"collapse_nums"},{"containerName":"collapse_nums","name":"$from","line":667,"kind":13},{"kind":13,"line":667,"name":"$from","containerName":"collapse_nums"},{"kind":13,"line":669,"containerName":"collapse_nums","name":"@ca"}],"line":641},{"children":[{"line":715,"kind":13,"localvar":"my","containerName":"strip_blast_html","name":"$string_ref","definition":"my"},{"line":717,"kind":13,"containerName":"strip_blast_html","name":"$string_ref"},{"definition":"my","name":"$str","containerName":"strip_blast_html","localvar":"my","kind":13,"line":721},{"localvar":"my","containerName":"strip_blast_html","definition":"my","name":"$stripped","line":722,"kind":13},{"name":"$str","containerName":"strip_blast_html","kind":13,"line":726},{"containerName":"strip_blast_html","name":"$stripped","kind":13,"line":726},{"kind":13,"line":729,"name":"$str","containerName":"strip_blast_html"},{"name":"$stripped","containerName":"strip_blast_html","kind":13,"line":729},{"kind":13,"line":732,"containerName":"strip_blast_html","name":"$str"},{"containerName":"strip_blast_html","name":"$stripped","line":732,"kind":13},{"name":"$str","containerName":"strip_blast_html","line":734,"kind":13},{"kind":13,"line":735,"containerName":"strip_blast_html","name":"$stripped"}],"line":708,"kind":12,"range":{"end":{"character":9999,"line":736},"start":{"character":0,"line":708}},"name":"strip_blast_html","definition":"sub","containerName":"main::"},{"kind":12,"line":718,"name":"croak"},{"kind":12,"line":721,"name":"string_ref"},{"name":"string_ref","line":734,"kind":12},{"name":"result2hash","range":{"start":{"character":0,"line":749},"end":{"line":784,"character":9999}},"containerName":"main::","definition":"sub","detail":"($result)","signature":{"label":"result2hash($result)","documentation":"1;\n=head1 NAME\n\nBio::Search::SearchUtils - Utility functions for Bio::Search:: objects\n\n=head1 SYNOPSIS\n\n  # This module is just a collection of subroutines, not an object.\n\n=head1 DESCRIPTION\n\nThe SearchUtils.pm module is a collection of subroutines used\nprimarily by Bio::Search::Hit::HitI objects for some of the additional\nfunctionality, such as HSP tiling. Right now, the SearchUtils is just\na collection of methods, not an object.\n\n=head1 AUTHOR \n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n\npackage Bio::Search::SearchUtils;\nuse Bio::Root::Version;\n\nuse strict;\n\n=head2 tile_hsps\n\n Usage     : tile_hsps( $sbjct );\n           : This is called automatically by methods in Bio::Search::Hit::GenericHit \n           : that rely on having tiled data.\n           :\n           : If you are interested in getting data about the constructed HSP contigs:\n           : my ($qcontigs, $scontigs) = Bio::Search::SearchUtils::tile_hsps($hit);\n           : if (ref $qcontigs) {\n           :    print STDERR \"Query contigs:\\n\";\n           :    foreach (@{$qcontigs}) {\n           :         print \"contig start is $_->{'start'}\\n\";\n           :         print \"contig stop is $_->{'stop'}\\n\";\n           :    }\n           : }\n           : See below for more information about the contig data structure.\n           :\n Purpose   : Collect statistics about the aligned sequences in a set of HSPs.\n           : Calculates the following data across all HSPs: \n           :    -- total alignment length \n           :    -- total identical residues \n           :    -- total conserved residues\n Returns   : If there was only a single HSP (so no tiling was necessary)\n               tile_hsps() returns a list of two non-zero integers.\n             If there were multiple HSP, \n               tile_hsps() returns a list of two array references containin HSP contig data.\n             The first array ref contains a list of HSP contigs on the query sequence.\n             The second array ref contains a list of HSP contigs on the subject sequence.\n             Each contig is a hash reference with the following data fields:\n               'start' => start coordinate of the contig\n               'stop'  => start coordinate of the contig\n               'iden'  => number of identical residues in the contig\n               'cons'  => number of conserved residues in the contig\n               'strand'=> strand of the contig\n               'frame' => frame of the contig\n Argument  : A Bio::Search::Hit::HitI object \n Throws    : n/a\n Comments  :\n           : This method performs more careful summing of data across\n           : all HSPs in the Sbjct object. Only HSPs that are in the same strand \n           : and frame are tiled. Simply summing the data from all HSPs\n           : in the same strand and frame will overestimate the actual \n           : length of the alignment if there is overlap between different HSPs \n           : (often the case).\n           :\n           : The strategy is to tile the HSPs and sum over the\n           : contigs, collecting data separately from overlapping and\n           : non-overlapping regions of each HSP. To facilitate this, the\n           : HSP.pm object now permits extraction of data from sub-sections\n           : of an HSP.\n           : \n           : Additional useful information is collected from the results\n           : of the tiling. It is possible that sub-sequences in\n           : different HSPs will overlap significantly. In this case, it\n           : is impossible to create a single unambiguous alignment by\n           : concatenating the HSPs. The ambiguity may indicate the\n           : presence of multiple, similar domains in one or both of the\n           : aligned sequences. This ambiguity is recorded using the\n           : ambiguous_aln() method.\n           : \n           : This method does not attempt to discern biologically\n           : significant vs. insignificant overlaps. The allowable amount of \n           : overlap can be set with the overlap() method or with the -OVERLAP\n           : parameter used when constructing the Hit object.\n           : \n           : For a given hit, both the query and the sbjct sequences are\n           : tiled independently.\n           : \n           :    -- If only query sequence HSPs overlap, \n           :          this may suggest multiple domains in the sbjct.\n           :    -- If only sbjct sequence HSPs overlap, \n           :          this may suggest multiple domains in the query.\n           :    -- If both query & sbjct sequence HSPs overlap, \n           :          this suggests multiple domains in both.\n           :    -- If neither query & sbjct sequence HSPs overlap, \n           :          this suggests either no multiple domains in either\n           :          sequence OR that both sequences have the same\n           :          distribution of multiple similar domains.\n           : \n           : This method can deal with the special case of when multiple\n           : HSPs exactly overlap.\n           : \n           : Efficiency concerns:\n           :  Speed will be an issue for sequences with numerous HSPs.\n           : \n Bugs      : Currently, tile_hsps() does not properly account for\n           : the number of non-tiled but overlapping HSPs, which becomes a problem\n           : as overlap() grows. Large values overlap() may thus lead to \n           : incorrect statistics for some hits. For best results, keep overlap()\n           : below 5 (DEFAULT IS 2). For more about this, see the \"HSP Tiling and\n           : Ambiguous Alignments\" section in L<Bio::Search::Hit::GenericHit>.\n\nSee Also   : L<_adjust_contigs>(), L<Bio::Search::Hit::GenericHit|Bio::Search::Hit::GenericHit>\n\n\n#--------------\nsub tile_hsps {\n#--------------\n    my $sbjct = shift;\n\n    #print STDERR \"Calling tile_hsps(): $sbjct\\n\";\n    #$sbjct->verbose(1);  # to activate debugging\n    $sbjct->tiled_hsps(1);\n\n    if( $sbjct->num_hsps == 0 || $sbjct->n == 0 ) { \t\t\n\t#print STDERR \"_tile_hsps(): no hsps, nothing to tile! (\", $sbjct->num_hsps, \")\\n\";\n        _warn_about_no_hsps($sbjct);\n        return (undef, undef);\n\n    } elsif( $sbjct->n == 1 or $sbjct->num_hsps == 1) {\n        ## Simple summation scheme. Valid if there is only one HSP.\n\t#print STDERR \"_tile_hsps(): single HSP, easy stats.\\n\";\n\tmy $hsp = $sbjct->hsp;\n\t$sbjct->length_aln('query', $hsp->length('query'));\n\t$sbjct->length_aln('hit', $hsp->length('sbjct'));\n\t$sbjct->length_aln('total', $hsp->length('total'));\n\t$sbjct->matches( $hsp->matches() );\n\t$sbjct->gaps('query', $hsp->gaps('query'));\n\t$sbjct->gaps('sbjct', $hsp->gaps('sbjct'));\n\n        _adjust_length_aln($sbjct);\n\treturn (1, 1);\n    } else {\n\t#print STDERR \"Sbjct: _tile_hsps: summing multiple HSPs\\n\";\n\t$sbjct->length_aln('query', 0);\n\t$sbjct->length_aln('sbjct', 0);\n\t$sbjct->length_aln('total', 0); \n \t$sbjct->matches( 0, 0);\n        $sbjct->gaps('query', 0);\n        $sbjct->gaps('hit', 0);\n    }\n\n    ## More than one HSP. Must tile HSPs.\n#    print \"\\nTiling HSPs for $sbjct\\n\";\n    my($hsp, $qstart, $qstop, $sstart, $sstop);\n    my($frame, $strand, $qstrand, $sstrand);\n    my(@qcontigs, @scontigs);\n    my $qoverlap = 0;\n    my $soverlap = 0;\n    my $max_overlap = $sbjct->overlap;\n    my $hit_qgaps = 0;\n    my $hit_sgaps = 0;\n    my $hit_len_aln = 0;\n    my %start_stop;\n    my $v = $sbjct->verbose;\n    foreach $hsp ( $sbjct->hsps() ) {\n\t#$sbjct->debug( sprintf(\"  HSP: %s %d..%d\\n\",$hsp->query->seq_id, $hsp->query->start, $hsp->hit->end)) if $v > 0; #$hsp->str('query');\n#\tprintf \"  Length = %d; Identical = %d; Conserved = %d; Conserved(1-10): %d\",$hsp->length, $hsp->length(-TYPE=>'iden'), \n#\t$hsp->length(-TYPE=>'cons'),\n#\t$hsp->length(-TYPE=>'cons',\n#\t\t     -START=>0,-STOP=>10); \n\n\t($qstart, $qstop) = $hsp->range('query');\n\t($sstart, $sstop) = $hsp->range('sbjct');\n\t$frame = $hsp->frame('hit');\n\t$frame = -1 unless defined $frame;\n\t\n\t($qstrand, $sstrand) = ($hsp->query->strand,\n\t\t\t\t$hsp->hit->strand);\n\n        # Note: No correction for overlap.\n\t\n\tmy ($qgaps, $sgaps)  = ($hsp->gaps('query'), $hsp->gaps('hit'));\n\t$hit_qgaps += $qgaps;\n\t$hit_sgaps += $sgaps;\n\t$hit_len_aln += $hsp->length;\n\n\t## Collect contigs in the query sequence.\n \t$qoverlap += &_adjust_contigs('query', $hsp, $qstart, $qstop, \n\t\t\t\t     \\@qcontigs, $max_overlap, $frame, \n\t\t\t\t     $qstrand);\n\n\t## Collect contigs in the sbjct sequence \n\t#  (needed for domain data and gapped Blast).\n\t$soverlap += &_adjust_contigs('sbjct', $hsp, $sstart, $sstop, \n\t\t\t\t     \\@scontigs, $max_overlap, $frame, \n\t\t\t\t     $sstrand);\n\n\t## Collect overall start and stop data for query and \n\t#  sbjct over all HSPs.\n\tunless ( defined $start_stop{'qstart'} ) {\n            $start_stop{'qstart'}  = $qstart;\n            $start_stop{'qstop'}   = $qstop;\n            $start_stop{'sstart'}  = $sstart;\n            $start_stop{'sstop'}   = $sstop;\n\t} else {\n\t    $start_stop{'qstart'} = ($qstart < $start_stop{'qstart'} ? \n\t\t\t\t     $qstart : $start_stop{'qstart'} );\n\t    $start_stop{'qstop'}  = ($qstop  > $start_stop{'qstop'} ? \n\t\t\t\t     $qstop  : $start_stop{'qstop'} );\n\t    $start_stop{'sstart'} = ($sstart < $start_stop{'sstart'} ? \n\t\t\t\t     $sstart : $start_stop{'sstart'} );\n\t    $start_stop{'sstop'}  = ($sstop  > $start_stop{'sstop'} ? \n\t\t\t\t     $sstop  : $start_stop{'sstop'} );\n\t}\t    \n    }\n\n    # Store the collected data in the Hit object\n    $sbjct->gaps('query', $hit_qgaps);\n    $sbjct->gaps('hit', $hit_sgaps);\n    $sbjct->length_aln('total', $hit_len_aln);\n    \n    $sbjct->start('query',$start_stop{'qstart'});\n    $sbjct->end('query', $start_stop{'qstop'});\n    $sbjct->start('hit', $start_stop{'sstart'});\n    $sbjct->end('hit', $start_stop{'sstop'});\n    ## Collect data across the collected contigs.\n\n    #$sbjct->debug( \"\\nQUERY CONTIGS:\\n\".\"  gaps = $sbjct->{'_gaps_query'}\\n\");\n\n    # Account for strand/frame.\n    # Strategy: collect data on a per strand+frame basis and \n    #           save the most significant one.\n    my (%qctg_dat);\n    foreach (@qcontigs) {\n        ($frame, $strand) = ($_->{'frame'}, $_->{'strand'});\n        \n        if( $v > 0 ) {\n            #$sbjct->debug(sprintf( \"$frame/$strand len is getting %d for %d..%d\\n\", \n            #\t\t\t   ($_->{'stop'} - $_->{'start'} + 1), $_->{'start'}, $_->{'stop'}));\n        }\n        \n        $qctg_dat{ \"$frame$strand\" }->{'length_aln_query'} += $_->{'stop'} - $_->{'start'} + 1;\n        $qctg_dat{ \"$frame$strand\" }->{'totalIdentical'}   += $_->{'iden'};\n        $qctg_dat{ \"$frame$strand\" }->{'totalConserved'}   += $_->{'cons'};\n        $qctg_dat{ \"$frame$strand\" }->{'qstrand'}   = $strand;\n    }\n\n    # Find longest contig.\n    my @sortedkeys = sort { $qctg_dat{$b}->{'length_aln_query'} \n\t\t\t    <=> $qctg_dat{$a}->{'length_aln_query'} }\n    keys %qctg_dat;\n\n    # Save the largest to the sbjct:\n    my $longest = $sortedkeys[0];\n    #$sbjct->debug( \"longest is \". $qctg_dat{ $longest }->{'length_aln_query'}. \"\\n\");\n    $sbjct->length_aln('query', $qctg_dat{ $longest }->{'length_aln_query'});\n    $sbjct->matches($qctg_dat{ $longest }->{'totalIdentical'},\n                    $qctg_dat{ $longest }->{'totalConserved'});\n    $sbjct->strand('query', $qctg_dat{ $longest }->{'qstrand'});\n\n    ## Collect data for sbjct contigs. Important for gapped Blast.\n    ## The totalIdentical and totalConserved numbers will be the same\n    ## as determined for the query contigs.\n\n    #$sbjct->debug( \"\\nSBJCT CONTIGS:\\n\".\"  gaps = \". $sbjct->gaps('sbjct'). \"\\n\");\n    my (%sctg_dat);\n    foreach(@scontigs) {\n\t#$sbjct->debug(\"  sbjct contig: $_->{'start'} - $_->{'stop'}\\n\".\n\t#\t     \"         iden = $_->{'iden'}; cons = $_->{'cons'}\\n\");\n\t($frame, $strand) = ($_->{'frame'}, $_->{'strand'});\n\t$sctg_dat{ \"$frame$strand\" }->{'length_aln_sbjct'}   += $_->{'stop'} - $_->{'start'} + 1;\n\t$sctg_dat{ \"$frame$strand\" }->{'frame'}  = $frame;\n\t$sctg_dat{ \"$frame$strand\" }->{'sstrand'}  = $strand;\n    }\n    \n    @sortedkeys = sort { $sctg_dat{ $b }->{'length_aln_sbjct'} \n\t\t\t <=> $sctg_dat{ $a }->{'length_aln_sbjct'} \n\t\t     } keys %sctg_dat;\n\n    # Save the largest to the sbjct:\n    $longest = $sortedkeys[0];\n\n    $sbjct->length_aln('sbjct', $sctg_dat{ $longest }->{'length_aln_sbjct'});\n    $sbjct->frame( $sctg_dat{ $longest }->{'frame'} );\n    $sbjct->strand('hit', $sctg_dat{ $longest }->{'sstrand'});\n\n    if($qoverlap) {\n\tif($soverlap) { $sbjct->ambiguous_aln('qs'); \n\t\t\t#$sbjct->debug(\"\\n*** AMBIGUOUS ALIGNMENT: Query and Sbjct\\n\\n\");\n\t\t    }\n\telse { $sbjct->ambiguous_aln('q');\n\t       #$sbjct->debug( \"\\n*** AMBIGUOUS ALIGNMENT: Query\\n\\n\");\n\t   }\n    } elsif($soverlap) { \n\t$sbjct->ambiguous_aln('s'); \n\t#$sbjct->debug( \"\\n*** AMBIGUOUS ALIGNMENT: Sbjct\\n\\n\");\n    }\n\n    _adjust_length_aln($sbjct);\n\n    return ( [@qcontigs], [@scontigs] );\n}\n\n\n\n# Title    : _adjust_length_aln  \n# Usage    : n/a; internal use only; called by tile_hsps.\n# Purpose  : Adjust length of aligment based on BLAST flavor.\n# Comments : See comments in logica_length()\nsub _adjust_length_aln {\n    my $sbjct = shift;\n    my $algo = $sbjct->algorithm;\n    my $hlen = $sbjct->length_aln('sbjct');\n    my $qlen = $sbjct->length_aln('query');\n\n    $sbjct->length_aln('sbjct', logical_length($algo, 'sbjct', $hlen));\n    $sbjct->length_aln('query', logical_length($algo, 'query', $qlen));\n}\n\n=head2 logical_length\n\n Usage     : logical_length( $alg_name, $seq_type, $length );\n Purpose   : Determine the logical length of an aligned sequence based on \n           : algorithm name and sequence type.\n Returns   : integer representing the logical aligned length.\n Argument  : $alg_name = name of algorigthm (e.g., blastx, tblastn)\n           : $seq_type = type of sequence (e.g., query or hit)\n           : $length = physical length of the sequence in the alignment.\n Throws    : n/a\n Comments  : This function is used to account for the fact that number of identities \n             and conserved residues is reported in peptide space while the query \n             length (in the case of BLASTX and TBLASTX) and/or the hit length \n             (in the case of TBLASTN and TBLASTX) are in nucleotide space.\n             The adjustment affects the values reported by the various frac_XXX \n             methods in GenericHit and GenericHSP.\n\n\nsub logical_length {\n    my ($algo, $type, $len) = @_;\n    my $logical = $len;\n    if($algo =~ /^(?:PSI)?T(?:BLASTN|FAST(?:X|Y|XY))/oi ) {\n        $logical = $len/3 if $type =~ /sbjct|hit|tot/i;\n    } elsif($algo =~ /^(?:BLASTX|FAST(?:X|Y|XY))/oi ) {\n        $logical = $len/3 if $type =~ /query|tot/i;\n    } elsif($algo =~ /^TBLASTX/oi ) {\n        $logical = $len/3;\n    }\n    return $logical;\n}\n\n\n#=head2 _adjust_contigs\n#\n# Usage     : n/a; internal function called by tile_hsps\n# Purpose   : Builds HSP contigs for a given BLAST hit.\n#           : Utility method called by _tile_hsps()\n# Returns   : \n# Argument  : \n# Throws    : Exceptions propagated from Bio::Search::Hit::BlastHSP::matches()\n#           : for invalid sub-sequence ranges.\n# Status    : Experimental\n# Comments  : This method supports gapped alignments through a patch by maj\n#           : to B:S:HSP:HSPI::matches().\n#           : It does not keep track of the number of HSPs that\n#           : overlap within the amount specified by overlap().\n#           : This will lead to significant tracking errors for large\n#           : overlap values.\n#\n#See Also   : L<tile_hsps>(), L<Bio::Search::Hit::BlastHSP::matches|Bio::Search::Hit::BlastHSP>\n#\n#=cut\n\nsub _adjust_contigs {\n    my ($seqType, $hsp, $start, $stop, $contigs_ref, \n\t$max_overlap, $frame, $strand) = @_;\n    my $overlap = 0;\n    my ($numID, $numCons);\n    \n    foreach (@$contigs_ref) {\n        # Don't merge things unless they have matching strand/frame.\n        next unless ($_->{'frame'} == $frame && $_->{'strand'} == $strand);\n        \n        # Test special case of a nested HSP. Skip it.\n        if ($start >= $_->{'start'} && $stop <= $_->{'stop'}) {\n            $overlap = 1; \n            next;\n        }\n        \n        # Test for overlap at beginning of contig, or precedes consecutively\n        if ($start < $_->{'start'} && $stop >= ($_->{'start'} + $max_overlap - 1)) {\n            eval {\n                ($numID, $numCons) = $hsp->matches(-SEQ   =>$seqType, \n                               -START => $start, \n                               -STOP  => $_->{'start'} - 1); \n\t\tif ($numID eq '') {\n\t\t    $hsp->warn(\"\\$hsp->matches() returned '' for number identical; setting to 0\");\n\t\t    $numID = 0;\n\t\t}\n\t\tif ($numCons eq '') {\n\t\t    $hsp->warn(\"\\$hsp->matches() returned '' for number conserved; setting to 0\");\n\t\t    $numCons = 0;\n\t\t}\n            };\n            if($@) { warn \"\\a\\n$@\\n\"; }\n            else {\n                $_->{'start'} = $start;\t# Assign a new start coordinate to the contig\n                $_->{'iden'} += $numID;\t# and add new data to #identical, #conserved.\n                $_->{'cons'} += $numCons;\n                push(@{$_->{hsps}}, $hsp);\n                $overlap     = 1; \n            }\n        }\n        \n        # Test for overlap at end of contig, or follows consecutively\n        if ($stop > $_->{'stop'} and $start <= ($_->{'stop'} - $max_overlap + 1)) {\n            eval {\n                ($numID,$numCons) = $hsp->matches(-SEQ   =>$seqType, \n                              -START => $_->{'stop'} + 1, \n                              -STOP  => $stop); \n\t\tif ($numID eq '') {\n\t\t    $hsp->warn(\"\\$hsp->matches() returned '' for number identical; setting to 0\");\n\t\t    $numID = 0;\n\t\t}\n\t\tif ($numCons eq '') {\n\t\t    $hsp->warn(\"\\$hsp->matches() returned '' for number conserved; setting to 0\");\n\t\t    $numCons = 0;\n\t\t}\n\t    };\n            if($@) { warn \"\\a\\n$@\\n\"; }\n            else {\n                $_->{'stop'}  = $stop; # Assign a new stop coordinate to the contig\n                $_->{'iden'} += $numID;\t# and add new data to #identical, #conserved.\n                $_->{'cons'} += $numCons;\n                push(@{$_->{hsps}}, $hsp);\n                $overlap    = 1; \n            }\n        }\n        \n        last if $overlap;\n    }\n    \n    if ($overlap && @$contigs_ref > 1) {\n        ## Merge any contigs that now overlap\n        my $max = $#{$contigs_ref};\n        for my $i (0..$max) {\n            ${$contigs_ref}[$i] || next;\n            my ($i_start, $i_stop) = (${$contigs_ref}[$i]->{start}, ${$contigs_ref}[$i]->{stop});\n            \n            for my $u ($i+1..$max) {\n                ${$contigs_ref}[$u] || next;\n                my ($u_start, $u_stop) = (${$contigs_ref}[$u]->{start}, ${$contigs_ref}[$u]->{stop});\n                \n                if ($u_start < $i_start && $u_stop >= ($i_start + $max_overlap - 1)) {\n                    # find the hsps within the contig that have sequence\n                    # extending before $i_start\n                    my ($ids, $cons) = (0, 0);\n                    my $use_start = $i_start;\n                    foreach my $hsp (sort { $b->end($seqType) <=> $a->end($seqType) } @{${$contigs_ref}[$u]->{hsps}}) {\n                        my $hsp_start = $hsp->start($seqType);\n                        $hsp_start < $use_start || next;\n                        \n                        my ($these_ids, $these_cons);\n                        eval {\n                            ($these_ids, $these_cons) = $hsp->matches(-SEQ => $seqType, -START => $hsp_start, -STOP => $use_start - 1);\n\t\t\t    if ($these_ids eq '') {\n\t\t\t\t$hsp->warn(\"\\$hsp->matches() returned '' for number identical; setting to 0\");\n\t\t\t\t$these_ids = 0;\n\t\t\t    }\n\t\t\t    if ($these_cons eq '') {\n\t\t\t\t$hsp->warn(\"\\$hsp->matches() returned '' for number conserved; setting to 0\");\n\t\t\t\t$these_cons = 0;\n\t\t\t    }\n\t\t\t};\n                        if($@) { warn \"\\a\\n$@\\n\"; }\n                        else {\n                            $ids  += $these_ids;\n                            $cons += $these_cons;\n                        }\n                        \n                        last if $hsp_start == $u_start;\n                        $use_start = $hsp_start;\n                    }\n                    ${$contigs_ref}[$i]->{start} = $u_start;\n                    ${$contigs_ref}[$i]->{'iden'} += $ids;\n                    ${$contigs_ref}[$i]->{'cons'} += $cons;\n                    push(@{${$contigs_ref}[$i]->{hsps}}, @{${$contigs_ref}[$u]->{hsps}});\n                    \n                    ${$contigs_ref}[$u] = undef;\n                }\n                elsif ($u_stop > $i_stop && $u_start <= ($i_stop - $max_overlap + 1)) {\n                    # find the hsps within the contig that have sequence\n                    # extending beyond $i_stop\n                    my ($ids, $cons) = (0, 0);\n                    my $use_stop = $i_stop;\n                    foreach my $hsp (sort { $a->start($seqType) <=> $b->start($seqType) } @{${$contigs_ref}[$u]->{hsps}}) {\n                        my $hsp_end = $hsp->end($seqType);\n                        $hsp_end > $use_stop || next;\n                        \n                        my ($these_ids, $these_cons);\n                        eval {\n                            ($these_ids, $these_cons) = $hsp->matches(-SEQ => $seqType, -START => $use_stop + 1, -STOP => $hsp_end);\n\t\t\t    if ($these_ids eq '') {\n\t\t\t\t$hsp->warn(\"\\$hsp->matches() returned '' for number identical; setting to 0\");\n\t\t\t\t$these_ids = 0;\n\t\t\t    }\n\t\t\t    if ($these_cons eq '') {\n\t\t\t\t$hsp->warn(\"\\$hsp->matches() returned '' for number conserved; setting to 0\");\n\t\t\t\t$these_cons = 0;\n\t\t\t    }\n                        };\n                        if($@) { warn \"\\a\\n$@\\n\"; }\n                        else {\n                            $ids  += $these_ids;\n                            $cons += $these_cons;\n                        }\n                        \n                        last if $hsp_end == $u_stop;\n                        $use_stop = $hsp_end;\n                    }\n                    ${$contigs_ref}[$i]->{'stop'}  = $u_stop;\n                    ${$contigs_ref}[$i]->{'iden'} += $ids;\n                    ${$contigs_ref}[$i]->{'cons'} += $cons;\n                    push(@{${$contigs_ref}[$i]->{hsps}}, @{${$contigs_ref}[$u]->{hsps}});\n                    \n                    ${$contigs_ref}[$u] = undef;\n                }\n                elsif ($u_start >= $i_start && $u_stop <= $i_stop) {\n                    # nested, drop this contig\n                    #*** ideally we might do some magic to keep the stats of the\n                    #    better hsp...\n                    ${$contigs_ref}[$u] = undef;\n                }\n            }\n        }\n        \n        my @merged;\n        foreach (@$contigs_ref) {\n            push(@merged, $_ || next);\n        }\n        @{$contigs_ref} = @merged;\n    }\n    elsif (! $overlap) {\n        ## If there is no overlap, add the complete HSP data.\n        ($numID,$numCons) = $hsp->matches(-SEQ=>$seqType);\n\tif ($numID eq '') {\n\t    $hsp->warn(\"\\$hsp->matches() returned '' for number identical; setting to 0\");\n\t    $numID = 0;\n\t}\n\tif ($numCons eq '') {\n\t    $hsp->warn(\"\\$hsp->matches() returned '' for number conserved; setting to 0\");\n\t    $numCons = 0;\n\t}\n\n        push @$contigs_ref, {'start' =>$start, 'stop' =>$stop,\n\t\t\t     'iden'  =>$numID, 'cons' =>$numCons,\n\t\t\t     'strand'=>$strand,'frame'=>$frame,'hsps'=>[$hsp]};\n    }\n    \n    return $overlap;\n}\n\n=head2 get_exponent\n\n Usage     : &get_exponent( number );\n Purpose   : Determines the power of 10 exponent of an integer, float, \n           : or scientific notation number.\n Example   : &get_exponent(\"4.0e-206\");\n           : &get_exponent(\"0.00032\");\n           : &get_exponent(\"10.\");\n           : &get_exponent(\"1000.0\");\n           : &get_exponent(\"e+83\");\n Argument  : Float, Integer, or scientific notation number\n Returns   : Integer representing the exponent part of the number (+ or -).\n           : If argument == 0 (zero), return value is \"-999\".\n Comments  : Exponents are rounded up (less negative) if the mantissa is >= 5.\n           : Exponents are rounded down (more negative) if the mantissa is <= -5.\n\n\nsub get_exponent {\n    my $data = shift;\n\n    my($num, $exp) = split /[eE]/, $data;\n\n    if( defined $exp) { \n\t$num = 1 if not $num;\n\t$num >= 5 and $exp++;\n\t$num <= -5 and $exp--;\n    } elsif( $num == 0) {\n\t$exp = -999;\n    } elsif( not $num =~ /\\./) {\n\t$exp = CORE::length($num) -1;\n    } else {\n\t$exp = 0;\n\t$num .= '0' if $num =~ /\\.$/;\n\tmy ($c);\n\tmy $rev = 0;\n\tif($num !~ /^0/) {\n\t    $num = reverse($num);\n\t    $rev = 1;\n\t}\n\tdo { $c = chop($num);\n\t     $c == 0 && $exp++; \n\t } while( $c ne '.');\n\n\t$exp = -$exp if $num == 0 and not $rev;\n\t$exp -= 1 if $rev;\n    }\n    return $exp;\n}\n\n=head2 collapse_nums\n\n Usage     : @cnums = collapse_nums( @numbers );\n Purpose   : Collapses a list of numbers into a set of ranges of consecutive terms:\n           : Useful for condensing long lists of consecutive numbers.\n           :  EXPANDED:\n           :     1 2 3 4 5 6 10 12 13 14 15 17 18 20 21 22 24 26 30 31 32\n           :  COLLAPSED:\n           :     1-6 10 12-15 17 18 20-22 24 26 30-32\n Argument  : List of numbers sorted numerically.\n Returns   : List of numbers mixed with ranges of numbers (see above).\n Throws    : n/a\n\nSee Also   : L<Bio::Search::Hit::BlastHit::seq_inds()|Bio::Search::Hit::BlastHit>\n\n\nsub collapse_nums {\n# This is probably not the slickest connectivity algorithm, but will do for now.\n    my @a = @_;\n    my ($from, $to, $i, @ca, $consec);\n    \n    $consec = 0;\n    for($i=0; $i < @a; $i++) {\n\tnot $from and do{ $from = $a[$i]; next; };\n    # pass repeated positions (gap inserts)\n    next if $a[$i] == $a[$i-1];\n\tif($a[$i] == $a[$i-1]+1) {\n\t    $to = $a[$i];\n\t    $consec++;\n\t} else {\n\t    if($consec == 1) { $from .= \",$to\"; }\n\t    else { $from .= $consec>1 ? \"\\-$to\" : \"\"; }\n\t    push @ca, split(',', $from);\n\t    $from =  $a[$i];\n\t    $consec = 0;\n\t    $to = undef;\n\t}\n    }\n    if(defined $to) {\n\tif($consec == 1) { $from .= \",$to\"; }\n\telse { $from .= $consec>1 ? \"\\-$to\" : \"\"; }\n    }\n    push @ca, split(',', $from) if $from;\n\n    @ca;\n}\n\n\n=head2 strip_blast_html\n\n Usage     : $boolean = &strip_blast_html( string_ref );\n           : This method is exported.\n Purpose   : Removes HTML formatting from a supplied string.\n           : Attempts to restore the Blast report to enable\n           : parsing by Bio::SearchIO::blast.pm\n Returns   : Boolean: true if string was stripped, false if not.\n Argument  : string_ref = reference to a string containing the whole Blast\n           :              report containing HTML formatting.\n Throws    : Croaks if the argument is not a scalar reference.\n Comments  : Based on code originally written by Alex Dong Li\n           : (ali@genet.sickkids.on.ca).\n           : This method does some Blast-specific stripping \n           : (adds back a '>' character in front of each HSP \n           : alignment listing).\n           :   \n           : THIS METHOD IS VERY SENSITIVE TO BLAST FORMATTING CHANGES!\n           :\n           : Removal of the HTML tags and accurate reconstitution of the\n           : non-HTML-formatted report is highly dependent on structure of\n           : the HTML-formatted version. For example, it assumes that first \n           : line of each alignment section (HSP listing) starts with a\n           : <a name=..> anchor tag. This permits the reconstruction of the \n           : original report in which these lines begin with a \">\".\n           : This is required for parsing.\n           :\n           : If the structure of the Blast report itself is not intended to\n           : be a standard, the structure of the HTML-formatted version\n           : is even less so. Therefore, the use of this method to\n           : reconstitute parsable Blast reports from HTML-format versions\n           : should be considered a temorary solution.\n\n\nsub strip_blast_html {\n      # This may not best way to remove html tags. However, it is simple.\n      # it won't work under following conditions:\n      #    1) if quoted > appears in a tag  (does this ever happen?)\n      #    2) if a tag is split over multiple lines and this method is\n      #       used to process one line at a time.\n      \n    my ($string_ref) = shift;\n\n    ref $string_ref eq 'SCALAR' or \n\tcroak (\"Can't strip HTML: \".\n\t       \"Argument is should be a SCALAR reference not a ${\\ref $string_ref}\\n\");\n\n    my $str = $$string_ref;\n    my $stripped = 0;\n\n    # Removing \"<a name =...>\" and adding the '>' character for \n    # HSP alignment listings.\n    $str =~ s/(\\A|\\n)<a name ?=[^>]+> ?/>/sgi and $stripped = 1;\n\n    # Removing all \"<>\" tags. \n    $str =~ s/<[^>]+>|&nbsp//sgi and $stripped = 1;\n\n    # Re-uniting any lone '>' characters.\n    $str =~ s/(\\A|\\n)>\\s+/\\n\\n>/sgi and $stripped = 1;\n\n    $$string_ref = $str;\n    $stripped;\n}\n\n=head2 result2hash\n\n Title    : result2hash\n Usage    : my %data = &Bio::Search::SearchUtils($result)\n Function : converts ResultI data to simple hash\n Returns  : hash\n Args     : ResultI\n Note     : used mainly as a utility for running SearchIO tests","parameters":[{"label":"$result"}]},"kind":12,"line":749,"children":[{"line":750,"kind":13,"localvar":"my","containerName":"result2hash","name":"$result","definition":"my"},{"localvar":"my","definition":"my","name":"%hash","containerName":"result2hash","line":751,"kind":13},{"name":"$hash","containerName":"result2hash","line":752,"kind":13},{"line":752,"kind":13,"containerName":"result2hash","name":"$result"},{"containerName":"result2hash","name":"query_name","line":752,"kind":12},{"containerName":"result2hash","name":"$hitcount","definition":"my","localvar":"my","kind":13,"line":753},{"kind":13,"line":754,"containerName":"result2hash","name":"$hspcount","definition":"my","localvar":"my"},{"localvar":"my","definition":"my","name":"$hit","containerName":"result2hash","line":755,"kind":13},{"name":"$result","containerName":"result2hash","line":755,"kind":13},{"line":755,"kind":12,"name":"hits","containerName":"result2hash"},{"name":"$hash","containerName":"result2hash","line":756,"kind":13},{"name":"$hit","containerName":"result2hash","kind":13,"line":756},{"containerName":"result2hash","name":"name","kind":12,"line":756},{"line":761,"kind":13,"name":"$hash","containerName":"result2hash"},{"line":761,"kind":13,"containerName":"result2hash","name":"$hit"},{"line":761,"kind":12,"containerName":"result2hash","name":"bits"},{"localvar":"my","containerName":"result2hash","name":"$hsp","definition":"my","line":763,"kind":13},{"containerName":"result2hash","name":"$hit","kind":13,"line":763},{"containerName":"result2hash","name":"hsps","kind":12,"line":763},{"kind":13,"line":764,"name":"$hash","containerName":"result2hash"},{"name":"$hsp","containerName":"result2hash","line":764,"kind":13},{"kind":12,"line":764,"name":"bits","containerName":"result2hash"},{"kind":13,"line":769,"name":"$hash","containerName":"result2hash"},{"kind":13,"line":769,"containerName":"result2hash","name":"$hsp"},{"containerName":"result2hash","name":"query","line":769,"kind":12},{"name":"start","containerName":"result2hash","kind":12,"line":769},{"line":770,"kind":13,"containerName":"result2hash","name":"$hash"},{"containerName":"result2hash","name":"$hsp","line":770,"kind":13},{"line":770,"kind":12,"name":"query","containerName":"result2hash"},{"containerName":"result2hash","name":"end","kind":12,"line":770},{"line":771,"kind":13,"containerName":"result2hash","name":"$hash"},{"kind":13,"line":771,"containerName":"result2hash","name":"$hsp"},{"name":"query","containerName":"result2hash","kind":12,"line":771},{"containerName":"result2hash","name":"strand","line":771,"kind":12},{"kind":13,"line":772,"name":"$hash","containerName":"result2hash"},{"name":"$hsp","containerName":"result2hash","kind":13,"line":772},{"kind":12,"line":772,"name":"hit","containerName":"result2hash"},{"name":"start","containerName":"result2hash","line":772,"kind":12},{"containerName":"result2hash","name":"$hash","line":773,"kind":13},{"kind":13,"line":773,"containerName":"result2hash","name":"$hsp"},{"name":"hit","containerName":"result2hash","line":773,"kind":12},{"line":773,"kind":12,"name":"end","containerName":"result2hash"},{"name":"$hash","containerName":"result2hash","kind":13,"line":774},{"line":774,"kind":13,"name":"$hsp","containerName":"result2hash"},{"name":"hit","containerName":"result2hash","line":774,"kind":12},{"kind":12,"line":774,"containerName":"result2hash","name":"strand"},{"name":"$hash","containerName":"result2hash","line":778,"kind":13},{"containerName":"result2hash","name":"$hsp","line":778,"kind":13},{"line":778,"kind":12,"containerName":"result2hash","name":"gaps"},{"name":"$hspcount","containerName":"result2hash","line":779,"kind":13},{"containerName":"result2hash","name":"$hitcount","line":781,"kind":13},{"line":783,"kind":13,"containerName":"result2hash","name":"%hash"}]},{"containerName":"main::","definition":"sub","name":"_warn_about_no_hsps","range":{"start":{"character":0,"line":786},"end":{"character":9999,"line":799}},"kind":12,"line":786,"children":[{"containerName":"_warn_about_no_hsps","definition":"my","name":"$hit","localvar":"my","kind":13,"line":787},{"kind":13,"line":788,"containerName":"_warn_about_no_hsps","name":"$prev_func","definition":"my","localvar":"my"},{"line":789,"kind":13,"name":"$hit","containerName":"_warn_about_no_hsps"},{"name":"warn","containerName":"_warn_about_no_hsps","line":789,"kind":12},{"line":789,"kind":13,"name":"$hit","containerName":"_warn_about_no_hsps"},{"line":789,"kind":12,"containerName":"_warn_about_no_hsps","name":"name"}]}],"version":5}