{"vars":[{"line":96,"kind":2,"name":"base","containerName":""},{"range":{"end":{"character":9999,"line":132},"start":{"character":0,"line":112}},"name":"new","line":112,"children":[{"localvar":"my","name":"$class","definition":"my","containerName":"new","line":113,"kind":13},{"line":113,"kind":13,"containerName":"new","name":"@args"},{"localvar":"my","containerName":"new","name":"$self","definition":"my","line":115,"kind":13},{"kind":13,"line":115,"name":"$class","containerName":"new"},{"line":115,"kind":13,"name":"@args","containerName":"new"},{"kind":13,"line":117,"containerName":"new","name":"$self"},{"containerName":"new","name":"$self","kind":13,"line":118},{"kind":13,"line":119,"containerName":"new","name":"$self"},{"kind":13,"line":121,"name":"$iters","definition":"my","containerName":"new","localvar":"my"},{"line":121,"kind":13,"containerName":"new","name":"$ithresh"},{"name":"$self","containerName":"new","kind":13,"line":121},{"kind":12,"line":121,"name":"_rearrange","containerName":"new"},{"line":122,"kind":13,"name":"@args","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":124},{"containerName":"new","name":"$ithresh","line":124,"kind":13},{"containerName":"new","name":"$iters","line":126,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":127},{"name":"throw","containerName":"new","kind":12,"line":127},{"containerName":"new","name":"$iters","kind":13,"line":127},{"definition":"my","name":"$i","containerName":"new","localvar":"my","kind":13,"line":129},{"containerName":"new","name":"$iters","line":129,"kind":13},{"name":"$self","containerName":"new","line":130,"kind":13},{"containerName":"new","name":"add_iteration","line":130,"kind":12},{"kind":13,"line":130,"name":"$i","containerName":"new"}],"kind":12,"detail":"($class,@args)","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: BlastResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::BlastResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::BlastResult - Blast-specific subclass of Bio::Search::Result::GenericResult\n\n=head1 SYNOPSIS\n\n    # Working with iterations (PSI-BLAST results)\n\n    $result->next_iteration();\n    $result->num_iterations();\n    $result->iteration();\n    $result->iterations();\n\n# See Bio::Search::Result::GenericResult for information about working with Results.\n\n# See L<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>\n# for details about working with iterations.\n\n# TODO:\n#     * Show how to configure a SearchIO stream so that it generates\n#       BlastResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is a subclass of Bio::Search::Result::GenericResult\nand provides some operations that facilitate working with BLAST\nand PSI-BLAST results.\n\nFor general information about working with Results, see \nBio::Search::Result::GenericResult.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::BlastResult;\nuse strict;\n\nuse Bio::Search::BlastStatistics;\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::BlastResult->new();\n Function: Builds a new Bio::Search::Result::BlastResult object\n Returns : Bio::Search::Result::BlastResult\n Args    : See Bio::Search::Result::GenericResult();\n           The following parameters are specific to BlastResult:\n             -iterations  => array ref of Bio::Search::Iteration::IterationI objects\n             -inclusion_threshold => e-value threshold for inclusion in the\n                                     PSI-BLAST score matrix model (blastpgp)","label":"new($class,@args)"},"containerName":"main::","definition":"sub"},{"name":"SUPER","containerName":"new","line":115,"kind":12},{"kind":13,"line":136,"containerName":null,"name":"%self"},{"containerName":null,"name":"$self","line":139,"kind":13},{"range":{"end":{"character":9999,"line":171},"start":{"line":161,"character":0}},"containerName":"main::","definition":"sub","name":"hits","line":161,"children":[{"kind":13,"line":162,"definition":"my","name":"$self","containerName":"hits","localvar":"my"},{"kind":13,"line":163,"containerName":"hits","name":"$self"},{"kind":13,"line":164,"name":"$self","containerName":"hits"},{"name":"@hits","definition":"my","containerName":"hits","localvar":"my","kind":13,"line":166},{"line":167,"kind":13,"localvar":"my","containerName":"hits","name":"$it","definition":"my"},{"kind":13,"line":167,"containerName":"hits","name":"$self"},{"line":167,"kind":12,"name":"iterations","containerName":"hits"},{"kind":13,"line":168,"name":"@hits","containerName":"hits"},{"kind":13,"line":168,"containerName":"hits","name":"$it"},{"containerName":"hits","name":"hits","line":168,"kind":12},{"kind":13,"line":170,"name":"@hits","containerName":"hits"}],"kind":12},{"name":"SUPER","containerName":"hits","line":166,"kind":12},{"name":"next_hit","range":{"start":{"line":193,"character":0},"end":{"character":9999,"line":206}},"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: BlastResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::BlastResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::BlastResult - Blast-specific subclass of Bio::Search::Result::GenericResult\n\n=head1 SYNOPSIS\n\n    # Working with iterations (PSI-BLAST results)\n\n    $result->next_iteration();\n    $result->num_iterations();\n    $result->iteration();\n    $result->iterations();\n\n# See Bio::Search::Result::GenericResult for information about working with Results.\n\n# See L<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>\n# for details about working with iterations.\n\n# TODO:\n#     * Show how to configure a SearchIO stream so that it generates\n#       BlastResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is a subclass of Bio::Search::Result::GenericResult\nand provides some operations that facilitate working with BLAST\nand PSI-BLAST results.\n\nFor general information about working with Results, see \nBio::Search::Result::GenericResult.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::BlastResult;\nuse strict;\n\nuse Bio::Search::BlastStatistics;\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::BlastResult->new();\n Function: Builds a new Bio::Search::Result::BlastResult object\n Returns : Bio::Search::Result::BlastResult\n Args    : See Bio::Search::Result::GenericResult();\n           The following parameters are specific to BlastResult:\n             -iterations  => array ref of Bio::Search::Iteration::IterationI objects\n             -inclusion_threshold => e-value threshold for inclusion in the\n                                     PSI-BLAST score matrix model (blastpgp)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_iterations'} = [];\n  $self->{'_iteration_index'} = 0;\n  $self->{'_iteration_count'} = 0;\n\n  my( $iters, $ithresh ) = $self->_rearrange([qw(ITERATIONS\n                                                 INCLUSION_THRESHOLD)],@args);\n\n  $self->{'_inclusion_threshold'} = $ithresh;  # This is a read-only variable\n\n  if( defined $iters  ) {\n      $self->throw(\"Must define arrayref of Iterations when initializing a $class\\n\") unless ref($iters) =~ /array/i;\n\n      foreach my $i ( @{$iters} ) {\n          $self->add_iteration($i);\n      }\n  } \n  else {\n      # This shouldn't get called with the new SearchIO::blast.\n      print STDERR \"BlastResult::new(): Not adding iterations.\\n\";\n      $self->{'_no_iterations'} = 1;\n  }\n\n  return $self;\n}\n\n\n=head2 hits\n\n Title   : hits\n Usage   : my @hits = $result->hits\n Function: Returns the available hits for this Result\n Returns : Array of L<Bio::Search::Hit::HitI> objects\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::hits> to\n           take into account the possibility of multiple iterations, as occurs\n           in PSI-BLAST reports.\n           If there are multiple iterations, all 'new' hits for all iterations\n           are returned. These are the hits that did not occur in a previous\n           iteration.\n\n           See Also: L<Bio::Search::Result::GenericResult::hits>\n\n\nsub hits {\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::hits;\n   }\n   my @hits = ();\n   foreach my $it ($self->iterations) {\n       push @hits, $it->hits;\n   }\n   return @hits;\n}\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::next_hit>\n           to take into account the possibility of multiple iterations, as\n           occurs in PSI-BLAST reports.\n\n           If there are multiple iterations, calling next_hit() traverses the\n           all of the hits, old and new, for each iteration, calling next_hit()\n           on each iteration.\n\n           See Also: L<Bio::Search::Iteration::GenericIteration::next_hit>","parameters":[{"label":"$self"},{"label":"@args"}],"label":"next_hit($self,@args)"},"detail":"($self,@args)","kind":12,"children":[{"kind":13,"line":194,"containerName":"next_hit","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":194,"name":"@args","containerName":"next_hit"},{"name":"$self","containerName":"next_hit","line":195,"kind":13},{"line":196,"kind":13,"name":"$self","containerName":"next_hit"},{"name":"@args","containerName":"next_hit","line":196,"kind":13},{"kind":13,"line":199,"definition":"my","name":"$iter_index","containerName":"next_hit","localvar":"my"},{"name":"$self","containerName":"next_hit","kind":13,"line":200},{"kind":13,"line":201,"containerName":"next_hit","name":"$iter_index"},{"kind":13,"line":201,"containerName":"next_hit","name":"$self"},{"name":"$self","containerName":"next_hit","line":201,"kind":13},{"line":201,"kind":12,"containerName":"next_hit","name":"_next_iteration_index"},{"line":203,"kind":13,"name":"$iter_index","containerName":"next_hit"},{"line":203,"kind":13,"containerName":"next_hit","name":"$self"},{"kind":13,"line":206,"containerName":"next_hit","name":"$iter_index"},{"kind":13,"line":206,"containerName":"next_hit","name":"$self"}],"line":193},{"kind":12,"line":196,"name":"SUPER","containerName":"next_hit"},{"kind":13,"line":208,"containerName":null,"definition":"my","name":"$it","localvar":"my"},{"line":208,"kind":13,"containerName":null,"name":"%self"},{"line":208,"kind":13,"name":"$iter_index","containerName":null},{"kind":13,"line":209,"name":"$hit","definition":"my","containerName":null,"localvar":"my"},{"kind":13,"line":209,"containerName":null,"name":"%self"},{"name":"$it","containerName":null,"kind":13,"line":209},{"kind":12,"line":209,"containerName":"main::","name":"next_hit"},{"name":"$hit","containerName":null,"line":211,"kind":13},{"kind":13,"line":211,"name":"$hit","containerName":null},{"containerName":null,"name":"$self","line":211,"kind":13},{"containerName":"main::","name":"next_hit","kind":12,"line":211},{"name":"num_hits","definition":"sub","containerName":"main::","range":{"start":{"line":234,"character":0},"end":{"line":243,"character":9999}},"kind":12,"children":[{"line":235,"kind":13,"localvar":"my","containerName":"num_hits","definition":"my","name":"$self"},{"kind":13,"line":236,"containerName":"num_hits","name":"$self"},{"name":"$self","containerName":"num_hits","kind":13,"line":237},{"kind":13,"line":239,"containerName":"num_hits","name":"$self"},{"kind":13,"line":240,"containerName":"num_hits","name":"$self"},{"kind":12,"line":240,"name":"throw","containerName":"num_hits"},{"line":242,"kind":13,"containerName":"num_hits","name":"$self"},{"kind":12,"line":242,"name":"hits","containerName":"num_hits"}],"line":234},{"line":239,"kind":12,"name":"SUPER","containerName":"num_hits"},{"line":255,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"add_hit","line":256,"kind":13},{"containerName":"add_hit","name":"$hit","line":256,"kind":13},{"line":257,"kind":13,"localvar":"my","containerName":"add_hit","name":"$iter","definition":"my"},{"name":"$self","containerName":"add_hit","kind":13,"line":257},{"line":257,"kind":12,"containerName":"add_hit","name":"iteration"},{"kind":13,"line":258,"containerName":"add_hit","name":"$hit"},{"line":258,"kind":12,"containerName":"add_hit","name":"isa"},{"containerName":"add_hit","name":"$iter","kind":13,"line":259},{"kind":12,"line":259,"name":"add_hit","containerName":"add_hit"},{"name":"$hit","containerName":"add_hit","line":259,"kind":13},{"name":"$self","containerName":"add_hit","kind":13,"line":261},{"kind":12,"line":261,"containerName":"add_hit","name":"throw"},{"line":261,"kind":13,"name":"$hit","containerName":"add_hit"},{"line":264,"kind":13,"name":"$iter","containerName":"add_hit"},{"kind":12,"line":264,"name":"num_hits","containerName":"add_hit"}],"kind":12,"detail":"($self,$hit)","signature":{"label":"add_hit($self,$hit)","documentation":"1;\n# $Id: BlastResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::BlastResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::BlastResult - Blast-specific subclass of Bio::Search::Result::GenericResult\n\n=head1 SYNOPSIS\n\n    # Working with iterations (PSI-BLAST results)\n\n    $result->next_iteration();\n    $result->num_iterations();\n    $result->iteration();\n    $result->iterations();\n\n# See Bio::Search::Result::GenericResult for information about working with Results.\n\n# See L<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>\n# for details about working with iterations.\n\n# TODO:\n#     * Show how to configure a SearchIO stream so that it generates\n#       BlastResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is a subclass of Bio::Search::Result::GenericResult\nand provides some operations that facilitate working with BLAST\nand PSI-BLAST results.\n\nFor general information about working with Results, see \nBio::Search::Result::GenericResult.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::BlastResult;\nuse strict;\n\nuse Bio::Search::BlastStatistics;\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::BlastResult->new();\n Function: Builds a new Bio::Search::Result::BlastResult object\n Returns : Bio::Search::Result::BlastResult\n Args    : See Bio::Search::Result::GenericResult();\n           The following parameters are specific to BlastResult:\n             -iterations  => array ref of Bio::Search::Iteration::IterationI objects\n             -inclusion_threshold => e-value threshold for inclusion in the\n                                     PSI-BLAST score matrix model (blastpgp)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_iterations'} = [];\n  $self->{'_iteration_index'} = 0;\n  $self->{'_iteration_count'} = 0;\n\n  my( $iters, $ithresh ) = $self->_rearrange([qw(ITERATIONS\n                                                 INCLUSION_THRESHOLD)],@args);\n\n  $self->{'_inclusion_threshold'} = $ithresh;  # This is a read-only variable\n\n  if( defined $iters  ) {\n      $self->throw(\"Must define arrayref of Iterations when initializing a $class\\n\") unless ref($iters) =~ /array/i;\n\n      foreach my $i ( @{$iters} ) {\n          $self->add_iteration($i);\n      }\n  } \n  else {\n      # This shouldn't get called with the new SearchIO::blast.\n      print STDERR \"BlastResult::new(): Not adding iterations.\\n\";\n      $self->{'_no_iterations'} = 1;\n  }\n\n  return $self;\n}\n\n\n=head2 hits\n\n Title   : hits\n Usage   : my @hits = $result->hits\n Function: Returns the available hits for this Result\n Returns : Array of L<Bio::Search::Hit::HitI> objects\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::hits> to\n           take into account the possibility of multiple iterations, as occurs\n           in PSI-BLAST reports.\n           If there are multiple iterations, all 'new' hits for all iterations\n           are returned. These are the hits that did not occur in a previous\n           iteration.\n\n           See Also: L<Bio::Search::Result::GenericResult::hits>\n\n\nsub hits {\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::hits;\n   }\n   my @hits = ();\n   foreach my $it ($self->iterations) {\n       push @hits, $it->hits;\n   }\n   return @hits;\n}\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::next_hit>\n           to take into account the possibility of multiple iterations, as\n           occurs in PSI-BLAST reports.\n\n           If there are multiple iterations, calling next_hit() traverses the\n           all of the hits, old and new, for each iteration, calling next_hit()\n           on each iteration.\n\n           See Also: L<Bio::Search::Iteration::GenericIteration::next_hit>\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    if ($self->{'_no_iterations'}) {\n        return $self->SUPER::next_hit(@args);\n    }\n\n    my $iter_index;\n    if (not defined $self->{'_last_hit'}) {\n        $iter_index = $self->{'_iter_index'} = $self->_next_iteration_index;\n    } else {\n        $iter_index = $self->{'_iter_index'};\n    }\n\n    return if $iter_index >= scalar @{$self->{'_iterations'}};\n\n    my $it = $self->{'_iterations'}->[$iter_index];\n    my $hit = $self->{'_last_hit'} = $it->next_hit;\n\n    return defined($hit) ? $hit : $self->next_hit;\n}\n\n\n=head2 num_hits\n\n Title   : num_hits\n Usage   : my $hitcount= $result->num_hits\n Function: returns the number of hits for this query result\n Returns : integer\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::num_hits>\n           to take into account the possibility of multiple iterations, as\n           occurs in PSI-BLAST reports.\n\n           If there are multiple iterations, calling num_hits() returns the\n           number of 'new' hits for each iteration. These are the hits that did\n           not occur in a previous iteration.\n\n           See Also: L<Bio::Search::Result::GenericResult::num_hits>\n\n\nsub num_hits{\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::num_hits;\n   }\n   if (not defined $self->{'_iterations'}) {\n       $self->throw(\"Can't get Hits: data not collected.\");\n    }\n    return scalar( $self->hits );\n}\n\n=head2 add_hit\n\n Title   : add_hit\n Usage   : $report->add_hit($hit)\n Function: Adds a HitI to the stored list of hits\n Returns : Number of HitI currently stored\n Args    : Bio::Search::Hit::HitI","parameters":[{"label":"$self"},{"label":"$hit"}]},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":255},"end":{"line":265,"character":9999}},"name":"add_hit"},{"range":{"end":{"line":282,"character":9999},"start":{"line":277,"character":0}},"name":"add_iteration","line":277,"children":[{"definition":"my","name":"$self","containerName":"add_iteration","localvar":"my","kind":13,"line":278},{"name":"$i","containerName":"add_iteration","line":278,"kind":13},{"name":"$i","containerName":"add_iteration","kind":13,"line":279},{"name":"isa","containerName":"add_iteration","line":279,"kind":12},{"containerName":"add_iteration","name":"$self","kind":13,"line":280},{"containerName":"add_iteration","name":"$i","line":280,"kind":13},{"containerName":"add_iteration","name":"$self","kind":13,"line":281}],"kind":12,"detail":"($self,$i)","signature":{"documentation":"1;\n# $Id: BlastResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::BlastResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::BlastResult - Blast-specific subclass of Bio::Search::Result::GenericResult\n\n=head1 SYNOPSIS\n\n    # Working with iterations (PSI-BLAST results)\n\n    $result->next_iteration();\n    $result->num_iterations();\n    $result->iteration();\n    $result->iterations();\n\n# See Bio::Search::Result::GenericResult for information about working with Results.\n\n# See L<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>\n# for details about working with iterations.\n\n# TODO:\n#     * Show how to configure a SearchIO stream so that it generates\n#       BlastResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is a subclass of Bio::Search::Result::GenericResult\nand provides some operations that facilitate working with BLAST\nand PSI-BLAST results.\n\nFor general information about working with Results, see \nBio::Search::Result::GenericResult.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::BlastResult;\nuse strict;\n\nuse Bio::Search::BlastStatistics;\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::BlastResult->new();\n Function: Builds a new Bio::Search::Result::BlastResult object\n Returns : Bio::Search::Result::BlastResult\n Args    : See Bio::Search::Result::GenericResult();\n           The following parameters are specific to BlastResult:\n             -iterations  => array ref of Bio::Search::Iteration::IterationI objects\n             -inclusion_threshold => e-value threshold for inclusion in the\n                                     PSI-BLAST score matrix model (blastpgp)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_iterations'} = [];\n  $self->{'_iteration_index'} = 0;\n  $self->{'_iteration_count'} = 0;\n\n  my( $iters, $ithresh ) = $self->_rearrange([qw(ITERATIONS\n                                                 INCLUSION_THRESHOLD)],@args);\n\n  $self->{'_inclusion_threshold'} = $ithresh;  # This is a read-only variable\n\n  if( defined $iters  ) {\n      $self->throw(\"Must define arrayref of Iterations when initializing a $class\\n\") unless ref($iters) =~ /array/i;\n\n      foreach my $i ( @{$iters} ) {\n          $self->add_iteration($i);\n      }\n  } \n  else {\n      # This shouldn't get called with the new SearchIO::blast.\n      print STDERR \"BlastResult::new(): Not adding iterations.\\n\";\n      $self->{'_no_iterations'} = 1;\n  }\n\n  return $self;\n}\n\n\n=head2 hits\n\n Title   : hits\n Usage   : my @hits = $result->hits\n Function: Returns the available hits for this Result\n Returns : Array of L<Bio::Search::Hit::HitI> objects\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::hits> to\n           take into account the possibility of multiple iterations, as occurs\n           in PSI-BLAST reports.\n           If there are multiple iterations, all 'new' hits for all iterations\n           are returned. These are the hits that did not occur in a previous\n           iteration.\n\n           See Also: L<Bio::Search::Result::GenericResult::hits>\n\n\nsub hits {\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::hits;\n   }\n   my @hits = ();\n   foreach my $it ($self->iterations) {\n       push @hits, $it->hits;\n   }\n   return @hits;\n}\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::next_hit>\n           to take into account the possibility of multiple iterations, as\n           occurs in PSI-BLAST reports.\n\n           If there are multiple iterations, calling next_hit() traverses the\n           all of the hits, old and new, for each iteration, calling next_hit()\n           on each iteration.\n\n           See Also: L<Bio::Search::Iteration::GenericIteration::next_hit>\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    if ($self->{'_no_iterations'}) {\n        return $self->SUPER::next_hit(@args);\n    }\n\n    my $iter_index;\n    if (not defined $self->{'_last_hit'}) {\n        $iter_index = $self->{'_iter_index'} = $self->_next_iteration_index;\n    } else {\n        $iter_index = $self->{'_iter_index'};\n    }\n\n    return if $iter_index >= scalar @{$self->{'_iterations'}};\n\n    my $it = $self->{'_iterations'}->[$iter_index];\n    my $hit = $self->{'_last_hit'} = $it->next_hit;\n\n    return defined($hit) ? $hit : $self->next_hit;\n}\n\n\n=head2 num_hits\n\n Title   : num_hits\n Usage   : my $hitcount= $result->num_hits\n Function: returns the number of hits for this query result\n Returns : integer\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::num_hits>\n           to take into account the possibility of multiple iterations, as\n           occurs in PSI-BLAST reports.\n\n           If there are multiple iterations, calling num_hits() returns the\n           number of 'new' hits for each iteration. These are the hits that did\n           not occur in a previous iteration.\n\n           See Also: L<Bio::Search::Result::GenericResult::num_hits>\n\n\nsub num_hits{\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::num_hits;\n   }\n   if (not defined $self->{'_iterations'}) {\n       $self->throw(\"Can't get Hits: data not collected.\");\n    }\n    return scalar( $self->hits );\n}\n\n=head2 add_hit\n\n Title   : add_hit\n Usage   : $report->add_hit($hit)\n Function: Adds a HitI to the stored list of hits\n Returns : Number of HitI currently stored\n Args    : Bio::Search::Hit::HitI\n\n\nsub add_hit {\n    my ($self,$hit) = @_;\n    my $iter = $self->iteration;\n    if( $hit->isa('Bio::Search::Hit::HitI') ) { \n\treturn $iter->add_hit(-hit => $hit);\n    } else { \n        $self->throw(\"Passed in a \" .ref($hit). \n                     \" as a Iteration which is not a Bio::Search::Hit::HitI.\");\n    }\n    return $iter->num_hits;\n}\n\n=head2 add_iteration\n\n Title   : add_iteration\n Usage   : $report->add_iteration($iteration)\n Function: Adds a IterationI to the stored list of iterations\n Returns : Number of IterationI currently stored\n Args    : Bio::Search::Iteration::IterationI","parameters":[{"label":"$self"},{"label":"$i"}],"label":"add_iteration($self,$i)"},"containerName":"main::","definition":"sub"},{"line":283,"kind":13,"name":"$self","containerName":null},{"containerName":"main::","name":"throw","line":283,"kind":12},{"kind":13,"line":283,"name":"$i","containerName":null},{"kind":13,"line":286,"containerName":null,"name":"%self"},{"definition":"sub","containerName":"main::","signature":{"label":"next_iteration($self)","documentation":"1;\n# $Id: BlastResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::BlastResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::BlastResult - Blast-specific subclass of Bio::Search::Result::GenericResult\n\n=head1 SYNOPSIS\n\n    # Working with iterations (PSI-BLAST results)\n\n    $result->next_iteration();\n    $result->num_iterations();\n    $result->iteration();\n    $result->iterations();\n\n# See Bio::Search::Result::GenericResult for information about working with Results.\n\n# See L<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>\n# for details about working with iterations.\n\n# TODO:\n#     * Show how to configure a SearchIO stream so that it generates\n#       BlastResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is a subclass of Bio::Search::Result::GenericResult\nand provides some operations that facilitate working with BLAST\nand PSI-BLAST results.\n\nFor general information about working with Results, see \nBio::Search::Result::GenericResult.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::BlastResult;\nuse strict;\n\nuse Bio::Search::BlastStatistics;\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::BlastResult->new();\n Function: Builds a new Bio::Search::Result::BlastResult object\n Returns : Bio::Search::Result::BlastResult\n Args    : See Bio::Search::Result::GenericResult();\n           The following parameters are specific to BlastResult:\n             -iterations  => array ref of Bio::Search::Iteration::IterationI objects\n             -inclusion_threshold => e-value threshold for inclusion in the\n                                     PSI-BLAST score matrix model (blastpgp)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_iterations'} = [];\n  $self->{'_iteration_index'} = 0;\n  $self->{'_iteration_count'} = 0;\n\n  my( $iters, $ithresh ) = $self->_rearrange([qw(ITERATIONS\n                                                 INCLUSION_THRESHOLD)],@args);\n\n  $self->{'_inclusion_threshold'} = $ithresh;  # This is a read-only variable\n\n  if( defined $iters  ) {\n      $self->throw(\"Must define arrayref of Iterations when initializing a $class\\n\") unless ref($iters) =~ /array/i;\n\n      foreach my $i ( @{$iters} ) {\n          $self->add_iteration($i);\n      }\n  } \n  else {\n      # This shouldn't get called with the new SearchIO::blast.\n      print STDERR \"BlastResult::new(): Not adding iterations.\\n\";\n      $self->{'_no_iterations'} = 1;\n  }\n\n  return $self;\n}\n\n\n=head2 hits\n\n Title   : hits\n Usage   : my @hits = $result->hits\n Function: Returns the available hits for this Result\n Returns : Array of L<Bio::Search::Hit::HitI> objects\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::hits> to\n           take into account the possibility of multiple iterations, as occurs\n           in PSI-BLAST reports.\n           If there are multiple iterations, all 'new' hits for all iterations\n           are returned. These are the hits that did not occur in a previous\n           iteration.\n\n           See Also: L<Bio::Search::Result::GenericResult::hits>\n\n\nsub hits {\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::hits;\n   }\n   my @hits = ();\n   foreach my $it ($self->iterations) {\n       push @hits, $it->hits;\n   }\n   return @hits;\n}\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::next_hit>\n           to take into account the possibility of multiple iterations, as\n           occurs in PSI-BLAST reports.\n\n           If there are multiple iterations, calling next_hit() traverses the\n           all of the hits, old and new, for each iteration, calling next_hit()\n           on each iteration.\n\n           See Also: L<Bio::Search::Iteration::GenericIteration::next_hit>\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    if ($self->{'_no_iterations'}) {\n        return $self->SUPER::next_hit(@args);\n    }\n\n    my $iter_index;\n    if (not defined $self->{'_last_hit'}) {\n        $iter_index = $self->{'_iter_index'} = $self->_next_iteration_index;\n    } else {\n        $iter_index = $self->{'_iter_index'};\n    }\n\n    return if $iter_index >= scalar @{$self->{'_iterations'}};\n\n    my $it = $self->{'_iterations'}->[$iter_index];\n    my $hit = $self->{'_last_hit'} = $it->next_hit;\n\n    return defined($hit) ? $hit : $self->next_hit;\n}\n\n\n=head2 num_hits\n\n Title   : num_hits\n Usage   : my $hitcount= $result->num_hits\n Function: returns the number of hits for this query result\n Returns : integer\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::num_hits>\n           to take into account the possibility of multiple iterations, as\n           occurs in PSI-BLAST reports.\n\n           If there are multiple iterations, calling num_hits() returns the\n           number of 'new' hits for each iteration. These are the hits that did\n           not occur in a previous iteration.\n\n           See Also: L<Bio::Search::Result::GenericResult::num_hits>\n\n\nsub num_hits{\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::num_hits;\n   }\n   if (not defined $self->{'_iterations'}) {\n       $self->throw(\"Can't get Hits: data not collected.\");\n    }\n    return scalar( $self->hits );\n}\n\n=head2 add_hit\n\n Title   : add_hit\n Usage   : $report->add_hit($hit)\n Function: Adds a HitI to the stored list of hits\n Returns : Number of HitI currently stored\n Args    : Bio::Search::Hit::HitI\n\n\nsub add_hit {\n    my ($self,$hit) = @_;\n    my $iter = $self->iteration;\n    if( $hit->isa('Bio::Search::Hit::HitI') ) { \n\treturn $iter->add_hit(-hit => $hit);\n    } else { \n        $self->throw(\"Passed in a \" .ref($hit). \n                     \" as a Iteration which is not a Bio::Search::Hit::HitI.\");\n    }\n    return $iter->num_hits;\n}\n\n=head2 add_iteration\n\n Title   : add_iteration\n Usage   : $report->add_iteration($iteration)\n Function: Adds a IterationI to the stored list of iterations\n Returns : Number of IterationI currently stored\n Args    : Bio::Search::Iteration::IterationI\n\n\nsub add_iteration {\n    my ($self,$i) = @_;\n    if( $i->isa('Bio::Search::Iteration::IterationI') ) { \n        push @{$self->{'_iterations'}}, $i;\n        $self->{'_iteration_count'}++;\n    } else { \n        $self->throw(\"Passed in a \" .ref($i). \n                     \" as a Iteration which is not a Bio::Search::Iteration::IterationI.\");\n    }\n    return scalar @{$self->{'_iterations'}};\n}\n\n\n=head2 next_iteration\n\n Title   : next_iteration\n Usage   : while( $it = $result->next_iteration()) { ... }\n Function: Returns the next Iteration object, representing all hits\n           found within a given PSI-Blast iteration.\n Returns : a Bio::Search::Iteration::IterationI object or undef if there are no more.\n Args    : none","parameters":[{"label":"$self"}]},"detail":"($self)","kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"next_iteration","line":302,"kind":13},{"name":"$self","containerName":"next_iteration","line":304,"kind":13},{"line":305,"kind":13,"containerName":"next_iteration","name":"$self"},{"line":305,"kind":13,"containerName":"next_iteration","name":"$self"},{"name":"iterations","containerName":"next_iteration","kind":12,"line":305},{"containerName":"next_iteration","name":"$self","kind":13,"line":306},{"kind":13,"line":308,"name":"$self","containerName":"next_iteration"}],"line":301,"name":"next_iteration","range":{"end":{"character":9999,"line":308},"start":{"line":301,"character":0}}},{"definition":"sub","containerName":"main::","signature":{"label":"iteration($self,$num)","documentation":"1;\n# $Id: BlastResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::BlastResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::BlastResult - Blast-specific subclass of Bio::Search::Result::GenericResult\n\n=head1 SYNOPSIS\n\n    # Working with iterations (PSI-BLAST results)\n\n    $result->next_iteration();\n    $result->num_iterations();\n    $result->iteration();\n    $result->iterations();\n\n# See Bio::Search::Result::GenericResult for information about working with Results.\n\n# See L<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>\n# for details about working with iterations.\n\n# TODO:\n#     * Show how to configure a SearchIO stream so that it generates\n#       BlastResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is a subclass of Bio::Search::Result::GenericResult\nand provides some operations that facilitate working with BLAST\nand PSI-BLAST results.\n\nFor general information about working with Results, see \nBio::Search::Result::GenericResult.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::BlastResult;\nuse strict;\n\nuse Bio::Search::BlastStatistics;\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::BlastResult->new();\n Function: Builds a new Bio::Search::Result::BlastResult object\n Returns : Bio::Search::Result::BlastResult\n Args    : See Bio::Search::Result::GenericResult();\n           The following parameters are specific to BlastResult:\n             -iterations  => array ref of Bio::Search::Iteration::IterationI objects\n             -inclusion_threshold => e-value threshold for inclusion in the\n                                     PSI-BLAST score matrix model (blastpgp)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_iterations'} = [];\n  $self->{'_iteration_index'} = 0;\n  $self->{'_iteration_count'} = 0;\n\n  my( $iters, $ithresh ) = $self->_rearrange([qw(ITERATIONS\n                                                 INCLUSION_THRESHOLD)],@args);\n\n  $self->{'_inclusion_threshold'} = $ithresh;  # This is a read-only variable\n\n  if( defined $iters  ) {\n      $self->throw(\"Must define arrayref of Iterations when initializing a $class\\n\") unless ref($iters) =~ /array/i;\n\n      foreach my $i ( @{$iters} ) {\n          $self->add_iteration($i);\n      }\n  } \n  else {\n      # This shouldn't get called with the new SearchIO::blast.\n      print STDERR \"BlastResult::new(): Not adding iterations.\\n\";\n      $self->{'_no_iterations'} = 1;\n  }\n\n  return $self;\n}\n\n\n=head2 hits\n\n Title   : hits\n Usage   : my @hits = $result->hits\n Function: Returns the available hits for this Result\n Returns : Array of L<Bio::Search::Hit::HitI> objects\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::hits> to\n           take into account the possibility of multiple iterations, as occurs\n           in PSI-BLAST reports.\n           If there are multiple iterations, all 'new' hits for all iterations\n           are returned. These are the hits that did not occur in a previous\n           iteration.\n\n           See Also: L<Bio::Search::Result::GenericResult::hits>\n\n\nsub hits {\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::hits;\n   }\n   my @hits = ();\n   foreach my $it ($self->iterations) {\n       push @hits, $it->hits;\n   }\n   return @hits;\n}\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::next_hit>\n           to take into account the possibility of multiple iterations, as\n           occurs in PSI-BLAST reports.\n\n           If there are multiple iterations, calling next_hit() traverses the\n           all of the hits, old and new, for each iteration, calling next_hit()\n           on each iteration.\n\n           See Also: L<Bio::Search::Iteration::GenericIteration::next_hit>\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    if ($self->{'_no_iterations'}) {\n        return $self->SUPER::next_hit(@args);\n    }\n\n    my $iter_index;\n    if (not defined $self->{'_last_hit'}) {\n        $iter_index = $self->{'_iter_index'} = $self->_next_iteration_index;\n    } else {\n        $iter_index = $self->{'_iter_index'};\n    }\n\n    return if $iter_index >= scalar @{$self->{'_iterations'}};\n\n    my $it = $self->{'_iterations'}->[$iter_index];\n    my $hit = $self->{'_last_hit'} = $it->next_hit;\n\n    return defined($hit) ? $hit : $self->next_hit;\n}\n\n\n=head2 num_hits\n\n Title   : num_hits\n Usage   : my $hitcount= $result->num_hits\n Function: returns the number of hits for this query result\n Returns : integer\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::num_hits>\n           to take into account the possibility of multiple iterations, as\n           occurs in PSI-BLAST reports.\n\n           If there are multiple iterations, calling num_hits() returns the\n           number of 'new' hits for each iteration. These are the hits that did\n           not occur in a previous iteration.\n\n           See Also: L<Bio::Search::Result::GenericResult::num_hits>\n\n\nsub num_hits{\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::num_hits;\n   }\n   if (not defined $self->{'_iterations'}) {\n       $self->throw(\"Can't get Hits: data not collected.\");\n    }\n    return scalar( $self->hits );\n}\n\n=head2 add_hit\n\n Title   : add_hit\n Usage   : $report->add_hit($hit)\n Function: Adds a HitI to the stored list of hits\n Returns : Number of HitI currently stored\n Args    : Bio::Search::Hit::HitI\n\n\nsub add_hit {\n    my ($self,$hit) = @_;\n    my $iter = $self->iteration;\n    if( $hit->isa('Bio::Search::Hit::HitI') ) { \n\treturn $iter->add_hit(-hit => $hit);\n    } else { \n        $self->throw(\"Passed in a \" .ref($hit). \n                     \" as a Iteration which is not a Bio::Search::Hit::HitI.\");\n    }\n    return $iter->num_hits;\n}\n\n=head2 add_iteration\n\n Title   : add_iteration\n Usage   : $report->add_iteration($iteration)\n Function: Adds a IterationI to the stored list of iterations\n Returns : Number of IterationI currently stored\n Args    : Bio::Search::Iteration::IterationI\n\n\nsub add_iteration {\n    my ($self,$i) = @_;\n    if( $i->isa('Bio::Search::Iteration::IterationI') ) { \n        push @{$self->{'_iterations'}}, $i;\n        $self->{'_iteration_count'}++;\n    } else { \n        $self->throw(\"Passed in a \" .ref($i). \n                     \" as a Iteration which is not a Bio::Search::Iteration::IterationI.\");\n    }\n    return scalar @{$self->{'_iterations'}};\n}\n\n\n=head2 next_iteration\n\n Title   : next_iteration\n Usage   : while( $it = $result->next_iteration()) { ... }\n Function: Returns the next Iteration object, representing all hits\n           found within a given PSI-Blast iteration.\n Returns : a Bio::Search::Iteration::IterationI object or undef if there are no more.\n Args    : none\n\n\nsub next_iteration {\n    my ($self) = @_;\n\n   unless($self->{'_iter_queue_started'}) {\n       $self->{'_iter_queue'} = [$self->iterations()];\n       $self->{'_iter_queue_started'} = 1;\n   }\n   return shift @{$self->{'_iter_queue'}};\n}\n\n=head2 iteration\n\n Usage     : $iteration = $blast->iteration( $number );\n Purpose   : Get an IterationI object for the specified iteration\n             in the search result (PSI-BLAST).\n Returns   : Bio::Search::Iteration::IterationI object\n Throws    : Bio::Root::NoSuchThing exception if $number is not within \n             range of the number of iterations in this report.\n Argument  : integer (optional, if not specified get the last iteration)\n             First iteration = 1","parameters":[{"label":"$self"},{"label":"$num"}]},"detail":"($self,$num)","kind":12,"children":[{"line":325,"kind":13,"localvar":"my","containerName":"iteration","definition":"my","name":"$self"},{"line":325,"kind":13,"name":"$num","containerName":"iteration"},{"kind":13,"line":326,"containerName":"iteration","name":"$num"},{"kind":13,"line":326,"containerName":"iteration","name":"$self"}],"line":324,"name":"iteration","range":{"end":{"line":326,"character":9999},"start":{"character":0,"line":324}}},{"name":"$num","containerName":null,"kind":13,"line":326},{"containerName":null,"name":"$num","line":327,"kind":13},{"kind":13,"line":327,"containerName":null,"name":"$num"},{"containerName":null,"name":"%self","kind":13,"line":327},{"name":"$self","containerName":null,"kind":13,"line":328},{"name":"throw","containerName":"main::","line":328,"kind":12},{"kind":13,"line":330,"containerName":null,"name":"$num"},{"line":332,"kind":13,"name":"%self","containerName":null},{"containerName":null,"name":"$num","line":332,"kind":13},{"containerName":"main::","definition":"sub","name":"num_iterations","range":{"start":{"character":0,"line":344},"end":{"character":9999,"line":344}},"kind":12,"line":344,"children":[]},{"kind":12,"children":[{"kind":12,"line":359,"containerName":"number_of_iterations","name":"num_iterations"}],"line":359,"definition":"sub","name":"number_of_iterations","containerName":"main::","range":{"start":{"line":359,"character":0},"end":{"character":9999,"line":359}}},{"kind":12,"line":375,"children":[{"name":"iteration","containerName":"round","kind":12,"line":375}],"containerName":"main::","name":"round","definition":"sub","range":{"start":{"line":375,"character":0},"end":{"character":9999,"line":375}}},{"children":[{"localvar":"my","containerName":"iterations","name":"$self","definition":"my","line":389,"kind":13},{"line":390,"kind":13,"localvar":"my","definition":"my","name":"@its","containerName":"iterations"},{"line":391,"kind":13,"name":"$self","containerName":"iterations"},{"name":"@its","containerName":"iterations","kind":13,"line":392},{"containerName":"iterations","name":"$self","line":392,"kind":13}],"line":388,"kind":12,"range":{"start":{"character":0,"line":388},"end":{"line":393,"character":9999}},"definition":"sub","name":"iterations","containerName":"main::"},{"line":394,"kind":13,"containerName":null,"name":"@its"},{"containerName":"main::","definition":"sub","detail":"($self,$val)","signature":{"label":"psiblast($self,$val)","parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n# $Id: BlastResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::BlastResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::BlastResult - Blast-specific subclass of Bio::Search::Result::GenericResult\n\n=head1 SYNOPSIS\n\n    # Working with iterations (PSI-BLAST results)\n\n    $result->next_iteration();\n    $result->num_iterations();\n    $result->iteration();\n    $result->iterations();\n\n# See Bio::Search::Result::GenericResult for information about working with Results.\n\n# See L<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>\n# for details about working with iterations.\n\n# TODO:\n#     * Show how to configure a SearchIO stream so that it generates\n#       BlastResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is a subclass of Bio::Search::Result::GenericResult\nand provides some operations that facilitate working with BLAST\nand PSI-BLAST results.\n\nFor general information about working with Results, see \nBio::Search::Result::GenericResult.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::BlastResult;\nuse strict;\n\nuse Bio::Search::BlastStatistics;\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::BlastResult->new();\n Function: Builds a new Bio::Search::Result::BlastResult object\n Returns : Bio::Search::Result::BlastResult\n Args    : See Bio::Search::Result::GenericResult();\n           The following parameters are specific to BlastResult:\n             -iterations  => array ref of Bio::Search::Iteration::IterationI objects\n             -inclusion_threshold => e-value threshold for inclusion in the\n                                     PSI-BLAST score matrix model (blastpgp)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_iterations'} = [];\n  $self->{'_iteration_index'} = 0;\n  $self->{'_iteration_count'} = 0;\n\n  my( $iters, $ithresh ) = $self->_rearrange([qw(ITERATIONS\n                                                 INCLUSION_THRESHOLD)],@args);\n\n  $self->{'_inclusion_threshold'} = $ithresh;  # This is a read-only variable\n\n  if( defined $iters  ) {\n      $self->throw(\"Must define arrayref of Iterations when initializing a $class\\n\") unless ref($iters) =~ /array/i;\n\n      foreach my $i ( @{$iters} ) {\n          $self->add_iteration($i);\n      }\n  } \n  else {\n      # This shouldn't get called with the new SearchIO::blast.\n      print STDERR \"BlastResult::new(): Not adding iterations.\\n\";\n      $self->{'_no_iterations'} = 1;\n  }\n\n  return $self;\n}\n\n\n=head2 hits\n\n Title   : hits\n Usage   : my @hits = $result->hits\n Function: Returns the available hits for this Result\n Returns : Array of L<Bio::Search::Hit::HitI> objects\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::hits> to\n           take into account the possibility of multiple iterations, as occurs\n           in PSI-BLAST reports.\n           If there are multiple iterations, all 'new' hits for all iterations\n           are returned. These are the hits that did not occur in a previous\n           iteration.\n\n           See Also: L<Bio::Search::Result::GenericResult::hits>\n\n\nsub hits {\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::hits;\n   }\n   my @hits = ();\n   foreach my $it ($self->iterations) {\n       push @hits, $it->hits;\n   }\n   return @hits;\n}\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::next_hit>\n           to take into account the possibility of multiple iterations, as\n           occurs in PSI-BLAST reports.\n\n           If there are multiple iterations, calling next_hit() traverses the\n           all of the hits, old and new, for each iteration, calling next_hit()\n           on each iteration.\n\n           See Also: L<Bio::Search::Iteration::GenericIteration::next_hit>\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    if ($self->{'_no_iterations'}) {\n        return $self->SUPER::next_hit(@args);\n    }\n\n    my $iter_index;\n    if (not defined $self->{'_last_hit'}) {\n        $iter_index = $self->{'_iter_index'} = $self->_next_iteration_index;\n    } else {\n        $iter_index = $self->{'_iter_index'};\n    }\n\n    return if $iter_index >= scalar @{$self->{'_iterations'}};\n\n    my $it = $self->{'_iterations'}->[$iter_index];\n    my $hit = $self->{'_last_hit'} = $it->next_hit;\n\n    return defined($hit) ? $hit : $self->next_hit;\n}\n\n\n=head2 num_hits\n\n Title   : num_hits\n Usage   : my $hitcount= $result->num_hits\n Function: returns the number of hits for this query result\n Returns : integer\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::num_hits>\n           to take into account the possibility of multiple iterations, as\n           occurs in PSI-BLAST reports.\n\n           If there are multiple iterations, calling num_hits() returns the\n           number of 'new' hits for each iteration. These are the hits that did\n           not occur in a previous iteration.\n\n           See Also: L<Bio::Search::Result::GenericResult::num_hits>\n\n\nsub num_hits{\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::num_hits;\n   }\n   if (not defined $self->{'_iterations'}) {\n       $self->throw(\"Can't get Hits: data not collected.\");\n    }\n    return scalar( $self->hits );\n}\n\n=head2 add_hit\n\n Title   : add_hit\n Usage   : $report->add_hit($hit)\n Function: Adds a HitI to the stored list of hits\n Returns : Number of HitI currently stored\n Args    : Bio::Search::Hit::HitI\n\n\nsub add_hit {\n    my ($self,$hit) = @_;\n    my $iter = $self->iteration;\n    if( $hit->isa('Bio::Search::Hit::HitI') ) { \n\treturn $iter->add_hit(-hit => $hit);\n    } else { \n        $self->throw(\"Passed in a \" .ref($hit). \n                     \" as a Iteration which is not a Bio::Search::Hit::HitI.\");\n    }\n    return $iter->num_hits;\n}\n\n=head2 add_iteration\n\n Title   : add_iteration\n Usage   : $report->add_iteration($iteration)\n Function: Adds a IterationI to the stored list of iterations\n Returns : Number of IterationI currently stored\n Args    : Bio::Search::Iteration::IterationI\n\n\nsub add_iteration {\n    my ($self,$i) = @_;\n    if( $i->isa('Bio::Search::Iteration::IterationI') ) { \n        push @{$self->{'_iterations'}}, $i;\n        $self->{'_iteration_count'}++;\n    } else { \n        $self->throw(\"Passed in a \" .ref($i). \n                     \" as a Iteration which is not a Bio::Search::Iteration::IterationI.\");\n    }\n    return scalar @{$self->{'_iterations'}};\n}\n\n\n=head2 next_iteration\n\n Title   : next_iteration\n Usage   : while( $it = $result->next_iteration()) { ... }\n Function: Returns the next Iteration object, representing all hits\n           found within a given PSI-Blast iteration.\n Returns : a Bio::Search::Iteration::IterationI object or undef if there are no more.\n Args    : none\n\n\nsub next_iteration {\n    my ($self) = @_;\n\n   unless($self->{'_iter_queue_started'}) {\n       $self->{'_iter_queue'} = [$self->iterations()];\n       $self->{'_iter_queue_started'} = 1;\n   }\n   return shift @{$self->{'_iter_queue'}};\n}\n\n=head2 iteration\n\n Usage     : $iteration = $blast->iteration( $number );\n Purpose   : Get an IterationI object for the specified iteration\n             in the search result (PSI-BLAST).\n Returns   : Bio::Search::Iteration::IterationI object\n Throws    : Bio::Root::NoSuchThing exception if $number is not within \n             range of the number of iterations in this report.\n Argument  : integer (optional, if not specified get the last iteration)\n             First iteration = 1\n\n\nsub iteration {\n    my ($self,$num) = @_;\n    $num = scalar @{$self->{'_iterations'}} unless defined $num;\n    unless ($num >= 1 and $num <= scalar $self->{'_iteration_count'}) {\n        $self->throw(-class=>'Bio::Root::NoSuchThing',\n                     -text=>\"No such iteration number: $num. Valid range=1-$self->{'_iteration_count'}\",\n                     -value=>$num);\n    }\n    return $self->{'_iterations'}->[$num-1];\n}\n\n=head2 num_iterations\n\n Usage     : $num_iterations = $blast->num_iterations; \n Purpose   : Get the number of iterations in the search result (PSI-BLAST).\n Returns   : Total number of iterations in the report\n Argument  : none (read-only)\n\n\nsub num_iterations { shift->{'_iteration_count'} }\n\n# Methods provided for consistency with BPpsilite.pm (now deprecated);\n# these are now merely synonyms\n\n=head2 number_of_iterations\n\n Usage     : $num_iterations = $blast->number_of_iterations; \n Purpose   : Get the number of iterations in the search result (PSI-BLAST).\n Returns   : Total number of iterations in the report\n Argument  : none (read-only)\n Note      : Alias of L<num_iterations>.\n\n\nsub number_of_iterations { shift->num_iterations }\n\n=head2 round\n\n Usage     : $round = $blast->round( $number );\n Purpose   : Get an IterationI object for the specified iteration\n             in the search result (PSI-BLAST).\n Returns   : Bio::Search::Iteration::IterationI object\n Throws    : Bio::Root::NoSuchThing exception if $number is not within \n             range of the number of iterations in this report.\n Argument  : integer (optional, if not specified get the last iteration)\n             First iteration = 1\n Note      : Alias of L<iteration>.\n\n\nsub round { shift->iteration(@_) }\n\n\n=head2 iterations\n\n Title   : iterations\n Usage   : my @iterations = $result->iterations\n Function: Returns the IterationI objects contained within this Result\n Returns : Array of L<Bio::Search::Iteration::IterationI> objects\n Args    : none\n\n\nsub iterations { \n    my $self = shift;\n    my @its = ();\n    if( ref($self->{'_iterations'}) =~ /ARRAY/i ) {\n       @its = @{$self->{'_iterations'}};\n    }\n    return @its;\n}\n\n=head2 psiblast\n\n Usage     : if( $blast->psiblast ) { ... }\n Purpose   : Set/get a boolean indicator whether or not the report \n             is a PSI-BLAST report.\n Returns   : 1 if PSI-BLAST, undef if not.\n Argument  : 1 (when setting)"},"kind":12,"line":408,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"psiblast","line":410,"kind":13},{"name":"$val","containerName":"psiblast","kind":13,"line":410},{"line":411,"kind":13,"containerName":"psiblast","name":"$val"},{"containerName":"psiblast","name":"$self","line":412,"kind":13},{"containerName":"psiblast","name":"$self","kind":13,"line":414}],"name":"psiblast","range":{"start":{"line":408,"character":0},"end":{"character":9999,"line":415}}},{"name":"no_hits_found","range":{"end":{"character":9999,"line":468},"start":{"character":0,"line":439}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$round"}],"documentation":"1;\n# $Id: BlastResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::BlastResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::BlastResult - Blast-specific subclass of Bio::Search::Result::GenericResult\n\n=head1 SYNOPSIS\n\n    # Working with iterations (PSI-BLAST results)\n\n    $result->next_iteration();\n    $result->num_iterations();\n    $result->iteration();\n    $result->iterations();\n\n# See Bio::Search::Result::GenericResult for information about working with Results.\n\n# See L<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>\n# for details about working with iterations.\n\n# TODO:\n#     * Show how to configure a SearchIO stream so that it generates\n#       BlastResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is a subclass of Bio::Search::Result::GenericResult\nand provides some operations that facilitate working with BLAST\nand PSI-BLAST results.\n\nFor general information about working with Results, see \nBio::Search::Result::GenericResult.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::BlastResult;\nuse strict;\n\nuse Bio::Search::BlastStatistics;\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::BlastResult->new();\n Function: Builds a new Bio::Search::Result::BlastResult object\n Returns : Bio::Search::Result::BlastResult\n Args    : See Bio::Search::Result::GenericResult();\n           The following parameters are specific to BlastResult:\n             -iterations  => array ref of Bio::Search::Iteration::IterationI objects\n             -inclusion_threshold => e-value threshold for inclusion in the\n                                     PSI-BLAST score matrix model (blastpgp)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_iterations'} = [];\n  $self->{'_iteration_index'} = 0;\n  $self->{'_iteration_count'} = 0;\n\n  my( $iters, $ithresh ) = $self->_rearrange([qw(ITERATIONS\n                                                 INCLUSION_THRESHOLD)],@args);\n\n  $self->{'_inclusion_threshold'} = $ithresh;  # This is a read-only variable\n\n  if( defined $iters  ) {\n      $self->throw(\"Must define arrayref of Iterations when initializing a $class\\n\") unless ref($iters) =~ /array/i;\n\n      foreach my $i ( @{$iters} ) {\n          $self->add_iteration($i);\n      }\n  } \n  else {\n      # This shouldn't get called with the new SearchIO::blast.\n      print STDERR \"BlastResult::new(): Not adding iterations.\\n\";\n      $self->{'_no_iterations'} = 1;\n  }\n\n  return $self;\n}\n\n\n=head2 hits\n\n Title   : hits\n Usage   : my @hits = $result->hits\n Function: Returns the available hits for this Result\n Returns : Array of L<Bio::Search::Hit::HitI> objects\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::hits> to\n           take into account the possibility of multiple iterations, as occurs\n           in PSI-BLAST reports.\n           If there are multiple iterations, all 'new' hits for all iterations\n           are returned. These are the hits that did not occur in a previous\n           iteration.\n\n           See Also: L<Bio::Search::Result::GenericResult::hits>\n\n\nsub hits {\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::hits;\n   }\n   my @hits = ();\n   foreach my $it ($self->iterations) {\n       push @hits, $it->hits;\n   }\n   return @hits;\n}\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::next_hit>\n           to take into account the possibility of multiple iterations, as\n           occurs in PSI-BLAST reports.\n\n           If there are multiple iterations, calling next_hit() traverses the\n           all of the hits, old and new, for each iteration, calling next_hit()\n           on each iteration.\n\n           See Also: L<Bio::Search::Iteration::GenericIteration::next_hit>\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    if ($self->{'_no_iterations'}) {\n        return $self->SUPER::next_hit(@args);\n    }\n\n    my $iter_index;\n    if (not defined $self->{'_last_hit'}) {\n        $iter_index = $self->{'_iter_index'} = $self->_next_iteration_index;\n    } else {\n        $iter_index = $self->{'_iter_index'};\n    }\n\n    return if $iter_index >= scalar @{$self->{'_iterations'}};\n\n    my $it = $self->{'_iterations'}->[$iter_index];\n    my $hit = $self->{'_last_hit'} = $it->next_hit;\n\n    return defined($hit) ? $hit : $self->next_hit;\n}\n\n\n=head2 num_hits\n\n Title   : num_hits\n Usage   : my $hitcount= $result->num_hits\n Function: returns the number of hits for this query result\n Returns : integer\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::num_hits>\n           to take into account the possibility of multiple iterations, as\n           occurs in PSI-BLAST reports.\n\n           If there are multiple iterations, calling num_hits() returns the\n           number of 'new' hits for each iteration. These are the hits that did\n           not occur in a previous iteration.\n\n           See Also: L<Bio::Search::Result::GenericResult::num_hits>\n\n\nsub num_hits{\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::num_hits;\n   }\n   if (not defined $self->{'_iterations'}) {\n       $self->throw(\"Can't get Hits: data not collected.\");\n    }\n    return scalar( $self->hits );\n}\n\n=head2 add_hit\n\n Title   : add_hit\n Usage   : $report->add_hit($hit)\n Function: Adds a HitI to the stored list of hits\n Returns : Number of HitI currently stored\n Args    : Bio::Search::Hit::HitI\n\n\nsub add_hit {\n    my ($self,$hit) = @_;\n    my $iter = $self->iteration;\n    if( $hit->isa('Bio::Search::Hit::HitI') ) { \n\treturn $iter->add_hit(-hit => $hit);\n    } else { \n        $self->throw(\"Passed in a \" .ref($hit). \n                     \" as a Iteration which is not a Bio::Search::Hit::HitI.\");\n    }\n    return $iter->num_hits;\n}\n\n=head2 add_iteration\n\n Title   : add_iteration\n Usage   : $report->add_iteration($iteration)\n Function: Adds a IterationI to the stored list of iterations\n Returns : Number of IterationI currently stored\n Args    : Bio::Search::Iteration::IterationI\n\n\nsub add_iteration {\n    my ($self,$i) = @_;\n    if( $i->isa('Bio::Search::Iteration::IterationI') ) { \n        push @{$self->{'_iterations'}}, $i;\n        $self->{'_iteration_count'}++;\n    } else { \n        $self->throw(\"Passed in a \" .ref($i). \n                     \" as a Iteration which is not a Bio::Search::Iteration::IterationI.\");\n    }\n    return scalar @{$self->{'_iterations'}};\n}\n\n\n=head2 next_iteration\n\n Title   : next_iteration\n Usage   : while( $it = $result->next_iteration()) { ... }\n Function: Returns the next Iteration object, representing all hits\n           found within a given PSI-Blast iteration.\n Returns : a Bio::Search::Iteration::IterationI object or undef if there are no more.\n Args    : none\n\n\nsub next_iteration {\n    my ($self) = @_;\n\n   unless($self->{'_iter_queue_started'}) {\n       $self->{'_iter_queue'} = [$self->iterations()];\n       $self->{'_iter_queue_started'} = 1;\n   }\n   return shift @{$self->{'_iter_queue'}};\n}\n\n=head2 iteration\n\n Usage     : $iteration = $blast->iteration( $number );\n Purpose   : Get an IterationI object for the specified iteration\n             in the search result (PSI-BLAST).\n Returns   : Bio::Search::Iteration::IterationI object\n Throws    : Bio::Root::NoSuchThing exception if $number is not within \n             range of the number of iterations in this report.\n Argument  : integer (optional, if not specified get the last iteration)\n             First iteration = 1\n\n\nsub iteration {\n    my ($self,$num) = @_;\n    $num = scalar @{$self->{'_iterations'}} unless defined $num;\n    unless ($num >= 1 and $num <= scalar $self->{'_iteration_count'}) {\n        $self->throw(-class=>'Bio::Root::NoSuchThing',\n                     -text=>\"No such iteration number: $num. Valid range=1-$self->{'_iteration_count'}\",\n                     -value=>$num);\n    }\n    return $self->{'_iterations'}->[$num-1];\n}\n\n=head2 num_iterations\n\n Usage     : $num_iterations = $blast->num_iterations; \n Purpose   : Get the number of iterations in the search result (PSI-BLAST).\n Returns   : Total number of iterations in the report\n Argument  : none (read-only)\n\n\nsub num_iterations { shift->{'_iteration_count'} }\n\n# Methods provided for consistency with BPpsilite.pm (now deprecated);\n# these are now merely synonyms\n\n=head2 number_of_iterations\n\n Usage     : $num_iterations = $blast->number_of_iterations; \n Purpose   : Get the number of iterations in the search result (PSI-BLAST).\n Returns   : Total number of iterations in the report\n Argument  : none (read-only)\n Note      : Alias of L<num_iterations>.\n\n\nsub number_of_iterations { shift->num_iterations }\n\n=head2 round\n\n Usage     : $round = $blast->round( $number );\n Purpose   : Get an IterationI object for the specified iteration\n             in the search result (PSI-BLAST).\n Returns   : Bio::Search::Iteration::IterationI object\n Throws    : Bio::Root::NoSuchThing exception if $number is not within \n             range of the number of iterations in this report.\n Argument  : integer (optional, if not specified get the last iteration)\n             First iteration = 1\n Note      : Alias of L<iteration>.\n\n\nsub round { shift->iteration(@_) }\n\n\n=head2 iterations\n\n Title   : iterations\n Usage   : my @iterations = $result->iterations\n Function: Returns the IterationI objects contained within this Result\n Returns : Array of L<Bio::Search::Iteration::IterationI> objects\n Args    : none\n\n\nsub iterations { \n    my $self = shift;\n    my @its = ();\n    if( ref($self->{'_iterations'}) =~ /ARRAY/i ) {\n       @its = @{$self->{'_iterations'}};\n    }\n    return @its;\n}\n\n=head2 psiblast\n\n Usage     : if( $blast->psiblast ) { ... }\n Purpose   : Set/get a boolean indicator whether or not the report \n             is a PSI-BLAST report.\n Returns   : 1 if PSI-BLAST, undef if not.\n Argument  : 1 (when setting)\n\n\n#----------------\nsub psiblast {\n#----------------\n    my ($self, $val ) = @_;\n    if( $val ) {\n        $self->{'_psiblast'} = 1;\n    }\n    return $self->{'_psiblast'};\n}\n\n\n=head2 no_hits_found\n\n Usage     : $nohits = $blast->no_hits_found( $iteration_number );\n Purpose   : Get boolean indicator indicating whether or not any hits\n             were present in the report.\n\n             This is NOT the same as determining the number of hits via\n             the hits() method, which will return zero hits if there were no\n             hits in the report or if all hits were filtered out during the parse.\n\n             Thus, this method can be used to distinguish these possibilities\n             for hitless reports generated when filtering.\n\n Returns   : Boolean\n Argument  : (optional) integer indicating the iteration number (PSI-BLAST)\n             If iteration number is not specified and this is a PSI-BLAST result,\n             then this method will return true only if all iterations had\n             no hits found.","label":"no_hits_found($self,$round)"},"detail":"($self,$round)","kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"no_hits_found","line":440,"kind":13},{"containerName":"no_hits_found","name":"$round","line":440,"kind":13},{"kind":13,"line":442,"containerName":"no_hits_found","name":"$result","definition":"my","localvar":"my"},{"name":"$round","containerName":"no_hits_found","kind":13,"line":449},{"containerName":"no_hits_found","name":"$self","kind":13,"line":450},{"name":"$result","containerName":"no_hits_found","kind":13,"line":451},{"kind":13,"line":452,"name":"$i","definition":"my","containerName":"no_hits_found","localvar":"my"},{"name":"$self","containerName":"no_hits_found","kind":13,"line":452},{"line":453,"kind":13,"name":"$self","containerName":"no_hits_found"},{"containerName":"no_hits_found","name":"$result","line":454,"kind":13},{"name":"$result","containerName":"no_hits_found","kind":13,"line":460},{"name":"$self","containerName":"no_hits_found","kind":13,"line":460},{"name":"$result","containerName":"no_hits_found","line":464,"kind":13},{"kind":13,"line":464,"name":"$self","containerName":"no_hits_found"},{"kind":13,"line":467,"name":"$result","containerName":"no_hits_found"}],"line":439},{"detail":"($self,$round)","signature":{"label":"set_no_hits_found($self,$round)","documentation":"1;\n# $Id: BlastResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::BlastResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::BlastResult - Blast-specific subclass of Bio::Search::Result::GenericResult\n\n=head1 SYNOPSIS\n\n    # Working with iterations (PSI-BLAST results)\n\n    $result->next_iteration();\n    $result->num_iterations();\n    $result->iteration();\n    $result->iterations();\n\n# See Bio::Search::Result::GenericResult for information about working with Results.\n\n# See L<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>\n# for details about working with iterations.\n\n# TODO:\n#     * Show how to configure a SearchIO stream so that it generates\n#       BlastResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is a subclass of Bio::Search::Result::GenericResult\nand provides some operations that facilitate working with BLAST\nand PSI-BLAST results.\n\nFor general information about working with Results, see \nBio::Search::Result::GenericResult.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::BlastResult;\nuse strict;\n\nuse Bio::Search::BlastStatistics;\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::BlastResult->new();\n Function: Builds a new Bio::Search::Result::BlastResult object\n Returns : Bio::Search::Result::BlastResult\n Args    : See Bio::Search::Result::GenericResult();\n           The following parameters are specific to BlastResult:\n             -iterations  => array ref of Bio::Search::Iteration::IterationI objects\n             -inclusion_threshold => e-value threshold for inclusion in the\n                                     PSI-BLAST score matrix model (blastpgp)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_iterations'} = [];\n  $self->{'_iteration_index'} = 0;\n  $self->{'_iteration_count'} = 0;\n\n  my( $iters, $ithresh ) = $self->_rearrange([qw(ITERATIONS\n                                                 INCLUSION_THRESHOLD)],@args);\n\n  $self->{'_inclusion_threshold'} = $ithresh;  # This is a read-only variable\n\n  if( defined $iters  ) {\n      $self->throw(\"Must define arrayref of Iterations when initializing a $class\\n\") unless ref($iters) =~ /array/i;\n\n      foreach my $i ( @{$iters} ) {\n          $self->add_iteration($i);\n      }\n  } \n  else {\n      # This shouldn't get called with the new SearchIO::blast.\n      print STDERR \"BlastResult::new(): Not adding iterations.\\n\";\n      $self->{'_no_iterations'} = 1;\n  }\n\n  return $self;\n}\n\n\n=head2 hits\n\n Title   : hits\n Usage   : my @hits = $result->hits\n Function: Returns the available hits for this Result\n Returns : Array of L<Bio::Search::Hit::HitI> objects\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::hits> to\n           take into account the possibility of multiple iterations, as occurs\n           in PSI-BLAST reports.\n           If there are multiple iterations, all 'new' hits for all iterations\n           are returned. These are the hits that did not occur in a previous\n           iteration.\n\n           See Also: L<Bio::Search::Result::GenericResult::hits>\n\n\nsub hits {\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::hits;\n   }\n   my @hits = ();\n   foreach my $it ($self->iterations) {\n       push @hits, $it->hits;\n   }\n   return @hits;\n}\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::next_hit>\n           to take into account the possibility of multiple iterations, as\n           occurs in PSI-BLAST reports.\n\n           If there are multiple iterations, calling next_hit() traverses the\n           all of the hits, old and new, for each iteration, calling next_hit()\n           on each iteration.\n\n           See Also: L<Bio::Search::Iteration::GenericIteration::next_hit>\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    if ($self->{'_no_iterations'}) {\n        return $self->SUPER::next_hit(@args);\n    }\n\n    my $iter_index;\n    if (not defined $self->{'_last_hit'}) {\n        $iter_index = $self->{'_iter_index'} = $self->_next_iteration_index;\n    } else {\n        $iter_index = $self->{'_iter_index'};\n    }\n\n    return if $iter_index >= scalar @{$self->{'_iterations'}};\n\n    my $it = $self->{'_iterations'}->[$iter_index];\n    my $hit = $self->{'_last_hit'} = $it->next_hit;\n\n    return defined($hit) ? $hit : $self->next_hit;\n}\n\n\n=head2 num_hits\n\n Title   : num_hits\n Usage   : my $hitcount= $result->num_hits\n Function: returns the number of hits for this query result\n Returns : integer\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::num_hits>\n           to take into account the possibility of multiple iterations, as\n           occurs in PSI-BLAST reports.\n\n           If there are multiple iterations, calling num_hits() returns the\n           number of 'new' hits for each iteration. These are the hits that did\n           not occur in a previous iteration.\n\n           See Also: L<Bio::Search::Result::GenericResult::num_hits>\n\n\nsub num_hits{\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::num_hits;\n   }\n   if (not defined $self->{'_iterations'}) {\n       $self->throw(\"Can't get Hits: data not collected.\");\n    }\n    return scalar( $self->hits );\n}\n\n=head2 add_hit\n\n Title   : add_hit\n Usage   : $report->add_hit($hit)\n Function: Adds a HitI to the stored list of hits\n Returns : Number of HitI currently stored\n Args    : Bio::Search::Hit::HitI\n\n\nsub add_hit {\n    my ($self,$hit) = @_;\n    my $iter = $self->iteration;\n    if( $hit->isa('Bio::Search::Hit::HitI') ) { \n\treturn $iter->add_hit(-hit => $hit);\n    } else { \n        $self->throw(\"Passed in a \" .ref($hit). \n                     \" as a Iteration which is not a Bio::Search::Hit::HitI.\");\n    }\n    return $iter->num_hits;\n}\n\n=head2 add_iteration\n\n Title   : add_iteration\n Usage   : $report->add_iteration($iteration)\n Function: Adds a IterationI to the stored list of iterations\n Returns : Number of IterationI currently stored\n Args    : Bio::Search::Iteration::IterationI\n\n\nsub add_iteration {\n    my ($self,$i) = @_;\n    if( $i->isa('Bio::Search::Iteration::IterationI') ) { \n        push @{$self->{'_iterations'}}, $i;\n        $self->{'_iteration_count'}++;\n    } else { \n        $self->throw(\"Passed in a \" .ref($i). \n                     \" as a Iteration which is not a Bio::Search::Iteration::IterationI.\");\n    }\n    return scalar @{$self->{'_iterations'}};\n}\n\n\n=head2 next_iteration\n\n Title   : next_iteration\n Usage   : while( $it = $result->next_iteration()) { ... }\n Function: Returns the next Iteration object, representing all hits\n           found within a given PSI-Blast iteration.\n Returns : a Bio::Search::Iteration::IterationI object or undef if there are no more.\n Args    : none\n\n\nsub next_iteration {\n    my ($self) = @_;\n\n   unless($self->{'_iter_queue_started'}) {\n       $self->{'_iter_queue'} = [$self->iterations()];\n       $self->{'_iter_queue_started'} = 1;\n   }\n   return shift @{$self->{'_iter_queue'}};\n}\n\n=head2 iteration\n\n Usage     : $iteration = $blast->iteration( $number );\n Purpose   : Get an IterationI object for the specified iteration\n             in the search result (PSI-BLAST).\n Returns   : Bio::Search::Iteration::IterationI object\n Throws    : Bio::Root::NoSuchThing exception if $number is not within \n             range of the number of iterations in this report.\n Argument  : integer (optional, if not specified get the last iteration)\n             First iteration = 1\n\n\nsub iteration {\n    my ($self,$num) = @_;\n    $num = scalar @{$self->{'_iterations'}} unless defined $num;\n    unless ($num >= 1 and $num <= scalar $self->{'_iteration_count'}) {\n        $self->throw(-class=>'Bio::Root::NoSuchThing',\n                     -text=>\"No such iteration number: $num. Valid range=1-$self->{'_iteration_count'}\",\n                     -value=>$num);\n    }\n    return $self->{'_iterations'}->[$num-1];\n}\n\n=head2 num_iterations\n\n Usage     : $num_iterations = $blast->num_iterations; \n Purpose   : Get the number of iterations in the search result (PSI-BLAST).\n Returns   : Total number of iterations in the report\n Argument  : none (read-only)\n\n\nsub num_iterations { shift->{'_iteration_count'} }\n\n# Methods provided for consistency with BPpsilite.pm (now deprecated);\n# these are now merely synonyms\n\n=head2 number_of_iterations\n\n Usage     : $num_iterations = $blast->number_of_iterations; \n Purpose   : Get the number of iterations in the search result (PSI-BLAST).\n Returns   : Total number of iterations in the report\n Argument  : none (read-only)\n Note      : Alias of L<num_iterations>.\n\n\nsub number_of_iterations { shift->num_iterations }\n\n=head2 round\n\n Usage     : $round = $blast->round( $number );\n Purpose   : Get an IterationI object for the specified iteration\n             in the search result (PSI-BLAST).\n Returns   : Bio::Search::Iteration::IterationI object\n Throws    : Bio::Root::NoSuchThing exception if $number is not within \n             range of the number of iterations in this report.\n Argument  : integer (optional, if not specified get the last iteration)\n             First iteration = 1\n Note      : Alias of L<iteration>.\n\n\nsub round { shift->iteration(@_) }\n\n\n=head2 iterations\n\n Title   : iterations\n Usage   : my @iterations = $result->iterations\n Function: Returns the IterationI objects contained within this Result\n Returns : Array of L<Bio::Search::Iteration::IterationI> objects\n Args    : none\n\n\nsub iterations { \n    my $self = shift;\n    my @its = ();\n    if( ref($self->{'_iterations'}) =~ /ARRAY/i ) {\n       @its = @{$self->{'_iterations'}};\n    }\n    return @its;\n}\n\n=head2 psiblast\n\n Usage     : if( $blast->psiblast ) { ... }\n Purpose   : Set/get a boolean indicator whether or not the report \n             is a PSI-BLAST report.\n Returns   : 1 if PSI-BLAST, undef if not.\n Argument  : 1 (when setting)\n\n\n#----------------\nsub psiblast {\n#----------------\n    my ($self, $val ) = @_;\n    if( $val ) {\n        $self->{'_psiblast'} = 1;\n    }\n    return $self->{'_psiblast'};\n}\n\n\n=head2 no_hits_found\n\n Usage     : $nohits = $blast->no_hits_found( $iteration_number );\n Purpose   : Get boolean indicator indicating whether or not any hits\n             were present in the report.\n\n             This is NOT the same as determining the number of hits via\n             the hits() method, which will return zero hits if there were no\n             hits in the report or if all hits were filtered out during the parse.\n\n             Thus, this method can be used to distinguish these possibilities\n             for hitless reports generated when filtering.\n\n Returns   : Boolean\n Argument  : (optional) integer indicating the iteration number (PSI-BLAST)\n             If iteration number is not specified and this is a PSI-BLAST result,\n             then this method will return true only if all iterations had\n             no hits found.\n\n\nsub no_hits_found {\n    my ($self, $round) = @_;\n\n    my $result = 0;   # final return value of this method.\n    # Watch the double negative! \n    # result = 0 means \"yes hits were found\"\n    # result = 1 means \"no hits were found\" (for the indicated iteration or all iterations)\n\n    # If a iteration was not specified and there were multiple iterations,\n    # this method should return true only if all iterations had no hits found.\n    if( not defined $round ) {\n        if( $self->{'_iterations'} > 1) {\n            $result = 1;\n            foreach my $i( 1..$self->{'_iterations'} ) {\n                if( not defined $self->{\"_iteration_$i\"}->{'_no_hits_found'} ) {\n                    $result = 0;\n                    last;\n                }\n            }\n        }\n        else {\n            $result = $self->{\"_iteration_1\"}->{'_no_hits_found'};\n        }\n    }\n    else {\n        $result = $self->{\"_iteration_$round\"}->{'_no_hits_found'};\n    }\n\n    return $result;\n}\n\n\n=head2 set_no_hits_found\n\n Usage     : $blast->set_no_hits_found( $iteration_number ); \n Purpose   : Set boolean indicator indicating whether or not any hits\n             were present in the report.\n Returns   : n/a\n Argument  : (optional) integer indicating the iteration number (PSI-BLAST)","parameters":[{"label":"$self"},{"label":"$round"}]},"containerName":"main::","definition":"sub","line":481,"children":[{"kind":13,"line":482,"containerName":"set_no_hits_found","definition":"my","name":"$self","localvar":"my"},{"containerName":"set_no_hits_found","name":"$round","kind":13,"line":482},{"name":"$round","containerName":"set_no_hits_found","line":483,"kind":13},{"kind":13,"line":484,"name":"$self","containerName":"set_no_hits_found"}],"kind":12,"range":{"end":{"line":485,"character":9999},"start":{"character":0,"line":481}},"name":"set_no_hits_found"},{"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: BlastResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::BlastResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::BlastResult - Blast-specific subclass of Bio::Search::Result::GenericResult\n\n=head1 SYNOPSIS\n\n    # Working with iterations (PSI-BLAST results)\n\n    $result->next_iteration();\n    $result->num_iterations();\n    $result->iteration();\n    $result->iterations();\n\n# See Bio::Search::Result::GenericResult for information about working with Results.\n\n# See L<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>\n# for details about working with iterations.\n\n# TODO:\n#     * Show how to configure a SearchIO stream so that it generates\n#       BlastResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is a subclass of Bio::Search::Result::GenericResult\nand provides some operations that facilitate working with BLAST\nand PSI-BLAST results.\n\nFor general information about working with Results, see \nBio::Search::Result::GenericResult.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::BlastResult;\nuse strict;\n\nuse Bio::Search::BlastStatistics;\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::BlastResult->new();\n Function: Builds a new Bio::Search::Result::BlastResult object\n Returns : Bio::Search::Result::BlastResult\n Args    : See Bio::Search::Result::GenericResult();\n           The following parameters are specific to BlastResult:\n             -iterations  => array ref of Bio::Search::Iteration::IterationI objects\n             -inclusion_threshold => e-value threshold for inclusion in the\n                                     PSI-BLAST score matrix model (blastpgp)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_iterations'} = [];\n  $self->{'_iteration_index'} = 0;\n  $self->{'_iteration_count'} = 0;\n\n  my( $iters, $ithresh ) = $self->_rearrange([qw(ITERATIONS\n                                                 INCLUSION_THRESHOLD)],@args);\n\n  $self->{'_inclusion_threshold'} = $ithresh;  # This is a read-only variable\n\n  if( defined $iters  ) {\n      $self->throw(\"Must define arrayref of Iterations when initializing a $class\\n\") unless ref($iters) =~ /array/i;\n\n      foreach my $i ( @{$iters} ) {\n          $self->add_iteration($i);\n      }\n  } \n  else {\n      # This shouldn't get called with the new SearchIO::blast.\n      print STDERR \"BlastResult::new(): Not adding iterations.\\n\";\n      $self->{'_no_iterations'} = 1;\n  }\n\n  return $self;\n}\n\n\n=head2 hits\n\n Title   : hits\n Usage   : my @hits = $result->hits\n Function: Returns the available hits for this Result\n Returns : Array of L<Bio::Search::Hit::HitI> objects\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::hits> to\n           take into account the possibility of multiple iterations, as occurs\n           in PSI-BLAST reports.\n           If there are multiple iterations, all 'new' hits for all iterations\n           are returned. These are the hits that did not occur in a previous\n           iteration.\n\n           See Also: L<Bio::Search::Result::GenericResult::hits>\n\n\nsub hits {\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::hits;\n   }\n   my @hits = ();\n   foreach my $it ($self->iterations) {\n       push @hits, $it->hits;\n   }\n   return @hits;\n}\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::next_hit>\n           to take into account the possibility of multiple iterations, as\n           occurs in PSI-BLAST reports.\n\n           If there are multiple iterations, calling next_hit() traverses the\n           all of the hits, old and new, for each iteration, calling next_hit()\n           on each iteration.\n\n           See Also: L<Bio::Search::Iteration::GenericIteration::next_hit>\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    if ($self->{'_no_iterations'}) {\n        return $self->SUPER::next_hit(@args);\n    }\n\n    my $iter_index;\n    if (not defined $self->{'_last_hit'}) {\n        $iter_index = $self->{'_iter_index'} = $self->_next_iteration_index;\n    } else {\n        $iter_index = $self->{'_iter_index'};\n    }\n\n    return if $iter_index >= scalar @{$self->{'_iterations'}};\n\n    my $it = $self->{'_iterations'}->[$iter_index];\n    my $hit = $self->{'_last_hit'} = $it->next_hit;\n\n    return defined($hit) ? $hit : $self->next_hit;\n}\n\n\n=head2 num_hits\n\n Title   : num_hits\n Usage   : my $hitcount= $result->num_hits\n Function: returns the number of hits for this query result\n Returns : integer\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::num_hits>\n           to take into account the possibility of multiple iterations, as\n           occurs in PSI-BLAST reports.\n\n           If there are multiple iterations, calling num_hits() returns the\n           number of 'new' hits for each iteration. These are the hits that did\n           not occur in a previous iteration.\n\n           See Also: L<Bio::Search::Result::GenericResult::num_hits>\n\n\nsub num_hits{\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::num_hits;\n   }\n   if (not defined $self->{'_iterations'}) {\n       $self->throw(\"Can't get Hits: data not collected.\");\n    }\n    return scalar( $self->hits );\n}\n\n=head2 add_hit\n\n Title   : add_hit\n Usage   : $report->add_hit($hit)\n Function: Adds a HitI to the stored list of hits\n Returns : Number of HitI currently stored\n Args    : Bio::Search::Hit::HitI\n\n\nsub add_hit {\n    my ($self,$hit) = @_;\n    my $iter = $self->iteration;\n    if( $hit->isa('Bio::Search::Hit::HitI') ) { \n\treturn $iter->add_hit(-hit => $hit);\n    } else { \n        $self->throw(\"Passed in a \" .ref($hit). \n                     \" as a Iteration which is not a Bio::Search::Hit::HitI.\");\n    }\n    return $iter->num_hits;\n}\n\n=head2 add_iteration\n\n Title   : add_iteration\n Usage   : $report->add_iteration($iteration)\n Function: Adds a IterationI to the stored list of iterations\n Returns : Number of IterationI currently stored\n Args    : Bio::Search::Iteration::IterationI\n\n\nsub add_iteration {\n    my ($self,$i) = @_;\n    if( $i->isa('Bio::Search::Iteration::IterationI') ) { \n        push @{$self->{'_iterations'}}, $i;\n        $self->{'_iteration_count'}++;\n    } else { \n        $self->throw(\"Passed in a \" .ref($i). \n                     \" as a Iteration which is not a Bio::Search::Iteration::IterationI.\");\n    }\n    return scalar @{$self->{'_iterations'}};\n}\n\n\n=head2 next_iteration\n\n Title   : next_iteration\n Usage   : while( $it = $result->next_iteration()) { ... }\n Function: Returns the next Iteration object, representing all hits\n           found within a given PSI-Blast iteration.\n Returns : a Bio::Search::Iteration::IterationI object or undef if there are no more.\n Args    : none\n\n\nsub next_iteration {\n    my ($self) = @_;\n\n   unless($self->{'_iter_queue_started'}) {\n       $self->{'_iter_queue'} = [$self->iterations()];\n       $self->{'_iter_queue_started'} = 1;\n   }\n   return shift @{$self->{'_iter_queue'}};\n}\n\n=head2 iteration\n\n Usage     : $iteration = $blast->iteration( $number );\n Purpose   : Get an IterationI object for the specified iteration\n             in the search result (PSI-BLAST).\n Returns   : Bio::Search::Iteration::IterationI object\n Throws    : Bio::Root::NoSuchThing exception if $number is not within \n             range of the number of iterations in this report.\n Argument  : integer (optional, if not specified get the last iteration)\n             First iteration = 1\n\n\nsub iteration {\n    my ($self,$num) = @_;\n    $num = scalar @{$self->{'_iterations'}} unless defined $num;\n    unless ($num >= 1 and $num <= scalar $self->{'_iteration_count'}) {\n        $self->throw(-class=>'Bio::Root::NoSuchThing',\n                     -text=>\"No such iteration number: $num. Valid range=1-$self->{'_iteration_count'}\",\n                     -value=>$num);\n    }\n    return $self->{'_iterations'}->[$num-1];\n}\n\n=head2 num_iterations\n\n Usage     : $num_iterations = $blast->num_iterations; \n Purpose   : Get the number of iterations in the search result (PSI-BLAST).\n Returns   : Total number of iterations in the report\n Argument  : none (read-only)\n\n\nsub num_iterations { shift->{'_iteration_count'} }\n\n# Methods provided for consistency with BPpsilite.pm (now deprecated);\n# these are now merely synonyms\n\n=head2 number_of_iterations\n\n Usage     : $num_iterations = $blast->number_of_iterations; \n Purpose   : Get the number of iterations in the search result (PSI-BLAST).\n Returns   : Total number of iterations in the report\n Argument  : none (read-only)\n Note      : Alias of L<num_iterations>.\n\n\nsub number_of_iterations { shift->num_iterations }\n\n=head2 round\n\n Usage     : $round = $blast->round( $number );\n Purpose   : Get an IterationI object for the specified iteration\n             in the search result (PSI-BLAST).\n Returns   : Bio::Search::Iteration::IterationI object\n Throws    : Bio::Root::NoSuchThing exception if $number is not within \n             range of the number of iterations in this report.\n Argument  : integer (optional, if not specified get the last iteration)\n             First iteration = 1\n Note      : Alias of L<iteration>.\n\n\nsub round { shift->iteration(@_) }\n\n\n=head2 iterations\n\n Title   : iterations\n Usage   : my @iterations = $result->iterations\n Function: Returns the IterationI objects contained within this Result\n Returns : Array of L<Bio::Search::Iteration::IterationI> objects\n Args    : none\n\n\nsub iterations { \n    my $self = shift;\n    my @its = ();\n    if( ref($self->{'_iterations'}) =~ /ARRAY/i ) {\n       @its = @{$self->{'_iterations'}};\n    }\n    return @its;\n}\n\n=head2 psiblast\n\n Usage     : if( $blast->psiblast ) { ... }\n Purpose   : Set/get a boolean indicator whether or not the report \n             is a PSI-BLAST report.\n Returns   : 1 if PSI-BLAST, undef if not.\n Argument  : 1 (when setting)\n\n\n#----------------\nsub psiblast {\n#----------------\n    my ($self, $val ) = @_;\n    if( $val ) {\n        $self->{'_psiblast'} = 1;\n    }\n    return $self->{'_psiblast'};\n}\n\n\n=head2 no_hits_found\n\n Usage     : $nohits = $blast->no_hits_found( $iteration_number );\n Purpose   : Get boolean indicator indicating whether or not any hits\n             were present in the report.\n\n             This is NOT the same as determining the number of hits via\n             the hits() method, which will return zero hits if there were no\n             hits in the report or if all hits were filtered out during the parse.\n\n             Thus, this method can be used to distinguish these possibilities\n             for hitless reports generated when filtering.\n\n Returns   : Boolean\n Argument  : (optional) integer indicating the iteration number (PSI-BLAST)\n             If iteration number is not specified and this is a PSI-BLAST result,\n             then this method will return true only if all iterations had\n             no hits found.\n\n\nsub no_hits_found {\n    my ($self, $round) = @_;\n\n    my $result = 0;   # final return value of this method.\n    # Watch the double negative! \n    # result = 0 means \"yes hits were found\"\n    # result = 1 means \"no hits were found\" (for the indicated iteration or all iterations)\n\n    # If a iteration was not specified and there were multiple iterations,\n    # this method should return true only if all iterations had no hits found.\n    if( not defined $round ) {\n        if( $self->{'_iterations'} > 1) {\n            $result = 1;\n            foreach my $i( 1..$self->{'_iterations'} ) {\n                if( not defined $self->{\"_iteration_$i\"}->{'_no_hits_found'} ) {\n                    $result = 0;\n                    last;\n                }\n            }\n        }\n        else {\n            $result = $self->{\"_iteration_1\"}->{'_no_hits_found'};\n        }\n    }\n    else {\n        $result = $self->{\"_iteration_$round\"}->{'_no_hits_found'};\n    }\n\n    return $result;\n}\n\n\n=head2 set_no_hits_found\n\n Usage     : $blast->set_no_hits_found( $iteration_number ); \n Purpose   : Set boolean indicator indicating whether or not any hits\n             were present in the report.\n Returns   : n/a\n Argument  : (optional) integer indicating the iteration number (PSI-BLAST)\n\n\nsub set_no_hits_found {\n    my ($self, $round) = @_;\n    $round ||= 1;\n    $self->{\"_iteration_$round\"}->{'_no_hits_found'} = 1;\n}\n\n=head2 _next_iteration_index\n\n Title   : _next_iteration_index\n Usage   : private","label":"_next_iteration_index($self,@args)"},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_next_iteration_index","line":495,"kind":13},{"line":495,"kind":13,"containerName":"_next_iteration_index","name":"@args"},{"line":496,"kind":13,"name":"$self","containerName":"_next_iteration_index"}],"line":494,"kind":12,"range":{"start":{"line":494,"character":0},"end":{"character":9999,"line":497}},"name":"_next_iteration_index"},{"containerName":"main::","definition":"sub","name":"rewind","range":{"end":{"character":9999,"line":518},"start":{"character":0,"line":511}},"kind":12,"line":511,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"rewind","line":512,"kind":13},{"containerName":"rewind","name":"$self","kind":13,"line":513},{"kind":13,"line":514,"containerName":"rewind","name":"$self"},{"kind":13,"line":515,"name":"$self","containerName":"rewind"},{"name":"iterations","containerName":"rewind","kind":12,"line":515},{"name":"rewind","containerName":"rewind","line":516,"kind":12}]},{"line":513,"kind":12,"name":"SUPER","containerName":"rewind"},{"line":533,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"inclusion_threshold","line":534,"kind":13},{"line":535,"kind":13,"containerName":"inclusion_threshold","name":"$self"}],"kind":12,"range":{"start":{"line":533,"character":0},"end":{"character":9999,"line":536}},"containerName":"main::","definition":"sub","name":"inclusion_threshold"}],"version":5}