{"version":5,"vars":[{"name":"base","containerName":"","kind":2,"line":91},{"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: HmmpfamHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::HmmpfamHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::HmmpfamHit - A parser and hit object for hmmpfam hits\n\n=head1 SYNOPSIS\n\n    # generally we use Bio::SearchIO to build these objects\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer_pull',\n\t\t\t\t\t\t\t   -file   => 'result.hmmer');\n\n    while (my $result = $in->next_result) {\n\t\twhile (my $hit = $result->next_hit) {\n\t\t\tprint $hit->name, \"\\n\";\n\t\t\tprint $hit->score, \"\\n\";\n\t\t\tprint $hit->significance, \"\\n\";\n\n\t\t\twhile (my $hsp = $hit->next_hsp) {\n\t\t\t\t# process HSPI objects\n\t\t\t}\n\t\t}\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for hmmpfam hit output, a program in the HMMER\npackage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::HmmpfamHit;\n\nuse strict;\n\nuse Bio::Search::HSP::HmmpfamHSP;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::PullHitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::HmmpfamHit->new();\n Function: Builds a new Bio::Search::Hit::HmmpfamHit object.\n Returns : Bio::Search::Hit::HmmpfamHit\n Args    : -chunk    => [Bio::Root::IO, $start, $end] (required if no -parent)\n           -parent   => Bio::PullParserI object (required if no -chunk)\n           -hit_data => array ref with [name description score significance\n\t\t                                num_hsps rank]\n\n           where the array ref provided to -chunk contains an IO object\n           for a filehandle to something representing the raw data of the\n           hit, and $start and $end define the tell() position within the\n           filehandle that the hit data starts and ends (optional; defaults\n           to start and end of the entire thing described by the filehandle)"},"detail":"($class,@args)","definition":"sub","containerName":"main::","children":[{"containerName":"new","definition":"my","name":"$class","localvar":"my","kind":13,"line":113},{"line":113,"kind":13,"containerName":"new","name":"@args"},{"kind":13,"line":114,"name":"$self","definition":"my","containerName":"new","localvar":"my"},{"line":114,"kind":13,"containerName":"new","name":"$class"},{"line":114,"kind":13,"name":"@args","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":116},{"kind":12,"line":116,"name":"_setup","containerName":"new"},{"kind":13,"line":116,"name":"@args","containerName":"new"},{"line":118,"kind":13,"localvar":"my","name":"$fields","definition":"my","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":118},{"containerName":"new","name":"_fields","line":118,"kind":12},{"line":119,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$field"},{"line":120,"kind":13,"name":"$fields","containerName":"new"},{"line":120,"kind":13,"name":"$field","containerName":"new"},{"kind":13,"line":123,"containerName":"new","name":"$hit_data","definition":"my","localvar":"my"},{"line":123,"kind":13,"name":"$self","containerName":"new"},{"name":"_raw_hit_data","containerName":"new","line":123,"kind":12},{"containerName":"new","name":"$hit_data","line":124,"kind":13},{"name":"$hit_data","containerName":"new","kind":13,"line":124},{"kind":13,"line":125,"definition":"my","name":"$field","containerName":"new","localvar":"my"},{"containerName":"new","name":"$fields","kind":13,"line":126},{"kind":13,"line":126,"name":"$field","containerName":"new"},{"line":126,"kind":13,"containerName":"new","name":"$hit_data"}],"line":112,"kind":12,"range":{"start":{"character":0,"line":112},"end":{"character":9999,"line":128}},"name":"new"},{"containerName":"new","name":"SUPER","kind":12,"line":114},{"line":129,"kind":13,"containerName":null,"name":"%fields"},{"kind":12,"line":129,"name":"hit_start"},{"kind":13,"line":131,"name":"$self","containerName":null},{"name":"_fields","containerName":"main::","kind":12,"line":131},{"name":"accession","line":131,"kind":12},{"line":133,"kind":13,"name":"$self","containerName":null},{"kind":12,"line":133,"name":"_dependencies","containerName":"main::"},{"kind":12,"line":133,"name":"length"},{"name":"$self","containerName":null,"line":135,"kind":13},{"kind":12,"line":142,"children":[],"containerName":"main::","definition":"sub","name":"_discover_description","range":{"end":{"character":9999,"line":147},"start":{"line":142,"character":0}}},{"range":{"end":{"character":9999,"line":161},"start":{"character":0,"line":149}},"containerName":"main::","name":"_discover_hsp_data","definition":"sub","line":149,"children":[{"line":150,"kind":13,"localvar":"my","containerName":"_discover_hsp_data","definition":"my","name":"$self"},{"definition":"my","name":"$hsp_table","containerName":"_discover_hsp_data","localvar":"my","kind":13,"line":151},{"containerName":"_discover_hsp_data","name":"$self","line":151,"kind":13},{"containerName":"_discover_hsp_data","name":"get_field","line":151,"kind":12},{"localvar":"my","containerName":"_discover_hsp_data","name":"$hsp_data","definition":"my","line":152,"kind":13},{"name":"$hsp_table","containerName":"_discover_hsp_data","line":152,"kind":13},{"line":152,"kind":13,"name":"$self","containerName":"_discover_hsp_data"},{"kind":12,"line":152,"name":"get_field","containerName":"_discover_hsp_data"},{"name":"$hsp_data","containerName":"_discover_hsp_data","line":153,"kind":13},{"name":"$hsp_data","containerName":"_discover_hsp_data","line":154,"kind":13},{"name":"$self","containerName":"_discover_hsp_data","line":155,"kind":13},{"kind":12,"line":155,"name":"_fields","containerName":"_discover_hsp_data"},{"containerName":"_discover_hsp_data","name":"$hsp_data","kind":13,"line":155},{"containerName":"_discover_hsp_data","name":"$self","kind":13,"line":159},{"name":"_fields","containerName":"_discover_hsp_data","line":159,"kind":12},{"containerName":"_discover_hsp_data","name":"$hsp_data","kind":13,"line":159}],"kind":12},{"name":"hit_length","line":154,"kind":12},{"name":"length","line":155,"kind":12},{"line":155,"kind":12,"name":"hit_length"},{"line":159,"kind":12,"name":"hsp_data"},{"name":"hsp_data","kind":12,"line":159},{"kind":12,"line":163,"children":[{"kind":13,"line":164,"definition":"my","name":"$self","containerName":"_discover_query_start","localvar":"my"},{"kind":13,"line":165,"definition":"my","name":"$hsp_data","containerName":"_discover_query_start","localvar":"my"},{"kind":13,"line":165,"name":"$self","containerName":"_discover_query_start"},{"containerName":"_discover_query_start","name":"get_field","line":165,"kind":12},{"localvar":"my","containerName":"_discover_query_start","definition":"my","name":"$this_hsp","line":167,"kind":13},{"containerName":"_discover_query_start","name":"$a","kind":13,"line":167},{"line":167,"kind":13,"containerName":"_discover_query_start","name":"$b"},{"containerName":"_discover_query_start","name":"$hsp_data","kind":13,"line":167}],"containerName":"main::","definition":"sub","name":"_discover_query_start","range":{"end":{"line":167,"character":9999},"start":{"character":0,"line":163}}},{"name":"$self","containerName":null,"kind":13,"line":168},{"name":"_fields","containerName":"main::","line":168,"kind":12},{"line":168,"kind":12,"name":"query_start"},{"name":"@this_hsp","containerName":null,"line":168,"kind":13},{"children":[{"localvar":"my","containerName":"_discover_query_end","definition":"my","name":"$self","line":172,"kind":13},{"name":"$hsp_data","definition":"my","containerName":"_discover_query_end","localvar":"my","kind":13,"line":173},{"name":"$self","containerName":"_discover_query_end","kind":13,"line":173},{"containerName":"_discover_query_end","name":"get_field","kind":12,"line":173},{"localvar":"my","definition":"my","name":"$this_hsp","containerName":"_discover_query_end","line":175,"kind":13},{"name":"$b","containerName":"_discover_query_end","line":175,"kind":13},{"kind":13,"line":175,"containerName":"_discover_query_end","name":"$a"},{"line":175,"kind":13,"containerName":"_discover_query_end","name":"$hsp_data"}],"line":171,"kind":12,"range":{"start":{"character":0,"line":171},"end":{"line":175,"character":9999}},"name":"_discover_query_end","definition":"sub","containerName":"main::"},{"line":176,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"line":176,"name":"_fields","containerName":"main::"},{"name":"query_end","line":176,"kind":12},{"kind":13,"line":176,"name":"@this_hsp","containerName":null},{"kind":12,"line":179,"children":[{"line":180,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_discover_hit_start"},{"localvar":"my","definition":"my","name":"$hsp_data","containerName":"_discover_hit_start","line":181,"kind":13},{"containerName":"_discover_hit_start","name":"$self","line":181,"kind":13},{"line":181,"kind":12,"containerName":"_discover_hit_start","name":"get_field"},{"definition":"my","name":"$this_hsp","containerName":"_discover_hit_start","localvar":"my","kind":13,"line":183},{"name":"$a","containerName":"_discover_hit_start","line":183,"kind":13},{"name":"$b","containerName":"_discover_hit_start","line":183,"kind":13},{"kind":13,"line":183,"name":"$hsp_data","containerName":"_discover_hit_start"}],"containerName":"main::","definition":"sub","name":"_discover_hit_start","range":{"start":{"line":179,"character":0},"end":{"line":183,"character":9999}}},{"line":184,"kind":13,"name":"$self","containerName":null},{"containerName":"main::","name":"_fields","line":184,"kind":12},{"name":"hit_start","kind":12,"line":184},{"name":"@this_hsp","containerName":null,"line":184,"kind":13},{"kind":12,"children":[{"localvar":"my","containerName":"_discover_hit_end","definition":"my","name":"$self","line":188,"kind":13},{"containerName":"_discover_hit_end","definition":"my","name":"$hsp_data","localvar":"my","kind":13,"line":189},{"line":189,"kind":13,"name":"$self","containerName":"_discover_hit_end"},{"kind":12,"line":189,"containerName":"_discover_hit_end","name":"get_field"},{"kind":13,"line":191,"definition":"my","name":"$this_hsp","containerName":"_discover_hit_end","localvar":"my"},{"kind":13,"line":191,"name":"$b","containerName":"_discover_hit_end"},{"containerName":"_discover_hit_end","name":"$a","line":191,"kind":13},{"name":"$hsp_data","containerName":"_discover_hit_end","line":191,"kind":13}],"line":187,"definition":"sub","name":"_discover_hit_end","containerName":"main::","range":{"end":{"character":9999,"line":191},"start":{"character":0,"line":187}}},{"containerName":null,"name":"$self","kind":13,"line":192},{"name":"_fields","containerName":"main::","line":192,"kind":12},{"kind":12,"line":192,"name":"hit_end"},{"containerName":null,"name":"@this_hsp","line":192,"kind":13},{"children":[{"definition":"my","name":"$self","containerName":"_discover_next_hsp","localvar":"my","kind":13,"line":196},{"kind":13,"line":197,"containerName":"_discover_next_hsp","definition":"my","name":"$hsp_data","localvar":"my"},{"containerName":"_discover_next_hsp","name":"$self","line":197,"kind":13},{"kind":12,"line":197,"containerName":"_discover_next_hsp","name":"get_field"},{"name":"$self","containerName":"_discover_next_hsp","kind":13,"line":198},{"kind":13,"line":199,"name":"$self","containerName":"_discover_next_hsp"},{"kind":13,"line":201,"containerName":"_discover_next_hsp","name":"$self"},{"line":203,"kind":13,"containerName":"_discover_next_hsp","name":"$self"},{"name":"_fields","containerName":"_discover_next_hsp","line":203,"kind":12},{"containerName":"_discover_next_hsp","name":"new","line":203,"kind":12},{"line":203,"kind":13,"name":"$self","containerName":"_discover_next_hsp"},{"containerName":"_discover_next_hsp","name":"$hsp_data","kind":13,"line":204},{"line":204,"kind":13,"containerName":"_discover_next_hsp","name":"$self"},{"name":"$self","containerName":"_discover_next_hsp","line":206,"kind":13},{"name":"$hsp_data","containerName":"_discover_next_hsp","line":206,"kind":13}],"line":195,"kind":12,"range":{"end":{"line":206,"character":9999},"start":{"line":195,"character":0}},"name":"_discover_next_hsp","definition":"sub","containerName":"main::"},{"line":198,"kind":12,"name":"_next_hsp_index"},{"name":"_next_hsp_index","kind":12,"line":199},{"name":"_next_hsp_index","line":201,"kind":12},{"kind":12,"line":203,"name":"next_hsp"},{"name":"Bio","containerName":"Search::HSP::HmmpfamHSP","kind":12,"line":203},{"name":"_next_hsp_index","line":204,"kind":12},{"name":"_next_hsp_index","kind":12,"line":206},{"kind":13,"line":207,"containerName":null,"name":"%self"},{"line":207,"kind":12,"name":"_next_hsp_index"},{"range":{"start":{"line":222,"character":0},"end":{"character":9999,"line":227}},"containerName":"main::","definition":"sub","name":"next_hsp","line":222,"children":[{"line":223,"kind":13,"localvar":"my","containerName":"next_hsp","definition":"my","name":"$self"},{"line":224,"kind":13,"localvar":"my","definition":"my","name":"$hsp","containerName":"next_hsp"},{"containerName":"next_hsp","name":"$self","line":224,"kind":13},{"kind":12,"line":224,"name":"get_field","containerName":"next_hsp"},{"name":"$self","containerName":"next_hsp","kind":13,"line":225},{"containerName":"next_hsp","name":"_fields","line":225,"kind":12},{"line":226,"kind":13,"name":"$hsp","containerName":"next_hsp"}],"kind":12},{"kind":12,"line":225,"name":"next_hsp"},{"containerName":"main::","definition":"sub","name":"hsps","range":{"end":{"line":261,"character":9999},"start":{"character":0,"line":251}},"kind":12,"line":251,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"hsps","line":252,"kind":13},{"localvar":"my","name":"$old","definition":"my","containerName":"hsps","line":253,"kind":13},{"kind":13,"line":253,"name":"$self","containerName":"hsps"},{"containerName":"hsps","name":"$self","kind":13,"line":254},{"containerName":"hsps","name":"rewind","line":254,"kind":12},{"line":255,"kind":13,"localvar":"my","definition":"my","name":"@hsps","containerName":"hsps"},{"line":256,"kind":13,"localvar":"my","containerName":"hsps","definition":"my","name":"$hsp"},{"kind":13,"line":256,"containerName":"hsps","name":"$self"},{"containerName":"hsps","name":"next_hsp","kind":12,"line":256},{"containerName":"hsps","name":"@hsps","kind":13,"line":257},{"containerName":"hsps","name":"$hsp","line":257,"kind":13},{"line":259,"kind":13,"name":"$self","containerName":"hsps"},{"kind":13,"line":259,"name":"@hsps","containerName":"hsps"},{"name":"$old","containerName":"hsps","line":259,"kind":13},{"containerName":"hsps","name":"@hsps","line":260,"kind":13}]},{"name":"_next_hsp_index","line":253,"kind":12},{"kind":12,"line":259,"name":"_next_hsp_index"},{"name":"hsp","range":{"end":{"line":309,"character":9999},"start":{"line":293,"character":0}},"kind":12,"children":[{"kind":13,"line":294,"containerName":"hsp","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":294,"name":"$type","containerName":"hsp"},{"line":295,"kind":13,"containerName":"hsp","name":"$type"},{"localvar":"my","definition":"my","name":"$hsp_data","containerName":"hsp","line":296,"kind":13},{"line":296,"kind":13,"containerName":"hsp","name":"$self"},{"name":"get_field","containerName":"hsp","line":296,"kind":12},{"kind":13,"line":298,"definition":"my","name":"$sort","containerName":"hsp","localvar":"my"},{"kind":13,"line":299,"containerName":"hsp","name":"$type"},{"containerName":"hsp","name":"$sort","kind":13,"line":300},{"line":300,"kind":13,"name":"$a","containerName":"hsp"},{"line":300,"kind":13,"containerName":"hsp","name":"$b"},{"kind":13,"line":302,"name":"$type","containerName":"hsp"},{"kind":13,"line":303,"name":"$sort","containerName":"hsp"},{"kind":13,"line":303,"containerName":"hsp","name":"$b"},{"line":303,"kind":13,"name":"$a","containerName":"hsp"},{"containerName":"hsp","name":"$self","kind":13,"line":306},{"kind":12,"line":306,"name":"throw","containerName":"hsp"},{"kind":13,"line":309,"definition":"my","name":"$this_hsp","containerName":"hsp","localvar":"my"},{"kind":13,"line":309,"containerName":"hsp","name":"$sort"},{"kind":13,"line":309,"name":"$hsp_data","containerName":"hsp"}],"line":293,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: HmmpfamHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::HmmpfamHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::HmmpfamHit - A parser and hit object for hmmpfam hits\n\n=head1 SYNOPSIS\n\n    # generally we use Bio::SearchIO to build these objects\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer_pull',\n\t\t\t\t\t\t\t   -file   => 'result.hmmer');\n\n    while (my $result = $in->next_result) {\n\t\twhile (my $hit = $result->next_hit) {\n\t\t\tprint $hit->name, \"\\n\";\n\t\t\tprint $hit->score, \"\\n\";\n\t\t\tprint $hit->significance, \"\\n\";\n\n\t\t\twhile (my $hsp = $hit->next_hsp) {\n\t\t\t\t# process HSPI objects\n\t\t\t}\n\t\t}\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for hmmpfam hit output, a program in the HMMER\npackage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::HmmpfamHit;\n\nuse strict;\n\nuse Bio::Search::HSP::HmmpfamHSP;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::PullHitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::HmmpfamHit->new();\n Function: Builds a new Bio::Search::Hit::HmmpfamHit object.\n Returns : Bio::Search::Hit::HmmpfamHit\n Args    : -chunk    => [Bio::Root::IO, $start, $end] (required if no -parent)\n           -parent   => Bio::PullParserI object (required if no -chunk)\n           -hit_data => array ref with [name description score significance\n\t\t                                num_hsps rank]\n\n           where the array ref provided to -chunk contains an IO object\n           for a filehandle to something representing the raw data of the\n           hit, and $start and $end define the tell() position within the\n           filehandle that the hit data starts and ends (optional; defaults\n           to start and end of the entire thing described by the filehandle)\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\t\n\t$self->_setup(@args);\n\t\n\tmy $fields = $self->_fields;\n\tforeach my $field (qw( next_domain domains hsp_data )) {\n\t\t$fields->{$field} = undef;\n\t}\n\t\n\tmy $hit_data = $self->_raw_hit_data;\n\tif ($hit_data && ref($hit_data) eq 'ARRAY') {\n\t\tforeach my $field (qw(name description score significance num_hsps rank)) {\n\t\t\t$fields->{$field} = shift(@{$hit_data});\n\t\t}\n\t}\n\t$fields->{hit_start} = 1;\n\t\n\tdelete $self->_fields->{accession};\n\t\n\t$self->_dependencies( { ( length => 'hsp_data' ) } );\n\t\n    return $self;\n}\n\n#\n# PullParserI discovery methods so we can answer all HitI questions\n#\n\nsub _discover_description {\n\t# this should be set when this object is created, but if it was undef as is\n\t# possible, this _discover method will be called: just return and keep the\n\t# return value undef\n\treturn;\n}\n\nsub _discover_hsp_data {\n\tmy $self = shift;\n\tmy $hsp_table = $self->get_field('hsp_table');\n\tmy $hsp_data = $hsp_table->{$self->get_field('name')} || undef;\n\tif ($hsp_data) {\n\t\tif (defined $hsp_data->{hit_length}) {\n\t\t\t$self->_fields->{length} = $hsp_data->{hit_length};\n\t\t}\n\t\t\n\t\t# rank query_start query_end hit_start hit_end score evalue\n\t\t$self->_fields->{hsp_data} = $hsp_data->{hsp_data};\n\t}\n}\n\nsub _discover_query_start {\n\tmy $self = shift;\n\tmy $hsp_data = $self->get_field('hsp_data') || return;\n\t\n\tmy ($this_hsp) = sort { $a->[1] <=> $b->[1] } @{$hsp_data};\n\t$self->_fields->{query_start} = $this_hsp->[1];\n}\n\nsub _discover_query_end {\n\tmy $self = shift;\n\tmy $hsp_data = $self->get_field('hsp_data') || return;\n\t\n\tmy ($this_hsp) = sort { $b->[2] <=> $a->[2] } @{$hsp_data};\n\t$self->_fields->{query_end} = $this_hsp->[2];\n}\n\nsub _discover_hit_start {\n\tmy $self = shift;\n\tmy $hsp_data = $self->get_field('hsp_data') || return;\n\t\n\tmy ($this_hsp) = sort { $a->[3] <=> $b->[3] } @{$hsp_data};\n\t$self->_fields->{hit_start} = $this_hsp->[3];\n}\n\nsub _discover_hit_end {\n\tmy $self = shift;\n\tmy $hsp_data = $self->get_field('hsp_data') || return;\n\t\n\tmy ($this_hsp) = sort { $b->[4] <=> $a->[4] } @{$hsp_data};\n\t$self->_fields->{hit_end} = $this_hsp->[4];\n}\n\nsub _discover_next_hsp {\n\tmy $self = shift;\n\tmy $hsp_data = $self->get_field('hsp_data') || return;\n\tunless (defined $self->{_next_hsp_index}) {\n\t\t$self->{_next_hsp_index} = 0;\n\t}\n\treturn if $self->{_next_hsp_index} == -1;\n\t\n\t$self->_fields->{next_hsp} = Bio::Search::HSP::HmmpfamHSP->new(-parent => $self,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  -hsp_data => $hsp_data->[$self->{_next_hsp_index}++]);\n\t\n\tif ($self->{_next_hsp_index} > $#{$hsp_data}) {\n\t\t$self->{_next_hsp_index} = -1;\n\t}\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : L<Bio::Search::HSP::HSPI> object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    my $hsp = $self->get_field('next_hsp');\n\tundef $self->_fields->{next_hsp};\n\treturn $hsp;\n}\n\n=head2 next_domain\n\n Title   : next_domain \n Usage   : my $domain = $hit->next_domain();\n Function: An alias for L<next_hsp()>, this will return the next HSP\n Returns : L<Bio::Search::HSP::HSPI> object\n Args    : none\n\n\n*next_domain = \\&next_hsp;\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n Example   : @hsps = $hit_object->hsps();\n Returns   : list of L<Bio::Search::HSP::BlastHSP> objects.\n Argument  : none\n\n\nsub hsps {\n    my $self = shift;\n\tmy $old = $self->{_next_hsp_index} || 0;\n\t$self->rewind;\n\tmy @hsps;\n\twhile (defined(my $hsp = $self->next_hsp)) {\n\t\tpush(@hsps, $hsp);\n\t}\n\t$self->{_next_hsp_index} =  @hsps > 0 ? $old : -1;\n\treturn @hsps;\n}\n\n=head2 domains\n\n Title   : domains\n Usage   : my @domains = $hit->domains();\n Function: An alias for L<hsps()>, this will return the full list of hsps\n Returns : array of L<Bio::Search::HSP::HSPI> objects\n Args    : none\n\n\n*domains = \\&hsps;\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a L<Bio::Search::HSP::HSPI> object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best'  = highest scoring HSP.\n           :   'worst' = lowest scoring HSP.\n Throws    : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()","parameters":[{"label":"$self"},{"label":"$type"}],"label":"hsp($self,$type)"},"detail":"($self,$type)"},{"line":310,"kind":12,"containerName":"Search::HSP::HmmpfamHSP","name":"Bio"},{"kind":12,"line":310,"containerName":"main::","name":"new"},{"line":310,"kind":13,"containerName":null,"name":"$self"},{"kind":13,"line":310,"name":"$this_hsp","containerName":null},{"kind":12,"line":324,"children":[{"localvar":"my","containerName":"rewind","name":"$self","definition":"my","line":325,"kind":13},{"kind":13,"line":326,"definition":"my","name":"$hsp_data","containerName":"rewind","localvar":"my"},{"containerName":"rewind","name":"$self","kind":13,"line":326},{"containerName":"rewind","name":"get_field","line":326,"kind":12},{"line":327,"kind":13,"containerName":"rewind","name":"$self"},{"containerName":"rewind","name":"$hsp_data","kind":13,"line":327}],"containerName":"main::","definition":"sub","name":"rewind","range":{"end":{"line":327,"character":9999},"start":{"character":0,"line":324}}},{"name":"_next_hsp_index","line":327,"kind":12},{"kind":12,"line":331,"children":[{"name":"significance","containerName":"p","line":332,"kind":12}],"containerName":"main::","definition":"sub","name":"p","range":{"start":{"character":0,"line":331},"end":{"character":9999,"line":333}}},{"kind":12,"line":352,"children":[{"kind":13,"line":353,"containerName":"strand","name":"$self","definition":"my","localvar":"my"},{"name":"$type","containerName":"strand","kind":13,"line":353},{"name":"$type","containerName":"strand","kind":13,"line":354},{"line":355,"kind":13,"name":"$type","containerName":"strand"},{"kind":13,"line":355,"containerName":"strand","name":"$type"},{"containerName":"strand","name":"$type","kind":13,"line":356},{"line":356,"kind":13,"name":"$type","containerName":"strand"}],"containerName":"main::","definition":"sub","detail":"($self,$type)","signature":{"parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"1;\n# $Id: HmmpfamHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::HmmpfamHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::HmmpfamHit - A parser and hit object for hmmpfam hits\n\n=head1 SYNOPSIS\n\n    # generally we use Bio::SearchIO to build these objects\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer_pull',\n\t\t\t\t\t\t\t   -file   => 'result.hmmer');\n\n    while (my $result = $in->next_result) {\n\t\twhile (my $hit = $result->next_hit) {\n\t\t\tprint $hit->name, \"\\n\";\n\t\t\tprint $hit->score, \"\\n\";\n\t\t\tprint $hit->significance, \"\\n\";\n\n\t\t\twhile (my $hsp = $hit->next_hsp) {\n\t\t\t\t# process HSPI objects\n\t\t\t}\n\t\t}\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for hmmpfam hit output, a program in the HMMER\npackage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::HmmpfamHit;\n\nuse strict;\n\nuse Bio::Search::HSP::HmmpfamHSP;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::PullHitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::HmmpfamHit->new();\n Function: Builds a new Bio::Search::Hit::HmmpfamHit object.\n Returns : Bio::Search::Hit::HmmpfamHit\n Args    : -chunk    => [Bio::Root::IO, $start, $end] (required if no -parent)\n           -parent   => Bio::PullParserI object (required if no -chunk)\n           -hit_data => array ref with [name description score significance\n\t\t                                num_hsps rank]\n\n           where the array ref provided to -chunk contains an IO object\n           for a filehandle to something representing the raw data of the\n           hit, and $start and $end define the tell() position within the\n           filehandle that the hit data starts and ends (optional; defaults\n           to start and end of the entire thing described by the filehandle)\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\t\n\t$self->_setup(@args);\n\t\n\tmy $fields = $self->_fields;\n\tforeach my $field (qw( next_domain domains hsp_data )) {\n\t\t$fields->{$field} = undef;\n\t}\n\t\n\tmy $hit_data = $self->_raw_hit_data;\n\tif ($hit_data && ref($hit_data) eq 'ARRAY') {\n\t\tforeach my $field (qw(name description score significance num_hsps rank)) {\n\t\t\t$fields->{$field} = shift(@{$hit_data});\n\t\t}\n\t}\n\t$fields->{hit_start} = 1;\n\t\n\tdelete $self->_fields->{accession};\n\t\n\t$self->_dependencies( { ( length => 'hsp_data' ) } );\n\t\n    return $self;\n}\n\n#\n# PullParserI discovery methods so we can answer all HitI questions\n#\n\nsub _discover_description {\n\t# this should be set when this object is created, but if it was undef as is\n\t# possible, this _discover method will be called: just return and keep the\n\t# return value undef\n\treturn;\n}\n\nsub _discover_hsp_data {\n\tmy $self = shift;\n\tmy $hsp_table = $self->get_field('hsp_table');\n\tmy $hsp_data = $hsp_table->{$self->get_field('name')} || undef;\n\tif ($hsp_data) {\n\t\tif (defined $hsp_data->{hit_length}) {\n\t\t\t$self->_fields->{length} = $hsp_data->{hit_length};\n\t\t}\n\t\t\n\t\t# rank query_start query_end hit_start hit_end score evalue\n\t\t$self->_fields->{hsp_data} = $hsp_data->{hsp_data};\n\t}\n}\n\nsub _discover_query_start {\n\tmy $self = shift;\n\tmy $hsp_data = $self->get_field('hsp_data') || return;\n\t\n\tmy ($this_hsp) = sort { $a->[1] <=> $b->[1] } @{$hsp_data};\n\t$self->_fields->{query_start} = $this_hsp->[1];\n}\n\nsub _discover_query_end {\n\tmy $self = shift;\n\tmy $hsp_data = $self->get_field('hsp_data') || return;\n\t\n\tmy ($this_hsp) = sort { $b->[2] <=> $a->[2] } @{$hsp_data};\n\t$self->_fields->{query_end} = $this_hsp->[2];\n}\n\nsub _discover_hit_start {\n\tmy $self = shift;\n\tmy $hsp_data = $self->get_field('hsp_data') || return;\n\t\n\tmy ($this_hsp) = sort { $a->[3] <=> $b->[3] } @{$hsp_data};\n\t$self->_fields->{hit_start} = $this_hsp->[3];\n}\n\nsub _discover_hit_end {\n\tmy $self = shift;\n\tmy $hsp_data = $self->get_field('hsp_data') || return;\n\t\n\tmy ($this_hsp) = sort { $b->[4] <=> $a->[4] } @{$hsp_data};\n\t$self->_fields->{hit_end} = $this_hsp->[4];\n}\n\nsub _discover_next_hsp {\n\tmy $self = shift;\n\tmy $hsp_data = $self->get_field('hsp_data') || return;\n\tunless (defined $self->{_next_hsp_index}) {\n\t\t$self->{_next_hsp_index} = 0;\n\t}\n\treturn if $self->{_next_hsp_index} == -1;\n\t\n\t$self->_fields->{next_hsp} = Bio::Search::HSP::HmmpfamHSP->new(-parent => $self,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  -hsp_data => $hsp_data->[$self->{_next_hsp_index}++]);\n\t\n\tif ($self->{_next_hsp_index} > $#{$hsp_data}) {\n\t\t$self->{_next_hsp_index} = -1;\n\t}\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : L<Bio::Search::HSP::HSPI> object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    my $hsp = $self->get_field('next_hsp');\n\tundef $self->_fields->{next_hsp};\n\treturn $hsp;\n}\n\n=head2 next_domain\n\n Title   : next_domain \n Usage   : my $domain = $hit->next_domain();\n Function: An alias for L<next_hsp()>, this will return the next HSP\n Returns : L<Bio::Search::HSP::HSPI> object\n Args    : none\n\n\n*next_domain = \\&next_hsp;\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n Example   : @hsps = $hit_object->hsps();\n Returns   : list of L<Bio::Search::HSP::BlastHSP> objects.\n Argument  : none\n\n\nsub hsps {\n    my $self = shift;\n\tmy $old = $self->{_next_hsp_index} || 0;\n\t$self->rewind;\n\tmy @hsps;\n\twhile (defined(my $hsp = $self->next_hsp)) {\n\t\tpush(@hsps, $hsp);\n\t}\n\t$self->{_next_hsp_index} =  @hsps > 0 ? $old : -1;\n\treturn @hsps;\n}\n\n=head2 domains\n\n Title   : domains\n Usage   : my @domains = $hit->domains();\n Function: An alias for L<hsps()>, this will return the full list of hsps\n Returns : array of L<Bio::Search::HSP::HSPI> objects\n Args    : none\n\n\n*domains = \\&hsps;\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a L<Bio::Search::HSP::HSPI> object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best'  = highest scoring HSP.\n           :   'worst' = lowest scoring HSP.\n Throws    : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    my ($self, $type) = @_;\n\t$type ||= 'best';\n\tmy $hsp_data = $self->get_field('hsp_data') || return;\n\t\n\tmy $sort;\n\tif ($type eq 'best') {\n\t\t$sort = sub { $a->[6] <=> $b->[6] };\n\t}\n\telsif ($type eq 'worst') {\n\t\t$sort = sub { $b->[6] <=> $a->[6] };\n\t}\n\telse {\n\t\t$self->throw(\"Unknown arg '$type' given to hsp()\");\n\t}\n\t\n\tmy ($this_hsp) = sort $sort @{$hsp_data};\n\treturn Bio::Search::HSP::HmmpfamHSP->new(-parent => $self, -hsp_data => $this_hsp);\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $result->rewind;\n Function: Allow one to reset the Hit iterator to the beginning, so that\n           next_hit() will subsequently return the first hit and so on.\n Returns : n/a\n Args    : none\n\n\nsub rewind {\n\tmy $self = shift;\n\tmy $hsp_data = $self->get_field('hsp_data') || return;\n\t$self->{_next_hsp_index} = @{$hsp_data} > 0 ? 0 : -1;\n}\n\n# have p() a synonym of significance()\nsub p {\n\treturn shift->significance;\n}\n\n=head2 strand\n\n Usage     : $sbjct->strand( [seq_type] );\n Purpose   : Gets the strand(s) for the query, sbjct, or both sequences.\n           : For hmmpfam, the answers are always 1 (forward strand).\n Example   : $qstrand = $sbjct->strand('query');\n           : $sstrand = $sbjct->strand('hit');\n           : ($qstrand, $sstrand) = $sbjct->strand();\n Returns   : scalar context: integer '1'\n           : array context without args: list of two strings (1, 1)\n           : Array context can be \"induced\" by providing an argument of 'list'\n\t\t   : or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default\n           : = 'query') ('sbjct' is synonymous with 'hit')","label":"strand($self,$type)"},"name":"strand","range":{"end":{"character":9999,"line":360},"start":{"character":0,"line":352}}},{"kind":12,"children":[],"line":375,"definition":"sub","name":"frac_aligned_query","containerName":"main::","range":{"end":{"line":375,"character":9999},"start":{"character":0,"line":375}}}]}