{"version":5,"vars":[{"kind":2,"line":102,"name":"base","containerName":""},{"name":"new","range":{"end":{"character":9999,"line":180},"start":{"line":127,"character":0}},"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects."},"kind":12,"line":127,"children":[{"line":128,"kind":13,"localvar":"my","definition":"my","name":"$class","containerName":"new"},{"line":128,"kind":13,"name":"@args","containerName":"new"},{"kind":13,"line":130,"definition":"my","name":"$self","containerName":"new","localvar":"my"},{"kind":13,"line":130,"name":"$class","containerName":"new"},{"line":130,"kind":13,"containerName":"new","name":"@args"},{"kind":13,"line":131,"name":"$hsps","definition":"my","containerName":"new","localvar":"my"},{"line":131,"kind":13,"containerName":"new","name":"$name"},{"containerName":"new","name":"$query_len","kind":13,"line":131},{"name":"$desc","containerName":"new","kind":13,"line":131},{"kind":13,"line":131,"name":"$acc","containerName":"new"},{"name":"$locus","containerName":"new","kind":13,"line":131},{"name":"$length","containerName":"new","line":131,"kind":13},{"name":"$score","containerName":"new","line":132,"kind":13},{"line":132,"kind":13,"name":"$algo","containerName":"new"},{"line":132,"kind":13,"name":"$signif","containerName":"new"},{"containerName":"new","name":"$bits","line":132,"kind":13},{"line":132,"kind":13,"name":"$p","containerName":"new"},{"containerName":"new","name":"$rank","kind":13,"line":133},{"line":133,"kind":13,"containerName":"new","name":"$hsp_factory"},{"name":"$gi","containerName":"new","kind":13,"line":133},{"line":133,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"_rearrange","line":133,"kind":12},{"containerName":"new","name":"@args","kind":13,"line":143},{"line":145,"kind":13,"name":"$query_len","containerName":"new"},{"line":145,"kind":13,"containerName":"new","name":"$self"},{"line":145,"kind":12,"containerName":"new","name":"query_length"},{"line":145,"kind":13,"name":"$query_len","containerName":"new"},{"kind":13,"line":147,"containerName":"new","name":"$name"},{"containerName":"new","name":"$self","line":148,"kind":13},{"containerName":"new","name":"throw","line":148,"kind":12},{"kind":13,"line":150,"containerName":"new","name":"$self"},{"name":"name","containerName":"new","line":150,"kind":12},{"line":150,"kind":13,"containerName":"new","name":"$name"},{"name":"$acc","containerName":"new","line":153,"kind":13},{"containerName":"new","name":"$self","line":153,"kind":13},{"kind":12,"line":153,"containerName":"new","name":"accession"},{"containerName":"new","name":"$acc","line":153,"kind":13},{"kind":13,"line":154,"name":"$locus","containerName":"new"},{"kind":13,"line":154,"name":"$self","containerName":"new"},{"name":"locus","containerName":"new","kind":12,"line":154},{"containerName":"new","name":"$locus","kind":13,"line":154},{"kind":13,"line":155,"containerName":"new","name":"$desc"},{"containerName":"new","name":"$self","line":155,"kind":13},{"line":155,"kind":12,"name":"description","containerName":"new"},{"line":155,"kind":13,"name":"$desc","containerName":"new"},{"kind":13,"line":156,"containerName":"new","name":"$length"},{"kind":13,"line":156,"name":"$self","containerName":"new"},{"name":"length","containerName":"new","line":156,"kind":12},{"line":156,"kind":13,"containerName":"new","name":"$length"},{"line":157,"kind":13,"containerName":"new","name":"$algo"},{"line":157,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"algorithm","kind":12,"line":157},{"name":"$algo","containerName":"new","kind":13,"line":157},{"containerName":"new","name":"$signif","line":158,"kind":13},{"name":"$self","containerName":"new","line":158,"kind":13},{"kind":12,"line":158,"containerName":"new","name":"significance"},{"containerName":"new","name":"$signif","line":158,"kind":13},{"line":159,"kind":13,"containerName":"new","name":"$score"},{"line":159,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"raw_score","kind":12,"line":159},{"name":"$score","containerName":"new","kind":13,"line":159},{"name":"$bits","containerName":"new","kind":13,"line":160},{"name":"$self","containerName":"new","line":160,"kind":13},{"name":"bits","containerName":"new","kind":12,"line":160},{"line":160,"kind":13,"containerName":"new","name":"$bits"},{"line":161,"kind":13,"containerName":"new","name":"$rank"},{"kind":13,"line":161,"name":"$self","containerName":"new"},{"kind":12,"line":161,"containerName":"new","name":"rank"},{"containerName":"new","name":"$rank","kind":13,"line":161},{"line":162,"kind":13,"name":"$hsp_factory","containerName":"new"},{"line":162,"kind":13,"name":"$self","containerName":"new"},{"name":"hsp_factory","containerName":"new","kind":12,"line":162},{"containerName":"new","name":"$hsp_factory","line":162,"kind":13},{"containerName":"new","name":"$gi","line":163,"kind":13},{"line":163,"kind":13,"name":"$self","containerName":"new"},{"name":"ncbi_gi","containerName":"new","line":163,"kind":12},{"kind":13,"line":163,"name":"$gi","containerName":"new"},{"line":165,"kind":13,"name":"$p","containerName":"new"},{"kind":13,"line":166,"containerName":"new","name":"$self"},{"containerName":"new","name":"$p","line":166,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":169},{"name":"$hsps","containerName":"new","line":170,"kind":13},{"kind":13,"line":171,"containerName":"new","name":"$hsps"},{"name":"$self","containerName":"new","kind":13,"line":172},{"kind":12,"line":172,"containerName":"new","name":"warn"},{"kind":13,"line":174,"containerName":"new","name":"$hspcount","definition":"my","localvar":"my"},{"kind":13,"line":175,"name":"$hsps","containerName":"new"},{"containerName":"new","name":"$hspcount","line":176,"kind":13},{"line":177,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":177,"containerName":"new","name":"add_hsp"},{"containerName":"new","name":"$hsps","line":177,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":179},{"containerName":"new","name":"$hspcount","kind":13,"line":179}]},{"containerName":"new","name":"SUPER","kind":12,"line":130},{"kind":12,"line":166,"name":"_p"},{"line":183,"kind":13,"name":"%self","containerName":null},{"kind":13,"line":186,"containerName":null,"name":"$self"},{"definition":"sub","containerName":"main::","signature":{"label":"add_hsp($self,$hsp)","parameters":[{"label":"$self"},{"label":"$hsp"}],"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)"},"detail":"($self,$hsp)","kind":12,"children":[{"line":201,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"add_hsp"},{"line":201,"kind":13,"name":"$hsp","containerName":"add_hsp"},{"name":"$hsp","containerName":"add_hsp","line":202,"kind":13},{"kind":13,"line":202,"name":"$hsp","containerName":"add_hsp"},{"line":202,"kind":13,"containerName":"add_hsp","name":"$hsp"},{"kind":12,"line":202,"name":"isa","containerName":"add_hsp"},{"name":"$self","containerName":"add_hsp","kind":13,"line":203},{"line":203,"kind":12,"containerName":"add_hsp","name":"throw"},{"name":"$self","containerName":"add_hsp","line":207,"kind":13}],"line":200,"name":"add_hsp","range":{"start":{"line":200,"character":0},"end":{"line":207,"character":9999}}},{"containerName":null,"name":"$hsp","kind":13,"line":207},{"line":208,"kind":13,"name":"%hsp","containerName":null},{"kind":13,"line":209,"containerName":null,"name":"%self"},{"name":"_hashes","kind":12,"line":209},{"kind":13,"line":209,"name":"%self","containerName":null},{"line":211,"kind":13,"name":"%self","containerName":null},{"range":{"start":{"character":0,"line":224},"end":{"line":228,"character":9999}},"name":"hsp_factory","definition":"sub","containerName":"main::","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"hsp_factory","line":225,"kind":13},{"containerName":"hsp_factory","name":"$self","line":226,"kind":13},{"kind":13,"line":227,"containerName":"hsp_factory","name":"$self"}],"line":224,"kind":12},{"kind":12,"line":226,"name":"_hsp_factory"},{"name":"_hsp_factory","line":227,"kind":12},{"definition":"sub","containerName":"main::","signature":{"label":"name($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name"},"detail":"($self,$value)","kind":12,"children":[{"kind":13,"line":245,"containerName":"name","definition":"my","name":"$self","localvar":"my"},{"line":245,"kind":13,"containerName":"name","name":"$value"},{"containerName":"name","definition":"my","name":"$previous","localvar":"my","kind":13,"line":246},{"name":"$self","containerName":"name","kind":13,"line":246},{"kind":13,"line":247,"containerName":"name","name":"$value"},{"containerName":"name","name":"$previous","kind":13,"line":247},{"kind":13,"line":248,"containerName":"name","name":"$value"},{"containerName":"name","name":"$previous","line":248,"kind":13},{"containerName":"name","name":"$value","kind":13,"line":248},{"kind":13,"line":249,"containerName":"name","name":"$self"},{"containerName":"name","name":"$value","kind":13,"line":249},{"line":251,"kind":13,"containerName":"name","name":"$previous"}],"line":244,"name":"name","range":{"end":{"character":9999,"line":252},"start":{"line":244,"character":0}}},{"name":"accession","range":{"end":{"line":272,"character":9999},"start":{"character":0,"line":264}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none","label":"accession($self,$value)"},"detail":"($self,$value)","kind":12,"children":[{"line":265,"kind":13,"localvar":"my","containerName":"accession","definition":"my","name":"$self"},{"line":265,"kind":13,"name":"$value","containerName":"accession"},{"line":266,"kind":13,"localvar":"my","containerName":"accession","name":"$previous","definition":"my"},{"kind":13,"line":266,"name":"$self","containerName":"accession"},{"containerName":"accession","name":"$value","line":267,"kind":13},{"containerName":"accession","name":"$previous","kind":13,"line":267},{"containerName":"accession","name":"$value","kind":13,"line":268},{"name":"$previous","containerName":"accession","line":268,"kind":13},{"containerName":"accession","name":"$value","kind":13,"line":268},{"kind":13,"line":269,"containerName":"accession","name":"$self"},{"name":"$value","containerName":"accession","kind":13,"line":269},{"line":271,"kind":13,"name":"$previous","containerName":"accession"}],"line":264},{"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"description($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition"},"kind":12,"line":284,"children":[{"line":285,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"description"},{"name":"$value","containerName":"description","line":285,"kind":13},{"kind":13,"line":286,"definition":"my","name":"$previous","containerName":"description","localvar":"my"},{"line":286,"kind":13,"containerName":"description","name":"$self"},{"containerName":"description","name":"$value","line":287,"kind":13},{"kind":13,"line":287,"name":"$previous","containerName":"description"},{"kind":13,"line":288,"name":"$value","containerName":"description"},{"containerName":"description","name":"$previous","line":288,"kind":13},{"name":"$value","containerName":"description","kind":13,"line":288},{"line":289,"kind":13,"containerName":"description","name":"$self"},{"kind":13,"line":289,"containerName":"description","name":"$value"},{"containerName":"description","name":"$previous","kind":13,"line":291}],"name":"description","range":{"end":{"character":9999,"line":292},"start":{"line":284,"character":0}}},{"kind":12,"line":304,"children":[{"containerName":"length","definition":"my","name":"$self","localvar":"my","kind":13,"line":305},{"line":305,"kind":13,"containerName":"length","name":"$value"},{"localvar":"my","definition":"my","name":"$previous","containerName":"length","line":306,"kind":13},{"name":"$self","containerName":"length","line":306,"kind":13},{"kind":13,"line":307,"containerName":"length","name":"$value"},{"name":"$previous","containerName":"length","kind":13,"line":307},{"containerName":"length","name":"$value","kind":13,"line":308},{"kind":13,"line":308,"containerName":"length","name":"$previous"},{"containerName":"length","name":"$value","line":308,"kind":13},{"line":309,"kind":13,"containerName":"length","name":"$self"},{"name":"$value","containerName":"length","line":309,"kind":13},{"line":311,"kind":13,"name":"$previous","containerName":"length"}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"length($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length"},"name":"length","range":{"end":{"character":9999,"line":312},"start":{"character":0,"line":304}}},{"detail":"($self,$value)","signature":{"label":"algorithm($self,$value)","documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm","parameters":[{"label":"$self"},{"label":"$value"}]},"containerName":"main::","definition":"sub","line":329,"children":[{"kind":13,"line":330,"containerName":"algorithm","name":"$self","definition":"my","localvar":"my"},{"name":"$value","containerName":"algorithm","line":330,"kind":13},{"localvar":"my","containerName":"algorithm","name":"$previous","definition":"my","line":331,"kind":13},{"name":"$self","containerName":"algorithm","kind":13,"line":331},{"line":332,"kind":13,"name":"$value","containerName":"algorithm"},{"line":332,"kind":13,"name":"$previous","containerName":"algorithm"},{"kind":13,"line":333,"containerName":"algorithm","name":"$value"},{"name":"$previous","containerName":"algorithm","line":333,"kind":13},{"containerName":"algorithm","name":"$value","kind":13,"line":333},{"kind":13,"line":334,"name":"$self","containerName":"algorithm"},{"containerName":"algorithm","name":"$value","kind":13,"line":334},{"name":"$previous","containerName":"algorithm","line":336,"kind":13}],"kind":12,"range":{"end":{"line":337,"character":9999},"start":{"line":329,"character":0}},"name":"algorithm"},{"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score","parameters":[{"label":"$self"},{"label":"$value"}],"label":"raw_score($self,$value)"},"kind":12,"line":351,"children":[{"containerName":"raw_score","name":"$self","definition":"my","localvar":"my","kind":13,"line":352},{"kind":13,"line":352,"name":"$value","containerName":"raw_score"},{"localvar":"my","containerName":"raw_score","definition":"my","name":"$previous","line":353,"kind":13},{"name":"$self","containerName":"raw_score","line":353,"kind":13},{"kind":13,"line":354,"name":"$value","containerName":"raw_score"},{"name":"$self","containerName":"raw_score","line":355,"kind":13},{"line":355,"kind":13,"name":"$value","containerName":"raw_score"},{"kind":13,"line":356,"containerName":"raw_score","name":"$previous"},{"line":358,"kind":13,"name":"$self","containerName":"raw_score"},{"line":359,"kind":13,"containerName":"raw_score","name":"$self"},{"name":"warn","containerName":"raw_score","line":359,"kind":12},{"containerName":"raw_score","name":"$self","kind":13,"line":359},{"containerName":"raw_score","name":"name","kind":12,"line":359},{"kind":13,"line":363,"containerName":"raw_score","name":"$previous"},{"line":363,"kind":13,"name":"$self","containerName":"raw_score"},{"kind":13,"line":363,"name":"$self","containerName":"raw_score"},{"name":"hsps","containerName":"raw_score","line":363,"kind":12},{"line":363,"kind":12,"containerName":"raw_score","name":"score"},{"line":365,"kind":13,"containerName":"raw_score","name":"$previous"}],"name":"raw_score","range":{"start":{"line":351,"character":0},"end":{"character":9999,"line":366}}},{"containerName":"main::","definition":"sub","name":"score","range":{"end":{"line":374,"character":9999},"start":{"line":374,"character":0}},"kind":12,"line":374,"children":[{"kind":12,"line":374,"name":"raw_score","containerName":"score"}]},{"line":389,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"significance","line":390,"kind":13},{"containerName":"significance","name":"$value","line":390,"kind":13},{"containerName":"significance","definition":"my","name":"$previous","localvar":"my","kind":13,"line":391},{"line":391,"kind":13,"name":"$self","containerName":"significance"},{"name":"$value","containerName":"significance","kind":13,"line":392},{"line":393,"kind":13,"name":"$self","containerName":"significance"},{"line":393,"kind":13,"containerName":"significance","name":"$value"},{"line":394,"kind":13,"name":"$previous","containerName":"significance"},{"name":"$self","containerName":"significance","kind":13,"line":395},{"name":"$self","containerName":"significance","kind":13,"line":396},{"line":396,"kind":12,"name":"warn","containerName":"significance"},{"kind":13,"line":396,"containerName":"significance","name":"$self"},{"kind":12,"line":396,"containerName":"significance","name":"name"},{"name":"$previous","containerName":"significance","kind":13,"line":400},{"name":"$self","containerName":"significance","kind":13,"line":400},{"name":"$self","containerName":"significance","kind":13,"line":400},{"kind":12,"line":400,"containerName":"significance","name":"hsps"},{"name":"significance","containerName":"significance","line":400,"kind":12},{"name":"$previous","containerName":"significance","line":403,"kind":13}],"kind":12,"detail":"($self,$value)","signature":{"label":"significance($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance"},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":404},"start":{"line":389,"character":0}},"name":"significance"},{"kind":12,"line":419,"children":[{"localvar":"my","containerName":"bits","definition":"my","name":"$self","line":420,"kind":13},{"kind":13,"line":420,"containerName":"bits","name":"$value"},{"localvar":"my","name":"$previous","definition":"my","containerName":"bits","line":421,"kind":13},{"name":"$self","containerName":"bits","line":421,"kind":13},{"containerName":"bits","name":"$value","kind":13,"line":422},{"line":423,"kind":13,"name":"$self","containerName":"bits"},{"name":"$value","containerName":"bits","line":423,"kind":13},{"line":424,"kind":13,"name":"$previous","containerName":"bits"},{"name":"$self","containerName":"bits","line":426,"kind":13},{"name":"$self","containerName":"bits","kind":13,"line":427},{"line":427,"kind":12,"name":"warn","containerName":"bits"},{"line":427,"kind":13,"name":"$self","containerName":"bits"},{"line":427,"kind":12,"containerName":"bits","name":"name"},{"name":"$previous","containerName":"bits","line":431,"kind":13},{"name":"$self","containerName":"bits","line":431,"kind":13},{"name":"$self","containerName":"bits","line":431,"kind":13},{"line":431,"kind":12,"containerName":"bits","name":"hsps"},{"name":"bits","containerName":"bits","line":431,"kind":12},{"containerName":"bits","name":"$previous","kind":13,"line":433}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\nsub significance {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_significance'};\n    if( defined $value ) { \n        $self->{'_significance'} = $value;\n    } elsif ( ! defined $previous ) {\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this Hit (\".$self->name.\")\");\n\t    return;\n\t}\n        # Set the significance of the Hit to that of the top HSP.\n        $previous = $self->{'_significance'} = ($self->hsps)[0]->significance;\n    }\n\n    return $previous;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>","label":"bits($self,$value)"},"name":"bits","range":{"start":{"line":419,"character":0},"end":{"character":9999,"line":434}}},{"children":[{"kind":13,"line":448,"containerName":"next_hsp","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":449,"containerName":"next_hsp","name":"$self"},{"name":"$self","containerName":"next_hsp","line":449,"kind":13},{"name":"$self","containerName":"next_hsp","kind":13,"line":451},{"name":"$self","containerName":"next_hsp","line":452,"kind":13},{"containerName":"next_hsp","name":"$self","line":452,"kind":13}],"line":447,"kind":12,"range":{"end":{"line":452,"character":9999},"start":{"line":447,"character":0}},"name":"next_hsp","definition":"sub","containerName":"main::"},{"containerName":null,"name":"$iterator","definition":"my","localvar":"my","kind":13,"line":454},{"containerName":null,"name":"%self","kind":13,"line":454},{"line":455,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$hsp"},{"name":"%self","containerName":null,"line":455,"kind":13},{"containerName":null,"name":"$iterator","kind":13,"line":455},{"line":456,"kind":13,"containerName":null,"name":"%hsp"},{"line":457,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$factory"},{"line":457,"kind":13,"containerName":null,"name":"$self"},{"name":"hsp_factory","containerName":"main::","kind":12,"line":457},{"line":457,"kind":13,"name":"$self","containerName":null},{"name":"throw","containerName":"main::","line":457,"kind":12},{"kind":13,"line":458,"name":"$hsp","containerName":null},{"containerName":null,"name":"$factory","kind":13,"line":458},{"containerName":"main::","name":"create_object","line":458,"kind":12},{"name":"$hsp","containerName":null,"line":458,"kind":13},{"line":459,"kind":13,"name":"%self","containerName":null},{"containerName":null,"name":"$iterator","line":459,"kind":13},{"line":459,"kind":13,"name":"$hsp","containerName":null},{"line":460,"kind":13,"containerName":null,"name":"%self"},{"name":"_hashes","line":460,"kind":12},{"name":"$iterator","containerName":null,"line":460,"kind":13},{"kind":13,"line":462,"containerName":null,"name":"$hsp"},{"line":483,"children":[{"kind":13,"line":484,"definition":"my","name":"$self","containerName":"hsps","localvar":"my"},{"line":485,"kind":13,"localvar":"my","name":"$i","definition":"my","containerName":"hsps"},{"name":"$self","containerName":"hsps","kind":13,"line":485}],"kind":12,"range":{"end":{"line":485,"character":9999},"start":{"character":0,"line":483}},"containerName":"main::","name":"hsps","definition":"sub"},{"kind":12,"line":485,"name":"_hashes"},{"kind":13,"line":486,"containerName":null,"name":"$factory","definition":"my","localvar":"my"},{"line":486,"kind":13,"containerName":null,"name":"$self"},{"line":486,"kind":12,"name":"hsp_factory","containerName":"main::"},{"containerName":null,"name":"$self","line":486,"kind":13},{"containerName":"main::","name":"throw","kind":12,"line":486},{"name":"%self","containerName":null,"line":487,"kind":13},{"name":"$i","containerName":null,"line":487,"kind":13},{"kind":13,"line":487,"name":"$factory","containerName":null},{"line":487,"kind":12,"name":"create_object","containerName":"main::"},{"name":"%self","containerName":null,"kind":13,"line":487},{"containerName":null,"name":"$i","line":487,"kind":13},{"name":"%self","containerName":null,"kind":13,"line":488},{"kind":12,"line":488,"name":"_hashes"},{"kind":13,"line":488,"containerName":null,"name":"$i"},{"kind":13,"line":491,"name":"%self","containerName":null},{"line":491,"kind":13,"containerName":null,"name":"%self"},{"range":{"end":{"line":513,"character":9999},"start":{"character":0,"line":506}},"name":"num_hsps","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"num_hsps","name":"$self","definition":"my","line":507,"kind":13},{"name":"$self","containerName":"num_hsps","kind":13,"line":509},{"name":"$self","containerName":"num_hsps","kind":13,"line":513}],"line":506,"kind":12},{"kind":12,"line":527,"children":[{"definition":"my","name":"$self","containerName":"rewind","localvar":"my","kind":13,"line":528},{"kind":13,"line":529,"containerName":"rewind","name":"$self"}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"rewind($self)","documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\nsub significance {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_significance'};\n    if( defined $value ) { \n        $self->{'_significance'} = $value;\n    } elsif ( ! defined $previous ) {\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this Hit (\".$self->name.\")\");\n\t    return;\n\t}\n        # Set the significance of the Hit to that of the top HSP.\n        $previous = $self->{'_significance'} = ($self->hsps)[0]->significance;\n    }\n\n    return $previous;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_bits'};\n    if( defined $value ) { \n        $self->{'_bits'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using WU-BLAST, check raw_score() instead\");\n\t    return;\n\t}\n        $previous = $self->{'_bits'} = ($self->hsps)[0]->bits;\n    }    \n    return $previous;\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    $self->{'_iterator'} = 0 unless defined $self->{'_iterator'};\n    return unless\n        defined($self->{'_hsps'}) \n        && $self->{'_iterator'} <= scalar @{$self->{'_hsps'}};\n    \n    my $iterator = $self->{'_iterator'}++;\n    my $hsp = $self->{'_hsps'}->[$iterator] || return;\n    if (ref($hsp) eq 'HASH') {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $hsp = $factory->create_object(%{$hsp});\n        $self->{'_hsps'}->[$iterator] = $hsp;\n        delete $self->{_hashes}->{$iterator};\n    }\n    return $hsp;  \n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    my $self = shift;\n    foreach my $i (keys %{$self->{_hashes} || {}}) {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $self->{'_hsps'}->[$i] = $factory->create_object(%{$self->{'_hsps'}->[$i]});\n        delete $self->{_hashes}->{$i};\n    }\n    \n    return wantarray() ? @{$self->{'_hsps'} || []} : scalar(@{$self->{'_hsps'} || []});\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    my $self = shift;\n    \n    unless ($self->{'_hsps'}) {\n        return '-';\n    }\n    \n    return scalar(@{$self->{'_hsps'}});\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none","parameters":[{"label":"$self"}]},"name":"rewind","range":{"start":{"character":0,"line":527},"end":{"line":530,"character":9999}}},{"children":[{"line":554,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"ambiguous_aln"},{"name":"$self","containerName":"ambiguous_aln","kind":13,"line":555},{"containerName":"ambiguous_aln","name":"$self","kind":13,"line":556}],"line":553,"kind":12,"range":{"start":{"character":0,"line":553},"end":{"character":9999,"line":557}},"name":"ambiguous_aln","definition":"sub","containerName":"main::"},{"definition":"sub","name":"overlap","containerName":"main::","range":{"start":{"line":565,"character":0},"end":{"character":9999,"line":569}},"kind":12,"children":[{"line":566,"kind":13,"localvar":"my","containerName":"overlap","definition":"my","name":"$self"},{"containerName":"overlap","name":"$self","kind":13,"line":567},{"name":"$self","containerName":"overlap","kind":13,"line":568},{"containerName":"overlap","name":"$self","line":568,"kind":13}],"line":565},{"containerName":"main::","definition":"sub","name":"n","range":{"start":{"line":594,"character":0},"end":{"line":612,"character":9999}},"kind":12,"line":594,"children":[{"kind":13,"line":595,"name":"$self","definition":"my","containerName":"n","localvar":"my"},{"kind":13,"line":601,"definition":"my","name":"$n","containerName":"n","localvar":"my"},{"name":"$self","containerName":"n","line":602,"kind":13},{"name":"$self","containerName":"n","kind":13,"line":603},{"name":"hsp","containerName":"n","kind":12,"line":603},{"line":604,"kind":13,"name":"$n","containerName":"n"},{"kind":13,"line":604,"name":"$self","containerName":"n"},{"name":"hsp","containerName":"n","kind":12,"line":604},{"line":604,"kind":12,"name":"n","containerName":"n"},{"containerName":"n","name":"$n","line":607,"kind":13},{"kind":13,"line":607,"containerName":"n","name":"$self"},{"name":"$n","containerName":"n","line":609,"kind":13},{"containerName":"n","name":"$self","kind":13,"line":609},{"containerName":"n","name":"num_hsps","line":609,"kind":12},{"containerName":"n","name":"$n","line":611,"kind":13}]},{"containerName":"main::","definition":"sub","detail":"($self,$fmt)","signature":{"label":"p($self,$fmt)","documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\nsub significance {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_significance'};\n    if( defined $value ) { \n        $self->{'_significance'} = $value;\n    } elsif ( ! defined $previous ) {\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this Hit (\".$self->name.\")\");\n\t    return;\n\t}\n        # Set the significance of the Hit to that of the top HSP.\n        $previous = $self->{'_significance'} = ($self->hsps)[0]->significance;\n    }\n\n    return $previous;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_bits'};\n    if( defined $value ) { \n        $self->{'_bits'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using WU-BLAST, check raw_score() instead\");\n\t    return;\n\t}\n        $previous = $self->{'_bits'} = ($self->hsps)[0]->bits;\n    }    \n    return $previous;\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    $self->{'_iterator'} = 0 unless defined $self->{'_iterator'};\n    return unless\n        defined($self->{'_hsps'}) \n        && $self->{'_iterator'} <= scalar @{$self->{'_hsps'}};\n    \n    my $iterator = $self->{'_iterator'}++;\n    my $hsp = $self->{'_hsps'}->[$iterator] || return;\n    if (ref($hsp) eq 'HASH') {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $hsp = $factory->create_object(%{$hsp});\n        $self->{'_hsps'}->[$iterator] = $hsp;\n        delete $self->{_hashes}->{$iterator};\n    }\n    return $hsp;  \n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    my $self = shift;\n    foreach my $i (keys %{$self->{_hashes} || {}}) {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $self->{'_hsps'}->[$i] = $factory->create_object(%{$self->{'_hsps'}->[$i]});\n        delete $self->{_hashes}->{$i};\n    }\n    \n    return wantarray() ? @{$self->{'_hsps'} || []} : scalar(@{$self->{'_hsps'} || []});\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    my $self = shift;\n    \n    unless ($self->{'_hsps'}) {\n        return '-';\n    }\n    \n    return scalar(@{$self->{'_hsps'}});\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_iterator'} = 0;\n}\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences \n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences \n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains \n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Comment   : Note: \"sbjct\" is synonymous with \"hit\"\n\n\nsub ambiguous_aln {\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n=head2 overlap\n\nSee documentation in L<Bio::Search::Hit::HitI::overlap()|Bio::Search::Hit::HitI>\n\n\nsub overlap {\n    my $self = shift; \n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    my $self = shift; \n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description \n    # line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n\tif( $self->hsp ) {\n\t    $n = $self->hsp->n;\n\t}\n    } else {\n        $n = $self->{'_n'}; \n    } \n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<significance()|significance>, L<Bio::Search::SearchUtils::get_exponent()|Bio::Search::SearchUtils>","parameters":[{"label":"$self"},{"label":"$fmt"}]},"kind":12,"line":641,"children":[{"kind":13,"line":643,"name":"$self","definition":"my","containerName":"p","localvar":"my"},{"kind":13,"line":643,"containerName":"p","name":"$fmt"},{"definition":"my","name":"$val","containerName":"p","localvar":"my","kind":13,"line":645},{"kind":13,"line":645,"name":"$self","containerName":"p"},{"kind":13,"line":648,"containerName":"p","name":"$val"},{"name":"$self","containerName":"p","kind":13,"line":651},{"name":"warn","containerName":"p","line":651,"kind":12},{"line":652,"kind":13,"name":"$val","containerName":"p"},{"line":652,"kind":13,"name":"$self","containerName":"p"},{"kind":12,"line":652,"name":"significance","containerName":"p"},{"containerName":"p","name":"$val","kind":13,"line":655},{"line":655,"kind":13,"name":"$fmt","containerName":"p"},{"line":655,"kind":13,"name":"$fmt","containerName":"p"},{"containerName":"p","name":"$val","line":657,"kind":13},{"name":"$fmt","containerName":"p","line":657,"kind":13},{"name":"$val","containerName":"p","line":658,"kind":13},{"name":"$fmt","containerName":"p","line":658,"kind":13},{"kind":13,"line":661,"name":"$val","containerName":"p"}],"name":"p","range":{"end":{"line":662,"character":9999},"start":{"line":641,"character":0}}},{"containerName":"Search::SearchUtils::get_exponent","name":"Bio","kind":12,"line":657},{"detail":"($self,$option)","signature":{"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\nsub significance {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_significance'};\n    if( defined $value ) { \n        $self->{'_significance'} = $value;\n    } elsif ( ! defined $previous ) {\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this Hit (\".$self->name.\")\");\n\t    return;\n\t}\n        # Set the significance of the Hit to that of the top HSP.\n        $previous = $self->{'_significance'} = ($self->hsps)[0]->significance;\n    }\n\n    return $previous;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_bits'};\n    if( defined $value ) { \n        $self->{'_bits'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using WU-BLAST, check raw_score() instead\");\n\t    return;\n\t}\n        $previous = $self->{'_bits'} = ($self->hsps)[0]->bits;\n    }    \n    return $previous;\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    $self->{'_iterator'} = 0 unless defined $self->{'_iterator'};\n    return unless\n        defined($self->{'_hsps'}) \n        && $self->{'_iterator'} <= scalar @{$self->{'_hsps'}};\n    \n    my $iterator = $self->{'_iterator'}++;\n    my $hsp = $self->{'_hsps'}->[$iterator] || return;\n    if (ref($hsp) eq 'HASH') {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $hsp = $factory->create_object(%{$hsp});\n        $self->{'_hsps'}->[$iterator] = $hsp;\n        delete $self->{_hashes}->{$iterator};\n    }\n    return $hsp;  \n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    my $self = shift;\n    foreach my $i (keys %{$self->{_hashes} || {}}) {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $self->{'_hsps'}->[$i] = $factory->create_object(%{$self->{'_hsps'}->[$i]});\n        delete $self->{_hashes}->{$i};\n    }\n    \n    return wantarray() ? @{$self->{'_hsps'} || []} : scalar(@{$self->{'_hsps'} || []});\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    my $self = shift;\n    \n    unless ($self->{'_hsps'}) {\n        return '-';\n    }\n    \n    return scalar(@{$self->{'_hsps'}});\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_iterator'} = 0;\n}\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences \n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences \n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains \n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Comment   : Note: \"sbjct\" is synonymous with \"hit\"\n\n\nsub ambiguous_aln {\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n=head2 overlap\n\nSee documentation in L<Bio::Search::Hit::HitI::overlap()|Bio::Search::Hit::HitI>\n\n\nsub overlap {\n    my $self = shift; \n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    my $self = shift; \n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description \n    # line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n\tif( $self->hsp ) {\n\t    $n = $self->hsp->n;\n\t}\n    } else {\n        $n = $self->{'_n'}; \n    } \n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<significance()|significance>, L<Bio::Search::SearchUtils::get_exponent()|Bio::Search::SearchUtils>\n\n\nsub p {\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(!defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using significance() instead.\");\n        $val = $self->significance();\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::SearchUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()","parameters":[{"label":"$self"},{"label":"$option"}],"label":"hsp($self,$option)"},"containerName":"main::","definition":"sub","line":683,"children":[{"localvar":"my","containerName":"hsp","definition":"my","name":"$self","line":684,"kind":13},{"containerName":"hsp","name":"$option","kind":13,"line":684},{"kind":13,"line":685,"name":"$option","containerName":"hsp"},{"containerName":"hsp","name":"$self","kind":13,"line":687},{"name":"$self","containerName":"hsp","kind":13,"line":688},{"line":688,"kind":12,"name":"throw","containerName":"hsp"},{"definition":"my","name":"@hsps","containerName":"hsp","localvar":"my","kind":13,"line":691},{"containerName":"hsp","name":"$self","kind":13,"line":691},{"line":691,"kind":12,"name":"hsps","containerName":"hsp"},{"containerName":"hsp","name":"$hsps","kind":13,"line":693},{"line":693,"kind":13,"name":"$option","containerName":"hsp"},{"name":"$hsps","containerName":"hsp","line":694,"kind":13},{"containerName":"hsp","name":"$option","line":694,"kind":13},{"name":"$self","containerName":"hsp","line":696,"kind":13},{"containerName":"hsp","name":"throw","kind":12,"line":696}],"kind":12,"range":{"start":{"character":0,"line":683},"end":{"character":9999,"line":698}},"name":"hsp"},{"name":"hsps","line":694,"kind":12},{"containerName":"main::","definition":"sub","name":"logical_length","range":{"end":{"line":749,"character":9999},"start":{"line":729,"character":0}},"kind":12,"line":729,"children":[{"containerName":"logical_length","definition":"my","name":"$self","localvar":"my","kind":13,"line":730},{"localvar":"my","containerName":"logical_length","name":"$seqType","definition":"my","line":731,"kind":13},{"line":732,"kind":13,"containerName":"logical_length","name":"$seqType"},{"name":"$seqType","containerName":"logical_length","kind":13,"line":732},{"name":"$length","definition":"my","containerName":"logical_length","localvar":"my","kind":13,"line":734},{"name":"$logical","containerName":"logical_length","kind":13,"line":734},{"containerName":"logical_length","name":"$algo","definition":"my","localvar":"my","kind":13,"line":735},{"line":735,"kind":13,"name":"$self","containerName":"logical_length"},{"kind":12,"line":735,"name":"algorithm","containerName":"logical_length"},{"name":"$seqType","containerName":"logical_length","line":738,"kind":13},{"kind":13,"line":739,"containerName":"logical_length","name":"$length"},{"line":739,"kind":13,"name":"$self","containerName":"logical_length"},{"line":739,"kind":12,"containerName":"logical_length","name":"length"},{"kind":13,"line":742,"name":"$length","containerName":"logical_length"},{"line":742,"kind":13,"containerName":"logical_length","name":"$self"},{"line":742,"kind":12,"containerName":"logical_length","name":"query_length"},{"line":743,"kind":13,"containerName":"logical_length","name":"$self"},{"line":743,"kind":12,"containerName":"logical_length","name":"throw"},{"line":743,"kind":13,"name":"$length","containerName":"logical_length"},{"name":"$logical","containerName":"logical_length","kind":13,"line":746},{"name":"$algo","containerName":"logical_length","kind":13,"line":746},{"name":"$seqType","containerName":"logical_length","kind":13,"line":746},{"name":"$length","containerName":"logical_length","line":746,"kind":13},{"kind":13,"line":748,"containerName":"logical_length","name":"$logical"}]},{"kind":12,"line":746,"containerName":"Search::SearchUtils::logical_length","name":"Bio"},{"detail":"($self,$seqType,$num)","signature":{"label":"length_aln($self,$seqType,$num)","parameters":[{"label":"$self"},{"label":"$seqType"},{"label":"$num"}],"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\nsub significance {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_significance'};\n    if( defined $value ) { \n        $self->{'_significance'} = $value;\n    } elsif ( ! defined $previous ) {\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this Hit (\".$self->name.\")\");\n\t    return;\n\t}\n        # Set the significance of the Hit to that of the top HSP.\n        $previous = $self->{'_significance'} = ($self->hsps)[0]->significance;\n    }\n\n    return $previous;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_bits'};\n    if( defined $value ) { \n        $self->{'_bits'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using WU-BLAST, check raw_score() instead\");\n\t    return;\n\t}\n        $previous = $self->{'_bits'} = ($self->hsps)[0]->bits;\n    }    \n    return $previous;\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    $self->{'_iterator'} = 0 unless defined $self->{'_iterator'};\n    return unless\n        defined($self->{'_hsps'}) \n        && $self->{'_iterator'} <= scalar @{$self->{'_hsps'}};\n    \n    my $iterator = $self->{'_iterator'}++;\n    my $hsp = $self->{'_hsps'}->[$iterator] || return;\n    if (ref($hsp) eq 'HASH') {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $hsp = $factory->create_object(%{$hsp});\n        $self->{'_hsps'}->[$iterator] = $hsp;\n        delete $self->{_hashes}->{$iterator};\n    }\n    return $hsp;  \n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    my $self = shift;\n    foreach my $i (keys %{$self->{_hashes} || {}}) {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $self->{'_hsps'}->[$i] = $factory->create_object(%{$self->{'_hsps'}->[$i]});\n        delete $self->{_hashes}->{$i};\n    }\n    \n    return wantarray() ? @{$self->{'_hsps'} || []} : scalar(@{$self->{'_hsps'} || []});\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    my $self = shift;\n    \n    unless ($self->{'_hsps'}) {\n        return '-';\n    }\n    \n    return scalar(@{$self->{'_hsps'}});\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_iterator'} = 0;\n}\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences \n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences \n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains \n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Comment   : Note: \"sbjct\" is synonymous with \"hit\"\n\n\nsub ambiguous_aln {\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n=head2 overlap\n\nSee documentation in L<Bio::Search::Hit::HitI::overlap()|Bio::Search::Hit::HitI>\n\n\nsub overlap {\n    my $self = shift; \n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    my $self = shift; \n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description \n    # line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n\tif( $self->hsp ) {\n\t    $n = $self->hsp->n;\n\t}\n    } else {\n        $n = $self->{'_n'}; \n    } \n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<significance()|significance>, L<Bio::Search::SearchUtils::get_exponent()|Bio::Search::SearchUtils>\n\n\nsub p {\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(!defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using significance() instead.\");\n        $val = $self->significance();\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::SearchUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n    \n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = $self->hsps;\n    \n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : This is necessary since the number of identical/conserved residues \n           : can be in terms of peptide sequence space, yet the query and/or hit\n           : sequence are in nucleotide space.\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : In the case of BLAST flavors:\n           : For TBLASTN reports, the length of the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           :\n           : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub logical_length {\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my ($length, $logical);\n    my $algo = $self->algorithm;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->length;\n    } else {\n        # Otherwise, return logical query length\n        $length = $self->query_length();\n        $self->throw(\"Must have defined query_len\") unless ( $length );\n    }\n\n    $logical = Bio::Search::SearchUtils::logical_length($algo, $seqType, $length);\n\n    return int($logical);\n}\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer \n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           : \n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>"},"containerName":"main::","definition":"sub","line":775,"children":[{"containerName":"length_aln","name":"$self","definition":"my","localvar":"my","kind":13,"line":776},{"name":"$seqType","containerName":"length_aln","kind":13,"line":776},{"line":776,"kind":13,"containerName":"length_aln","name":"$num"},{"name":"$seqType","containerName":"length_aln","line":778,"kind":13},{"kind":13,"line":779,"containerName":"length_aln","name":"$seqType"},{"containerName":"length_aln","name":"$seqType","kind":13,"line":779},{"line":782,"kind":13,"containerName":"length_aln","name":"$num"},{"containerName":"length_aln","name":"$self","kind":13,"line":783},{"line":783,"kind":13,"containerName":"length_aln","name":"$seqType"},{"containerName":"length_aln","name":"$num","kind":13,"line":783},{"line":786,"kind":13,"name":"$self","containerName":"length_aln"},{"name":"$self","containerName":"length_aln","kind":13,"line":788},{"line":792,"kind":13,"name":"$self","containerName":"length_aln"},{"containerName":"length_aln","name":"$self","kind":13,"line":792},{"kind":12,"line":792,"name":"tiled_hsps","containerName":"length_aln"},{"line":794,"kind":13,"localvar":"my","name":"$data","definition":"my","containerName":"length_aln"},{"kind":13,"line":794,"containerName":"length_aln","name":"$self"},{"name":"$seqType","containerName":"length_aln","kind":13,"line":794},{"line":797,"kind":13,"name":"$data","containerName":"length_aln"},{"containerName":"length_aln","name":"$self","kind":13,"line":798},{"name":"throw","containerName":"length_aln","kind":12,"line":798},{"kind":13,"line":801,"name":"$data","containerName":"length_aln"}],"kind":12,"range":{"end":{"line":802,"character":9999},"start":{"character":0,"line":775}},"name":"length_aln"},{"kind":12,"line":788,"containerName":"Search::SearchUtils::_warn_about_no_hsps","name":"Bio"},{"name":"Bio","containerName":"Search::SearchUtils::tile_hsps","line":792,"kind":12},{"range":{"end":{"line":867,"character":9999},"start":{"character":0,"line":838}},"name":"gaps","children":[{"containerName":"gaps","definition":"my","name":"$self","localvar":"my","kind":13,"line":839},{"name":"$seqType","containerName":"gaps","line":839,"kind":13},{"containerName":"gaps","name":"$num","line":839,"kind":13},{"name":"$seqType","containerName":"gaps","kind":13,"line":841},{"containerName":"gaps","name":"$seqType","line":842,"kind":13},{"line":842,"kind":13,"containerName":"gaps","name":"$seqType"},{"name":"$self","containerName":"gaps","kind":13,"line":844},{"line":845,"kind":13,"name":"$self","containerName":"gaps"},{"line":850,"kind":13,"name":"$self","containerName":"gaps"},{"containerName":"gaps","name":"$self","line":850,"kind":13},{"containerName":"gaps","name":"tiled_hsps","kind":12,"line":850},{"containerName":"gaps","name":"$seqType","line":852,"kind":13},{"containerName":"gaps","name":"$seqType","line":852,"kind":13},{"containerName":"gaps","name":"$num","line":854,"kind":13},{"name":"$self","containerName":"gaps","kind":13,"line":855},{"containerName":"gaps","name":"throw","line":855,"kind":12},{"containerName":"gaps","name":"$seqType","kind":13,"line":855},{"name":"$seqType","containerName":"gaps","line":855,"kind":13},{"kind":13,"line":857,"name":"$self","containerName":"gaps"},{"line":857,"kind":13,"name":"$seqType","containerName":"gaps"},{"line":857,"kind":13,"name":"$num","containerName":"gaps"},{"name":"$seqType","containerName":"gaps","line":859,"kind":13},{"kind":13,"line":860,"name":"$self","containerName":"gaps"},{"name":"$self","containerName":"gaps","line":860,"kind":13},{"line":862,"kind":13,"containerName":"gaps","name":"$seqType"},{"line":863,"kind":13,"containerName":"gaps","name":"$self"},{"containerName":"gaps","name":"$self","line":863,"kind":13},{"name":"$self","containerName":"gaps","kind":13,"line":865},{"line":865,"kind":13,"containerName":"gaps","name":"$seqType"}],"line":838,"kind":12,"signature":{"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\nsub significance {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_significance'};\n    if( defined $value ) { \n        $self->{'_significance'} = $value;\n    } elsif ( ! defined $previous ) {\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this Hit (\".$self->name.\")\");\n\t    return;\n\t}\n        # Set the significance of the Hit to that of the top HSP.\n        $previous = $self->{'_significance'} = ($self->hsps)[0]->significance;\n    }\n\n    return $previous;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_bits'};\n    if( defined $value ) { \n        $self->{'_bits'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using WU-BLAST, check raw_score() instead\");\n\t    return;\n\t}\n        $previous = $self->{'_bits'} = ($self->hsps)[0]->bits;\n    }    \n    return $previous;\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    $self->{'_iterator'} = 0 unless defined $self->{'_iterator'};\n    return unless\n        defined($self->{'_hsps'}) \n        && $self->{'_iterator'} <= scalar @{$self->{'_hsps'}};\n    \n    my $iterator = $self->{'_iterator'}++;\n    my $hsp = $self->{'_hsps'}->[$iterator] || return;\n    if (ref($hsp) eq 'HASH') {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $hsp = $factory->create_object(%{$hsp});\n        $self->{'_hsps'}->[$iterator] = $hsp;\n        delete $self->{_hashes}->{$iterator};\n    }\n    return $hsp;  \n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    my $self = shift;\n    foreach my $i (keys %{$self->{_hashes} || {}}) {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $self->{'_hsps'}->[$i] = $factory->create_object(%{$self->{'_hsps'}->[$i]});\n        delete $self->{_hashes}->{$i};\n    }\n    \n    return wantarray() ? @{$self->{'_hsps'} || []} : scalar(@{$self->{'_hsps'} || []});\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    my $self = shift;\n    \n    unless ($self->{'_hsps'}) {\n        return '-';\n    }\n    \n    return scalar(@{$self->{'_hsps'}});\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_iterator'} = 0;\n}\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences \n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences \n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains \n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Comment   : Note: \"sbjct\" is synonymous with \"hit\"\n\n\nsub ambiguous_aln {\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n=head2 overlap\n\nSee documentation in L<Bio::Search::Hit::HitI::overlap()|Bio::Search::Hit::HitI>\n\n\nsub overlap {\n    my $self = shift; \n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    my $self = shift; \n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description \n    # line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n\tif( $self->hsp ) {\n\t    $n = $self->hsp->n;\n\t}\n    } else {\n        $n = $self->{'_n'}; \n    } \n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<significance()|significance>, L<Bio::Search::SearchUtils::get_exponent()|Bio::Search::SearchUtils>\n\n\nsub p {\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(!defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using significance() instead.\");\n        $val = $self->significance();\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::SearchUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n    \n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = $self->hsps;\n    \n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : This is necessary since the number of identical/conserved residues \n           : can be in terms of peptide sequence space, yet the query and/or hit\n           : sequence are in nucleotide space.\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : In the case of BLAST flavors:\n           : For TBLASTN reports, the length of the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           :\n           : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub logical_length {\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my ($length, $logical);\n    my $algo = $self->algorithm;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->length;\n    } else {\n        # Otherwise, return logical query length\n        $length = $self->query_length();\n        $self->throw(\"Must have defined query_len\") unless ( $length );\n    }\n\n    $logical = Bio::Search::SearchUtils::logical_length($algo, $seqType, $length);\n\n    return int($logical);\n}\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer \n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           : \n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\nsub length_aln {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    # Setter:\n    if( defined $num) {\n        return $self->{'_length_aln_'.$seqType} = $num;\n    }\n\n    unless ($self->{'_hsps'}) {\n        #return wantarray ? ('-','-') : '-';\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $data = $self->{'_length_aln_'.$seqType};\n    \n    ## If we don't have data, figure out what went wrong.\n    if(!$data) {\n        $self->throw(\"Can't get length aln for sequence type \\\"$seqType\\\". \" . \n                     \"Valid types are 'query', 'hit', 'sbjct' ('sbjct' = 'hit')\");\n    }                \n    return $data;\n}    \n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, hit, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers  \n           :    (queryGaps, hitGaps)\n           : Array context can be forced by providing an argument of 'list' or 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed \n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : Not relying on wantarray since that will fail in situations \n           : such as printf \"%d\", $hit->gaps() in which you might expect to \n           : be printing the total gaps, but evaluates to array context.\n\nSee Also   : L<length_aln()|length_aln>","parameters":[{"label":"$self"},{"label":"$seqType"},{"label":"$num"}],"label":"gaps($self,$seqType,$num)"},"detail":"($self,$seqType,$num)","definition":"sub","containerName":"main::"},{"name":"Bio","containerName":"Search::SearchUtils::_warn_about_no_hsps","kind":12,"line":845},{"containerName":"Search::SearchUtils::tile_hsps","name":"Bio","kind":12,"line":850},{"range":{"start":{"character":0,"line":876},"end":{"character":9999,"line":913}},"name":"matches","signature":{"label":"matches($self,$arg1,$arg2)","documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\nsub significance {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_significance'};\n    if( defined $value ) { \n        $self->{'_significance'} = $value;\n    } elsif ( ! defined $previous ) {\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this Hit (\".$self->name.\")\");\n\t    return;\n\t}\n        # Set the significance of the Hit to that of the top HSP.\n        $previous = $self->{'_significance'} = ($self->hsps)[0]->significance;\n    }\n\n    return $previous;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_bits'};\n    if( defined $value ) { \n        $self->{'_bits'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using WU-BLAST, check raw_score() instead\");\n\t    return;\n\t}\n        $previous = $self->{'_bits'} = ($self->hsps)[0]->bits;\n    }    \n    return $previous;\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    $self->{'_iterator'} = 0 unless defined $self->{'_iterator'};\n    return unless\n        defined($self->{'_hsps'}) \n        && $self->{'_iterator'} <= scalar @{$self->{'_hsps'}};\n    \n    my $iterator = $self->{'_iterator'}++;\n    my $hsp = $self->{'_hsps'}->[$iterator] || return;\n    if (ref($hsp) eq 'HASH') {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $hsp = $factory->create_object(%{$hsp});\n        $self->{'_hsps'}->[$iterator] = $hsp;\n        delete $self->{_hashes}->{$iterator};\n    }\n    return $hsp;  \n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    my $self = shift;\n    foreach my $i (keys %{$self->{_hashes} || {}}) {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $self->{'_hsps'}->[$i] = $factory->create_object(%{$self->{'_hsps'}->[$i]});\n        delete $self->{_hashes}->{$i};\n    }\n    \n    return wantarray() ? @{$self->{'_hsps'} || []} : scalar(@{$self->{'_hsps'} || []});\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    my $self = shift;\n    \n    unless ($self->{'_hsps'}) {\n        return '-';\n    }\n    \n    return scalar(@{$self->{'_hsps'}});\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_iterator'} = 0;\n}\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences \n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences \n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains \n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Comment   : Note: \"sbjct\" is synonymous with \"hit\"\n\n\nsub ambiguous_aln {\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n=head2 overlap\n\nSee documentation in L<Bio::Search::Hit::HitI::overlap()|Bio::Search::Hit::HitI>\n\n\nsub overlap {\n    my $self = shift; \n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    my $self = shift; \n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description \n    # line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n\tif( $self->hsp ) {\n\t    $n = $self->hsp->n;\n\t}\n    } else {\n        $n = $self->{'_n'}; \n    } \n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<significance()|significance>, L<Bio::Search::SearchUtils::get_exponent()|Bio::Search::SearchUtils>\n\n\nsub p {\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(!defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using significance() instead.\");\n        $val = $self->significance();\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::SearchUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n    \n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = $self->hsps;\n    \n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : This is necessary since the number of identical/conserved residues \n           : can be in terms of peptide sequence space, yet the query and/or hit\n           : sequence are in nucleotide space.\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : In the case of BLAST flavors:\n           : For TBLASTN reports, the length of the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           :\n           : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub logical_length {\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my ($length, $logical);\n    my $algo = $self->algorithm;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->length;\n    } else {\n        # Otherwise, return logical query length\n        $length = $self->query_length();\n        $self->throw(\"Must have defined query_len\") unless ( $length );\n    }\n\n    $logical = Bio::Search::SearchUtils::logical_length($algo, $seqType, $length);\n\n    return int($logical);\n}\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer \n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           : \n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\nsub length_aln {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    # Setter:\n    if( defined $num) {\n        return $self->{'_length_aln_'.$seqType} = $num;\n    }\n\n    unless ($self->{'_hsps'}) {\n        #return wantarray ? ('-','-') : '-';\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $data = $self->{'_length_aln_'.$seqType};\n    \n    ## If we don't have data, figure out what went wrong.\n    if(!$data) {\n        $self->throw(\"Can't get length aln for sequence type \\\"$seqType\\\". \" . \n                     \"Valid types are 'query', 'hit', 'sbjct' ('sbjct' = 'hit')\");\n    }                \n    return $data;\n}    \n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, hit, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers  \n           :    (queryGaps, hitGaps)\n           : Array context can be forced by providing an argument of 'list' or 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed \n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : Not relying on wantarray since that will fail in situations \n           : such as printf \"%d\", $hit->gaps() in which you might expect to \n           : be printing the total gaps, but evaluates to array context.\n\nSee Also   : L<length_aln()|length_aln>\n\n\nsub gaps {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n        #return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    $seqType = lc($seqType);\n\n    if( defined $num ) {\n        $self->throw(\"Can't set gaps for seqType '$seqType'. Must be 'query' or 'hit'\\n\") unless ($seqType eq 'sbjct' or $seqType eq 'query');\n\n        return $self->{'_gaps_'.$seqType} = $num;\n    }\n    elsif($seqType =~ /list|array/i) {\n        return ($self->{'_gaps_query'}, $self->{'_gaps_sbjct'});\n    }\n    elsif($seqType eq 'total') {\n        return ($self->{'_gaps_query'} + $self->{'_gaps_sbjct'}) || 0;\n    } else {\n        return $self->{'_gaps_'.$seqType} || 0;\n    }\n}    \n\n\n=head2 matches\n\nSee documentation in L<Bio::Search::Hit::HitI::matches()|Bio::Search::Hit::HitI>","parameters":[{"label":"$self"},{"label":"$arg1"},{"label":"$arg2"}]},"detail":"($self,$arg1,$arg2)","definition":"sub","containerName":"main::","children":[{"containerName":"matches","definition":"my","name":"$self","localvar":"my","kind":13,"line":877},{"containerName":"matches","name":"$arg1","kind":13,"line":877},{"containerName":"matches","name":"$arg2","kind":13,"line":877},{"localvar":"my","name":"@data","definition":"my","containerName":"matches","line":878,"kind":13},{"line":878,"kind":13,"containerName":"matches","name":"$data"},{"name":"$self","containerName":"matches","kind":13,"line":880},{"name":"$self","containerName":"matches","line":881,"kind":13},{"line":885,"kind":13,"containerName":"matches","name":"$self"},{"name":"$self","containerName":"matches","kind":13,"line":885},{"kind":12,"line":885,"containerName":"matches","name":"tiled_hsps"},{"containerName":"matches","name":"$arg1","line":887,"kind":13},{"containerName":"matches","name":"@data","kind":13,"line":888},{"line":888,"kind":13,"name":"$self","containerName":"matches"},{"line":888,"kind":13,"name":"$self","containerName":"matches"},{"name":"@data","containerName":"matches","kind":13,"line":890},{"name":"$arg2","containerName":"matches","line":893,"kind":13},{"kind":13,"line":894,"containerName":"matches","name":"$self"},{"containerName":"matches","name":"$arg1","line":894,"kind":13},{"kind":13,"line":895,"name":"$self","containerName":"matches"},{"name":"$arg2","containerName":"matches","line":895,"kind":13},{"line":896,"kind":13,"containerName":"matches","name":"$arg1"},{"line":896,"kind":13,"name":"$arg2","containerName":"matches"},{"name":"$arg1","containerName":"matches","line":898,"kind":13},{"name":"$data","containerName":"matches","line":899,"kind":13},{"kind":13,"line":899,"containerName":"matches","name":"$self"},{"name":"$data","containerName":"matches","line":901,"kind":13},{"kind":13,"line":901,"name":"$self","containerName":"matches"},{"kind":13,"line":904,"containerName":"matches","name":"$data"}],"line":876,"kind":12},{"kind":12,"line":881,"containerName":"Search::SearchUtils::_warn_about_no_hsps","name":"Bio"},{"containerName":"Search::SearchUtils::tile_hsps","name":"Bio","kind":12,"line":885},{"name":"start","range":{"start":{"line":937,"character":0},"end":{"character":9999,"line":988}},"containerName":"main::","definition":"sub","detail":"($self,$seqType,$num)","signature":{"label":"start($self,$seqType,$num)","parameters":[{"label":"$self"},{"label":"$seqType"},{"label":"$num"}],"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\nsub significance {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_significance'};\n    if( defined $value ) { \n        $self->{'_significance'} = $value;\n    } elsif ( ! defined $previous ) {\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this Hit (\".$self->name.\")\");\n\t    return;\n\t}\n        # Set the significance of the Hit to that of the top HSP.\n        $previous = $self->{'_significance'} = ($self->hsps)[0]->significance;\n    }\n\n    return $previous;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_bits'};\n    if( defined $value ) { \n        $self->{'_bits'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using WU-BLAST, check raw_score() instead\");\n\t    return;\n\t}\n        $previous = $self->{'_bits'} = ($self->hsps)[0]->bits;\n    }    \n    return $previous;\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    $self->{'_iterator'} = 0 unless defined $self->{'_iterator'};\n    return unless\n        defined($self->{'_hsps'}) \n        && $self->{'_iterator'} <= scalar @{$self->{'_hsps'}};\n    \n    my $iterator = $self->{'_iterator'}++;\n    my $hsp = $self->{'_hsps'}->[$iterator] || return;\n    if (ref($hsp) eq 'HASH') {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $hsp = $factory->create_object(%{$hsp});\n        $self->{'_hsps'}->[$iterator] = $hsp;\n        delete $self->{_hashes}->{$iterator};\n    }\n    return $hsp;  \n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    my $self = shift;\n    foreach my $i (keys %{$self->{_hashes} || {}}) {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $self->{'_hsps'}->[$i] = $factory->create_object(%{$self->{'_hsps'}->[$i]});\n        delete $self->{_hashes}->{$i};\n    }\n    \n    return wantarray() ? @{$self->{'_hsps'} || []} : scalar(@{$self->{'_hsps'} || []});\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    my $self = shift;\n    \n    unless ($self->{'_hsps'}) {\n        return '-';\n    }\n    \n    return scalar(@{$self->{'_hsps'}});\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_iterator'} = 0;\n}\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences \n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences \n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains \n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Comment   : Note: \"sbjct\" is synonymous with \"hit\"\n\n\nsub ambiguous_aln {\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n=head2 overlap\n\nSee documentation in L<Bio::Search::Hit::HitI::overlap()|Bio::Search::Hit::HitI>\n\n\nsub overlap {\n    my $self = shift; \n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    my $self = shift; \n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description \n    # line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n\tif( $self->hsp ) {\n\t    $n = $self->hsp->n;\n\t}\n    } else {\n        $n = $self->{'_n'}; \n    } \n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<significance()|significance>, L<Bio::Search::SearchUtils::get_exponent()|Bio::Search::SearchUtils>\n\n\nsub p {\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(!defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using significance() instead.\");\n        $val = $self->significance();\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::SearchUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n    \n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = $self->hsps;\n    \n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : This is necessary since the number of identical/conserved residues \n           : can be in terms of peptide sequence space, yet the query and/or hit\n           : sequence are in nucleotide space.\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : In the case of BLAST flavors:\n           : For TBLASTN reports, the length of the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           :\n           : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub logical_length {\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my ($length, $logical);\n    my $algo = $self->algorithm;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->length;\n    } else {\n        # Otherwise, return logical query length\n        $length = $self->query_length();\n        $self->throw(\"Must have defined query_len\") unless ( $length );\n    }\n\n    $logical = Bio::Search::SearchUtils::logical_length($algo, $seqType, $length);\n\n    return int($logical);\n}\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer \n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           : \n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\nsub length_aln {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    # Setter:\n    if( defined $num) {\n        return $self->{'_length_aln_'.$seqType} = $num;\n    }\n\n    unless ($self->{'_hsps'}) {\n        #return wantarray ? ('-','-') : '-';\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $data = $self->{'_length_aln_'.$seqType};\n    \n    ## If we don't have data, figure out what went wrong.\n    if(!$data) {\n        $self->throw(\"Can't get length aln for sequence type \\\"$seqType\\\". \" . \n                     \"Valid types are 'query', 'hit', 'sbjct' ('sbjct' = 'hit')\");\n    }                \n    return $data;\n}    \n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, hit, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers  \n           :    (queryGaps, hitGaps)\n           : Array context can be forced by providing an argument of 'list' or 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed \n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : Not relying on wantarray since that will fail in situations \n           : such as printf \"%d\", $hit->gaps() in which you might expect to \n           : be printing the total gaps, but evaluates to array context.\n\nSee Also   : L<length_aln()|length_aln>\n\n\nsub gaps {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n        #return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    $seqType = lc($seqType);\n\n    if( defined $num ) {\n        $self->throw(\"Can't set gaps for seqType '$seqType'. Must be 'query' or 'hit'\\n\") unless ($seqType eq 'sbjct' or $seqType eq 'query');\n\n        return $self->{'_gaps_'.$seqType} = $num;\n    }\n    elsif($seqType =~ /list|array/i) {\n        return ($self->{'_gaps_query'}, $self->{'_gaps_sbjct'});\n    }\n    elsif($seqType eq 'total') {\n        return ($self->{'_gaps_query'} + $self->{'_gaps_sbjct'}) || 0;\n    } else {\n        return $self->{'_gaps_'.$seqType} || 0;\n    }\n}    \n\n\n=head2 matches\n\nSee documentation in L<Bio::Search::Hit::HitI::matches()|Bio::Search::Hit::HitI>\n\n\nsub matches {\n    my( $self, $arg1, $arg2) = @_;\n    my(@data,$data);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    unless( $arg1 ) {\n        @data = ($self->{'_totalIdentical'}, $self->{'_totalConserved'});\n\n        return @data;\n    } else {\n\n        if( defined $arg2 ) {\n            $self->{'_totalIdentical'} = $arg1;\n            $self->{'_totalConserved'} = $arg2;\n            return ( $arg1, $arg2 );\n        }\n        elsif($arg1 =~ /^id/i) { \n            $data = $self->{'_totalIdentical'};\n        } else {\n            $data = $self->{'_totalConserved'};\n        }\n        #print STDERR \"\\nmatches(): id=$self->{'_totalIdentical'}, cons=$self->{'_totalConserved'}\\n\\n\";\n        return $data;\n    }\n    \n    ## If we make it to here, it is likely the case that\n    ## the parser constructed a minimal hit object from the summary line only.\n    ## It either delibrately skipped parsing the alignment section,\n    ## or was not able to because it was absent (due to blast executable parameter\n    ## setting such as -b 0 (B=0 for WU-BLAST) )\n    #$self->throw(\"Can't get identical or conserved data: no data.\");\n}\n\n\n=head2 start\n\n Usage     : $sbjct->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, the lowest start\n           : value of all HSPs is returned.\n Example   : $qbeg = $sbjct->start('query');\n           : $sbeg = $sbjct->start('hit');\n           : ($qbeg, $sbeg) = $sbjct->start();\n Returns   : scalar context: integer \n           : array context without args: list of two integers (queryStart, sbjctStart)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<end()|end>, L<range()|range>, L<strand()|strand>, \n             L<Bio::Search::HSP::BlastHSP::start|Bio::Search::HSP::BlastHSP>"},"kind":12,"line":937,"children":[{"kind":13,"line":938,"containerName":"start","definition":"my","name":"$self","localvar":"my"},{"name":"$seqType","containerName":"start","line":938,"kind":13},{"line":938,"kind":13,"name":"$num","containerName":"start"},{"kind":13,"line":940,"name":"$self","containerName":"start"},{"kind":13,"line":941,"name":"$self","containerName":"start"},{"line":945,"kind":13,"name":"$seqType","containerName":"start"},{"name":"$seqType","containerName":"start","kind":13,"line":946},{"kind":13,"line":946,"name":"$seqType","containerName":"start"},{"kind":13,"line":948,"containerName":"start","name":"$num"},{"kind":13,"line":949,"name":"$seqType","containerName":"start"},{"line":950,"kind":13,"name":"$self","containerName":"start"},{"line":950,"kind":13,"name":"$seqType","containerName":"start"},{"name":"$num","containerName":"start","kind":13,"line":950},{"containerName":"start","name":"$self","line":954,"kind":13},{"line":954,"kind":12,"containerName":"start","name":"num_hsps"},{"line":955,"kind":13,"containerName":"start","name":"$self"},{"containerName":"start","name":"hsp","line":955,"kind":12},{"kind":12,"line":955,"containerName":"start","name":"start"},{"line":955,"kind":13,"containerName":"start","name":"$seqType"},{"line":961,"kind":13,"name":"$self","containerName":"start"},{"localvar":"my","containerName":"start","name":"$earliest_query_start","definition":"my","line":962,"kind":13},{"localvar":"my","containerName":"start","definition":"my","name":"$earliest_sbjct_start","line":963,"kind":13},{"kind":13,"line":964,"containerName":"start","name":"$hsp","definition":"my","localvar":"my"},{"name":"$self","containerName":"start","kind":13,"line":964},{"name":"hsps","containerName":"start","kind":12,"line":964},{"kind":13,"line":965,"name":"$this_query_start","definition":"my","containerName":"start","localvar":"my"},{"name":"$hsp","containerName":"start","kind":13,"line":965},{"kind":12,"line":965,"name":"start","containerName":"start"},{"kind":13,"line":966,"name":"$earliest_query_start","containerName":"start"},{"kind":13,"line":966,"name":"$this_query_start","containerName":"start"},{"kind":13,"line":966,"containerName":"start","name":"$earliest_query_start"},{"name":"$earliest_query_start","containerName":"start","line":967,"kind":13},{"name":"$this_query_start","containerName":"start","kind":13,"line":967},{"containerName":"start","definition":"my","name":"$this_sbjct_start","localvar":"my","kind":13,"line":970},{"line":970,"kind":13,"containerName":"start","name":"$hsp"},{"line":970,"kind":12,"containerName":"start","name":"start"},{"line":971,"kind":13,"containerName":"start","name":"$earliest_sbjct_start"},{"containerName":"start","name":"$this_sbjct_start","line":971,"kind":13},{"containerName":"start","name":"$earliest_sbjct_start","kind":13,"line":971},{"containerName":"start","name":"$earliest_sbjct_start","kind":13,"line":972},{"containerName":"start","name":"$this_sbjct_start","line":972,"kind":13},{"line":975,"kind":13,"name":"$self","containerName":"start"},{"kind":13,"line":975,"name":"$earliest_query_start","containerName":"start"},{"containerName":"start","name":"$self","kind":13,"line":976},{"name":"$earliest_sbjct_start","containerName":"start","kind":13,"line":976},{"line":980,"kind":13,"containerName":"start","name":"$seqType"},{"line":981,"kind":13,"containerName":"start","name":"$self"},{"name":"$self","containerName":"start","kind":13,"line":981},{"line":984,"kind":13,"containerName":"start","name":"$seqType"},{"name":"$self","containerName":"start","line":985,"kind":13},{"name":"$seqType","containerName":"start","kind":13,"line":985}]},{"kind":12,"line":941,"containerName":"Search::SearchUtils::_warn_about_no_hsps","name":"Bio"},{"range":{"start":{"character":0,"line":1014},"end":{"character":9999,"line":1064}},"name":"end","line":1014,"children":[{"line":1015,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"end"},{"line":1015,"kind":13,"name":"$seqType","containerName":"end"},{"name":"$num","containerName":"end","kind":13,"line":1015},{"containerName":"end","name":"$self","line":1017,"kind":13},{"line":1021,"kind":13,"name":"$seqType","containerName":"end"},{"line":1022,"kind":13,"name":"$seqType","containerName":"end"},{"kind":13,"line":1022,"containerName":"end","name":"$seqType"},{"containerName":"end","name":"$num","kind":13,"line":1024},{"containerName":"end","name":"$seqType","kind":13,"line":1025},{"line":1026,"kind":13,"name":"$self","containerName":"end"},{"containerName":"end","name":"$seqType","kind":13,"line":1026},{"kind":13,"line":1026,"name":"$num","containerName":"end"},{"line":1030,"kind":13,"containerName":"end","name":"$self"},{"name":"num_hsps","containerName":"end","line":1030,"kind":12},{"containerName":"end","name":"$self","kind":13,"line":1031},{"kind":12,"line":1031,"name":"hsp","containerName":"end"},{"kind":12,"line":1031,"name":"end","containerName":"end"},{"kind":13,"line":1031,"containerName":"end","name":"$seqType"},{"kind":13,"line":1037,"name":"$self","containerName":"end"},{"containerName":"end","definition":"my","name":"$latest_query_end","localvar":"my","kind":13,"line":1038},{"line":1039,"kind":13,"localvar":"my","containerName":"end","name":"$latest_sbjct_end","definition":"my"},{"kind":13,"line":1040,"definition":"my","name":"$hsp","containerName":"end","localvar":"my"},{"name":"$self","containerName":"end","line":1040,"kind":13},{"name":"hsps","containerName":"end","kind":12,"line":1040},{"name":"$this_query_end","definition":"my","containerName":"end","localvar":"my","kind":13,"line":1041},{"containerName":"end","name":"$hsp","line":1041,"kind":13},{"kind":12,"line":1041,"containerName":"end","name":"end"},{"containerName":"end","name":"$latest_query_end","line":1042,"kind":13},{"name":"$this_query_end","containerName":"end","line":1042,"kind":13},{"line":1042,"kind":13,"containerName":"end","name":"$latest_query_end"},{"name":"$latest_query_end","containerName":"end","kind":13,"line":1043},{"containerName":"end","name":"$this_query_end","line":1043,"kind":13},{"definition":"my","name":"$this_sbjct_end","containerName":"end","localvar":"my","kind":13,"line":1046},{"kind":13,"line":1046,"containerName":"end","name":"$hsp"},{"line":1046,"kind":12,"name":"end","containerName":"end"},{"name":"$latest_sbjct_end","containerName":"end","kind":13,"line":1047},{"kind":13,"line":1047,"name":"$this_sbjct_end","containerName":"end"},{"name":"$latest_sbjct_end","containerName":"end","line":1047,"kind":13},{"line":1048,"kind":13,"containerName":"end","name":"$latest_sbjct_end"},{"name":"$this_sbjct_end","containerName":"end","line":1048,"kind":13},{"line":1051,"kind":13,"containerName":"end","name":"$self"},{"kind":13,"line":1051,"containerName":"end","name":"$latest_query_end"},{"line":1052,"kind":13,"containerName":"end","name":"$self"},{"kind":13,"line":1052,"name":"$latest_sbjct_end","containerName":"end"},{"kind":13,"line":1056,"containerName":"end","name":"$seqType"},{"kind":13,"line":1057,"name":"$self","containerName":"end"},{"name":"$self","containerName":"end","kind":13,"line":1057},{"name":"$seqType","containerName":"end","line":1060,"kind":13},{"line":1061,"kind":13,"name":"$self","containerName":"end"},{"line":1061,"kind":13,"containerName":"end","name":"$seqType"}],"kind":12,"detail":"($self,$seqType,$num)","signature":{"label":"end($self,$seqType,$num)","documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\nsub significance {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_significance'};\n    if( defined $value ) { \n        $self->{'_significance'} = $value;\n    } elsif ( ! defined $previous ) {\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this Hit (\".$self->name.\")\");\n\t    return;\n\t}\n        # Set the significance of the Hit to that of the top HSP.\n        $previous = $self->{'_significance'} = ($self->hsps)[0]->significance;\n    }\n\n    return $previous;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_bits'};\n    if( defined $value ) { \n        $self->{'_bits'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using WU-BLAST, check raw_score() instead\");\n\t    return;\n\t}\n        $previous = $self->{'_bits'} = ($self->hsps)[0]->bits;\n    }    \n    return $previous;\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    $self->{'_iterator'} = 0 unless defined $self->{'_iterator'};\n    return unless\n        defined($self->{'_hsps'}) \n        && $self->{'_iterator'} <= scalar @{$self->{'_hsps'}};\n    \n    my $iterator = $self->{'_iterator'}++;\n    my $hsp = $self->{'_hsps'}->[$iterator] || return;\n    if (ref($hsp) eq 'HASH') {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $hsp = $factory->create_object(%{$hsp});\n        $self->{'_hsps'}->[$iterator] = $hsp;\n        delete $self->{_hashes}->{$iterator};\n    }\n    return $hsp;  \n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    my $self = shift;\n    foreach my $i (keys %{$self->{_hashes} || {}}) {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $self->{'_hsps'}->[$i] = $factory->create_object(%{$self->{'_hsps'}->[$i]});\n        delete $self->{_hashes}->{$i};\n    }\n    \n    return wantarray() ? @{$self->{'_hsps'} || []} : scalar(@{$self->{'_hsps'} || []});\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    my $self = shift;\n    \n    unless ($self->{'_hsps'}) {\n        return '-';\n    }\n    \n    return scalar(@{$self->{'_hsps'}});\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_iterator'} = 0;\n}\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences \n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences \n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains \n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Comment   : Note: \"sbjct\" is synonymous with \"hit\"\n\n\nsub ambiguous_aln {\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n=head2 overlap\n\nSee documentation in L<Bio::Search::Hit::HitI::overlap()|Bio::Search::Hit::HitI>\n\n\nsub overlap {\n    my $self = shift; \n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    my $self = shift; \n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description \n    # line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n\tif( $self->hsp ) {\n\t    $n = $self->hsp->n;\n\t}\n    } else {\n        $n = $self->{'_n'}; \n    } \n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<significance()|significance>, L<Bio::Search::SearchUtils::get_exponent()|Bio::Search::SearchUtils>\n\n\nsub p {\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(!defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using significance() instead.\");\n        $val = $self->significance();\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::SearchUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n    \n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = $self->hsps;\n    \n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : This is necessary since the number of identical/conserved residues \n           : can be in terms of peptide sequence space, yet the query and/or hit\n           : sequence are in nucleotide space.\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : In the case of BLAST flavors:\n           : For TBLASTN reports, the length of the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           :\n           : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub logical_length {\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my ($length, $logical);\n    my $algo = $self->algorithm;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->length;\n    } else {\n        # Otherwise, return logical query length\n        $length = $self->query_length();\n        $self->throw(\"Must have defined query_len\") unless ( $length );\n    }\n\n    $logical = Bio::Search::SearchUtils::logical_length($algo, $seqType, $length);\n\n    return int($logical);\n}\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer \n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           : \n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\nsub length_aln {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    # Setter:\n    if( defined $num) {\n        return $self->{'_length_aln_'.$seqType} = $num;\n    }\n\n    unless ($self->{'_hsps'}) {\n        #return wantarray ? ('-','-') : '-';\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $data = $self->{'_length_aln_'.$seqType};\n    \n    ## If we don't have data, figure out what went wrong.\n    if(!$data) {\n        $self->throw(\"Can't get length aln for sequence type \\\"$seqType\\\". \" . \n                     \"Valid types are 'query', 'hit', 'sbjct' ('sbjct' = 'hit')\");\n    }                \n    return $data;\n}    \n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, hit, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers  \n           :    (queryGaps, hitGaps)\n           : Array context can be forced by providing an argument of 'list' or 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed \n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : Not relying on wantarray since that will fail in situations \n           : such as printf \"%d\", $hit->gaps() in which you might expect to \n           : be printing the total gaps, but evaluates to array context.\n\nSee Also   : L<length_aln()|length_aln>\n\n\nsub gaps {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n        #return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    $seqType = lc($seqType);\n\n    if( defined $num ) {\n        $self->throw(\"Can't set gaps for seqType '$seqType'. Must be 'query' or 'hit'\\n\") unless ($seqType eq 'sbjct' or $seqType eq 'query');\n\n        return $self->{'_gaps_'.$seqType} = $num;\n    }\n    elsif($seqType =~ /list|array/i) {\n        return ($self->{'_gaps_query'}, $self->{'_gaps_sbjct'});\n    }\n    elsif($seqType eq 'total') {\n        return ($self->{'_gaps_query'} + $self->{'_gaps_sbjct'}) || 0;\n    } else {\n        return $self->{'_gaps_'.$seqType} || 0;\n    }\n}    \n\n\n=head2 matches\n\nSee documentation in L<Bio::Search::Hit::HitI::matches()|Bio::Search::Hit::HitI>\n\n\nsub matches {\n    my( $self, $arg1, $arg2) = @_;\n    my(@data,$data);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    unless( $arg1 ) {\n        @data = ($self->{'_totalIdentical'}, $self->{'_totalConserved'});\n\n        return @data;\n    } else {\n\n        if( defined $arg2 ) {\n            $self->{'_totalIdentical'} = $arg1;\n            $self->{'_totalConserved'} = $arg2;\n            return ( $arg1, $arg2 );\n        }\n        elsif($arg1 =~ /^id/i) { \n            $data = $self->{'_totalIdentical'};\n        } else {\n            $data = $self->{'_totalConserved'};\n        }\n        #print STDERR \"\\nmatches(): id=$self->{'_totalIdentical'}, cons=$self->{'_totalConserved'}\\n\\n\";\n        return $data;\n    }\n    \n    ## If we make it to here, it is likely the case that\n    ## the parser constructed a minimal hit object from the summary line only.\n    ## It either delibrately skipped parsing the alignment section,\n    ## or was not able to because it was absent (due to blast executable parameter\n    ## setting such as -b 0 (B=0 for WU-BLAST) )\n    #$self->throw(\"Can't get identical or conserved data: no data.\");\n}\n\n\n=head2 start\n\n Usage     : $sbjct->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, the lowest start\n           : value of all HSPs is returned.\n Example   : $qbeg = $sbjct->start('query');\n           : $sbeg = $sbjct->start('hit');\n           : ($qbeg, $sbeg) = $sbjct->start();\n Returns   : scalar context: integer \n           : array context without args: list of two integers (queryStart, sbjctStart)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<end()|end>, L<range()|range>, L<strand()|strand>, \n             L<Bio::Search::HSP::BlastHSP::start|Bio::Search::HSP::BlastHSP>\n\n\nsub start {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Start'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->start($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStart'} and\n        # $self->{'_sbjctStart'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStart'}) {\n            my $earliest_query_start;\n            my $earliest_sbjct_start;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_start = $hsp->start('query');\n                if (! defined $earliest_query_start || $this_query_start < $earliest_query_start) {\n                    $earliest_query_start = $this_query_start;\n                }\n                \n                my $this_sbjct_start = $hsp->start('sbjct');\n                if (! defined $earliest_sbjct_start || $this_sbjct_start < $earliest_sbjct_start) {\n                    $earliest_sbjct_start = $this_sbjct_start;\n                }\n            }\n            $self->{'_queryStart'} = $earliest_query_start;\n            $self->{'_sbjctStart'} = $earliest_sbjct_start;\n        }\n        \n        \n        if ($seqType =~ /list|array/i) {\n            return ($self->{'_queryStart'}, $self->{'_sbjctStart'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Start'};\n        }\n    }\n}\n\n\n=head2 end\n\n Usage     : $sbjct->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, \n             the largest end\n           : value of all HSPs is returned.\n Example   : $qend = $sbjct->end('query');\n           : $send = $sbjct->end('hit');\n           : ($qend, $send) = $sbjct->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers \n           : (queryEnd, sbjctEnd)\n           : Array context can be \"induced\" by providing an argument \n           : of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'sbjct'\n           :  (case insensitive). If not supplied, 'query' is used.\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<range()|range>, L<strand()|strand>","parameters":[{"label":"$self"},{"label":"$seqType"},{"label":"$num"}]},"containerName":"main::","definition":"sub"},{"name":"range","range":{"end":{"character":9999,"line":1087},"start":{"line":1082,"character":0}},"containerName":"main::","definition":"sub","detail":"($self,$seqType)","signature":{"label":"range($self,$seqType)","parameters":[{"label":"$self"},{"label":"$seqType"}],"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\nsub significance {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_significance'};\n    if( defined $value ) { \n        $self->{'_significance'} = $value;\n    } elsif ( ! defined $previous ) {\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this Hit (\".$self->name.\")\");\n\t    return;\n\t}\n        # Set the significance of the Hit to that of the top HSP.\n        $previous = $self->{'_significance'} = ($self->hsps)[0]->significance;\n    }\n\n    return $previous;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_bits'};\n    if( defined $value ) { \n        $self->{'_bits'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using WU-BLAST, check raw_score() instead\");\n\t    return;\n\t}\n        $previous = $self->{'_bits'} = ($self->hsps)[0]->bits;\n    }    \n    return $previous;\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    $self->{'_iterator'} = 0 unless defined $self->{'_iterator'};\n    return unless\n        defined($self->{'_hsps'}) \n        && $self->{'_iterator'} <= scalar @{$self->{'_hsps'}};\n    \n    my $iterator = $self->{'_iterator'}++;\n    my $hsp = $self->{'_hsps'}->[$iterator] || return;\n    if (ref($hsp) eq 'HASH') {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $hsp = $factory->create_object(%{$hsp});\n        $self->{'_hsps'}->[$iterator] = $hsp;\n        delete $self->{_hashes}->{$iterator};\n    }\n    return $hsp;  \n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    my $self = shift;\n    foreach my $i (keys %{$self->{_hashes} || {}}) {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $self->{'_hsps'}->[$i] = $factory->create_object(%{$self->{'_hsps'}->[$i]});\n        delete $self->{_hashes}->{$i};\n    }\n    \n    return wantarray() ? @{$self->{'_hsps'} || []} : scalar(@{$self->{'_hsps'} || []});\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    my $self = shift;\n    \n    unless ($self->{'_hsps'}) {\n        return '-';\n    }\n    \n    return scalar(@{$self->{'_hsps'}});\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_iterator'} = 0;\n}\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences \n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences \n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains \n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Comment   : Note: \"sbjct\" is synonymous with \"hit\"\n\n\nsub ambiguous_aln {\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n=head2 overlap\n\nSee documentation in L<Bio::Search::Hit::HitI::overlap()|Bio::Search::Hit::HitI>\n\n\nsub overlap {\n    my $self = shift; \n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    my $self = shift; \n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description \n    # line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n\tif( $self->hsp ) {\n\t    $n = $self->hsp->n;\n\t}\n    } else {\n        $n = $self->{'_n'}; \n    } \n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<significance()|significance>, L<Bio::Search::SearchUtils::get_exponent()|Bio::Search::SearchUtils>\n\n\nsub p {\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(!defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using significance() instead.\");\n        $val = $self->significance();\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::SearchUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n    \n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = $self->hsps;\n    \n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : This is necessary since the number of identical/conserved residues \n           : can be in terms of peptide sequence space, yet the query and/or hit\n           : sequence are in nucleotide space.\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : In the case of BLAST flavors:\n           : For TBLASTN reports, the length of the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           :\n           : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub logical_length {\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my ($length, $logical);\n    my $algo = $self->algorithm;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->length;\n    } else {\n        # Otherwise, return logical query length\n        $length = $self->query_length();\n        $self->throw(\"Must have defined query_len\") unless ( $length );\n    }\n\n    $logical = Bio::Search::SearchUtils::logical_length($algo, $seqType, $length);\n\n    return int($logical);\n}\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer \n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           : \n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\nsub length_aln {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    # Setter:\n    if( defined $num) {\n        return $self->{'_length_aln_'.$seqType} = $num;\n    }\n\n    unless ($self->{'_hsps'}) {\n        #return wantarray ? ('-','-') : '-';\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $data = $self->{'_length_aln_'.$seqType};\n    \n    ## If we don't have data, figure out what went wrong.\n    if(!$data) {\n        $self->throw(\"Can't get length aln for sequence type \\\"$seqType\\\". \" . \n                     \"Valid types are 'query', 'hit', 'sbjct' ('sbjct' = 'hit')\");\n    }                \n    return $data;\n}    \n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, hit, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers  \n           :    (queryGaps, hitGaps)\n           : Array context can be forced by providing an argument of 'list' or 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed \n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : Not relying on wantarray since that will fail in situations \n           : such as printf \"%d\", $hit->gaps() in which you might expect to \n           : be printing the total gaps, but evaluates to array context.\n\nSee Also   : L<length_aln()|length_aln>\n\n\nsub gaps {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n        #return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    $seqType = lc($seqType);\n\n    if( defined $num ) {\n        $self->throw(\"Can't set gaps for seqType '$seqType'. Must be 'query' or 'hit'\\n\") unless ($seqType eq 'sbjct' or $seqType eq 'query');\n\n        return $self->{'_gaps_'.$seqType} = $num;\n    }\n    elsif($seqType =~ /list|array/i) {\n        return ($self->{'_gaps_query'}, $self->{'_gaps_sbjct'});\n    }\n    elsif($seqType eq 'total') {\n        return ($self->{'_gaps_query'} + $self->{'_gaps_sbjct'}) || 0;\n    } else {\n        return $self->{'_gaps_'.$seqType} || 0;\n    }\n}    \n\n\n=head2 matches\n\nSee documentation in L<Bio::Search::Hit::HitI::matches()|Bio::Search::Hit::HitI>\n\n\nsub matches {\n    my( $self, $arg1, $arg2) = @_;\n    my(@data,$data);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    unless( $arg1 ) {\n        @data = ($self->{'_totalIdentical'}, $self->{'_totalConserved'});\n\n        return @data;\n    } else {\n\n        if( defined $arg2 ) {\n            $self->{'_totalIdentical'} = $arg1;\n            $self->{'_totalConserved'} = $arg2;\n            return ( $arg1, $arg2 );\n        }\n        elsif($arg1 =~ /^id/i) { \n            $data = $self->{'_totalIdentical'};\n        } else {\n            $data = $self->{'_totalConserved'};\n        }\n        #print STDERR \"\\nmatches(): id=$self->{'_totalIdentical'}, cons=$self->{'_totalConserved'}\\n\\n\";\n        return $data;\n    }\n    \n    ## If we make it to here, it is likely the case that\n    ## the parser constructed a minimal hit object from the summary line only.\n    ## It either delibrately skipped parsing the alignment section,\n    ## or was not able to because it was absent (due to blast executable parameter\n    ## setting such as -b 0 (B=0 for WU-BLAST) )\n    #$self->throw(\"Can't get identical or conserved data: no data.\");\n}\n\n\n=head2 start\n\n Usage     : $sbjct->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, the lowest start\n           : value of all HSPs is returned.\n Example   : $qbeg = $sbjct->start('query');\n           : $sbeg = $sbjct->start('hit');\n           : ($qbeg, $sbeg) = $sbjct->start();\n Returns   : scalar context: integer \n           : array context without args: list of two integers (queryStart, sbjctStart)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<end()|end>, L<range()|range>, L<strand()|strand>, \n             L<Bio::Search::HSP::BlastHSP::start|Bio::Search::HSP::BlastHSP>\n\n\nsub start {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Start'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->start($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStart'} and\n        # $self->{'_sbjctStart'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStart'}) {\n            my $earliest_query_start;\n            my $earliest_sbjct_start;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_start = $hsp->start('query');\n                if (! defined $earliest_query_start || $this_query_start < $earliest_query_start) {\n                    $earliest_query_start = $this_query_start;\n                }\n                \n                my $this_sbjct_start = $hsp->start('sbjct');\n                if (! defined $earliest_sbjct_start || $this_sbjct_start < $earliest_sbjct_start) {\n                    $earliest_sbjct_start = $this_sbjct_start;\n                }\n            }\n            $self->{'_queryStart'} = $earliest_query_start;\n            $self->{'_sbjctStart'} = $earliest_sbjct_start;\n        }\n        \n        \n        if ($seqType =~ /list|array/i) {\n            return ($self->{'_queryStart'}, $self->{'_sbjctStart'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Start'};\n        }\n    }\n}\n\n\n=head2 end\n\n Usage     : $sbjct->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, \n             the largest end\n           : value of all HSPs is returned.\n Example   : $qend = $sbjct->end('query');\n           : $send = $sbjct->end('hit');\n           : ($qend, $send) = $sbjct->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers \n           : (queryEnd, sbjctEnd)\n           : Array context can be \"induced\" by providing an argument \n           : of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'sbjct'\n           :  (case insensitive). If not supplied, 'query' is used.\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<range()|range>, L<strand()|strand>\n\n\nsub end {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Stop'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->end($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStop'} and\n        # $self->{'_sbjctStop'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStop'}) {\n            my $latest_query_end;\n            my $latest_sbjct_end;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_end = $hsp->end('query');\n                if (! defined $latest_query_end || $this_query_end > $latest_query_end) {\n                    $latest_query_end = $this_query_end;\n                }\n                \n                my $this_sbjct_end = $hsp->end('sbjct');\n                if (! defined $latest_sbjct_end || $this_sbjct_end > $latest_sbjct_end) {\n                    $latest_sbjct_end = $this_sbjct_end;\n                }\n            }\n            $self->{'_queryStop'} = $latest_query_end;\n            $self->{'_sbjctStop'} = $latest_sbjct_end;\n        }\n        \n        \n        if($seqType =~ /list|array/i) {\n            return ($self->{'_queryStop'}, $self->{'_sbjctStop'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Stop'};\n        }\n    }\n}\n\n=head2 range\n\n Usage     : $sbjct->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($qbeg, $qend) = $sbjct->range('query');\n           : ($sbeg, $send) = $sbjct->range('hit');\n Returns   : Two-element array of integers \n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<end()|end>"},"kind":12,"line":1082,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"range","line":1083,"kind":13},{"name":"$seqType","containerName":"range","kind":13,"line":1083},{"kind":13,"line":1084,"containerName":"range","name":"$seqType"},{"kind":13,"line":1085,"containerName":"range","name":"$seqType"},{"containerName":"range","name":"$seqType","kind":13,"line":1085},{"kind":13,"line":1086,"name":"$self","containerName":"range"},{"containerName":"range","name":"start","line":1086,"kind":12},{"containerName":"range","name":"$seqType","kind":13,"line":1086},{"kind":13,"line":1086,"name":"$self","containerName":"range"},{"containerName":"range","name":"end","kind":12,"line":1086},{"name":"$seqType","containerName":"range","line":1086,"kind":13}]},{"children":[{"line":1140,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"frac_identical"},{"containerName":"frac_identical","name":"$seqType","line":1140,"kind":13},{"line":1141,"kind":13,"name":"$seqType","containerName":"frac_identical"},{"containerName":"frac_identical","name":"$seqType","line":1142,"kind":13},{"kind":13,"line":1142,"name":"$seqType","containerName":"frac_identical"},{"line":1145,"kind":13,"name":"$seqType","containerName":"frac_identical"},{"name":"$seqType","containerName":"frac_identical","kind":13,"line":1145},{"containerName":"frac_identical","name":"$self","line":1147,"kind":13},{"containerName":"frac_identical","name":"$self","kind":13,"line":1148},{"kind":13,"line":1153,"containerName":"frac_identical","name":"$self"},{"line":1153,"kind":13,"containerName":"frac_identical","name":"$self"},{"line":1153,"kind":12,"containerName":"frac_identical","name":"tiled_hsps"},{"localvar":"my","containerName":"frac_identical","name":"$ident","definition":"my","line":1155,"kind":13},{"line":1155,"kind":13,"containerName":"frac_identical","name":"$self"},{"line":1155,"kind":12,"name":"matches","containerName":"frac_identical"},{"definition":"my","name":"$total","containerName":"frac_identical","localvar":"my","kind":13,"line":1156},{"kind":13,"line":1156,"containerName":"frac_identical","name":"$self"},{"line":1156,"kind":12,"name":"length_aln","containerName":"frac_identical"},{"name":"$seqType","containerName":"frac_identical","line":1156,"kind":13},{"containerName":"frac_identical","name":"$ratio","definition":"my","localvar":"my","kind":13,"line":1157},{"containerName":"frac_identical","name":"$ident","kind":13,"line":1157},{"kind":13,"line":1157,"name":"$total","containerName":"frac_identical"},{"name":"$ratio_rounded","definition":"my","containerName":"frac_identical","localvar":"my","kind":13,"line":1158},{"line":1158,"kind":13,"containerName":"frac_identical","name":"$ratio"},{"kind":13,"line":1161,"containerName":"frac_identical","name":"$ratio_rounded"},{"containerName":"frac_identical","name":"$ratio_rounded","kind":13,"line":1161},{"name":"$ratio","containerName":"frac_identical","kind":13,"line":1161},{"kind":13,"line":1162,"name":"$ratio_rounded","containerName":"frac_identical"}],"line":1139,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$seqType"}],"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\nsub significance {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_significance'};\n    if( defined $value ) { \n        $self->{'_significance'} = $value;\n    } elsif ( ! defined $previous ) {\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this Hit (\".$self->name.\")\");\n\t    return;\n\t}\n        # Set the significance of the Hit to that of the top HSP.\n        $previous = $self->{'_significance'} = ($self->hsps)[0]->significance;\n    }\n\n    return $previous;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_bits'};\n    if( defined $value ) { \n        $self->{'_bits'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using WU-BLAST, check raw_score() instead\");\n\t    return;\n\t}\n        $previous = $self->{'_bits'} = ($self->hsps)[0]->bits;\n    }    \n    return $previous;\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    $self->{'_iterator'} = 0 unless defined $self->{'_iterator'};\n    return unless\n        defined($self->{'_hsps'}) \n        && $self->{'_iterator'} <= scalar @{$self->{'_hsps'}};\n    \n    my $iterator = $self->{'_iterator'}++;\n    my $hsp = $self->{'_hsps'}->[$iterator] || return;\n    if (ref($hsp) eq 'HASH') {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $hsp = $factory->create_object(%{$hsp});\n        $self->{'_hsps'}->[$iterator] = $hsp;\n        delete $self->{_hashes}->{$iterator};\n    }\n    return $hsp;  \n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    my $self = shift;\n    foreach my $i (keys %{$self->{_hashes} || {}}) {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $self->{'_hsps'}->[$i] = $factory->create_object(%{$self->{'_hsps'}->[$i]});\n        delete $self->{_hashes}->{$i};\n    }\n    \n    return wantarray() ? @{$self->{'_hsps'} || []} : scalar(@{$self->{'_hsps'} || []});\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    my $self = shift;\n    \n    unless ($self->{'_hsps'}) {\n        return '-';\n    }\n    \n    return scalar(@{$self->{'_hsps'}});\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_iterator'} = 0;\n}\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences \n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences \n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains \n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Comment   : Note: \"sbjct\" is synonymous with \"hit\"\n\n\nsub ambiguous_aln {\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n=head2 overlap\n\nSee documentation in L<Bio::Search::Hit::HitI::overlap()|Bio::Search::Hit::HitI>\n\n\nsub overlap {\n    my $self = shift; \n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    my $self = shift; \n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description \n    # line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n\tif( $self->hsp ) {\n\t    $n = $self->hsp->n;\n\t}\n    } else {\n        $n = $self->{'_n'}; \n    } \n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<significance()|significance>, L<Bio::Search::SearchUtils::get_exponent()|Bio::Search::SearchUtils>\n\n\nsub p {\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(!defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using significance() instead.\");\n        $val = $self->significance();\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::SearchUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n    \n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = $self->hsps;\n    \n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : This is necessary since the number of identical/conserved residues \n           : can be in terms of peptide sequence space, yet the query and/or hit\n           : sequence are in nucleotide space.\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : In the case of BLAST flavors:\n           : For TBLASTN reports, the length of the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           :\n           : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub logical_length {\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my ($length, $logical);\n    my $algo = $self->algorithm;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->length;\n    } else {\n        # Otherwise, return logical query length\n        $length = $self->query_length();\n        $self->throw(\"Must have defined query_len\") unless ( $length );\n    }\n\n    $logical = Bio::Search::SearchUtils::logical_length($algo, $seqType, $length);\n\n    return int($logical);\n}\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer \n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           : \n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\nsub length_aln {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    # Setter:\n    if( defined $num) {\n        return $self->{'_length_aln_'.$seqType} = $num;\n    }\n\n    unless ($self->{'_hsps'}) {\n        #return wantarray ? ('-','-') : '-';\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $data = $self->{'_length_aln_'.$seqType};\n    \n    ## If we don't have data, figure out what went wrong.\n    if(!$data) {\n        $self->throw(\"Can't get length aln for sequence type \\\"$seqType\\\". \" . \n                     \"Valid types are 'query', 'hit', 'sbjct' ('sbjct' = 'hit')\");\n    }                \n    return $data;\n}    \n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, hit, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers  \n           :    (queryGaps, hitGaps)\n           : Array context can be forced by providing an argument of 'list' or 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed \n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : Not relying on wantarray since that will fail in situations \n           : such as printf \"%d\", $hit->gaps() in which you might expect to \n           : be printing the total gaps, but evaluates to array context.\n\nSee Also   : L<length_aln()|length_aln>\n\n\nsub gaps {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n        #return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    $seqType = lc($seqType);\n\n    if( defined $num ) {\n        $self->throw(\"Can't set gaps for seqType '$seqType'. Must be 'query' or 'hit'\\n\") unless ($seqType eq 'sbjct' or $seqType eq 'query');\n\n        return $self->{'_gaps_'.$seqType} = $num;\n    }\n    elsif($seqType =~ /list|array/i) {\n        return ($self->{'_gaps_query'}, $self->{'_gaps_sbjct'});\n    }\n    elsif($seqType eq 'total') {\n        return ($self->{'_gaps_query'} + $self->{'_gaps_sbjct'}) || 0;\n    } else {\n        return $self->{'_gaps_'.$seqType} || 0;\n    }\n}    \n\n\n=head2 matches\n\nSee documentation in L<Bio::Search::Hit::HitI::matches()|Bio::Search::Hit::HitI>\n\n\nsub matches {\n    my( $self, $arg1, $arg2) = @_;\n    my(@data,$data);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    unless( $arg1 ) {\n        @data = ($self->{'_totalIdentical'}, $self->{'_totalConserved'});\n\n        return @data;\n    } else {\n\n        if( defined $arg2 ) {\n            $self->{'_totalIdentical'} = $arg1;\n            $self->{'_totalConserved'} = $arg2;\n            return ( $arg1, $arg2 );\n        }\n        elsif($arg1 =~ /^id/i) { \n            $data = $self->{'_totalIdentical'};\n        } else {\n            $data = $self->{'_totalConserved'};\n        }\n        #print STDERR \"\\nmatches(): id=$self->{'_totalIdentical'}, cons=$self->{'_totalConserved'}\\n\\n\";\n        return $data;\n    }\n    \n    ## If we make it to here, it is likely the case that\n    ## the parser constructed a minimal hit object from the summary line only.\n    ## It either delibrately skipped parsing the alignment section,\n    ## or was not able to because it was absent (due to blast executable parameter\n    ## setting such as -b 0 (B=0 for WU-BLAST) )\n    #$self->throw(\"Can't get identical or conserved data: no data.\");\n}\n\n\n=head2 start\n\n Usage     : $sbjct->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, the lowest start\n           : value of all HSPs is returned.\n Example   : $qbeg = $sbjct->start('query');\n           : $sbeg = $sbjct->start('hit');\n           : ($qbeg, $sbeg) = $sbjct->start();\n Returns   : scalar context: integer \n           : array context without args: list of two integers (queryStart, sbjctStart)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<end()|end>, L<range()|range>, L<strand()|strand>, \n             L<Bio::Search::HSP::BlastHSP::start|Bio::Search::HSP::BlastHSP>\n\n\nsub start {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Start'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->start($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStart'} and\n        # $self->{'_sbjctStart'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStart'}) {\n            my $earliest_query_start;\n            my $earliest_sbjct_start;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_start = $hsp->start('query');\n                if (! defined $earliest_query_start || $this_query_start < $earliest_query_start) {\n                    $earliest_query_start = $this_query_start;\n                }\n                \n                my $this_sbjct_start = $hsp->start('sbjct');\n                if (! defined $earliest_sbjct_start || $this_sbjct_start < $earliest_sbjct_start) {\n                    $earliest_sbjct_start = $this_sbjct_start;\n                }\n            }\n            $self->{'_queryStart'} = $earliest_query_start;\n            $self->{'_sbjctStart'} = $earliest_sbjct_start;\n        }\n        \n        \n        if ($seqType =~ /list|array/i) {\n            return ($self->{'_queryStart'}, $self->{'_sbjctStart'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Start'};\n        }\n    }\n}\n\n\n=head2 end\n\n Usage     : $sbjct->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, \n             the largest end\n           : value of all HSPs is returned.\n Example   : $qend = $sbjct->end('query');\n           : $send = $sbjct->end('hit');\n           : ($qend, $send) = $sbjct->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers \n           : (queryEnd, sbjctEnd)\n           : Array context can be \"induced\" by providing an argument \n           : of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'sbjct'\n           :  (case insensitive). If not supplied, 'query' is used.\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<range()|range>, L<strand()|strand>\n\n\nsub end {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Stop'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->end($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStop'} and\n        # $self->{'_sbjctStop'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStop'}) {\n            my $latest_query_end;\n            my $latest_sbjct_end;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_end = $hsp->end('query');\n                if (! defined $latest_query_end || $this_query_end > $latest_query_end) {\n                    $latest_query_end = $this_query_end;\n                }\n                \n                my $this_sbjct_end = $hsp->end('sbjct');\n                if (! defined $latest_sbjct_end || $this_sbjct_end > $latest_sbjct_end) {\n                    $latest_sbjct_end = $this_sbjct_end;\n                }\n            }\n            $self->{'_queryStop'} = $latest_query_end;\n            $self->{'_sbjctStop'} = $latest_sbjct_end;\n        }\n        \n        \n        if($seqType =~ /list|array/i) {\n            return ($self->{'_queryStop'}, $self->{'_sbjctStop'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Stop'};\n        }\n    }\n}\n\n=head2 range\n\n Usage     : $sbjct->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($qbeg, $qend) = $sbjct->range('query');\n           : ($sbeg, $send) = $sbjct->range('hit');\n Returns   : Two-element array of integers \n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<end()|end>\n\n\nsub range {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n    return ($self->start($seqType), $self->end($seqType));\n}\n\n\n=head2 frac_identical\n\n Usage     : $hit_object->frac_identical( [seq_type] );\n Purpose   : Get the overall fraction of identical positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_iden = $hit_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : To compute the fraction identical, the logical length of the \n           : aligned portion of the sequence is used, meaning that\n           : in the case of BLAST flavors, for TBLASTN reports, the length of \n           : the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           : This is necessary since the number of identical residues is\n           : in terms of peptide sequence space.\n           :\n           : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or \n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then iterate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_conserved()|frac_conserved>, L<frac_aligned_query()|frac_aligned_query>, L<matches()|matches>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>","label":"frac_identical($self,$seqType)"},"detail":"($self,$seqType)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":1163},"start":{"line":1139,"character":0}},"name":"frac_identical"},{"line":1148,"kind":12,"containerName":"Search::SearchUtils::_warn_about_no_hsps","name":"Bio"},{"kind":12,"line":1153,"name":"Bio","containerName":"Search::SearchUtils::tile_hsps"},{"signature":{"parameters":[{"label":"$self"},{"label":"$seqType"}],"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\nsub significance {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_significance'};\n    if( defined $value ) { \n        $self->{'_significance'} = $value;\n    } elsif ( ! defined $previous ) {\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this Hit (\".$self->name.\")\");\n\t    return;\n\t}\n        # Set the significance of the Hit to that of the top HSP.\n        $previous = $self->{'_significance'} = ($self->hsps)[0]->significance;\n    }\n\n    return $previous;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_bits'};\n    if( defined $value ) { \n        $self->{'_bits'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using WU-BLAST, check raw_score() instead\");\n\t    return;\n\t}\n        $previous = $self->{'_bits'} = ($self->hsps)[0]->bits;\n    }    \n    return $previous;\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    $self->{'_iterator'} = 0 unless defined $self->{'_iterator'};\n    return unless\n        defined($self->{'_hsps'}) \n        && $self->{'_iterator'} <= scalar @{$self->{'_hsps'}};\n    \n    my $iterator = $self->{'_iterator'}++;\n    my $hsp = $self->{'_hsps'}->[$iterator] || return;\n    if (ref($hsp) eq 'HASH') {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $hsp = $factory->create_object(%{$hsp});\n        $self->{'_hsps'}->[$iterator] = $hsp;\n        delete $self->{_hashes}->{$iterator};\n    }\n    return $hsp;  \n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    my $self = shift;\n    foreach my $i (keys %{$self->{_hashes} || {}}) {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $self->{'_hsps'}->[$i] = $factory->create_object(%{$self->{'_hsps'}->[$i]});\n        delete $self->{_hashes}->{$i};\n    }\n    \n    return wantarray() ? @{$self->{'_hsps'} || []} : scalar(@{$self->{'_hsps'} || []});\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    my $self = shift;\n    \n    unless ($self->{'_hsps'}) {\n        return '-';\n    }\n    \n    return scalar(@{$self->{'_hsps'}});\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_iterator'} = 0;\n}\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences \n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences \n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains \n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Comment   : Note: \"sbjct\" is synonymous with \"hit\"\n\n\nsub ambiguous_aln {\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n=head2 overlap\n\nSee documentation in L<Bio::Search::Hit::HitI::overlap()|Bio::Search::Hit::HitI>\n\n\nsub overlap {\n    my $self = shift; \n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    my $self = shift; \n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description \n    # line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n\tif( $self->hsp ) {\n\t    $n = $self->hsp->n;\n\t}\n    } else {\n        $n = $self->{'_n'}; \n    } \n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<significance()|significance>, L<Bio::Search::SearchUtils::get_exponent()|Bio::Search::SearchUtils>\n\n\nsub p {\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(!defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using significance() instead.\");\n        $val = $self->significance();\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::SearchUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n    \n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = $self->hsps;\n    \n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : This is necessary since the number of identical/conserved residues \n           : can be in terms of peptide sequence space, yet the query and/or hit\n           : sequence are in nucleotide space.\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : In the case of BLAST flavors:\n           : For TBLASTN reports, the length of the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           :\n           : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub logical_length {\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my ($length, $logical);\n    my $algo = $self->algorithm;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->length;\n    } else {\n        # Otherwise, return logical query length\n        $length = $self->query_length();\n        $self->throw(\"Must have defined query_len\") unless ( $length );\n    }\n\n    $logical = Bio::Search::SearchUtils::logical_length($algo, $seqType, $length);\n\n    return int($logical);\n}\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer \n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           : \n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\nsub length_aln {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    # Setter:\n    if( defined $num) {\n        return $self->{'_length_aln_'.$seqType} = $num;\n    }\n\n    unless ($self->{'_hsps'}) {\n        #return wantarray ? ('-','-') : '-';\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $data = $self->{'_length_aln_'.$seqType};\n    \n    ## If we don't have data, figure out what went wrong.\n    if(!$data) {\n        $self->throw(\"Can't get length aln for sequence type \\\"$seqType\\\". \" . \n                     \"Valid types are 'query', 'hit', 'sbjct' ('sbjct' = 'hit')\");\n    }                \n    return $data;\n}    \n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, hit, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers  \n           :    (queryGaps, hitGaps)\n           : Array context can be forced by providing an argument of 'list' or 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed \n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : Not relying on wantarray since that will fail in situations \n           : such as printf \"%d\", $hit->gaps() in which you might expect to \n           : be printing the total gaps, but evaluates to array context.\n\nSee Also   : L<length_aln()|length_aln>\n\n\nsub gaps {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n        #return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    $seqType = lc($seqType);\n\n    if( defined $num ) {\n        $self->throw(\"Can't set gaps for seqType '$seqType'. Must be 'query' or 'hit'\\n\") unless ($seqType eq 'sbjct' or $seqType eq 'query');\n\n        return $self->{'_gaps_'.$seqType} = $num;\n    }\n    elsif($seqType =~ /list|array/i) {\n        return ($self->{'_gaps_query'}, $self->{'_gaps_sbjct'});\n    }\n    elsif($seqType eq 'total') {\n        return ($self->{'_gaps_query'} + $self->{'_gaps_sbjct'}) || 0;\n    } else {\n        return $self->{'_gaps_'.$seqType} || 0;\n    }\n}    \n\n\n=head2 matches\n\nSee documentation in L<Bio::Search::Hit::HitI::matches()|Bio::Search::Hit::HitI>\n\n\nsub matches {\n    my( $self, $arg1, $arg2) = @_;\n    my(@data,$data);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    unless( $arg1 ) {\n        @data = ($self->{'_totalIdentical'}, $self->{'_totalConserved'});\n\n        return @data;\n    } else {\n\n        if( defined $arg2 ) {\n            $self->{'_totalIdentical'} = $arg1;\n            $self->{'_totalConserved'} = $arg2;\n            return ( $arg1, $arg2 );\n        }\n        elsif($arg1 =~ /^id/i) { \n            $data = $self->{'_totalIdentical'};\n        } else {\n            $data = $self->{'_totalConserved'};\n        }\n        #print STDERR \"\\nmatches(): id=$self->{'_totalIdentical'}, cons=$self->{'_totalConserved'}\\n\\n\";\n        return $data;\n    }\n    \n    ## If we make it to here, it is likely the case that\n    ## the parser constructed a minimal hit object from the summary line only.\n    ## It either delibrately skipped parsing the alignment section,\n    ## or was not able to because it was absent (due to blast executable parameter\n    ## setting such as -b 0 (B=0 for WU-BLAST) )\n    #$self->throw(\"Can't get identical or conserved data: no data.\");\n}\n\n\n=head2 start\n\n Usage     : $sbjct->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, the lowest start\n           : value of all HSPs is returned.\n Example   : $qbeg = $sbjct->start('query');\n           : $sbeg = $sbjct->start('hit');\n           : ($qbeg, $sbeg) = $sbjct->start();\n Returns   : scalar context: integer \n           : array context without args: list of two integers (queryStart, sbjctStart)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<end()|end>, L<range()|range>, L<strand()|strand>, \n             L<Bio::Search::HSP::BlastHSP::start|Bio::Search::HSP::BlastHSP>\n\n\nsub start {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Start'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->start($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStart'} and\n        # $self->{'_sbjctStart'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStart'}) {\n            my $earliest_query_start;\n            my $earliest_sbjct_start;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_start = $hsp->start('query');\n                if (! defined $earliest_query_start || $this_query_start < $earliest_query_start) {\n                    $earliest_query_start = $this_query_start;\n                }\n                \n                my $this_sbjct_start = $hsp->start('sbjct');\n                if (! defined $earliest_sbjct_start || $this_sbjct_start < $earliest_sbjct_start) {\n                    $earliest_sbjct_start = $this_sbjct_start;\n                }\n            }\n            $self->{'_queryStart'} = $earliest_query_start;\n            $self->{'_sbjctStart'} = $earliest_sbjct_start;\n        }\n        \n        \n        if ($seqType =~ /list|array/i) {\n            return ($self->{'_queryStart'}, $self->{'_sbjctStart'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Start'};\n        }\n    }\n}\n\n\n=head2 end\n\n Usage     : $sbjct->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, \n             the largest end\n           : value of all HSPs is returned.\n Example   : $qend = $sbjct->end('query');\n           : $send = $sbjct->end('hit');\n           : ($qend, $send) = $sbjct->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers \n           : (queryEnd, sbjctEnd)\n           : Array context can be \"induced\" by providing an argument \n           : of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'sbjct'\n           :  (case insensitive). If not supplied, 'query' is used.\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<range()|range>, L<strand()|strand>\n\n\nsub end {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Stop'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->end($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStop'} and\n        # $self->{'_sbjctStop'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStop'}) {\n            my $latest_query_end;\n            my $latest_sbjct_end;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_end = $hsp->end('query');\n                if (! defined $latest_query_end || $this_query_end > $latest_query_end) {\n                    $latest_query_end = $this_query_end;\n                }\n                \n                my $this_sbjct_end = $hsp->end('sbjct');\n                if (! defined $latest_sbjct_end || $this_sbjct_end > $latest_sbjct_end) {\n                    $latest_sbjct_end = $this_sbjct_end;\n                }\n            }\n            $self->{'_queryStop'} = $latest_query_end;\n            $self->{'_sbjctStop'} = $latest_sbjct_end;\n        }\n        \n        \n        if($seqType =~ /list|array/i) {\n            return ($self->{'_queryStop'}, $self->{'_sbjctStop'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Stop'};\n        }\n    }\n}\n\n=head2 range\n\n Usage     : $sbjct->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($qbeg, $qend) = $sbjct->range('query');\n           : ($sbeg, $send) = $sbjct->range('hit');\n Returns   : Two-element array of integers \n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<end()|end>\n\n\nsub range {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n    return ($self->start($seqType), $self->end($seqType));\n}\n\n\n=head2 frac_identical\n\n Usage     : $hit_object->frac_identical( [seq_type] );\n Purpose   : Get the overall fraction of identical positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_iden = $hit_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : To compute the fraction identical, the logical length of the \n           : aligned portion of the sequence is used, meaning that\n           : in the case of BLAST flavors, for TBLASTN reports, the length of \n           : the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           : This is necessary since the number of identical residues is\n           : in terms of peptide sequence space.\n           :\n           : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or \n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then iterate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_conserved()|frac_conserved>, L<frac_aligned_query()|frac_aligned_query>, L<matches()|matches>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_identical {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = lc($seqType);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $ident = $self->matches('id');\n    my $total = $self->length_aln($seqType);\n    my $ratio = $ident / $total;\n    my $ratio_rounded = sprintf( \"%.3f\", $ratio);\n\n    # Round down iff normal rounding yields 1 (just like blast)\n    $ratio_rounded = 0.999 if (($ratio_rounded == 1) && ($ratio < 1));\n    return $ratio_rounded;\n}\n\n\n=head2 frac_conserved\n\n Usage     : $hit_object->frac_conserved( [seq_type] );\n Purpose   : Get the overall fraction of conserved positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_cons = $hit_object->frac_conserved('hit');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : To compute the fraction conserved, the logical length of the \n           : aligned portion of the sequence is used, meaning that\n           : in the case of BLAST flavors, for TBLASTN reports, the length of \n           : the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           : This is necessary since the number of conserved residues is\n           : in terms of peptide sequence space.\n           :\n           : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Positives = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or \n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_identical()|frac_identical>, L<matches()|matches>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>","label":"frac_conserved($self,$seqType)"},"detail":"($self,$seqType)","definition":"sub","containerName":"main::","children":[{"line":1216,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"frac_conserved"},{"name":"$seqType","containerName":"frac_conserved","line":1216,"kind":13},{"containerName":"frac_conserved","name":"$seqType","line":1217,"kind":13},{"containerName":"frac_conserved","name":"$seqType","kind":13,"line":1218},{"containerName":"frac_conserved","name":"$seqType","line":1218,"kind":13},{"containerName":"frac_conserved","name":"$seqType","line":1221,"kind":13},{"line":1221,"kind":13,"name":"$seqType","containerName":"frac_conserved"},{"name":"$self","containerName":"frac_conserved","line":1223,"kind":13},{"line":1224,"kind":13,"name":"$self","containerName":"frac_conserved"},{"kind":13,"line":1229,"name":"$self","containerName":"frac_conserved"},{"containerName":"frac_conserved","name":"$self","kind":13,"line":1229},{"line":1229,"kind":12,"name":"tiled_hsps","containerName":"frac_conserved"},{"kind":13,"line":1231,"definition":"my","name":"$consv","containerName":"frac_conserved","localvar":"my"},{"kind":13,"line":1231,"name":"$self","containerName":"frac_conserved"},{"kind":12,"line":1231,"name":"matches","containerName":"frac_conserved"},{"line":1232,"kind":13,"localvar":"my","definition":"my","name":"$total","containerName":"frac_conserved"},{"line":1232,"kind":13,"name":"$self","containerName":"frac_conserved"},{"kind":12,"line":1232,"name":"length_aln","containerName":"frac_conserved"},{"line":1232,"kind":13,"containerName":"frac_conserved","name":"$seqType"},{"localvar":"my","name":"$ratio","definition":"my","containerName":"frac_conserved","line":1233,"kind":13},{"name":"$consv","containerName":"frac_conserved","line":1233,"kind":13},{"containerName":"frac_conserved","name":"$total","kind":13,"line":1233},{"kind":13,"line":1234,"name":"$ratio_rounded","definition":"my","containerName":"frac_conserved","localvar":"my"},{"kind":13,"line":1234,"containerName":"frac_conserved","name":"$ratio"},{"line":1237,"kind":13,"name":"$ratio_rounded","containerName":"frac_conserved"},{"containerName":"frac_conserved","name":"$ratio_rounded","kind":13,"line":1237},{"name":"$ratio","containerName":"frac_conserved","kind":13,"line":1237},{"containerName":"frac_conserved","name":"$ratio_rounded","kind":13,"line":1238}],"line":1215,"kind":12,"range":{"start":{"line":1215,"character":0},"end":{"character":9999,"line":1239}},"name":"frac_conserved"},{"name":"Bio","containerName":"Search::SearchUtils::_warn_about_no_hsps","kind":12,"line":1224},{"containerName":"Search::SearchUtils::tile_hsps","name":"Bio","line":1229,"kind":12},{"name":"frac_aligned_query","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":1276},"start":{"character":0,"line":1263}},"kind":12,"children":[{"line":1264,"kind":13,"localvar":"my","containerName":"frac_aligned_query","name":"$self","definition":"my"},{"line":1266,"kind":13,"containerName":"frac_aligned_query","name":"$self"},{"kind":13,"line":1267,"name":"$self","containerName":"frac_aligned_query"},{"name":"$self","containerName":"frac_aligned_query","line":1272,"kind":13},{"name":"$self","containerName":"frac_aligned_query","line":1272,"kind":13},{"kind":12,"line":1272,"name":"tiled_hsps","containerName":"frac_aligned_query"},{"containerName":"frac_aligned_query","name":"$self","line":1274,"kind":13},{"name":"length_aln","containerName":"frac_aligned_query","kind":12,"line":1274},{"containerName":"frac_aligned_query","name":"$self","line":1275,"kind":13},{"line":1275,"kind":12,"name":"logical_length","containerName":"frac_aligned_query"}],"line":1263},{"kind":12,"line":1267,"containerName":"Search::SearchUtils::_warn_about_no_hsps","name":"Bio"},{"containerName":"Search::SearchUtils::tile_hsps","name":"Bio","kind":12,"line":1272},{"containerName":"main::","name":"frac_aligned_hit","definition":"sub","range":{"end":{"line":1311,"character":9999},"start":{"line":1299,"character":0}},"kind":12,"line":1299,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"frac_aligned_hit","line":1300,"kind":13},{"kind":13,"line":1302,"containerName":"frac_aligned_hit","name":"$self"},{"name":"$self","containerName":"frac_aligned_hit","line":1303,"kind":13},{"kind":13,"line":1308,"name":"$self","containerName":"frac_aligned_hit"},{"line":1308,"kind":13,"containerName":"frac_aligned_hit","name":"$self"},{"line":1308,"kind":12,"containerName":"frac_aligned_hit","name":"tiled_hsps"},{"kind":13,"line":1310,"containerName":"frac_aligned_hit","name":"$self"},{"name":"length_aln","containerName":"frac_aligned_hit","kind":12,"line":1310},{"name":"$self","containerName":"frac_aligned_hit","kind":13,"line":1310},{"line":1310,"kind":12,"name":"logical_length","containerName":"frac_aligned_hit"}]},{"kind":12,"line":1303,"containerName":"Search::SearchUtils::_warn_about_no_hsps","name":"Bio"},{"name":"Bio","containerName":"Search::SearchUtils::tile_hsps","kind":12,"line":1308},{"name":"num_unaligned_hit","kind":12,"line":1330},{"range":{"start":{"character":0,"line":1353},"end":{"line":1366,"character":9999}},"containerName":"main::","definition":"sub","name":"num_unaligned_hit","line":1353,"children":[{"name":"$self","definition":"my","containerName":"num_unaligned_hit","localvar":"my","kind":13,"line":1354},{"line":1356,"kind":13,"name":"$self","containerName":"num_unaligned_hit"},{"containerName":"num_unaligned_hit","name":"$self","line":1357,"kind":13},{"name":"$self","containerName":"num_unaligned_hit","line":1362,"kind":13},{"kind":13,"line":1362,"containerName":"num_unaligned_hit","name":"$self"},{"containerName":"num_unaligned_hit","name":"tiled_hsps","line":1362,"kind":12},{"line":1364,"kind":13,"localvar":"my","definition":"my","name":"$num","containerName":"num_unaligned_hit"},{"kind":13,"line":1364,"name":"$self","containerName":"num_unaligned_hit"},{"kind":12,"line":1364,"name":"logical_length","containerName":"num_unaligned_hit"},{"containerName":"num_unaligned_hit","name":"$self","line":1364,"kind":13},{"name":"length_aln","containerName":"num_unaligned_hit","kind":12,"line":1364},{"kind":13,"line":1365,"containerName":"num_unaligned_hit","name":"$num"},{"name":"$num","containerName":"num_unaligned_hit","line":1365,"kind":13}],"kind":12},{"containerName":"Search::SearchUtils::_warn_about_no_hsps","name":"Bio","line":1357,"kind":12},{"name":"Bio","containerName":"Search::SearchUtils::tile_hsps","line":1362,"kind":12},{"range":{"start":{"character":0,"line":1389},"end":{"line":1402,"character":9999}},"name":"num_unaligned_query","definition":"sub","containerName":"main::","children":[{"containerName":"num_unaligned_query","name":"$self","definition":"my","localvar":"my","kind":13,"line":1390},{"line":1392,"kind":13,"containerName":"num_unaligned_query","name":"$self"},{"line":1393,"kind":13,"containerName":"num_unaligned_query","name":"$self"},{"line":1398,"kind":13,"containerName":"num_unaligned_query","name":"$self"},{"containerName":"num_unaligned_query","name":"$self","line":1398,"kind":13},{"name":"tiled_hsps","containerName":"num_unaligned_query","line":1398,"kind":12},{"containerName":"num_unaligned_query","name":"$num","definition":"my","localvar":"my","kind":13,"line":1400},{"kind":13,"line":1400,"name":"$self","containerName":"num_unaligned_query"},{"name":"logical_length","containerName":"num_unaligned_query","line":1400,"kind":12},{"line":1400,"kind":13,"containerName":"num_unaligned_query","name":"$self"},{"name":"length_aln","containerName":"num_unaligned_query","line":1400,"kind":12},{"name":"$num","containerName":"num_unaligned_query","line":1401,"kind":13},{"name":"$num","containerName":"num_unaligned_query","line":1401,"kind":13}],"line":1389,"kind":12},{"line":1393,"kind":12,"containerName":"Search::SearchUtils::_warn_about_no_hsps","name":"Bio"},{"line":1398,"kind":12,"containerName":"Search::SearchUtils::tile_hsps","name":"Bio"},{"detail":"($self,$seqType,$class,$collapse)","signature":{"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\nsub significance {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_significance'};\n    if( defined $value ) { \n        $self->{'_significance'} = $value;\n    } elsif ( ! defined $previous ) {\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this Hit (\".$self->name.\")\");\n\t    return;\n\t}\n        # Set the significance of the Hit to that of the top HSP.\n        $previous = $self->{'_significance'} = ($self->hsps)[0]->significance;\n    }\n\n    return $previous;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_bits'};\n    if( defined $value ) { \n        $self->{'_bits'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using WU-BLAST, check raw_score() instead\");\n\t    return;\n\t}\n        $previous = $self->{'_bits'} = ($self->hsps)[0]->bits;\n    }    \n    return $previous;\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    $self->{'_iterator'} = 0 unless defined $self->{'_iterator'};\n    return unless\n        defined($self->{'_hsps'}) \n        && $self->{'_iterator'} <= scalar @{$self->{'_hsps'}};\n    \n    my $iterator = $self->{'_iterator'}++;\n    my $hsp = $self->{'_hsps'}->[$iterator] || return;\n    if (ref($hsp) eq 'HASH') {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $hsp = $factory->create_object(%{$hsp});\n        $self->{'_hsps'}->[$iterator] = $hsp;\n        delete $self->{_hashes}->{$iterator};\n    }\n    return $hsp;  \n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    my $self = shift;\n    foreach my $i (keys %{$self->{_hashes} || {}}) {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $self->{'_hsps'}->[$i] = $factory->create_object(%{$self->{'_hsps'}->[$i]});\n        delete $self->{_hashes}->{$i};\n    }\n    \n    return wantarray() ? @{$self->{'_hsps'} || []} : scalar(@{$self->{'_hsps'} || []});\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    my $self = shift;\n    \n    unless ($self->{'_hsps'}) {\n        return '-';\n    }\n    \n    return scalar(@{$self->{'_hsps'}});\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_iterator'} = 0;\n}\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences \n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences \n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains \n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Comment   : Note: \"sbjct\" is synonymous with \"hit\"\n\n\nsub ambiguous_aln {\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n=head2 overlap\n\nSee documentation in L<Bio::Search::Hit::HitI::overlap()|Bio::Search::Hit::HitI>\n\n\nsub overlap {\n    my $self = shift; \n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    my $self = shift; \n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description \n    # line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n\tif( $self->hsp ) {\n\t    $n = $self->hsp->n;\n\t}\n    } else {\n        $n = $self->{'_n'}; \n    } \n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<significance()|significance>, L<Bio::Search::SearchUtils::get_exponent()|Bio::Search::SearchUtils>\n\n\nsub p {\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(!defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using significance() instead.\");\n        $val = $self->significance();\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::SearchUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n    \n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = $self->hsps;\n    \n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : This is necessary since the number of identical/conserved residues \n           : can be in terms of peptide sequence space, yet the query and/or hit\n           : sequence are in nucleotide space.\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : In the case of BLAST flavors:\n           : For TBLASTN reports, the length of the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           :\n           : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub logical_length {\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my ($length, $logical);\n    my $algo = $self->algorithm;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->length;\n    } else {\n        # Otherwise, return logical query length\n        $length = $self->query_length();\n        $self->throw(\"Must have defined query_len\") unless ( $length );\n    }\n\n    $logical = Bio::Search::SearchUtils::logical_length($algo, $seqType, $length);\n\n    return int($logical);\n}\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer \n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           : \n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\nsub length_aln {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    # Setter:\n    if( defined $num) {\n        return $self->{'_length_aln_'.$seqType} = $num;\n    }\n\n    unless ($self->{'_hsps'}) {\n        #return wantarray ? ('-','-') : '-';\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $data = $self->{'_length_aln_'.$seqType};\n    \n    ## If we don't have data, figure out what went wrong.\n    if(!$data) {\n        $self->throw(\"Can't get length aln for sequence type \\\"$seqType\\\". \" . \n                     \"Valid types are 'query', 'hit', 'sbjct' ('sbjct' = 'hit')\");\n    }                \n    return $data;\n}    \n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, hit, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers  \n           :    (queryGaps, hitGaps)\n           : Array context can be forced by providing an argument of 'list' or 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed \n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : Not relying on wantarray since that will fail in situations \n           : such as printf \"%d\", $hit->gaps() in which you might expect to \n           : be printing the total gaps, but evaluates to array context.\n\nSee Also   : L<length_aln()|length_aln>\n\n\nsub gaps {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n        #return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    $seqType = lc($seqType);\n\n    if( defined $num ) {\n        $self->throw(\"Can't set gaps for seqType '$seqType'. Must be 'query' or 'hit'\\n\") unless ($seqType eq 'sbjct' or $seqType eq 'query');\n\n        return $self->{'_gaps_'.$seqType} = $num;\n    }\n    elsif($seqType =~ /list|array/i) {\n        return ($self->{'_gaps_query'}, $self->{'_gaps_sbjct'});\n    }\n    elsif($seqType eq 'total') {\n        return ($self->{'_gaps_query'} + $self->{'_gaps_sbjct'}) || 0;\n    } else {\n        return $self->{'_gaps_'.$seqType} || 0;\n    }\n}    \n\n\n=head2 matches\n\nSee documentation in L<Bio::Search::Hit::HitI::matches()|Bio::Search::Hit::HitI>\n\n\nsub matches {\n    my( $self, $arg1, $arg2) = @_;\n    my(@data,$data);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    unless( $arg1 ) {\n        @data = ($self->{'_totalIdentical'}, $self->{'_totalConserved'});\n\n        return @data;\n    } else {\n\n        if( defined $arg2 ) {\n            $self->{'_totalIdentical'} = $arg1;\n            $self->{'_totalConserved'} = $arg2;\n            return ( $arg1, $arg2 );\n        }\n        elsif($arg1 =~ /^id/i) { \n            $data = $self->{'_totalIdentical'};\n        } else {\n            $data = $self->{'_totalConserved'};\n        }\n        #print STDERR \"\\nmatches(): id=$self->{'_totalIdentical'}, cons=$self->{'_totalConserved'}\\n\\n\";\n        return $data;\n    }\n    \n    ## If we make it to here, it is likely the case that\n    ## the parser constructed a minimal hit object from the summary line only.\n    ## It either delibrately skipped parsing the alignment section,\n    ## or was not able to because it was absent (due to blast executable parameter\n    ## setting such as -b 0 (B=0 for WU-BLAST) )\n    #$self->throw(\"Can't get identical or conserved data: no data.\");\n}\n\n\n=head2 start\n\n Usage     : $sbjct->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, the lowest start\n           : value of all HSPs is returned.\n Example   : $qbeg = $sbjct->start('query');\n           : $sbeg = $sbjct->start('hit');\n           : ($qbeg, $sbeg) = $sbjct->start();\n Returns   : scalar context: integer \n           : array context without args: list of two integers (queryStart, sbjctStart)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<end()|end>, L<range()|range>, L<strand()|strand>, \n             L<Bio::Search::HSP::BlastHSP::start|Bio::Search::HSP::BlastHSP>\n\n\nsub start {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Start'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->start($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStart'} and\n        # $self->{'_sbjctStart'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStart'}) {\n            my $earliest_query_start;\n            my $earliest_sbjct_start;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_start = $hsp->start('query');\n                if (! defined $earliest_query_start || $this_query_start < $earliest_query_start) {\n                    $earliest_query_start = $this_query_start;\n                }\n                \n                my $this_sbjct_start = $hsp->start('sbjct');\n                if (! defined $earliest_sbjct_start || $this_sbjct_start < $earliest_sbjct_start) {\n                    $earliest_sbjct_start = $this_sbjct_start;\n                }\n            }\n            $self->{'_queryStart'} = $earliest_query_start;\n            $self->{'_sbjctStart'} = $earliest_sbjct_start;\n        }\n        \n        \n        if ($seqType =~ /list|array/i) {\n            return ($self->{'_queryStart'}, $self->{'_sbjctStart'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Start'};\n        }\n    }\n}\n\n\n=head2 end\n\n Usage     : $sbjct->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, \n             the largest end\n           : value of all HSPs is returned.\n Example   : $qend = $sbjct->end('query');\n           : $send = $sbjct->end('hit');\n           : ($qend, $send) = $sbjct->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers \n           : (queryEnd, sbjctEnd)\n           : Array context can be \"induced\" by providing an argument \n           : of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'sbjct'\n           :  (case insensitive). If not supplied, 'query' is used.\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<range()|range>, L<strand()|strand>\n\n\nsub end {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Stop'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->end($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStop'} and\n        # $self->{'_sbjctStop'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStop'}) {\n            my $latest_query_end;\n            my $latest_sbjct_end;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_end = $hsp->end('query');\n                if (! defined $latest_query_end || $this_query_end > $latest_query_end) {\n                    $latest_query_end = $this_query_end;\n                }\n                \n                my $this_sbjct_end = $hsp->end('sbjct');\n                if (! defined $latest_sbjct_end || $this_sbjct_end > $latest_sbjct_end) {\n                    $latest_sbjct_end = $this_sbjct_end;\n                }\n            }\n            $self->{'_queryStop'} = $latest_query_end;\n            $self->{'_sbjctStop'} = $latest_sbjct_end;\n        }\n        \n        \n        if($seqType =~ /list|array/i) {\n            return ($self->{'_queryStop'}, $self->{'_sbjctStop'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Stop'};\n        }\n    }\n}\n\n=head2 range\n\n Usage     : $sbjct->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($qbeg, $qend) = $sbjct->range('query');\n           : ($sbeg, $send) = $sbjct->range('hit');\n Returns   : Two-element array of integers \n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<end()|end>\n\n\nsub range {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n    return ($self->start($seqType), $self->end($seqType));\n}\n\n\n=head2 frac_identical\n\n Usage     : $hit_object->frac_identical( [seq_type] );\n Purpose   : Get the overall fraction of identical positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_iden = $hit_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : To compute the fraction identical, the logical length of the \n           : aligned portion of the sequence is used, meaning that\n           : in the case of BLAST flavors, for TBLASTN reports, the length of \n           : the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           : This is necessary since the number of identical residues is\n           : in terms of peptide sequence space.\n           :\n           : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or \n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then iterate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_conserved()|frac_conserved>, L<frac_aligned_query()|frac_aligned_query>, L<matches()|matches>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_identical {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = lc($seqType);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $ident = $self->matches('id');\n    my $total = $self->length_aln($seqType);\n    my $ratio = $ident / $total;\n    my $ratio_rounded = sprintf( \"%.3f\", $ratio);\n\n    # Round down iff normal rounding yields 1 (just like blast)\n    $ratio_rounded = 0.999 if (($ratio_rounded == 1) && ($ratio < 1));\n    return $ratio_rounded;\n}\n\n\n=head2 frac_conserved\n\n Usage     : $hit_object->frac_conserved( [seq_type] );\n Purpose   : Get the overall fraction of conserved positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_cons = $hit_object->frac_conserved('hit');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : To compute the fraction conserved, the logical length of the \n           : aligned portion of the sequence is used, meaning that\n           : in the case of BLAST flavors, for TBLASTN reports, the length of \n           : the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           : This is necessary since the number of conserved residues is\n           : in terms of peptide sequence space.\n           :\n           : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Positives = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or \n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_identical()|frac_identical>, L<matches()|matches>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_conserved {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = lc($seqType);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $consv = $self->matches('cons');\n    my $total = $self->length_aln($seqType);\n    my $ratio = $consv / $total;\n    my $ratio_rounded = sprintf( \"%.3f\", $ratio);\n\n    # Round down iff normal rounding yields 1 (just like blast)\n    $ratio_rounded = 0.999 if (($ratio_rounded == 1) && ($ratio < 1));\n    return $ratio_rounded;\n}\n\n\n\n\n=head2 frac_aligned_query\n\n Usage     : $hit_object->frac_aligned_query();\n Purpose   : Get the fraction of the query sequence which has been aligned\n           : across all HSPs (not including intervals between non-overlapping\n           : HSPs).\n Example   : $frac_alnq = $hit_object->frac_aligned_query();\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : n/a\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_aligned_hit()|frac_aligned_hit>, L<logical_length()|logical_length>, L<length_aln()|length_aln>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_aligned_query {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    sprintf( \"%.2f\", $self->length_aln('query') /\n             $self->logical_length('query'));\n}\n\n\n\n=head2 frac_aligned_hit\n\n Usage     : $hit_object->frac_aligned_hit();\n Purpose   : Get the fraction of the hit (sbjct) sequence which has been aligned\n           : across all HSPs (not including intervals between non-overlapping\n           : HSPs).\n Example   : $frac_alnq = $hit_object->frac_aligned_hit();\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : n/a\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_aligned_query()|frac_aligned_query>, L<matches()|matches>, , L<logical_length()|logical_length>, L<length_aln()|length_aln>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_aligned_hit {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    sprintf( \"%.2f\", $self->length_aln('sbjct') / $self->logical_length('sbjct'));\n}\n\n\n## These methods are being maintained for backward compatibility. \n\n=head2 frac_aligned_sbjct\n\nSame as L<frac_aligned_hit()|frac_aligned_hit>\n\n\n*frac_aligned_sbjct = \\&frac_aligned_hit;\n\n=head2 num_unaligned_sbjct\n\nSame as L<num_unaligned_hit()|num_unaligned_hit>\n\n\n*num_unaligned_sbjct = \\&num_unaligned_hit;\n\n\n=head2 num_unaligned_hit\n\n Usage     : $hit_object->num_unaligned_hit();\n Purpose   : Get the number of the unaligned residues in the hit sequence.\n           : Sums across all all HSPs.\n Example   : $num_unaln = $hit_object->num_unaligned_hit();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : See notes regarding logical lengths in the comments for frac_aligned_hit().\n           : They apply here as well.\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n\nSee Also   : L<num_unaligned_query()|num_unaligned_query>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub num_unaligned_hit {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $num = $self->logical_length('sbjct') - $self->length_aln('sbjct');\n    ($num < 0 ? 0 : $num );\n}\n\n\n=head2 num_unaligned_query\n\n Usage     : $hit_object->num_unaligned_query();\n Purpose   : Get the number of the unaligned residues in the query sequence.\n           : Sums across all all HSPs.\n Example   : $num_unaln = $hit_object->num_unaligned_query();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : See notes regarding logical lengths in the comments for frac_aligned_query().\n           : They apply here as well.\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n\nSee Also   : L<num_unaligned_hit()|num_unaligned_hit>, L<frac_aligned_query()|frac_aligned_query>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub num_unaligned_query {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $num = $self->logical_length('query') - $self->length_aln('query');\n    ($num < 0 ? 0 : $num );\n}\n\n\n\n=head2 seq_inds\n\n Usage     : $hit->seq_inds( seq_type, class, collapse );\n Purpose   : Get a list of residue positions (indices) across all HSPs\n           : for identical or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hit->seq_inds('query', 'identical');\n           : @h_ind = $hit->seq_inds('hit', 'conserved');\n           : @h_ind = $hit->seq_inds('hit', 'conserved', 1);\n Returns   : Array of integers \n           : May include ranges if collapse is non-zero.\n Argument  : [0] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : [1] class     = 'identical' or 'conserved' (default = 'identical')\n           :              (can be shortened to 'id' or 'cons')\n           :              (actually, anything not 'id' will evaluate to 'conserved').\n           : [2] collapse  = boolean, if non-zero, consecutive positions are merged\n           :             using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\" \n           :             collapses to \"1-5 7 9-11\". This is useful for \n           :             consolidating long lists. Default = no collapse.\n Throws    : n/a.\n\nSee Also   : L<Bio::Search::HSP::BlastHSP::seq_inds()|Bio::Search::HSP::BlastHSP>","parameters":[{"label":"$self"},{"label":"$seqType"},{"label":"$class"},{"label":"$collapse"}],"label":"seq_inds($self,$seqType,$class,$collapse)"},"containerName":"main::","definition":"sub","line":1431,"children":[{"kind":13,"line":1432,"containerName":"seq_inds","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":1432,"name":"$seqType","containerName":"seq_inds"},{"line":1432,"kind":13,"name":"$class","containerName":"seq_inds"},{"line":1432,"kind":13,"containerName":"seq_inds","name":"$collapse"},{"line":1434,"kind":13,"name":"$seqType","containerName":"seq_inds"},{"containerName":"seq_inds","name":"$class","line":1435,"kind":13},{"kind":13,"line":1436,"name":"$collapse","containerName":"seq_inds"},{"name":"$seqType","containerName":"seq_inds","line":1438,"kind":13},{"containerName":"seq_inds","name":"$seqType","kind":13,"line":1438},{"line":1440,"kind":13,"localvar":"my","name":"@inds","definition":"my","containerName":"seq_inds"},{"kind":13,"line":1440,"containerName":"seq_inds","name":"$hsp"},{"containerName":"seq_inds","name":"$hsp","line":1441,"kind":13},{"kind":13,"line":1441,"containerName":"seq_inds","name":"$self"},{"containerName":"seq_inds","name":"hsps","kind":12,"line":1441},{"line":1443,"kind":13,"containerName":"seq_inds","name":"@inds"},{"line":1443,"kind":13,"containerName":"seq_inds","name":"$hsp"},{"kind":12,"line":1443,"name":"seq_inds","containerName":"seq_inds"},{"containerName":"seq_inds","name":"$seqType","kind":13,"line":1443},{"kind":13,"line":1443,"containerName":"seq_inds","name":"$class"},{"line":1447,"kind":13,"name":"@inds","containerName":"seq_inds"},{"localvar":"my","containerName":"seq_inds","definition":"my","name":"%tmp","line":1448,"kind":13},{"containerName":"seq_inds","name":"@inds","kind":13,"line":1448},{"kind":13,"line":1449,"containerName":"seq_inds","name":"@inds"},{"line":1449,"kind":13,"containerName":"seq_inds","name":"$a"},{"kind":13,"line":1449,"containerName":"seq_inds","name":"$b"},{"line":1449,"kind":13,"containerName":"seq_inds","name":"%tmp"},{"containerName":"seq_inds","name":"$collapse","kind":13,"line":1452},{"containerName":"seq_inds","name":"@inds","line":1452,"kind":13},{"line":1452,"kind":13,"containerName":"seq_inds","name":"@inds"}],"kind":12,"range":{"start":{"line":1431,"character":0},"end":{"line":1453,"character":9999}},"name":"seq_inds"},{"kind":12,"line":1452,"name":"Bio","containerName":"Search::SearchUtils::collapse_nums"},{"range":{"end":{"character":9999,"line":1516},"start":{"line":1462,"character":0}},"name":"strand","detail":"($self,$seqType,$strnd)","signature":{"parameters":[{"label":"$self"},{"label":"$seqType"},{"label":"$strnd"}],"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\nsub significance {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_significance'};\n    if( defined $value ) { \n        $self->{'_significance'} = $value;\n    } elsif ( ! defined $previous ) {\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this Hit (\".$self->name.\")\");\n\t    return;\n\t}\n        # Set the significance of the Hit to that of the top HSP.\n        $previous = $self->{'_significance'} = ($self->hsps)[0]->significance;\n    }\n\n    return $previous;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_bits'};\n    if( defined $value ) { \n        $self->{'_bits'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using WU-BLAST, check raw_score() instead\");\n\t    return;\n\t}\n        $previous = $self->{'_bits'} = ($self->hsps)[0]->bits;\n    }    \n    return $previous;\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    $self->{'_iterator'} = 0 unless defined $self->{'_iterator'};\n    return unless\n        defined($self->{'_hsps'}) \n        && $self->{'_iterator'} <= scalar @{$self->{'_hsps'}};\n    \n    my $iterator = $self->{'_iterator'}++;\n    my $hsp = $self->{'_hsps'}->[$iterator] || return;\n    if (ref($hsp) eq 'HASH') {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $hsp = $factory->create_object(%{$hsp});\n        $self->{'_hsps'}->[$iterator] = $hsp;\n        delete $self->{_hashes}->{$iterator};\n    }\n    return $hsp;  \n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    my $self = shift;\n    foreach my $i (keys %{$self->{_hashes} || {}}) {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $self->{'_hsps'}->[$i] = $factory->create_object(%{$self->{'_hsps'}->[$i]});\n        delete $self->{_hashes}->{$i};\n    }\n    \n    return wantarray() ? @{$self->{'_hsps'} || []} : scalar(@{$self->{'_hsps'} || []});\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    my $self = shift;\n    \n    unless ($self->{'_hsps'}) {\n        return '-';\n    }\n    \n    return scalar(@{$self->{'_hsps'}});\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_iterator'} = 0;\n}\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences \n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences \n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains \n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Comment   : Note: \"sbjct\" is synonymous with \"hit\"\n\n\nsub ambiguous_aln {\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n=head2 overlap\n\nSee documentation in L<Bio::Search::Hit::HitI::overlap()|Bio::Search::Hit::HitI>\n\n\nsub overlap {\n    my $self = shift; \n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    my $self = shift; \n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description \n    # line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n\tif( $self->hsp ) {\n\t    $n = $self->hsp->n;\n\t}\n    } else {\n        $n = $self->{'_n'}; \n    } \n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<significance()|significance>, L<Bio::Search::SearchUtils::get_exponent()|Bio::Search::SearchUtils>\n\n\nsub p {\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(!defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using significance() instead.\");\n        $val = $self->significance();\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::SearchUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n    \n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = $self->hsps;\n    \n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : This is necessary since the number of identical/conserved residues \n           : can be in terms of peptide sequence space, yet the query and/or hit\n           : sequence are in nucleotide space.\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : In the case of BLAST flavors:\n           : For TBLASTN reports, the length of the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           :\n           : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub logical_length {\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my ($length, $logical);\n    my $algo = $self->algorithm;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->length;\n    } else {\n        # Otherwise, return logical query length\n        $length = $self->query_length();\n        $self->throw(\"Must have defined query_len\") unless ( $length );\n    }\n\n    $logical = Bio::Search::SearchUtils::logical_length($algo, $seqType, $length);\n\n    return int($logical);\n}\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer \n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           : \n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\nsub length_aln {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    # Setter:\n    if( defined $num) {\n        return $self->{'_length_aln_'.$seqType} = $num;\n    }\n\n    unless ($self->{'_hsps'}) {\n        #return wantarray ? ('-','-') : '-';\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $data = $self->{'_length_aln_'.$seqType};\n    \n    ## If we don't have data, figure out what went wrong.\n    if(!$data) {\n        $self->throw(\"Can't get length aln for sequence type \\\"$seqType\\\". \" . \n                     \"Valid types are 'query', 'hit', 'sbjct' ('sbjct' = 'hit')\");\n    }                \n    return $data;\n}    \n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, hit, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers  \n           :    (queryGaps, hitGaps)\n           : Array context can be forced by providing an argument of 'list' or 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed \n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : Not relying on wantarray since that will fail in situations \n           : such as printf \"%d\", $hit->gaps() in which you might expect to \n           : be printing the total gaps, but evaluates to array context.\n\nSee Also   : L<length_aln()|length_aln>\n\n\nsub gaps {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n        #return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    $seqType = lc($seqType);\n\n    if( defined $num ) {\n        $self->throw(\"Can't set gaps for seqType '$seqType'. Must be 'query' or 'hit'\\n\") unless ($seqType eq 'sbjct' or $seqType eq 'query');\n\n        return $self->{'_gaps_'.$seqType} = $num;\n    }\n    elsif($seqType =~ /list|array/i) {\n        return ($self->{'_gaps_query'}, $self->{'_gaps_sbjct'});\n    }\n    elsif($seqType eq 'total') {\n        return ($self->{'_gaps_query'} + $self->{'_gaps_sbjct'}) || 0;\n    } else {\n        return $self->{'_gaps_'.$seqType} || 0;\n    }\n}    \n\n\n=head2 matches\n\nSee documentation in L<Bio::Search::Hit::HitI::matches()|Bio::Search::Hit::HitI>\n\n\nsub matches {\n    my( $self, $arg1, $arg2) = @_;\n    my(@data,$data);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    unless( $arg1 ) {\n        @data = ($self->{'_totalIdentical'}, $self->{'_totalConserved'});\n\n        return @data;\n    } else {\n\n        if( defined $arg2 ) {\n            $self->{'_totalIdentical'} = $arg1;\n            $self->{'_totalConserved'} = $arg2;\n            return ( $arg1, $arg2 );\n        }\n        elsif($arg1 =~ /^id/i) { \n            $data = $self->{'_totalIdentical'};\n        } else {\n            $data = $self->{'_totalConserved'};\n        }\n        #print STDERR \"\\nmatches(): id=$self->{'_totalIdentical'}, cons=$self->{'_totalConserved'}\\n\\n\";\n        return $data;\n    }\n    \n    ## If we make it to here, it is likely the case that\n    ## the parser constructed a minimal hit object from the summary line only.\n    ## It either delibrately skipped parsing the alignment section,\n    ## or was not able to because it was absent (due to blast executable parameter\n    ## setting such as -b 0 (B=0 for WU-BLAST) )\n    #$self->throw(\"Can't get identical or conserved data: no data.\");\n}\n\n\n=head2 start\n\n Usage     : $sbjct->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, the lowest start\n           : value of all HSPs is returned.\n Example   : $qbeg = $sbjct->start('query');\n           : $sbeg = $sbjct->start('hit');\n           : ($qbeg, $sbeg) = $sbjct->start();\n Returns   : scalar context: integer \n           : array context without args: list of two integers (queryStart, sbjctStart)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<end()|end>, L<range()|range>, L<strand()|strand>, \n             L<Bio::Search::HSP::BlastHSP::start|Bio::Search::HSP::BlastHSP>\n\n\nsub start {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Start'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->start($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStart'} and\n        # $self->{'_sbjctStart'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStart'}) {\n            my $earliest_query_start;\n            my $earliest_sbjct_start;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_start = $hsp->start('query');\n                if (! defined $earliest_query_start || $this_query_start < $earliest_query_start) {\n                    $earliest_query_start = $this_query_start;\n                }\n                \n                my $this_sbjct_start = $hsp->start('sbjct');\n                if (! defined $earliest_sbjct_start || $this_sbjct_start < $earliest_sbjct_start) {\n                    $earliest_sbjct_start = $this_sbjct_start;\n                }\n            }\n            $self->{'_queryStart'} = $earliest_query_start;\n            $self->{'_sbjctStart'} = $earliest_sbjct_start;\n        }\n        \n        \n        if ($seqType =~ /list|array/i) {\n            return ($self->{'_queryStart'}, $self->{'_sbjctStart'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Start'};\n        }\n    }\n}\n\n\n=head2 end\n\n Usage     : $sbjct->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, \n             the largest end\n           : value of all HSPs is returned.\n Example   : $qend = $sbjct->end('query');\n           : $send = $sbjct->end('hit');\n           : ($qend, $send) = $sbjct->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers \n           : (queryEnd, sbjctEnd)\n           : Array context can be \"induced\" by providing an argument \n           : of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'sbjct'\n           :  (case insensitive). If not supplied, 'query' is used.\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<range()|range>, L<strand()|strand>\n\n\nsub end {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Stop'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->end($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStop'} and\n        # $self->{'_sbjctStop'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStop'}) {\n            my $latest_query_end;\n            my $latest_sbjct_end;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_end = $hsp->end('query');\n                if (! defined $latest_query_end || $this_query_end > $latest_query_end) {\n                    $latest_query_end = $this_query_end;\n                }\n                \n                my $this_sbjct_end = $hsp->end('sbjct');\n                if (! defined $latest_sbjct_end || $this_sbjct_end > $latest_sbjct_end) {\n                    $latest_sbjct_end = $this_sbjct_end;\n                }\n            }\n            $self->{'_queryStop'} = $latest_query_end;\n            $self->{'_sbjctStop'} = $latest_sbjct_end;\n        }\n        \n        \n        if($seqType =~ /list|array/i) {\n            return ($self->{'_queryStop'}, $self->{'_sbjctStop'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Stop'};\n        }\n    }\n}\n\n=head2 range\n\n Usage     : $sbjct->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($qbeg, $qend) = $sbjct->range('query');\n           : ($sbeg, $send) = $sbjct->range('hit');\n Returns   : Two-element array of integers \n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<end()|end>\n\n\nsub range {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n    return ($self->start($seqType), $self->end($seqType));\n}\n\n\n=head2 frac_identical\n\n Usage     : $hit_object->frac_identical( [seq_type] );\n Purpose   : Get the overall fraction of identical positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_iden = $hit_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : To compute the fraction identical, the logical length of the \n           : aligned portion of the sequence is used, meaning that\n           : in the case of BLAST flavors, for TBLASTN reports, the length of \n           : the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           : This is necessary since the number of identical residues is\n           : in terms of peptide sequence space.\n           :\n           : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or \n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then iterate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_conserved()|frac_conserved>, L<frac_aligned_query()|frac_aligned_query>, L<matches()|matches>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_identical {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = lc($seqType);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $ident = $self->matches('id');\n    my $total = $self->length_aln($seqType);\n    my $ratio = $ident / $total;\n    my $ratio_rounded = sprintf( \"%.3f\", $ratio);\n\n    # Round down iff normal rounding yields 1 (just like blast)\n    $ratio_rounded = 0.999 if (($ratio_rounded == 1) && ($ratio < 1));\n    return $ratio_rounded;\n}\n\n\n=head2 frac_conserved\n\n Usage     : $hit_object->frac_conserved( [seq_type] );\n Purpose   : Get the overall fraction of conserved positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_cons = $hit_object->frac_conserved('hit');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : To compute the fraction conserved, the logical length of the \n           : aligned portion of the sequence is used, meaning that\n           : in the case of BLAST flavors, for TBLASTN reports, the length of \n           : the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           : This is necessary since the number of conserved residues is\n           : in terms of peptide sequence space.\n           :\n           : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Positives = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or \n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_identical()|frac_identical>, L<matches()|matches>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_conserved {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = lc($seqType);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $consv = $self->matches('cons');\n    my $total = $self->length_aln($seqType);\n    my $ratio = $consv / $total;\n    my $ratio_rounded = sprintf( \"%.3f\", $ratio);\n\n    # Round down iff normal rounding yields 1 (just like blast)\n    $ratio_rounded = 0.999 if (($ratio_rounded == 1) && ($ratio < 1));\n    return $ratio_rounded;\n}\n\n\n\n\n=head2 frac_aligned_query\n\n Usage     : $hit_object->frac_aligned_query();\n Purpose   : Get the fraction of the query sequence which has been aligned\n           : across all HSPs (not including intervals between non-overlapping\n           : HSPs).\n Example   : $frac_alnq = $hit_object->frac_aligned_query();\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : n/a\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_aligned_hit()|frac_aligned_hit>, L<logical_length()|logical_length>, L<length_aln()|length_aln>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_aligned_query {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    sprintf( \"%.2f\", $self->length_aln('query') /\n             $self->logical_length('query'));\n}\n\n\n\n=head2 frac_aligned_hit\n\n Usage     : $hit_object->frac_aligned_hit();\n Purpose   : Get the fraction of the hit (sbjct) sequence which has been aligned\n           : across all HSPs (not including intervals between non-overlapping\n           : HSPs).\n Example   : $frac_alnq = $hit_object->frac_aligned_hit();\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : n/a\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_aligned_query()|frac_aligned_query>, L<matches()|matches>, , L<logical_length()|logical_length>, L<length_aln()|length_aln>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_aligned_hit {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    sprintf( \"%.2f\", $self->length_aln('sbjct') / $self->logical_length('sbjct'));\n}\n\n\n## These methods are being maintained for backward compatibility. \n\n=head2 frac_aligned_sbjct\n\nSame as L<frac_aligned_hit()|frac_aligned_hit>\n\n\n*frac_aligned_sbjct = \\&frac_aligned_hit;\n\n=head2 num_unaligned_sbjct\n\nSame as L<num_unaligned_hit()|num_unaligned_hit>\n\n\n*num_unaligned_sbjct = \\&num_unaligned_hit;\n\n\n=head2 num_unaligned_hit\n\n Usage     : $hit_object->num_unaligned_hit();\n Purpose   : Get the number of the unaligned residues in the hit sequence.\n           : Sums across all all HSPs.\n Example   : $num_unaln = $hit_object->num_unaligned_hit();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : See notes regarding logical lengths in the comments for frac_aligned_hit().\n           : They apply here as well.\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n\nSee Also   : L<num_unaligned_query()|num_unaligned_query>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub num_unaligned_hit {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $num = $self->logical_length('sbjct') - $self->length_aln('sbjct');\n    ($num < 0 ? 0 : $num );\n}\n\n\n=head2 num_unaligned_query\n\n Usage     : $hit_object->num_unaligned_query();\n Purpose   : Get the number of the unaligned residues in the query sequence.\n           : Sums across all all HSPs.\n Example   : $num_unaln = $hit_object->num_unaligned_query();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : See notes regarding logical lengths in the comments for frac_aligned_query().\n           : They apply here as well.\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n\nSee Also   : L<num_unaligned_hit()|num_unaligned_hit>, L<frac_aligned_query()|frac_aligned_query>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub num_unaligned_query {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $num = $self->logical_length('query') - $self->length_aln('query');\n    ($num < 0 ? 0 : $num );\n}\n\n\n\n=head2 seq_inds\n\n Usage     : $hit->seq_inds( seq_type, class, collapse );\n Purpose   : Get a list of residue positions (indices) across all HSPs\n           : for identical or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hit->seq_inds('query', 'identical');\n           : @h_ind = $hit->seq_inds('hit', 'conserved');\n           : @h_ind = $hit->seq_inds('hit', 'conserved', 1);\n Returns   : Array of integers \n           : May include ranges if collapse is non-zero.\n Argument  : [0] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : [1] class     = 'identical' or 'conserved' (default = 'identical')\n           :              (can be shortened to 'id' or 'cons')\n           :              (actually, anything not 'id' will evaluate to 'conserved').\n           : [2] collapse  = boolean, if non-zero, consecutive positions are merged\n           :             using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\" \n           :             collapses to \"1-5 7 9-11\". This is useful for \n           :             consolidating long lists. Default = no collapse.\n Throws    : n/a.\n\nSee Also   : L<Bio::Search::HSP::BlastHSP::seq_inds()|Bio::Search::HSP::BlastHSP>\n\n\nsub seq_inds {\n    my ($self, $seqType, $class, $collapse) = @_;\n\n    $seqType  ||= 'query';\n    $class ||= 'identical';\n    $collapse ||= 0;\n\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my (@inds, $hsp);\n    foreach $hsp ($self->hsps) {\n        # This will merge data for all HSPs together.\n        push @inds, $hsp->seq_inds($seqType, $class);\n    }\n    \n    # Need to remove duplicates and sort the merged positions.\n    if(@inds) {\n        my %tmp = map { $_, 1 } @inds;\n        @inds = sort {$a <=> $b} keys %tmp;\n    }\n\n    $collapse ?  &Bio::Search::SearchUtils::collapse_nums(@inds) : @inds; \n}\n\n\n=head2 strand\n\nSee documentation in L<Bio::Search::Hit::HitI::strand()|Bio::Search::Hit::HitI>","label":"strand($self,$seqType,$strnd)"},"containerName":"main::","definition":"sub","line":1462,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"strand","line":1463,"kind":13},{"name":"$seqType","containerName":"strand","kind":13,"line":1463},{"name":"$strnd","containerName":"strand","line":1463,"kind":13},{"line":1465,"kind":13,"containerName":"strand","name":"$self"},{"name":"$self","containerName":"strand","kind":13,"line":1466},{"name":"$self","containerName":"strand","kind":13,"line":1471},{"containerName":"strand","name":"$self","kind":13,"line":1471},{"kind":12,"line":1471,"name":"tiled_hsps","containerName":"strand"},{"containerName":"strand","name":"$seqType","line":1473,"kind":13},{"containerName":"strand","name":"$seqType","line":1474,"kind":13},{"name":"$seqType","containerName":"strand","line":1474,"kind":13},{"line":1476,"kind":13,"containerName":"strand","name":"$seqType"},{"containerName":"strand","name":"$seqType","line":1476,"kind":13},{"name":"$strnd","containerName":"strand","line":1478,"kind":13},{"kind":13,"line":1479,"name":"$self","containerName":"strand"},{"name":"throw","containerName":"strand","kind":12,"line":1479},{"name":"$seqType","containerName":"strand","line":1479,"kind":13},{"line":1479,"kind":13,"containerName":"strand","name":"$seqType"},{"containerName":"strand","name":"$self","line":1481,"kind":13},{"name":"$seqType","containerName":"strand","kind":13,"line":1481},{"containerName":"strand","name":"$strnd","kind":13,"line":1481},{"name":"$qstr","definition":"my","containerName":"strand","localvar":"my","kind":13,"line":1484},{"containerName":"strand","name":"$hstr","line":1484,"kind":13},{"kind":13,"line":1486,"containerName":"strand","name":"$self"},{"containerName":"strand","name":"num_hsps","line":1486,"kind":12},{"name":"$self","containerName":"strand","kind":13,"line":1487},{"line":1487,"kind":12,"name":"hsp","containerName":"strand"},{"name":"strand","containerName":"strand","kind":12,"line":1487},{"kind":13,"line":1487,"containerName":"strand","name":"$seqType"},{"line":1489,"kind":13,"containerName":"strand","name":"$self"},{"kind":13,"line":1491,"name":"$qstr","containerName":"strand"},{"name":"$self","containerName":"strand","kind":13,"line":1491},{"kind":13,"line":1492,"name":"$hstr","containerName":"strand"},{"name":"$self","containerName":"strand","kind":13,"line":1492},{"name":"%qstr","definition":"my","containerName":"strand","localvar":"my","kind":13,"line":1499},{"line":1499,"kind":13,"containerName":"strand","name":"%hstr"},{"line":1500,"kind":13,"localvar":"my","name":"$hsp","definition":"my","containerName":"strand"},{"containerName":"strand","name":"$self","line":1500,"kind":13},{"containerName":"strand","name":"hsps","line":1500,"kind":12},{"localvar":"my","name":"$q","definition":"my","containerName":"strand","line":1501,"kind":13},{"name":"$h","containerName":"strand","line":1501,"kind":13},{"name":"$hsp","containerName":"strand","kind":13,"line":1501},{"line":1501,"kind":12,"containerName":"strand","name":"strand"},{"containerName":"strand","name":"$qstr","kind":13,"line":1502},{"containerName":"strand","name":"$q","kind":13,"line":1502},{"line":1503,"kind":13,"containerName":"strand","name":"$hstr"},{"name":"$h","containerName":"strand","line":1503,"kind":13},{"name":"$qstr","containerName":"strand","kind":13,"line":1505},{"line":1505,"kind":13,"containerName":"strand","name":"%qstr"},{"line":1506,"kind":13,"name":"$hstr","containerName":"strand"},{"containerName":"strand","name":"%hstr","line":1506,"kind":13},{"kind":13,"line":1509,"name":"$seqType","containerName":"strand"},{"line":1510,"kind":13,"containerName":"strand","name":"$qstr"},{"name":"$hstr","containerName":"strand","kind":13,"line":1510},{"line":1511,"kind":13,"name":"$seqType","containerName":"strand"},{"name":"$qstr","containerName":"strand","kind":13,"line":1512},{"name":"$hstr","containerName":"strand","line":1514,"kind":13}],"kind":12},{"name":"Bio","containerName":"Search::SearchUtils::_warn_about_no_hsps","line":1466,"kind":12},{"containerName":"Search::SearchUtils::tile_hsps","name":"Bio","line":1471,"kind":12},{"name":"frame","range":{"start":{"line":1524,"character":0},"end":{"character":9999,"line":1549}},"kind":12,"line":1524,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"frame","line":1525,"kind":13},{"name":"$frm","containerName":"frame","line":1525,"kind":13},{"containerName":"frame","name":"$self","line":1527,"kind":13},{"name":"$self","containerName":"frame","kind":13,"line":1528},{"name":"$self","containerName":"frame","line":1533,"kind":13},{"name":"$self","containerName":"frame","kind":13,"line":1533},{"kind":12,"line":1533,"containerName":"frame","name":"tiled_hsps"},{"line":1535,"kind":13,"name":"$frm","containerName":"frame"},{"containerName":"frame","name":"$self","kind":13,"line":1536},{"kind":13,"line":1536,"containerName":"frame","name":"$frm"},{"kind":13,"line":1542,"containerName":"frame","name":"$frame","definition":"my","localvar":"my"},{"kind":13,"line":1543,"name":"$self","containerName":"frame"},{"name":"$frame","containerName":"frame","kind":13,"line":1544},{"line":1544,"kind":13,"name":"$self","containerName":"frame"},{"kind":12,"line":1544,"containerName":"frame","name":"hsp"},{"kind":12,"line":1544,"containerName":"frame","name":"frame"},{"kind":13,"line":1546,"containerName":"frame","name":"$frame"},{"line":1546,"kind":13,"containerName":"frame","name":"$self"},{"kind":13,"line":1548,"containerName":"frame","name":"$frame"}],"containerName":"main::","definition":"sub","detail":"($self,$frm)","signature":{"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\nsub significance {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_significance'};\n    if( defined $value ) { \n        $self->{'_significance'} = $value;\n    } elsif ( ! defined $previous ) {\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this Hit (\".$self->name.\")\");\n\t    return;\n\t}\n        # Set the significance of the Hit to that of the top HSP.\n        $previous = $self->{'_significance'} = ($self->hsps)[0]->significance;\n    }\n\n    return $previous;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_bits'};\n    if( defined $value ) { \n        $self->{'_bits'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using WU-BLAST, check raw_score() instead\");\n\t    return;\n\t}\n        $previous = $self->{'_bits'} = ($self->hsps)[0]->bits;\n    }    \n    return $previous;\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    $self->{'_iterator'} = 0 unless defined $self->{'_iterator'};\n    return unless\n        defined($self->{'_hsps'}) \n        && $self->{'_iterator'} <= scalar @{$self->{'_hsps'}};\n    \n    my $iterator = $self->{'_iterator'}++;\n    my $hsp = $self->{'_hsps'}->[$iterator] || return;\n    if (ref($hsp) eq 'HASH') {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $hsp = $factory->create_object(%{$hsp});\n        $self->{'_hsps'}->[$iterator] = $hsp;\n        delete $self->{_hashes}->{$iterator};\n    }\n    return $hsp;  \n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    my $self = shift;\n    foreach my $i (keys %{$self->{_hashes} || {}}) {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $self->{'_hsps'}->[$i] = $factory->create_object(%{$self->{'_hsps'}->[$i]});\n        delete $self->{_hashes}->{$i};\n    }\n    \n    return wantarray() ? @{$self->{'_hsps'} || []} : scalar(@{$self->{'_hsps'} || []});\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    my $self = shift;\n    \n    unless ($self->{'_hsps'}) {\n        return '-';\n    }\n    \n    return scalar(@{$self->{'_hsps'}});\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_iterator'} = 0;\n}\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences \n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences \n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains \n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Comment   : Note: \"sbjct\" is synonymous with \"hit\"\n\n\nsub ambiguous_aln {\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n=head2 overlap\n\nSee documentation in L<Bio::Search::Hit::HitI::overlap()|Bio::Search::Hit::HitI>\n\n\nsub overlap {\n    my $self = shift; \n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    my $self = shift; \n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description \n    # line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n\tif( $self->hsp ) {\n\t    $n = $self->hsp->n;\n\t}\n    } else {\n        $n = $self->{'_n'}; \n    } \n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<significance()|significance>, L<Bio::Search::SearchUtils::get_exponent()|Bio::Search::SearchUtils>\n\n\nsub p {\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(!defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using significance() instead.\");\n        $val = $self->significance();\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::SearchUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n    \n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = $self->hsps;\n    \n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : This is necessary since the number of identical/conserved residues \n           : can be in terms of peptide sequence space, yet the query and/or hit\n           : sequence are in nucleotide space.\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : In the case of BLAST flavors:\n           : For TBLASTN reports, the length of the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           :\n           : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub logical_length {\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my ($length, $logical);\n    my $algo = $self->algorithm;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->length;\n    } else {\n        # Otherwise, return logical query length\n        $length = $self->query_length();\n        $self->throw(\"Must have defined query_len\") unless ( $length );\n    }\n\n    $logical = Bio::Search::SearchUtils::logical_length($algo, $seqType, $length);\n\n    return int($logical);\n}\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer \n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           : \n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\nsub length_aln {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    # Setter:\n    if( defined $num) {\n        return $self->{'_length_aln_'.$seqType} = $num;\n    }\n\n    unless ($self->{'_hsps'}) {\n        #return wantarray ? ('-','-') : '-';\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $data = $self->{'_length_aln_'.$seqType};\n    \n    ## If we don't have data, figure out what went wrong.\n    if(!$data) {\n        $self->throw(\"Can't get length aln for sequence type \\\"$seqType\\\". \" . \n                     \"Valid types are 'query', 'hit', 'sbjct' ('sbjct' = 'hit')\");\n    }                \n    return $data;\n}    \n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, hit, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers  \n           :    (queryGaps, hitGaps)\n           : Array context can be forced by providing an argument of 'list' or 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed \n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : Not relying on wantarray since that will fail in situations \n           : such as printf \"%d\", $hit->gaps() in which you might expect to \n           : be printing the total gaps, but evaluates to array context.\n\nSee Also   : L<length_aln()|length_aln>\n\n\nsub gaps {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n        #return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    $seqType = lc($seqType);\n\n    if( defined $num ) {\n        $self->throw(\"Can't set gaps for seqType '$seqType'. Must be 'query' or 'hit'\\n\") unless ($seqType eq 'sbjct' or $seqType eq 'query');\n\n        return $self->{'_gaps_'.$seqType} = $num;\n    }\n    elsif($seqType =~ /list|array/i) {\n        return ($self->{'_gaps_query'}, $self->{'_gaps_sbjct'});\n    }\n    elsif($seqType eq 'total') {\n        return ($self->{'_gaps_query'} + $self->{'_gaps_sbjct'}) || 0;\n    } else {\n        return $self->{'_gaps_'.$seqType} || 0;\n    }\n}    \n\n\n=head2 matches\n\nSee documentation in L<Bio::Search::Hit::HitI::matches()|Bio::Search::Hit::HitI>\n\n\nsub matches {\n    my( $self, $arg1, $arg2) = @_;\n    my(@data,$data);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    unless( $arg1 ) {\n        @data = ($self->{'_totalIdentical'}, $self->{'_totalConserved'});\n\n        return @data;\n    } else {\n\n        if( defined $arg2 ) {\n            $self->{'_totalIdentical'} = $arg1;\n            $self->{'_totalConserved'} = $arg2;\n            return ( $arg1, $arg2 );\n        }\n        elsif($arg1 =~ /^id/i) { \n            $data = $self->{'_totalIdentical'};\n        } else {\n            $data = $self->{'_totalConserved'};\n        }\n        #print STDERR \"\\nmatches(): id=$self->{'_totalIdentical'}, cons=$self->{'_totalConserved'}\\n\\n\";\n        return $data;\n    }\n    \n    ## If we make it to here, it is likely the case that\n    ## the parser constructed a minimal hit object from the summary line only.\n    ## It either delibrately skipped parsing the alignment section,\n    ## or was not able to because it was absent (due to blast executable parameter\n    ## setting such as -b 0 (B=0 for WU-BLAST) )\n    #$self->throw(\"Can't get identical or conserved data: no data.\");\n}\n\n\n=head2 start\n\n Usage     : $sbjct->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, the lowest start\n           : value of all HSPs is returned.\n Example   : $qbeg = $sbjct->start('query');\n           : $sbeg = $sbjct->start('hit');\n           : ($qbeg, $sbeg) = $sbjct->start();\n Returns   : scalar context: integer \n           : array context without args: list of two integers (queryStart, sbjctStart)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<end()|end>, L<range()|range>, L<strand()|strand>, \n             L<Bio::Search::HSP::BlastHSP::start|Bio::Search::HSP::BlastHSP>\n\n\nsub start {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Start'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->start($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStart'} and\n        # $self->{'_sbjctStart'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStart'}) {\n            my $earliest_query_start;\n            my $earliest_sbjct_start;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_start = $hsp->start('query');\n                if (! defined $earliest_query_start || $this_query_start < $earliest_query_start) {\n                    $earliest_query_start = $this_query_start;\n                }\n                \n                my $this_sbjct_start = $hsp->start('sbjct');\n                if (! defined $earliest_sbjct_start || $this_sbjct_start < $earliest_sbjct_start) {\n                    $earliest_sbjct_start = $this_sbjct_start;\n                }\n            }\n            $self->{'_queryStart'} = $earliest_query_start;\n            $self->{'_sbjctStart'} = $earliest_sbjct_start;\n        }\n        \n        \n        if ($seqType =~ /list|array/i) {\n            return ($self->{'_queryStart'}, $self->{'_sbjctStart'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Start'};\n        }\n    }\n}\n\n\n=head2 end\n\n Usage     : $sbjct->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, \n             the largest end\n           : value of all HSPs is returned.\n Example   : $qend = $sbjct->end('query');\n           : $send = $sbjct->end('hit');\n           : ($qend, $send) = $sbjct->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers \n           : (queryEnd, sbjctEnd)\n           : Array context can be \"induced\" by providing an argument \n           : of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'sbjct'\n           :  (case insensitive). If not supplied, 'query' is used.\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<range()|range>, L<strand()|strand>\n\n\nsub end {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Stop'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->end($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStop'} and\n        # $self->{'_sbjctStop'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStop'}) {\n            my $latest_query_end;\n            my $latest_sbjct_end;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_end = $hsp->end('query');\n                if (! defined $latest_query_end || $this_query_end > $latest_query_end) {\n                    $latest_query_end = $this_query_end;\n                }\n                \n                my $this_sbjct_end = $hsp->end('sbjct');\n                if (! defined $latest_sbjct_end || $this_sbjct_end > $latest_sbjct_end) {\n                    $latest_sbjct_end = $this_sbjct_end;\n                }\n            }\n            $self->{'_queryStop'} = $latest_query_end;\n            $self->{'_sbjctStop'} = $latest_sbjct_end;\n        }\n        \n        \n        if($seqType =~ /list|array/i) {\n            return ($self->{'_queryStop'}, $self->{'_sbjctStop'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Stop'};\n        }\n    }\n}\n\n=head2 range\n\n Usage     : $sbjct->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($qbeg, $qend) = $sbjct->range('query');\n           : ($sbeg, $send) = $sbjct->range('hit');\n Returns   : Two-element array of integers \n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<end()|end>\n\n\nsub range {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n    return ($self->start($seqType), $self->end($seqType));\n}\n\n\n=head2 frac_identical\n\n Usage     : $hit_object->frac_identical( [seq_type] );\n Purpose   : Get the overall fraction of identical positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_iden = $hit_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : To compute the fraction identical, the logical length of the \n           : aligned portion of the sequence is used, meaning that\n           : in the case of BLAST flavors, for TBLASTN reports, the length of \n           : the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           : This is necessary since the number of identical residues is\n           : in terms of peptide sequence space.\n           :\n           : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or \n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then iterate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_conserved()|frac_conserved>, L<frac_aligned_query()|frac_aligned_query>, L<matches()|matches>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_identical {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = lc($seqType);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $ident = $self->matches('id');\n    my $total = $self->length_aln($seqType);\n    my $ratio = $ident / $total;\n    my $ratio_rounded = sprintf( \"%.3f\", $ratio);\n\n    # Round down iff normal rounding yields 1 (just like blast)\n    $ratio_rounded = 0.999 if (($ratio_rounded == 1) && ($ratio < 1));\n    return $ratio_rounded;\n}\n\n\n=head2 frac_conserved\n\n Usage     : $hit_object->frac_conserved( [seq_type] );\n Purpose   : Get the overall fraction of conserved positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_cons = $hit_object->frac_conserved('hit');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : To compute the fraction conserved, the logical length of the \n           : aligned portion of the sequence is used, meaning that\n           : in the case of BLAST flavors, for TBLASTN reports, the length of \n           : the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           : This is necessary since the number of conserved residues is\n           : in terms of peptide sequence space.\n           :\n           : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Positives = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or \n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_identical()|frac_identical>, L<matches()|matches>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_conserved {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = lc($seqType);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $consv = $self->matches('cons');\n    my $total = $self->length_aln($seqType);\n    my $ratio = $consv / $total;\n    my $ratio_rounded = sprintf( \"%.3f\", $ratio);\n\n    # Round down iff normal rounding yields 1 (just like blast)\n    $ratio_rounded = 0.999 if (($ratio_rounded == 1) && ($ratio < 1));\n    return $ratio_rounded;\n}\n\n\n\n\n=head2 frac_aligned_query\n\n Usage     : $hit_object->frac_aligned_query();\n Purpose   : Get the fraction of the query sequence which has been aligned\n           : across all HSPs (not including intervals between non-overlapping\n           : HSPs).\n Example   : $frac_alnq = $hit_object->frac_aligned_query();\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : n/a\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_aligned_hit()|frac_aligned_hit>, L<logical_length()|logical_length>, L<length_aln()|length_aln>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_aligned_query {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    sprintf( \"%.2f\", $self->length_aln('query') /\n             $self->logical_length('query'));\n}\n\n\n\n=head2 frac_aligned_hit\n\n Usage     : $hit_object->frac_aligned_hit();\n Purpose   : Get the fraction of the hit (sbjct) sequence which has been aligned\n           : across all HSPs (not including intervals between non-overlapping\n           : HSPs).\n Example   : $frac_alnq = $hit_object->frac_aligned_hit();\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : n/a\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_aligned_query()|frac_aligned_query>, L<matches()|matches>, , L<logical_length()|logical_length>, L<length_aln()|length_aln>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_aligned_hit {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    sprintf( \"%.2f\", $self->length_aln('sbjct') / $self->logical_length('sbjct'));\n}\n\n\n## These methods are being maintained for backward compatibility. \n\n=head2 frac_aligned_sbjct\n\nSame as L<frac_aligned_hit()|frac_aligned_hit>\n\n\n*frac_aligned_sbjct = \\&frac_aligned_hit;\n\n=head2 num_unaligned_sbjct\n\nSame as L<num_unaligned_hit()|num_unaligned_hit>\n\n\n*num_unaligned_sbjct = \\&num_unaligned_hit;\n\n\n=head2 num_unaligned_hit\n\n Usage     : $hit_object->num_unaligned_hit();\n Purpose   : Get the number of the unaligned residues in the hit sequence.\n           : Sums across all all HSPs.\n Example   : $num_unaln = $hit_object->num_unaligned_hit();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : See notes regarding logical lengths in the comments for frac_aligned_hit().\n           : They apply here as well.\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n\nSee Also   : L<num_unaligned_query()|num_unaligned_query>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub num_unaligned_hit {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $num = $self->logical_length('sbjct') - $self->length_aln('sbjct');\n    ($num < 0 ? 0 : $num );\n}\n\n\n=head2 num_unaligned_query\n\n Usage     : $hit_object->num_unaligned_query();\n Purpose   : Get the number of the unaligned residues in the query sequence.\n           : Sums across all all HSPs.\n Example   : $num_unaln = $hit_object->num_unaligned_query();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : See notes regarding logical lengths in the comments for frac_aligned_query().\n           : They apply here as well.\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n\nSee Also   : L<num_unaligned_hit()|num_unaligned_hit>, L<frac_aligned_query()|frac_aligned_query>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub num_unaligned_query {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $num = $self->logical_length('query') - $self->length_aln('query');\n    ($num < 0 ? 0 : $num );\n}\n\n\n\n=head2 seq_inds\n\n Usage     : $hit->seq_inds( seq_type, class, collapse );\n Purpose   : Get a list of residue positions (indices) across all HSPs\n           : for identical or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hit->seq_inds('query', 'identical');\n           : @h_ind = $hit->seq_inds('hit', 'conserved');\n           : @h_ind = $hit->seq_inds('hit', 'conserved', 1);\n Returns   : Array of integers \n           : May include ranges if collapse is non-zero.\n Argument  : [0] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : [1] class     = 'identical' or 'conserved' (default = 'identical')\n           :              (can be shortened to 'id' or 'cons')\n           :              (actually, anything not 'id' will evaluate to 'conserved').\n           : [2] collapse  = boolean, if non-zero, consecutive positions are merged\n           :             using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\" \n           :             collapses to \"1-5 7 9-11\". This is useful for \n           :             consolidating long lists. Default = no collapse.\n Throws    : n/a.\n\nSee Also   : L<Bio::Search::HSP::BlastHSP::seq_inds()|Bio::Search::HSP::BlastHSP>\n\n\nsub seq_inds {\n    my ($self, $seqType, $class, $collapse) = @_;\n\n    $seqType  ||= 'query';\n    $class ||= 'identical';\n    $collapse ||= 0;\n\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my (@inds, $hsp);\n    foreach $hsp ($self->hsps) {\n        # This will merge data for all HSPs together.\n        push @inds, $hsp->seq_inds($seqType, $class);\n    }\n    \n    # Need to remove duplicates and sort the merged positions.\n    if(@inds) {\n        my %tmp = map { $_, 1 } @inds;\n        @inds = sort {$a <=> $b} keys %tmp;\n    }\n\n    $collapse ?  &Bio::Search::SearchUtils::collapse_nums(@inds) : @inds; \n}\n\n\n=head2 strand\n\nSee documentation in L<Bio::Search::Hit::HitI::strand()|Bio::Search::Hit::HitI>\n\n\nsub strand {\n    my ($self, $seqType, $strnd) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n        #return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $seqType = lc($seqType);\n\n    if( defined $strnd ) {\n        $self->throw(\"Can't set strand for seqType '$seqType'. Must be 'query' or 'hit'\\n\") unless ($seqType eq 'sbjct' or $seqType eq 'query');\n\n        return $self->{'_strand_'.$seqType} = $strnd;\n    }\n\n    my ($qstr, $hstr);\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->strand($seqType);\n    } \n    elsif( defined $self->{'_strand_query'}) {\n        # Get the data computed during hsp tiling.\n        $qstr = $self->{'_strand_query'};\n        $hstr = $self->{'_strand_sbjct'}\n    }\n    else {\n        # otherwise, iterate through all HSPs collecting strand info.\n        # This will return the string \"-1/1\" if there are HSPs on different strands.\n        # NOTE: This was the pre-10/21/02 procedure which will no longer be used,\n        # (unless the above elsif{} is commented out).\n        my (%qstr, %hstr);\n        foreach my $hsp( $self->hsps ) {\n            my ( $q, $h ) = $hsp->strand();\n            $qstr{ $q }++;\n            $hstr{ $h }++;\n        }\n        $qstr = join( '/', sort keys %qstr);\n        $hstr = join( '/', sort keys %hstr);\n    }\n\n    if($seqType =~ /list|array/i) {\n        return ($qstr, $hstr);\n    } elsif( $seqType eq 'query' ) {\n        return $qstr;\n    } else {\n        return $hstr;\n    }\n}\n\n=head2 frame\n\nSee documentation in L<Bio::Search::Hit::HitI::frame()|Bio::Search::Hit::HitI>","parameters":[{"label":"$self"},{"label":"$frm"}],"label":"frame($self,$frm)"}},{"kind":12,"line":1528,"containerName":"Search::SearchUtils::_warn_about_no_hsps","name":"Bio"},{"line":1533,"kind":12,"name":"Bio","containerName":"Search::SearchUtils::tile_hsps"},{"containerName":"main::","name":"rank","definition":"sub","range":{"start":{"line":1563,"character":0},"end":{"line":1567,"character":9999}},"kind":12,"line":1563,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"rank","line":1564,"kind":13},{"line":1565,"kind":13,"name":"$self","containerName":"rank"},{"kind":13,"line":1566,"containerName":"rank","name":"$self"}]},{"range":{"start":{"character":0,"line":1579},"end":{"line":1593,"character":9999}},"name":"locus","line":1579,"children":[{"kind":13,"line":1580,"containerName":"locus","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":1580,"name":"$value","containerName":"locus"},{"definition":"my","name":"$previous","containerName":"locus","localvar":"my","kind":13,"line":1581},{"name":"$self","containerName":"locus","kind":13,"line":1581},{"containerName":"locus","name":"$value","kind":13,"line":1582},{"name":"$previous","containerName":"locus","kind":13,"line":1582},{"name":"$value","containerName":"locus","line":1583,"kind":13},{"kind":13,"line":1584,"name":"$self","containerName":"locus"},{"kind":13,"line":1585,"name":"$value","containerName":"locus"},{"name":"$previous","containerName":"locus","line":1585,"kind":13},{"kind":13,"line":1587,"name":"$value","containerName":"locus"},{"line":1587,"kind":13,"name":"$previous","containerName":"locus"},{"name":"$self","containerName":"locus","kind":13,"line":1590},{"containerName":"locus","name":"$value","kind":13,"line":1590},{"name":"$previous","containerName":"locus","kind":13,"line":1592}],"kind":12,"detail":"($self,$value)","signature":{"label":"locus($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\nsub significance {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_significance'};\n    if( defined $value ) { \n        $self->{'_significance'} = $value;\n    } elsif ( ! defined $previous ) {\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this Hit (\".$self->name.\")\");\n\t    return;\n\t}\n        # Set the significance of the Hit to that of the top HSP.\n        $previous = $self->{'_significance'} = ($self->hsps)[0]->significance;\n    }\n\n    return $previous;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_bits'};\n    if( defined $value ) { \n        $self->{'_bits'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using WU-BLAST, check raw_score() instead\");\n\t    return;\n\t}\n        $previous = $self->{'_bits'} = ($self->hsps)[0]->bits;\n    }    \n    return $previous;\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    $self->{'_iterator'} = 0 unless defined $self->{'_iterator'};\n    return unless\n        defined($self->{'_hsps'}) \n        && $self->{'_iterator'} <= scalar @{$self->{'_hsps'}};\n    \n    my $iterator = $self->{'_iterator'}++;\n    my $hsp = $self->{'_hsps'}->[$iterator] || return;\n    if (ref($hsp) eq 'HASH') {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $hsp = $factory->create_object(%{$hsp});\n        $self->{'_hsps'}->[$iterator] = $hsp;\n        delete $self->{_hashes}->{$iterator};\n    }\n    return $hsp;  \n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    my $self = shift;\n    foreach my $i (keys %{$self->{_hashes} || {}}) {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $self->{'_hsps'}->[$i] = $factory->create_object(%{$self->{'_hsps'}->[$i]});\n        delete $self->{_hashes}->{$i};\n    }\n    \n    return wantarray() ? @{$self->{'_hsps'} || []} : scalar(@{$self->{'_hsps'} || []});\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    my $self = shift;\n    \n    unless ($self->{'_hsps'}) {\n        return '-';\n    }\n    \n    return scalar(@{$self->{'_hsps'}});\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_iterator'} = 0;\n}\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences \n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences \n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains \n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Comment   : Note: \"sbjct\" is synonymous with \"hit\"\n\n\nsub ambiguous_aln {\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n=head2 overlap\n\nSee documentation in L<Bio::Search::Hit::HitI::overlap()|Bio::Search::Hit::HitI>\n\n\nsub overlap {\n    my $self = shift; \n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    my $self = shift; \n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description \n    # line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n\tif( $self->hsp ) {\n\t    $n = $self->hsp->n;\n\t}\n    } else {\n        $n = $self->{'_n'}; \n    } \n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<significance()|significance>, L<Bio::Search::SearchUtils::get_exponent()|Bio::Search::SearchUtils>\n\n\nsub p {\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(!defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using significance() instead.\");\n        $val = $self->significance();\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::SearchUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n    \n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = $self->hsps;\n    \n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : This is necessary since the number of identical/conserved residues \n           : can be in terms of peptide sequence space, yet the query and/or hit\n           : sequence are in nucleotide space.\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : In the case of BLAST flavors:\n           : For TBLASTN reports, the length of the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           :\n           : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub logical_length {\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my ($length, $logical);\n    my $algo = $self->algorithm;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->length;\n    } else {\n        # Otherwise, return logical query length\n        $length = $self->query_length();\n        $self->throw(\"Must have defined query_len\") unless ( $length );\n    }\n\n    $logical = Bio::Search::SearchUtils::logical_length($algo, $seqType, $length);\n\n    return int($logical);\n}\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer \n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           : \n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\nsub length_aln {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    # Setter:\n    if( defined $num) {\n        return $self->{'_length_aln_'.$seqType} = $num;\n    }\n\n    unless ($self->{'_hsps'}) {\n        #return wantarray ? ('-','-') : '-';\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $data = $self->{'_length_aln_'.$seqType};\n    \n    ## If we don't have data, figure out what went wrong.\n    if(!$data) {\n        $self->throw(\"Can't get length aln for sequence type \\\"$seqType\\\". \" . \n                     \"Valid types are 'query', 'hit', 'sbjct' ('sbjct' = 'hit')\");\n    }                \n    return $data;\n}    \n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, hit, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers  \n           :    (queryGaps, hitGaps)\n           : Array context can be forced by providing an argument of 'list' or 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed \n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : Not relying on wantarray since that will fail in situations \n           : such as printf \"%d\", $hit->gaps() in which you might expect to \n           : be printing the total gaps, but evaluates to array context.\n\nSee Also   : L<length_aln()|length_aln>\n\n\nsub gaps {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n        #return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    $seqType = lc($seqType);\n\n    if( defined $num ) {\n        $self->throw(\"Can't set gaps for seqType '$seqType'. Must be 'query' or 'hit'\\n\") unless ($seqType eq 'sbjct' or $seqType eq 'query');\n\n        return $self->{'_gaps_'.$seqType} = $num;\n    }\n    elsif($seqType =~ /list|array/i) {\n        return ($self->{'_gaps_query'}, $self->{'_gaps_sbjct'});\n    }\n    elsif($seqType eq 'total') {\n        return ($self->{'_gaps_query'} + $self->{'_gaps_sbjct'}) || 0;\n    } else {\n        return $self->{'_gaps_'.$seqType} || 0;\n    }\n}    \n\n\n=head2 matches\n\nSee documentation in L<Bio::Search::Hit::HitI::matches()|Bio::Search::Hit::HitI>\n\n\nsub matches {\n    my( $self, $arg1, $arg2) = @_;\n    my(@data,$data);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    unless( $arg1 ) {\n        @data = ($self->{'_totalIdentical'}, $self->{'_totalConserved'});\n\n        return @data;\n    } else {\n\n        if( defined $arg2 ) {\n            $self->{'_totalIdentical'} = $arg1;\n            $self->{'_totalConserved'} = $arg2;\n            return ( $arg1, $arg2 );\n        }\n        elsif($arg1 =~ /^id/i) { \n            $data = $self->{'_totalIdentical'};\n        } else {\n            $data = $self->{'_totalConserved'};\n        }\n        #print STDERR \"\\nmatches(): id=$self->{'_totalIdentical'}, cons=$self->{'_totalConserved'}\\n\\n\";\n        return $data;\n    }\n    \n    ## If we make it to here, it is likely the case that\n    ## the parser constructed a minimal hit object from the summary line only.\n    ## It either delibrately skipped parsing the alignment section,\n    ## or was not able to because it was absent (due to blast executable parameter\n    ## setting such as -b 0 (B=0 for WU-BLAST) )\n    #$self->throw(\"Can't get identical or conserved data: no data.\");\n}\n\n\n=head2 start\n\n Usage     : $sbjct->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, the lowest start\n           : value of all HSPs is returned.\n Example   : $qbeg = $sbjct->start('query');\n           : $sbeg = $sbjct->start('hit');\n           : ($qbeg, $sbeg) = $sbjct->start();\n Returns   : scalar context: integer \n           : array context without args: list of two integers (queryStart, sbjctStart)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<end()|end>, L<range()|range>, L<strand()|strand>, \n             L<Bio::Search::HSP::BlastHSP::start|Bio::Search::HSP::BlastHSP>\n\n\nsub start {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Start'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->start($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStart'} and\n        # $self->{'_sbjctStart'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStart'}) {\n            my $earliest_query_start;\n            my $earliest_sbjct_start;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_start = $hsp->start('query');\n                if (! defined $earliest_query_start || $this_query_start < $earliest_query_start) {\n                    $earliest_query_start = $this_query_start;\n                }\n                \n                my $this_sbjct_start = $hsp->start('sbjct');\n                if (! defined $earliest_sbjct_start || $this_sbjct_start < $earliest_sbjct_start) {\n                    $earliest_sbjct_start = $this_sbjct_start;\n                }\n            }\n            $self->{'_queryStart'} = $earliest_query_start;\n            $self->{'_sbjctStart'} = $earliest_sbjct_start;\n        }\n        \n        \n        if ($seqType =~ /list|array/i) {\n            return ($self->{'_queryStart'}, $self->{'_sbjctStart'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Start'};\n        }\n    }\n}\n\n\n=head2 end\n\n Usage     : $sbjct->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, \n             the largest end\n           : value of all HSPs is returned.\n Example   : $qend = $sbjct->end('query');\n           : $send = $sbjct->end('hit');\n           : ($qend, $send) = $sbjct->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers \n           : (queryEnd, sbjctEnd)\n           : Array context can be \"induced\" by providing an argument \n           : of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'sbjct'\n           :  (case insensitive). If not supplied, 'query' is used.\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<range()|range>, L<strand()|strand>\n\n\nsub end {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Stop'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->end($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStop'} and\n        # $self->{'_sbjctStop'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStop'}) {\n            my $latest_query_end;\n            my $latest_sbjct_end;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_end = $hsp->end('query');\n                if (! defined $latest_query_end || $this_query_end > $latest_query_end) {\n                    $latest_query_end = $this_query_end;\n                }\n                \n                my $this_sbjct_end = $hsp->end('sbjct');\n                if (! defined $latest_sbjct_end || $this_sbjct_end > $latest_sbjct_end) {\n                    $latest_sbjct_end = $this_sbjct_end;\n                }\n            }\n            $self->{'_queryStop'} = $latest_query_end;\n            $self->{'_sbjctStop'} = $latest_sbjct_end;\n        }\n        \n        \n        if($seqType =~ /list|array/i) {\n            return ($self->{'_queryStop'}, $self->{'_sbjctStop'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Stop'};\n        }\n    }\n}\n\n=head2 range\n\n Usage     : $sbjct->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($qbeg, $qend) = $sbjct->range('query');\n           : ($sbeg, $send) = $sbjct->range('hit');\n Returns   : Two-element array of integers \n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<end()|end>\n\n\nsub range {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n    return ($self->start($seqType), $self->end($seqType));\n}\n\n\n=head2 frac_identical\n\n Usage     : $hit_object->frac_identical( [seq_type] );\n Purpose   : Get the overall fraction of identical positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_iden = $hit_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : To compute the fraction identical, the logical length of the \n           : aligned portion of the sequence is used, meaning that\n           : in the case of BLAST flavors, for TBLASTN reports, the length of \n           : the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           : This is necessary since the number of identical residues is\n           : in terms of peptide sequence space.\n           :\n           : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or \n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then iterate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_conserved()|frac_conserved>, L<frac_aligned_query()|frac_aligned_query>, L<matches()|matches>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_identical {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = lc($seqType);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $ident = $self->matches('id');\n    my $total = $self->length_aln($seqType);\n    my $ratio = $ident / $total;\n    my $ratio_rounded = sprintf( \"%.3f\", $ratio);\n\n    # Round down iff normal rounding yields 1 (just like blast)\n    $ratio_rounded = 0.999 if (($ratio_rounded == 1) && ($ratio < 1));\n    return $ratio_rounded;\n}\n\n\n=head2 frac_conserved\n\n Usage     : $hit_object->frac_conserved( [seq_type] );\n Purpose   : Get the overall fraction of conserved positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_cons = $hit_object->frac_conserved('hit');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : To compute the fraction conserved, the logical length of the \n           : aligned portion of the sequence is used, meaning that\n           : in the case of BLAST flavors, for TBLASTN reports, the length of \n           : the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           : This is necessary since the number of conserved residues is\n           : in terms of peptide sequence space.\n           :\n           : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Positives = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or \n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_identical()|frac_identical>, L<matches()|matches>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_conserved {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = lc($seqType);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $consv = $self->matches('cons');\n    my $total = $self->length_aln($seqType);\n    my $ratio = $consv / $total;\n    my $ratio_rounded = sprintf( \"%.3f\", $ratio);\n\n    # Round down iff normal rounding yields 1 (just like blast)\n    $ratio_rounded = 0.999 if (($ratio_rounded == 1) && ($ratio < 1));\n    return $ratio_rounded;\n}\n\n\n\n\n=head2 frac_aligned_query\n\n Usage     : $hit_object->frac_aligned_query();\n Purpose   : Get the fraction of the query sequence which has been aligned\n           : across all HSPs (not including intervals between non-overlapping\n           : HSPs).\n Example   : $frac_alnq = $hit_object->frac_aligned_query();\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : n/a\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_aligned_hit()|frac_aligned_hit>, L<logical_length()|logical_length>, L<length_aln()|length_aln>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_aligned_query {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    sprintf( \"%.2f\", $self->length_aln('query') /\n             $self->logical_length('query'));\n}\n\n\n\n=head2 frac_aligned_hit\n\n Usage     : $hit_object->frac_aligned_hit();\n Purpose   : Get the fraction of the hit (sbjct) sequence which has been aligned\n           : across all HSPs (not including intervals between non-overlapping\n           : HSPs).\n Example   : $frac_alnq = $hit_object->frac_aligned_hit();\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : n/a\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_aligned_query()|frac_aligned_query>, L<matches()|matches>, , L<logical_length()|logical_length>, L<length_aln()|length_aln>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_aligned_hit {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    sprintf( \"%.2f\", $self->length_aln('sbjct') / $self->logical_length('sbjct'));\n}\n\n\n## These methods are being maintained for backward compatibility. \n\n=head2 frac_aligned_sbjct\n\nSame as L<frac_aligned_hit()|frac_aligned_hit>\n\n\n*frac_aligned_sbjct = \\&frac_aligned_hit;\n\n=head2 num_unaligned_sbjct\n\nSame as L<num_unaligned_hit()|num_unaligned_hit>\n\n\n*num_unaligned_sbjct = \\&num_unaligned_hit;\n\n\n=head2 num_unaligned_hit\n\n Usage     : $hit_object->num_unaligned_hit();\n Purpose   : Get the number of the unaligned residues in the hit sequence.\n           : Sums across all all HSPs.\n Example   : $num_unaln = $hit_object->num_unaligned_hit();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : See notes regarding logical lengths in the comments for frac_aligned_hit().\n           : They apply here as well.\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n\nSee Also   : L<num_unaligned_query()|num_unaligned_query>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub num_unaligned_hit {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $num = $self->logical_length('sbjct') - $self->length_aln('sbjct');\n    ($num < 0 ? 0 : $num );\n}\n\n\n=head2 num_unaligned_query\n\n Usage     : $hit_object->num_unaligned_query();\n Purpose   : Get the number of the unaligned residues in the query sequence.\n           : Sums across all all HSPs.\n Example   : $num_unaln = $hit_object->num_unaligned_query();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : See notes regarding logical lengths in the comments for frac_aligned_query().\n           : They apply here as well.\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n\nSee Also   : L<num_unaligned_hit()|num_unaligned_hit>, L<frac_aligned_query()|frac_aligned_query>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub num_unaligned_query {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $num = $self->logical_length('query') - $self->length_aln('query');\n    ($num < 0 ? 0 : $num );\n}\n\n\n\n=head2 seq_inds\n\n Usage     : $hit->seq_inds( seq_type, class, collapse );\n Purpose   : Get a list of residue positions (indices) across all HSPs\n           : for identical or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hit->seq_inds('query', 'identical');\n           : @h_ind = $hit->seq_inds('hit', 'conserved');\n           : @h_ind = $hit->seq_inds('hit', 'conserved', 1);\n Returns   : Array of integers \n           : May include ranges if collapse is non-zero.\n Argument  : [0] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : [1] class     = 'identical' or 'conserved' (default = 'identical')\n           :              (can be shortened to 'id' or 'cons')\n           :              (actually, anything not 'id' will evaluate to 'conserved').\n           : [2] collapse  = boolean, if non-zero, consecutive positions are merged\n           :             using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\" \n           :             collapses to \"1-5 7 9-11\". This is useful for \n           :             consolidating long lists. Default = no collapse.\n Throws    : n/a.\n\nSee Also   : L<Bio::Search::HSP::BlastHSP::seq_inds()|Bio::Search::HSP::BlastHSP>\n\n\nsub seq_inds {\n    my ($self, $seqType, $class, $collapse) = @_;\n\n    $seqType  ||= 'query';\n    $class ||= 'identical';\n    $collapse ||= 0;\n\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my (@inds, $hsp);\n    foreach $hsp ($self->hsps) {\n        # This will merge data for all HSPs together.\n        push @inds, $hsp->seq_inds($seqType, $class);\n    }\n    \n    # Need to remove duplicates and sort the merged positions.\n    if(@inds) {\n        my %tmp = map { $_, 1 } @inds;\n        @inds = sort {$a <=> $b} keys %tmp;\n    }\n\n    $collapse ?  &Bio::Search::SearchUtils::collapse_nums(@inds) : @inds; \n}\n\n\n=head2 strand\n\nSee documentation in L<Bio::Search::Hit::HitI::strand()|Bio::Search::Hit::HitI>\n\n\nsub strand {\n    my ($self, $seqType, $strnd) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n        #return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $seqType = lc($seqType);\n\n    if( defined $strnd ) {\n        $self->throw(\"Can't set strand for seqType '$seqType'. Must be 'query' or 'hit'\\n\") unless ($seqType eq 'sbjct' or $seqType eq 'query');\n\n        return $self->{'_strand_'.$seqType} = $strnd;\n    }\n\n    my ($qstr, $hstr);\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->strand($seqType);\n    } \n    elsif( defined $self->{'_strand_query'}) {\n        # Get the data computed during hsp tiling.\n        $qstr = $self->{'_strand_query'};\n        $hstr = $self->{'_strand_sbjct'}\n    }\n    else {\n        # otherwise, iterate through all HSPs collecting strand info.\n        # This will return the string \"-1/1\" if there are HSPs on different strands.\n        # NOTE: This was the pre-10/21/02 procedure which will no longer be used,\n        # (unless the above elsif{} is commented out).\n        my (%qstr, %hstr);\n        foreach my $hsp( $self->hsps ) {\n            my ( $q, $h ) = $hsp->strand();\n            $qstr{ $q }++;\n            $hstr{ $h }++;\n        }\n        $qstr = join( '/', sort keys %qstr);\n        $hstr = join( '/', sort keys %hstr);\n    }\n\n    if($seqType =~ /list|array/i) {\n        return ($qstr, $hstr);\n    } elsif( $seqType eq 'query' ) {\n        return $qstr;\n    } else {\n        return $hstr;\n    }\n}\n\n=head2 frame\n\nSee documentation in L<Bio::Search::Hit::HitI::frame()|Bio::Search::Hit::HitI>\n\n\nsub frame {\n    my( $self, $frm ) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    if( defined $frm ) {\n        return $self->{'_frame'} = $frm;\n    }\n\n    # The check for $self->{'_frame'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($frame);\n    if(not defined($self->{'_frame'})) {\n        $frame = $self->hsp->frame('hit');\n    } else {\n        $frame = $self->{'_frame'}; \n    } \n    return $frame;\n}\n\n=head2 rank\n\n Title   : rank\n Usage   : $obj->rank($newval)\n Function: Get/Set the rank of this Hit in the Query search list\n           i.e. this is the Nth hit for a specific query\n Returns : value of rank\n Args    : newvalue (optional)\n\n\n\nsub rank {\n    my $self = shift;\n    return $self->{'_rank'} = shift if @_;\n    return $self->{'_rank'} || 1;\n}\n\n=head2 locus\n\n Title   : locus\n Usage   : $locus = $hit->locus();\n Function: Retrieve the locus (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none"},"containerName":"main::","definition":"sub"},{"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"each_accession_number($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\nsub significance {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_significance'};\n    if( defined $value ) { \n        $self->{'_significance'} = $value;\n    } elsif ( ! defined $previous ) {\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this Hit (\".$self->name.\")\");\n\t    return;\n\t}\n        # Set the significance of the Hit to that of the top HSP.\n        $previous = $self->{'_significance'} = ($self->hsps)[0]->significance;\n    }\n\n    return $previous;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_bits'};\n    if( defined $value ) { \n        $self->{'_bits'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using WU-BLAST, check raw_score() instead\");\n\t    return;\n\t}\n        $previous = $self->{'_bits'} = ($self->hsps)[0]->bits;\n    }    \n    return $previous;\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    $self->{'_iterator'} = 0 unless defined $self->{'_iterator'};\n    return unless\n        defined($self->{'_hsps'}) \n        && $self->{'_iterator'} <= scalar @{$self->{'_hsps'}};\n    \n    my $iterator = $self->{'_iterator'}++;\n    my $hsp = $self->{'_hsps'}->[$iterator] || return;\n    if (ref($hsp) eq 'HASH') {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $hsp = $factory->create_object(%{$hsp});\n        $self->{'_hsps'}->[$iterator] = $hsp;\n        delete $self->{_hashes}->{$iterator};\n    }\n    return $hsp;  \n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    my $self = shift;\n    foreach my $i (keys %{$self->{_hashes} || {}}) {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $self->{'_hsps'}->[$i] = $factory->create_object(%{$self->{'_hsps'}->[$i]});\n        delete $self->{_hashes}->{$i};\n    }\n    \n    return wantarray() ? @{$self->{'_hsps'} || []} : scalar(@{$self->{'_hsps'} || []});\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    my $self = shift;\n    \n    unless ($self->{'_hsps'}) {\n        return '-';\n    }\n    \n    return scalar(@{$self->{'_hsps'}});\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_iterator'} = 0;\n}\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences \n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences \n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains \n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Comment   : Note: \"sbjct\" is synonymous with \"hit\"\n\n\nsub ambiguous_aln {\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n=head2 overlap\n\nSee documentation in L<Bio::Search::Hit::HitI::overlap()|Bio::Search::Hit::HitI>\n\n\nsub overlap {\n    my $self = shift; \n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    my $self = shift; \n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description \n    # line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n\tif( $self->hsp ) {\n\t    $n = $self->hsp->n;\n\t}\n    } else {\n        $n = $self->{'_n'}; \n    } \n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<significance()|significance>, L<Bio::Search::SearchUtils::get_exponent()|Bio::Search::SearchUtils>\n\n\nsub p {\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(!defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using significance() instead.\");\n        $val = $self->significance();\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::SearchUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n    \n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = $self->hsps;\n    \n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : This is necessary since the number of identical/conserved residues \n           : can be in terms of peptide sequence space, yet the query and/or hit\n           : sequence are in nucleotide space.\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : In the case of BLAST flavors:\n           : For TBLASTN reports, the length of the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           :\n           : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub logical_length {\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my ($length, $logical);\n    my $algo = $self->algorithm;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->length;\n    } else {\n        # Otherwise, return logical query length\n        $length = $self->query_length();\n        $self->throw(\"Must have defined query_len\") unless ( $length );\n    }\n\n    $logical = Bio::Search::SearchUtils::logical_length($algo, $seqType, $length);\n\n    return int($logical);\n}\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer \n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           : \n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\nsub length_aln {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    # Setter:\n    if( defined $num) {\n        return $self->{'_length_aln_'.$seqType} = $num;\n    }\n\n    unless ($self->{'_hsps'}) {\n        #return wantarray ? ('-','-') : '-';\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $data = $self->{'_length_aln_'.$seqType};\n    \n    ## If we don't have data, figure out what went wrong.\n    if(!$data) {\n        $self->throw(\"Can't get length aln for sequence type \\\"$seqType\\\". \" . \n                     \"Valid types are 'query', 'hit', 'sbjct' ('sbjct' = 'hit')\");\n    }                \n    return $data;\n}    \n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, hit, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers  \n           :    (queryGaps, hitGaps)\n           : Array context can be forced by providing an argument of 'list' or 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed \n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : Not relying on wantarray since that will fail in situations \n           : such as printf \"%d\", $hit->gaps() in which you might expect to \n           : be printing the total gaps, but evaluates to array context.\n\nSee Also   : L<length_aln()|length_aln>\n\n\nsub gaps {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n        #return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    $seqType = lc($seqType);\n\n    if( defined $num ) {\n        $self->throw(\"Can't set gaps for seqType '$seqType'. Must be 'query' or 'hit'\\n\") unless ($seqType eq 'sbjct' or $seqType eq 'query');\n\n        return $self->{'_gaps_'.$seqType} = $num;\n    }\n    elsif($seqType =~ /list|array/i) {\n        return ($self->{'_gaps_query'}, $self->{'_gaps_sbjct'});\n    }\n    elsif($seqType eq 'total') {\n        return ($self->{'_gaps_query'} + $self->{'_gaps_sbjct'}) || 0;\n    } else {\n        return $self->{'_gaps_'.$seqType} || 0;\n    }\n}    \n\n\n=head2 matches\n\nSee documentation in L<Bio::Search::Hit::HitI::matches()|Bio::Search::Hit::HitI>\n\n\nsub matches {\n    my( $self, $arg1, $arg2) = @_;\n    my(@data,$data);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    unless( $arg1 ) {\n        @data = ($self->{'_totalIdentical'}, $self->{'_totalConserved'});\n\n        return @data;\n    } else {\n\n        if( defined $arg2 ) {\n            $self->{'_totalIdentical'} = $arg1;\n            $self->{'_totalConserved'} = $arg2;\n            return ( $arg1, $arg2 );\n        }\n        elsif($arg1 =~ /^id/i) { \n            $data = $self->{'_totalIdentical'};\n        } else {\n            $data = $self->{'_totalConserved'};\n        }\n        #print STDERR \"\\nmatches(): id=$self->{'_totalIdentical'}, cons=$self->{'_totalConserved'}\\n\\n\";\n        return $data;\n    }\n    \n    ## If we make it to here, it is likely the case that\n    ## the parser constructed a minimal hit object from the summary line only.\n    ## It either delibrately skipped parsing the alignment section,\n    ## or was not able to because it was absent (due to blast executable parameter\n    ## setting such as -b 0 (B=0 for WU-BLAST) )\n    #$self->throw(\"Can't get identical or conserved data: no data.\");\n}\n\n\n=head2 start\n\n Usage     : $sbjct->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, the lowest start\n           : value of all HSPs is returned.\n Example   : $qbeg = $sbjct->start('query');\n           : $sbeg = $sbjct->start('hit');\n           : ($qbeg, $sbeg) = $sbjct->start();\n Returns   : scalar context: integer \n           : array context without args: list of two integers (queryStart, sbjctStart)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<end()|end>, L<range()|range>, L<strand()|strand>, \n             L<Bio::Search::HSP::BlastHSP::start|Bio::Search::HSP::BlastHSP>\n\n\nsub start {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Start'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->start($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStart'} and\n        # $self->{'_sbjctStart'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStart'}) {\n            my $earliest_query_start;\n            my $earliest_sbjct_start;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_start = $hsp->start('query');\n                if (! defined $earliest_query_start || $this_query_start < $earliest_query_start) {\n                    $earliest_query_start = $this_query_start;\n                }\n                \n                my $this_sbjct_start = $hsp->start('sbjct');\n                if (! defined $earliest_sbjct_start || $this_sbjct_start < $earliest_sbjct_start) {\n                    $earliest_sbjct_start = $this_sbjct_start;\n                }\n            }\n            $self->{'_queryStart'} = $earliest_query_start;\n            $self->{'_sbjctStart'} = $earliest_sbjct_start;\n        }\n        \n        \n        if ($seqType =~ /list|array/i) {\n            return ($self->{'_queryStart'}, $self->{'_sbjctStart'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Start'};\n        }\n    }\n}\n\n\n=head2 end\n\n Usage     : $sbjct->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, \n             the largest end\n           : value of all HSPs is returned.\n Example   : $qend = $sbjct->end('query');\n           : $send = $sbjct->end('hit');\n           : ($qend, $send) = $sbjct->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers \n           : (queryEnd, sbjctEnd)\n           : Array context can be \"induced\" by providing an argument \n           : of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'sbjct'\n           :  (case insensitive). If not supplied, 'query' is used.\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<range()|range>, L<strand()|strand>\n\n\nsub end {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Stop'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->end($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStop'} and\n        # $self->{'_sbjctStop'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStop'}) {\n            my $latest_query_end;\n            my $latest_sbjct_end;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_end = $hsp->end('query');\n                if (! defined $latest_query_end || $this_query_end > $latest_query_end) {\n                    $latest_query_end = $this_query_end;\n                }\n                \n                my $this_sbjct_end = $hsp->end('sbjct');\n                if (! defined $latest_sbjct_end || $this_sbjct_end > $latest_sbjct_end) {\n                    $latest_sbjct_end = $this_sbjct_end;\n                }\n            }\n            $self->{'_queryStop'} = $latest_query_end;\n            $self->{'_sbjctStop'} = $latest_sbjct_end;\n        }\n        \n        \n        if($seqType =~ /list|array/i) {\n            return ($self->{'_queryStop'}, $self->{'_sbjctStop'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Stop'};\n        }\n    }\n}\n\n=head2 range\n\n Usage     : $sbjct->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($qbeg, $qend) = $sbjct->range('query');\n           : ($sbeg, $send) = $sbjct->range('hit');\n Returns   : Two-element array of integers \n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<end()|end>\n\n\nsub range {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n    return ($self->start($seqType), $self->end($seqType));\n}\n\n\n=head2 frac_identical\n\n Usage     : $hit_object->frac_identical( [seq_type] );\n Purpose   : Get the overall fraction of identical positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_iden = $hit_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : To compute the fraction identical, the logical length of the \n           : aligned portion of the sequence is used, meaning that\n           : in the case of BLAST flavors, for TBLASTN reports, the length of \n           : the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           : This is necessary since the number of identical residues is\n           : in terms of peptide sequence space.\n           :\n           : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or \n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then iterate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_conserved()|frac_conserved>, L<frac_aligned_query()|frac_aligned_query>, L<matches()|matches>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_identical {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = lc($seqType);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $ident = $self->matches('id');\n    my $total = $self->length_aln($seqType);\n    my $ratio = $ident / $total;\n    my $ratio_rounded = sprintf( \"%.3f\", $ratio);\n\n    # Round down iff normal rounding yields 1 (just like blast)\n    $ratio_rounded = 0.999 if (($ratio_rounded == 1) && ($ratio < 1));\n    return $ratio_rounded;\n}\n\n\n=head2 frac_conserved\n\n Usage     : $hit_object->frac_conserved( [seq_type] );\n Purpose   : Get the overall fraction of conserved positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_cons = $hit_object->frac_conserved('hit');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : To compute the fraction conserved, the logical length of the \n           : aligned portion of the sequence is used, meaning that\n           : in the case of BLAST flavors, for TBLASTN reports, the length of \n           : the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           : This is necessary since the number of conserved residues is\n           : in terms of peptide sequence space.\n           :\n           : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Positives = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or \n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_identical()|frac_identical>, L<matches()|matches>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_conserved {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = lc($seqType);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $consv = $self->matches('cons');\n    my $total = $self->length_aln($seqType);\n    my $ratio = $consv / $total;\n    my $ratio_rounded = sprintf( \"%.3f\", $ratio);\n\n    # Round down iff normal rounding yields 1 (just like blast)\n    $ratio_rounded = 0.999 if (($ratio_rounded == 1) && ($ratio < 1));\n    return $ratio_rounded;\n}\n\n\n\n\n=head2 frac_aligned_query\n\n Usage     : $hit_object->frac_aligned_query();\n Purpose   : Get the fraction of the query sequence which has been aligned\n           : across all HSPs (not including intervals between non-overlapping\n           : HSPs).\n Example   : $frac_alnq = $hit_object->frac_aligned_query();\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : n/a\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_aligned_hit()|frac_aligned_hit>, L<logical_length()|logical_length>, L<length_aln()|length_aln>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_aligned_query {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    sprintf( \"%.2f\", $self->length_aln('query') /\n             $self->logical_length('query'));\n}\n\n\n\n=head2 frac_aligned_hit\n\n Usage     : $hit_object->frac_aligned_hit();\n Purpose   : Get the fraction of the hit (sbjct) sequence which has been aligned\n           : across all HSPs (not including intervals between non-overlapping\n           : HSPs).\n Example   : $frac_alnq = $hit_object->frac_aligned_hit();\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : n/a\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_aligned_query()|frac_aligned_query>, L<matches()|matches>, , L<logical_length()|logical_length>, L<length_aln()|length_aln>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_aligned_hit {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    sprintf( \"%.2f\", $self->length_aln('sbjct') / $self->logical_length('sbjct'));\n}\n\n\n## These methods are being maintained for backward compatibility. \n\n=head2 frac_aligned_sbjct\n\nSame as L<frac_aligned_hit()|frac_aligned_hit>\n\n\n*frac_aligned_sbjct = \\&frac_aligned_hit;\n\n=head2 num_unaligned_sbjct\n\nSame as L<num_unaligned_hit()|num_unaligned_hit>\n\n\n*num_unaligned_sbjct = \\&num_unaligned_hit;\n\n\n=head2 num_unaligned_hit\n\n Usage     : $hit_object->num_unaligned_hit();\n Purpose   : Get the number of the unaligned residues in the hit sequence.\n           : Sums across all all HSPs.\n Example   : $num_unaln = $hit_object->num_unaligned_hit();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : See notes regarding logical lengths in the comments for frac_aligned_hit().\n           : They apply here as well.\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n\nSee Also   : L<num_unaligned_query()|num_unaligned_query>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub num_unaligned_hit {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $num = $self->logical_length('sbjct') - $self->length_aln('sbjct');\n    ($num < 0 ? 0 : $num );\n}\n\n\n=head2 num_unaligned_query\n\n Usage     : $hit_object->num_unaligned_query();\n Purpose   : Get the number of the unaligned residues in the query sequence.\n           : Sums across all all HSPs.\n Example   : $num_unaln = $hit_object->num_unaligned_query();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : See notes regarding logical lengths in the comments for frac_aligned_query().\n           : They apply here as well.\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n\nSee Also   : L<num_unaligned_hit()|num_unaligned_hit>, L<frac_aligned_query()|frac_aligned_query>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub num_unaligned_query {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $num = $self->logical_length('query') - $self->length_aln('query');\n    ($num < 0 ? 0 : $num );\n}\n\n\n\n=head2 seq_inds\n\n Usage     : $hit->seq_inds( seq_type, class, collapse );\n Purpose   : Get a list of residue positions (indices) across all HSPs\n           : for identical or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hit->seq_inds('query', 'identical');\n           : @h_ind = $hit->seq_inds('hit', 'conserved');\n           : @h_ind = $hit->seq_inds('hit', 'conserved', 1);\n Returns   : Array of integers \n           : May include ranges if collapse is non-zero.\n Argument  : [0] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : [1] class     = 'identical' or 'conserved' (default = 'identical')\n           :              (can be shortened to 'id' or 'cons')\n           :              (actually, anything not 'id' will evaluate to 'conserved').\n           : [2] collapse  = boolean, if non-zero, consecutive positions are merged\n           :             using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\" \n           :             collapses to \"1-5 7 9-11\". This is useful for \n           :             consolidating long lists. Default = no collapse.\n Throws    : n/a.\n\nSee Also   : L<Bio::Search::HSP::BlastHSP::seq_inds()|Bio::Search::HSP::BlastHSP>\n\n\nsub seq_inds {\n    my ($self, $seqType, $class, $collapse) = @_;\n\n    $seqType  ||= 'query';\n    $class ||= 'identical';\n    $collapse ||= 0;\n\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my (@inds, $hsp);\n    foreach $hsp ($self->hsps) {\n        # This will merge data for all HSPs together.\n        push @inds, $hsp->seq_inds($seqType, $class);\n    }\n    \n    # Need to remove duplicates and sort the merged positions.\n    if(@inds) {\n        my %tmp = map { $_, 1 } @inds;\n        @inds = sort {$a <=> $b} keys %tmp;\n    }\n\n    $collapse ?  &Bio::Search::SearchUtils::collapse_nums(@inds) : @inds; \n}\n\n\n=head2 strand\n\nSee documentation in L<Bio::Search::Hit::HitI::strand()|Bio::Search::Hit::HitI>\n\n\nsub strand {\n    my ($self, $seqType, $strnd) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n        #return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $seqType = lc($seqType);\n\n    if( defined $strnd ) {\n        $self->throw(\"Can't set strand for seqType '$seqType'. Must be 'query' or 'hit'\\n\") unless ($seqType eq 'sbjct' or $seqType eq 'query');\n\n        return $self->{'_strand_'.$seqType} = $strnd;\n    }\n\n    my ($qstr, $hstr);\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->strand($seqType);\n    } \n    elsif( defined $self->{'_strand_query'}) {\n        # Get the data computed during hsp tiling.\n        $qstr = $self->{'_strand_query'};\n        $hstr = $self->{'_strand_sbjct'}\n    }\n    else {\n        # otherwise, iterate through all HSPs collecting strand info.\n        # This will return the string \"-1/1\" if there are HSPs on different strands.\n        # NOTE: This was the pre-10/21/02 procedure which will no longer be used,\n        # (unless the above elsif{} is commented out).\n        my (%qstr, %hstr);\n        foreach my $hsp( $self->hsps ) {\n            my ( $q, $h ) = $hsp->strand();\n            $qstr{ $q }++;\n            $hstr{ $h }++;\n        }\n        $qstr = join( '/', sort keys %qstr);\n        $hstr = join( '/', sort keys %hstr);\n    }\n\n    if($seqType =~ /list|array/i) {\n        return ($qstr, $hstr);\n    } elsif( $seqType eq 'query' ) {\n        return $qstr;\n    } else {\n        return $hstr;\n    }\n}\n\n=head2 frame\n\nSee documentation in L<Bio::Search::Hit::HitI::frame()|Bio::Search::Hit::HitI>\n\n\nsub frame {\n    my( $self, $frm ) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    if( defined $frm ) {\n        return $self->{'_frame'} = $frm;\n    }\n\n    # The check for $self->{'_frame'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($frame);\n    if(not defined($self->{'_frame'})) {\n        $frame = $self->hsp->frame('hit');\n    } else {\n        $frame = $self->{'_frame'}; \n    } \n    return $frame;\n}\n\n=head2 rank\n\n Title   : rank\n Usage   : $obj->rank($newval)\n Function: Get/Set the rank of this Hit in the Query search list\n           i.e. this is the Nth hit for a specific query\n Returns : value of rank\n Args    : newvalue (optional)\n\n\n\nsub rank {\n    my $self = shift;\n    return $self->{'_rank'} = shift if @_;\n    return $self->{'_rank'} || 1;\n}\n\n=head2 locus\n\n Title   : locus\n Usage   : $locus = $hit->locus();\n Function: Retrieve the locus (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub locus {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_locus'};\n    if( defined $value || ! defined $previous ) { \n      unless (defined $value) {\n        if ($self->{'_name'} =~/(gb|emb|dbj|ref)\\|(.*)\\|(.*)/) {\n                  $value = $previous = $3;\n                } else {\n          $value = $previous = '';\n        }\n      }\n          $self->{'_locus'} = $value;\n    } \n        return $previous;\n}\n\n=head2 each_accession_number\n\n Title   : each_accession_number\n Usage   : @each_accession_number = $hit->each_accession_number();\n Function: Get each accession number listed in the description of the hit.\n           If there are no alternatives, then only the primary accession will \n           be given\n Returns : list of all accession numbers in the description\n Args    : none"},"kind":12,"line":1607,"children":[{"localvar":"my","containerName":"each_accession_number","definition":"my","name":"$self","line":1608,"kind":13},{"line":1608,"kind":13,"name":"$value","containerName":"each_accession_number"},{"kind":13,"line":1609,"containerName":"each_accession_number","definition":"my","name":"$desc","localvar":"my"},{"containerName":"each_accession_number","name":"$self","line":1609,"kind":13},{"localvar":"my","definition":"my","name":"@accnums","containerName":"each_accession_number","line":1611,"kind":13},{"kind":13,"line":1612,"containerName":"each_accession_number","name":"@accnums"},{"name":"$self","containerName":"each_accession_number","line":1612,"kind":13},{"name":"$desc","containerName":"each_accession_number","kind":13,"line":1613},{"containerName":"each_accession_number","name":"$desc","kind":13,"line":1614},{"localvar":"my","containerName":"each_accession_number","definition":"my","name":"$id","line":1615,"kind":13},{"line":1616,"kind":13,"localvar":"my","name":"$acc","definition":"my","containerName":"each_accession_number"},{"kind":13,"line":1616,"containerName":"each_accession_number","name":"$version"},{"kind":13,"line":1617,"containerName":"each_accession_number","name":"$id"},{"line":1618,"kind":13,"containerName":"each_accession_number","name":"$acc"},{"line":1618,"kind":13,"containerName":"each_accession_number","name":"$version"},{"line":1619,"kind":13,"name":"$id","containerName":"each_accession_number"},{"containerName":"each_accession_number","name":"$acc","kind":13,"line":1620},{"line":1620,"kind":13,"name":"$version","containerName":"each_accession_number"},{"containerName":"each_accession_number","name":"$id","kind":13,"line":1621},{"kind":13,"line":1622,"containerName":"each_accession_number","name":"$acc"},{"line":1622,"kind":13,"name":"$id","containerName":"each_accession_number"},{"containerName":"each_accession_number","name":"$id","kind":13,"line":1623},{"containerName":"each_accession_number","name":"$acc","kind":13,"line":1624},{"line":1624,"kind":13,"name":"$version","containerName":"each_accession_number"},{"kind":13,"line":1641,"containerName":"each_accession_number","name":"$acc"},{"kind":13,"line":1641,"containerName":"each_accession_number","name":"$id"},{"kind":13,"line":1643,"name":"@accnums","containerName":"each_accession_number"},{"line":1643,"kind":13,"containerName":"each_accession_number","name":"$acc"},{"containerName":"each_accession_number","name":"@accnums","kind":13,"line":1646}],"name":"each_accession_number","range":{"end":{"character":9999,"line":1647},"start":{"character":0,"line":1607}}},{"children":[{"localvar":"my","containerName":"tiled_hsps","name":"$self","definition":"my","line":1656,"kind":13},{"name":"$self","containerName":"tiled_hsps","kind":13,"line":1657},{"line":1658,"kind":13,"containerName":"tiled_hsps","name":"$self"}],"line":1655,"kind":12,"range":{"start":{"line":1655,"character":0},"end":{"character":9999,"line":1659}},"name":"tiled_hsps","definition":"sub","containerName":"main::"},{"name":"query_length","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":1677},"start":{"line":1672,"character":0}},"kind":12,"children":[{"kind":13,"line":1673,"definition":"my","name":"$self","containerName":"query_length","localvar":"my"},{"line":1675,"kind":13,"containerName":"query_length","name":"$self"},{"kind":13,"line":1676,"containerName":"query_length","name":"$self"}],"line":1672},{"definition":"sub","containerName":"main::","signature":{"label":"ncbi_gi($self,$value)","documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\nsub significance {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_significance'};\n    if( defined $value ) { \n        $self->{'_significance'} = $value;\n    } elsif ( ! defined $previous ) {\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this Hit (\".$self->name.\")\");\n\t    return;\n\t}\n        # Set the significance of the Hit to that of the top HSP.\n        $previous = $self->{'_significance'} = ($self->hsps)[0]->significance;\n    }\n\n    return $previous;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_bits'};\n    if( defined $value ) { \n        $self->{'_bits'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using WU-BLAST, check raw_score() instead\");\n\t    return;\n\t}\n        $previous = $self->{'_bits'} = ($self->hsps)[0]->bits;\n    }    \n    return $previous;\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    $self->{'_iterator'} = 0 unless defined $self->{'_iterator'};\n    return unless\n        defined($self->{'_hsps'}) \n        && $self->{'_iterator'} <= scalar @{$self->{'_hsps'}};\n    \n    my $iterator = $self->{'_iterator'}++;\n    my $hsp = $self->{'_hsps'}->[$iterator] || return;\n    if (ref($hsp) eq 'HASH') {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $hsp = $factory->create_object(%{$hsp});\n        $self->{'_hsps'}->[$iterator] = $hsp;\n        delete $self->{_hashes}->{$iterator};\n    }\n    return $hsp;  \n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    my $self = shift;\n    foreach my $i (keys %{$self->{_hashes} || {}}) {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $self->{'_hsps'}->[$i] = $factory->create_object(%{$self->{'_hsps'}->[$i]});\n        delete $self->{_hashes}->{$i};\n    }\n    \n    return wantarray() ? @{$self->{'_hsps'} || []} : scalar(@{$self->{'_hsps'} || []});\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    my $self = shift;\n    \n    unless ($self->{'_hsps'}) {\n        return '-';\n    }\n    \n    return scalar(@{$self->{'_hsps'}});\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_iterator'} = 0;\n}\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences \n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences \n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains \n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Comment   : Note: \"sbjct\" is synonymous with \"hit\"\n\n\nsub ambiguous_aln {\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n=head2 overlap\n\nSee documentation in L<Bio::Search::Hit::HitI::overlap()|Bio::Search::Hit::HitI>\n\n\nsub overlap {\n    my $self = shift; \n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    my $self = shift; \n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description \n    # line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n\tif( $self->hsp ) {\n\t    $n = $self->hsp->n;\n\t}\n    } else {\n        $n = $self->{'_n'}; \n    } \n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<significance()|significance>, L<Bio::Search::SearchUtils::get_exponent()|Bio::Search::SearchUtils>\n\n\nsub p {\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(!defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using significance() instead.\");\n        $val = $self->significance();\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::SearchUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n    \n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = $self->hsps;\n    \n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : This is necessary since the number of identical/conserved residues \n           : can be in terms of peptide sequence space, yet the query and/or hit\n           : sequence are in nucleotide space.\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : In the case of BLAST flavors:\n           : For TBLASTN reports, the length of the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           :\n           : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub logical_length {\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my ($length, $logical);\n    my $algo = $self->algorithm;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->length;\n    } else {\n        # Otherwise, return logical query length\n        $length = $self->query_length();\n        $self->throw(\"Must have defined query_len\") unless ( $length );\n    }\n\n    $logical = Bio::Search::SearchUtils::logical_length($algo, $seqType, $length);\n\n    return int($logical);\n}\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer \n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           : \n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\nsub length_aln {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    # Setter:\n    if( defined $num) {\n        return $self->{'_length_aln_'.$seqType} = $num;\n    }\n\n    unless ($self->{'_hsps'}) {\n        #return wantarray ? ('-','-') : '-';\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $data = $self->{'_length_aln_'.$seqType};\n    \n    ## If we don't have data, figure out what went wrong.\n    if(!$data) {\n        $self->throw(\"Can't get length aln for sequence type \\\"$seqType\\\". \" . \n                     \"Valid types are 'query', 'hit', 'sbjct' ('sbjct' = 'hit')\");\n    }                \n    return $data;\n}    \n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, hit, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers  \n           :    (queryGaps, hitGaps)\n           : Array context can be forced by providing an argument of 'list' or 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed \n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : Not relying on wantarray since that will fail in situations \n           : such as printf \"%d\", $hit->gaps() in which you might expect to \n           : be printing the total gaps, but evaluates to array context.\n\nSee Also   : L<length_aln()|length_aln>\n\n\nsub gaps {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n        #return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    $seqType = lc($seqType);\n\n    if( defined $num ) {\n        $self->throw(\"Can't set gaps for seqType '$seqType'. Must be 'query' or 'hit'\\n\") unless ($seqType eq 'sbjct' or $seqType eq 'query');\n\n        return $self->{'_gaps_'.$seqType} = $num;\n    }\n    elsif($seqType =~ /list|array/i) {\n        return ($self->{'_gaps_query'}, $self->{'_gaps_sbjct'});\n    }\n    elsif($seqType eq 'total') {\n        return ($self->{'_gaps_query'} + $self->{'_gaps_sbjct'}) || 0;\n    } else {\n        return $self->{'_gaps_'.$seqType} || 0;\n    }\n}    \n\n\n=head2 matches\n\nSee documentation in L<Bio::Search::Hit::HitI::matches()|Bio::Search::Hit::HitI>\n\n\nsub matches {\n    my( $self, $arg1, $arg2) = @_;\n    my(@data,$data);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    unless( $arg1 ) {\n        @data = ($self->{'_totalIdentical'}, $self->{'_totalConserved'});\n\n        return @data;\n    } else {\n\n        if( defined $arg2 ) {\n            $self->{'_totalIdentical'} = $arg1;\n            $self->{'_totalConserved'} = $arg2;\n            return ( $arg1, $arg2 );\n        }\n        elsif($arg1 =~ /^id/i) { \n            $data = $self->{'_totalIdentical'};\n        } else {\n            $data = $self->{'_totalConserved'};\n        }\n        #print STDERR \"\\nmatches(): id=$self->{'_totalIdentical'}, cons=$self->{'_totalConserved'}\\n\\n\";\n        return $data;\n    }\n    \n    ## If we make it to here, it is likely the case that\n    ## the parser constructed a minimal hit object from the summary line only.\n    ## It either delibrately skipped parsing the alignment section,\n    ## or was not able to because it was absent (due to blast executable parameter\n    ## setting such as -b 0 (B=0 for WU-BLAST) )\n    #$self->throw(\"Can't get identical or conserved data: no data.\");\n}\n\n\n=head2 start\n\n Usage     : $sbjct->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, the lowest start\n           : value of all HSPs is returned.\n Example   : $qbeg = $sbjct->start('query');\n           : $sbeg = $sbjct->start('hit');\n           : ($qbeg, $sbeg) = $sbjct->start();\n Returns   : scalar context: integer \n           : array context without args: list of two integers (queryStart, sbjctStart)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<end()|end>, L<range()|range>, L<strand()|strand>, \n             L<Bio::Search::HSP::BlastHSP::start|Bio::Search::HSP::BlastHSP>\n\n\nsub start {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Start'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->start($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStart'} and\n        # $self->{'_sbjctStart'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStart'}) {\n            my $earliest_query_start;\n            my $earliest_sbjct_start;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_start = $hsp->start('query');\n                if (! defined $earliest_query_start || $this_query_start < $earliest_query_start) {\n                    $earliest_query_start = $this_query_start;\n                }\n                \n                my $this_sbjct_start = $hsp->start('sbjct');\n                if (! defined $earliest_sbjct_start || $this_sbjct_start < $earliest_sbjct_start) {\n                    $earliest_sbjct_start = $this_sbjct_start;\n                }\n            }\n            $self->{'_queryStart'} = $earliest_query_start;\n            $self->{'_sbjctStart'} = $earliest_sbjct_start;\n        }\n        \n        \n        if ($seqType =~ /list|array/i) {\n            return ($self->{'_queryStart'}, $self->{'_sbjctStart'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Start'};\n        }\n    }\n}\n\n\n=head2 end\n\n Usage     : $sbjct->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, \n             the largest end\n           : value of all HSPs is returned.\n Example   : $qend = $sbjct->end('query');\n           : $send = $sbjct->end('hit');\n           : ($qend, $send) = $sbjct->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers \n           : (queryEnd, sbjctEnd)\n           : Array context can be \"induced\" by providing an argument \n           : of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'sbjct'\n           :  (case insensitive). If not supplied, 'query' is used.\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<range()|range>, L<strand()|strand>\n\n\nsub end {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Stop'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->end($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStop'} and\n        # $self->{'_sbjctStop'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStop'}) {\n            my $latest_query_end;\n            my $latest_sbjct_end;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_end = $hsp->end('query');\n                if (! defined $latest_query_end || $this_query_end > $latest_query_end) {\n                    $latest_query_end = $this_query_end;\n                }\n                \n                my $this_sbjct_end = $hsp->end('sbjct');\n                if (! defined $latest_sbjct_end || $this_sbjct_end > $latest_sbjct_end) {\n                    $latest_sbjct_end = $this_sbjct_end;\n                }\n            }\n            $self->{'_queryStop'} = $latest_query_end;\n            $self->{'_sbjctStop'} = $latest_sbjct_end;\n        }\n        \n        \n        if($seqType =~ /list|array/i) {\n            return ($self->{'_queryStop'}, $self->{'_sbjctStop'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Stop'};\n        }\n    }\n}\n\n=head2 range\n\n Usage     : $sbjct->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($qbeg, $qend) = $sbjct->range('query');\n           : ($sbeg, $send) = $sbjct->range('hit');\n Returns   : Two-element array of integers \n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<end()|end>\n\n\nsub range {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n    return ($self->start($seqType), $self->end($seqType));\n}\n\n\n=head2 frac_identical\n\n Usage     : $hit_object->frac_identical( [seq_type] );\n Purpose   : Get the overall fraction of identical positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_iden = $hit_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : To compute the fraction identical, the logical length of the \n           : aligned portion of the sequence is used, meaning that\n           : in the case of BLAST flavors, for TBLASTN reports, the length of \n           : the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           : This is necessary since the number of identical residues is\n           : in terms of peptide sequence space.\n           :\n           : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or \n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then iterate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_conserved()|frac_conserved>, L<frac_aligned_query()|frac_aligned_query>, L<matches()|matches>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_identical {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = lc($seqType);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $ident = $self->matches('id');\n    my $total = $self->length_aln($seqType);\n    my $ratio = $ident / $total;\n    my $ratio_rounded = sprintf( \"%.3f\", $ratio);\n\n    # Round down iff normal rounding yields 1 (just like blast)\n    $ratio_rounded = 0.999 if (($ratio_rounded == 1) && ($ratio < 1));\n    return $ratio_rounded;\n}\n\n\n=head2 frac_conserved\n\n Usage     : $hit_object->frac_conserved( [seq_type] );\n Purpose   : Get the overall fraction of conserved positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_cons = $hit_object->frac_conserved('hit');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : To compute the fraction conserved, the logical length of the \n           : aligned portion of the sequence is used, meaning that\n           : in the case of BLAST flavors, for TBLASTN reports, the length of \n           : the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           : This is necessary since the number of conserved residues is\n           : in terms of peptide sequence space.\n           :\n           : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Positives = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or \n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_identical()|frac_identical>, L<matches()|matches>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_conserved {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = lc($seqType);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $consv = $self->matches('cons');\n    my $total = $self->length_aln($seqType);\n    my $ratio = $consv / $total;\n    my $ratio_rounded = sprintf( \"%.3f\", $ratio);\n\n    # Round down iff normal rounding yields 1 (just like blast)\n    $ratio_rounded = 0.999 if (($ratio_rounded == 1) && ($ratio < 1));\n    return $ratio_rounded;\n}\n\n\n\n\n=head2 frac_aligned_query\n\n Usage     : $hit_object->frac_aligned_query();\n Purpose   : Get the fraction of the query sequence which has been aligned\n           : across all HSPs (not including intervals between non-overlapping\n           : HSPs).\n Example   : $frac_alnq = $hit_object->frac_aligned_query();\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : n/a\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_aligned_hit()|frac_aligned_hit>, L<logical_length()|logical_length>, L<length_aln()|length_aln>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_aligned_query {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    sprintf( \"%.2f\", $self->length_aln('query') /\n             $self->logical_length('query'));\n}\n\n\n\n=head2 frac_aligned_hit\n\n Usage     : $hit_object->frac_aligned_hit();\n Purpose   : Get the fraction of the hit (sbjct) sequence which has been aligned\n           : across all HSPs (not including intervals between non-overlapping\n           : HSPs).\n Example   : $frac_alnq = $hit_object->frac_aligned_hit();\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : n/a\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_aligned_query()|frac_aligned_query>, L<matches()|matches>, , L<logical_length()|logical_length>, L<length_aln()|length_aln>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_aligned_hit {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    sprintf( \"%.2f\", $self->length_aln('sbjct') / $self->logical_length('sbjct'));\n}\n\n\n## These methods are being maintained for backward compatibility. \n\n=head2 frac_aligned_sbjct\n\nSame as L<frac_aligned_hit()|frac_aligned_hit>\n\n\n*frac_aligned_sbjct = \\&frac_aligned_hit;\n\n=head2 num_unaligned_sbjct\n\nSame as L<num_unaligned_hit()|num_unaligned_hit>\n\n\n*num_unaligned_sbjct = \\&num_unaligned_hit;\n\n\n=head2 num_unaligned_hit\n\n Usage     : $hit_object->num_unaligned_hit();\n Purpose   : Get the number of the unaligned residues in the hit sequence.\n           : Sums across all all HSPs.\n Example   : $num_unaln = $hit_object->num_unaligned_hit();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : See notes regarding logical lengths in the comments for frac_aligned_hit().\n           : They apply here as well.\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n\nSee Also   : L<num_unaligned_query()|num_unaligned_query>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub num_unaligned_hit {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $num = $self->logical_length('sbjct') - $self->length_aln('sbjct');\n    ($num < 0 ? 0 : $num );\n}\n\n\n=head2 num_unaligned_query\n\n Usage     : $hit_object->num_unaligned_query();\n Purpose   : Get the number of the unaligned residues in the query sequence.\n           : Sums across all all HSPs.\n Example   : $num_unaln = $hit_object->num_unaligned_query();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : See notes regarding logical lengths in the comments for frac_aligned_query().\n           : They apply here as well.\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n\nSee Also   : L<num_unaligned_hit()|num_unaligned_hit>, L<frac_aligned_query()|frac_aligned_query>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub num_unaligned_query {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $num = $self->logical_length('query') - $self->length_aln('query');\n    ($num < 0 ? 0 : $num );\n}\n\n\n\n=head2 seq_inds\n\n Usage     : $hit->seq_inds( seq_type, class, collapse );\n Purpose   : Get a list of residue positions (indices) across all HSPs\n           : for identical or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hit->seq_inds('query', 'identical');\n           : @h_ind = $hit->seq_inds('hit', 'conserved');\n           : @h_ind = $hit->seq_inds('hit', 'conserved', 1);\n Returns   : Array of integers \n           : May include ranges if collapse is non-zero.\n Argument  : [0] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : [1] class     = 'identical' or 'conserved' (default = 'identical')\n           :              (can be shortened to 'id' or 'cons')\n           :              (actually, anything not 'id' will evaluate to 'conserved').\n           : [2] collapse  = boolean, if non-zero, consecutive positions are merged\n           :             using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\" \n           :             collapses to \"1-5 7 9-11\". This is useful for \n           :             consolidating long lists. Default = no collapse.\n Throws    : n/a.\n\nSee Also   : L<Bio::Search::HSP::BlastHSP::seq_inds()|Bio::Search::HSP::BlastHSP>\n\n\nsub seq_inds {\n    my ($self, $seqType, $class, $collapse) = @_;\n\n    $seqType  ||= 'query';\n    $class ||= 'identical';\n    $collapse ||= 0;\n\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my (@inds, $hsp);\n    foreach $hsp ($self->hsps) {\n        # This will merge data for all HSPs together.\n        push @inds, $hsp->seq_inds($seqType, $class);\n    }\n    \n    # Need to remove duplicates and sort the merged positions.\n    if(@inds) {\n        my %tmp = map { $_, 1 } @inds;\n        @inds = sort {$a <=> $b} keys %tmp;\n    }\n\n    $collapse ?  &Bio::Search::SearchUtils::collapse_nums(@inds) : @inds; \n}\n\n\n=head2 strand\n\nSee documentation in L<Bio::Search::Hit::HitI::strand()|Bio::Search::Hit::HitI>\n\n\nsub strand {\n    my ($self, $seqType, $strnd) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n        #return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $seqType = lc($seqType);\n\n    if( defined $strnd ) {\n        $self->throw(\"Can't set strand for seqType '$seqType'. Must be 'query' or 'hit'\\n\") unless ($seqType eq 'sbjct' or $seqType eq 'query');\n\n        return $self->{'_strand_'.$seqType} = $strnd;\n    }\n\n    my ($qstr, $hstr);\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->strand($seqType);\n    } \n    elsif( defined $self->{'_strand_query'}) {\n        # Get the data computed during hsp tiling.\n        $qstr = $self->{'_strand_query'};\n        $hstr = $self->{'_strand_sbjct'}\n    }\n    else {\n        # otherwise, iterate through all HSPs collecting strand info.\n        # This will return the string \"-1/1\" if there are HSPs on different strands.\n        # NOTE: This was the pre-10/21/02 procedure which will no longer be used,\n        # (unless the above elsif{} is commented out).\n        my (%qstr, %hstr);\n        foreach my $hsp( $self->hsps ) {\n            my ( $q, $h ) = $hsp->strand();\n            $qstr{ $q }++;\n            $hstr{ $h }++;\n        }\n        $qstr = join( '/', sort keys %qstr);\n        $hstr = join( '/', sort keys %hstr);\n    }\n\n    if($seqType =~ /list|array/i) {\n        return ($qstr, $hstr);\n    } elsif( $seqType eq 'query' ) {\n        return $qstr;\n    } else {\n        return $hstr;\n    }\n}\n\n=head2 frame\n\nSee documentation in L<Bio::Search::Hit::HitI::frame()|Bio::Search::Hit::HitI>\n\n\nsub frame {\n    my( $self, $frm ) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    if( defined $frm ) {\n        return $self->{'_frame'} = $frm;\n    }\n\n    # The check for $self->{'_frame'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($frame);\n    if(not defined($self->{'_frame'})) {\n        $frame = $self->hsp->frame('hit');\n    } else {\n        $frame = $self->{'_frame'}; \n    } \n    return $frame;\n}\n\n=head2 rank\n\n Title   : rank\n Usage   : $obj->rank($newval)\n Function: Get/Set the rank of this Hit in the Query search list\n           i.e. this is the Nth hit for a specific query\n Returns : value of rank\n Args    : newvalue (optional)\n\n\n\nsub rank {\n    my $self = shift;\n    return $self->{'_rank'} = shift if @_;\n    return $self->{'_rank'} || 1;\n}\n\n=head2 locus\n\n Title   : locus\n Usage   : $locus = $hit->locus();\n Function: Retrieve the locus (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub locus {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_locus'};\n    if( defined $value || ! defined $previous ) { \n      unless (defined $value) {\n        if ($self->{'_name'} =~/(gb|emb|dbj|ref)\\|(.*)\\|(.*)/) {\n                  $value = $previous = $3;\n                } else {\n          $value = $previous = '';\n        }\n      }\n          $self->{'_locus'} = $value;\n    } \n        return $previous;\n}\n\n=head2 each_accession_number\n\n Title   : each_accession_number\n Usage   : @each_accession_number = $hit->each_accession_number();\n Function: Get each accession number listed in the description of the hit.\n           If there are no alternatives, then only the primary accession will \n           be given\n Returns : list of all accession numbers in the description\n Args    : none\n\n\nsub each_accession_number {\n    my ($self,$value) = @_;\n    my $desc = $self->{'_description'};\n    #put primary accnum on the list\n    my @accnums;\n    push (@accnums,$self->{'_accession'});\n    if( defined $desc )  { \n      while ($desc =~ /(\\b\\S+\\|\\S*\\|\\S*\\s?)/g) {\n        my $id = $1;\n        my ($acc, $version);\n\tif ($id =~ /(gb|emb|dbj|sp|pdb|bbs|ref|tp[gde])\\|(.*)\\|(.*)/) {\n\t    ($acc, $version) = split /\\./, $2; \n\t} elsif ($id =~ /(pir|prf|pat|gnl)\\|(.*)\\|(.*)/) {\n\t    ($acc, $version) = split /\\./, $3;  \n\t} elsif( $id =~ /(gim|gi|bbm|bbs|lcl)\\|(\\d*)/) {\n\t    $acc = $id;\n\t} elsif( $id =~ /(oth)\\|(.*)\\|(.*)\\|(.*)/ ) { # discontinued...\n\t    ($acc,$version) = ($2);\n\t} else {\n                     #punt, not matching the db's at ftp://ftp.ncbi.nih.gov/blast/db/README\n                     #Database Name                     Identifier Syntax\n          #============================      ========================\n          #GenBank                           gb|accession|locus\n          #EMBL Data Library                 emb|accession|locus\n          #DDBJ, DNA Database of Japan       dbj|accession|locus\n          #NBRF PIR                          pir||entry\n          #Protein Research Foundation       prf||name\n          #SWISS-PROT                        sp|accession|entry name\n          #Brookhaven Protein Data Bank      pdb|entry|chain\n          #Patents                           pat|country|number \n          #GenInfo Backbone Id               bbs|number \n          #General database identifier           gnl|database|identifier\n          #NCBI Reference Sequence           ref|accession|locus\n          #Local Sequence identifier         lcl|identifier\n              $acc=$id;\n            }\n            push(@accnums, $acc);\n          }\n    }  \n    return @accnums;\n}\n\n=head2 tiled_hsps\n\nSee documentation in L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub tiled_hsps { \n    my $self = shift;\n    return $self->{'_tiled_hsps'} = shift if @_;\n    return $self->{'_tiled_hsps'};\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $obj->query_length($newval)\n Function: Get/Set the query_length\n Returns : value of query_length (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub query_length {\n    my $self = shift;\n\n    return $self->{'_query_length'} = shift if @_;\n    return $self->{'_query_length'};\n}\n\n=head2 ncbi_gi\n\n Title   : ncbi_gi\n Usage   : $acc = $hit->ncbi_gi();\n Function: Retrieve the NCBI Unique ID (aka the GI #),\n           if available, for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)","kind":12,"children":[{"kind":13,"line":1691,"containerName":"ncbi_gi","name":"$self","definition":"my","localvar":"my"},{"containerName":"ncbi_gi","name":"$value","kind":13,"line":1691},{"name":"$value","containerName":"ncbi_gi","line":1692,"kind":13},{"kind":13,"line":1693,"name":"$self","containerName":"ncbi_gi"},{"containerName":"ncbi_gi","name":"$value","line":1693,"kind":13},{"name":"$self","containerName":"ncbi_gi","kind":13,"line":1695},{"kind":13,"line":1695,"containerName":"ncbi_gi","name":"$self"},{"containerName":"ncbi_gi","name":"name","kind":12,"line":1695},{"kind":13,"line":1697,"name":"$self","containerName":"ncbi_gi"}],"line":1690,"name":"ncbi_gi","range":{"start":{"character":0,"line":1690},"end":{"line":1698,"character":9999}}},{"kind":12,"line":1721,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"sort_hsps","line":1722,"kind":13},{"name":"$coderef","containerName":"sort_hsps","line":1722,"kind":13},{"definition":"my","name":"@sorted_hsps","containerName":"sort_hsps","localvar":"my","kind":13,"line":1723},{"kind":13,"line":1725,"name":"$coderef","containerName":"sort_hsps"},{"line":1726,"kind":13,"name":"$self","containerName":"sort_hsps"},{"name":"throw","containerName":"sort_hsps","line":1726,"kind":12},{"kind":13,"line":1727,"name":"$coderef","containerName":"sort_hsps"},{"kind":13,"line":1730,"containerName":"sort_hsps","name":"$coderef"},{"localvar":"my","definition":"my","name":"@hsps","containerName":"sort_hsps","line":1734,"kind":13},{"line":1734,"kind":13,"name":"$self","containerName":"sort_hsps"},{"name":"hsps","containerName":"sort_hsps","line":1734,"kind":12},{"name":"@sorted_hsps","containerName":"sort_hsps","kind":13,"line":1735},{"kind":13,"line":1735,"name":"$coderef","containerName":"sort_hsps"},{"containerName":"sort_hsps","name":"@hsps","line":1735,"kind":13},{"name":"$self","containerName":"sort_hsps","kind":13,"line":1738},{"containerName":"sort_hsps","name":"throw","kind":12,"line":1738},{"name":"$self","containerName":"sort_hsps","line":1741,"kind":13},{"name":"@sorted_hsps","containerName":"sort_hsps","kind":13,"line":1741}],"containerName":"main::","definition":"sub","detail":"($self,$coderef)","signature":{"label":"sort_hsps($self,$coderef)","parameters":[{"label":"$self"},{"label":"$coderef"}],"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\nsub significance {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_significance'};\n    if( defined $value ) { \n        $self->{'_significance'} = $value;\n    } elsif ( ! defined $previous ) {\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this Hit (\".$self->name.\")\");\n\t    return;\n\t}\n        # Set the significance of the Hit to that of the top HSP.\n        $previous = $self->{'_significance'} = ($self->hsps)[0]->significance;\n    }\n\n    return $previous;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_bits'};\n    if( defined $value ) { \n        $self->{'_bits'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using WU-BLAST, check raw_score() instead\");\n\t    return;\n\t}\n        $previous = $self->{'_bits'} = ($self->hsps)[0]->bits;\n    }    \n    return $previous;\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    $self->{'_iterator'} = 0 unless defined $self->{'_iterator'};\n    return unless\n        defined($self->{'_hsps'}) \n        && $self->{'_iterator'} <= scalar @{$self->{'_hsps'}};\n    \n    my $iterator = $self->{'_iterator'}++;\n    my $hsp = $self->{'_hsps'}->[$iterator] || return;\n    if (ref($hsp) eq 'HASH') {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $hsp = $factory->create_object(%{$hsp});\n        $self->{'_hsps'}->[$iterator] = $hsp;\n        delete $self->{_hashes}->{$iterator};\n    }\n    return $hsp;  \n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    my $self = shift;\n    foreach my $i (keys %{$self->{_hashes} || {}}) {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $self->{'_hsps'}->[$i] = $factory->create_object(%{$self->{'_hsps'}->[$i]});\n        delete $self->{_hashes}->{$i};\n    }\n    \n    return wantarray() ? @{$self->{'_hsps'} || []} : scalar(@{$self->{'_hsps'} || []});\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    my $self = shift;\n    \n    unless ($self->{'_hsps'}) {\n        return '-';\n    }\n    \n    return scalar(@{$self->{'_hsps'}});\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_iterator'} = 0;\n}\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences \n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences \n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains \n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Comment   : Note: \"sbjct\" is synonymous with \"hit\"\n\n\nsub ambiguous_aln {\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n=head2 overlap\n\nSee documentation in L<Bio::Search::Hit::HitI::overlap()|Bio::Search::Hit::HitI>\n\n\nsub overlap {\n    my $self = shift; \n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    my $self = shift; \n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description \n    # line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n\tif( $self->hsp ) {\n\t    $n = $self->hsp->n;\n\t}\n    } else {\n        $n = $self->{'_n'}; \n    } \n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<significance()|significance>, L<Bio::Search::SearchUtils::get_exponent()|Bio::Search::SearchUtils>\n\n\nsub p {\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(!defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using significance() instead.\");\n        $val = $self->significance();\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::SearchUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n    \n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = $self->hsps;\n    \n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : This is necessary since the number of identical/conserved residues \n           : can be in terms of peptide sequence space, yet the query and/or hit\n           : sequence are in nucleotide space.\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : In the case of BLAST flavors:\n           : For TBLASTN reports, the length of the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           :\n           : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub logical_length {\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my ($length, $logical);\n    my $algo = $self->algorithm;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->length;\n    } else {\n        # Otherwise, return logical query length\n        $length = $self->query_length();\n        $self->throw(\"Must have defined query_len\") unless ( $length );\n    }\n\n    $logical = Bio::Search::SearchUtils::logical_length($algo, $seqType, $length);\n\n    return int($logical);\n}\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer \n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           : \n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\nsub length_aln {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    # Setter:\n    if( defined $num) {\n        return $self->{'_length_aln_'.$seqType} = $num;\n    }\n\n    unless ($self->{'_hsps'}) {\n        #return wantarray ? ('-','-') : '-';\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $data = $self->{'_length_aln_'.$seqType};\n    \n    ## If we don't have data, figure out what went wrong.\n    if(!$data) {\n        $self->throw(\"Can't get length aln for sequence type \\\"$seqType\\\". \" . \n                     \"Valid types are 'query', 'hit', 'sbjct' ('sbjct' = 'hit')\");\n    }                \n    return $data;\n}    \n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, hit, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers  \n           :    (queryGaps, hitGaps)\n           : Array context can be forced by providing an argument of 'list' or 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed \n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : Not relying on wantarray since that will fail in situations \n           : such as printf \"%d\", $hit->gaps() in which you might expect to \n           : be printing the total gaps, but evaluates to array context.\n\nSee Also   : L<length_aln()|length_aln>\n\n\nsub gaps {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n        #return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    $seqType = lc($seqType);\n\n    if( defined $num ) {\n        $self->throw(\"Can't set gaps for seqType '$seqType'. Must be 'query' or 'hit'\\n\") unless ($seqType eq 'sbjct' or $seqType eq 'query');\n\n        return $self->{'_gaps_'.$seqType} = $num;\n    }\n    elsif($seqType =~ /list|array/i) {\n        return ($self->{'_gaps_query'}, $self->{'_gaps_sbjct'});\n    }\n    elsif($seqType eq 'total') {\n        return ($self->{'_gaps_query'} + $self->{'_gaps_sbjct'}) || 0;\n    } else {\n        return $self->{'_gaps_'.$seqType} || 0;\n    }\n}    \n\n\n=head2 matches\n\nSee documentation in L<Bio::Search::Hit::HitI::matches()|Bio::Search::Hit::HitI>\n\n\nsub matches {\n    my( $self, $arg1, $arg2) = @_;\n    my(@data,$data);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    unless( $arg1 ) {\n        @data = ($self->{'_totalIdentical'}, $self->{'_totalConserved'});\n\n        return @data;\n    } else {\n\n        if( defined $arg2 ) {\n            $self->{'_totalIdentical'} = $arg1;\n            $self->{'_totalConserved'} = $arg2;\n            return ( $arg1, $arg2 );\n        }\n        elsif($arg1 =~ /^id/i) { \n            $data = $self->{'_totalIdentical'};\n        } else {\n            $data = $self->{'_totalConserved'};\n        }\n        #print STDERR \"\\nmatches(): id=$self->{'_totalIdentical'}, cons=$self->{'_totalConserved'}\\n\\n\";\n        return $data;\n    }\n    \n    ## If we make it to here, it is likely the case that\n    ## the parser constructed a minimal hit object from the summary line only.\n    ## It either delibrately skipped parsing the alignment section,\n    ## or was not able to because it was absent (due to blast executable parameter\n    ## setting such as -b 0 (B=0 for WU-BLAST) )\n    #$self->throw(\"Can't get identical or conserved data: no data.\");\n}\n\n\n=head2 start\n\n Usage     : $sbjct->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, the lowest start\n           : value of all HSPs is returned.\n Example   : $qbeg = $sbjct->start('query');\n           : $sbeg = $sbjct->start('hit');\n           : ($qbeg, $sbeg) = $sbjct->start();\n Returns   : scalar context: integer \n           : array context without args: list of two integers (queryStart, sbjctStart)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<end()|end>, L<range()|range>, L<strand()|strand>, \n             L<Bio::Search::HSP::BlastHSP::start|Bio::Search::HSP::BlastHSP>\n\n\nsub start {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Start'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->start($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStart'} and\n        # $self->{'_sbjctStart'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStart'}) {\n            my $earliest_query_start;\n            my $earliest_sbjct_start;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_start = $hsp->start('query');\n                if (! defined $earliest_query_start || $this_query_start < $earliest_query_start) {\n                    $earliest_query_start = $this_query_start;\n                }\n                \n                my $this_sbjct_start = $hsp->start('sbjct');\n                if (! defined $earliest_sbjct_start || $this_sbjct_start < $earliest_sbjct_start) {\n                    $earliest_sbjct_start = $this_sbjct_start;\n                }\n            }\n            $self->{'_queryStart'} = $earliest_query_start;\n            $self->{'_sbjctStart'} = $earliest_sbjct_start;\n        }\n        \n        \n        if ($seqType =~ /list|array/i) {\n            return ($self->{'_queryStart'}, $self->{'_sbjctStart'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Start'};\n        }\n    }\n}\n\n\n=head2 end\n\n Usage     : $sbjct->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, \n             the largest end\n           : value of all HSPs is returned.\n Example   : $qend = $sbjct->end('query');\n           : $send = $sbjct->end('hit');\n           : ($qend, $send) = $sbjct->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers \n           : (queryEnd, sbjctEnd)\n           : Array context can be \"induced\" by providing an argument \n           : of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'sbjct'\n           :  (case insensitive). If not supplied, 'query' is used.\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<range()|range>, L<strand()|strand>\n\n\nsub end {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Stop'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->end($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStop'} and\n        # $self->{'_sbjctStop'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStop'}) {\n            my $latest_query_end;\n            my $latest_sbjct_end;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_end = $hsp->end('query');\n                if (! defined $latest_query_end || $this_query_end > $latest_query_end) {\n                    $latest_query_end = $this_query_end;\n                }\n                \n                my $this_sbjct_end = $hsp->end('sbjct');\n                if (! defined $latest_sbjct_end || $this_sbjct_end > $latest_sbjct_end) {\n                    $latest_sbjct_end = $this_sbjct_end;\n                }\n            }\n            $self->{'_queryStop'} = $latest_query_end;\n            $self->{'_sbjctStop'} = $latest_sbjct_end;\n        }\n        \n        \n        if($seqType =~ /list|array/i) {\n            return ($self->{'_queryStop'}, $self->{'_sbjctStop'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Stop'};\n        }\n    }\n}\n\n=head2 range\n\n Usage     : $sbjct->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($qbeg, $qend) = $sbjct->range('query');\n           : ($sbeg, $send) = $sbjct->range('hit');\n Returns   : Two-element array of integers \n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<end()|end>\n\n\nsub range {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n    return ($self->start($seqType), $self->end($seqType));\n}\n\n\n=head2 frac_identical\n\n Usage     : $hit_object->frac_identical( [seq_type] );\n Purpose   : Get the overall fraction of identical positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_iden = $hit_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : To compute the fraction identical, the logical length of the \n           : aligned portion of the sequence is used, meaning that\n           : in the case of BLAST flavors, for TBLASTN reports, the length of \n           : the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           : This is necessary since the number of identical residues is\n           : in terms of peptide sequence space.\n           :\n           : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or \n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then iterate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_conserved()|frac_conserved>, L<frac_aligned_query()|frac_aligned_query>, L<matches()|matches>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_identical {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = lc($seqType);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $ident = $self->matches('id');\n    my $total = $self->length_aln($seqType);\n    my $ratio = $ident / $total;\n    my $ratio_rounded = sprintf( \"%.3f\", $ratio);\n\n    # Round down iff normal rounding yields 1 (just like blast)\n    $ratio_rounded = 0.999 if (($ratio_rounded == 1) && ($ratio < 1));\n    return $ratio_rounded;\n}\n\n\n=head2 frac_conserved\n\n Usage     : $hit_object->frac_conserved( [seq_type] );\n Purpose   : Get the overall fraction of conserved positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_cons = $hit_object->frac_conserved('hit');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : To compute the fraction conserved, the logical length of the \n           : aligned portion of the sequence is used, meaning that\n           : in the case of BLAST flavors, for TBLASTN reports, the length of \n           : the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           : This is necessary since the number of conserved residues is\n           : in terms of peptide sequence space.\n           :\n           : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Positives = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or \n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_identical()|frac_identical>, L<matches()|matches>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_conserved {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = lc($seqType);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $consv = $self->matches('cons');\n    my $total = $self->length_aln($seqType);\n    my $ratio = $consv / $total;\n    my $ratio_rounded = sprintf( \"%.3f\", $ratio);\n\n    # Round down iff normal rounding yields 1 (just like blast)\n    $ratio_rounded = 0.999 if (($ratio_rounded == 1) && ($ratio < 1));\n    return $ratio_rounded;\n}\n\n\n\n\n=head2 frac_aligned_query\n\n Usage     : $hit_object->frac_aligned_query();\n Purpose   : Get the fraction of the query sequence which has been aligned\n           : across all HSPs (not including intervals between non-overlapping\n           : HSPs).\n Example   : $frac_alnq = $hit_object->frac_aligned_query();\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : n/a\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_aligned_hit()|frac_aligned_hit>, L<logical_length()|logical_length>, L<length_aln()|length_aln>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_aligned_query {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    sprintf( \"%.2f\", $self->length_aln('query') /\n             $self->logical_length('query'));\n}\n\n\n\n=head2 frac_aligned_hit\n\n Usage     : $hit_object->frac_aligned_hit();\n Purpose   : Get the fraction of the hit (sbjct) sequence which has been aligned\n           : across all HSPs (not including intervals between non-overlapping\n           : HSPs).\n Example   : $frac_alnq = $hit_object->frac_aligned_hit();\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : n/a\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_aligned_query()|frac_aligned_query>, L<matches()|matches>, , L<logical_length()|logical_length>, L<length_aln()|length_aln>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_aligned_hit {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    sprintf( \"%.2f\", $self->length_aln('sbjct') / $self->logical_length('sbjct'));\n}\n\n\n## These methods are being maintained for backward compatibility. \n\n=head2 frac_aligned_sbjct\n\nSame as L<frac_aligned_hit()|frac_aligned_hit>\n\n\n*frac_aligned_sbjct = \\&frac_aligned_hit;\n\n=head2 num_unaligned_sbjct\n\nSame as L<num_unaligned_hit()|num_unaligned_hit>\n\n\n*num_unaligned_sbjct = \\&num_unaligned_hit;\n\n\n=head2 num_unaligned_hit\n\n Usage     : $hit_object->num_unaligned_hit();\n Purpose   : Get the number of the unaligned residues in the hit sequence.\n           : Sums across all all HSPs.\n Example   : $num_unaln = $hit_object->num_unaligned_hit();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : See notes regarding logical lengths in the comments for frac_aligned_hit().\n           : They apply here as well.\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n\nSee Also   : L<num_unaligned_query()|num_unaligned_query>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub num_unaligned_hit {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $num = $self->logical_length('sbjct') - $self->length_aln('sbjct');\n    ($num < 0 ? 0 : $num );\n}\n\n\n=head2 num_unaligned_query\n\n Usage     : $hit_object->num_unaligned_query();\n Purpose   : Get the number of the unaligned residues in the query sequence.\n           : Sums across all all HSPs.\n Example   : $num_unaln = $hit_object->num_unaligned_query();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : See notes regarding logical lengths in the comments for frac_aligned_query().\n           : They apply here as well.\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n\nSee Also   : L<num_unaligned_hit()|num_unaligned_hit>, L<frac_aligned_query()|frac_aligned_query>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub num_unaligned_query {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $num = $self->logical_length('query') - $self->length_aln('query');\n    ($num < 0 ? 0 : $num );\n}\n\n\n\n=head2 seq_inds\n\n Usage     : $hit->seq_inds( seq_type, class, collapse );\n Purpose   : Get a list of residue positions (indices) across all HSPs\n           : for identical or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hit->seq_inds('query', 'identical');\n           : @h_ind = $hit->seq_inds('hit', 'conserved');\n           : @h_ind = $hit->seq_inds('hit', 'conserved', 1);\n Returns   : Array of integers \n           : May include ranges if collapse is non-zero.\n Argument  : [0] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : [1] class     = 'identical' or 'conserved' (default = 'identical')\n           :              (can be shortened to 'id' or 'cons')\n           :              (actually, anything not 'id' will evaluate to 'conserved').\n           : [2] collapse  = boolean, if non-zero, consecutive positions are merged\n           :             using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\" \n           :             collapses to \"1-5 7 9-11\". This is useful for \n           :             consolidating long lists. Default = no collapse.\n Throws    : n/a.\n\nSee Also   : L<Bio::Search::HSP::BlastHSP::seq_inds()|Bio::Search::HSP::BlastHSP>\n\n\nsub seq_inds {\n    my ($self, $seqType, $class, $collapse) = @_;\n\n    $seqType  ||= 'query';\n    $class ||= 'identical';\n    $collapse ||= 0;\n\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my (@inds, $hsp);\n    foreach $hsp ($self->hsps) {\n        # This will merge data for all HSPs together.\n        push @inds, $hsp->seq_inds($seqType, $class);\n    }\n    \n    # Need to remove duplicates and sort the merged positions.\n    if(@inds) {\n        my %tmp = map { $_, 1 } @inds;\n        @inds = sort {$a <=> $b} keys %tmp;\n    }\n\n    $collapse ?  &Bio::Search::SearchUtils::collapse_nums(@inds) : @inds; \n}\n\n\n=head2 strand\n\nSee documentation in L<Bio::Search::Hit::HitI::strand()|Bio::Search::Hit::HitI>\n\n\nsub strand {\n    my ($self, $seqType, $strnd) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n        #return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $seqType = lc($seqType);\n\n    if( defined $strnd ) {\n        $self->throw(\"Can't set strand for seqType '$seqType'. Must be 'query' or 'hit'\\n\") unless ($seqType eq 'sbjct' or $seqType eq 'query');\n\n        return $self->{'_strand_'.$seqType} = $strnd;\n    }\n\n    my ($qstr, $hstr);\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->strand($seqType);\n    } \n    elsif( defined $self->{'_strand_query'}) {\n        # Get the data computed during hsp tiling.\n        $qstr = $self->{'_strand_query'};\n        $hstr = $self->{'_strand_sbjct'}\n    }\n    else {\n        # otherwise, iterate through all HSPs collecting strand info.\n        # This will return the string \"-1/1\" if there are HSPs on different strands.\n        # NOTE: This was the pre-10/21/02 procedure which will no longer be used,\n        # (unless the above elsif{} is commented out).\n        my (%qstr, %hstr);\n        foreach my $hsp( $self->hsps ) {\n            my ( $q, $h ) = $hsp->strand();\n            $qstr{ $q }++;\n            $hstr{ $h }++;\n        }\n        $qstr = join( '/', sort keys %qstr);\n        $hstr = join( '/', sort keys %hstr);\n    }\n\n    if($seqType =~ /list|array/i) {\n        return ($qstr, $hstr);\n    } elsif( $seqType eq 'query' ) {\n        return $qstr;\n    } else {\n        return $hstr;\n    }\n}\n\n=head2 frame\n\nSee documentation in L<Bio::Search::Hit::HitI::frame()|Bio::Search::Hit::HitI>\n\n\nsub frame {\n    my( $self, $frm ) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    if( defined $frm ) {\n        return $self->{'_frame'} = $frm;\n    }\n\n    # The check for $self->{'_frame'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($frame);\n    if(not defined($self->{'_frame'})) {\n        $frame = $self->hsp->frame('hit');\n    } else {\n        $frame = $self->{'_frame'}; \n    } \n    return $frame;\n}\n\n=head2 rank\n\n Title   : rank\n Usage   : $obj->rank($newval)\n Function: Get/Set the rank of this Hit in the Query search list\n           i.e. this is the Nth hit for a specific query\n Returns : value of rank\n Args    : newvalue (optional)\n\n\n\nsub rank {\n    my $self = shift;\n    return $self->{'_rank'} = shift if @_;\n    return $self->{'_rank'} || 1;\n}\n\n=head2 locus\n\n Title   : locus\n Usage   : $locus = $hit->locus();\n Function: Retrieve the locus (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub locus {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_locus'};\n    if( defined $value || ! defined $previous ) { \n      unless (defined $value) {\n        if ($self->{'_name'} =~/(gb|emb|dbj|ref)\\|(.*)\\|(.*)/) {\n                  $value = $previous = $3;\n                } else {\n          $value = $previous = '';\n        }\n      }\n          $self->{'_locus'} = $value;\n    } \n        return $previous;\n}\n\n=head2 each_accession_number\n\n Title   : each_accession_number\n Usage   : @each_accession_number = $hit->each_accession_number();\n Function: Get each accession number listed in the description of the hit.\n           If there are no alternatives, then only the primary accession will \n           be given\n Returns : list of all accession numbers in the description\n Args    : none\n\n\nsub each_accession_number {\n    my ($self,$value) = @_;\n    my $desc = $self->{'_description'};\n    #put primary accnum on the list\n    my @accnums;\n    push (@accnums,$self->{'_accession'});\n    if( defined $desc )  { \n      while ($desc =~ /(\\b\\S+\\|\\S*\\|\\S*\\s?)/g) {\n        my $id = $1;\n        my ($acc, $version);\n\tif ($id =~ /(gb|emb|dbj|sp|pdb|bbs|ref|tp[gde])\\|(.*)\\|(.*)/) {\n\t    ($acc, $version) = split /\\./, $2; \n\t} elsif ($id =~ /(pir|prf|pat|gnl)\\|(.*)\\|(.*)/) {\n\t    ($acc, $version) = split /\\./, $3;  \n\t} elsif( $id =~ /(gim|gi|bbm|bbs|lcl)\\|(\\d*)/) {\n\t    $acc = $id;\n\t} elsif( $id =~ /(oth)\\|(.*)\\|(.*)\\|(.*)/ ) { # discontinued...\n\t    ($acc,$version) = ($2);\n\t} else {\n                     #punt, not matching the db's at ftp://ftp.ncbi.nih.gov/blast/db/README\n                     #Database Name                     Identifier Syntax\n          #============================      ========================\n          #GenBank                           gb|accession|locus\n          #EMBL Data Library                 emb|accession|locus\n          #DDBJ, DNA Database of Japan       dbj|accession|locus\n          #NBRF PIR                          pir||entry\n          #Protein Research Foundation       prf||name\n          #SWISS-PROT                        sp|accession|entry name\n          #Brookhaven Protein Data Bank      pdb|entry|chain\n          #Patents                           pat|country|number \n          #GenInfo Backbone Id               bbs|number \n          #General database identifier           gnl|database|identifier\n          #NCBI Reference Sequence           ref|accession|locus\n          #Local Sequence identifier         lcl|identifier\n              $acc=$id;\n            }\n            push(@accnums, $acc);\n          }\n    }  \n    return @accnums;\n}\n\n=head2 tiled_hsps\n\nSee documentation in L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub tiled_hsps { \n    my $self = shift;\n    return $self->{'_tiled_hsps'} = shift if @_;\n    return $self->{'_tiled_hsps'};\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $obj->query_length($newval)\n Function: Get/Set the query_length\n Returns : value of query_length (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub query_length {\n    my $self = shift;\n\n    return $self->{'_query_length'} = shift if @_;\n    return $self->{'_query_length'};\n}\n\n=head2 ncbi_gi\n\n Title   : ncbi_gi\n Usage   : $acc = $hit->ncbi_gi();\n Function: Retrieve the NCBI Unique ID (aka the GI #),\n           if available, for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub ncbi_gi {\n    my ($self,$value) = @_;\n    if( defined $value ) {\n        $self->{'_ncbi_gi'} = $value;\n    } else {\n        $self->{'_ncbi_gi'} = $self->name =~ m{^gi\\|(\\d+)} ? $1 : '';\n    } \n    return $self->{'_ncbi_gi'};\n}\n\n\n# sort method for HSPs\n\n=head2 sort_hits\n\n Title\t\t: sort_hsps\n Usage\t\t: $result->sort_hsps(\\&sort_function)\n Function\t: Sorts the available HSP objects by a user-supplied function. Defaults to sort\n                  by descending score.\n Returns\t: n/a\n Args\t\t: A coderef for the sort function.  See the documentation on the Perl sort()\n                  function for guidelines on writing sort functions.  \n Note\t\t: To access the special variables $a and $b used by the Perl sort() function \n                  the user function must access Bio::Search::Hit::HitI namespace. \n                  For example, use :\n                  $hit->sort_hsps( sub{$Bio::Search::Result::HitI::a->length <=> \n\t\t\t\t\t  $Bio::Search::Result::HitI::b->length});\n                   NOT $hit->sort_hsps($a->length <=> $b->length);"},"name":"sort_hsps","range":{"start":{"character":0,"line":1721},"end":{"line":1744,"character":9999}}},{"name":"_default_sort_hsps","kind":12,"line":1730}]}