{"version":5,"vars":[{"name":"head1","line":0,"kind":12},{"kind":12,"line":1,"name":"NAME"},{"name":"Bio","containerName":"Search::BlastUtils","line":2,"kind":12},{"name":"Utility","line":2,"kind":12},{"line":2,"kind":12,"name":"functions"},{"name":"objects","line":3,"kind":12},{"line":110,"children":[{"line":112,"kind":13,"localvar":"my","definition":"my","name":"$sbjct","containerName":"tile_hsps"},{"name":"$sbjct","containerName":"tile_hsps","kind":13,"line":114},{"name":"$sbjct","containerName":"tile_hsps","line":115,"kind":13},{"name":"$sbjct","containerName":"tile_hsps","line":116,"kind":13},{"kind":13,"line":119,"containerName":"tile_hsps","name":"$sbjct"},{"containerName":"tile_hsps","name":"$sbjct","kind":13,"line":119},{"kind":13,"line":119,"name":"$sbjct","containerName":"tile_hsps"},{"containerName":"tile_hsps","name":"num_hsps","line":119,"kind":12},{"localvar":"my","definition":"my","name":"$hsp","containerName":"tile_hsps","line":120,"kind":13},{"containerName":"tile_hsps","name":"$sbjct","line":120,"kind":13},{"containerName":"tile_hsps","name":"hsp","line":120,"kind":12},{"kind":13,"line":121,"containerName":"tile_hsps","name":"$sbjct"},{"name":"$hsp","containerName":"tile_hsps","line":121,"kind":13},{"name":"length","containerName":"tile_hsps","line":121,"kind":12},{"containerName":"tile_hsps","name":"$sbjct","line":122,"kind":13},{"kind":13,"line":122,"containerName":"tile_hsps","name":"$hsp"},{"kind":12,"line":122,"containerName":"tile_hsps","name":"length"},{"line":123,"kind":13,"containerName":"tile_hsps","name":"$sbjct"},{"line":123,"kind":13,"containerName":"tile_hsps","name":"$hsp"},{"line":123,"kind":12,"containerName":"tile_hsps","name":"length"},{"name":"$sbjct","containerName":"tile_hsps","line":124,"kind":13},{"containerName":"tile_hsps","name":"$sbjct","kind":13,"line":124},{"kind":13,"line":124,"containerName":"tile_hsps","name":"$hsp"},{"line":124,"kind":12,"name":"matches","containerName":"tile_hsps"},{"line":125,"kind":13,"name":"$sbjct","containerName":"tile_hsps"},{"line":125,"kind":13,"name":"$hsp","containerName":"tile_hsps"},{"line":125,"kind":12,"containerName":"tile_hsps","name":"gaps"},{"kind":13,"line":126,"containerName":"tile_hsps","name":"$sbjct"},{"containerName":"tile_hsps","name":"$hsp","line":126,"kind":13},{"line":126,"kind":12,"name":"gaps","containerName":"tile_hsps"},{"kind":13,"line":132,"name":"$sbjct","containerName":"tile_hsps"},{"kind":13,"line":133,"name":"$sbjct","containerName":"tile_hsps"},{"name":"$sbjct","containerName":"tile_hsps","kind":13,"line":134},{"kind":13,"line":135,"containerName":"tile_hsps","name":"$sbjct"},{"kind":13,"line":136,"name":"$sbjct","containerName":"tile_hsps"},{"kind":13,"line":141,"containerName":"tile_hsps","name":"$hsp","definition":"my","localvar":"my"},{"line":141,"kind":13,"name":"$qstart","containerName":"tile_hsps"},{"name":"$qstop","containerName":"tile_hsps","line":141,"kind":13},{"kind":13,"line":141,"containerName":"tile_hsps","name":"$sstart"},{"name":"$sstop","containerName":"tile_hsps","kind":13,"line":141},{"localvar":"my","containerName":"tile_hsps","name":"$frame","definition":"my","line":142,"kind":13},{"containerName":"tile_hsps","name":"$strand","kind":13,"line":142},{"name":"$qstrand","containerName":"tile_hsps","line":142,"kind":13},{"name":"$sstrand","containerName":"tile_hsps","line":142,"kind":13},{"localvar":"my","name":"@qcontigs","definition":"my","containerName":"tile_hsps","line":143,"kind":13},{"name":"@scontigs","containerName":"tile_hsps","line":143,"kind":13},{"localvar":"my","containerName":"tile_hsps","name":"$qoverlap","definition":"my","line":144,"kind":13},{"line":145,"kind":13,"localvar":"my","definition":"my","name":"$soverlap","containerName":"tile_hsps"},{"localvar":"my","containerName":"tile_hsps","name":"$max_overlap","definition":"my","line":146,"kind":13},{"containerName":"tile_hsps","name":"$sbjct","kind":13,"line":146},{"kind":13,"line":148,"containerName":"tile_hsps","name":"$hsp"},{"kind":13,"line":148,"containerName":"tile_hsps","name":"$sbjct"},{"containerName":"tile_hsps","name":"hsps","kind":12,"line":148},{"kind":13,"line":151,"containerName":"tile_hsps","name":"$qstart"},{"containerName":"tile_hsps","name":"$qstop","line":151,"kind":13},{"containerName":"tile_hsps","name":"$hsp","kind":13,"line":151},{"containerName":"tile_hsps","name":"range","kind":12,"line":151},{"containerName":"tile_hsps","name":"$sstart","kind":13,"line":152},{"line":152,"kind":13,"containerName":"tile_hsps","name":"$sstop"},{"line":152,"kind":13,"name":"$hsp","containerName":"tile_hsps"},{"name":"range","containerName":"tile_hsps","kind":12,"line":152},{"name":"$frame","containerName":"tile_hsps","kind":13,"line":153},{"line":153,"kind":13,"name":"$hsp","containerName":"tile_hsps"},{"containerName":"tile_hsps","name":"frame","kind":12,"line":153},{"containerName":"tile_hsps","name":"$frame","line":154,"kind":13},{"name":"$frame","containerName":"tile_hsps","kind":13,"line":154},{"line":155,"kind":13,"name":"$qstrand","containerName":"tile_hsps"},{"containerName":"tile_hsps","name":"$sstrand","line":155,"kind":13},{"name":"$hsp","containerName":"tile_hsps","kind":13,"line":155},{"containerName":"tile_hsps","name":"strand","kind":12,"line":155},{"line":157,"kind":13,"localvar":"my","definition":"my","name":"$qgaps","containerName":"tile_hsps"},{"kind":13,"line":157,"containerName":"tile_hsps","name":"$sgaps"},{"kind":13,"line":157,"containerName":"tile_hsps","name":"$hsp"},{"line":157,"kind":12,"containerName":"tile_hsps","name":"gaps"},{"containerName":"tile_hsps","name":"$sbjct","line":158,"kind":13},{"line":158,"kind":13,"name":"$qgaps","containerName":"tile_hsps"},{"name":"$sbjct","containerName":"tile_hsps","line":159,"kind":13},{"kind":13,"line":159,"name":"$sgaps","containerName":"tile_hsps"},{"containerName":"tile_hsps","name":"$sbjct","line":161,"kind":13},{"line":161,"kind":13,"containerName":"tile_hsps","name":"$hsp"},{"line":161,"kind":12,"containerName":"tile_hsps","name":"length"},{"kind":13,"line":163,"name":"$qoverlap","containerName":"tile_hsps"},{"containerName":"tile_hsps","name":"$hsp","kind":13,"line":163},{"kind":13,"line":163,"name":"$qstart","containerName":"tile_hsps"},{"line":163,"kind":13,"name":"$qstop","containerName":"tile_hsps"},{"name":"@qcontigs","containerName":"tile_hsps","line":163,"kind":13},{"name":"$max_overlap","containerName":"tile_hsps","kind":13,"line":163},{"kind":13,"line":163,"containerName":"tile_hsps","name":"$frame"},{"kind":13,"line":163,"containerName":"tile_hsps","name":"$qstrand"},{"name":"$soverlap","containerName":"tile_hsps","kind":13,"line":166},{"line":166,"kind":13,"containerName":"tile_hsps","name":"$hsp"},{"containerName":"tile_hsps","name":"$sstart","line":166,"kind":13},{"name":"$sstop","containerName":"tile_hsps","kind":13,"line":166},{"name":"@scontigs","containerName":"tile_hsps","line":166,"kind":13},{"line":166,"kind":13,"name":"$max_overlap","containerName":"tile_hsps"},{"line":166,"kind":13,"containerName":"tile_hsps","name":"$frame"},{"line":166,"kind":13,"containerName":"tile_hsps","name":"$sstrand"},{"kind":13,"line":169,"containerName":"tile_hsps","name":"$sbjct"},{"name":"$sbjct","containerName":"tile_hsps","line":170,"kind":13},{"name":"$qstart","containerName":"tile_hsps","kind":13,"line":170},{"containerName":"tile_hsps","name":"$sbjct","kind":13,"line":171},{"line":171,"kind":13,"containerName":"tile_hsps","name":"$qstop"},{"line":172,"kind":13,"containerName":"tile_hsps","name":"$sbjct"},{"line":172,"kind":13,"containerName":"tile_hsps","name":"$sstart"},{"containerName":"tile_hsps","name":"$sbjct","kind":13,"line":173},{"containerName":"tile_hsps","name":"$sstop","kind":13,"line":173},{"name":"$sbjct","containerName":"tile_hsps","line":175,"kind":13},{"name":"$qstart","containerName":"tile_hsps","kind":13,"line":175},{"name":"$sbjct","containerName":"tile_hsps","kind":13,"line":175},{"line":175,"kind":13,"name":"$qstart","containerName":"tile_hsps"},{"containerName":"tile_hsps","name":"$sbjct","line":175,"kind":13},{"name":"$sbjct","containerName":"tile_hsps","kind":13,"line":176},{"name":"$qstop","containerName":"tile_hsps","line":176,"kind":13},{"kind":13,"line":176,"name":"$sbjct","containerName":"tile_hsps"},{"kind":13,"line":176,"containerName":"tile_hsps","name":"$qstop"},{"line":176,"kind":13,"name":"$sbjct","containerName":"tile_hsps"},{"line":177,"kind":13,"name":"$sbjct","containerName":"tile_hsps"},{"line":177,"kind":13,"containerName":"tile_hsps","name":"$sstart"},{"line":177,"kind":13,"containerName":"tile_hsps","name":"$sbjct"},{"containerName":"tile_hsps","name":"$sstart","line":177,"kind":13},{"line":177,"kind":13,"containerName":"tile_hsps","name":"$sbjct"},{"name":"$sbjct","containerName":"tile_hsps","kind":13,"line":178},{"name":"$sstop","containerName":"tile_hsps","kind":13,"line":178},{"name":"$sbjct","containerName":"tile_hsps","kind":13,"line":178},{"name":"$sstop","containerName":"tile_hsps","line":178,"kind":13},{"name":"$sbjct","containerName":"tile_hsps","line":178,"kind":13},{"kind":13,"line":189,"name":"%qctg_dat","definition":"my","containerName":"tile_hsps","localvar":"my"},{"containerName":"tile_hsps","name":"@qcontigs","kind":13,"line":190},{"kind":13,"line":193,"name":"$frame","containerName":"tile_hsps"},{"line":193,"kind":13,"containerName":"tile_hsps","name":"$strand"},{"containerName":"tile_hsps","name":"$qctg_dat","line":194,"kind":13},{"line":195,"kind":13,"containerName":"tile_hsps","name":"$qctg_dat"},{"containerName":"tile_hsps","name":"$qctg_dat","line":196,"kind":13},{"name":"$qctg_dat","containerName":"tile_hsps","kind":13,"line":197},{"kind":13,"line":197,"containerName":"tile_hsps","name":"$strand"},{"line":201,"kind":13,"localvar":"my","definition":"my","name":"@sortedkeys","containerName":"tile_hsps"},{"containerName":"tile_hsps","name":"$qctg_dat","line":201,"kind":13},{"name":"$a","containerName":"tile_hsps","kind":13,"line":201},{"containerName":"tile_hsps","name":"$qctg_dat","line":201,"kind":13},{"kind":13,"line":201,"name":"$b","containerName":"tile_hsps"},{"line":201,"kind":13,"containerName":"tile_hsps","name":"%qctg_dat"},{"kind":13,"line":204,"containerName":"tile_hsps","definition":"my","name":"$longest","localvar":"my"},{"kind":13,"line":204,"containerName":"tile_hsps","name":"$sortedkeys"},{"kind":13,"line":205,"name":"$sbjct","containerName":"tile_hsps"},{"containerName":"tile_hsps","name":"$qctg_dat","line":205,"kind":13},{"kind":13,"line":205,"name":"$longest","containerName":"tile_hsps"},{"line":206,"kind":13,"containerName":"tile_hsps","name":"$sbjct"},{"containerName":"tile_hsps","name":"$qctg_dat","kind":13,"line":206},{"name":"$longest","containerName":"tile_hsps","kind":13,"line":206},{"name":"$sbjct","containerName":"tile_hsps","kind":13,"line":207},{"containerName":"tile_hsps","name":"$qctg_dat","line":207,"kind":13},{"kind":13,"line":207,"name":"$longest","containerName":"tile_hsps"},{"kind":13,"line":208,"containerName":"tile_hsps","name":"$sbjct"},{"containerName":"tile_hsps","name":"$qctg_dat","line":208,"kind":13},{"containerName":"tile_hsps","name":"$longest","kind":13,"line":208},{"kind":13,"line":217,"name":"%sctg_dat","definition":"my","containerName":"tile_hsps","localvar":"my"},{"line":218,"kind":13,"containerName":"tile_hsps","name":"@scontigs"},{"kind":13,"line":221,"containerName":"tile_hsps","name":"$frame"},{"kind":13,"line":221,"containerName":"tile_hsps","name":"$strand"},{"containerName":"tile_hsps","name":"$sctg_dat","kind":13,"line":222},{"name":"$sctg_dat","containerName":"tile_hsps","line":223,"kind":13},{"kind":13,"line":223,"containerName":"tile_hsps","name":"$frame"},{"containerName":"tile_hsps","name":"$sctg_dat","kind":13,"line":224},{"kind":13,"line":224,"containerName":"tile_hsps","name":"$strand"},{"kind":13,"line":227,"containerName":"tile_hsps","name":"@sortedkeys"},{"name":"$sctg_dat","containerName":"tile_hsps","kind":13,"line":227},{"line":227,"kind":13,"name":"$a","containerName":"tile_hsps"},{"containerName":"tile_hsps","name":"$sctg_dat","line":227,"kind":13},{"containerName":"tile_hsps","name":"$b","kind":13,"line":227},{"kind":13,"line":227,"name":"%sctg_dat","containerName":"tile_hsps"},{"name":"$longest","containerName":"tile_hsps","line":230,"kind":13},{"line":230,"kind":13,"containerName":"tile_hsps","name":"$sortedkeys"},{"line":232,"kind":13,"name":"$sbjct","containerName":"tile_hsps"},{"name":"$sctg_dat","containerName":"tile_hsps","line":232,"kind":13},{"line":232,"kind":13,"name":"$longest","containerName":"tile_hsps"},{"kind":13,"line":233,"containerName":"tile_hsps","name":"$sbjct"},{"containerName":"tile_hsps","name":"$sctg_dat","kind":13,"line":233},{"kind":13,"line":233,"name":"$longest","containerName":"tile_hsps"},{"kind":13,"line":234,"name":"$sbjct","containerName":"tile_hsps"},{"line":234,"kind":13,"name":"$sctg_dat","containerName":"tile_hsps"},{"containerName":"tile_hsps","name":"$longest","kind":13,"line":234},{"line":236,"kind":13,"containerName":"tile_hsps","name":"$qoverlap"},{"kind":13,"line":237,"name":"$soverlap","containerName":"tile_hsps"},{"kind":13,"line":237,"containerName":"tile_hsps","name":"$sbjct"},{"name":"ambiguous_aln","containerName":"tile_hsps","kind":12,"line":237},{"line":240,"kind":13,"name":"$sbjct","containerName":"tile_hsps"},{"containerName":"tile_hsps","name":"ambiguous_aln","line":240,"kind":12},{"line":243,"kind":13,"name":"$soverlap","containerName":"tile_hsps"},{"containerName":"tile_hsps","name":"$sbjct","kind":13,"line":244},{"name":"ambiguous_aln","containerName":"tile_hsps","line":244,"kind":12},{"kind":13,"line":249,"containerName":"tile_hsps","definition":"my","name":"$prog","localvar":"my"},{"line":249,"kind":13,"name":"$sbjct","containerName":"tile_hsps"},{"containerName":"tile_hsps","name":"algorithm","kind":12,"line":249},{"kind":13,"line":250,"containerName":"tile_hsps","name":"$prog"},{"line":251,"kind":13,"containerName":"tile_hsps","name":"$sbjct"},{"kind":13,"line":252,"containerName":"tile_hsps","name":"$prog"},{"kind":13,"line":253,"name":"$sbjct","containerName":"tile_hsps"},{"kind":13,"line":254,"name":"$prog","containerName":"tile_hsps"},{"kind":13,"line":255,"containerName":"tile_hsps","name":"$sbjct"},{"line":256,"kind":13,"containerName":"tile_hsps","name":"$sbjct"}],"kind":12,"range":{"start":{"character":0,"line":110},"end":{"character":9999,"line":258}},"containerName":"main::","definition":"sub","name":"tile_hsps"},{"kind":2,"line":112,"containerName":"Bio::Search::BLAST::Bio::Search::BlastUtils::Bio::Root","name":"Version"},{"line":163,"kind":12,"name":"_adjust_contigs"},{"line":166,"kind":12,"name":"_adjust_contigs"},{"name":"_adjust_contigs","range":{"start":{"character":0,"line":283},"end":{"line":354,"character":9999}},"kind":12,"line":283,"children":[{"definition":"my","name":"$seqType","containerName":"_adjust_contigs","localvar":"my","kind":13,"line":285},{"line":285,"kind":13,"containerName":"_adjust_contigs","name":"$hsp"},{"kind":13,"line":285,"containerName":"_adjust_contigs","name":"$start"},{"kind":13,"line":285,"containerName":"_adjust_contigs","name":"$stop"},{"containerName":"_adjust_contigs","name":"$contigs_ref","kind":13,"line":285},{"containerName":"_adjust_contigs","name":"$max_overlap","line":285,"kind":13},{"line":285,"kind":13,"name":"$frame","containerName":"_adjust_contigs"},{"line":285,"kind":13,"name":"$strand","containerName":"_adjust_contigs"},{"kind":13,"line":287,"definition":"my","name":"$overlap","containerName":"_adjust_contigs","localvar":"my"},{"line":288,"kind":13,"localvar":"my","containerName":"_adjust_contigs","definition":"my","name":"$numID"},{"kind":13,"line":288,"name":"$numCons","containerName":"_adjust_contigs"},{"line":291,"kind":13,"name":"$contigs_ref","containerName":"_adjust_contigs"},{"kind":13,"line":295,"containerName":"_adjust_contigs","name":"$frame"},{"kind":13,"line":295,"containerName":"_adjust_contigs","name":"$strand"},{"name":"$start","containerName":"_adjust_contigs","kind":13,"line":298},{"name":"$stop","containerName":"_adjust_contigs","kind":13,"line":298},{"kind":13,"line":300,"containerName":"_adjust_contigs","name":"$overlap"},{"containerName":"_adjust_contigs","name":"$start","kind":13,"line":305},{"line":305,"kind":13,"name":"$stop","containerName":"_adjust_contigs"},{"kind":13,"line":305,"name":"$max_overlap","containerName":"_adjust_contigs"},{"line":309,"kind":13,"name":"$numID","containerName":"_adjust_contigs"},{"containerName":"_adjust_contigs","name":"$numCons","kind":13,"line":309},{"name":"$hsp","containerName":"_adjust_contigs","line":309,"kind":13},{"name":"matches","containerName":"_adjust_contigs","line":309,"kind":12},{"kind":13,"line":309,"containerName":"_adjust_contigs","name":"$seqType"},{"name":"$start","containerName":"_adjust_contigs","line":310,"kind":13},{"kind":13,"line":315,"name":"$start","containerName":"_adjust_contigs"},{"line":316,"kind":13,"containerName":"_adjust_contigs","name":"$numID"},{"name":"$numCons","containerName":"_adjust_contigs","kind":13,"line":317},{"name":"$overlap","containerName":"_adjust_contigs","kind":13,"line":318},{"kind":13,"line":323,"name":"$stop","containerName":"_adjust_contigs"},{"containerName":"_adjust_contigs","name":"$start","line":323,"kind":13},{"line":323,"kind":13,"name":"$max_overlap","containerName":"_adjust_contigs"},{"line":327,"kind":13,"name":"$numID","containerName":"_adjust_contigs"},{"name":"$numCons","containerName":"_adjust_contigs","kind":13,"line":327},{"line":327,"kind":13,"name":"$hsp","containerName":"_adjust_contigs"},{"containerName":"_adjust_contigs","name":"matches","kind":12,"line":327},{"name":"$seqType","containerName":"_adjust_contigs","line":327,"kind":13},{"line":329,"kind":13,"name":"$stop","containerName":"_adjust_contigs"},{"name":"$stop","containerName":"_adjust_contigs","kind":13,"line":333},{"line":334,"kind":13,"containerName":"_adjust_contigs","name":"$numID"},{"containerName":"_adjust_contigs","name":"$numCons","kind":13,"line":335},{"kind":13,"line":336,"name":"$overlap","containerName":"_adjust_contigs"},{"containerName":"_adjust_contigs","name":"$overlap","kind":13,"line":339},{"line":346,"kind":13,"containerName":"_adjust_contigs","name":"$overlap"},{"line":348,"kind":13,"name":"$numID","containerName":"_adjust_contigs"},{"line":348,"kind":13,"containerName":"_adjust_contigs","name":"$numCons"},{"name":"$hsp","containerName":"_adjust_contigs","kind":13,"line":348},{"kind":12,"line":348,"name":"matches","containerName":"_adjust_contigs"},{"line":348,"kind":13,"name":"$seqType","containerName":"_adjust_contigs"},{"kind":13,"line":349,"containerName":"_adjust_contigs","name":"$contigs_ref"},{"line":349,"kind":13,"name":"$start","containerName":"_adjust_contigs"},{"name":"$stop","containerName":"_adjust_contigs","kind":13,"line":349},{"containerName":"_adjust_contigs","name":"$numID","kind":13,"line":350},{"containerName":"_adjust_contigs","name":"$numCons","kind":13,"line":350},{"containerName":"_adjust_contigs","name":"$strand","line":351,"kind":13},{"containerName":"_adjust_contigs","name":"$frame","line":351,"kind":13},{"line":353,"kind":13,"containerName":"_adjust_contigs","name":"$overlap"}],"containerName":"main::","definition":"sub","detail":"($seqType,$hsp,$start,$stop,$contigs_ref,$max_overlap,$frame,$strand)","signature":{"label":"_adjust_contigs($seqType,$hsp,$start,$stop,$contigs_ref,$max_overlap,$frame,$strand)","parameters":[{"label":"$seqType"},{"label":"$hsp"},{"label":"$start"},{"label":"$stop"},{"label":"$contigs_ref"},{"label":"$max_overlap"},{"label":"$frame"},{"label":"$strand"}],"documentation":"1;\n=head1 NAME\n\nBio::Search::BlastUtils - Utility functions for Bio::Search:: BLAST objects\n\n=head1 SYNOPSIS\n\n # This module is just a collection of subroutines, not an object.\n\nSee L<Bio::Search::Hit::BlastHit>.\n\n=head1 DESCRIPTION\n\nThe BlastUtils.pm module is a collection of subroutines used primarily by\nBio::Search::Hit::BlastHit objects for some of the additional\nfunctionality, such as HSP tiling. Right now, the BlastUtils is just a\ncollection of methods, not an object, and it's tightly coupled to\nBio::Search::Hit::BlastHit. A goal for the future is to generalize it\nto work based on the Bio::Search interfaces, then it can work with any\nobjects that implements them.\n\n=head1 AUTHOR \n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\n\n#'\n\npackage Bio::Search::BlastUtils;\nuse Bio::Root::Version;\n\n\n=head2 tile_hsps\n\n Usage     : tile_hsps( $sbjct );\n           : This is called automatically by Bio::Search::Hit::BlastHit \n           : during object construction or\n           : as needed by methods that rely on having tiled data.\n Purpose   : Collect statistics about the aligned sequences in a set of HSPs.\n           : Calculates the following data across all HSPs: \n           :    -- total alignment length \n           :    -- total identical residues \n           :    -- total conserved residues\n Returns   : n/a\n Argument  : A Bio::Search::Hit::BlastHit object \n Throws    : n/a\n Comments  :\n \t   : This method is *strongly* coupled to Bio::Search::Hit::BlastHit\n \t   : (it accesses BlastHit data members directly).\n \t   : TODO: Re-write this to the Bio::Search::Hit::HitI interface.\n \t   :\n           : This method performs more careful summing of data across\n           : all HSPs in the Sbjct object. Only HSPs that are in the same strand \n           : and frame are tiled. Simply summing the data from all HSPs\n           : in the same strand and frame will overestimate the actual \n           : length of the alignment if there is overlap between different HSPs \n           : (often the case).\n           :\n           : The strategy is to tile the HSPs and sum over the\n           : contigs, collecting data separately from overlapping and\n           : non-overlapping regions of each HSP. To facilitate this, the\n           : HSP.pm object now permits extraction of data from sub-sections\n           : of an HSP.\n           : \n           : Additional useful information is collected from the results\n           : of the tiling. It is possible that sub-sequences in\n           : different HSPs will overlap significantly. In this case, it\n           : is impossible to create a single unambiguous alignment by\n           : concatenating the HSPs. The ambiguity may indicate the\n           : presence of multiple, similar domains in one or both of the\n           : aligned sequences. This ambiguity is recorded using the\n           : ambiguous_aln() method.\n           : \n           : This method does not attempt to discern biologically\n           : significant vs. insignificant overlaps. The allowable amount of \n           : overlap can be set with the overlap() method or with the -OVERLAP\n           : parameter used when constructing the Blast & Sbjct objects. \n           : \n           : For a given hit, both the query and the sbjct sequences are\n           : tiled independently.\n           : \n           :    -- If only query sequence HSPs overlap, \n           :          this may suggest multiple domains in the sbjct.\n           :    -- If only sbjct sequence HSPs overlap, \n           :          this may suggest multiple domains in the query.\n           :    -- If both query & sbjct sequence HSPs overlap, \n           :          this suggests multiple domains in both.\n           :    -- If neither query & sbjct sequence HSPs overlap, \n           :          this suggests either no multiple domains in either\n           :          sequence OR that both sequences have the same\n           :          distribution of multiple similar domains.\n           : \n           : This method can deal with the special case of when multiple\n           : HSPs exactly overlap.\n           : \n           : Efficiency concerns:\n           :  Speed will be an issue for sequences with numerous HSPs.\n           : \n Bugs      : Currently, tile_hsps() does not properly account for\n           : the number of non-tiled but overlapping HSPs, which becomes a problem\n           : as overlap() grows. Large values overlap() may thus lead to \n           : incorrect statistics for some hits. For best results, keep overlap()\n           : below 5 (DEFAULT IS 2). For more about this, see the \"HSP Tiling and\n           : Ambiguous Alignments\" section in L<Bio::Search::Hit::BlastHit>.\n\nSee Also   : L<_adjust_contigs>(), L<Bio::Search::Hit::BlastHit|Bio::Search::Hit::BlastHit>\n\n\n#--------------\nsub tile_hsps {\n#--------------\n    my $sbjct = shift;\n\n    $sbjct->{'_tile_hsps'} = 1;\n    $sbjct->{'_gaps_query'} = 0;\n    $sbjct->{'_gaps_sbjct'} = 0;\n\n    ## Simple summation scheme. Valid if there is only one HSP.\n    if((defined($sbjct->{'_n'}) and $sbjct->{'_n'} == 1) or $sbjct->num_hsps == 1) {\n\tmy $hsp = $sbjct->hsp;\n\t$sbjct->{'_length_aln_query'} = $hsp->length('query');\n\t$sbjct->{'_length_aln_sbjct'} = $hsp->length('sbjct');\n\t$sbjct->{'_length_aln_total'} = $hsp->length('total');\n\t($sbjct->{'_totalIdentical'},$sbjct->{'_totalConserved'}) = $hsp->matches();\n\t$sbjct->{'_gaps_query'} = $hsp->gaps('query');\n\t$sbjct->{'_gaps_sbjct'} = $hsp->gaps('sbjct');\n\n#\tprint \"_tile_hsps(): single HSP, easy stats.\\n\";\n\treturn;\n    } else {\n#\tprint STDERR \"Sbjct: _tile_hsps: summing multiple HSPs\\n\";\n\t$sbjct->{'_length_aln_query'} = 0;\n\t$sbjct->{'_length_aln_sbjct'} = 0;\n\t$sbjct->{'_length_aln_total'} = 0;\n\t$sbjct->{'_totalIdentical'}   = 0;\n\t$sbjct->{'_totalConserved'}   = 0;\n    }\n\n    ## More than one HSP. Must tile HSPs.\n#    print \"\\nTiling HSPs for $sbjct\\n\";\n    my($hsp, $qstart, $qstop, $sstart, $sstop);\n    my($frame, $strand, $qstrand, $sstrand);\n    my(@qcontigs, @scontigs);\n    my $qoverlap = 0;\n    my $soverlap = 0;\n    my $max_overlap = $sbjct->{'_overlap'};\n\n    foreach $hsp ($sbjct->hsps()) {\n#\tprintf \"  HSP: %s\\n%s\\n\",$hsp->name, $hsp->str('query');\n#\tprintf \"  Length = %d; Identical = %d; Conserved = %d; Conserved(1-10): %d\",$hsp->length, $hsp->length(-TYPE=>'iden'), $hsp->length(-TYPE=>'cons'), $hsp->length(-TYPE=>'cons',-START=>0,-STOP=>10); \n\t($qstart, $qstop) = $hsp->range('query');\n\t($sstart, $sstop) = $hsp->range('sbjct');\n\t$frame = $hsp->frame('hit');\n\t$frame = -1 unless defined $frame;\n\t($qstrand, $sstrand) = $hsp->strand;\n\n\tmy ($qgaps, $sgaps)  = $hsp->gaps();\n\t$sbjct->{'_gaps_query'} += $qgaps;\n\t$sbjct->{'_gaps_sbjct'} += $sgaps;\n\n\t$sbjct->{'_length_aln_total'} += $hsp->length;\n\t## Collect contigs in the query sequence.\n\t$qoverlap = &_adjust_contigs('query', $hsp, $qstart, $qstop, \\@qcontigs, $max_overlap, $frame, $qstrand);\n\n\t## Collect contigs in the sbjct sequence (needed for domain data and gapped Blast).\n\t$soverlap = &_adjust_contigs('sbjct', $hsp, $sstart, $sstop, \\@scontigs, $max_overlap, $frame, $sstrand);\n\n\t## Collect overall start and stop data for query and sbjct over all HSPs.\n\tif(not defined $sbjct->{'_queryStart'}) {\n\t    $sbjct->{'_queryStart'} = $qstart;\n\t    $sbjct->{'_queryStop'}  = $qstop;\n\t    $sbjct->{'_sbjctStart'} = $sstart;\n\t    $sbjct->{'_sbjctStop'}  = $sstop;\n\t} else {\n\t    $sbjct->{'_queryStart'} = ($qstart < $sbjct->{'_queryStart'} ? $qstart : $sbjct->{'_queryStart'});\n\t    $sbjct->{'_queryStop'}  = ($qstop  > $sbjct->{'_queryStop'}  ? $qstop  : $sbjct->{'_queryStop'});\n\t    $sbjct->{'_sbjctStart'} = ($sstart < $sbjct->{'_sbjctStart'} ? $sstart : $sbjct->{'_sbjctStart'});\n\t    $sbjct->{'_sbjctStop'}  = ($sstop  > $sbjct->{'_sbjctStop'}  ? $sstop  : $sbjct->{'_sbjctStop'});\n\t}\t    \n    }\n\n    ## Collect data across the collected contigs.\n\n#    print \"\\nQUERY CONTIGS:\\n\";\n#    print \"  gaps = $sbjct->{'_gaps_query'}\\n\";\n\n    # TODO: Account for strand/frame issue!\n    # Strategy: collect data on a per strand+frame basis and save the most significant one.\n    my (%qctg_dat);\n    foreach(@qcontigs) {\n#\tprint \"  query contig: $_->{'start'} - $_->{'stop'}\\n\";\n#\tprint \"         iden = $_->{'iden'}; cons = $_->{'cons'}\\n\";\n\t($frame, $strand) = ($_->{'frame'}, $_->{'strand'});\n\t$qctg_dat{ \"$frame$strand\" }->{'length_aln_query'} += $_->{'stop'} - $_->{'start'} + 1;\n\t$qctg_dat{ \"$frame$strand\" }->{'totalIdentical'}   += $_->{'iden'};\n\t$qctg_dat{ \"$frame$strand\" }->{'totalConserved'}   += $_->{'cons'};\n\t$qctg_dat{ \"$frame$strand\" }->{'qstrand'}   = $strand;\n    }\n\n    # Find longest contig.\n    my @sortedkeys = reverse sort { $qctg_dat{ $a }->{'length_aln_query'} <=> $qctg_dat{ $b }->{'length_aln_query'} } keys %qctg_dat;\n\n    # Save the largest to the sbjct:\n    my $longest = $sortedkeys[0];\n    $sbjct->{'_length_aln_query'} = $qctg_dat{ $longest }->{'length_aln_query'};\n    $sbjct->{'_totalIdentical'}   = $qctg_dat{ $longest }->{'totalIdentical'};\n    $sbjct->{'_totalConserved'}   = $qctg_dat{ $longest }->{'totalConserved'};\n    $sbjct->{'_qstrand'} = $qctg_dat{ $longest }->{'qstrand'};\n\n    ## Collect data for sbjct contigs. Important for gapped Blast.\n    ## The totalIdentical and totalConserved numbers will be the same\n    ## as determined for the query contigs.\n\n#    print \"\\nSBJCT CONTIGS:\\n\";\n#    print \"  gaps = $sbjct->{'_gaps_sbjct'}\\n\";\n\n    my (%sctg_dat);\n    foreach(@scontigs) {\n#\tprint \"  sbjct contig: $_->{'start'} - $_->{'stop'}\\n\";\n#\tprint \"         iden = $_->{'iden'}; cons = $_->{'cons'}\\n\";\n\t($frame, $strand) = ($_->{'frame'}, $_->{'strand'});\n\t$sctg_dat{ \"$frame$strand\" }->{'length_aln_sbjct'}   += $_->{'stop'} - $_->{'start'} + 1;\n\t$sctg_dat{ \"$frame$strand\" }->{'frame'}  = $frame;\n\t$sctg_dat{ \"$frame$strand\" }->{'sstrand'}  = $strand;\n    }\n\n    @sortedkeys = reverse sort { $sctg_dat{ $a }->{'length_aln_sbjct'} <=> $sctg_dat{ $b }->{'length_aln_sbjct'} } keys %sctg_dat;\n\n    # Save the largest to the sbjct:\n    $longest = $sortedkeys[0];\n\n    $sbjct->{'_length_aln_sbjct'} = $sctg_dat{ $longest }->{'length_aln_sbjct'};\n    $sbjct->{'_frame'} = $sctg_dat{ $longest }->{'frame'};\n    $sbjct->{'_sstrand'} = $sctg_dat{ $longest }->{'sstrand'};\n\n    if($qoverlap) {\n\tif($soverlap) { $sbjct->ambiguous_aln('qs'); \n#\t\t\tprint \"\\n*** AMBIGUOUS ALIGNMENT: Query and Sbjct\\n\\n\";\n\t\t      }\n\telse { $sbjct->ambiguous_aln('q');\n#\t       print \"\\n*** AMBIGUOUS ALIGNMENT: Query\\n\\n\";\n\t   }\n    } elsif($soverlap) { \n\t$sbjct->ambiguous_aln('s'); \n#\tprint \"\\n*** AMBIGUOUS ALIGNMENT: Sbjct\\n\\n\";\n    }\n\n    # Adjust length based on BLAST flavor.\n    my $prog = $sbjct->algorithm;\n    if($prog eq 'TBLASTN') {\n\t$sbjct->{'_length_aln_sbjct'} /= 3;\n    } elsif($prog eq 'BLASTX' ) {\n\t$sbjct->{'_length_aln_query'} /= 3;\n    } elsif($prog eq 'TBLASTX') {\n\t$sbjct->{'_length_aln_query'} /= 3;\n\t$sbjct->{'_length_aln_sbjct'} /= 3;\n    }\n}\n\n\n\n=head2 _adjust_contigs\n\n Usage     : n/a; called automatically during object construction.\n Purpose   : Builds HSP contigs for a given BLAST hit.\n           : Utility method called by _tile_hsps()\n Returns   : \n Argument  : \n Throws    : Exceptions propagated from Bio::Search::Hit::BlastHSP::matches()\n           : for invalid sub-sequence ranges.\n Status    : Experimental\n Comments  : This method does not currently support gapped alignments.\n           : Also, it does not keep track of the number of HSPs that\n           : overlap within the amount specified by overlap().\n           : This will lead to significant tracking errors for large\n           : overlap values.\n\nSee Also   : L<tile_hsps>(), L<Bio::Search::Hit::BlastHSP::matches|Bio::Search::Hit::BlastHSP>"}},{"children":[{"line":377,"kind":13,"localvar":"my","containerName":"get_exponent","definition":"my","name":"$data"},{"line":379,"kind":13,"localvar":"my","containerName":"get_exponent","name":"$num","definition":"my"},{"containerName":"get_exponent","name":"$exp","line":379,"kind":13},{"kind":13,"line":379,"name":"$data","containerName":"get_exponent"},{"line":381,"kind":13,"containerName":"get_exponent","name":"$exp"},{"kind":13,"line":382,"containerName":"get_exponent","name":"$num"},{"kind":13,"line":382,"name":"$num","containerName":"get_exponent"},{"containerName":"get_exponent","name":"$num","kind":13,"line":383},{"name":"$exp","containerName":"get_exponent","line":383,"kind":13},{"containerName":"get_exponent","name":"$num","kind":13,"line":384},{"kind":13,"line":384,"containerName":"get_exponent","name":"$exp"},{"name":"$num","containerName":"get_exponent","kind":13,"line":385},{"line":386,"kind":13,"name":"$exp","containerName":"get_exponent"},{"name":"$num","containerName":"get_exponent","line":387,"kind":13},{"containerName":"get_exponent","name":"$exp","line":388,"kind":13},{"name":"$num","containerName":"get_exponent","kind":13,"line":388},{"name":"$exp","containerName":"get_exponent","line":390,"kind":13},{"containerName":"get_exponent","name":"$num","kind":13,"line":391},{"line":391,"kind":13,"name":"$num","containerName":"get_exponent"},{"kind":13,"line":392,"containerName":"get_exponent","name":"$c","definition":"my","localvar":"my"},{"localvar":"my","name":"$rev","definition":"my","containerName":"get_exponent","line":393,"kind":13},{"name":"$num","containerName":"get_exponent","line":394,"kind":13},{"line":395,"kind":13,"name":"$num","containerName":"get_exponent"},{"kind":13,"line":395,"name":"$num","containerName":"get_exponent"},{"kind":13,"line":396,"containerName":"get_exponent","name":"$rev"},{"kind":13,"line":398,"containerName":"get_exponent","name":"$c"},{"kind":13,"line":398,"containerName":"get_exponent","name":"$num"},{"name":"$c","containerName":"get_exponent","line":399,"kind":13},{"name":"$exp","containerName":"get_exponent","kind":13,"line":399},{"containerName":"get_exponent","name":"$c","line":400,"kind":13},{"name":"$exp","containerName":"get_exponent","line":402,"kind":13},{"kind":13,"line":402,"name":"$exp","containerName":"get_exponent"},{"name":"$num","containerName":"get_exponent","line":402,"kind":13},{"kind":13,"line":402,"containerName":"get_exponent","name":"$rev"},{"name":"$exp","containerName":"get_exponent","line":403,"kind":13},{"name":"$rev","containerName":"get_exponent","line":403,"kind":13},{"kind":13,"line":405,"containerName":"get_exponent","name":"$exp"}],"line":375,"kind":12,"range":{"end":{"character":9999,"line":406},"start":{"character":0,"line":375}},"definition":"sub","name":"get_exponent","containerName":"main::"},{"line":388,"kind":12,"containerName":"length","name":"CORE"},{"children":[{"definition":"my","name":"@a","containerName":"collapse_nums","localvar":"my","kind":13,"line":429},{"containerName":"collapse_nums","name":"$from","definition":"my","localvar":"my","kind":13,"line":430},{"line":430,"kind":13,"containerName":"collapse_nums","name":"$to"},{"line":430,"kind":13,"name":"$i","containerName":"collapse_nums"},{"containerName":"collapse_nums","name":"@ca","line":430,"kind":13},{"kind":13,"line":430,"containerName":"collapse_nums","name":"$consec"},{"name":"$consec","containerName":"collapse_nums","kind":13,"line":432},{"line":433,"kind":13,"containerName":"collapse_nums","name":"$i"},{"kind":13,"line":433,"name":"$i","containerName":"collapse_nums"},{"containerName":"collapse_nums","name":"@a","kind":13,"line":433},{"kind":13,"line":433,"name":"$i","containerName":"collapse_nums"},{"name":"$from","containerName":"collapse_nums","line":434,"kind":13},{"name":"$from","containerName":"collapse_nums","line":434,"kind":13},{"containerName":"collapse_nums","name":"$a","line":434,"kind":13},{"line":434,"kind":13,"containerName":"collapse_nums","name":"$i"},{"kind":13,"line":435,"containerName":"collapse_nums","name":"$a"},{"containerName":"collapse_nums","name":"$i","kind":13,"line":435},{"containerName":"collapse_nums","name":"$a","line":435,"kind":13},{"kind":13,"line":435,"name":"$i","containerName":"collapse_nums"},{"containerName":"collapse_nums","name":"$to","kind":13,"line":436},{"name":"$a","containerName":"collapse_nums","line":436,"kind":13},{"line":436,"kind":13,"containerName":"collapse_nums","name":"$i"},{"name":"$consec","containerName":"collapse_nums","kind":13,"line":437},{"line":439,"kind":13,"name":"$consec","containerName":"collapse_nums"},{"line":439,"kind":13,"name":"$from","containerName":"collapse_nums"},{"containerName":"collapse_nums","name":"$from","kind":13,"line":440},{"line":440,"kind":13,"containerName":"collapse_nums","name":"$consec"},{"containerName":"collapse_nums","name":"@ca","kind":13,"line":441},{"name":"$from","containerName":"collapse_nums","line":441,"kind":13},{"containerName":"collapse_nums","name":"$from","line":442,"kind":13},{"kind":13,"line":442,"name":"$a","containerName":"collapse_nums"},{"containerName":"collapse_nums","name":"$i","kind":13,"line":442},{"name":"$consec","containerName":"collapse_nums","kind":13,"line":443},{"name":"$to","containerName":"collapse_nums","line":444,"kind":13},{"containerName":"collapse_nums","name":"$to","kind":13,"line":447},{"containerName":"collapse_nums","name":"$consec","kind":13,"line":448},{"containerName":"collapse_nums","name":"$from","line":448,"kind":13},{"name":"$from","containerName":"collapse_nums","kind":13,"line":449},{"line":449,"kind":13,"name":"$consec","containerName":"collapse_nums"},{"name":"@ca","containerName":"collapse_nums","kind":13,"line":451},{"kind":13,"line":451,"name":"$from","containerName":"collapse_nums"},{"line":451,"kind":13,"name":"$from","containerName":"collapse_nums"},{"line":453,"kind":13,"name":"@ca","containerName":"collapse_nums"}],"line":426,"kind":12,"range":{"end":{"character":9999,"line":454},"start":{"line":426,"character":0}},"name":"collapse_nums","definition":"sub","containerName":"main::"},{"children":[{"localvar":"my","definition":"my","name":"$string_ref","containerName":"strip_blast_html","line":501,"kind":13},{"line":503,"kind":13,"name":"$string_ref","containerName":"strip_blast_html"},{"localvar":"my","containerName":"strip_blast_html","definition":"my","name":"$str","line":507,"kind":13},{"containerName":"strip_blast_html","name":"$stripped","definition":"my","localvar":"my","kind":13,"line":508},{"name":"$str","containerName":"strip_blast_html","line":512,"kind":13},{"line":512,"kind":13,"name":"$stripped","containerName":"strip_blast_html"},{"name":"$str","containerName":"strip_blast_html","kind":13,"line":515},{"line":515,"kind":13,"name":"$stripped","containerName":"strip_blast_html"},{"containerName":"strip_blast_html","name":"$str","kind":13,"line":518},{"line":518,"kind":13,"name":"$stripped","containerName":"strip_blast_html"},{"name":"$str","containerName":"strip_blast_html","line":520,"kind":13},{"name":"$stripped","containerName":"strip_blast_html","line":521,"kind":13}],"line":493,"kind":12,"range":{"end":{"line":522,"character":9999},"start":{"line":493,"character":0}},"name":"strip_blast_html","definition":"sub","containerName":"main::"},{"name":"croak","line":504,"kind":12},{"kind":12,"line":507,"name":"string_ref"},{"line":520,"kind":12,"name":"string_ref"}]}