{"vars":[{"line":193,"kind":13,"localvar":"my","definition":"my","name":"$debug","containerName":null},{"line":193,"kind":2,"containerName":"","name":"strict"},{"line":193,"kind":13,"name":"$Error","containerName":null},{"localvar":"my","name":"$DEFAULT_VALUE","definition":"my","containerName":null,"line":194,"kind":13},{"kind":12,"line":194,"name":"Debug","containerName":""},{"containerName":null,"name":"@Bio","line":206,"kind":13},{"name":"Root","containerName":"Exception::ISA","kind":12,"line":206},{"name":"new","range":{"end":{"line":261,"character":9999},"start":{"character":0,"line":238}},"kind":12,"line":238,"children":[{"localvar":"my","containerName":"new","name":"$class","definition":"my","line":239,"kind":13},{"name":"@args","containerName":"new","kind":13,"line":239},{"line":240,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$value"},{"kind":13,"line":240,"containerName":"new","name":"%params"},{"line":241,"kind":13,"name":"@args","containerName":"new"},{"containerName":"new","name":"$args","kind":13,"line":241},{"kind":13,"line":242,"containerName":"new","name":"%params"},{"kind":13,"line":242,"containerName":"new","name":"@args"},{"line":243,"kind":13,"name":"$value","containerName":"new"},{"containerName":"new","name":"$params","line":243,"kind":13},{"line":246,"kind":13,"containerName":"new","name":"$params"},{"name":"$args","containerName":"new","line":246,"kind":13},{"name":"$value","containerName":"new","kind":13,"line":247},{"kind":13,"line":247,"name":"$args","containerName":"new"},{"containerName":"new","name":"$value","line":250,"kind":13},{"containerName":"new","name":"$value","line":251,"kind":13},{"name":"$value","containerName":"new","line":251,"kind":13},{"name":"$value","containerName":"new","kind":13,"line":251},{"line":252,"kind":13,"name":"$value","containerName":"new"},{"kind":13,"line":252,"containerName":"new","name":"$value"},{"line":255,"kind":13,"containerName":"new","name":"$value"},{"line":255,"kind":13,"name":"$DEFAULT_VALUE","containerName":"new"},{"line":257,"kind":13,"name":"$params","containerName":"new"},{"containerName":"new","name":"$value","kind":13,"line":257},{"localvar":"my","definition":"my","name":"$self","containerName":"new","line":259,"kind":13},{"name":"$class","containerName":"new","line":259,"kind":13},{"kind":13,"line":259,"containerName":"new","name":"%params"},{"kind":13,"line":260,"containerName":"new","name":"$self"}],"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: Exception.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Root::Exception\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n=head1 NAME\n\nBio::Root::Exception - Generic exception objects for Bioperl\n\n=head1 SYNOPSIS\n\n=head2 Throwing exceptions using L<Error.pm throw|Error::throw>:\n\n    use Bio::Root::Exception;\n    use Error;\n\n    # Set Error::Debug to include stack trace data in the error messages\n    $Error::Debug = 1;\n\n    $file = shift;\n    open (IN, $file) ||\n\t    throw Bio::Root::FileOpenException ( \"Can't open file $file for reading\", $!);\n\n=head2 Throwing exceptions using L<Bioperl throw|Bio::Root::Root/throw>:\n\n     # Here we have an object that ISA Bio::Root::Root, so it inherits throw().\n\n     open (IN, $file) || \n                $object->throw(-class => 'Bio::Root::FileOpenException',\n                               -text => \"Can't open file $file for reading\",\n                               -value => $!);\n\n=head2 Catching and handling exceptions using L<Error.pm try|Error/try>:\n\n    use Bio::Root::Exception;\n    use Error qw(:try);\n\n    # Note that we need to import the 'try' tag from Error.pm\n\n    # Set Error::Debug to include stack trace data in the error messages\n    $Error::Debug = 1;\n\n    $file = shift;\n    try {\n        open (IN, $file) ||\n\t    throw Bio::Root::FileOpenException ( \"Can't open file $file for reading\", $!);\n    }\n    catch Bio::Root::FileOpenException with {\n        my $err = shift;\n        print STDERR \"Using default input file: $default_file\\n\";\n        open (IN, $default_file) || die \"Can't open $default_file\";\n    }\n    otherwise {\n        my $err = shift;\n    \tprint STDERR \"An unexpected exception occurred: \\n$err\";\n\n\t# By placing an the error object reference within double quotes,\n\t# you're invoking its stringify() method.\n    }\n   finally {\n       # Any code that you want to execute regardless of whether or not\n       # an exception occurred.\n   };  \n   # the ending semicolon is essential!\n\n\n=head2 Defining a new Exception type as a subclass of Bio::Root::Exception:\n\n    @Bio::TestException::ISA = qw( Bio::Root::Exception );\n\n=head1 DESCRIPTION\n\n=head2 Exceptions defined in L<Bio::Root::Exception>\n\nThese are generic exceptions for typical problem situations that could arise\nin any module or script. \n\n=over 8\n\n* Bio::Root::Exception()\n\n* Bio::Root::NotImplemented()\n\n* Bio::Root::IOException()\n\n* Bio::Root::FileOpenException()\n\n* Bio::Root::SystemException()\n\n* Bio::Root::BadParameter()\n\n* Bio::Root::OutOfRange()\n\n* Bio::Root::NoSuchThing()\n\n\nUsing defined exception classes like these is a good idea because it\nindicates the basic nature of what went wrong in a convenient,\ncomputable way.\n\nIf there is a type of exception that you want to throw\nthat is not covered by the classes listed above, it is easy to define\na new one that fits your needs. Just write a line like the following\nin your module or script where you want to use it (or put it somewhere\nthat is accessible to your code):\n\n    @NoCanDoException::ISA = qw( Bio::Root::Exception );\n\nAll of the exceptions defined in this module inherit from a common\nbase class exception, Bio::Root::Exception. This allows a user to\nwrite a handler for all Bioperl-derived exceptions as follows:\n\n           use Bio::Whatever;\n           use Error qw(:try);\n\n           try {\n                # some code that depends on Bioperl\n           }\n           catch Bio::Root::Exception with {\n               my $err = shift;\n               print \"A Bioperl exception occurred:\\n$err\\n\";\n           };\n\nSo if you do create your own exceptions, just be sure they inherit\nfrom Bio::Root::Exception directly, or indirectly by inheriting from a\nBio::Root::Exception subclass.\n\nThe exceptions in Bio::Root::Exception are extensions of Graham Barr's\nL<Error> module available from CPAN.  Despite this dependency, the\nL<Bio::Root::Exception> module does not explicitly C<require Error>.\nThis permits Bio::Root::Exception to be loaded even when\nError.pm is not available.\n\n=head2 Throwing exceptions within Bioperl modules\n\nError.pm is not part of the Bioperl distibution, and may not be\npresent within  any given perl installation. So, when you want to \nthrow an exception in a Bioperl module, the safe way to throw it\nis to use L<Bio::Root::Root/throw> which can use Error.pm \nwhen it's available. See documentation in Bio::Root::Root for details.\n\n=head1 SEE ALSO\n\nSee the C<examples/exceptions> directory of the Bioperl distribution for \nworking demo code.\n\nL<Bio::Root::Root/throw> for information about throwing \nL<Bio::Root::Exception>-based exceptions.\n\nL<Error> (available from CPAN, author: GBARR)\n\nError.pm is helping to guide the design of exception handling in Perl 6. \nSee these RFC's: \n\n     http://dev.perl.org/rfc/63.pod \n\n     http://dev.perl.org/rfc/88.pod\n\n\n=head1 AUTHOR \n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\n=head1 COPYRIGHT\n\nCopyright (c) 2001 Steve Chervitz. All Rights Reserved.\n\nThis library is free software; you can redistribute it and/or modify\nit under the same terms as Perl itself.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 EXCEPTIONS\n\n\n# Define some generic exceptions.'\n\npackage Bio::Root::Exception;\nuse Bio::Root::Version;\n\nuse strict;\n\nmy $debug = $Error::Debug;  # Prevents the \"used only once\" warning.\nmy $DEFAULT_VALUE = \"__DUMMY__\";  # Permits eval{} based handlers to work\n\n=head2 L<Bio::Root::Exception>\n\n Purpose : A generic base class for all BioPerl exceptions.\n           By including a \"catch Bio::Root::Exception\" block, you\n           should be able to trap all BioPerl exceptions.\n Example : throw Bio::Root::Exception(\"A generic exception\", $!);\n\n\n#---------------------------------------------------------\n@Bio::Root::Exception::ISA = qw( Error );\n#---------------------------------------------------------\n\n=head1 Methods defined by Bio::Root::Exception\n\n=head2 new\n\n Purpose : Guarantees that -value is set properly before\n           calling Error::new().\n\n Arguments: key-value style arguments same as for Error::new()\n\n     You can also specify plain arguments as ($message, $value)\n     where $value is optional.\n\n     -value, if defined, must be non-zero and not an empty string \n     in order for eval{}-based exception handlers to work. \n     These require that if($@) evaluates to true, which will not \n     be the case if the Error has no value (Error overloads \n     numeric operations to the Error::value() method).\n\n     It is OK to create Bio::Root::Exception objects without\n     specifing -value. In this case, an invisible dummy value is used.\n\n     If you happen to specify a -value of zero (0), it will\n     be replaced by the string \"The number zero (0)\".\n\n     If you happen to specify a -value of empty string (\"\"), it will\n     be replaced by the string \"An empty string (\"\")\".","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"}},{"name":"SUPER","containerName":"new","line":259,"kind":12},{"range":{"end":{"line":289,"character":9999},"start":{"line":274,"character":0}},"containerName":"main::","definition":"sub","name":"pretty_format","line":274,"children":[{"containerName":"pretty_format","name":"$self","definition":"my","localvar":"my","kind":13,"line":275},{"localvar":"my","containerName":"pretty_format","definition":"my","name":"$msg","line":276,"kind":13},{"containerName":"pretty_format","name":"$self","kind":13,"line":276},{"name":"text","containerName":"pretty_format","line":276,"kind":12},{"kind":13,"line":277,"containerName":"pretty_format","definition":"my","name":"$stack","localvar":"my"},{"line":278,"kind":13,"containerName":"pretty_format","name":"$Error"},{"containerName":"pretty_format","name":"$stack","line":279,"kind":13},{"name":"$self","containerName":"pretty_format","line":279,"kind":13},{"containerName":"pretty_format","name":"_reformat_stacktrace","line":279,"kind":12},{"localvar":"my","containerName":"pretty_format","name":"$value_string","definition":"my","line":281,"kind":13},{"kind":13,"line":281,"name":"$self","containerName":"pretty_format"},{"name":"value","containerName":"pretty_format","kind":12,"line":281},{"line":281,"kind":13,"containerName":"pretty_format","name":"$DEFAULT_VALUE"},{"kind":13,"line":281,"name":"$self","containerName":"pretty_format"},{"kind":12,"line":281,"containerName":"pretty_format","name":"value"},{"kind":13,"line":282,"name":"$class","definition":"my","containerName":"pretty_format","localvar":"my"},{"name":"$self","containerName":"pretty_format","kind":13,"line":282},{"containerName":"pretty_format","definition":"my","name":"$title","localvar":"my","kind":13,"line":284},{"localvar":"my","containerName":"pretty_format","name":"$footer","definition":"my","line":285,"kind":13},{"kind":13,"line":285,"containerName":"pretty_format","name":"$title"},{"containerName":"pretty_format","definition":"my","name":"$out","localvar":"my","kind":13,"line":286},{"name":"$value_string","containerName":"pretty_format","kind":13,"line":287},{"line":287,"kind":13,"name":"$stack","containerName":"pretty_format"},{"kind":13,"line":287,"containerName":"pretty_format","name":"$footer"},{"kind":13,"line":288,"containerName":"pretty_format","name":"$out"}],"kind":12},{"kind":12,"line":278,"containerName":"","name":"Debug"},{"containerName":"length","name":"CORE","kind":12,"line":285},{"line":300,"children":[{"kind":13,"line":301,"containerName":"_reformat_stacktrace","definition":"my","name":"$self","localvar":"my"},{"localvar":"my","containerName":"_reformat_stacktrace","definition":"my","name":"$msg","line":302,"kind":13},{"kind":13,"line":302,"name":"$self","containerName":"_reformat_stacktrace"},{"kind":12,"line":302,"name":"text","containerName":"_reformat_stacktrace"},{"localvar":"my","containerName":"_reformat_stacktrace","name":"$stack","definition":"my","line":303,"kind":13},{"kind":13,"line":303,"containerName":"_reformat_stacktrace","name":"$self"},{"name":"stacktrace","containerName":"_reformat_stacktrace","line":303,"kind":12},{"line":304,"kind":13,"name":"$stack","containerName":"_reformat_stacktrace"},{"localvar":"my","name":"@stack","definition":"my","containerName":"_reformat_stacktrace","line":305,"kind":13},{"line":305,"kind":13,"name":"$stack","containerName":"_reformat_stacktrace"},{"line":306,"kind":13,"localvar":"my","name":"@new_stack","definition":"my","containerName":"_reformat_stacktrace"},{"localvar":"my","definition":"my","name":"$method","containerName":"_reformat_stacktrace","line":307,"kind":13},{"name":"$file","containerName":"_reformat_stacktrace","kind":13,"line":307},{"kind":13,"line":307,"containerName":"_reformat_stacktrace","name":"$linenum"},{"containerName":"_reformat_stacktrace","name":"$prev_file","line":307,"kind":13},{"kind":13,"line":307,"containerName":"_reformat_stacktrace","name":"$prev_linenum"},{"line":308,"kind":13,"localvar":"my","definition":"my","name":"$stack_count","containerName":"_reformat_stacktrace"},{"kind":13,"line":309,"definition":"my","name":"$i","containerName":"_reformat_stacktrace","localvar":"my"},{"kind":13,"line":311,"containerName":"_reformat_stacktrace","name":"$stack"},{"line":311,"kind":13,"name":"$i","containerName":"_reformat_stacktrace"},{"line":312,"kind":13,"containerName":"_reformat_stacktrace","name":"$stack"},{"kind":13,"line":312,"containerName":"_reformat_stacktrace","name":"$i"},{"name":"$method","containerName":"_reformat_stacktrace","line":313,"kind":13},{"name":"$file","containerName":"_reformat_stacktrace","line":313,"kind":13},{"line":313,"kind":13,"name":"$linenum","containerName":"_reformat_stacktrace"},{"name":"$stack_count","containerName":"_reformat_stacktrace","kind":13,"line":314},{"containerName":"_reformat_stacktrace","name":"$stack_count","kind":13,"line":319},{"kind":13,"line":320,"containerName":"_reformat_stacktrace","name":"@new_stack"},{"containerName":"_reformat_stacktrace","name":"$prev_file","kind":13,"line":321},{"containerName":"_reformat_stacktrace","name":"$prev_linenum","kind":13,"line":321},{"kind":13,"line":321,"name":"$file","containerName":"_reformat_stacktrace"},{"containerName":"_reformat_stacktrace","name":"$linenum","kind":13,"line":321},{"line":325,"kind":13,"containerName":"_reformat_stacktrace","name":"$method"},{"name":"$method","containerName":"_reformat_stacktrace","kind":13,"line":326},{"line":328,"kind":13,"name":"$method","containerName":"_reformat_stacktrace"},{"containerName":"_reformat_stacktrace","name":"$file","kind":13,"line":328},{"containerName":"_reformat_stacktrace","name":"$method","line":329,"kind":13},{"line":332,"kind":13,"name":"@new_stack","containerName":"_reformat_stacktrace"},{"line":333,"kind":13,"name":"$prev_file","containerName":"_reformat_stacktrace"},{"line":333,"kind":13,"containerName":"_reformat_stacktrace","name":"$prev_linenum"},{"kind":13,"line":333,"name":"$file","containerName":"_reformat_stacktrace"},{"name":"$linenum","containerName":"_reformat_stacktrace","line":333,"kind":13},{"kind":13,"line":335,"name":"@new_stack","containerName":"_reformat_stacktrace"},{"line":337,"kind":13,"name":"@new_stack","containerName":"_reformat_stacktrace"}],"kind":12,"range":{"end":{"line":338,"character":9999},"start":{"line":300,"character":0}},"containerName":"main::","name":"_reformat_stacktrace","definition":"sub"},{"name":"stack","kind":12,"line":309},{"range":{"end":{"line":357,"character":9999},"start":{"line":354,"character":0}},"name":"stringify","children":[{"containerName":"stringify","definition":"my","name":"$self","localvar":"my","kind":13,"line":355},{"containerName":"stringify","name":"@args","kind":13,"line":355},{"line":356,"kind":13,"containerName":"stringify","name":"$self"},{"kind":12,"line":356,"containerName":"stringify","name":"pretty_format"},{"kind":13,"line":356,"containerName":"stringify","name":"@args"}],"line":354,"kind":12,"signature":{"label":"stringify($self,@args)","documentation":"1;\n#-----------------------------------------------------------------\n# $Id: Exception.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Root::Exception\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n=head1 NAME\n\nBio::Root::Exception - Generic exception objects for Bioperl\n\n=head1 SYNOPSIS\n\n=head2 Throwing exceptions using L<Error.pm throw|Error::throw>:\n\n    use Bio::Root::Exception;\n    use Error;\n\n    # Set Error::Debug to include stack trace data in the error messages\n    $Error::Debug = 1;\n\n    $file = shift;\n    open (IN, $file) ||\n\t    throw Bio::Root::FileOpenException ( \"Can't open file $file for reading\", $!);\n\n=head2 Throwing exceptions using L<Bioperl throw|Bio::Root::Root/throw>:\n\n     # Here we have an object that ISA Bio::Root::Root, so it inherits throw().\n\n     open (IN, $file) || \n                $object->throw(-class => 'Bio::Root::FileOpenException',\n                               -text => \"Can't open file $file for reading\",\n                               -value => $!);\n\n=head2 Catching and handling exceptions using L<Error.pm try|Error/try>:\n\n    use Bio::Root::Exception;\n    use Error qw(:try);\n\n    # Note that we need to import the 'try' tag from Error.pm\n\n    # Set Error::Debug to include stack trace data in the error messages\n    $Error::Debug = 1;\n\n    $file = shift;\n    try {\n        open (IN, $file) ||\n\t    throw Bio::Root::FileOpenException ( \"Can't open file $file for reading\", $!);\n    }\n    catch Bio::Root::FileOpenException with {\n        my $err = shift;\n        print STDERR \"Using default input file: $default_file\\n\";\n        open (IN, $default_file) || die \"Can't open $default_file\";\n    }\n    otherwise {\n        my $err = shift;\n    \tprint STDERR \"An unexpected exception occurred: \\n$err\";\n\n\t# By placing an the error object reference within double quotes,\n\t# you're invoking its stringify() method.\n    }\n   finally {\n       # Any code that you want to execute regardless of whether or not\n       # an exception occurred.\n   };  \n   # the ending semicolon is essential!\n\n\n=head2 Defining a new Exception type as a subclass of Bio::Root::Exception:\n\n    @Bio::TestException::ISA = qw( Bio::Root::Exception );\n\n=head1 DESCRIPTION\n\n=head2 Exceptions defined in L<Bio::Root::Exception>\n\nThese are generic exceptions for typical problem situations that could arise\nin any module or script. \n\n=over 8\n\n* Bio::Root::Exception()\n\n* Bio::Root::NotImplemented()\n\n* Bio::Root::IOException()\n\n* Bio::Root::FileOpenException()\n\n* Bio::Root::SystemException()\n\n* Bio::Root::BadParameter()\n\n* Bio::Root::OutOfRange()\n\n* Bio::Root::NoSuchThing()\n\n\nUsing defined exception classes like these is a good idea because it\nindicates the basic nature of what went wrong in a convenient,\ncomputable way.\n\nIf there is a type of exception that you want to throw\nthat is not covered by the classes listed above, it is easy to define\na new one that fits your needs. Just write a line like the following\nin your module or script where you want to use it (or put it somewhere\nthat is accessible to your code):\n\n    @NoCanDoException::ISA = qw( Bio::Root::Exception );\n\nAll of the exceptions defined in this module inherit from a common\nbase class exception, Bio::Root::Exception. This allows a user to\nwrite a handler for all Bioperl-derived exceptions as follows:\n\n           use Bio::Whatever;\n           use Error qw(:try);\n\n           try {\n                # some code that depends on Bioperl\n           }\n           catch Bio::Root::Exception with {\n               my $err = shift;\n               print \"A Bioperl exception occurred:\\n$err\\n\";\n           };\n\nSo if you do create your own exceptions, just be sure they inherit\nfrom Bio::Root::Exception directly, or indirectly by inheriting from a\nBio::Root::Exception subclass.\n\nThe exceptions in Bio::Root::Exception are extensions of Graham Barr's\nL<Error> module available from CPAN.  Despite this dependency, the\nL<Bio::Root::Exception> module does not explicitly C<require Error>.\nThis permits Bio::Root::Exception to be loaded even when\nError.pm is not available.\n\n=head2 Throwing exceptions within Bioperl modules\n\nError.pm is not part of the Bioperl distibution, and may not be\npresent within  any given perl installation. So, when you want to \nthrow an exception in a Bioperl module, the safe way to throw it\nis to use L<Bio::Root::Root/throw> which can use Error.pm \nwhen it's available. See documentation in Bio::Root::Root for details.\n\n=head1 SEE ALSO\n\nSee the C<examples/exceptions> directory of the Bioperl distribution for \nworking demo code.\n\nL<Bio::Root::Root/throw> for information about throwing \nL<Bio::Root::Exception>-based exceptions.\n\nL<Error> (available from CPAN, author: GBARR)\n\nError.pm is helping to guide the design of exception handling in Perl 6. \nSee these RFC's: \n\n     http://dev.perl.org/rfc/63.pod \n\n     http://dev.perl.org/rfc/88.pod\n\n\n=head1 AUTHOR \n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\n=head1 COPYRIGHT\n\nCopyright (c) 2001 Steve Chervitz. All Rights Reserved.\n\nThis library is free software; you can redistribute it and/or modify\nit under the same terms as Perl itself.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 EXCEPTIONS\n\n\n# Define some generic exceptions.'\n\npackage Bio::Root::Exception;\nuse Bio::Root::Version;\n\nuse strict;\n\nmy $debug = $Error::Debug;  # Prevents the \"used only once\" warning.\nmy $DEFAULT_VALUE = \"__DUMMY__\";  # Permits eval{} based handlers to work\n\n=head2 L<Bio::Root::Exception>\n\n Purpose : A generic base class for all BioPerl exceptions.\n           By including a \"catch Bio::Root::Exception\" block, you\n           should be able to trap all BioPerl exceptions.\n Example : throw Bio::Root::Exception(\"A generic exception\", $!);\n\n\n#---------------------------------------------------------\n@Bio::Root::Exception::ISA = qw( Error );\n#---------------------------------------------------------\n\n=head1 Methods defined by Bio::Root::Exception\n\n=head2 new\n\n Purpose : Guarantees that -value is set properly before\n           calling Error::new().\n\n Arguments: key-value style arguments same as for Error::new()\n\n     You can also specify plain arguments as ($message, $value)\n     where $value is optional.\n\n     -value, if defined, must be non-zero and not an empty string \n     in order for eval{}-based exception handlers to work. \n     These require that if($@) evaluates to true, which will not \n     be the case if the Error has no value (Error overloads \n     numeric operations to the Error::value() method).\n\n     It is OK to create Bio::Root::Exception objects without\n     specifing -value. In this case, an invisible dummy value is used.\n\n     If you happen to specify a -value of zero (0), it will\n     be replaced by the string \"The number zero (0)\".\n\n     If you happen to specify a -value of empty string (\"\"), it will\n     be replaced by the string \"An empty string (\"\")\".\n\n\nsub new {\n    my ($class, @args) = @_; \n    my ($value, %params);\n    if( @args % 2 == 0 && $args[0] =~ /^-/) {\n        %params = @args;\n        $value = $params{'-value'};\n    }\n    else {\n        $params{-text} = $args[0];\n        $value = $args[1];\n    }\n\n    if( defined $value ) {\n        $value = \"The number zero (0)\" if $value =~ /^\\d+$/ && $value == 0;\n        $value = \"An empty string (\\\"\\\")\" if $value eq \"\";\n    }\n    else {\n\t$value ||= $DEFAULT_VALUE;\n    }\n    $params{-value} = $value;\n\n    my $self = $class->SUPER::new( %params );\n    return $self;\n}\n\n=head2 pretty_format()\n\n Purpose : Get a nicely formatted string containing information about the \n           exception. Format is similar to that produced by \n           Bio::Root::Root::throw(), with the addition of the name of\n           the exception class in the EXCEPTION line and some other\n           data available via the Error object.\n Example : print $error->pretty_format;\n\n\nsub pretty_format {\n    my $self = shift;\n    my $msg = $self->text;\n    my $stack = '';\n    if( $Error::Debug ) {\n      $stack = $self->_reformat_stacktrace();\n    }\n    my $value_string = $self->value ne $DEFAULT_VALUE ? \"VALUE: \".$self->value.\"\\n\" : \"\";\n    my $class = ref($self);\n\n    my $title = \"------------- EXCEPTION: $class -------------\";\n    my $footer = \"\\n\" . '-' x CORE::length($title);\n    my $out = \"\\n$title\\n\" .\n       \"MSG: $msg\\n\". $value_string. $stack. $footer . \"\\n\";\n    return $out;\n}\n\n\n# Reformatting of the stack performed by  _reformat_stacktrace:\n#   1. Shift the file:line data in line i to line i+1.\n#   2. change xxx::__ANON__() to \"try{} block\"\n#   3. skip the \"require\" and \"Error::subs::try\" stack entries (boring)\n# This means that the first line in the stack won't have any file:line data\n# But this isn't a big issue since it's for a Bio::Root::-based method \n# that doesn't vary from exception to exception.\n\nsub _reformat_stacktrace {\n    my $self = shift;\n    my $msg = $self->text;\n    my $stack = $self->stacktrace();\n    $stack =~ s/\\Q$msg//;\n    my @stack = split( /\\n/, $stack);\n    my @new_stack = ();\n    my ($method, $file, $linenum, $prev_file, $prev_linenum);\n    my $stack_count = 0;\n    foreach my $i( 0..$#stack ) {\n        # print \"STACK-ORIG: $stack[$i]\\n\";\n        if( ($stack[$i] =~ /^\\s*([^(]+)\\s*\\(.*\\) called at (\\S+) line (\\d+)/) ||\n             ($stack[$i] =~ /^\\s*(require 0) called at (\\S+) line (\\d+)/)) {\n            ($method, $file, $linenum) = ($1, $2, $3);\n            $stack_count++;\n        }\n        else{\n            next;\n        }\n        if( $stack_count == 1 ) {\n            push @new_stack, \"STACK: $method\";\n            ($prev_file, $prev_linenum) = ($file, $linenum);\n            next;\n        }\n\n        if( $method =~ /__ANON__/ ) {\n            $method = \"try{} block\";\n        }\n        if( ($method =~ /^require/ and $file =~ /Error\\.pm/ ) ||\n            ($method =~ /^Error::subs::try/ ) )   {\n            last;\n        }\n        push @new_stack, \"STACK: $method $prev_file:$prev_linenum\";\n        ($prev_file, $prev_linenum) = ($file, $linenum);\n    }\n    push @new_stack, \"STACK: $prev_file:$prev_linenum\";\n\n    return join \"\\n\", @new_stack;\n}\n\n=head2 stringify()\n\n Purpose : Overrides Error::stringify() to call pretty_format(). \n           This is called automatically when an exception object \n           is placed between double quotes.\n Example : catch Bio::Root::Exception with {\n              my $error = shift;\n              print \"$error\";\n           }\n\nSee Also: L<pretty_format()|pretty_format>","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","definition":"sub","containerName":"main::"},{"name":"@Bio","containerName":null,"line":371,"kind":13},{"containerName":"NotImplemented::ISA","name":"Root","kind":12,"line":371},{"name":"@Bio","containerName":null,"line":384,"kind":13},{"name":"Root","containerName":"IOException::ISA","kind":12,"line":384},{"name":"@Bio","containerName":null,"line":398,"kind":13},{"name":"Root","containerName":"FileOpenException::ISA","kind":12,"line":398},{"kind":13,"line":412,"name":"@Bio","containerName":null},{"line":412,"kind":12,"name":"Root","containerName":"SystemException::ISA"},{"containerName":null,"name":"@Bio","kind":13,"line":427},{"name":"Root","containerName":"BadParameter::ISA","line":427,"kind":12},{"containerName":null,"name":"@Bio","line":442,"kind":13},{"line":442,"kind":12,"name":"Root","containerName":"OutOfRange::ISA"},{"containerName":null,"name":"@Bio","kind":13,"line":457},{"containerName":"NoSuchThing::ISA","name":"Root","line":457,"kind":12}],"version":5}